"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationLoadBalancerLatencyOutlierCalculation = void 0;
/**
 * The options for calculating if an AZ is an outlier for latency for ALBs
 */
var ApplicationLoadBalancerLatencyOutlierCalculation;
(function (ApplicationLoadBalancerLatencyOutlierCalculation) {
    /**
     * This will take the latency threshold and count the number of requests per AZ
     * that exceed this threshold and then calculate the percentage of requests
     * exceeding this threshold belong to each AZ. This provides a static comparison
     * of the number of high latency requests in one AZ versus the others
     */
    ApplicationLoadBalancerLatencyOutlierCalculation["STATIC"] = "STATIC";
    /**
     * This calculates the z score of latency in one AZ against the other AZs. It uses
     * the target response time of all requests to calculate the standard deviation and
     * average for all AZs. This is the default.
     */
    ApplicationLoadBalancerLatencyOutlierCalculation["Z_SCORE"] = "Z_SCORE";
})(ApplicationLoadBalancerLatencyOutlierCalculation || (exports.ApplicationLoadBalancerLatencyOutlierCalculation = ApplicationLoadBalancerLatencyOutlierCalculation = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQXBwbGljYXRpb25Mb2FkQmFsYW5jZXJMYXRlbmN5T3V0bGllckNhbGN1bGF0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2Jhc2ljX29ic2VydmFiaWxpdHkvcHJvcHMvQXBwbGljYXRpb25Mb2FkQmFsYW5jZXJMYXRlbmN5T3V0bGllckNhbGN1bGF0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBOztHQUVHO0FBQ0gsSUFBWSxnREFnQlg7QUFoQkQsV0FBWSxnREFBZ0Q7SUFFeEQ7Ozs7O09BS0c7SUFDSCxxRUFBaUIsQ0FBQTtJQUVqQjs7OztPQUlHO0lBQ0gsdUVBQWtCLENBQUE7QUFDdEIsQ0FBQyxFQWhCVyxnREFBZ0QsZ0VBQWhELGdEQUFnRCxRQWdCM0QiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFRoZSBvcHRpb25zIGZvciBjYWxjdWxhdGluZyBpZiBhbiBBWiBpcyBhbiBvdXRsaWVyIGZvciBsYXRlbmN5IGZvciBBTEJzXG4gKi9cbmV4cG9ydCBlbnVtIEFwcGxpY2F0aW9uTG9hZEJhbGFuY2VyTGF0ZW5jeU91dGxpZXJDYWxjdWxhdGlvblxue1xuICAgIC8qKlxuICAgICAqIFRoaXMgd2lsbCB0YWtlIHRoZSBsYXRlbmN5IHRocmVzaG9sZCBhbmQgY291bnQgdGhlIG51bWJlciBvZiByZXF1ZXN0cyBwZXIgQVogXG4gICAgICogdGhhdCBleGNlZWQgdGhpcyB0aHJlc2hvbGQgYW5kIHRoZW4gY2FsY3VsYXRlIHRoZSBwZXJjZW50YWdlIG9mIHJlcXVlc3RzXG4gICAgICogZXhjZWVkaW5nIHRoaXMgdGhyZXNob2xkIGJlbG9uZyB0byBlYWNoIEFaLiBUaGlzIHByb3ZpZGVzIGEgc3RhdGljIGNvbXBhcmlzb25cbiAgICAgKiBvZiB0aGUgbnVtYmVyIG9mIGhpZ2ggbGF0ZW5jeSByZXF1ZXN0cyBpbiBvbmUgQVogdmVyc3VzIHRoZSBvdGhlcnNcbiAgICAgKi9cbiAgICBTVEFUSUMgPSBcIlNUQVRJQ1wiLFxuXG4gICAgLyoqXG4gICAgICogVGhpcyBjYWxjdWxhdGVzIHRoZSB6IHNjb3JlIG9mIGxhdGVuY3kgaW4gb25lIEFaIGFnYWluc3QgdGhlIG90aGVyIEFacy4gSXQgdXNlc1xuICAgICAqIHRoZSB0YXJnZXQgcmVzcG9uc2UgdGltZSBvZiBhbGwgcmVxdWVzdHMgdG8gY2FsY3VsYXRlIHRoZSBzdGFuZGFyZCBkZXZpYXRpb24gYW5kXG4gICAgICogYXZlcmFnZSBmb3IgYWxsIEFacy4gVGhpcyBpcyB0aGUgZGVmYXVsdC5cbiAgICAgKi9cbiAgICBaX1NDT1JFPSBcIlpfU0NPUkVcIlxufSJdfQ==