"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerSideOperationRegionalAlarmsAndRules = void 0;
const AvailabilityAndLatencyAlarmsAndRules_1 = require("./AvailabilityAndLatencyAlarmsAndRules");
const BaseOperationRegionalAlarmsAndRules_1 = require("./BaseOperationRegionalAlarmsAndRules");
/**
 * The server side regional alarms and rules for an operation
 */
class ServerSideOperationRegionalAlarmsAndRules extends BaseOperationRegionalAlarmsAndRules_1.BaseOperationRegionalAlarmsAndRules {
    constructor(scope, id, props) {
        super(scope, id, props);
        if (props.contributorInsightRuleDetails !== undefined &&
            props.contributorInsightRuleDetails != null) {
            this.instanceContributorsToRegionalFaults =
                AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createRegionalInstanceContributorsToFaults(this, props.availabilityMetricDetails, props.contributorInsightRuleDetails);
            this.instanceContributorsToRegionalHighLatency =
                AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createRegionalInstanceContributorsToHighLatency(this, props.latencyMetricDetails, props.contributorInsightRuleDetails);
        }
    }
}
exports.ServerSideOperationRegionalAlarmsAndRules = ServerSideOperationRegionalAlarmsAndRules;
//# sourceMappingURL=data:application/json;base64,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