"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InsightRuleBody = void 0;
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * The insight rule body to be included in a CfnInsightRule construct
 */
class InsightRuleBody {
    constructor() {
        this.schema = {
            name: 'CloudWatchLogRule',
            version: 1,
        };
        this.aggregateOn = '';
        this.contribution = {
            keys: [],
        };
        this.logFormat = '';
        this.logGroupNames = [];
    }
    /**
     * Converts the rule to a JSON string
     * @returns
     */
    toJson() {
        let objectKeysToUpperCase = function (input) {
            if (typeof input !== 'object')
                return input;
            if (Array.isArray(input))
                return input.map(objectKeysToUpperCase);
            return Object.keys(input).reduce(function (newObj, key) {
                let val = input[key];
                let newVal = typeof val === 'object' && val !== null
                    ? objectKeysToUpperCase(val)
                    : val;
                let newKey = key.slice(0, 1).toUpperCase() + key.substring(1);
                newObj[newKey] = newVal;
                return newObj;
            }, {});
        };
        return JSON.stringify(objectKeysToUpperCase(this));
    }
}
exports.InsightRuleBody = InsightRuleBody;
//# sourceMappingURL=data:application/json;base64,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