"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CanaryOperationZonalAlarmsAndRules = void 0;
const AvailabilityAndLatencyAlarmsAndRules_1 = require("./AvailabilityAndLatencyAlarmsAndRules");
const BaseOperationZonalAlarmsAndRules_1 = require("./BaseOperationZonalAlarmsAndRules");
const OutlierDetectionAlgorithm_1 = require("../utilities/OutlierDetectionAlgorithm");
/**
 * Creates the alarms and rules for a particular operation as measured by the canary
 */
class CanaryOperationZonalAlarmsAndRules extends BaseOperationZonalAlarmsAndRules_1.BaseOperationZonalAlarmsAndRules {
    constructor(scope, id, props) {
        super(scope, id, props);
        if (props.outlierDetectionAlgorithm == OutlierDetectionAlgorithm_1.OutlierDetectionAlgorithm.STATIC) {
            this.availabilityZoneIsOutlierForFaults =
                AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createZonalFaultRateStaticOutlierAlarmForCanaries(this, props.availabilityMetricDetails, props.availabilityZoneId, props.operation.service.availabilityZoneNames, props.counter, props.outlierThreshold, props.nameSuffix);
            this.availabilityZoneIsOutlierForLatency =
                AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createZonalHighLatencyStaticOutlierAlarmForCanaries(this, props.latencyMetricDetails, props.availabilityZoneId, props.operation.service.availabilityZoneNames, props.counter, props.outlierThreshold, props.nameSuffix);
        }
        else {
            this.availabilityZoneIsOutlierForFaults =
                AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createZonalFaultRateOutlierAlarm(this, props.availabilityMetricDetails, props.availabilityZoneId, props.operation.service.availabilityZoneNames.map((az) => {
                    return props.azMapper.availabilityZoneIdFromAvailabilityZoneLetter(az.substring(az.length - 1));
                }), props.outlierThreshold, props.outlierDetectionFunction, props.outlierDetectionAlgorithm, props.counter, props.nameSuffix);
            this.availabilityZoneIsOutlierForLatency =
                AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createZonalHighLatencyOutlierAlarm(this, props.latencyMetricDetails, props.availabilityZoneId, props.operation.service.availabilityZoneNames.map((az) => {
                    return props.azMapper.availabilityZoneIdFromAvailabilityZoneLetter(az.substring(az.length - 1));
                }), props.outlierThreshold, props.outlierDetectionFunction, props.outlierDetectionAlgorithm, props.counter, props.nameSuffix);
        }
        this.isolatedImpactAlarm =
            AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createCanaryIsolatedAZImpactAlarm(this, props.availabilityMetricDetails.operationName, props.availabilityZoneId, props.counter, this.availabilityZoneIsOutlierForFaults, this.availabilityAlarm, this.availabilityZoneIsOutlierForLatency, this.latencyAlarm, props.nameSuffix);
    }
}
exports.CanaryOperationZonalAlarmsAndRules = CanaryOperationZonalAlarmsAndRules;
//# sourceMappingURL=data:application/json;base64,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