import { IAlarm } from 'aws-cdk-lib/aws-cloudwatch';
import { Construct } from 'constructs';
import { BaseOperationZonalAlarmsAndRules } from './BaseOperationZonalAlarmsAndRules';
import { ICanaryOperationZonalAlarmsAndRules } from './ICanaryOperationZonalAlarmsAndRules';
import { CanaryOperationZonalAlarmsAndRulesProps } from './props/CanaryOperationZonalAlarmsAndRulesProps';
/**
 * Creates the alarms and rules for a particular operation as measured by the canary
 */
export declare class CanaryOperationZonalAlarmsAndRules extends BaseOperationZonalAlarmsAndRules implements ICanaryOperationZonalAlarmsAndRules {
    /**
     * Alarm that triggers if either latency or availability breach the specified
     * threshold in this AZ and the AZ is an outlier for faults or latency
     */
    isolatedImpactAlarm: IAlarm;
    /**
     * Alarm that indicates that this AZ is an outlier for fault rate
     */
    availabilityZoneIsOutlierForFaults: IAlarm;
    /**
     * Alarm that indicates this AZ is an outlier for high latency
     */
    availabilityZoneIsOutlierForLatency: IAlarm;
    constructor(scope: Construct, id: string, props: CanaryOperationZonalAlarmsAndRulesProps);
}
