"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseOperationZonalAlarmsAndRules = void 0;
const constructs_1 = require("constructs");
const AvailabilityAndLatencyAlarmsAndRules_1 = require("./AvailabilityAndLatencyAlarmsAndRules");
/**
 * The base operation regional alarms and rules
 */
class BaseOperationZonalAlarmsAndRules extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.availabilityZoneId = props.availabilityZoneId;
        this.availabilityAlarm =
            AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createZonalAvailabilityAlarm(this, props.availabilityMetricDetails, props.availabilityZoneId, props.counter, props.nameSuffix);
        this.latencyAlarm =
            AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createZonalLatencyAlarm(this, props.latencyMetricDetails, props.availabilityZoneId, props.counter, props.nameSuffix);
        this.availabilityOrLatencyAlarm =
            AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createZonalAvailabilityOrLatencyCompositeAlarm(this, props.availabilityMetricDetails.operationName, props.availabilityZoneId, props.counter, this.availabilityAlarm, this.latencyAlarm, props.nameSuffix);
    }
}
exports.BaseOperationZonalAlarmsAndRules = BaseOperationZonalAlarmsAndRules;
//# sourceMappingURL=data:application/json;base64,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