"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseOperationRegionalAlarmsAndRules = void 0;
const constructs_1 = require("constructs");
const AvailabilityAndLatencyAlarmsAndRules_1 = require("./AvailabilityAndLatencyAlarmsAndRules");
/**
 * Base operation regional alarms and rules
 */
class BaseOperationRegionalAlarmsAndRules extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.availabilityAlarm =
            AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createRegionalAvailabilityAlarm(this, props.availabilityMetricDetails, props.nameSuffix);
        this.latencyAlarm =
            AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createRegionalLatencyAlarm(this, props.latencyMetricDetails, props.nameSuffix);
        this.availabilityOrLatencyAlarm =
            AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createRegionalCustomerExperienceAlarm(this, props.availabilityMetricDetails.operationName, props.nameSuffix, this.availabilityAlarm, this.latencyAlarm);
    }
}
exports.BaseOperationRegionalAlarmsAndRules = BaseOperationRegionalAlarmsAndRules;
//# sourceMappingURL=data:application/json;base64,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