import { IAlarm } from 'aws-cdk-lib/aws-cloudwatch';
import { Construct } from 'constructs';
import { IBaseOperationRegionalAlarmsAndRules } from './IBaseOperationRegionalAlarmsAndRules';
import { BaseOperationRegionalAlarmsAndRulesProps } from './props/BaseOperationRegionalAlarmsAndRulesProps';
/**
 * Base operation regional alarms and rules
 */
export declare abstract class BaseOperationRegionalAlarmsAndRules extends Construct implements IBaseOperationRegionalAlarmsAndRules {
    /**
     * Availability alarm for this operation
     */
    availabilityAlarm: IAlarm;
    /**
     * Latency alarm for this operation
     */
    latencyAlarm: IAlarm;
    /**
     * Composite alarm for either availabiltiy or latency impact to this operation
     */
    availabilityOrLatencyAlarm: IAlarm;
    constructor(scope: Construct, id: string, props: BaseOperationRegionalAlarmsAndRulesProps);
}
