# aws-cdk-microservice
aws-cdk-microservice construct library is an open-source extension of the AWS Cloud Development Kit (AWS CDK) to deploy configurable microservice infra and its individual components in less than 50 lines of code and human readable configuration which can be managed by pull requests!

## A typical microservice architecture on AWS looks like:
![Architecture diagram](/static/microservice.png)

 Using cdk a microservice can be deployed using the following sample code snippet:
 ```typescript
import { Stack, StackProps } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { InfraEnv, MicroService, ProductName } from '@smallcase/aws-cdk-microservice';
import { App } from '@aws-cdk/core';

export class UnknownAPIStackDev extends Stack {
  constructor(scope: Construct, id: string, props?: StackProps) {
    super(scope, id, props);
    new MicroService(stack, 'UnknownAPI', {
      appName: 'UnknownAPI',
      env: 'development',
      asgMaxSize: '1',
      asgMinSize: '1',
      diskSize: 20,
      instanceLabels: [
        {
          key: 'NODE-VERSION',
          propagateAtLaunch: true,
          value: '12',
        },
        {
          key: 'TYPE',
          propagateAtLaunch: true,
          value: 'application',
        },
      ],
      instanceType: 't3.micro',
      vpc: 'vpc-1234567',
      port: 8000,
      protocol: 'HTTP',
      healthCheckPath: '/health',
      subnets: ['subnet-987654321', 'subnet-12345678'],
      tcpRules: [
        {
          sourceSG: 'sg-12345678',
          description: 'ssh rule',
          port: 22,
        },
      ],
      host: 'abc-test-123.smallcase.com',
      lbArn: 'arn:aws:elasticloadbalancing:ap-south-1:12345678910:loadbalancer/app/API-DEV-External',
      sslEnabled: false,
      sshKey: 'master-dev',
      createCodedeployApplication: true,
      role: {
        type: 'new',
      },
    });
  }
}

new UnknownAPIStackDev(app, 'UnknownAPIStackDev', {
  env: { account: '12345678910', region: 'ap-south-1' },
});

app.synth()
```
Please refer [here](/API.md) to check how to use individual resource constructs.

