# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ws_dash_components']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0', 'dash>=2.6.2,<3.0.0']

setup_kwargs = {
    'name': 'ws-dash-components',
    'version': '0.1.0',
    'description': '',
    'long_description': "# Whetstone Dash Components\n\nWhetstone Dash Components is a Dash component library.\n\nGet started with:\n1. Install Dash and its dependencies: https://dash.plotly.com/installation\n2. Run `python usage.py`\n3. Visit http://localhost:8050 in your web browser\n\n## Contributing\n\nSee [CONTRIBUTING.md](./CONTRIBUTING.md)\n\n### Install dependencies\n\nIf you have selected install_dependencies during the prompt, you can skip this part.\n\n1. Install npm packages\n    ```\n    $ npm install\n    ```\n2. Create a virtual env and activate.\n    ```\n    $ virtualenv venv\n    $ . venv/bin/activate\n    ```\n    _Note: venv\\Scripts\\activate for windows_\n\n3. Install python packages required to build components.\n    ```\n    $ pip install -r requirements.txt\n    ```\n4. Install the python packages for testing (optional)\n    ```\n    $ pip install -r tests/requirements.txt\n    ```\n\n### Write your component code in `src/lib/components/S3Upload.react.js`.\n\n- The demo app is in `src/demo` and you will import your example component code into your demo app.\n- Test your code in a Python environment:\n    1. Build your code\n        ```\n        $ npm run build\n        ```\n    2. Run and modify the `usage.py` sample dash app:\n        ```\n        $ python usage.py\n        ```\n- Write tests for your component.\n    - A sample test is available in `tests/test_usage.py`, it will load `usage.py` and you can then automate interactions with selenium.\n    - Run the tests with `$ pytest tests`.\n    - The Dash team uses these types of integration tests extensively. Browse the Dash component code on GitHub for more examples of testing (e.g. https://github.com/plotly/dash-core-components)\n- Add custom styles to your component by putting your custom CSS files into your distribution folder (`ws_dash_components`).\n    - Make sure that they are referenced in `MANIFEST.in` so that they get properly included when you're ready to publish your component.\n    - Make sure the stylesheets are added to the `_css_dist` dict in `ws_dash_components/__init__.py` so dash will serve them automatically when the component suite is requested.\n- [Review your code](./review_checklist.md)\n\n### Create a production build and publish:\n\n1. Build your code:\n    ```\n    $ npm run build\n    ```\n2. Create a Python distribution\n    ```\n    $ python setup.py sdist bdist_wheel\n    ```\n    This will create source and wheel distribution in the generated the `dist/` folder.\n    See [PyPA](https://packaging.python.org/guides/distributing-packages-using-setuptools/#packaging-your-project)\n    for more information.\n\n3. Test your tarball by copying it into a new environment and installing it locally:\n    ```\n    $ pip install ws_dash_components-0.0.1.tar.gz\n    ```\n\n4. If it works, then you can publish the component to NPM and PyPI:\n    1. Publish on PyPI\n        ```\n        $ twine upload dist/*\n        ```\n    2. Cleanup the dist folder (optional)\n        ```\n        $ rm -rf dist\n        ```\n    3. Publish on NPM (Optional if chosen False in `publish_on_npm`)\n        ```\n        $ npm publish\n        ```\n        _Publishing your component to NPM will make the JavaScript bundles available on the unpkg CDN. By default, Dash serves the component library's CSS and JS locally, but if you choose to publish the package to NPM you can set `serve_locally` to `False` and you may see faster load times._\n\n5. Share your component with the community! https://community.plotly.com/c/dash\n    1. Publish this repository to GitHub\n    2. Tag your GitHub repository with the plotly-dash tag so that it appears here: https://github.com/topics/plotly-dash\n    3. Create a post in the Dash community forum: https://community.plotly.com/c/dash\n",
    'author': 'Your Name',
    'author_email': 'you@example.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
