# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_core.ipynb.

# %% auto 0
__all__ = ['ConsultaSCR']

# %% ../nbs/00_core.ipynb 3
import json
import requests
import pandas as pd
from datetime import datetime
from typing import Tuple

class ConsultaSCR:
    def __init__(self, 
                 user: str,     # SCR user
                 password: str, # SCR password
                 code: str,     # SCR code
                 api_key: str   # SCR api key
    ):
        "Class to query SCR"
        self.user = user
        self.password = password
        self.code = code                                                
        self.key = api_key
        self.headers = {'Content-Type': 'application/json'}
        self.url = "https://bmpdigital.moneyp.com.br/api/BMPDigital/ConsultaSCR"
        self.params = {
            "auth": {
                "Usuario": self.user,
                "Senha": self.password,
                "CodigoParametro": self.code,
                "Chave": self.key
            },
            "consulta": {
                "Documento": "",
                "DataBaseMes": "",
                "DataBaseAno": ""
            }
        }
        
    def _request(self, 
                 doc: str,    # CPF or CNPJ
                 ano_mes: str # Year and month to be consulted. Format: MM_YYYY
    ) -> requests.models.Response:
        "Make a request to the SCR API"

        self.params["consulta"]["Documento"] = doc
        self.params["consulta"]["DataBaseMes"] = ano_mes[:2]
        self.params["consulta"]["DataBaseAno"] = ano_mes[3:]
        response = requests.request("POST", self.url, data=json.dumps(self.params), headers=self.headers)
        return response

    def _get_resumo_cliente_traduzido(self, 
                                      response_json: dict, # Response from the SCR API 
                                      **kwargs: dict       # Keyword arguments
    ) -> pd.DataFrame:
        "Return a DataFrame with the translated client summary"

        df = pd.DataFrame(response_json.get("ResumoDoClienteTraduzido"), columns=response_json.get("ResumoDoClienteTraduzido").keys(), index = [0])
        #df.insert(0, "doc", ''.join(filter(str.isdigit, kwargs.get("doc"))))
        df.insert(0, "doc", kwargs.get("doc"))
        df.insert(1, "data_consulta", kwargs.get("data_consulta"))
        df.insert(2, "ano_mes", kwargs.get("ano_mes"))
        df.insert(3, "msg", response_json.get("MensagemOperador"))
        return df
    
    def _get_resumo_modalidade(self, 
                               response_json: dict, # Response from the SCR API 
                               **kwargs: dict       # Keyword arguments
    ) -> pd.DataFrame:
        "Return a DataFrame with the modalities client summary"

        df = pd.DataFrame(response_json.get("ResumoModalidade"))
        df.insert(0, "doc", kwargs.get("doc"))
        df.insert(1, "data_consulta", kwargs.get("data_consulta"))
        df.insert(2, "ano_mes", kwargs.get("ano_mes"))
        return df

    def get_cpf_data(self, 
                     cpf: str, # List of CPFs
                     ano_mes: str,    # Year and month to be consulted. Format: MM_YYYY
    ) -> Tuple[pd.DataFrame, pd.DataFrame]:
        "Query CPFs and return a tuple of DataFrames: (df_cpf_resumo_cliente_traduzido, df_cpf_resumo_modalidade)"
        
        data_consulta = datetime.today().strftime("%d_%m_%Y")
        response_json = self._request(cpf, ano_mes).json()
        if response_json.get("Erro"):
            raise Exception(response_json.get("Msg").strip() + f": {cpf}")
        
        df_traduzido = self._get_resumo_cliente_traduzido(response_json, doc=cpf, data_consulta=data_consulta, ano_mes=ano_mes)
        df_modalidade = self._get_resumo_modalidade(response_json, doc=cpf, data_consulta=data_consulta, ano_mes=ano_mes)
        
        return df_traduzido, df_modalidade

    
    def get_cnpj_data(self, 
                      cnpj: str, # List of CNPJs 
                      ano_mes: str,     # Year and month to be consulted. Format: MM_YYYY
    ) -> Tuple[pd.DataFrame, pd.DataFrame]:
        "Query CNPJs and return a tuple of DataFrames: (df_cnpj_resumo_cliente_traduzido, df_cnpj_resumo_modalidade)"
        data_consulta = datetime.today().strftime("%d_%m_%Y")
        response_json = self._request(cnpj, ano_mes).json()
        if response_json.get("Erro"):
            raise Exception(response_json.get("Msg").strip() + f": {cnpj}")
        
        df_traduzido = self._get_resumo_cliente_traduzido(response_json, doc=cnpj, data_consulta=data_consulta, ano_mes=ano_mes)
        df_modalidade = self._get_resumo_modalidade(response_json, doc=cnpj, data_consulta=data_consulta, ano_mes=ano_mes)

        return df_traduzido, df_modalidade
