# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_cli.ipynb.

# %% auto 0
__all__ = ['consulta_scr', 'install_package', 'build_package']

# %% ../nbs/01_cli.ipynb 3
import os
from .core import ConsultaSCR
from fastcore.script import call_parse

# %% ../nbs/01_cli.ipynb 4
@call_parse
def consulta_scr(user:str,     # SCR user
                 password:str, # SCR password
                 code:str,     # SCR code
                 api_key:str,  # SCR API KEY
                 doc:str,      # CNPJs ou CPFs. Deve ser no formato 00.000.000/0000-00 ou 000.000.000-00
                 anomes:str,   # Ano e mês da consulta. Deve ser no formato MM_YYYY.
                 path:str="./scr_data", # Caminho para salvar os arquivos

    ):
    """
    Consulta o SCR e salva os dados em arquivos CSV.
    """

    scr = ConsultaSCR(
        user=user,
        password=password,
        code=code,
        api_key=api_key
    )

    if not os.path.exists(path):
        os.makedirs(path)

    if '/' in doc:
        df_cnpj_traduzido, df_cnpj_modalidade = scr.get_cnpj_data(doc, anomes)
        doc_only_digits = ''.join(filter(str.isdigit, doc))
        df_cnpj_traduzido.to_csv(f'{path}/scr_data_traduzido_{doc_only_digits}.csv', index=False, sep=";")
        df_cnpj_modalidade.to_csv(f'{path}/scr_data_modalidade_{doc_only_digits}.csv', index=False, sep=";")
    else:
        df_cpf_traduzido, df_cpf_modalidade = scr.get_cpf_data(doc, anomes)
        doc_only_digits = ''.join(filter(str.isdigit, doc))
        df_cpf_traduzido.to_csv(f'{path}/scr_data_traduzido_{doc_only_digits}.csv', index=False, sep=";")
        df_cpf_modalidade.to_csv(f'{path}/scr_data_modalidade_{doc_only_digits}.csv', index=False, sep=";")

    return True

# %% ../nbs/01_cli.ipynb 9
@call_parse
def install_package():
    "Install the package"
    os.system("pip install -e '.[dev]'")

# %% ../nbs/01_cli.ipynb 10
@call_parse
def build_package():
    "Build the package and generate the .whl file"
    os.system("python setup.py bdist_wheel")
