import numpy as np
import hashlib 
import time 

def encrypt(image, key, duration):

    # row X column X 3
    temp = np.array(image)
    temp1 = temp.copy()
    pic1 = temp.copy()

    duration = int(round(time.time() * 1000)) // duration

    # key generation 
    sha_key = hashlib.sha256((key+str(duration)).encode()).hexdigest().upper()
    len1 = (temp.shape[1]//16)*16
    column_key = [x for x in random_set if x < temp.shape[1]]

    counter = 0
    for i in range(0,len1, 16):
        sub_key = sha_key[counter:counter+16] + "1A0B95C4D37286EF"
        temp_set = []
        temp_index = 0

        # fisher-yates algo
        for j in range(i,i+16): 

            # pick only unique 0-9A-F values 
            while sub_key[temp_index] in temp_set:
                temp_index+=1
            temp_set.append(sub_key[temp_index])
            
            # hex to decimal 
            index = int(sub_key[temp_index], 16)
            
            # swap
            column_key[j],column_key[i+index] = column_key[i+index],column_key[j] 

        counter += 16
        if counter == 64:
            counter = 0
            sha_key = hashlib.sha256((sha_key).encode()).hexdigest().upper()

    # column transposition
    col = 0
    for k in column_key:
        for j in range(0, temp.shape[0]):
            temp1[j][col] = temp[j][k]
        col+=1

    # key generation 
    sha_key = hashlib.sha256((key+str(duration)).encode()).hexdigest().upper()
    len1 = (temp.shape[0]//16)*16
    row_key = [x for x in random_set if x < temp.shape[0]]

    counter = 0
    for i in range(0,len1, 16):
        sub_key = sha_key[counter:counter+16] + "1A0B95C4D37286EF"
        temp_set = []
        temp_index = 0

        # fisher-yates algo
        for j in range(i,i+16): 

            # pick only unique 0-9A-F values 
            while sub_key[temp_index] in temp_set:
                temp_index+=1
            temp_set.append(sub_key[temp_index])
            
            # hex to decimal 
            index = int(sub_key[temp_index], 16)
            
            # swap
            row_key[j],row_key[i+index] = row_key[i+index],row_key[j] 

        counter += 16
        if counter == 64:
            counter = 0
            sha_key = hashlib.sha256((sha_key).encode()).hexdigest().upper()

    # row transposition
    row = 0
    for k in row_key:
        for j in range(0, temp.shape[1]):
            pic1[row][j] = temp1[k][j]
        row+=1

    return pic1

def decrypt(image, key, duration):

    # row X column X 3
    temp = np.array(image)
    temp1 = temp.copy()
    pic1 = temp.copy()

    duration = int(round(time.time() * 1000)) // duration

    # key generation 
    sha_key = hashlib.sha256((key+str(duration)).encode()).hexdigest().upper()
    len1 = (temp.shape[0]//16)*16
    row_key = [x for x in random_set if x < temp.shape[0]]

    counter = 0
    for i in range(0,len1, 16):
        sub_key = sha_key[counter:counter+16] + "1A0B95C4D37286EF"
        temp_set = []
        temp_index = 0

        # fisher-yates algo
        for j in range(i,i+16): 

            # pick only unique 0-9A-F values 
            while sub_key[temp_index] in temp_set:
                temp_index+=1
            temp_set.append(sub_key[temp_index])
            
            # hex to decimal 
            index = int(sub_key[temp_index], 16)
            
            # swap
            row_key[j],row_key[i+index] = row_key[i+index],row_key[j] 

        counter += 16
        if counter == 64:
            counter = 0
            sha_key = hashlib.sha256((sha_key).encode()).hexdigest().upper()

    # row transposition
    row = 0
    for k in row_key:
        for j in range(0, temp.shape[1]):
            temp1[k][j] = temp[row][j]
        row+=1

    # key generation 
    sha_key = hashlib.sha256((key+str(duration)).encode()).hexdigest().upper()
    len1 = (temp.shape[1]//16)*16
    column_key = [x for x in random_set if x < temp.shape[1]]

    counter = 0
    for i in range(0,len1, 16):
        sub_key = sha_key[counter:counter+16] + "1A0B95C4D37286EF"
        temp_set = []
        temp_index = 0

        # fisher-yates algo
        for j in range(i,i+16): 

            # pick only unique 0-9A-F values 
            while sub_key[temp_index] in temp_set:
                temp_index+=1
            temp_set.append(sub_key[temp_index])
            
            # hex to decimal 
            index = int(sub_key[temp_index], 16)
            
            # swap
            column_key[j],column_key[i+index] = column_key[i+index],column_key[j] 

        counter += 16
        if counter == 64:
            counter = 0
            sha_key = hashlib.sha256((sha_key).encode()).hexdigest().upper()

    # column transposition
    col = 0
    for k in column_key:
        for j in range(0, temp.shape[0]):
            pic1[j][k] = temp1[j][col]
        col+=1

    return pic1
    
random_set = [1387, 62, 3942, 1922, 2268, 3303, 3641, 2803, 2141, 3302, 4595, 4871, 4054, 3305, 3263, 128, 1964, 2187, 4057, 1730, 531, 4905, 632, 1074, 2966, 1430, 3497, 3855, 4076, 3062, 4463, 4536, 1005, 4035, 1280, 740, 2839, 387, 675, 2679, 1029, 3783, 887, 3192, 359, 2037, 1526, 467, 1135, 1363, 3544, 358, 555, 2592, 4490, 4369, 4498, 23, 998, 981, 3682, 1609, 1053, 4623, 438, 4288, 3704, 704, 3345, 2249, 2175, 1332, 3552, 2285, 2680, 246, 3131, 4328, 2999, 1583, 4729, 4800, 264, 1234, 2114, 4633, 892, 1497, 3506, 36, 3480, 821, 2746, 4652, 4176, 2675, 1220, 511, 255, 3142, 4187, 1209, 161, 2843, 4386, 3985, 1857, 2648, 2979, 1081, 4687, 4153, 610, 1998, 2014, 4815, 3756, 2500, 2958, 39, 2228, 3687, 3656, 1806, 711, 2842, 606, 640, 3376, 3821, 2757, 1557, 3228, 1632, 4877, 4641, 4000, 2584, 2399, 1243, 1700, 4856, 899, 124, 158, 650, 363, 3090, 853, 3283, 121, 2261, 1020, 2589, 4719, 3767, 3045, 2856, 1085, 1192, 1841, 266, 3476, 2125, 389, 1323, 2690, 2171, 3428, 3180, 4244, 4813, 322, 1728, 1049, 4593, 3569, 2189, 4906, 1610, 3777, 2239, 4713, 3899, 624, 2678, 4639, 4053, 2099, 3493, 27, 4285, 3203, 2000, 4990, 2216, 1205, 4464, 2266, 378, 4372, 3407, 3221, 1248, 983, 371, 567, 3, 29, 1939, 1267, 4282, 1977, 4644, 2738, 1487, 2057, 2198, 3198, 2154, 1231, 1622, 451, 3672, 2577, 1057, 403, 294, 505, 415, 1334, 1261, 3017, 461, 3500, 3101, 2504, 3570, 1655, 1395, 1774, 4119, 3066, 2476, 2931, 4851, 2415, 2925, 2173, 4527, 4239, 3589, 999, 4017, 603, 4216, 3034, 2793, 4625, 2529, 2426, 825, 4534, 4493, 4359, 4392, 4845, 2557, 2408, 1830, 2722, 1590, 4672, 3949, 401, 1028, 3636, 3612, 4698, 1570, 4338, 1106, 4090, 4446, 4360, 2657, 4488, 2977, 50, 1905, 2790, 676, 4686, 475, 3988, 2841, 3499, 51, 3132, 1437, 2596, 1184, 4139, 3083, 548, 1401, 1542, 3058, 1572, 828, 2641, 15, 4707, 3618, 1751, 987, 2077, 3581, 3346, 4965, 1318, 4972, 308, 3844, 2697, 38, 526, 4930, 1203, 3745, 262, 2503, 2830, 2531, 3562, 1893, 3582, 4811, 2688, 3200, 1067, 4223, 3975, 964, 907, 2085, 4659, 835, 4774, 4430, 1612, 4448, 2637, 4193, 81, 3528, 3035, 2178, 3725, 4762, 424, 2190, 4128, 683, 106, 1767, 2086, 2273, 953, 4942, 4847, 3584, 3185, 2986, 388, 7, 2127, 3179, 1668, 189, 3761, 3509, 4151, 627, 4614, 2808, 787, 1027, 1043, 1625, 4429, 1672, 2802, 4191, 443, 251, 2649, 1529, 1208, 4946, 49, 1510, 857, 1391, 2265, 1404, 2963, 1023, 2565, 354, 4005, 770, 4261, 3172, 1657, 714, 2608, 4413, 2267, 666, 3782, 4003, 3039, 1896, 1837, 3196, 2483, 737, 656, 2044, 2909, 913, 1761, 3171, 2229, 757, 4210, 4782, 3085, 1827, 823, 775, 2982, 1740, 4180, 534, 3580, 1076, 2812, 3905, 2094, 2075, 1312, 1522, 3324, 3954, 1428, 1124, 4734, 1619, 4040, 3256, 1549, 171, 145, 3291, 2782, 277, 1212, 4141, 551, 4092, 1943, 2941, 2869, 3823, 4841, 2140, 993, 1383, 4484, 3168, 4100, 468, 2613, 1957, 4838, 2810, 2847, 152, 2018, 1200, 2357, 1794, 3780, 745, 3233, 1501, 2774, 3004, 2002, 3360, 402, 2578, 3423, 386, 1936, 1435, 1115, 4653, 58, 432, 4031, 2431, 2281, 1813, 3760, 490, 4710, 2451, 1399, 1039, 4777, 1165, 530, 2477, 1066, 773, 1845, 4267, 3079, 1971, 847, 4479, 413, 0, 2413, 3652, 4144, 3711, 1515, 1486, 2367, 1866, 1989, 2752, 3565, 688, 4272, 1104, 1075, 3266, 2875, 2379, 1873, 1594, 4726, 3025, 3465, 4565, 1788, 2498, 895, 3127, 2009, 641, 4416, 3406, 1451, 3647, 324, 2547, 783, 3663, 3961, 4468, 1661, 3720, 137, 3426, 3732, 2597, 3795, 1052, 2313, 2366, 1493, 325, 2571, 837, 2331, 4867, 2663, 1287, 589, 4083, 2102, 4497, 3014, 747, 25, 1834, 4613, 247, 2539, 3521, 827, 4268, 2218, 3106, 2588, 3757, 574, 916, 148, 3235, 74, 2923, 351, 2736, 3225, 2737, 129, 4509, 1352, 4717, 1485, 1265, 4855, 3434, 1904, 852, 1397, 3964, 2744, 199, 1776, 3444, 1566, 2101, 4260, 373, 2651, 167, 3396, 460, 1097, 1815, 900, 4857, 3490, 4944, 4309, 3108, 1413, 1268, 4426, 2139, 1240, 4438, 4358, 4610, 231, 1689, 1441, 1471, 3285, 4106, 1050, 230, 4341, 3137, 1484, 4349, 2708, 1329, 4284, 3074, 1748, 1113, 3872, 3579, 4462, 2788, 629, 2964, 503, 2074, 4089, 4496, 1855, 141, 3997, 2332, 1760, 4807, 1394, 2968, 647, 211, 1448, 2857, 2311, 3176, 4002, 270, 473, 2996, 2632, 1743, 2181, 3188, 597, 91, 1145, 3113, 4028, 3214, 1950, 2618, 2030, 1929, 2525, 4065, 160, 3772, 4571, 429, 1384, 3907, 3788, 1336, 3312, 4854, 1260, 4712, 361, 4056, 3901, 1322, 923, 418, 4093, 4131, 1627, 2143, 2462, 4515, 2748, 1603, 671, 2309, 1556, 3592, 826, 4918, 3572, 3785, 3382, 4896, 2402, 338, 345, 3056, 2324, 159, 196, 3523, 888, 3496, 425, 2418, 2180, 4955, 2419, 2517, 54, 1836, 628, 3646, 225, 1259, 609, 3245, 725, 3337, 2601, 4290, 3073, 1414, 2775, 3100, 2095, 4739, 4963, 1090, 1507, 4427, 3536, 3600, 1803, 3686, 3759, 1491, 2526, 2210, 3748, 518, 4417, 3219, 4691, 4749, 2562, 3969, 3177, 2013, 4329, 3971, 4192, 4411, 3440, 201, 4188, 2350, 596, 2762, 1547, 2928, 4806, 2345, 556, 3438, 4826, 1083, 1360, 3806, 3338, 4819, 3264, 317, 3380, 3254, 2892, 3213, 2473, 2583, 2459, 4585, 727, 672, 1960, 613, 2280, 4560, 2212, 4669, 130, 668, 4460, 540, 869, 3010, 4580, 4431, 4602, 4038, 4907, 1797, 377, 2863, 904, 3914, 4758, 4049, 674, 758, 1693, 3621, 46, 22, 97, 1881, 2818, 1789, 282, 4140, 891, 486, 1909, 3931, 1660, 2318, 4578, 4636, 1007, 658, 4340, 2307, 344, 1811, 4030, 4661, 3946, 2233, 706, 248, 2370, 1988, 4232, 1026, 682, 1551, 2513, 2113, 4174, 4982, 1534, 3545, 3114, 1932, 2849, 755, 729, 3839, 1266, 513, 482, 3843, 1356, 4337, 103, 2453, 1586, 1775, 4043, 836, 1604, 1708, 2634, 2881, 3624, 3691, 988, 3201, 4637, 4860, 4701, 890, 2053, 441, 2896, 3412, 1698, 4751, 1917, 135, 4356, 986, 1044, 1714, 1354, 841, 2169, 3765, 842, 1319, 4548, 2860, 1241, 367, 1637, 2015, 1157, 3712, 4375, 800, 8, 1864, 1702, 2100, 4368, 1333, 2569, 2702, 1978, 419, 4651, 2829, 839, 3705, 3953, 3522, 2213, 4126, 1382, 2417, 1204, 314, 4213, 643, 479, 3640, 3001, 2623, 4561, 3596, 1463, 3876, 1951, 2038, 2705, 1545, 2017, 276, 4132, 4177, 580, 1302, 1379, 3292, 1553, 3206, 487, 830, 795, 1035, 3422, 2686, 1467, 713, 3874, 4959, 4752, 3766, 694, 1127, 4456, 4670, 2704, 1578, 2047, 1783, 502, 1082, 3080, 3231, 3825, 3293, 1286, 2880, 2424, 2155, 4519, 2079, 901, 1330, 2202, 2338, 1685, 1532, 464, 1424, 3340, 1938, 4334, 4234, 1654, 2003, 4574, 4521, 1459, 1511, 1034, 3401, 667, 2222, 3694, 182, 2978, 903, 4722, 4645, 2604, 1739, 2028, 3352, 2505, 583, 3543, 3251, 1585, 1068, 463, 1598, 975, 1785, 816, 3169, 4764, 2436, 2784, 2967, 1958, 2134, 3375, 3195, 1499, 493, 2957, 4769, 4226, 384, 4865, 3064, 4933, 1620, 4590, 4512, 979, 833, 1155, 2954, 815, 4277, 2908, 996, 1974, 543, 165, 2305, 1724, 3602, 3175, 4194, 3099, 4741, 4702, 1535, 3884, 2036, 4117, 1473, 4186, 2090, 2605, 733, 2126, 2629, 3330, 1353, 4461, 3400, 1303, 2023, 4666, 170, 2076, 1179, 2006, 2817, 4724, 2455, 3939, 2004, 1434, 2927, 946, 1216, 654, 2848, 4577, 547, 3327, 4537, 2959, 2110, 1820, 2209, 4880, 1071, 2804, 2293, 3781, 4297, 3597, 24, 4347, 2043, 4036, 3259, 3425, 3239, 2813, 2511, 4345, 4883, 2296, 2907, 2710, 4581, 4023, 1631, 454, 4344, 568, 797, 355, 2717, 3370, 2432, 4185, 3669, 3740, 3260, 1225, 3441, 3091, 3463, 2133, 3575, 1538, 3922, 4566, 4434, 4720, 209, 2447, 4684, 1372, 1972, 3229, 2470, 1579, 3677, 2067, 4770, 2046, 4278, 696, 3336, 956, 2425, 2411, 4747, 4466, 3845, 1768, 4333, 941, 3129, 3359, 2058, 423, 2800, 2558, 3449, 3234, 1516, 810, 1099, 1673, 4307, 4024, 215, 569, 2653, 2078, 3583, 3892, 4891, 3242, 2730, 2401, 4928, 3033, 4230, 1412, 1629, 2185, 3871, 855, 4292, 1765, 1185, 370, 4077, 709, 4450, 3397, 1682, 2831, 1128, 1070, 3835, 2310, 1642, 3768, 1164, 3764, 2138, 4979, 4336, 4572, 1111, 2444, 1350, 480, 3442, 1854, 4217, 3802, 4096, 445, 1525, 2427, 1750, 4853, 3258, 3368, 3520, 1647, 3873, 333, 1643, 2069, 933, 1370, 254, 3739, 2130, 2656, 702, 4316, 2360, 2550, 1662, 2097, 4780, 772, 1703, 2719, 3738, 175, 2188, 1398, 805, 4203, 352, 2754, 318, 4470, 2049, 1095, 1626, 4415, 4175, 893, 4649, 3531, 4220, 2056, 2760, 848, 4091, 4535, 1359, 1675, 1440, 4619, 1256, 3852, 3237, 3972, 2272, 1432, 789, 3403, 1040, 3608, 286, 1169, 1191, 4104, 319, 4868, 3372, 1676, 2873, 2650, 271, 431, 214, 1297, 4550, 1368, 3831, 4055, 2956, 2995, 3519, 4586, 2234, 3809, 3918, 301, 2128, 1092, 3713, 4027, 2739, 2998, 3651, 3210, 1144, 4254, 2484, 957, 4156, 4929, 1362, 3295, 1045, 2390, 4984, 2042, 3967, 3436, 2822, 3197, 4500, 3717, 1019, 528, 1869, 2468, 3588, 1968, 1015, 1041, 537, 4240, 2372, 3483, 2088, 1952, 1230, 2422, 809, 1981, 2507, 2434, 2063, 4001, 2537, 1080, 3474, 4699, 2316, 3926, 4408, 3591, 3373, 1844, 76, 2633, 1131, 3689, 3181, 1239, 4172, 3667, 1112, 26, 4286, 4708, 4504, 4582, 3887, 4631, 4790, 114, 3096, 4820, 3307, 2021, 1955, 1147, 2677, 4073, 743, 2727, 1488, 1250, 3353, 3818, 2277, 4047, 4598, 3671, 748, 1618, 3383, 1301, 2644, 200, 4364, 2179, 3661, 3167, 1328, 3339, 633, 618, 174, 60, 3790, 784, 1561, 1504, 1773, 4999, 1219, 3053, 2007, 917, 626, 3735, 3817, 4556, 1038, 4079, 1996, 1215, 4251, 3277, 3933, 126, 2326, 3576, 934, 1443, 4773, 3409, 521, 4353, 655, 4514, 744, 3154, 1694, 1217, 4325, 4618, 4594, 3859, 3995, 2905, 4042, 4886, 2450, 2421, 21, 2356, 2016, 1374, 1415, 1925, 284, 951, 4327, 2628, 1658, 4597, 1536, 3603, 982, 4237, 2567, 2524, 3940, 1474, 1683, 3164, 2115, 2828, 2626, 3319, 4797, 1512, 2052, 1125, 4264, 2709, 2475, 469, 1390, 180, 3654, 393, 380, 2821, 2635, 1559, 3664, 3398, 2642, 2543, 4910, 327, 1692, 1478, 1078, 4478, 3709, 2011, 3830, 89, 871, 2346, 4029, 1299, 4197, 1644, 4044, 3281, 2320, 3358, 780, 1000, 222, 3504, 315, 492, 1479, 873, 2990, 1296, 16, 4890, 1839, 2066, 972, 4876, 3515, 3877, 2206, 1009, 4324, 3729, 59, 1042, 4160, 32, 4902, 178, 2553, 2655, 3800, 3822, 781, 4954, 2952, 3248, 4444, 3445, 452, 434, 1915, 2288, 546, 4604, 1903, 1623, 1423, 1897, 1916, 994, 4361, 3150, 2520, 527, 3891, 598, 1196, 924, 663, 878, 3082, 541, 3537, 3183, 1024, 705, 4748, 3928, 4250, 4953, 4836, 1883, 1568, 4745, 1995, 3432, 3424, 4149, 1314, 2243, 90, 4704, 4814, 4875, 1342, 2494, 2899, 1278, 1543, 4958, 2533, 1008, 3391, 2866, 749, 3557, 163, 292, 2682, 3590, 3746, 3986, 4406, 2755, 2747, 4129, 261, 607, 2854, 35, 4320, 997, 4626, 1032, 4899, 4888, 3868, 4567, 1304, 4246, 3919, 1475, 2506, 4418, 846, 3121, 4308, 1709, 3902, 796, 3973, 3898, 4909, 2054, 1151, 3542, 444, 4718, 2946, 4376, 2487, 484, 65, 3367, 272, 1134, 3328, 552, 1741, 1879, 2103, 2997, 3107, 4020, 4997, 2669, 100, 2398, 2924, 1509, 3968, 4949, 3900, 4318, 4279, 1431, 2937, 3255, 3561, 533, 1290, 762, 1742, 3593, 992, 2315, 1386, 2232, 4051, 3089, 866, 4122, 4354, 2917, 4783, 2761, 2395, 2546, 849, 685, 2244, 4494, 2230, 1630, 4339, 1453, 4423, 4591, 1214, 765, 4, 3813, 2490, 1400, 2693, 63, 1327, 3369, 188, 193, 3886, 1574, 1804, 4522, 3979, 2061, 4911, 1770, 1885, 2776, 4632, 3385, 4142, 510, 4668, 4225, 2479, 257, 4917, 343, 1649, 4270, 2135, 149, 340, 256, 1150, 2351, 1436, 1983, 4754, 2834, 723, 122, 3631, 1982, 701, 1624, 3834, 708, 2072, 1865, 1193, 4379, 1639, 1201, 4874, 1895, 3331, 411, 4008, 3475, 2330, 4380, 448, 488, 1281, 3267, 844, 2889, 566, 4291, 1416, 2393, 3999, 1406, 3842, 4032, 2412, 661, 2622, 3205, 2105, 3007, 3461, 3556, 4147, 1949, 412, 2106, 138, 3658, 1934, 3625, 2647, 1380, 4381, 2290, 1381, 2527, 2920, 1779, 2041, 4775, 4440, 4818, 86, 3418, 4362, 622, 1874, 1358, 3351, 824, 4400, 1979, 4048, 1600, 2157, 2463, 3040, 801, 3840, 1947, 224, 1121, 4562, 3472, 1818, 2936, 3482, 532, 2934, 166, 2616, 1100, 407, 4511, 3897, 2989, 3462, 3937, 1514, 1059, 2020, 1276, 3944, 636, 4608, 1022, 2581, 1505, 943, 305, 719, 2611, 4533, 453, 2938, 4436, 594, 4068, 4189, 1175, 717, 1924, 3190, 2509, 18, 3008, 4102, 3466, 131, 1665, 80, 4087, 4766, 2120, 4768, 28, 2363, 2750, 1298, 684, 4873, 4727, 3690, 303, 4183, 4685, 1762, 4410, 455, 3204, 3288, 2255, 3524, 4395, 311, 4007, 1737, 1870, 435, 4396, 4543, 2888, 240, 1419, 1438, 4967, 3714, 3311, 4757, 3808, 4367, 3078, 697, 2405, 1771, 33, 2240, 506, 1759, 3119, 2245, 3564, 2538, 312, 4019, 1859, 2815, 4133, 1961, 75, 1161, 3076, 123, 4627, 3063, 4276, 2820, 326, 4190, 1051, 2236, 213, 1454, 44, 2381, 3222, 1176, 2409, 4765, 3199, 804, 3152, 4255, 4642, 73, 1210, 646, 83, 4695, 1077, 4221, 112, 227, 2827, 2890, 722, 4378, 2388, 3715, 4961, 1913, 1449, 3670, 329, 3863, 374, 2983, 3860, 379, 2008, 2119, 143, 1829, 2122, 1799, 3733, 1344, 766, 313, 615, 4784, 3220, 2032, 2590, 4011, 3675, 1667, 1166, 653, 3747, 52, 2766, 2573, 381, 2919, 3431, 1838, 1181, 3275, 1894, 4314, 4118, 3906, 995, 3665, 4182, 4179, 2911, 68, 1807, 4233, 2292, 2548, 712, 2146, 4976, 2235, 894, 3960, 369, 4145, 2731, 4097, 4062, 132, 252, 707, 323, 3992, 1331, 2, 82, 1606, 1160, 1466, 1468, 1769, 2523, 4110, 462, 2308, 2735, 3378, 1122, 3553, 3286, 3464, 4785, 1195, 1118, 3387, 1307, 1757, 2728, 4287, 2969, 3700, 485, 2885, 3744, 4363, 3006, 774, 4343, 4903, 1197, 590, 2279, 2610, 2718, 3450, 2645, 1001, 6, 969, 120, 184, 1146, 450, 4014, 595, 1014, 2258, 4831, 803, 1719, 1816, 861, 4977, 399, 4169, 1691, 840, 2901, 1613, 2406, 2184, 4385, 4492, 2518, 4351, 1640, 372, 3050, 867, 1851, 1713, 1064, 4326, 4643, 4231, 4442, 1293, 2638, 2945, 2314, 4664, 4241, 1411, 2348, 3065, 2670, 2586, 2495, 3915, 3587, 3252, 3271, 1733, 700, 104, 3994, 4922, 4978, 1992, 1892, 2561, 1117, 1518, 3990, 1186, 4274, 3865, 1828, 2461, 1821, 3710, 2211, 1508, 3829, 2559, 623, 55, 728, 1809, 1853, 1706, 4981, 1871, 2758, 4663, 4621, 807, 944, 3573, 886, 110, 4296, 3771, 1823, 845, 2445, 4350, 3075, 4471, 3752, 3059, 1678, 3488, 698, 2700, 1482, 4487, 4837, 1143, 4404, 3393, 2437, 1795, 1407, 4832, 2874, 673, 1159, 4673, 563, 4616, 4803, 1569, 108, 786, 1638, 297, 3789, 3105, 4109, 4756, 1088, 2798, 3491, 3194, 2711, 4403, 2984, 428, 2217, 4732, 4215, 3833, 4951, 3936, 3541, 3737, 4646, 3716, 4352, 3539, 976, 3850, 3657, 4635, 4205, 3754, 3155, 726, 2306, 1589, 1094, 466, 1920, 2207, 3751, 2906, 2515, 585, 360, 3042, 1584, 237, 1069, 1812, 4130, 4414, 4452, 3630, 2259, 4060, 954, 4908, 2970, 3145, 3335, 2385, 1091, 523, 4388, 2695, 3941, 4995, 4629, 339, 1763, 2620, 310, 2809, 3306, 2340, 2083, 1801, 3279, 349, 3329, 939, 1963, 2763, 183, 3447, 3224, 4656, 4776, 1272, 2104, 1548, 3249, 1410, 2786, 1544, 642, 2124, 4788, 2168, 1727, 3097, 4725, 4437, 442, 3456, 168, 2012, 2910, 259, 4667, 4647, 3209, 3024, 3801, 2286, 3666, 500, 3535, 2867, 4723, 2716, 4099, 752, 2764, 2667, 4485, 2975, 2153, 669, 2636, 4552, 1378, 3847, 4195, 1791, 3365, 3362, 330, 4711, 2943, 829, 3810, 2627, 1173, 164, 558, 2096, 1805, 3676, 1959, 1946, 4199, 1206, 1447, 4924, 1102, 4266, 2238, 1641, 3726, 2111, 4365, 1666, 2039, 1494, 3092, 919, 525, 4242, 69, 3103, 1291, 1427, 2994, 2773, 2993, 3935, 477, 4989, 1073, 1377, 854, 771, 4026, 3186, 2549, 4319, 3896, 3945, 1177, 11, 4447, 679, 3166, 3458, 3804, 2713, 2973, 4694, 4508, 3261, 1931, 3120, 1537, 1456, 2396, 882, 12, 1002, 2121, 1718, 3736, 3002, 2335, 3510, 3296, 1326, 4455, 4121, 1991, 87, 88, 4247, 2876, 4451, 1729, 2282, 3455, 814, 3301, 1418, 860, 2723, 2805, 245, 573, 858, 3016, 3798, 4200, 4983, 945, 2478, 3052, 2707, 3244, 2024, 2132, 4693, 4587, 289, 2791, 400, 1758, 4601, 2325, 2672, 4640, 3832, 4925, 2600, 942, 3812, 3741, 2865, 1930, 3232, 4869, 2535, 1311, 4968, 3805, 397, 1294, 3514, 2845, 4405, 662, 1781, 1233, 4991, 940, 2457, 1787, 20, 738, 1756, 3170, 4012, 911, 1824, 2400, 1826, 1798, 724, 3708, 1731, 1513, 1444, 1860, 192, 4870, 3605, 883, 1228, 1994, 4526, 4088, 2489, 2416, 1862, 1954, 838, 1295, 268, 3827, 465, 3578, 3620, 635, 346, 331, 3023, 877, 1833, 3399, 1346, 3139, 96, 206, 2117, 291, 2220, 1607, 1470, 1483, 1502, 1244, 2253, 1872, 3875, 818, 2001, 4654, 968, 2664, 4219, 2380, 4771, 1519, 2269, 910, 2836, 1189, 4069, 2384, 1389, 3869, 2933, 616, 1766, 4980, 3851, 4248, 1573, 2585, 3218, 2932, 3927, 1275, 3934, 2214, 2323, 1262, 1445, 3068, 3866, 3776, 4457, 2336, 1777, 2706, 217, 3088, 931, 198, 2740, 1199, 1242, 2955, 2579, 1966, 3683, 10, 316, 1226, 5, 332, 2116, 4986, 4015, 1187, 1246, 4793, 3626, 210, 4120, 3191, 4198, 2165, 1555, 4245, 2915, 896, 3679, 604, 2151, 1292, 3518, 3981, 3381, 3421, 4889, 3998, 602, 971, 4513, 1408, 4283, 2897, 918, 3786, 3629, 2339, 1229, 4224, 4721, 1877, 4084, 102, 3125, 4021, 2226, 3437, 3236, 614, 4830, 4878, 3862, 2833, 3019, 233, 1633, 4532, 3217, 582, 4289, 2347, 2619, 4795, 3141, 4265, 938, 4737, 4700, 2373, 3585, 4740, 1778, 3653, 898, 2460, 1223, 3470, 3144, 811, 1738, 2544, 94, 2939, 2092, 3354, 4505, 1888, 436, 664, 561, 791, 1887, 2438, 2073, 1283, 1472, 4992, 3140, 1221, 2965, 78, 881, 2595, 3241, 550, 2824, 1477, 2256, 1611, 3511, 625, 2953, 3550, 2914, 235, 4563, 1575, 657, 812, 3313, 536, 4866, 2692, 754, 1615, 2162, 1681, 4750, 296, 1114, 2743, 117, 4901, 385, 2098, 4256, 2093, 258, 2215, 508, 457, 4397, 3574, 2519, 2614, 4236, 2361, 3371, 2574, 879, 1367, 2464, 4675, 2683, 195, 422, 1258, 1402, 1251, 2654, 3753, 3124, 364, 1006, 790, 2742, 4481, 3215, 4839, 2035, 1695, 710, 4103, 3707, 4342, 203, 2879, 4523, 4206, 4389, 2423, 2383, 4164, 4852, 3392, 3816, 4422, 549, 4167, 1277, 496, 3211, 4322, 3230, 1911, 4146, 2502, 2536, 3316, 1810, 1697, 3000, 1927, 4004, 105, 2991, 3280, 2652, 1480, 2303, 3507, 3047, 2778, 1918, 2988, 1284, 3692, 1236, 952, 1037, 3355, 2689, 3880, 4075, 4985, 4209, 1517, 3030, 3841, 3489, 3257, 4539, 1524, 3938, 3890, 3443, 2534, 342, 3043, 4281, 2321, 2696, 4524, 2203, 2862, 1054, 1744, 4483, 920, 3414, 4864, 905, 2354, 1987, 4530, 98, 155, 2568, 1597, 4045, 146, 1420, 3778, 115, 3548, 1800, 571, 3031, 3029, 864, 2734, 3525, 1153, 1388, 4676, 3811, 659, 1498, 4510, 1506, 3916, 3162, 3828, 2246, 3594, 4262, 1392, 3126, 1439, 4611, 4948, 4310, 4235, 2886, 2665, 64, 421, 1403, 3722, 621, 2342, 3038, 3604, 763, 3662, 1941, 4787, 3498, 927, 2971, 1711, 1503, 2182, 3151, 2913, 3289, 1349, 908, 3323, 1646, 147, 4495, 4299, 2891, 909, 1636, 1735, 1103, 2391, 4501, 4181, 4295, 3321, 4473, 3889, 1163, 1564, 494, 1962, 2051, 2480, 4127, 232, 72, 4046, 2701, 4010, 3273, 1985, 914, 4196, 2512, 3787, 819, 3655, 4650, 1101, 2570, 4063, 281, 1935, 3439, 77, 2174, 2745, 2109, 2050, 177, 1705, 1984, 109, 53, 2666, 1366, 806, 3347, 4912, 2034, 3613, 1365, 2355, 1882, 3727, 34, 639, 228, 3238, 383, 1369, 3377, 2658, 2270, 4269, 4884, 2712, 2508, 3356, 2844, 169, 581, 570, 404, 4157, 4767, 56, 144, 3742, 2853, 2612, 4480, 1253, 2394, 557, 1910, 587, 1663, 1183, 776, 1273, 1442, 3923, 4829, 2029, 1137, 253, 472, 1528, 4799, 2283, 4993, 1492, 4162, 4789, 1975, 4409, 242, 3246, 1061, 3379, 912, 1371, 2972, 3117, 3932, 2040, 3924, 3146, 620, 2371, 4863, 3599, 4792, 1289, 3836, 2715, 2048, 3921, 4674, 974, 4477, 269, 2771, 3298, 742, 2883, 3384, 157, 3133, 2598, 4112, 4034, 3032, 3269, 955, 4294, 470, 3966, 2064, 3469, 2521, 1889, 3216, 1108, 3457, 1802, 1270, 4009, 3310, 3908, 1746, 3253, 1819, 1338, 2341, 3803, 1148, 1132, 220, 3148, 4570, 2439, 2974, 1355, 357, 989, 2194, 2976, 1621, 4124, 2242, 3903, 4678, 1107, 1754, 3011, 799, 1772, 544, 275, 4861, 3093, 612, 4849, 202, 1288, 1417, 119, 4449, 285, 670, 3678, 4303, 1202, 2639, 3104, 2443, 396, 3361, 2859, 1347, 4859, 718, 2287, 1614, 4731, 1634, 4208, 127, 1178, 14, 578, 3527, 875, 2148, 1656, 4786, 1156, 3061, 142, 2987, 4107, 2729, 1188, 1780, 4932, 449, 576, 4887, 2811, 3086, 3357, 3429, 283, 2720, 341, 4006, 2673, 4459, 2152, 2435, 4665, 250, 4964, 1593, 751, 2893, 1337, 3247, 4435, 928, 3018, 1970, 3013, 4082, 958, 243, 37, 962, 2962, 1921, 4987, 236, 4662, 290, 1126, 3501, 4503, 4064, 2846, 4529, 2177, 4541, 4072, 3012, 1792, 1098, 4298, 3325, 2671, 1533, 2160, 4735, 2264, 3318, 2429, 885, 693, 1096, 822, 2257, 3703, 1174, 4862, 565, 2161, 4013, 1116, 1162, 2219, 1490, 3910, 4960, 3184, 2795, 1232, 2659, 2780, 1325, 2172, 1308, 1194, 2221, 4135, 2528, 1245, 173, 2826, 3015, 99, 3342, 2376, 3920, 1235, 767, 1914, 4321, 4370, 2353, 2251, 560, 3147, 4842, 732, 4827, 2684, 577, 1902, 43, 2694, 4753, 2554, 3577, 1599, 3420, 3419, 1993, 1617, 4834, 3883, 4825, 2201, 4605, 2176, 3290, 1669, 3773, 4682, 4202, 136, 2949, 1481, 3673, 1317, 2149, 584, 1796, 1552, 2129, 4382, 185, 4474, 4655, 1953, 4879, 1948, 2084, 4059, 4716, 768, 2186, 677, 1324, 3849, 446, 2541, 2661, 4330, 963, 539, 219, 4808, 1313, 865, 961, 47, 1576, 2192, 2882, 4420, 417, 545, 514, 1840, 2491, 3446, 1707, 2767, 2819, 3893, 3598, 2864, 3102, 761, 522, 4317, 1048, 427, 208, 973, 3138, 4846, 4781, 2751, 1170, 906, 695, 1011, 307, 2440, 1031, 4940, 4273, 3508, 3799, 31, 3477, 3394, 2852, 2362, 501, 3094, 4882, 2118, 759, 368, 1452, 2725, 2660, 4728, 3894, 4615, 118, 205, 1252, 4098, 2499, 2397, 4772, 2926, 4204, 3294, 4988, 4824, 2159, 4323, 3546, 2922, 1926, 3731, 366, 965, 3540, 4692, 3538, 2276, 4243, 2200, 2591, 4575, 2516, 3586, 350, 3202, 2167, 3226, 1849, 2199, 1808, 1539, 79, 960, 3568, 929, 3622, 2328, 1716, 1858, 1003, 3055, 4897, 4576, 4228, 3721, 3681, 4973, 4041, 2250, 2091, 4306, 1563, 1605, 134, 234, 3243, 794, 61, 2961, 4802, 306, 2902, 3349, 2940, 3322, 3660, 4401, 3856, 459, 3529, 4816, 4746, 2254, 1316, 3650, 4108, 509, 3958, 4305, 617, 2019, 990, 1997, 1167, 4432, 2205, 4936, 4377, 2615, 1580, 309, 1671, 4152, 2496, 564, 586, 4312, 3749, 1426, 980, 660, 4858, 4315, 1722, 4939, 3718, 1093, 3478, 4904, 3864, 4823, 4931, 2070, 862, 2904, 4689, 3157, 3526, 4402, 2545, 1017, 1595, 1063, 1348, 1688, 2714, 2832, 3395, 1405, 3554, 902, 3109, 299, 2033, 42, 382, 3479, 4812, 3853, 4293, 4168, 3755, 238, 3743, 2456, 2756, 4407, 229, 680, 3724, 3158, 4589, 151, 1715, 1016, 4962, 2835, 2080, 1, 1375, 721, 868, 3611, 2960, 4742, 1764, 375, 4171, 1745, 4074, 889, 4557, 347, 1340, 3693, 3774, 3348, 2300, 4259, 1825, 4445, 186, 2900, 579, 2223, 260, 1907, 1158, 3410, 447, 2295, 4387, 4105, 1285, 3615, 559, 3473, 4970, 832, 497, 3634, 4761, 3750, 1793, 1421, 2302, 3408, 4313, 2204, 634, 263, 1305, 1587, 3454, 3637, 356, 2197, 2609, 2060, 2392, 4482, 1025, 3559, 2446, 3003, 3619, 2304, 1725, 3072, 491, 4081, 4166, 2333, 1343, 782, 3036, 4078, 3697, 4677, 1690, 3838, 2870, 1255, 880, 4706, 3044, 2136, 113, 1890, 608, 3163, 678, 4258, 4840, 562, 471, 3791, 504, 3268, 524, 3020, 792, 2884, 19, 3797, 1306, 2724, 3160, 651, 4558, 3178, 1462, 689, 4050, 249, 1680, 3067, 3888, 4634, 1908, 1110, 2055, 1309, 1591, 2299, 2452, 2768, 4941, 2433, 2540, 2898, 1171, 2691, 3688, 3315, 1335, 4218, 4491, 4170, 649, 2797, 735, 456, 2617, 4111, 154, 4683, 3304, 4154, 3993, 3879, 831, 3115, 2403, 2877, 1409, 631, 2156, 1684, 3794, 1527, 2789, 1320, 1835, 1969, 4163, 3041, 4622, 2497, 409, 3616, 3037, 433, 4947, 645, 1699, 3095, 67, 4229, 1852, 162, 92, 1880, 3309, 172, 591, 3208, 870, 1720, 4630, 2327, 3054, 2806, 2301, 3858, 3049, 483, 985, 535, 1247, 3112, 1645, 1271, 3775, 4828, 3110, 4143, 1822, 3136, 4155, 984, 1749, 2349, 3607, 2921, 2430, 3784, 4588, 3978, 601, 3959, 2196, 4018, 2343, 4703, 3153, 3060, 1138, 3512, 3051, 1710, 4573, 2625, 1679, 876, 2358, 4956, 3193, 3989, 1736, 4553, 3983, 1753, 4441, 3388, 4915, 2441, 4071, 4275, 4545, 734, 2170, 935, 1933, 3122, 593, 2522, 1213, 125, 3609, 334, 2144, 1884, 4311, 1396, 3684, 2364, 3815, 3453, 2407, 328, 2871, 4568, 2317, 856, 3796, 495, 4518, 4394, 665, 4688, 4850, 1659, 2726, 394, 4607, 2191, 2344, 3026, 3991, 716, 2643, 3207, 1013, 843, 739, 4263, 1696, 45, 295, 3308, 778, 3701, 204, 1123, 3913, 1450, 4252, 4914, 2486, 1139, 932, 1899, 4817, 2838, 4950, 2703, 4791, 3820, 4885, 850, 1956, 4596, 813, 2183, 3460, 2950, 1500, 2026, 2551, 588, 1129, 4658, 512, 4227, 3623, 4302, 638, 2410, 3606, 3276, 406, 1190, 3405, 476, 507, 95, 4332, 3300, 1848, 1047, 3448, 4085, 3435, 1341, 3930, 4304, 3451, 439, 2903, 4443, 897, 3595, 2980, 2142, 4974, 2530, 599, 542, 1218, 2087, 2378, 4549, 1923, 1677, 731, 2225, 4253, 288, 4094, 3187, 4433, 4872, 2284, 2481, 4373, 3628, 3427, 181, 4624, 4520, 4052, 1582, 2449, 1567, 2428, 1523, 2555, 4671, 216, 1227, 947, 4759, 1608, 2646, 1393, 101, 820, 4428, 3494, 244, 4280, 730, 3956, 3696, 4738, 176, 3929, 692, 3837, 3022, 3695, 1550, 365, 3143, 1616, 4892, 1425, 4696, 2375, 1084, 1105, 3719, 4399, 3389, 1565, 3021, 1133, 2291, 1036, 3413, 2137, 605, 4101, 2488, 2674, 1732, 2560, 4660, 3320, 1701, 3610, 4648, 2587, 3481, 4755, 3861, 2150, 1198, 4489, 4579, 3070, 3947, 3824, 2263, 2319, 140, 3250, 3734, 2850, 3287, 1455, 2382, 1089, 4680, 592, 3567, 353, 2031, 191, 3404, 3134, 4835, 337, 3417, 4421, 336, 967, 2123, 2607, 4743, 3793, 2861, 2227, 3098, 267, 3970, 2602, 1588, 884, 619, 2420, 1755, 2741, 4564, 4486, 4538, 1723, 4603, 3980, 279, 2492, 156, 4080, 2799, 4517, 3878, 1863, 420, 2772, 139, 1558, 3227, 2337, 978, 1571, 3471, 2062, 4058, 2935, 741, 1058, 3532, 4920, 2458, 2912, 2749, 3987, 2942, 1207, 3503, 3087, 2918, 499, 2448, 1018, 3649, 798, 4681, 3685, 3314, 4454, 611, 4805, 2801, 520, 3081, 4916, 4507, 430, 2252, 3433, 1180, 2025, 925, 2624, 1577, 116, 3635, 4037, 3976, 1937, 2294, 3702, 3534, 4628, 3644, 4271, 2630, 3135, 3955, 207, 715, 4136, 1361, 1521, 1033, 71, 2796, 1120, 3533, 1072, 194, 2145, 2386, 4966, 1581, 4366, 1945, 2247, 4600, 4472, 320, 3486, 851, 1310, 2825, 2231, 4467, 1257, 3009, 1446, 3071, 2224, 2471, 2289, 3341, 1461, 1635, 40, 3814, 4893, 4921, 2699, 1704, 3639, 1891, 2858, 1912, 2081, 1650, 863, 478, 1140, 4061, 4115, 4335, 2482, 2082, 4134, 4123, 746, 4705, 1976, 3492, 4833, 630, 2837, 1652, 1687, 3350, 1282, 2563, 3415, 3948, 2816, 3430, 278, 516, 190, 3374, 3770, 2894, 2685, 4137, 4391, 2631, 554, 1010, 3278, 1154, 1055, 1898, 4810, 4555, 750, 1562, 736, 70, 1846, 4158, 265, 760, 1136, 4894, 3502, 335, 2759, 4465, 3156, 57, 93, 4895, 1376, 3173, 4544, 4331, 2369, 3668, 4384, 3632, 1119, 4804, 2662, 1868, 4609, 3571, 2840, 2929, 1079, 4822, 4733, 3648, 4927, 4809, 3909, 3551, 1831, 4371, 426, 4606, 1279, 1224, 2855, 2753, 4934, 2274, 2552, 2241, 4207, 4469, 293, 4569, 416, 405, 2474, 4583, 9, 1847, 2676, 3762, 4913, 4458, 2992, 1004, 644, 3962, 3982, 4945, 703, 720, 4383, 4499, 4796, 3416, 1747, 3333, 3723, 3555, 2878, 241, 3182, 2334, 150, 3984, 3917, 280, 274, 4201, 3857, 3645, 977, 1919, 519, 2948, 2770, 2733, 681, 1254, 1182, 959, 753, 1876, 3925, 930, 1967, 3174, 3159, 2010, 273, 2851, 3390, 4148, 4070, 1300, 1345, 2359, 4844, 2059, 458, 3343, 2329, 489, 4821, 2640, 3560, 398, 4525, 948, 3366, 4898, 4559, 1670, 921, 2807, 3149, 1130, 3643, 391, 1990, 2944, 4926, 4390, 4346, 4736, 970, 4257, 4744, 3965, 300, 17, 4425, 2572, 4125, 1973, 1999, 764, 84, 1060, 4801, 2698, 85, 1601, 4919, 2454, 1875, 2787, 3627, 1653, 4996, 3730, 2564, 2005, 1168, 1850, 1142, 3128, 1315, 2469, 4506, 179, 4994, 2668, 1458, 1628, 1429, 3807, 2068, 1540, 3904, 4212, 2872, 1541, 1087, 699, 2794, 2916, 3996, 3558, 1172, 515, 3642, 3262, 4709, 2387, 1906, 2389, 3116, 1752, 3077, 2065, 4374, 3974, 2732, 648, 3495, 2887, 1460, 2237, 4016, 3706, 30, 1021, 777, 2131, 1648, 3459, 802, 2606, 4690, 2783, 2108, 575, 1900, 4542, 4039, 395, 3517, 950, 410, 3638, 4592, 3118, 3728, 1944, 4554, 2365, 1867, 2414, 4159, 3452, 874, 4657, 2164, 3819, 3881, 4165, 3680, 4222, 1476, 1674, 3848, 1222, 3977, 392, 3363, 1782, 1832, 1030, 2765, 187, 4516, 1940, 3659, 1489, 1856, 1901, 4301, 197, 1560, 348, 2814, 4214, 529, 4086, 133, 3048, 1062, 2467, 3282, 1433, 2594, 1495, 2147, 3274, 4714, 4531, 937, 1664, 2278, 1602, 1238, 2322, 1790, 1065, 3911, 2472, 1046, 3284, 2576, 2785, 1520, 2542, 3957, 3364, 1237, 3123, 4398, 2045, 2404, 2442, 4551, 4952, 3547, 2193, 4923, 3485, 4439, 218, 4528, 4778, 1530, 1056, 1149, 4937, 3270, 3882, 4348, 4679, 1651, 4161, 1264, 4238, 3069, 1717, 3792, 2599, 4033, 2166, 2930, 287, 3189, 966, 3027, 4025, 3513, 3344, 2769, 1965, 4475, 4848, 3161, 687, 13, 2027, 4173, 4969, 362, 2777, 834, 4393, 3332, 3963, 3895, 2262, 1351, 756, 3698, 4599, 785, 2981, 221, 1784, 691, 2985, 66, 4943, 2485, 4779, 3867, 302, 1546, 4178, 652, 4095, 3130, 3633, 1786, 2687, 2312, 4638, 4971, 4184, 4617, 3601, 2275, 3549, 3028, 872, 4476, 3530, 4730, 859, 2163, 2681, 2368, 3046, 4763, 1464, 3487, 1686, 600, 3566, 788, 3516, 4843, 298, 2260, 3699, 1592, 3951, 304, 4453, 1980, 4211, 1152, 2493, 2271, 4612, 390, 2868, 474, 3617, 3386, 1339, 4113, 3165, 4620, 4502, 3779, 4138, 4760, 769, 226, 3467, 517, 1321, 3411, 690, 2112, 922, 1364, 1269, 572, 3402, 4300, 498, 1496, 926, 4584, 223, 779, 1422, 808, 2374, 2582, 1109, 4938, 153, 4412, 1817, 2195, 3846, 321, 1385, 4998, 414, 3111, 637, 2107, 1357, 3769, 2603, 2593, 4881, 2208, 817, 2297, 2792, 3265, 3674, 793, 936, 4547, 2721, 3758, 915, 4900, 4798, 1842, 2377, 2089, 2298, 3484, 3826, 2951, 3912, 1843, 1086, 2158, 481, 437, 1531, 2895, 4715, 2580, 1814, 1942, 1469, 3563, 376, 2779, 4249, 3870, 3084, 4022, 2466, 4935, 1928, 3240, 949, 4975, 111, 2501, 1457, 3005, 3212, 1861, 2556, 3505, 3326, 1249, 1726, 440, 3468, 4067, 1263, 991, 1734, 1211, 4546, 1554, 3334, 2575, 212, 3763, 4697, 4114, 4540, 3952, 4957, 1878, 1721, 4424, 2566, 2781, 107, 1012, 3223, 4066, 3272, 3885, 3943, 2352, 2514, 4150, 553, 4357, 1596, 408, 3299, 1465, 4355, 2621, 686, 41, 2532, 3317, 538, 2823, 239, 2465, 4116, 2248, 3297, 2510, 48, 3057, 3614, 2947, 2022, 1141, 3950, 4419, 1712, 3854, 4794, 1373, 1986, 1886, 2071, 1274]
