# Generated by Django 4.2.23 on 2025-08-07 11:50

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('eveuniverse', '0011_extend_industry_activites'),
    ]

    operations = [
        migrations.CreateModel(
            name='General',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'permissions': [('basic_access', 'Can access this app'), ('manage_anoms', 'Can manage anomalies')],
                'managed': False,
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='AnomalyTierSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tier', models.CharField(choices=[('t1', 'Tier 1'), ('t2', 'Tier 2'), ('t3', 'Tier 3'), ('ice', 'Ice')], max_length=10, unique=True)),
                ('respawn_time', models.IntegerField(default=60)),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='Discord',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('webhook_active', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=150)),
                ('webhook_url', models.CharField(max_length=500)),
                ('ping_target', models.CharField(blank=True, help_text='Select @everyone, @here, or a group name from AllianceAuth.', max_length=100)),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='Anomalies',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_up', models.BooleanField(default=True)),
                ('roll_started_at', models.DateTimeField(blank=True, null=True)),
                ('next_respown', models.BooleanField(default=False)),
                ('all_respown', models.BooleanField(default=False)),
                ('ore', models.CharField(choices=[('Veldspar', 'Tritanium'), ('Mordunium', 'Pyerite'), ('Kylixium', 'Mexallon'), ('Griemeer', 'Isogen'), ('Nocxite', 'Nocxium'), ('Hezorime', 'Zydrine'), ('Neganite', 'Megacyte'), ('Ice', 'Ice')], default='', max_length=15)),
                ('anom_system', models.ForeignKey(help_text='system of the anomally', on_delete=django.db.models.deletion.CASCADE, to='eveuniverse.evesolarsystem')),
                ('anom_tier', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='anomalies', to='anomalytracker.anomalytiersettings')),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.AddConstraint(
            model_name='anomalies',
            constraint=models.UniqueConstraint(fields=('anom_system',), name='unique_anom_per_system'),
        ),
    ]
