import * as cdk from '@aws-cdk/core';
/**
 * Provides a S3 bucket resource.
 *
 * -> This functionality is for managing S3 in an AWS Partition. To manage [S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html), see the [`aws_s3control_bucket`](/docs/providers/aws/r/s3control_bucket.html) resource.
 *
 * @schema CfnS3bucketProps
 */
export interface CfnS3bucketProps {
    /**
     * Sets the accelerate configuration of an existing bucket.
     *
     * Can be `Enabled` or `Suspended`.
     *
     * @schema CfnS3bucketProps#AccelerationStatus
     */
    readonly accelerationStatus?: string;
    /**
     * The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`.
     *
     * @default private`.  Conflicts with `grant`.
     * @schema CfnS3bucketProps#Acl
     */
    readonly acl?: string;
    /**
     * @schema CfnS3bucketProps#Arn
     */
    readonly arn?: string;
    /**
     * The name of the bucket.
     *
     * If omitted, Terraform will assign a random, unique name. Must be less than or equal to 63 characters in length.
     *
     * @schema CfnS3bucketProps#Bucket
     */
    readonly bucket?: string;
    /**
     * Creates a unique bucket name beginning with the specified prefix.
     *
     * Conflicts with `bucket`. Must be less than or equal to 37 characters in length.
     *
     * @schema CfnS3bucketProps#BucketPrefix
     */
    readonly bucketPrefix?: string;
    /**
     * A boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket so that the bucket can be destroyed without error. These objects are *not* recoverable.
     *
     * @schema CfnS3bucketProps#ForceDestroy
     */
    readonly forceDestroy?: boolean;
    /**
     * @schema CfnS3bucketProps#HostedZoneId
     */
    readonly hostedZoneId?: string;
    /**
     * A valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), Terraform may view the policy as constantly changing in a `terraform plan`. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with Terraform, see the [AWS IAM Policy Document Guide](https://learn.hashicorp.com/terraform/aws/iam-policy).
     *
     * @schema CfnS3bucketProps#Policy
     */
    readonly policy?: string;
    /**
     * Specifies who should bear the cost of Amazon S3 data transfer.
     *
     * Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur
     * the costs of any data transfer. See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html)
     * developer guide for more information.
     *
     * @schema CfnS3bucketProps#RequestPayer
     */
    readonly requestPayer?: string;
    /**
     * A map of tags to assign to the bucket.
     *
     * If configured with a provider [`default_tags` configuration block](/docs/providers/aws/index.html#default_tags-configuration-block) present, tags with matching keys will overwrite those defined at the provider-level.
     *
     * @schema CfnS3bucketProps#Tags
     */
    readonly tags?: TagsDefinition[];
    /**
     * @schema CfnS3bucketProps#TagsAll
     */
    readonly tagsAll?: TagsAllDefinition[];
    /**
     * @schema CfnS3bucketProps#WebsiteDomain
     */
    readonly websiteDomain?: string;
    /**
     * @schema CfnS3bucketProps#WebsiteEndpoint
     */
    readonly websiteEndpoint?: string;
    /**
     * @schema CfnS3bucketProps#CorsRule
     */
    readonly corsRule?: CorsRuleDefinition[];
    /**
     * @schema CfnS3bucketProps#Grant
     */
    readonly grant?: GrantDefinition[];
    /**
     * @schema CfnS3bucketProps#LifecycleRule
     */
    readonly lifecycleRule?: LifecycleRuleDefinition[];
    /**
     * @schema CfnS3bucketProps#Logging
     */
    readonly logging?: LoggingDefinition[];
    /**
     * @schema CfnS3bucketProps#ObjectLockConfiguration
     */
    readonly objectLockConfiguration?: ObjectLockConfigurationDefinition[];
    /**
     * @schema CfnS3bucketProps#ReplicationConfiguration
     */
    readonly replicationConfiguration?: ReplicationConfigurationDefinition[];
    /**
     * @schema CfnS3bucketProps#ServerSideEncryptionConfiguration
     */
    readonly serverSideEncryptionConfiguration?: ServerSideEncryptionConfigurationDefinition[];
    /**
     * @schema CfnS3bucketProps#Versioning
     */
    readonly versioning?: VersioningDefinition[];
    /**
     * @schema CfnS3bucketProps#Website
     */
    readonly website?: WebsiteDefinition[];
}
/**
 * Converts an object of type 'CfnS3bucketProps' to JSON representation.
 */
export declare function toJson_CfnS3bucketProps(obj: CfnS3bucketProps | undefined): Record<string, any> | undefined;
/**
 * @schema TagsDefinition
 */
export interface TagsDefinition {
    /**
     * @schema TagsDefinition#MapKey
     */
    readonly mapKey: string;
    /**
     * @schema TagsDefinition#MapValue
     */
    readonly mapValue: string;
}
/**
 * Converts an object of type 'TagsDefinition' to JSON representation.
 */
export declare function toJson_TagsDefinition(obj: TagsDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema TagsAllDefinition
 */
export interface TagsAllDefinition {
    /**
     * @schema TagsAllDefinition#MapKey
     */
    readonly mapKey: string;
    /**
     * @schema TagsAllDefinition#MapValue
     */
    readonly mapValue: string;
}
/**
 * Converts an object of type 'TagsAllDefinition' to JSON representation.
 */
export declare function toJson_TagsAllDefinition(obj: TagsAllDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema CorsRuleDefinition
 */
export interface CorsRuleDefinition {
    /**
     * @schema CorsRuleDefinition#AllowedHeaders
     */
    readonly allowedHeaders?: string[];
    /**
     * @schema CorsRuleDefinition#AllowedMethods
     */
    readonly allowedMethods: string[];
    /**
     * @schema CorsRuleDefinition#AllowedOrigins
     */
    readonly allowedOrigins: string[];
    /**
     * @schema CorsRuleDefinition#ExposeHeaders
     */
    readonly exposeHeaders?: string[];
    /**
     * @schema CorsRuleDefinition#MaxAgeSeconds
     */
    readonly maxAgeSeconds?: number;
}
/**
 * Converts an object of type 'CorsRuleDefinition' to JSON representation.
 */
export declare function toJson_CorsRuleDefinition(obj: CorsRuleDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema GrantDefinition
 */
export interface GrantDefinition {
    /**
     * Canonical user id to grant for.
     *
     * Used only when `type` is `CanonicalUser`.
     *
     * @schema GrantDefinition#Id
     */
    readonly id?: string;
    /**
     * List of permissions to apply for grantee.
     *
     * Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
     *
     * @schema GrantDefinition#Permissions
     */
    readonly permissions: string[];
    /**
     * - Type of grantee to apply for.
     *
     * Valid values are `CanonicalUser` and `Group`. `AmazonCustomerByEmail` is not supported.
     *
     * @schema GrantDefinition#Type
     */
    readonly type: string;
    /**
     * Uri address to grant for.
     *
     * Used only when `type` is `Group`.
     *
     * @schema GrantDefinition#Uri
     */
    readonly uri?: string;
}
/**
 * Converts an object of type 'GrantDefinition' to JSON representation.
 */
export declare function toJson_GrantDefinition(obj: GrantDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema LifecycleRuleDefinition
 */
export interface LifecycleRuleDefinition {
    /**
     * @schema LifecycleRuleDefinition#AbortIncompleteMultipartUploadDays
     */
    readonly abortIncompleteMultipartUploadDays?: number;
    /**
     * Specifies lifecycle rule status.
     *
     * @schema LifecycleRuleDefinition#Enabled
     */
    readonly enabled: boolean;
    /**
     * Unique identifier for the rule.
     *
     * Must be less than or equal to 255 characters in length.
     *
     * @schema LifecycleRuleDefinition#Id
     */
    readonly id?: string;
    /**
     * Object key prefix identifying one or more objects to which the rule applies.
     *
     * @schema LifecycleRuleDefinition#Prefix
     */
    readonly prefix?: string;
    /**
     * Specifies object tags key and value.
     *
     * @schema LifecycleRuleDefinition#Tags
     */
    readonly tags?: TagsDefinition2[];
    /**
     * @schema LifecycleRuleDefinition#Expiration
     */
    readonly expiration?: ExpirationDefinition[];
    /**
     * @schema LifecycleRuleDefinition#NoncurrentVersionExpiration
     */
    readonly noncurrentVersionExpiration?: NoncurrentVersionExpirationDefinition[];
    /**
     * @schema LifecycleRuleDefinition#NoncurrentVersionTransition
     */
    readonly noncurrentVersionTransition?: NoncurrentVersionTransitionDefinition[];
    /**
     * @schema LifecycleRuleDefinition#Transition
     */
    readonly transition?: TransitionDefinition[];
}
/**
 * Converts an object of type 'LifecycleRuleDefinition' to JSON representation.
 */
export declare function toJson_LifecycleRuleDefinition(obj: LifecycleRuleDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema LoggingDefinition
 */
export interface LoggingDefinition {
    /**
     * The name of the bucket that will receive the log objects.
     *
     * @schema LoggingDefinition#TargetBucket
     */
    readonly targetBucket: string;
    /**
     * To specify a key prefix for log objects.
     *
     * @schema LoggingDefinition#TargetPrefix
     */
    readonly targetPrefix?: string;
}
/**
 * Converts an object of type 'LoggingDefinition' to JSON representation.
 */
export declare function toJson_LoggingDefinition(obj: LoggingDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema ObjectLockConfigurationDefinition
 */
export interface ObjectLockConfigurationDefinition {
    /**
     * Indicates whether this bucket has an Object Lock configuration enabled.
     *
     * Valid value is `Enabled`.
     *
     * @schema ObjectLockConfigurationDefinition#ObjectLockEnabled
     */
    readonly objectLockEnabled: string;
    /**
     * @schema ObjectLockConfigurationDefinition#Rule
     */
    readonly rule?: RuleDefinition[];
}
/**
 * Converts an object of type 'ObjectLockConfigurationDefinition' to JSON representation.
 */
export declare function toJson_ObjectLockConfigurationDefinition(obj: ObjectLockConfigurationDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema ReplicationConfigurationDefinition
 */
export interface ReplicationConfigurationDefinition {
    /**
     * The ARN of the IAM role for Amazon S3 to assume when replicating the objects.
     *
     * @schema ReplicationConfigurationDefinition#Role
     */
    readonly role: string;
    /**
     * @schema ReplicationConfigurationDefinition#Rules
     */
    readonly rules?: RulesDefinition[];
}
/**
 * Converts an object of type 'ReplicationConfigurationDefinition' to JSON representation.
 */
export declare function toJson_ReplicationConfigurationDefinition(obj: ReplicationConfigurationDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema ServerSideEncryptionConfigurationDefinition
 */
export interface ServerSideEncryptionConfigurationDefinition {
    /**
     * @schema ServerSideEncryptionConfigurationDefinition#Rule
     */
    readonly rule?: RuleDefinition[];
}
/**
 * Converts an object of type 'ServerSideEncryptionConfigurationDefinition' to JSON representation.
 */
export declare function toJson_ServerSideEncryptionConfigurationDefinition(obj: ServerSideEncryptionConfigurationDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema VersioningDefinition
 */
export interface VersioningDefinition {
    /**
     * Enable versioning.
     *
     * Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
     *
     * @schema VersioningDefinition#Enabled
     */
    readonly enabled?: boolean;
    /**
     * Enable MFA delete for either `Change the versioning state of your bucket` or `Permanently delete an object version`.
     *
     * Default is `false`. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS.
     *
     * @default false`. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS.
     * @schema VersioningDefinition#MfaDelete
     */
    readonly mfaDelete?: boolean;
}
/**
 * Converts an object of type 'VersioningDefinition' to JSON representation.
 */
export declare function toJson_VersioningDefinition(obj: VersioningDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema WebsiteDefinition
 */
export interface WebsiteDefinition {
    /**
     * An absolute path to the document to return in case of a 4XX error.
     *
     * @schema WebsiteDefinition#ErrorDocument
     */
    readonly errorDocument?: string;
    /**
     * Amazon S3 returns this index document when requests are made to the root domain or any of the subfolders.
     *
     * @schema WebsiteDefinition#IndexDocument
     */
    readonly indexDocument?: string;
    /**
     * A hostname to redirect all website requests for this bucket to.
     *
     * Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
     *
     * @schema WebsiteDefinition#RedirectAllRequestsTo
     */
    readonly redirectAllRequestsTo?: string;
    /**
     * A json array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html) describing redirect behavior and when redirects are applied.
     *
     * @schema WebsiteDefinition#RoutingRules
     */
    readonly routingRules?: string;
}
/**
 * Converts an object of type 'WebsiteDefinition' to JSON representation.
 */
export declare function toJson_WebsiteDefinition(obj: WebsiteDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema TagsDefinition2
 */
export interface TagsDefinition2 {
    /**
     * @schema TagsDefinition2#MapKey
     */
    readonly mapKey: string;
    /**
     * @schema TagsDefinition2#MapValue
     */
    readonly mapValue: string;
}
/**
 * Converts an object of type 'TagsDefinition2' to JSON representation.
 */
export declare function toJson_TagsDefinition2(obj: TagsDefinition2 | undefined): Record<string, any> | undefined;
/**
 * @schema ExpirationDefinition
 */
export interface ExpirationDefinition {
    /**
     * @schema ExpirationDefinition#Date
     */
    readonly date?: string;
    /**
     * @schema ExpirationDefinition#Days
     */
    readonly days?: number;
    /**
     * @schema ExpirationDefinition#ExpiredObjectDeleteMarker
     */
    readonly expiredObjectDeleteMarker?: boolean;
}
/**
 * Converts an object of type 'ExpirationDefinition' to JSON representation.
 */
export declare function toJson_ExpirationDefinition(obj: ExpirationDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema NoncurrentVersionExpirationDefinition
 */
export interface NoncurrentVersionExpirationDefinition {
    /**
     * @schema NoncurrentVersionExpirationDefinition#Days
     */
    readonly days?: number;
}
/**
 * Converts an object of type 'NoncurrentVersionExpirationDefinition' to JSON representation.
 */
export declare function toJson_NoncurrentVersionExpirationDefinition(obj: NoncurrentVersionExpirationDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema NoncurrentVersionTransitionDefinition
 */
export interface NoncurrentVersionTransitionDefinition {
    /**
     * @schema NoncurrentVersionTransitionDefinition#Days
     */
    readonly days?: number;
    /**
     * @schema NoncurrentVersionTransitionDefinition#StorageClass
     */
    readonly storageClass: string;
}
/**
 * Converts an object of type 'NoncurrentVersionTransitionDefinition' to JSON representation.
 */
export declare function toJson_NoncurrentVersionTransitionDefinition(obj: NoncurrentVersionTransitionDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema TransitionDefinition
 */
export interface TransitionDefinition {
    /**
     * @schema TransitionDefinition#Date
     */
    readonly date?: string;
    /**
     * @schema TransitionDefinition#Days
     */
    readonly days?: number;
    /**
     * @schema TransitionDefinition#StorageClass
     */
    readonly storageClass: string;
}
/**
 * Converts an object of type 'TransitionDefinition' to JSON representation.
 */
export declare function toJson_TransitionDefinition(obj: TransitionDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema RuleDefinition
 */
export interface RuleDefinition {
    /**
     * Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
     *
     * @schema RuleDefinition#BucketKeyEnabled
     */
    readonly bucketKeyEnabled?: boolean;
    /**
     * @schema RuleDefinition#ApplyServerSideEncryptionByDefault
     */
    readonly applyServerSideEncryptionByDefault?: ApplyServerSideEncryptionByDefaultDefinition[];
}
/**
 * Converts an object of type 'RuleDefinition' to JSON representation.
 */
export declare function toJson_RuleDefinition(obj: RuleDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema RulesDefinition
 */
export interface RulesDefinition {
    /**
     * Unique identifier for the rule.
     *
     * Must be less than or equal to 255 characters in length.
     *
     * @schema RulesDefinition#Id
     */
    readonly id?: string;
    /**
     * Object keyname prefix identifying one or more objects to which the rule applies.
     *
     * Must be less than or equal to 1024 characters in length.
     *
     * @schema RulesDefinition#Prefix
     */
    readonly prefix?: string;
    /**
     * The priority associated with the rule.
     *
     * @schema RulesDefinition#Priority
     */
    readonly priority?: number;
    /**
     * The status of the rule.
     *
     * Either `Enabled` or `Disabled`. The rule is ignored if status is not Enabled.
     *
     * @schema RulesDefinition#Status
     */
    readonly status: string;
    /**
     * @schema RulesDefinition#Destination
     */
    readonly destination?: DestinationDefinition[];
    /**
     * @schema RulesDefinition#Filter
     */
    readonly filter?: FilterDefinition[];
    /**
     * @schema RulesDefinition#SourceSelectionCriteria
     */
    readonly sourceSelectionCriteria?: SourceSelectionCriteriaDefinition[];
}
/**
 * Converts an object of type 'RulesDefinition' to JSON representation.
 */
export declare function toJson_RulesDefinition(obj: RulesDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema ApplyServerSideEncryptionByDefaultDefinition
 */
export interface ApplyServerSideEncryptionByDefaultDefinition {
    /**
     * The AWS KMS master key ID used for the SSE-KMS encryption.
     *
     * This can only be used when you set the value of `sse_algorithm` as `aws:kms`. The default `aws/s3` AWS KMS master key is used if this element is absent while the `sse_algorithm` is `aws:kms`.
     *
     * @schema ApplyServerSideEncryptionByDefaultDefinition#KmsMasterKeyId
     */
    readonly kmsMasterKeyId?: string;
    /**
     * The server-side encryption algorithm to use.
     *
     * Valid values are `AES256` and `aws:kms`.
     *
     * @schema ApplyServerSideEncryptionByDefaultDefinition#SseAlgorithm
     */
    readonly sseAlgorithm: string;
}
/**
 * Converts an object of type 'ApplyServerSideEncryptionByDefaultDefinition' to JSON representation.
 */
export declare function toJson_ApplyServerSideEncryptionByDefaultDefinition(obj: ApplyServerSideEncryptionByDefaultDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema DestinationDefinition
 */
export interface DestinationDefinition {
    /**
     * The Account ID to use for overriding the object owner on replication.
     *
     * Must be used in conjunction with `access_control_translation` override configuration.
     *
     * @schema DestinationDefinition#AccountId
     */
    readonly accountId?: string;
    /**
     * The ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
     *
     * @schema DestinationDefinition#Bucket
     */
    readonly bucket: string;
    /**
     * Destination KMS encryption key ARN for SSE-KMS replication.
     *
     * Must be used in conjunction with
     * `sse_kms_encrypted_objects` source selection criteria.
     *
     * @schema DestinationDefinition#ReplicaKmsKeyId
     */
    readonly replicaKmsKeyId?: string;
    /**
     * The class of storage used to store the object.
     *
     * Can be `STANDARD`, `REDUCED_REDUNDANCY`, `STANDARD_IA`, `ONEZONE_IA`, `INTELLIGENT_TIERING`, `GLACIER`, or `DEEP_ARCHIVE`.
     *
     * @schema DestinationDefinition#StorageClass
     */
    readonly storageClass?: string;
    /**
     * @schema DestinationDefinition#AccessControlTranslation
     */
    readonly accessControlTranslation?: AccessControlTranslationDefinition[];
}
/**
 * Converts an object of type 'DestinationDefinition' to JSON representation.
 */
export declare function toJson_DestinationDefinition(obj: DestinationDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema FilterDefinition
 */
export interface FilterDefinition {
    /**
     * Object keyname prefix that identifies subset of objects to which the rule applies.
     *
     * Must be less than or equal to 1024 characters in length.
     *
     * @schema FilterDefinition#Prefix
     */
    readonly prefix?: string;
    /**
     * A map of tags that identifies subset of objects to which the rule applies.
     *
     * The rule applies only to objects having all the tags in its tagset.
     *
     * @schema FilterDefinition#Tags
     */
    readonly tags?: TagsDefinition3[];
}
/**
 * Converts an object of type 'FilterDefinition' to JSON representation.
 */
export declare function toJson_FilterDefinition(obj: FilterDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema SourceSelectionCriteriaDefinition
 */
export interface SourceSelectionCriteriaDefinition {
    /**
     * @schema SourceSelectionCriteriaDefinition#SseKmsEncryptedObjects
     */
    readonly sseKmsEncryptedObjects?: SseKmsEncryptedObjectsDefinition[];
}
/**
 * Converts an object of type 'SourceSelectionCriteriaDefinition' to JSON representation.
 */
export declare function toJson_SourceSelectionCriteriaDefinition(obj: SourceSelectionCriteriaDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema AccessControlTranslationDefinition
 */
export interface AccessControlTranslationDefinition {
    /**
     * The override value for the owner on replicated objects.
     *
     * Currently only `Destination` is supported.
     *
     * @schema AccessControlTranslationDefinition#Owner
     */
    readonly owner: string;
}
/**
 * Converts an object of type 'AccessControlTranslationDefinition' to JSON representation.
 */
export declare function toJson_AccessControlTranslationDefinition(obj: AccessControlTranslationDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema TagsDefinition3
 */
export interface TagsDefinition3 {
    /**
     * @schema TagsDefinition3#MapKey
     */
    readonly mapKey: string;
    /**
     * @schema TagsDefinition3#MapValue
     */
    readonly mapValue: string;
}
/**
 * Converts an object of type 'TagsDefinition3' to JSON representation.
 */
export declare function toJson_TagsDefinition3(obj: TagsDefinition3 | undefined): Record<string, any> | undefined;
/**
 * @schema SseKmsEncryptedObjectsDefinition
 */
export interface SseKmsEncryptedObjectsDefinition {
    /**
     * Boolean which indicates if this criteria is enabled.
     *
     * @schema SseKmsEncryptedObjectsDefinition#Enabled
     */
    readonly enabled: boolean;
}
/**
 * Converts an object of type 'SseKmsEncryptedObjectsDefinition' to JSON representation.
 */
export declare function toJson_SseKmsEncryptedObjectsDefinition(obj: SseKmsEncryptedObjectsDefinition | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `TF::AWS::S3Bucket`.
 *
 * @external
 * @cloudformationResource TF::AWS::S3Bucket
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
export declare class CfnS3bucket extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "TF::AWS::S3Bucket";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnS3bucketProps;
    /**
     * Attribute `TF::AWS::S3Bucket.tfcfnid`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrTfcfnid: string;
    /**
     * Attribute `TF::AWS::S3Bucket.BucketDomainName`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrBucketDomainName: string;
    /**
     * Attribute `TF::AWS::S3Bucket.BucketRegionalDomainName`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrBucketRegionalDomainName: string;
    /**
     * Attribute `TF::AWS::S3Bucket.Id`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrId: string;
    /**
     * Attribute `TF::AWS::S3Bucket.Region`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrRegion: string;
    /**
     * Create a new `TF::AWS::S3Bucket`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnS3bucketProps);
}
