__all__ = ["get_logo"]

from reportlab.graphics.shapes import Drawing, Path
from reportlab.lib.colors import Color

# The following paths were gotten from the `dk_logo.svg` file. As a convenience, it's possible to manually run this file
# to update the paths, in case the logo changes. Installing the `svglib` package is required for that.

shapes = [
    Path(fillOpacity=1.0, strokeColor=None, strokeOpacity=1.0, points=[37.3, 107.6, 37.9, 107.6, 38.4, 107.6, 38.9, 107.5, 36.699999999999996, 107.5, 34.4, 107.6, 32.0, 107.6, 37.3, 107.6], operators=[0, 2, 2, 1, 3], _fillRule=1),
    Path(fillOpacity=1.0, strokeColor=None, strokeOpacity=1.0, points=[37.3, 9.9, 32.0, 9.9, 34.4, 9.9, 36.7, 9.9, 38.9, 10.0, 38.3, 9.9, 37.8, 9.9, 37.3, 9.9], operators=[0, 1, 2, 2, 3], _fillRule=1),
    Path(fillColor=Color(.666667,.815686,.27451,1), fillOpacity=1.0, strokeColor=None, strokeOpacity=1.0, points=[85.6, 58.3, 85.6, 56.599999999999994, 85.5, 55.0, 85.3, 53.4, 84.7, 45.6, 82.8, 38.599999999999994, 79.39999999999999, 32.599999999999994, 76.0, 26.5, 71.5, 21.7, 65.9, 18.0, 64.7, 17.2, 63.60000000000001, 16.4, 62.300000000000004, 15.8, 59.6, 14.4, 56.800000000000004, 13.3, 53.800000000000004, 12.4, 11.7, 58.7, 53.900000000000006, 105.1, 56.800000000000004, 104.19999999999999, 59.7, 103.1, 62.400000000000006, 101.69999999999999, 63.300000000000004, 101.19999999999999, 64.2, 100.6, 65.10000000000001, 99.99999999999999, 71.10000000000001, 96.19999999999999, 76.00000000000001, 91.19999999999999, 79.50000000000001, 84.79999999999998, 83.10000000000001, 78.39999999999998, 85.00000000000001, 70.89999999999998, 85.40000000000002, 62.399999999999984, 85.50000000000001, 61.499999999999986, 85.50000000000001, 60.59999999999999, 85.50000000000001, 59.69999999999998, 85.50000000000001, 59.29999999999998, 85.60000000000001, 58.99999999999998, 85.60000000000001, 58.59999999999998, 85.60000000000001, 58.49999999999998, 85.60000000000001, 58.49999999999998, 85.60000000000001, 58.39999999999998, 85.5, 58.5, 85.6, 58.4, 85.6, 58.3], operators=[0, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3], _fillRule=1),
    Path(fillColor=Color(.023529,.627451,.290196,1), fillOpacity=1.0, strokeColor=None, strokeOpacity=1.0, points=[53.8, 12.3, 49.199999999999996, 10.9, 44.199999999999996, 10.100000000000001, 38.9, 9.9, 36.699999999999996, 9.9, 34.4, 9.8, 32.0, 9.8, 16.5, 9.8, 13.8, 9.8, 11.7, 12.0, 11.7, 14.600000000000001, 11.7, 44.400000000000006, 11.7, 58.7, 53.8, 12.3, 53.8, 12.3, 53.8, 12.3, 53.8, 12.3], operators=[0, 2, 2, 1, 2, 1, 1, 1, 2, 3], _fillRule=1),
    Path(fillColor=Color(.023529,.627451,.290196,1), fillOpacity=1.0, strokeColor=None, strokeOpacity=1.0, points=[11.7, 73.0, 11.7, 102.8, 11.7, 105.5, 13.899999999999999, 107.6, 16.5, 107.6, 32.0, 107.6, 34.4, 107.6, 36.7, 107.6, 38.9, 107.5, 44.199999999999996, 107.4, 49.2, 106.5, 53.8, 105.1, 53.8, 105.1, 53.8, 105.1, 53.8, 105.1, 11.7, 58.7, 11.7, 73.0], operators=[0, 1, 2, 1, 2, 2, 2, 1, 1, 3], _fillRule=1),
    Path(fillColor=Color(.666667,.815686,.27451,1), fillOpacity=1.0, strokeColor=None, strokeOpacity=1.0, points=[94.5, 9.9, 69.3, 9.9, 69.6, 10.1, 69.8, 10.3, 70.1, 10.6, 76.5, 15.0, 81.8, 20.6, 85.69999999999999, 27.700000000000003, 89.69999999999999, 34.900000000000006, 91.99999999999999, 43.2, 92.69999999999999, 52.5, 92.89999999999999, 54.4, 92.99999999999999, 56.4, 92.99999999999999, 58.4, 92.99999999999999, 58.5, 92.99999999999999, 58.6, 92.99999999999999, 58.699999999999996, 92.99999999999999, 58.8, 92.99999999999999, 58.8, 92.99999999999999, 58.9, 92.99999999999999, 59.3, 92.89999999999999, 59.699999999999996, 92.89999999999999, 60.199999999999996, 92.89999999999999, 61.3, 92.8, 62.3, 92.69999999999999, 63.4, 92.19999999999999, 73.5, 89.89999999999999, 82.4, 85.6, 90.1, 81.5, 97.5, 75.89999999999999, 103.3, 69.1, 107.69999999999999, 69.1, 107.69999999999999, 69.1, 107.79999999999998, 69.1, 107.79999999999998, 94.5, 107.79999999999998, 97.2, 107.79999999999998, 99.3, 105.59999999999998, 99.3, 102.99999999999999, 99.3, 14.999999999999986, 99.4, 12.1, 97.2, 9.9, 94.5, 9.9], operators=[0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 3], _fillRule=1),
    Path(fillColor=Color(.023529,.627451,.290196,1), fillOpacity=1.0, strokeColor=None, strokeOpacity=1.0, points=[132.0, 28.0, 156.1, 28.0, 173.7, 28.0, 183.9, 41.4, 183.9, 58.9, 183.9, 76.3, 173.6, 89.5, 156.1, 89.5, 132.0, 89.5, 132.0, 28.0, 156.1, 79.7, 167.29999999999998, 79.7, 173.0, 70.2, 173.0, 58.800000000000004, 173.0, 47.300000000000004, 167.3, 37.7, 156.1, 37.7, 142.9, 37.7, 142.9, 79.7, 156.1, 79.7], operators=[0, 1, 2, 2, 1, 1, 3, 0, 2, 2, 1, 1, 1, 3], _fillRule=1),
    Path(fillColor=Color(.023529,.627451,.290196,1), fillOpacity=1.0, strokeColor=None, strokeOpacity=1.0, points=[231.9, 47.8, 231.9, 89.5, 221.5, 89.5, 221.5, 83.9, 218.6, 88.4, 212.8, 90.4, 207.7, 90.4, 196.7, 90.4, 187.2, 81.9, 187.2, 68.60000000000001, 187.2, 55.20000000000001, 196.7, 46.900000000000006, 207.6, 46.900000000000006, 212.9, 46.900000000000006, 218.7, 49.00000000000001, 221.5, 53.300000000000004, 221.5, 47.800000000000004, 231.9, 47.800000000000004, 221.4, 68.5, 221.4, 61.2, 215.3, 56.5, 209.4, 56.5, 203.0, 56.5, 197.70000000000002, 61.5, 197.70000000000002, 68.5, 197.70000000000002, 75.5, 203.00000000000003, 80.6, 209.4, 80.6, 215.7, 80.6, 221.4, 75.8, 221.4, 68.5], operators=[0, 1, 1, 1, 2, 2, 2, 2, 1, 1, 3, 0, 2, 2, 2, 2, 3], _fillRule=1),
    Path(fillColor=Color(.023529,.627451,.290196,1), fillOpacity=1.0, strokeColor=None, strokeOpacity=1.0, points=[263.0, 56.1, 254.2, 56.1, 254.2, 89.5, 243.79999999999998, 89.5, 243.79999999999998, 56.1, 236.29999999999998, 56.1, 236.29999999999998, 47.8, 243.79999999999998, 47.8, 243.79999999999998, 32.5, 254.2, 32.5, 254.2, 47.9, 263.0, 47.9, 263.0, 56.1], operators=[0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3], _fillRule=1),
    Path(fillColor=Color(.023529,.627451,.290196,1), fillOpacity=1.0, strokeColor=None, strokeOpacity=1.0, points=[309.0, 47.8, 309.0, 89.5, 298.6, 89.5, 298.6, 83.9, 295.70000000000005, 88.4, 289.90000000000003, 90.4, 284.8, 90.4, 273.8, 90.4, 264.3, 81.9, 264.3, 68.60000000000001, 264.3, 55.20000000000001, 273.8, 46.900000000000006, 284.7, 46.900000000000006, 290.0, 46.900000000000006, 295.8, 49.00000000000001, 298.59999999999997, 53.300000000000004, 298.59999999999997, 47.800000000000004, 309.0, 47.800000000000004, 298.4, 68.5, 298.4, 61.2, 292.29999999999995, 56.5, 286.4, 56.5, 280.0, 56.5, 274.7, 61.5, 274.7, 68.5, 274.7, 75.5, 280.0, 80.6, 286.4, 80.6, 292.7, 80.6, 298.4, 75.8, 298.4, 68.5], operators=[0, 1, 1, 1, 2, 2, 2, 2, 1, 1, 3, 0, 2, 2, 2, 2, 3], _fillRule=1),
    Path(fillColor=Color(.023529,.627451,.290196,1), fillOpacity=1.0, strokeColor=None, strokeOpacity=1.0, points=[354.6, 89.5, 333.40000000000003, 66.1, 333.40000000000003, 89.5, 322.6, 89.5, 322.6, 28.0, 333.40000000000003, 28.0, 333.40000000000003, 51.3, 350.7, 28.0, 364.2, 28.0, 340.7, 58.6, 369.3, 89.5, 354.6, 89.5], operators=[0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3], _fillRule=1),
    Path(fillColor=Color(.023529,.627451,.290196,1), fillOpacity=1.0, strokeColor=None, strokeOpacity=1.0, points=[373.7, 33.1, 373.7, 29.400000000000002, 376.8, 26.8, 380.5, 26.8, 384.2, 26.8, 387.2, 29.5, 387.2, 33.1, 387.2, 36.7, 384.3, 39.4, 380.5, 39.4, 376.9, 39.4, 373.7, 36.6, 373.7, 33.1, 375.3, 47.8, 385.7, 47.8, 385.7, 89.5, 375.3, 89.5, 375.3, 47.8], operators=[0, 2, 2, 2, 2, 3, 0, 1, 1, 1, 1, 3], _fillRule=1),
    Path(fillColor=Color(.023529,.627451,.290196,1), fillOpacity=1.0, strokeColor=None, strokeOpacity=1.0, points=[417.4, 56.1, 408.59999999999997, 56.1, 408.59999999999997, 89.5, 398.2, 89.5, 398.2, 56.1, 390.7, 56.1, 390.7, 47.8, 398.2, 47.8, 398.2, 32.5, 408.59999999999997, 32.5, 408.59999999999997, 47.9, 417.4, 47.9, 417.4, 56.1], operators=[0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3], _fillRule=1),
    Path(fillColor=Color(.023529,.627451,.290196,1), fillOpacity=1.0, strokeColor=None, strokeOpacity=1.0, points=[417.6, 68.6, 417.6, 55.39999999999999, 428.20000000000005, 46.89999999999999, 440.3, 46.89999999999999, 447.5, 46.89999999999999, 453.40000000000003, 49.99999999999999, 457.3, 54.89999999999999, 449.90000000000003, 60.69999999999999, 447.8, 58.09999999999999, 444.20000000000005, 56.499999999999986, 440.50000000000006, 56.499999999999986, 433.30000000000007, 56.499999999999986, 428.1000000000001, 61.499999999999986, 428.1000000000001, 68.49999999999999, 428.1000000000001, 75.49999999999999, 433.30000000000007, 80.49999999999999, 440.50000000000006, 80.49999999999999, 444.20000000000005, 80.49999999999999, 447.70000000000005, 78.89999999999999, 449.90000000000003, 76.29999999999998, 457.3, 82.09999999999998, 453.5, 86.89999999999998, 447.6, 90.09999999999998, 440.3, 90.09999999999998, 428.3, 90.3, 417.6, 81.8, 417.6, 68.6], operators=[0, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 3], _fillRule=1),
    Path(fillColor=Color(.023529,.627451,.290196,1), fillOpacity=1.0, strokeColor=None, strokeOpacity=1.0, points=[500.7, 66.1, 500.7, 89.5, 490.3, 89.5, 490.3, 67.1, 490.3, 60.49999999999999, 486.3, 57.099999999999994, 481.6, 57.099999999999994, 476.90000000000003, 57.099999999999994, 471.0, 59.699999999999996, 471.0, 67.69999999999999, 471.0, 89.49999999999999, 460.6, 89.49999999999999, 460.6, 25.499999999999986, 471.0, 25.499999999999986, 471.0, 54.09999999999999, 473.1, 49.09999999999999, 479.7, 46.899999999999984, 483.9, 46.899999999999984, 494.8, 46.9, 500.7, 54.0, 500.7, 66.1], operators=[0, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 3], _fillRule=1),
    Path(fillColor=Color(.023529,.627451,.290196,1), fillOpacity=1.0, strokeColor=None, strokeOpacity=1.0, points=[547.5, 72.3, 515.3, 72.3, 516.5, 78.1, 520.9, 81.0, 527.0999999999999, 81.0, 531.6999999999999, 81.0, 535.8999999999999, 79.2, 538.3999999999999, 75.8, 545.2999999999998, 81.1, 541.4999999999999, 87.19999999999999, 534.0999999999998, 90.39999999999999, 526.5999999999998, 90.39999999999999, 514.0999999999998, 90.39999999999999, 504.5999999999998, 81.69999999999999, 504.5999999999998, 68.6, 504.5999999999998, 55.3, 514.5999999999998, 46.89999999999999, 526.4999999999998, 46.89999999999999, 538.4999999999998, 46.89999999999999, 547.7999999999997, 55.19999999999999, 547.7999999999997, 68.19999999999999, 547.8, 69.4, 547.7, 70.7, 547.5, 72.3, 537.4, 65.0, 536.8, 59.3, 532.4, 56.0, 526.6, 56.0, 521.0, 56.0, 516.5, 58.7, 515.3000000000001, 65.0, 537.4, 65.0], operators=[0, 1, 2, 2, 1, 2, 2, 2, 2, 2, 3, 0, 2, 2, 1, 3], _fillRule=1),
    Path(fillColor=Color(.023529,.627451,.290196,1), fillOpacity=1.0, strokeColor=None, strokeOpacity=1.0, points=[591.9, 66.1, 591.9, 89.5, 581.5, 89.5, 581.5, 67.1, 581.5, 60.49999999999999, 577.5, 57.099999999999994, 572.8, 57.099999999999994, 568.0999999999999, 57.099999999999994, 562.1999999999999, 59.699999999999996, 562.1999999999999, 67.69999999999999, 562.1999999999999, 89.49999999999999, 551.8, 89.49999999999999, 551.8, 47.8, 562.1999999999999, 47.8, 562.1999999999999, 54.4, 564.3, 49.199999999999996, 570.9, 46.9, 575.0999999999999, 46.9, 585.9, 46.9, 591.9, 54.0, 591.9, 66.1], operators=[0, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 3], _fillRule=1),
]


def get_logo(width):
    orig_width = 600
    orig_height = 110
    height = orig_height * width / orig_width
    logo = Drawing(width, height, *shapes)
    logo.translate(0, height)
    scale = width / orig_width
    logo.scale(scale, -scale)
    return logo


if __name__ == "__main__":

    from svglib.svglib import svg2rlg

    drawing = svg2rlg("./testgen/testgen/ui/assets/dk_logo.svg")

    def extract_shapes(drawing):
        if hasattr(drawing, "contents"):
            for content in drawing.contents:
                yield from extract_shapes(content)
        else:
            yield drawing

    print("shapes = [")
    for shape in extract_shapes(drawing):
        print(f"    {shape.__class__.__name__}(", end="")
        print(", ".join([f"{attr}={val!r}" for attr, val in shape.getProperties().items()]), end="")
        print("),")
    print("]\n")
