
************** File: testdoc.do.txt *****************
TITLE: A Document for Testing DocOnce
AUTHOR: Hans Petter Langtangen Email: hpl@simula.no at Center for Biomedical Computing, Simula Research Laboratory & Department of Informatics, University of Oslo
AUTHOR: Kaare Dump at Segfault, Cyberspace
AUTHOR: A. Dummy Author
AUTHOR: I. S. Overworked and Outburned at Inst1 & Inst2, Somewhere & Third Inst, Elsewhere & Fourth Inst
AUTHOR: J. Doe mail: j_doe@cyberspace.com
DATE: today

TOC: on

# #include "_testdoc.do.txt"

************** File: _testdoc.do.txt *****************

!split

<%doc>
This is Mako comment block
to test the use of Mako as preprocessor.
</%doc>


The format of this document is
% if FORMAT == 'html':
plain, homemade HTML (from DocOnce).
  % elif FORMAT == 'latex':
plain, homemade LaTeX (from DocOnce).
  % elif FORMAT == 'pdflatex':
plain, homemade pdfLaTeX (from DocOnce).
  %else:
${FORMAT}
% endif

% if SOMEVAR is not UNDEFINED:
# Just a comment
% endif

__Abstract.__
This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.

# Cannot demonstrate chapter headings since abstract and chapter
# are mutually exclusive in LaTeX

======= Section 1 =======
label{sec1}

Here is a nested list:

  * item1
  * item2
  * item3 which continues
    on the next line to test that feature
  * and a sublist
    * with indented subitem1
    * and a subitem2
  * and perhaps an ordered sublist
    o first item
    o second item,
      continuing on a new line

__Here is a list with paragraph heading.__

  * item1
  * item2

=== Here is a list with subsubsection heading ===

  * item1
  * item2

!bquote
Here are two lines that make up
a block quote for testing *emphasized words* and _boldface words_,
also with hypens:
*pre*-fix, post-*fix*, _pre_-fix, post-_fix_.
!equote

Here are two references. Equation~(ref{my:eq1}) is fine. Eq.~(ref{my:eq1}) too.
Even Equation (ref{my:eq1}) without the tilde.
# #if FORMAT in ("sphinx", "html")
This equation appears in another part if this document is split.
# #endif

# #if FORMAT == 'html'
Let us add a paragraph to
test that HTML,
with WordPress
(`--wordpress` option)
can handle linebreaks
*correctly*,
even when lines begin with
_bold words_ and
`verbatim words` in
color{red}{red color}, and
"links": "https://google.com" as well as math:
$1+1=2$.

Test also that *emphasize*
at the end of line, and _bold_
works, as well as color{blue}{color}
and "links2": "https://google.com"
and `verbatim`
as well.
# #endif

===== Subsection 1 =====
label{subsec1}

idx{`somefunc` function}

# Refer to section/appendix etc. at the beginning of the line
# and other special fix situations for HTML.

More text, with a reference back to
Section ref{sec1} and ref{subsec1}, and further to the
sections    ref{subsec1} and ref{subsubsec:ex}, which
encourages you to do the tasks in the
Exercises ref{demo:ex:1} and ref{exer:some:formula}.
Appendices     ref{app1} and ref{app2} are also nice elements.

=== Test Section reference at beginning of line and after a sentence ===

Section ref{subsec1} is fine.
Section ref{subsubsec:ex} too.


# sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console

=== Computer code ===

Let's do some copying from files too. First from subroutine up to the very end,

@@@CODE ../doc/src/manual/__testcode.f fromto: subroutine@
and then just the subroutine,
@@@CODE ../doc/src/manual/__testcode.f from-to:a comment@^C\s+END1
and finally the complete file with a plain text verbatim environment
(`envir=ccq`):
@@@CODE ../doc/src/manual/__testcode.f envir=ccq

Testing other code environments. First Python:

!bc
|bc pycod
def f(x):
    return x+1
|ec
!ec
which gets rendered as

!bc pycod-t
def f(x):
    return x+1
!ec

# #if FORMAT not in ("rst", "plain", "epytext", "st")
Test paragraph and subsubsection headings before
before code.

__Paragraph heading before code.__

!bc pycod-t
import sys
sys.path.insert(0, os.pardir)
!ec

=== Subsubsection heading before code ===

!bc pycod-t
def h(z):
    return z+1
!ec
# #endif

# #if FORMAT in ("sphinx", "html", "latex", "pdflatex")
Now a complete program to be shown via Python Online Tutorial:
# #else
Here is a program that is supposed to be interactive via
Python Online Tutorial, but that service is not accessible
for the present format.
# #endif

!bc pyoptpro
class Line:
    def __init__(self, a, b):
        self.a, self.b = a, b

    def __call__(self, x):
        a, b = self.a, self.b
        return a*x + b

line = Line(2, 1)
y = line(x=3)
print(y)
!ec

# #if FORMAT == "sphinx"
Another complete program to be typeset as a sage cell:
# #else
Some more Python code (actually specified as a sage cell, but
such cells are not supported by this format).
# #endif

!bc pyscpro
a = 2
b = 3
print('a+b:', a + b)

# In a sage cell we can also plot
from matplotlib.pyplot import *
from numpy import *
x = linspace(0, 4*pi, 101)
y = exp(-0.1*x)*cos(x)
plot(x, y)
xlabel('x'); ylabel('y')
show()
!ec

## Should also test that one can read .pyopt and .pysc programs

Then Cython (with -h option so it is hidden in html/sphinx):

!bc cycod-h
cpdef f(double x):
    return x + 1
!ec

Standard Python shell sessions:

!bc pyshell
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
!ec

Similar IPython sessions:

!bc ipy
In [1]: from numpy import linspace, sin
In [2]: # Some comment
In [3]: x = linspace(0, 2, 11)
In [4]: y = sin(x)
In [5]: y[0]
Out[5]: 0
In [6]: import matplotlib.pyplot as plt
In [7]: plt.plot(x, y)
In [8]: a='multiple-\nline\noutput'
In [9]: a
Out[9]: 'multiple-\nline\noutput'
In [10]: print(a)
multiple-
line
output
!ec

Here is the interactive session again, but with `pyshell-t`.
% if FORMAT == 'ipynb':
This makes a significant difference in the Jupyter Notebook, but
not in other formats: code is not typset in cells, but printed
verbatim in plain text (`-t` for text).
% endif

!bc pyshell-t
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
!ec

# This one tests a + sign before a code environment
C++:
!bc cpppro-t
#include <iostream>

int main()
{
   std::cout << "Sample output" << std::endl;
   return 0
}
!ec
# The next should get correctly typset in sphinx (cod is fcod)
# It also tests emoji before code
And a little bit of Fortran: :dizzy_face:

!bc
|bc cod
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
|ec
!ec
which then is typeset as

!bc cod-t
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
!ec

HTML:

!bc htmlcod
<table>
<tr><td>Column 1</td><td>Column 2</td></tr>
<tr><td>0.67526 </td><td>0.92871 </td></tr>
<!-- comment -->
</table>
!ec

But inline HTML code is also important, like text that starts with
`<a href="` (which can destroy the following text if not properly
quoted).

Matlab with comments requires special typesetting:

!bc mcod
%% Comment on the beginning of the line can be escaped by %%
if a > b
  ${'%'} Indented comment needs this trick
  c = a + b
end
!ec

And here is a system call:

!bc sys-t
Terminal> mkdir test
Terminal> cd test
Terminal> myprog -f
output1
output2
!ec

Any valid pygments lexer/language name can appear to, e.g.,

!bc
|bc restructuredtext
=======
Heading
=======

Some text.
|ec
!ec
results in

!bc restructuredtext
=======
Heading
=======

Some text.
!ec

# Here goes hidden code.
# Python can be treated by some formats, Fortran is always out.

!bc pyhid
def f(x):
    """Secret, hidden function to be defined."""
    return 42
!ec

!bc fhid
       subroutine helper1(x)
       real*8 x
       x = 42
       return

       subroutine helper2(x)
       real*8 x
       x = 43
       return
!ec

Finally, `!bc do` supports highlighting of DocOnce source:

!bc do
======= DocOnce test file =======

===== Computer code =====

Inline verbatim code, as in `import numpy as np`, is allowed, as well as
code blocks:

|bc pycod
from math import sin

def f(x):
    """Example on a function."""
    return sin(x) + 1

print(f(0))
|ec


===== Mathematics =====

Formulas can be inline, as in $\nabla\cdot\bm{u} = 0$, or typeset
as equations:

|bt
\begin{align*}
\nabla\cdot\bm{u} &= 0,\\
\bm{u} &= \nabla\phi .
\end{align*}
|et

=== Subsubsection heading ===

DocOnce files can have chapters, sections, subsections, and subsubsections.

__Paragraph heading.__ Paragraphs may have headings.
!ec

It is time to test `verbatim inline font` especially with `a newline
inside the text` and an exclamation mark at the end: `BEGIN`! For
spellcheck, test `a verbatim expression` in `another` in a `third`.
Also test exclamation mark as in `!bc` and `!ec` as well as `a != b`.
Also test backslashes and braces like `\begin`, `\begin{enumerate}`,
`\end{this}\end{that}`, and `{something \inside braces}`.

# #if FORMAT not in ("latex", "pdflatex", "html")
The following attempt to exemplify colored text does not work in
format ${FORMAT}.
# #endif
Here is some color{red}{red color} and an attempt to write color{green}{with
green color containing a linebreak<linebreak>
code.} Some formats will only display <linebreak>
this correctly when `html` <linebreak>
is the output format.
But here some more running text is added which is not part of
the previous blocks with line breaks.

=== Running OS commands ===

@@@OSCMD python -c 'print("Testing\noutput\nfrom\nPython.")'

=== Footnotes ===

Here is a test of footnotes [^footnote], which are handy in text.
They are used in different flavors, now in

 * list items (note below that footnotes work after math, verbatim, and URLs - bin fact old and emphasize too!)
 * even with math $\nabla^2u$[^math1]
 * and code `h[i] += 1`[^code]
   (*must* have space between inline code and footnote!)
 * and "links": "https://google.com"[^google-search]

which gives flexibility in writing.
This is the third[^example-of-the-third-footnote] example.

  [^footnote]: Typesetting of the footnote depends on the format.
Plain text does nothing, LaTeX removes the
definition and inserts the footnote as part of the LaTeX text.
reStructuredText and Sphinx employ a similar type of typesetting
as Extended Markdown and DocOnce, and in HTML we keep the same
syntax, just displayed properly in HTML.
[^math1]: Math footnotes can be dangerous since it
interferes with an exponent.
[^code]: One-line footnote.

[^google-search]: URL: "google.com" is perhaps the most famous
web site today.

Here is some more text before a new definition of a footnote that was
used above.

!bnotice Non-breaking space character
This paragraph aims to test "non-breaking space character":
"https://en.wikipedia.org/wiki/Non-breaking_space", and a typical
example where this is needed is in physical units: 7.4~km is traveled
in~$7.4/5.5\approx 1.345$~s.  Also check that a~"link": "https://google.com"~is
not broken across lines (drag the browser window to test this).
(On the other hand, the tilde is used in
computer code, e.g., as in `[~x for x in y]` or in `y=~x`, and should
of course remain a tilde in those contexts.)
!enotice

===== Subsection 2: Testing figures =====
label{subsec:ex}
idx{figures}

Test of figures. In particular we refer to Figure ref{fig:impact} in which
there is a flow.

FIGURE:[../doc/src/manual/fig/wave1D, width=200] Visualization _of_ a *wave*. label{fig:impact}

Figures without captions are allowed and will be inlined.

FIGURE:[../doc/src/manual/fig/wave1D, width=200]

idx{movies}


# Test multi-line caption in figure with sidecap=True

Here is figure ref{myfig} with a long (illegal) multi-line caption
containing inline verbatim text:

FIGURE: [../doc/src/manual/fig/wave1D.png, width=500 sidecap=True] A long
caption spanning
several lines and containing verbatim words like `my_file_v1` and `my_file_v2`
as well as math with subscript as in $t_{i+1}$. label{myfig}

# Must be a blank line after MOVIE or FIGURE to detect this problem

Test URL as figure name:

FIGURE: [https://raw.github.com/doconce/doconce/master/doc/src/blog/f_plot.png, width=500 frac=0.8]

# #if FORMAT in ("html", "sphinx")
Test SVG figure:

FIGURE: [https://openclipart.org/people/jpneok/junebug.svg, width=200]
# #endif

# Test wikimedia type of files that otherwise reside in subdirs
# #if FORMAT == "mwiki"
FIGURE: [testfigs/df_plot.png, width=800] This is a wikimedia figure file.

# Non-uploaded file with no caption
FIGURE: [testfigs/df2s8765s_plot.png, width=200, frac=0.4]
# #endif

# #if FORMAT == 'html'
HTML output may feature Bokeh plots:

FIGURE: [bokeh_test]
# #endif

__Remark.__
Movies are tested in separate file `movies.do.txt`.


# Somewhat challenging heading with latex math, \t, \n, ? and parenthesis

===== The $\theta$ parameter (not $\nabla$?) =====
label{decay:sec:theta}

Functions do not always need to be advanced, here is one
involving $\theta$:
!bc
def f(theta):
    return theta**2
!ec

__More on $\theta$.__ Here is more text following headline with math.

Newcommands must also be tested in this \report:
$\half$, $\halfi$, $\x$, $\Ddt{u}$,
both inline and in block:

!bt
\begin{align}
\Ddt{u} &= 0\nonumber
\\
\half &= \halfi\\
\half\x &= \normalvec
\end{align}
!et

Or with align with label and numbers:

!bt
\begin{align}
\Ddt{u} &= 0
label{aligneq1}
\\
\half &= \halfi\\
\half\x &= \normalvec

label{aligneq2}
\end{align}
!et

% if FORMAT == "sphinx":
Sphinx makes a fix here and splits align into multiple equation
environments.
% endif
% if FORMAT == "mwiki":
The labels above are removed in mwiki since mwiki cannot refer to
labels in equations.
% endif

% if FORMAT not in ("sphinx", "pandoc", "ipynb"):
# Must test more complicated align and matrix compositions
# where DocOnce inserts auto-numbered labels etc.

First one numbered (automatically):

!bt
\begin{align}
\begin{pmatrix}
G_2 + G_3 & -G_3 & -G_2 & 0 \\
-G_3 & G_3 + G_4 & 0 & -G_4 \\
-G_2 & 0 & G_1 + G_2 & 0 \\
0 & -G_4 & 0 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\
 v_2 \\
 v_3 \\
 v_4
\end{pmatrix}
+ \cdots \\
\begin{pmatrix}
 C_5 + C_6 & -C_6 & 0 & 0 \\
 -C_6 & C_6 & 0 & 0 \\
 0 & 0 & 0 & 0 \\
 0 & 0 & 0 & 0
\end{pmatrix}
  &= \frac{d}{dt}\begin{pmatrix}
 v_1 \\
 v_2 \\
 v_3 \\
 v_4
\end{pmatrix} +
\begin{pmatrix}
 0 \\
 0 \\
 0 \\
 -i_0
\end{pmatrix}
\nonumber
\end{align}
!et

Second numbered (automatically):

!bt
\begin{align}
\begin{pmatrix}
G_1 + G_2\\
-G_3 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\
 v_2
\end{pmatrix}
+ \cdots\nonumber
\\
\left(\begin{array}{ll}
y & 2\\
2 & 1
\end{array}\right)
\left(\begin{array}{ll}
0 \\ x
\end{array}\right)
&= \begin{pmatrix}
A \\ B
\end{pmatrix}
\end{align}
!et

Both numbered, with label by the user:

!bt
\begin{align}
\begin{pmatrix}
G_1 + G_2\\
-G_3 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\
 v_2
\end{pmatrix}
+ \cdots label{mymatrix:eq1}
\\
label{mymatrix:eq2}
\left(\begin{array}{ll}
y & 2\\
2 & 1
\end{array}\right)
\left(\begin{array}{ll}
0 \\ x
\end{array}\right)
&= \begin{pmatrix}
A \\ B
\end{pmatrix}
\end{align}
!et
Now we refer to (ref{mymatrix:eq1})-(ref{mymatrix:eq2}).
% endif

===== Custom Environments =====

Here is an attempt to create a theorem environment via Mako
(for counting theorems) and comment lines to help replacing lines in
the `.tex` by proper begin-end LaTeX environments for theorems.
Should look nice in most formats!

<%
theorem_counter = 4
%>

# begin theorem
label{theorem:fundamental1}
<%
theorem_counter += 1
theorem_fundamental1 = theorem_counter
%>

__Theorem ${theorem_counter}.__
Let $a=1$ and $b=2$. Then $c=3$.
# end theorem

# begin proof
__Proof.__
Since $c=a+b$, the result follows from straightforward addition.
$\Diamond$|$END$
# end proof

As we see, the proof of Theorem ${theorem_counter} is a modest
achievement.


===== Tables =====
label{subsec:table}

idx{test index with `verbatim text` which is possible}
idx{test `two` (separate) `verbatim expressions` which is also possible}
idx{index with!subindex}
idx{_boldface word_ in index}
idx{index with _boldface word_}
idx{index with!_boldface word_ in subentry}
idx{double _boldface word_!_boldface word_ in subentry too}

# index with comma could fool sphinx
idx{index, with comma, and one more}

Let us take this table from the manual:

% if FORMAT in ("latex", "pdflatex"):
\begin{table}
\caption{
Testing table environment in LaTeX, enabled by testing on the "latex" format
with the preprocessor.
label{mytab}
}

% endif

  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

% if FORMAT in ("latex", "pdflatex"):
\end{table}
% endif

The DocOnce source code reads
!bc ccq

  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

!ec

Here is yet another table to test that we can handle more than
one table:

  |--l-------l----------l----------|
  |time  | velocity | acceleration |
  |--l-------l----------l----------|
  | 0.0  | 1.4186   | -5.01        |
  | 1.0  | 1.376512 | 11.919       |
  | 3.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

And one with math headings (that are expanded and must be treated
accordingly), verbatim heading and entry, and no space around the pipe
symbol:

|--------------------------|
|$i$|$h_i$|$\bar T_i$|`L_i`|
|-l-----r-------r----r-----|
|0   |0     |288   |-0.0065|
|1   |11,000|216   |0.0	   |
|2   |20,000|216   |0.001  |
|3   |32,000|228   |0.0028 |
|4   |47,000|270   |0.0	   |
|5   |51,000|270   |-0.0028|
|6   |71,000|214   |`NaN`  |
|--------------------------|

And add one with verbatim headings (with underscores),
and rows starting with `|-` because of a negative number,
and `|` right before and after verbatim word (with no space):
## +`v_2` does not work, need space + `v_2`

|-----------------------------------------|
| exact | `v_1`   |$a_i$ + `v_2`|`verb_3_`|
|---r--------r---------r-----------r------|
|9      | 9.62    | 5.57      |  8.98     |
|-20    | -23.39  | -7.65     | -19.93    |
|10     | 17.74   | -4.50     |  9.96     |
|0      | -9.19   | 4.13      | -0.26     |
|-----------------------------------------|

Pipe symbols in verbatim and math text in tables used to pose difficulties,
but not
# #if FORMAT in ('plain', 'matlabnb')
anymore (except for plain text and matlabnb).
# #else
anymore:

|-----------------------------|
| $S$         | command       |
|-----l---------------r-------|
| $||a_0||$   | `norm|length` |
| $x\cap y$   | `x|y`         |
|-----------------------------|

# #endif

Here is a table with X alignment:

|---------------------|
| Type | Description  |
|--c---------X--------|
| X    | Alignment character that is used for specifying a potentially very long text in a column in a table. It makes use of the `tabularx` package in LaTeX, otherwise (for other formats) it means `l` (centered alignment). |
| l,r,c | standard alignment characters |
|---------------------|

Finally, a table with math
# #if FORMAT in ("rst", "html", "sphinx", "pandoc")
(`bm` that expands to `boldsymbol`, was tricky, but
cleanly handled now)
# #endif
and URLs.

# Mako code to expand URLs in the table
# (These types of tables did not work before Jan 2014)
<%
def tfig(fileno):
    p = '../doc/src/manual/mov/wave_frames/frame_0' + fileno + '.png'  # path
    if FORMAT in ("latex", "pdflatex"):
        text = r'\includegraphics[width=2cm]{%s}' % p
    elif FORMAT == "html":
        text = '<a href="%s"><img src="%s" width="300"></a>' % (p, p)
    else:
        text = '"`%s`": "%s"' % (fileno, p)  # plain link
    return text
%>

|-----------------------------------------------------------|
|                         |                |                |
|--------------c------------------c----------------c--------|
| $\mathcal{L}=0$         | ${tfig('080')} | ${tfig('085')} |
| $a=b$                   | ${tfig('090')} | ${tfig('095')} |
| $\nabla\cdot\bm{u} =0 $ | ${tfig('100')} | ${tfig('105')} |
|-----------------------------------------------------------|


===== A test of verbatim words in heading with subscript $a_i$: `my_file_v1` and `my_file_v2` =====

__Paragraph with verbatim and math: `my_file_v1.py` and `my_file_v2.py` define some math $a_{i-1}$.__ Here is more `__verbatim__` code and
some plain text on a new line.

# Test various types of headlines
% for heading in ('_Just bold_', '*Just emphasize*', '`Just verbatim`', '_Bold_ beginning', '*Emphasize* beginning', '`Verbatim` beginning', 'Maybe _bold end_', 'Maybe *emphasize end*', 'Maybe `verbatim end`', 'The middle has _bold_ word', 'The middle has *emphasize* word', 'The middle has `verbatim` word'):
===== ${heading} =====

Some text.

% endfor
% for heading in ('*Just emphasize*', '`Just verbatim`', '*Emphasize* beginning', '`Verbatim beginning`', 'Maybe *emphasize end*', 'Maybe `verbatim end`', 'The middle has *emphasize* word', 'The middle has `verbatim` word'):

__${heading}.__ Some text.

% endfor

__Ampersand.__
We can test Hennes & Mauritz, often abbreviated H & M, but written
as `Hennes & Mauritz` and `H & M`.
A sole `&` must also work.
# Note: substitutions must not occur inside verbatim, just in ordinary text.

!bc
# Just to check that ampersand works in code blocks:
c = a & b
!ec

__Quotes.__
Let us also add a test of quotes such as ``double quotes, with numbers
like 3.14 and newline/comma and hyphen (as in double-quote)''; written
in the standard LaTeX-style that gives correct LaTeX formatting and
ordinary double quotes for all non-LaTeX formats.  Here is another
sentence that ``caused'' a bug in the past because double backtick
quotes could imply verbatim text up to a verbatim word starting with
period, like `.txt`.

More quotes to be tested for spellcheck:
(``with parenthesis''), ``with newline''
and ``with comma'', ``hyphen''-wise, and ``period''.


===== Bibliography test =====

Here is an example: cite{Langtangen_Pedersen_2002} discussed propagation of
large destructive water waves, cite{Langtangen_et_al_2002} gave
an overview of numerical methods for solving the Navier--Stokes equations,
while the use of Backward Kolmogorov equations for analyzing
random vibrations was investigated in cite{Langtangen_1994a}.
The book chapter cite{Mardal_et_al_2003a} contains information on
C++ software tools for programming multigrid methods. A real retro
reference is cite{Langtangen_1988d} about a big FORTRAN package.
Multiple references are also possible, e.g., see
cite{Langtangen_Pedersen_2002,Mardal_et_al_2003a}.

We need to cite more than 10 papers to reproduce an old formatting
problem with blanks in the keys in reST format:
cite{Langtangen_1992c,Langtangen_1994a,Mortensen_et_al_2011,Langtangen_Pedersen_2002}
and
cite{Langtangen_et_al_2002,Glimsdal_et_al_20006,Rahman_et_al_2006b,Haga_et_al_2011a,Langtangen_2003a,Langtangen_2008a,Langtangen:95}
and all the work of
cite{Langtangen_2012,Mardal_et_al_2003a,Jeberg_et_al_2004} as well as
old work cite{Langtangen_1988d} and cite{Langtangen_1989e}, and the
talk cite{Langtangen_talk_2007a}.
Langtangen also had two thesis cite{Langtangen:85,Langtangen_1989e}
back in the days.
More retro citations are
the old ME-IN323 book cite{Langtangen:91} and the
cite{Langtangen:94b} OONSKI '94 paper.


===== Example: Examples can be typeset as exercises =====
label{Example}

Examples can start with a subsection heading starting with `Example:`
and then, with the command-line option `--examples_as_exercises` be
typeset as exercises. This is useful if one has solution
environments as part of the example.


!bsubex
State some problem.

!bsol
The answer to this subproblem can be written here.
!esol
!esubex

!bsubex
State some other problem.

!bhint
A hint can be given.
!ehint

!bhint
Maybe even another hint?
!ehint

!bsol
The answer to this other subproblem goes here,
maybe over multiple doconce input lines.
!esol
!esubex

===== User-defined environments =====

<%
def refex(label, capital=False):
    if FORMAT in ('latex', 'pdflatex'):
        return 'Example ref{%s}' % label
    else:
        s = 'The ' if capital else 'the '
        s += 'example in Section ref{%s}' % label
        return s
%>

${refex('ex:test:1p1', capital=True)} demonstrates how to write a test function.
That is, a special test function for a function `add` appears in
${refex('ex:test:1p1')}.

!bu-example A test function label=ex:test:1p1
Suppose we want to write a test function for checking the
implementation of a Python function for addition.

!bc pycod
def add(a, b):
    return a + b

def test_add():
    a = 1; b = 1
    expected = a + b
    computed = add(a, b)
    assert expected == computed
!ec
!eu-example

!bu-example Addition label=ex:math:1p1
We have

!bt
\[ 1 + 1 = 2 \]
!et
or in tabular form:

|-------------------|
| Problem | Result  |
|----c--------c-----|
| $1+1$   |  $2$    |
|-------------------|

!eu-example

!bu-highlight Highlight box!
This environment is used to highlight something:

!bt
\[ E = mc^2 \]
!et
!eu-highlight


===== URLs =====
label{subsubsec:ex}

Testing of URLs: hpl's home page "hpl":"https://folk.uio.no/hpl", or
the entire URL if desired, "URL": "https://folk.uio.no/hpl".  Here is a
plain file link "URL": "testdoc.do.txt", or "url":"testdoc.do.txt", or
URL: "testdoc.do.txt" or url : "testdoc.do.txt" or "a link with
newline": "testdoc.do.txt". Can test spaces with the link with word
too: "hpl": "https://folk.uio.no/hpl" or "hpl" :
"https://folk.uio.no/hpl". Also `file:///` works: "link to a
file":"file:///home/hpl/vc/doconce/doc/demos/manual/manual.html" is
fine to have. Moreover, ``loose'' URLs work, i.e., no quotes, just
the plain URL as in https://folk.uio.no/hpl, if followed by space, comma,
colon, semi-colon, question mark, exclamation mark, but not a period
(which gets confused with the periods inside the URL).

Mail addresses can also be used: "`hpl@simula.no`": "mailto:hpl@simula.no", or just a "mail link": "mailto:hpl@simula.no", or a raw URL: "mailto:hpl@simula.no".

Here are some tough tests of URLs, especially for the `latex` format:
"Newton-Cotes":
"https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas" formulas
and a "good book":
"https://www.springer.com/mathematics/computational+science+%26+engineering/book/978-3-642-23098-1". Need to test
Newton-Cotes with percentage in URL too:
URL: "https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas"
and URL: "https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae" which has a shebang.

For the `--device=paper` option it is important to test that URLs with
monospace font link text get a footnote
(unless the `--latex_no_program_footnotelink`
is used), as in this reference to
"`decay_mod`":
"https://github.com/hplgit/INF5620/tree/gh-pages/src/decay/experiments/decay_mod.py", "`ball1.py`": "https://tinyurl.com/pwyasaa/formulas.ball1.py",
and "`ball2.py`": "https://tinyurl.com/pwyasaa/formulas.ball2.py".


# Comments should be inserted outside paragraphs (because in the rst
# format extra blanks make a paragraph break).

# Note that when there is no https: or file:, it can be a file link
# if the link name is URL, url, "URL", or "url". Such files should,
# if rst output is desired, but placed in a `_static*` folder.

More tough tests: repeated URLs whose footnotes when using the
`--device=paper` option must be correct. We have
"google": "https://google.com", "google": "https://google.com", and
"google": "https://google.com", which should result in exactly three
footnotes.


% if FORMAT in ("latex", "pdflatex"):

===== Test of Some LaTeX Fixes =====

Let's check abbr. of some common kind, e.g. the well-known i.e.
expression as an example, and 1 vs.  2 which is also often used.
Dr. Tang and Prof. Monsen, or maybe also prof.  Ting,
will go to the Dept. of Science to test how Mr.    Hansen is doing together
with Ms. Larsen. A reference like Sec. ref{subsubsec:ex} or
Ch. ref{subsubsec:ex}, or even App. ref{subsubsec:ex}, must also be
handled. Likewise, this is test no. $i$ of DocOnce features.
Also, look at Fig. 4 to see how the data compares with Tab. ref{mytab}.
Percentage must be fixed: 7%,  87.65% and
50% at the beginning of the line.

% endif

!split and check if these extra words are included properly in the comment

======= LaTeX Mathematics =======

Here is an equation without label using backslash-bracket environment:
!bt
\[ a = b + c \]
!et

or with number and label, as in (ref{my:eq1}), using the equation environment:

!bt
\begin{equation}
{\partial u\over\partial t} = \nabla^2 u label{my:eq1}
\end{equation}
!et

We can refer to this equation by (ref{my:eq1}).

Here is a system without equation numbers, using the align-asterisk environment:

!bt
\begin{align*}
\pmb{a} &= \pmb{q}\times\pmb{n} \\
b &= \nabla^2 u + \nabla^4 v
\end{align*}
!et


% if FORMAT in ('latex', 'pdflatex', 'sphinx', 'html', 'pandoc'):
And here is a system of equations with labels in an align environment:

!bt
\begin{align}
a &= q + 4 + 5+ 6 label{eq1} \\
b &= \nabla^2 u + \nabla^4 x label{eq2}
\end{align}

!et
We can refer to (ref{eq1})-(ref{eq2}). They are a bit simpler than
the Navier--Stokes equations. And test LaTeX hyphen in `CG-2`.
Also test $a_{i-j}$ as well as $kx-wt$.

Testing `alignat` environment:

!bt
\begin{alignat}{2}
a &= q + 4 + 5+ 6\qquad & \mbox{for } q\geq 0 label{eq1a} \\
b &= \nabla^2 u + \nabla^4 x & x\in\Omega label{eq2a}
\end{alignat}
!et

% if FORMAT in ("latex", "pdflatex"):
Many of the next environments will fail in non-latex formats.
Testing multiline:

!bt
\begin{multline}
a = b = q + \\
  f + \nabla\cdot\nabla u
label{multiline:eq1}
\end{multline}
!et

Testing split:

!bt
\begin{equation}
label{split:envir:eq}
\begin{split}
a = b = q &+ \\
  & f + \nabla\cdot\nabla u
\end{split}
\end{equation}
!et
We can refer to the last equation by (ref{split:envir:eq}).

Testing gather:
!bt
\begin{gather}
a = b \\
c = d + 7 + 9
\end{gather}
!et

Let us refer to (ref{eq1})-(ref{eq2}) again, and to the
alignat variant (ref{eq1a})-(ref{eq2a}), and to (ref{my:eq1}).

Testing eqnarray:
!bt
\begin{eqnarray}
{\partial u\over\partial t} &=& \nabla^2 u + f, label{myeq1}\\
{\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g label{myeq2}
\end{eqnarray}
!et
% endif
% endif

More mathematical typesetting is demonstrated in the coming exercises.

Below, we have Problem ref{demo:ex:1} and Project ref{demo:ex:2},
as well as Projects ref{proj:circle1} and ref{exer:you}, and in
between there we have Exercise ref{exer:some:formula}.


======= Exercises =======

===== Problem: Flip a Coin =====
label{demo:ex:1}
files = flip_coin.py, flip_coin.pdf
solutions = mysol.txt, mysol_flip_coin.py
keywords = random numbers; Monte Carlo simulation; ipynb

# Torture tests
file=myfile_should_be_a_part_of_the_text
solutions = mysol.txt, mysol_flip_coin.py, yet_another.file

!bsubex
Make a program that simulates flipping a coin $N$ times.
Print out ``tail'' or ``head'' for each flip and
let the program count the number of heads.

!bhint
Use `r = random.random()` and define head as `r <= 0.5`.
!ehint

!bhint
Draw an integer among $\{1,2\}$ with
`r = random.randint(1,2)` and define head when `r` is 1.
!ehint

!bans
If the `random.random()` function returns a number $<1/2$, let it be
head, otherwise tail. Repeat this $N$ number of times.
!eans

!bsol
!bc pycod
import sys, random
N = int(sys.argv[1])
heads = 0
for i in range(N):
    r = random.random()
    if r <= 0.5:
        heads += 1
print('Flipping a coin %d times gave %d heads' % (N, heads))
!ec
!esol
!esubex

!bsubex
Vectorize the code in a) using boolean indexing.
!esubex

Vectorized code can be written in many ways.
Sometimes the code is less intuitive, sometimes not.
## Need a ref from this exer to the rest of the document
## when we run doconce extract_exercises and get this exercises
## out in its own document.
At least there is not much to find in Section ref{sec1}.

!bsubex
Vectorize the code in a) using `numpy.sum`.


!bans
`np.sum(np.where(r <= 0.5, 1, 0))` or `np.sum(r <= 0.5)`.
!eans
!esubex

In this latter subexercise, we have an
example where the code is easy to read.

!bremarks
These are the exercise remarks, appearing at the very end.
!eremarks

=== My remarks ===

Remarks with such a subsubsection is treated as more text
after the last subexercise. Test a list too:

 o Mark 1.
 o Mark 2.

===== Not an exercise =====

Should be possible to stick a normal section in the middle of many
exercises.

===== Exercise: Test of plain text exercise =====
label{my:exer1}
file=myexer1

Very short exercise. What is the capital
of Norway?

===== Project: Compute a Probability =====

# Minimalistic exercise

label{demo:ex:2}

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval $[0,1)$?

!bhint
To answer this question empirically, let a program
draw $N$ such random numbers using Python's standard `random` module,
count how many of them, $M$, that fall in the interval $(0.5,0.6)$, and
compute the probability as $M/N$.
!ehint

At the end we have a list because that caused problems in LaTeX
in previous DocOnce versions:

 o item1
 o item2

===== Project: Explore Distributions of Random Circles =====

label{proj:circle1}
file=circles
kw=ipynb

The formula for a circle is given by

!bt
\begin{align}
x &= x_0 + R\cos 2\pi t,
label{circle:x}\\
y &= y_0 + R\sin 2\pi t,
label{circle:y}
\end{align}
!et
where $R$ is the radius of the circle, $(x_0,y_0)$ is the
center point, and $t$ is a parameter in the unit interval $[0,1]$.
For any $t$, $(x,y)$ computed from (ref{circle:x})-(ref{circle:y})
is a point on the circle.
The formula can be used to generate `n` points on a circle:

!bc pypro
import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y

x, y = circle(2.0, 0, 0)
!ec

# Often in an exercise we have some comments about the solution
# which we normally want to keep where they are.

The goal of this project is to draw $N$ circles with random
center and radius. Plot each circle using the `circle` function
above.

!bsubex
Let $R$ be normally distributed and $(x_0,y_0)$ uniformly distributed.

!bans
Here goes the short answer to part a).
!eans

!bsol
Here goes a full solution to part a).
!esol

!bhint
Use the `numpy.random` module to draw the
$x_0$, $y_0$, and $R$ quantities.
!ehint

!esubex

!bsubex
Let $R$ be uniformly distributed and $(x_0,y_0)$ normally distributed.

file=norm  # test local filename for subexercise
!esubex

!bsubex
Let $R$ and $(x_0,y_0)$ be normally distributed.
!esubex

!bremarks
At the very end of the exercise it may be appropriate to summarize
and give some perspectives.
!eremarks

===== Exercise: Determine some Distance =====
label{exer:dist}

Intro to this exercise. Questions are in subexercises below.

!bsubex
Subexercises are numbered a), b), etc.

file=subexer_a.pdf

!bans
Short answer to subexercise a).
With math in answer: $a=b$.
!eans

!bhint
First hint to subexercise a).
With math $a=b$ in hint:

!bt
\[ a=b. \]
!et
And with code (in plain verbatim) returning $x+1$ in hint:

!bc
def func(x):
    return x + 1  # with code in hint
!ec
!ehint

!bhint
Second hint to subexercise a).

Test list in hint:

 o item1
 o item2

!ehint
!esubex

!bsubex
Here goes the text for subexercise b).

file=subexer_b.pdf

Some math $\cos^2 x + \sin^2 x = 1$ written one a single line:

!bt
\[ \cos^2 x + \sin^2 x = 1 \thinspace .\]
!et

!bhint
A hint for this subexercise.
!ehint

!bsol
Here goes the solution of this subexercise.
!esol
!esubex

!bremarks
Some final closing remarks, e.g., summarizing the main findings
and their implications in other problems can be made. These
remarks will appear at the end of the typeset exercise.
!eremarks

!bsol
Here goes a full solution of the whole exercise.
With some math $a=b$ in this solution:
!bt
\[ \hbox{math in solution: } a = b \]
!et
And code `a=b` in this solution:
!bc
a = b  # code in solution
!ec
End of solution is here.
!esol

#  No meaning in this weired test example:
The text here belongs to the main (intro) part of the exercise. Need
closing remarks to have text after subexercises.

Test list in exercise:

 o item1
 o item2


===== {Exercise}: Some exercise without the "Exercise:" prefix =====

# Another minimalistic exercise

Just some text. And some math saying that $e^0=1$ on a single line,
to test that math block insertion is correct:

!bt
\[ \exp{(0)} = 1 \]
!et

And a test that the code `lambda x: x+2` is correctly placed here:

!bc
lambda x: x+2
!ec

# Have some comments at the end of the exercise to see that
# the Filename: ... is written correctly.


===== Exercise: Solution of differential equation =====
label{sec:this:exer:de}

!bquiz
H: SOlution of differential equation
K: derivatives; exponential function; equation, differential; differential equation
Q: Given

!bt
\[ \frac{dy}{dx} = -y(x),\quad y(0)=1 \]
!et
What is the solution of this equation?

L: quiz:diff:eq1

Cr: $y=e^{-y}$

Cw: $y=e^{y}$
E: Almost, but the sign is wrong (note the minus!).

Cw:
!bc pycod
from math import exp
def f(x):
    return exp(x)
!ec

E: Ooops, forgot a minus: `exp(-x)`, otherwise this Python code
must be considered as a good answer. It is more natural,
though, to write the solution to the problem
in mathematical notation:

!bt
\[ y(x) = e^{-y}.\]
!et

Cw: The solution cannot be found because there is a derivative in the equation.
E: Equations with derivatives can be solved;
they are termed *differential
equations*.

Cw: The equation is meaningless: an equation must be an equation
for $x$ or $y$, not a function $y(x)$.
E: Equations where the unknown is a function, as $y(x)$
here, are called *differential equations*, and are solved by
special techniques.
!equiz


===== Example: Just an example =====

# This example needs the --examples_as_exercises option, otherwise
# it is just typeset as it is written.

!bsubex
What is the capital of Norway?

!bans
Oslo.
!eans
!esubex

======= Here goes another section =======

With some text, before we continue with exercises.

======= More Exercises =======

===== Exercise: Make references to projects and problems =====

label{exer:some:formula}
file=verify_formula.py

# Test comments not at the end only
Pick a statement from Project ref{proj:circle1} or Problem ref{demo:ex:1}
and verify it.

Test list at the end of an exercise without other elements (like subexercise,
hint, etc.):

 o item1
 o item2

% if FORMAT in ('rst', 'sphinx', 'html'):
===== Project: References in a headings do not work well in ${FORMAT} =====
% else:
===== Project: References to Project ref{demo:ex:2} in a heading works for ${FORMAT} =====
% endif

label{exer:you}
file=selc_composed.pdf

Refer to the previous exercise as Exercise ref{exer:some:formula},
the two before that as Projects ref{demo:ex:2} and ref{proj:circle1},
and this one as Project ref{exer:you}.

======= References =======

BIBFILE: papers.pub


======= Appendix: Just for testing; part I =======
label{app1}

This is the first appendix.

===== A subsection within an appendix =====

Some text.

======= Appendix: Just for testing; part II =======
label{app2}

This is more stuff for an appendix.

===== Appendix: Testing identical titles =====

Without label.


===== Appendix: Testing identical titles =====
label{test:title:id1}

With label.

===== Appendix: Testing identical titles =====
label{test:title:id2}

What about inserting a quiz?

!bquiz
NP: Test of quizzes
H: Capital of Norway
K: capitals; basic intelligence; geography

Q: [Fundamental test:] What is the capital of Norway?
Cw: [Answer 1:] Stockholm
E: Stockholm is the capital of Sweden.
Cw: [Answer 2:] London
Cr: [Answer 3:] Oslo
Cw: Bergen
E: Those from Bergen would claim so, but nobody else.
!equiz


===== Appendix: Testing identical titles =====

Without label.

!bnotice Tip
Here is a tip or hint box, typeset as a notice box.
!enotice


# #if FORMAT in ("latex", "pdflatex")
\clearpage
# #endif

Need a lot of text to surround the summary box.
Version control systems allow you to record the history of files
and share files among several computers and collaborators in a
professional way. File changes on one computer are updated or
merged with changes on another computer. Especially when working
with programs or technical reports it is essential
to have changes documented and to
ensure that every computer and person involved in the project
have the latest updates of the files.
Greg Wilson' excellent "Script for Introduction to Version Control":
"https://software-carpentry.org/2010/07/script-for-introduction-to-version-control/" provides a more detailed motivation why you will benefit greatly
from using version control systems.

!bsummary
_Bold remark:_ Make some text with this summary.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
!esummary

Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that site. I strongly
recommend you to use such sites for all serious programming and
scientific writing work - and all other important files.

The simplest services for hosting project files are "Dropbox":
"https://dropbox.com" and "Google Drive": "https://drive.google.com".
It is very easy to get started with these systems, and they allow you
to share files among laptops and mobile units with as many users as
you want. The systems offer a kind of version control in that the
files are stored frequently (several times per minute), and you can go
back to previous versions for the last 30 days. However, it is
challenging  to find the right version from the past when there are
so many of them.

More seriously, when several people may edit files simultaneously, it
can be difficult detect who did what when, roll back to previous
versions, and to manually merge the edits when these are
incompatible. Then one needs more sophisticated tools than Dropbox or
Google Drive: project hosting services with true version control
systems.  The following text aims at providing you with the minimum
information to started with such systems. Numerous other tutorials
contain more comprehensive material and in-depth explanations of the
concepts and tools.

The idea with project hosting services is that you have the files
associated with a project in the cloud. Many people may share these
files.  Every time you want to work on the project you explicitly
update your version of the files, edit the files as you like, and
synchronize the files with the "master version" at the site where the
project is hosted.  If you at some point need to go back to a
version of the files at some particular point in the past,
this is an easy operation. You can also use tools to see
what various people have done with the files in the various versions.

All these services are very similar. Below we describe how you get
started with Bitbucket, GitHub, and Googlecode. Launchpad works very
similarly to the latter three. All the project hosting services have
excellent introductions available at their web sites, but the recipes
below are much shorter and aim at getting you started as quickly as
possible by concentrating on the most important need-to-know steps.
The Git tutorials we refer to later in this document contain more
detailed information and constitute of course very valuable readings
when you use version control systems every day. The point now is
to get started.


===== Appendix: Testing inline comments =====

# Names can be [ A-Za-z0-9_'+-]+

Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that
site. [hpl's semi opinion:
not sure if in the cloud is
understood by
all.] I strongly recommend you to use such sites for all serious
programming and scientific writing work - and all other important
files.

The simplest services for hosting project files is Dropbox. [mp:
Simply go to URL:"https://dropbox.com" and watch the video. It explains
how files, like `myfile.py`, perhaps containing much math, like
$\partial u/\partial t$, are easily communicated between machines.] It
is very easy to get started with Dropbox, and it allows you to share
files among [hpl: laptops and mobile units -> computers, tablets,
and phones].

# Test horizontal rule

------

# Coments for editing

First[add: ,] consider a quantity $Q$. [edit: To this end, -> We note that]
$Q>0$, because [del: a] negative [edit: quantity is -> quantities
are] [del: just] negative. [add: This comes as no surprise.]

# Test tailored latex figure references with page number
Let us refer to Figure ref{fig:impact} again.

Test references in a list:

 * ref{sec1}
 * ref{subsec1}
 * ref{fig:impact}


===== Appendix: Testing headings ending with `verbatim inline` =====

The point here is to test 1) `verbatim` code in headings, and 2)
ending a heading with verbatim code as this triggers a special
case in LaTeX.

We also test mdash---used as alternative to hyphen without spaces around,
or in quotes:

!bquote
*Fun is fun*.---Unknown.
!equote

The ndash should also be tested -- as in the Hanson--Nilson equations
on page 277--278.

And finally, what about admons, quotes, and boxes? They are tested
in a separate document: `admon.do.txt`.

[^example-of-the-third-footnote]: Not much to add here, but the footnote
is at the end with only one newline.

************** File: testdoc.html *****************
<!--
Automatically generated HTML file from DocOnce source
(https://github.com/doconce/doconce/)
-->
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="generator" content="DocOnce: https://github.com/doconce/doconce/" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<meta name="description" content="A Document for Testing DocOnce">
<meta name="keywords" content="figures,movies,index with subindex,_boldface word_ in index,index with _boldface word_,index with _boldface word_ in subentry,double _boldface word_  _boldface word_ in subentry too,index, with comma, and one more">

<title>A Document for Testing DocOnce</title>


<link href="https://raw.github.com/doconce/doconce/master/bundled/html_styles/style_solarized_box/css/solarized_light_code.css" rel="stylesheet" type="text/css" title="light"/>
<script src="https://raw.github.com/doconce/doconce/master/bundled/html_styles/style_solarized_box/js/highlight.pack.js"></script>
<script>hljs.initHighlightingOnLoad();</script>

<style type="text/css">
body, td {font-size: 140%;}
h1 {font-size: 200%;}
h2 {font-size: 180%;}

/* solarized style */
body {
  margin:5;
  padding:0;
  border:0; /* Remove the border around the viewport in old versions of IE */
  width:100%;
  background: #fdf6e3;
  min-width:600px;	/* Minimum width of layout - remove if not required */
  font-family: Verdana, Helvetica, Arial, sans-serif;
  font-size: 1.0em;
  line-height: 1.3em;
  color: #657b83;
}
a { color: #859900; text-decoration: underline; }
a:hover, a:active { outline:none }
a, a:active, a:visited { color: #859900; }
a:hover { color: #268bd2; }
h1, h2, h3 { margin:.8em 0 .2em 0; padding:0; line-height: 125%; }
h2 { font-variant: small-caps; }
tt, code { font-family: monospace, sans-serif; box-shadow: none; }
hr { border: 0; width: 80%; border-bottom: 1px solid #aaa; }
p { text-indent: 0px; }
p.caption { width: 80%; font-style: normal; text-align: left; }
hr.figure { border: 0; width: 80%; border-bottom: 1px solid #aaa; }
.alert-text-small   { font-size: 80%;  }
.alert-text-large   { font-size: 130%; }
.alert-text-normal  { font-size: 90%;  }
.alert {
  padding:8px 35px 8px 14px; margin-bottom:18px;
  text-shadow:0 1px 0 rgba(255,255,255,0.5);
  border:1px solid #93a1a1;
  border-radius: 4px;
  -webkit-border-radius: 4px;
  -moz-border-radius: 4px;
  color: #555;
  background-color: #eee8d5;
  background-position: 10px 5px;
  background-repeat: no-repeat;
  background-size: 38px;
  padding-left: 55px;
  width: 75%;
 }
.alert-block {padding-top:14px; padding-bottom:14px}
.alert-block > p, .alert-block > ul {margin-bottom:1em}
.alert li {margin-top: 1em}
.alert-block p+p {margin-top:5px}
.alert-notice { background-image: url(https://raw.github.com/doconce/doconce/master/bundled/html_images/small_yellow_notice.png); }
.alert-summary  { background-image:url(https://raw.github.com/doconce/doconce/master/bundled/html_images/small_yellow_summary.png); }
.alert-warning { background-image: url(https://raw.github.com/doconce/doconce/master/bundled/html_images/small_yellow_warning.png); }
.alert-question {background-image:url(https://raw.github.com/doconce/doconce/master/bundled/html_images/small_yellow_question.png); }

div { text-align: justify; text-justify: inter-word; }
</style>


<script src="https://sagecell.sagemath.org/static/jquery.min.js"></script>
<script src="https://sagecell.sagemath.org/embedded_sagecell.js"></script>
<link rel="stylesheet" type="text/css" href="https://sagecell.sagemath.org/static/sagecell_embed.css">
<script>
$(function () {
    // Make the div with id 'mycell' a Sage cell
    sagecell.makeSagecell({inputLocation:  '#mycell',
                           template:       sagecell.templates.minimal,
                           evalButtonText: 'Activate'});
    // Make *any* div with class 'compute' a Sage cell
    sagecell.makeSagecell({inputLocation: 'div.compute',
                           evalButtonText: 'Evaluate'});
});
</script>




<!-- Tools for embedded Bokeh plots -->
<link rel="stylesheet"
      href="https://cdn.pydata.org/bokeh/release/bokeh-0.9.0.min.css"
      type="text/css" />
<script type="text/javascript"
	src="https://cdn.pydata.org/bokeh/release/bokeh-0.9.0.min.js">
</script>
<script type="text/javascript">
  Bokeh.set_log_level("info");
</script>


</head>

<!-- tocinfo
{'highest level': 1,
 'sections': [('Table of contents',
               1,
               'table_of_contents',
               'table_of_contents'),
              ('Section 1', 1, 'sec1', 'sec1'),
              ('Here is a list with subsubsection heading',
               3,
               None,
               'here-is-a-list-with-subsubsection-heading'),
              ('Subsection 1', 2, 'subsec1', 'subsec1'),
              ('Test Section reference at beginning of line and after a '
               'sentence',
               3,
               None,
               'test-section-reference-at-beginning-of-line-and-after-a-sentence'),
              ('Computer code', 3, None, 'computer-code'),
              ('Subsubsection heading before code',
               3,
               None,
               'subsubsection-heading-before-code'),
              ('Running OS commands', 3, None, 'running-os-commands'),
              ('Footnotes', 3, None, 'footnotes'),
              ('Subsection 2: Testing figures', 2, 'subsec:ex', 'subsec:ex'),
              ('The $\\theta$ parameter (not $\\nabla$?)',
               2,
               'decay:sec:theta',
               'decay:sec:theta'),
              ('Custom Environments', 2, None, 'custom-environments'),
              ('Tables', 2, 'subsec:table', 'subsec:table'),
              ('A test of verbatim words in heading with subscript $a_i$: '
               '`my_file_v1` and `my_file_v2`',
               2,
               None,
               'a-test-of-verbatim-words-in-heading-with-subscript-a_i-my_file_v1-and-my_file_v2'),
              ('_Just bold_', 2, None, '_just-bold_'),
              ('*Just emphasize*', 2, None, 'just-emphasize'),
              ('`Just verbatim`', 2, None, 'just-verbatim'),
              ('_Bold_ beginning', 2, None, '_bold_-beginning'),
              ('*Emphasize* beginning', 2, None, 'emphasize-beginning'),
              ('`Verbatim` beginning', 2, None, 'verbatim-beginning'),
              ('Maybe _bold end_', 2, None, 'maybe-_bold-end_'),
              ('Maybe *emphasize end*', 2, None, 'maybe-emphasize-end'),
              ('Maybe `verbatim end`', 2, None, 'maybe-verbatim-end'),
              ('The middle has _bold_ word',
               2,
               None,
               'the-middle-has-_bold_-word'),
              ('The middle has *emphasize* word',
               2,
               None,
               'the-middle-has-emphasize-word'),
              ('The middle has `verbatim` word',
               2,
               None,
               'the-middle-has-verbatim-word'),
              ('Bibliography test', 2, None, 'bibliography-test'),
              ('Example 1: Examples can be typeset as exercises',
               2,
               'Example',
               'Example'),
              ('User-defined environments',
               2,
               None,
               'user-defined-environments'),
              ('Example 1: A test function', 2, 'ex:test:1p1', 'ex:test:1p1'),
              ('Example 2: Addition', 2, 'ex:math:1p1', 'ex:math:1p1'),
              ('URLs', 2, 'subsubsec:ex', 'subsubsec:ex'),
              ('LaTeX Mathematics', 1, None, 'latex-mathematics'),
              ('Exercises', 1, None, 'exercises'),
              ('Problem 2: Flip a Coin', 2, 'demo:ex:1', 'demo:ex:1'),
              ('My remarks', 3, None, 'my-remarks'),
              ('Remarks', 3, None, 'remarks'),
              ('Not an exercise', 2, None, 'not-an-exercise'),
              ('Exercise 3: Test of plain text exercise',
               2,
               'my:exer1',
               'my:exer1'),
              ('Project 4: Compute a Probability', 2, 'demo:ex:2', 'demo:ex:2'),
              ('Project 5: Explore Distributions of Random Circles',
               2,
               'proj:circle1',
               'proj:circle1'),
              ('Remarks', 3, None, 'remarks'),
              ('Exercise 6: Determine some Distance',
               2,
               'exer:dist',
               'exer:dist'),
              ('Remarks', 3, None, 'remarks'),
              ('Some exercise without the "Exercise:" prefix',
               2,
               None,
               'some-exercise-without-the-exercise-prefix'),
              ('Exercise 8: Solution of differential equation',
               2,
               'sec:this:exer:de',
               'sec:this:exer:de'),
              ('Example 9: Just an example',
               2,
               None,
               'example-9-just-an-example'),
              ('Here goes another section',
               1,
               None,
               'here-goes-another-section'),
              ('More Exercises', 1, None, 'more-exercises'),
              ('Exercise 10: Make references to projects and problems',
               2,
               'exer:some:formula',
               'exer:some:formula'),
              ('Project 11: References in a headings do not work well in html',
               2,
               'exer:you',
               'exer:you'),
              ('References', 1, None, 'references'),
              ('Appendix: Just for testing; part I', 1, 'app1', 'app1'),
              ('A subsection within an appendix',
               2,
               None,
               'a-subsection-within-an-appendix'),
              ('Appendix: Just for testing; part II', 1, 'app2', 'app2'),
              ('Appendix: Testing identical titles',
               2,
               None,
               'appendix-testing-identical-titles'),
              ('Appendix: Testing identical titles',
               2,
               'test:title:id1',
               'test:title:id1'),
              ('Appendix: Testing identical titles',
               2,
               'test:title:id2',
               'test:title:id2'),
              ('Appendix: Testing identical titles',
               2,
               None,
               'appendix-testing-identical-titles'),
              ('Appendix: Testing inline comments',
               2,
               None,
               'appendix-testing-inline-comments'),
              ('Appendix: Testing headings ending with `verbatim inline`',
               2,
               None,
               'appendix-testing-headings-ending-with-verbatim-inline')]}
end of tocinfo -->

<body>



<script type="text/x-mathjax-config">
MathJax.Hub.Config({
  TeX: {
     equationNumbers: {  autoNumber: "none"  },
     extensions: ["AMSmath.js", "AMSsymbols.js", "autobold.js", "color.js"]
  }
});
</script>
<script type="text/javascript" async
 src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.1/MathJax.js?config=TeX-AMS-MML_HTMLorMML">
</script>



    
<a name="part0000"></a>
<!-- ------------------- main content ---------------------- -->



<center>
<h1>A Document for Testing DocOnce</h1>
</center>  <!-- document title -->

<p></p>
<!-- author(s): Hans Petter Langtangen, Kaare Dump, A. Dummy Author, I. S. Overworked and Outburned, and J. Doe -->

<center>
<b>Hans Petter Langtangen</b> [1, 2] (<tt>hpl at simula.no</tt>)
</center>


<center>
<b>Kaare Dump</b> [3]
</center>


<center>
<b>A. Dummy Author</b> 
</center>


<center>
<b>I. S. Overworked and Outburned</b> [4, 5, 6, 7]
</center>


<center>
<b>J. Doe</b>  (<tt>j_doe at cyberspace.com</tt>)
</center>

<p><!-- institution(s) --></p>

<center>
[1] <b>Center for Biomedical Computing, Simula Research Laboratory</b>
</center>

<center>
[2] <b>Department of Informatics, University of Oslo</b>
</center>

<center>
[3] <b>Segfault, Cyberspace</b>
</center>

<center>
[4] <b>Inst1</b>
</center>

<center>
[5] <b>Inst2, Somewhere</b>
</center>

<center>
[6] <b>Third Inst, Elsewhere</b>
</center>

<center>
[7] <b>Fourth Inst</b>
</center>

<br>
<center>
<h4>Jan 32, 2100</h4>
</center> <!-- date -->
<br>
<p></p>
<h1 id="table_of_contents">Table of contents</h1>

<p></p>
<a href="._testdoc001.html#sec1"> Section 1 </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#subsec1"> Subsection 1 </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#subsec:ex"> Subsection 2: Testing figures </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#decay:sec:theta"> The \( \theta \) parameter (not \( \nabla \)?) </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#custom-environments"> Custom Environments </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#subsec:table"> Tables </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#a-test-of-verbatim-words-in-heading-with-subscript-a_i-my_file_v1-and-my_file_v2"> A test of verbatim words in heading with subscript \( a_i \): <code>my_file_v1</code> and <code>my_file_v2</code> </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#_just-bold_"> <b>Just bold</b> </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#just-emphasize"> <em>Just emphasize</em> </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#just-verbatim"> <code>Just verbatim</code> </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#_bold_-beginning"> <b>Bold</b> beginning </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#emphasize-beginning"> <em>Emphasize</em> beginning </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#verbatim-beginning"> <code>Verbatim</code> beginning </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#maybe-_bold-end_"> Maybe <b>bold end</b> </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#maybe-emphasize-end"> Maybe <em>emphasize end</em> </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#maybe-verbatim-end"> Maybe <code>verbatim end</code> </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#the-middle-has-<b>bold</b>-word"> The middle has <b>bold</b> word </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#the-middle-has-emphasize-word"> The middle has <em>emphasize</em> word </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#the-middle-has-verbatim-word"> The middle has <code>verbatim</code> word </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#bibliography-test"> Bibliography test </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#Example"> Example 1: Examples can be typeset as exercises </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#user-defined-environments"> User-defined environments </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#ex:test:1p1"> Example 1: A test function </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#ex:math:1p1"> Example 2: Addition </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc001.html#subsubsec:ex"> URLs </a>
<br>
<a href="._testdoc002.html#latex-mathematics"> LaTeX Mathematics </a>
<br>
<a href="._testdoc002.html#exercises"> Exercises </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc002.html#demo:ex:1"> Problem 2: Flip a Coin </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc002.html#not-an-exercise"> Not an exercise </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc002.html#my:exer1"> Exercise 3: Test of plain text exercise </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc002.html#demo:ex:2"> Project 4: Compute a Probability </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc002.html#proj:circle1"> Project 5: Explore Distributions of Random Circles </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc002.html#exer:dist"> Exercise 6: Determine some Distance </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc002.html#some-exercise-without-the-exercise-prefix"> Some exercise without the "Exercise:" prefix </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc002.html#sec:this:exer:de"> Exercise 8: Solution of differential equation </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc002.html#example-9-just-an-example"> Example 9: Just an example </a>
<br>
<a href="._testdoc002.html#here-goes-another-section"> Here goes another section </a>
<br>
<a href="._testdoc002.html#more-exercises"> More Exercises </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc002.html#exer:some:formula"> Exercise 10: Make references to projects and problems </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc002.html#exer:you"> Project 11: References in a headings do not work well in html </a>
<br>
<a href="._testdoc002.html#references"> References </a>
<br>
<a href="._testdoc002.html#app1"> Appendix: Just for testing; part I </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc002.html#a-subsection-within-an-appendix"> A subsection within an appendix </a>
<br>
<a href="._testdoc002.html#app2"> Appendix: Just for testing; part II </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc003.html#appendix-testing-identical-titles"> Appendix: Testing identical titles </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc002.html#test:title:id1"> Appendix: Testing identical titles </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc002.html#test:title:id2"> Appendix: Testing identical titles </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc003.html#appendix-testing-identical-titles"> Appendix: Testing identical titles </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc003.html#appendix-testing-inline-comments"> Appendix: Testing inline comments </a>
<br>
&nbsp; &nbsp; &nbsp; <a href="._testdoc003.html#appendix-testing-headings-ending-with-verbatim-inline"> Appendix: Testing headings ending with <code>verbatim inline</code> </a>
<br>

<p></p>
<p>
<!-- begin bottom navigation -->
<table style="width: 100%"><tr><td>
</td><td>
\
<div style="text-align: right;"><a href="._testdoc001.html"><img src="https://hplgit.github.io/doconce/bundled/html_images/next2.png" border=0 alt="Next &raquo;"></a></div>
</td></tr></table>
<!-- end bottom navigation -->
</p>

<!-- ------------------- end of main content --------------- -->

<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.js"></script>


</body>
</html>

************** File: testdoc.p.tex *****************
%%
%% Automatically generated file from DocOnce source
%% (https://github.com/doconce/doconce/)
%%
%%
% #ifdef PTEX2TEX_EXPLANATION
%%
%% The file follows the ptex2tex extended LaTeX format, see
%% ptex2tex: https://code.google.com/p/ptex2tex/
%%
%% Run
%%      ptex2tex myfile
%% or
%%      doconce ptex2tex myfile
%%
%% to turn myfile.p.tex into an ordinary LaTeX file myfile.tex.
%% (The ptex2tex program: https://code.google.com/p/ptex2tex)
%% Many preprocess options can be added to ptex2tex or doconce ptex2tex
%%
%%      ptex2tex -DMINTED myfile
%%      doconce ptex2tex myfile envir=minted
%%
%% ptex2tex will typeset code environments according to a global or local
%% .ptex2tex.cfg configure file. doconce ptex2tex will typeset code
%% according to options on the command line (just type doconce ptex2tex to
%% see examples). If doconce ptex2tex has envir=minted, it enables the
%% minted style without needing -DMINTED.
% #endif

% #define PREAMBLE

% #ifdef PREAMBLE
%-------------------- begin preamble ----------------------

\documentclass[%
oneside,                 % oneside: electronic viewing, twoside: printing
final,                   % draft: marks overfull hboxes, figures with paths
10pt]{article}

\listfiles               %  print all files needed to compile this document

\usepackage{relsize,epsfig,makeidx,color,setspace,amsmath,amsfonts,amssymb}
\usepackage[table]{xcolor}
\usepackage{bm,ltablex,microtype}

\usepackage{graphicx}
\usepackage{sidecap}

% user-provided packages: --latex_packages=varioref
\usepackage{varioref}

% 'on page ...' reference with \vref{} and varioref package
\renewcommand\reftextfaceafter{on page~\thevpagerefnum}
\renewcommand\reftextfacebefore{on page~\thevpagerefnum}
\renewcommand\reftextafter{on page~\thevpagerefnum}
\renewcommand\reftextbefore{on page~\thevpagerefnum}

% Tools for marking corrections
\usepackage{soul}
\newcommand{\replace}[2]{{\color{red}\text{\st{#1} #2}}}
\newcommand{\remove}[1]{{\color{red}\st{#1}}}

\usepackage{ptex2tex}
% #ifdef MINTED
\usepackage{minted}
\usemintedstyle{default}
% #endif
\usepackage{fancyvrb}

\usepackage[T1]{fontenc}
%\usepackage[latin1]{inputenc}
\usepackage{ucs}
\usepackage[utf8x]{inputenc}

\usepackage{lmodern}         % Latin Modern fonts derived from Computer Modern

\newenvironment{doconcequiz}{}{}
\newcounter{doconcequizcounter}

% Hyperlinks in PDF:
\definecolor{linkcolor}{rgb}{0,0,0.4}
\usepackage{hyperref}
\hypersetup{
    breaklinks=true,
    colorlinks=true,
    linkcolor=linkcolor,
    urlcolor=linkcolor,
    citecolor=black,
    filecolor=black,
    %filecolor=blue,
    pdfmenubar=true,
    pdftoolbar=true,
    bookmarksdepth=3   % Uncomment (and tweak) for PDF bookmarks with more levels than the TOC
    }
%\hyperbaseurl{}   % hyperlinks are relative to this root

\setcounter{tocdepth}{2}  % levels in table of contents

%\VerbatimFootnotes must come after hyperref and footmisc packages
\VerbatimFootnotes

% Tricks for having figures close to where they are defined:
% 1. define less restrictive rules for where to put figures
\setcounter{topnumber}{2}
\setcounter{bottomnumber}{2}
\setcounter{totalnumber}{4}
\renewcommand{\topfraction}{0.95}
\renewcommand{\bottomfraction}{0.95}
\renewcommand{\textfraction}{0}
\renewcommand{\floatpagefraction}{0.75}
% floatpagefraction must always be less than topfraction!
% 2. ensure all figures are flushed before next section
\usepackage[section]{placeins}
% 3. enable begin{figure}[H] (often leads to ugly pagebreaks)
%\usepackage{float}\restylefloat{figure}

% newcommands for typesetting inline (doconce) comments
\newcommand{\shortinlinecomment}[3]{{\color{red}{\bf #1}: #2}}
\newcommand{\longinlinecomment}[3]{{\color{red}{\bf #1}: #2}}

\usepackage[framemethod=TikZ]{mdframed}

% --- begin definitions of admonition environments ---

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "notice" admon
\colorlet{mdfbox_notice_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_notice_background,
  linecolor=black,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=mdfbox_notice_background,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{notice_mdfboxmdframed}

\newenvironment{notice_mdfboxadmon}[1][]{
\begin{notice_mdfboxmdframed}[frametitle=#1]
}
{
\end{notice_mdfboxmdframed}
}

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "summary" admon
\colorlet{mdfbox_summary_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_summary_background,
  linecolor=black,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=mdfbox_summary_background,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{summary_mdfboxmdframed}

\newenvironment{summary_mdfboxadmon}[1][]{
\begin{summary_mdfboxmdframed}[frametitle=#1]
}
{
\end{summary_mdfboxmdframed}
}

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "warning" admon
\colorlet{mdfbox_warning_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_warning_background,
  linecolor=black,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=mdfbox_warning_background,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{warning_mdfboxmdframed}

\newenvironment{warning_mdfboxadmon}[1][]{
\begin{warning_mdfboxmdframed}[frametitle=#1]
}
{
\end{warning_mdfboxmdframed}
}

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "question" admon
\colorlet{mdfbox_question_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_question_background,
  linecolor=black,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=mdfbox_question_background,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{question_mdfboxmdframed}

\newenvironment{question_mdfboxadmon}[1][]{
\begin{question_mdfboxmdframed}[frametitle=#1]
}
{
\end{question_mdfboxmdframed}
}

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "block" admon
\colorlet{mdfbox_block_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_block_background,
  linecolor=black,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=mdfbox_block_background,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{block_mdfboxmdframed}

\newenvironment{block_mdfboxadmon}[1][]{
\begin{block_mdfboxmdframed}[frametitle=#1]
}
{
\end{block_mdfboxmdframed}
}

% --- end of definitions of admonition environments ---

% prevent orhpans and widows
\clubpenalty = 10000
\widowpenalty = 10000

\usepackage{calc}

\newenvironment{doconceexercise}{}{}
\newcounter{doconceexercisecounter}
% --- begin definition of \listofexercises command ---
\makeatletter
\newcommand\listofexercises{\section*{List of Examples, Exercises, Problems, and Projects}
\@starttoc{loe}
}
\newcommand*{\l@doconceexercise}{\@dottedtocline{0}{0pt}{6.5em}}
\makeatother
% --- end definition of \listofexercises command ---



% ------ header in subexercises ------
%\newcommand{\subex}[1]{\paragraph{#1}}
%\newcommand{\subex}[1]{\par\vspace{1.7mm}\noindent{\bf #1}\ \ }
\makeatletter
% 1.5ex is the spacing above the header, 0.5em the spacing after subex title
\newcommand\subex{\@startsection{paragraph}{4}{\z@}%
                  {1.5ex\@plus1ex \@minus.2ex}%
                  {-0.5em}%
                  {\normalfont\normalsize\bfseries}}
\makeatother


% --- end of standard preamble for documents ---


\usepackage{amsthm,tcolorbox}
\theoremstyle{definition}
\newtheorem{example}{Example}[section]



% insert custom LaTeX commands...

\raggedbottom
\makeindex
\usepackage[totoc]{idxlayout}   % for index in the toc
\usepackage[nottoc]{tocbibind}  % for references/bibliography in the toc

%-------------------- end preamble ----------------------

\begin{document}

% matching end for #ifdef PREAMBLE
% #endif

\newcommand{\exercisesection}[1]{\subsection*{#1}}

\input{newcommands_bfmath}
\input{newcommands_replace}

% ------------------- main content ----------------------



% ----------------- title -------------------------

\title{A Document for Testing DocOnce}

% ----------------- author(s) -------------------------

\author{Hans Petter Langtangen\footnote{Email: \texttt{hpl@simula.no}. Center for Biomedical Computing, Simula Research Laboratory and Department of Informatics, University of Oslo.}
\and Kaare Dump\footnote{Segfault, Cyberspace.}
\and A. Dummy Author
\and I. S. Overworked and Outburned\footnote{Inst1; Inst2, Somewhere; Third Inst, Elsewhere; and Fourth Inst.}
\and J. Doe\footnote{Email: \texttt{j\_doe@cyberspace.com}.}}

% ----------------- end author(s) -------------------------

\date{Jan 32, 2100}
\maketitle

\tableofcontents

\vspace{1cm} % after toc

% !split

The format of this document is
plain, homemade {\LaTeX} (from DocOnce).

\begin{abstract}
This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.

% Cannot demonstrate chapter headings since abstract and chapter
% are mutually exclusive in {\LaTeX}
\end{abstract}

\section{Section 1}
\label{sec1}

Here is a nested list:

\begin{itemize}
  \item item1

  \item item2

  \item item3 which continues
    on the next line to test that feature

  \item and a sublist
\begin{itemize}

    \item with indented subitem1

    \item and a subitem2

\end{itemize}

\noindent
  \item and perhaps an ordered sublist
\begin{enumerate}

   \item first item

   \item second item,
      continuing on a new line
\end{enumerate}

\noindent
\end{itemize}

\noindent
\paragraph{Here is a list with paragraph heading.}

\begin{itemize}
  \item item1

  \item item2
\end{itemize}

\noindent
\paragraph{Here is a list with subsubsection heading.}
\begin{itemize}
  \item item1

  \item item2
\end{itemize}

\noindent

\begin{quote}
Here are two lines that make up
a block quote for testing \emph{emphasized words} and \textbf{boldface words},
also with hypens:
\emph{pre}-fix, post-\emph{fix}, \textbf{pre}-fix, post-\textbf{fix}.
\end{quote}


Here are two references. Equation~(\ref{my:eq1}) is fine. Eq.~(\ref{my:eq1}) too.
Even Equation (\ref{my:eq1}) without the tilde.

\subsection{Subsection 1}
\label{subsec1}

\index{somefunc@{\rm\texttt{somefunc}} function}

% Refer to section/appendix etc. at the beginning of the line
% and other special fix situations for HTML.

More text, with a reference back to
Section~\vref{sec1} and~\vref{subsec1}, and further to the
sections~\vref{subsec1} and~\vref{subsubsec:ex}, which
encourages you to do the tasks in the
Exercises~\vref{demo:ex:1} and~\vref{exer:some:formula}.
Appendices~\vref{app1} and~\vref{app2} are also nice elements.

\paragraph{Test Section reference at beginning of line and after a sentence.}
Section~\vref{subsec1} is fine.
Section~\vref{subsubsec:ex} too.

% sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console

\paragraph{Computer code.}
Let's do some copying from files too. First from subroutine up to the very end,

\bfcod
      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
\efcod
and then just the subroutine,
\bfcod

      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
\efcod
and finally the complete file with a plain text verbatim environment
(\texttt{envir=ccq}):
\bccq
C     a comment

      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
\eccq

Testing other code environments. First Python:

\bccq
!bc pycod
def f(x):
    return x+1
!ec
\eccq
which gets rendered as

\bpycod
def f(x):
    return x+1
\epycod

Test paragraph and subsubsection headings before
before code.

\paragraph{Paragraph heading before code.}

\bpycod
import sys
sys.path.insert(0, os.pardir)
\epycod

\paragraph{Subsubsection heading before code.}
\bpycod
def h(z):
    return z+1
\epycod

Now a complete program to be shown via Python Online Tutorial:

\bpypro
class Line:
    def __init__(self, a, b):
        self.a, self.b = a, b

    def __call__(self, x):
        a, b = self.a, self.b
        return a*x + b

line = Line(2, 1)
y = line(x=3)
print(y)
\epypro
\noindent
(\href{{https://pythontutor.com/visualize.html\#code=class+Line\%3A\%0A++++def+__init__\%28self\%2C+a\%2C+b\%29\%3A\%0A++++++++self.a\%2C+self.b+\%3D+a\%2C+b\%0A\%0A++++def+__call__\%28self\%2C+x\%29\%3A\%0A++++++++a\%2C+b+\%3D+self.a\%2C+self.b\%0A++++++++return+a\%2Ax+\%2B+b\%0A\%0Aline+\%3D+Line\%282\%2C+1\%29\%0Ay+\%3D+line\%28x\%3D3\%29\%0Aprint\%28y\%29&mode=display&cumulative=false&heapPrimitives=false&drawParentPointers=false&textReferences=false&py=2&curInstr=0}}{Visualize execution}) 


Some more Python code (actually specified as a sage cell, but
such cells are not supported by this format).

\bpypro
a = 2
b = 3
print('a+b:', a + b)

# In a sage cell we can also plot
from matplotlib.pyplot import *
from numpy import *
x = linspace(0, 4*pi, 101)
y = exp(-0.1*x)*cos(x)
plot(x, y)
xlabel('x'); ylabel('y')
show()
\epypro

Then Cython (with -h option so it is hidden in html/sphinx):

\bcycod
cpdef f(double x):
    return x + 1
\ecycod

Standard Python shell sessions:

\bpyshell
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
\epyshell

Similar IPython sessions:

\bipy
In [1]: from numpy import linspace, sin
In [2]: # Some comment
In [3]: x = linspace(0, 2, 11)
In [4]: y = sin(x)
In [5]: y[0]
Out[5]: 0
In [6]: import matplotlib.pyplot as plt
In [7]: plt.plot(x, y)
In [8]: a='multiple-\nline\noutput'
In [9]: a
Out[9]: 'multiple-\nline\noutput'
In [10]: print(a)
multiple-
line
output
\eipy

Here is the interactive session again, but with \texttt{pyshell-t}.

\bpyshell
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
\epyshell

% This one tests a + sign before a code environment
C++:
\bcpppro
#include <iostream>

int main()
{
   std::cout << "Sample output" << std::endl;
   return 0
}
\ecpppro
% The next should get correctly typset in sphinx (cod is fcod)
% It also tests emoji before code
And a little bit of Fortran: (\Verb!dizzy_face!)

\bccq
!bc cod
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
!ec
\eccq
which then is typeset as

\bcod
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
\ecod

HTML:

\bhtmlcod
<table>
<tr><td>Column 1</td><td>Column 2</td></tr>
<tr><td>0.67526 </td><td>0.92871 </td></tr>
<!-- comment -->
</table>
\ehtmlcod

But inline HTML code is also important, like text that starts with
\texttt{<a href="} (which can destroy the following text if not properly
quoted).

Matlab with comments requires special typesetting:

\bmcod
% Comment on the beginning of the line can be escaped by %%
if a > b
  % Indented comment needs this trick
  c = a + b
end
\emcod

And here is a system call:

\bsys
Terminal> mkdir test
Terminal> cd test
Terminal> myprog -f
output1
output2
\esys

Any valid pygments lexer/language name can appear to, e.g.,

\bccq
!bc restructuredtext
=======
Heading
=======

Some text.
!ec
\eccq
results in

\brestructuredtext
=======
Heading
=======

Some text.
\erestructuredtext

% Here goes hidden code.
% Python can be treated by some formats, Fortran is always out.





Finally, \Verb?!bc do? supports highlighting of DocOnce source:

\bdo
======= DocOnce test file =======

===== Computer code =====

Inline verbatim code, as in `import numpy as np`, is allowed, as well as
code blocks:

!bc pycod
from math import sin

def f(x):
    """Example on a function."""
    return sin(x) + 1

print(f(0))
!ec


===== Mathematics =====

Formulas can be inline, as in $\nabla\cdot\bm{u} = 0$, or typeset
as equations:

!bt
\begin{align*}
\nabla\cdot\bm{u} &= 0,\\ 
\bm{u} &= \nabla\phi .
\end{align*}
!et

=== Subsubsection heading ===

DocOnce files can have chapters, sections, subsections, and subsubsections.

__Paragraph heading.__ Paragraphs may have headings.
\edo

It is time to test \texttt{verbatim inline font} especially with \texttt{a newline inside the text} and an exclamation mark at the end: \texttt{BEGIN}! For
spellcheck, test \texttt{a verbatim expression} in \texttt{another} in a \texttt{third}.
Also test exclamation mark as in \Verb?!bc? and \Verb?!ec? as well as \Verb?a != b?.
Also test backslashes and braces like \Verb!\begin!, \Verb!\begin{enumerate}!,
\Verb!\end{this}\end{that}!, and \Verb!{something \inside braces}!.

Here is some \textcolor{red}{red color} and an attempt to write \textcolor{green}{with
green color containing a linebreak\\
code.} Some formats will only display \\
this correctly when \texttt{html} \\
is the output format.
But here some more running text is added which is not part of
the previous blocks with line breaks.

\paragraph{Running OS commands.}
\bsys
Terminal> python -c 'print("Testing\noutput\nfrom\nPython.")'
Testing
output
from
Python.
\esys

\paragraph{Footnotes.}
Here is a test of footnotes \footnote{Typesetting of the footnote depends on the format. Plain text does nothing, {\LaTeX} removes the definition and inserts the footnote as part of the {\LaTeX} text. reStructuredText and Sphinx employ a similar type of typesetting as Extended Markdown and DocOnce, and in HTML we keep the same syntax, just displayed properly in HTML.}, which are handy in text.
They are used in different flavors, now in

\begin{itemize}
 \item list items (note below that footnotes work after math, verbatim, and URLs - bin fact old and emphasize too!)

 \item even with math $\nabla^2u$\footnote{Math footnotes can be dangerous since it interferes with an exponent.}

 \item and code \texttt{h[i] += 1}\footnote{One-line footnote.}
   (\emph{must} have space between inline code and footnote!)

 \item and \href{{https://google.com}}{links}\footnote{\href{{google.com}}{\nolinkurl{google.com}} is perhaps the most famous web site today.}
\end{itemize}

\noindent
which gives flexibility in writing.
This is the third\footnote{Not much to add here, but the footnote is at the end with only one newline.} example.

Here is some more text before a new definition of a footnote that was
used above.


\begin{notice_mdfboxadmon}[Non-breaking space character.]
This paragraph aims to test \href{{https://en.wikipedia.org/wiki/Non-breaking_space}}{non-breaking space character}, and a typical
example where this is needed is in physical units: 7.4~km is traveled
in~$7.4/5.5\approx 1.345$~s.  Also check that a~\href{{https://google.com}}{link}~is
not broken across lines (drag the browser window to test this).
(On the other hand, the tilde is used in
computer code, e.g., as in \texttt{[~x for x in y]} or in \texttt{y=~x}, and should
of course remain a tilde in those contexts.)
\end{notice_mdfboxadmon} % title: Non-breaking space character.



\subsection{Subsection 2: Testing figures}
\label{subsec:ex}
\index{figures}

Test of figures. In particular we refer to Figure~\vref{fig:impact} in which
there is a flow.

\begin{figure}[!ht]  % fig:impact
  \centerline{\includegraphics[width=0.9\linewidth]{../doc/src/manual/fig/wave1D.png}}
  \caption{
  Visualization \textbf{of} a \emph{wave}. \label{fig:impact}
  }
\end{figure}
%\clearpage % flush figures fig:impact

Figures without captions are allowed and will be inlined.

\vspace{6mm}

% inline figure
\centerline{\includegraphics[width=0.9\linewidth]{../doc/src/manual/fig/wave1D.png}}

\vspace{6mm}

\index{movies}

% Test multi-line caption in figure with sidecap=True

Here is figure~\vref{myfig} with a long (illegal) multi-line caption
containing inline verbatim text:

\begin{SCfigure}
  \centering
  \includegraphics[width=0.9\linewidth]{../doc/src/manual/fig/wave1D.png}
  \caption{
  A long caption spanning several lines and containing verbatim words like \protect \Verb!my\_file\_v1! and \protect \Verb!my\_file\_v2! as well as math with subscript as in $t_{i+1}$. \label{myfig}
  }
\end{SCfigure}
%\clearpage % flush figures myfig

% Must be a blank line after MOVIE or FIGURE to detect this problem

Test URL as figure name:

\vspace{6mm}

% inline figure
\centerline{\includegraphics[width=0.8\linewidth]{downloaded_figures/f_plot.png}}

\vspace{6mm}

% Test wikimedia type of files that otherwise reside in subdirs

\paragraph{Remark.}
Movies are tested in separate file \texttt{movies.do.txt}.

% Somewhat challenging heading with latex math, \t, \n, ? and parenthesis

\subsection{The $\theta$ parameter (not $\nabla$?)}
\label{decay:sec:theta}

Functions do not always need to be advanced, here is one
involving $\theta$:
\bccq
def f(theta):
    return theta**2
\eccq

\paragraph{More on $\theta$.}
Here is more text following headline with math.

Newcommands must also be tested in this \report:
$\half$, $\halfi$, $\x$, $\Ddt{u}$,
both inline and in block:

\begin{align}
\Ddt{u} &= 0\nonumber
\\ 
\half &= \halfi\\ 
\half\x &= \normalvec
\end{align}

Or with align with label and numbers:

\begin{align}
\Ddt{u} &= 0
\label{aligneq1}
\\ 
\half &= \halfi\\ 
\half\x &= \normalvec
\label{aligneq2}
\end{align}

% Must test more complicated align and matrix compositions
% where DocOnce inserts auto-numbered labels etc.

First one numbered (automatically):

\begin{align}
\begin{pmatrix}
G_2 + G_3 & -G_3 & -G_2 & 0 \\ 
-G_3 & G_3 + G_4 & 0 & -G_4 \\ 
-G_2 & 0 & G_1 + G_2 & 0 \\ 
0 & -G_4 & 0 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2 \\ 
 v_3 \\ 
 v_4
\end{pmatrix}
+ \cdots \\ 
\begin{pmatrix}
 C_5 + C_6 & -C_6 & 0 & 0 \\ 
 -C_6 & C_6 & 0 & 0 \\ 
 0 & 0 & 0 & 0 \\ 
 0 & 0 & 0 & 0
\end{pmatrix}
  &= \frac{d}{dt}\begin{pmatrix}
 v_1 \\ 
 v_2 \\ 
 v_3 \\ 
 v_4
\end{pmatrix} +
\begin{pmatrix}
 0 \\ 
 0 \\ 
 0 \\ 
 -i_0
\end{pmatrix}
\nonumber
\end{align}

Second numbered (automatically):

\begin{align}
\begin{pmatrix}
G_1 + G_2\\ 
-G_3 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2
\end{pmatrix}
+ \cdots\nonumber
\\ 
\left(\begin{array}{ll}
y & 2\\ 
2 & 1
\end{array}\right)
\left(\begin{array}{ll}
0 \\ x
\end{array}\right)
&= \begin{pmatrix}
A \\ B
\end{pmatrix}
\end{align}

Both numbered, with label by the user:

\begin{align}
\begin{pmatrix}
G_1 + G_2\\ 
-G_3 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2
\end{pmatrix}
+ \cdots \label{mymatrix:eq1}
\\ 
\label{mymatrix:eq2}
\left(\begin{array}{ll}
y & 2\\ 
2 & 1
\end{array}\right)
\left(\begin{array}{ll}
0 \\ x
\end{array}\right)
&= \begin{pmatrix}
A \\ B
\end{pmatrix}
\end{align}
Now we refer to (\ref{mymatrix:eq1})-(\ref{mymatrix:eq2}).

\subsection{Custom Environments}

Here is an attempt to create a theorem environment via Mako
(for counting theorems) and comment lines to help replacing lines in
the \texttt{.tex} by proper begin-end {\LaTeX} environments for theorems.
Should look nice in most formats!

% begin theorem
\label{theorem:fundamental1}

\paragraph{Theorem 5.}
Let $a=1$ and $b=2$. Then $c=3$.
% end theorem

% begin proof
\paragraph{Proof.}
Since $c=a+b$, the result follows from straightforward addition.
$\Diamond$
% end proof

As we see, the proof of Theorem 5 is a modest
achievement.

\subsection{Tables}
\label{subsec:table}

\index{test index with verbatim text@test index with {\rm\texttt{verbatim text}} which is possible}
\index{test two@test {\rm\texttt{two}} (separate) {\rm\texttt{verbatim expressions}} which is also possible}
\index{index with!subindex}
\index{\textbf{boldface word} in index}
\index{index with \textbf{boldface word}}
\index{index with!\textbf{boldface word} in subentry}
\index{double \textbf{boldface word}! \textbf{boldface word} in subentry too}

% index with comma could fool sphinx
\index{index, with comma, and one more}

Let us take this table from the manual:

\begin{table}
\caption{
Testing table environment in {\LaTeX}, enabled by testing on the "latex" format
with the preprocessor.
\label{mytab}
}


\begin{quote}
\begin{tabular}{lrr}
\hline
\multicolumn{1}{c}{ time } & \multicolumn{1}{c}{ velocity } & \multicolumn{1}{c}{ acceleration } \\
\hline
0.0  & 1.4186   & -5.01        \\
2.0  & 1.376512 & 11.919       \\
4.0  & 1.1E+1   & 14.717624    \\
\hline
\end{tabular}
\end{quote}

\noindent
\end{table}

The DocOnce source code reads
\bccq

  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

\eccq

Here is yet another table to test that we can handle more than
one table:


\begin{quote}
\begin{tabular}{lll}
\hline
\multicolumn{1}{l}{ time } & \multicolumn{1}{l}{ velocity } & \multicolumn{1}{l}{ acceleration } \\
\hline
0.0  & 1.4186   & -5.01        \\
1.0  & 1.376512 & 11.919       \\
3.0  & 1.1E+1   & 14.717624    \\
\hline
\end{tabular}
\end{quote}

\noindent
And one with math headings (that are expanded and must be treated
accordingly), verbatim heading and entry, and no space around the pipe
symbol:


\begin{quote}
\begin{tabular}{lrrr}
\hline
\multicolumn{1}{c}{ $i$ } & \multicolumn{1}{c}{ $h_i$ } & \multicolumn{1}{c}{ $\bar T_i$ } & \multicolumn{1}{c}{ \Verb!L\_i! } \\
\hline
0   & 0      & 288        & -0.0065    \\
1   & 11,000 & 216        & 0.0        \\
2   & 20,000 & 216        & 0.001      \\
3   & 32,000 & 228        & 0.0028     \\
4   & 47,000 & 270        & 0.0        \\
5   & 51,000 & 270        & -0.0028    \\
6   & 71,000 & 214        & \texttt{NaN} \\
\hline
\end{tabular}
\end{quote}

\noindent
And add one with verbatim headings (with underscores),
and rows starting with \texttt{|-} because of a negative number,
and \texttt{|} right before and after verbatim word (with no space):


\begin{quote}
\begin{tabular}{rrrr}
\hline
\multicolumn{1}{c}{ exact } & \multicolumn{1}{c}{ \Verb!v\_1! } & \multicolumn{1}{c}{ $a_i$ + \Verb!v\_2! } & \multicolumn{1}{c}{ \Verb!verb\_3\_! } \\
\hline
9     & 9.62       & 5.57               & 8.98           \\
-20   & -23.39     & -7.65              & -19.93         \\
10    & 17.74      & -4.50              & 9.96           \\
0     & -9.19      & 4.13               & -0.26          \\
\hline
\end{tabular}
\end{quote}

\noindent
Pipe symbols in verbatim and math text in tables used to pose difficulties,
but not
anymore:


\begin{quote}
\begin{tabular}{lr}
\hline
\multicolumn{1}{c}{ $S$ } & \multicolumn{1}{c}{ command } \\
\hline
$ ||a_0|| $ & \texttt{norm|length} \\
$x\cap y$   & \texttt{x|y}         \\
\hline
\end{tabular}
\end{quote}

\noindent
Here is a table with X alignment:


\begin{quote}
\begin{tabularx}{\linewidth}{cX}
\hline
\multicolumn{1}{c}{ Type } & \multicolumn{1}{c}{ Description } \\
\hline
X     & Alignment character that is used for specifying a potentially very long text in a column in a table. It makes use of the \texttt{tabularx} package in {\LaTeX}, otherwise (for other formats) it means \texttt{l} (centered alignment). \\
l,r,c & standard alignment characters                                                                                                                                                                                                       \\
\hline
\end{tabularx}
\end{quote}

\noindent
Finally, a table with math
and URLs.

% Mako code to expand URLs in the table
% (These types of tables did not work before Jan 2014)


\begin{quote}
\begin{tabular}{ccc}
\hline
 \\
\hline
$\mathcal{L}=0$         & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0080.png} & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0085.png} \\
$a=b$                   & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0090.png} & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0095.png} \\
$\nabla\cdot\bm{u} =0 $ & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0100.png} & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0105.png} \\
\hline
\end{tabular}
\end{quote}

\noindent
\subsection{A test of verbatim words in heading with subscript $a_i$: \protect\Verb!my\_file\_v1! and \protect\Verb!my\_file\_v2! }

\paragraph{Paragraph with verbatim and math: \protect\Verb!my\_file\_v1.py! and \protect\Verb!my\_file\_v2.py! define some math $a_{i-1}$.}
Here is more \Verb!__verbatim__! code and
some plain text on a new line.

% Test various types of headlines
\subsection{\textbf{Just bold}}

Some text.

\subsection{\emph{Just emphasize}}

Some text.

\subsection{\texttt{Just verbatim} }

Some text.

\subsection{\textbf{Bold} beginning}

Some text.

\subsection{\emph{Emphasize} beginning}

Some text.

\subsection{\texttt{Verbatim} beginning}

Some text.

\subsection{Maybe \textbf{bold end}}

Some text.

\subsection{Maybe \emph{emphasize end}}

Some text.

\subsection{Maybe \texttt{verbatim end} }

Some text.

\subsection{The middle has \textbf{bold} word}

Some text.

\subsection{The middle has \emph{emphasize} word}

Some text.

\subsection{The middle has \texttt{verbatim} word}

Some text.

\paragraph{\emph{Just emphasize}.}
Some text.

\paragraph{\texttt{Just verbatim}.}
Some text.

\paragraph{\emph{Emphasize} beginning.}
Some text.

\paragraph{\texttt{Verbatim beginning}.}
Some text.

\paragraph{Maybe \emph{emphasize end}.}
Some text.

\paragraph{Maybe \texttt{verbatim end}.}
Some text.

\paragraph{The middle has \emph{emphasize} word.}
Some text.

\paragraph{The middle has \texttt{verbatim} word.}
Some text.

\paragraph{Ampersand.}
We can test Hennes {\&} Mauritz, often abbreviated H{\&}M, but written
as \Verb!Hennes & Mauritz! and \Verb!H & M!.
A sole \Verb!&! must also work.
% Note: substitutions must not occur inside verbatim, just in ordinary text.

\bccq
# Just to check that ampersand works in code blocks:
c = a & b
\eccq

\paragraph{Quotes.}
Let us also add a test of quotes such as ``double quotes, with numbers
like 3.14 and newline/comma and hyphen (as in double-quote)''; written
in the standard LaTeX-style that gives correct {\LaTeX} formatting and
ordinary double quotes for all non-LaTeX formats.  Here is another
sentence that ``caused'' a bug in the past because double backtick
quotes could imply verbatim text up to a verbatim word starting with
period, like \texttt{.txt}.

More quotes to be tested for spellcheck:
(``with parenthesis''), ``with newline''
and ``with comma'', ``hyphen''-wise, and ``period''.

\subsection{Bibliography test}

Here is an example: \cite{Langtangen_Pedersen_2002} discussed propagation of
large destructive water waves, \cite{Langtangen_et_al_2002} gave
an overview of numerical methods for solving the Navier--Stokes equations,
while the use of Backward Kolmogorov equations for analyzing
random vibrations was investigated in \cite{Langtangen_1994a}.
The book chapter \cite{Mardal_et_al_2003a} contains information on
C++ software tools for programming multigrid methods. A real retro
reference is \cite{Langtangen_1988d} about a big FORTRAN package.
Multiple references are also possible, e.g., see
\cite{Langtangen_Pedersen_2002,Mardal_et_al_2003a}.

We need to cite more than 10 papers to reproduce an old formatting
problem with blanks in the keys in reST format:
\cite{Langtangen_1992c,Langtangen_1994a,Mortensen_et_al_2011,Langtangen_Pedersen_2002}
and
\cite{Langtangen_et_al_2002,Glimsdal_et_al_20006,Rahman_et_al_2006b,Haga_et_al_2011a,Langtangen_2003a,Langtangen_2008a,Langtangen:95}
and all the work of
\cite{Langtangen_2012,Mardal_et_al_2003a,Jeberg_et_al_2004} as well as
old work \cite{Langtangen_1988d} and \cite{Langtangen_1989e}, and the
talk \cite{Langtangen_talk_2007a}.
Langtangen also had two thesis \cite{Langtangen:85,Langtangen_1989e}
back in the days.
More retro citations are
the old ME-IN323 book \cite{Langtangen:91} and the
\cite{Langtangen:94b} OONSKI '94 paper.

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Example \thedoconceexercisecounter: Examples can be typeset as exercises}
                             
\label{Example}

Examples can start with a subsection heading starting with \texttt{Example:}
and then, with the command-line option \Verb!--examples_as_exercises! be
typeset as exercises. This is useful if one has solution
environments as part of the example.

\subex{a)}
State some problem.

\paragraph{Solution.}
The answer to this subproblem can be written here.

\subex{b)}
State some other problem.

\paragraph{Hint 1.}
A hint can be given.

\paragraph{Hint 2.}
Maybe even another hint?

\paragraph{Solution.}
The answer to this other subproblem goes here,
maybe over multiple doconce input lines.

\end{doconceexercise}
% --- end exercise ---

\subsection{User-defined environments}

Example~\vref{ex:test:1p1} demonstrates how to write a test function.
That is, a special test function for a function \texttt{add} appears in
Example~\vref{ex:test:1p1}.

\begin{example}
\label{ex:test:1p1}

\noindent\emph{A test function}.

Suppose we want to write a test function for checking the
implementation of a Python function for addition.

\bpycod
def add(a, b):
    return a + b

def test_add():
    a = 1; b = 1
    expected = a + b
    computed = add(a, b)
    assert expected == computed
\epycod
\end{example}

\begin{example}
\label{ex:math:1p1}

\noindent\emph{Addition}.

We have

\[ 1 + 1 = 2 \]
or in tabular form:


\begin{quote}
\begin{tabular}{cc}
\hline
\multicolumn{1}{c}{ Problem } & \multicolumn{1}{c}{ Result } \\
\hline
$1+1$   & $2$    \\
\hline
\end{tabular}
\end{quote}

\noindent
\end{example}

\begin{tcolorbox}[%skin=widget,
boxrule=1mm,
coltitle=black,
colframe=blue!45!white,
colback=blue!15!white,
width=(.9\linewidth),before=\hfill,after=\hfill,
adjusted title={Highlight box!}]
This environment is used to highlight something:

\[ E = mc^2 \]
\end{tcolorbox}

\subsection{URLs}
\label{subsubsec:ex}

Testing of URLs: hpl's home page \href{{https://folk.uio.no/hpl}}{hpl}, or
the entire URL if desired, \href{{https://folk.uio.no/hpl}}{\nolinkurl{https://folk.uio.no/hpl}}.  Here is a
plain file link \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}}, or \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}}, or
\href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}} or \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}} or \href{{testdoc.do.txt}}{a link with
newline}. Can test spaces with the link with word
too: \href{{https://folk.uio.no/hpl}}{hpl} or \href{{https://folk.uio.no/hpl}}{hpl}. Also \texttt{file:///} works: \href{{file:///home/hpl/vc/doconce/doc/demos/manual/manual.html}}{link to a
file} is
fine to have. Moreover, ``loose'' URLs work, i.e., no quotes, just
the plain URL as in \href{{https://folk.uio.no/hpl}}{\nolinkurl{https://folk.uio.no/hpl}}, if followed by space, comma,
colon, semi-colon, question mark, exclamation mark, but not a period
(which gets confused with the periods inside the URL).

Mail addresses can also be used: \href{{mailto:hpl@simula.no}}{\nolinkurl{hpl@simula.no}}, or just a \href{{mailto:hpl@simula.no}}{mail link}, or a raw \href{{mailto:hpl@simula.no}}{\nolinkurl{mailto:hpl@simula.no}}.

Here are some tough tests of URLs, especially for the \texttt{latex} format:
\href{{https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas}}{Newton-Cotes} formulas
and a \href{{https://www.springer.com/mathematics/computational+science+%26+engineering/book/978-3-642-23098-1}}{good book}. Need to test
Newton-Cotes with percentage in URL too:
\href{{https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas}}{\nolinkurl{https://en.wikipedia.org/wiki/Newton\%E2\%80\%93Cotes_formulas}}
and \href{{https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae}}{\nolinkurl{https://en.wikipedia.org/wiki/Newton-Cotes\#Open_Newton.E2.80.93Cotes_formulae}} which has a shebang.

For the \texttt{--device=paper} option it is important to test that URLs with
monospace font link text get a footnote
(unless the \Verb!--latex_no_program_footnotelink!
is used), as in this reference to
\href{{https://github.com/hplgit/INF5620/tree/gh-pages/src/decay/experiments/decay_mod.py}}{\nolinkurl{decay_mod}}, \href{{https://tinyurl.com/pwyasaa/formulas.ball1.py}}{\nolinkurl{ball1.py}},
and \href{{https://tinyurl.com/pwyasaa/formulas.ball2.py}}{\nolinkurl{ball2.py}}.

% Comments should be inserted outside paragraphs (because in the rst
% format extra blanks make a paragraph break).

% Note that when there is no https: or file:, it can be a file link
% if the link name is URL, url, "URL", or "url". Such files should,
% if rst output is desired, but placed in a \Verb!_static*! folder.

More tough tests: repeated URLs whose footnotes when using the
\texttt{--device=paper} option must be correct. We have
\href{{https://google.com}}{google}, \href{{https://google.com}}{google}, and
\href{{https://google.com}}{google}, which should result in exactly three
footnotes.

\subsection{Test of Some {\LaTeX} Fixes}

Let's check abbr.~of some common kind, e.g.~the well-known i.e.
expression as an example, and 1 vs.~2 which is also often used.
Dr.~Tang and Prof.~Monsen, or maybe also prof.~Ting,
will go to the Dept.~of Science to test how Mr.~Hansen is doing together
with Ms.~Larsen. A reference like Sec.~\vref{subsubsec:ex} or
Ch.~\vref{subsubsec:ex}, or even App.~\vref{subsubsec:ex}, must also be
handled. Likewise, this is test no.~$i$ of DocOnce features.
Also, look at Fig.~4 to see how the data compares with Tab.~\vref{mytab}.
Percentage must be fixed: 7\%,  87.65\% and
50\% at the beginning of the line.

% !split and check if these extra words are included properly in the comment

\section{{\LaTeX} Mathematics}

Here is an equation without label using backslash-bracket environment:
\[ a = b + c \]

or with number and label, as in (\ref{my:eq1}), using the equation environment:

\begin{equation}
{\partial u\over\partial t} = \nabla^2 u \label{my:eq1}
\end{equation}

We can refer to this equation by (\ref{my:eq1}).

Here is a system without equation numbers, using the align-asterisk environment:

\begin{align*}
\pmb{a} &= \pmb{q}\times\pmb{n} \\ 
b &= \nabla^2 u + \nabla^4 v
\end{align*}

And here is a system of equations with labels in an align environment:

\begin{align}
a &= q + 4 + 5+ 6 \label{eq1} \\ 
b &= \nabla^2 u + \nabla^4 x \label{eq2}
\end{align}

We can refer to (\ref{eq1})-(\ref{eq2}). They are a bit simpler than
the Navier--Stokes equations. And test {\LaTeX} hyphen in \texttt{CG-2}.
Also test $a_{i-j}$ as well as $kx-wt$.

Testing \texttt{alignat} environment:

\begin{alignat}{2}
a &= q + 4 + 5+ 6\qquad & \mbox{for } q\geq 0 \label{eq1a} \\ 
b &= \nabla^2 u + \nabla^4 x & x\in\Omega \label{eq2a}
\end{alignat}

Many of the next environments will fail in non-latex formats.
Testing multiline:

\begin{multline}
a = b = q + \\ 
  f + \nabla\cdot\nabla u
\label{multiline:eq1}
\end{multline}

Testing split:

\begin{equation}
\label{split:envir:eq}
\begin{split}
a = b = q &+ \\ 
  & f + \nabla\cdot\nabla u
\end{split}
\end{equation}
We can refer to the last equation by (\ref{split:envir:eq}).

Testing gather:
\begin{gather}
a = b \\ 
c = d + 7 + 9
\end{gather}

Let us refer to (\ref{eq1})-(\ref{eq2}) again, and to the
alignat variant (\ref{eq1a})-(\ref{eq2a}), and to (\ref{my:eq1}).

Testing eqnarray:
\begin{eqnarray}
{\partial u\over\partial t} &=& \nabla^2 u + f, \label{myeq1}\\ 
{\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g \label{myeq2}
\end{eqnarray}

More mathematical typesetting is demonstrated in the coming exercises.

Below, we have Problem~\vref{demo:ex:1} and Project~\vref{demo:ex:2},
as well as Projects~\vref{proj:circle1} and~\vref{exer:you}, and in
between there we have Exercise~\vref{exer:some:formula}.

\section{Exercises}

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Problem \thedoconceexercisecounter: Flip a Coin}
                             
\label{demo:ex:1}
% keywords = random numbers; Monte Carlo simulation; ipynb

% Torture tests

\subex{a)}
Make a program that simulates flipping a coin $N$ times.
Print out ``tail'' or ``head'' for each flip and
let the program count the number of heads.

% --- begin hint in exercise ---

\paragraph{Hint 1.}
Use \texttt{r = random.random()} and define head as \texttt{r <= 0.5}.

% --- end hint in exercise ---

% --- begin hint in exercise ---

\paragraph{Hint 2.}
Draw an integer among $\{1,2\}$ with
\texttt{r = random.randint(1,2)} and define head when \texttt{r} is 1.

% --- end hint in exercise ---

% --- begin answer of exercise ---
\paragraph{Answer.}
If the \texttt{random.random()} function returns a number $<1/2$, let it be
head, otherwise tail. Repeat this $N$ number of times.
% --- end answer of exercise ---

% --- begin solution of exercise ---
\paragraph{Solution.}
\bpycod
import sys, random
N = int(sys.argv[1])
heads = 0
for i in range(N):
    r = random.random()
    if r <= 0.5:
        heads += 1
print('Flipping a coin %d times gave %d heads' % (N, heads))
\epycod
% --- end solution of exercise ---

\subex{b)}
Vectorize the code in a) using boolean indexing.

Vectorized code can be written in many ways.
Sometimes the code is less intuitive, sometimes not.
At least there is not much to find in Section~\vref{sec1}.

\subex{c)}
Vectorize the code in a) using \texttt{numpy.sum}.

% --- begin answer of exercise ---
\paragraph{Answer.}
\texttt{np.sum(np.where(r <= 0.5, 1, 0))} or \texttt{np.sum(r <= 0.5)}.
% --- end answer of exercise ---

In this latter subexercise, we have an
example where the code is easy to read.

\paragraph{My remarks.}
Remarks with such a subsubsection is treated as more text
after the last subexercise. Test a list too:

\begin{enumerate}
\item Mark 1.

\item Mark 2.
\end{enumerate}

\noindent
\noindent Filenames: \Verb!flip_coin.py!, \Verb!flip_coin.pdf!.

% Closing remarks for this Problem

\paragraph{Remarks.}
These are the exercise remarks, appearing at the very end.

% solution files: mysol.txt, mysol_flip_coin.py, yet_another.file

\end{doconceexercise}
% --- end exercise ---

\subsection{Not an exercise}

Should be possible to stick a normal section in the middle of many
exercises.

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Exercise \thedoconceexercisecounter: Test of plain text exercise}
                             
\label{my:exer1}

Very short exercise. What is the capital
of Norway?
\noindent Filename: \texttt{myexer1}.

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Project \thedoconceexercisecounter: Compute a Probability}
                             
\label{demo:ex:2}

% Minimalistic exercise

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval $[0,1)$?

At the end we have a list because that caused problems in {\LaTeX}
in previous DocOnce versions:

\begin{enumerate}
\item item1

\item item2
\end{enumerate}

\noindent
% --- begin hint in exercise ---

\paragraph{Hint.}
To answer this question empirically, let a program
draw $N$ such random numbers using Python's standard \texttt{random} module,
count how many of them, $M$, that fall in the interval $(0.5,0.6)$, and
compute the probability as $M/N$.

% --- end hint in exercise ---

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Project \thedoconceexercisecounter: Explore Distributions of Random Circles}
                             
\label{proj:circle1}
% keywords = ipynb

The formula for a circle is given by

\begin{align}
x &= x_0 + R\cos 2\pi t,
\label{circle:x}\\ 
y &= y_0 + R\sin 2\pi t,
\label{circle:y}
\end{align}
where $R$ is the radius of the circle, $(x_0,y_0)$ is the
center point, and $t$ is a parameter in the unit interval $[0,1]$.
For any $t$, $(x,y)$ computed from (\ref{circle:x})-(\ref{circle:y})
is a point on the circle.
The formula can be used to generate \texttt{n} points on a circle:

\bpypro
import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y

x, y = circle(2.0, 0, 0)
\epypro

% Often in an exercise we have some comments about the solution
% which we normally want to keep where they are.

The goal of this project is to draw $N$ circles with random
center and radius. Plot each circle using the \texttt{circle} function
above.

\subex{a)}
Let $R$ be normally distributed and $(x_0,y_0)$ uniformly distributed.

% --- begin hint in exercise ---

\paragraph{Hint.}
Use the \texttt{numpy.random} module to draw the
$x_0$, $y_0$, and $R$ quantities.

% --- end hint in exercise ---

% --- begin answer of exercise ---
\paragraph{Answer.}
Here goes the short answer to part a).
% --- end answer of exercise ---

% --- begin solution of exercise ---
\paragraph{Solution.}
Here goes a full solution to part a).
% --- end solution of exercise ---

\subex{b)}
Let $R$ be uniformly distributed and $(x_0,y_0)$ normally distributed.
\noindent Filename: \texttt{norm}.

\subex{c)}
Let $R$ and $(x_0,y_0)$ be normally distributed.

\noindent Filename: \texttt{circles}.

% Closing remarks for this Project

\paragraph{Remarks.}
At the very end of the exercise it may be appropriate to summarize
and give some perspectives.

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Exercise \thedoconceexercisecounter: Determine some Distance}
                             
\label{exer:dist}

Intro to this exercise. Questions are in subexercises below.

% --- begin solution of exercise ---
\paragraph{Solution.}
Here goes a full solution of the whole exercise.
With some math $a=b$ in this solution:
\[ \hbox{math in solution: } a = b \]
And code \texttt{a=b} in this solution:
\bccq
a = b  # code in solution
\eccq
End of solution is here.

% --- end solution of exercise ---

\subex{a)}
Subexercises are numbered a), b), etc.

% --- begin hint in exercise ---

\paragraph{Hint 1.}
First hint to subexercise a).
With math $a=b$ in hint:

\[ a=b. \]
And with code (in plain verbatim) returning $x+1$ in hint:

\bccq
def func(x):
    return x + 1  # with code in hint
\eccq

% --- end hint in exercise ---

% --- begin hint in exercise ---

\paragraph{Hint 2.}
Second hint to subexercise a).

Test list in hint:

\begin{enumerate}
\item item1

\item item2
\end{enumerate}

\noindent
% --- end hint in exercise ---
\noindent Filename: \Verb!subexer_a.pdf!.

% --- begin answer of exercise ---
\paragraph{Answer.}
Short answer to subexercise a).
With math in answer: $a=b$.
% --- end answer of exercise ---

\subex{b)}
Here goes the text for subexercise b).

Some math $\cos^2 x + \sin^2 x = 1$ written one a single line:

\[ \cos^2 x + \sin^2 x = 1 \thinspace .\]

% --- begin hint in exercise ---

\paragraph{Hint.}
A hint for this subexercise.

% --- end hint in exercise ---
\noindent Filename: \Verb!subexer_b.pdf!.

% --- begin solution of exercise ---
\paragraph{Solution.}
Here goes the solution of this subexercise.
% --- end solution of exercise ---

% No meaning in this weired test example:
The text here belongs to the main (intro) part of the exercise. Need
closing remarks to have text after subexercises.

Test list in exercise:

\begin{enumerate}
\item item1

\item item2
% Closing remarks for this Exercise
\end{enumerate}

\noindent
\paragraph{Remarks.}
Some final closing remarks, e.g., summarizing the main findings
and their implications in other problems can be made. These
remarks will appear at the end of the typeset exercise.

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}

\exercisesection{Some exercise without the "Exercise:" prefix}

% Another minimalistic exercise

Just some text. And some math saying that $e^0=1$ on a single line,
to test that math block insertion is correct:

\[ \exp{(0)} = 1 \]

And a test that the code \texttt{lambda x: x+2} is correctly placed here:

\bccq
lambda x: x+2
\eccq

% Have some comments at the end of the exercise to see that
% the Filename: ... is written correctly.
\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Exercise \thedoconceexercisecounter: Solution of differential equation}
                             
\label{sec:this:exer:de}


\begin{doconcequiz}
\refstepcounter{doconcequizcounter}
\label{quiz:diff:eq1}


\noindent\textbf{\large SOlution of differential equation}

\noindent
Given

\[ \frac{dy}{dx} = -y(x),\quad y(0)=1 \]
What is the solution of this equation?

\vspace{2mm}

\textbf{A}. 
$y=e^{-y}$

\textbf{B}. 
$y=e^{y}$

\textbf{C}. 
\bpycod
from math import exp
def f(x):
    return exp(x)
\epycod

\textbf{D}. 
The solution cannot be found because there is a derivative in the equation.

\textbf{E}. 
The equation is meaningless: an equation must be an equation
for $x$ or $y$, not a function $y(x)$.


% --- begin answer of exercise ---
\paragraph{Answer:} A.
% --- end answer of exercise ---

% --- begin solution of exercise ---
\noindent {\bf Solution:}\\


\textbf{A}: Right. 

\textbf{B}: Wrong. Almost, but the sign is wrong (note the minus!).

\textbf{C}: Wrong. Ooops, forgot a minus: \texttt{exp(-x)}, otherwise this Python code
must be considered as a good answer. It is more natural,
though, to write the solution to the problem
in mathematical notation:

\[ y(x) = e^{-y}.\]

\textbf{D}: Wrong. Equations with derivatives can be solved;
they are termed \emph{differential
equations}.

\textbf{E}: Wrong. Equations where the unknown is a function, as $y(x)$
here, are called \emph{differential equations}, and are solved by
special techniques.


% --- end solution of exercise ---


\vspace{3mm}

\end{doconcequiz}



\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Example \thedoconceexercisecounter: Just an example}
                             

% This example needs the --examples_as_exercises option, otherwise
% it is just typeset as it is written.

\subex{a)}
What is the capital of Norway?

\paragraph{Answer.}
Oslo.

\end{doconceexercise}
% --- end exercise ---

\section{Here goes another section}

With some text, before we continue with exercises.

\section{More Exercises}

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Exercise \thedoconceexercisecounter: Make references to projects and problems}
                             
\label{exer:some:formula}

% Test comments not at the end only
Pick a statement from Project~\vref{proj:circle1} or Problem~\vref{demo:ex:1}
and verify it.

Test list at the end of an exercise without other elements (like subexercise,
hint, etc.):

\begin{enumerate}
\item item1

\item item2
\end{enumerate}

\noindent
\noindent Filename: \Verb!verify_formula.py!.

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Project \thedoconceexercisecounter: References to Project~\vref{demo:ex:2} in a heading works for latex}
                             
\label{exer:you}

Refer to the previous exercise as Exercise~\vref{exer:some:formula},
the two before that as Projects~\vref{demo:ex:2} and~\vref{proj:circle1},
and this one as Project~\vref{exer:you}.
\noindent Filename: \Verb!selc_composed.pdf!.

\end{doconceexercise}
% --- end exercise ---

\bibliographystyle{plain}
\bibliography{papers}



\appendix

\section{Just for testing; part I}
\label{app1}

This is the first appendix.

\subsection{A subsection within an appendix}

Some text.

\section{Just for testing; part II}
\label{app2}

This is more stuff for an appendix.

\subsection{Appendix: Testing identical titles}

Without label.

\subsection{Appendix: Testing identical titles}
\label{test:title:id1}

With label.

\subsection{Appendix: Testing identical titles}
\label{test:title:id2}

What about inserting a quiz?


\begin{doconcequiz}
\refstepcounter{doconcequizcounter}
\label{quiz:2}


\noindent\textbf{\large Capital of Norway}
\paragraph{Fundamental test:}
What is the capital of Norway?

\vspace{2mm}

\textbf{A}. 
Stockholm

\textbf{B}. 
London

\textbf{C}. 
Oslo

\textbf{D}. 
Bergen


% --- begin answer of exercise ---
\paragraph{Answer:} C.
% --- end answer of exercise ---

% --- begin solution of exercise ---
\noindent {\bf Solution:}\\


\textbf{A}: Wrong. Stockholm is the capital of Sweden.

\textbf{B}: Wrong. 

\textbf{C}: Right. 

\textbf{D}: Wrong. Those from Bergen would claim so, but nobody else.


% --- end solution of exercise ---


\vspace{3mm}

\end{doconcequiz}



\subsection{Appendix: Testing identical titles}

Without label.


\begin{notice_mdfboxadmon}[Tip.]
Here is a tip or hint box, typeset as a notice box.
\end{notice_mdfboxadmon} % title: Tip.



\clearpage

Need a lot of text to surround the summary box.
Version control systems allow you to record the history of files
and share files among several computers and collaborators in a
professional way. File changes on one computer are updated or
merged with changes on another computer. Especially when working
with programs or technical reports it is essential
to have changes documented and to
ensure that every computer and person involved in the project
have the latest updates of the files.
Greg Wilson' excellent \href{{https://software-carpentry.org/2010/07/script-for-introduction-to-version-control/}}{Script for Introduction to Version Control} provides a more detailed motivation why you will benefit greatly
from using version control systems.


\begin{summary_mdfboxadmon}[Summary.]
\textbf{Bold remark:} Make some text with this summary.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
\end{summary_mdfboxadmon} % title: Summary.



Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that site. I strongly
recommend you to use such sites for all serious programming and
scientific writing work - and all other important files.

The simplest services for hosting project files are \href{{https://dropbox.com}}{Dropbox} and \href{{https://drive.google.com}}{Google Drive}.
It is very easy to get started with these systems, and they allow you
to share files among laptops and mobile units with as many users as
you want. The systems offer a kind of version control in that the
files are stored frequently (several times per minute), and you can go
back to previous versions for the last 30 days. However, it is
challenging  to find the right version from the past when there are
so many of them.

More seriously, when several people may edit files simultaneously, it
can be difficult detect who did what when, roll back to previous
versions, and to manually merge the edits when these are
incompatible. Then one needs more sophisticated tools than Dropbox or
Google Drive: project hosting services with true version control
systems.  The following text aims at providing you with the minimum
information to started with such systems. Numerous other tutorials
contain more comprehensive material and in-depth explanations of the
concepts and tools.

The idea with project hosting services is that you have the files
associated with a project in the cloud. Many people may share these
files.  Every time you want to work on the project you explicitly
update your version of the files, edit the files as you like, and
synchronize the files with the "master version" at the site where the
project is hosted.  If you at some point need to go back to a
version of the files at some particular point in the past,
this is an easy operation. You can also use tools to see
what various people have done with the files in the various versions.

All these services are very similar. Below we describe how you get
started with Bitbucket, GitHub, and Googlecode. Launchpad works very
similarly to the latter three. All the project hosting services have
excellent introductions available at their web sites, but the recipes
below are much shorter and aim at getting you started as quickly as
possible by concentrating on the most important need-to-know steps.
The Git tutorials we refer to later in this document contain more
detailed information and constitute of course very valuable readings
when you use version control systems every day. The point now is
to get started.

\subsection{Appendix: Testing inline comments}

% Names can be [ A-Za-z0-9_'+-]+

Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that
site. \shortinlinecomment{hpl's semi opinion 1}{ not sure if in the cloud is understood by all. }{ not sure if in } I strongly recommend you to use such sites for all serious
programming and scientific writing work - and all other important
files.

The simplest services for hosting project files is Dropbox. \longinlinecomment{mp 2}{ Simply go to \href{{https://dropbox.com}}{\nolinkurl{https://dropbox.com}} and watch the video. It explains how files, like \texttt{myfile.py}, perhaps containing much math, like $\partial u/\partial t$, are easily communicated between machines. }{ Simply go to \href{{https://dropbox.com}}{\nolinkurl{https://dropbox.com}} } It
is very easy to get started with Dropbox, and it allows you to share
files among \textcolor{red}{(hpl 3:)} \replace{laptops and mobile units}{computers, tablets, and phones}.

% Test horizontal rule

------

% Coments for editing

First\textcolor{red}{, (\textbf{edit 4}: add comma)} consider a quantity $Q$. \textcolor{red}{(edit 5:)} \replace{To this end,}{We note that}
$Q>0$, because (\textbf{edit 6}:) \remove{a} negative \textcolor{red}{(edit 7:)} \replace{quantity is}{quantities are} (\textbf{edit 8}:) \remove{just} negative.  \textcolor{red}{ (\textbf{edit 9}:) This comes as no surprise.}

% Test tailored latex figure references with page number
Let us refer to Figure~\vref{fig:impact} again.

Test references in a list:

\begin{itemize}
 \item \vref{sec1}

 \item \vref{subsec1}

 \item \vref{fig:impact}
\end{itemize}

\noindent
\subsection{Appendix: Testing headings ending with \texttt{verbatim inline} }

The point here is to test 1) \texttt{verbatim} code in headings, and 2)
ending a heading with verbatim code as this triggers a special
case in {\LaTeX}.

We also test mdash---used as alternative to hyphen without spaces around,
or in quotes:


\begin{quote}
\emph{Fun is fun}.---Unknown.
\end{quote}


The ndash should also be tested -- as in the Hanson--Nilson equations
on page 277--278.

And finally, what about admons, quotes, and boxes? They are tested
in a separate document: \texttt{admon.do.txt}.


% ------------------- end of main content ---------------

% #ifdef PREAMBLE
\cleardoublepage\phantomsection  % trick to get correct link to Index
\printindex

\end{document}
% #endif

************** File: testdoc_bigex.tex *****************
%%
%% Automatically generated file from DocOnce source
%% (https://github.com/doconce/doconce/)
%%

% #define PREAMBLE

% #ifdef PREAMBLE
%-------------------- begin preamble ----------------------

\documentclass[%
oneside,                 % oneside: electronic viewing, twoside: printing
final,                   % draft: marks overfull hboxes, figures with paths
10pt]{article}

\listfiles               %  print all files needed to compile this document

\usepackage{relsize,makeidx,color,setspace,amsmath,amsfonts,amssymb}
\usepackage[table]{xcolor}
\usepackage{bm,ltablex,microtype}

\usepackage[pdftex]{graphicx}
\usepackage{sidecap}

% user-provided packages: --latex_packages=varioref
\usepackage{varioref}

% 'on page ...' reference with \vref{} and varioref package
\renewcommand\reftextfaceafter{on page~\thevpagerefnum}
\renewcommand\reftextfacebefore{on page~\thevpagerefnum}
\renewcommand\reftextafter{on page~\thevpagerefnum}
\renewcommand\reftextbefore{on page~\thevpagerefnum}

% Tools for marking corrections
\usepackage{soul}
\newcommand{\replace}[2]{{\color{red}\text{\st{#1} #2}}}
\newcommand{\remove}[1]{{\color{red}\st{#1}}}

% Packages for typesetting blocks of computer code
\usepackage{fancyvrb,framed,moreverb}

% Define colors
\definecolor{orange}{cmyk}{0,0.4,0.8,0.2}
\definecolor{tucorange}{rgb}{1.0,0.64,0}
\definecolor{darkorange}{rgb}{.71,0.21,0.01}
\definecolor{darkgreen}{rgb}{.12,.54,.11}
\definecolor{myteal}{rgb}{.26, .44, .56}
\definecolor{gray}{gray}{0.45}
\definecolor{mediumgray}{gray}{.8}
\definecolor{lightgray}{gray}{.95}
\definecolor{brown}{rgb}{0.54,0.27,0.07}
\definecolor{purple}{rgb}{0.5,0.0,0.5}
\definecolor{darkgray}{gray}{0.25}
\definecolor{darkblue}{rgb}{0,0.08,0.45}
\definecolor{darkblue2}{rgb}{0,0,0.8}
\definecolor{lightred}{rgb}{1.0,0.39,0.28}
\definecolor{lightgreen}{rgb}{0.48,0.99,0.0}
\definecolor{lightblue}{rgb}{0.53,0.81,0.92}
\definecolor{lightblue2}{rgb}{0.3,0.3,1.0}
\definecolor{lightpurple}{rgb}{0.87,0.63,0.87}
\definecolor{lightcyan}{rgb}{0.5,1.0,0.83}

\colorlet{comment_green}{green!50!black}
\colorlet{string_red}{red!60!black}
\colorlet{keyword_pink}{magenta!70!black}
\colorlet{indendifier_green}{green!70!white}

% Backgrounds for code
\definecolor{cbg_gray}{rgb}{.95, .95, .95}
\definecolor{bar_gray}{rgb}{.92, .92, .92}

\definecolor{cbg_yellowgray}{rgb}{.95, .95, .85}
\definecolor{bar_yellowgray}{rgb}{.95, .95, .65}

\colorlet{cbg_yellow2}{yellow!10}
\colorlet{bar_yellow2}{yellow!20}

\definecolor{cbg_yellow1}{rgb}{.98, .98, 0.8}
\definecolor{bar_yellow1}{rgb}{.98, .98, 0.4}

\definecolor{cbg_red1}{rgb}{1, 0.85, 0.85}
\definecolor{bar_red1}{rgb}{1, 0.75, 0.85}

\definecolor{cbg_blue1}{rgb}{0.87843, 0.95686, 1.0}
\definecolor{bar_blue1}{rgb}{0.7,     0.95686, 1}

%\setlength{\fboxsep}{2mm}  % adjust cod_vpad/pro_vpad background box

%% Background for code blocks (parameter is color name)

%% pro/cod_vpad: gives some vertical padding before and after the text
%% (but has more simplistic code than _cod/pro_tight+cod/pro).
%% pro/cod_vpad can be used to enclose Verbatim or lst begin/end for code.
%% pro/cod calls _pro/cod_tight and has very little vertical padding,
%% used to enclose Verbatim and other begin/end for code.
%% (pro/cod is what the ptex2tex program could produce with the
%% Blue/BlueBar definitions in .ptex2tex.cfg.)

\newenvironment{cod_vpad}[1]{
   \def\FrameCommand{\colorbox{#1}}
   \MakeFramed{\FrameRestore}}
   {\endMakeFramed}

\newenvironment{_cod_tight}[1]{
   \def\FrameCommand{\colorbox{#1}}
   \FrameRule0.6pt\MakeFramed {\FrameRestore}\vskip3mm}
   {\vskip0mm\endMakeFramed}

\newenvironment{cod}[1]{
\bgroup\rmfamily
\fboxsep=0mm\relax
\begin{_cod_tight}{#1}
\list{}{\parsep=-2mm\parskip=0mm\topsep=0pt\leftmargin=2mm
\rightmargin=2\leftmargin\leftmargin=4pt\relax}
\item\relax}
{\endlist\end{_cod_tight}\egroup}

%% Background for complete program blocks (parameter 1 is color name
%% for background, parameter 2 is color for left bar)
\newenvironment{pro_vpad}[2]{
   \def\FrameCommand{\color{#2}\vrule width 1mm\normalcolor\colorbox{#1}}
   \MakeFramed{\FrameRestore}}
   {\endMakeFramed}

\newenvironment{_pro_tight}[2]{
   \def\FrameCommand{\color{#2}\vrule width 1mm\normalcolor\colorbox{#1}}
   \FrameRule0.6pt\MakeFramed {\advance\hsize-2mm\FrameRestore}\vskip3mm}
   {\vskip0mm\endMakeFramed}

\newenvironment{pro}[2]{
\bgroup\rmfamily
\fboxsep=0mm\relax
\begin{_pro_tight}{#1}{#2}
\list{}{\parsep=-2mm\parskip=0mm\topsep=0pt\leftmargin=2mm
\rightmargin=2\leftmargin\leftmargin=4pt\relax}
\item\relax}
{\endlist\end{_pro_tight}\egroup}

\usepackage{listingsutf8}

% Common lstlisting parameters

\usepackage{calc}
\newlength{\lstboxwidth}  % width of lst box
\newlength{\framethickness}
\setlength{\framethickness}{0.5mm}
% for frame=trbl and a framerule that has significant size, set
% xleftmargin=5mm and xrightmargin=5mm.

\lstset{
  basicstyle=\small \ttfamily,
  breaklines=false,          % break/wrap lines
  breakatwhitespace=true,    % let linebreaks happen at whitespace
  breakindent=40pt,
  tab=,
  tabsize=4,                 % tab means 4 spaces
  %belowskip=\smallskipamount,  % space between code and text below
  xleftmargin=2mm,           % indentation of code frame
  xrightmargin=0mm,
  framexleftmargin=2mm,      % add frame space to the left of the code box
  %numbers=left,             % put line numbers on the left
  %stepnumber=2,             % stepnumber=1 numbers each line, =n every n lines
  framerule=\framethickness, % thickness of frame
  aboveskip=2ex,             % vertical space above code frame
  showstringspaces=false,    % show spaces in strings with an underscore
  showspaces=false,          % show spaces with an underscore
  showtabs=false,
  keepspaces=true,
  columns=fullflexible,      % tighter character kerning, like verb
  escapeinside={(*@}{@*)},   % (*@ \pause @*) in slides and math in code blocks
  extendedchars=\true,       % allows non-ascii chars, does not work with utf-8
}

% Internally defined styles for lstlisting

\lstdefinestyle{simple}{
commentstyle={},
}

% user-defined lst styles in file "mylststyles":
\lstdefinestyle{myspeciallststyle}{
keywordstyle=\color{blue}\bfseries,
commentstyle=\color{myteal},
stringstyle=\color{darkgreen},
identifierstyle=\color{darkorange},
}

% end of custom lstdefinestyles

\usepackage[T1]{fontenc}
%\usepackage[latin1]{inputenc}
\usepackage{ucs}
\usepackage[utf8x]{inputenc}

\usepackage{lmodern}         % Latin Modern fonts derived from Computer Modern

\newenvironment{doconcequiz}{}{}
\newcounter{doconcequizcounter}

% Hyperlinks in PDF:
\definecolor{linkcolor}{rgb}{0,0,0.4}
\usepackage{hyperref}
\hypersetup{
    breaklinks=true,
    colorlinks=true,
    linkcolor=linkcolor,
    urlcolor=linkcolor,
    citecolor=black,
    filecolor=black,
    %filecolor=blue,
    pdfmenubar=true,
    pdftoolbar=true,
    bookmarksdepth=3   % Uncomment (and tweak) for PDF bookmarks with more levels than the TOC
    }
%\hyperbaseurl{}   % hyperlinks are relative to this root

\setcounter{tocdepth}{2}  % levels in table of contents

%\VerbatimFootnotes must come after hyperref and footmisc packages
\VerbatimFootnotes

% Tricks for having figures close to where they are defined:
% 1. define less restrictive rules for where to put figures
\setcounter{topnumber}{2}
\setcounter{bottomnumber}{2}
\setcounter{totalnumber}{4}
\renewcommand{\topfraction}{0.95}
\renewcommand{\bottomfraction}{0.95}
\renewcommand{\textfraction}{0}
\renewcommand{\floatpagefraction}{0.75}
% floatpagefraction must always be less than topfraction!
% 2. ensure all figures are flushed before next section
\usepackage[section]{placeins}
% 3. enable begin{figure}[H] (often leads to ugly pagebreaks)
%\usepackage{float}\restylefloat{figure}

% newcommands for typesetting inline (doconce) comments
\newcommand{\shortinlinecomment}[3]{{\color{red}{\bf #1}: #2}}
\newcommand{\longinlinecomment}[3]{{\color{red}{\bf #1}: #2}}

\usepackage[framemethod=TikZ]{mdframed}

% --- begin definitions of admonition environments ---

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "notice" admon
\colorlet{mdfbox_notice_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_notice_background,
  linecolor=black,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=mdfbox_notice_background,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{notice_mdfboxmdframed}

\newenvironment{notice_mdfboxadmon}[1][]{
\begin{notice_mdfboxmdframed}[frametitle=#1]
}
{
\end{notice_mdfboxmdframed}
}

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "summary" admon
\colorlet{mdfbox_summary_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_summary_background,
  linecolor=black,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=mdfbox_summary_background,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{summary_mdfboxmdframed}

\newenvironment{summary_mdfboxadmon}[1][]{
\begin{summary_mdfboxmdframed}[frametitle=#1]
}
{
\end{summary_mdfboxmdframed}
}

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "warning" admon
\colorlet{mdfbox_warning_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_warning_background,
  linecolor=black,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=mdfbox_warning_background,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{warning_mdfboxmdframed}

\newenvironment{warning_mdfboxadmon}[1][]{
\begin{warning_mdfboxmdframed}[frametitle=#1]
}
{
\end{warning_mdfboxmdframed}
}

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "question" admon
\colorlet{mdfbox_question_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_question_background,
  linecolor=black,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=mdfbox_question_background,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{question_mdfboxmdframed}

\newenvironment{question_mdfboxadmon}[1][]{
\begin{question_mdfboxmdframed}[frametitle=#1]
}
{
\end{question_mdfboxmdframed}
}

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "block" admon
\colorlet{mdfbox_block_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_block_background,
  linecolor=black,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=mdfbox_block_background,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{block_mdfboxmdframed}

\newenvironment{block_mdfboxadmon}[1][]{
\begin{block_mdfboxmdframed}[frametitle=#1]
}
{
\end{block_mdfboxmdframed}
}

% --- end of definitions of admonition environments ---

% prevent orhpans and widows
\clubpenalty = 10000
\widowpenalty = 10000

\usepackage{calc}

\newenvironment{doconceexercise}{}{}
\newcounter{doconceexercisecounter}
% --- begin definition of \listofexercises command ---
\makeatletter
\newcommand\listofexercises{\section*{List of Examples, Exercises, Problems, and Projects}
\@starttoc{loe}
}
\newcommand*{\l@doconceexercise}{\@dottedtocline{0}{0pt}{6.5em}}
\makeatother
% --- end definition of \listofexercises command ---



% ------ header in subexercises ------
%\newcommand{\subex}[1]{\paragraph{#1}}
%\newcommand{\subex}[1]{\par\vspace{1.7mm}\noindent{\bf #1}\ \ }
\makeatletter
% 1.5ex is the spacing above the header, 0.5em the spacing after subex title
\newcommand\subex{\@startsection{paragraph}{4}{\z@}%
                  {1.5ex\@plus1ex \@minus.2ex}%
                  {-0.5em}%
                  {\normalfont\normalsize\bfseries}}
\makeatother


% --- end of standard preamble for documents ---


\usepackage{amsthm,tcolorbox}
\theoremstyle{definition}
\newtheorem{example}{Example}[section]



% insert custom LaTeX commands...

\raggedbottom
\makeindex
\usepackage[totoc]{idxlayout}   % for index in the toc
\usepackage[nottoc]{tocbibind}  % for references/bibliography in the toc

%-------------------- end preamble ----------------------

\begin{document}

% matching end for #ifdef PREAMBLE
% #endif

\newcommand{\exercisesection}[1]{\subsection*{#1}}

\input{newcommands_bfmath}
\input{newcommands_replace}

% ------------------- main content ----------------------



% ----------------- title -------------------------

\thispagestyle{empty}

\begin{center}
{\LARGE\bf
\begin{spacing}{1.25}
A Document for Testing DocOnce
\end{spacing}
}
\end{center}

% ----------------- author(s) -------------------------

\begin{center}
{\bf Hans Petter Langtangen${}^{1, 2}$ (\texttt{hpl@simula.no})} \\ [0mm]
\end{center}


\begin{center}
{\bf Kaare Dump${}^{3}$} \\ [0mm]
\end{center}


\begin{center}
{\bf A. Dummy Author${}^{}$} \\ [0mm]
\end{center}


\begin{center}
{\bf I. S. Overworked and Outburned${}^{4, 5, 6, 7}$} \\ [0mm]
\end{center}


\begin{center}
{\bf J. Doe${}^{}$ (\texttt{j\_doe@cyberspace.com})} \\ [0mm]
\end{center}

\begin{center}
% List of all institutions:
\centerline{{\small ${}^1$Center for Biomedical Computing, Simula Research Laboratory}}
\centerline{{\small ${}^2$Department of Informatics, University of Oslo}}
\centerline{{\small ${}^3$Segfault, Cyberspace}}
\centerline{{\small ${}^4$Inst1}}
\centerline{{\small ${}^5$Inst2, Somewhere}}
\centerline{{\small ${}^6$Third Inst, Elsewhere}}
\centerline{{\small ${}^7$Fourth Inst}}
\end{center}
    
% ----------------- end author(s) -------------------------

% --- begin date ---
\begin{center}
Jan 32, 2100
\end{center}
% --- end date ---

\vspace{1cm}


\tableofcontents

\vspace{1cm} % after toc

% !split

The format of this document is
plain, homemade \textsc{pdf}{\LaTeX} (from DocOnce).

\begin{abstract}
This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.

% Cannot demonstrate chapter headings since abstract and chapter
% are mutually exclusive in {\LaTeX}
\end{abstract}

\section{Section 1}
\label{sec1}

Here is a nested list:

\begin{itemize}
  \item item1

  \item item2

  \item item3 which continues
    on the next line to test that feature

  \item and a sublist
\begin{itemize}

    \item with indented subitem1

    \item and a subitem2

\end{itemize}

\noindent
  \item and perhaps an ordered sublist
\begin{enumerate}

   \item first item

   \item second item,
      continuing on a new line
\end{enumerate}

\noindent
\end{itemize}

\noindent
\paragraph{Here is a list with paragraph heading.}

\begin{itemize}
  \item item1

  \item item2
\end{itemize}

\noindent
\paragraph{Here is a list with subsubsection heading.}
\begin{itemize}
  \item item1

  \item item2
\end{itemize}

\noindent

\begin{quote}
Here are two lines that make up
a block quote for testing \emph{emphasized words} and \textbf{boldface words},
also with hypens:
\emph{pre}-fix, post-\emph{fix}, \textbf{pre}-fix, post-\textbf{fix}.
\end{quote}


Here are two references. Equation~(\ref{my:eq1}) is fine. Eq.~(\ref{my:eq1}) too.
Even Equation (\ref{my:eq1}) without the tilde.

\subsection{Subsection 1}
\label{subsec1}

\index{somefunc@{\rm\texttt{somefunc}} function}

% Refer to section/appendix etc. at the beginning of the line
% and other special fix situations for HTML.

More text, with a reference back to
Section~\vref{sec1} and~\vref{subsec1}, and further to the
sections~\vref{subsec1} and~\vref{subsubsec:ex}, which
encourages you to do the tasks in the
Exercises~\vref{demo:ex:1} and~\vref{exer:some:formula}.
Appendices~\vref{app1} and~\vref{app2} are also nice elements.

\paragraph{Test Section reference at beginning of line and after a sentence.}
Section~\vref{subsec1} is fine.
Section~\vref{subsubsec:ex} too.

% sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console

\paragraph{Computer code.}
Let's do some copying from files too. First from subroutine up to the very end,

\begin{cod}{cbg_gray}\begin{Verbatim}[numbers=none,fontsize=\fontsize{9pt}{9pt},baselinestretch=0.95,xleftmargin=2mm]
      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
\end{Verbatim}
\end{cod}
\noindent
and then just the subroutine,
\begin{cod}{cbg_gray}\begin{Verbatim}[numbers=none,fontsize=\fontsize{9pt}{9pt},baselinestretch=0.95,xleftmargin=2mm]

      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
\end{Verbatim}
\end{cod}
\noindent
and finally the complete file with a plain text verbatim environment
(\texttt{envir=ccq}):
\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
C     a comment

      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
\end{lstlisting}\end{cod}
\noindent

Testing other code environments. First Python:

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
!bc pycod
def f(x):
    return x+1
!ec
\end{lstlisting}\end{cod}
\noindent
which gets rendered as

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
def f(x):
    return x+1
\end{lstlisting}\end{cod}
\noindent

Test paragraph and subsubsection headings before
before code.

\paragraph{Paragraph heading before code.}

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
import sys
sys.path.insert(0, os.pardir)
\end{lstlisting}\end{cod}
\noindent

\paragraph{Subsubsection heading before code.}
\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
def h(z):
    return z+1
\end{lstlisting}\end{cod}
\noindent

Now a complete program to be shown via Python Online Tutorial:

\begin{pro}{cbg_blue1}{bar_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
class Line:
    def __init__(self, a, b):
        self.a, self.b = a, b

    def __call__(self, x):
        a, b = self.a, self.b
        return a*x + b

line = Line(2, 1)
y = line(x=3)
print(y)
\end{lstlisting}\end{pro}
\noindent
\noindent
(\href{{https://pythontutor.com/visualize.html\#code=class+Line\%3A\%0A++++def+__init__\%28self\%2C+a\%2C+b\%29\%3A\%0A++++++++self.a\%2C+self.b+\%3D+a\%2C+b\%0A\%0A++++def+__call__\%28self\%2C+x\%29\%3A\%0A++++++++a\%2C+b+\%3D+self.a\%2C+self.b\%0A++++++++return+a\%2Ax+\%2B+b\%0A\%0Aline+\%3D+Line\%282\%2C+1\%29\%0Ay+\%3D+line\%28x\%3D3\%29\%0Aprint\%28y\%29&mode=display&cumulative=false&heapPrimitives=false&drawParentPointers=false&textReferences=false&py=2&curInstr=0}}{Visualize execution}) 


Some more Python code (actually specified as a sage cell, but
such cells are not supported by this format).

\begin{pro}{cbg_blue1}{bar_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
a = 2
b = 3
print('a+b:', a + b)

# In a sage cell we can also plot
from matplotlib.pyplot import *
from numpy import *
x = linspace(0, 4*pi, 101)
y = exp(-0.1*x)*cos(x)
plot(x, y)
xlabel('x'); ylabel('y')
show()
\end{lstlisting}\end{pro}
\noindent

Then Cython (with -h option so it is hidden in html/sphinx):

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
cpdef f(double x):
    return x + 1
\end{lstlisting}\end{cod}
\noindent

Standard Python shell sessions:

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
\end{lstlisting}\end{cod}
\noindent

Similar IPython sessions:

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
In [1]: from numpy import linspace, sin
In [2]: # Some comment
In [3]: x = linspace(0, 2, 11)
In [4]: y = sin(x)
In [5]: y[0]
Out[5]: 0
In [6]: import matplotlib.pyplot as plt
In [7]: plt.plot(x, y)
In [8]: a='multiple-\nline\noutput'
In [9]: a
Out[9]: 'multiple-\nline\noutput'
In [10]: print(a)
multiple-
line
output
\end{lstlisting}\end{cod}
\noindent

Here is the interactive session again, but with \texttt{pyshell-t}.

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
\end{lstlisting}\end{cod}
\noindent

% This one tests a + sign before a code environment
C++:
\begin{pro}{cbg_blue1}{bar_blue1}\begin{lstlisting}[language=C++,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
#include <iostream>

int main()
{
   std::cout << "Sample output" << std::endl;
   return 0
}
\end{lstlisting}\end{pro}
\noindent
% The next should get correctly typset in sphinx (cod is fcod)
% It also tests emoji before code
And a little bit of Fortran: \raisebox{-\height+\ht\strutbox}{\includegraphics[height=1.5em]{latex_figs/dizzy_face.png}}

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
!bc cod
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
!ec
\end{lstlisting}\end{cod}
\noindent
which then is typeset as

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
\end{lstlisting}\end{cod}
\noindent

HTML:

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=HTML,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
<table>
<tr><td>Column 1</td><td>Column 2</td></tr>
<tr><td>0.67526 </td><td>0.92871 </td></tr>
<!-- comment -->
</table>
\end{lstlisting}\end{cod}
\noindent

But inline HTML code is also important, like text that starts with
\texttt{<a href="} (which can destroy the following text if not properly
quoted).

Matlab with comments requires special typesetting:

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Matlab,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
% Comment on the beginning of the line can be escaped by %%
if a > b
  % Indented comment needs this trick
  c = a + b
end
\end{lstlisting}\end{cod}
\noindent

And here is a system call:

\begin{Verbatim}[frame=lines,label=\fbox{{\tiny Terminal}},framesep=2.5mm,framerule=0.7pt]
Terminal> mkdir test
Terminal> cd test
Terminal> myprog -f
output1
output2
\end{Verbatim}

Any valid pygments lexer/language name can appear to, e.g.,

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
!bc restructuredtext
=======
Heading
=======

Some text.
!ec
\end{lstlisting}\end{cod}
\noindent
results in

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
=======
Heading
=======

Some text.
\end{lstlisting}\end{cod}
\noindent

% Here goes hidden code.
% Python can be treated by some formats, Fortran is always out.





Finally, \Verb?!bc do? supports highlighting of DocOnce source:

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
======= DocOnce test file =======

===== Computer code =====

Inline verbatim code, as in `import numpy as np`, is allowed, as well as
code blocks:

!bc pycod
from math import sin

def f(x):
    """Example on a function."""
    return sin(x) + 1

print(f(0))
!ec


===== Mathematics =====

Formulas can be inline, as in $\nabla\cdot\bm{u} = 0$, or typeset
as equations:

!bt
\begin{align*}
\nabla\cdot\bm{u} &= 0,\\ 
\bm{u} &= \nabla\phi .
\end{align*}
!et

=== Subsubsection heading ===

DocOnce files can have chapters, sections, subsections, and subsubsections.

__Paragraph heading.__ Paragraphs may have headings.
\end{lstlisting}\end{cod}
\noindent

It is time to test \texttt{verbatim inline font} especially with \texttt{a newline inside the text} and an exclamation mark at the end: \texttt{BEGIN}! For
spellcheck, test \texttt{a verbatim expression} in \texttt{another} in a \texttt{third}.
Also test exclamation mark as in \Verb?!bc? and \Verb?!ec? as well as \Verb?a != b?.
Also test backslashes and braces like \Verb!\begin!, \Verb!\begin{enumerate}!,
\Verb!\end{this}\end{that}!, and \Verb!{something \inside braces}!.

Here is some \textcolor{red}{red color} and an attempt to write \textcolor{green}{with
green color containing a linebreak\\
code.} Some formats will only display \\
this correctly when \texttt{html} \\
is the output format.
But here some more running text is added which is not part of
the previous blocks with line breaks.

\paragraph{Running OS commands.}
\begin{Verbatim}[frame=lines,label=\fbox{{\tiny Terminal}},framesep=2.5mm,framerule=0.7pt]
Terminal> python -c 'print("Testing\noutput\nfrom\nPython.")'
Testing
output
from
Python.
\end{Verbatim}

\paragraph{Footnotes.}
Here is a test of footnotes \footnote{Typesetting of the footnote depends on the format. Plain text does nothing, {\LaTeX} removes the definition and inserts the footnote as part of the {\LaTeX} text. reStructuredText and Sphinx employ a similar type of typesetting as Extended Markdown and DocOnce, and in HTML we keep the same syntax, just displayed properly in HTML.}, which are handy in text.
They are used in different flavors, now in

\begin{itemize}
 \item list items (note below that footnotes work after math, verbatim, and URLs - bin fact old and emphasize too!)

 \item even with math $\nabla^2u$\footnote{Math footnotes can be dangerous since it interferes with an exponent.}

 \item and code \texttt{h[i] += 1}\footnote{One-line footnote.}
   (\emph{must} have space between inline code and footnote!)

 \item and \href{{https://google.com}}{links}\footnote{\href{{google.com}}{\nolinkurl{google.com}} is perhaps the most famous web site today.}
\end{itemize}

\noindent
which gives flexibility in writing.
This is the third\footnote{Not much to add here, but the footnote is at the end with only one newline.} example.

Here is some more text before a new definition of a footnote that was
used above.


\begin{notice_mdfboxadmon}[Non-breaking space character.]
This paragraph aims to test \href{{https://en.wikipedia.org/wiki/Non-breaking_space}}{non-breaking space character}, and a typical
example where this is needed is in physical units: 7.4~km is traveled
in~$7.4/5.5\approx 1.345$~s.  Also check that a~\href{{https://google.com}}{link}~is
not broken across lines (drag the browser window to test this).
(On the other hand, the tilde is used in
computer code, e.g., as in \texttt{[~x for x in y]} or in \texttt{y=~x}, and should
of course remain a tilde in those contexts.)
\end{notice_mdfboxadmon} % title: Non-breaking space character.



\subsection{Subsection 2: Testing figures}
\label{subsec:ex}
\index{figures}

Test of figures. In particular we refer to Figure~\vref{fig:impact} in which
there is a flow.

\begin{figure}[!ht]  % fig:impact
  \centerline{\includegraphics[width=0.9\linewidth]{../doc/src/manual/fig/wave1D.pdf}}
  \caption{
  Visualization \textbf{of} a \emph{wave}. \label{fig:impact}
  }
\end{figure}
%\clearpage % flush figures fig:impact

Figures without captions are allowed and will be inlined.

\vspace{6mm}

% inline figure
\centerline{\includegraphics[width=0.9\linewidth]{../doc/src/manual/fig/wave1D.pdf}}

\vspace{6mm}

\index{movies}

% Test multi-line caption in figure with sidecap=True

Here is figure~\vref{myfig} with a long (illegal) multi-line caption
containing inline verbatim text:

\begin{SCfigure}
  \centering
  \includegraphics[width=0.9\linewidth]{../doc/src/manual/fig/wave1D.png}
  \caption{
  A long caption spanning several lines and containing verbatim words like \protect \Verb!my\_file\_v1! and \protect \Verb!my\_file\_v2! as well as math with subscript as in $t_{i+1}$. \label{myfig}
  }
\end{SCfigure}
%\clearpage % flush figures myfig

% Must be a blank line after MOVIE or FIGURE to detect this problem

Test URL as figure name:

\vspace{6mm}

% inline figure
\centerline{\includegraphics[width=0.8\linewidth]{downloaded_figures/f_plot.png}}

\vspace{6mm}

% Test wikimedia type of files that otherwise reside in subdirs

\paragraph{Remark.}
Movies are tested in separate file \texttt{movies.do.txt}.

% Somewhat challenging heading with latex math, \t, \n, ? and parenthesis

\subsection{The $\theta$ parameter (not $\nabla$?)}
\label{decay:sec:theta}

Functions do not always need to be advanced, here is one
involving $\theta$:
\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
def f(theta):
    return theta**2
\end{lstlisting}\end{cod}
\noindent

\paragraph{More on $\theta$.}
Here is more text following headline with math.

Newcommands must also be tested in this \report:
$\half$, $\halfi$, $\x$, $\Ddt{u}$,
both inline and in block:

\begin{align}
\Ddt{u} &= 0\nonumber
\\ 
\half &= \halfi\\ 
\half\x &= \normalvec
\end{align}

Or with align with label and numbers:

\begin{align}
\Ddt{u} &= 0
\label{aligneq1}
\\ 
\half &= \halfi\\ 
\half\x &= \normalvec
\label{aligneq2}
\end{align}

% Must test more complicated align and matrix compositions
% where DocOnce inserts auto-numbered labels etc.

First one numbered (automatically):

\begin{align}
\begin{pmatrix}
G_2 + G_3 & -G_3 & -G_2 & 0 \\ 
-G_3 & G_3 + G_4 & 0 & -G_4 \\ 
-G_2 & 0 & G_1 + G_2 & 0 \\ 
0 & -G_4 & 0 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2 \\ 
 v_3 \\ 
 v_4
\end{pmatrix}
+ \cdots \\ 
\begin{pmatrix}
 C_5 + C_6 & -C_6 & 0 & 0 \\ 
 -C_6 & C_6 & 0 & 0 \\ 
 0 & 0 & 0 & 0 \\ 
 0 & 0 & 0 & 0
\end{pmatrix}
  &= \frac{d}{dt}\begin{pmatrix}
 v_1 \\ 
 v_2 \\ 
 v_3 \\ 
 v_4
\end{pmatrix} +
\begin{pmatrix}
 0 \\ 
 0 \\ 
 0 \\ 
 -i_0
\end{pmatrix}
\nonumber
\end{align}

Second numbered (automatically):

\begin{align}
\begin{pmatrix}
G_1 + G_2\\ 
-G_3 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2
\end{pmatrix}
+ \cdots\nonumber
\\ 
\left(\begin{array}{ll}
y & 2\\ 
2 & 1
\end{array}\right)
\left(\begin{array}{ll}
0 \\ x
\end{array}\right)
&= \begin{pmatrix}
A \\ B
\end{pmatrix}
\end{align}

Both numbered, with label by the user:

\begin{align}
\begin{pmatrix}
G_1 + G_2\\ 
-G_3 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2
\end{pmatrix}
+ \cdots \label{mymatrix:eq1}
\\ 
\label{mymatrix:eq2}
\left(\begin{array}{ll}
y & 2\\ 
2 & 1
\end{array}\right)
\left(\begin{array}{ll}
0 \\ x
\end{array}\right)
&= \begin{pmatrix}
A \\ B
\end{pmatrix}
\end{align}
Now we refer to (\ref{mymatrix:eq1})-(\ref{mymatrix:eq2}).

\subsection{Custom Environments}

Here is an attempt to create a theorem environment via Mako
(for counting theorems) and comment lines to help replacing lines in
the \texttt{.tex} by proper begin-end {\LaTeX} environments for theorems.
Should look nice in most formats!

% begin theorem
\label{theorem:fundamental1}

\paragraph{Theorem 5.}
Let $a=1$ and $b=2$. Then $c=3$.
% end theorem

% begin proof
\paragraph{Proof.}
Since $c=a+b$, the result follows from straightforward addition.
$\Diamond$
% end proof

As we see, the proof of Theorem 5 is a modest
achievement.

\subsection{Tables}
\label{subsec:table}

\index{test index with verbatim text@test index with {\rm\texttt{verbatim text}} which is possible}
\index{test two@test {\rm\texttt{two}} (separate) {\rm\texttt{verbatim expressions}} which is also possible}
\index{index with!subindex}
\index{\textbf{boldface word} in index}
\index{index with \textbf{boldface word}}
\index{index with!\textbf{boldface word} in subentry}
\index{double \textbf{boldface word}! \textbf{boldface word} in subentry too}

% index with comma could fool sphinx
\index{index, with comma, and one more}

Let us take this table from the manual:

\begin{table}
\caption{
Testing table environment in {\LaTeX}, enabled by testing on the "latex" format
with the preprocessor.
\label{mytab}
}


\begin{quote}
\begin{tabular}{lrr}
\hline
\multicolumn{1}{c}{ time } & \multicolumn{1}{c}{ velocity } & \multicolumn{1}{c}{ acceleration } \\
\hline
0.0  & 1.4186   & -5.01        \\
2.0  & 1.376512 & 11.919       \\
4.0  & 1.1E+1   & 14.717624    \\
\hline
\end{tabular}
\end{quote}

\noindent
\end{table}

The DocOnce source code reads
\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]

  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

\end{lstlisting}\end{cod}
\noindent

Here is yet another table to test that we can handle more than
one table:


\begin{quote}
\begin{tabular}{lll}
\hline
\multicolumn{1}{l}{ time } & \multicolumn{1}{l}{ velocity } & \multicolumn{1}{l}{ acceleration } \\
\hline
0.0  & 1.4186   & -5.01        \\
1.0  & 1.376512 & 11.919       \\
3.0  & 1.1E+1   & 14.717624    \\
\hline
\end{tabular}
\end{quote}

\noindent
And one with math headings (that are expanded and must be treated
accordingly), verbatim heading and entry, and no space around the pipe
symbol:


\begin{quote}
\begin{tabular}{lrrr}
\hline
\multicolumn{1}{c}{ $i$ } & \multicolumn{1}{c}{ $h_i$ } & \multicolumn{1}{c}{ $\bar T_i$ } & \multicolumn{1}{c}{ \Verb!L\_i! } \\
\hline
0   & 0      & 288        & -0.0065    \\
1   & 11,000 & 216        & 0.0        \\
2   & 20,000 & 216        & 0.001      \\
3   & 32,000 & 228        & 0.0028     \\
4   & 47,000 & 270        & 0.0        \\
5   & 51,000 & 270        & -0.0028    \\
6   & 71,000 & 214        & \texttt{NaN} \\
\hline
\end{tabular}
\end{quote}

\noindent
And add one with verbatim headings (with underscores),
and rows starting with \texttt{|-} because of a negative number,
and \texttt{|} right before and after verbatim word (with no space):


\begin{quote}
\begin{tabular}{rrrr}
\hline
\multicolumn{1}{c}{ exact } & \multicolumn{1}{c}{ \Verb!v\_1! } & \multicolumn{1}{c}{ $a_i$ + \Verb!v\_2! } & \multicolumn{1}{c}{ \Verb!verb\_3\_! } \\
\hline
9     & 9.62       & 5.57               & 8.98           \\
-20   & -23.39     & -7.65              & -19.93         \\
10    & 17.74      & -4.50              & 9.96           \\
0     & -9.19      & 4.13               & -0.26          \\
\hline
\end{tabular}
\end{quote}

\noindent
Pipe symbols in verbatim and math text in tables used to pose difficulties,
but not
anymore:


\begin{quote}
\begin{tabular}{lr}
\hline
\multicolumn{1}{c}{ $S$ } & \multicolumn{1}{c}{ command } \\
\hline
$ ||a_0|| $ & \texttt{norm|length} \\
$x\cap y$   & \texttt{x|y}         \\
\hline
\end{tabular}
\end{quote}

\noindent
Here is a table with X alignment:


\begin{quote}
\begin{tabularx}{\linewidth}{cX}
\hline
\multicolumn{1}{c}{ Type } & \multicolumn{1}{c}{ Description } \\
\hline
X     & Alignment character that is used for specifying a potentially very long text in a column in a table. It makes use of the \texttt{tabularx} package in {\LaTeX}, otherwise (for other formats) it means \texttt{l} (centered alignment). \\
l,r,c & standard alignment characters                                                                                                                                                                                                       \\
\hline
\end{tabularx}
\end{quote}

\noindent
Finally, a table with math
and URLs.

% Mako code to expand URLs in the table
% (These types of tables did not work before Jan 2014)


\begin{quote}
\begin{tabular}{ccc}
\hline
 \\
\hline
$\mathcal{L}=0$         & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0080.png} & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0085.png} \\
$a=b$                   & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0090.png} & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0095.png} \\
$\nabla\cdot\bm{u} =0 $ & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0100.png} & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0105.png} \\
\hline
\end{tabular}
\end{quote}

\noindent
\subsection{A test of verbatim words in heading with subscript $a_i$: \protect\Verb!my\_file\_v1! and \protect\Verb!my\_file\_v2! }

\paragraph{Paragraph with verbatim and math: \protect\Verb!my\_file\_v1.py! and \protect\Verb!my\_file\_v2.py! define some math $a_{i-1}$.}
Here is more \Verb!__verbatim__! code and
some plain text on a new line.

% Test various types of headlines
\subsection{\textbf{Just bold}}

Some text.

\subsection{\emph{Just emphasize}}

Some text.

\subsection{\texttt{Just verbatim} }

Some text.

\subsection{\textbf{Bold} beginning}

Some text.

\subsection{\emph{Emphasize} beginning}

Some text.

\subsection{\texttt{Verbatim} beginning}

Some text.

\subsection{Maybe \textbf{bold end}}

Some text.

\subsection{Maybe \emph{emphasize end}}

Some text.

\subsection{Maybe \texttt{verbatim end} }

Some text.

\subsection{The middle has \textbf{bold} word}

Some text.

\subsection{The middle has \emph{emphasize} word}

Some text.

\subsection{The middle has \texttt{verbatim} word}

Some text.

\paragraph{\emph{Just emphasize}.}
Some text.

\paragraph{\texttt{Just verbatim}.}
Some text.

\paragraph{\emph{Emphasize} beginning.}
Some text.

\paragraph{\texttt{Verbatim beginning}.}
Some text.

\paragraph{Maybe \emph{emphasize end}.}
Some text.

\paragraph{Maybe \texttt{verbatim end}.}
Some text.

\paragraph{The middle has \emph{emphasize} word.}
Some text.

\paragraph{The middle has \texttt{verbatim} word.}
Some text.

\paragraph{Ampersand.}
We can test Hennes {\&} Mauritz, often abbreviated H{\&}M, but written
as \Verb!Hennes & Mauritz! and \Verb!H & M!.
A sole \Verb!&! must also work.
% Note: substitutions must not occur inside verbatim, just in ordinary text.

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
# Just to check that ampersand works in code blocks:
c = a & b
\end{lstlisting}\end{cod}
\noindent

\paragraph{Quotes.}
Let us also add a test of quotes such as ``double quotes, with numbers
like 3.14 and newline/comma and hyphen (as in double-quote)''; written
in the standard LaTeX-style that gives correct {\LaTeX} formatting and
ordinary double quotes for all non-LaTeX formats.  Here is another
sentence that ``caused'' a bug in the past because double backtick
quotes could imply verbatim text up to a verbatim word starting with
period, like \texttt{.txt}.

More quotes to be tested for spellcheck:
(``with parenthesis''), ``with newline''
and ``with comma'', ``hyphen''-wise, and ``period''.

\subsection{Bibliography test}

Here is an example: \cite{Langtangen_Pedersen_2002} discussed propagation of
large destructive water waves, \cite{Langtangen_et_al_2002} gave
an overview of numerical methods for solving the Navier--Stokes equations,
while the use of Backward Kolmogorov equations for analyzing
random vibrations was investigated in \cite{Langtangen_1994a}.
The book chapter \cite{Mardal_et_al_2003a} contains information on
C++ software tools for programming multigrid methods. A real retro
reference is \cite{Langtangen_1988d} about a big FORTRAN package.
Multiple references are also possible, e.g., see
\cite{Langtangen_Pedersen_2002,Mardal_et_al_2003a}.

We need to cite more than 10 papers to reproduce an old formatting
problem with blanks in the keys in reST format:
\cite{Langtangen_1992c,Langtangen_1994a,Mortensen_et_al_2011,Langtangen_Pedersen_2002}
and
\cite{Langtangen_et_al_2002,Glimsdal_et_al_20006,Rahman_et_al_2006b,Haga_et_al_2011a,Langtangen_2003a,Langtangen_2008a,Langtangen:95}
and all the work of
\cite{Langtangen_2012,Mardal_et_al_2003a,Jeberg_et_al_2004} as well as
old work \cite{Langtangen_1988d} and \cite{Langtangen_1989e}, and the
talk \cite{Langtangen_talk_2007a}.
Langtangen also had two thesis \cite{Langtangen:85,Langtangen_1989e}
back in the days.
More retro citations are
the old ME-IN323 book \cite{Langtangen:91} and the
\cite{Langtangen:94b} OONSKI '94 paper.

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Example \thedoconceexercisecounter: Examples can be typeset as exercises}
                             
\label{Example}

Examples can start with a subsection heading starting with \texttt{Example:}
and then, with the command-line option \Verb!--examples_as_exercises! be
typeset as exercises. This is useful if one has solution
environments as part of the example.

\subex{a)}
State some problem.

\paragraph{Solution.}
The answer to this subproblem can be written here.

\subex{b)}
State some other problem.

\paragraph{Hint 1.}
A hint can be given.

\paragraph{Hint 2.}
Maybe even another hint?

\paragraph{Solution.}
The answer to this other subproblem goes here,
maybe over multiple doconce input lines.

\end{doconceexercise}
% --- end exercise ---

\subsection{User-defined environments}

Example~\vref{ex:test:1p1} demonstrates how to write a test function.
That is, a special test function for a function \texttt{add} appears in
Example~\vref{ex:test:1p1}.

\begin{example}
\label{ex:test:1p1}

\noindent\emph{A test function}.

Suppose we want to write a test function for checking the
implementation of a Python function for addition.

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
def add(a, b):
    return a + b

def test_add():
    a = 1; b = 1
    expected = a + b
    computed = add(a, b)
    assert expected == computed
\end{lstlisting}\end{cod}
\noindent
\end{example}

\begin{example}
\label{ex:math:1p1}

\noindent\emph{Addition}.

We have

\[ 1 + 1 = 2 \]
or in tabular form:


\begin{quote}
\begin{tabular}{cc}
\hline
\multicolumn{1}{c}{ Problem } & \multicolumn{1}{c}{ Result } \\
\hline
$1+1$   & $2$    \\
\hline
\end{tabular}
\end{quote}

\noindent
\end{example}

\begin{tcolorbox}[%skin=widget,
boxrule=1mm,
coltitle=black,
colframe=blue!45!white,
colback=blue!15!white,
width=(.9\linewidth),before=\hfill,after=\hfill,
adjusted title={Highlight box!}]
This environment is used to highlight something:

\[ E = mc^2 \]
\end{tcolorbox}

\subsection{URLs}
\label{subsubsec:ex}

Testing of URLs: hpl's home page \href{{https://folk.uio.no/hpl}}{hpl}, or
the entire URL if desired, \href{{https://folk.uio.no/hpl}}{\nolinkurl{https://folk.uio.no/hpl}}.  Here is a
plain file link \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}}, or \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}}, or
\href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}} or \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}} or \href{{testdoc.do.txt}}{a link with
newline}. Can test spaces with the link with word
too: \href{{https://folk.uio.no/hpl}}{hpl} or \href{{https://folk.uio.no/hpl}}{hpl}. Also \texttt{file:///} works: \href{{file:///home/hpl/vc/doconce/doc/demos/manual/manual.html}}{link to a
file} is
fine to have. Moreover, ``loose'' URLs work, i.e., no quotes, just
the plain URL as in \href{{https://folk.uio.no/hpl}}{\nolinkurl{https://folk.uio.no/hpl}}, if followed by space, comma,
colon, semi-colon, question mark, exclamation mark, but not a period
(which gets confused with the periods inside the URL).

Mail addresses can also be used: \href{{mailto:hpl@simula.no}}{\nolinkurl{hpl@simula.no}}, or just a \href{{mailto:hpl@simula.no}}{mail link}, or a raw \href{{mailto:hpl@simula.no}}{\nolinkurl{mailto:hpl@simula.no}}.

Here are some tough tests of URLs, especially for the \texttt{latex} format:
\href{{https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas}}{Newton-Cotes} formulas
and a \href{{https://www.springer.com/mathematics/computational+science+%26+engineering/book/978-3-642-23098-1}}{good book}. Need to test
Newton-Cotes with percentage in URL too:
\href{{https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas}}{\nolinkurl{https://en.wikipedia.org/wiki/Newton\%E2\%80\%93Cotes_formulas}}
and \href{{https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae}}{\nolinkurl{https://en.wikipedia.org/wiki/Newton-Cotes\#Open_Newton.E2.80.93Cotes_formulae}} which has a shebang.

For the \texttt{--device=paper} option it is important to test that URLs with
monospace font link text get a footnote
(unless the \Verb!--latex_no_program_footnotelink!
is used), as in this reference to
\href{{https://github.com/hplgit/INF5620/tree/gh-pages/src/decay/experiments/decay_mod.py}}{\nolinkurl{decay_mod}}, \href{{https://tinyurl.com/pwyasaa/formulas.ball1.py}}{\nolinkurl{ball1.py}},
and \href{{https://tinyurl.com/pwyasaa/formulas.ball2.py}}{\nolinkurl{ball2.py}}.

% Comments should be inserted outside paragraphs (because in the rst
% format extra blanks make a paragraph break).

% Note that when there is no https: or file:, it can be a file link
% if the link name is URL, url, "URL", or "url". Such files should,
% if rst output is desired, but placed in a \Verb!_static*! folder.

More tough tests: repeated URLs whose footnotes when using the
\texttt{--device=paper} option must be correct. We have
\href{{https://google.com}}{google}, \href{{https://google.com}}{google}, and
\href{{https://google.com}}{google}, which should result in exactly three
footnotes.

\subsection{Test of Some {\LaTeX} Fixes}

Let's check abbr.~of some common kind, e.g.~the well-known i.e.
expression as an example, and 1 vs.~2 which is also often used.
Dr.~Tang and Prof.~Monsen, or maybe also prof.~Ting,
will go to the Dept.~of Science to test how Mr.~Hansen is doing together
with Ms.~Larsen. A reference like Sec.~\vref{subsubsec:ex} or
Ch.~\vref{subsubsec:ex}, or even App.~\vref{subsubsec:ex}, must also be
handled. Likewise, this is test no.~$i$ of DocOnce features.
Also, look at Fig.~4 to see how the data compares with Tab.~\vref{mytab}.
Percentage must be fixed: 7\%,  87.65\% and
50\% at the beginning of the line.

% !split and check if these extra words are included properly in the comment

\section{{\LaTeX} Mathematics}

Here is an equation without label using backslash-bracket environment:
\[ a = b + c \]

or with number and label, as in (\ref{my:eq1}), using the equation environment:

\begin{equation}
{\partial u\over\partial t} = \nabla^2 u \label{my:eq1}
\end{equation}

We can refer to this equation by (\ref{my:eq1}).

Here is a system without equation numbers, using the align-asterisk environment:

\begin{align*}
\pmb{a} &= \pmb{q}\times\pmb{n} \\ 
b &= \nabla^2 u + \nabla^4 v
\end{align*}

And here is a system of equations with labels in an align environment:

\begin{align}
a &= q + 4 + 5+ 6 \label{eq1} \\ 
b &= \nabla^2 u + \nabla^4 x \label{eq2}
\end{align}

We can refer to (\ref{eq1})-(\ref{eq2}). They are a bit simpler than
the Navier--Stokes equations. And test {\LaTeX} hyphen in \texttt{CG-2}.
Also test $a_{i-j}$ as well as $kx-wt$.

Testing \texttt{alignat} environment:

\begin{alignat}{2}
a &= q + 4 + 5+ 6\qquad & \mbox{for } q\geq 0 \label{eq1a} \\ 
b &= \nabla^2 u + \nabla^4 x & x\in\Omega \label{eq2a}
\end{alignat}

Many of the next environments will fail in non-latex formats.
Testing multiline:

\begin{multline}
a = b = q + \\ 
  f + \nabla\cdot\nabla u
\label{multiline:eq1}
\end{multline}

Testing split:

\begin{equation}
\label{split:envir:eq}
\begin{split}
a = b = q &+ \\ 
  & f + \nabla\cdot\nabla u
\end{split}
\end{equation}
We can refer to the last equation by (\ref{split:envir:eq}).

Testing gather:
\begin{gather}
a = b \\ 
c = d + 7 + 9
\end{gather}

Let us refer to (\ref{eq1})-(\ref{eq2}) again, and to the
alignat variant (\ref{eq1a})-(\ref{eq2a}), and to (\ref{my:eq1}).

Testing eqnarray:
\begin{eqnarray}
{\partial u\over\partial t} &=& \nabla^2 u + f, \label{myeq1}\\ 
{\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g \label{myeq2}
\end{eqnarray}

More mathematical typesetting is demonstrated in the coming exercises.

Below, we have Problem~\vref{demo:ex:1} and Project~\vref{demo:ex:2},
as well as Projects~\vref{proj:circle1} and~\vref{exer:you}, and in
between there we have Exercise~\vref{exer:some:formula}.

\section{Exercises}

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Problem \thedoconceexercisecounter: Flip a Coin}
                             
\label{demo:ex:1}
% keywords = random numbers; Monte Carlo simulation; ipynb

% Torture tests

\subex{a)}
Make a program that simulates flipping a coin $N$ times.
Print out ``tail'' or ``head'' for each flip and
let the program count the number of heads.

% --- begin hint in exercise ---

\paragraph{Hint 1.}
Use \texttt{r = random.random()} and define head as \texttt{r <= 0.5}.

% --- end hint in exercise ---

% --- begin hint in exercise ---

\paragraph{Hint 2.}
Draw an integer among $\{1,2\}$ with
\texttt{r = random.randint(1,2)} and define head when \texttt{r} is 1.

% --- end hint in exercise ---

% --- begin answer of exercise ---
\paragraph{Answer.}
If the \texttt{random.random()} function returns a number $<1/2$, let it be
head, otherwise tail. Repeat this $N$ number of times.
% --- end answer of exercise ---

% --- begin solution of exercise ---
\paragraph{Solution.}
\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
import sys, random
N = int(sys.argv[1])
heads = 0
for i in range(N):
    r = random.random()
    if r <= 0.5:
        heads += 1
print('Flipping a coin %d times gave %d heads' % (N, heads))
\end{lstlisting}\end{cod}
\noindent
% --- end solution of exercise ---

\subex{b)}
Vectorize the code in a) using boolean indexing.

Vectorized code can be written in many ways.
Sometimes the code is less intuitive, sometimes not.
At least there is not much to find in Section~\vref{sec1}.

\subex{c)}
Vectorize the code in a) using \texttt{numpy.sum}.

% --- begin answer of exercise ---
\paragraph{Answer.}
\texttt{np.sum(np.where(r <= 0.5, 1, 0))} or \texttt{np.sum(r <= 0.5)}.
% --- end answer of exercise ---

In this latter subexercise, we have an
example where the code is easy to read.

\paragraph{My remarks.}
Remarks with such a subsubsection is treated as more text
after the last subexercise. Test a list too:

\begin{enumerate}
\item Mark 1.

\item Mark 2.
\end{enumerate}

\noindent
\noindent Filenames: \Verb!flip_coin.py!, \Verb!flip_coin.pdf!.

% Closing remarks for this Problem

\paragraph{Remarks.}
These are the exercise remarks, appearing at the very end.

% solution files: mysol.txt, mysol_flip_coin.py, yet_another.file

\end{doconceexercise}
% --- end exercise ---

\subsection{Not an exercise}

Should be possible to stick a normal section in the middle of many
exercises.

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Exercise \thedoconceexercisecounter: Test of plain text exercise}
                             
\label{my:exer1}

Very short exercise. What is the capital
of Norway?
\noindent Filename: \texttt{myexer1}.

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Project \thedoconceexercisecounter: Compute a Probability}
                             
\label{demo:ex:2}

% Minimalistic exercise

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval $[0,1)$?

At the end we have a list because that caused problems in {\LaTeX}
in previous DocOnce versions:

\begin{enumerate}
\item item1

\item item2
\end{enumerate}

\noindent
% --- begin hint in exercise ---

\paragraph{Hint.}
To answer this question empirically, let a program
draw $N$ such random numbers using Python's standard \texttt{random} module,
count how many of them, $M$, that fall in the interval $(0.5,0.6)$, and
compute the probability as $M/N$.

% --- end hint in exercise ---

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Project \thedoconceexercisecounter: Explore Distributions of Random Circles}
                             
\label{proj:circle1}
% keywords = ipynb

The formula for a circle is given by

\begin{align}
x &= x_0 + R\cos 2\pi t,
\label{circle:x}\\ 
y &= y_0 + R\sin 2\pi t,
\label{circle:y}
\end{align}
where $R$ is the radius of the circle, $(x_0,y_0)$ is the
center point, and $t$ is a parameter in the unit interval $[0,1]$.
For any $t$, $(x,y)$ computed from (\ref{circle:x})-(\ref{circle:y})
is a point on the circle.
The formula can be used to generate \texttt{n} points on a circle:

\begin{pro}{cbg_blue1}{bar_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y

x, y = circle(2.0, 0, 0)
\end{lstlisting}\end{pro}
\noindent

% Often in an exercise we have some comments about the solution
% which we normally want to keep where they are.

The goal of this project is to draw $N$ circles with random
center and radius. Plot each circle using the \texttt{circle} function
above.

\subex{a)}
Let $R$ be normally distributed and $(x_0,y_0)$ uniformly distributed.

% --- begin hint in exercise ---

\paragraph{Hint.}
Use the \texttt{numpy.random} module to draw the
$x_0$, $y_0$, and $R$ quantities.

% --- end hint in exercise ---

% --- begin answer of exercise ---
\paragraph{Answer.}
Here goes the short answer to part a).
% --- end answer of exercise ---

% --- begin solution of exercise ---
\paragraph{Solution.}
Here goes a full solution to part a).
% --- end solution of exercise ---

\subex{b)}
Let $R$ be uniformly distributed and $(x_0,y_0)$ normally distributed.
\noindent Filename: \texttt{norm}.

\subex{c)}
Let $R$ and $(x_0,y_0)$ be normally distributed.

\noindent Filename: \texttt{circles}.

% Closing remarks for this Project

\paragraph{Remarks.}
At the very end of the exercise it may be appropriate to summarize
and give some perspectives.

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Exercise \thedoconceexercisecounter: Determine some Distance}
                             
\label{exer:dist}

Intro to this exercise. Questions are in subexercises below.

% --- begin solution of exercise ---
\paragraph{Solution.}
Here goes a full solution of the whole exercise.
With some math $a=b$ in this solution:
\[ \hbox{math in solution: } a = b \]
And code \texttt{a=b} in this solution:
\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
a = b  # code in solution
\end{lstlisting}\end{cod}
\noindent
End of solution is here.

% --- end solution of exercise ---

\subex{a)}
Subexercises are numbered a), b), etc.

% --- begin hint in exercise ---

\paragraph{Hint 1.}
First hint to subexercise a).
With math $a=b$ in hint:

\[ a=b. \]
And with code (in plain verbatim) returning $x+1$ in hint:

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
def func(x):
    return x + 1  # with code in hint
\end{lstlisting}\end{cod}
\noindent

% --- end hint in exercise ---

% --- begin hint in exercise ---

\paragraph{Hint 2.}
Second hint to subexercise a).

Test list in hint:

\begin{enumerate}
\item item1

\item item2
\end{enumerate}

\noindent
% --- end hint in exercise ---
\noindent Filename: \Verb!subexer_a.pdf!.

% --- begin answer of exercise ---
\paragraph{Answer.}
Short answer to subexercise a).
With math in answer: $a=b$.
% --- end answer of exercise ---

\subex{b)}
Here goes the text for subexercise b).

Some math $\cos^2 x + \sin^2 x = 1$ written one a single line:

\[ \cos^2 x + \sin^2 x = 1 \thinspace .\]

% --- begin hint in exercise ---

\paragraph{Hint.}
A hint for this subexercise.

% --- end hint in exercise ---
\noindent Filename: \Verb!subexer_b.pdf!.

% --- begin solution of exercise ---
\paragraph{Solution.}
Here goes the solution of this subexercise.
% --- end solution of exercise ---

% No meaning in this weired test example:
The text here belongs to the main (intro) part of the exercise. Need
closing remarks to have text after subexercises.

Test list in exercise:

\begin{enumerate}
\item item1

\item item2
% Closing remarks for this Exercise
\end{enumerate}

\noindent
\paragraph{Remarks.}
Some final closing remarks, e.g., summarizing the main findings
and their implications in other problems can be made. These
remarks will appear at the end of the typeset exercise.

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}

\exercisesection{Some exercise without the "Exercise:" prefix}

% Another minimalistic exercise

Just some text. And some math saying that $e^0=1$ on a single line,
to test that math block insertion is correct:

\[ \exp{(0)} = 1 \]

And a test that the code \texttt{lambda x: x+2} is correctly placed here:

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
lambda x: x+2
\end{lstlisting}\end{cod}
\noindent

% Have some comments at the end of the exercise to see that
% the Filename: ... is written correctly.
\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Exercise \thedoconceexercisecounter: Solution of differential equation}
                             
\label{sec:this:exer:de}


\begin{doconcequiz}
\refstepcounter{doconcequizcounter}
\label{quiz:diff:eq1}


\noindent\textbf{\large SOlution of differential equation}

\noindent
Given

\[ \frac{dy}{dx} = -y(x),\quad y(0)=1 \]
What is the solution of this equation?

\vspace{2mm}

\textbf{A}. 
$y=e^{-y}$

\textbf{B}. 
$y=e^{y}$

\textbf{C}. 
\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
from math import exp
def f(x):
    return exp(x)
\end{lstlisting}\end{cod}
\noindent

\textbf{D}. 
The solution cannot be found because there is a derivative in the equation.

\textbf{E}. 
The equation is meaningless: an equation must be an equation
for $x$ or $y$, not a function $y(x)$.


% --- begin answer of exercise ---
\paragraph{Answer:} A.
% --- end answer of exercise ---

% --- begin solution of exercise ---
\noindent {\bf Solution:}\\


\textbf{A}: Right. 

\textbf{B}: Wrong. Almost, but the sign is wrong (note the minus!).

\textbf{C}: Wrong. Ooops, forgot a minus: \texttt{exp(-x)}, otherwise this Python code
must be considered as a good answer. It is more natural,
though, to write the solution to the problem
in mathematical notation:

\[ y(x) = e^{-y}.\]

\textbf{D}: Wrong. Equations with derivatives can be solved;
they are termed \emph{differential
equations}.

\textbf{E}: Wrong. Equations where the unknown is a function, as $y(x)$
here, are called \emph{differential equations}, and are solved by
special techniques.


% --- end solution of exercise ---


\vspace{3mm}

\end{doconcequiz}



\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Example \thedoconceexercisecounter: Just an example}
                             

% This example needs the --examples_as_exercises option, otherwise
% it is just typeset as it is written.

\subex{a)}
What is the capital of Norway?

\paragraph{Answer.}
Oslo.

\end{doconceexercise}
% --- end exercise ---

\section{Here goes another section}

With some text, before we continue with exercises.

\section{More Exercises}

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Exercise \thedoconceexercisecounter: Make references to projects and problems}
                             
\label{exer:some:formula}

% Test comments not at the end only
Pick a statement from Project~\vref{proj:circle1} or Problem~\vref{demo:ex:1}
and verify it.

Test list at the end of an exercise without other elements (like subexercise,
hint, etc.):

\begin{enumerate}
\item item1

\item item2
\end{enumerate}

\noindent
\noindent Filename: \Verb!verify_formula.py!.

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Project \thedoconceexercisecounter: References to Project~\vref{demo:ex:2} in a heading works for pdflatex}
                             
\label{exer:you}

Refer to the previous exercise as Exercise~\vref{exer:some:formula},
the two before that as Projects~\vref{demo:ex:2} and~\vref{proj:circle1},
and this one as Project~\vref{exer:you}.
\noindent Filename: \Verb!selc_composed.pdf!.

\end{doconceexercise}
% --- end exercise ---

\bibliographystyle{plain}
\bibliography{papers}



\appendix

\section{Just for testing; part I}
\label{app1}

This is the first appendix.

\subsection{A subsection within an appendix}

Some text.

\section{Just for testing; part II}
\label{app2}

This is more stuff for an appendix.

\subsection{Appendix: Testing identical titles}

Without label.

\subsection{Appendix: Testing identical titles}
\label{test:title:id1}

With label.

\subsection{Appendix: Testing identical titles}
\label{test:title:id2}

What about inserting a quiz?


\begin{doconcequiz}
\refstepcounter{doconcequizcounter}
\label{quiz:2}


\noindent\textbf{\large Capital of Norway}
\paragraph{Fundamental test:}
What is the capital of Norway?

\vspace{2mm}

\textbf{A}. 
Stockholm

\textbf{B}. 
London

\textbf{C}. 
Oslo

\textbf{D}. 
Bergen


% --- begin answer of exercise ---
\paragraph{Answer:} C.
% --- end answer of exercise ---

% --- begin solution of exercise ---
\noindent {\bf Solution:}\\


\textbf{A}: Wrong. Stockholm is the capital of Sweden.

\textbf{B}: Wrong. 

\textbf{C}: Right. 

\textbf{D}: Wrong. Those from Bergen would claim so, but nobody else.


% --- end solution of exercise ---


\vspace{3mm}

\end{doconcequiz}



\subsection{Appendix: Testing identical titles}

Without label.


\begin{notice_mdfboxadmon}[Tip.]
Here is a tip or hint box, typeset as a notice box.
\end{notice_mdfboxadmon} % title: Tip.



\clearpage

Need a lot of text to surround the summary box.
Version control systems allow you to record the history of files
and share files among several computers and collaborators in a
professional way. File changes on one computer are updated or
merged with changes on another computer. Especially when working
with programs or technical reports it is essential
to have changes documented and to
ensure that every computer and person involved in the project
have the latest updates of the files.
Greg Wilson' excellent \href{{https://software-carpentry.org/2010/07/script-for-introduction-to-version-control/}}{Script for Introduction to Version Control} provides a more detailed motivation why you will benefit greatly
from using version control systems.


\begin{summary_mdfboxadmon}[Summary.]
\textbf{Bold remark:} Make some text with this summary.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
\end{summary_mdfboxadmon} % title: Summary.



Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that site. I strongly
recommend you to use such sites for all serious programming and
scientific writing work - and all other important files.

The simplest services for hosting project files are \href{{https://dropbox.com}}{Dropbox} and \href{{https://drive.google.com}}{Google Drive}.
It is very easy to get started with these systems, and they allow you
to share files among laptops and mobile units with as many users as
you want. The systems offer a kind of version control in that the
files are stored frequently (several times per minute), and you can go
back to previous versions for the last 30 days. However, it is
challenging  to find the right version from the past when there are
so many of them.

More seriously, when several people may edit files simultaneously, it
can be difficult detect who did what when, roll back to previous
versions, and to manually merge the edits when these are
incompatible. Then one needs more sophisticated tools than Dropbox or
Google Drive: project hosting services with true version control
systems.  The following text aims at providing you with the minimum
information to started with such systems. Numerous other tutorials
contain more comprehensive material and in-depth explanations of the
concepts and tools.

The idea with project hosting services is that you have the files
associated with a project in the cloud. Many people may share these
files.  Every time you want to work on the project you explicitly
update your version of the files, edit the files as you like, and
synchronize the files with the "master version" at the site where the
project is hosted.  If you at some point need to go back to a
version of the files at some particular point in the past,
this is an easy operation. You can also use tools to see
what various people have done with the files in the various versions.

All these services are very similar. Below we describe how you get
started with Bitbucket, GitHub, and Googlecode. Launchpad works very
similarly to the latter three. All the project hosting services have
excellent introductions available at their web sites, but the recipes
below are much shorter and aim at getting you started as quickly as
possible by concentrating on the most important need-to-know steps.
The Git tutorials we refer to later in this document contain more
detailed information and constitute of course very valuable readings
when you use version control systems every day. The point now is
to get started.

\subsection{Appendix: Testing inline comments}

% Names can be [ A-Za-z0-9_'+-]+

Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that
site. \shortinlinecomment{hpl's semi opinion 1}{ not sure if in the cloud is understood by all. }{ not sure if in } I strongly recommend you to use such sites for all serious
programming and scientific writing work - and all other important
files.

The simplest services for hosting project files is Dropbox. \longinlinecomment{mp 2}{ Simply go to \href{{https://dropbox.com}}{\nolinkurl{https://dropbox.com}} and watch the video. It explains how files, like \texttt{myfile.py}, perhaps containing much math, like $\partial u/\partial t$, are easily communicated between machines. }{ Simply go to \href{{https://dropbox.com}}{\nolinkurl{https://dropbox.com}} } It
is very easy to get started with Dropbox, and it allows you to share
files among \textcolor{red}{(hpl 3:)} \replace{laptops and mobile units}{computers, tablets, and phones}.

% Test horizontal rule

------

% Coments for editing

First\textcolor{red}{, (\textbf{edit 4}: add comma)} consider a quantity $Q$. \textcolor{red}{(edit 5:)} \replace{To this end,}{We note that}
$Q>0$, because (\textbf{edit 6}:) \remove{a} negative \textcolor{red}{(edit 7:)} \replace{quantity is}{quantities are} (\textbf{edit 8}:) \remove{just} negative.  \textcolor{red}{ (\textbf{edit 9}:) This comes as no surprise.}

% Test tailored latex figure references with page number
Let us refer to Figure~\vref{fig:impact} again.

Test references in a list:

\begin{itemize}
 \item \vref{sec1}

 \item \vref{subsec1}

 \item \vref{fig:impact}
\end{itemize}

\noindent
\subsection{Appendix: Testing headings ending with \texttt{verbatim inline} }

The point here is to test 1) \texttt{verbatim} code in headings, and 2)
ending a heading with verbatim code as this triggers a special
case in {\LaTeX}.

We also test mdash---used as alternative to hyphen without spaces around,
or in quotes:


\begin{quote}
\emph{Fun is fun}.---Unknown.
\end{quote}


The ndash should also be tested -- as in the Hanson--Nilson equations
on page 277--278.

And finally, what about admons, quotes, and boxes? They are tested
in a separate document: \texttt{admon.do.txt}.


% ------------------- end of main content ---------------

% #ifdef PREAMBLE
\cleardoublepage\phantomsection  % trick to get correct link to Index
\printindex

\end{document}
% #endif

************** File: testdoc.tex_doconce_ptex2tex *****************
\bsys (!bc sys) -> \begin{Verbatim}[frame=lines]

\bpypro (!bc pypro) -> \begin{python:nt}

\bpyshell (!bc pyshell) -> \begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{python}

\bpycod (!bc py) -> \begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{python}

\bcycod (!bc cy) -> \begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{cython}

\bfcod (!bc f) -> \begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{fortran}

\bcpppro (!bc cpp) -> \begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{c++}

\bmcod (!bc m) -> \begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{matlab}

\bhtmlcod (!bc html) -> \begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{html}

\bipy (!bc ipy) -> \begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{ipy}

\bdo (!bc do) -> \begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{doconce}

\brestructuredtext (!bc restructuredtext) -> \begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{restructuredtext}

\bccq (!bc ccq) -> \begin{Verbatim}[numbers=none,fontsize=\fontsize{9pt}{9pt},baselinestretch=0.95] ("ccq" is unsupported so we use Verbatim)

\bcod (!bc cod) -> \begin{Verbatim}[numbers=none,fontsize=\fontsize{9pt}{9pt},baselinestretch=0.95] ("cod" is unsupported so we use Verbatim)

output in testdoc.tex
----------- end of doconce ptex2tex output ----------------
%%
%% Automatically generated file from DocOnce source
%% (https://github.com/doconce/doconce/)
%%
%%


%-------------------- begin preamble ----------------------

\documentclass[%
twoside,                 % oneside: electronic viewing, twoside: printing
draft,                   % draft: marks overfull hboxes, figures with paths
10pt]{article}

\listfiles               %  print all files needed to compile this document

\usepackage[a4paper]{geometry}

\usepackage{relsize,makeidx,color,setspace,amsmath,amsfonts,amssymb}
\usepackage[table]{xcolor}
\usepackage{bm,ltablex,microtype}

\usepackage[pdftex]{graphicx}
\usepackage{sidecap}

% user--provided packages: --latex_packages=varioref
\usepackage{varioref}

% 'on page ...' reference with \vref{} and varioref package
\renewcommand\reftextfaceafter{on page~\thevpagerefnum}
\renewcommand\reftextfacebefore{on page~\thevpagerefnum}
\renewcommand\reftextafter{on page~\thevpagerefnum}
\renewcommand\reftextbefore{on page~\thevpagerefnum}

% Tools for marking corrections
\usepackage{soul}
\newcommand{\replace}[2]{{\color{red}\text{\st{#1} #2}}}
\newcommand{\remove}[1]{{\color{red}\st{#1}}}

\usepackage{fancyvrb,anslistings} % packages needed for verbatim environments
\usepackage{minted}
\usemintedstyle{default}
\usepackage{fancyvrb}

\usepackage[T1]{fontenc}
%\usepackage[latin1]{inputenc}
\usepackage{ucs}
\usepackage[utf8x]{inputenc}

% Set palatino as the default font family:
\usepackage[sc]{mathpazo}    % Palatino fonts
\linespread{1.05}            % Palatino needs extra line spread to look nice

\usepackage{lmodern}         % Latin Modern fonts derived from Computer Modern

\newenvironment{doconcequiz}{}{}
\newcounter{doconcequizcounter}

% Hyperlinks in PDF:
\colorlet{linkcolor}{blue!90}
\usepackage{hyperref}
\hypersetup{
    breaklinks=true,
    colorlinks=true,
    linkcolor=linkcolor,
    urlcolor=linkcolor,
    citecolor=black,
    filecolor=black,
    %filecolor=blue,
    pdfmenubar=true,
    pdftoolbar=true,
    bookmarksdepth=3   % Uncomment (and tweak) for PDF bookmarks with more levels than the TOC
    }
%\hyperbaseurl{}   % hyperlinks are relative to this root

\setcounter{tocdepth}{2}  % levels in table of contents

%\VerbatimFootnotes must come after hyperref and footmisc packages
\VerbatimFootnotes

% Tricks for having figures close to where they are defined:
% 1. define less restrictive rules for where to put figures
\setcounter{topnumber}{2}
\setcounter{bottomnumber}{2}
\setcounter{totalnumber}{4}
\renewcommand{\topfraction}{0.95}
\renewcommand{\bottomfraction}{0.95}
\renewcommand{\textfraction}{0}
\renewcommand{\floatpagefraction}{0.75}
% floatpagefraction must always be less than topfraction!
% 2. ensure all figures are flushed before next section
\usepackage[section]{placeins}
% 3. enable begin{figure}[H] (often leads to ugly pagebreaks)
%\usepackage{float}\restylefloat{figure}

% enable inline (doconce) comments to be typeset with the todonotes package
\usepackage{ifthen,xkeyval,tikz,calc,graphicx}
\usepackage[shadow]{todonotes}
\newcommand{\shortinlinecomment}[3]{%
\todo[size=\normalsize,fancyline,color=orange!40,caption={#3}]{%
 \begin{spacing}{0.75}{\bf #1}: #2\end{spacing}}}
\newcommand{\longinlinecomment}[3]{%
\todo[inline,color=orange!40,caption={#3}]{{\bf #1}: #2}}

% Display labels for sections, equations, and citations in the margin
\usepackage{showlabels}
\showlabels{cite}

\onehalfspacing    % from setspace package
%\doublespacing

% --- fancyhdr package for fancy headers ---
\usepackage{fancyhdr}
\fancyhf{} % sets both header and footer to nothing
\renewcommand{\headrulewidth}{1pt}
% section name to the left (L) and page number to the right (R)
% on even (E) pages, the other way around on odd pages
% (switch twoside to onside in documentclass to just have odd pages)
\fancyhead[LE,RO]{\rightmark} % section
\fancyhead[RE,LO]{\thepage}
\pagestyle{fancy}


\usepackage[framemethod=TikZ]{mdframed}

% --- begin definitions of admonition environments ---

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "notice" admon
\colorlet{mdfbox_notice_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_notice_background,
  linecolor=seccolor,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=seccolor!20,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{notice_mdfboxmdframed}

\newenvironment{notice_mdfboxadmon}[1][]{
\begin{notice_mdfboxmdframed}[frametitle=#1]
}
{
\end{notice_mdfboxmdframed}
}

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "summary" admon
\colorlet{mdfbox_summary_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_summary_background,
  linecolor=seccolor,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=seccolor!20,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{summary_mdfboxmdframed}

\newenvironment{summary_mdfboxadmon}[1][]{
\begin{summary_mdfboxmdframed}[frametitle=#1]
}
{
\end{summary_mdfboxmdframed}
}

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "warning" admon
\colorlet{mdfbox_warning_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_warning_background,
  linecolor=seccolor,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=seccolor!20,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{warning_mdfboxmdframed}

\newenvironment{warning_mdfboxadmon}[1][]{
\begin{warning_mdfboxmdframed}[frametitle=#1]
}
{
\end{warning_mdfboxmdframed}
}

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "question" admon
\colorlet{mdfbox_question_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_question_background,
  linecolor=seccolor,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=seccolor!20,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{question_mdfboxmdframed}

\newenvironment{question_mdfboxadmon}[1][]{
\begin{question_mdfboxmdframed}[frametitle=#1]
}
{
\end{question_mdfboxmdframed}
}

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "block" admon
\colorlet{mdfbox_block_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_block_background,
  linecolor=seccolor,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=seccolor!20,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{block_mdfboxmdframed}

\newenvironment{block_mdfboxadmon}[1][]{
\begin{block_mdfboxmdframed}[frametitle=#1]
}
{
\end{block_mdfboxmdframed}
}

% --- end of definitions of admonition environments ---

% prevent orhpans and widows
\clubpenalty = 10000
\widowpenalty = 10000

% https://www.ctex.org/documents/packages/layout/titlesec.pdf
\usepackage{titlesec}  % needed for colored section headings
%\usepackage[compact]{titlesec}  % reduce the spacing around section headings

% --- section/subsection headings with blue color ---
\definecolor{seccolor}{cmyk}{.9,.5,0,.35}  % siamltexmm.sty section color
\titleformat{name=\section}
{\color{seccolor}\normalfont\Large\bfseries}
{\color{seccolor}\thesection}{1em}{}
\titleformat{name=\subsection}
{\color{seccolor}\normalfont\large\bfseries}
{\color{seccolor}\thesubsection}{1em}{}
\titleformat{name=\paragraph}[runin]
{\color{seccolor}\normalfont\normalsize\bfseries}
{}{}{\indent}

% let the header have a thick gray hrule with section and page in blue above
\renewcommand{\headrulewidth}{1pt}
\renewcommand{\headrule}{{\color{gray!50}%
\hrule width\headwidth height\headrulewidth \vskip-\headrulewidth}}
% replace \rightmark and \thepage by bfseries everwyhere to get bold headings
\fancyhead[LE,RO]{{\color{seccolor}\nouppercase{\rightmark}}} %section
\fancyhead[RE,LO]{{\color{seccolor}\thepage}}


% --- color every two table rows ---
\let\oldtabular\tabular
\let\endoldtabular\endtabular
\definecolor{appleblue}{rgb}{0.93,0.95,1.0}  % Apple blue
\renewenvironment{tabular}{\rowcolors{2}{white}{appleblue}%
\oldtabular}{\endoldtabular}


\newenvironment{doconceexercise}{}{}
\newcounter{doconceexercisecounter}
% --- begin definition of \listofexercises command ---
\makeatletter
\newcommand\listofexercises{\section*{List of Examples, Exercises, Problems, and Projects}
\@starttoc{loe}
}
\newcommand*{\l@doconceexercise}{\@dottedtocline{0}{0pt}{6.5em}}
\makeatother
% --- end definition of \listofexercises command ---



% ------ header in subexercises ------
%\newcommand{\subex}[1]{\paragraph{#1}}
%\newcommand{\subex}[1]{\par\vspace{1.7mm}\noindent{\bf #1}\ \ }
\makeatletter
% 1.5ex is the spacing above the header, 0.5em the spacing after subex title
\newcommand\subex{\@startsection{paragraph}{4}{\z@}%
                  {1.5ex\@plus1ex \@minus.2ex}%
                  {-0.5em}%
                  {\normalfont\normalsize\bfseries}}
\makeatother


% --- end of standard preamble for documents ---


\usepackage{amsthm,tcolorbox}
\theoremstyle{definition}
\newtheorem{example}{Example}[section]
\newtheorem{theorem}{Theorem}[section]



% insert custom LaTeX commands...

\raggedbottom
\makeindex
\usepackage[totoc]{idxlayout}   % for index in the toc
\usepackage[nottoc]{tocbibind}  % for references/bibliography in the toc

%-------------------- end preamble ----------------------

\begin{document}

% matching end for #ifdef PREAMBLE

\newcommand{\exercisesection}[1]{\subsection*{#1}}

\input{newcommands_bfmath}
\input{newcommands_replace}

% ------------------- main content ----------------------



% ----------------- title -------------------------

\thispagestyle{empty}
\hbox{\ \ }
\vfill
\begin{center}
{\huge{\bfseries{
\begin{spacing}{1.25}
{\color{seccolor}\rule{\linewidth}{0.5mm}} \\[0.4cm]
{\color{seccolor}A Document for Testing DocOnce}
\\[0.4cm] {\color{seccolor}\rule{\linewidth}{0.5mm}} \\[1.5cm]
\end{spacing}
}}}

% ----------------- author(s) -------------------------

\vspace{0.5cm}

{\Large\textsf{Hans Petter Langtangen${}^{1, 2}$ (\texttt{hpl@simula.no})}}\\ [3mm]

{\Large\textsf{Kaare Dump${}^{3}$}}\\ [3mm]

{\Large\textsf{A. Dummy Author${}^{}$}}\\ [3mm]

{\Large\textsf{I. S. Overworked and Outburned${}^{4, 5, 6, 7}$}}\\ [3mm]

{\Large\textsf{J. Doe${}^{}$ (\texttt{j\_doe@cyberspace.com})}}\\ [3mm]

\ \\ [2mm]

{\large\textsf{${}^1$Center for Biomedical Computing, Simula Research Laboratory} \\ [1.5mm]}
{\large\textsf{${}^2$Department of Informatics, University of Oslo} \\ [1.5mm]}
{\large\textsf{${}^3$Segfault, Cyberspace} \\ [1.5mm]}
{\large\textsf{${}^4$Inst1} \\ [1.5mm]}
{\large\textsf{${}^5$Inst2, Somewhere} \\ [1.5mm]}
{\large\textsf{${}^6$Third Inst, Elsewhere} \\ [1.5mm]}
{\large\textsf{${}^7$Fourth Inst} \\ [1.5mm]}
% ----------------- end author(s) -------------------------

% --- begin date ---
\ \\ [10mm]
{\large\textsf{Jan 32, 2100}}
\end{center}
% --- end date ---
\vfill
\clearpage

\tableofcontents
\listofexercises


\listoftodos[List of inline comments]

\clearpage % after toc

% !split

The format of this document is
plain, homemade \textsc{pdf}{\LaTeX} (from DocOnce).

% --- begin abstract ---
\ \\ [13mm]
\begin{center}
\begin{minipage}{0.9\linewidth}
\small
This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.

% Cannot demonstrate chapter headings since abstract and chapter
% are mutually exclusive in {\LaTeX}
\end{minipage}
\end{center}
% --- end abstract ---

\section{Section 1}
\label{sec1}

Here is a nested list:

\begin{itemize}
  \item item1

  \item item2

  \item item3 which continues
    on the next line to test that feature

  \item and a sublist
\begin{itemize}

    \item with indented subitem1

    \item and a subitem2

\end{itemize}

\noindent
  \item and perhaps an ordered sublist
\begin{enumerate}

   \item first item

   \item second item,
      continuing on a new line
\end{enumerate}

\noindent
\end{itemize}

\noindent
\paragraph{Here is a list with paragraph heading.}

\begin{itemize}
  \item item1

  \item item2
\end{itemize}

\noindent
\paragraph{Here is a list with subsubsection heading.}
\begin{itemize}
  \item item1

  \item item2
\end{itemize}

\noindent

\begin{quote}
Here are two lines that make up
a block quote for testing \emph{emphasized words} and \textbf{boldface words},
also with hypens:
\emph{pre}-fix, post-\emph{fix}, \textbf{pre}-fix, post-\textbf{fix}.
\end{quote}


Here are two references. Equation~(\ref{my:eq1}) is fine. Eq.~(\ref{my:eq1}) too.
Even Equation (\ref{my:eq1}) without the tilde.

\subsection{Subsection 1}
\label{subsec1}

\index{somefunc@{\rm\texttt{somefunc}} function}\marginpar{\footnotesize {\rm\texttt{somefunc}} function}

% Refer to section/appendix etc. at the beginning of the line
% and other special fix situations for HTML.

More text, with a reference back to
Section~\vref{sec1} and~\vref{subsec1}, and further to the
sections~\vref{subsec1} and~\vref{subsubsec:ex}, which
encourages you to do the tasks in the
Exercises~\vref{demo:ex:1} and~\vref{exer:some:formula}.
Appendices~\vref{app1} and~\vref{app2} are also nice elements.

\paragraph{Test Section reference at beginning of line and after a sentence.}
Section~\vref{subsec1} is fine.
Section~\vref{subsubsec:ex} too.

% sphinx code--blocks: pycod=python cod=fortran cppcod=c++ sys=console

\paragraph{Computer code.}
Let's do some copying from files too. First from subroutine up to the very end,

\begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{fortran}
      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
\end{minted}
and then just the subroutine,
\begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{fortran}

      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
\end{minted}
and finally the complete file with a plain text verbatim environment
(\texttt{envir=ccq}):
\begin{Verbatim}[numbers=none,fontsize=\fontsize{9pt}{9pt},baselinestretch=0.95]
C     a comment

      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
\end{Verbatim}

Testing other code environments. First Python:

\begin{Verbatim}[numbers=none,fontsize=\fontsize{9pt}{9pt},baselinestretch=0.95]
!bc pycod
def f(x):
    return x+1
!ec
\end{Verbatim}
which gets rendered as

\begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{python}
def f(x):
    return x+1
\end{minted}

Test paragraph and subsubsection headings before
before code.

\paragraph{Paragraph heading before code.}

\begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{python}
import sys
sys.path.insert(0, os.pardir)
\end{minted}

\paragraph{Subsubsection heading before code.}
\begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{python}
def h(z):
    return z+1
\end{minted}

Now a complete program to be shown via Python Online Tutorial:

\begin{python:nt}
class Line:
    def __init__(self, a, b):
        self.a, self.b = a, b

    def __call__(self, x):
        a, b = self.a, self.b
        return a*x + b

line = Line(2, 1)
y = line(x=3)
print(y)
\end{python:nt}

Some more Python code (actually specified as a sage cell, but
such cells are not supported by this format).

\begin{python:nt}
a = 2
b = 3
print('a+b:', a + b)

# In a sage cell we can also plot
from matplotlib.pyplot import *
from numpy import *
x = linspace(0, 4*pi, 101)
y = exp(-0.1*x)*cos(x)
plot(x, y)
xlabel('x'); ylabel('y')
show()
\end{python:nt}

Then Cython (with -h option so it is hidden in html/sphinx):

\begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{cython}
cpdef f(double x):
    return x + 1
\end{minted}

Standard Python shell sessions:

\begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{python}
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
\end{minted}

Similar IPython sessions:

\begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{ipy}
In [1]: from numpy import linspace, sin
In [2]: # Some comment
In [3]: x = linspace(0, 2, 11)
In [4]: y = sin(x)
In [5]: y[0]
Out[5]: 0
In [6]: import matplotlib.pyplot as plt
In [7]: plt.plot(x, y)
In [8]: a='multiple-\nline\noutput'
In [9]: a
Out[9]: 'multiple-\nline\noutput'
In [10]: print(a)
multiple-
line
output
\end{minted}

Here is the interactive session again, but with \texttt{pyshell-t}.

\begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{python}
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
\end{minted}

% This one tests a + sign before a code environment
C++:
\begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{c++}
#include <iostream>

int main()
{
   std::cout << "Sample output" << std::endl;
   return 0
}
\end{minted}
% The next should get correctly typset in sphinx (cod is fcod)
% It also tests emoji before code
And a little bit of Fortran: \raisebox{-\height+\ht\strutbox}{\includegraphics[height=1.5em]{latex_figs/dizzy_face.png}}

\begin{Verbatim}[numbers=none,fontsize=\fontsize{9pt}{9pt},baselinestretch=0.95]
!bc cod
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
!ec
\end{Verbatim}
which then is typeset as

\begin{Verbatim}[numbers=none,fontsize=\fontsize{9pt}{9pt},baselinestretch=0.95]
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
\end{Verbatim}

HTML:

\begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{html}
<table>
<tr><td>Column 1</td><td>Column 2</td></tr>
<tr><td>0.67526 </td><td>0.92871 </td></tr>
<!-- comment -->
</table>
\end{minted}

But inline HTML code is also important, like text that starts with
\texttt{<a href="} (which can destroy the following text if not properly
quoted).

Matlab with comments requires special typesetting:

\begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{matlab}
% Comment on the beginning of the line can be escaped by %%
if a > b
  % Indented comment needs this trick
  c = a + b
end
\end{minted}

And here is a system call:

\begin{Verbatim}[frame=lines]
Terminal> mkdir test
Terminal> cd test
Terminal> myprog -f
output1
output2
\end{Verbatim}

Any valid pygments lexer/language name can appear to, e.g.,

\begin{Verbatim}[numbers=none,fontsize=\fontsize{9pt}{9pt},baselinestretch=0.95]
!bc restructuredtext
=======
Heading
=======

Some text.
!ec
\end{Verbatim}
results in

\begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{restructuredtext}
=======
Heading
=======

Some text.
\end{minted}

% Here goes hidden code.
% Python can be treated by some formats, Fortran is always out.





Finally, \Verb?!bc do? supports highlighting of DocOnce source:

\begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{doconce}
======= DocOnce test file =======

===== Computer code =====

Inline verbatim code, as in `import numpy as np`, is allowed, as well as
code blocks:

!bc pycod
from math import sin

def f(x):
    """Example on a function."""
    return sin(x) + 1

print(f(0))
!ec


===== Mathematics =====

Formulas can be inline, as in $\nabla\cdot\bm{u} = 0$, or typeset
as equations:

!bt
\begin{align*}
\nabla\cdot\bm{u} &= 0,\\ 
\bm{u} &= \nabla\phi .
\end{align*}
!et

=== Subsubsection heading ===

DocOnce files can have chapters, sections, subsections, and subsubsections.

__Paragraph heading.__ Paragraphs may have headings.
\end{minted}

It is time to test \texttt{verbatim inline font} especially with \texttt{a newline inside the text} and an exclamation mark at the end: \texttt{BEGIN}! For
spellcheck, test \texttt{a verbatim expression} in \texttt{another} in a \texttt{third}.
Also test exclamation mark as in \Verb?!bc? and \Verb?!ec? as well as \Verb?a != b?.
Also test backslashes and braces like \Verb!\begin!, \Verb!\begin{enumerate}!,
\Verb!\end{this}\end{that}!, and \Verb!{something \inside braces}!.

Here is some \textcolor{red}{red color} and an attempt to write \textcolor{green}{with
green color containing a linebreak\\
code.} Some formats will only display \\
this correctly when \texttt{html} \\
is the output format.
But here some more running text is added which is not part of
the previous blocks with line breaks.

\paragraph{Running OS commands.}
\begin{Verbatim}[frame=lines]
Terminal> python -c 'print("Testing\noutput\nfrom\nPython.")'
Testing
output
from
Python.
\end{Verbatim}

\paragraph{Footnotes.}
Here is a test of footnotes \footnote{Typesetting of the footnote depends on the format. Plain text does nothing, {\LaTeX} removes the definition and inserts the footnote as part of the {\LaTeX} text. reStructuredText and Sphinx employ a similar type of typesetting as Extended Markdown and DocOnce, and in HTML we keep the same syntax, just displayed properly in HTML.}, which are handy in text.
They are used in different flavors, now in

\begin{itemize}
 \item list items (note below that footnotes work after math, verbatim, and URLs - bin fact old and emphasize too!)

 \item even with math $\nabla^2u$\footnote{Math footnotes can be dangerous since it interferes with an exponent.}

 \item and code \texttt{h[i] += 1}\footnote{One--line footnote.}
   (\emph{must} have space between inline code and footnote!)

 \item and \href{{https://google.com}}{links}\footnote{\texttt{https://google.com}}\footnote{\href{{google.com}}{\nolinkurl{google.com}\footnote{\texttt{google.com}}} is perhaps the most famous web site today.}
\end{itemize}

\noindent
which gives flexibility in writing.
This is the third\footnote{Not much to add here, but the footnote is at the end with only one newline.} example.

Here is some more text before a new definition of a footnote that was
used above.


\begin{notice_mdfboxadmon}[Non--breaking space character.]
This paragraph aims to test \href{{https://en.wikipedia.org/wiki/Non--breaking_space}}{non--breaking space character}\footnote{\texttt{https://en.wikipedia.org/wiki/Non--breaking\_space}}, and a typical
example where this is needed is in physical units: 7.4~km is traveled
in~$7.4/5.5\approx 1.345$~s.  Also check that a~\href{{https://google.com}}{link}\footnote{\texttt{https://google.com}}~is
not broken across lines (drag the browser window to test this).
(On the other hand, the tilde is used in
computer code, e.g., as in \texttt{[~x for x in y]} or in \texttt{y=~x}, and should
of course remain a tilde in those contexts.)
\end{notice_mdfboxadmon} % title: Non--breaking space character.



\subsection{Subsection 2: Testing figures}
\label{subsec:ex}
\index{figures}\marginpar{\footnotesize figures}

Test of figures. In particular we refer to Figure~\vref{fig:impact} in which
there is a flow.

\begin{figure}[!ht]  % fig:impact
  \centerline{\includegraphics[width=0.9\linewidth]{../doc/src/manual/fig/wave1D.pdf}}
  \caption{
  Visualization \textbf{of} a \emph{wave}. \label{fig:impact}
  }
\end{figure}
%\clearpage % flush figures fig:impact

Figures without captions are allowed and will be inlined.

\vspace{6mm}

% inline figure
\centerline{\includegraphics[width=0.9\linewidth]{../doc/src/manual/fig/wave1D.pdf}}

\vspace{6mm}

\index{movies}\marginpar{\footnotesize movies}

% Test multi--line caption in figure with sidecap=True

Here is figure~\vref{myfig} with a long (illegal) multi--line caption
containing inline verbatim text:

\begin{SCfigure}
  \centering
  \includegraphics[width=0.9\linewidth]{../doc/src/manual/fig/wave1D.png}
  \caption{
  A long caption spanning several lines and containing verbatim words like \protect \Verb!my\_file\_v1! and \protect \Verb!my\_file\_v2! as well as math with subscript as in $t_{i+1}$. \label{myfig}
  }
\end{SCfigure}
%\clearpage % flush figures myfig

% Must be a blank line after MOVIE or FIGURE to detect this problem

Test URL as figure name:

\vspace{6mm}

% inline figure
\centerline{\includegraphics[width=0.8\linewidth]{downloaded_figures/f_plot.png}}

\vspace{6mm}

% Test wikimedia type of files that otherwise reside in subdirs

\paragraph{Remark.}
Movies are tested in separate file \texttt{movies.do.txt}.

% Somewhat challenging heading with latex math, \t, \n, ? and parenthesis

\subsection{The $\theta$ parameter (not $\nabla$?)}
\label{decay:sec:theta}

Functions do not always need to be advanced, here is one
involving $\theta$:
\begin{Verbatim}[numbers=none,fontsize=\fontsize{9pt}{9pt},baselinestretch=0.95]
def f(theta):
    return theta**2
\end{Verbatim}

\paragraph{More on $\theta$.}
Here is more text following headline with math.

Newcommands must also be tested in this \report:
$\half$, $\halfi$, $\x$, $\Ddt{u}$,
both inline and in block:

\begin{align}
\Ddt{u} &= 0\nonumber
\\ 
\half &= \halfi\\ 
\half\x &= \normalvec
\end{align}

Or with align with label and numbers:

\begin{align}
\Ddt{u} &= 0
\label{aligneq1}
\\ 
\half &= \halfi\\ 
\half\x &= \normalvec
\label{aligneq2}
\end{align}

% Must test more complicated align and matrix compositions
% where DocOnce inserts auto--numbered labels etc.

First one numbered (automatically):

\begin{align}
\begin{pmatrix}
G_2 + G_3 & -G_3 & -G_2 & 0 \\ 
-G_3 & G_3 + G_4 & 0 & -G_4 \\ 
-G_2 & 0 & G_1 + G_2 & 0 \\ 
0 & -G_4 & 0 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2 \\ 
 v_3 \\ 
 v_4
\end{pmatrix}
+ \cdots \\ 
\begin{pmatrix}
 C_5 + C_6 & -C_6 & 0 & 0 \\ 
 -C_6 & C_6 & 0 & 0 \\ 
 0 & 0 & 0 & 0 \\ 
 0 & 0 & 0 & 0
\end{pmatrix}
  &= \frac{d}{dt}\begin{pmatrix}
 v_1 \\ 
 v_2 \\ 
 v_3 \\ 
 v_4
\end{pmatrix} +
\begin{pmatrix}
 0 \\ 
 0 \\ 
 0 \\ 
 -i_0
\end{pmatrix}
\nonumber
\end{align}

Second numbered (automatically):

\begin{align}
\begin{pmatrix}
G_1 + G_2\\ 
-G_3 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2
\end{pmatrix}
+ \cdots\nonumber
\\ 
\left(\begin{array}{ll}
y & 2\\ 
2 & 1
\end{array}\right)
\left(\begin{array}{ll}
0 \\ x
\end{array}\right)
&= \begin{pmatrix}
A \\ B
\end{pmatrix}
\end{align}

Both numbered, with label by the user:

\begin{align}
\begin{pmatrix}
G_1 + G_2\\ 
-G_3 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2
\end{pmatrix}
+ \cdots \label{mymatrix:eq1}
\\ 
\label{mymatrix:eq2}
\left(\begin{array}{ll}
y & 2\\ 
2 & 1
\end{array}\right)
\left(\begin{array}{ll}
0 \\ x
\end{array}\right)
&= \begin{pmatrix}
A \\ B
\end{pmatrix}
\end{align}
Now we refer to (\ref{mymatrix:eq1})-(\ref{mymatrix:eq2}).

\subsection{Custom Environments}

Here is an attempt to create a theorem environment via Mako
(for counting theorems) and comment lines to help replacing lines in
the \texttt{.tex} by proper begin--end {\LaTeX} environments for theorems.
Should look nice in most formats!

\begin{theorem}
\label{theorem:fundamental1}


Let $a=1$ and $b=2$. Then $c=3$.
\end{theorem}

% begin proof
\paragraph{Proof.}
Since $c=a+b$, the result follows from straightforward addition.
$\Diamond$
% end proof

As we see, the proof of Theorem 5 is a modest
achievement.

\subsection{Tables}
\label{subsec:table}

\index{test index with verbatim text@test index with {\rm\texttt{verbatim text}} which is possible}\marginpar{\footnotesize test index with {\rm\texttt{verbatim text}} which is possible}
\index{test two@test {\rm\texttt{two}} (separate) {\rm\texttt{verbatim expressions}} which is also possible}\marginpar{\footnotesize test {\rm\texttt{two}} (separate) {\rm\texttt{verbatim expressions}} which is also possible}
\index{index with!subindex}\marginpar{\footnotesize index with!subindex}
\index{\textbf{boldface word} in index}\marginpar{\footnotesize \textbf{boldface word} in index}
\index{index with \textbf{boldface word}}\marginpar{\footnotesize index with \textbf{boldface word}}
\index{index with!\textbf{boldface word} in subentry}\marginpar{\footnotesize index with!\textbf{boldface word} in subentry}
\index{double \textbf{boldface word}! \textbf{boldface word} in subentry too}\marginpar{\footnotesize double \textbf{boldface word}! \textbf{boldface word} in subentry too}

% index with comma could fool sphinx
\index{index, with comma, and one more}\marginpar{\footnotesize index, with comma, and one more}

Let us take this table from the manual:

\begin{table}
\caption{
Testing table environment in {\LaTeX}, enabled by testing on the "latex" format
with the preprocessor.
\label{mytab}
}


\begin{quote}
\begin{tabular}{lrr}
\hline
\multicolumn{1}{c}{ time } & \multicolumn{1}{c}{ velocity } & \multicolumn{1}{c}{ acceleration } \\
\hline
0.0  & 1.4186   & -5.01        \\
2.0  & 1.376512 & 11.919       \\
4.0  & 1.1E+1   & 14.717624    \\
\hline
\end{tabular}
\end{quote}

\noindent
\end{table}

The DocOnce source code reads
\begin{Verbatim}[numbers=none,fontsize=\fontsize{9pt}{9pt},baselinestretch=0.95]

  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

\end{Verbatim}

Here is yet another table to test that we can handle more than
one table:


\begin{quote}
\begin{tabular}{lll}
\hline
\multicolumn{1}{l}{ time } & \multicolumn{1}{l}{ velocity } & \multicolumn{1}{l}{ acceleration } \\
\hline
0.0  & 1.4186   & -5.01        \\
1.0  & 1.376512 & 11.919       \\
3.0  & 1.1E+1   & 14.717624    \\
\hline
\end{tabular}
\end{quote}

\noindent
And one with math headings (that are expanded and must be treated
accordingly), verbatim heading and entry, and no space around the pipe
symbol:


\begin{quote}
\begin{tabular}{lrrr}
\hline
\multicolumn{1}{c}{ $i$ } & \multicolumn{1}{c}{ $h_i$ } & \multicolumn{1}{c}{ $\bar T_i$ } & \multicolumn{1}{c}{ \Verb!L\_i! } \\
\hline
0   & 0      & 288        & -0.0065    \\
1   & 11,000 & 216        & 0.0        \\
2   & 20,000 & 216        & 0.001      \\
3   & 32,000 & 228        & 0.0028     \\
4   & 47,000 & 270        & 0.0        \\
5   & 51,000 & 270        & -0.0028    \\
6   & 71,000 & 214        & \texttt{NaN} \\
\hline
\end{tabular}
\end{quote}

\noindent
And add one with verbatim headings (with underscores),
and rows starting with \texttt{|-} because of a negative number,
and \texttt{|} right before and after verbatim word (with no space):


\begin{quote}
\begin{tabular}{rrrr}
\hline
\multicolumn{1}{c}{ exact } & \multicolumn{1}{c}{ \Verb!v\_1! } & \multicolumn{1}{c}{ $a_i$ + \Verb!v\_2! } & \multicolumn{1}{c}{ \Verb!verb\_3\_! } \\
\hline
9     & 9.62       & 5.57               & 8.98           \\
-20   & -23.39     & -7.65              & -19.93         \\
10    & 17.74      & -4.50              & 9.96           \\
0     & -9.19      & 4.13               & -0.26          \\
\hline
\end{tabular}
\end{quote}

\noindent
Pipe symbols in verbatim and math text in tables used to pose difficulties,
but not
anymore:


\begin{quote}
\begin{tabular}{lr}
\hline
\multicolumn{1}{c}{ $S$ } & \multicolumn{1}{c}{ command } \\
\hline
$ ||a_0|| $ & \texttt{norm|length} \\
$x\cap y$   & \texttt{x|y}         \\
\hline
\end{tabular}
\end{quote}

\noindent
Here is a table with X alignment:


\begin{quote}
\begin{tabularx}{\linewidth}{cX}
\hline
\multicolumn{1}{c}{ Type } & \multicolumn{1}{c}{ Description } \\
\hline
X     & Alignment character that is used for specifying a potentially very long text in a column in a table. It makes use of the \texttt{tabularx} package in {\LaTeX}, otherwise (for other formats) it means \texttt{l} (centered alignment). \\
l,r,c & standard alignment characters                                                                                                                                                                                                       \\
\hline
\end{tabularx}
\end{quote}

\noindent
Finally, a table with math
and URLs.

% Mako code to expand URLs in the table
% (These types of tables did not work before Jan 2014)


\begin{quote}
\begin{tabular}{ccc}
\hline
 \\
\hline
$\mathcal{L}=0$         & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0080.png} & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0085.png} \\
$a=b$                   & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0090.png} & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0095.png} \\
$\nabla\cdot\bm{u} =0 $ & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0100.png} & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0105.png} \\
\hline
\end{tabular}
\end{quote}

\noindent
\subsection{A test of verbatim words in heading with subscript $a_i$: \protect\Verb!my\_file\_v1! and \protect\Verb!my\_file\_v2! }

\paragraph{Paragraph with verbatim and math: \protect\Verb!my\_file\_v1.py! and \protect\Verb!my\_file\_v2.py! define some math $a_{i-1}$.}
Here is more \Verb!__verbatim__! code and
some plain text on a new line.

% Test various types of headlines
\subsection{\textbf{Just bold}}

Some text.

\subsection{\emph{Just emphasize}}

Some text.

\subsection{\texttt{Just verbatim} }

Some text.

\subsection{\textbf{Bold} beginning}

Some text.

\subsection{\emph{Emphasize} beginning}

Some text.

\subsection{\texttt{Verbatim} beginning}

Some text.

\subsection{Maybe \textbf{bold end}}

Some text.

\subsection{Maybe \emph{emphasize end}}

Some text.

\subsection{Maybe \texttt{verbatim end} }

Some text.

\subsection{The middle has \textbf{bold} word}

Some text.

\subsection{The middle has \emph{emphasize} word}

Some text.

\subsection{The middle has \texttt{verbatim} word}

Some text.

\paragraph{\emph{Just emphasize}.}
Some text.

\paragraph{\texttt{Just verbatim}.}
Some text.

\paragraph{\emph{Emphasize} beginning.}
Some text.

\paragraph{\texttt{Verbatim beginning}.}
Some text.

\paragraph{Maybe \emph{emphasize end}.}
Some text.

\paragraph{Maybe \texttt{verbatim end}.}
Some text.

\paragraph{The middle has \emph{emphasize} word.}
Some text.

\paragraph{The middle has \texttt{verbatim} word.}
Some text.

\paragraph{Ampersand.}
We can test Hennes {\&} Mauritz, often abbreviated H{\&}M, but written
as \Verb!Hennes & Mauritz! and \Verb!H & M!.
A sole \Verb!&! must also work.
% Note: substitutions must not occur inside verbatim, just in ordinary text.

\begin{Verbatim}[numbers=none,fontsize=\fontsize{9pt}{9pt},baselinestretch=0.95]
# Just to check that ampersand works in code blocks:
c = a & b
\end{Verbatim}

\paragraph{Quotes.}
Let us also add a test of quotes such as ``double quotes, with numbers
like 3.14 and newline/comma and hyphen (as in double--quote)''; written
in the standard LaTeX--style that gives correct {\LaTeX} formatting and
ordinary double quotes for all non--LaTeX formats.  Here is another
sentence that ``caused'' a bug in the past because double backtick
quotes could imply verbatim text up to a verbatim word starting with
period, like \texttt{.txt}.

More quotes to be tested for spellcheck:
(``with parenthesis''), ``with newline''
and ``with comma'', ``hyphen''-wise, and ``period''.

\subsection{Bibliography test}

Here is an example: \cite{Langtangen_Pedersen_2002} discussed propagation of
large destructive water waves, \cite{Langtangen_et_al_2002} gave
an overview of numerical methods for solving the Navier---Stokes equations,
while the use of Backward Kolmogorov equations for analyzing
random vibrations was investigated in \cite{Langtangen_1994a}.
The book chapter \cite{Mardal_et_al_2003a} contains information on
C++ software tools for programming multigrid methods. A real retro
reference is \cite{Langtangen_1988d} about a big FORTRAN package.
Multiple references are also possible, e.g., see
\cite{Langtangen_Pedersen_2002,Mardal_et_al_2003a}.

We need to cite more than 10 papers to reproduce an old formatting
problem with blanks in the keys in reST format:
\cite{Langtangen_1992c,Langtangen_1994a,Mortensen_et_al_2011,Langtangen_Pedersen_2002}
and
\cite{Langtangen_et_al_2002,Glimsdal_et_al_20006,Rahman_et_al_2006b,Haga_et_al_2011a,Langtangen_2003a,Langtangen_2008a,Langtangen:95}
and all the work of
\cite{Langtangen_2012,Mardal_et_al_2003a,Jeberg_et_al_2004} as well as
old work \cite{Langtangen_1988d} and \cite{Langtangen_1989e}, and the
talk \cite{Langtangen_talk_2007a}.
Langtangen also had two thesis \cite{Langtangen:85,Langtangen_1989e}
back in the days.
More retro citations are
the old ME-IN323 book \cite{Langtangen:91} and the
\cite{Langtangen:94b} OONSKI '94 paper.

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Example \thedoconceexercisecounter: Examples can be typeset as exercises}
                \addcontentsline{loe}{doconceexercise}{Example \thedoconceexercisecounter: Examples can be typeset as exercises}
                
\label{Example}

Examples can start with a subsection heading starting with \texttt{Example:}
and then, with the command--line option \Verb!--examples_as_exercises! be
typeset as exercises. This is useful if one has solution
environments as part of the example.

\subex{a)}
State some problem.

\paragraph{Solution.}
The answer to this subproblem can be written here.

\subex{b)}
State some other problem.

\paragraph{Hint 1.}
A hint can be given.

\paragraph{Hint 2.}
Maybe even another hint?

\paragraph{Solution.}
The answer to this other subproblem goes here,
maybe over multiple doconce input lines.

\end{doconceexercise}
% --- end exercise ---

\subsection{User--defined environments}

Example~\vref{ex:test:1p1} demonstrates how to write a test function.
That is, a special test function for a function \texttt{add} appears in
Example~\vref{ex:test:1p1}.

\begin{example}
\label{ex:test:1p1}

\noindent\emph{A test function}.

Suppose we want to write a test function for checking the
implementation of a Python function for addition.

\begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{python}
def add(a, b):
    return a + b

def test_add():
    a = 1; b = 1
    expected = a + b
    computed = add(a, b)
    assert expected == computed
\end{minted}
\end{example}

\begin{example}
\label{ex:math:1p1}

\noindent\emph{Addition}.

We have

\[ 1 + 1 = 2 \]
or in tabular form:


\begin{quote}
\begin{tabular}{cc}
\hline
\multicolumn{1}{c}{ Problem } & \multicolumn{1}{c}{ Result } \\
\hline
$1+1$   & $2$    \\
\hline
\end{tabular}
\end{quote}

\noindent
\end{example}

\begin{tcolorbox}[%skin=widget,
boxrule=1mm,
coltitle=black,
colframe=blue!45!white,
colback=blue!15!white,
width=(.9\linewidth),before=\hfill,after=\hfill,
adjusted title={Highlight box!}]
This environment is used to highlight something:

\[ E = mc^2 \]
\end{tcolorbox}

\subsection{URLs}
\label{subsubsec:ex}

Testing of URLs: hpl's home page \href{{https://folk.uio.no/hpl}}{hpl}\footnote{\texttt{https://folk.uio.no/hpl}}, or
the entire URL if desired, \href{{https://folk.uio.no/hpl}}{\nolinkurl{https://folk.uio.no/hpl}}.  Here is a
plain file link \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}\footnote{\texttt{testdoc.do.txt}}}, or \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}\footnote{\texttt{testdoc.do.txt}}}, or
\href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}\footnote{\texttt{testdoc.do.txt}}} or \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}\footnote{\texttt{testdoc.do.txt}}} or \href{{testdoc.do.txt}}{a link with
newline}\footnote{\texttt{testdoc.do.txt}}. Can test spaces with the link with word
too: \href{{https://folk.uio.no/hpl}}{hpl}\footnote{\texttt{https://folk.uio.no/hpl}} or \href{{https://folk.uio.no/hpl}}{hpl}\footnote{\texttt{https://folk.uio.no/hpl}}. Also \texttt{file:///} works: \href{{file:///home/hpl/vc/doconce/doc/demos/manual/manual.html}}{link to a
file}\footnote{\texttt{file:///home/hpl/vc/doconce/doc/demos/manual/manual.html}} is
fine to have. Moreover, ``loose'' URLs work, i.e., no quotes, just
the plain URL as in \href{{https://folk.uio.no/hpl}}{\nolinkurl{https://folk.uio.no/hpl}}, if followed by space, comma,
colon, semi--colon, question mark, exclamation mark, but not a period
(which gets confused with the periods inside the URL).

Mail addresses can also be used: \href{{mailto:hpl@simula.no}}{\nolinkurl{hpl@simula.no}\footnote{\texttt{mailto:hpl@simula.no}}}, or just a \href{{mailto:hpl@simula.no}}{mail link}\footnote{\texttt{mailto:hpl@simula.no}}, or a raw \href{{mailto:hpl@simula.no}}{\nolinkurl{mailto:hpl@simula.no}\footnote{\texttt{mailto:hpl@simula.no}}}.

Here are some tough tests of URLs, especially for the \texttt{latex} format:
\href{{https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas}}{Newton-Cotes}\footnote{\texttt{https://en.wikipedia.org/wiki/Newton\%E2\%80\%93Cotes\_formulas}} formulas
and a \href{{https://www.springer.com/mathematics/computational+science+%26+engineering/book/978-3-642-23098-1}}{good book}\footnote{\texttt{https://www.springer.com/mathematics/computational+science+\%26+engineering/book/978-3-642-23098-1}}. Need to test
Newton-Cotes with percentage in URL too:
\href{{https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas}}{\nolinkurl{https://en.wikipedia.org/wiki/Newton\%E2\%80\%93Cotes_formulas}}
and \href{{https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae}}{\nolinkurl{https://en.wikipedia.org/wiki/Newton-Cotes\#Open_Newton.E2.80.93Cotes_formulae}} which has a shebang.

For the \texttt{--device=paper} option it is important to test that URLs with
monospace font link text get a footnote
(unless the \Verb!--latex_no_program_footnotelink!
is used), as in this reference to
\href{{https://github.com/hplgit/INF5620/tree/gh-pages/src/decay/experiments/decay_mod.py}}{\nolinkurl{decay_mod}}, \href{{https://tinyurl.com/pwyasaa/formulas.ball1.py}}{\nolinkurl{ball1.py}},
and \href{{https://tinyurl.com/pwyasaa/formulas.ball2.py}}{\nolinkurl{ball2.py}}.

% Comments should be inserted outside paragraphs (because in the rst
% format extra blanks make a paragraph break).

% Note that when there is no https: or file:, it can be a file link
% if the link name is URL, url, "URL", or "url". Such files should,
% if rst output is desired, but placed in a \Verb!_static*! folder.

More tough tests: repeated URLs whose footnotes when using the
\texttt{--device=paper} option must be correct. We have
\href{{https://google.com}}{google}\footnote{\texttt{https://google.com}}, \href{{https://google.com}}{google}\footnote{\texttt{https://google.com}}, and
\href{{https://google.com}}{google}\footnote{\texttt{https://google.com}}, which should result in exactly three
footnotes.

\subsection{Test of Some {\LaTeX} Fixes}

Let's check abbr.~of some common kind, e.g.~the well--known i.e.
expression as an example, and 1 vs.~2 which is also often used.
Dr.~Tang and Prof.~Monsen, or maybe also prof.~Ting,
will go to the Dept.~of Science to test how Mr.~Hansen is doing together
with Ms.~Larsen. A reference like Sec.~\vref{subsubsec:ex} or
Ch.~\vref{subsubsec:ex}, or even App.~\vref{subsubsec:ex}, must also be
handled. Likewise, this is test no.~$i$ of DocOnce features.
Also, look at Fig.~4 to see how the data compares with Tab.~\vref{mytab}.
Percentage must be fixed: 7\%,  87.65\% and
50\% at the beginning of the line.

% !split and check if these extra words are included properly in the comment

\section{{\LaTeX} Mathematics}

Here is an equation without label using backslash--bracket environment:
\[ a = b + c \]

or with number and label, as in (\ref{my:eq1}), using the equation environment:

\begin{equation}
{\partial u\over\partial t} = \nabla^2 u \label{my:eq1}
\end{equation}

We can refer to this equation by (\ref{my:eq1}).

Here is a system without equation numbers, using the align--asterisk environment:

\begin{align*}
\pmb{a} &= \pmb{q}\times\pmb{n} \\ 
b &= \nabla^2 u + \nabla^4 v
\end{align*}

And here is a system of equations with labels in an align environment:

\begin{align}
a &= q + 4 + 5+ 6 \label{eq1} \\ 
b &= \nabla^2 u + \nabla^4 x \label{eq2}
\end{align}

We can refer to (\ref{eq1})-(\ref{eq2}). They are a bit simpler than
the Navier---Stokes equations. And test {\LaTeX} hyphen in \texttt{CG-2}.
Also test $a_{i-j}$ as well as $kx-wt$.

Testing \texttt{alignat} environment:

\begin{alignat}{2}
a &= q + 4 + 5+ 6\qquad & \mbox{for } q\geq 0 \label{eq1a} \\ 
b &= \nabla^2 u + \nabla^4 x & x\in\Omega \label{eq2a}
\end{alignat}

Many of the next environments will fail in non--latex formats.
Testing multiline:

\begin{multline}
a = b = q + \\ 
  f + \nabla\cdot\nabla u
\label{multiline:eq1}
\end{multline}

Testing split:

\begin{equation}
\label{split:envir:eq}
\begin{split}
a = b = q &+ \\ 
  & f + \nabla\cdot\nabla u
\end{split}
\end{equation}
We can refer to the last equation by (\ref{split:envir:eq}).

Testing gather:
\begin{gather}
a = b \\ 
c = d + 7 + 9
\end{gather}

Let us refer to (\ref{eq1})-(\ref{eq2}) again, and to the
alignat variant (\ref{eq1a})-(\ref{eq2a}), and to (\ref{my:eq1}).

Testing eqnarray:
\begin{eqnarray}
{\partial u\over\partial t} &=& \nabla^2 u + f, \label{myeq1}\\ 
{\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g \label{myeq2}
\end{eqnarray}

More mathematical typesetting is demonstrated in the coming exercises.

Below, we have Problem~\vref{demo:ex:1} and Project~\vref{demo:ex:2},
as well as Projects~\vref{proj:circle1} and~\vref{exer:you}, and in
between there we have Exercise~\vref{exer:some:formula}.

\section{Exercises}

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Problem \thedoconceexercisecounter: Flip a Coin}
                \addcontentsline{loe}{doconceexercise}{Problem \thedoconceexercisecounter: Flip a Coin}
                
\label{demo:ex:1}
% keywords = random numbers; Monte Carlo simulation; ipynb

% Torture tests

\subex{a)}
Make a program that simulates flipping a coin $N$ times.
Print out ``tail'' or ``head'' for each flip and
let the program count the number of heads.

% --- begin hint in exercise ---

\paragraph{Hint 1.}
Use \texttt{r = random.random()} and define head as \texttt{r <= 0.5}.

% --- end hint in exercise ---

% --- begin hint in exercise ---

\paragraph{Hint 2.}
Draw an integer among $\{1,2\}$ with
\texttt{r = random.randint(1,2)} and define head when \texttt{r} is 1.

% --- end hint in exercise ---

% --- begin answer of exercise ---
\paragraph{Answer.}
If the \texttt{random.random()} function returns a number $<1/2$, let it be
head, otherwise tail. Repeat this $N$ number of times.
% --- end answer of exercise ---

% --- begin solution of exercise ---
\paragraph{Solution.}
\begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{python}
import sys, random
N = int(sys.argv[1])
heads = 0
for i in range(N):
    r = random.random()
    if r <= 0.5:
        heads += 1
print('Flipping a coin %d times gave %d heads' % (N, heads))
\end{minted}
% --- end solution of exercise ---

\subex{b)}
Vectorize the code in a) using boolean indexing.

Vectorized code can be written in many ways.
Sometimes the code is less intuitive, sometimes not.
At least there is not much to find in Section~\vref{sec1}.

\subex{c)}
Vectorize the code in a) using \texttt{numpy.sum}.

% --- begin answer of exercise ---
\paragraph{Answer.}
\texttt{np.sum(np.where(r <= 0.5, 1, 0))} or \texttt{np.sum(r <= 0.5)}.
% --- end answer of exercise ---

In this latter subexercise, we have an
example where the code is easy to read.

\paragraph{My remarks.}
Remarks with such a subsubsection is treated as more text
after the last subexercise. Test a list too:

\begin{enumerate}
\item Mark 1.

\item Mark 2.
\end{enumerate}

\noindent
\noindent Filenames: \Verb!flip_coin.py!, \Verb!flip_coin.pdf!.

% Closing remarks for this Problem

\paragraph{Remarks.}
These are the exercise remarks, appearing at the very end.

% solution files: mysol.txt, mysol_flip_coin.py, yet_another.file

\end{doconceexercise}
% --- end exercise ---

\subsection{Not an exercise}

Should be possible to stick a normal section in the middle of many
exercises.

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Exercise \thedoconceexercisecounter: Test of plain text exercise}
                \addcontentsline{loe}{doconceexercise}{Exercise \thedoconceexercisecounter: Test of plain text exercise}
                
\label{my:exer1}

Very short exercise. What is the capital
of Norway?
\noindent Filename: \texttt{myexer1}.

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Project \thedoconceexercisecounter: Compute a Probability}
                \addcontentsline{loe}{doconceexercise}{Project \thedoconceexercisecounter: Compute a Probability}
                
\label{demo:ex:2}

% Minimalistic exercise

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval $[0,1)$?

At the end we have a list because that caused problems in {\LaTeX}
in previous DocOnce versions:

\begin{enumerate}
\item item1

\item item2
\end{enumerate}

\noindent
% --- begin hint in exercise ---

\paragraph{Hint.}
To answer this question empirically, let a program
draw $N$ such random numbers using Python's standard \texttt{random} module,
count how many of them, $M$, that fall in the interval $(0.5,0.6)$, and
compute the probability as $M/N$.

% --- end hint in exercise ---

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Project \thedoconceexercisecounter: Explore Distributions of Random Circles}
                \addcontentsline{loe}{doconceexercise}{Project \thedoconceexercisecounter: Explore Distributions of Random Circles}
                
\label{proj:circle1}
% keywords = ipynb

The formula for a circle is given by

\begin{align}
x &= x_0 + R\cos 2\pi t,
\label{circle:x}\\ 
y &= y_0 + R\sin 2\pi t,
\label{circle:y}
\end{align}
where $R$ is the radius of the circle, $(x_0,y_0)$ is the
center point, and $t$ is a parameter in the unit interval $[0,1]$.
For any $t$, $(x,y)$ computed from (\ref{circle:x})-(\ref{circle:y})
is a point on the circle.
The formula can be used to generate \texttt{n} points on a circle:

\begin{python:nt}
import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y

x, y = circle(2.0, 0, 0)
\end{python:nt}

% Often in an exercise we have some comments about the solution
% which we normally want to keep where they are.

The goal of this project is to draw $N$ circles with random
center and radius. Plot each circle using the \texttt{circle} function
above.

\subex{a)}
Let $R$ be normally distributed and $(x_0,y_0)$ uniformly distributed.

% --- begin hint in exercise ---

\paragraph{Hint.}
Use the \texttt{numpy.random} module to draw the
$x_0$, $y_0$, and $R$ quantities.

% --- end hint in exercise ---

% --- begin answer of exercise ---
\paragraph{Answer.}
Here goes the short answer to part a).
% --- end answer of exercise ---

% --- begin solution of exercise ---
\paragraph{Solution.}
Here goes a full solution to part a).
% --- end solution of exercise ---

\subex{b)}
Let $R$ be uniformly distributed and $(x_0,y_0)$ normally distributed.
\noindent Filename: \texttt{norm}.

\subex{c)}
Let $R$ and $(x_0,y_0)$ be normally distributed.

\noindent Filename: \texttt{circles}.

% Closing remarks for this Project

\paragraph{Remarks.}
At the very end of the exercise it may be appropriate to summarize
and give some perspectives.

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Exercise \thedoconceexercisecounter: Determine some Distance}
                \addcontentsline{loe}{doconceexercise}{Exercise \thedoconceexercisecounter: Determine some Distance}
                
\label{exer:dist}

Intro to this exercise. Questions are in subexercises below.

% --- begin solution of exercise ---
\paragraph{Solution.}
Here goes a full solution of the whole exercise.
With some math $a=b$ in this solution:
\[ \hbox{math in solution: } a = b \]
And code \texttt{a=b} in this solution:
\begin{Verbatim}[numbers=none,fontsize=\fontsize{9pt}{9pt},baselinestretch=0.95]
a = b  # code in solution
\end{Verbatim}
End of solution is here.

% --- end solution of exercise ---

\subex{a)}
Subexercises are numbered a), b), etc.

% --- begin hint in exercise ---

\paragraph{Hint 1.}
First hint to subexercise a).
With math $a=b$ in hint:

\[ a=b. \]
And with code (in plain verbatim) returning $x+1$ in hint:

\begin{Verbatim}[numbers=none,fontsize=\fontsize{9pt}{9pt},baselinestretch=0.95]
def func(x):
    return x + 1  # with code in hint
\end{Verbatim}

% --- end hint in exercise ---

% --- begin hint in exercise ---

\paragraph{Hint 2.}
Second hint to subexercise a).

Test list in hint:

\begin{enumerate}
\item item1

\item item2
\end{enumerate}

\noindent
% --- end hint in exercise ---
\noindent Filename: \Verb!subexer_a.pdf!.

% --- begin answer of exercise ---
\paragraph{Answer.}
Short answer to subexercise a).
With math in answer: $a=b$.
% --- end answer of exercise ---

\subex{b)}
Here goes the text for subexercise b).

Some math $\cos^2 x + \sin^2 x = 1$ written one a single line:

\[ \cos^2 x + \sin^2 x = 1 \thinspace .\]

% --- begin hint in exercise ---

\paragraph{Hint.}
A hint for this subexercise.

% --- end hint in exercise ---
\noindent Filename: \Verb!subexer_b.pdf!.

% --- begin solution of exercise ---
\paragraph{Solution.}
Here goes the solution of this subexercise.
% --- end solution of exercise ---

% No meaning in this weired test example:
The text here belongs to the main (intro) part of the exercise. Need
closing remarks to have text after subexercises.

Test list in exercise:

\begin{enumerate}
\item item1

\item item2
% Closing remarks for this Exercise
\end{enumerate}

\noindent
\paragraph{Remarks.}
Some final closing remarks, e.g., summarizing the main findings
and their implications in other problems can be made. These
remarks will appear at the end of the typeset exercise.

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}

\exercisesection{Some exercise without the "Exercise:" prefix}
\addcontentsline{loe}{doconceexercise}{Some exercise without the "Exercise:" prefix}


% Another minimalistic exercise

Just some text. And some math saying that $e^0=1$ on a single line,
to test that math block insertion is correct:

\[ \exp{(0)} = 1 \]

And a test that the code \texttt{lambda x: x+2} is correctly placed here:

\begin{Verbatim}[numbers=none,fontsize=\fontsize{9pt}{9pt},baselinestretch=0.95]
lambda x: x+2
\end{Verbatim}

% Have some comments at the end of the exercise to see that
% the Filename: ... is written correctly.
\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Exercise \thedoconceexercisecounter: Solution of differential equation}
                \addcontentsline{loe}{doconceexercise}{Exercise \thedoconceexercisecounter: Solution of differential equation}
                
\label{sec:this:exer:de}


\begin{doconcequiz}
\refstepcounter{doconcequizcounter}
\label{quiz:diff:eq1}


\noindent\textbf{\large SOlution of differential equation}

\noindent
Given

\[ \frac{dy}{dx} = -y(x),\quad y(0)=1 \]
What is the solution of this equation?

\vspace{2mm}

\textbf{A}. 
$y=e^{-y}$

\textbf{B}. 
$y=e^{y}$

\textbf{C}. 
\begin{minted}[fontsize=\fontsize{9pt}{9pt},linenos=false,mathescape,baselinestretch=1.0,fontfamily=tt,xleftmargin=7mm]{python}
from math import exp
def f(x):
    return exp(x)
\end{minted}

\textbf{D}. 
The solution cannot be found because there is a derivative in the equation.

\textbf{E}. 
The equation is meaningless: an equation must be an equation
for $x$ or $y$, not a function $y(x)$.


% --- begin answer of exercise ---
\paragraph{Answer:} A.
% --- end answer of exercise ---

% --- begin solution of exercise ---
\noindent {\bf Solution:}\\


\textbf{A}: Right. 

\textbf{B}: Wrong. Almost, but the sign is wrong (note the minus!).

\textbf{C}: Wrong. Ooops, forgot a minus: \texttt{exp(-x)}, otherwise this Python code
must be considered as a good answer. It is more natural,
though, to write the solution to the problem
in mathematical notation:

\[ y(x) = e^{-y}.\]

\textbf{D}: Wrong. Equations with derivatives can be solved;
they are termed \emph{differential
equations}.

\textbf{E}: Wrong. Equations where the unknown is a function, as $y(x)$
here, are called \emph{differential equations}, and are solved by
special techniques.


% --- end solution of exercise ---


\vspace{3mm}

\end{doconcequiz}



\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Example \thedoconceexercisecounter: Just an example}
                \addcontentsline{loe}{doconceexercise}{Example \thedoconceexercisecounter: Just an example}
                

% This example needs the --examples_as_exercises option, otherwise
% it is just typeset as it is written.

\subex{a)}
What is the capital of Norway?

\paragraph{Answer.}
Oslo.

\end{doconceexercise}
% --- end exercise ---

\section{Here goes another section}

With some text, before we continue with exercises.

\section{More Exercises}

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Exercise \thedoconceexercisecounter: Make references to projects and problems}
                \addcontentsline{loe}{doconceexercise}{Exercise \thedoconceexercisecounter: Make references to projects and problems}
                
\label{exer:some:formula}

% Test comments not at the end only
Pick a statement from Project~\vref{proj:circle1} or Problem~\vref{demo:ex:1}
and verify it.

Test list at the end of an exercise without other elements (like subexercise,
hint, etc.):

\begin{enumerate}
\item item1

\item item2
\end{enumerate}

\noindent
\noindent Filename: \Verb!verify_formula.py!.

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Project \thedoconceexercisecounter: References to Project~\vref{demo:ex:2} in a heading works for pdflatex}
                \addcontentsline{loe}{doconceexercise}{Project \thedoconceexercisecounter: References to Project~\vref{demo:ex:2} in a heading works for pdflatex}
                
\label{exer:you}

Refer to the previous exercise as Exercise~\vref{exer:some:formula},
the two before that as Projects~\vref{demo:ex:2} and~\vref{proj:circle1},
and this one as Project~\vref{exer:you}.
\noindent Filename: \Verb!selc_composed.pdf!.

\end{doconceexercise}
% --- end exercise ---

\bibliographystyle{plain}
\bibliography{papers}



\appendix

\section{Just for testing; part I}
\label{app1}

This is the first appendix.

\subsection{A subsection within an appendix}

Some text.

\section{Just for testing; part II}
\label{app2}

This is more stuff for an appendix.

\subsection{Appendix: Testing identical titles}

Without label.

\subsection{Appendix: Testing identical titles}
\label{test:title:id1}

With label.

\subsection{Appendix: Testing identical titles}
\label{test:title:id2}

What about inserting a quiz?


\begin{doconcequiz}
\refstepcounter{doconcequizcounter}
\label{quiz:2}


\noindent\textbf{\large Capital of Norway}
\paragraph{Fundamental test:}
What is the capital of Norway?

\vspace{2mm}

\textbf{A}. 
Stockholm

\textbf{B}. 
London

\textbf{C}. 
Oslo

\textbf{D}. 
Bergen


% --- begin answer of exercise ---
\paragraph{Answer:} C.
% --- end answer of exercise ---

% --- begin solution of exercise ---
\noindent {\bf Solution:}\\


\textbf{A}: Wrong. Stockholm is the capital of Sweden.

\textbf{B}: Wrong. 

\textbf{C}: Right. 

\textbf{D}: Wrong. Those from Bergen would claim so, but nobody else.


% --- end solution of exercise ---


\vspace{3mm}

\end{doconcequiz}



\subsection{Appendix: Testing identical titles}

Without label.


\begin{notice_mdfboxadmon}[Tip.]
Here is a tip or hint box, typeset as a notice box.
\end{notice_mdfboxadmon} % title: Tip.



\clearpage

Need a lot of text to surround the summary box.
Version control systems allow you to record the history of files
and share files among several computers and collaborators in a
professional way. File changes on one computer are updated or
merged with changes on another computer. Especially when working
with programs or technical reports it is essential
to have changes documented and to
ensure that every computer and person involved in the project
have the latest updates of the files.
Greg Wilson' excellent \href{{https://software--carpentry.org/2010/07/script--for-introduction-to--version-control/}}{Script for Introduction to Version Control}\footnote{\texttt{https://software--carpentry.org/2010/07/script--for-introduction-to--version-control/}} provides a more detailed motivation why you will benefit greatly
from using version control systems.


\begin{summary_mdfboxadmon}[Summary.]
\textbf{Bold remark:} Make some text with this summary.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
\end{summary_mdfboxadmon} % title: Summary.



Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that site. I strongly
recommend you to use such sites for all serious programming and
scientific writing work - and all other important files.

The simplest services for hosting project files are \href{{https://dropbox.com}}{Dropbox}\footnote{\texttt{https://dropbox.com}} and \href{{https://drive.google.com}}{Google Drive}\footnote{\texttt{https://drive.google.com}}.
It is very easy to get started with these systems, and they allow you
to share files among laptops and mobile units with as many users as
you want. The systems offer a kind of version control in that the
files are stored frequently (several times per minute), and you can go
back to previous versions for the last 30 days. However, it is
challenging  to find the right version from the past when there are
so many of them.

More seriously, when several people may edit files simultaneously, it
can be difficult detect who did what when, roll back to previous
versions, and to manually merge the edits when these are
incompatible. Then one needs more sophisticated tools than Dropbox or
Google Drive: project hosting services with true version control
systems.  The following text aims at providing you with the minimum
information to started with such systems. Numerous other tutorials
contain more comprehensive material and in--depth explanations of the
concepts and tools.

The idea with project hosting services is that you have the files
associated with a project in the cloud. Many people may share these
files.  Every time you want to work on the project you explicitly
update your version of the files, edit the files as you like, and
synchronize the files with the "master version" at the site where the
project is hosted.  If you at some point need to go back to a
version of the files at some particular point in the past,
this is an easy operation. You can also use tools to see
what various people have done with the files in the various versions.

All these services are very similar. Below we describe how you get
started with Bitbucket, GitHub, and Googlecode. Launchpad works very
similarly to the latter three. All the project hosting services have
excellent introductions available at their web sites, but the recipes
below are much shorter and aim at getting you started as quickly as
possible by concentrating on the most important need-to--know steps.
The Git tutorials we refer to later in this document contain more
detailed information and constitute of course very valuable readings
when you use version control systems every day. The point now is
to get started.

\subsection{Appendix: Testing inline comments}

% Names can be [ A-Za-z0-9_'+-]+

Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that
site. \shortinlinecomment{hpl's semi opinion 1}{ not sure if in the cloud is understood by all. }{ not sure if in } I strongly recommend you to use such sites for all serious
programming and scientific writing work - and all other important
files.

The simplest services for hosting project files is Dropbox. \longinlinecomment{mp 2}{ Simply go to \href{{https://dropbox.com}}{\nolinkurl{https://dropbox.com}} and watch the video. It explains how files, like \texttt{myfile.py}, perhaps containing much math, like $\partial u/\partial t$, are easily communicated between machines. }{ Simply go to \href{{https://dropbox.com}}{\nolinkurl{https://dropbox.com}} } It
is very easy to get started with Dropbox, and it allows you to share
files among \textcolor{red}{(hpl 3:)} \replace{laptops and mobile units}{computers, tablets, and phones}.

% Test horizontal rule

------

% Coments for editing

First\textcolor{red}{, (\textbf{edit 4}: add comma)} consider a quantity $Q$. \textcolor{red}{(edit 5:)} \replace{To this end,}{We note that}
$Q>0$, because (\textbf{edit 6}:) \remove{a} negative \textcolor{red}{(edit 7:)} \replace{quantity is}{quantities are} (\textbf{edit 8}:) \remove{just} negative.  \textcolor{red}{ (\textbf{edit 9}:) This comes as no surprise.}

% Test tailored latex figure references with page number
Let us refer to Figure~\vref{fig:impact} again.

Test references in a list:

\begin{itemize}
 \item \vref{sec1}

 \item \vref{subsec1}

 \item \vref{fig:impact}
\end{itemize}

\noindent
\subsection{Appendix: Testing headings ending with \texttt{verbatim inline} }

The point here is to test 1) \texttt{verbatim} code in headings, and 2)
ending a heading with verbatim code as this triggers a special
case in {\LaTeX}.

We also test mdash---used as alternative to hyphen without spaces around,
or in quotes:


\begin{quote}
\emph{Fun is fun}.---Unknown.
\end{quote}


The ndash should also be tested -- as in the Hanson---Nilson equations
on page 277--278.

And finally, what about admons, quotes, and boxes? They are tested
in a separate document: \texttt{admon.do.txt}.


% ------------------- end of main content ---------------

\cleardoublepage\phantomsection  % trick to get correct link to Index
\printindex

\end{document}

************** File: testdoc.tex_direct *****************
%%
%% Automatically generated file from DocOnce source
%% (https://github.com/doconce/doconce/)
%%

% #define PREAMBLE

% #ifdef PREAMBLE
%-------------------- begin preamble ----------------------

\documentclass[%
oneside,                 % oneside: electronic viewing, twoside: printing
final,                   % draft: marks overfull hboxes, figures with paths
10pt]{article}

\listfiles               %  print all files needed to compile this document

\usepackage{relsize,makeidx,color,setspace,amsmath,amsfonts,amssymb}
\usepackage[table]{xcolor}
\usepackage{bm,ltablex,microtype}

\usepackage[pdftex]{graphicx}
\usepackage{sidecap}

% user-provided packages: --latex_packages=varioref
\usepackage{varioref}

% 'on page ...' reference with \vref{} and varioref package
\renewcommand\reftextfaceafter{on page~\thevpagerefnum}
\renewcommand\reftextfacebefore{on page~\thevpagerefnum}
\renewcommand\reftextafter{on page~\thevpagerefnum}
\renewcommand\reftextbefore{on page~\thevpagerefnum}

% Tools for marking corrections
\usepackage{soul}
\newcommand{\replace}[2]{{\color{red}\text{\st{#1} #2}}}
\newcommand{\remove}[1]{{\color{red}\st{#1}}}

% Packages for typesetting blocks of computer code
\usepackage{fancyvrb,framed,moreverb}

% Define colors
\definecolor{orange}{cmyk}{0,0.4,0.8,0.2}
\definecolor{tucorange}{rgb}{1.0,0.64,0}
\definecolor{darkorange}{rgb}{.71,0.21,0.01}
\definecolor{darkgreen}{rgb}{.12,.54,.11}
\definecolor{myteal}{rgb}{.26, .44, .56}
\definecolor{gray}{gray}{0.45}
\definecolor{mediumgray}{gray}{.8}
\definecolor{lightgray}{gray}{.95}
\definecolor{brown}{rgb}{0.54,0.27,0.07}
\definecolor{purple}{rgb}{0.5,0.0,0.5}
\definecolor{darkgray}{gray}{0.25}
\definecolor{darkblue}{rgb}{0,0.08,0.45}
\definecolor{darkblue2}{rgb}{0,0,0.8}
\definecolor{lightred}{rgb}{1.0,0.39,0.28}
\definecolor{lightgreen}{rgb}{0.48,0.99,0.0}
\definecolor{lightblue}{rgb}{0.53,0.81,0.92}
\definecolor{lightblue2}{rgb}{0.3,0.3,1.0}
\definecolor{lightpurple}{rgb}{0.87,0.63,0.87}
\definecolor{lightcyan}{rgb}{0.5,1.0,0.83}

\colorlet{comment_green}{green!50!black}
\colorlet{string_red}{red!60!black}
\colorlet{keyword_pink}{magenta!70!black}
\colorlet{indendifier_green}{green!70!white}

% Backgrounds for code
\definecolor{cbg_gray}{rgb}{.95, .95, .95}
\definecolor{bar_gray}{rgb}{.92, .92, .92}

\definecolor{cbg_yellowgray}{rgb}{.95, .95, .85}
\definecolor{bar_yellowgray}{rgb}{.95, .95, .65}

\colorlet{cbg_yellow2}{yellow!10}
\colorlet{bar_yellow2}{yellow!20}

\definecolor{cbg_yellow1}{rgb}{.98, .98, 0.8}
\definecolor{bar_yellow1}{rgb}{.98, .98, 0.4}

\definecolor{cbg_red1}{rgb}{1, 0.85, 0.85}
\definecolor{bar_red1}{rgb}{1, 0.75, 0.85}

\definecolor{cbg_blue1}{rgb}{0.87843, 0.95686, 1.0}
\definecolor{bar_blue1}{rgb}{0.7,     0.95686, 1}

%\setlength{\fboxsep}{2mm}  % adjust cod_vpad/pro_vpad background box

%% Background for code blocks (parameter is color name)

%% pro/cod_vpad: gives some vertical padding before and after the text
%% (but has more simplistic code than _cod/pro_tight+cod/pro).
%% pro/cod_vpad can be used to enclose Verbatim or lst begin/end for code.
%% pro/cod calls _pro/cod_tight and has very little vertical padding,
%% used to enclose Verbatim and other begin/end for code.
%% (pro/cod is what the ptex2tex program could produce with the
%% Blue/BlueBar definitions in .ptex2tex.cfg.)

\newenvironment{cod_vpad}[1]{
   \def\FrameCommand{\colorbox{#1}}
   \MakeFramed{\FrameRestore}}
   {\endMakeFramed}

\newenvironment{_cod_tight}[1]{
   \def\FrameCommand{\colorbox{#1}}
   \FrameRule0.6pt\MakeFramed {\FrameRestore}\vskip3mm}
   {\vskip0mm\endMakeFramed}

\newenvironment{cod}[1]{
\bgroup\rmfamily
\fboxsep=0mm\relax
\begin{_cod_tight}{#1}
\list{}{\parsep=-2mm\parskip=0mm\topsep=0pt\leftmargin=2mm
\rightmargin=2\leftmargin\leftmargin=4pt\relax}
\item\relax}
{\endlist\end{_cod_tight}\egroup}

%% Background for complete program blocks (parameter 1 is color name
%% for background, parameter 2 is color for left bar)
\newenvironment{pro_vpad}[2]{
   \def\FrameCommand{\color{#2}\vrule width 1mm\normalcolor\colorbox{#1}}
   \MakeFramed{\FrameRestore}}
   {\endMakeFramed}

\newenvironment{_pro_tight}[2]{
   \def\FrameCommand{\color{#2}\vrule width 1mm\normalcolor\colorbox{#1}}
   \FrameRule0.6pt\MakeFramed {\advance\hsize-2mm\FrameRestore}\vskip3mm}
   {\vskip0mm\endMakeFramed}

\newenvironment{pro}[2]{
\bgroup\rmfamily
\fboxsep=0mm\relax
\begin{_pro_tight}{#1}{#2}
\list{}{\parsep=-2mm\parskip=0mm\topsep=0pt\leftmargin=2mm
\rightmargin=2\leftmargin\leftmargin=4pt\relax}
\item\relax}
{\endlist\end{_pro_tight}\egroup}

\usepackage{listingsutf8}

% Common lstlisting parameters

\usepackage{calc}
\newlength{\lstboxwidth}  % width of lst box
\newlength{\framethickness}
\setlength{\framethickness}{0.5mm}
% for frame=trbl and a framerule that has significant size, set
% xleftmargin=5mm and xrightmargin=5mm.

\lstset{
  basicstyle=\small \ttfamily,
  breaklines=false,          % break/wrap lines
  breakatwhitespace=true,    % let linebreaks happen at whitespace
  breakindent=40pt,
  tab=,
  tabsize=4,                 % tab means 4 spaces
  %belowskip=\smallskipamount,  % space between code and text below
  xleftmargin=2mm,           % indentation of code frame
  xrightmargin=0mm,
  framexleftmargin=2mm,      % add frame space to the left of the code box
  %numbers=left,             % put line numbers on the left
  %stepnumber=2,             % stepnumber=1 numbers each line, =n every n lines
  framerule=\framethickness, % thickness of frame
  aboveskip=2ex,             % vertical space above code frame
  showstringspaces=false,    % show spaces in strings with an underscore
  showspaces=false,          % show spaces with an underscore
  showtabs=false,
  keepspaces=true,
  columns=fullflexible,      % tighter character kerning, like verb
  escapeinside={(*@}{@*)},   % (*@ \pause @*) in slides and math in code blocks
  extendedchars=\true,       % allows non-ascii chars, does not work with utf-8
}

% Internally defined styles for lstlisting

\lstdefinestyle{simple}{
commentstyle={},
}

% user-defined lst styles in file "mylststyles":
\lstdefinestyle{myspeciallststyle}{
keywordstyle=\color{blue}\bfseries,
commentstyle=\color{myteal},
stringstyle=\color{darkgreen},
identifierstyle=\color{darkorange},
}

% end of custom lstdefinestyles

\usepackage[T1]{fontenc}
%\usepackage[latin1]{inputenc}
\usepackage{ucs}
\usepackage[utf8x]{inputenc}

\usepackage{lmodern}         % Latin Modern fonts derived from Computer Modern

\newenvironment{doconcequiz}{}{}
\newcounter{doconcequizcounter}

% Hyperlinks in PDF:
\definecolor{linkcolor}{rgb}{0,0,0.4}
\usepackage{hyperref}
\hypersetup{
    breaklinks=true,
    colorlinks=true,
    linkcolor=linkcolor,
    urlcolor=linkcolor,
    citecolor=black,
    filecolor=black,
    %filecolor=blue,
    pdfmenubar=true,
    pdftoolbar=true,
    bookmarksdepth=3   % Uncomment (and tweak) for PDF bookmarks with more levels than the TOC
    }
%\hyperbaseurl{}   % hyperlinks are relative to this root

\setcounter{tocdepth}{2}  % levels in table of contents

%\VerbatimFootnotes must come after hyperref and footmisc packages
\VerbatimFootnotes

% Tricks for having figures close to where they are defined:
% 1. define less restrictive rules for where to put figures
\setcounter{topnumber}{2}
\setcounter{bottomnumber}{2}
\setcounter{totalnumber}{4}
\renewcommand{\topfraction}{0.95}
\renewcommand{\bottomfraction}{0.95}
\renewcommand{\textfraction}{0}
\renewcommand{\floatpagefraction}{0.75}
% floatpagefraction must always be less than topfraction!
% 2. ensure all figures are flushed before next section
\usepackage[section]{placeins}
% 3. enable begin{figure}[H] (often leads to ugly pagebreaks)
%\usepackage{float}\restylefloat{figure}

% newcommands for typesetting inline (doconce) comments
\newcommand{\shortinlinecomment}[3]{{\color{red}{\bf #1}: #2}}
\newcommand{\longinlinecomment}[3]{{\color{red}{\bf #1}: #2}}

\usepackage[framemethod=TikZ]{mdframed}

% --- begin definitions of admonition environments ---

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "notice" admon
\colorlet{mdfbox_notice_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_notice_background,
  linecolor=black,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=mdfbox_notice_background,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{notice_mdfboxmdframed}

\newenvironment{notice_mdfboxadmon}[1][]{
\begin{notice_mdfboxmdframed}[frametitle=#1]
}
{
\end{notice_mdfboxmdframed}
}

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "summary" admon
\colorlet{mdfbox_summary_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_summary_background,
  linecolor=black,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=mdfbox_summary_background,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{summary_mdfboxmdframed}

\newenvironment{summary_mdfboxadmon}[1][]{
\begin{summary_mdfboxmdframed}[frametitle=#1]
}
{
\end{summary_mdfboxmdframed}
}

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "warning" admon
\colorlet{mdfbox_warning_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_warning_background,
  linecolor=black,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=mdfbox_warning_background,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{warning_mdfboxmdframed}

\newenvironment{warning_mdfboxadmon}[1][]{
\begin{warning_mdfboxmdframed}[frametitle=#1]
}
{
\end{warning_mdfboxmdframed}
}

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "question" admon
\colorlet{mdfbox_question_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_question_background,
  linecolor=black,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=mdfbox_question_background,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{question_mdfboxmdframed}

\newenvironment{question_mdfboxadmon}[1][]{
\begin{question_mdfboxmdframed}[frametitle=#1]
}
{
\end{question_mdfboxmdframed}
}

% Admonition style "mdfbox" is an oval colored box based on mdframed
% "block" admon
\colorlet{mdfbox_block_background}{gray!5}
\newmdenv[
  skipabove=15pt,
  skipbelow=15pt,
  outerlinewidth=0,
  backgroundcolor=mdfbox_block_background,
  linecolor=black,
  linewidth=2pt,       % frame thickness
  frametitlebackgroundcolor=mdfbox_block_background,
  frametitlerule=true,
  frametitlefont=\normalfont\bfseries,
  shadow=false,        % frame shadow?
  shadowsize=11pt,
  leftmargin=0,
  rightmargin=0,
  roundcorner=5,
  needspace=0pt,
]{block_mdfboxmdframed}

\newenvironment{block_mdfboxadmon}[1][]{
\begin{block_mdfboxmdframed}[frametitle=#1]
}
{
\end{block_mdfboxmdframed}
}

% --- end of definitions of admonition environments ---

% prevent orhpans and widows
\clubpenalty = 10000
\widowpenalty = 10000

\usepackage{calc}

\newenvironment{doconceexercise}{}{}
\newcounter{doconceexercisecounter}
% --- begin definition of \listofexercises command ---
\makeatletter
\newcommand\listofexercises{\section*{List of Examples, Exercises, Problems, and Projects}
\@starttoc{loe}
}
\newcommand*{\l@doconceexercise}{\@dottedtocline{0}{0pt}{6.5em}}
\makeatother
% --- end definition of \listofexercises command ---



% ------ header in subexercises ------
%\newcommand{\subex}[1]{\paragraph{#1}}
%\newcommand{\subex}[1]{\par\vspace{1.7mm}\noindent{\bf #1}\ \ }
\makeatletter
% 1.5ex is the spacing above the header, 0.5em the spacing after subex title
\newcommand\subex{\@startsection{paragraph}{4}{\z@}%
                  {1.5ex\@plus1ex \@minus.2ex}%
                  {-0.5em}%
                  {\normalfont\normalsize\bfseries}}
\makeatother


% --- end of standard preamble for documents ---


\usepackage{amsthm,tcolorbox}
\theoremstyle{definition}
\newtheorem{example}{Example}[section]



% insert custom LaTeX commands...

\raggedbottom
\makeindex
\usepackage[totoc]{idxlayout}   % for index in the toc
\usepackage[nottoc]{tocbibind}  % for references/bibliography in the toc

%-------------------- end preamble ----------------------

\begin{document}

% matching end for #ifdef PREAMBLE
% #endif

\newcommand{\exercisesection}[1]{\subsection*{#1}}

\input{newcommands_bfmath}
\input{newcommands_replace}

% ------------------- main content ----------------------



% ----------------- title -------------------------

\thispagestyle{empty}

\begin{center}
{\LARGE\bf
\begin{spacing}{1.25}
A Document for Testing DocOnce
\end{spacing}
}
\end{center}

% ----------------- author(s) -------------------------

\begin{center}
{\bf Hans Petter Langtangen${}^{1, 2}$ (\texttt{hpl@simula.no})} \\ [0mm]
\end{center}


\begin{center}
{\bf Kaare Dump${}^{3}$} \\ [0mm]
\end{center}


\begin{center}
{\bf A. Dummy Author${}^{}$} \\ [0mm]
\end{center}


\begin{center}
{\bf I. S. Overworked and Outburned${}^{4, 5, 6, 7}$} \\ [0mm]
\end{center}


\begin{center}
{\bf J. Doe${}^{}$ (\texttt{j\_doe@cyberspace.com})} \\ [0mm]
\end{center}

\begin{center}
% List of all institutions:
\centerline{{\small ${}^1$Center for Biomedical Computing, Simula Research Laboratory}}
\centerline{{\small ${}^2$Department of Informatics, University of Oslo}}
\centerline{{\small ${}^3$Segfault, Cyberspace}}
\centerline{{\small ${}^4$Inst1}}
\centerline{{\small ${}^5$Inst2, Somewhere}}
\centerline{{\small ${}^6$Third Inst, Elsewhere}}
\centerline{{\small ${}^7$Fourth Inst}}
\end{center}
    
% ----------------- end author(s) -------------------------

% --- begin date ---
\begin{center}
Jan 32, 2100
\end{center}
% --- end date ---

\vspace{1cm}


\tableofcontents

\vspace{1cm} % after toc

% !split

The format of this document is
plain, homemade \textsc{pdf}{\LaTeX} (from DocOnce).

\begin{abstract}
This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.

% Cannot demonstrate chapter headings since abstract and chapter
% are mutually exclusive in {\LaTeX}
\end{abstract}

\section{Section 1}
\label{sec1}

Here is a nested list:

\begin{itemize}
  \item item1

  \item item2

  \item item3 which continues
    on the next line to test that feature

  \item and a sublist
\begin{itemize}

    \item with indented subitem1

    \item and a subitem2

\end{itemize}

\noindent
  \item and perhaps an ordered sublist
\begin{enumerate}

   \item first item

   \item second item,
      continuing on a new line
\end{enumerate}

\noindent
\end{itemize}

\noindent
\paragraph{Here is a list with paragraph heading.}

\begin{itemize}
  \item item1

  \item item2
\end{itemize}

\noindent
\paragraph{Here is a list with subsubsection heading.}
\begin{itemize}
  \item item1

  \item item2
\end{itemize}

\noindent

\begin{quote}
Here are two lines that make up
a block quote for testing \emph{emphasized words} and \textbf{boldface words},
also with hypens:
\emph{pre}-fix, post-\emph{fix}, \textbf{pre}-fix, post-\textbf{fix}.
\end{quote}


Here are two references. Equation~(\ref{my:eq1}) is fine. Eq.~(\ref{my:eq1}) too.
Even Equation (\ref{my:eq1}) without the tilde.

\subsection{Subsection 1}
\label{subsec1}

\index{somefunc@{\rm\texttt{somefunc}} function}

% Refer to section/appendix etc. at the beginning of the line
% and other special fix situations for HTML.

More text, with a reference back to
Section~\vref{sec1} and~\vref{subsec1}, and further to the
sections~\vref{subsec1} and~\vref{subsubsec:ex}, which
encourages you to do the tasks in the
Exercises~\vref{demo:ex:1} and~\vref{exer:some:formula}.
Appendices~\vref{app1} and~\vref{app2} are also nice elements.

\paragraph{Test Section reference at beginning of line and after a sentence.}
Section~\vref{subsec1} is fine.
Section~\vref{subsubsec:ex} too.

% sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console

\paragraph{Computer code.}
Let's do some copying from files too. First from subroutine up to the very end,

\begin{cod}{cbg_gray}\begin{Verbatim}[numbers=none,fontsize=\fontsize{9pt}{9pt},baselinestretch=0.95,xleftmargin=2mm]
      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
\end{Verbatim}
\end{cod}
\noindent
and then just the subroutine,
\begin{cod}{cbg_gray}\begin{Verbatim}[numbers=none,fontsize=\fontsize{9pt}{9pt},baselinestretch=0.95,xleftmargin=2mm]

      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
\end{Verbatim}
\end{cod}
\noindent
and finally the complete file with a plain text verbatim environment
(\texttt{envir=ccq}):
\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
C     a comment

      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
\end{lstlisting}\end{cod}
\noindent

Testing other code environments. First Python:

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
!bc pycod
def f(x):
    return x+1
!ec
\end{lstlisting}\end{cod}
\noindent
which gets rendered as

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
def f(x):
    return x+1
\end{lstlisting}\end{cod}
\noindent

Test paragraph and subsubsection headings before
before code.

\paragraph{Paragraph heading before code.}

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
import sys
sys.path.insert(0, os.pardir)
\end{lstlisting}\end{cod}
\noindent

\paragraph{Subsubsection heading before code.}
\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
def h(z):
    return z+1
\end{lstlisting}\end{cod}
\noindent

Now a complete program to be shown via Python Online Tutorial:

\begin{pro}{cbg_blue1}{bar_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
class Line:
    def __init__(self, a, b):
        self.a, self.b = a, b

    def __call__(self, x):
        a, b = self.a, self.b
        return a*x + b

line = Line(2, 1)
y = line(x=3)
print(y)
\end{lstlisting}\end{pro}
\noindent
\noindent
(\href{{https://pythontutor.com/visualize.html\#code=class+Line\%3A\%0A++++def+__init__\%28self\%2C+a\%2C+b\%29\%3A\%0A++++++++self.a\%2C+self.b+\%3D+a\%2C+b\%0A\%0A++++def+__call__\%28self\%2C+x\%29\%3A\%0A++++++++a\%2C+b+\%3D+self.a\%2C+self.b\%0A++++++++return+a\%2Ax+\%2B+b\%0A\%0Aline+\%3D+Line\%282\%2C+1\%29\%0Ay+\%3D+line\%28x\%3D3\%29\%0Aprint\%28y\%29&mode=display&cumulative=false&heapPrimitives=false&drawParentPointers=false&textReferences=false&py=2&curInstr=0}}{Visualize execution}) 


Some more Python code (actually specified as a sage cell, but
such cells are not supported by this format).

\begin{pro}{cbg_blue1}{bar_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
a = 2
b = 3
print('a+b:', a + b)

# In a sage cell we can also plot
from matplotlib.pyplot import *
from numpy import *
x = linspace(0, 4*pi, 101)
y = exp(-0.1*x)*cos(x)
plot(x, y)
xlabel('x'); ylabel('y')
show()
\end{lstlisting}\end{pro}
\noindent

Then Cython (with -h option so it is hidden in html/sphinx):

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
cpdef f(double x):
    return x + 1
\end{lstlisting}\end{cod}
\noindent

Standard Python shell sessions:

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
\end{lstlisting}\end{cod}
\noindent

Similar IPython sessions:

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
In [1]: from numpy import linspace, sin
In [2]: # Some comment
In [3]: x = linspace(0, 2, 11)
In [4]: y = sin(x)
In [5]: y[0]
Out[5]: 0
In [6]: import matplotlib.pyplot as plt
In [7]: plt.plot(x, y)
In [8]: a='multiple-\nline\noutput'
In [9]: a
Out[9]: 'multiple-\nline\noutput'
In [10]: print(a)
multiple-
line
output
\end{lstlisting}\end{cod}
\noindent

Here is the interactive session again, but with \texttt{pyshell-t}.

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
\end{lstlisting}\end{cod}
\noindent

% This one tests a + sign before a code environment
C++:
\begin{pro}{cbg_blue1}{bar_blue1}\begin{lstlisting}[language=C++,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
#include <iostream>

int main()
{
   std::cout << "Sample output" << std::endl;
   return 0
}
\end{lstlisting}\end{pro}
\noindent
% The next should get correctly typset in sphinx (cod is fcod)
% It also tests emoji before code
And a little bit of Fortran: \raisebox{-\height+\ht\strutbox}{\includegraphics[height=1.5em]{latex_figs/dizzy_face.png}}

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
!bc cod
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
!ec
\end{lstlisting}\end{cod}
\noindent
which then is typeset as

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
\end{lstlisting}\end{cod}
\noindent

HTML:

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=HTML,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
<table>
<tr><td>Column 1</td><td>Column 2</td></tr>
<tr><td>0.67526 </td><td>0.92871 </td></tr>
<!-- comment -->
</table>
\end{lstlisting}\end{cod}
\noindent

But inline HTML code is also important, like text that starts with
\texttt{<a href="} (which can destroy the following text if not properly
quoted).

Matlab with comments requires special typesetting:

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Matlab,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
% Comment on the beginning of the line can be escaped by %%
if a > b
  % Indented comment needs this trick
  c = a + b
end
\end{lstlisting}\end{cod}
\noindent

And here is a system call:

\begin{Verbatim}[frame=lines,label=\fbox{{\tiny Terminal}},framesep=2.5mm,framerule=0.7pt]
Terminal> mkdir test
Terminal> cd test
Terminal> myprog -f
output1
output2
\end{Verbatim}

Any valid pygments lexer/language name can appear to, e.g.,

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
!bc restructuredtext
=======
Heading
=======

Some text.
!ec
\end{lstlisting}\end{cod}
\noindent
results in

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
=======
Heading
=======

Some text.
\end{lstlisting}\end{cod}
\noindent

% Here goes hidden code.
% Python can be treated by some formats, Fortran is always out.





Finally, \Verb?!bc do? supports highlighting of DocOnce source:

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
======= DocOnce test file =======

===== Computer code =====

Inline verbatim code, as in `import numpy as np`, is allowed, as well as
code blocks:

!bc pycod
from math import sin

def f(x):
    """Example on a function."""
    return sin(x) + 1

print(f(0))
!ec


===== Mathematics =====

Formulas can be inline, as in $\nabla\cdot\bm{u} = 0$, or typeset
as equations:

!bt
\begin{align*}
\nabla\cdot\bm{u} &= 0,\\ 
\bm{u} &= \nabla\phi .
\end{align*}
!et

=== Subsubsection heading ===

DocOnce files can have chapters, sections, subsections, and subsubsections.

__Paragraph heading.__ Paragraphs may have headings.
\end{lstlisting}\end{cod}
\noindent

It is time to test \texttt{verbatim inline font} especially with \texttt{a newline inside the text} and an exclamation mark at the end: \texttt{BEGIN}! For
spellcheck, test \texttt{a verbatim expression} in \texttt{another} in a \texttt{third}.
Also test exclamation mark as in \Verb?!bc? and \Verb?!ec? as well as \Verb?a != b?.
Also test backslashes and braces like \Verb!\begin!, \Verb!\begin{enumerate}!,
\Verb!\end{this}\end{that}!, and \Verb!{something \inside braces}!.

Here is some \textcolor{red}{red color} and an attempt to write \textcolor{green}{with
green color containing a linebreak\\
code.} Some formats will only display \\
this correctly when \texttt{html} \\
is the output format.
But here some more running text is added which is not part of
the previous blocks with line breaks.

\paragraph{Running OS commands.}
\begin{Verbatim}[frame=lines,label=\fbox{{\tiny Terminal}},framesep=2.5mm,framerule=0.7pt]
Terminal> python -c 'print("Testing\noutput\nfrom\nPython.")'
Testing
output
from
Python.
\end{Verbatim}

\paragraph{Footnotes.}
Here is a test of footnotes \footnote{Typesetting of the footnote depends on the format. Plain text does nothing, {\LaTeX} removes the definition and inserts the footnote as part of the {\LaTeX} text. reStructuredText and Sphinx employ a similar type of typesetting as Extended Markdown and DocOnce, and in HTML we keep the same syntax, just displayed properly in HTML.}, which are handy in text.
They are used in different flavors, now in

\begin{itemize}
 \item list items (note below that footnotes work after math, verbatim, and URLs - bin fact old and emphasize too!)

 \item even with math $\nabla^2u$\footnote{Math footnotes can be dangerous since it interferes with an exponent.}

 \item and code \texttt{h[i] += 1}\footnote{One-line footnote.}
   (\emph{must} have space between inline code and footnote!)

 \item and \href{{https://google.com}}{links}\footnote{\href{{google.com}}{\nolinkurl{google.com}} is perhaps the most famous web site today.}
\end{itemize}

\noindent
which gives flexibility in writing.
This is the third\footnote{Not much to add here, but the footnote is at the end with only one newline.} example.

Here is some more text before a new definition of a footnote that was
used above.


\begin{notice_mdfboxadmon}[Non-breaking space character.]
This paragraph aims to test \href{{https://en.wikipedia.org/wiki/Non-breaking_space}}{non-breaking space character}, and a typical
example where this is needed is in physical units: 7.4~km is traveled
in~$7.4/5.5\approx 1.345$~s.  Also check that a~\href{{https://google.com}}{link}~is
not broken across lines (drag the browser window to test this).
(On the other hand, the tilde is used in
computer code, e.g., as in \texttt{[~x for x in y]} or in \texttt{y=~x}, and should
of course remain a tilde in those contexts.)
\end{notice_mdfboxadmon} % title: Non-breaking space character.



\subsection{Subsection 2: Testing figures}
\label{subsec:ex}
\index{figures}

Test of figures. In particular we refer to Figure~\vref{fig:impact} in which
there is a flow.

\begin{figure}[!ht]  % fig:impact
  \centerline{\includegraphics[width=0.9\linewidth]{../doc/src/manual/fig/wave1D.pdf}}
  \caption{
  Visualization \textbf{of} a \emph{wave}. \label{fig:impact}
  }
\end{figure}
%\clearpage % flush figures fig:impact

Figures without captions are allowed and will be inlined.

\vspace{6mm}

% inline figure
\centerline{\includegraphics[width=0.9\linewidth]{../doc/src/manual/fig/wave1D.pdf}}

\vspace{6mm}

\index{movies}

% Test multi-line caption in figure with sidecap=True

Here is figure~\vref{myfig} with a long (illegal) multi-line caption
containing inline verbatim text:

\begin{SCfigure}
  \centering
  \includegraphics[width=0.9\linewidth]{../doc/src/manual/fig/wave1D.png}
  \caption{
  A long caption spanning several lines and containing verbatim words like \protect \Verb!my\_file\_v1! and \protect \Verb!my\_file\_v2! as well as math with subscript as in $t_{i+1}$. \label{myfig}
  }
\end{SCfigure}
%\clearpage % flush figures myfig

% Must be a blank line after MOVIE or FIGURE to detect this problem

Test URL as figure name:

\vspace{6mm}

% inline figure
\centerline{\includegraphics[width=0.8\linewidth]{downloaded_figures/f_plot.png}}

\vspace{6mm}

% Test wikimedia type of files that otherwise reside in subdirs

\paragraph{Remark.}
Movies are tested in separate file \texttt{movies.do.txt}.

% Somewhat challenging heading with latex math, \t, \n, ? and parenthesis

\subsection{The $\theta$ parameter (not $\nabla$?)}
\label{decay:sec:theta}

Functions do not always need to be advanced, here is one
involving $\theta$:
\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
def f(theta):
    return theta**2
\end{lstlisting}\end{cod}
\noindent

\paragraph{More on $\theta$.}
Here is more text following headline with math.

Newcommands must also be tested in this \report:
$\half$, $\halfi$, $\x$, $\Ddt{u}$,
both inline and in block:

\begin{align}
\Ddt{u} &= 0\nonumber
\\ 
\half &= \halfi\\ 
\half\x &= \normalvec
\end{align}

Or with align with label and numbers:

\begin{align}
\Ddt{u} &= 0
\label{aligneq1}
\\ 
\half &= \halfi\\ 
\half\x &= \normalvec
\label{aligneq2}
\end{align}

% Must test more complicated align and matrix compositions
% where DocOnce inserts auto-numbered labels etc.

First one numbered (automatically):

\begin{align}
\begin{pmatrix}
G_2 + G_3 & -G_3 & -G_2 & 0 \\ 
-G_3 & G_3 + G_4 & 0 & -G_4 \\ 
-G_2 & 0 & G_1 + G_2 & 0 \\ 
0 & -G_4 & 0 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2 \\ 
 v_3 \\ 
 v_4
\end{pmatrix}
+ \cdots \\ 
\begin{pmatrix}
 C_5 + C_6 & -C_6 & 0 & 0 \\ 
 -C_6 & C_6 & 0 & 0 \\ 
 0 & 0 & 0 & 0 \\ 
 0 & 0 & 0 & 0
\end{pmatrix}
  &= \frac{d}{dt}\begin{pmatrix}
 v_1 \\ 
 v_2 \\ 
 v_3 \\ 
 v_4
\end{pmatrix} +
\begin{pmatrix}
 0 \\ 
 0 \\ 
 0 \\ 
 -i_0
\end{pmatrix}
\nonumber
\end{align}

Second numbered (automatically):

\begin{align}
\begin{pmatrix}
G_1 + G_2\\ 
-G_3 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2
\end{pmatrix}
+ \cdots\nonumber
\\ 
\left(\begin{array}{ll}
y & 2\\ 
2 & 1
\end{array}\right)
\left(\begin{array}{ll}
0 \\ x
\end{array}\right)
&= \begin{pmatrix}
A \\ B
\end{pmatrix}
\end{align}

Both numbered, with label by the user:

\begin{align}
\begin{pmatrix}
G_1 + G_2\\ 
-G_3 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2
\end{pmatrix}
+ \cdots \label{mymatrix:eq1}
\\ 
\label{mymatrix:eq2}
\left(\begin{array}{ll}
y & 2\\ 
2 & 1
\end{array}\right)
\left(\begin{array}{ll}
0 \\ x
\end{array}\right)
&= \begin{pmatrix}
A \\ B
\end{pmatrix}
\end{align}
Now we refer to (\ref{mymatrix:eq1})-(\ref{mymatrix:eq2}).

\subsection{Custom Environments}

Here is an attempt to create a theorem environment via Mako
(for counting theorems) and comment lines to help replacing lines in
the \texttt{.tex} by proper begin-end {\LaTeX} environments for theorems.
Should look nice in most formats!

% begin theorem
\label{theorem:fundamental1}

\paragraph{Theorem 5.}
Let $a=1$ and $b=2$. Then $c=3$.
% end theorem

% begin proof
\paragraph{Proof.}
Since $c=a+b$, the result follows from straightforward addition.
$\Diamond$
% end proof

As we see, the proof of Theorem 5 is a modest
achievement.

\subsection{Tables}
\label{subsec:table}

\index{test index with verbatim text@test index with {\rm\texttt{verbatim text}} which is possible}
\index{test two@test {\rm\texttt{two}} (separate) {\rm\texttt{verbatim expressions}} which is also possible}
\index{index with!subindex}
\index{\textbf{boldface word} in index}
\index{index with \textbf{boldface word}}
\index{index with!\textbf{boldface word} in subentry}
\index{double \textbf{boldface word}! \textbf{boldface word} in subentry too}

% index with comma could fool sphinx
\index{index, with comma, and one more}

Let us take this table from the manual:

\begin{table}
\caption{
Testing table environment in {\LaTeX}, enabled by testing on the "latex" format
with the preprocessor.
\label{mytab}
}


\begin{quote}
\begin{tabular}{lrr}
\hline
\multicolumn{1}{c}{ time } & \multicolumn{1}{c}{ velocity } & \multicolumn{1}{c}{ acceleration } \\
\hline
0.0  & 1.4186   & -5.01        \\
2.0  & 1.376512 & 11.919       \\
4.0  & 1.1E+1   & 14.717624    \\
\hline
\end{tabular}
\end{quote}

\noindent
\end{table}

The DocOnce source code reads
\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]

  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

\end{lstlisting}\end{cod}
\noindent

Here is yet another table to test that we can handle more than
one table:


\begin{quote}
\begin{tabular}{lll}
\hline
\multicolumn{1}{l}{ time } & \multicolumn{1}{l}{ velocity } & \multicolumn{1}{l}{ acceleration } \\
\hline
0.0  & 1.4186   & -5.01        \\
1.0  & 1.376512 & 11.919       \\
3.0  & 1.1E+1   & 14.717624    \\
\hline
\end{tabular}
\end{quote}

\noindent
And one with math headings (that are expanded and must be treated
accordingly), verbatim heading and entry, and no space around the pipe
symbol:


\begin{quote}
\begin{tabular}{lrrr}
\hline
\multicolumn{1}{c}{ $i$ } & \multicolumn{1}{c}{ $h_i$ } & \multicolumn{1}{c}{ $\bar T_i$ } & \multicolumn{1}{c}{ \Verb!L\_i! } \\
\hline
0   & 0      & 288        & -0.0065    \\
1   & 11,000 & 216        & 0.0        \\
2   & 20,000 & 216        & 0.001      \\
3   & 32,000 & 228        & 0.0028     \\
4   & 47,000 & 270        & 0.0        \\
5   & 51,000 & 270        & -0.0028    \\
6   & 71,000 & 214        & \texttt{NaN} \\
\hline
\end{tabular}
\end{quote}

\noindent
And add one with verbatim headings (with underscores),
and rows starting with \texttt{|-} because of a negative number,
and \texttt{|} right before and after verbatim word (with no space):


\begin{quote}
\begin{tabular}{rrrr}
\hline
\multicolumn{1}{c}{ exact } & \multicolumn{1}{c}{ \Verb!v\_1! } & \multicolumn{1}{c}{ $a_i$ + \Verb!v\_2! } & \multicolumn{1}{c}{ \Verb!verb\_3\_! } \\
\hline
9     & 9.62       & 5.57               & 8.98           \\
-20   & -23.39     & -7.65              & -19.93         \\
10    & 17.74      & -4.50              & 9.96           \\
0     & -9.19      & 4.13               & -0.26          \\
\hline
\end{tabular}
\end{quote}

\noindent
Pipe symbols in verbatim and math text in tables used to pose difficulties,
but not
anymore:


\begin{quote}
\begin{tabular}{lr}
\hline
\multicolumn{1}{c}{ $S$ } & \multicolumn{1}{c}{ command } \\
\hline
$ ||a_0|| $ & \texttt{norm|length} \\
$x\cap y$   & \texttt{x|y}         \\
\hline
\end{tabular}
\end{quote}

\noindent
Here is a table with X alignment:


\begin{quote}
\begin{tabularx}{\linewidth}{cX}
\hline
\multicolumn{1}{c}{ Type } & \multicolumn{1}{c}{ Description } \\
\hline
X     & Alignment character that is used for specifying a potentially very long text in a column in a table. It makes use of the \texttt{tabularx} package in {\LaTeX}, otherwise (for other formats) it means \texttt{l} (centered alignment). \\
l,r,c & standard alignment characters                                                                                                                                                                                                       \\
\hline
\end{tabularx}
\end{quote}

\noindent
Finally, a table with math
and URLs.

% Mako code to expand URLs in the table
% (These types of tables did not work before Jan 2014)


\begin{quote}
\begin{tabular}{ccc}
\hline
 \\
\hline
$\mathcal{L}=0$         & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0080.png} & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0085.png} \\
$a=b$                   & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0090.png} & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0095.png} \\
$\nabla\cdot\bm{u} =0 $ & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0100.png} & \includegraphics[width=2cm]{../doc/src/manual/mov/wave_frames/frame_0105.png} \\
\hline
\end{tabular}
\end{quote}

\noindent
\subsection{A test of verbatim words in heading with subscript $a_i$: \protect\Verb!my\_file\_v1! and \protect\Verb!my\_file\_v2! }

\paragraph{Paragraph with verbatim and math: \protect\Verb!my\_file\_v1.py! and \protect\Verb!my\_file\_v2.py! define some math $a_{i-1}$.}
Here is more \Verb!__verbatim__! code and
some plain text on a new line.

% Test various types of headlines
\subsection{\textbf{Just bold}}

Some text.

\subsection{\emph{Just emphasize}}

Some text.

\subsection{\texttt{Just verbatim} }

Some text.

\subsection{\textbf{Bold} beginning}

Some text.

\subsection{\emph{Emphasize} beginning}

Some text.

\subsection{\texttt{Verbatim} beginning}

Some text.

\subsection{Maybe \textbf{bold end}}

Some text.

\subsection{Maybe \emph{emphasize end}}

Some text.

\subsection{Maybe \texttt{verbatim end} }

Some text.

\subsection{The middle has \textbf{bold} word}

Some text.

\subsection{The middle has \emph{emphasize} word}

Some text.

\subsection{The middle has \texttt{verbatim} word}

Some text.

\paragraph{\emph{Just emphasize}.}
Some text.

\paragraph{\texttt{Just verbatim}.}
Some text.

\paragraph{\emph{Emphasize} beginning.}
Some text.

\paragraph{\texttt{Verbatim beginning}.}
Some text.

\paragraph{Maybe \emph{emphasize end}.}
Some text.

\paragraph{Maybe \texttt{verbatim end}.}
Some text.

\paragraph{The middle has \emph{emphasize} word.}
Some text.

\paragraph{The middle has \texttt{verbatim} word.}
Some text.

\paragraph{Ampersand.}
We can test Hennes {\&} Mauritz, often abbreviated H{\&}M, but written
as \Verb!Hennes & Mauritz! and \Verb!H & M!.
A sole \Verb!&! must also work.
% Note: substitutions must not occur inside verbatim, just in ordinary text.

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
# Just to check that ampersand works in code blocks:
c = a & b
\end{lstlisting}\end{cod}
\noindent

\paragraph{Quotes.}
Let us also add a test of quotes such as ``double quotes, with numbers
like 3.14 and newline/comma and hyphen (as in double-quote)''; written
in the standard LaTeX-style that gives correct {\LaTeX} formatting and
ordinary double quotes for all non-LaTeX formats.  Here is another
sentence that ``caused'' a bug in the past because double backtick
quotes could imply verbatim text up to a verbatim word starting with
period, like \texttt{.txt}.

More quotes to be tested for spellcheck:
(``with parenthesis''), ``with newline''
and ``with comma'', ``hyphen''-wise, and ``period''.

\subsection{Bibliography test}

Here is an example: \cite{Langtangen_Pedersen_2002} discussed propagation of
large destructive water waves, \cite{Langtangen_et_al_2002} gave
an overview of numerical methods for solving the Navier--Stokes equations,
while the use of Backward Kolmogorov equations for analyzing
random vibrations was investigated in \cite{Langtangen_1994a}.
The book chapter \cite{Mardal_et_al_2003a} contains information on
C++ software tools for programming multigrid methods. A real retro
reference is \cite{Langtangen_1988d} about a big FORTRAN package.
Multiple references are also possible, e.g., see
\cite{Langtangen_Pedersen_2002,Mardal_et_al_2003a}.

We need to cite more than 10 papers to reproduce an old formatting
problem with blanks in the keys in reST format:
\cite{Langtangen_1992c,Langtangen_1994a,Mortensen_et_al_2011,Langtangen_Pedersen_2002}
and
\cite{Langtangen_et_al_2002,Glimsdal_et_al_20006,Rahman_et_al_2006b,Haga_et_al_2011a,Langtangen_2003a,Langtangen_2008a,Langtangen:95}
and all the work of
\cite{Langtangen_2012,Mardal_et_al_2003a,Jeberg_et_al_2004} as well as
old work \cite{Langtangen_1988d} and \cite{Langtangen_1989e}, and the
talk \cite{Langtangen_talk_2007a}.
Langtangen also had two thesis \cite{Langtangen:85,Langtangen_1989e}
back in the days.
More retro citations are
the old ME-IN323 book \cite{Langtangen:91} and the
\cite{Langtangen:94b} OONSKI '94 paper.

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Example \thedoconceexercisecounter: Examples can be typeset as exercises}
                             
\label{Example}

Examples can start with a subsection heading starting with \texttt{Example:}
and then, with the command-line option \Verb!--examples_as_exercises! be
typeset as exercises. This is useful if one has solution
environments as part of the example.

\subex{a)}
State some problem.

\paragraph{Solution.}
The answer to this subproblem can be written here.

\subex{b)}
State some other problem.

\paragraph{Hint 1.}
A hint can be given.

\paragraph{Hint 2.}
Maybe even another hint?

\paragraph{Solution.}
The answer to this other subproblem goes here,
maybe over multiple doconce input lines.

\end{doconceexercise}
% --- end exercise ---

\subsection{User-defined environments}

Example~\vref{ex:test:1p1} demonstrates how to write a test function.
That is, a special test function for a function \texttt{add} appears in
Example~\vref{ex:test:1p1}.

\begin{example}
\label{ex:test:1p1}

\noindent\emph{A test function}.

Suppose we want to write a test function for checking the
implementation of a Python function for addition.

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
def add(a, b):
    return a + b

def test_add():
    a = 1; b = 1
    expected = a + b
    computed = add(a, b)
    assert expected == computed
\end{lstlisting}\end{cod}
\noindent
\end{example}

\begin{example}
\label{ex:math:1p1}

\noindent\emph{Addition}.

We have

\[ 1 + 1 = 2 \]
or in tabular form:


\begin{quote}
\begin{tabular}{cc}
\hline
\multicolumn{1}{c}{ Problem } & \multicolumn{1}{c}{ Result } \\
\hline
$1+1$   & $2$    \\
\hline
\end{tabular}
\end{quote}

\noindent
\end{example}

\begin{tcolorbox}[%skin=widget,
boxrule=1mm,
coltitle=black,
colframe=blue!45!white,
colback=blue!15!white,
width=(.9\linewidth),before=\hfill,after=\hfill,
adjusted title={Highlight box!}]
This environment is used to highlight something:

\[ E = mc^2 \]
\end{tcolorbox}

\subsection{URLs}
\label{subsubsec:ex}

Testing of URLs: hpl's home page \href{{https://folk.uio.no/hpl}}{hpl}, or
the entire URL if desired, \href{{https://folk.uio.no/hpl}}{\nolinkurl{https://folk.uio.no/hpl}}.  Here is a
plain file link \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}}, or \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}}, or
\href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}} or \href{{testdoc.do.txt}}{\nolinkurl{testdoc.do.txt}} or \href{{testdoc.do.txt}}{a link with
newline}. Can test spaces with the link with word
too: \href{{https://folk.uio.no/hpl}}{hpl} or \href{{https://folk.uio.no/hpl}}{hpl}. Also \texttt{file:///} works: \href{{file:///home/hpl/vc/doconce/doc/demos/manual/manual.html}}{link to a
file} is
fine to have. Moreover, ``loose'' URLs work, i.e., no quotes, just
the plain URL as in \href{{https://folk.uio.no/hpl}}{\nolinkurl{https://folk.uio.no/hpl}}, if followed by space, comma,
colon, semi-colon, question mark, exclamation mark, but not a period
(which gets confused with the periods inside the URL).

Mail addresses can also be used: \href{{mailto:hpl@simula.no}}{\nolinkurl{hpl@simula.no}}, or just a \href{{mailto:hpl@simula.no}}{mail link}, or a raw \href{{mailto:hpl@simula.no}}{\nolinkurl{mailto:hpl@simula.no}}.

Here are some tough tests of URLs, especially for the \texttt{latex} format:
\href{{https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas}}{Newton-Cotes} formulas
and a \href{{https://www.springer.com/mathematics/computational+science+%26+engineering/book/978-3-642-23098-1}}{good book}. Need to test
Newton-Cotes with percentage in URL too:
\href{{https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas}}{\nolinkurl{https://en.wikipedia.org/wiki/Newton\%E2\%80\%93Cotes_formulas}}
and \href{{https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae}}{\nolinkurl{https://en.wikipedia.org/wiki/Newton-Cotes\#Open_Newton.E2.80.93Cotes_formulae}} which has a shebang.

For the \texttt{--device=paper} option it is important to test that URLs with
monospace font link text get a footnote
(unless the \Verb!--latex_no_program_footnotelink!
is used), as in this reference to
\href{{https://github.com/hplgit/INF5620/tree/gh-pages/src/decay/experiments/decay_mod.py}}{\nolinkurl{decay_mod}}, \href{{https://tinyurl.com/pwyasaa/formulas.ball1.py}}{\nolinkurl{ball1.py}},
and \href{{https://tinyurl.com/pwyasaa/formulas.ball2.py}}{\nolinkurl{ball2.py}}.

% Comments should be inserted outside paragraphs (because in the rst
% format extra blanks make a paragraph break).

% Note that when there is no https: or file:, it can be a file link
% if the link name is URL, url, "URL", or "url". Such files should,
% if rst output is desired, but placed in a \Verb!_static*! folder.

More tough tests: repeated URLs whose footnotes when using the
\texttt{--device=paper} option must be correct. We have
\href{{https://google.com}}{google}, \href{{https://google.com}}{google}, and
\href{{https://google.com}}{google}, which should result in exactly three
footnotes.

\subsection{Test of Some {\LaTeX} Fixes}

Let's check abbr.~of some common kind, e.g.~the well-known i.e.
expression as an example, and 1 vs.~2 which is also often used.
Dr.~Tang and Prof.~Monsen, or maybe also prof.~Ting,
will go to the Dept.~of Science to test how Mr.~Hansen is doing together
with Ms.~Larsen. A reference like Sec.~\vref{subsubsec:ex} or
Ch.~\vref{subsubsec:ex}, or even App.~\vref{subsubsec:ex}, must also be
handled. Likewise, this is test no.~$i$ of DocOnce features.
Also, look at Fig.~4 to see how the data compares with Tab.~\vref{mytab}.
Percentage must be fixed: 7\%,  87.65\% and
50\% at the beginning of the line.

% !split and check if these extra words are included properly in the comment

\section{{\LaTeX} Mathematics}

Here is an equation without label using backslash-bracket environment:
\[ a = b + c \]

or with number and label, as in (\ref{my:eq1}), using the equation environment:

\begin{equation}
{\partial u\over\partial t} = \nabla^2 u \label{my:eq1}
\end{equation}

We can refer to this equation by (\ref{my:eq1}).

Here is a system without equation numbers, using the align-asterisk environment:

\begin{align*}
\pmb{a} &= \pmb{q}\times\pmb{n} \\ 
b &= \nabla^2 u + \nabla^4 v
\end{align*}

And here is a system of equations with labels in an align environment:

\begin{align}
a &= q + 4 + 5+ 6 \label{eq1} \\ 
b &= \nabla^2 u + \nabla^4 x \label{eq2}
\end{align}

We can refer to (\ref{eq1})-(\ref{eq2}). They are a bit simpler than
the Navier--Stokes equations. And test {\LaTeX} hyphen in \texttt{CG-2}.
Also test $a_{i-j}$ as well as $kx-wt$.

Testing \texttt{alignat} environment:

\begin{alignat}{2}
a &= q + 4 + 5+ 6\qquad & \mbox{for } q\geq 0 \label{eq1a} \\ 
b &= \nabla^2 u + \nabla^4 x & x\in\Omega \label{eq2a}
\end{alignat}

Many of the next environments will fail in non-latex formats.
Testing multiline:

\begin{multline}
a = b = q + \\ 
  f + \nabla\cdot\nabla u
\label{multiline:eq1}
\end{multline}

Testing split:

\begin{equation}
\label{split:envir:eq}
\begin{split}
a = b = q &+ \\ 
  & f + \nabla\cdot\nabla u
\end{split}
\end{equation}
We can refer to the last equation by (\ref{split:envir:eq}).

Testing gather:
\begin{gather}
a = b \\ 
c = d + 7 + 9
\end{gather}

Let us refer to (\ref{eq1})-(\ref{eq2}) again, and to the
alignat variant (\ref{eq1a})-(\ref{eq2a}), and to (\ref{my:eq1}).

Testing eqnarray:
\begin{eqnarray}
{\partial u\over\partial t} &=& \nabla^2 u + f, \label{myeq1}\\ 
{\partial v\over\partial t} &=& \nabla\cdot(q(u)\nabla v) + g \label{myeq2}
\end{eqnarray}

More mathematical typesetting is demonstrated in the coming exercises.

Below, we have Problem~\vref{demo:ex:1} and Project~\vref{demo:ex:2},
as well as Projects~\vref{proj:circle1} and~\vref{exer:you}, and in
between there we have Exercise~\vref{exer:some:formula}.

\section{Exercises}

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Problem \thedoconceexercisecounter: Flip a Coin}
                             
\label{demo:ex:1}
% keywords = random numbers; Monte Carlo simulation; ipynb

% Torture tests

\subex{a)}
Make a program that simulates flipping a coin $N$ times.
Print out ``tail'' or ``head'' for each flip and
let the program count the number of heads.

% --- begin hint in exercise ---

\paragraph{Hint 1.}
Use \texttt{r = random.random()} and define head as \texttt{r <= 0.5}.

% --- end hint in exercise ---

% --- begin hint in exercise ---

\paragraph{Hint 2.}
Draw an integer among $\{1,2\}$ with
\texttt{r = random.randint(1,2)} and define head when \texttt{r} is 1.

% --- end hint in exercise ---

% --- begin answer of exercise ---
\paragraph{Answer.}
If the \texttt{random.random()} function returns a number $<1/2$, let it be
head, otherwise tail. Repeat this $N$ number of times.
% --- end answer of exercise ---

% --- begin solution of exercise ---
\paragraph{Solution.}
\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
import sys, random
N = int(sys.argv[1])
heads = 0
for i in range(N):
    r = random.random()
    if r <= 0.5:
        heads += 1
print('Flipping a coin %d times gave %d heads' % (N, heads))
\end{lstlisting}\end{cod}
\noindent
% --- end solution of exercise ---

\subex{b)}
Vectorize the code in a) using boolean indexing.

Vectorized code can be written in many ways.
Sometimes the code is less intuitive, sometimes not.
At least there is not much to find in Section~\vref{sec1}.

\subex{c)}
Vectorize the code in a) using \texttt{numpy.sum}.

% --- begin answer of exercise ---
\paragraph{Answer.}
\texttt{np.sum(np.where(r <= 0.5, 1, 0))} or \texttt{np.sum(r <= 0.5)}.
% --- end answer of exercise ---

In this latter subexercise, we have an
example where the code is easy to read.

\paragraph{My remarks.}
Remarks with such a subsubsection is treated as more text
after the last subexercise. Test a list too:

\begin{enumerate}
\item Mark 1.

\item Mark 2.
\end{enumerate}

\noindent
\noindent Filenames: \Verb!flip_coin.py!, \Verb!flip_coin.pdf!.

% Closing remarks for this Problem

\paragraph{Remarks.}
These are the exercise remarks, appearing at the very end.

% solution files: mysol.txt, mysol_flip_coin.py, yet_another.file

\end{doconceexercise}
% --- end exercise ---

\subsection{Not an exercise}

Should be possible to stick a normal section in the middle of many
exercises.

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Exercise \thedoconceexercisecounter: Test of plain text exercise}
                             
\label{my:exer1}

Very short exercise. What is the capital
of Norway?
\noindent Filename: \texttt{myexer1}.

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Project \thedoconceexercisecounter: Compute a Probability}
                             
\label{demo:ex:2}

% Minimalistic exercise

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval $[0,1)$?

At the end we have a list because that caused problems in {\LaTeX}
in previous DocOnce versions:

\begin{enumerate}
\item item1

\item item2
\end{enumerate}

\noindent
% --- begin hint in exercise ---

\paragraph{Hint.}
To answer this question empirically, let a program
draw $N$ such random numbers using Python's standard \texttt{random} module,
count how many of them, $M$, that fall in the interval $(0.5,0.6)$, and
compute the probability as $M/N$.

% --- end hint in exercise ---

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Project \thedoconceexercisecounter: Explore Distributions of Random Circles}
                             
\label{proj:circle1}
% keywords = ipynb

The formula for a circle is given by

\begin{align}
x &= x_0 + R\cos 2\pi t,
\label{circle:x}\\ 
y &= y_0 + R\sin 2\pi t,
\label{circle:y}
\end{align}
where $R$ is the radius of the circle, $(x_0,y_0)$ is the
center point, and $t$ is a parameter in the unit interval $[0,1]$.
For any $t$, $(x,y)$ computed from (\ref{circle:x})-(\ref{circle:y})
is a point on the circle.
The formula can be used to generate \texttt{n} points on a circle:

\begin{pro}{cbg_blue1}{bar_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y

x, y = circle(2.0, 0, 0)
\end{lstlisting}\end{pro}
\noindent

% Often in an exercise we have some comments about the solution
% which we normally want to keep where they are.

The goal of this project is to draw $N$ circles with random
center and radius. Plot each circle using the \texttt{circle} function
above.

\subex{a)}
Let $R$ be normally distributed and $(x_0,y_0)$ uniformly distributed.

% --- begin hint in exercise ---

\paragraph{Hint.}
Use the \texttt{numpy.random} module to draw the
$x_0$, $y_0$, and $R$ quantities.

% --- end hint in exercise ---

% --- begin answer of exercise ---
\paragraph{Answer.}
Here goes the short answer to part a).
% --- end answer of exercise ---

% --- begin solution of exercise ---
\paragraph{Solution.}
Here goes a full solution to part a).
% --- end solution of exercise ---

\subex{b)}
Let $R$ be uniformly distributed and $(x_0,y_0)$ normally distributed.
\noindent Filename: \texttt{norm}.

\subex{c)}
Let $R$ and $(x_0,y_0)$ be normally distributed.

\noindent Filename: \texttt{circles}.

% Closing remarks for this Project

\paragraph{Remarks.}
At the very end of the exercise it may be appropriate to summarize
and give some perspectives.

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Exercise \thedoconceexercisecounter: Determine some Distance}
                             
\label{exer:dist}

Intro to this exercise. Questions are in subexercises below.

% --- begin solution of exercise ---
\paragraph{Solution.}
Here goes a full solution of the whole exercise.
With some math $a=b$ in this solution:
\[ \hbox{math in solution: } a = b \]
And code \texttt{a=b} in this solution:
\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
a = b  # code in solution
\end{lstlisting}\end{cod}
\noindent
End of solution is here.

% --- end solution of exercise ---

\subex{a)}
Subexercises are numbered a), b), etc.

% --- begin hint in exercise ---

\paragraph{Hint 1.}
First hint to subexercise a).
With math $a=b$ in hint:

\[ a=b. \]
And with code (in plain verbatim) returning $x+1$ in hint:

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
def func(x):
    return x + 1  # with code in hint
\end{lstlisting}\end{cod}
\noindent

% --- end hint in exercise ---

% --- begin hint in exercise ---

\paragraph{Hint 2.}
Second hint to subexercise a).

Test list in hint:

\begin{enumerate}
\item item1

\item item2
\end{enumerate}

\noindent
% --- end hint in exercise ---
\noindent Filename: \Verb!subexer_a.pdf!.

% --- begin answer of exercise ---
\paragraph{Answer.}
Short answer to subexercise a).
With math in answer: $a=b$.
% --- end answer of exercise ---

\subex{b)}
Here goes the text for subexercise b).

Some math $\cos^2 x + \sin^2 x = 1$ written one a single line:

\[ \cos^2 x + \sin^2 x = 1 \thinspace .\]

% --- begin hint in exercise ---

\paragraph{Hint.}
A hint for this subexercise.

% --- end hint in exercise ---
\noindent Filename: \Verb!subexer_b.pdf!.

% --- begin solution of exercise ---
\paragraph{Solution.}
Here goes the solution of this subexercise.
% --- end solution of exercise ---

% No meaning in this weired test example:
The text here belongs to the main (intro) part of the exercise. Need
closing remarks to have text after subexercises.

Test list in exercise:

\begin{enumerate}
\item item1

\item item2
% Closing remarks for this Exercise
\end{enumerate}

\noindent
\paragraph{Remarks.}
Some final closing remarks, e.g., summarizing the main findings
and their implications in other problems can be made. These
remarks will appear at the end of the typeset exercise.

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}

\exercisesection{Some exercise without the "Exercise:" prefix}

% Another minimalistic exercise

Just some text. And some math saying that $e^0=1$ on a single line,
to test that math block insertion is correct:

\[ \exp{(0)} = 1 \]

And a test that the code \texttt{lambda x: x+2} is correctly placed here:

\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
lambda x: x+2
\end{lstlisting}\end{cod}
\noindent

% Have some comments at the end of the exercise to see that
% the Filename: ... is written correctly.
\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Exercise \thedoconceexercisecounter: Solution of differential equation}
                             
\label{sec:this:exer:de}


\begin{doconcequiz}
\refstepcounter{doconcequizcounter}
\label{quiz:diff:eq1}


\noindent\textbf{\large SOlution of differential equation}

\noindent
Given

\[ \frac{dy}{dx} = -y(x),\quad y(0)=1 \]
What is the solution of this equation?

\vspace{2mm}

\textbf{A}. 
$y=e^{-y}$

\textbf{B}. 
$y=e^{y}$

\textbf{C}. 
\begin{cod}{cbg_blue1}\begin{lstlisting}[language=Python,style=myspeciallststyle,numbers=left,numberstyle=\tiny,stepnumber=3,numbersep=15pt,xleftmargin=1mm]
from math import exp
def f(x):
    return exp(x)
\end{lstlisting}\end{cod}
\noindent

\textbf{D}. 
The solution cannot be found because there is a derivative in the equation.

\textbf{E}. 
The equation is meaningless: an equation must be an equation
for $x$ or $y$, not a function $y(x)$.


% --- begin answer of exercise ---
\paragraph{Answer:} A.
% --- end answer of exercise ---

% --- begin solution of exercise ---
\noindent {\bf Solution:}\\


\textbf{A}: Right. 

\textbf{B}: Wrong. Almost, but the sign is wrong (note the minus!).

\textbf{C}: Wrong. Ooops, forgot a minus: \texttt{exp(-x)}, otherwise this Python code
must be considered as a good answer. It is more natural,
though, to write the solution to the problem
in mathematical notation:

\[ y(x) = e^{-y}.\]

\textbf{D}: Wrong. Equations with derivatives can be solved;
they are termed \emph{differential
equations}.

\textbf{E}: Wrong. Equations where the unknown is a function, as $y(x)$
here, are called \emph{differential equations}, and are solved by
special techniques.


% --- end solution of exercise ---


\vspace{3mm}

\end{doconcequiz}



\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Example \thedoconceexercisecounter: Just an example}
                             

% This example needs the --examples_as_exercises option, otherwise
% it is just typeset as it is written.

\subex{a)}
What is the capital of Norway?

\paragraph{Answer.}
Oslo.

\end{doconceexercise}
% --- end exercise ---

\section{Here goes another section}

With some text, before we continue with exercises.

\section{More Exercises}

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Exercise \thedoconceexercisecounter: Make references to projects and problems}
                             
\label{exer:some:formula}

% Test comments not at the end only
Pick a statement from Project~\vref{proj:circle1} or Problem~\vref{demo:ex:1}
and verify it.

Test list at the end of an exercise without other elements (like subexercise,
hint, etc.):

\begin{enumerate}
\item item1

\item item2
\end{enumerate}

\noindent
\noindent Filename: \Verb!verify_formula.py!.

\end{doconceexercise}
% --- end exercise ---

% --- begin exercise ---
\begin{doconceexercise}
\refstepcounter{doconceexercisecounter}

\exercisesection{Project \thedoconceexercisecounter: References to Project~\vref{demo:ex:2} in a heading works for pdflatex}
                             
\label{exer:you}

Refer to the previous exercise as Exercise~\vref{exer:some:formula},
the two before that as Projects~\vref{demo:ex:2} and~\vref{proj:circle1},
and this one as Project~\vref{exer:you}.
\noindent Filename: \Verb!selc_composed.pdf!.

\end{doconceexercise}
% --- end exercise ---

\bibliographystyle{plain}
\bibliography{papers}



\appendix

\section{Just for testing; part I}
\label{app1}

This is the first appendix.

\subsection{A subsection within an appendix}

Some text.

\section{Just for testing; part II}
\label{app2}

This is more stuff for an appendix.

\subsection{Appendix: Testing identical titles}

Without label.

\subsection{Appendix: Testing identical titles}
\label{test:title:id1}

With label.

\subsection{Appendix: Testing identical titles}
\label{test:title:id2}

What about inserting a quiz?


\begin{doconcequiz}
\refstepcounter{doconcequizcounter}
\label{quiz:2}


\noindent\textbf{\large Capital of Norway}
\paragraph{Fundamental test:}
What is the capital of Norway?

\vspace{2mm}

\textbf{A}. 
Stockholm

\textbf{B}. 
London

\textbf{C}. 
Oslo

\textbf{D}. 
Bergen


% --- begin answer of exercise ---
\paragraph{Answer:} C.
% --- end answer of exercise ---

% --- begin solution of exercise ---
\noindent {\bf Solution:}\\


\textbf{A}: Wrong. Stockholm is the capital of Sweden.

\textbf{B}: Wrong. 

\textbf{C}: Right. 

\textbf{D}: Wrong. Those from Bergen would claim so, but nobody else.


% --- end solution of exercise ---


\vspace{3mm}

\end{doconcequiz}



\subsection{Appendix: Testing identical titles}

Without label.


\begin{notice_mdfboxadmon}[Tip.]
Here is a tip or hint box, typeset as a notice box.
\end{notice_mdfboxadmon} % title: Tip.



\clearpage

Need a lot of text to surround the summary box.
Version control systems allow you to record the history of files
and share files among several computers and collaborators in a
professional way. File changes on one computer are updated or
merged with changes on another computer. Especially when working
with programs or technical reports it is essential
to have changes documented and to
ensure that every computer and person involved in the project
have the latest updates of the files.
Greg Wilson' excellent \href{{https://software-carpentry.org/2010/07/script-for-introduction-to-version-control/}}{Script for Introduction to Version Control} provides a more detailed motivation why you will benefit greatly
from using version control systems.


\begin{summary_mdfboxadmon}[Summary.]
\textbf{Bold remark:} Make some text with this summary.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
\end{summary_mdfboxadmon} % title: Summary.



Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that site. I strongly
recommend you to use such sites for all serious programming and
scientific writing work - and all other important files.

The simplest services for hosting project files are \href{{https://dropbox.com}}{Dropbox} and \href{{https://drive.google.com}}{Google Drive}.
It is very easy to get started with these systems, and they allow you
to share files among laptops and mobile units with as many users as
you want. The systems offer a kind of version control in that the
files are stored frequently (several times per minute), and you can go
back to previous versions for the last 30 days. However, it is
challenging  to find the right version from the past when there are
so many of them.

More seriously, when several people may edit files simultaneously, it
can be difficult detect who did what when, roll back to previous
versions, and to manually merge the edits when these are
incompatible. Then one needs more sophisticated tools than Dropbox or
Google Drive: project hosting services with true version control
systems.  The following text aims at providing you with the minimum
information to started with such systems. Numerous other tutorials
contain more comprehensive material and in-depth explanations of the
concepts and tools.

The idea with project hosting services is that you have the files
associated with a project in the cloud. Many people may share these
files.  Every time you want to work on the project you explicitly
update your version of the files, edit the files as you like, and
synchronize the files with the "master version" at the site where the
project is hosted.  If you at some point need to go back to a
version of the files at some particular point in the past,
this is an easy operation. You can also use tools to see
what various people have done with the files in the various versions.

All these services are very similar. Below we describe how you get
started with Bitbucket, GitHub, and Googlecode. Launchpad works very
similarly to the latter three. All the project hosting services have
excellent introductions available at their web sites, but the recipes
below are much shorter and aim at getting you started as quickly as
possible by concentrating on the most important need-to-know steps.
The Git tutorials we refer to later in this document contain more
detailed information and constitute of course very valuable readings
when you use version control systems every day. The point now is
to get started.

\subsection{Appendix: Testing inline comments}

% Names can be [ A-Za-z0-9_'+-]+

Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that
site. \shortinlinecomment{hpl's semi opinion 1}{ not sure if in the cloud is understood by all. }{ not sure if in } I strongly recommend you to use such sites for all serious
programming and scientific writing work - and all other important
files.

The simplest services for hosting project files is Dropbox. \longinlinecomment{mp 2}{ Simply go to \href{{https://dropbox.com}}{\nolinkurl{https://dropbox.com}} and watch the video. It explains how files, like \texttt{myfile.py}, perhaps containing much math, like $\partial u/\partial t$, are easily communicated between machines. }{ Simply go to \href{{https://dropbox.com}}{\nolinkurl{https://dropbox.com}} } It
is very easy to get started with Dropbox, and it allows you to share
files among \textcolor{red}{(hpl 3:)} \replace{laptops and mobile units}{computers, tablets, and phones}.

% Test horizontal rule

------

% Coments for editing

First\textcolor{red}{, (\textbf{edit 4}: add comma)} consider a quantity $Q$. \textcolor{red}{(edit 5:)} \replace{To this end,}{We note that}
$Q>0$, because (\textbf{edit 6}:) \remove{a} negative \textcolor{red}{(edit 7:)} \replace{quantity is}{quantities are} (\textbf{edit 8}:) \remove{just} negative.  \textcolor{red}{ (\textbf{edit 9}:) This comes as no surprise.}

% Test tailored latex figure references with page number
Let us refer to Figure~\vref{fig:impact} again.

Test references in a list:

\begin{itemize}
 \item \vref{sec1}

 \item \vref{subsec1}

 \item \vref{fig:impact}
\end{itemize}

\noindent
\subsection{Appendix: Testing headings ending with \texttt{verbatim inline} }

The point here is to test 1) \texttt{verbatim} code in headings, and 2)
ending a heading with verbatim code as this triggers a special
case in {\LaTeX}.

We also test mdash---used as alternative to hyphen without spaces around,
or in quotes:


\begin{quote}
\emph{Fun is fun}.---Unknown.
\end{quote}


The ndash should also be tested -- as in the Hanson--Nilson equations
on page 277--278.

And finally, what about admons, quotes, and boxes? They are tested
in a separate document: \texttt{admon.do.txt}.


% ------------------- end of main content ---------------

% #ifdef PREAMBLE
\cleardoublepage\phantomsection  % trick to get correct link to Index
\printindex

\end{document}
% #endif

************** File: testdoc.rst *****************

.. raw:: html

        <script type="text/x-mathjax-config">
        MathJax.Hub.Config({
          TeX: {
             equationNumbers: {  autoNumber: "AMS"  },
             extensions: ["AMSmath.js", "AMSsymbols.js", "autobold.js", "color.js"]
          }
        });
        </script>
        <script type="text/javascript" async
         src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.1/MathJax.js?config=TeX-AMS-MML_HTMLorMML">
        </script>
        
        

.. Automatically generated reStructuredText file from DocOnce source
   (https://github.com/doconce/doconce/)

.. |nbsp| unicode:: 0xA0
   :trim:

.. Document title:

A Document for Testing DocOnce
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:Authors: Hans Petter Langtangen (hpl at simula.no), Kaare Dump, A. Dummy Author, I. S. Overworked and Outburned, J. Doe (j_doe at cyberspace.com)
:Date: Jan 32, 2100

Made with DocOnce

.. contents:: Table of contents
   :depth: 2

.. !split

The format of this document is
rst

*Abstract.* This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.

.. Cannot demonstrate chapter headings since abstract and chapter

.. are mutually exclusive in LaTeX

.. _sec1:

Section 1
=========

Here is a nested list:

  * item1

  * item2

  * item3 which continues
    on the next line to test that feature

  * and a sublist

    * with indented subitem1

    * and a subitem2

  * and perhaps an ordered sublist

   a. first item

   b. second item,
      continuing on a new line

**Here is a list with paragraph heading.**

  * item1

  * item2

Here is a list with subsubsection heading
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  * item1

  * item2


..

    Here are two lines that make up
    a block quote for testing *emphasized words* and **boldface words**,
    also with hypens:
    *pre*-fix, post-*fix*, **pre**-fix, post-**fix**.



Here are two references. Equation |nbsp| (`my:eq1`_) is fine. Eq. |nbsp| (`my:eq1`_) too.
Even Equation (`my:eq1`_) without the tilde.

.. _subsec1:

Subsection 1
------------

.. Refer to section/appendix etc. at the beginning of the line

.. and other special fix situations for HTML.

More text, with a reference back to
the section `Section 1`_ and `Subsection 1`_, and further to the
the sections `Subsection 1`_ and `URLs`_, which
encourages you to do the tasks in `Problem 2: Flip a Coin`_ and `Exercise 10: Make references to projects and problems`_.
 `Appendix: Just for testing; part I`_ and `Appendix: Just for testing; part II`_ are also nice elements.

Test Section reference at beginning of line and after a sentence
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The section `Subsection 1`_ is fine.
The section `URLs`_ too.

.. sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console

Computer code
~~~~~~~~~~~~~

Let's do some copying from files too. First from subroutine up to the very end::

              subroutine test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return

and then just the subroutine::

        
              subroutine test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return

and finally the complete file with a plain text verbatim environment
(``envir=ccq``)::

        C     a comment
        
              subroutine test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return

Testing other code environments. First Python::

        !bc pycod
        def f(x):
            return x+1
        !ec

which gets rendered as::

        def f(x):
            return x+1

Here is a program that is supposed to be interactive via
Python Online Tutorial, but that service is not accessible
for the present format::

        class Line:
            def __init__(self, a, b):
                self.a, self.b = a, b
        
            def __call__(self, x):
                a, b = self.a, self.b
                return a*x + b
        
        line = Line(2, 1)
        y = line(x=3)
        print(y)

Some more Python code (actually specified as a sage cell, but
such cells are not supported by this format)::

        a = 2
        b = 3
        print('a+b:', a + b)
        
        # In a sage cell we can also plot
        from matplotlib.pyplot import *
        from numpy import *
        x = linspace(0, 4*pi, 101)
        y = exp(-0.1*x)*cos(x)
        plot(x, y)
        xlabel('x'); ylabel('y')
        show()

Then Cython (with -h option so it is hidden in html/sphinx)::

        cpdef f(double x):
            return x + 1

Standard Python shell sessions::

        >>> from numpy import linspace, sin
        >>> # Some comment
        >>> x = linspace(0, 2, 11)
        >>> y = sin(x)
        >>> y[0]
        0
        >>> import matplotlib.pyplot as plt
        >>> plt.plot(x, y)

Similar IPython sessions::

        In [1]: from numpy import linspace, sin
        In [2]: # Some comment
        In [3]: x = linspace(0, 2, 11)
        In [4]: y = sin(x)
        In [5]: y[0]
        Out[5]: 0
        In [6]: import matplotlib.pyplot as plt
        In [7]: plt.plot(x, y)
        In [8]: a='multiple-\nline\noutput'
        In [9]: a
        Out[9]: 'multiple-\nline\noutput'
        In [10]: print(a)
        multiple-
        line
        output

Here is the interactive session again, but with ``pyshell-t``::

        >>> from numpy import linspace, sin
        >>> # Some comment
        >>> x = linspace(0, 2, 11)
        >>> y = sin(x)
        >>> y[0]
        0
        >>> import matplotlib.pyplot as plt
        >>> plt.plot(x, y)

.. This one tests a + sign before a code environment

C++::

        #include <iostream>
        
        int main()
        {
           std::cout << "Sample output" << std::endl;
           return 0
        }

.. The next should get correctly typset in sphinx (cod is fcod)

.. It also tests emoji before code

And a little bit of Fortran: :dizzy_face::

        !bc cod
              subroutine midpt(x, length, a, b)
              real*8 a, b, x
              x = (a + b)/2
              length = b - a
              return
              end
        !ec

which then is typeset as::

              subroutine midpt(x, length, a, b)
              real*8 a, b, x
              x = (a + b)/2
              length = b - a
              return
              end

HTML::

        <table>
        <tr><td>Column 1</td><td>Column 2</td></tr>
        <tr><td>0.67526 </td><td>0.92871 </td></tr>
        <!-- comment -->
        </table>

But inline HTML code is also important, like text that starts with
``<a href="`` (which can destroy the following text if not properly
quoted).

Matlab with comments requires special typesetting::

        % Comment on the beginning of the line can be escaped by %%
        if a > b
          % Indented comment needs this trick
          c = a + b
        end

And here is a system call::

        Terminal> mkdir test
        Terminal> cd test
        Terminal> myprog -f
        output1
        output2

Any valid pygments lexer/language name can appear to, e.g.::

        !bc restructuredtext
        =======
        Heading
        =======
        
        Some text.
        !ec

results in::

        =======
        Heading
        =======
        
        Some text.

.. Here goes hidden code.

.. Python can be treated by some formats, Fortran is always out.

Finally, ``!bc do`` supports highlighting of DocOnce source::

        ======= DocOnce test file =======
        
        ===== Computer code =====
        
        Inline verbatim code, as in `import numpy as np`, is allowed, as well as
        code blocks:
        
        !bc pycod
        from math import sin
        
        def f(x):
            """Example on a function."""
            return sin(x) + 1
        
        print(f(0))
        !ec
        
        
        ===== Mathematics =====
        
        Formulas can be inline, as in $\nabla\cdot\bm{u} = 0$, or typeset
        as equations:
        
        !bt
        \begin{align*}
        \nabla\cdot\bm{u} &= 0,\\ 
        \bm{u} &= \nabla\phi .
        \end{align*}
        !et
        
        === Subsubsection heading ===
        
        DocOnce files can have chapters, sections, subsections, and subsubsections.
        
        __Paragraph heading.__ Paragraphs may have headings.

It is time to test ``verbatim inline font`` especially with ``a newline
inside the text`` and an exclamation mark at the end: ``BEGIN``! For
spellcheck, test ``a verbatim expression`` in ``another`` in a ``third``.
Also test exclamation mark as in ``!bc`` and ``!ec`` as well as ``a != b``.
Also test backslashes and braces like ``\begin``, ``\begin{enumerate}``,
``\end{this}\end{that}``, and ``{something \inside braces}``.

The following attempt to exemplify colored text does not work in
format rst.
Here is some **red color** and an attempt to write **with
green color containing a linebreak

| code.** Some formats will only display 
| this correctly when ``html`` 
| is the output format.

But here some more running text is added which is not part of
the previous blocks with line breaks.

Running OS commands
~~~~~~~~~~~~~~~~~~~

        Terminal> python -c 'print("Testing\noutput\nfrom\nPython.")'
        Testing
        output
        from
        Python.

Footnotes
~~~~~~~~~

Here is a test of footnotes [#footnote]_, which are handy in text.
They are used in different flavors, now in

 * list items (note below that footnotes work after math, verbatim, and URLs - bin fact old and emphasize too!)

 * even with math \\( \nabla^2u \\) [#math1]_

 * and code ``h[i] += 1`` [#code]_
   (*must* have space between inline code and footnote!)

 * and `links <https://google.com>`__ [#google-search]_

which gives flexibility in writing.
This is the third [#example-of-the-third-footnote]_ example.

.. [#footnote] Typesetting of the footnote depends on the format.
   Plain text does nothing, LaTeX removes the
   definition and inserts the footnote as part of the LaTeX text.
   reStructuredText and Sphinx employ a similar type of typesetting
   as Extended Markdown and DocOnce, and in HTML we keep the same
   syntax, just displayed properly in HTML.

.. [#math1] Math footnotes can be dangerous since it
   interferes with an exponent.

.. [#code] One-line footnote.

.. [#google-search] `<google.com>`_ is perhaps the most famous
   web site today.

Here is some more text before a new definition of a footnote that was
used above.


.. admonition:: Non-breaking space character

   This paragraph aims to test `non-breaking space character <https://en.wikipedia.org/wiki/Non-breaking_space>`__, and a typical
   example where this is needed is in physical units: 7.4 |nbsp| km is traveled
   in |nbsp| \\( 7.4/5.5\approx 1.345 \\) |nbsp| s.  Also check that a |nbsp| `link <https://google.com>`__ |nbsp| is
   not broken across lines (drag the browser window to test this).
   (On the other hand, the tilde is used in
   computer code, e.g., as in ``[~x for x in y]`` or in ``y=~x``, and should
   of course remain a tilde in those contexts.)




.. _subsec:ex:

Subsection 2: Testing figures
-----------------------------

Test of figures. In particular we refer to Figure `fig:impact`_ in which
there is a flow.

.. _fig:impact:

.. figure:: ../doc/src/manual/fig/wave1D.png
   :width: 200

   *Visualization **of** a *wave**  (fig:impact)

Figures without captions are allowed and will be inlined.

.. figure:: ../doc/src/manual/fig/wave1D.png
   :width: 200

.. Test multi-line caption in figure with sidecap=True

Here is figure `myfig`_ with a long (illegal) multi-line caption
containing inline verbatim text:

.. _myfig:

.. figure:: ../doc/src/manual/fig/wave1D.png
   :width: 500

   *A long caption spanning several lines and containing verbatim words like ``my_file_v1`` and ``my_file_v2`` as well as math with subscript as in $t_{i+1}$*  (myfig)

.. Must be a blank line after MOVIE or FIGURE to detect this problem

Test URL as figure name:

.. figure:: https://raw.github.com/doconce/doconce/master/doc/src/blog/f_plot.png
   :width: 500

.. Test wikimedia type of files that otherwise reside in subdirs

**Remark.**
Movies are tested in separate file ``movies.do.txt``.

.. Somewhat challenging heading with latex math, \t, \n, ? and parenthesis

.. _decay:sec:theta:

The \\( \theta \\) parameter (not \\( \nabla \\)?)
--------------------------------------------------

Functions do not always need to be advanced, here is one
involving \\( \theta \\)::

        def f(theta):
            return theta**2

**More on \\( \theta \\).**
Here is more text following headline with math.

Newcommands must also be tested in this test report:
\\( \frac{1}{2} \\), \\( {1/2} \\), \\( \pmb{x} \\), \\( \frac{Du}{dt} \\),
both inline and in block

.. raw:: html

        $$
        \begin{align}
        \frac{Du}{dt} &= 0\nonumber
        \\ 
        \frac{1}{2} &= {1/2}\\ 
        \frac{1}{2}\pmb{x} &= \pmb{n}
        \end{align}
        $$

Or with align with label and numbers

.. raw:: html

        $$
        \begin{align}
        \frac{Du}{dt} &= 0
        \label{aligneq1}
        \\ 
        \frac{1}{2} &= {1/2}\\ 
        \frac{1}{2}\pmb{x} &= \pmb{n}
        \label{aligneq2}
        \end{align}
        $$

.. Must test more complicated align and matrix compositions

.. where DocOnce inserts auto-numbered labels etc.

First one numbered (automatically)

.. raw:: html

        $$
        \begin{align}
        \begin{pmatrix}
        G_2 + G_3 & -G_3 & -G_2 & 0 \\ 
        -G_3 & G_3 + G_4 & 0 & -G_4 \\ 
        -G_2 & 0 & G_1 + G_2 & 0 \\ 
        0 & -G_4 & 0 & G_4
        \end{pmatrix}
        &=
        \begin{pmatrix}
         v_1 \\ 
         v_2 \\ 
         v_3 \\ 
         v_4
        \end{pmatrix}
        + \cdots \\ 
        \begin{pmatrix}
         C_5 + C_6 & -C_6 & 0 & 0 \\ 
         -C_6 & C_6 & 0 & 0 \\ 
         0 & 0 & 0 & 0 \\ 
         0 & 0 & 0 & 0
        \end{pmatrix}
          &= \frac{d}{dt}\begin{pmatrix}
         v_1 \\ 
         v_2 \\ 
         v_3 \\ 
         v_4
        \end{pmatrix} +
        \begin{pmatrix}
         0 \\ 
         0 \\ 
         0 \\ 
         -i_0
        \end{pmatrix}
        \nonumber
        \end{align}
        $$

Second numbered (automatically)

.. raw:: html

        $$
        \begin{align}
        \begin{pmatrix}
        G_1 + G_2\\ 
        -G_3 & G_4
        \end{pmatrix}
        &=
        \begin{pmatrix}
         v_1 \\ 
         v_2
        \end{pmatrix}
        + \cdots\nonumber
        \\ 
        \left(\begin{array}{ll}
        y & 2\\ 
        2 & 1
        \end{array}\right)
        \left(\begin{array}{ll}
        0 \\ x
        \end{array}\right)
        &= \begin{pmatrix}
        A \\ B
        \end{pmatrix}
        \end{align}
        $$

Both numbered, with label by the user

.. raw:: html

        $$
        \begin{align}
        \begin{pmatrix}
        G_1 + G_2\\ 
        -G_3 & G_4
        \end{pmatrix}
        &=
        \begin{pmatrix}
         v_1 \\ 
         v_2
        \end{pmatrix}
        + \cdots \label{mymatrix:eq1}
        \\ 
        \label{mymatrix:eq2}
        \left(\begin{array}{ll}
        y & 2\\ 
        2 & 1
        \end{array}\right)
        \left(\begin{array}{ll}
        0 \\ x
        \end{array}\right)
        &= \begin{pmatrix}
        A \\ B
        \end{pmatrix}
        \end{align}
        $$

Now we refer to Equations (mymatrix:eq1)-(mymatrix:eq2).

Custom Environments
-------------------

Here is an attempt to create a theorem environment via Mako
(for counting theorems) and comment lines to help replacing lines in
the ``.tex`` by proper begin-end LaTeX environments for theorems.
Should look nice in most formats!

.. begin theorem

**Theorem 5.**
Let \\( a=1 \\) and \\( b=2 \\). Then \\( c=3 \\).

.. end theorem

.. begin proof

**Proof.**
Since \\( c=a+b \\), the result follows from straightforward addition.
\\( \Diamond \\)

.. end proof

As we see, the proof of Theorem 5 is a modest
achievement.

.. _subsec:table:

Tables
------

.. index with comma could fool sphinx

Let us take this table from the manual:

====  ========  ============  
time  velocity  acceleration  
====  ========  ============  
0.0     1.4186         -5.01  
2.0   1.376512        11.919  
4.0     1.1E+1     14.717624  
====  ========  ============  

The DocOnce source code reads::

        
          |--------------------------------|
          |time  | velocity | acceleration |
          |--l--------r-----------r--------|
          | 0.0  | 1.4186   | -5.01        |
          | 2.0  | 1.376512 | 11.919       |
          | 4.0  | 1.1E+1   | 14.717624    |
          |--------------------------------|
        

Here is yet another table to test that we can handle more than
one table:

====  ========  ============  
time  velocity  acceleration  
====  ========  ============  
0.0   1.4186    -5.01         
1.0   1.376512  11.919        
3.0   1.1E+1    14.717624     
====  ========  ============  

And one with math headings (that are expanded and must be treated
accordingly), verbatim heading and entry, and no space around the pipe
symbol:

=========  ===========  ================  =======  
\\( i \\)  \\( h_i \\)  \\( \bar T_i \\)  ``L_i``  
=========  ===========  ================  =======  
0                    0               288  -0.0065  
1               11,000               216      0.0  
2               20,000               216    0.001  
3               32,000               228   0.0028  
4               47,000               270      0.0  
5               51,000               270  -0.0028  
6               71,000               214  ``NaN``  
=========  ===========  ================  =======  

And add one with verbatim headings (with underscores),
and rows starting with ``|-`` because of a negative number,
and ``|`` right before and after verbatim word (with no space):

=====  =======  =====================  ===========  
exact  ``v_1``  \\( a_i \\) + ``v_2``  ``verb_3_``  
=====  =======  =====================  ===========  
    9     9.62                   5.57         8.98  
  -20   -23.39                  -7.65       -19.93  
   10    17.74                  -4.50         9.96  
    0    -9.19                   4.13        -0.26  
=====  =======  =====================  ===========  

Pipe symbols in verbatim and math text in tables used to pose difficulties,
but not
anymore:

===============  ===============  
   \\( S \\)         command      
===============  ===============  
$ ||a_0|| $      ``norm|length``  
\\( x\cap y \\)          ``x|y``  
===============  ===============  

Here is a table with X alignment:

=====  ==========================================================================================================================================================================================================================  
 Type                                                                                                         Description                                                                                                          
=====  ==========================================================================================================================================================================================================================  
  X    Alignment character that is used for specifying a potentially very long text in a column in a table. It makes use of the ``tabularx`` package in LaTeX, otherwise (for other formats) it means ``l`` (centered alignment).  
l,r,c  standard alignment characters                                                                                                                                                                                               
=====  ==========================================================================================================================================================================================================================  

Finally, a table with math
(``bm`` that expands to ``boldsymbol``, was tricky, but
cleanly handled now)
and URLs.

.. Mako code to expand URLs in the table

.. (These types of tables did not work before Jan 2014)

=============================  ==========================================================  ==========================================================  
                                                                                                                                                       
=============================  ==========================================================  ==========================================================  
    \\( \mathcal{L}=0 \\)      `080 <../doc/src/manual/mov/wave_frames/frame_0080.png>`__  `085 <../doc/src/manual/mov/wave_frames/frame_0085.png>`__  
         \\( a=b \\)           `090 <../doc/src/manual/mov/wave_frames/frame_0090.png>`__  `095 <../doc/src/manual/mov/wave_frames/frame_0095.png>`__  
\\( \nabla\cdot\bm{u} =0  \\)  `100 <../doc/src/manual/mov/wave_frames/frame_0100.png>`__  `105 <../doc/src/manual/mov/wave_frames/frame_0105.png>`__  
=============================  ==========================================================  ==========================================================  

A test of verbatim words in heading with subscript \\( a_i \\): ``my_file_v1`` and ``my_file_v2``
-------------------------------------------------------------------------------------------------

**Paragraph with verbatim and math: ``my_file_v1.py`` and ``my_file_v2.py`` define some math \\( a_{i-1} \\).**
Here is more ``__verbatim__`` code and
some plain text on a new line.

.. Test various types of headlines

**Just bold**
-------------

Some text.

*Just emphasize*
----------------

Some text.

``Just verbatim``
-----------------

Some text.

**Bold** beginning
------------------

Some text.

*Emphasize* beginning
---------------------

Some text.

``Verbatim`` beginning
----------------------

Some text.

Maybe **bold end**
------------------

Some text.

Maybe *emphasize end*
---------------------

Some text.

Maybe ``verbatim end``
----------------------

Some text.

The middle has **bold** word
----------------------------

Some text.

The middle has *emphasize* word
-------------------------------

Some text.

The middle has ``verbatim`` word
--------------------------------

Some text.

***Just emphasize*.**
Some text.

**``Just verbatim``.**
Some text.

***Emphasize* beginning.**
Some text.

**``Verbatim beginning``.**
Some text.

**Maybe *emphasize end*.**
Some text.

**Maybe ``verbatim end``.**
Some text.

**The middle has *emphasize* word.**
Some text.

**The middle has ``verbatim`` word.**
Some text.

**Ampersand.**
We can test Hennes & Mauritz, often abbreviated H&M, but written
as ``Hennes & Mauritz`` and ``H & M``.
A sole ``&`` must also work.

.. Note: substitutions must not occur inside verbatim, just in ordinary text::

        # Just to check that ampersand works in code blocks:
        c = a & b

**Quotes.**
Let us also add a test of quotes such as "double quotes, with numbers
like 3.14 and newline/comma and hyphen (as in double-quote)"; written
in the standard LaTeX-style that gives correct LaTeX formatting and
ordinary double quotes for all non-LaTeX formats.  Here is another
sentence that "caused" a bug in the past because double backtick
quotes could imply verbatim text up to a verbatim word starting with
period, like ``.txt``.

More quotes to be tested for spellcheck:
("with parenthesis"), "with newline"
and "with comma", "hyphen"-wise, and "period".

Bibliography test
-----------------

Here is an example: [Ref01]_ discussed propagation of
large destructive water waves, [Ref02]_ gave
an overview of numerical methods for solving the Navier - Stokes equations,
while the use of Backward Kolmogorov equations for analyzing
random vibrations was investigated in [Ref03]_.
The book chapter [Ref04]_ contains information on
C++ software tools for programming multigrid methods. A real retro
reference is [Ref05]_ about a big FORTRAN package.
Multiple references are also possible, e.g., see
[Ref01]_ [Ref04]_.

We need to cite more than 10 papers to reproduce an old formatting
problem with blanks in the keys in reST format:
[Ref06]_ [Ref03]_ [Ref07]_ [Ref01]_
and
[Ref02]_ [Ref08]_ [Ref09]_ [Ref10]_ [Ref11]_ [Ref12]_ [Ref13]_
and all the work of
[Ref14]_ [Ref04]_ [Ref15]_ as well as
old work [Ref05]_ and [Ref16]_, and the
talk [Ref17]_.
Langtangen also had two thesis [Ref18]_ [Ref16]_
back in the days.
More retro citations are
the old ME-IN323 book [Ref19]_ and the
[Ref20]_ OONSKI '94 paper.

.. --- begin exercise ---

.. _Example:

Example 1: Examples can be typeset as exercises
-----------------------------------------------

Examples can start with a subsection heading starting with ``Example:``
and then, with the command-line option ``--examples_as_exercises`` be
typeset as exercises. This is useful if one has solution
environments as part of the example.

**a)**
State some problem.

**Solution.**
The answer to this subproblem can be written here.

**b)**
State some other problem.

**Hint 1.**
A hint can be given.

**Hint 2.**
Maybe even another hint?

**Solution.**
The answer to this other subproblem goes here,
maybe over multiple doconce input lines.

.. --- end exercise ---

User-defined environments
-------------------------

The example in the section `Example 1: A test function`_ demonstrates how to write a test function.
That is, a special test function for a function ``add`` appears in
the example in the section `Example 1: A test function`_.

.. _ex:test:1p1:

Example 1: A test function
--------------------------

Suppose we want to write a test function for checking the
implementation of a Python function for addition::

        def add(a, b):
            return a + b
        
        def test_add():
            a = 1; b = 1
            expected = a + b
            computed = add(a, b)
            assert expected == computed

.. _ex:math:1p1:

Example 2: Addition
-------------------

We have

.. raw:: html

        $$ 1 + 1 = 2 $$

or in tabular form:

===========  =========  
  Problem      Result   
===========  =========  
\\( 1+1 \\)  \\( 2 \\)  
===========  =========  


.. admonition:: Highlight box

   This environment is used to highlight something
   
   .. raw:: html
   
           $$ E = mc^2 $$




.. _subsubsec:ex:

URLs
----

Testing of URLs: hpl's home page `hpl <https://folk.uio.no/hpl>`__, or
the entire URL if desired, `<https://folk.uio.no/hpl>`_.  Here is a
plain file link `<testdoc.do.txt>`_, or `<testdoc.do.txt>`_, or
`<testdoc.do.txt>`_ or `<testdoc.do.txt>`_ or `a link with
newline <testdoc.do.txt>`__. Can test spaces with the link with word
too: `hpl <https://folk.uio.no/hpl>`__ or `hpl <https://folk.uio.no/hpl>`__. Also ``file:///`` works: `link to a
file <file:///home/hpl/vc/doconce/doc/demos/manual/manual.html>`__ is
fine to have. Moreover, "loose" URLs work, i.e., no quotes, just
the plain URL as in `<https://folk.uio.no/hpl>`_, if followed by space, comma,
colon, semi-colon, question mark, exclamation mark, but not a period
(which gets confused with the periods inside the URL).

Mail addresses can also be used: `hpl@simula.no <mailto:hpl@simula.no>`__, or just a `mail link <mailto:hpl@simula.no>`__, or a raw `<mailto:hpl@simula.no>`_.

Here are some tough tests of URLs, especially for the ``latex`` format:
`Newton-Cotes <https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas>`__ formulas
and a `good book <https://www.springer.com/mathematics/computational+science+%26+engineering/book/978-3-642-23098-1>`__. Need to test
Newton-Cotes with percentage in URL too:
`<https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas>`_
and `<https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae>`_ which has a shebang.

For the ``--device=paper`` option it is important to test that URLs with
monospace font link text get a footnote
(unless the ``--latex_no_program_footnotelink``
is used), as in this reference to
`decay_mod <https://github.com/hplgit/INF5620/tree/gh-pages/src/decay/experiments/decay_mod.py>`__, `ball1.py <https://tinyurl.com/pwyasaa/formulas.ball1.py>`__,
and `ball2.py <https://tinyurl.com/pwyasaa/formulas.ball2.py>`__.

.. Comments should be inserted outside paragraphs (because in the rst

.. format extra blanks make a paragraph break).

.. Note that when there is no https: or file:, it can be a file link

.. if the link name is URL, url, "URL", or "url". Such files should,

.. if rst output is desired, but placed in a ``_static*`` folder.

More tough tests: repeated URLs whose footnotes when using the
``--device=paper`` option must be correct. We have
`google <https://google.com>`__, `google <https://google.com>`__, and
`google <https://google.com>`__, which should result in exactly three
footnotes.

.. !split and check if these extra words are included properly in the comment

LaTeX Mathematics
=================

Here is an equation without label using backslash-bracket environment

.. raw:: html

        $$ a = b + c $$

or with number and label, as in Equation (my:eq1), using the equation environment

.. raw:: html

        $$
        \begin{equation}
        {\partial u\over\partial t} = \nabla^2 u \label{my:eq1}
        \end{equation}
        $$

We can refer to this equation by Equation (my:eq1).

Here is a system without equation numbers, using the align-asterisk environment

.. raw:: html

        $$
        \begin{align*}
        \pmb{a} &= \pmb{q}\times\pmb{n} \\ 
        b &= \nabla^2 u + \nabla^4 v
        \end{align*}
        $$

More mathematical typesetting is demonstrated in the coming exercises.

Below, we have `Problem 2: Flip a Coin`_ and `Project 4: Compute a Probability`_,
as well as `Project 5: Explore Distributions of Random Circles`_ and `Project 11: References in a headings do not work well in rst`_, and in
between there we have `Exercise 10: Make references to projects and problems`_.

Exercises
=========

.. --- begin exercise ---

.. _demo:ex:1:

Problem 2: Flip a Coin
----------------------

.. keywords = random numbers; Monte Carlo simulation; ipynb

.. Torture tests

**a)**
Make a program that simulates flipping a coin \\( N \\) times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

.. --- begin hint in exercise ---

**Hint 1.**
Use ``r = random.random()`` and define head as ``r <= 0.5``.

.. --- end hint in exercise ---

.. --- begin hint in exercise ---

**Hint 2.**
Draw an integer among \\( \{1,2\} \\) with
``r = random.randint(1,2)`` and define head when ``r`` is 1.

.. --- end hint in exercise ---

.. --- begin answer of exercise ---

**Answer.**
If the ``random.random()`` function returns a number \\( <1/2 \\), let it be
head, otherwise tail. Repeat this \\( N \\) number of times.

.. --- end answer of exercise ---

.. --- begin solution of exercise ---

**Solution.**::

        import sys, random
        N = int(sys.argv[1])
        heads = 0
        for i in range(N):
            r = random.random()
            if r <= 0.5:
                heads += 1
        print('Flipping a coin %d times gave %d heads' % (N, heads))

.. --- end solution of exercise ---

**b)**
Vectorize the code in a) using boolean indexing.

Vectorized code can be written in many ways.
Sometimes the code is less intuitive, sometimes not.
At least there is not much to find in the section `Section 1`_.

**c)**
Vectorize the code in a) using ``numpy.sum``.

.. --- begin answer of exercise ---

**Answer.**
``np.sum(np.where(r <= 0.5, 1, 0))`` or ``np.sum(r <= 0.5)``.

.. --- end answer of exercise ---

In this latter subexercise, we have an
example where the code is easy to read.

My remarks
~~~~~~~~~~

Remarks with such a subsubsection is treated as more text
after the last subexercise. Test a list too:

1. Mark 1.

2. Mark 2.

Filenames: ``flip_coin.py``, ``flip_coin.pdf``.

.. Closing remarks for this Problem

Remarks          (1)
~~~~~~~~~~~~~~~~~~~~

These are the exercise remarks, appearing at the very end.

.. solution files: mysol.txt, mysol_flip_coin.py, yet_another.file

.. --- end exercise ---

Not an exercise
---------------

Should be possible to stick a normal section in the middle of many
exercises.

.. --- begin exercise ---

.. _my:exer1:

Exercise 3: Test of plain text exercise
---------------------------------------

Very short exercise. What is the capital
of Norway?
Filename: ``myexer1``.

.. --- end exercise ---

.. --- begin exercise ---

.. _demo:ex:2:

Project 4: Compute a Probability
--------------------------------

.. Minimalistic exercise

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval \\( [0,1) \\)?

At the end we have a list because that caused problems in LaTeX
in previous DocOnce versions:

1. item1

2. item2

.. --- begin hint in exercise ---

**Hint.**
To answer this question empirically, let a program
draw \\( N \\) such random numbers using Python's standard ``random`` module,
count how many of them, \\( M \\), that fall in the interval \\( (0.5,0.6) \\), and
compute the probability as \\( M/N \\).

.. --- end hint in exercise ---

.. --- end exercise ---

.. --- begin exercise ---

.. _proj:circle1:

Project 5: Explore Distributions of Random Circles
--------------------------------------------------

.. keywords = ipynb

The formula for a circle is given by

.. raw:: html

        $$
        \begin{align}
        x &= x_0 + R\cos 2\pi t,
        \label{circle:x}\\ 
        y &= y_0 + R\sin 2\pi t,
        \label{circle:y}
        \end{align}
        $$

where \\( R \\) is the radius of the circle, \\( (x_0,y_0) \\) is the
center point, and \\( t \\) is a parameter in the unit interval \\( [0,1] \\).
For any \\( t \\), \\( (x,y) \\) computed from Equations (circle:x)-(circle:y)
is a point on the circle.
The formula can be used to generate ``n`` points on a circle::

        import numpy as np
        
        def circle(R, x0, y0, n=501):
            t = np.linspace(0, 1, n)
            x = x0 + R*np.cos(2*np.pi*t)
            y = y0 + R*np.sin(2*np.pi*t)
            return x, y
        
        x, y = circle(2.0, 0, 0)

.. Often in an exercise we have some comments about the solution

.. which we normally want to keep where they are.

The goal of this project is to draw \\( N \\) circles with random
center and radius. Plot each circle using the ``circle`` function
above.

**a)**
Let \\( R \\) be normally distributed and \\( (x_0,y_0) \\) uniformly distributed.

.. --- begin hint in exercise ---

**Hint.**
Use the ``numpy.random`` module to draw the
\\( x_0 \\), \\( y_0 \\), and \\( R \\) quantities.

.. --- end hint in exercise ---

.. --- begin answer of exercise ---

**Answer.**
Here goes the short answer to part a).

.. --- end answer of exercise ---

.. --- begin solution of exercise ---

**Solution.**
Here goes a full solution to part a).

.. --- end solution of exercise ---

**b)**
Let \\( R \\) be uniformly distributed and \\( (x_0,y_0) \\) normally distributed.
Filename: ``norm``.

**c)**
Let \\( R \\) and \\( (x_0,y_0) \\) be normally distributed.

Filename: ``circles``.

.. Closing remarks for this Project

Remarks          (2)
~~~~~~~~~~~~~~~~~~~~

At the very end of the exercise it may be appropriate to summarize
and give some perspectives.

.. --- end exercise ---

.. --- begin exercise ---

.. _exer:dist:

Exercise 6: Determine some Distance
-----------------------------------

Intro to this exercise. Questions are in subexercises below.

.. --- begin solution of exercise ---

**Solution.**
Here goes a full solution of the whole exercise.
With some math \\( a=b \\) in this solution

.. raw:: html

        $$ \hbox{math in solution: } a = b $$

And code ``a=b`` in this solution::

        a = b  # code in solution

End of solution is here.

.. --- end solution of exercise ---

**a)**
Subexercises are numbered a), b), etc.

.. --- begin hint in exercise ---

**Hint 1.**
First hint to subexercise a).
With math \\( a=b \\) in hint

.. raw:: html

        $$ a=b. $$

And with code (in plain verbatim) returning \\( x+1 \\) in hint::

        def func(x):
            return x + 1  # with code in hint

.. --- end hint in exercise ---

.. --- begin hint in exercise ---

**Hint 2.**
Second hint to subexercise a).

Test list in hint:

1. item1

2. item2

.. --- end hint in exercise ---

Filename: ``subexer_a.pdf``.

.. --- begin answer of exercise ---

**Answer.**
Short answer to subexercise a).
With math in answer: \\( a=b \\).

.. --- end answer of exercise ---

**b)**
Here goes the text for subexercise b).

Some math \\( \cos^2 x + \sin^2 x = 1 \\) written one a single line

.. raw:: html

        $$ \cos^2 x + \sin^2 x = 1 \thinspace .$$

.. --- begin hint in exercise ---

**Hint.**
A hint for this subexercise.

.. --- end hint in exercise ---

Filename: ``subexer_b.pdf``.

.. --- begin solution of exercise ---

**Solution.**
Here goes the solution of this subexercise.

.. --- end solution of exercise ---

.. No meaning in this weired test example:

The text here belongs to the main (intro) part of the exercise. Need
closing remarks to have text after subexercises.

Test list in exercise:

1. item1

2. item2

.. Closing remarks for this Exercise

Remarks          (3)
~~~~~~~~~~~~~~~~~~~~

Some final closing remarks, e.g., summarizing the main findings
and their implications in other problems can be made. These
remarks will appear at the end of the typeset exercise.

.. --- end exercise ---

.. --- begin exercise ---

Some exercise without the "Exercise:" prefix
--------------------------------------------

.. Another minimalistic exercise

Just some text. And some math saying that \\( e^0=1 \\) on a single line,
to test that math block insertion is correct

.. raw:: html

        $$ \exp{(0)} = 1 $$

And a test that the code ``lambda x: x+2`` is correctly placed here::

        lambda x: x+2

.. Have some comments at the end of the exercise to see that

.. the Filename: ... is written correctly.

.. --- end exercise ---

.. --- begin exercise ---

.. _sec:this:exer:de:

Exercise 8: Solution of differential equation
---------------------------------------------



.. begin quiz

Given

.. raw:: html

        $$ \frac{dy}{dx} = -y(x),\quad y(0)=1 $$

What is the solution of this equation?


**Choice A:** \\( y=e^{-y} \\)

:abbr:`? (Right!)`

**Choice B:** \\( y=e^{y} \\)

:abbr:`? (Wrong!)` :abbr:`# (Almost, but the sign is wrong (note the minus!).)`

**Choice C:** Code::

        from math import exp
        def f(x):
            return exp(x)

:abbr:`? (Wrong!)` :abbr:`# (Ooops, forgot a minus: exp(-x), otherwise this Python code must be considered as a good answer. It is more natural, though, to write the solution to the problem in mathematical notation  .. raw:: html          $$ y(x) = e^{-y}.$$)`

**Choice D:** The solution cannot be found because there is a derivative in the equation.

:abbr:`? (Wrong!)` :abbr:`# (Equations with derivatives can be solved; they are termed *differential equations*.)`

**Choice E:** The equation is meaningless: an equation must be an equation
for \\( x \\) or \\( y \\), not a function \\( y(x) \\).

:abbr:`? (Wrong!)` :abbr:`# (Equations where the unknown is a function, as \\( y(x) \\) here, are called *differential equations*, and are solved by special techniques.)`

.. end quiz



.. --- end exercise ---

.. --- begin exercise ---

Example 9: Just an example
--------------------------

.. This example needs the --examples_as_exercises option, otherwise

.. it is just typeset as it is written.

**a)**
What is the capital of Norway?

**Answer.**
Oslo.

.. --- end exercise ---

Here goes another section
=========================

With some text, before we continue with exercises.

More Exercises
==============

.. --- begin exercise ---

.. _exer:some:formula:

Exercise 10: Make references to projects and problems
-----------------------------------------------------

.. Test comments not at the end only

Pick a statement from `Project 5: Explore Distributions of Random Circles`_ or `Problem 2: Flip a Coin`_
and verify it.

Test list at the end of an exercise without other elements (like subexercise,
hint, etc.):

1. item1

2. item2

Filename: ``verify_formula.py``.

.. --- end exercise ---

.. --- begin exercise ---

.. _exer:you:

Project 11: References in a headings do not work well in rst
------------------------------------------------------------

Refer to the previous exercise as `Exercise 10: Make references to projects and problems`_,
the two before that as `Project 4: Compute a Probability`_ and `Project 5: Explore Distributions of Random Circles`_,
and this one as `Project 11: References in a headings do not work well in rst`_.
Filename: ``selc_composed.pdf``.

.. --- end exercise ---

References
==========

.. [Ref01]
   **H. P. Langtangen and G. Pedersen**. Propagation of Large Destructive Waves,
   *International Journal of Applied Mechanics and Engineering*,
   7(1),
   pp. 187-204,
   2002.

.. [Ref02]
   **H. P. Langtangen, K.-A. Mardal and R. Winther**. Numerical Methods for Incompressible Viscous Flow,
   *Advances in Water Resources*,
   25,
   pp. 1125-1146,
   2002.

.. [Ref03]
   **H. P. Langtangen**. Numerical Solution of First Passage Problems in Random Vibrations,
   *SIAM Journal of Scientific and Statistical Computing*,
   15,
   pp. 997-996,
   1994.

.. [Ref04]
   **K.-A. Mardal, G. W. Zumbusch and H. P. Langtangen**. Software Tools for Multigrid Methods,
   Advanced Topics in Computational Partial Differential Equations -- Numerical Methods and Diffpack Programming,
   edited by **H. P. Langtangen and A. Tveito**,
   Springer,
   2003,
   Edited book,
   `\urlhttp://some.where.org <\urlhttp://some.where.org>`_.

.. [Ref05]
   **H. P. Langtangen**. The FEMDEQS Program System,
   *Department of Mathematics, University of Oslo*,
   `http://www.math.uio.no/old/days/hpl/femdeqs.pdf <http://www.math.uio.no/old/days/hpl/femdeqs.pdf>`_,
   1989.

.. [Ref06]
   **H. P. Langtangen**. Stochastic Breakthrough Time Analysis of an Enhanced Oil Recovery Process,
   *SIAM Journal on Scientific Computing*,
   13,
   pp. 1394-1417,
   1992.

.. [Ref07]
   **M. Mortensen, H. P. Langtangen and G. N. Wells**. A FEniCS-Based Programming Framework for Modeling Turbulent Flow by the Reynolds-Averaged Navier-Stokes Equations,
   *Advances in Water Resources*,
   34(9),
   `doi: 10.1016/j.advwatres.2011.02.013 <https://dx.doi.org/10.1016/j.advwatres.2011.02.013>`__,
   2011.

.. [Ref08]
   **S. Glimsdal, G. Pedersen, K. Atakan, C. B. Harbitz, H. P. Langtangen and F. L\ovholt**. Propagation of the Dec. |nbsp| 26, 2004 Indian Ocean Tsunami: Effects of Dispersion and Source Characteristics,
   *International Journal of Fluid Mechanics Research*,
   33(1),
   pp. 15-43,
   2006.

.. [Ref09]
   **S. Rahman, J. Gorman, C. H. W. Barnes, D. A. Williams and H. P. Langtangen**. Numerical Investigation of a Piezoelectric Surface Acoustic Wave Interaction With a One-Dimensional Channel,
   *Physical Review B: Condensed Matter and Materials Physics*,
   74,
   2006,
   035308.

.. [Ref10]
   **J. B. Haga, H. Osnes and H. P. Langtangen**. On the Causes of Pressure Oscillations in Low-Permeable and Low-Compressible Porous Media,
   *International Journal of Analytical and Numerical Methods in Geomechanics*,
   `doi: 10.1002/nag.1062 <https://dx.doi.org/10.1002/nag.1062>`__,
   2011,
   `http://onlinelibrary.wiley.com/doi/10.1002/nag.1062/abstract <http://onlinelibrary.wiley.com/doi/10.1002/nag.1062/abstract>`_.

.. [Ref11]
   **H. P. Langtangen**. *Computational Partial Differential Equations - Numerical Methods and Diffpack Programming*,
   second edition,
   *Texts in Computational Science and Engineering*,
   Springer,
   2003.

.. [Ref12]
   **H. P. Langtangen**. *Python Scripting for Computational Science*,
   third edition,
   *Texts in Computational Science and Engineering*,
   Springer,
   2008.

.. [Ref13]
   **H. P. Langtangen and G. Pedersen**. Finite Elements for the Boussinesq Wave Equations,
   Waves and Non-linear Processes in Hydrodynamics,
   edited by **J. Grue, B. Gjevik and J. E. Weber**,
   Kluwer Academic Publishers,
   pp. pp. 117-126,
   1995,
   `http://www.amazon.ca/Waves-Nonlinear-Processes-Hydrodynamics-John/dp/0792340310 <http://www.amazon.ca/Waves-Nonlinear-Processes-Hydrodynamics-John/dp/0792340310>`_.

.. [Ref14]
   **H. P. Langtangen**. *A Primer on Scientific Programming With Python*,
   third edition,
   *Texts in Computational Science and Engineering*,
   Springer,
   2012.

.. [Ref15]
   **P. V. Jeberg, H. P. Langtangen and C. B. Terp**. Optimization With Diffpack: Practical Example From Welding,
   *Simula Research Laboratory*,
   Internal report,
   2004.

.. [Ref16]
   **H. P. Langtangen**. Computational Methods for Two-Phase Flow in Oil Reservoirs,
   Ph.D. Thesis,
   Mechanics Division, Department of Mathematics, University of Oslo,
   1989,
   Dr. |nbsp| Scient. |nbsp| thesis..

.. [Ref17]
   **H. P. Langtangen**. Computational Modeling of Huge Tsunamis From Asteroid Impacts,
   Invited keynote lecture at the \emphInternational conference on Computational Science 2007 (ICCS'07), Beijing, China,
   2007.

.. [Ref18]
   **H. P. Langtangen**. Solution of the Navier-Stokes Equations With the Finite Element Method in Two and Three Dimensions,
   M.Sc. Thesis,
   Mechanics Division, Department of Mathematics, University of Oslo,
   1985,
   Cand.Scient. thesis.

.. [Ref19]
   **H. P. Langtangen and A. Tveito**. Numerical Methods in Continuum Mechanics,
   *Center for Industrial Research*,
   1991,
   Lecture notes for a course (ME-IN 324). 286 pages..

.. [Ref20]
   **H. P. Langtangen**. Diffpack: Software for Partial Differential Equations,
   Proceedings of the Second Annual Object-Oriented Numerics Conference (OON-SKI'94), Sunriver, Oregon, USA,
   edited by **A. Vermeulen**,
   1994.

.. _app1:

Appendix: Just for testing; part I
==================================

This is the first appendix.

A subsection within an appendix
-------------------------------

Some text.

.. _app2:

Appendix: Just for testing; part II
===================================

This is more stuff for an appendix.

Appendix: Testing identical titles          (1)
-----------------------------------------------

Without label.

.. _test:title:id1:

Appendix: Testing identical titles          (2)
-----------------------------------------------

With label.

.. _test:title:id2:

Appendix: Testing identical titles          (3)
-----------------------------------------------

What about inserting a quiz?



.. !split
Test of quizzes
---------------.. begin quiz



**Fundamental test:** What is the capital of Norway?


**Answer 1:** Stockholm

:abbr:`? (Wrong!)` :abbr:`# (Stockholm is the capital of Sweden.)`

**Answer 2:** London

:abbr:`? (Wrong!)`

**Answer 3:** Oslo

:abbr:`? (Right!)`

**Choice D:** Bergen

:abbr:`? (Wrong!)` :abbr:`# (Those from Bergen would claim so, but nobody else.)`

.. end quiz



Appendix: Testing identical titles          (4)
-----------------------------------------------

Without label.


.. admonition:: Tip

   Here is a tip or hint box, typeset as a notice box.




Need a lot of text to surround the summary box.
Version control systems allow you to record the history of files
and share files among several computers and collaborators in a
professional way. File changes on one computer are updated or
merged with changes on another computer. Especially when working
with programs or technical reports it is essential
to have changes documented and to
ensure that every computer and person involved in the project
have the latest updates of the files.
Greg Wilson' excellent `Script for Introduction to Version Control <https://software-carpentry.org/2010/07/script-for-introduction-to-version-control/>`__ provides a more detailed motivation why you will benefit greatly
from using version control systems.


.. admonition:: Summary

   **Bold remark:** Make some text with this summary.
   Much testing in this document, otherwise stupid content.
   Much testing in this document, otherwise stupid content.
   Much testing in this document, otherwise stupid content.
   Much testing in this document, otherwise stupid content.
   Much testing in this document, otherwise stupid content.
   Much testing in this document, otherwise stupid content.
   Much testing in this document, otherwise stupid content.
   Much testing in this document, otherwise stupid content.
   Much testing in this document, otherwise stupid content.




Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that site. I strongly
recommend you to use such sites for all serious programming and
scientific writing work - and all other important files.

The simplest services for hosting project files are `Dropbox <https://dropbox.com>`__ and `Google Drive <https://drive.google.com>`__.
It is very easy to get started with these systems, and they allow you
to share files among laptops and mobile units with as many users as
you want. The systems offer a kind of version control in that the
files are stored frequently (several times per minute), and you can go
back to previous versions for the last 30 days. However, it is
challenging  to find the right version from the past when there are
so many of them.

More seriously, when several people may edit files simultaneously, it
can be difficult detect who did what when, roll back to previous
versions, and to manually merge the edits when these are
incompatible. Then one needs more sophisticated tools than Dropbox or
Google Drive: project hosting services with true version control
systems.  The following text aims at providing you with the minimum
information to started with such systems. Numerous other tutorials
contain more comprehensive material and in-depth explanations of the
concepts and tools.

The idea with project hosting services is that you have the files
associated with a project in the cloud. Many people may share these
files.  Every time you want to work on the project you explicitly
update your version of the files, edit the files as you like, and
synchronize the files with the "master version" at the site where the
project is hosted.  If you at some point need to go back to a
version of the files at some particular point in the past,
this is an easy operation. You can also use tools to see
what various people have done with the files in the various versions.

All these services are very similar. Below we describe how you get
started with Bitbucket, GitHub, and Googlecode. Launchpad works very
similarly to the latter three. All the project hosting services have
excellent introductions available at their web sites, but the recipes
below are much shorter and aim at getting you started as quickly as
possible by concentrating on the most important need-to-know steps.
The Git tutorials we refer to later in this document contain more
detailed information and constitute of course very valuable readings
when you use version control systems every day. The point now is
to get started.

Appendix: Testing inline comments
---------------------------------

.. Names can be [ A-Za-z0-9_'+-]+

Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that
site. **(**hpl's semi opinion 1**: not sure if in the cloud is
understood by
all.**) I strongly recommend you to use such sites for all serious
programming and scientific writing work - and all other important
files.

The simplest services for hosting project files is Dropbox. **(**mp 2**: Simply go to `<https://dropbox.com>`_ and watch the video. It explains
how files, like ``myfile.py``, perhaps containing much math, like
\\( \partial u/\partial t \\), are easily communicated between machines.**) It
is very easy to get started with Dropbox, and it allows you to share
files among **(**hpl 3**: laptops and mobile units -> computers, tablets,
and phones**).

.. Test horizontal rule

---------

.. Coments for editing

Firstcolor{red}{(**add 4**: ,}) consider a quantity \\( Q \\). **(**edit 5**: To this end, -> We note that**)
\\( Q>0 \\), because **(**del 6**: a**) negative **(**edit 7**: quantity is -> quantities
are**) **(**del 8**: just**) negative. **(**add 9**: This comes as no surprise.**)

.. Test tailored latex figure references with page number

Let us refer to Figure `fig:impact`_ again.

Test references in a list:

 * `Section 1`_

 * `Subsection 1`_

 * `fig:impact`_

Appendix: Testing headings ending with ``verbatim inline``
----------------------------------------------------------

The point here is to test 1) ``verbatim`` code in headings, and 2)
ending a heading with verbatim code as this triggers a special
case in LaTeX.

We also test mdash---used as alternative to hyphen without spaces around,
or in quotes:


..

    *Fun is fun*.---Unknown.



The ndash should also be tested - as in the Hanson - Nilson equations
on page 277 - 278.

And finally, what about admons, quotes, and boxes? They are tested
in a separate document: ``admon.do.txt``.

.. [#example-of-the-third-footnote] Not much to add here, but the footnote
   is at the end with only one newline.
************** File: testdoc.sphinx.rst *****************
.. raw:: html

        <script type="text/javascript">
        $(document).ready(function() {
            $("a[href^='http']").attr('target','_blank');
        });
        </script>

.. Automatically generated Sphinx-extended reStructuredText file from DocOnce source
   (https://github.com/doconce/doconce/)

.. |nbsp| unicode:: 0xA0
   :trim:

.. Document title:

A Document for Testing DocOnce
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:Authors: Hans Petter Langtangen (hpl at simula.no), Kaare Dump, A. Dummy Author, I. S. Overworked and Outburned, J. Doe (j_doe at cyberspace.com)
:Date: Jan 32, 2100

The format of this document is
sphinx

*Abstract.* This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.

.. Cannot demonstrate chapter headings since abstract and chapter

.. are mutually exclusive in LaTeX

.. !split

.. _sec1:

Section 1
=========

Here is a nested list:

  * item1

  * item2

  * item3 which continues
    on the next line to test that feature

  * and a sublist

    * with indented subitem1

    * and a subitem2

  * and perhaps an ordered sublist

   a. first item

   b. second item,
      continuing on a new line

**Here is a list with paragraph heading.**

  * item1

  * item2

Here is a list with subsubsection heading
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  * item1

  * item2


..

    Here are two lines that make up
    a block quote for testing *emphasized words* and **boldface words**,
    also with hypens:
    *pre*-fix, post-*fix*, **pre**-fix, post-**fix**.



Here are two references. Equation |nbsp| :eq:`my:eq1` is fine. Eq. |nbsp| :eq:`my:eq1` too.
Even Equation :eq:`my:eq1` without the tilde.
This equation appears in another part if this document is split.

.. _subsec1:

Subsection 1
------------

.. index:: somefunc function

.. Refer to section/appendix etc. at the beginning of the line

.. and other special fix situations for HTML.

More text, with a reference back to
the section :ref:`sec1` and :ref:`subsec1`, and further to the
the sections :ref:`subsec1` and :ref:`subsubsec:ex`, which
encourages you to do the tasks in :ref:`demo:ex:1` and :ref:`exer:some:formula`.
 :ref:`app1` and :ref:`app2` are also nice elements.

Test Section reference at beginning of line and after a sentence
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The section :ref:`subsec1` is fine.
The section :ref:`subsubsec:ex` too.

.. sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console

Computer code
~~~~~~~~~~~~~

Let's do some copying from files too. First from subroutine up to the very end,

.. code-block:: fortran

          subroutine test()
          integer i
          real*8 r
          r = 0
          do i = 1, i
             r = r + i
          end do
          return
    C     END1
    
          program testme
          call test()
          return

and then just the subroutine,

.. code-block:: fortran

          subroutine test()
          integer i
          real*8 r
          r = 0
          do i = 1, i
             r = r + i
          end do
          return

and finally the complete file with a plain text verbatim environment
(``envir=ccq``):

.. code-block:: text

    C     a comment
    
          subroutine test()
          integer i
          real*8 r
          r = 0
          do i = 1, i
             r = r + i
          end do
          return
    C     END1
    
          program testme
          call test()
          return

Testing other code environments. First Python:

.. code-block:: text

    !bc pycod
    def f(x):
        return x+1
    !ec

which gets rendered as

.. code-block:: python

    def f(x):
        return x+1

Test paragraph and subsubsection headings before
before code.

**Paragraph heading before code.**

.. code-block:: python

    import sys
    sys.path.insert(0, os.pardir)

Subsubsection heading before code
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

.. code-block:: python

    def h(z):
        return z+1

Now a complete program to be shown via Python Online Tutorial:

.. raw:: html

    <iframe width="950" height="500" frameborder="0"
            src="https://pythontutor.com/iframe-embed.html#code=class+Line%3A%0A++++def+__init__%28self%2C+a%2C+b%29%3A%0A++++++++self.a%2C+self.b+%3D+a%2C+b%0A%0A++++def+__call__%28self%2C+x%29%3A%0A++++++++a%2C+b+%3D+self.a%2C+self.b%0A++++++++return+a%2Ax+%2B+b%0A%0Aline+%3D+Line%282%2C+1%29%0Ay+%3D+line%28x%3D3%29%0Aprint%28y%29&py=2&curInstr=0&cumulative=false">
    </iframe>

Another complete program to be typeset as a sage cell:

.. code-block:: text

    a = 2
    b = 3
    print('a+b:', a + b)
    
    # In a sage cell we can also plot
    from matplotlib.pyplot import *
    from numpy import *
    x = linspace(0, 4*pi, 101)
    y = exp(-0.1*x)*cos(x)
    plot(x, y)
    xlabel('x'); ylabel('y')
    show()

Then Cython (with -h option so it is hidden in html/sphinx):

.. container:: toggle

    .. container:: header

        **Show/Hide Code**

    .. code-block:: cython

        cpdef f(double x):
            return x + 1

Standard Python shell sessions:

.. code-block:: python

    >>> from numpy import linspace, sin
    >>> # Some comment
    >>> x = linspace(0, 2, 11)
    >>> y = sin(x)
    >>> y[0]
    0
    >>> import matplotlib.pyplot as plt
    >>> plt.plot(x, y)

Similar IPython sessions:

.. code-block:: ipy

    In [1]: from numpy import linspace, sin
    In [2]: # Some comment
    In [3]: x = linspace(0, 2, 11)
    In [4]: y = sin(x)
    In [5]: y[0]
    Out[5]: 0
    In [6]: import matplotlib.pyplot as plt
    In [7]: plt.plot(x, y)
    In [8]: a='multiple-\nline\noutput'
    In [9]: a
    Out[9]: 'multiple-\nline\noutput'
    In [10]: print(a)
    multiple-
    line
    output

Here is the interactive session again, but with ``pyshell-t``.

.. code-block:: python

    >>> from numpy import linspace, sin
    >>> # Some comment
    >>> x = linspace(0, 2, 11)
    >>> y = sin(x)
    >>> y[0]
    0
    >>> import matplotlib.pyplot as plt
    >>> plt.plot(x, y)

.. This one tests a + sign before a code environment

C++:

.. code-block:: c++

    #include <iostream>
    
    int main()
    {
       std::cout << "Sample output" << std::endl;
       return 0
    }

.. The next should get correctly typset in sphinx (cod is fcod)

.. It also tests emoji before code

And a little bit of Fortran: :dizzy_face:

.. code-block:: text

    !bc cod
          subroutine midpt(x, length, a, b)
          real*8 a, b, x
          x = (a + b)/2
          length = b - a
          return
          end
    !ec

which then is typeset as

.. code-block:: fortran

          subroutine midpt(x, length, a, b)
          real*8 a, b, x
          x = (a + b)/2
          length = b - a
          return
          end

HTML:

.. code-block:: html

    <table>
    <tr><td>Column 1</td><td>Column 2</td></tr>
    <tr><td>0.67526 </td><td>0.92871 </td></tr>
    <!-- comment -->
    </table>

But inline HTML code is also important, like text that starts with
``<a href="`` (which can destroy the following text if not properly
quoted).

Matlab with comments requires special typesetting:

.. code-block:: matlab

    % Comment on the beginning of the line can be escaped by %%
    if a > b
      % Indented comment needs this trick
      c = a + b
    end

And here is a system call:

.. code-block:: console

    Terminal> mkdir test
    Terminal> cd test
    Terminal> myprog -f
    output1
    output2

Any valid pygments lexer/language name can appear to, e.g.,

.. code-block:: text

    !bc restructuredtext
    =======
    Heading
    =======
    
    Some text.
    !ec

results in

.. code-block:: restructuredtext

    =======
    Heading
    =======
    
    Some text.

.. Here goes hidden code.

.. Python can be treated by some formats, Fortran is always out.

Finally, ``!bc do`` supports highlighting of DocOnce source:

.. code-block:: doconce

    ======= DocOnce test file =======
    
    ===== Computer code =====
    
    Inline verbatim code, as in `import numpy as np`, is allowed, as well as
    code blocks:
    
    !bc pycod
    from math import sin
    
    def f(x):
        """Example on a function."""
        return sin(x) + 1
    
    print(f(0))
    !ec
    
    
    ===== Mathematics =====
    
    Formulas can be inline, as in $\nabla\cdot\boldsymbol{u} = 0$, or typeset
    as equations:
    
    !bt
    \begin{align*}
    \nabla\cdot\boldsymbol{u} &= 0,\\ 
    \boldsymbol{u} &= \nabla\phi .
    \end{align*}
    !et
    
    === Subsubsection heading ===
    
    DocOnce files can have chapters, sections, subsections, and subsubsections.
    
    __Paragraph heading.__ Paragraphs may have headings.

It is time to test ``verbatim inline font`` especially with ``a newline
inside the text`` and an exclamation mark at the end: ``BEGIN``! For
spellcheck, test ``a verbatim expression`` in ``another`` in a ``third``.
Also test exclamation mark as in ``!bc`` and ``!ec`` as well as ``a != b``.
Also test backslashes and braces like ``\begin``, ``\begin{enumerate}``,
``\end{this}\end{that}``, and ``{something \inside braces}``.

The following attempt to exemplify colored text does not work in
format sphinx.
Here is some **red color** and an attempt to write **with
green color containing a linebreak

| code.** Some formats will only display 
| this correctly when ``html`` 
| is the output format.

But here some more running text is added which is not part of
the previous blocks with line breaks.

Running OS commands
~~~~~~~~~~~~~~~~~~~

.. code-block:: console

    Terminal> python -c 'print("Testing\noutput\nfrom\nPython.")'
    Testing
    output
    from
    Python.

Footnotes
~~~~~~~~~

Here is a test of footnotes [#footnote]_, which are handy in text.
They are used in different flavors, now in

 * list items (note below that footnotes work after math, verbatim, and URLs - bin fact old and emphasize too!)

 * even with math :math:`\nabla^2u` [#math1]_

 * and code ``h[i] += 1`` [#code]_
   (*must* have space between inline code and footnote!)

 * and `links <https://google.com>`__ [#google-search]_

which gives flexibility in writing.
This is the third [#example-of-the-third-footnote]_ example.

.. [#footnote] Typesetting of the footnote depends on the format.
   Plain text does nothing, LaTeX removes the
   definition and inserts the footnote as part of the LaTeX text.
   reStructuredText and Sphinx employ a similar type of typesetting
   as Extended Markdown and DocOnce, and in HTML we keep the same
   syntax, just displayed properly in HTML.

.. [#math1] Math footnotes can be dangerous since it
   interferes with an exponent.

.. [#code] One-line footnote.

.. [#google-search] `<google.com>`_ is perhaps the most famous
   web site today.

Here is some more text before a new definition of a footnote that was
used above.


.. admonition:: Non-breaking space character

   This paragraph aims to test `non-breaking space character <https://en.wikipedia.org/wiki/Non-breaking_space>`__, and a typical
   example where this is needed is in physical units: 7.4 |nbsp| km is traveled
   in |nbsp| :math:`7.4/5.5\approx 1.345` |nbsp| s.  Also check that a |nbsp| `link <https://google.com>`__ |nbsp| is
   not broken across lines (drag the browser window to test this).
   (On the other hand, the tilde is used in
   computer code, e.g., as in ``[~x for x in y]`` or in ``y=~x``, and should
   of course remain a tilde in those contexts.)




.. _subsec:ex:

Subsection 2: Testing figures
-----------------------------

.. index:: figures

Test of figures. In particular we refer to Figure :ref:`fig:impact` in which
there is a flow.

.. _fig:impact:

.. figure:: ../doc/src/manual/fig/wave1D.png
   :width: 200

   Visualization **of** a *wave*

Figures without captions are allowed and will be inlined.

.. figure:: ../doc/src/manual/fig/wave1D.png
   :width: 200

.. index:: movies

.. Test multi-line caption in figure with sidecap=True

Here is figure :ref:`myfig` with a long (illegal) multi-line caption
containing inline verbatim text:

.. _myfig:

.. figure:: ../doc/src/manual/fig/wave1D.png
   :width: 500

   A long caption spanning several lines and containing verbatim words like ``my_file_v1`` and ``my_file_v2`` as well as math with subscript as in :math:`t_{i+1}`

.. Must be a blank line after MOVIE or FIGURE to detect this problem

Test URL as figure name:

.. figure:: https://raw.github.com/doconce/doconce/master/doc/src/blog/f_plot.png
   :width: 500

Test SVG figure:

.. figure:: https://openclipart.org/people/jpneok/junebug.svg
   :width: 200

.. Test wikimedia type of files that otherwise reside in subdirs

**Remark.**
Movies are tested in separate file ``movies.do.txt``.

.. Somewhat challenging heading with latex math, \t, \n, ? and parenthesis

.. _decay:sec:theta:

The :math:`\theta` parameter (not :math:`\nabla`?)
--------------------------------------------------

Functions do not always need to be advanced, here is one
involving :math:`\theta`:

.. code-block:: text

    def f(theta):
        return theta**2

**More on :math:`\theta`.**
Here is more text following headline with math.

Newcommands must also be tested in this test report:
:math:`\frac{1}{2}`, :math:`{1/2}`, :math:`\pmb{x}`, :math:`\frac{Du}{dt}`,
both inline and in block:

.. math::
        
        \frac{Du}{dt} = 0\nonumber
        

.. math::
   :label: _auto1

          
        \frac{1}{2} = {1/2}
        
        

.. math::
   :label: _auto2

          
        \frac{1}{2}\pmb{x} = \pmb{n}
        
        

Or with align with label and numbers:

.. math::
   :label: aligneq1

        
        \frac{Du}{dt} = 0
        
        

.. math::
   :label: _auto3

          
        \frac{1}{2} = {1/2}
        
        

.. math::
   :label: aligneq2

          
        \frac{1}{2}\pmb{x} = \pmb{n}
        
        

Sphinx makes a fix here and splits align into multiple equation
environments.

Custom Environments
-------------------

Here is an attempt to create a theorem environment via Mako
(for counting theorems) and comment lines to help replacing lines in
the ``.tex`` by proper begin-end LaTeX environments for theorems.
Should look nice in most formats!

.. begin theorem

**Theorem 5.**
Let :math:`a=1` and :math:`b=2`. Then :math:`c=3`.

.. end theorem

.. begin proof

**Proof.**
Since :math:`c=a+b`, the result follows from straightforward addition.
:math:`\Diamond`

.. end proof

As we see, the proof of Theorem 5 is a modest
achievement.

.. _subsec:table:

Tables
------

.. index:: test index with verbatim text which is possible

.. index:: test two (separate) verbatim expressions which is also possible

.. index::
   single: index with; subindex

.. index:: boldface word in index

.. index:: index with boldface word

.. index::
   single: index with; boldface word in subentry

.. index::
   single: double boldface word;  boldface word in subentry too

.. index with comma could fool sphinx

.. index::
   single: index, with comma, and one more

Let us take this table from the manual:

====  ========  ============  
time  velocity  acceleration  
====  ========  ============  
0.0     1.4186         -5.01  
2.0   1.376512        11.919  
4.0     1.1E+1     14.717624  
====  ========  ============  

The DocOnce source code reads

.. code-block:: text

      |--------------------------------|
      |time  | velocity | acceleration |
      |--l--------r-----------r--------|
      | 0.0  | 1.4186   | -5.01        |
      | 2.0  | 1.376512 | 11.919       |
      | 4.0  | 1.1E+1   | 14.717624    |
      |--------------------------------|
    

Here is yet another table to test that we can handle more than
one table:

====  ========  ============  
time  velocity  acceleration  
====  ========  ============  
0.0   1.4186    -5.01         
1.0   1.376512  11.919        
3.0   1.1E+1    14.717624     
====  ========  ============  

And one with math headings (that are expanded and must be treated
accordingly), verbatim heading and entry, and no space around the pipe
symbol:

=========  ===========  ================  =======  
:math:`i`  :math:`h_i`  :math:`\bar T_i`  ``L_i``  
=========  ===========  ================  =======  
0                    0               288  -0.0065  
1               11,000               216      0.0  
2               20,000               216    0.001  
3               32,000               228   0.0028  
4               47,000               270      0.0  
5               51,000               270  -0.0028  
6               71,000               214  ``NaN``  
=========  ===========  ================  =======  

And add one with verbatim headings (with underscores),
and rows starting with ``|-`` because of a negative number,
and ``|`` right before and after verbatim word (with no space):

=====  =======  =====================  ===========  
exact  ``v_1``  :math:`a_i` + ``v_2``  ``verb_3_``  
=====  =======  =====================  ===========  
    9     9.62                   5.57         8.98  
  -20   -23.39                  -7.65       -19.93  
   10    17.74                  -4.50         9.96  
    0    -9.19                   4.13        -0.26  
=====  =======  =====================  ===========  

Pipe symbols in verbatim and math text in tables used to pose difficulties,
but not
anymore:

===============  ===============  
   :math:`S`         command      
===============  ===============  
$ ||a_0|| $      ``norm|length``  
:math:`x\cap y`          ``x|y``  
===============  ===============  

Here is a table with X alignment:

=====  ==========================================================================================================================================================================================================================  
 Type                                                                                                         Description                                                                                                          
=====  ==========================================================================================================================================================================================================================  
  X    Alignment character that is used for specifying a potentially very long text in a column in a table. It makes use of the ``tabularx`` package in LaTeX, otherwise (for other formats) it means ``l`` (centered alignment).  
l,r,c  standard alignment characters                                                                                                                                                                                               
=====  ==========================================================================================================================================================================================================================  

Finally, a table with math
(``bm`` that expands to ``boldsymbol``, was tricky, but
cleanly handled now)
and URLs.

.. Mako code to expand URLs in the table

.. (These types of tables did not work before Jan 2014)

====================================  ==========================================================  ==========================================================  
                                                                                                                                                              
====================================  ==========================================================  ==========================================================  
       :math:`\mathcal{L}=0`          `080 <../doc/src/manual/mov/wave_frames/frame_0080.png>`__  `085 <../doc/src/manual/mov/wave_frames/frame_0085.png>`__  
            :math:`a=b`               `090 <../doc/src/manual/mov/wave_frames/frame_0090.png>`__  `095 <../doc/src/manual/mov/wave_frames/frame_0095.png>`__  
:math:`\nabla\cdot\boldsymbol{u} =0`  `100 <../doc/src/manual/mov/wave_frames/frame_0100.png>`__  `105 <../doc/src/manual/mov/wave_frames/frame_0105.png>`__  
====================================  ==========================================================  ==========================================================  

A test of verbatim words in heading with subscript :math:`a_i`: ``my_file_v1`` and ``my_file_v2``
-------------------------------------------------------------------------------------------------

**Paragraph with verbatim and math: ``my_file_v1.py`` and ``my_file_v2.py`` define some math :math:`a_{i-1}`.**
Here is more ``__verbatim__`` code and
some plain text on a new line.

.. Test various types of headlines

**Just bold**
-------------

Some text.

*Just emphasize*
----------------

Some text.

``Just verbatim``
-----------------

Some text.

**Bold** beginning
------------------

Some text.

*Emphasize* beginning
---------------------

Some text.

``Verbatim`` beginning
----------------------

Some text.

Maybe **bold end**
------------------

Some text.

Maybe *emphasize end*
---------------------

Some text.

Maybe ``verbatim end``
----------------------

Some text.

The middle has **bold** word
----------------------------

Some text.

The middle has *emphasize* word
-------------------------------

Some text.

The middle has ``verbatim`` word
--------------------------------

Some text.

***Just emphasize*.**
Some text.

**``Just verbatim``.**
Some text.

***Emphasize* beginning.**
Some text.

**``Verbatim beginning``.**
Some text.

**Maybe *emphasize end*.**
Some text.

**Maybe ``verbatim end``.**
Some text.

**The middle has *emphasize* word.**
Some text.

**The middle has ``verbatim`` word.**
Some text.

**Ampersand.**
We can test Hennes & Mauritz, often abbreviated H&M, but written
as ``Hennes & Mauritz`` and ``H & M``.
A sole ``&`` must also work.

.. Note: substitutions must not occur inside verbatim, just in ordinary text.

.. code-block:: text

    # Just to check that ampersand works in code blocks:
    c = a & b

**Quotes.**
Let us also add a test of quotes such as "double quotes, with numbers
like 3.14 and newline/comma and hyphen (as in double-quote)"; written
in the standard LaTeX-style that gives correct LaTeX formatting and
ordinary double quotes for all non-LaTeX formats.  Here is another
sentence that "caused" a bug in the past because double backtick
quotes could imply verbatim text up to a verbatim word starting with
period, like ``.txt``.

More quotes to be tested for spellcheck:
("with parenthesis"), "with newline"
and "with comma", "hyphen"-wise, and "period".

Bibliography test
-----------------

Here is an example: [Ref01]_ discussed propagation of
large destructive water waves, [Ref02]_ gave
an overview of numerical methods for solving the Navier - Stokes equations,
while the use of Backward Kolmogorov equations for analyzing
random vibrations was investigated in [Ref03]_.
The book chapter [Ref04]_ contains information on
C++ software tools for programming multigrid methods. A real retro
reference is [Ref05]_ about a big FORTRAN package.
Multiple references are also possible, e.g., see
[Ref01]_ [Ref04]_.

We need to cite more than 10 papers to reproduce an old formatting
problem with blanks in the keys in reST format:
[Ref06]_ [Ref03]_ [Ref07]_ [Ref01]_
and
[Ref02]_ [Ref08]_ [Ref09]_ [Ref10]_ [Ref11]_ [Ref12]_ [Ref13]_
and all the work of
[Ref14]_ [Ref04]_ [Ref15]_ as well as
old work [Ref05]_ and [Ref16]_, and the
talk [Ref17]_.
Langtangen also had two thesis [Ref18]_ [Ref16]_
back in the days.
More retro citations are
the old ME-IN323 book [Ref19]_ and the
[Ref20]_ OONSKI '94 paper.

.. --- begin exercise ---

.. _Example:

Example 1: Examples can be typeset as exercises
-----------------------------------------------

Examples can start with a subsection heading starting with ``Example:``
and then, with the command-line option ``--examples_as_exercises`` be
typeset as exercises. This is useful if one has solution
environments as part of the example.

**a)**
State some problem.

**Solution.**
The answer to this subproblem can be written here.

**b)**
State some other problem.

**Hint 1.**
A hint can be given.

**Hint 2.**
Maybe even another hint?

**Solution.**
The answer to this other subproblem goes here,
maybe over multiple doconce input lines.

.. --- end exercise ---

User-defined environments
-------------------------

The example in the section :ref:`ex:test:1p1` demonstrates how to write a test function.
That is, a special test function for a function ``add`` appears in
the example in the section :ref:`ex:test:1p1`.

.. _ex:test:1p1:

Example 1: A test function
--------------------------

Suppose we want to write a test function for checking the
implementation of a Python function for addition.

.. code-block:: python

    def add(a, b):
        return a + b
    
    def test_add():
        a = 1; b = 1
        expected = a + b
        computed = add(a, b)
        assert expected == computed

.. _ex:math:1p1:

Example 2: Addition
-------------------

We have

.. math::
         1 + 1 = 2 

or in tabular form:

===========  =========  
  Problem      Result   
===========  =========  
:math:`1+1`  :math:`2`  
===========  =========  


.. admonition:: Highlight box

   This environment is used to highlight something:
   
   .. math::
            E = mc^2




.. _subsubsec:ex:

URLs
----

Testing of URLs: hpl's home page `hpl <https://folk.uio.no/hpl>`__, or
the entire URL if desired, `<https://folk.uio.no/hpl>`_.  Here is a
plain file link `<testdoc.do.txt>`_, or `<testdoc.do.txt>`_, or
`<testdoc.do.txt>`_ or `<testdoc.do.txt>`_ or `a link with
newline <testdoc.do.txt>`__. Can test spaces with the link with word
too: `hpl <https://folk.uio.no/hpl>`__ or `hpl <https://folk.uio.no/hpl>`__. Also ``file:///`` works: `link to a
file <file:///home/hpl/vc/doconce/doc/demos/manual/manual.html>`__ is
fine to have. Moreover, "loose" URLs work, i.e., no quotes, just
the plain URL as in `<https://folk.uio.no/hpl>`_, if followed by space, comma,
colon, semi-colon, question mark, exclamation mark, but not a period
(which gets confused with the periods inside the URL).

Mail addresses can also be used: `hpl@simula.no <mailto:hpl@simula.no>`__, or just a `mail link <mailto:hpl@simula.no>`__, or a raw `<mailto:hpl@simula.no>`_.

Here are some tough tests of URLs, especially for the ``latex`` format:
`Newton-Cotes <https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas>`__ formulas
and a `good book <https://www.springer.com/mathematics/computational+science+%26+engineering/book/978-3-642-23098-1>`__. Need to test
Newton-Cotes with percentage in URL too:
`<https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas>`_
and `<https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae>`_ which has a shebang.

For the ``--device=paper`` option it is important to test that URLs with
monospace font link text get a footnote
(unless the ``--latex_no_program_footnotelink``
is used), as in this reference to
`decay_mod <https://github.com/hplgit/INF5620/tree/gh-pages/src/decay/experiments/decay_mod.py>`__, `ball1.py <https://tinyurl.com/pwyasaa/formulas.ball1.py>`__,
and `ball2.py <https://tinyurl.com/pwyasaa/formulas.ball2.py>`__.

.. Comments should be inserted outside paragraphs (because in the rst

.. format extra blanks make a paragraph break).

.. Note that when there is no https: or file:, it can be a file link

.. if the link name is URL, url, "URL", or "url". Such files should,

.. if rst output is desired, but placed in a ``_static*`` folder.

More tough tests: repeated URLs whose footnotes when using the
``--device=paper`` option must be correct. We have
`google <https://google.com>`__, `google <https://google.com>`__, and
`google <https://google.com>`__, which should result in exactly three
footnotes.

.. !split and check if these extra words are included properly in the comment

.. !split

LaTeX Mathematics
=================

Here is an equation without label using backslash-bracket environment:

.. math::
         a = b + c 

or with number and label, as in :eq:`my:eq1`, using the equation environment:

.. math::
   :label: my:eq1

        
        {\partial u\over\partial t} = \nabla^2 u 
        

We can refer to this equation by :eq:`my:eq1`.

Here is a system without equation numbers, using the align-asterisk environment:

.. math::
        \begin{align*}
        \pmb{a} &= \pmb{q}\times\pmb{n} \\ 
        b &= \nabla^2 u + \nabla^4 v
        \end{align*}

And here is a system of equations with labels in an align environment:

.. math::
   :label: eq1

        
        a = q + 4 + 5+ 6  
        

.. math::
   :label: eq2

          
        b = \nabla^2 u + \nabla^4 x 
        
        

We can refer to :eq:`eq1`-:eq:`eq2`. They are a bit simpler than
the Navier - Stokes equations. And test LaTeX hyphen in ``CG-2``.
Also test :math:`a_{i-j}` as well as :math:`kx-wt`.

Testing ``alignat`` environment:

.. math::
   :label: eq1a

        
        a = q + 4 + 5+ 6\qquad  \mbox{for } q\geq 0  
        

.. math::
   :label: eq2a

          
        b = \nabla^2 u + \nabla^4 x  x\in\Omega 
        

More mathematical typesetting is demonstrated in the coming exercises.

Below, we have :ref:`demo:ex:1` and :ref:`demo:ex:2`,
as well as :ref:`proj:circle1` and :ref:`exer:you`, and in
between there we have :ref:`exer:some:formula`.

.. !split

Exercises
=========

.. --- begin exercise ---

.. _demo:ex:1:

Problem 2: Flip a Coin
----------------------

.. keywords = random numbers; Monte Carlo simulation; ipynb

.. Torture tests

**a)**
Make a program that simulates flipping a coin :math:`N` times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

.. --- begin hint in exercise ---

**Hint 1.**
Use ``r = random.random()`` and define head as ``r <= 0.5``.

.. --- end hint in exercise ---

.. --- begin hint in exercise ---

**Hint 2.**
Draw an integer among :math:`\{1,2\}` with
``r = random.randint(1,2)`` and define head when ``r`` is 1.

.. --- end hint in exercise ---

.. --- begin answer of exercise ---

**Answer.**
If the ``random.random()`` function returns a number :math:`<1/2`, let it be
head, otherwise tail. Repeat this :math:`N` number of times.

.. --- end answer of exercise ---

.. --- begin solution of exercise ---

**Solution.**

.. code-block:: python

    import sys, random
    N = int(sys.argv[1])
    heads = 0
    for i in range(N):
        r = random.random()
        if r <= 0.5:
            heads += 1
    print('Flipping a coin %d times gave %d heads' % (N, heads))

.. --- end solution of exercise ---

**b)**
Vectorize the code in a) using boolean indexing.

Vectorized code can be written in many ways.
Sometimes the code is less intuitive, sometimes not.
At least there is not much to find in the section :ref:`sec1`.

**c)**
Vectorize the code in a) using ``numpy.sum``.

.. --- begin answer of exercise ---

**Answer.**
``np.sum(np.where(r <= 0.5, 1, 0))`` or ``np.sum(r <= 0.5)``.

.. --- end answer of exercise ---

In this latter subexercise, we have an
example where the code is easy to read.

My remarks
~~~~~~~~~~

Remarks with such a subsubsection is treated as more text
after the last subexercise. Test a list too:

1. Mark 1.

2. Mark 2.

Filenames: ``flip_coin.py``, ``flip_coin.pdf``.

.. Closing remarks for this Problem

Remarks          (1)
~~~~~~~~~~~~~~~~~~~~

These are the exercise remarks, appearing at the very end.

.. solution files: mysol.txt, mysol_flip_coin.py, yet_another.file

.. --- end exercise ---

Not an exercise
---------------

Should be possible to stick a normal section in the middle of many
exercises.

.. --- begin exercise ---

.. _my:exer1:

Exercise 3: Test of plain text exercise
---------------------------------------

Very short exercise. What is the capital
of Norway?
Filename: ``myexer1``.

.. --- end exercise ---

.. --- begin exercise ---

.. _demo:ex:2:

Project 4: Compute a Probability
--------------------------------

.. Minimalistic exercise

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval :math:`[0,1)`?

At the end we have a list because that caused problems in LaTeX
in previous DocOnce versions:

1. item1

2. item2

.. --- begin hint in exercise ---

**Hint.**
To answer this question empirically, let a program
draw :math:`N` such random numbers using Python's standard ``random`` module,
count how many of them, :math:`M`, that fall in the interval :math:`(0.5,0.6)`, and
compute the probability as :math:`M/N`.

.. --- end hint in exercise ---

.. --- end exercise ---

.. --- begin exercise ---

.. _proj:circle1:

Project 5: Explore Distributions of Random Circles
--------------------------------------------------

.. keywords = ipynb

The formula for a circle is given by

.. math::
   :label: circle:x

        
        x = x_0 + R\cos 2\pi t,
        
        

.. math::
   :label: circle:y

          
        y = y_0 + R\sin 2\pi t,
        
        

where :math:`R` is the radius of the circle, :math:`(x_0,y_0)` is the
center point, and :math:`t` is a parameter in the unit interval :math:`[0,1]`.
For any :math:`t`, :math:`(x,y)` computed from :eq:`circle:x`-:eq:`circle:y`
is a point on the circle.
The formula can be used to generate ``n`` points on a circle:

.. code-block:: python

    import numpy as np
    
    def circle(R, x0, y0, n=501):
        t = np.linspace(0, 1, n)
        x = x0 + R*np.cos(2*np.pi*t)
        y = y0 + R*np.sin(2*np.pi*t)
        return x, y
    
    x, y = circle(2.0, 0, 0)

.. Often in an exercise we have some comments about the solution

.. which we normally want to keep where they are.

The goal of this project is to draw :math:`N` circles with random
center and radius. Plot each circle using the ``circle`` function
above.

**a)**
Let :math:`R` be normally distributed and :math:`(x_0,y_0)` uniformly distributed.

.. --- begin hint in exercise ---

**Hint.**
Use the ``numpy.random`` module to draw the
:math:`x_0`, :math:`y_0`, and :math:`R` quantities.

.. --- end hint in exercise ---

.. --- begin answer of exercise ---

**Answer.**
Here goes the short answer to part a).

.. --- end answer of exercise ---

.. --- begin solution of exercise ---

**Solution.**
Here goes a full solution to part a).

.. --- end solution of exercise ---

**b)**
Let :math:`R` be uniformly distributed and :math:`(x_0,y_0)` normally distributed.
Filename: ``norm``.

**c)**
Let :math:`R` and :math:`(x_0,y_0)` be normally distributed.

Filename: ``circles``.

.. Closing remarks for this Project

Remarks          (2)
~~~~~~~~~~~~~~~~~~~~

At the very end of the exercise it may be appropriate to summarize
and give some perspectives.

.. --- end exercise ---

.. --- begin exercise ---

.. _exer:dist:

Exercise 6: Determine some Distance
-----------------------------------

Intro to this exercise. Questions are in subexercises below.

.. --- begin solution of exercise ---

**Solution.**
Here goes a full solution of the whole exercise.
With some math :math:`a=b` in this solution:

.. math::
         \hbox{math in solution: } a = b 

And code ``a=b`` in this solution:

.. code-block:: text

    a = b  # code in solution

End of solution is here.

.. --- end solution of exercise ---

**a)**
Subexercises are numbered a), b), etc.

.. --- begin hint in exercise ---

**Hint 1.**
First hint to subexercise a).
With math :math:`a=b` in hint:

.. math::
         a=b. 

And with code (in plain verbatim) returning :math:`x+1` in hint:

.. code-block:: text

    def func(x):
        return x + 1  # with code in hint

.. --- end hint in exercise ---

.. --- begin hint in exercise ---

**Hint 2.**
Second hint to subexercise a).

Test list in hint:

1. item1

2. item2

.. --- end hint in exercise ---

Filename: ``subexer_a.pdf``.

.. --- begin answer of exercise ---

**Answer.**
Short answer to subexercise a).
With math in answer: :math:`a=b`.

.. --- end answer of exercise ---

**b)**
Here goes the text for subexercise b).

Some math :math:`\cos^2 x + \sin^2 x = 1` written one a single line:

.. math::
         \cos^2 x + \sin^2 x = 1 \thinspace .

.. --- begin hint in exercise ---

**Hint.**
A hint for this subexercise.

.. --- end hint in exercise ---

Filename: ``subexer_b.pdf``.

.. --- begin solution of exercise ---

**Solution.**
Here goes the solution of this subexercise.

.. --- end solution of exercise ---

.. No meaning in this weired test example:

The text here belongs to the main (intro) part of the exercise. Need
closing remarks to have text after subexercises.

Test list in exercise:

1. item1

2. item2

.. Closing remarks for this Exercise

Remarks          (3)
~~~~~~~~~~~~~~~~~~~~

Some final closing remarks, e.g., summarizing the main findings
and their implications in other problems can be made. These
remarks will appear at the end of the typeset exercise.

.. --- end exercise ---

.. --- begin exercise ---

Some exercise without the "Exercise:" prefix
--------------------------------------------

.. Another minimalistic exercise

Just some text. And some math saying that :math:`e^0=1` on a single line,
to test that math block insertion is correct:

.. math::
         \exp{(0)} = 1 

And a test that the code ``lambda x: x+2`` is correctly placed here:

.. code-block:: text

    lambda x: x+2

.. Have some comments at the end of the exercise to see that

.. the Filename: ... is written correctly.

.. --- end exercise ---

.. --- begin exercise ---

.. _sec:this:exer:de:

Exercise 8: Solution of differential equation
---------------------------------------------



.. begin quiz

Given

.. math::
         \frac{dy}{dx} = -y(x),\quad y(0)=1 

What is the solution of this equation?


**Choice A:** :math:`y=e^{-y}`

:abbr:`? (Right!)`

**Choice B:** :math:`y=e^{y}`

:abbr:`? (Wrong!)` :abbr:`# (Almost, but the sign is wrong (note the minus!).)`

**Choice C:** .. code-block:: python

    from math import exp
    def f(x):
        return exp(x)

:abbr:`? (Wrong!)`

**Choice D:** The solution cannot be found because there is a derivative in the equation.

:abbr:`? (Wrong!)` :abbr:`# (Equations with derivatives can be solved; they are termed *differential equations*.)`

**Choice E:** The equation is meaningless: an equation must be an equation
for :math:`x` or :math:`y`, not a function :math:`y(x)`.

:abbr:`? (Wrong!)` :abbr:`# (Equations where the unknown is a function, as y(x) here, are called *differential equations*, and are solved by special techniques.)`

.. end quiz



.. --- end exercise ---

.. --- begin exercise ---

Example 9: Just an example
--------------------------

.. This example needs the --examples_as_exercises option, otherwise

.. it is just typeset as it is written.

**a)**
What is the capital of Norway?

**Answer.**
Oslo.

.. --- end exercise ---

.. !split

Here goes another section
=========================

With some text, before we continue with exercises.

.. !split

More Exercises
==============

.. --- begin exercise ---

.. _exer:some:formula:

Exercise 10: Make references to projects and problems
-----------------------------------------------------

.. Test comments not at the end only

Pick a statement from :ref:`proj:circle1` or :ref:`demo:ex:1`
and verify it.

Test list at the end of an exercise without other elements (like subexercise,
hint, etc.):

1. item1

2. item2

Filename: ``verify_formula.py``.

.. --- end exercise ---

.. --- begin exercise ---

.. _exer:you:

Project 11: References in a headings do not work well in sphinx
---------------------------------------------------------------

Refer to the previous exercise as :ref:`exer:some:formula`,
the two before that as :ref:`demo:ex:2` and :ref:`proj:circle1`,
and this one as :ref:`exer:you`.
Filename: ``selc_composed.pdf``.

.. --- end exercise ---

.. !split

References
==========

.. [Ref01]
   **H. P. Langtangen and G. Pedersen**. Propagation of Large Destructive Waves,
   *International Journal of Applied Mechanics and Engineering*,
   7(1),
   pp. 187-204,
   2002.

.. [Ref02]
   **H. P. Langtangen, K.-A. Mardal and R. Winther**. Numerical Methods for Incompressible Viscous Flow,
   *Advances in Water Resources*,
   25,
   pp. 1125-1146,
   2002.

.. [Ref03]
   **H. P. Langtangen**. Numerical Solution of First Passage Problems in Random Vibrations,
   *SIAM Journal of Scientific and Statistical Computing*,
   15,
   pp. 997-996,
   1994.

.. [Ref04]
   **K.-A. Mardal, G. W. Zumbusch and H. P. Langtangen**. Software Tools for Multigrid Methods,
   Advanced Topics in Computational Partial Differential Equations -- Numerical Methods and Diffpack Programming,
   edited by **H. P. Langtangen and A. Tveito**,
   Springer,
   2003,
   Edited book,
   `\urlhttp://some.where.org <\urlhttp://some.where.org>`_.

.. [Ref05]
   **H. P. Langtangen**. The FEMDEQS Program System,
   *Department of Mathematics, University of Oslo*,
   `http://www.math.uio.no/old/days/hpl/femdeqs.pdf <http://www.math.uio.no/old/days/hpl/femdeqs.pdf>`_,
   1989.

.. [Ref06]
   **H. P. Langtangen**. Stochastic Breakthrough Time Analysis of an Enhanced Oil Recovery Process,
   *SIAM Journal on Scientific Computing*,
   13,
   pp. 1394-1417,
   1992.

.. [Ref07]
   **M. Mortensen, H. P. Langtangen and G. N. Wells**. A FEniCS-Based Programming Framework for Modeling Turbulent Flow by the Reynolds-Averaged Navier-Stokes Equations,
   *Advances in Water Resources*,
   34(9),
   `doi: 10.1016/j.advwatres.2011.02.013 <https://dx.doi.org/10.1016/j.advwatres.2011.02.013>`__,
   2011.

.. [Ref08]
   **S. Glimsdal, G. Pedersen, K. Atakan, C. B. Harbitz, H. P. Langtangen and F. L\ovholt**. Propagation of the Dec. |nbsp| 26, 2004 Indian Ocean Tsunami: Effects of Dispersion and Source Characteristics,
   *International Journal of Fluid Mechanics Research*,
   33(1),
   pp. 15-43,
   2006.

.. [Ref09]
   **S. Rahman, J. Gorman, C. H. W. Barnes, D. A. Williams and H. P. Langtangen**. Numerical Investigation of a Piezoelectric Surface Acoustic Wave Interaction With a One-Dimensional Channel,
   *Physical Review B: Condensed Matter and Materials Physics*,
   74,
   2006,
   035308.

.. [Ref10]
   **J. B. Haga, H. Osnes and H. P. Langtangen**. On the Causes of Pressure Oscillations in Low-Permeable and Low-Compressible Porous Media,
   *International Journal of Analytical and Numerical Methods in Geomechanics*,
   `doi: 10.1002/nag.1062 <https://dx.doi.org/10.1002/nag.1062>`__,
   2011,
   `http://onlinelibrary.wiley.com/doi/10.1002/nag.1062/abstract <http://onlinelibrary.wiley.com/doi/10.1002/nag.1062/abstract>`_.

.. [Ref11]
   **H. P. Langtangen**. *Computational Partial Differential Equations - Numerical Methods and Diffpack Programming*,
   second edition,
   *Texts in Computational Science and Engineering*,
   Springer,
   2003.

.. [Ref12]
   **H. P. Langtangen**. *Python Scripting for Computational Science*,
   third edition,
   *Texts in Computational Science and Engineering*,
   Springer,
   2008.

.. [Ref13]
   **H. P. Langtangen and G. Pedersen**. Finite Elements for the Boussinesq Wave Equations,
   Waves and Non-linear Processes in Hydrodynamics,
   edited by **J. Grue, B. Gjevik and J. E. Weber**,
   Kluwer Academic Publishers,
   pp. pp. 117-126,
   1995,
   `http://www.amazon.ca/Waves-Nonlinear-Processes-Hydrodynamics-John/dp/0792340310 <http://www.amazon.ca/Waves-Nonlinear-Processes-Hydrodynamics-John/dp/0792340310>`_.

.. [Ref14]
   **H. P. Langtangen**. *A Primer on Scientific Programming With Python*,
   third edition,
   *Texts in Computational Science and Engineering*,
   Springer,
   2012.

.. [Ref15]
   **P. V. Jeberg, H. P. Langtangen and C. B. Terp**. Optimization With Diffpack: Practical Example From Welding,
   *Simula Research Laboratory*,
   Internal report,
   2004.

.. [Ref16]
   **H. P. Langtangen**. Computational Methods for Two-Phase Flow in Oil Reservoirs,
   Ph.D. Thesis,
   Mechanics Division, Department of Mathematics, University of Oslo,
   1989,
   Dr. |nbsp| Scient. |nbsp| thesis..

.. [Ref17]
   **H. P. Langtangen**. Computational Modeling of Huge Tsunamis From Asteroid Impacts,
   Invited keynote lecture at the \emphInternational conference on Computational Science 2007 (ICCS'07), Beijing, China,
   2007.

.. [Ref18]
   **H. P. Langtangen**. Solution of the Navier-Stokes Equations With the Finite Element Method in Two and Three Dimensions,
   M.Sc. Thesis,
   Mechanics Division, Department of Mathematics, University of Oslo,
   1985,
   Cand.Scient. thesis.

.. [Ref19]
   **H. P. Langtangen and A. Tveito**. Numerical Methods in Continuum Mechanics,
   *Center for Industrial Research*,
   1991,
   Lecture notes for a course (ME-IN 324). 286 pages..

.. [Ref20]
   **H. P. Langtangen**. Diffpack: Software for Partial Differential Equations,
   Proceedings of the Second Annual Object-Oriented Numerics Conference (OON-SKI'94), Sunriver, Oregon, USA,
   edited by **A. Vermeulen**,
   1994.

.. !split

.. _app1:

Appendix: Just for testing; part I
==================================

This is the first appendix.

A subsection within an appendix
-------------------------------

Some text.

.. !split

.. _app2:

Appendix: Just for testing; part II
===================================

This is more stuff for an appendix.

Appendix: Testing identical titles          (1)
-----------------------------------------------

Without label.

.. _test:title:id1:

Appendix: Testing identical titles          (2)
-----------------------------------------------

With label.

.. _test:title:id2:

Appendix: Testing identical titles          (3)
-----------------------------------------------

What about inserting a quiz?



.. !split
Test of quizzes
---------------.. begin quiz



**Fundamental test:** What is the capital of Norway?


**Answer 1:** Stockholm

:abbr:`? (Wrong!)` :abbr:`# (Stockholm is the capital of Sweden.)`

**Answer 2:** London

:abbr:`? (Wrong!)`

**Answer 3:** Oslo

:abbr:`? (Right!)`

**Choice D:** Bergen

:abbr:`? (Wrong!)` :abbr:`# (Those from Bergen would claim so, but nobody else.)`

.. end quiz



Appendix: Testing identical titles          (4)
-----------------------------------------------

Without label.


.. admonition:: Tip

   Here is a tip or hint box, typeset as a notice box.




Need a lot of text to surround the summary box.
Version control systems allow you to record the history of files
and share files among several computers and collaborators in a
professional way. File changes on one computer are updated or
merged with changes on another computer. Especially when working
with programs or technical reports it is essential
to have changes documented and to
ensure that every computer and person involved in the project
have the latest updates of the files.
Greg Wilson' excellent `Script for Introduction to Version Control <https://software-carpentry.org/2010/07/script-for-introduction-to-version-control/>`__ provides a more detailed motivation why you will benefit greatly
from using version control systems.


.. admonition:: Summary

   **Bold remark:** Make some text with this summary.
   Much testing in this document, otherwise stupid content.
   Much testing in this document, otherwise stupid content.
   Much testing in this document, otherwise stupid content.
   Much testing in this document, otherwise stupid content.
   Much testing in this document, otherwise stupid content.
   Much testing in this document, otherwise stupid content.
   Much testing in this document, otherwise stupid content.
   Much testing in this document, otherwise stupid content.
   Much testing in this document, otherwise stupid content.




Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that site. I strongly
recommend you to use such sites for all serious programming and
scientific writing work - and all other important files.

The simplest services for hosting project files are `Dropbox <https://dropbox.com>`__ and `Google Drive <https://drive.google.com>`__.
It is very easy to get started with these systems, and they allow you
to share files among laptops and mobile units with as many users as
you want. The systems offer a kind of version control in that the
files are stored frequently (several times per minute), and you can go
back to previous versions for the last 30 days. However, it is
challenging  to find the right version from the past when there are
so many of them.

More seriously, when several people may edit files simultaneously, it
can be difficult detect who did what when, roll back to previous
versions, and to manually merge the edits when these are
incompatible. Then one needs more sophisticated tools than Dropbox or
Google Drive: project hosting services with true version control
systems.  The following text aims at providing you with the minimum
information to started with such systems. Numerous other tutorials
contain more comprehensive material and in-depth explanations of the
concepts and tools.

The idea with project hosting services is that you have the files
associated with a project in the cloud. Many people may share these
files.  Every time you want to work on the project you explicitly
update your version of the files, edit the files as you like, and
synchronize the files with the "master version" at the site where the
project is hosted.  If you at some point need to go back to a
version of the files at some particular point in the past,
this is an easy operation. You can also use tools to see
what various people have done with the files in the various versions.

All these services are very similar. Below we describe how you get
started with Bitbucket, GitHub, and Googlecode. Launchpad works very
similarly to the latter three. All the project hosting services have
excellent introductions available at their web sites, but the recipes
below are much shorter and aim at getting you started as quickly as
possible by concentrating on the most important need-to-know steps.
The Git tutorials we refer to later in this document contain more
detailed information and constitute of course very valuable readings
when you use version control systems every day. The point now is
to get started.

Appendix: Testing inline comments
---------------------------------

.. Names can be [ A-Za-z0-9_'+-]+

Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that
site. [**hpl's semi opinion 1**: not sure if in the cloud is understood by all.] I strongly recommend you to use such sites for all serious
programming and scientific writing work - and all other important
files.

The simplest services for hosting project files is Dropbox. [**mp 2**: Simply go to `<https://dropbox.com>`_ and watch the video. It explains how files, like ``myfile.py``, perhaps containing much math, like :math:`\partial u/\partial t`, are easily communicated between machines.] It
is very easy to get started with Dropbox, and it allows you to share
files among (**hpl 3: remove** laptops and mobile units) (**insert:**)computers, tablets, and phones (**end insert**).

.. Test horizontal rule

---------

.. Coments for editing

First, (**edit 4: add comma**) consider a quantity :math:`Q`. (**edit 5: remove** To this end,) (**insert:**)We note that (**end insert**)
:math:`Q>0`, because (**edit 6**: **delete** a) negative (**edit 7: remove** quantity is) (**insert:**)quantities are (**end insert**) (**edit 8**: **delete** just) negative.  (**edit 9: add**) This comes as no surprise. (**end add**)

.. Test tailored latex figure references with page number

Let us refer to Figure :ref:`fig:impact` again.

Test references in a list:

 * :ref:`sec1`

 * :ref:`subsec1`

 * :ref:`fig:impact`

Appendix: Testing headings ending with ``verbatim inline``
----------------------------------------------------------

The point here is to test 1) ``verbatim`` code in headings, and 2)
ending a heading with verbatim code as this triggers a special
case in LaTeX.

We also test mdash---used as alternative to hyphen without spaces around,
or in quotes:


..

    *Fun is fun*.---Unknown.



The ndash should also be tested - as in the Hanson - Nilson equations
on page 277 - 278.

And finally, what about admons, quotes, and boxes? They are tested
in a separate document: ``admon.do.txt``.

.. [#example-of-the-third-footnote] Not much to add here, but the footnote
   is at the end with only one newline.
************** File: testdoc.gwiki *****************
#summary A Document for Testing DocOnce

By *Hans Petter Langtangen* (hpl at simula.no), *Kaare Dump*, *A. Dummy Author*, *I. S. Overworked and Outburned*, and *J. Doe* (j_doe at cyberspace.com)
==== Jan 32, 2100 ====

Made with DocOnce



<wiki: toc max_depth="2" />

<wiki:comment> !split </wiki:comment>

The format of this document is
gwiki

*Abstract.* This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.

<wiki:comment> Cannot demonstrate chapter headings since abstract and chapter </wiki:comment>
<wiki:comment> are mutually exclusive in LaTeX </wiki:comment>

== Section 1 ==

Here is a nested list:


  * item1
  * item2
  * item3 which continues    on the next line to test that feature
  * and a sublist

    * with indented subitem1
    * and a subitem2


  * and perhaps an ordered sublist

   # first item
   # second item,      continuing on a new line



*Here is a list with paragraph heading.*


  * item1
  * item2

==== Here is a list with subsubsection heading ====

  * item1
  * item2





Here are two references. Equation (my:eq1) is fine. Eq. (my:eq1) too.
Even Equation (my:eq1) without the tilde.

==== Subsection 1 ====

<wiki:comment> Refer to section/appendix etc. at the beginning of the line </wiki:comment>
<wiki:comment> and other special fix situations for HTML. </wiki:comment>

More text, with a reference back to
the section [#Section_1] and [#Subsection_1], and further to the
the sections [#Subsection_1] and [#URLs], which
encourages you to do the tasks in [#Problem_2:_Flip_a_Coin] and [#Exercise_10:_Make_references_to_projects_and_problems].
 [#Appendix:_Just_for_testing;_part_I] and [#Appendix:_Just_for_testing;_part_II] are also nice elements.

==== Test Section reference at beginning of line and after a sentence ====

The section [#Subsection_1] is fine.
The section [#URLs] too.

<wiki:comment> sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console </wiki:comment>

==== Computer code ====

Let's do some copying from files too. First from subroutine up to the very end,

{{{
      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
}}}
and then just the subroutine,
{{{

      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
}}}
and finally the complete file with a plain text verbatim environment
(`envir=ccq`):
{{{
C     a comment

      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
}}}

Testing other code environments. First Python:

{{{
!bc pycod
def f(x):
    return x+1
!ec
}}}
which gets rendered as

{{{
def f(x):
    return x+1
}}}

Test paragraph and subsubsection headings before
before code.

*Paragraph heading before code.*

{{{
import sys
sys.path.insert(0, os.pardir)
}}}

==== Subsubsection heading before code ====

{{{
def h(z):
    return z+1
}}}

Here is a program that is supposed to be interactive via
Python Online Tutorial, but that service is not accessible
for the present format.

{{{
class Line:
    def __init__(self, a, b):
        self.a, self.b = a, b

    def __call__(self, x):
        a, b = self.a, self.b
        return a*x + b

line = Line(2, 1)
y = line(x=3)
print(y)
}}}

Some more Python code (actually specified as a sage cell, but
such cells are not supported by this format).

{{{
a = 2
b = 3
print('a+b:', a + b)

# In a sage cell we can also plot
from matplotlib.pyplot import *
from numpy import *
x = linspace(0, 4*pi, 101)
y = exp(-0.1*x)*cos(x)
plot(x, y)
xlabel('x'); ylabel('y')
show()
}}}

Then Cython (with -h option so it is hidden in html/sphinx):

{{{
cpdef f(double x):
    return x + 1
}}}

Standard Python shell sessions:

{{{
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
}}}

Similar IPython sessions:

{{{
In [1]: from numpy import linspace, sin
In [2]: # Some comment
In [3]: x = linspace(0, 2, 11)
In [4]: y = sin(x)
In [5]: y[0]
Out[5]: 0
In [6]: import matplotlib.pyplot as plt
In [7]: plt.plot(x, y)
In [8]: a='multiple-\nline\noutput'
In [9]: a
Out[9]: 'multiple-\nline\noutput'
In [10]: print(a)
multiple-
line
output
}}}

Here is the interactive session again, but with `pyshell-t`.

{{{
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
}}}

<wiki:comment> This one tests a + sign before a code environment </wiki:comment>
C++:
{{{
#include <iostream>

int main()
{
   std::cout << "Sample output" << std::endl;
   return 0
}
}}}
<wiki:comment> The next should get correctly typset in sphinx (cod is fcod) </wiki:comment>
<wiki:comment> It also tests emoji before code </wiki:comment>
And a little bit of Fortran: :dizzy_face:

{{{
!bc cod
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
!ec
}}}
which then is typeset as

{{{
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
}}}

HTML:

{{{
<table>
<tr><td>Column 1</td><td>Column 2</td></tr>
<tr><td>0.67526 </td><td>0.92871 </td></tr>
<!-- comment -->
</table>
}}}

But inline HTML code is also important, like text that starts with
`<a href="` (which can destroy the following text if not properly
quoted).

Matlab with comments requires special typesetting:

{{{
% Comment on the beginning of the line can be escaped by %%
if a > b
  % Indented comment needs this trick
  c = a + b
end
}}}

And here is a system call:

{{{
Terminal> mkdir test
Terminal> cd test
Terminal> myprog -f
output1
output2
}}}

Any valid pygments lexer/language name can appear to, e.g.,

{{{
!bc restructuredtext
=======
Heading
=======

Some text.
!ec
}}}
results in

{{{
=======
Heading
=======

Some text.
}}}

<wiki:comment> Here goes hidden code. </wiki:comment>
<wiki:comment> Python can be treated by some formats, Fortran is always out. </wiki:comment>





Finally, `!bc do` supports highlighting of DocOnce source:

{{{
======= DocOnce test file =======

===== Computer code =====

Inline verbatim code, as in `import numpy as np`, is allowed, as well as
code blocks:

!bc pycod
from math import sin

def f(x):
    """Example on a function."""
    return sin(x) + 1

print(f(0))
!ec


===== Mathematics =====

Formulas can be inline, as in $\nabla\cdot\bm{u} = 0$, or typeset
as equations:

!bt
\begin{align*}
\nabla\cdot\bm{u} &= 0,\\ 
\bm{u} &= \nabla\phi .
\end{align*}
!et

=== Subsubsection heading ===

DocOnce files can have chapters, sections, subsections, and subsubsections.

__Paragraph heading.__ Paragraphs may have headings.
}}}

It is time to test `verbatim inline font` especially with `a newline
inside the text` and an exclamation mark at the end: `BEGIN`! For
spellcheck, test `a verbatim expression` in `another` in a `third`.
Also test exclamation mark as in `!bc` and `!ec` as well as `a != b`.
Also test backslashes and braces like `\begin`, `\begin{enumerate}`,
`\end{this}\end{that}`, and `{something \inside braces}`.

The following attempt to exemplify colored text does not work in
format gwiki.
Here is some <font color="red">red color</font> and an attempt to write <font color="green">with
green color containing a linebreak

code.</font> Some formats will only display 

this correctly when `html` 

is the output format.
But here some more running text is added which is not part of
the previous blocks with line breaks.

==== Running OS commands ====

{{{
Terminal> python -c 'print("Testing\noutput\nfrom\nPython.")'
Testing
output
from
Python.
}}}

==== Footnotes ====

Here is a test of footnotes [^footnote], which are handy in text.
They are used in different flavors, now in


 * list items (note below that footnotes work after math, verbatim, and URLs - bin fact old and emphasize too!)
 * even with math `\nabla^2u`[^math1]
 * and code `h[i] += 1`[^code]   (*must* have space between inline code and footnote!)
 * and [https://google.com links][^google-search]

which gives flexibility in writing.
This is the third[^example-of-the-third-footnote] example.

  [^footnote]: Typesetting of the footnote depends on the format.
Plain text does nothing, LaTeX removes the
definition and inserts the footnote as part of the LaTeX text.
reStructuredText and Sphinx employ a similar type of typesetting
as Extended Markdown and DocOnce, and in HTML we keep the same
syntax, just displayed properly in HTML.
[^math1]: Math footnotes can be dangerous since it
interferes with an exponent.
[^code]: One-line footnote.

[^google-search]: google.com is perhaps the most famous
web site today.

Here is some more text before a new definition of a footnote that was
used above.

*Non-breaking space character.* 
This paragraph aims to test [https://en.wikipedia.org/wiki/Non-breaking_space non-breaking space character], and a typical
example where this is needed is in physical units: 7.4 km is traveled
in `7.4/5.5\approx 1.345` s.  Also check that a~[https://google.com link]~is
not broken across lines (drag the browser window to test this).
(On the other hand, the tilde is used in
computer code, e.g., as in `[~x for x in y]` or in `y=~x`, and should
of course remain a tilde in those contexts.)



==== Subsection 2: Testing figures ====

Test of figures. In particular we refer to Figure fig:impact in which
there is a flow.

---------------------------------------------------------------

Figure:  Visualization *of* a *wave*. (fig:impact)

(the URL of the image file ../doc/src/manual/fig/wave1D.png must be inserted here)

<wiki:comment>
Put the figure file ../doc/src/manual/fig/wave1D.png on the web (e.g., as part of the
googlecode repository) and substitute the line above with the URL.
</wiki:comment>
---------------------------------------------------------------

Figures without captions are allowed and will be inlined.

---------------------------------------------------------------

Figure: 

(the URL of the image file ../doc/src/manual/fig/wave1D.png must be inserted here)

<wiki:comment>
Put the figure file ../doc/src/manual/fig/wave1D.png on the web (e.g., as part of the
googlecode repository) and substitute the line above with the URL.
</wiki:comment>
---------------------------------------------------------------

<wiki:comment> Test multi-line caption in figure with sidecap=True </wiki:comment>

Here is figure myfig with a long (illegal) multi-line caption
containing inline verbatim text:

---------------------------------------------------------------

Figure:  A long caption spanning several lines and containing verbatim words like `my_file_v1` and `my_file_v2` as well as math with subscript as in `t_{i+1}`. (myfig) 

(the URL of the image file ../doc/src/manual/fig/wave1D.png must be inserted here)

<wiki:comment>
Put the figure file ../doc/src/manual/fig/wave1D.png on the web (e.g., as part of the
googlecode repository) and substitute the line above with the URL.
</wiki:comment>
---------------------------------------------------------------

<wiki:comment> Must be a blank line after MOVIE or FIGURE to detect this problem </wiki:comment>

Test URL as figure name:

---------------------------------------------------------------

Figure: 

(the URL of the image file https://raw.github.com/doconce/doconce/master/doc/src/blog/f_plot.png must be inserted here)

<wiki:comment>
Put the figure file https://raw.github.com/doconce/doconce/master/doc/src/blog/f_plot.png on the web (e.g., as part of the
googlecode repository) and substitute the line above with the URL.
</wiki:comment>
---------------------------------------------------------------

<wiki:comment> Test wikimedia type of files that otherwise reside in subdirs </wiki:comment>

*Remark.*
Movies are tested in separate file `movies.do.txt`.

<wiki:comment> Somewhat challenging heading with latex math, \t, \n, ? and parenthesis </wiki:comment>

==== The `\theta` parameter (not `\nabla`?) ====

Functions do not always need to be advanced, here is one
involving `\theta`:
{{{
def f(theta):
    return theta**2
}}}

*More on `\theta`.* Here is more text following headline with math.

Newcommands must also be tested in this test report:
`\frac{1}{2}`, `{1/2}`, `\pmb{x}`, `\frac{Du}{dt}`,
both inline and in block:

{{{
\begin{align}
\frac{Du}{dt} &= 0\nonumber
\\ 
\frac{1}{2} &= {1/2}\\ 
\frac{1}{2}\pmb{x} &= \pmb{n}
\end{align}
}}}

Or with align with label and numbers:

{{{
\begin{align}
\frac{Du}{dt} &= 0
label{aligneq1}
\\ 
\frac{1}{2} &= {1/2}\\ 
\frac{1}{2}\pmb{x} &= \pmb{n}
label{aligneq2}
\end{align}
}}}

<wiki:comment> Must test more complicated align and matrix compositions </wiki:comment>
<wiki:comment> where DocOnce inserts auto-numbered labels etc. </wiki:comment>

First one numbered (automatically):

{{{
\begin{align}
\begin{pmatrix}
G_2 + G_3 & -G_3 & -G_2 & 0 \\ 
-G_3 & G_3 + G_4 & 0 & -G_4 \\ 
-G_2 & 0 & G_1 + G_2 & 0 \\ 
0 & -G_4 & 0 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2 \\ 
 v_3 \\ 
 v_4
\end{pmatrix}
+ \cdots \\ 
\begin{pmatrix}
 C_5 + C_6 & -C_6 & 0 & 0 \\ 
 -C_6 & C_6 & 0 & 0 \\ 
 0 & 0 & 0 & 0 \\ 
 0 & 0 & 0 & 0
\end{pmatrix}
  &= \frac{d}{dt}\begin{pmatrix}
 v_1 \\ 
 v_2 \\ 
 v_3 \\ 
 v_4
\end{pmatrix} +
\begin{pmatrix}
 0 \\ 
 0 \\ 
 0 \\ 
 -i_0
\end{pmatrix}
\nonumber
\end{align}
}}}

Second numbered (automatically):

{{{
\begin{align}
\begin{pmatrix}
G_1 + G_2\\ 
-G_3 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2
\end{pmatrix}
+ \cdots\nonumber
\\ 
\left(\begin{array}{ll}
y & 2\\ 
2 & 1
\end{array}\right)
\left(\begin{array}{ll}
0 \\ x
\end{array}\right)
&= \begin{pmatrix}
A \\ B
\end{pmatrix}
\end{align}
}}}

Both numbered, with label by the user:

{{{
\begin{align}
\begin{pmatrix}
G_1 + G_2\\ 
-G_3 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2
\end{pmatrix}
+ \cdots label{mymatrix:eq1}
\\ 
label{mymatrix:eq2}
\left(\begin{array}{ll}
y & 2\\ 
2 & 1
\end{array}\right)
\left(\begin{array}{ll}
0 \\ x
\end{array}\right)
&= \begin{pmatrix}
A \\ B
\end{pmatrix}
\end{align}
}}}
Now we refer to Equations (mymatrix:eq1)-(mymatrix:eq2).

==== Custom Environments ====

Here is an attempt to create a theorem environment via Mako
(for counting theorems) and comment lines to help replacing lines in
the `.tex` by proper begin-end LaTeX environments for theorems.
Should look nice in most formats!

<wiki:comment> begin theorem </wiki:comment>

*Theorem 5.*
Let `a=1` and `b=2`. Then `c=3`.
<wiki:comment> end theorem </wiki:comment>

<wiki:comment> begin proof </wiki:comment>
*Proof.*
Since `c=a+b`, the result follows from straightforward addition.
`END`
<wiki:comment> end proof </wiki:comment>

As we see, the proof of Theorem 5 is a modest
achievement.

==== Tables ====

<wiki:comment> index with comma could fool sphinx </wiki:comment>

Let us take this table from the manual:


 ||  _time_   ||  _velocity_   ||  _acceleration_   ||
 ||  0.0      ||  1.4186       ||  -5.01            ||
 ||  2.0      ||  1.376512     ||  11.919           ||
 ||  4.0      ||  1.1E+1       ||  14.717624        ||


The DocOnce source code reads
{{{

  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

}}}

Here is yet another table to test that we can handle more than
one table:


 ||  _time_   ||  _velocity_   ||  _acceleration_   ||
 ||  0.0      ||  1.4186       ||  -5.01            ||
 ||  1.0      ||  1.376512     ||  11.919           ||
 ||  3.0      ||  1.1E+1       ||  14.717624        ||


And one with math headings (that are expanded and must be treated
accordingly), verbatim heading and entry, and no space around the pipe
symbol:


 ||  _`i`_   ||  _`h_i`_    ||  _`\bar T_i`_   ||   _`L_i`_    ||
 ||  0       ||  0          ||  288            ||  -0.0065     ||
 ||  1       ||  11,000     ||  216            ||  0.0         ||
 ||  2       ||  20,000     ||  216            ||  0.001       ||
 ||  3       ||  32,000     ||  228            ||  0.0028      ||
 ||  4       ||  47,000     ||  270            ||  0.0         ||
 ||  5       ||  51,000     ||  270            ||  -0.0028     ||
 ||  6       ||  71,000     ||  214            ||  `NaN`       ||


And add one with verbatim headings (with underscores),
and rows starting with `|-` because of a negative number,
and `|` right before and after verbatim word (with no space):


 ||  _exact_   ||  _`v_1`_    ||  _`a_i` + `v_2`_   ||  _`verb_3_`_   ||
 ||  9         ||  9.62       ||  5.57              ||  8.98          ||
 ||  -20       ||  -23.39     ||  -7.65             ||  -19.93        ||
 ||  10        ||  17.74      ||  -4.50             ||  9.96          ||
 ||  0         ||  -9.19      ||  4.13              ||  -0.26         ||


Pipe symbols in verbatim and math text in tables used to pose difficulties,
but not
anymore:


 ||      _`S`_       ||     _command_      ||
 ||  $ ||a_0|| $     ||  `norm|length`     ||
 ||  `x\cap y`       ||  `x|y`             ||


Here is a table with X alignment:


 ||   _Type_   ||                                                                                                       _Description_                                                                                                         ||
 ||  X         ||  Alignment character that is used for specifying a potentially very long text in a column in a table. It makes use of the `tabularx` package in LaTeX, otherwise (for other formats) it means `l` (centered alignment).     ||
 ||  l,r,c     ||  standard alignment characters                                                                                                                                                                                              ||


Finally, a table with math
and URLs.

<wiki:comment> Mako code to expand URLs in the table </wiki:comment>
<wiki:comment> (These types of tables did not work before Jan 2014) </wiki:comment>


 ||  `\mathcal{L}=0`             ||  [../doc/src/manual/mov/wave_frames/frame_0080.png `080`]     ||  [../doc/src/manual/mov/wave_frames/frame_0085.png `085`]     ||
 ||  `a=b`                       ||  [../doc/src/manual/mov/wave_frames/frame_0090.png `090`]     ||  [../doc/src/manual/mov/wave_frames/frame_0095.png `095`]     ||
 ||  `\nabla\cdot\bm{u} =0 `     ||  [../doc/src/manual/mov/wave_frames/frame_0100.png `100`]     ||  [../doc/src/manual/mov/wave_frames/frame_0105.png `105`]     ||


==== A test of verbatim words in heading with subscript `a_i`: `my_file_v1` and `my_file_v2` ====

*Paragraph with verbatim and math: `my_file_v1.py` and `my_file_v2.py` define some math `a_{i-1}`.* Here is more `__verbatim__` code and
some plain text on a new line.

<wiki:comment> Test various types of headlines </wiki:comment>
==== *Just bold* ====

Some text.

==== *Just emphasize* ====

Some text.

==== `Just verbatim` ====

Some text.

==== *Bold* beginning ====

Some text.

==== *Emphasize* beginning ====

Some text.

==== `Verbatim` beginning ====

Some text.

==== Maybe *bold end* ====

Some text.

==== Maybe *emphasize end* ====

Some text.

==== Maybe `verbatim end` ====

Some text.

==== The middle has *bold* word ====

Some text.

==== The middle has *emphasize* word ====

Some text.

==== The middle has `verbatim` word ====

Some text.

**Just emphasize*.* Some text.

*`Just verbatim`.* Some text.

**Emphasize* beginning.* Some text.

*`Verbatim beginning`.* Some text.

*Maybe *emphasize end*.* Some text.

*Maybe `verbatim end`.* Some text.

*The middle has *emphasize* word.* Some text.

*The middle has `verbatim` word.* Some text.

*Ampersand.*
We can test Hennes & Mauritz, often abbreviated H&M, but written
as `Hennes & Mauritz` and `H & M`.
A sole `&` must also work.
<wiki:comment> Note: substitutions must not occur inside verbatim, just in ordinary text. </wiki:comment>

{{{
# Just to check that ampersand works in code blocks:
c = a & b
}}}

*Quotes.*
Let us also add a test of quotes such as "double quotes, with numbers
like 3.14 and newline/comma and hyphen (as in double-quote)"; written
in the standard LaTeX-style that gives correct LaTeX formatting and
ordinary double quotes for all non-LaTeX formats.  Here is another
sentence that "caused" a bug in the past because double backtick
quotes could imply verbatim text up to a verbatim word starting with
period, like `.txt`.

More quotes to be tested for spellcheck:
("with parenthesis"), "with newline"
and "with comma", "hyphen"-wise, and "period".

==== Bibliography test ====

Here is an example: [1] discussed propagation of
large destructive water waves, [2] gave
an overview of numerical methods for solving the Navier - Stokes equations,
while the use of Backward Kolmogorov equations for analyzing
random vibrations was investigated in [3].
The book chapter [4] contains information on
C++ software tools for programming multigrid methods. A real retro
reference is [5] about a big FORTRAN package.
Multiple references are also possible, e.g., see
[1] [4].

We need to cite more than 10 papers to reproduce an old formatting
problem with blanks in the keys in reST format:
[6] [3] [7] [1]
and
[2] [8] [9] [10] [11] [12] [13]
and all the work of
[14] [4] [15] as well as
old work [5] and [16], and the
talk [17].
Langtangen also had two thesis [18] [16]
back in the days.
More retro citations are
the old ME-IN323 book [19] and the
[20] OONSKI '94 paper.

<wiki:comment> --- begin exercise --- </wiki:comment>

==== Example 1: Examples can be typeset as exercises ====

Examples can start with a subsection heading starting with `Example:`
and then, with the command-line option `--examples_as_exercises` be
typeset as exercises. This is useful if one has solution
environments as part of the example.

*a)*
State some problem.

*Solution.*
The answer to this subproblem can be written here.

*b)*
State some other problem.

*Hint 1.*
A hint can be given.

*Hint 2.*
Maybe even another hint?

*Solution.*
The answer to this other subproblem goes here,
maybe over multiple doconce input lines.

<wiki:comment> --- end exercise --- </wiki:comment>

==== User-defined environments ====

The example in the section [#Example_1:_A_test_function] demonstrates how to write a test function.
That is, a special test function for a function `add` appears in
the example in the section [#Example_1:_A_test_function].

==== Example 1: A test function ====

Suppose we want to write a test function for checking the
implementation of a Python function for addition.

{{{
def add(a, b):
    return a + b

def test_add():
    a = 1; b = 1
    expected = a + b
    computed = add(a, b)
    assert expected == computed
}}}

==== Example 2: Addition ====

We have

{{{
\[ 1 + 1 = 2 \]
}}}
or in tabular form:


 ||  _Problem_   ||  _Result_   ||
 ||  `1+1`       ||  `2`        ||


*Highlight box!* 
This environment is used to highlight something:

{{{
\[ E = mc^2 \]
}}}



==== URLs ====

Testing of URLs: hpl's home page [https://folk.uio.no/hpl hpl], or
the entire URL if desired, https://folk.uio.no/hpl.  Here is a
plain file link testdoc.do.txt, or testdoc.do.txt, or
testdoc.do.txt or testdoc.do.txt or [testdoc.do.txt a link with
newline]. Can test spaces with the link with word
too: [https://folk.uio.no/hpl hpl] or [https://folk.uio.no/hpl hpl]. Also `file:///` works: [file:///home/hpl/vc/doconce/doc/demos/manual/manual.html link to a
file] is
fine to have. Moreover, "loose" URLs work, i.e., no quotes, just
the plain URL as in https://folk.uio.no/hpl, if followed by space, comma,
colon, semi-colon, question mark, exclamation mark, but not a period
(which gets confused with the periods inside the URL).

Mail addresses can also be used: [mailto:hpl@simula.no `hpl@simula.no`], or just a [mailto:hpl@simula.no mail link], or a raw mailto:hpl@simula.no.

Here are some tough tests of URLs, especially for the `latex` format:
[https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas Newton-Cotes] formulas
and a [https://www.springer.com/mathematics/computational+science+%26+engineering/book/978-3-642-23098-1 good book]. Need to test
Newton-Cotes with percentage in URL too:
https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas
and https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae which has a shebang.

For the `--device=paper` option it is important to test that URLs with
monospace font link text get a footnote
(unless the `--latex_no_program_footnotelink`
is used), as in this reference to
[https://github.com/hplgit/INF5620/tree/gh-pages/src/decay/experiments/decay_mod.py `decay_mod`], [https://tinyurl.com/pwyasaa/formulas.ball1.py `ball1.py`],
and [https://tinyurl.com/pwyasaa/formulas.ball2.py `ball2.py`].

<wiki:comment> Comments should be inserted outside paragraphs (because in the rst </wiki:comment>
<wiki:comment> format extra blanks make a paragraph break). </wiki:comment>

<wiki:comment> Note that when there is no https: or file:, it can be a file link </wiki:comment>
<wiki:comment> if the link name is URL, url, "URL", or "url". Such files should, </wiki:comment>
<wiki:comment> if rst output is desired, but placed in a `_static*` folder. </wiki:comment>

More tough tests: repeated URLs whose footnotes when using the
`--device=paper` option must be correct. We have
[https://google.com google], [https://google.com google], and
[https://google.com google], which should result in exactly three
footnotes.

<wiki:comment> !split and check if these extra words are included properly in the comment </wiki:comment>

== LaTeX Mathematics ==

Here is an equation without label using backslash-bracket environment:
{{{
\[ a = b + c \]
}}}

or with number and label, as in Equation (my:eq1), using the equation environment:

{{{
\begin{equation}
{\partial u\over\partial t} = \nabla^2 u label{my:eq1}
\end{equation}
}}}

We can refer to this equation by Equation (my:eq1).

Here is a system without equation numbers, using the align-asterisk environment:

{{{
\begin{align*}
\pmb{a} &= \pmb{q}\times\pmb{n} \\ 
b &= \nabla^2 u + \nabla^4 v
\end{align*}
}}}

More mathematical typesetting is demonstrated in the coming exercises.

Below, we have [#Problem_2:_Flip_a_Coin] and [#Project_4:_Compute_a_Probability],
as well as [#Project_5:_Explore_Distributions_of_Random_Circles] and [#Project_11:_References_to_Project_demo:ex:2_in_a_heading_works_for_gwiki], and in
between there we have [#Exercise_10:_Make_references_to_projects_and_problems].

== Exercises ==

<wiki:comment> --- begin exercise --- </wiki:comment>

==== Problem 2: Flip a Coin ====

<wiki:comment> keywords = random numbers; Monte Carlo simulation; ipynb </wiki:comment>

<wiki:comment> Torture tests </wiki:comment>

*a)*
Make a program that simulates flipping a coin `N` times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

<wiki:comment> --- begin hint in exercise --- </wiki:comment>

*Hint 1.*
Use `r = random.random()` and define head as `r <= 0.5`.

<wiki:comment> --- end hint in exercise --- </wiki:comment>

<wiki:comment> --- begin hint in exercise --- </wiki:comment>

*Hint 2.*
Draw an integer among `\{1,2\}` with
`r = random.randint(1,2)` and define head when `r` is 1.

<wiki:comment> --- end hint in exercise --- </wiki:comment>

<wiki:comment> --- begin answer of exercise --- </wiki:comment>
*Answer.*
If the `random.random()` function returns a number `<1/2`, let it be
head, otherwise tail. Repeat this `N` number of times.
<wiki:comment> --- end answer of exercise --- </wiki:comment>

<wiki:comment> --- begin solution of exercise --- </wiki:comment>
*Solution.*
{{{
import sys, random
N = int(sys.argv[1])
heads = 0
for i in range(N):
    r = random.random()
    if r <= 0.5:
        heads += 1
print('Flipping a coin %d times gave %d heads' % (N, heads))
}}}
<wiki:comment> --- end solution of exercise --- </wiki:comment>

*b)*
Vectorize the code in a) using boolean indexing.

Vectorized code can be written in many ways.
Sometimes the code is less intuitive, sometimes not.
At least there is not much to find in the section [#Section_1].

*c)*
Vectorize the code in a) using `numpy.sum`.

<wiki:comment> --- begin answer of exercise --- </wiki:comment>
*Answer.*
`np.sum(np.where(r <= 0.5, 1, 0))` or `np.sum(r <= 0.5)`.
<wiki:comment> --- end answer of exercise --- </wiki:comment>

In this latter subexercise, we have an
example where the code is easy to read.

==== My remarks ====

Remarks with such a subsubsection is treated as more text
after the last subexercise. Test a list too:


# Mark 1.
# Mark 2.

Filenames: `flip_coin.py`, `flip_coin.pdf`.

<wiki:comment> Closing remarks for this Problem </wiki:comment>

==== Remarks ====

These are the exercise remarks, appearing at the very end.

<wiki:comment> solution files: mysol.txt, mysol_flip_coin.py, yet_another.file </wiki:comment>

<wiki:comment> --- end exercise --- </wiki:comment>

==== Not an exercise ====

Should be possible to stick a normal section in the middle of many
exercises.

<wiki:comment> --- begin exercise --- </wiki:comment>

==== Exercise 3: Test of plain text exercise ====

Very short exercise. What is the capital
of Norway?
Filename: `myexer1`.

<wiki:comment> --- end exercise --- </wiki:comment>

<wiki:comment> --- begin exercise --- </wiki:comment>

==== Project 4: Compute a Probability ====

<wiki:comment> Minimalistic exercise </wiki:comment>

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval `[0,1)`?

At the end we have a list because that caused problems in LaTeX
in previous DocOnce versions:


# item1
# item2

<wiki:comment> --- begin hint in exercise --- </wiki:comment>

*Hint.*
To answer this question empirically, let a program
draw `N` such random numbers using Python's standard `random` module,
count how many of them, `M`, that fall in the interval `(0.5,0.6)`, and
compute the probability as `M/N`.

<wiki:comment> --- end hint in exercise --- </wiki:comment>

<wiki:comment> --- end exercise --- </wiki:comment>

<wiki:comment> --- begin exercise --- </wiki:comment>

==== Project 5: Explore Distributions of Random Circles ====

<wiki:comment> keywords = ipynb </wiki:comment>

The formula for a circle is given by

{{{
\begin{align}
x &= x_0 + R\cos 2\pi t,
label{circle:x}\\ 
y &= y_0 + R\sin 2\pi t,
label{circle:y}
\end{align}
}}}
where `R` is the radius of the circle, `(x_0,y_0)` is the
center point, and `t` is a parameter in the unit interval `[0,1]`.
For any `t`, `(x,y)` computed from Equations (circle:x)-(circle:y)
is a point on the circle.
The formula can be used to generate `n` points on a circle:

{{{
import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y

x, y = circle(2.0, 0, 0)
}}}

<wiki:comment> Often in an exercise we have some comments about the solution </wiki:comment>
<wiki:comment> which we normally want to keep where they are. </wiki:comment>

The goal of this project is to draw `N` circles with random
center and radius. Plot each circle using the `circle` function
above.

*a)*
Let `R` be normally distributed and `(x_0,y_0)` uniformly distributed.

<wiki:comment> --- begin hint in exercise --- </wiki:comment>

*Hint.*
Use the `numpy.random` module to draw the
`x_0`, `y_0`, and `R` quantities.

<wiki:comment> --- end hint in exercise --- </wiki:comment>

<wiki:comment> --- begin answer of exercise --- </wiki:comment>
*Answer.*
Here goes the short answer to part a).
<wiki:comment> --- end answer of exercise --- </wiki:comment>

<wiki:comment> --- begin solution of exercise --- </wiki:comment>
*Solution.*
Here goes a full solution to part a).
<wiki:comment> --- end solution of exercise --- </wiki:comment>

*b)*
Let `R` be uniformly distributed and `(x_0,y_0)` normally distributed.
Filename: `norm`.

*c)*
Let `R` and `(x_0,y_0)` be normally distributed.

Filename: `circles`.

<wiki:comment> Closing remarks for this Project </wiki:comment>

==== Remarks ====

At the very end of the exercise it may be appropriate to summarize
and give some perspectives.

<wiki:comment> --- end exercise --- </wiki:comment>

<wiki:comment> --- begin exercise --- </wiki:comment>

==== Exercise 6: Determine some Distance ====

Intro to this exercise. Questions are in subexercises below.

<wiki:comment> --- begin solution of exercise --- </wiki:comment>
*Solution.*
Here goes a full solution of the whole exercise.
With some math `a=b` in this solution:
{{{
\[ \hbox{math in solution: } a = b \]
}}}
And code `a=b` in this solution:
{{{
a = b  # code in solution
}}}
End of solution is here.

<wiki:comment> --- end solution of exercise --- </wiki:comment>

*a)*
Subexercises are numbered a), b), etc.

<wiki:comment> --- begin hint in exercise --- </wiki:comment>

*Hint 1.*
First hint to subexercise a).
With math `a=b` in hint:

{{{
\[ a=b. \]
}}}
And with code (in plain verbatim) returning `x+1` in hint:

{{{
def func(x):
    return x + 1  # with code in hint
}}}

<wiki:comment> --- end hint in exercise --- </wiki:comment>

<wiki:comment> --- begin hint in exercise --- </wiki:comment>

*Hint 2.*
Second hint to subexercise a).

Test list in hint:


# item1
# item2

<wiki:comment> --- end hint in exercise --- </wiki:comment>
Filename: `subexer_a.pdf`.

<wiki:comment> --- begin answer of exercise --- </wiki:comment>
*Answer.*
Short answer to subexercise a).
With math in answer: `a=b`.
<wiki:comment> --- end answer of exercise --- </wiki:comment>

*b)*
Here goes the text for subexercise b).

Some math `\cos^2 x + \sin^2 x = 1` written one a single line:

{{{
\[ \cos^2 x + \sin^2 x = 1 \thinspace .\]
}}}

<wiki:comment> --- begin hint in exercise --- </wiki:comment>

*Hint.*
A hint for this subexercise.

<wiki:comment> --- end hint in exercise --- </wiki:comment>
Filename: `subexer_b.pdf`.

<wiki:comment> --- begin solution of exercise --- </wiki:comment>
*Solution.*
Here goes the solution of this subexercise.
<wiki:comment> --- end solution of exercise --- </wiki:comment>

<wiki:comment> No meaning in this weired test example: </wiki:comment>
The text here belongs to the main (intro) part of the exercise. Need
closing remarks to have text after subexercises.

Test list in exercise:


# item1
# item2<wiki:comment> Closing remarks for this Exercise </wiki:comment>


==== Remarks ====

Some final closing remarks, e.g., summarizing the main findings
and their implications in other problems can be made. These
remarks will appear at the end of the typeset exercise.

<wiki:comment> --- end exercise --- </wiki:comment>

<wiki:comment> --- begin exercise --- </wiki:comment>

==== Some exercise without the "Exercise:" prefix ====

<wiki:comment> Another minimalistic exercise </wiki:comment>

Just some text. And some math saying that `e^0=1` on a single line,
to test that math block insertion is correct:

{{{
\[ \exp{(0)} = 1 \]
}}}

And a test that the code `lambda x: x+2` is correctly placed here:

{{{
lambda x: x+2
}}}

<wiki:comment> Have some comments at the end of the exercise to see that </wiki:comment>
<wiki:comment> the Filename: ... is written correctly. </wiki:comment>
<wiki:comment> --- end exercise --- </wiki:comment>

<wiki:comment> --- begin exercise --- </wiki:comment>

==== Exercise 8: Solution of differential equation ====



Given

{{{
\[ \frac{dy}{dx} = -y(x),\quad y(0)=1 \]
}}}
What is the solution of this equation?

Choice A: `y=e^{-y}`

Choice B: `y=e^{y}`

Choice C: 
{{{
from math import exp
def f(x):
    return exp(x)
}}}

Choice D: The solution cannot be found because there is a derivative in the equation.

Choice E: The equation is meaningless: an equation must be an equation
for `x` or `y`, not a function `y(x)`.



<wiki:comment> --- end exercise --- </wiki:comment>

<wiki:comment> --- begin exercise --- </wiki:comment>

==== Example 9: Just an example ====

<wiki:comment> This example needs the --examples_as_exercises option, otherwise </wiki:comment>
<wiki:comment> it is just typeset as it is written. </wiki:comment>

*a)*
What is the capital of Norway?

*Answer.*
Oslo.

<wiki:comment> --- end exercise --- </wiki:comment>

== Here goes another section ==

With some text, before we continue with exercises.

== More Exercises ==

<wiki:comment> --- begin exercise --- </wiki:comment>

==== Exercise 10: Make references to projects and problems ====

<wiki:comment> Test comments not at the end only </wiki:comment>
Pick a statement from [#Project_5:_Explore_Distributions_of_Random_Circles] or [#Problem_2:_Flip_a_Coin]
and verify it.

Test list at the end of an exercise without other elements (like subexercise,
hint, etc.):


# item1
# item2

Filename: `verify_formula.py`.

<wiki:comment> --- end exercise --- </wiki:comment>

<wiki:comment> --- begin exercise --- </wiki:comment>

==== Project 11: References to [#Project_4:_Compute_a_Probability] in a heading works for gwiki ====

Refer to the previous exercise as [#Exercise_10:_Make_references_to_projects_and_problems],
the two before that as [#Project_4:_Compute_a_Probability] and [#Project_5:_Explore_Distributions_of_Random_Circles],
and this one as [#Project_11:_References_to_Project_demo:ex:2_in_a_heading_works_for_gwiki].
Filename: `selc_composed.pdf`.

<wiki:comment> --- end exercise --- </wiki:comment>

== References ==


 # *H. P. Langtangen and G. Pedersen*.     Propagation of Large Destructive Waves,    *International Journal of Applied Mechanics and Engineering*,    7(1),    pp. 187-204,    2002.
 # *H. P. Langtangen, K.-A. Mardal and R. Winther*.     Numerical Methods for Incompressible Viscous Flow,    *Advances in Water Resources*,    25,    pp. 1125-1146,    2002.
 # *H. P. Langtangen*.     Numerical Solution of First Passage Problems in Random Vibrations,    *SIAM Journal of Scientific and Statistical Computing*,    15,    pp. 997-996,    1994.
 # *K.-A. Mardal, G. W. Zumbusch and H. P. Langtangen*.     Software Tools for Multigrid Methods,    *Advanced Topics in Computational Partial Differential Equations -- Numerical Methods and Diffpack Programming*,    edited by *H. P. Langtangen and A. Tveito*,    Springer,    2003,    Edited book,    http://some.where.org.
 # *H. P. Langtangen*.     The FEMDEQS Program System,    *Department of Mathematics, University of Oslo*,    1989,    http://www.math.uio.no/old/days/hpl/femdeqs.pdf.
 # *H. P. Langtangen*.     Stochastic Breakthrough Time Analysis of an Enhanced Oil Recovery Process,    *SIAM Journal on Scientific Computing*,    13,    pp. 1394-1417,    1992.
 # *M. Mortensen, H. P. Langtangen and G. N. Wells*.     A FEniCS-Based Programming Framework for Modeling Turbulent Flow by the Reynolds-Averaged Navier-Stokes Equations,    *Advances in Water Resources*,    34(9),    [https://dx.doi.org/10.1016/j.advwatres.2011.02.013 doi: 10.1016/j.advwatres.2011.02.013],    2011.
 # *S. Glimsdal, G. Pedersen, K. Atakan, C. B. Harbitz, H. P. Langtangen and F. L\ovholt*.     Propagation of the Dec. 26, 2004 Indian Ocean Tsunami: Effects of Dispersion and Source Characteristics,    *International Journal of Fluid Mechanics Research*,    33(1),    pp. 15-43,    2006.
 # *S. Rahman, J. Gorman, C. H. W. Barnes, D. A. Williams and H. P. Langtangen*.     Numerical Investigation of a Piezoelectric Surface Acoustic Wave Interaction With a One-Dimensional Channel,    *Physical Review B: Condensed Matter and Materials Physics*,    74,    2006,    035308.
# *J. B. Haga, H. Osnes and H. P. Langtangen*.     On the Causes of Pressure Oscillations in Low-Permeable and Low-Compressible Porous Media,    *International Journal of Analytical and Numerical Methods in Geomechanics*,    [https://dx.doi.org/10.1002/nag.1062 doi: 10.1002/nag.1062],    2011,    http://onlinelibrary.wiley.com/doi/10.1002/nag.1062/abstract.
# *H. P. Langtangen*.     *Computational Partial Differential Equations - Numerical Methods and Diffpack Programming*,    second edition,    *Texts in Computational Science and Engineering*,    Springer,    2003.
# *H. P. Langtangen*.     *Python Scripting for Computational Science*,    third edition,    *Texts in Computational Science and Engineering*,    Springer,    2008.
# *H. P. Langtangen and G. Pedersen*.     Finite Elements for the Boussinesq Wave Equations,    Waves and Non-linear Processes in Hydrodynamics,    edited by *J. Grue, B. Gjevik and J. E. Weber*,    Kluwer Academic Publishers,    pp. pp. 117-126,    1995,    http://www.amazon.ca/Waves-Nonlinear-Processes-Hydrodynamics-John/dp/0792340310.
# *H. P. Langtangen*.     *A Primer on Scientific Programming With Python*,    third edition,    *Texts in Computational Science and Engineering*,    Springer,    2012.
# *P. V. Jeberg, H. P. Langtangen and C. B. Terp*.     Optimization With Diffpack: Practical Example From Welding,    *Simula Research Laboratory*,    2004,    Internal report.
# *H. P. Langtangen*.     Computational Methods for Two-Phase Flow in Oil Reservoirs,    Ph.D. Thesis,    Mechanics Division, Department of Mathematics, University of Oslo,    1989,    Dr. Scient. thesis..
# *H. P. Langtangen*.     Computational Modeling of Huge Tsunamis From Asteroid Impacts,    2007,    Invited keynote lecture at the \emphInternational conference on Computational Science 2007 (ICCS'07), Beijing, China.
# *H. P. Langtangen*.     Solution of the Navier-Stokes Equations With the Finite Element Method in Two and Three Dimensions,    M.Sc. Thesis,    Mechanics Division, Department of Mathematics, University of Oslo,    1985,    Cand.Scient. thesis.
# *H. P. Langtangen and A. Tveito*.     Numerical Methods in Continuum Mechanics,    *Center for Industrial Research*,    1991,    Lecture notes for a course (ME-IN 324). 286 pages..
# *H. P. Langtangen*.     Diffpack: Software for Partial Differential Equations,    *Proceedings of the Second Annual Object-Oriented Numerics Conference (OON-SKI'94), Sunriver, Oregon, USA*,    edited by *A. Vermeulen*,    1994.

== Appendix: Just for testing; part I ==

This is the first appendix.

==== A subsection within an appendix ====

Some text.

== Appendix: Just for testing; part II ==

This is more stuff for an appendix.

==== Appendix: Testing identical titles ====

Without label.

==== Appendix: Testing identical titles ====

With label.

==== Appendix: Testing identical titles ====

What about inserting a quiz?



======= Test of quizzes =======


Fundamental test: What is the capital of Norway?

Answer 1: Stockholm

Answer 2: London

Answer 3: Oslo

Choice D: Bergen



==== Appendix: Testing identical titles ====

Without label.

*Tip.* 
Here is a tip or hint box, typeset as a notice box.



Need a lot of text to surround the summary box.
Version control systems allow you to record the history of files
and share files among several computers and collaborators in a
professional way. File changes on one computer are updated or
merged with changes on another computer. Especially when working
with programs or technical reports it is essential
to have changes documented and to
ensure that every computer and person involved in the project
have the latest updates of the files.
Greg Wilson' excellent [https://software-carpentry.org/2010/07/script-for-introduction-to-version-control/ Script for Introduction to Version Control] provides a more detailed motivation why you will benefit greatly
from using version control systems.

*Summary.* 
*Bold remark:* Make some text with this summary.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.



Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that site. I strongly
recommend you to use such sites for all serious programming and
scientific writing work - and all other important files.

The simplest services for hosting project files are [https://dropbox.com Dropbox] and [https://drive.google.com Google Drive].
It is very easy to get started with these systems, and they allow you
to share files among laptops and mobile units with as many users as
you want. The systems offer a kind of version control in that the
files are stored frequently (several times per minute), and you can go
back to previous versions for the last 30 days. However, it is
challenging  to find the right version from the past when there are
so many of them.

More seriously, when several people may edit files simultaneously, it
can be difficult detect who did what when, roll back to previous
versions, and to manually merge the edits when these are
incompatible. Then one needs more sophisticated tools than Dropbox or
Google Drive: project hosting services with true version control
systems.  The following text aims at providing you with the minimum
information to started with such systems. Numerous other tutorials
contain more comprehensive material and in-depth explanations of the
concepts and tools.

The idea with project hosting services is that you have the files
associated with a project in the cloud. Many people may share these
files.  Every time you want to work on the project you explicitly
update your version of the files, edit the files as you like, and
synchronize the files with the "master version" at the site where the
project is hosted.  If you at some point need to go back to a
version of the files at some particular point in the past,
this is an easy operation. You can also use tools to see
what various people have done with the files in the various versions.

All these services are very similar. Below we describe how you get
started with Bitbucket, GitHub, and Googlecode. Launchpad works very
similarly to the latter three. All the project hosting services have
excellent introductions available at their web sites, but the recipes
below are much shorter and aim at getting you started as quickly as
possible by concentrating on the most important need-to-know steps.
The Git tutorials we refer to later in this document contain more
detailed information and constitute of course very valuable readings
when you use version control systems every day. The point now is
to get started.

==== Appendix: Testing inline comments ====

<wiki:comment> Names can be [ A-Za-z0-9_'+-]+ </wiki:comment>

Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that
site.  I strongly recommend you to use such sites for all serious
programming and scientific writing work - and all other important
files.

The simplest services for hosting project files is Dropbox.  It
is very easy to get started with Dropbox, and it allows you to share
files among .

<wiki:comment> Test horizontal rule </wiki:comment>

------

<wiki:comment> Coments for editing </wiki:comment>

First consider a quantity `Q`. 
`Q>0`, because  negative   negative. 

<wiki:comment> Test tailored latex figure references with page number </wiki:comment>
Let us refer to Figure fig:impact again.

Test references in a list:


 * [#Section_1]
 * [#Subsection_1]
 * fig:impact

==== Appendix: Testing headings ending with `verbatim inline` ====

The point here is to test 1) `verbatim` code in headings, and 2)
ending a heading with verbatim code as this triggers a special
case in LaTeX.

We also test mdash---used as alternative to hyphen without spaces around,
or in quotes:





The ndash should also be tested - as in the Hanson - Nilson equations
on page 277 - 278.

And finally, what about admons, quotes, and boxes? They are tested
in a separate document: `admon.do.txt`.

[^example-of-the-third-footnote]: Not much to add here, but the footnote
is at the end with only one newline.

************** File: testdoc.mwiki *****************
#TITLE (actually governed by the filename): A Document for Testing DocOnce

By '''Hans Petter Langtangen''' (hpl at simula.no), '''Kaare Dump''', '''A. Dummy Author''', '''I. S. Overworked and Outburned''', and '''J. Doe''' (j_doe at cyberspace.com)
==== Jan 32, 2100 ====

Made with DocOnce



__TOC__

<!-- !split -->

The format of this document is
mwiki

''Abstract.'' This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.

<!-- Cannot demonstrate chapter headings since abstract and chapter -->
<!-- are mutually exclusive in LaTeX -->

== Section 1 ==

Here is a nested list:


<ul>
  <li> item1
  <li> item2
  <li> item3 which continues
    on the next line to test that feature
  <li> and a sublist

<ul>
    <li><li> with indented subitem1
    <li><li> and a subitem2
</ul>

  <li> and perhaps an ordered sublist

<ol type="a">
   <li><li> first item
   <li><li> second item,
      continuing on a new line
</ol>

</ul>

''Here is a list with paragraph heading.''


<ul>
  <li> item1
  <li> item2
</ul>

==== Here is a list with subsubsection heading ====

<ul>
  <li> item1
  <li> item2
</ul>


{{quote box
| quote = Here are two lines that make up
a block quote for testing ''emphasized words'' and '''boldface words''',
also with hypens:
''pre''-fix, post-''fix'', '''pre'''-fix, post-'''fix'''.
| textstyle = font-size: 90%;
}}



Here are two references. Equation&nbsp;(my:eq1) is fine. Eq.&nbsp;(my:eq1) too.
Even Equation (my:eq1) without the tilde.

==== Subsection 1 ====

<!-- Refer to section/appendix etc. at the beginning of the line -->
<!-- and other special fix situations for HTML. -->

More text, with a reference back to
the section [#Section_1] and [#Subsection_1], and further to the
the sections [#Subsection_1] and [#URLs], which
encourages you to do the tasks in [#Problem_2:_Flip_a_Coin] and [#Exercise_10:_Make_references_to_projects_and_problems].
 [#Appendix:_Just_for_testing;_part_I] and [#Appendix:_Just_for_testing;_part_II] are also nice elements.

==== Test Section reference at beginning of line and after a sentence ====

The section [#Subsection_1] is fine.
The section [#URLs] too.

<!-- sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console -->

==== Computer code ====

Let's do some copying from files too. First from subroutine up to the very end,

<syntaxhighlight lang="fortran">
      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
</syntaxhighlight>
and then just the subroutine,
<syntaxhighlight lang="fortran">
      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
</syntaxhighlight>
and finally the complete file with a plain text verbatim environment
(<code>envir=ccq</code>):
<syntaxhighlight lang="text">
C     a comment

      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
</syntaxhighlight>

Testing other code environments. First Python:

<syntaxhighlight lang="text">
!bc pycod
def f(x):
    return x+1
!ec
</syntaxhighlight>
which gets rendered as

<syntaxhighlight lang="python">
def f(x):
    return x+1
</syntaxhighlight>

Test paragraph and subsubsection headings before
before code.

''Paragraph heading before code.''

<syntaxhighlight lang="python">
import sys
sys.path.insert(0, os.pardir)
</syntaxhighlight>

==== Subsubsection heading before code ====

<syntaxhighlight lang="python">
def h(z):
    return z+1
</syntaxhighlight>

Here is a program that is supposed to be interactive via
Python Online Tutorial, but that service is not accessible
for the present format.

<syntaxhighlight lang="python">
class Line:
    def __init__(self, a, b):
        self.a, self.b = a, b

    def __call__(self, x):
        a, b = self.a, self.b
        return a*x + b

line = Line(2, 1)
y = line(x=3)
print(y)
</syntaxhighlight>

Some more Python code (actually specified as a sage cell, but
such cells are not supported by this format).

<syntaxhighlight lang="python">
a = 2
b = 3
print('a+b:', a + b)

# In a sage cell we can also plot
from matplotlib.pyplot import *
from numpy import *
x = linspace(0, 4*pi, 101)
y = exp(-0.1*x)*cos(x)
plot(x, y)
xlabel('x'); ylabel('y')
show()
</syntaxhighlight>

Then Cython (with -h option so it is hidden in html/sphinx):

<syntaxhighlight lang="python">
cpdef f(double x):
    return x + 1
</syntaxhighlight>

Standard Python shell sessions:

<syntaxhighlight lang="python">
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
</syntaxhighlight>

Similar IPython sessions:

<syntaxhighlight lang="python">
In [1]: from numpy import linspace, sin
In [2]: # Some comment
In [3]: x = linspace(0, 2, 11)
In [4]: y = sin(x)
In [5]: y[0]
Out[5]: 0
In [6]: import matplotlib.pyplot as plt
In [7]: plt.plot(x, y)
In [8]: a='multiple-\nline\noutput'
In [9]: a
Out[9]: 'multiple-\nline\noutput'
In [10]: print(a)
multiple-
line
output
</syntaxhighlight>

Here is the interactive session again, but with <code>pyshell-t</code>.

<syntaxhighlight lang="python">
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
</syntaxhighlight>

<!-- This one tests a + sign before a code environment -->
C++:
<syntaxhighlight lang="cpp">
#include <iostream>

int main()
{
   std::cout << "Sample output" << std::endl;
   return 0
}
</syntaxhighlight>
<!-- The next should get correctly typset in sphinx (cod is fcod) -->
<!-- It also tests emoji before code -->
And a little bit of Fortran: :dizzy_face:

<syntaxhighlight lang="text">
!bc cod
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
!ec
</syntaxhighlight>
which then is typeset as

<syntaxhighlight lang="python">
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
</syntaxhighlight>

HTML:

<syntaxhighlight lang="html5">
<table>
<tr><td>Column 1</td><td>Column 2</td></tr>
<tr><td>0.67526 </td><td>0.92871 </td></tr>
<!-- comment -->
</table>
</syntaxhighlight>

But inline HTML code is also important, like text that starts with
<code><a href="</code> (which can destroy the following text if not properly
quoted).

Matlab with comments requires special typesetting:

<syntaxhighlight lang="matlab">
% Comment on the beginning of the line can be escaped by %%
if a > b
  % Indented comment needs this trick
  c = a + b
end
</syntaxhighlight>

And here is a system call:

<syntaxhighlight lang="bash">
Terminal> mkdir test
Terminal> cd test
Terminal> myprog -f
output1
output2
</syntaxhighlight>

Any valid pygments lexer/language name can appear to, e.g.,

<syntaxhighlight lang="text">
!bc restructuredtext
=======
Heading
=======

Some text.
!ec
</syntaxhighlight>
results in

<syntaxhighlight lang="text">
=======
Heading
=======

Some text.
</syntaxhighlight>

<!-- Here goes hidden code. -->
<!-- Python can be treated by some formats, Fortran is always out. -->





Finally, <code>!bc do</code> supports highlighting of DocOnce source:

<syntaxhighlight lang="text">
======= DocOnce test file =======

===== Computer code =====

Inline verbatim code, as in `import numpy as np`, is allowed, as well as
code blocks:

!bc pycod
from math import sin

def f(x):
    """Example on a function."""
    return sin(x) + 1

print(f(0))
!ec


===== Mathematics =====

Formulas can be inline, as in $\nabla\cdot\bm{u} = 0$, or typeset
as equations:

!bt
\begin{align*}
\nabla\cdot\bm{u} &= 0,\\ 
\bm{u} &= \nabla\phi .
\end{align*}
!et

=== Subsubsection heading ===

DocOnce files can have chapters, sections, subsections, and subsubsections.

__Paragraph heading.__ Paragraphs may have headings.
</syntaxhighlight>

It is time to test <code>verbatim inline font</code> especially with <code>a newline
inside the text</code> and an exclamation mark at the end: <code>BEGIN</code>! For
spellcheck, test <code>a verbatim expression</code> in <code>another</code> in a <code>third</code>.
Also test exclamation mark as in <code>!bc</code> and <code>!ec</code> as well as <code>a != b</code>.
Also test backslashes and braces like <code>\begin</code>, <code>\begin{enumerate}</code>,
<code>\end{this}\end{that}</code>, and <code>{something \inside braces}</code>.

The following attempt to exemplify colored text does not work in
format mwiki.
Here is some <font color="red">red color</font> and an attempt to write <font color="green">with
green color containing a linebreak<br />
code.</font> Some formats will only display <br />
this correctly when <code>html</code> <br />
is the output format.
But here some more running text is added which is not part of
the previous blocks with line breaks.

==== Running OS commands ====

<syntaxhighlight lang="bash">
Terminal> python -c 'print("Testing\noutput\nfrom\nPython.")'
Testing
output
from
Python.
</syntaxhighlight>

==== Footnotes ====

Here is a test of footnotes [^footnote], which are handy in text.
They are used in different flavors, now in


<ul>
 <li> list items (note below that footnotes work after math, verbatim, and URLs - bin fact old and emphasize too!)
 <li> even with math <math>\nabla^2u</math>[^math1]
 <li> and code <code>h[i] += 1</code>[^code]
   (''must'' have space between inline code and footnote!)
 <li> and [https://google.com links][^google-search]
</ul>

which gives flexibility in writing.
This is the third[^example-of-the-third-footnote] example.

  [^footnote]: Typesetting of the footnote depends on the format.
Plain text does nothing, LaTeX removes the
definition and inserts the footnote as part of the LaTeX text.
reStructuredText and Sphinx employ a similar type of typesetting
as Extended Markdown and DocOnce, and in HTML we keep the same
syntax, just displayed properly in HTML.
[^math1]: Math footnotes can be dangerous since it
interferes with an exponent.
[^code]: One-line footnote.

[^google-search]: google.com is perhaps the most famous
web site today.

Here is some more text before a new definition of a footnote that was
used above.


{{mbox
| type = notice
| textstyle = font-size: 90%;
| text = '''Non-breaking space character.''' This paragraph aims to test [https://en.wikipedia.org/wiki/Non-breaking_space non-breaking space character], and a typical
example where this is needed is in physical units: 7.4&nbsp;km is traveled
in&nbsp;<math>7.4/5.5\approx 1.345</math>&nbsp;s.  Also check that a~[https://google.com link]~is
not broken across lines (drag the browser window to test this).
(On the other hand, the tilde is used in
computer code, e.g., as in <code>[~x for x in y]</code> or in <code>y=~x</code>, and should
of course remain a tilde in those contexts.)
}}



==== Subsection 2: Testing figures ====

Test of figures. In particular we refer to Figure fig:impact in which
there is a flow.

[[File:Wave1D.png|frame|200px|alt=Wave1D.png|Visualization '''of''' a ''wave''. (fig:impact)]] <!-- not yet uploaded to common.wikimedia.org -->

Figures without captions are allowed and will be inlined.

[[File:Wave1D.png|frame|200px|alt=Wave1D.png|<span title=""></span>]] <!-- not yet uploaded to common.wikimedia.org -->

<!-- Test multi-line caption in figure with sidecap=True -->

Here is figure myfig with a long (illegal) multi-line caption
containing inline verbatim text:

[[File:Wave1D.png|frame|500px|alt=Wave1D.png|A long caption spanning several lines and containing verbatim words like <code>my_file_v1</code> and <code>my_file_v2</code> as well as math with subscript as in <math>t_{i+1}</math>. (myfig)]] <!-- not yet uploaded to common.wikimedia.org -->

<!-- Must be a blank line after MOVIE or FIGURE to detect this problem -->

Test URL as figure name:

[[File:f_plot.png|frame|500px|link=https://raw.github.com/doconce/doconce/master/doc/src/blog|alt=f_plot.png|<span title=""></span>]]

<!-- Test wikimedia type of files that otherwise reside in subdirs -->

    [[File:Df plot.png|frame|800px|alt=Df plot.png|This is a wikimedia figure file.]] <!-- user: Hplwp, filename: df_plot.png, timestamp: 2013-01-10T11:37:05Z -->


<!-- Non-uploaded file with no caption -->

[[File:Df2s8765s plot.png|frame|200,px|alt=Df2s8765s plot.png|<span title=""></span>]] <!-- not yet uploaded to common.wikimedia.org -->

''Remark.''
Movies are tested in separate file <code>movies.do.txt</code>.

<!-- Somewhat challenging heading with latex math, \t, \n, ? and parenthesis -->

==== The <math>\theta</math> parameter (not <math>\nabla</math>?) ====

Functions do not always need to be advanced, here is one
involving <math>\theta</math>:
<syntaxhighlight lang="text">
def f(theta):
    return theta**2
</syntaxhighlight>

''More on <math>\theta</math>.''
Here is more text following headline with math.

Newcommands must also be tested in this test report:
<math>\frac{1}{2}</math>, <math>{1/2}</math>, <math>\pmb{x}</math>, <math>\frac{Du}{dt}</math>,
both inline and in block:

:<math>
\begin{align}
\frac{Du}{dt} &= 0\nonumber
\\ 
\frac{1}{2} &= {1/2}\\ 
\frac{1}{2}\pmb{x} &= \pmb{n}
\end{align}
</math>

Or with align with label and numbers:

:<math>
\begin{align}
\frac{Du}{dt} &= 0
\\ 
\frac{1}{2} &= {1/2}\\ 
\frac{1}{2}\pmb{x} &= \pmb{n}
\end{align}
</math>

The labels above are removed in mwiki since mwiki cannot refer to
labels in equations.

<!-- Must test more complicated align and matrix compositions -->
<!-- where DocOnce inserts auto-numbered labels etc. -->

First one numbered (automatically):

:<math>
\begin{align}
\begin{pmatrix}
G_2 + G_3 & -G_3 & -G_2 & 0 \\ 
-G_3 & G_3 + G_4 & 0 & -G_4 \\ 
-G_2 & 0 & G_1 + G_2 & 0 \\ 
0 & -G_4 & 0 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2 \\ 
 v_3 \\ 
 v_4
\end{pmatrix}
+ \cdots \\ 
\begin{pmatrix}
 C_5 + C_6 & -C_6 & 0 & 0 \\ 
 -C_6 & C_6 & 0 & 0 \\ 
 0 & 0 & 0 & 0 \\ 
 0 & 0 & 0 & 0
\end{pmatrix}
  &= \frac{d}{dt}\begin{pmatrix}
 v_1 \\ 
 v_2 \\ 
 v_3 \\ 
 v_4
\end{pmatrix} +
\begin{pmatrix}
 0 \\ 
 0 \\ 
 0 \\ 
 -i_0
\end{pmatrix}
\nonumber
\end{align}
</math>

Second numbered (automatically):

:<math>
\begin{align}
\begin{pmatrix}
G_1 + G_2\\ 
-G_3 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2
\end{pmatrix}
+ \cdots\nonumber
\\ 
\left(\begin{array}{ll}
y & 2\\ 
2 & 1
\end{array}\right)
\left(\begin{array}{ll}
0 \\ x
\end{array}\right)
&= \begin{pmatrix}
A \\ B
\end{pmatrix}
\end{align}
</math>

Both numbered, with label by the user:

:<math>
\begin{align}
\begin{pmatrix}
G_1 + G_2\\ 
-G_3 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2
\end{pmatrix}
+ \cdots \\ 
\left(\begin{array}{ll}
y & 2\\ 
2 & 1
\end{array}\right)
\left(\begin{array}{ll}
0 \\ x
\end{array}\right)
&= \begin{pmatrix}
A \\ B
\end{pmatrix}
\end{align}
</math>
Now we refer to Equations (mymatrix:eq1)-(mymatrix:eq2).

==== Custom Environments ====

Here is an attempt to create a theorem environment via Mako
(for counting theorems) and comment lines to help replacing lines in
the <code>.tex</code> by proper begin-end LaTeX environments for theorems.
Should look nice in most formats!

<!-- begin theorem -->

''Theorem 5.''
Let <math>a=1</math> and <math>b=2</math>. Then <math>c=3</math>.
<!-- end theorem -->

<!-- begin proof -->
''Proof.''
Since <math>c=a+b</math>, the result follows from straightforward addition.
<math>\Diamond</math>
<!-- end proof -->

As we see, the proof of Theorem 5 is a modest
achievement.

==== Tables ====

<!-- index with comma could fool sphinx -->

Let us take this table from the manual:

<table border="1">
<thead>
<tr><th align="center">time</th> <th align="center">velocity</th> <th align="center">acceleration</th> </tr>
</thead>
<tbody>
<tr><td align="left">   0.0     </td> <td align="right">   1.4186      </td> <td align="right">   -5.01           </td> </tr>
<tr><td align="left">   2.0     </td> <td align="right">   1.376512    </td> <td align="right">   11.919          </td> </tr>
<tr><td align="left">   4.0     </td> <td align="right">   1.1E+1      </td> <td align="right">   14.717624       </td> </tr>
</tbody>
</table>
The DocOnce source code reads
<syntaxhighlight lang="text">

  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

</syntaxhighlight>

Here is yet another table to test that we can handle more than
one table:

<table border="1">
<thead>
<tr><th align="left">time</th> <th align="left">velocity</th> <th align="left">acceleration</th> </tr>
</thead>
<tbody>
<tr><td align="left">   0.0     </td> <td align="left">   1.4186      </td> <td align="left">   -5.01           </td> </tr>
<tr><td align="left">   1.0     </td> <td align="left">   1.376512    </td> <td align="left">   11.919          </td> </tr>
<tr><td align="left">   3.0     </td> <td align="left">   1.1E+1      </td> <td align="left">   14.717624       </td> </tr>
</tbody>
</table>
And one with math headings (that are expanded and must be treated
accordingly), verbatim heading and entry, and no space around the pipe
symbol:

<table border="1">
<thead>
<tr><th align="center"><math>i</math></th> <th align="center"><math>h_i</math></th> <th align="center"><math>\bar T_i</math></th> <td align="center"><code>L_i</code></td> </tr>
</thead>
<tbody>
<tr><td align="left">   0                 </td> <td align="right">   0                   </td> <td align="right">   288                      </td> <td align="right">   -0.0065             </td> </tr>
<tr><td align="left">   1                 </td> <td align="right">   11,000              </td> <td align="right">   216                      </td> <td align="right">   0.0                 </td> </tr>
<tr><td align="left">   2                 </td> <td align="right">   20,000              </td> <td align="right">   216                      </td> <td align="right">   0.001               </td> </tr>
<tr><td align="left">   3                 </td> <td align="right">   32,000              </td> <td align="right">   228                      </td> <td align="right">   0.0028              </td> </tr>
<tr><td align="left">   4                 </td> <td align="right">   47,000              </td> <td align="right">   270                      </td> <td align="right">   0.0                 </td> </tr>
<tr><td align="left">   5                 </td> <td align="right">   51,000              </td> <td align="right">   270                      </td> <td align="right">   -0.0028             </td> </tr>
<tr><td align="left">   6                 </td> <td align="right">   71,000              </td> <td align="right">   214                      </td> <td align="right">   <code>NaN</code>    </td> </tr>
</tbody>
</table>
And add one with verbatim headings (with underscores),
and rows starting with <code>|-</code> because of a negative number,
and <code>|</code> right before and after verbatim word (with no space):

<table border="1">
<thead>
<tr><th align="center">exact</th> <td align="center"><code>v_1</code></td> <td align="center"><math>a_i</math> + <code>v_2</code></td> <td align="center"><code>verb_3_</code></td> </tr>
</thead>
<tbody>
<tr><td align="right">   9        </td> <td align="right">   9.62                </td> <td align="right">   5.57                                   </td> <td align="right">   8.98                    </td> </tr>
<tr><td align="right">   -20      </td> <td align="right">   -23.39              </td> <td align="right">   -7.65                                  </td> <td align="right">   -19.93                  </td> </tr>
<tr><td align="right">   10       </td> <td align="right">   17.74               </td> <td align="right">   -4.50                                  </td> <td align="right">   9.96                    </td> </tr>
<tr><td align="right">   0        </td> <td align="right">   -9.19               </td> <td align="right">   4.13                                   </td> <td align="right">   -0.26                   </td> </tr>
</tbody>
</table>
Pipe symbols in verbatim and math text in tables used to pose difficulties,
but not
anymore:

<table border="1">
<thead>
<tr><th align="center">   <math>S</math>   </th> <th align="center">        command         </th> </tr>
</thead>
<tbody>
<tr><td align="left">   $ ||a_0|| $             </td> <td align="right">   <code>norm|length</code>    </td> </tr>
<tr><td align="left">   <math>x\cap y</math>    </td> <td align="right">   <code>x|y</code>            </td> </tr>
</tbody>
</table>
Here is a table with X alignment:

<table border="1">
<thead>
<tr><th align="center"> Type</th> <th align="center">                                                                                                                Description                                                                                                                 </th> </tr>
</thead>
<tbody>
<tr><td align="center">   X        </td> <td align="left">   Alignment character that is used for specifying a potentially very long text in a column in a table. It makes use of the <code>tabularx</code> package in LaTeX, otherwise (for other formats) it means <code>l</code> (centered alignment).    </td> </tr>
<tr><td align="center">   l,r,c    </td> <td align="left">   standard alignment characters                                                                                                                                                                                                                   </td> </tr>
</tbody>
</table>
Finally, a table with math
and URLs.

<!-- Mako code to expand URLs in the table -->
<!-- (These types of tables did not work before Jan 2014) -->

<table border="1">
<tr></tr>
<tbody>
<tr><td align="center">   <math>\mathcal{L}=0</math>            </td> <td align="center">   [../doc/src/manual/mov/wave_frames/frame_0080.png <code>080</code>]    </td> <td align="center">   [../doc/src/manual/mov/wave_frames/frame_0085.png <code>085</code>]    </td> </tr>
<tr><td align="center">   <math>a=b</math>                      </td> <td align="center">   [../doc/src/manual/mov/wave_frames/frame_0090.png <code>090</code>]    </td> <td align="center">   [../doc/src/manual/mov/wave_frames/frame_0095.png <code>095</code>]    </td> </tr>
<tr><td align="center">   <math>\nabla\cdot\bm{u} =0 </math>    </td> <td align="center">   [../doc/src/manual/mov/wave_frames/frame_0100.png <code>100</code>]    </td> <td align="center">   [../doc/src/manual/mov/wave_frames/frame_0105.png <code>105</code>]    </td> </tr>
</tbody>
</table>
==== A test of verbatim words in heading with subscript <math>a_i</math>: <code>my_file_v1</code> and <code>my_file_v2</code> ====

''Paragraph with verbatim and math: <code>my_file_v1.py</code> and <code>my_file_v2.py</code> define some math <math>a_{i-1}</math>.''
Here is more <code>__verbatim__</code> code and
some plain text on a new line.

<!-- Test various types of headlines -->
==== '''Just bold''' ====

Some text.

==== ''Just emphasize'' ====

Some text.

==== <code>Just verbatim</code> ====

Some text.

==== '''Bold''' beginning ====

Some text.

==== ''Emphasize'' beginning ====

Some text.

==== <code>Verbatim</code> beginning ====

Some text.

==== Maybe '''bold end''' ====

Some text.

==== Maybe ''emphasize end'' ====

Some text.

==== Maybe <code>verbatim end</code> ====

Some text.

==== The middle has '''bold''' word ====

Some text.

==== The middle has ''emphasize'' word ====

Some text.

==== The middle has <code>verbatim</code> word ====

Some text.

''''Just emphasize''.''
Some text.

''<code>Just verbatim</code>.''
Some text.

''''Emphasize'' beginning.''
Some text.

''<code>Verbatim beginning</code>.''
Some text.

''Maybe ''emphasize end''.''
Some text.

''Maybe <code>verbatim end</code>.''
Some text.

''The middle has ''emphasize'' word.''
Some text.

''The middle has <code>verbatim</code> word.''
Some text.

''Ampersand.''
We can test Hennes & Mauritz, often abbreviated H&M, but written
as <code>Hennes & Mauritz</code> and <code>H & M</code>.
A sole <code>&</code> must also work.
<!-- Note: substitutions must not occur inside verbatim, just in ordinary text. -->

<syntaxhighlight lang="text">
# Just to check that ampersand works in code blocks:
c = a & b
</syntaxhighlight>

''Quotes.''
Let us also add a test of quotes such as "double quotes, with numbers
like 3.14 and newline/comma and hyphen (as in double-quote)"; written
in the standard LaTeX-style that gives correct LaTeX formatting and
ordinary double quotes for all non-LaTeX formats.  Here is another
sentence that "caused" a bug in the past because double backtick
quotes could imply verbatim text up to a verbatim word starting with
period, like <code>.txt</code>.

More quotes to be tested for spellcheck:
("with parenthesis"), "with newline"
and "with comma", "hyphen"-wise, and "period".

==== Bibliography test ====

Here is an example: [1] discussed propagation of
large destructive water waves, [2] gave
an overview of numerical methods for solving the Navier - Stokes equations,
while the use of Backward Kolmogorov equations for analyzing
random vibrations was investigated in [3].
The book chapter [4] contains information on
C++ software tools for programming multigrid methods. A real retro
reference is [5] about a big FORTRAN package.
Multiple references are also possible, e.g., see
[1] [4].

We need to cite more than 10 papers to reproduce an old formatting
problem with blanks in the keys in reST format:
[6] [3] [7] [1]
and
[2] [8] [9] [10] [11] [12] [13]
and all the work of
[14] [4] [15] as well as
old work [5] and [16], and the
talk [17].
Langtangen also had two thesis [18] [16]
back in the days.
More retro citations are
the old ME-IN323 book [19] and the
[20] OONSKI '94 paper.

<!-- --- begin exercise --- -->

==== Example 1: Examples can be typeset as exercises ====

Examples can start with a subsection heading starting with <code>Example:</code>
and then, with the command-line option <code>--examples_as_exercises</code> be
typeset as exercises. This is useful if one has solution
environments as part of the example.

''a)''
State some problem.

''Solution.''
The answer to this subproblem can be written here.

''b)''
State some other problem.

''Hint 1.''
A hint can be given.

''Hint 2.''
Maybe even another hint?

''Solution.''
The answer to this other subproblem goes here,
maybe over multiple doconce input lines.

<!-- --- end exercise --- -->

==== User-defined environments ====

The example in the section [#Example_1:_A_test_function] demonstrates how to write a test function.
That is, a special test function for a function <code>add</code> appears in
the example in the section [#Example_1:_A_test_function].

==== Example 1: A test function ====

Suppose we want to write a test function for checking the
implementation of a Python function for addition.

<syntaxhighlight lang="python">
def add(a, b):
    return a + b

def test_add():
    a = 1; b = 1
    expected = a + b
    computed = add(a, b)
    assert expected == computed
</syntaxhighlight>

==== Example 2: Addition ====

We have

:<math>
 1 + 1 = 2 
</math>
or in tabular form:

<table border="1">
<thead>
<tr><th align="center">    Problem     </th> <th align="center">    Result    </th> </tr>
</thead>
<tbody>
<tr><td align="center">   <math>1+1</math>    </td> <td align="center">   <math>2</math>    </td> </tr>
</tbody>
</table>

{{mbox
| type = notice
| textstyle = font-size: 90%;
| text = '''Highlight box!''' This environment is used to highlight something:

:<math>
 E = mc^2 
</math>
}}



==== URLs ====

Testing of URLs: hpl's home page [https://folk.uio.no/hpl hpl], or
the entire URL if desired, https://folk.uio.no/hpl.  Here is a
plain file link testdoc.do.txt, or testdoc.do.txt, or
testdoc.do.txt or testdoc.do.txt or [testdoc.do.txt a link with
newline]. Can test spaces with the link with word
too: [https://folk.uio.no/hpl hpl] or [https://folk.uio.no/hpl hpl]. Also <code>file:///</code> works: [file:///home/hpl/vc/doconce/doc/demos/manual/manual.html link to a
file] is
fine to have. Moreover, "loose" URLs work, i.e., no quotes, just
the plain URL as in https://folk.uio.no/hpl, if followed by space, comma,
colon, semi-colon, question mark, exclamation mark, but not a period
(which gets confused with the periods inside the URL).

Mail addresses can also be used: [mailto:hpl@simula.no <code>hpl@simula.no</code>], or just a [mailto:hpl@simula.no mail link], or a raw mailto:hpl@simula.no.

Here are some tough tests of URLs, especially for the <code>latex</code> format:
[https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas Newton-Cotes] formulas
and a [https://www.springer.com/mathematics/computational+science+%26+engineering/book/978-3-642-23098-1 good book]. Need to test
Newton-Cotes with percentage in URL too:
https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas
and https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae which has a shebang.

For the <code>--device=paper</code> option it is important to test that URLs with
monospace font link text get a footnote
(unless the <code>--latex_no_program_footnotelink</code>
is used), as in this reference to
[https://github.com/hplgit/INF5620/tree/gh-pages/src/decay/experiments/decay_mod.py <code>decay_mod</code>], [https://tinyurl.com/pwyasaa/formulas.ball1.py <code>ball1.py</code>],
and [https://tinyurl.com/pwyasaa/formulas.ball2.py <code>ball2.py</code>].

<!-- Comments should be inserted outside paragraphs (because in the rst -->
<!-- format extra blanks make a paragraph break). -->

<!-- Note that when there is no https: or file:, it can be a file link -->
<!-- if the link name is URL, url, "URL", or "url". Such files should, -->
<!-- if rst output is desired, but placed in a <code>_static*</code> folder. -->

More tough tests: repeated URLs whose footnotes when using the
<code>--device=paper</code> option must be correct. We have
[https://google.com google], [https://google.com google], and
[https://google.com google], which should result in exactly three
footnotes.

<!-- !split and check if these extra words are included properly in the comment -->

== LaTeX Mathematics ==

Here is an equation without label using backslash-bracket environment:
:<math>
 a = b + c 
</math>

or with number and label, as in Equation (my:eq1), using the equation environment:

:<math>
{\partial u\over\partial t} = \nabla^2 u </math>

We can refer to this equation by Equation (my:eq1).

Here is a system without equation numbers, using the align-asterisk environment:

:<math>
\begin{align*}
\pmb{a} &= \pmb{q}\times\pmb{n} \\ 
b &= \nabla^2 u + \nabla^4 v
\end{align*}
</math>

More mathematical typesetting is demonstrated in the coming exercises.

Below, we have [#Problem_2:_Flip_a_Coin] and [#Project_4:_Compute_a_Probability],
as well as [#Project_5:_Explore_Distributions_of_Random_Circles] and [#Project_11:_References_to_Project_demo:ex:2_in_a_heading_works_for_mwiki], and in
between there we have [#Exercise_10:_Make_references_to_projects_and_problems].

== Exercises ==

<!-- --- begin exercise --- -->

==== Problem 2: Flip a Coin ====

<!-- keywords = random numbers; Monte Carlo simulation; ipynb -->

<!-- Torture tests -->

''a)''
Make a program that simulates flipping a coin <math>N</math> times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

<!-- --- begin hint in exercise --- -->

''Hint 1.''
Use <code>r = random.random()</code> and define head as <code>r <= 0.5</code>.

<!-- --- end hint in exercise --- -->

<!-- --- begin hint in exercise --- -->

''Hint 2.''
Draw an integer among <math>\{1,2\}</math> with
<code>r = random.randint(1,2)</code> and define head when <code>r</code> is 1.

<!-- --- end hint in exercise --- -->

<!-- --- begin answer of exercise --- -->
''Answer.''
If the <code>random.random()</code> function returns a number <math><1/2</math>, let it be
head, otherwise tail. Repeat this <math>N</math> number of times.
<!-- --- end answer of exercise --- -->

<!-- --- begin solution of exercise --- -->
''Solution.''
<syntaxhighlight lang="python">
import sys, random
N = int(sys.argv[1])
heads = 0
for i in range(N):
    r = random.random()
    if r <= 0.5:
        heads += 1
print('Flipping a coin %d times gave %d heads' % (N, heads))
</syntaxhighlight>
<!-- --- end solution of exercise --- -->

''b)''
Vectorize the code in a) using boolean indexing.

Vectorized code can be written in many ways.
Sometimes the code is less intuitive, sometimes not.
At least there is not much to find in the section [#Section_1].

''c)''
Vectorize the code in a) using <code>numpy.sum</code>.

<!-- --- begin answer of exercise --- -->
''Answer.''
<code>np.sum(np.where(r <= 0.5, 1, 0))</code> or <code>np.sum(r <= 0.5)</code>.
<!-- --- end answer of exercise --- -->

In this latter subexercise, we have an
example where the code is easy to read.

==== My remarks ====

Remarks with such a subsubsection is treated as more text
after the last subexercise. Test a list too:


<ol>
<li> Mark 1.
<li> Mark 2.
</ol>

Filenames: <code>flip_coin.py</code>, <code>flip_coin.pdf</code>.

<!-- Closing remarks for this Problem -->

==== Remarks ====

These are the exercise remarks, appearing at the very end.

<!-- solution files: mysol.txt, mysol_flip_coin.py, yet_another.file -->

<!-- --- end exercise --- -->

==== Not an exercise ====

Should be possible to stick a normal section in the middle of many
exercises.

<!-- --- begin exercise --- -->

==== Exercise 3: Test of plain text exercise ====

Very short exercise. What is the capital
of Norway?
Filename: <code>myexer1</code>.

<!-- --- end exercise --- -->

<!-- --- begin exercise --- -->

==== Project 4: Compute a Probability ====

<!-- Minimalistic exercise -->

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval <math>[0,1)</math>?

At the end we have a list because that caused problems in LaTeX
in previous DocOnce versions:


<ol>
<li> item1
<li> item2
</ol>

<!-- --- begin hint in exercise --- -->

''Hint.''
To answer this question empirically, let a program
draw <math>N</math> such random numbers using Python's standard <code>random</code> module,
count how many of them, <math>M</math>, that fall in the interval <math>(0.5,0.6)</math>, and
compute the probability as <math>M/N</math>.

<!-- --- end hint in exercise --- -->

<!-- --- end exercise --- -->

<!-- --- begin exercise --- -->

==== Project 5: Explore Distributions of Random Circles ====

<!-- keywords = ipynb -->

The formula for a circle is given by

:<math>
\begin{align}
x &= x_0 + R\cos 2\pi t,
\\ 
y &= y_0 + R\sin 2\pi t,
\end{align}
</math>
where <math>R</math> is the radius of the circle, <math>(x_0,y_0)</math> is the
center point, and <math>t</math> is a parameter in the unit interval <math>[0,1]</math>.
For any <math>t</math>, <math>(x,y)</math> computed from Equations (circle:x)-(circle:y)
is a point on the circle.
The formula can be used to generate <code>n</code> points on a circle:

<syntaxhighlight lang="python">
import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y

x, y = circle(2.0, 0, 0)
</syntaxhighlight>

<!-- Often in an exercise we have some comments about the solution -->
<!-- which we normally want to keep where they are. -->

The goal of this project is to draw <math>N</math> circles with random
center and radius. Plot each circle using the <code>circle</code> function
above.

''a)''
Let <math>R</math> be normally distributed and <math>(x_0,y_0)</math> uniformly distributed.

<!-- --- begin hint in exercise --- -->

''Hint.''
Use the <code>numpy.random</code> module to draw the
<math>x_0</math>, <math>y_0</math>, and <math>R</math> quantities.

<!-- --- end hint in exercise --- -->

<!-- --- begin answer of exercise --- -->
''Answer.''
Here goes the short answer to part a).
<!-- --- end answer of exercise --- -->

<!-- --- begin solution of exercise --- -->
''Solution.''
Here goes a full solution to part a).
<!-- --- end solution of exercise --- -->

''b)''
Let <math>R</math> be uniformly distributed and <math>(x_0,y_0)</math> normally distributed.
Filename: <code>norm</code>.

''c)''
Let <math>R</math> and <math>(x_0,y_0)</math> be normally distributed.

Filename: <code>circles</code>.

<!-- Closing remarks for this Project -->

==== Remarks ====

At the very end of the exercise it may be appropriate to summarize
and give some perspectives.

<!-- --- end exercise --- -->

<!-- --- begin exercise --- -->

==== Exercise 6: Determine some Distance ====

Intro to this exercise. Questions are in subexercises below.

<!-- --- begin solution of exercise --- -->
''Solution.''
Here goes a full solution of the whole exercise.
With some math <math>a=b</math> in this solution:
:<math>
 \hbox{math in solution: } a = b 
</math>
And code <code>a=b</code> in this solution:
<syntaxhighlight lang="text">
a = b  # code in solution
</syntaxhighlight>
End of solution is here.

<!-- --- end solution of exercise --- -->

''a)''
Subexercises are numbered a), b), etc.

<!-- --- begin hint in exercise --- -->

''Hint 1.''
First hint to subexercise a).
With math <math>a=b</math> in hint:

:<math>
 a=b. 
</math>
And with code (in plain verbatim) returning <math>x+1</math> in hint:

<syntaxhighlight lang="text">
def func(x):
    return x + 1  # with code in hint
</syntaxhighlight>

<!-- --- end hint in exercise --- -->

<!-- --- begin hint in exercise --- -->

''Hint 2.''
Second hint to subexercise a).

Test list in hint:


<ol>
<li> item1
<li> item2
</ol>

<!-- --- end hint in exercise --- -->
Filename: <code>subexer_a.pdf</code>.

<!-- --- begin answer of exercise --- -->
''Answer.''
Short answer to subexercise a).
With math in answer: <math>a=b</math>.
<!-- --- end answer of exercise --- -->

''b)''
Here goes the text for subexercise b).

Some math <math>\cos^2 x + \sin^2 x = 1</math> written one a single line:

:<math>
 \cos^2 x + \sin^2 x = 1 \thinspace .
</math>

<!-- --- begin hint in exercise --- -->

''Hint.''
A hint for this subexercise.

<!-- --- end hint in exercise --- -->
Filename: <code>subexer_b.pdf</code>.

<!-- --- begin solution of exercise --- -->
''Solution.''
Here goes the solution of this subexercise.
<!-- --- end solution of exercise --- -->

<!-- No meaning in this weired test example: -->
The text here belongs to the main (intro) part of the exercise. Need
closing remarks to have text after subexercises.

Test list in exercise:


<ol>
<li> item1
<li> item2
<!-- Closing remarks for this Exercise -->
</ol>

==== Remarks ====

Some final closing remarks, e.g., summarizing the main findings
and their implications in other problems can be made. These
remarks will appear at the end of the typeset exercise.

<!-- --- end exercise --- -->

<!-- --- begin exercise --- -->

==== Some exercise without the "Exercise:" prefix ====

<!-- Another minimalistic exercise -->

Just some text. And some math saying that <math>e^0=1</math> on a single line,
to test that math block insertion is correct:

:<math>
 \exp{(0)} = 1 
</math>

And a test that the code <code>lambda x: x+2</code> is correctly placed here:

<syntaxhighlight lang="text">
lambda x: x+2
</syntaxhighlight>

<!-- Have some comments at the end of the exercise to see that -->
<!-- the Filename: ... is written correctly. -->
<!-- --- end exercise --- -->

<!-- --- begin exercise --- -->

==== Exercise 8: Solution of differential equation ====



Given

:<math>
 \frac{dy}{dx} = -y(x),\quad y(0)=1 
</math>
What is the solution of this equation?

Choice A: <math>y=e^{-y}</math>

Choice B: <math>y=e^{y}</math>

Choice C: <syntaxhighlight lang="python">
from math import exp
def f(x):
    return exp(x)
</syntaxhighlight>

Choice D: The solution cannot be found because there is a derivative in the equation.

Choice E: The equation is meaningless: an equation must be an equation
for <math>x</math> or <math>y</math>, not a function <math>y(x)</math>.



<!-- --- end exercise --- -->

<!-- --- begin exercise --- -->

==== Example 9: Just an example ====

<!-- This example needs the --examples_as_exercises option, otherwise -->
<!-- it is just typeset as it is written. -->

''a)''
What is the capital of Norway?

''Answer.''
Oslo.

<!-- --- end exercise --- -->

== Here goes another section ==

With some text, before we continue with exercises.

== More Exercises ==

<!-- --- begin exercise --- -->

==== Exercise 10: Make references to projects and problems ====

<!-- Test comments not at the end only -->
Pick a statement from [#Project_5:_Explore_Distributions_of_Random_Circles] or [#Problem_2:_Flip_a_Coin]
and verify it.

Test list at the end of an exercise without other elements (like subexercise,
hint, etc.):


<ol>
<li> item1
<li> item2
</ol>

Filename: <code>verify_formula.py</code>.

<!-- --- end exercise --- -->

<!-- --- begin exercise --- -->

==== Project 11: References to [#Project_4:_Compute_a_Probability] in a heading works for mwiki ====

Refer to the previous exercise as [#Exercise_10:_Make_references_to_projects_and_problems],
the two before that as [#Project_4:_Compute_a_Probability] and [#Project_5:_Explore_Distributions_of_Random_Circles],
and this one as [#Project_11:_References_to_Project_demo:ex:2_in_a_heading_works_for_mwiki].
Filename: <code>selc_composed.pdf</code>.

<!-- --- end exercise --- -->

== References ==


<ol>
 <li> '''H. P. Langtangen and G. Pedersen'''. 
    Propagation of Large Destructive Waves,
    ''International Journal of Applied Mechanics and Engineering'',
    7(1),
    pp. 187-204,
    2002.
 <li> '''H. P. Langtangen, K.-A. Mardal and R. Winther'''. 
    Numerical Methods for Incompressible Viscous Flow,
    ''Advances in Water Resources'',
    25,
    pp. 1125-1146,
    2002.
 <li> '''H. P. Langtangen'''. 
    Numerical Solution of First Passage Problems in Random Vibrations,
    ''SIAM Journal of Scientific and Statistical Computing'',
    15,
    pp. 997-996,
    1994.
 <li> '''K.-A. Mardal, G. W. Zumbusch and H. P. Langtangen'''. 
    Software Tools for Multigrid Methods,
    ''Advanced Topics in Computational Partial Differential Equations -- Numerical Methods and Diffpack Programming'',
    edited by '''H. P. Langtangen and A. Tveito''',
    Springer,
    2003,
    Edited book,
    http://some.where.org.
 <li> '''H. P. Langtangen'''. 
    The FEMDEQS Program System,
    ''Department of Mathematics, University of Oslo'',
    1989,
    http://www.math.uio.no/old/days/hpl/femdeqs.pdf.
 <li> '''H. P. Langtangen'''. 
    Stochastic Breakthrough Time Analysis of an Enhanced Oil Recovery Process,
    ''SIAM Journal on Scientific Computing'',
    13,
    pp. 1394-1417,
    1992.
 <li> '''M. Mortensen, H. P. Langtangen and G. N. Wells'''. 
    A FEniCS-Based Programming Framework for Modeling Turbulent Flow by the Reynolds-Averaged Navier-Stokes Equations,
    ''Advances in Water Resources'',
    34(9),
    [https://dx.doi.org/10.1016/j.advwatres.2011.02.013 doi: 10.1016/j.advwatres.2011.02.013],
    2011.
 <li> '''S. Glimsdal, G. Pedersen, K. Atakan, C. B. Harbitz, H. P. Langtangen and F. L\ovholt'''. 
    Propagation of the Dec.&nbsp;26, 2004 Indian Ocean Tsunami: Effects of Dispersion and Source Characteristics,
    ''International Journal of Fluid Mechanics Research'',
    33(1),
    pp. 15-43,
    2006.
 <li> '''S. Rahman, J. Gorman, C. H. W. Barnes, D. A. Williams and H. P. Langtangen'''. 
    Numerical Investigation of a Piezoelectric Surface Acoustic Wave Interaction With a One-Dimensional Channel,
    ''Physical Review B: Condensed Matter and Materials Physics'',
    74,
    2006,
    035308.
<li> '''J. B. Haga, H. Osnes and H. P. Langtangen'''. 
    On the Causes of Pressure Oscillations in Low-Permeable and Low-Compressible Porous Media,
    ''International Journal of Analytical and Numerical Methods in Geomechanics'',
    [https://dx.doi.org/10.1002/nag.1062 doi: 10.1002/nag.1062],
    2011,
    http://onlinelibrary.wiley.com/doi/10.1002/nag.1062/abstract.
<li> '''H. P. Langtangen'''. 
    ''Computational Partial Differential Equations - Numerical Methods and Diffpack Programming'',
    second edition,
    ''Texts in Computational Science and Engineering'',
    Springer,
    2003.
<li> '''H. P. Langtangen'''. 
    ''Python Scripting for Computational Science'',
    third edition,
    ''Texts in Computational Science and Engineering'',
    Springer,
    2008.
<li> '''H. P. Langtangen and G. Pedersen'''. 
    Finite Elements for the Boussinesq Wave Equations,
    Waves and Non-linear Processes in Hydrodynamics,
    edited by '''J. Grue, B. Gjevik and J. E. Weber''',
    Kluwer Academic Publishers,
    pp. pp. 117-126,
    1995,
    http://www.amazon.ca/Waves-Nonlinear-Processes-Hydrodynamics-John/dp/0792340310.
<li> '''H. P. Langtangen'''. 
    ''A Primer on Scientific Programming With Python'',
    third edition,
    ''Texts in Computational Science and Engineering'',
    Springer,
    2012.
<li> '''P. V. Jeberg, H. P. Langtangen and C. B. Terp'''. 
    Optimization With Diffpack: Practical Example From Welding,
    ''Simula Research Laboratory'',
    2004,
    Internal report.
<li> '''H. P. Langtangen'''. 
    Computational Methods for Two-Phase Flow in Oil Reservoirs,
    Ph.D. Thesis,
    Mechanics Division, Department of Mathematics, University of Oslo,
    1989,
    Dr.&nbsp;Scient.&nbsp;thesis..
<li> '''H. P. Langtangen'''. 
    Computational Modeling of Huge Tsunamis From Asteroid Impacts,
    2007,
    Invited keynote lecture at the \emphInternational conference on Computational Science 2007 (ICCS'07), Beijing, China.
<li> '''H. P. Langtangen'''. 
    Solution of the Navier-Stokes Equations With the Finite Element Method in Two and Three Dimensions,
    M.Sc. Thesis,
    Mechanics Division, Department of Mathematics, University of Oslo,
    1985,
    Cand.Scient. thesis.
<li> '''H. P. Langtangen and A. Tveito'''. 
    Numerical Methods in Continuum Mechanics,
    ''Center for Industrial Research'',
    1991,
    Lecture notes for a course (ME-IN 324). 286 pages..
<li> '''H. P. Langtangen'''. 
    Diffpack: Software for Partial Differential Equations,
    ''Proceedings of the Second Annual Object-Oriented Numerics Conference (OON-SKI'94), Sunriver, Oregon, USA'',
    edited by '''A. Vermeulen''',
    1994.
</ol>

== Appendix: Just for testing; part I ==

This is the first appendix.

==== A subsection within an appendix ====

Some text.

== Appendix: Just for testing; part II ==

This is more stuff for an appendix.

==== Appendix: Testing identical titles ====

Without label.

==== Appendix: Testing identical titles ====

With label.

==== Appendix: Testing identical titles ====

What about inserting a quiz?



======= Test of quizzes =======


Fundamental test: What is the capital of Norway?

Answer 1: Stockholm

Answer 2: London

Answer 3: Oslo

Choice D: Bergen



==== Appendix: Testing identical titles ====

Without label.


{{mbox
| type = notice
| textstyle = font-size: 90%;
| text = '''Tip.''' Here is a tip or hint box, typeset as a notice box.
}}



Need a lot of text to surround the summary box.
Version control systems allow you to record the history of files
and share files among several computers and collaborators in a
professional way. File changes on one computer are updated or
merged with changes on another computer. Especially when working
with programs or technical reports it is essential
to have changes documented and to
ensure that every computer and person involved in the project
have the latest updates of the files.
Greg Wilson' excellent [https://software-carpentry.org/2010/07/script-for-introduction-to-version-control/ Script for Introduction to Version Control] provides a more detailed motivation why you will benefit greatly
from using version control systems.


{{mbox
| type = Summary.
| textstyle = font-size: 90%;
| text = '''Summary.''' '''Bold remark:''' Make some text with this summary.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
}}



Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that site. I strongly
recommend you to use such sites for all serious programming and
scientific writing work - and all other important files.

The simplest services for hosting project files are [https://dropbox.com Dropbox] and [https://drive.google.com Google Drive].
It is very easy to get started with these systems, and they allow you
to share files among laptops and mobile units with as many users as
you want. The systems offer a kind of version control in that the
files are stored frequently (several times per minute), and you can go
back to previous versions for the last 30 days. However, it is
challenging  to find the right version from the past when there are
so many of them.

More seriously, when several people may edit files simultaneously, it
can be difficult detect who did what when, roll back to previous
versions, and to manually merge the edits when these are
incompatible. Then one needs more sophisticated tools than Dropbox or
Google Drive: project hosting services with true version control
systems.  The following text aims at providing you with the minimum
information to started with such systems. Numerous other tutorials
contain more comprehensive material and in-depth explanations of the
concepts and tools.

The idea with project hosting services is that you have the files
associated with a project in the cloud. Many people may share these
files.  Every time you want to work on the project you explicitly
update your version of the files, edit the files as you like, and
synchronize the files with the "master version" at the site where the
project is hosted.  If you at some point need to go back to a
version of the files at some particular point in the past,
this is an easy operation. You can also use tools to see
what various people have done with the files in the various versions.

All these services are very similar. Below we describe how you get
started with Bitbucket, GitHub, and Googlecode. Launchpad works very
similarly to the latter three. All the project hosting services have
excellent introductions available at their web sites, but the recipes
below are much shorter and aim at getting you started as quickly as
possible by concentrating on the most important need-to-know steps.
The Git tutorials we refer to later in this document contain more
detailed information and constitute of course very valuable readings
when you use version control systems every day. The point now is
to get started.

==== Appendix: Testing inline comments ====

<!-- Names can be [ A-Za-z0-9_'+-]+ -->

Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that
site. [hpl's semi opinion 1: not sure if in the cloud is
understood by
all.] I strongly recommend you to use such sites for all serious
programming and scientific writing work - and all other important
files.

The simplest services for hosting project files is Dropbox. [mp 2: Simply go to https://dropbox.com and watch the video. It explains
how files, like <code>myfile.py</code>, perhaps containing much math, like
<math>\partial u/\partial t</math>, are easily communicated between machines.] It
is very easy to get started with Dropbox, and it allows you to share
files among [hpl 3: laptops and mobile units -> computers, tablets,
and phones].

<!-- Test horizontal rule -->

----

<!-- Coments for editing -->

First[add 4: ,] consider a quantity <math>Q</math>. [edit 5: To this end, -> We note that]
<math>Q>0</math>, because [del 6: a] negative [edit 7: quantity is -> quantities
are] [del 8: just] negative. [add 9: This comes as no surprise.]

<!-- Test tailored latex figure references with page number -->
Let us refer to Figure fig:impact again.

Test references in a list:


<ul>
 <li> [#Section_1]
 <li> [#Subsection_1]
 <li> fig:impact
</ul>

==== Appendix: Testing headings ending with <code>verbatim inline</code> ====

The point here is to test 1) <code>verbatim</code> code in headings, and 2)
ending a heading with verbatim code as this triggers a special
case in LaTeX.

We also test mdash---used as alternative to hyphen without spaces around,
or in quotes:


{{quote box
| quote = ''Fun is fun''.---Unknown.
| textstyle = font-size: 90%;
}}



The ndash should also be tested - as in the Hanson - Nilson equations
on page 277 - 278.

And finally, what about admons, quotes, and boxes? They are tested
in a separate document: <code>admon.do.txt</code>.

[^example-of-the-third-footnote]: Not much to add here, but the footnote
is at the end with only one newline.

************** File: testdoc.cwiki *****************
#summary A Document for Testing DocOnce
<wiki:toc max_depth="2" />
By **Hans Petter Langtangen** (hpl at simula.no), **Kaare Dump**, **A. Dummy Author**, **I. S. Overworked and Outburned**, and **J. Doe** (j_doe at cyberspace.com)
=== Jan 32, 2100 ===

Made with DocOnce



<<TableOfContents>>

<wiki:comment> !split </wiki:comment>

The format of this document is
cwiki

//Abstract.// This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.

<wiki:comment> Cannot demonstrate chapter headings since abstract and chapter </wiki:comment>
<wiki:comment> are mutually exclusive in LaTeX </wiki:comment>

= Section 1 =

Here is a nested list:


  * item1
  * item2
  * item3 which continues    on the next line to test that feature
  * and a sublist

    ** with indented subitem1
    //* and a subitem2


  // and perhaps an ordered sublist

   ## first item
   ## second item,      continuing on a new line



//Here is a list with paragraph heading.//


  * item1
  * item2

=== Here is a list with subsubsection heading ===

  * item1
  * item2





Here are two references. Equation (my:eq1) is fine. Eq. (my:eq1) too.
Even Equation (my:eq1) without the tilde.

== Subsection 1 ==

<wiki:comment> Refer to section/appendix etc. at the beginning of the line </wiki:comment>
<wiki:comment> and other special fix situations for HTML. </wiki:comment>

More text, with a reference back to
the section [#Section_1] and [#Subsection_1], and further to the
the sections [#Subsection_1] and [#URLs], which
encourages you to do the tasks in [#Problem_2:_Flip_a_Coin] and [#Exercise_10:_Make_references_to_projects_and_problems].
 [#Appendix:_Just_for_testing;_part_I] and [#Appendix:_Just_for_testing;_part_II] are also nice elements.

=== Test Section reference at beginning of line and after a sentence ===

The section [#Subsection_1] is fine.
The section [#URLs] too.

<wiki:comment> sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console </wiki:comment>

=== Computer code ===

Let's do some copying from files too. First from subroutine up to the very end,

{{{
      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
}}}
and then just the subroutine,
{{{

      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
}}}
and finally the complete file with a plain text verbatim environment
({{{envir=ccq}}}):
{{{
C     a comment

      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
}}}

Testing other code environments. First Python:

{{{
!bc pycod
def f(x):
    return x+1
!ec
}}}
which gets rendered as

{{{
def f(x):
    return x+1
}}}

Test paragraph and subsubsection headings before
before code.

//Paragraph heading before code.//

{{{
import sys
sys.path.insert(0, os.pardir)
}}}

=== Subsubsection heading before code ===

{{{
def h(z):
    return z+1
}}}

Here is a program that is supposed to be interactive via
Python Online Tutorial, but that service is not accessible
for the present format.

{{{
class Line:
    def __init__(self, a, b):
        self.a, self.b = a, b

    def __call__(self, x):
        a, b = self.a, self.b
        return a*x + b

line = Line(2, 1)
y = line(x=3)
print(y)
}}}

Some more Python code (actually specified as a sage cell, but
such cells are not supported by this format).

{{{
a = 2
b = 3
print('a+b:', a + b)

# In a sage cell we can also plot
from matplotlib.pyplot import *
from numpy import *
x = linspace(0, 4*pi, 101)
y = exp(-0.1*x)*cos(x)
plot(x, y)
xlabel('x'); ylabel('y')
show()
}}}

Then Cython (with -h option so it is hidden in html/sphinx):

{{{
cpdef f(double x):
    return x + 1
}}}

Standard Python shell sessions:

{{{
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
}}}

Similar IPython sessions:

{{{
In [1]: from numpy import linspace, sin
In [2]: # Some comment
In [3]: x = linspace(0, 2, 11)
In [4]: y = sin(x)
In [5]: y[0]
Out[5]: 0
In [6]: import matplotlib.pyplot as plt
In [7]: plt.plot(x, y)
In [8]: a='multiple-\nline\noutput'
In [9]: a
Out[9]: 'multiple-\nline\noutput'
In [10]: print(a)
multiple-
line
output
}}}

Here is the interactive session again, but with {{{pyshell-t}}}.

{{{
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
}}}

<wiki:comment> This one tests a + sign before a code environment </wiki:comment>
C++:
{{{
#include <iostream>

int main()
{
   std::cout << "Sample output" << std::endl;
   return 0
}
}}}
<wiki:comment> The next should get correctly typset in sphinx (cod is fcod) </wiki:comment>
<wiki:comment> It also tests emoji before code </wiki:comment>
And a little bit of Fortran: :dizzy_face:

{{{
!bc cod
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
!ec
}}}
which then is typeset as

{{{
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
}}}

HTML:

{{{
<table>
<tr><td>Column 1</td><td>Column 2</td></tr>
<tr><td>0.67526 </td><td>0.92871 </td></tr>
<!-- comment -->
</table>
}}}

But inline HTML code is also important, like text that starts with
{{{<a href="}}} (which can destroy the following text if not properly
quoted).

Matlab with comments requires special typesetting:

{{{
% Comment on the beginning of the line can be escaped by %%
if a > b
  % Indented comment needs this trick
  c = a + b
end
}}}

And here is a system call:

{{{
Terminal> mkdir test
Terminal> cd test
Terminal> myprog -f
output1
output2
}}}

Any valid pygments lexer/language name can appear to, e.g.,

{{{
!bc restructuredtext
=======
Heading
=======

Some text.
!ec
}}}
results in

{{{
=======
Heading
=======

Some text.
}}}

<wiki:comment> Here goes hidden code. </wiki:comment>
<wiki:comment> Python can be treated by some formats, Fortran is always out. </wiki:comment>





Finally, {{{!bc do}}} supports highlighting of DocOnce source:

{{{
======= DocOnce test file =======

===== Computer code =====

Inline verbatim code, as in `import numpy as np`, is allowed, as well as
code blocks:

!bc pycod
from math import sin

def f(x):
    """Example on a function."""
    return sin(x) + 1

print(f(0))
!ec


===== Mathematics =====

Formulas can be inline, as in $\nabla\cdot\bm{u} = 0$, or typeset
as equations:

!bt
\begin{align*}
\nabla\cdot\bm{u} &= 0,\\ 
\bm{u} &= \nabla\phi .
\end{align*}
!et

=== Subsubsection heading ===

DocOnce files can have chapters, sections, subsections, and subsubsections.

__Paragraph heading.__ Paragraphs may have headings.
}}}

It is time to test {{{verbatim inline font}}} especially with {{{a newline
inside the text}}} and an exclamation mark at the end: {{{BEGIN}}}! For
spellcheck, test {{{a verbatim expression}}} in {{{another}}} in a {{{third}}}.
Also test exclamation mark as in {{{!bc}}} and {{{!ec}}} as well as {{{a != b}}}.
Also test backslashes and braces like {{{\begin}}}, {{{\begin{enumerate}}}},
{{{\end{this}\end{that}}}}, and {{{{something \inside braces}}}}.

The following attempt to exemplify colored text does not work in
format cwiki.
Here is some <font color="red">red color</font> and an attempt to write <font color="green">with
green color containing a linebreak<br />
code.</font> Some formats will only display <br />
this correctly when {{{html}}} <br />
is the output format.
But here some more running text is added which is not part of
the previous blocks with line breaks.

=== Running OS commands ===

{{{
Terminal> python -c 'print("Testing\noutput\nfrom\nPython.")'
Testing
output
from
Python.
}}}

=== Footnotes ===

Here is a test of footnotes [^footnote], which are handy in text.
They are used in different flavors, now in


 * list items (note below that footnotes work after math, verbatim, and URLs - bin fact old and emphasize too!)
 * even with math {{{\nabla^2u}}}[^math1]
 * and code {{{h[i] += 1}}}[^code]   (//must// have space between inline code and footnote!)
 * and [[https://google.com|links]][^google-search]

which gives flexibility in writing.
This is the third[^example-of-the-third-footnote] example.

  [^footnote]: Typesetting of the footnote depends on the format.
Plain text does nothing, LaTeX removes the
definition and inserts the footnote as part of the LaTeX text.
reStructuredText and Sphinx employ a similar type of typesetting
as Extended Markdown and DocOnce, and in HTML we keep the same
syntax, just displayed properly in HTML.
[^math1]: Math footnotes can be dangerous since it
interferes with an exponent.
[^code]: One-line footnote.

[^google-search]: [[google.com]] is perhaps the most famous
web site today.

Here is some more text before a new definition of a footnote that was
used above.

//Non-breaking space character.// 
This paragraph aims to test [[https://en.wikipedia.org/wiki/Non-breaking_space|non-breaking space character]], and a typical
example where this is needed is in physical units: 7.4 km is traveled
in {{{7.4/5.5\approx 1.345}}} s.  Also check that a~[[https://google.com|link]]~is
not broken across lines (drag the browser window to test this).
(On the other hand, the tilde is used in
computer code, e.g., as in {{{[~x for x in y]}}} or in {{{y=~x}}}, and should
of course remain a tilde in those contexts.)



== Subsection 2: Testing figures ==

Test of figures. In particular we refer to Figure fig:impact in which
there is a flow.

{{../doc/src/manual/fig/wave1D.png| Visualization **of** a //wave//. (fig:impact)}}

Figures without captions are allowed and will be inlined.

{{../doc/src/manual/fig/wave1D.png|}}

<wiki:comment> Test multi-line caption in figure with sidecap=True </wiki:comment>

Here is figure myfig with a long (illegal) multi-line caption
containing inline verbatim text:

{{../doc/src/manual/fig/wave1D.png| A long caption spanning several lines and containing verbatim words like {{{my_file_v1}}} and {{{my_file_v2}}} as well as math with subscript as in {{{t_{i+1}}}}. (myfig) }}

<wiki:comment> Must be a blank line after MOVIE or FIGURE to detect this problem </wiki:comment>

Test URL as figure name:

{{https://raw.github.com/doconce/doconce/master/doc/src/blog/f_plot.png|}}

<wiki:comment> Test wikimedia type of files that otherwise reside in subdirs </wiki:comment>

//Remark.//
Movies are tested in separate file {{{movies.do.txt}}}.

<wiki:comment> Somewhat challenging heading with latex math, \t, \n, ? and parenthesis </wiki:comment>

== The {{{\theta}}} parameter (not {{{\nabla}}}?) ==

Functions do not always need to be advanced, here is one
involving {{{\theta}}}:
{{{
def f(theta):
    return theta**2
}}}

//More on {{{\theta}}}.// Here is more text following headline with math.

Newcommands must also be tested in this test report:
{{{\frac{1}{2}}}}, {{{{1/2}}}}, {{{\pmb{x}}}}, {{{\frac{Du}{dt}}}},
both inline and in block:

{{{
\begin{align}
\frac{Du}{dt} &= 0\nonumber
\\ 
\frac{1}{2} &= {1/2}\\ 
\frac{1}{2}\pmb{x} &= \pmb{n}
\end{align}
}}}

Or with align with label and numbers:

{{{
\begin{align}
\frac{Du}{dt} &= 0
label{aligneq1}
\\ 
\frac{1}{2} &= {1/2}\\ 
\frac{1}{2}\pmb{x} &= \pmb{n}
label{aligneq2}
\end{align}
}}}

<wiki:comment> Must test more complicated align and matrix compositions </wiki:comment>
<wiki:comment> where DocOnce inserts auto-numbered labels etc. </wiki:comment>

First one numbered (automatically):

{{{
\begin{align}
\begin{pmatrix}
G_2 + G_3 & -G_3 & -G_2 & 0 \\ 
-G_3 & G_3 + G_4 & 0 & -G_4 \\ 
-G_2 & 0 & G_1 + G_2 & 0 \\ 
0 & -G_4 & 0 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2 \\ 
 v_3 \\ 
 v_4
\end{pmatrix}
+ \cdots \\ 
\begin{pmatrix}
 C_5 + C_6 & -C_6 & 0 & 0 \\ 
 -C_6 & C_6 & 0 & 0 \\ 
 0 & 0 & 0 & 0 \\ 
 0 & 0 & 0 & 0
\end{pmatrix}
  &= \frac{d}{dt}\begin{pmatrix}
 v_1 \\ 
 v_2 \\ 
 v_3 \\ 
 v_4
\end{pmatrix} +
\begin{pmatrix}
 0 \\ 
 0 \\ 
 0 \\ 
 -i_0
\end{pmatrix}
\nonumber
\end{align}
}}}

Second numbered (automatically):

{{{
\begin{align}
\begin{pmatrix}
G_1 + G_2\\ 
-G_3 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2
\end{pmatrix}
+ \cdots\nonumber
\\ 
\left(\begin{array}{ll}
y & 2\\ 
2 & 1
\end{array}\right)
\left(\begin{array}{ll}
0 \\ x
\end{array}\right)
&= \begin{pmatrix}
A \\ B
\end{pmatrix}
\end{align}
}}}

Both numbered, with label by the user:

{{{
\begin{align}
\begin{pmatrix}
G_1 + G_2\\ 
-G_3 & G_4
\end{pmatrix}
&=
\begin{pmatrix}
 v_1 \\ 
 v_2
\end{pmatrix}
+ \cdots label{mymatrix:eq1}
\\ 
label{mymatrix:eq2}
\left(\begin{array}{ll}
y & 2\\ 
2 & 1
\end{array}\right)
\left(\begin{array}{ll}
0 \\ x
\end{array}\right)
&= \begin{pmatrix}
A \\ B
\end{pmatrix}
\end{align}
}}}
Now we refer to Equations (mymatrix:eq1)-(mymatrix:eq2).

== Custom Environments ==

Here is an attempt to create a theorem environment via Mako
(for counting theorems) and comment lines to help replacing lines in
the {{{.tex}}} by proper begin-end LaTeX environments for theorems.
Should look nice in most formats!

<wiki:comment> begin theorem </wiki:comment>

//Theorem 5.//
Let {{{a=1}}} and {{{b=2}}}. Then {{{c=3}}}.
<wiki:comment> end theorem </wiki:comment>

<wiki:comment> begin proof </wiki:comment>
//Proof.//
Since {{{c=a+b}}}, the result follows from straightforward addition.
END
<wiki:comment> end proof </wiki:comment>

As we see, the proof of Theorem 5 is a modest
achievement.

== Tables ==

<wiki:comment> index with comma could fool sphinx </wiki:comment>

Let us take this table from the manual:


 | =time     | =velocity     | =acceleration     |
 |  0.0      |  1.4186       |  -5.01            |
 |  2.0      |  1.376512     |  11.919           |
 |  4.0      |  1.1E+1       |  14.717624        |


The DocOnce source code reads
{{{

  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

}}}

Here is yet another table to test that we can handle more than
one table:


 | =time     | =velocity     | =acceleration     |
 |  0.0      |  1.4186       |  -5.01            |
 |  1.0      |  1.376512     |  11.919           |
 |  3.0      |  1.1E+1       |  14.717624        |


And one with math headings (that are expanded and must be treated
accordingly), verbatim heading and entry, and no space around the pipe
symbol:


 | ={{{i}}}     | ={{{h_i}}}     | ={{{\bar T_i}}}     | ={{{L_i}}}     |
 |  0           |  0             |  288                |  -0.0065       |
 |  1           |  11,000        |  216                |  0.0           |
 |  2           |  20,000        |  216                |  0.001         |
 |  3           |  32,000        |  228                |  0.0028        |
 |  4           |  47,000        |  270                |  0.0           |
 |  5           |  51,000        |  270                |  -0.0028       |
 |  6           |  71,000        |  214                |  {{{NaN}}}     |


And add one with verbatim headings (with underscores),
and rows starting with {{{|-}}} because of a negative number,
and {{{|}}} right before and after verbatim word (with no space):


 | =exact     | ={{{v_1}}}     | ={{{a_i}}} + {{{v_2}}}     | ={{{verb_3_}}}     |
 |  9         |  9.62          |  5.57                      |  8.98              |
 |  -20       |  -23.39        |  -7.65                     |  -19.93            |
 |  10        |  17.74         |  -4.50                     |  9.96              |
 |  0         |  -9.19         |  4.13                      |  -0.26             |


Pipe symbols in verbatim and math text in tables used to pose difficulties,
but not
anymore:


 | ={{{S}}}           | =command               |
 |  $ ||a_0|| $       |  {{{norm|length}}}     |
 |  {{{x\cap y}}}     |  {{{x|y}}}             |


Here is a table with X alignment:


 | =Type      | =Description                                                                                                                                                                                                                        |
 |  X         |  Alignment character that is used for specifying a potentially very long text in a column in a table. It makes use of the {{{tabularx}}} package in LaTeX, otherwise (for other formats) it means {{{l}}} (centered alignment).     |
 |  l,r,c     |  standard alignment characters                                                                                                                                                                                                      |


Finally, a table with math
and URLs.

<wiki:comment> Mako code to expand URLs in the table </wiki:comment>
<wiki:comment> (These types of tables did not work before Jan 2014) </wiki:comment>


 | =                                | =                                                       | =                |
 |  {{{\mathcal{L}=0}}}             |  [[../doc/src/manual/mov/wave_frames/frame_0080.png     |  {{{080}}}]]     |  [[../doc/src/manual/mov/wave_frames/frame_0085.png     |  {{{085}}}]]     |
 |  {{{a=b}}}                       |  [[../doc/src/manual/mov/wave_frames/frame_0090.png     |  {{{090}}}]]     |  [[../doc/src/manual/mov/wave_frames/frame_0095.png     |  {{{095}}}]]     |
 |  {{{\nabla\cdot\bm{u} =0 }}}     |  [[../doc/src/manual/mov/wave_frames/frame_0100.png     |  {{{100}}}]]     |  [[../doc/src/manual/mov/wave_frames/frame_0105.png     |  {{{105}}}]]     |


== A test of verbatim words in heading with subscript {{{a_i}}}: {{{my_file_v1}}} and {{{my_file_v2}}} ==

//Paragraph with verbatim and math: {{{my_file_v1.py}}} and {{{my_file_v2.py}}} define some math {{{a_{i-1}}}}.// Here is more {{{__verbatim__}}} code and
some plain text on a new line.

<wiki:comment> Test various types of headlines </wiki:comment>
== **Just bold** ==

Some text.

== //Just emphasize// ==

Some text.

== {{{Just verbatim}}} ==

Some text.

== **Bold** beginning ==

Some text.

== //Emphasize// beginning ==

Some text.

== {{{Verbatim}}} beginning ==

Some text.

== Maybe **bold end** ==

Some text.

== Maybe //emphasize end// ==

Some text.

== Maybe {{{verbatim end}}} ==

Some text.

== The middle has **bold** word ==

Some text.

== The middle has //emphasize// word ==

Some text.

== The middle has {{{verbatim}}} word ==

Some text.

////Just emphasize//.// Some text.

//{{{Just verbatim}}}.// Some text.

////Emphasize// beginning.// Some text.

//{{{Verbatim beginning}}}.// Some text.

//Maybe //emphasize end//.// Some text.

//Maybe {{{verbatim end}}}.// Some text.

//The middle has //emphasize// word.// Some text.

//The middle has {{{verbatim}}} word.// Some text.

//Ampersand.//
We can test Hennes & Mauritz, often abbreviated H&M, but written
as {{{Hennes & Mauritz}}} and {{{H & M}}}.
A sole {{{&}}} must also work.
<wiki:comment> Note: substitutions must not occur inside verbatim, just in ordinary text. </wiki:comment>

{{{
# Just to check that ampersand works in code blocks:
c = a & b
}}}

//Quotes.//
Let us also add a test of quotes such as "double quotes, with numbers
like 3.14 and newline/comma and hyphen (as in double-quote)"; written
in the standard LaTeX-style that gives correct LaTeX formatting and
ordinary double quotes for all non-LaTeX formats.  Here is another
sentence that "caused" a bug in the past because double backtick
quotes could imply verbatim text up to a verbatim word starting with
period, like {{{.txt}}}.

More quotes to be tested for spellcheck:
("with parenthesis"), "with newline"
and "with comma", "hyphen"-wise, and "period".

== Bibliography test ==

Here is an example: [1] discussed propagation of
large destructive water waves, [2] gave
an overview of numerical methods for solving the Navier - Stokes equations,
while the use of Backward Kolmogorov equations for analyzing
random vibrations was investigated in [3].
The book chapter [4] contains information on
C++ software tools for programming multigrid methods. A real retro
reference is [5] about a big FORTRAN package.
Multiple references are also possible, e.g., see
[1] [4].

We need to cite more than 10 papers to reproduce an old formatting
problem with blanks in the keys in reST format:
[6] [3] [7] [1]
and
[2] [8] [9] [10] [11] [12] [13]
and all the work of
[14] [4] [15] as well as
old work [5] and [16], and the
talk [17].
Langtangen also had two thesis [18] [16]
back in the days.
More retro citations are
the old ME-IN323 book [19] and the
[20] OONSKI '94 paper.

<wiki:comment> --- begin exercise --- </wiki:comment>

== Example 1: Examples can be typeset as exercises ==

Examples can start with a subsection heading starting with {{{Example:}}}
and then, with the command-line option {{{--examples_as_exercises}}} be
typeset as exercises. This is useful if one has solution
environments as part of the example.

//a)//
State some problem.

//Solution.//
The answer to this subproblem can be written here.

//b)//
State some other problem.

//Hint 1.//
A hint can be given.

//Hint 2.//
Maybe even another hint?

//Solution.//
The answer to this other subproblem goes here,
maybe over multiple doconce input lines.

<wiki:comment> --- end exercise --- </wiki:comment>

== User-defined environments ==

The example in the section [#Example_1:_A_test_function] demonstrates how to write a test function.
That is, a special test function for a function {{{add}}} appears in
the example in the section [#Example_1:_A_test_function].

== Example 1: A test function ==

Suppose we want to write a test function for checking the
implementation of a Python function for addition.

{{{
def add(a, b):
    return a + b

def test_add():
    a = 1; b = 1
    expected = a + b
    computed = add(a, b)
    assert expected == computed
}}}

== Example 2: Addition ==

We have

{{{
\[ 1 + 1 = 2 \]
}}}
or in tabular form:


 | =Problem       | =Result      |
 |  {{{1+1}}}     |  {{{2}}}     |


//Highlight box!// 
This environment is used to highlight something:

{{{
\[ E = mc^2 \]
}}}



== URLs ==

Testing of URLs: hpl's home page [[https://folk.uio.no/hpl|hpl]], or
the entire URL if desired, [[https://folk.uio.no/hpl]].  Here is a
plain file link [[testdoc.do.txt]], or [[testdoc.do.txt]], or
[[testdoc.do.txt]] or [[testdoc.do.txt]] or [[testdoc.do.txt|a link with
newline]]. Can test spaces with the link with word
too: [[https://folk.uio.no/hpl|hpl]] or [[https://folk.uio.no/hpl|hpl]]. Also {{{file:///}}} works: [[file:///home/hpl/vc/doconce/doc/demos/manual/manual.html|link to a
file]] is
fine to have. Moreover, "loose" URLs work, i.e., no quotes, just
the plain URL as in [[https://folk.uio.no/hpl]], if followed by space, comma,
colon, semi-colon, question mark, exclamation mark, but not a period
(which gets confused with the periods inside the URL).

Mail addresses can also be used: [[mailto:hpl@simula.no|{{{hpl@simula.no}}}]], or just a [[mailto:hpl@simula.no|mail link]], or a raw [[mailto:hpl@simula.no]].

Here are some tough tests of URLs, especially for the {{{latex}}} format:
[[https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas|Newton-Cotes]] formulas
and a [[https://www.springer.com/mathematics/computational+science+%26+engineering/book/978-3-642-23098-1|good book]]. Need to test
Newton-Cotes with percentage in URL too:
[[https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas]]
and [[https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae]] which has a shebang.

For the {{{--device=paper}}} option it is important to test that URLs with
monospace font link text get a footnote
(unless the {{{--latex_no_program_footnotelink}}}
is used), as in this reference to
[[https://github.com/hplgit/INF5620/tree/gh-pages/src/decay/experiments/decay_mod.py|{{{decay_mod}}}]], [[https://tinyurl.com/pwyasaa/formulas.ball1.py|{{{ball1.py}}}]],
and [[https://tinyurl.com/pwyasaa/formulas.ball2.py|{{{ball2.py}}}]].

<wiki:comment> Comments should be inserted outside paragraphs (because in the rst </wiki:comment>
<wiki:comment> format extra blanks make a paragraph break). </wiki:comment>

<wiki:comment> Note that when there is no https: or file:, it can be a file link </wiki:comment>
<wiki:comment> if the link name is URL, url, "URL", or "url". Such files should, </wiki:comment>
<wiki:comment> if rst output is desired, but placed in a {{{_static*}}} folder. </wiki:comment>

More tough tests: repeated URLs whose footnotes when using the
{{{--device=paper}}} option must be correct. We have
[[https://google.com|google]], [[https://google.com|google]], and
[[https://google.com|google]], which should result in exactly three
footnotes.

<wiki:comment> !split and check if these extra words are included properly in the comment </wiki:comment>

= LaTeX Mathematics =

Here is an equation without label using backslash-bracket environment:
{{{
\[ a = b + c \]
}}}

or with number and label, as in Equation (my:eq1), using the equation environment:

{{{
\begin{equation}
{\partial u\over\partial t} = \nabla^2 u label{my:eq1}
\end{equation}
}}}

We can refer to this equation by Equation (my:eq1).

Here is a system without equation numbers, using the align-asterisk environment:

{{{
\begin{align*}
\pmb{a} &= \pmb{q}\times\pmb{n} \\ 
b &= \nabla^2 u + \nabla^4 v
\end{align*}
}}}

More mathematical typesetting is demonstrated in the coming exercises.

Below, we have [#Problem_2:_Flip_a_Coin] and [#Project_4:_Compute_a_Probability],
as well as [#Project_5:_Explore_Distributions_of_Random_Circles] and [#Project_11:_References_to_Project_demo:ex:2_in_a_heading_works_for_cwiki], and in
between there we have [#Exercise_10:_Make_references_to_projects_and_problems].

= Exercises =

<wiki:comment> --- begin exercise --- </wiki:comment>

== Problem 2: Flip a Coin ==

<wiki:comment> keywords = random numbers; Monte Carlo simulation; ipynb </wiki:comment>

<wiki:comment> Torture tests </wiki:comment>

//a)//
Make a program that simulates flipping a coin {{{N}}} times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

<wiki:comment> --- begin hint in exercise --- </wiki:comment>

//Hint 1.//
Use {{{r = random.random()}}} and define head as {{{r <= 0.5}}}.

<wiki:comment> --- end hint in exercise --- </wiki:comment>

<wiki:comment> --- begin hint in exercise --- </wiki:comment>

//Hint 2.//
Draw an integer among {{{\{1,2\}}}} with
{{{r = random.randint(1,2)}}} and define head when {{{r}}} is 1.

<wiki:comment> --- end hint in exercise --- </wiki:comment>

<wiki:comment> --- begin answer of exercise --- </wiki:comment>
//Answer.//
If the {{{random.random()}}} function returns a number {{{<1/2}}}, let it be
head, otherwise tail. Repeat this {{{N}}} number of times.
<wiki:comment> --- end answer of exercise --- </wiki:comment>

<wiki:comment> --- begin solution of exercise --- </wiki:comment>
//Solution.//
{{{
import sys, random
N = int(sys.argv[1])
heads = 0
for i in range(N):
    r = random.random()
    if r <= 0.5:
        heads += 1
print('Flipping a coin %d times gave %d heads' % (N, heads))
}}}
<wiki:comment> --- end solution of exercise --- </wiki:comment>

//b)//
Vectorize the code in a) using boolean indexing.

Vectorized code can be written in many ways.
Sometimes the code is less intuitive, sometimes not.
At least there is not much to find in the section [#Section_1].

//c)//
Vectorize the code in a) using {{{numpy.sum}}}.

<wiki:comment> --- begin answer of exercise --- </wiki:comment>
//Answer.//
{{{np.sum(np.where(r <= 0.5, 1, 0))}}} or {{{np.sum(r <= 0.5)}}}.
<wiki:comment> --- end answer of exercise --- </wiki:comment>

In this latter subexercise, we have an
example where the code is easy to read.

=== My remarks ===

Remarks with such a subsubsection is treated as more text
after the last subexercise. Test a list too:


# Mark 1.
# Mark 2.

Filenames: {{{flip_coin.py}}}, {{{flip_coin.pdf}}}.

<wiki:comment> Closing remarks for this Problem </wiki:comment>

=== Remarks ===

These are the exercise remarks, appearing at the very end.

<wiki:comment> solution files: mysol.txt, mysol_flip_coin.py, yet_another.file </wiki:comment>

<wiki:comment> --- end exercise --- </wiki:comment>

== Not an exercise ==

Should be possible to stick a normal section in the middle of many
exercises.

<wiki:comment> --- begin exercise --- </wiki:comment>

== Exercise 3: Test of plain text exercise ==

Very short exercise. What is the capital
of Norway?
Filename: {{{myexer1}}}.

<wiki:comment> --- end exercise --- </wiki:comment>

<wiki:comment> --- begin exercise --- </wiki:comment>

== Project 4: Compute a Probability ==

<wiki:comment> Minimalistic exercise </wiki:comment>

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval {{{[0,1)}}}?

At the end we have a list because that caused problems in LaTeX
in previous DocOnce versions:


# item1
# item2

<wiki:comment> --- begin hint in exercise --- </wiki:comment>

//Hint.//
To answer this question empirically, let a program
draw {{{N}}} such random numbers using Python's standard {{{random}}} module,
count how many of them, {{{M}}}, that fall in the interval {{{(0.5,0.6)}}}, and
compute the probability as {{{M/N}}}.

<wiki:comment> --- end hint in exercise --- </wiki:comment>

<wiki:comment> --- end exercise --- </wiki:comment>

<wiki:comment> --- begin exercise --- </wiki:comment>

== Project 5: Explore Distributions of Random Circles ==

<wiki:comment> keywords = ipynb </wiki:comment>

The formula for a circle is given by

{{{
\begin{align}
x &= x_0 + R\cos 2\pi t,
label{circle:x}\\ 
y &= y_0 + R\sin 2\pi t,
label{circle:y}
\end{align}
}}}
where {{{R}}} is the radius of the circle, {{{(x_0,y_0)}}} is the
center point, and {{{t}}} is a parameter in the unit interval {{{[0,1]}}}.
For any {{{t}}}, {{{(x,y)}}} computed from Equations (circle:x)-(circle:y)
is a point on the circle.
The formula can be used to generate {{{n}}} points on a circle:

{{{
import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y

x, y = circle(2.0, 0, 0)
}}}

<wiki:comment> Often in an exercise we have some comments about the solution </wiki:comment>
<wiki:comment> which we normally want to keep where they are. </wiki:comment>

The goal of this project is to draw {{{N}}} circles with random
center and radius. Plot each circle using the {{{circle}}} function
above.

//a)//
Let {{{R}}} be normally distributed and {{{(x_0,y_0)}}} uniformly distributed.

<wiki:comment> --- begin hint in exercise --- </wiki:comment>

//Hint.//
Use the {{{numpy.random}}} module to draw the
{{{x_0}}}, {{{y_0}}}, and {{{R}}} quantities.

<wiki:comment> --- end hint in exercise --- </wiki:comment>

<wiki:comment> --- begin answer of exercise --- </wiki:comment>
//Answer.//
Here goes the short answer to part a).
<wiki:comment> --- end answer of exercise --- </wiki:comment>

<wiki:comment> --- begin solution of exercise --- </wiki:comment>
//Solution.//
Here goes a full solution to part a).
<wiki:comment> --- end solution of exercise --- </wiki:comment>

//b)//
Let {{{R}}} be uniformly distributed and {{{(x_0,y_0)}}} normally distributed.
Filename: {{{norm}}}.

//c)//
Let {{{R}}} and {{{(x_0,y_0)}}} be normally distributed.

Filename: {{{circles}}}.

<wiki:comment> Closing remarks for this Project </wiki:comment>

=== Remarks ===

At the very end of the exercise it may be appropriate to summarize
and give some perspectives.

<wiki:comment> --- end exercise --- </wiki:comment>

<wiki:comment> --- begin exercise --- </wiki:comment>

== Exercise 6: Determine some Distance ==

Intro to this exercise. Questions are in subexercises below.

<wiki:comment> --- begin solution of exercise --- </wiki:comment>
//Solution.//
Here goes a full solution of the whole exercise.
With some math {{{a=b}}} in this solution:
{{{
\[ \hbox{math in solution: } a = b \]
}}}
And code {{{a=b}}} in this solution:
{{{
a = b  # code in solution
}}}
End of solution is here.

<wiki:comment> --- end solution of exercise --- </wiki:comment>

//a)//
Subexercises are numbered a), b), etc.

<wiki:comment> --- begin hint in exercise --- </wiki:comment>

//Hint 1.//
First hint to subexercise a).
With math {{{a=b}}} in hint:

{{{
\[ a=b. \]
}}}
And with code (in plain verbatim) returning {{{x+1}}} in hint:

{{{
def func(x):
    return x + 1  # with code in hint
}}}

<wiki:comment> --- end hint in exercise --- </wiki:comment>

<wiki:comment> --- begin hint in exercise --- </wiki:comment>

//Hint 2.//
Second hint to subexercise a).

Test list in hint:


# item1
# item2

<wiki:comment> --- end hint in exercise --- </wiki:comment>
Filename: {{{subexer_a.pdf}}}.

<wiki:comment> --- begin answer of exercise --- </wiki:comment>
//Answer.//
Short answer to subexercise a).
With math in answer: {{{a=b}}}.
<wiki:comment> --- end answer of exercise --- </wiki:comment>

//b)//
Here goes the text for subexercise b).

Some math {{{\cos^2 x + \sin^2 x = 1}}} written one a single line:

{{{
\[ \cos^2 x + \sin^2 x = 1 \thinspace .\]
}}}

<wiki:comment> --- begin hint in exercise --- </wiki:comment>

//Hint.//
A hint for this subexercise.

<wiki:comment> --- end hint in exercise --- </wiki:comment>
Filename: {{{subexer_b.pdf}}}.

<wiki:comment> --- begin solution of exercise --- </wiki:comment>
//Solution.//
Here goes the solution of this subexercise.
<wiki:comment> --- end solution of exercise --- </wiki:comment>

<wiki:comment> No meaning in this weired test example: </wiki:comment>
The text here belongs to the main (intro) part of the exercise. Need
closing remarks to have text after subexercises.

Test list in exercise:


# item1
# item2<wiki:comment> Closing remarks for this Exercise </wiki:comment>


=== Remarks ===

Some final closing remarks, e.g., summarizing the main findings
and their implications in other problems can be made. These
remarks will appear at the end of the typeset exercise.

<wiki:comment> --- end exercise --- </wiki:comment>

<wiki:comment> --- begin exercise --- </wiki:comment>

== Some exercise without the "Exercise:" prefix ==

<wiki:comment> Another minimalistic exercise </wiki:comment>

Just some text. And some math saying that {{{e^0=1}}} on a single line,
to test that math block insertion is correct:

{{{
\[ \exp{(0)} = 1 \]
}}}

And a test that the code {{{lambda x: x+2}}} is correctly placed here:

{{{
lambda x: x+2
}}}

<wiki:comment> Have some comments at the end of the exercise to see that </wiki:comment>
<wiki:comment> the Filename: ... is written correctly. </wiki:comment>
<wiki:comment> --- end exercise --- </wiki:comment>

<wiki:comment> --- begin exercise --- </wiki:comment>

== Exercise 8: Solution of differential equation ==



Given

{{{
\[ \frac{dy}{dx} = -y(x),\quad y(0)=1 \]
}}}
What is the solution of this equation?

Choice A: 
{{{y=e^{-y}}}}

Choice B: 
{{{y=e^{y}}}}

Choice C: 
{{{
from math import exp
def f(x):
    return exp(x)
}}}

Choice D: The solution cannot be found because there is a derivative in the equation.

Choice E: The equation is meaningless: an equation must be an equation
for {{{x}}} or {{{y}}}, not a function {{{y(x)}}}.



<wiki:comment> --- end exercise --- </wiki:comment>

<wiki:comment> --- begin exercise --- </wiki:comment>

== Example 9: Just an example ==

<wiki:comment> This example needs the --examples_as_exercises option, otherwise </wiki:comment>
<wiki:comment> it is just typeset as it is written. </wiki:comment>

//a)//
What is the capital of Norway?

//Answer.//
Oslo.

<wiki:comment> --- end exercise --- </wiki:comment>

= Here goes another section =

With some text, before we continue with exercises.

= More Exercises =

<wiki:comment> --- begin exercise --- </wiki:comment>

== Exercise 10: Make references to projects and problems ==

<wiki:comment> Test comments not at the end only </wiki:comment>
Pick a statement from [#Project_5:_Explore_Distributions_of_Random_Circles] or [#Problem_2:_Flip_a_Coin]
and verify it.

Test list at the end of an exercise without other elements (like subexercise,
hint, etc.):


# item1
# item2

Filename: {{{verify_formula.py}}}.

<wiki:comment> --- end exercise --- </wiki:comment>

<wiki:comment> --- begin exercise --- </wiki:comment>

== Project 11: References to [#Project_4:_Compute_a_Probability] in a heading works for cwiki ==

Refer to the previous exercise as [#Exercise_10:_Make_references_to_projects_and_problems],
the two before that as [#Project_4:_Compute_a_Probability] and [#Project_5:_Explore_Distributions_of_Random_Circles],
and this one as [#Project_11:_References_to_Project_demo:ex:2_in_a_heading_works_for_cwiki].
Filename: {{{selc_composed.pdf}}}.

<wiki:comment> --- end exercise --- </wiki:comment>

= References =


 # **H. P. Langtangen and G. Pedersen**.     Propagation of Large Destructive Waves,    //International Journal of Applied Mechanics and Engineering//,    7(1),    pp. 187-204,    2002.
 # **H. P. Langtangen, K.-A. Mardal and R. Winther**.     Numerical Methods for Incompressible Viscous Flow,    //Advances in Water Resources//,    25,    pp. 1125-1146,    2002.
 # **H. P. Langtangen**.     Numerical Solution of First Passage Problems in Random Vibrations,    //SIAM Journal of Scientific and Statistical Computing//,    15,    pp. 997-996,    1994.
 # **K.-A. Mardal, G. W. Zumbusch and H. P. Langtangen**.     Software Tools for Multigrid Methods,    //Advanced Topics in Computational Partial Differential Equations -- Numerical Methods and Diffpack Programming//,    edited by **H. P. Langtangen and A. Tveito**,    Springer,    2003,    Edited book,    [[http://some.where.org]].
 # **H. P. Langtangen**.     The FEMDEQS Program System,    //Department of Mathematics, University of Oslo//,    1989,    [[http://www.math.uio.no/old/days/hpl/femdeqs.pdf]].
 # **H. P. Langtangen**.     Stochastic Breakthrough Time Analysis of an Enhanced Oil Recovery Process,    //SIAM Journal on Scientific Computing//,    13,    pp. 1394-1417,    1992.
 # **M. Mortensen, H. P. Langtangen and G. N. Wells**.     A FEniCS-Based Programming Framework for Modeling Turbulent Flow by the Reynolds-Averaged Navier-Stokes Equations,    //Advances in Water Resources//,    34(9),    [[https://dx.doi.org/10.1016/j.advwatres.2011.02.013|doi: 10.1016/j.advwatres.2011.02.013]],    2011.
 # **S. Glimsdal, G. Pedersen, K. Atakan, C. B. Harbitz, H. P. Langtangen and F. L\ovholt**.     Propagation of the Dec. 26, 2004 Indian Ocean Tsunami: Effects of Dispersion and Source Characteristics,    //International Journal of Fluid Mechanics Research//,    33(1),    pp. 15-43,    2006.
 # **S. Rahman, J. Gorman, C. H. W. Barnes, D. A. Williams and H. P. Langtangen**.     Numerical Investigation of a Piezoelectric Surface Acoustic Wave Interaction With a One-Dimensional Channel,    //Physical Review B: Condensed Matter and Materials Physics//,    74,    2006,    035308.
# **J. B. Haga, H. Osnes and H. P. Langtangen**.     On the Causes of Pressure Oscillations in Low-Permeable and Low-Compressible Porous Media,    //International Journal of Analytical and Numerical Methods in Geomechanics//,    [[https://dx.doi.org/10.1002/nag.1062|doi: 10.1002/nag.1062]],    2011,    [[http://onlinelibrary.wiley.com/doi/10.1002/nag.1062/abstract]].
# **H. P. Langtangen**.     //Computational Partial Differential Equations - Numerical Methods and Diffpack Programming//,    second edition,    //Texts in Computational Science and Engineering//,    Springer,    2003.
# **H. P. Langtangen**.     //Python Scripting for Computational Science//,    third edition,    //Texts in Computational Science and Engineering//,    Springer,    2008.
# **H. P. Langtangen and G. Pedersen**.     Finite Elements for the Boussinesq Wave Equations,    Waves and Non-linear Processes in Hydrodynamics,    edited by **J. Grue, B. Gjevik and J. E. Weber**,    Kluwer Academic Publishers,    pp. pp. 117-126,    1995,    [[http://www.amazon.ca/Waves-Nonlinear-Processes-Hydrodynamics-John/dp/0792340310]].
# **H. P. Langtangen**.     //A Primer on Scientific Programming With Python//,    third edition,    //Texts in Computational Science and Engineering//,    Springer,    2012.
# **P. V. Jeberg, H. P. Langtangen and C. B. Terp**.     Optimization With Diffpack: Practical Example From Welding,    //Simula Research Laboratory//,    2004,    Internal report.
# **H. P. Langtangen**.     Computational Methods for Two-Phase Flow in Oil Reservoirs,    Ph.D. Thesis,    Mechanics Division, Department of Mathematics, University of Oslo,    1989,    Dr. Scient. thesis..
# **H. P. Langtangen**.     Computational Modeling of Huge Tsunamis From Asteroid Impacts,    2007,    Invited keynote lecture at the \emphInternational conference on Computational Science 2007 (ICCS'07), Beijing, China.
# **H. P. Langtangen**.     Solution of the Navier-Stokes Equations With the Finite Element Method in Two and Three Dimensions,    M.Sc. Thesis,    Mechanics Division, Department of Mathematics, University of Oslo,    1985,    Cand.Scient. thesis.
# **H. P. Langtangen and A. Tveito**.     Numerical Methods in Continuum Mechanics,    //Center for Industrial Research//,    1991,    Lecture notes for a course (ME-IN 324). 286 pages..
# **H. P. Langtangen**.     Diffpack: Software for Partial Differential Equations,    //Proceedings of the Second Annual Object-Oriented Numerics Conference (OON-SKI'94), Sunriver, Oregon, USA//,    edited by **A. Vermeulen**,    1994.

= Appendix: Just for testing; part I =

This is the first appendix.

== A subsection within an appendix ==

Some text.

= Appendix: Just for testing; part II =

This is more stuff for an appendix.

== Appendix: Testing identical titles ==

Without label.

== Appendix: Testing identical titles ==

With label.

== Appendix: Testing identical titles ==

What about inserting a quiz?



======= Test of quizzes =======


Fundamental test: What is the capital of Norway?

Answer 1: Stockholm

Answer 2: London

Answer 3: Oslo

Choice D: Bergen



== Appendix: Testing identical titles ==

Without label.

//Tip.// 
Here is a tip or hint box, typeset as a notice box.



Need a lot of text to surround the summary box.
Version control systems allow you to record the history of files
and share files among several computers and collaborators in a
professional way. File changes on one computer are updated or
merged with changes on another computer. Especially when working
with programs or technical reports it is essential
to have changes documented and to
ensure that every computer and person involved in the project
have the latest updates of the files.
Greg Wilson' excellent [[https://software-carpentry.org/2010/07/script-for-introduction-to-version-control/|Script for Introduction to Version Control]] provides a more detailed motivation why you will benefit greatly
from using version control systems.

//Summary.// 
**Bold remark:** Make some text with this summary.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.



Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that site. I strongly
recommend you to use such sites for all serious programming and
scientific writing work - and all other important files.

The simplest services for hosting project files are [[https://dropbox.com|Dropbox]] and [[https://drive.google.com|Google Drive]].
It is very easy to get started with these systems, and they allow you
to share files among laptops and mobile units with as many users as
you want. The systems offer a kind of version control in that the
files are stored frequently (several times per minute), and you can go
back to previous versions for the last 30 days. However, it is
challenging  to find the right version from the past when there are
so many of them.

More seriously, when several people may edit files simultaneously, it
can be difficult detect who did what when, roll back to previous
versions, and to manually merge the edits when these are
incompatible. Then one needs more sophisticated tools than Dropbox or
Google Drive: project hosting services with true version control
systems.  The following text aims at providing you with the minimum
information to started with such systems. Numerous other tutorials
contain more comprehensive material and in-depth explanations of the
concepts and tools.

The idea with project hosting services is that you have the files
associated with a project in the cloud. Many people may share these
files.  Every time you want to work on the project you explicitly
update your version of the files, edit the files as you like, and
synchronize the files with the "master version" at the site where the
project is hosted.  If you at some point need to go back to a
version of the files at some particular point in the past,
this is an easy operation. You can also use tools to see
what various people have done with the files in the various versions.

All these services are very similar. Below we describe how you get
started with Bitbucket, GitHub, and Googlecode. Launchpad works very
similarly to the latter three. All the project hosting services have
excellent introductions available at their web sites, but the recipes
below are much shorter and aim at getting you started as quickly as
possible by concentrating on the most important need-to-know steps.
The Git tutorials we refer to later in this document contain more
detailed information and constitute of course very valuable readings
when you use version control systems every day. The point now is
to get started.

== Appendix: Testing inline comments ==

<wiki:comment> Names can be [ A-Za-z0-9_'+-]+ </wiki:comment>

Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that
site. [hpl's semi opinion 1: not sure if in the cloud is
understood by
all.] I strongly recommend you to use such sites for all serious
programming and scientific writing work - and all other important
files.

The simplest services for hosting project files is Dropbox. [mp 2: Simply go to [[https://dropbox.com]] and watch the video. It explains
how files, like {{{myfile.py}}}, perhaps containing much math, like
{{{\partial u/\partial t}}}, are easily communicated between machines.] It
is very easy to get started with Dropbox, and it allows you to share
files among [hpl 3: laptops and mobile units -> computers, tablets,
and phones].

<wiki:comment> Test horizontal rule </wiki:comment>

----

<wiki:comment> Coments for editing </wiki:comment>

First[add 4: ,] consider a quantity {{{Q}}}. [edit 5: To this end, -> We note that]
{{{Q>0}}}, because [del 6: a] negative [edit 7: quantity is -> quantities
are] [del 8: just] negative. [add 9: This comes as no surprise.]

<wiki:comment> Test tailored latex figure references with page number </wiki:comment>
Let us refer to Figure fig:impact again.

Test references in a list:


 * [#Section_1]
 * [#Subsection_1]
 * fig:impact

== Appendix: Testing headings ending with {{{verbatim inline}}} ==

The point here is to test 1) {{{verbatim}}} code in headings, and 2)
ending a heading with verbatim code as this triggers a special
case in LaTeX.

We also test mdash---used as alternative to hyphen without spaces around,
or in quotes:





The ndash should also be tested - as in the Hanson - Nilson equations
on page 277 - 278.

And finally, what about admons, quotes, and boxes? They are tested
in a separate document: {{{admon.do.txt}}}.

[^example-of-the-third-footnote]: Not much to add here, but the footnote
is at the end with only one newline.

************** File: testdoc.st *****************
TITLE: A Document for Testing DocOnce
BY: Hans Petter Langtangen (Center for Biomedical Computing, Simula Research Laboratory, and Department of Informatics, University of Oslo); Kaare Dump (Segfault, Cyberspace); A. Dummy Author; I. S. Overworked and Outburned (Inst1, and Inst2, Somewhere, and Third Inst, Elsewhere, and Fourth Inst); J. Doe
DATE: Jan 32, 2100
Made with DocOnce

# !split

The format of this document is
st
*Abstract.* This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.

Section 1

Here is a nested list:

  - item1
  - item2
  - item3 which continues
    on the next line to test that feature
  - and a sublist
    - with indented subitem1
    - and a subitem2

  - and perhaps an ordered sublist
   a. first item
   b. second item,
      continuing on a new line

*Here is a list with paragraph heading.*

  - item1
  - item2

Here is a list with subsubsection heading

  - item1
  - item2





Here are two references. Equation (ref{my:eq1}) is fine. Eq. (ref{my:eq1}) too.
Even Equation (ref{my:eq1}) without the tilde.

Subsection 1

More text, with a reference back to
the section "Section 1" and "Subsection 1", and further to the
the sections "Subsection 1" and "URLs", which
encourages you to do the tasks in "Problem 2: Flip a Coin" and "Exercise 10: Make references to projects and problems".
 "Appendix: Just for testing; part I" and "Appendix: Just for testing; part II" are also nice elements.

Test Section reference at beginning of line and after a sentence

The section "Subsection 1" is fine.
The section "URLs" too.

Computer code

Let's do some copying from files too. First from subroutine up to the very end::

              subroutine test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return

and then just the subroutine::

        
              subroutine test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return

and finally the complete file with a plain text verbatim environment
('envir=ccq')::

        C     a comment
        
              subroutine test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return

Testing other code environments. First Python::

        !bc pycod
        def f(x):
            return x+1
        !ec

which gets rendered as::

        def f(x):
            return x+1

Here is a program that is supposed to be interactive via
Python Online Tutorial, but that service is not accessible
for the present format::

        class Line:
            def __init__(self, a, b):
                self.a, self.b = a, b
        
            def __call__(self, x):
                a, b = self.a, self.b
                return a*x + b
        
        line = Line(2, 1)
        y = line(x=3)
        print(y)

Some more Python code (actually specified as a sage cell, but
such cells are not supported by this format)::

        a = 2
        b = 3
        print('a+b:', a + b)
        
        # In a sage cell we can also plot
        from matplotlib.pyplot import *
        from numpy import *
        x = linspace(0, 4*pi, 101)
        y = exp(-0.1*x)*cos(x)
        plot(x, y)
        xlabel('x'); ylabel('y')
        show()

Then Cython (with -h option so it is hidden in html/sphinx)::

        cpdef f(double x):
            return x + 1

Standard Python shell sessions::

        >>> from numpy import linspace, sin
        >>> # Some comment
        >>> x = linspace(0, 2, 11)
        >>> y = sin(x)
        >>> y[0]
        0
        >>> import matplotlib.pyplot as plt
        >>> plt.plot(x, y)

Similar IPython sessions::

        In [1]: from numpy import linspace, sin
        In [2]: # Some comment
        In [3]: x = linspace(0, 2, 11)
        In [4]: y = sin(x)
        In [5]: y[0]
        Out[5]: 0
        In [6]: import matplotlib.pyplot as plt
        In [7]: plt.plot(x, y)
        In [8]: a='multiple-\nline\noutput'
        In [9]: a
        Out[9]: 'multiple-\nline\noutput'
        In [10]: print(a)
        multiple-
        line
        output

Here is the interactive session again, but with 'pyshell-t'::

        >>> from numpy import linspace, sin
        >>> # Some comment
        >>> x = linspace(0, 2, 11)
        >>> y = sin(x)
        >>> y[0]
        0
        >>> import matplotlib.pyplot as plt
        >>> plt.plot(x, y)

C++::

        #include <iostream>
        
        int main()
        {
           std::cout << "Sample output" << std::endl;
           return 0
        }

And a little bit of Fortran: :dizzy_face::

        !bc cod
              subroutine midpt(x, length, a, b)
              real*8 a, b, x
              x = (a + b)/2
              length = b - a
              return
              end
        !ec

which then is typeset as::

              subroutine midpt(x, length, a, b)
              real*8 a, b, x
              x = (a + b)/2
              length = b - a
              return
              end

HTML::

        <table>
        <tr><td>Column 1</td><td>Column 2</td></tr>
        <tr><td>0.67526 </td><td>0.92871 </td></tr>
        <!-- comment -->
        </table>

But inline HTML code is also important, like text that starts with
'<a href="' (which can destroy the following text if not properly
quoted).

Matlab with comments requires special typesetting::

        % Comment on the beginning of the line can be escaped by %%
        if a > b
          % Indented comment needs this trick
          c = a + b
        end

And here is a system call::

        Terminal> mkdir test
        Terminal> cd test
        Terminal> myprog -f
        output1
        output2

Any valid pygments lexer/language name can appear to, e.g.::

        !bc restructuredtext
        =======
        Heading
        =======
        
        Some text.
        !ec

results in::

        =======
        Heading
        =======
        
        Some text.

Finally, '!bc do' supports highlighting of DocOnce source::

        ======= DocOnce test file =======
        
        ===== Computer code =====
        
        Inline verbatim code, as in `import numpy as np`, is allowed, as well as
        code blocks:
        
        !bc pycod
        from math import sin
        
        def f(x):
            """Example on a function."""
            return sin(x) + 1
        
        print(f(0))
        !ec
        
        
        ===== Mathematics =====
        
        Formulas can be inline, as in $\nabla\cdot\bm{u} = 0$, or typeset
        as equations:
        
        !bt
        \begin{align*}
        \nabla\cdot\bm{u} &= 0,\\ 
        \bm{u} &= \nabla\phi .
        \end{align*}
        !et
        
        === Subsubsection heading ===
        
        DocOnce files can have chapters, sections, subsections, and subsubsections.
        
        __Paragraph heading.__ Paragraphs may have headings.

It is time to test 'verbatim inline font' especially with 'a newline
inside the text' and an exclamation mark at the end: 'BEGIN'! For
spellcheck, test 'a verbatim expression' in 'another' in a 'third'.
Also test exclamation mark as in '!bc' and '!ec' as well as 'a != b'.
Also test backslashes and braces like '\begin', '\begin{enumerate}',
'\end{this}\end{that}', and '{something \inside braces}'.

The following attempt to exemplify colored text does not work in
format st.
Here is some red color and an attempt to write with
green color containing a linebreak
code. Some formats will only display 
this correctly when 'html' 
is the output format.
But here some more running text is added which is not part of
the previous blocks with line breaks.

Running OS commands::

        Terminal> python -c 'print("Testing\noutput\nfrom\nPython.")'
        Testing
        output
        from
        Python.

Footnotes

Here is a test of footnotes [^footnote], which are handy in text.
They are used in different flavors, now in

 - list items (note below that footnotes work after math, verbatim, and URLs - bin fact old and emphasize too!)
 - even with math \nabla^2u[^math1]
 - and code 'h[i] += 1'[^code]
   (*must* have space between inline code and footnote!)
 - and "https://google.com":links[^google-search]

which gives flexibility in writing.
This is the third[^example-of-the-third-footnote] example.

  [^footnote]: Typesetting of the footnote depends on the format.
Plain text does nothing, LaTeX removes the
definition and inserts the footnote as part of the LaTeX text.
reStructuredText and Sphinx employ a similar type of typesetting
as Extended Markdown and DocOnce, and in HTML we keep the same
syntax, just displayed properly in HTML.
[^math1]: Math footnotes can be dangerous since it
interferes with an exponent.
[^code]: One-line footnote.

[^google-search]: "google.com":google.com is perhaps the most famous
web site today.

Here is some more text before a new definition of a footnote that was
used above.

*Non-breaking space character.* 
This paragraph aims to test "https://en.wikipedia.org/wiki/Non-breaking_space":non-breaking space character, and a typical
example where this is needed is in physical units: 7.4 km is traveled
in 7.4/5.5\approx 1.345 s.  Also check that a~"https://google.com":link is
not broken across lines (drag the browser window to test this).
(On the other hand, the tilde is used in
computer code, e.g., as in '[~x for x in y]' or in 'y=~x', and should
of course remain a tilde in those contexts.)



Subsection 2: Testing figures

Test of figures. In particular we refer to Figure ref{fig:impact} in which
there is a flow.

FIGURE:[../doc/src/manual/fig/wave1D, width=200] Visualization **of** a *wave*. {fig:impact}

Figures without captions are allowed and will be inlined.

FIGURE:[../doc/src/manual/fig/wave1D, width=200]

Here is figure ref{myfig} with a long (illegal) multi-line caption
containing inline verbatim text:

FIGURE: [../doc/src/manual/fig/wave1D.png, width=500 sidecap=True] A long caption spanning several lines and containing verbatim words like 'my_file_v1' and 'my_file_v2' as well as math with subscript as in t_{i+1}. {myfig} 

Test URL as figure name:

FIGURE: [https://raw.github.com/doconce/doconce/master/doc/src/blog/f_plot.png, width=500 frac=0.8]

*Remark.*
Movies are tested in separate file 'movies.do.txt'.

The \theta parameter (not \nabla?)

Functions do not always need to be advanced, here is one
involving \theta::

        def f(theta):
            return theta**2

*More on \theta.* Here is more text following headline with math.

Newcommands must also be tested in this test report:
\frac{1}{2}, {1/2}, \pmb{x}, \frac{Du}{dt},
both inline and in block::

        \begin{align}
        \frac{Du}{dt} &= 0\nonumber
        \\ 
        \frac{1}{2} &= {1/2}\\ 
        \frac{1}{2}\pmb{x} &= \pmb{n}
        \end{align}

Or with align with label and numbers::

        \begin{align}
        \frac{Du}{dt} &= 0
        label{aligneq1}
        \\ 
        \frac{1}{2} &= {1/2}\\ 
        \frac{1}{2}\pmb{x} &= \pmb{n}
        label{aligneq2}
        \end{align}

First one numbered (automatically)::

        \begin{align}
        \begin{pmatrix}
        G_2 + G_3 & -G_3 & -G_2 & 0 \\ 
        -G_3 & G_3 + G_4 & 0 & -G_4 \\ 
        -G_2 & 0 & G_1 + G_2 & 0 \\ 
        0 & -G_4 & 0 & G_4
        \end{pmatrix}
        &=
        \begin{pmatrix}
         v_1 \\ 
         v_2 \\ 
         v_3 \\ 
         v_4
        \end{pmatrix}
        + \cdots \\ 
        \begin{pmatrix}
         C_5 + C_6 & -C_6 & 0 & 0 \\ 
         -C_6 & C_6 & 0 & 0 \\ 
         0 & 0 & 0 & 0 \\ 
         0 & 0 & 0 & 0
        \end{pmatrix}
          &= \frac{d}{dt}\begin{pmatrix}
         v_1 \\ 
         v_2 \\ 
         v_3 \\ 
         v_4
        \end{pmatrix} +
        \begin{pmatrix}
         0 \\ 
         0 \\ 
         0 \\ 
         -i_0
        \end{pmatrix}
        \nonumber
        \end{align}

Second numbered (automatically)::

        \begin{align}
        \begin{pmatrix}
        G_1 + G_2\\ 
        -G_3 & G_4
        \end{pmatrix}
        &=
        \begin{pmatrix}
         v_1 \\ 
         v_2
        \end{pmatrix}
        + \cdots\nonumber
        \\ 
        \left(\begin{array}{ll}
        y & 2\\ 
        2 & 1
        \end{array}\right)
        \left(\begin{array}{ll}
        0 \\ x
        \end{array}\right)
        &= \begin{pmatrix}
        A \\ B
        \end{pmatrix}
        \end{align}

Both numbered, with label by the user::

        \begin{align}
        \begin{pmatrix}
        G_1 + G_2\\ 
        -G_3 & G_4
        \end{pmatrix}
        &=
        \begin{pmatrix}
         v_1 \\ 
         v_2
        \end{pmatrix}
        + \cdots label{mymatrix:eq1}
        \\ 
        label{mymatrix:eq2}
        \left(\begin{array}{ll}
        y & 2\\ 
        2 & 1
        \end{array}\right)
        \left(\begin{array}{ll}
        0 \\ x
        \end{array}\right)
        &= \begin{pmatrix}
        A \\ B
        \end{pmatrix}
        \end{align}

Now we refer to Equations (mymatrix:eq1)-(mymatrix:eq2).

Custom Environments

Here is an attempt to create a theorem environment via Mako
(for counting theorems) and comment lines to help replacing lines in
the '.tex' by proper begin-end LaTeX environments for theorems.
Should look nice in most formats!

*Theorem 5.*
Let a=1 and b=2. Then c=3.

*Proof.*
Since c=a+b, the result follows from straightforward addition.
END

As we see, the proof of Theorem 5 is a modest
achievement.

Tables

Let us take this table from the manual:

====  ========  ============  
time  velocity  acceleration  
====  ========  ============  
0.0     1.4186         -5.01  
2.0   1.376512        11.919  
4.0     1.1E+1     14.717624  
====  ========  ============  

The DocOnce source code reads::

        
          |--------------------------------|
          |time  | velocity | acceleration |
          |--l--------r-----------r--------|
          | 0.0  | 1.4186   | -5.01        |
          | 2.0  | 1.376512 | 11.919       |
          | 4.0  | 1.1E+1   | 14.717624    |
          |--------------------------------|
        

Here is yet another table to test that we can handle more than
one table:

====  ========  ============  
time  velocity  acceleration  
====  ========  ============  
0.0   1.4186    -5.01         
1.0   1.376512  11.919        
3.0   1.1E+1    14.717624     
====  ========  ============  

And one with math headings (that are expanded and must be treated
accordingly), verbatim heading and entry, and no space around the pipe
symbol:

=  ======  ========  =======  
i   h_i    \bar T_i   'L_i'   
=  ======  ========  =======  
0       0       288  -0.0065  
1  11,000       216      0.0  
2  20,000       216    0.001  
3  32,000       228   0.0028  
4  47,000       270      0.0  
5  51,000       270  -0.0028  
6  71,000       214    'NaN'  
=  ======  ========  =======  

And add one with verbatim headings (with underscores),
and rows starting with '|-' because of a negative number,
and '|' right before and after verbatim word (with no space):

=====  ======  ===========  =========  
exact  'v_1'   a_i + 'v_2'  'verb_3_'  
=====  ======  ===========  =========  
    9    9.62         5.57       8.98  
  -20  -23.39        -7.65     -19.93  
   10   17.74        -4.50       9.96  
    0   -9.19         4.13      -0.26  
=====  ======  ===========  =========  

Pipe symbols in verbatim and math text in tables used to pose difficulties,
but not
anymore:

===========  =======  =======  
     S       command  
===========  =======  =======  
$ ||a_0|| $    'norm  
x\cap y           'x  
===========  =======  =======  

Here is a table with X alignment:

=====  ======================================================================================================================================================================================================================  
 Type                                                                                                       Description                                                                                                        
=====  ======================================================================================================================================================================================================================  
  X    Alignment character that is used for specifying a potentially very long text in a column in a table. It makes use of the 'tabularx' package in LaTeX, otherwise (for other formats) it means 'l' (centered alignment).  
l,r,c  standard alignment characters                                                                                                                                                                                           
=====  ======================================================================================================================================================================================================================  

Finally, a table with math
and URLs.

====================  ======================================================  ======================================================  
                                                                                                                                      
====================  ======================================================  ======================================================  
   \mathcal{L}=0      ../doc/src/manual/mov/wave_frames/frame_0080.png:'080'  ../doc/src/manual/mov/wave_frames/frame_0085.png:'085'  
        a=b           ../doc/src/manual/mov/wave_frames/frame_0090.png:'090'  ../doc/src/manual/mov/wave_frames/frame_0095.png:'095'  
\nabla\cdot\bm{u} =0  ../doc/src/manual/mov/wave_frames/frame_0100.png:'100'  ../doc/src/manual/mov/wave_frames/frame_0105.png:'105'  
====================  ======================================================  ======================================================  

A test of verbatim words in heading with subscript a_i: 'my_file_v1' and 'my_file_v2'

*Paragraph with verbatim and math: 'my_file_v1.py' and 'my_file_v2.py' define some math a_{i-1}.* Here is more '__verbatim__' code and
some plain text on a new line.

**Just bold**

Some text.

*Just emphasize*

Some text.

'Just verbatim'

Some text.

**Bold** beginning

Some text.

*Emphasize* beginning

Some text.

'Verbatim' beginning

Some text.

Maybe **bold end**

Some text.

Maybe *emphasize end*

Some text.

Maybe 'verbatim end'

Some text.

The middle has **bold** word

Some text.

The middle has *emphasize* word

Some text.

The middle has 'verbatim' word

Some text.

**Just emphasize*.* Some text.

*'Just verbatim'.* Some text.

**Emphasize* beginning.* Some text.

*'Verbatim beginning'.* Some text.

*Maybe *emphasize end*.* Some text.

*Maybe 'verbatim end'.* Some text.

*The middle has *emphasize* word.* Some text.

*The middle has 'verbatim' word.* Some text.

*Ampersand.*
We can test Hennes & Mauritz, often abbreviated H&M, but written
as 'Hennes & Mauritz' and 'H & M'.
A sole '&' must also work::

        # Just to check that ampersand works in code blocks:
        c = a & b

*Quotes.*
Let us also add a test of quotes such as "double quotes, with numbers
like 3.14 and newline/comma and hyphen (as in double-quote)"; written
in the standard LaTeX-style that gives correct LaTeX formatting and
ordinary double quotes for all non-LaTeX formats.  Here is another
sentence that "caused" a bug in the past because double backtick
quotes could imply verbatim text up to a verbatim word starting with
period, like '.txt'.

More quotes to be tested for spellcheck:
("with parenthesis"), "with newline"
and "with comma", "hyphen"-wise, and "period".

Bibliography test

Here is an example: [1] discussed propagation of
large destructive water waves, [2] gave
an overview of numerical methods for solving the Navier - Stokes equations,
while the use of Backward Kolmogorov equations for analyzing
random vibrations was investigated in [3].
The book chapter [4] contains information on
C++ software tools for programming multigrid methods. A real retro
reference is [5] about a big FORTRAN package.
Multiple references are also possible, e.g., see
[1] [4].

We need to cite more than 10 papers to reproduce an old formatting
problem with blanks in the keys in reST format:
[6] [3] [7] [1]
and
[2] [8] [9] [10] [11] [12] [13]
and all the work of
[14] [4] [15] as well as
old work [5] and [16], and the
talk [17].
Langtangen also had two thesis [18] [16]
back in the days.
More retro citations are
the old ME-IN323 book [19] and the
[20] OONSKI '94 paper.

# --- begin exercise ---

Example 1: Examples can be typeset as exercises

Examples can start with a subsection heading starting with 'Example:'
and then, with the command-line option '--examples_as_exercises' be
typeset as exercises. This is useful if one has solution
environments as part of the example.

*a)*
State some problem.

*Solution.*
The answer to this subproblem can be written here.

*b)*
State some other problem.

*Hint 1.*
A hint can be given.

*Hint 2.*
Maybe even another hint?

*Solution.*
The answer to this other subproblem goes here,
maybe over multiple doconce input lines.

# --- end exercise ---

User-defined environments

The example in the section "Example 1: A test function" demonstrates how to write a test function.
That is, a special test function for a function 'add' appears in
the example in the section "Example 1: A test function".

Example 1: A test function

Suppose we want to write a test function for checking the
implementation of a Python function for addition::

        def add(a, b):
            return a + b
        
        def test_add():
            a = 1; b = 1
            expected = a + b
            computed = add(a, b)
            assert expected == computed

Example 2: Addition

We have::

        \[ 1 + 1 = 2 \]

or in tabular form:

=======  ======  
Problem  Result  
=======  ======  
  1+1      2     
=======  ======  

*Highlight box!* 
This environment is used to highlight something::

        \[ E = mc^2 \]



URLs

Testing of URLs: hpl's home page "https://folk.uio.no/hpl":hpl, or
the entire URL if desired, "https://folk.uio.no/hpl":https://folk.uio.no/hpl.  Here is a
plain file link "testdoc.do.txt":testdoc.do.txt, or "testdoc.do.txt":testdoc.do.txt, or
"testdoc.do.txt":testdoc.do.txt or "testdoc.do.txt":testdoc.do.txt or "testdoc.do.txt":a link with
newline. Can test spaces with the link with word
too: "https://folk.uio.no/hpl":hpl or "https://folk.uio.no/hpl":hpl. Also 'file:///' works: "file:///home/hpl/vc/doconce/doc/demos/manual/manual.html":link to a
file is
fine to have. Moreover, "loose" URLs work, i.e., no quotes, just
the plain URL as in "https://folk.uio.no/hpl":https://folk.uio.no/hpl, if followed by space, comma,
colon, semi-colon, question mark, exclamation mark, but not a period
(which gets confused with the periods inside the URL).

Mail addresses can also be used: mailto:hpl@simula.no:'hpl@simula.no', or just a "mailto:hpl@simula.no":mail link, or a raw "mailto:hpl@simula.no":mailto:hpl@simula.no.

Here are some tough tests of URLs, especially for the 'latex' format:
"https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas":Newton-Cotes formulas
and a "https://www.springer.com/mathematics/computational+science+%26+engineering/book/978-3-642-23098-1":good book. Need to test
Newton-Cotes with percentage in URL too:
"https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas":https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas
and "https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae":https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae which has a shebang.

For the '--device=paper' option it is important to test that URLs with
monospace font link text get a footnote
(unless the '--latex_no_program_footnotelink'
is used), as in this reference to
https://github.com/hplgit/INF5620/tree/gh-pages/src/decay/experiments/decay_mod.py:'decay_mod', https://tinyurl.com/pwyasaa/formulas.ball1.py:'ball1.py',
and https://tinyurl.com/pwyasaa/formulas.ball2.py:'ball2.py'.

More tough tests: repeated URLs whose footnotes when using the
'--device=paper' option must be correct. We have
"https://google.com":google, "https://google.com":google, and
"https://google.com":google, which should result in exactly three
footnotes.

# !split and check if these extra words are included properly in the comment

LaTeX Mathematics

Here is an equation without label using backslash-bracket environment::

        \[ a = b + c \]

or with number and label, as in Equation (my:eq1), using the equation environment::

        \begin{equation}
        {\partial u\over\partial t} = \nabla^2 u label{my:eq1}
        \end{equation}

We can refer to this equation by Equation (my:eq1).

Here is a system without equation numbers, using the align-asterisk environment::

        \begin{align*}
        \pmb{a} &= \pmb{q}\times\pmb{n} \\ 
        b &= \nabla^2 u + \nabla^4 v
        \end{align*}

More mathematical typesetting is demonstrated in the coming exercises.

Below, we have "Problem 2: Flip a Coin" and "Project 4: Compute a Probability",
as well as "Project 5: Explore Distributions of Random Circles" and "Project 11: References to Project ref{demo:ex:2} in a heading works for st", and in
between there we have "Exercise 10: Make references to projects and problems".

Exercises

# --- begin exercise ---

Problem 2: Flip a Coin

*a)*
Make a program that simulates flipping a coin N times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

# --- begin hint in exercise ---

*Hint 1.*
Use 'r = random.random()' and define head as 'r <= 0.5'.

# --- end hint in exercise ---

# --- begin hint in exercise ---

*Hint 2.*
Draw an integer among \{1,2\} with
'r = random.randint(1,2)' and define head when 'r' is 1.

# --- end hint in exercise ---

# --- begin answer of exercise ---
*Answer.*
If the 'random.random()' function returns a number <1/2, let it be
head, otherwise tail. Repeat this N number of times.
# --- end answer of exercise ---

# --- begin solution of exercise ---
*Solution.*::

        import sys, random
        N = int(sys.argv[1])
        heads = 0
        for i in range(N):
            r = random.random()
            if r <= 0.5:
                heads += 1
        print('Flipping a coin %d times gave %d heads' % (N, heads))

# --- end solution of exercise ---

*b)*
Vectorize the code in a) using boolean indexing.

Vectorized code can be written in many ways.
Sometimes the code is less intuitive, sometimes not.
At least there is not much to find in the section "Section 1".

*c)*
Vectorize the code in a) using 'numpy.sum'.

# --- begin answer of exercise ---
*Answer.*
'np.sum(np.where(r <= 0.5, 1, 0))' or 'np.sum(r <= 0.5)'.
# --- end answer of exercise ---

In this latter subexercise, we have an
example where the code is easy to read.

My remarks

Remarks with such a subsubsection is treated as more text
after the last subexercise. Test a list too:

1. Mark 1.
2. Mark 2.

Filenames: 'flip_coin.py', 'flip_coin.pdf'.

Remarks

These are the exercise remarks, appearing at the very end.

# --- end exercise ---

Not an exercise

Should be possible to stick a normal section in the middle of many
exercises.

# --- begin exercise ---

Exercise 3: Test of plain text exercise

Very short exercise. What is the capital
of Norway?
Filename: 'myexer1'.

# --- end exercise ---

# --- begin exercise ---

Project 4: Compute a Probability

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval [0,1)?

At the end we have a list because that caused problems in LaTeX
in previous DocOnce versions:

1. item1
2. item2

# --- begin hint in exercise ---

*Hint.*
To answer this question empirically, let a program
draw N such random numbers using Python's standard 'random' module,
count how many of them, M, that fall in the interval (0.5,0.6), and
compute the probability as M/N.

# --- end hint in exercise ---

# --- end exercise ---

# --- begin exercise ---

Project 5: Explore Distributions of Random Circles

The formula for a circle is given by::

        \begin{align}
        x &= x_0 + R\cos 2\pi t,
        label{circle:x}\\ 
        y &= y_0 + R\sin 2\pi t,
        label{circle:y}
        \end{align}

where R is the radius of the circle, (x_0,y_0) is the
center point, and t is a parameter in the unit interval [0,1].
For any t, (x,y) computed from Equations (circle:x)-(circle:y)
is a point on the circle.
The formula can be used to generate 'n' points on a circle::

        import numpy as np
        
        def circle(R, x0, y0, n=501):
            t = np.linspace(0, 1, n)
            x = x0 + R*np.cos(2*np.pi*t)
            y = y0 + R*np.sin(2*np.pi*t)
            return x, y
        
        x, y = circle(2.0, 0, 0)

The goal of this project is to draw N circles with random
center and radius. Plot each circle using the 'circle' function
above.

*a)*
Let R be normally distributed and (x_0,y_0) uniformly distributed.

# --- begin hint in exercise ---

*Hint.*
Use the 'numpy.random' module to draw the
x_0, y_0, and R quantities.

# --- end hint in exercise ---

# --- begin answer of exercise ---
*Answer.*
Here goes the short answer to part a).
# --- end answer of exercise ---

# --- begin solution of exercise ---
*Solution.*
Here goes a full solution to part a).
# --- end solution of exercise ---

*b)*
Let R be uniformly distributed and (x_0,y_0) normally distributed.
Filename: 'norm'.

*c)*
Let R and (x_0,y_0) be normally distributed.

Filename: 'circles'.

Remarks

At the very end of the exercise it may be appropriate to summarize
and give some perspectives.

# --- end exercise ---

# --- begin exercise ---

Exercise 6: Determine some Distance

Intro to this exercise. Questions are in subexercises below.

# --- begin solution of exercise ---
*Solution.*
Here goes a full solution of the whole exercise.
With some math a=b in this solution::

        \[ \hbox{math in solution: } a = b \]

And code 'a=b' in this solution::

        a = b  # code in solution

End of solution is here.

# --- end solution of exercise ---

*a)*
Subexercises are numbered a), b), etc.

# --- begin hint in exercise ---

*Hint 1.*
First hint to subexercise a).
With math a=b in hint::

        \[ a=b. \]

And with code (in plain verbatim) returning x+1 in hint::

        def func(x):
            return x + 1  # with code in hint

# --- end hint in exercise ---

# --- begin hint in exercise ---

*Hint 2.*
Second hint to subexercise a).

Test list in hint:

1. item1
2. item2

# --- end hint in exercise ---
Filename: 'subexer_a.pdf'.

# --- begin answer of exercise ---
*Answer.*
Short answer to subexercise a).
With math in answer: a=b.
# --- end answer of exercise ---

*b)*
Here goes the text for subexercise b).

Some math \cos^2 x + \sin^2 x = 1 written one a single line::

        \[ \cos^2 x + \sin^2 x = 1 \thinspace .\]

# --- begin hint in exercise ---

*Hint.*
A hint for this subexercise.

# --- end hint in exercise ---
Filename: 'subexer_b.pdf'.

# --- begin solution of exercise ---
*Solution.*
Here goes the solution of this subexercise.
# --- end solution of exercise ---

The text here belongs to the main (intro) part of the exercise. Need
closing remarks to have text after subexercises.

Test list in exercise:

1. item1
2. item2

Remarks

Some final closing remarks, e.g., summarizing the main findings
and their implications in other problems can be made. These
remarks will appear at the end of the typeset exercise.

# --- end exercise ---

# --- begin exercise ---

Some exercise without the "Exercise:" prefix

Just some text. And some math saying that e^0=1 on a single line,
to test that math block insertion is correct::

        \[ \exp{(0)} = 1 \]

And a test that the code 'lambda x: x+2' is correctly placed here::

        lambda x: x+2

# --- end exercise ---

# --- begin exercise ---

Exercise 8: Solution of differential equation




Question: Given::

        \[ \frac{dy}{dx} = -y(x),\quad y(0)=1 \]

What is the solution of this equation?

Choice A: y=e^{-y}

Choice B: y=e^{y}

Choice C: 
Code::

        from math import exp
        def f(x):
            return exp(x)

Choice D: The solution cannot be found because there is a derivative in the equation.

Choice E: The equation is meaningless: an equation must be an equation
for x or y, not a function y(x).



# --- end exercise ---

# --- begin exercise ---

Example 9: Just an example

*a)*
What is the capital of Norway?

*Answer.*
Oslo.

# --- end exercise ---

Here goes another section

With some text, before we continue with exercises.

More Exercises

# --- begin exercise ---

Exercise 10: Make references to projects and problems

Pick a statement from "Project 5: Explore Distributions of Random Circles" or "Problem 2: Flip a Coin"
and verify it.

Test list at the end of an exercise without other elements (like subexercise,
hint, etc.):

1. item1
2. item2

Filename: 'verify_formula.py'.

# --- end exercise ---

# --- begin exercise ---

Project 11: References to "Project 4: Compute a Probability" in a heading works for st

Refer to the previous exercise as "Exercise 10: Make references to projects and problems",
the two before that as "Project 4: Compute a Probability" and "Project 5: Explore Distributions of Random Circles",
and this one as "Project 11: References to Project ref{demo:ex:2} in a heading works for st".
Filename: 'selc_composed.pdf'.

# --- end exercise ---

References

 1. **H. P. Langtangen and G. Pedersen**. 
    Propagation of Large Destructive Waves,
    *International Journal of Applied Mechanics and Engineering*,
    7(1),
    pp. 187-204,
    2002.
 2. **H. P. Langtangen, K.-A. Mardal and R. Winther**. 
    Numerical Methods for Incompressible Viscous Flow,
    *Advances in Water Resources*,
    25,
    pp. 1125-1146,
    2002.
 3. **H. P. Langtangen**. 
    Numerical Solution of First Passage Problems in Random Vibrations,
    *SIAM Journal of Scientific and Statistical Computing*,
    15,
    pp. 997-996,
    1994.
 4. **K.-A. Mardal, G. W. Zumbusch and H. P. Langtangen**. 
    Software Tools for Multigrid Methods,
    *Advanced Topics in Computational Partial Differential Equations -- Numerical Methods and Diffpack Programming*,
    edited by **H. P. Langtangen and A. Tveito**,
    Springer,
    2003,
    Edited book,
    "http://some.where.org":http://some.where.org.
 5. **H. P. Langtangen**. 
    The FEMDEQS Program System,
    *Department of Mathematics, University of Oslo*,
    1989,
    "http://www.math.uio.no/old/days/hpl/femdeqs.pdf":http://www.math.uio.no/old/days/hpl/femdeqs.pdf.
 6. **H. P. Langtangen**. 
    Stochastic Breakthrough Time Analysis of an Enhanced Oil Recovery Process,
    *SIAM Journal on Scientific Computing*,
    13,
    pp. 1394-1417,
    1992.
 7. **M. Mortensen, H. P. Langtangen and G. N. Wells**. 
    A FEniCS-Based Programming Framework for Modeling Turbulent Flow by the Reynolds-Averaged Navier-Stokes Equations,
    *Advances in Water Resources*,
    34(9),
    "https://dx.doi.org/10.1016/j.advwatres.2011.02.013":doi: 10.1016/j.advwatres.2011.02.013,
    2011.
 8. **S. Glimsdal, G. Pedersen, K. Atakan, C. B. Harbitz, H. P. Langtangen and F. L\ovholt**. 
    Propagation of the Dec. 26, 2004 Indian Ocean Tsunami: Effects of Dispersion and Source Characteristics,
    *International Journal of Fluid Mechanics Research*,
    33(1),
    pp. 15-43,
    2006.
 9. **S. Rahman, J. Gorman, C. H. W. Barnes, D. A. Williams and H. P. Langtangen**. 
    Numerical Investigation of a Piezoelectric Surface Acoustic Wave Interaction With a One-Dimensional Channel,
    *Physical Review B: Condensed Matter and Materials Physics*,
    74,
    2006,
    035308.
10. **J. B. Haga, H. Osnes and H. P. Langtangen**. 
    On the Causes of Pressure Oscillations in Low-Permeable and Low-Compressible Porous Media,
    *International Journal of Analytical and Numerical Methods in Geomechanics*,
    "https://dx.doi.org/10.1002/nag.1062":doi: 10.1002/nag.1062,
    2011,
    "http://onlinelibrary.wiley.com/doi/10.1002/nag.1062/abstract":http://onlinelibrary.wiley.com/doi/10.1002/nag.1062/abstract.
11. **H. P. Langtangen**. 
    *Computational Partial Differential Equations - Numerical Methods and Diffpack Programming*,
    second edition,
    *Texts in Computational Science and Engineering*,
    Springer,
    2003.
12. **H. P. Langtangen**. 
    *Python Scripting for Computational Science*,
    third edition,
    *Texts in Computational Science and Engineering*,
    Springer,
    2008.
13. **H. P. Langtangen and G. Pedersen**. 
    Finite Elements for the Boussinesq Wave Equations,
    Waves and Non-linear Processes in Hydrodynamics,
    edited by **J. Grue, B. Gjevik and J. E. Weber**,
    Kluwer Academic Publishers,
    pp. pp. 117-126,
    1995,
    "http://www.amazon.ca/Waves-Nonlinear-Processes-Hydrodynamics-John/dp/0792340310":http://www.amazon.ca/Waves-Nonlinear-Processes-Hydrodynamics-John/dp/0792340310.
14. **H. P. Langtangen**. 
    *A Primer on Scientific Programming With Python*,
    third edition,
    *Texts in Computational Science and Engineering*,
    Springer,
    2012.
15. **P. V. Jeberg, H. P. Langtangen and C. B. Terp**. 
    Optimization With Diffpack: Practical Example From Welding,
    *Simula Research Laboratory*,
    2004,
    Internal report.
16. **H. P. Langtangen**. 
    Computational Methods for Two-Phase Flow in Oil Reservoirs,
    Ph.D. Thesis,
    Mechanics Division, Department of Mathematics, University of Oslo,
    1989,
    Dr. Scient. thesis..
17. **H. P. Langtangen**. 
    Computational Modeling of Huge Tsunamis From Asteroid Impacts,
    2007,
    Invited keynote lecture at the \emphInternational conference on Computational Science 2007 (ICCS'07), Beijing, China.
18. **H. P. Langtangen**. 
    Solution of the Navier-Stokes Equations With the Finite Element Method in Two and Three Dimensions,
    M.Sc. Thesis,
    Mechanics Division, Department of Mathematics, University of Oslo,
    1985,
    Cand.Scient. thesis.
19. **H. P. Langtangen and A. Tveito**. 
    Numerical Methods in Continuum Mechanics,
    *Center for Industrial Research*,
    1991,
    Lecture notes for a course (ME-IN 324). 286 pages..
20. **H. P. Langtangen**. 
    Diffpack: Software for Partial Differential Equations,
    *Proceedings of the Second Annual Object-Oriented Numerics Conference (OON-SKI'94), Sunriver, Oregon, USA*,
    edited by **A. Vermeulen**,
    1994.

Appendix: Just for testing; part I

This is the first appendix.

A subsection within an appendix

Some text.

Appendix: Just for testing; part II

This is more stuff for an appendix.

Appendix: Testing identical titles

Without label.

Appendix: Testing identical titles

With label.

Appendix: Testing identical titles

What about inserting a quiz?




Fundamental test: What is the capital of Norway?

Answer 1: Stockholm

Answer 2: London

Answer 3: Oslo

Choice D: Bergen



Appendix: Testing identical titles

Without label.

*Tip.* 
Here is a tip or hint box, typeset as a notice box.



Need a lot of text to surround the summary box.
Version control systems allow you to record the history of files
and share files among several computers and collaborators in a
professional way. File changes on one computer are updated or
merged with changes on another computer. Especially when working
with programs or technical reports it is essential
to have changes documented and to
ensure that every computer and person involved in the project
have the latest updates of the files.
Greg Wilson' excellent "https://software-carpentry.org/2010/07/script-for-introduction-to-version-control/":Script for Introduction to Version Control provides a more detailed motivation why you will benefit greatly
from using version control systems.

*Summary.* 
**Bold remark:** Make some text with this summary.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.



Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that site. I strongly
recommend you to use such sites for all serious programming and
scientific writing work - and all other important files.

The simplest services for hosting project files are "https://dropbox.com":Dropbox and "https://drive.google.com":Google Drive.
It is very easy to get started with these systems, and they allow you
to share files among laptops and mobile units with as many users as
you want. The systems offer a kind of version control in that the
files are stored frequently (several times per minute), and you can go
back to previous versions for the last 30 days. However, it is
challenging  to find the right version from the past when there are
so many of them.

More seriously, when several people may edit files simultaneously, it
can be difficult detect who did what when, roll back to previous
versions, and to manually merge the edits when these are
incompatible. Then one needs more sophisticated tools than Dropbox or
Google Drive: project hosting services with true version control
systems.  The following text aims at providing you with the minimum
information to started with such systems. Numerous other tutorials
contain more comprehensive material and in-depth explanations of the
concepts and tools.

The idea with project hosting services is that you have the files
associated with a project in the cloud. Many people may share these
files.  Every time you want to work on the project you explicitly
update your version of the files, edit the files as you like, and
synchronize the files with the "master version" at the site where the
project is hosted.  If you at some point need to go back to a
version of the files at some particular point in the past,
this is an easy operation. You can also use tools to see
what various people have done with the files in the various versions.

All these services are very similar. Below we describe how you get
started with Bitbucket, GitHub, and Googlecode. Launchpad works very
similarly to the latter three. All the project hosting services have
excellent introductions available at their web sites, but the recipes
below are much shorter and aim at getting you started as quickly as
possible by concentrating on the most important need-to-know steps.
The Git tutorials we refer to later in this document contain more
detailed information and constitute of course very valuable readings
when you use version control systems every day. The point now is
to get started.

Appendix: Testing inline comments

Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that
site. [hpl's semi opinion 1: not sure if in the cloud is
understood by
all.] I strongly recommend you to use such sites for all serious
programming and scientific writing work - and all other important
files.

The simplest services for hosting project files is Dropbox. [mp 2: Simply go to "https://dropbox.com":https://dropbox.com and watch the video. It explains
how files, like 'myfile.py', perhaps containing much math, like
\partial u/\partial t, are easily communicated between machines.] It
is very easy to get started with Dropbox, and it allows you to share
files among [hpl 3: laptops and mobile units -> computers, tablets,
and phones].

------

First[add 4: ,] consider a quantity Q. [edit 5: To this end, -> We note that]
Q>0, because [del 6: a] negative [edit 7: quantity is -> quantities
are] [del 8: just] negative. [add 9: This comes as no surprise.]

Let us refer to Figure ref{fig:impact} again.

Test references in a list:

 - "Section 1"
 - "Subsection 1"
 - ref{fig:impact}

Appendix: Testing headings ending with 'verbatim inline'

The point here is to test 1) 'verbatim' code in headings, and 2)
ending a heading with verbatim code as this triggers a special
case in LaTeX.

We also test mdash---used as alternative to hyphen without spaces around,
or in quotes:





The ndash should also be tested - as in the Hanson - Nilson equations
on page 277 - 278.

And finally, what about admons, quotes, and boxes? They are tested
in a separate document: 'admon.do.txt'.

[^example-of-the-third-footnote]: Not much to add here, but the footnote
is at the end with only one newline.
************** File: testdoc.epytext *****************
TITLE: A Document for Testing DocOnce
BY: Hans Petter Langtangen (Center for Biomedical Computing, Simula Research Laboratory, and Department of Informatics, University of Oslo); Kaare Dump (Segfault, Cyberspace); A. Dummy Author; I. S. Overworked and Outburned (Inst1, and Inst2, Somewhere, and Third Inst, Elsewhere, and Fourth Inst); J. Doe
DATE: Jan 32, 2100
Made with DocOnce

# !split

The format of this document is
epytext

I{Abstract.} This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.

Section 1
=========

Here is a nested list:

  - item1
  - item2
  - item3 which continues
    on the next line to test that feature
  - and a sublist
    - with indented subitem1
    - and a subitem2

  - and perhaps an ordered sublist
   a. first item
   b. second item,
      continuing on a new line

I{Here is a list with paragraph heading.}

  - item1
  - item2

Here is a list with subsubsection heading
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  - item1
  - item2





Here are two references. Equation (ref{my:eq1}) is fine. Eq. (ref{my:eq1}) too.
Even Equation (ref{my:eq1}) without the tilde.

Subsection 1
------------

More text, with a reference back to
the section "Section 1" and "Subsection 1", and further to the
the sections "Subsection 1" and "URLs", which
encourages you to do the tasks in "Problem 2: Flip a Coin" and "Exercise 10: Make references to projects and problems".
 "Appendix: Just for testing; part I" and "Appendix: Just for testing; part II" are also nice elements.

Test Section reference at beginning of line and after a sentence
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The section "Subsection 1" is fine.
The section "URLs" too.

Computer code
~~~~~~~~~~~~~

Let's do some copying from files too. First from subroutine up to the very end::

              subroutine test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return

and then just the subroutine::

        
              subroutine test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return

and finally the complete file with a plain text verbatim environment
(C{envir=ccq})::

        C     a comment
        
              subroutine test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return

Testing other code environments. First Python::

        !bc pycod
        def f(x):
            return x+1
        !ec

which gets rendered as::

        def f(x):
            return x+1

Here is a program that is supposed to be interactive via
Python Online Tutorial, but that service is not accessible
for the present format::

        class Line:
            def __init__(self, a, b):
                self.a, self.b = a, b
        
            def __call__(self, x):
                a, b = self.a, self.b
                return a*x + b
        
        line = Line(2, 1)
        y = line(x=3)
        print(y)

Some more Python code (actually specified as a sage cell, but
such cells are not supported by this format)::

        a = 2
        b = 3
        print('a+b:', a + b)
        
        # In a sage cell we can also plot
        from matplotlib.pyplot import *
        from numpy import *
        x = linspace(0, 4*pi, 101)
        y = exp(-0.1*x)*cos(x)
        plot(x, y)
        xlabel('x'); ylabel('y')
        show()

Then Cython (with -h option so it is hidden in html/sphinx)::

        cpdef f(double x):
            return x + 1

Standard Python shell sessions::

        >>> from numpy import linspace, sin
        >>> # Some comment
        >>> x = linspace(0, 2, 11)
        >>> y = sin(x)
        >>> y[0]
        0
        >>> import matplotlib.pyplot as plt
        >>> plt.plot(x, y)

Similar IPython sessions::

            NOTE: A verbatim block has been removed because
                  it causes problems for Epytext.

Here is the interactive session again, but with C{pyshell-t}::

        >>> from numpy import linspace, sin
        >>> # Some comment
        >>> x = linspace(0, 2, 11)
        >>> y = sin(x)
        >>> y[0]
        0
        >>> import matplotlib.pyplot as plt
        >>> plt.plot(x, y)

C++::

        #include <iostream>
        
        int main()
        {
           std::cout << "Sample output" << std::endl;
           return 0
        }

And a little bit of Fortran: :dizzy_face::

        !bc cod
              subroutine midpt(x, length, a, b)
              real*8 a, b, x
              x = (a + b)/2
              length = b - a
              return
              end
        !ec

which then is typeset as::

              subroutine midpt(x, length, a, b)
              real*8 a, b, x
              x = (a + b)/2
              length = b - a
              return
              end

HTML::

        <table>
        <tr><td>Column 1</td><td>Column 2</td></tr>
        <tr><td>0.67526 </td><td>0.92871 </td></tr>
        <!-- comment -->
        </table>

But inline HTML code is also important, like text that starts with
C{<a href="} (which can destroy the following text if not properly
quoted).

Matlab with comments requires special typesetting::

        % Comment on the beginning of the line can be escaped by %%
        if a > b
          % Indented comment needs this trick
          c = a + b
        end

And here is a system call::

        Terminal> mkdir test
        Terminal> cd test
        Terminal> myprog -f
        output1
        output2

Any valid pygments lexer/language name can appear to, e.g.::

        !bc restructuredtext
        =======
        Heading
        =======
        
        Some text.
        !ec

results in::

        =======
        Heading
        =======
        
        Some text.

Finally, C{!bc do} supports highlighting of DocOnce source::

            NOTE: A verbatim block has been removed because
                  it causes problems for Epytext.

It is time to test C{verbatim inline font} especially with C{a newline
inside the text} and an exclamation mark at the end: C{BEGIN}! For
spellcheck, test C{a verbatim expression} in C{another} in a C{third}.
Also test exclamation mark as in C{!bc} and C{!ec} as well as C{a != b}.
Also test backslashes and braces like C{\begin}, C{\begin{enumerate}},
C{\end{this}\end{that}}, and C{{something \inside braces}}.

The following attempt to exemplify colored text does not work in
format epytext.
Here is some red color and an attempt to write with
green color containing a linebreak
code. Some formats will only display 
this correctly when C{html} 
is the output format.
But here some more running text is added which is not part of
the previous blocks with line breaks.

Running OS commands
~~~~~~~~~~~~~~~~~~~

            NOTE: A verbatim block has been removed because
                  it causes problems for Epytext.

Footnotes
~~~~~~~~~

Here is a test of footnotes [^footnote], which are handy in text.
They are used in different flavors, now in

 - list items (note below that footnotes work after math, verbatim, and URLs - bin fact old and emphasize too!)
 - even with math M{\nabla^2u}[^math1]
 - and code C{h[i] += 1}[^code]
   (I{must} have space between inline code and footnote!)
 - and U{links<https://google.com>}[^google-search]

which gives flexibility in writing.
This is the third[^example-of-the-third-footnote] example.

  [^footnote]: Typesetting of the footnote depends on the format.
Plain text does nothing, LaTeX removes the
definition and inserts the footnote as part of the LaTeX text.
reStructuredText and Sphinx employ a similar type of typesetting
as Extended Markdown and DocOnce, and in HTML we keep the same
syntax, just displayed properly in HTML.
[^math1]: Math footnotes can be dangerous since it
interferes with an exponent.
[^code]: One-line footnote.

[^google-search]: U{google.com<google.com>} is perhaps the most famous
web site today.

Here is some more text before a new definition of a footnote that was
used above.

I{Non-breaking space character.} 
This paragraph aims to test U{non-breaking space character<https://en.wikipedia.org/wiki/Non-breaking_space>}, and a typical
example where this is needed is in physical units: 7.4 km is traveled
in M{7.4/5.5\approx 1.345} s.  Also check that a U{link<https://google.com>} is
not broken across lines (drag the browser window to test this).
(On the other hand, the tilde is used in
computer code, e.g., as in C{[~x for x in y]} or in C{y=~x}, and should
of course remain a tilde in those contexts.)



Subsection 2: Testing figures
-----------------------------

Test of figures. In particular we refer to Figure ref{fig:impact} in which
there is a flow.

FIGURE:[../doc/src/manual/fig/wave1D, width=200] Visualization B{of} a I{wave}. {fig:impact}

Figures without captions are allowed and will be inlined.

FIGURE:[../doc/src/manual/fig/wave1D, width=200]

Here is figure ref{myfig} with a long (illegal) multi-line caption
containing inline verbatim text:

FIGURE: [../doc/src/manual/fig/wave1D.png, width=500 sidecap=True] A long caption spanning several lines and containing verbatim words like C{my_file_v1} and C{my_file_v2} as well as math with subscript as in M{t_{i+1}}. {myfig} 

Test URL as figure name:

FIGURE: [https://raw.github.com/doconce/doconce/master/doc/src/blog/f_plot.png, width=500 frac=0.8]

I{Remark.}
Movies are tested in separate file C{movies.do.txt}.

The M{\theta} parameter (not M{\nabla}?)
----------------------------------------

Functions do not always need to be advanced, here is one
involving M{\theta}::

        def f(theta):
            return theta**2

I{More on M{\theta}.} Here is more text following headline with math.

Newcommands must also be tested in this test report:
M{\frac{1}{2}}, M{{1/2}}, M{\pmb{x}}, M{\frac{Du}{dt}},
both inline and in block::

            NOTE: A verbatim block has been removed because
                  it causes problems for Epytext.

Or with align with label and numbers::

        \begin{align}
        \frac{Du}{dt} &= 0
        label{aligneq1}
        \\ 
        \frac{1}{2} &= {1/2}\\ 
        \frac{1}{2}\pmb{x} &= \pmb{n}
        label{aligneq2}
        \end{align}

First one numbered (automatically)::

            NOTE: A verbatim block has been removed because
                  it causes problems for Epytext.

Second numbered (automatically)::

            NOTE: A verbatim block has been removed because
                  it causes problems for Epytext.

Both numbered, with label by the user::

        \begin{align}
        \begin{pmatrix}
        G_1 + G_2\\ 
        -G_3 & G_4
        \end{pmatrix}
        &=
        \begin{pmatrix}
         v_1 \\ 
         v_2
        \end{pmatrix}
        + \cdots label{mymatrix:eq1}
        \\ 
        label{mymatrix:eq2}
        \left(\begin{array}{ll}
        y & 2\\ 
        2 & 1
        \end{array}\right)
        \left(\begin{array}{ll}
        0 \\ x
        \end{array}\right)
        &= \begin{pmatrix}
        A \\ B
        \end{pmatrix}
        \end{align}

Now we refer to Equations (mymatrix:eq1)-(mymatrix:eq2).

Custom Environments
-------------------

Here is an attempt to create a theorem environment via Mako
(for counting theorems) and comment lines to help replacing lines in
the C{.tex} by proper begin-end LaTeX environments for theorems.
Should look nice in most formats!

I{Theorem 5.}
Let M{a=1} and M{b=2}. Then M{c=3}.

I{Proof.}
Since M{c=a+b}, the result follows from straightforward addition.
M{END}

As we see, the proof of Theorem 5 is a modest
achievement.

Tables
------

Let us take this table from the manual:

====  ========  ============  
time  velocity  acceleration  
====  ========  ============  
0.0     1.4186         -5.01  
2.0   1.376512        11.919  
4.0     1.1E+1     14.717624  
====  ========  ============  

The DocOnce source code reads::

        
          |--------------------------------|
          |time  | velocity | acceleration |
          |--l--------r-----------r--------|
          | 0.0  | 1.4186   | -5.01        |
          | 2.0  | 1.376512 | 11.919       |
          | 4.0  | 1.1E+1   | 14.717624    |
          |--------------------------------|
        

Here is yet another table to test that we can handle more than
one table:

====  ========  ============  
time  velocity  acceleration  
====  ========  ============  
0.0   1.4186    -5.01         
1.0   1.376512  11.919        
3.0   1.1E+1    14.717624     
====  ========  ============  

And one with math headings (that are expanded and must be treated
accordingly), verbatim heading and entry, and no space around the pipe
symbol:

====  ======  ===========  =======  
M{i}  M{h_i}  M{\bar T_i}   C{L_i}  
====  ======  ===========  =======  
0          0          288  -0.0065  
1     11,000          216      0.0  
2     20,000          216    0.001  
3     32,000          228   0.0028  
4     47,000          270      0.0  
5     51,000          270  -0.0028  
6     71,000          214   C{NaN}  
====  ======  ===========  =======  

And add one with verbatim headings (with underscores),
and rows starting with C{|-} because of a negative number,
and C{|} right before and after verbatim word (with no space):

=====  ======  ===============  ==========  
exact  C{v_1}  M{a_i} + C{v_2}  C{verb_3_}  
=====  ======  ===============  ==========  
    9    9.62             5.57        8.98  
  -20  -23.39            -7.65      -19.93  
   10   17.74            -4.50        9.96  
    0   -9.19             4.13       -0.26  
=====  ======  ===============  ==========  

Pipe symbols in verbatim and math text in tables used to pose difficulties,
but not
anymore:

===========  ==============  
    M{S}        command      
===========  ==============  
$ ||a_0|| $  C{norm|length}  
M{x\cap y}           C{x|y}  
===========  ==============  

Here is a table with X alignment:

=====  ========================================================================================================================================================================================================================  
 Type                                                                                                        Description                                                                                                         
=====  ========================================================================================================================================================================================================================  
  X    Alignment character that is used for specifying a potentially very long text in a column in a table. It makes use of the C{tabularx} package in LaTeX, otherwise (for other formats) it means C{l} (centered alignment).  
l,r,c  standard alignment characters                                                                                                                                                                                             
=====  ========================================================================================================================================================================================================================  

Finally, a table with math
and URLs.

========================  ===========================================================  ===========================================================  
                                                                                                                                                    
========================  ===========================================================  ===========================================================  
    M{\mathcal{L}=0}      U{C{080}<../doc/src/manual/mov/wave_frames/frame_0080.png>}  U{C{085}<../doc/src/manual/mov/wave_frames/frame_0085.png>}  
         M{a=b}           U{C{090}<../doc/src/manual/mov/wave_frames/frame_0090.png>}  U{C{095}<../doc/src/manual/mov/wave_frames/frame_0095.png>}  
M{\nabla\cdot\bm{u} =0 }  U{C{100}<../doc/src/manual/mov/wave_frames/frame_0100.png>}  U{C{105}<../doc/src/manual/mov/wave_frames/frame_0105.png>}  
========================  ===========================================================  ===========================================================  

A test of verbatim words in heading with subscript M{a_i}: C{my_file_v1} and C{my_file_v2}
------------------------------------------------------------------------------------------

I{Paragraph with verbatim and math: C{my_file_v1.py} and C{my_file_v2.py} define some math M{a_{i-1}}.} Here is more C{__verbatim__} code and
some plain text on a new line.

B{Just bold}
------------

Some text.

I{Just emphasize}
-----------------

Some text.

C{Just verbatim}
----------------

Some text.

B{Bold} beginning
-----------------

Some text.

I{Emphasize} beginning
----------------------

Some text.

C{Verbatim} beginning
---------------------

Some text.

Maybe B{bold end}
-----------------

Some text.

Maybe I{emphasize end}
----------------------

Some text.

Maybe C{verbatim end}
---------------------

Some text.

The middle has B{bold} word
---------------------------

Some text.

The middle has I{emphasize} word
--------------------------------

Some text.

The middle has C{verbatim} word
-------------------------------

Some text.

I{I{Just emphasize}.} Some text.

I{C{Just verbatim}.} Some text.

I{I{Emphasize} beginning.} Some text.

I{C{Verbatim beginning}.} Some text.

I{Maybe I{emphasize end}.} Some text.

I{Maybe C{verbatim end}.} Some text.

I{The middle has I{emphasize} word.} Some text.

I{The middle has C{verbatim} word.} Some text.

I{Ampersand.}
We can test Hennes & Mauritz, often abbreviated H&M, but written
as C{Hennes & Mauritz} and C{H & M}.
A sole C{&} must also work::

        # Just to check that ampersand works in code blocks:
        c = a & b

I{Quotes.}
Let us also add a test of quotes such as "double quotes, with numbers
like 3.14 and newline/comma and hyphen (as in double-quote)"; written
in the standard LaTeX-style that gives correct LaTeX formatting and
ordinary double quotes for all non-LaTeX formats.  Here is another
sentence that "caused" a bug in the past because double backtick
quotes could imply verbatim text up to a verbatim word starting with
period, like C{.txt}.

More quotes to be tested for spellcheck:
("with parenthesis"), "with newline"
and "with comma", "hyphen"-wise, and "period".

Bibliography test
-----------------

Here is an example: [1] discussed propagation of
large destructive water waves, [2] gave
an overview of numerical methods for solving the Navier - Stokes equations,
while the use of Backward Kolmogorov equations for analyzing
random vibrations was investigated in [3].
The book chapter [4] contains information on
C++ software tools for programming multigrid methods. A real retro
reference is [5] about a big FORTRAN package.
Multiple references are also possible, e.g., see
[1] [4].

We need to cite more than 10 papers to reproduce an old formatting
problem with blanks in the keys in reST format:
[6] [3] [7] [1]
and
[2] [8] [9] [10] [11] [12] [13]
and all the work of
[14] [4] [15] as well as
old work [5] and [16], and the
talk [17].
Langtangen also had two thesis [18] [16]
back in the days.
More retro citations are
the old ME-IN323 book [19] and the
[20] OONSKI '94 paper.

# --- begin exercise ---

Example 1: Examples can be typeset as exercises
-----------------------------------------------

Examples can start with a subsection heading starting with C{Example:}
and then, with the command-line option C{--examples_as_exercises} be
typeset as exercises. This is useful if one has solution
environments as part of the example.

I{a)}
State some problem.

I{Solution.}
The answer to this subproblem can be written here.

I{b)}
State some other problem.

I{Hint 1.}
A hint can be given.

I{Hint 2.}
Maybe even another hint?

I{Solution.}
The answer to this other subproblem goes here,
maybe over multiple doconce input lines.

# --- end exercise ---

User-defined environments
-------------------------

The example in the section "Example 1: A test function" demonstrates how to write a test function.
That is, a special test function for a function C{add} appears in
the example in the section "Example 1: A test function".

Example 1: A test function
--------------------------

Suppose we want to write a test function for checking the
implementation of a Python function for addition::

        def add(a, b):
            return a + b
        
        def test_add():
            a = 1; b = 1
            expected = a + b
            computed = add(a, b)
            assert expected == computed

Example 2: Addition
-------------------

We have::

        \[ 1 + 1 = 2 \]

or in tabular form:

=======  ======  
Problem  Result  
=======  ======  
 M{1+1}   M{2}   
=======  ======  

I{Highlight box!} 
This environment is used to highlight something::

        \[ E = mc^2 \]



URLs
----

Testing of URLs: hpl's home page U{hpl<https://folk.uio.no/hpl>}, or
the entire URL if desired, U{https://folk.uio.no/hpl<https://folk.uio.no/hpl>}.  Here is a
plain file link U{testdoc.do.txt<testdoc.do.txt>}, or U{testdoc.do.txt<testdoc.do.txt>}, or
U{testdoc.do.txt<testdoc.do.txt>} or U{testdoc.do.txt<testdoc.do.txt>} or U{a link with
newline<testdoc.do.txt>}. Can test spaces with the link with word
too: U{hpl<https://folk.uio.no/hpl>} or U{hpl<https://folk.uio.no/hpl>}. Also C{file:///} works: U{link to a
file<file:///home/hpl/vc/doconce/doc/demos/manual/manual.html>} is
fine to have. Moreover, "loose" URLs work, i.e., no quotes, just
the plain URL as in U{https://folk.uio.no/hpl<https://folk.uio.no/hpl>}, if followed by space, comma,
colon, semi-colon, question mark, exclamation mark, but not a period
(which gets confused with the periods inside the URL).

Mail addresses can also be used: U{C{hpl@simula.no}<mailto:hpl@simula.no>}, or just a U{mail link<mailto:hpl@simula.no>}, or a raw U{mailto:hpl@simula.no<mailto:hpl@simula.no>}.

Here are some tough tests of URLs, especially for the C{latex} format:
U{Newton-Cotes<https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas>} formulas
and a U{good book<https://www.springer.com/mathematics/computational+science+%26+engineering/book/978-3-642-23098-1>}. Need to test
Newton-Cotes with percentage in URL too:
U{https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas<https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas>}
and U{https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae<https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae>} which has a shebang.

For the C{--device=paper} option it is important to test that URLs with
monospace font link text get a footnote
(unless the C{--latex_no_program_footnotelink}
is used), as in this reference to
U{C{decay_mod}<https://github.com/hplgit/INF5620/tree/gh-pages/src/decay/experiments/decay_mod.py>}, U{C{ball1.py}<https://tinyurl.com/pwyasaa/formulas.ball1.py>},
and U{C{ball2.py}<https://tinyurl.com/pwyasaa/formulas.ball2.py>}.

More tough tests: repeated URLs whose footnotes when using the
C{--device=paper} option must be correct. We have
U{google<https://google.com>}, U{google<https://google.com>}, and
U{google<https://google.com>}, which should result in exactly three
footnotes.

# !split and check if these extra words are included properly in the comment

LaTeX Mathematics
=================

Here is an equation without label using backslash-bracket environment::

        \[ a = b + c \]

or with number and label, as in Equation (my:eq1), using the equation environment::

            NOTE: A verbatim block has been removed because
                  it causes problems for Epytext.

We can refer to this equation by Equation (my:eq1).

Here is a system without equation numbers, using the align-asterisk environment::

            NOTE: A verbatim block has been removed because
                  it causes problems for Epytext.

More mathematical typesetting is demonstrated in the coming exercises.

Below, we have "Problem 2: Flip a Coin" and "Project 4: Compute a Probability",
as well as "Project 5: Explore Distributions of Random Circles" and "Project 11: References to Project ref{demo:ex:2} in a heading works for epytext", and in
between there we have "Exercise 10: Make references to projects and problems".

Exercises
=========

# --- begin exercise ---

Problem 2: Flip a Coin
----------------------

I{a)}
Make a program that simulates flipping a coin M{N} times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

# --- begin hint in exercise ---

I{Hint 1.}
Use C{r = random.random()} and define head as C{r <= 0.5}.

# --- end hint in exercise ---

# --- begin hint in exercise ---

I{Hint 2.}
Draw an integer among M{\{1,2\}} with
C{r = random.randint(1,2)} and define head when C{r} is 1.

# --- end hint in exercise ---

# --- begin answer of exercise ---
I{Answer.}
If the C{random.random()} function returns a number M{<1/2}, let it be
head, otherwise tail. Repeat this M{N} number of times.
# --- end answer of exercise ---

# --- begin solution of exercise ---
I{Solution.}::

        import sys, random
        N = int(sys.argv[1])
        heads = 0
        for i in range(N):
            r = random.random()
            if r <= 0.5:
                heads += 1
        print('Flipping a coin %d times gave %d heads' % (N, heads))

# --- end solution of exercise ---

I{b)}
Vectorize the code in a) using boolean indexing.

Vectorized code can be written in many ways.
Sometimes the code is less intuitive, sometimes not.
At least there is not much to find in the section "Section 1".

I{c)}
Vectorize the code in a) using C{numpy.sum}.

# --- begin answer of exercise ---
I{Answer.}
C{np.sum(np.where(r <= 0.5, 1, 0))} or C{np.sum(r <= 0.5)}.
# --- end answer of exercise ---

In this latter subexercise, we have an
example where the code is easy to read.

My remarks
~~~~~~~~~~

Remarks with such a subsubsection is treated as more text
after the last subexercise. Test a list too:

1. Mark 1.
2. Mark 2.

Filenames: C{flip_coin.py}, C{flip_coin.pdf}.

Remarks
~~~~~~~

These are the exercise remarks, appearing at the very end.

# --- end exercise ---

Not an exercise
---------------

Should be possible to stick a normal section in the middle of many
exercises.

# --- begin exercise ---

Exercise 3: Test of plain text exercise
---------------------------------------

Very short exercise. What is the capital
of Norway?
Filename: C{myexer1}.

# --- end exercise ---

# --- begin exercise ---

Project 4: Compute a Probability
--------------------------------

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval M{[0,1)}?

At the end we have a list because that caused problems in LaTeX
in previous DocOnce versions:

1. item1
2. item2

# --- begin hint in exercise ---

I{Hint.}
To answer this question empirically, let a program
draw M{N} such random numbers using Python's standard C{random} module,
count how many of them, M{M}, that fall in the interval M{(0.5,0.6)}, and
compute the probability as M{M/N}.

# --- end hint in exercise ---

# --- end exercise ---

# --- begin exercise ---

Project 5: Explore Distributions of Random Circles
--------------------------------------------------

The formula for a circle is given by::

        \begin{align}
        x &= x_0 + R\cos 2\pi t,
        label{circle:x}\\ 
        y &= y_0 + R\sin 2\pi t,
        label{circle:y}
        \end{align}

where M{R} is the radius of the circle, M{(x_0,y_0)} is the
center point, and M{t} is a parameter in the unit interval M{[0,1]}.
For any M{t}, M{(x,y)} computed from Equations (circle:x)-(circle:y)
is a point on the circle.
The formula can be used to generate C{n} points on a circle::

        import numpy as np
        
        def circle(R, x0, y0, n=501):
            t = np.linspace(0, 1, n)
            x = x0 + R*np.cos(2*np.pi*t)
            y = y0 + R*np.sin(2*np.pi*t)
            return x, y
        
        x, y = circle(2.0, 0, 0)

The goal of this project is to draw M{N} circles with random
center and radius. Plot each circle using the C{circle} function
above.

I{a)}
Let M{R} be normally distributed and M{(x_0,y_0)} uniformly distributed.

# --- begin hint in exercise ---

I{Hint.}
Use the C{numpy.random} module to draw the
M{x_0}, M{y_0}, and M{R} quantities.

# --- end hint in exercise ---

# --- begin answer of exercise ---
I{Answer.}
Here goes the short answer to part a).
# --- end answer of exercise ---

# --- begin solution of exercise ---
I{Solution.}
Here goes a full solution to part a).
# --- end solution of exercise ---

I{b)}
Let M{R} be uniformly distributed and M{(x_0,y_0)} normally distributed.
Filename: C{norm}.

I{c)}
Let M{R} and M{(x_0,y_0)} be normally distributed.

Filename: C{circles}.

Remarks
~~~~~~~

At the very end of the exercise it may be appropriate to summarize
and give some perspectives.

# --- end exercise ---

# --- begin exercise ---

Exercise 6: Determine some Distance
-----------------------------------

Intro to this exercise. Questions are in subexercises below.

# --- begin solution of exercise ---
I{Solution.}
Here goes a full solution of the whole exercise.
With some math M{a=b} in this solution::

        \[ \hbox{math in solution: } a = b \]

And code C{a=b} in this solution::

        a = b  # code in solution

End of solution is here.

# --- end solution of exercise ---

I{a)}
Subexercises are numbered a), b), etc.

# --- begin hint in exercise ---

I{Hint 1.}
First hint to subexercise a).
With math M{a=b} in hint::

        \[ a=b. \]

And with code (in plain verbatim) returning M{x+1} in hint::

        def func(x):
            return x + 1  # with code in hint

# --- end hint in exercise ---

# --- begin hint in exercise ---

I{Hint 2.}
Second hint to subexercise a).

Test list in hint:

1. item1
2. item2

# --- end hint in exercise ---
Filename: C{subexer_a.pdf}.

# --- begin answer of exercise ---
I{Answer.}
Short answer to subexercise a).
With math in answer: M{a=b}.
# --- end answer of exercise ---

I{b)}
Here goes the text for subexercise b).

Some math M{\cos^2 x + \sin^2 x = 1} written one a single line::

        \[ \cos^2 x + \sin^2 x = 1 \thinspace .\]

# --- begin hint in exercise ---

I{Hint.}
A hint for this subexercise.

# --- end hint in exercise ---
Filename: C{subexer_b.pdf}.

# --- begin solution of exercise ---
I{Solution.}
Here goes the solution of this subexercise.
# --- end solution of exercise ---

The text here belongs to the main (intro) part of the exercise. Need
closing remarks to have text after subexercises.

Test list in exercise:

1. item1
2. item2

Remarks
~~~~~~~

Some final closing remarks, e.g., summarizing the main findings
and their implications in other problems can be made. These
remarks will appear at the end of the typeset exercise.

# --- end exercise ---

# --- begin exercise ---

Some exercise without the "Exercise:" prefix
--------------------------------------------

Just some text. And some math saying that M{e^0=1} on a single line,
to test that math block insertion is correct::

        \[ \exp{(0)} = 1 \]

And a test that the code C{lambda x: x+2} is correctly placed here::

        lambda x: x+2

# --- end exercise ---

# --- begin exercise ---

Exercise 8: Solution of differential equation
---------------------------------------------




Question: Given::

        \[ \frac{dy}{dx} = -y(x),\quad y(0)=1 \]

What is the solution of this equation?

Choice A: M{y=e^{-y}}

Choice B: M{y=e^{y}}

Choice C: 
Code::

        from math import exp
        def f(x):
            return exp(x)

Choice D: The solution cannot be found because there is a derivative in the equation.

Choice E: The equation is meaningless: an equation must be an equation
for M{x} or M{y}, not a function M{y(x)}.



# --- end exercise ---

# --- begin exercise ---

Example 9: Just an example
--------------------------

I{a)}
What is the capital of Norway?

I{Answer.}
Oslo.

# --- end exercise ---

Here goes another section
=========================

With some text, before we continue with exercises.

More Exercises
==============

# --- begin exercise ---

Exercise 10: Make references to projects and problems
-----------------------------------------------------

Pick a statement from "Project 5: Explore Distributions of Random Circles" or "Problem 2: Flip a Coin"
and verify it.

Test list at the end of an exercise without other elements (like subexercise,
hint, etc.):

1. item1
2. item2

Filename: C{verify_formula.py}.

# --- end exercise ---

# --- begin exercise ---

Project 11: References to "Project 4: Compute a Probability" in a heading works for epytext
-------------------------------------------------------------------------------------------

Refer to the previous exercise as "Exercise 10: Make references to projects and problems",
the two before that as "Project 4: Compute a Probability" and "Project 5: Explore Distributions of Random Circles",
and this one as "Project 11: References to Project ref{demo:ex:2} in a heading works for epytext".
Filename: C{selc_composed.pdf}.

# --- end exercise ---

References
==========

 1. B{H. P. Langtangen and G. Pedersen}. 
    Propagation of Large Destructive Waves,
    I{International Journal of Applied Mechanics and Engineering},
    7(1),
    pp. 187-204,
    2002.
 2. B{H. P. Langtangen, K.-A. Mardal and R. Winther}. 
    Numerical Methods for Incompressible Viscous Flow,
    I{Advances in Water Resources},
    25,
    pp. 1125-1146,
    2002.
 3. B{H. P. Langtangen}. 
    Numerical Solution of First Passage Problems in Random Vibrations,
    I{SIAM Journal of Scientific and Statistical Computing},
    15,
    pp. 997-996,
    1994.
 4. B{K.-A. Mardal, G. W. Zumbusch and H. P. Langtangen}. 
    Software Tools for Multigrid Methods,
    I{Advanced Topics in Computational Partial Differential Equations -- Numerical Methods and Diffpack Programming},
    edited by B{H. P. Langtangen and A. Tveito},
    Springer,
    2003,
    Edited book,
    U{http://some.where.org<http://some.where.org>}.
 5. B{H. P. Langtangen}. 
    The FEMDEQS Program System,
    I{Department of Mathematics, University of Oslo},
    1989,
    U{http://www.math.uio.no/old/days/hpl/femdeqs.pdf<http://www.math.uio.no/old/days/hpl/femdeqs.pdf>}.
 6. B{H. P. Langtangen}. 
    Stochastic Breakthrough Time Analysis of an Enhanced Oil Recovery Process,
    I{SIAM Journal on Scientific Computing},
    13,
    pp. 1394-1417,
    1992.
 7. B{M. Mortensen, H. P. Langtangen and G. N. Wells}. 
    A FEniCS-Based Programming Framework for Modeling Turbulent Flow by the Reynolds-Averaged Navier-Stokes Equations,
    I{Advances in Water Resources},
    34(9),
    U{doi: 10.1016/j.advwatres.2011.02.013<https://dx.doi.org/10.1016/j.advwatres.2011.02.013>},
    2011.
 8. B{S. Glimsdal, G. Pedersen, K. Atakan, C. B. Harbitz, H. P. Langtangen and F. L\ovholt}. 
    Propagation of the Dec. 26, 2004 Indian Ocean Tsunami: Effects of Dispersion and Source Characteristics,
    I{International Journal of Fluid Mechanics Research},
    33(1),
    pp. 15-43,
    2006.
 9. B{S. Rahman, J. Gorman, C. H. W. Barnes, D. A. Williams and H. P. Langtangen}. 
    Numerical Investigation of a Piezoelectric Surface Acoustic Wave Interaction With a One-Dimensional Channel,
    I{Physical Review B: Condensed Matter and Materials Physics},
    74,
    2006,
    035308.
10. B{J. B. Haga, H. Osnes and H. P. Langtangen}. 
    On the Causes of Pressure Oscillations in Low-Permeable and Low-Compressible Porous Media,
    I{International Journal of Analytical and Numerical Methods in Geomechanics},
    U{doi: 10.1002/nag.1062<https://dx.doi.org/10.1002/nag.1062>},
    2011,
    U{http://onlinelibrary.wiley.com/doi/10.1002/nag.1062/abstract<http://onlinelibrary.wiley.com/doi/10.1002/nag.1062/abstract>}.
11. B{H. P. Langtangen}. 
    I{Computational Partial Differential Equations - Numerical Methods and Diffpack Programming},
    second edition,
    I{Texts in Computational Science and Engineering},
    Springer,
    2003.
12. B{H. P. Langtangen}. 
    I{Python Scripting for Computational Science},
    third edition,
    I{Texts in Computational Science and Engineering},
    Springer,
    2008.
13. B{H. P. Langtangen and G. Pedersen}. 
    Finite Elements for the Boussinesq Wave Equations,
    Waves and Non-linear Processes in Hydrodynamics,
    edited by B{J. Grue, B. Gjevik and J. E. Weber},
    Kluwer Academic Publishers,
    pp. pp. 117-126,
    1995,
    U{http://www.amazon.ca/Waves-Nonlinear-Processes-Hydrodynamics-John/dp/0792340310<http://www.amazon.ca/Waves-Nonlinear-Processes-Hydrodynamics-John/dp/0792340310>}.
14. B{H. P. Langtangen}. 
    I{A Primer on Scientific Programming With Python},
    third edition,
    I{Texts in Computational Science and Engineering},
    Springer,
    2012.
15. B{P. V. Jeberg, H. P. Langtangen and C. B. Terp}. 
    Optimization With Diffpack: Practical Example From Welding,
    I{Simula Research Laboratory},
    2004,
    Internal report.
16. B{H. P. Langtangen}. 
    Computational Methods for Two-Phase Flow in Oil Reservoirs,
    Ph.D. Thesis,
    Mechanics Division, Department of Mathematics, University of Oslo,
    1989,
    Dr. Scient. thesis..
17. B{H. P. Langtangen}. 
    Computational Modeling of Huge Tsunamis From Asteroid Impacts,
    2007,
    Invited keynote lecture at the \emphInternational conference on Computational Science 2007 (ICCS'07), Beijing, China.
18. B{H. P. Langtangen}. 
    Solution of the Navier-Stokes Equations With the Finite Element Method in Two and Three Dimensions,
    M.Sc. Thesis,
    Mechanics Division, Department of Mathematics, University of Oslo,
    1985,
    Cand.Scient. thesis.
19. B{H. P. Langtangen and A. Tveito}. 
    Numerical Methods in Continuum Mechanics,
    I{Center for Industrial Research},
    1991,
    Lecture notes for a course (ME-IN 324). 286 pages..
20. B{H. P. Langtangen}. 
    Diffpack: Software for Partial Differential Equations,
    I{Proceedings of the Second Annual Object-Oriented Numerics Conference (OON-SKI'94), Sunriver, Oregon, USA},
    edited by B{A. Vermeulen},
    1994.

Appendix: Just for testing; part I
==================================

This is the first appendix.

A subsection within an appendix
-------------------------------

Some text.

Appendix: Just for testing; part II
===================================

This is more stuff for an appendix.

Appendix: Testing identical titles
----------------------------------

Without label.

Appendix: Testing identical titles
----------------------------------

With label.

Appendix: Testing identical titles
----------------------------------

What about inserting a quiz?




Fundamental test: What is the capital of Norway?

Answer 1: Stockholm

Answer 2: London

Answer 3: Oslo

Choice D: Bergen



Appendix: Testing identical titles
----------------------------------

Without label.

I{Tip.} 
Here is a tip or hint box, typeset as a notice box.



Need a lot of text to surround the summary box.
Version control systems allow you to record the history of files
and share files among several computers and collaborators in a
professional way. File changes on one computer are updated or
merged with changes on another computer. Especially when working
with programs or technical reports it is essential
to have changes documented and to
ensure that every computer and person involved in the project
have the latest updates of the files.
Greg Wilson' excellent U{Script for Introduction to Version Control<https://software-carpentry.org/2010/07/script-for-introduction-to-version-control/>} provides a more detailed motivation why you will benefit greatly
from using version control systems.

I{Summary.} 
B{Bold remark:} Make some text with this summary.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.



Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that site. I strongly
recommend you to use such sites for all serious programming and
scientific writing work - and all other important files.

The simplest services for hosting project files are U{Dropbox<https://dropbox.com>} and U{Google Drive<https://drive.google.com>}.
It is very easy to get started with these systems, and they allow you
to share files among laptops and mobile units with as many users as
you want. The systems offer a kind of version control in that the
files are stored frequently (several times per minute), and you can go
back to previous versions for the last 30 days. However, it is
challenging  to find the right version from the past when there are
so many of them.

More seriously, when several people may edit files simultaneously, it
can be difficult detect who did what when, roll back to previous
versions, and to manually merge the edits when these are
incompatible. Then one needs more sophisticated tools than Dropbox or
Google Drive: project hosting services with true version control
systems.  The following text aims at providing you with the minimum
information to started with such systems. Numerous other tutorials
contain more comprehensive material and in-depth explanations of the
concepts and tools.

The idea with project hosting services is that you have the files
associated with a project in the cloud. Many people may share these
files.  Every time you want to work on the project you explicitly
update your version of the files, edit the files as you like, and
synchronize the files with the "master version" at the site where the
project is hosted.  If you at some point need to go back to a
version of the files at some particular point in the past,
this is an easy operation. You can also use tools to see
what various people have done with the files in the various versions.

All these services are very similar. Below we describe how you get
started with Bitbucket, GitHub, and Googlecode. Launchpad works very
similarly to the latter three. All the project hosting services have
excellent introductions available at their web sites, but the recipes
below are much shorter and aim at getting you started as quickly as
possible by concentrating on the most important need-to-know steps.
The Git tutorials we refer to later in this document contain more
detailed information and constitute of course very valuable readings
when you use version control systems every day. The point now is
to get started.

Appendix: Testing inline comments
---------------------------------

Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that
site. [hpl's semi opinion 1: not sure if in the cloud is
understood by
all.] I strongly recommend you to use such sites for all serious
programming and scientific writing work - and all other important
files.

The simplest services for hosting project files is Dropbox. [mp 2: Simply go to U{https://dropbox.com<https://dropbox.com>} and watch the video. It explains
how files, like C{myfile.py}, perhaps containing much math, like
M{\partial u/\partial t}, are easily communicated between machines.] It
is very easy to get started with Dropbox, and it allows you to share
files among [hpl 3: laptops and mobile units -> computers, tablets,
and phones].

------

First[add 4: ,] consider a quantity M{Q}. [edit 5: To this end, -> We note that]
M{Q>0}, because [del 6: a] negative [edit 7: quantity is -> quantities
are] [del 8: just] negative. [add 9: This comes as no surprise.]

Let us refer to Figure ref{fig:impact} again.

Test references in a list:

 - "Section 1"
 - "Subsection 1"
 - ref{fig:impact}

Appendix: Testing headings ending with C{verbatim inline}
---------------------------------------------------------

The point here is to test 1) C{verbatim} code in headings, and 2)
ending a heading with verbatim code as this triggers a special
case in LaTeX.

We also test mdash---used as alternative to hyphen without spaces around,
or in quotes:





The ndash should also be tested - as in the Hanson - Nilson equations
on page 277 - 278.

And finally, what about admons, quotes, and boxes? They are tested
in a separate document: C{admon.do.txt}.

[^example-of-the-third-footnote]: Not much to add here, but the footnote
is at the end with only one newline.
************** File: testdoc.txt *****************
A Document for Testing DocOnce
==============================

Hans Petter Langtangen [1, 2] (hpl@simula.no)
Kaare Dump [3] 
A. Dummy Author  
I. S. Overworked and Outburned [4, 5, 6, 7] 
J. Doe  (j_doe@cyberspace.com)

[1] Center for Biomedical Computing, Simula Research Laboratory
[2] Department of Informatics, University of Oslo
[3] Segfault, Cyberspace
[4] Inst1
[5] Inst2, Somewhere
[6] Third Inst, Elsewhere
[7] Fourth Inst

Date: Jan 32, 2100

Made with DocOnce

Table of contents:

 Section 1 
     Here is a list with subsubsection heading 
   Subsection 1 
     Test Section reference at beginning of line and after a sentence 
     Computer code 
     Running OS commands 
     Footnotes 
   Subsection 2: Testing figures 
   The \theta parameter (not \nabla?) 
   Custom Environments 
   Tables 
   A test of verbatim words in heading with subscript a_i: my_file_v1 and my_file_v2 
   _Just bold_ 
   *Just emphasize* 
   Just verbatim 
   _Bold_ beginning 
   *Emphasize* beginning 
   Verbatim beginning 
   Maybe _bold end_ 
   Maybe *emphasize end* 
   Maybe verbatim end 
   The middle has _bold_ word 
   The middle has *emphasize* word 
   The middle has verbatim word 
   Bibliography test 
   Example 1: Examples can be typeset as exercises 
   User-defined environments 
   Example 1: A test function 
   Example 2: Addition 
   URLs 
 LaTeX Mathematics 
 Exercises 
   Problem 2: Flip a Coin 
     My remarks 
     Remarks 
   Not an exercise 
   Exercise 3: Test of plain text exercise 
   Project 4: Compute a Probability 
   Project 5: Explore Distributions of Random Circles 
     Remarks 
   Exercise 6: Determine some Distance 
     Remarks 
   Some exercise without the "Exercise:" prefix 
   Exercise 8: Solution of differential equation 
   Example 9: Just an example 
 Here goes another section 
 More Exercises 
   Exercise 10: Make references to projects and problems 
   Project 11: References to "Project 4: Compute a Probability" in a heading works for plain 
 References 
 Appendix: Just for testing; part I 
   A subsection within an appendix 
 Appendix: Just for testing; part II 
   Appendix: Testing identical titles 
   Appendix: Testing identical titles 
   Appendix: Testing identical titles 
   Appendix: Testing identical titles 
   Appendix: Testing inline comments 
   Appendix: Testing headings ending with verbatim inline 

# !split

The format of this document is
plain

*Abstract.* This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.

Section 1
=========

Here is a nested list:

  * item1

  * item2

  * item3 which continues
    on the next line to test that feature

  * and a sublist

    * with indented subitem1

    * and a subitem2

  * and perhaps an ordered sublist

   a. first item

   b. second item,
      continuing on a new line

*Here is a list with paragraph heading.*

  * item1

  * item2

Here is a list with subsubsection heading
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  * item1

  * item2

        Here are two lines that make up
        a block quote for testing *emphasized words* and _boldface words_,
        also with hypens:
        *pre*-fix, post-*fix*, _pre_-fix, post-_fix_.


Here are two references. Equation (ref{my:eq1}) is fine. Eq. (ref{my:eq1}) too.
Even Equation (ref{my:eq1}) without the tilde.

Subsection 1
------------

More text, with a reference back to
the section "Section 1" and "Subsection 1", and further to the
the sections "Subsection 1" and "URLs", which
encourages you to do the tasks in "Problem 2: Flip a Coin" and "Exercise 10: Make references to projects and problems".
 "Appendix: Just for testing; part I" and "Appendix: Just for testing; part II" are also nice elements.

Test Section reference at beginning of line and after a sentence
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The section "Subsection 1" is fine.
The section "URLs" too.

Computer code
~~~~~~~~~~~~~

Let's do some copying from files too. First from subroutine up to the very end::

              subroutine test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return

and then just the subroutine::

        
              subroutine test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return

and finally the complete file with a plain text verbatim environment
(envir=ccq)::

        C     a comment
        
              subroutine test()
              integer i
              real*8 r
              r = 0
              do i = 1, i
                 r = r + i
              end do
              return
        C     END1
        
              program testme
              call test()
              return

Testing other code environments. First Python::

        !bc pycod
        def f(x):
            return x+1
        !ec

which gets rendered as::

        def f(x):
            return x+1

Here is a program that is supposed to be interactive via
Python Online Tutorial, but that service is not accessible
for the present format::

        class Line:
            def __init__(self, a, b):
                self.a, self.b = a, b
        
            def __call__(self, x):
                a, b = self.a, self.b
                return a*x + b
        
        line = Line(2, 1)
        y = line(x=3)
        print(y)

Some more Python code (actually specified as a sage cell, but
such cells are not supported by this format)::

        a = 2
        b = 3
        print('a+b:', a + b)
        
        # In a sage cell we can also plot
        from matplotlib.pyplot import *
        from numpy import *
        x = linspace(0, 4*pi, 101)
        y = exp(-0.1*x)*cos(x)
        plot(x, y)
        xlabel('x'); ylabel('y')
        show()

Then Cython (with -h option so it is hidden in html/sphinx)::

        cpdef f(double x):
            return x + 1

Standard Python shell sessions::

        >>> from numpy import linspace, sin
        >>> # Some comment
        >>> x = linspace(0, 2, 11)
        >>> y = sin(x)
        >>> y[0]
        0
        >>> import matplotlib.pyplot as plt
        >>> plt.plot(x, y)

Similar IPython sessions::

        In [1]: from numpy import linspace, sin
        In [2]: # Some comment
        In [3]: x = linspace(0, 2, 11)
        In [4]: y = sin(x)
        In [5]: y[0]
        Out[5]: 0
        In [6]: import matplotlib.pyplot as plt
        In [7]: plt.plot(x, y)
        In [8]: a='multiple-\nline\noutput'
        In [9]: a
        Out[9]: 'multiple-\nline\noutput'
        In [10]: print(a)
        multiple-
        line
        output

Here is the interactive session again, but with pyshell-t::

        >>> from numpy import linspace, sin
        >>> # Some comment
        >>> x = linspace(0, 2, 11)
        >>> y = sin(x)
        >>> y[0]
        0
        >>> import matplotlib.pyplot as plt
        >>> plt.plot(x, y)

C++::

        #include <iostream>
        
        int main()
        {
           std::cout << "Sample output" << std::endl;
           return 0
        }

And a little bit of Fortran: :dizzy_face::

        !bc cod
              subroutine midpt(x, length, a, b)
              real*8 a, b, x
              x = (a + b)/2
              length = b - a
              return
              end
        !ec

which then is typeset as::

              subroutine midpt(x, length, a, b)
              real*8 a, b, x
              x = (a + b)/2
              length = b - a
              return
              end

HTML::

        <table>
        <tr><td>Column 1</td><td>Column 2</td></tr>
        <tr><td>0.67526 </td><td>0.92871 </td></tr>
        <!-- comment -->
        </table>

But inline HTML code is also important, like text that starts with
<a href=" (which can destroy the following text if not properly
quoted).

Matlab with comments requires special typesetting::

        % Comment on the beginning of the line can be escaped by %%
        if a > b
          % Indented comment needs this trick
          c = a + b
        end

And here is a system call::

        Terminal> mkdir test
        Terminal> cd test
        Terminal> myprog -f
        output1
        output2

Any valid pygments lexer/language name can appear to, e.g.::

        !bc restructuredtext
        =======
        Heading
        =======
        
        Some text.
        !ec

results in::

        =======
        Heading
        =======
        
        Some text.

Finally, !bc do supports highlighting of DocOnce source::

        ======= DocOnce test file =======
        
        ===== Computer code =====
        
        Inline verbatim code, as in `import numpy as np`, is allowed, as well as
        code blocks:
        
        !bc pycod
        from math import sin
        
        def f(x):
            """Example on a function."""
            return sin(x) + 1
        
        print(f(0))
        !ec
        
        
        ===== Mathematics =====
        
        Formulas can be inline, as in $\nabla\cdot\bm{u} = 0$, or typeset
        as equations:
        
        !bt
        \begin{align*}
        \nabla\cdot\bm{u} &= 0,\\ 
        \bm{u} &= \nabla\phi .
        \end{align*}
        !et
        
        === Subsubsection heading ===
        
        DocOnce files can have chapters, sections, subsections, and subsubsections.
        
        __Paragraph heading.__ Paragraphs may have headings.

It is time to test verbatim inline font especially with a newline
inside the text and an exclamation mark at the end: BEGIN! For
spellcheck, test a verbatim expression in another in a third.
Also test exclamation mark as in !bc and !ec as well as a != b.
Also test backslashes and braces like \begin, \begin{enumerate},
\end{this}\end{that}, and {something \inside braces}.

The following attempt to exemplify colored text does not work in
format plain.
Here is some red color and an attempt to write with
green color containing a linebreak
code. Some formats will only display 
this correctly when html 
is the output format.
But here some more running text is added which is not part of
the previous blocks with line breaks.

Running OS commands
~~~~~~~~~~~~~~~~~~~

        Terminal> python -c 'print("Testing\noutput\nfrom\nPython.")'
        Testing
        output
        from
        Python.

Footnotes
~~~~~~~~~

Here is a test of footnotes [^footnote], which are handy in text.
They are used in different flavors, now in

 * list items (note below that footnotes work after math, verbatim, and URLs - bin fact old and emphasize too!)

 * even with math \nabla^2u[^math1]

 * and code h[i] += 1[^code]
   (*must* have space between inline code and footnote!)

 * and links (https://google.com)[^google-search]

which gives flexibility in writing.
This is the third[^example-of-the-third-footnote] example.

  [^footnote]: Typesetting of the footnote depends on the format.
Plain text does nothing, LaTeX removes the
definition and inserts the footnote as part of the LaTeX text.
reStructuredText and Sphinx employ a similar type of typesetting
as Extended Markdown and DocOnce, and in HTML we keep the same
syntax, just displayed properly in HTML.
[^math1]: Math footnotes can be dangerous since it
interferes with an exponent.
[^code]: One-line footnote.

[^google-search]: google.com is perhaps the most famous
web site today.

Here is some more text before a new definition of a footnote that was
used above.


Non-breaking space character ------------------------------------------------------------------------------------------------|
|                                                                                                                            |
| This paragraph aims to test non-breaking space character (https://en.wikipedia.org/wiki/Non-breaking_space), and a typical |
| example where this is needed is in physical units: 7.4 km is traveled                                                      |
| in 7.4/5.5\approx 1.345 s.  Also check that a link (https://google.com) is                                                 |
| not broken across lines (drag the browser window to test this).                                                            |
| (On the other hand, the tilde is used in                                                                                   |
| computer code, e.g., as in [~x for x in y] or in y=~x, and should                                                          |
| of course remain a tilde in those contexts.)                                                                               |
|----------------------------------------------------------------------------------------------------------------------------|


Subsection 2: Testing figures
-----------------------------

Test of figures. In particular we refer to Figure ref{fig:impact} in which
there is a flow.

FIGURE:[../doc/src/manual/fig/wave1D, width=200] Visualization _of_ a *wave*. {fig:impact}

Figures without captions are allowed and will be inlined.

FIGURE:[../doc/src/manual/fig/wave1D, width=200]

Here is figure ref{myfig} with a long (illegal) multi-line caption
containing inline verbatim text:

FIGURE: [../doc/src/manual/fig/wave1D.png, width=500 sidecap=True] A long caption spanning several lines and containing verbatim words like my_file_v1 and my_file_v2 as well as math with subscript as in t_{i+1}. {myfig} 

Test URL as figure name:

FIGURE: [https://raw.github.com/doconce/doconce/master/doc/src/blog/f_plot.png, width=500 frac=0.8]

*Remark.*
Movies are tested in separate file movies.do.txt.

The \theta parameter (not \nabla?)
----------------------------------

Functions do not always need to be advanced, here is one
involving \theta::

        def f(theta):
            return theta**2

*More on \theta.* Here is more text following headline with math.

Newcommands must also be tested in this test report:
\frac{1}{2}, {1/2}, \pmb{x}, \frac{Du}{dt},
both inline and in block::

        \begin{align}
        \frac{Du}{dt} &= 0\nonumber
        \\ 
        \frac{1}{2} &= {1/2}\\ 
        \frac{1}{2}\pmb{x} &= \pmb{n}
        \end{align}

Or with align with label and numbers::

        \begin{align}
        \frac{Du}{dt} &= 0
        label{aligneq1}
        \\ 
        \frac{1}{2} &= {1/2}\\ 
        \frac{1}{2}\pmb{x} &= \pmb{n}
        label{aligneq2}
        \end{align}

First one numbered (automatically)::

        \begin{align}
        \begin{pmatrix}
        G_2 + G_3 & -G_3 & -G_2 & 0 \\ 
        -G_3 & G_3 + G_4 & 0 & -G_4 \\ 
        -G_2 & 0 & G_1 + G_2 & 0 \\ 
        0 & -G_4 & 0 & G_4
        \end{pmatrix}
        &=
        \begin{pmatrix}
         v_1 \\ 
         v_2 \\ 
         v_3 \\ 
         v_4
        \end{pmatrix}
        + \cdots \\ 
        \begin{pmatrix}
         C_5 + C_6 & -C_6 & 0 & 0 \\ 
         -C_6 & C_6 & 0 & 0 \\ 
         0 & 0 & 0 & 0 \\ 
         0 & 0 & 0 & 0
        \end{pmatrix}
          &= \frac{d}{dt}\begin{pmatrix}
         v_1 \\ 
         v_2 \\ 
         v_3 \\ 
         v_4
        \end{pmatrix} +
        \begin{pmatrix}
         0 \\ 
         0 \\ 
         0 \\ 
         -i_0
        \end{pmatrix}
        \nonumber
        \end{align}

Second numbered (automatically)::

        \begin{align}
        \begin{pmatrix}
        G_1 + G_2\\ 
        -G_3 & G_4
        \end{pmatrix}
        &=
        \begin{pmatrix}
         v_1 \\ 
         v_2
        \end{pmatrix}
        + \cdots\nonumber
        \\ 
        \left(\begin{array}{ll}
        y & 2\\ 
        2 & 1
        \end{array}\right)
        \left(\begin{array}{ll}
        0 \\ x
        \end{array}\right)
        &= \begin{pmatrix}
        A \\ B
        \end{pmatrix}
        \end{align}

Both numbered, with label by the user::

        \begin{align}
        \begin{pmatrix}
        G_1 + G_2\\ 
        -G_3 & G_4
        \end{pmatrix}
        &=
        \begin{pmatrix}
         v_1 \\ 
         v_2
        \end{pmatrix}
        + \cdots label{mymatrix:eq1}
        \\ 
        label{mymatrix:eq2}
        \left(\begin{array}{ll}
        y & 2\\ 
        2 & 1
        \end{array}\right)
        \left(\begin{array}{ll}
        0 \\ x
        \end{array}\right)
        &= \begin{pmatrix}
        A \\ B
        \end{pmatrix}
        \end{align}

Now we refer to Equations (mymatrix:eq1)-(mymatrix:eq2).

Custom Environments
-------------------

Here is an attempt to create a theorem environment via Mako
(for counting theorems) and comment lines to help replacing lines in
the .tex by proper begin-end LaTeX environments for theorems.
Should look nice in most formats!

*Theorem 5.*
Let a=1 and b=2. Then c=3.

*Proof.*
Since c=a+b, the result follows from straightforward addition.
END

As we see, the proof of Theorem 5 is a modest
achievement.

Tables
------

Let us take this table from the manual:

====  ========  ============  
time  velocity  acceleration  
====  ========  ============  
0.0     1.4186         -5.01  
2.0   1.376512        11.919  
4.0     1.1E+1     14.717624  
====  ========  ============  

The DocOnce source code reads::

        
          |--------------------------------|
          |time  | velocity | acceleration |
          |--l--------r-----------r--------|
          | 0.0  | 1.4186   | -5.01        |
          | 2.0  | 1.376512 | 11.919       |
          | 4.0  | 1.1E+1   | 14.717624    |
          |--------------------------------|
        

Here is yet another table to test that we can handle more than
one table:

====  ========  ============  
time  velocity  acceleration  
====  ========  ============  
0.0   1.4186    -5.01         
1.0   1.376512  11.919        
3.0   1.1E+1    14.717624     
====  ========  ============  

And one with math headings (that are expanded and must be treated
accordingly), verbatim heading and entry, and no space around the pipe
symbol:

=  ======  ========  =======  
i   h_i    \bar T_i    L_i    
=  ======  ========  =======  
0       0       288  -0.0065  
1  11,000       216      0.0  
2  20,000       216    0.001  
3  32,000       228   0.0028  
4  47,000       270      0.0  
5  51,000       270  -0.0028  
6  71,000       214      NaN  
=  ======  ========  =======  

And add one with verbatim headings (with underscores),
and rows starting with |- because of a negative number,
and | right before and after verbatim word (with no space):

=====  ======  =========  =======  
exact   v_1    a_i + v_2  verb_3_  
=====  ======  =========  =======  
    9    9.62       5.57     8.98  
  -20  -23.39      -7.65   -19.93  
   10   17.74      -4.50     9.96  
    0   -9.19       4.13    -0.26  
=====  ======  =========  =======  

Pipe symbols in verbatim and math text in tables used to pose difficulties,
but not
anymore (except for plain text and matlabnb).

Here is a table with X alignment:

=====  ==================================================================================================================================================================================================================  
 Type                                                                                                     Description                                                                                                      
=====  ==================================================================================================================================================================================================================  
  X    Alignment character that is used for specifying a potentially very long text in a column in a table. It makes use of the tabularx package in LaTeX, otherwise (for other formats) it means l (centered alignment).  
l,r,c  standard alignment characters                                                                                                                                                                                       
=====  ==================================================================================================================================================================================================================  

Finally, a table with math
and URLs.

====================  ======================================================  ======================================================  
                                                                                                                                      
====================  ======================================================  ======================================================  
   \mathcal{L}=0      080 (../doc/src/manual/mov/wave_frames/frame_0080.png)  085 (../doc/src/manual/mov/wave_frames/frame_0085.png)  
        a=b           090 (../doc/src/manual/mov/wave_frames/frame_0090.png)  095 (../doc/src/manual/mov/wave_frames/frame_0095.png)  
\nabla\cdot\bm{u} =0  100 (../doc/src/manual/mov/wave_frames/frame_0100.png)  105 (../doc/src/manual/mov/wave_frames/frame_0105.png)  
====================  ======================================================  ======================================================  

A test of verbatim words in heading with subscript a_i: my_file_v1 and my_file_v2
---------------------------------------------------------------------------------

*Paragraph with verbatim and math: my_file_v1.py and my_file_v2.py define some math a_{i-1}.* Here is more __verbatim__ code and
some plain text on a new line.

_Just bold_
-----------

Some text.

*Just emphasize*
----------------

Some text.

Just verbatim
-------------

Some text.

_Bold_ beginning
----------------

Some text.

*Emphasize* beginning
---------------------

Some text.

Verbatim beginning
------------------

Some text.

Maybe _bold end_
----------------

Some text.

Maybe *emphasize end*
---------------------

Some text.

Maybe verbatim end
------------------

Some text.

The middle has _bold_ word
--------------------------

Some text.

The middle has *emphasize* word
-------------------------------

Some text.

The middle has verbatim word
----------------------------

Some text.

**Just emphasize*.* Some text.

*Just verbatim.* Some text.

**Emphasize* beginning.* Some text.

*Verbatim beginning.* Some text.

*Maybe *emphasize end*.* Some text.

*Maybe verbatim end.* Some text.

*The middle has *emphasize* word.* Some text.

*The middle has verbatim word.* Some text.

*Ampersand.*
We can test Hennes & Mauritz, often abbreviated H&M, but written
as Hennes & Mauritz and H & M.
A sole & must also work::

        # Just to check that ampersand works in code blocks:
        c = a & b

*Quotes.*
Let us also add a test of quotes such as "double quotes, with numbers
like 3.14 and newline/comma and hyphen (as in double-quote)"; written
in the standard LaTeX-style that gives correct LaTeX formatting and
ordinary double quotes for all non-LaTeX formats.  Here is another
sentence that "caused" a bug in the past because double backtick
quotes could imply verbatim text up to a verbatim word starting with
period, like .txt.

More quotes to be tested for spellcheck:
("with parenthesis"), "with newline"
and "with comma", "hyphen"-wise, and "period".

Bibliography test
-----------------

Here is an example: [1] discussed propagation of
large destructive water waves, [2] gave
an overview of numerical methods for solving the Navier - Stokes equations,
while the use of Backward Kolmogorov equations for analyzing
random vibrations was investigated in [3].
The book chapter [4] contains information on
C++ software tools for programming multigrid methods. A real retro
reference is [5] about a big FORTRAN package.
Multiple references are also possible, e.g., see
[1] [4].

We need to cite more than 10 papers to reproduce an old formatting
problem with blanks in the keys in reST format:
[6] [3] [7] [1]
and
[2] [8] [9] [10] [11] [12] [13]
and all the work of
[14] [4] [15] as well as
old work [5] and [16], and the
talk [17].
Langtangen also had two thesis [18] [16]
back in the days.
More retro citations are
the old ME-IN323 book [19] and the
[20] OONSKI '94 paper.

# --- begin exercise ---

Example 1: Examples can be typeset as exercises
-----------------------------------------------

Examples can start with a subsection heading starting with Example:
and then, with the command-line option --examples_as_exercises be
typeset as exercises. This is useful if one has solution
environments as part of the example.

*a)*
State some problem.

*Solution.*
The answer to this subproblem can be written here.

*b)*
State some other problem.

*Hint 1.*
A hint can be given.

*Hint 2.*
Maybe even another hint?

*Solution.*
The answer to this other subproblem goes here,
maybe over multiple doconce input lines.

# --- end exercise ---

User-defined environments
-------------------------

The example in the section "Example 1: A test function" demonstrates how to write a test function.
That is, a special test function for a function add appears in
the example in the section "Example 1: A test function".

Example 1: A test function
--------------------------

Suppose we want to write a test function for checking the
implementation of a Python function for addition::

        def add(a, b):
            return a + b
        
        def test_add():
            a = 1; b = 1
            expected = a + b
            computed = add(a, b)
            assert expected == computed

Example 2: Addition
-------------------

We have::

        \[ 1 + 1 = 2 \]

or in tabular form:

=======  ======  
Problem  Result  
=======  ======  
  1+1      2     
=======  ======  


Highlight box! -------------------------------------|
|                                                   |
| This environment is used to highlight something:: |
|                                                   |
|         \[ E = mc^2 \]                            |
|---------------------------------------------------|


URLs
----

Testing of URLs: hpl's home page hpl (https://folk.uio.no/hpl), or
the entire URL if desired, https://folk.uio.no/hpl.  Here is a
plain file link testdoc.do.txt, or testdoc.do.txt, or
testdoc.do.txt or testdoc.do.txt or a link with
newline (testdoc.do.txt). Can test spaces with the link with word
too: hpl (https://folk.uio.no/hpl) or hpl (https://folk.uio.no/hpl). Also file:/// works: link to a
file (file:///home/hpl/vc/doconce/doc/demos/manual/manual.html) is
fine to have. Moreover, "loose" URLs work, i.e., no quotes, just
the plain URL as in https://folk.uio.no/hpl, if followed by space, comma,
colon, semi-colon, question mark, exclamation mark, but not a period
(which gets confused with the periods inside the URL).

Mail addresses can also be used: hpl@simula.no (mailto:hpl@simula.no), or just a mail link (mailto:hpl@simula.no), or a raw mailto:hpl@simula.no.

Here are some tough tests of URLs, especially for the latex format:
Newton-Cotes (https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas) formulas
and a good book (https://www.springer.com/mathematics/computational+science+%26+engineering/book/978-3-642-23098-1). Need to test
Newton-Cotes with percentage in URL too:
https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas
and https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae which has a shebang.

For the --device=paper option it is important to test that URLs with
monospace font link text get a footnote
(unless the --latex_no_program_footnotelink
is used), as in this reference to
decay_mod (https://github.com/hplgit/INF5620/tree/gh-pages/src/decay/experiments/decay_mod.py), ball1.py (https://tinyurl.com/pwyasaa/formulas.ball1.py),
and ball2.py (https://tinyurl.com/pwyasaa/formulas.ball2.py).

More tough tests: repeated URLs whose footnotes when using the
--device=paper option must be correct. We have
google (https://google.com), google (https://google.com), and
google (https://google.com), which should result in exactly three
footnotes.

# !split and check if these extra words are included properly in the comment

LaTeX Mathematics
=================

Here is an equation without label using backslash-bracket environment::

        \[ a = b + c \]

or with number and label, as in Equation (my:eq1), using the equation environment::

        \begin{equation}
        {\partial u\over\partial t} = \nabla^2 u label{my:eq1}
        \end{equation}

We can refer to this equation by Equation (my:eq1).

Here is a system without equation numbers, using the align-asterisk environment::

        \begin{align*}
        \pmb{a} &= \pmb{q}\times\pmb{n} \\ 
        b &= \nabla^2 u + \nabla^4 v
        \end{align*}

More mathematical typesetting is demonstrated in the coming exercises.

Below, we have "Problem 2: Flip a Coin" and "Project 4: Compute a Probability",
as well as "Project 5: Explore Distributions of Random Circles" and "Project 11: References to Project ref{demo:ex:2} in a heading works for plain", and in
between there we have "Exercise 10: Make references to projects and problems".

Exercises
=========

# --- begin exercise ---

Problem 2: Flip a Coin
----------------------

*a)*
Make a program that simulates flipping a coin N times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

# --- begin hint in exercise ---

*Hint 1.*
Use r = random.random() and define head as r <= 0.5.

# --- end hint in exercise ---

# --- begin hint in exercise ---

*Hint 2.*
Draw an integer among \{1,2\} with
r = random.randint(1,2) and define head when r is 1.

# --- end hint in exercise ---

# --- begin answer of exercise ---
*Answer.*
If the random.random() function returns a number <1/2, let it be
head, otherwise tail. Repeat this N number of times.
# --- end answer of exercise ---

# --- begin solution of exercise ---
*Solution.*::

        import sys, random
        N = int(sys.argv[1])
        heads = 0
        for i in range(N):
            r = random.random()
            if r <= 0.5:
                heads += 1
        print('Flipping a coin %d times gave %d heads' % (N, heads))

# --- end solution of exercise ---

*b)*
Vectorize the code in a) using boolean indexing.

Vectorized code can be written in many ways.
Sometimes the code is less intuitive, sometimes not.
At least there is not much to find in the section "Section 1".

*c)*
Vectorize the code in a) using numpy.sum.

# --- begin answer of exercise ---
*Answer.*
np.sum(np.where(r <= 0.5, 1, 0)) or np.sum(r <= 0.5).
# --- end answer of exercise ---

In this latter subexercise, we have an
example where the code is easy to read.

My remarks
~~~~~~~~~~

Remarks with such a subsubsection is treated as more text
after the last subexercise. Test a list too:

1. Mark 1.

2. Mark 2.

Filenames: flip_coin.py, flip_coin.pdf.

Remarks
~~~~~~~

These are the exercise remarks, appearing at the very end.

# --- end exercise ---

Not an exercise
---------------

Should be possible to stick a normal section in the middle of many
exercises.

# --- begin exercise ---

Exercise 3: Test of plain text exercise
---------------------------------------

Very short exercise. What is the capital
of Norway?
Filename: myexer1.

# --- end exercise ---

# --- begin exercise ---

Project 4: Compute a Probability
--------------------------------

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval [0,1)?

At the end we have a list because that caused problems in LaTeX
in previous DocOnce versions:

1. item1

2. item2

# --- begin hint in exercise ---

*Hint.*
To answer this question empirically, let a program
draw N such random numbers using Python's standard random module,
count how many of them, M, that fall in the interval (0.5,0.6), and
compute the probability as M/N.

# --- end hint in exercise ---

# --- end exercise ---

# --- begin exercise ---

Project 5: Explore Distributions of Random Circles
--------------------------------------------------

The formula for a circle is given by::

        \begin{align}
        x &= x_0 + R\cos 2\pi t,
        label{circle:x}\\ 
        y &= y_0 + R\sin 2\pi t,
        label{circle:y}
        \end{align}

where R is the radius of the circle, (x_0,y_0) is the
center point, and t is a parameter in the unit interval [0,1].
For any t, (x,y) computed from Equations (circle:x)-(circle:y)
is a point on the circle.
The formula can be used to generate n points on a circle::

        import numpy as np
        
        def circle(R, x0, y0, n=501):
            t = np.linspace(0, 1, n)
            x = x0 + R*np.cos(2*np.pi*t)
            y = y0 + R*np.sin(2*np.pi*t)
            return x, y
        
        x, y = circle(2.0, 0, 0)

The goal of this project is to draw N circles with random
center and radius. Plot each circle using the circle function
above.

*a)*
Let R be normally distributed and (x_0,y_0) uniformly distributed.

# --- begin hint in exercise ---

*Hint.*
Use the numpy.random module to draw the
x_0, y_0, and R quantities.

# --- end hint in exercise ---

# --- begin answer of exercise ---
*Answer.*
Here goes the short answer to part a).
# --- end answer of exercise ---

# --- begin solution of exercise ---
*Solution.*
Here goes a full solution to part a).
# --- end solution of exercise ---

*b)*
Let R be uniformly distributed and (x_0,y_0) normally distributed.
Filename: norm.

*c)*
Let R and (x_0,y_0) be normally distributed.

Filename: circles.

Remarks
~~~~~~~

At the very end of the exercise it may be appropriate to summarize
and give some perspectives.

# --- end exercise ---

# --- begin exercise ---

Exercise 6: Determine some Distance
-----------------------------------

Intro to this exercise. Questions are in subexercises below.

# --- begin solution of exercise ---
*Solution.*
Here goes a full solution of the whole exercise.
With some math a=b in this solution::

        \[ \hbox{math in solution: } a = b \]

And code a=b in this solution::

        a = b  # code in solution

End of solution is here.

# --- end solution of exercise ---

*a)*
Subexercises are numbered a), b), etc.

# --- begin hint in exercise ---

*Hint 1.*
First hint to subexercise a).
With math a=b in hint::

        \[ a=b. \]

And with code (in plain verbatim) returning x+1 in hint::

        def func(x):
            return x + 1  # with code in hint

# --- end hint in exercise ---

# --- begin hint in exercise ---

*Hint 2.*
Second hint to subexercise a).

Test list in hint:

1. item1

2. item2

# --- end hint in exercise ---
Filename: subexer_a.pdf.

# --- begin answer of exercise ---
*Answer.*
Short answer to subexercise a).
With math in answer: a=b.
# --- end answer of exercise ---

*b)*
Here goes the text for subexercise b).

Some math \cos^2 x + \sin^2 x = 1 written one a single line::

        \[ \cos^2 x + \sin^2 x = 1 \thinspace .\]

# --- begin hint in exercise ---

*Hint.*
A hint for this subexercise.

# --- end hint in exercise ---
Filename: subexer_b.pdf.

# --- begin solution of exercise ---
*Solution.*
Here goes the solution of this subexercise.
# --- end solution of exercise ---

The text here belongs to the main (intro) part of the exercise. Need
closing remarks to have text after subexercises.

Test list in exercise:

1. item1

2. item2

Remarks
~~~~~~~

Some final closing remarks, e.g., summarizing the main findings
and their implications in other problems can be made. These
remarks will appear at the end of the typeset exercise.

# --- end exercise ---

# --- begin exercise ---

Some exercise without the "Exercise:" prefix
--------------------------------------------

Just some text. And some math saying that e^0=1 on a single line,
to test that math block insertion is correct::

        \[ \exp{(0)} = 1 \]

And a test that the code lambda x: x+2 is correctly placed here::

        lambda x: x+2

# --- end exercise ---

# --- begin exercise ---

Exercise 8: Solution of differential equation
---------------------------------------------




Question: Given::

        \[ \frac{dy}{dx} = -y(x),\quad y(0)=1 \]

What is the solution of this equation?

Choice A: y=e^{-y}

Choice B: y=e^{y}

Choice C: 
Code::

        from math import exp
        def f(x):
            return exp(x)

Choice D: The solution cannot be found because there is a derivative in the equation.

Choice E: The equation is meaningless: an equation must be an equation
for x or y, not a function y(x).



# --- end exercise ---

# --- begin exercise ---

Example 9: Just an example
--------------------------

*a)*
What is the capital of Norway?

*Answer.*
Oslo.

# --- end exercise ---

Here goes another section
=========================

With some text, before we continue with exercises.

More Exercises
==============

# --- begin exercise ---

Exercise 10: Make references to projects and problems
-----------------------------------------------------

Pick a statement from "Project 5: Explore Distributions of Random Circles" or "Problem 2: Flip a Coin"
and verify it.

Test list at the end of an exercise without other elements (like subexercise,
hint, etc.):

1. item1

2. item2

Filename: verify_formula.py.

# --- end exercise ---

# --- begin exercise ---

Project 11: References to "Project 4: Compute a Probability" in a heading works for plain
-----------------------------------------------------------------------------------------

Refer to the previous exercise as "Exercise 10: Make references to projects and problems",
the two before that as "Project 4: Compute a Probability" and "Project 5: Explore Distributions of Random Circles",
and this one as "Project 11: References to Project ref{demo:ex:2} in a heading works for plain".
Filename: selc_composed.pdf.

# --- end exercise ---

References
==========

 1. _H. P. Langtangen and G. Pedersen_. 
    Propagation of Large Destructive Waves,
    *International Journal of Applied Mechanics and Engineering*,
    7(1),
    pp. 187-204,
    2002.

 2. _H. P. Langtangen, K.-A. Mardal and R. Winther_. 
    Numerical Methods for Incompressible Viscous Flow,
    *Advances in Water Resources*,
    25,
    pp. 1125-1146,
    2002.

 3. _H. P. Langtangen_. 
    Numerical Solution of First Passage Problems in Random Vibrations,
    *SIAM Journal of Scientific and Statistical Computing*,
    15,
    pp. 997-996,
    1994.

 4. _K.-A. Mardal, G. W. Zumbusch and H. P. Langtangen_. 
    Software Tools for Multigrid Methods,
    *Advanced Topics in Computational Partial Differential Equations -- Numerical Methods and Diffpack Programming*,
    edited by _H. P. Langtangen and A. Tveito_,
    Springer,
    2003,
    Edited book,
    http://some.where.org.

 5. _H. P. Langtangen_. 
    The FEMDEQS Program System,
    *Department of Mathematics, University of Oslo*,
    1989,
    http://www.math.uio.no/old/days/hpl/femdeqs.pdf.

 6. _H. P. Langtangen_. 
    Stochastic Breakthrough Time Analysis of an Enhanced Oil Recovery Process,
    *SIAM Journal on Scientific Computing*,
    13,
    pp. 1394-1417,
    1992.

 7. _M. Mortensen, H. P. Langtangen and G. N. Wells_. 
    A FEniCS-Based Programming Framework for Modeling Turbulent Flow by the Reynolds-Averaged Navier-Stokes Equations,
    *Advances in Water Resources*,
    34(9),
    doi: 10.1016/j.advwatres.2011.02.013 (https://dx.doi.org/10.1016/j.advwatres.2011.02.013),
    2011.

 8. _S. Glimsdal, G. Pedersen, K. Atakan, C. B. Harbitz, H. P. Langtangen and F. L\ovholt_. 
    Propagation of the Dec. 26, 2004 Indian Ocean Tsunami: Effects of Dispersion and Source Characteristics,
    *International Journal of Fluid Mechanics Research*,
    33(1),
    pp. 15-43,
    2006.

 9. _S. Rahman, J. Gorman, C. H. W. Barnes, D. A. Williams and H. P. Langtangen_. 
    Numerical Investigation of a Piezoelectric Surface Acoustic Wave Interaction With a One-Dimensional Channel,
    *Physical Review B: Condensed Matter and Materials Physics*,
    74,
    2006,
    035308.

10. _J. B. Haga, H. Osnes and H. P. Langtangen_. 
    On the Causes of Pressure Oscillations in Low-Permeable and Low-Compressible Porous Media,
    *International Journal of Analytical and Numerical Methods in Geomechanics*,
    doi: 10.1002/nag.1062 (https://dx.doi.org/10.1002/nag.1062),
    2011,
    http://onlinelibrary.wiley.com/doi/10.1002/nag.1062/abstract.

11. _H. P. Langtangen_. 
    *Computational Partial Differential Equations - Numerical Methods and Diffpack Programming*,
    second edition,
    *Texts in Computational Science and Engineering*,
    Springer,
    2003.

12. _H. P. Langtangen_. 
    *Python Scripting for Computational Science*,
    third edition,
    *Texts in Computational Science and Engineering*,
    Springer,
    2008.

13. _H. P. Langtangen and G. Pedersen_. 
    Finite Elements for the Boussinesq Wave Equations,
    Waves and Non-linear Processes in Hydrodynamics,
    edited by _J. Grue, B. Gjevik and J. E. Weber_,
    Kluwer Academic Publishers,
    pp. pp. 117-126,
    1995,
    http://www.amazon.ca/Waves-Nonlinear-Processes-Hydrodynamics-John/dp/0792340310.

14. _H. P. Langtangen_. 
    *A Primer on Scientific Programming With Python*,
    third edition,
    *Texts in Computational Science and Engineering*,
    Springer,
    2012.

15. _P. V. Jeberg, H. P. Langtangen and C. B. Terp_. 
    Optimization With Diffpack: Practical Example From Welding,
    *Simula Research Laboratory*,
    2004,
    Internal report.

16. _H. P. Langtangen_. 
    Computational Methods for Two-Phase Flow in Oil Reservoirs,
    Ph.D. Thesis,
    Mechanics Division, Department of Mathematics, University of Oslo,
    1989,
    Dr. Scient. thesis..

17. _H. P. Langtangen_. 
    Computational Modeling of Huge Tsunamis From Asteroid Impacts,
    2007,
    Invited keynote lecture at the \emphInternational conference on Computational Science 2007 (ICCS'07), Beijing, China.

18. _H. P. Langtangen_. 
    Solution of the Navier-Stokes Equations With the Finite Element Method in Two and Three Dimensions,
    M.Sc. Thesis,
    Mechanics Division, Department of Mathematics, University of Oslo,
    1985,
    Cand.Scient. thesis.

19. _H. P. Langtangen and A. Tveito_. 
    Numerical Methods in Continuum Mechanics,
    *Center for Industrial Research*,
    1991,
    Lecture notes for a course (ME-IN 324). 286 pages..

20. _H. P. Langtangen_. 
    Diffpack: Software for Partial Differential Equations,
    *Proceedings of the Second Annual Object-Oriented Numerics Conference (OON-SKI'94), Sunriver, Oregon, USA*,
    edited by _A. Vermeulen_,
    1994.

Appendix: Just for testing; part I
==================================

This is the first appendix.

A subsection within an appendix
-------------------------------

Some text.

Appendix: Just for testing; part II
===================================

This is more stuff for an appendix.

Appendix: Testing identical titles
----------------------------------

Without label.

Appendix: Testing identical titles
----------------------------------

With label.

Appendix: Testing identical titles
----------------------------------

What about inserting a quiz?




Fundamental test: What is the capital of Norway?

Answer 1: Stockholm

Answer 2: London

Answer 3: Oslo

Choice D: Bergen



Appendix: Testing identical titles
----------------------------------

Without label.


Tip --------------------------------------------------|
|                                                     |
| Here is a tip or hint box, typeset as a notice box. |
|-----------------------------------------------------|


Need a lot of text to surround the summary box.
Version control systems allow you to record the history of files
and share files among several computers and collaborators in a
professional way. File changes on one computer are updated or
merged with changes on another computer. Especially when working
with programs or technical reports it is essential
to have changes documented and to
ensure that every computer and person involved in the project
have the latest updates of the files.
Greg Wilson' excellent Script for Introduction to Version Control (https://software-carpentry.org/2010/07/script-for-introduction-to-version-control/) provides a more detailed motivation why you will benefit greatly
from using version control systems.


Summary ---------------------------------------------------|
|                                                          |
| _Bold remark:_ Make some text with this summary.         |
| Much testing in this document, otherwise stupid content. |
| Much testing in this document, otherwise stupid content. |
| Much testing in this document, otherwise stupid content. |
| Much testing in this document, otherwise stupid content. |
| Much testing in this document, otherwise stupid content. |
| Much testing in this document, otherwise stupid content. |
| Much testing in this document, otherwise stupid content. |
| Much testing in this document, otherwise stupid content. |
| Much testing in this document, otherwise stupid content. |
|----------------------------------------------------------|


Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that site. I strongly
recommend you to use such sites for all serious programming and
scientific writing work - and all other important files.

The simplest services for hosting project files are Dropbox (https://dropbox.com) and Google Drive (https://drive.google.com).
It is very easy to get started with these systems, and they allow you
to share files among laptops and mobile units with as many users as
you want. The systems offer a kind of version control in that the
files are stored frequently (several times per minute), and you can go
back to previous versions for the last 30 days. However, it is
challenging  to find the right version from the past when there are
so many of them.

More seriously, when several people may edit files simultaneously, it
can be difficult detect who did what when, roll back to previous
versions, and to manually merge the edits when these are
incompatible. Then one needs more sophisticated tools than Dropbox or
Google Drive: project hosting services with true version control
systems.  The following text aims at providing you with the minimum
information to started with such systems. Numerous other tutorials
contain more comprehensive material and in-depth explanations of the
concepts and tools.

The idea with project hosting services is that you have the files
associated with a project in the cloud. Many people may share these
files.  Every time you want to work on the project you explicitly
update your version of the files, edit the files as you like, and
synchronize the files with the "master version" at the site where the
project is hosted.  If you at some point need to go back to a
version of the files at some particular point in the past,
this is an easy operation. You can also use tools to see
what various people have done with the files in the various versions.

All these services are very similar. Below we describe how you get
started with Bitbucket, GitHub, and Googlecode. Launchpad works very
similarly to the latter three. All the project hosting services have
excellent introductions available at their web sites, but the recipes
below are much shorter and aim at getting you started as quickly as
possible by concentrating on the most important need-to-know steps.
The Git tutorials we refer to later in this document contain more
detailed information and constitute of course very valuable readings
when you use version control systems every day. The point now is
to get started.

Appendix: Testing inline comments
---------------------------------

Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that
site. [hpl's semi opinion 1: not sure if in the cloud is
understood by
all.] I strongly recommend you to use such sites for all serious
programming and scientific writing work - and all other important
files.

The simplest services for hosting project files is Dropbox. [mp 2: Simply go to https://dropbox.com and watch the video. It explains
how files, like myfile.py, perhaps containing much math, like
\partial u/\partial t, are easily communicated between machines.] It
is very easy to get started with Dropbox, and it allows you to share
files among [hpl 3: laptops and mobile units -> computers, tablets,
and phones].

------

First[add 4: ,] consider a quantity Q. [edit 5: To this end, -> We note that]
Q>0, because [del 6: a] negative [edit 7: quantity is -> quantities
are] [del 8: just] negative. [add 9: This comes as no surprise.]

Let us refer to Figure ref{fig:impact} again.

Test references in a list:

 * "Section 1"

 * "Subsection 1"

 * ref{fig:impact}

Appendix: Testing headings ending with verbatim inline
------------------------------------------------------

The point here is to test 1) verbatim code in headings, and 2)
ending a heading with verbatim code as this triggers a special
case in LaTeX.

We also test mdash---used as alternative to hyphen without spaces around,
or in quotes:

        *Fun is fun*.---Unknown.


The ndash should also be tested - as in the Hanson - Nilson equations
on page 277 - 278.

And finally, what about admons, quotes, and boxes? They are tested
in a separate document: admon.do.txt.

[^example-of-the-third-footnote]: Not much to add here, but the footnote
is at the end with only one newline.
************** File: testdoc.md *****************
% A Document for Testing DocOnce
% **Hans Petter Langtangen** at Center for Biomedical Computing, Simula Research Laboratory and Department of Informatics, University of Oslo;  **Kaare Dump** at Segfault, Cyberspace;  **A. Dummy Author**;  **I. S. Overworked and Outburned** at Inst1 and Inst2, Somewhere and Third Inst, Elsewhere and Fourth Inst;  **J. Doe**
% Jan 32, 2100

Made with DocOnce



<!-- Table of contents: Run pandoc with --toc option -->

<!-- !split -->

The format of this document is
pandoc
*Abstract.* This is a document with many test constructions for doconce syntax.
It was used heavily for the development and kept for testing
numerous constructions, also special and less common cases.

And exactly for test purposes we have an extra line here, which
is part of the abstract.

<!-- Cannot demonstrate chapter headings since abstract and chapter -->
<!-- are mutually exclusive in LaTeX -->



## Section 1
<div id="sec1"></div>

Here is a nested list:

  * item1
  * item2
  * item3 which continues
    on the next line to test that feature
  * and a sublist
    * with indented subitem1
    * and a subitem2

  * and perhaps an ordered sublist
   a. first item
   b. second item,
      continuing on a new line


*Here is a list with paragraph heading.*

  * item1
  * item2

#### Here is a list with subsubsection heading

  * item1
  * item2

> Here are two lines that make up
> a block quote for testing *emphasized words* and **boldface words**,
> also with hypens:
> *pre*-fix, post-*fix*, **pre**-fix, post-**fix**.



Here are two references. Equation\ ([my:eq1](#my:eq1)) is fine. Eq.\ ([my:eq1](#my:eq1)) too.
Even Equation ([my:eq1](#my:eq1)) without the tilde.

### Subsection 1
<div id="subsec1"></div>

<!-- Refer to section/appendix etc. at the beginning of the line -->
<!-- and other special fix situations for HTML. -->

More text, with a reference back to
the section [Section 1](#sec1) and [Subsection 1](#subsec1), and further to the
the sections [Subsection 1](#subsec1) and [URLs](#subsubsec:ex), which
encourages you to do the tasks in [Problem 2: Flip a Coin](#demo:ex:1) and [Exercise 10: Make references to projects and problems](#exer:some:formula).
 [Appendix: Just for testing; part I](#app1) and [Appendix: Just for testing; part II](#app2) are also nice elements.

#### Test Section reference at beginning of line and after a sentence

The section [Subsection 1](#subsec1) is fine.
The section [URLs](#subsubsec:ex) too.

<!-- sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console -->

#### Computer code

Let's do some copying from files too. First from subroutine up to the very end,


~~~{.Fortran}
      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
~~~

and then just the subroutine,

~~~{.Fortran}
      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
~~~

and finally the complete file with a plain text verbatim environment
(`envir=ccq`):

~~~
C     a comment

      subroutine test()
      integer i
      real*8 r
      r = 0
      do i = 1, i
         r = r + i
      end do
      return
C     END1

      program testme
      call test()
      return
~~~

Testing other code environments. First Python:


~~~
!bc pycod
def f(x):
    return x+1
!ec
~~~

which gets rendered as


~~~{.Python}
def f(x):
    return x+1
~~~

Test paragraph and subsubsection headings before
before code.

*Paragraph heading before code.*


~~~{.Python}
import sys
sys.path.insert(0, os.pardir)
~~~

#### Subsubsection heading before code


~~~{.Python}
def h(z):
    return z+1
~~~

Here is a program that is supposed to be interactive via
Python Online Tutorial, but that service is not accessible
for the present format.


~~~{.Python}
class Line:
    def __init__(self, a, b):
        self.a, self.b = a, b

    def __call__(self, x):
        a, b = self.a, self.b
        return a*x + b

line = Line(2, 1)
y = line(x=3)
print(y)
~~~

Some more Python code (actually specified as a sage cell, but
such cells are not supported by this format).


~~~{.Python}
a = 2
b = 3
print('a+b:', a + b)

# In a sage cell we can also plot
from matplotlib.pyplot import *
from numpy import *
x = linspace(0, 4*pi, 101)
y = exp(-0.1*x)*cos(x)
plot(x, y)
xlabel('x'); ylabel('y')
show()
~~~

Then Cython (with -h option so it is hidden in html/sphinx):


~~~{.Python}
cpdef f(double x):
    return x + 1
~~~

Standard Python shell sessions:


~~~{.Python}
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
~~~

Similar IPython sessions:


~~~{.Python}
In [1]: from numpy import linspace, sin
In [2]: # Some comment
In [3]: x = linspace(0, 2, 11)
In [4]: y = sin(x)
In [5]: y[0]
Out[5]: 0
In [6]: import matplotlib.pyplot as plt
In [7]: plt.plot(x, y)
In [8]: a='multiple-\nline\noutput'
In [9]: a
Out[9]: 'multiple-\nline\noutput'
In [10]: print(a)
multiple-
line
output
~~~

Here is the interactive session again, but with `pyshell-t`.


~~~{.Python}
>>> from numpy import linspace, sin
>>> # Some comment
>>> x = linspace(0, 2, 11)
>>> y = sin(x)
>>> y[0]
0
>>> import matplotlib.pyplot as plt
>>> plt.plot(x, y)
~~~

<!-- This one tests a + sign before a code environment -->
C++:

~~~{.Cpp}
#include <iostream>

int main()
{
   std::cout << "Sample output" << std::endl;
   return 0
}
~~~

<!-- The next should get correctly typset in sphinx (cod is fcod) -->
<!-- It also tests emoji before code -->
And a little bit of Fortran: :dizzy_face:


~~~
!bc cod
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
!ec
~~~

which then is typeset as


~~~{.Python}
      subroutine midpt(x, length, a, b)
      real*8 a, b, x
      x = (a + b)/2
      length = b - a
      return
      end
~~~

HTML:


~~~{.HTML}
<table>
<tr><td>Column 1</td><td>Column 2</td></tr>
<tr><td>0.67526 </td><td>0.92871 </td></tr>
<!-- comment -->
</table>
~~~

But inline HTML code is also important, like text that starts with
`<a href="` (which can destroy the following text if not properly
quoted).

Matlab with comments requires special typesetting:


~~~
% Comment on the beginning of the line can be escaped by %%
if a > b
  % Indented comment needs this trick
  c = a + b
end
~~~

And here is a system call:


~~~
Terminal> mkdir test
Terminal> cd test
Terminal> myprog -f
output1
output2
~~~

Any valid pygments lexer/language name can appear to, e.g.,


~~~
!bc restructuredtext
=======
Heading
=======

Some text.
!ec
~~~

results in


~~~
=======
Heading
=======

Some text.
~~~

<!-- Here goes hidden code. -->
<!-- Python can be treated by some formats, Fortran is always out. -->





Finally, `!bc do` supports highlighting of DocOnce source:


~~~
======= DocOnce test file =======

===== Computer code =====

Inline verbatim code, as in `import numpy as np`, is allowed, as well as
code blocks:

!bc pycod
from math import sin

def f(x):
    """Example on a function."""
    return sin(x) + 1

print(f(0))
!ec


===== Mathematics =====

Formulas can be inline, as in $\nabla\cdot\boldsymbol{u} = 0$, or typeset
as equations:

!bt
\begin{align*}
\nabla\cdot\boldsymbol{u} &= 0,\\ 
\boldsymbol{u} &= \nabla\phi .
\end{align*}
!et

=== Subsubsection heading ===

DocOnce files can have chapters, sections, subsections, and subsubsections.

__Paragraph heading.__ Paragraphs may have headings.
~~~

It is time to test `verbatim inline font` especially with `a newline
inside the text` and an exclamation mark at the end: `BEGIN`! For
spellcheck, test `a verbatim expression` in `another` in a `third`.
Also test exclamation mark as in `!bc` and `!ec` as well as `a != b`.
Also test backslashes and braces like `\begin`, `\begin{enumerate}`,
`\end{this}\end{that}`, and `{something \inside braces}`.

The following attempt to exemplify colored text does not work in
format pandoc.
Here is some <font color="red">red color</font> and an attempt to write <font color="green">with
green color containing a linebreak\n
code.</font> Some formats will only display \n
this correctly when `html` \n
is the output format.
But here some more running text is added which is not part of
the previous blocks with line breaks.

#### Running OS commands


~~~
Terminal> python -c 'print("Testing\noutput\nfrom\nPython.")'
Testing
output
from
Python.
~~~

#### Footnotes

Here is a test of footnotes [^footnote], which are handy in text.
They are used in different flavors, now in

 * list items (note below that footnotes work after math, verbatim, and URLs - bin fact old and emphasize too!)
 * even with math $\nabla^2u$[^math1]
 * and code `h[i] += 1`[^code]
   (*must* have space between inline code and footnote!)
 * and [links](https://google.com)[^google-search]

which gives flexibility in writing.
This is the third[^example-of-the-third-footnote] example.

  [^footnote]: Typesetting of the footnote depends on the format.
Plain text does nothing, LaTeX removes the
definition and inserts the footnote as part of the LaTeX text.
reStructuredText and Sphinx employ a similar type of typesetting
as Extended Markdown and DocOnce, and in HTML we keep the same
syntax, just displayed properly in HTML.
[^math1]: Math footnotes can be dangerous since it
interferes with an exponent.
[^code]: One-line footnote.

[^google-search]: <google.com> is perhaps the most famous
web site today.

Here is some more text before a new definition of a footnote that was
used above.

*Non-breaking space character.* 
This paragraph aims to test [non-breaking space character](https://en.wikipedia.org/wiki/Non-breaking_space), and a typical
example where this is needed is in physical units: 7.4\ km is traveled
in\ $7.4/5.5\approx 1.345$\ s.  Also check that a~[link](https://google.com)\ is
not broken across lines (drag the browser window to test this).
(On the other hand, the tilde is used in
computer code, e.g., as in `[~x for x in y]` or in `y=~x`, and should
of course remain a tilde in those contexts.)



### Subsection 2: Testing figures
<div id="subsec:ex"></div>

Test of figures. In particular we refer to [Figure](#fig:impact) in which
there is a flow.

<!-- <img src="../doc/src/manual/fig/wave1D.png" width=200><p><em>Visualization **of** a *wave*. <div id="fig:impact"></div></em></p> -->
![<p><em>Visualization **of** a *wave*. <div id="fig:impact"></div></em></p>](../doc/src/manual/fig/wave1D.png)

Figures without captions are allowed and will be inlined.

<!-- <img src="../doc/src/manual/fig/wave1D.png" width=200> -->
![](../doc/src/manual/fig/wave1D.png)

<!-- Test multi-line caption in figure with sidecap=True -->

Here is [figure](#myfig) with a long (illegal) multi-line caption
containing inline verbatim text:

<!-- <img src="../doc/src/manual/fig/wave1D.png" width=500><p><em>A long caption spanning several lines and containing verbatim words like `my_file_v1` and `my_file_v2` as well as math with subscript as in $t_{i+1}$. <div id="myfig"></div></em></p> -->
![<p><em>A long caption spanning several lines and containing verbatim words like `my_file_v1` and `my_file_v2` as well as math with subscript as in $t_{i+1}$. <div id="myfig"></div></em></p>](../doc/src/manual/fig/wave1D.png)

<!-- Must be a blank line after MOVIE or FIGURE to detect this problem -->

Test URL as figure name:

<!-- <img src="https://raw.github.com/doconce/doconce/master/doc/src/blog/f_plot.png" width=500> -->
![](https://raw.github.com/doconce/doconce/master/doc/src/blog/f_plot.png)

<!-- Test wikimedia type of files that otherwise reside in subdirs -->

*Remark.*
Movies are tested in separate file `movies.do.txt`.

<!-- Somewhat challenging heading with latex math, \t, \n, ? and parenthesis -->

### The $\theta$ parameter (not $\nabla$?)
<div id="decay:sec:theta"></div>

Functions do not always need to be advanced, here is one
involving $\theta$:

~~~
def f(theta):
    return theta**2
~~~

*More on $\theta$.* Here is more text following headline with math.

Newcommands must also be tested in this test report:
$\frac{1}{2}$, ${1/2}$, $\pmb{x}$, $\frac{Du}{dt}$,
both inline and in block:

$$
\begin{align}
\frac{Du}{dt} &= 0\nonumber
\\ 
\frac{1}{2} &= {1/2}\\ 
\frac{1}{2}\pmb{x} &= \pmb{n}
\end{align}
$$

Or with align with label and numbers:

$$
\begin{align}
\frac{Du}{dt} &= 0
\label{aligneq1}
\\ 
\frac{1}{2} &= {1/2}\\ 
\frac{1}{2}\pmb{x} &= \pmb{n}
\label{aligneq2}
\end{align}
$$

### Custom Environments

Here is an attempt to create a theorem environment via Mako
(for counting theorems) and comment lines to help replacing lines in
the `.tex` by proper begin-end LaTeX environments for theorems.
Should look nice in most formats!

<!-- begin theorem -->
<div id="theorem:fundamental1"></div>

*Theorem 5.*
Let $a=1$ and $b=2$. Then $c=3$.
<!-- end theorem -->

<!-- begin proof -->
*Proof.*
Since $c=a+b$, the result follows from straightforward addition.
$\Diamond$
<!-- end proof -->

As we see, the proof of Theorem 5 is a modest
achievement.

### Tables
<div id="subsec:table"></div>

<!-- index with comma could fool sphinx -->

Let us take this table from the manual:


time  velocity  acceleration  
----  --------  ------------  
0.0     1.4186         -5.01  
2.0   1.376512        11.919  
4.0     1.1E+1     14.717624  


The DocOnce source code reads

~~~

  |--------------------------------|
  |time  | velocity | acceleration |
  |--l--------r-----------r--------|
  | 0.0  | 1.4186   | -5.01        |
  | 2.0  | 1.376512 | 11.919       |
  | 4.0  | 1.1E+1   | 14.717624    |
  |--------------------------------|

~~~

Here is yet another table to test that we can handle more than
one table:


time  velocity  acceleration  
----  --------  ------------  
0.0   1.4186    -5.01         
1.0   1.376512  11.919        
3.0   1.1E+1    14.717624     


And one with math headings (that are expanded and must be treated
accordingly), verbatim heading and entry, and no space around the pipe
symbol:


$i$  $h_i$   $\bar T_i$   `L_i`   
---  ------  ----------  -------  
0         0         288  -0.0065  
1    11,000         216      0.0  
2    20,000         216    0.001  
3    32,000         228   0.0028  
4    47,000         270      0.0  
5    51,000         270  -0.0028  
6    71,000         214    `NaN`  


And add one with verbatim headings (with underscores),
and rows starting with `|-` because of a negative number,
and `|` right before and after verbatim word (with no space):


exact  `v_1`   $a_i$ + `v_2`  `verb_3_`  
-----  ------  -------------  ---------  
    9    9.62           5.57       8.98  
  -20  -23.39          -7.65     -19.93  
   10   17.74          -4.50       9.96  
    0   -9.19           4.13      -0.26  


Pipe symbols in verbatim and math text in tables used to pose difficulties,
but not
anymore:


    $S$         command     
-----------  -------------  
$ ||a_0|| $  `norm|length`  
$x\cap y$            `x|y`  


Here is a table with X alignment:


 Type                                                                                                       Description                                                                                                        
-----  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------  
  X    Alignment character that is used for specifying a potentially very long text in a column in a table. It makes use of the `tabularx` package in LaTeX, otherwise (for other formats) it means `l` (centered alignment).  
l,r,c  standard alignment characters                                                                                                                                                                                           


Finally, a table with math
(`bm` that expands to `boldsymbol`, was tricky, but
cleanly handled now)
and URLs.

<!-- Mako code to expand URLs in the table -->
<!-- (These types of tables did not work before Jan 2014) -->


                                                                                                                                                       
-------------------------------  ---------------------------------------------------------  ---------------------------------------------------------  
        $\mathcal{L}=0$          [`080`](../doc/src/manual/mov/wave_frames/frame_0080.png)  [`085`](../doc/src/manual/mov/wave_frames/frame_0085.png)  
             $a=b$               [`090`](../doc/src/manual/mov/wave_frames/frame_0090.png)  [`095`](../doc/src/manual/mov/wave_frames/frame_0095.png)  
$\nabla\cdot\boldsymbol{u} =0 $  [`100`](../doc/src/manual/mov/wave_frames/frame_0100.png)  [`105`](../doc/src/manual/mov/wave_frames/frame_0105.png)  


### A test of verbatim words in heading with subscript $a_i$: `my_file_v1` and `my_file_v2`

*Paragraph with verbatim and math: `my_file_v1.py` and `my_file_v2.py` define some math $a_{i-1}$.* Here is more `__verbatim__` code and
some plain text on a new line.

<!-- Test various types of headlines -->
### **Just bold**

Some text.

### *Just emphasize*

Some text.

### `Just verbatim`

Some text.

### **Bold** beginning

Some text.

### *Emphasize* beginning

Some text.

### `Verbatim` beginning

Some text.

### Maybe **bold end**

Some text.

### Maybe *emphasize end*

Some text.

### Maybe `verbatim end`

Some text.

### The middle has **bold** word

Some text.

### The middle has *emphasize* word

Some text.

### The middle has `verbatim` word

Some text.

**Just emphasize*.* Some text.

*`Just verbatim`.* Some text.

**Emphasize* beginning.* Some text.

*`Verbatim beginning`.* Some text.

*Maybe *emphasize end*.* Some text.

*Maybe `verbatim end`.* Some text.

*The middle has *emphasize* word.* Some text.

*The middle has `verbatim` word.* Some text.

*Ampersand.*
We can test Hennes & Mauritz, often abbreviated H&M, but written
as `Hennes & Mauritz` and `H & M`.
A sole `&` must also work.
<!-- Note: substitutions must not occur inside verbatim, just in ordinary text. -->


~~~
# Just to check that ampersand works in code blocks:
c = a & b
~~~

*Quotes.*
Let us also add a test of quotes such as "double quotes, with numbers
like 3.14 and newline/comma and hyphen (as in double-quote)"; written
in the standard LaTeX-style that gives correct LaTeX formatting and
ordinary double quotes for all non-LaTeX formats.  Here is another
sentence that "caused" a bug in the past because double backtick
quotes could imply verbatim text up to a verbatim word starting with
period, like `.txt`.

More quotes to be tested for spellcheck:
("with parenthesis"), "with newline"
and "with comma", "hyphen"-wise, and "period".

### Bibliography test

Here is an example: [@Langtangen_Pedersen_2002] discussed propagation of
large destructive water waves, [@Langtangen_et_al_2002] gave
an overview of numerical methods for solving the Navier&ndash;Stokes equations,
while the use of Backward Kolmogorov equations for analyzing
random vibrations was investigated in [@Langtangen_1994a].
The book chapter [@Mardal_et_al_2003a] contains information on
C++ software tools for programming multigrid methods. A real retro
reference is [@Langtangen_1988d] about a big FORTRAN package.
Multiple references are also possible, e.g., see
[@Langtangen_Pedersen_2002;@Mardal_et_al_2003a].

We need to cite more than 10 papers to reproduce an old formatting
problem with blanks in the keys in reST format:
[@Langtangen_1992c;@Langtangen_1994a;@Mortensen_et_al_2011;@Langtangen_Pedersen_2002]
and
[@Langtangen_et_al_2002;@Glimsdal_et_al_20006;@Rahman_et_al_2006b;@Haga_et_al_2011a;@Langtangen_2003a;@Langtangen_2008a;@Langtangen:95]
and all the work of
[@Langtangen_2012;@Mardal_et_al_2003a;@Jeberg_et_al_2004] as well as
old work [@Langtangen_1988d] and [@Langtangen_1989e], and the
talk [@Langtangen_talk_2007a].
Langtangen also had two thesis [@Langtangen:85;@Langtangen_1989e]
back in the days.
More retro citations are
the old ME-IN323 book [@Langtangen:91] and the
[@Langtangen:94b] OONSKI '94 paper.

<!-- --- begin exercise --- -->

### Example 1: Examples can be typeset as exercises
<div id="Example"></div>

Examples can start with a subsection heading starting with `Example:`
and then, with the command-line option `--examples_as_exercises` be
typeset as exercises. This is useful if one has solution
environments as part of the example.

*a)*
State some problem.

*Solution.*
The answer to this subproblem can be written here.

*b)*
State some other problem.

*Hint 1.*
A hint can be given.

*Hint 2.*
Maybe even another hint?

*Solution.*
The answer to this other subproblem goes here,
maybe over multiple doconce input lines.

<!-- --- end exercise --- -->

### User-defined environments

The example in the section [Example 1: A test function](#ex:test:1p1) demonstrates how to write a test function.
That is, a special test function for a function `add` appears in
the example in the section [Example 1: A test function](#ex:test:1p1).

### Example 1: A test function
<div id="ex:test:1p1"></div>

Suppose we want to write a test function for checking the
implementation of a Python function for addition.


~~~{.Python}
def add(a, b):
    return a + b

def test_add():
    a = 1; b = 1
    expected = a + b
    computed = add(a, b)
    assert expected == computed
~~~

### Example 2: Addition
<div id="ex:math:1p1"></div>

We have

$$
 1 + 1 = 2 
$$
or in tabular form:


Problem  Result  
-------  ------  
 $1+1$    $2$    


*Highlight box!* 
This environment is used to highlight something:

$$
 E = mc^2 
$$



### URLs
<div id="subsubsec:ex"></div>

Testing of URLs: hpl's home page [hpl](https://folk.uio.no/hpl), or
the entire URL if desired, <https://folk.uio.no/hpl>.  Here is a
plain file link <testdoc.do.txt>, or <testdoc.do.txt>, or
<testdoc.do.txt> or <testdoc.do.txt> or [a link with
newline](testdoc.do.txt). Can test spaces with the link with word
too: [hpl](https://folk.uio.no/hpl) or [hpl](https://folk.uio.no/hpl). Also `file:///` works: [link to a
file](file:///home/hpl/vc/doconce/doc/demos/manual/manual.html) is
fine to have. Moreover, "loose" URLs work, i.e., no quotes, just
the plain URL as in <https://folk.uio.no/hpl>, if followed by space, comma,
colon, semi-colon, question mark, exclamation mark, but not a period
(which gets confused with the periods inside the URL).

Mail addresses can also be used: [`hpl@simula.no`](mailto:hpl@simula.no), or just a [mail link](mailto:hpl@simula.no), or a raw <mailto:hpl@simula.no>.

Here are some tough tests of URLs, especially for the `latex` format:
[Newton-Cotes](https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas) formulas
and a [good book](https://www.springer.com/mathematics/computational+science+%26+engineering/book/978-3-642-23098-1). Need to test
Newton-Cotes with percentage in URL too:
<https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas>
and <https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae> which has a shebang.

For the `--device=paper` option it is important to test that URLs with
monospace font link text get a footnote
(unless the `--latex_no_program_footnotelink`
is used), as in this reference to
[`decay_mod`](https://github.com/hplgit/INF5620/tree/gh-pages/src/decay/experiments/decay_mod.py), [`ball1.py`](https://tinyurl.com/pwyasaa/formulas.ball1.py),
and [`ball2.py`](https://tinyurl.com/pwyasaa/formulas.ball2.py).

<!-- Comments should be inserted outside paragraphs (because in the rst -->
<!-- format extra blanks make a paragraph break). -->

<!-- Note that when there is no https: or file:, it can be a file link -->
<!-- if the link name is URL, url, "URL", or "url". Such files should, -->
<!-- if rst output is desired, but placed in a `_static*` folder. -->

More tough tests: repeated URLs whose footnotes when using the
`--device=paper` option must be correct. We have
[google](https://google.com), [google](https://google.com), and
[google](https://google.com), which should result in exactly three
footnotes.

<!-- !split and check if these extra words are included properly in the comment -->

## LaTeX Mathematics

Here is an equation without label using backslash-bracket environment:
$$
 a = b + c 
$$

or with number and label, as in ([my:eq1](#my:eq1)), using the equation environment:

$$
\begin{equation}
{\partial u\over\partial t} = \nabla^2 u \label{my:eq1}
\end{equation}
$$

We can refer to this equation by ([my:eq1](#my:eq1)).

Here is a system without equation numbers, using the align-asterisk environment:

$$
\begin{align*}
\pmb{a} &= \pmb{q}\times\pmb{n} \\ 
b &= \nabla^2 u + \nabla^4 v
\end{align*}
$$

And here is a system of equations with labels in an align environment:

$$
\begin{align}
a &= q + 4 + 5+ 6 \label{eq1} \\ 
b &= \nabla^2 u + \nabla^4 x \label{eq2}
\end{align}

$$
We can refer to ([eq1](#eq1))-([eq2](#eq2)). They are a bit simpler than
the Navier&ndash;Stokes equations. And test LaTeX hyphen in `CG-2`.
Also test $a_{i-j}$ as well as $kx-wt$.

Testing `alignat` environment:

$$
\begin{alignat}{2}
a &= q + 4 + 5+ 6\qquad & \mbox{for } q\geq 0 \label{eq1a} \\ 
b &= \nabla^2 u + \nabla^4 x & x\in\Omega \label{eq2a}
\end{alignat}
$$

More mathematical typesetting is demonstrated in the coming exercises.

Below, we have [Problem 2: Flip a Coin](#demo:ex:1) and [Project 4: Compute a Probability](#demo:ex:2),
as well as [Project 5: Explore Distributions of Random Circles](#proj:circle1) and [Project 11: References to Project [demo:ex:2](#demo:ex:2) in a heading works for pandoc](#exer:you), and in
between there we have [Exercise 10: Make references to projects and problems](#exer:some:formula).

## Exercises

<!-- --- begin exercise --- -->

### Problem 2: Flip a Coin
<div id="demo:ex:1"></div>
<!-- keywords = random numbers; Monte Carlo simulation; ipynb -->

<!-- Torture tests -->

*a)*
Make a program that simulates flipping a coin $N$ times.
Print out "tail" or "head" for each flip and
let the program count the number of heads.

<!-- --- begin hint in exercise --- -->

*Hint 1.*
Use `r = random.random()` and define head as `r <= 0.5`.

<!-- --- end hint in exercise --- -->

<!-- --- begin hint in exercise --- -->

*Hint 2.*
Draw an integer among $\{1,2\}$ with
`r = random.randint(1,2)` and define head when `r` is 1.

<!-- --- end hint in exercise --- -->

<!-- --- begin answer of exercise --- -->
*Answer.*
If the `random.random()` function returns a number $<1/2$, let it be
head, otherwise tail. Repeat this $N$ number of times.
<!-- --- end answer of exercise --- -->

<!-- --- begin solution of exercise --- -->
*Solution.*

~~~{.Python}
import sys, random
N = int(sys.argv[1])
heads = 0
for i in range(N):
    r = random.random()
    if r <= 0.5:
        heads += 1
print('Flipping a coin %d times gave %d heads' % (N, heads))
~~~

<!-- --- end solution of exercise --- -->

*b)*
Vectorize the code in a) using boolean indexing.

Vectorized code can be written in many ways.
Sometimes the code is less intuitive, sometimes not.
At least there is not much to find in the section [Section 1](#sec1).

*c)*
Vectorize the code in a) using `numpy.sum`.

<!-- --- begin answer of exercise --- -->
*Answer.*
`np.sum(np.where(r <= 0.5, 1, 0))` or `np.sum(r <= 0.5)`.
<!-- --- end answer of exercise --- -->

In this latter subexercise, we have an
example where the code is easy to read.

#### My remarks

Remarks with such a subsubsection is treated as more text
after the last subexercise. Test a list too:

1. Mark 1.
2. Mark 2.

Filenames: `flip_coin.py`, `flip_coin.pdf`.

<!-- Closing remarks for this Problem -->

#### Remarks

These are the exercise remarks, appearing at the very end.

<!-- solution files: mysol.txt, mysol_flip_coin.py, yet_another.file -->

<!-- --- end exercise --- -->

### Not an exercise

Should be possible to stick a normal section in the middle of many
exercises.

<!-- --- begin exercise --- -->

### Exercise 3: Test of plain text exercise
<div id="my:exer1"></div>

Very short exercise. What is the capital
of Norway?
Filename: `myexer1`.

<!-- --- end exercise --- -->

<!-- --- begin exercise --- -->

### Project 4: Compute a Probability
<div id="demo:ex:2"></div>

<!-- Minimalistic exercise -->

What is the probability of getting a number between 0.5 and 0.6 when
drawing uniformly distributed random numbers from the interval $[0,1)$?

At the end we have a list because that caused problems in LaTeX
in previous DocOnce versions:

1. item1
2. item2

<!-- --- begin hint in exercise --- -->

*Hint.*
To answer this question empirically, let a program
draw $N$ such random numbers using Python's standard `random` module,
count how many of them, $M$, that fall in the interval $(0.5,0.6)$, and
compute the probability as $M/N$.

<!-- --- end hint in exercise --- -->

<!-- --- end exercise --- -->

<!-- --- begin exercise --- -->

### Project 5: Explore Distributions of Random Circles
<div id="proj:circle1"></div>
<!-- keywords = ipynb -->

The formula for a circle is given by

$$
\begin{align}
x &= x_0 + R\cos 2\pi t,
\label{circle:x}\\ 
y &= y_0 + R\sin 2\pi t,
\label{circle:y}
\end{align}
$$
where $R$ is the radius of the circle, $(x_0,y_0)$ is the
center point, and $t$ is a parameter in the unit interval $[0,1]$.
For any $t$, $(x,y)$ computed from ([circle:x](#circle:x))-([circle:y](#circle:y))
is a point on the circle.
The formula can be used to generate `n` points on a circle:


~~~{.Python}
import numpy as np

def circle(R, x0, y0, n=501):
    t = np.linspace(0, 1, n)
    x = x0 + R*np.cos(2*np.pi*t)
    y = y0 + R*np.sin(2*np.pi*t)
    return x, y

x, y = circle(2.0, 0, 0)
~~~

<!-- Often in an exercise we have some comments about the solution -->
<!-- which we normally want to keep where they are. -->

The goal of this project is to draw $N$ circles with random
center and radius. Plot each circle using the `circle` function
above.

*a)*
Let $R$ be normally distributed and $(x_0,y_0)$ uniformly distributed.

<!-- --- begin hint in exercise --- -->

*Hint.*
Use the `numpy.random` module to draw the
$x_0$, $y_0$, and $R$ quantities.

<!-- --- end hint in exercise --- -->

<!-- --- begin answer of exercise --- -->
*Answer.*
Here goes the short answer to part a).
<!-- --- end answer of exercise --- -->

<!-- --- begin solution of exercise --- -->
*Solution.*
Here goes a full solution to part a).
<!-- --- end solution of exercise --- -->

*b)*
Let $R$ be uniformly distributed and $(x_0,y_0)$ normally distributed.
Filename: `norm`.

*c)*
Let $R$ and $(x_0,y_0)$ be normally distributed.

Filename: `circles`.

<!-- Closing remarks for this Project -->

#### Remarks

At the very end of the exercise it may be appropriate to summarize
and give some perspectives.

<!-- --- end exercise --- -->

<!-- --- begin exercise --- -->

### Exercise 6: Determine some Distance
<div id="exer:dist"></div>

Intro to this exercise. Questions are in subexercises below.

<!-- --- begin solution of exercise --- -->
*Solution.*
Here goes a full solution of the whole exercise.
With some math $a=b$ in this solution:
$$
 \hbox{math in solution: } a = b 
$$
And code `a=b` in this solution:

~~~
a = b  # code in solution
~~~

End of solution is here.

<!-- --- end solution of exercise --- -->

*a)*
Subexercises are numbered a), b), etc.

<!-- --- begin hint in exercise --- -->

*Hint 1.*
First hint to subexercise a).
With math $a=b$ in hint:

$$
 a=b. 
$$
And with code (in plain verbatim) returning $x+1$ in hint:


~~~
def func(x):
    return x + 1  # with code in hint
~~~

<!-- --- end hint in exercise --- -->

<!-- --- begin hint in exercise --- -->

*Hint 2.*
Second hint to subexercise a).

Test list in hint:

1. item1
2. item2

<!-- --- end hint in exercise --- -->
Filename: `subexer_a.pdf`.

<!-- --- begin answer of exercise --- -->
*Answer.*
Short answer to subexercise a).
With math in answer: $a=b$.
<!-- --- end answer of exercise --- -->

*b)*
Here goes the text for subexercise b).

Some math $\cos^2 x + \sin^2 x = 1$ written one a single line:

$$
 \cos^2 x + \sin^2 x = 1 \thinspace .
$$

<!-- --- begin hint in exercise --- -->

*Hint.*
A hint for this subexercise.

<!-- --- end hint in exercise --- -->
Filename: `subexer_b.pdf`.

<!-- --- begin solution of exercise --- -->
*Solution.*
Here goes the solution of this subexercise.
<!-- --- end solution of exercise --- -->

<!-- No meaning in this weired test example: -->
The text here belongs to the main (intro) part of the exercise. Need
closing remarks to have text after subexercises.

Test list in exercise:

1. item1
2. item2
<!-- Closing remarks for this Exercise -->

#### Remarks

Some final closing remarks, e.g., summarizing the main findings
and their implications in other problems can be made. These
remarks will appear at the end of the typeset exercise.

<!-- --- end exercise --- -->

<!-- --- begin exercise --- -->

### Some exercise without the "Exercise:" prefix

<!-- Another minimalistic exercise -->

Just some text. And some math saying that $e^0=1$ on a single line,
to test that math block insertion is correct:

$$
 \exp{(0)} = 1 
$$

And a test that the code `lambda x: x+2` is correctly placed here:


~~~
lambda x: x+2
~~~

<!-- Have some comments at the end of the exercise to see that -->
<!-- the Filename: ... is written correctly. -->
<!-- --- end exercise --- -->

<!-- --- begin exercise --- -->

### Exercise 8: Solution of differential equation
<div id="sec:this:exer:de"></div>



Given

$$
 \frac{dy}{dx} = -y(x),\quad y(0)=1 
$$
What is the solution of this equation?

**Choice A:**
 $y=e^{-y}$

**Choice B:**
 $y=e^{y}$

**Choice C:**
 ~~~{.Python}
from math import exp
def f(x):
    return exp(x)
~~~

**Choice D:**
 The solution cannot be found because there is a derivative in the equation.

**Choice E:**
 The equation is meaningless: an equation must be an equation
for $x$ or $y$, not a function $y(x)$.



<!-- --- end exercise --- -->

<!-- --- begin exercise --- -->

### Example 9: Just an example

<!-- This example needs the --examples_as_exercises option, otherwise -->
<!-- it is just typeset as it is written. -->

*a)*
What is the capital of Norway?

*Answer.*
Oslo.

<!-- --- end exercise --- -->

## Here goes another section

With some text, before we continue with exercises.

## More Exercises

<!-- --- begin exercise --- -->

### Exercise 10: Make references to projects and problems
<div id="exer:some:formula"></div>

<!-- Test comments not at the end only -->
Pick a statement from [Project 5: Explore Distributions of Random Circles](#proj:circle1) or [Problem 2: Flip a Coin](#demo:ex:1)
and verify it.

Test list at the end of an exercise without other elements (like subexercise,
hint, etc.):

1. item1
2. item2

Filename: `verify_formula.py`.

<!-- --- end exercise --- -->

<!-- --- begin exercise --- -->

### Project 11: References to [Project 4: Compute a Probability](#demo:ex:2) in a heading works for pandoc
<div id="exer:you"></div>

Refer to the previous exercise as [Exercise 10: Make references to projects and problems](#exer:some:formula),
the two before that as [Project 4: Compute a Probability](#demo:ex:2) and [Project 5: Explore Distributions of Random Circles](#proj:circle1),
and this one as [Project 11: References to Project [demo:ex:2](#demo:ex:2) in a heading works for pandoc](#exer:you).
Filename: `selc_composed.pdf`.

<!-- --- end exercise --- -->

## References

 1. <div id="Langtangen_Pedersen_2002"></div> **H. P. Langtangen and G. Pedersen**. 
    Propagation of Large Destructive Waves,
    *International Journal of Applied Mechanics and Engineering*,
    7(1),
    pp. 187-204,
    2002.
 2. <div id="Langtangen_et_al_2002"></div> **H. P. Langtangen, K.-A. Mardal and R. Winther**. 
    Numerical Methods for Incompressible Viscous Flow,
    *Advances in Water Resources*,
    25,
    pp. 1125-1146,
    2002.
 3. <div id="Langtangen_1994a"></div> **H. P. Langtangen**. 
    Numerical Solution of First Passage Problems in Random Vibrations,
    *SIAM Journal of Scientific and Statistical Computing*,
    15,
    pp. 997-996,
    1994.
 4. <div id="Mardal_et_al_2003a"></div> **K.-A. Mardal, G. W. Zumbusch and H. P. Langtangen**. 
    Software Tools for Multigrid Methods,
    *Advanced Topics in Computational Partial Differential Equations -- Numerical Methods and Diffpack Programming*,
    edited by **H. P. Langtangen and A. Tveito**,
    Springer,
    2003,
    Edited book,
    <http://some.where.org>.
 5. <div id="Langtangen_1988d"></div> **H. P. Langtangen**. 
    The FEMDEQS Program System,
    *Department of Mathematics, University of Oslo*,
    1989,
    <http://www.math.uio.no/old/days/hpl/femdeqs.pdf>.
 6. <div id="Langtangen_1992c"></div> **H. P. Langtangen**. 
    Stochastic Breakthrough Time Analysis of an Enhanced Oil Recovery Process,
    *SIAM Journal on Scientific Computing*,
    13,
    pp. 1394-1417,
    1992.
 7. <div id="Mortensen_et_al_2011"></div> **M. Mortensen, H. P. Langtangen and G. N. Wells**. 
    A FEniCS-Based Programming Framework for Modeling Turbulent Flow by the Reynolds-Averaged Navier-Stokes Equations,
    *Advances in Water Resources*,
    34(9),
    [doi: 10.1016/j.advwatres.2011.02.013](https://dx.doi.org/10.1016/j.advwatres.2011.02.013),
    2011.
 8. <div id="Glimsdal_et_al_20006"></div> **S. Glimsdal, G. Pedersen, K. Atakan, C. B. Harbitz, H. P. Langtangen and F. L\ovholt**. 
    Propagation of the Dec.\ 26, 2004 Indian Ocean Tsunami: Effects of Dispersion and Source Characteristics,
    *International Journal of Fluid Mechanics Research*,
    33(1),
    pp. 15-43,
    2006.
 9. <div id="Rahman_et_al_2006b"></div> **S. Rahman, J. Gorman, C. H. W. Barnes, D. A. Williams and H. P. Langtangen**. 
    Numerical Investigation of a Piezoelectric Surface Acoustic Wave Interaction With a One-Dimensional Channel,
    *Physical Review B: Condensed Matter and Materials Physics*,
    74,
    2006,
    035308.
10. <div id="Haga_et_al_2011a"></div> **J. B. Haga, H. Osnes and H. P. Langtangen**. 
    On the Causes of Pressure Oscillations in Low-Permeable and Low-Compressible Porous Media,
    *International Journal of Analytical and Numerical Methods in Geomechanics*,
    [doi: 10.1002/nag.1062](https://dx.doi.org/10.1002/nag.1062),
    2011,
    <http://onlinelibrary.wiley.com/doi/10.1002/nag.1062/abstract>.
11. <div id="Langtangen_2003a"></div> **H. P. Langtangen**. 
    *Computational Partial Differential Equations - Numerical Methods and Diffpack Programming*,
    second edition,
    *Texts in Computational Science and Engineering*,
    Springer,
    2003.
12. <div id="Langtangen_2008a"></div> **H. P. Langtangen**. 
    *Python Scripting for Computational Science*,
    third edition,
    *Texts in Computational Science and Engineering*,
    Springer,
    2008.
13. <div id="Langtangen:95"></div> **H. P. Langtangen and G. Pedersen**. 
    Finite Elements for the Boussinesq Wave Equations,
    Waves and Non-linear Processes in Hydrodynamics,
    edited by **J. Grue, B. Gjevik and J. E. Weber**,
    Kluwer Academic Publishers,
    pp. pp. 117-126,
    1995,
    <http://www.amazon.ca/Waves-Nonlinear-Processes-Hydrodynamics-John/dp/0792340310>.
14. <div id="Langtangen_2012"></div> **H. P. Langtangen**. 
    *A Primer on Scientific Programming With Python*,
    third edition,
    *Texts in Computational Science and Engineering*,
    Springer,
    2012.
15. <div id="Jeberg_et_al_2004"></div> **P. V. Jeberg, H. P. Langtangen and C. B. Terp**. 
    Optimization With Diffpack: Practical Example From Welding,
    *Simula Research Laboratory*,
    2004,
    Internal report.
16. <div id="Langtangen_1989e"></div> **H. P. Langtangen**. 
    Computational Methods for Two-Phase Flow in Oil Reservoirs,
    Ph.D. Thesis,
    Mechanics Division, Department of Mathematics, University of Oslo,
    1989,
    Dr.\ Scient.\ thesis..
17. <div id="Langtangen_talk_2007a"></div> **H. P. Langtangen**. 
    Computational Modeling of Huge Tsunamis From Asteroid Impacts,
    2007,
    Invited keynote lecture at the \emphInternational conference on Computational Science 2007 (ICCS'07), Beijing, China.
18. <div id="Langtangen:85"></div> **H. P. Langtangen**. 
    Solution of the Navier-Stokes Equations With the Finite Element Method in Two and Three Dimensions,
    M.Sc. Thesis,
    Mechanics Division, Department of Mathematics, University of Oslo,
    1985,
    Cand.Scient. thesis.
19. <div id="Langtangen:91"></div> **H. P. Langtangen and A. Tveito**. 
    Numerical Methods in Continuum Mechanics,
    *Center for Industrial Research*,
    1991,
    Lecture notes for a course (ME-IN 324). 286 pages..
20. <div id="Langtangen:94b"></div> **H. P. Langtangen**. 
    Diffpack: Software for Partial Differential Equations,
    *Proceedings of the Second Annual Object-Oriented Numerics Conference (OON-SKI'94), Sunriver, Oregon, USA*,
    edited by **A. Vermeulen**,
    1994.

## Appendix: Just for testing; part I
<div id="app1"></div>

This is the first appendix.

### A subsection within an appendix

Some text.

## Appendix: Just for testing; part II
<div id="app2"></div>

This is more stuff for an appendix.

### Appendix: Testing identical titles

Without label.

### Appendix: Testing identical titles
<div id="test:title:id1"></div>

With label.

### Appendix: Testing identical titles
<div id="test:title:id2"></div>

What about inserting a quiz?



## Test of quizzes


**Fundamental test:** What is the capital of Norway?

**Answer 1:**
 Stockholm

**Answer 2:**
 London

**Answer 3:**
 Oslo

**Choice D:**
 Bergen



### Appendix: Testing identical titles

Without label.

*Tip.* 
Here is a tip or hint box, typeset as a notice box.



Need a lot of text to surround the summary box.
Version control systems allow you to record the history of files
and share files among several computers and collaborators in a
professional way. File changes on one computer are updated or
merged with changes on another computer. Especially when working
with programs or technical reports it is essential
to have changes documented and to
ensure that every computer and person involved in the project
have the latest updates of the files.
Greg Wilson' excellent [Script for Introduction to Version Control](https://software-carpentry.org/2010/07/script-for-introduction-to-version-control/) provides a more detailed motivation why you will benefit greatly
from using version control systems.

*Summary.* 
**Bold remark:** Make some text with this summary.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.
Much testing in this document, otherwise stupid content.



Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that site. I strongly
recommend you to use such sites for all serious programming and
scientific writing work - and all other important files.

The simplest services for hosting project files are [Dropbox](https://dropbox.com) and [Google Drive](https://drive.google.com).
It is very easy to get started with these systems, and they allow you
to share files among laptops and mobile units with as many users as
you want. The systems offer a kind of version control in that the
files are stored frequently (several times per minute), and you can go
back to previous versions for the last 30 days. However, it is
challenging  to find the right version from the past when there are
so many of them.

More seriously, when several people may edit files simultaneously, it
can be difficult detect who did what when, roll back to previous
versions, and to manually merge the edits when these are
incompatible. Then one needs more sophisticated tools than Dropbox or
Google Drive: project hosting services with true version control
systems.  The following text aims at providing you with the minimum
information to started with such systems. Numerous other tutorials
contain more comprehensive material and in-depth explanations of the
concepts and tools.

The idea with project hosting services is that you have the files
associated with a project in the cloud. Many people may share these
files.  Every time you want to work on the project you explicitly
update your version of the files, edit the files as you like, and
synchronize the files with the "master version" at the site where the
project is hosted.  If you at some point need to go back to a
version of the files at some particular point in the past,
this is an easy operation. You can also use tools to see
what various people have done with the files in the various versions.

All these services are very similar. Below we describe how you get
started with Bitbucket, GitHub, and Googlecode. Launchpad works very
similarly to the latter three. All the project hosting services have
excellent introductions available at their web sites, but the recipes
below are much shorter and aim at getting you started as quickly as
possible by concentrating on the most important need-to-know steps.
The Git tutorials we refer to later in this document contain more
detailed information and constitute of course very valuable readings
when you use version control systems every day. The point now is
to get started.

### Appendix: Testing inline comments

<!-- Names can be [ A-Za-z0-9_'+-]+ -->

Projects that you want to share among several computers or project
workers are today most conveniently stored at some web site "in the
cloud" and updated through communication with that
site. [hpl's semi opinion 1: not sure if in the cloud is
understood by
all.] I strongly recommend you to use such sites for all serious
programming and scientific writing work - and all other important
files.

The simplest services for hosting project files is Dropbox. [mp 2: Simply go to <https://dropbox.com> and watch the video. It explains
how files, like `myfile.py`, perhaps containing much math, like
$\partial u/\partial t$, are easily communicated between machines.] It
is very easy to get started with Dropbox, and it allows you to share
files among [hpl 3: laptops and mobile units -> computers, tablets,
and phones].

<!-- Test horizontal rule -->

------

<!-- Coments for editing -->

First[add 4: ,] consider a quantity $Q$. [edit 5: To this end, -> We note that]
$Q>0$, because [del 6: a] negative [edit 7: quantity is -> quantities
are] [del 8: just] negative. [add 9: This comes as no surprise.]

<!-- Test tailored latex figure references with page number -->
Let us refer to [Figure](#fig:impact) again.

Test references in a list:

 * [Section 1](#sec1)
 * [Subsection 1](#subsec1)
 * [fig:impact](#fig:impact)

### Appendix: Testing headings ending with `verbatim inline`

The point here is to test 1) `verbatim` code in headings, and 2)
ending a heading with verbatim code as this triggers a special
case in LaTeX.

We also test mdash&mdash;used as alternative to hyphen without spaces around,
or in quotes:

> *Fun is fun*.&mdash;Unknown.



The ndash should also be tested &ndash; as in the Hanson&ndash;Nilson equations
on page 277&ndash;278.

And finally, what about admons, quotes, and boxes? They are tested
in a separate document: `admon.do.txt`.

[^example-of-the-third-footnote]: Not much to add here, but the footnote
is at the end with only one newline.

************** File: testdoc.ipynb *****************
{
 "cells": [
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "<!-- dom:TITLE: A Document for Testing DocOnce -->\n",
    "# A Document for Testing DocOnce\n",
    "**Hans Petter Langtangen** (email: `hpl@simula.no`), Center for Biomedical Computing, Simula Research Laboratory and Department of Informatics, University of Oslo  \n",
    "**Kaare Dump**, Segfault, Cyberspace  \n",
    "**A. Dummy Author**  \n",
    "**I. S. Overworked and Outburned**, Inst1 and Inst2, Somewhere and Third Inst, Elsewhere and Fourth Inst  \n",
    "**J. Doe** (email: `j_doe@cyberspace.com`)\n",
    "\n",
    "Date: **Jan 32, 2100**\n",
    "\n",
    "Made with DocOnce"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "The format of this document is\n",
    "ipynb\n",
    "\n",
    "**Abstract.** This is a document with many test constructions for doconce syntax.\n",
    "It was used heavily for the development and kept for testing\n",
    "numerous constructions, also special and less common cases.\n",
    "\n",
    "And exactly for test purposes we have an extra line here, which\n",
    "is part of the abstract.\n",
    "\n",
    "<!-- Cannot demonstrate chapter headings since abstract and chapter -->\n",
    "<!-- are mutually exclusive in LaTeX -->\n",
    "\n",
    "\n",
    "\n",
    "# Section 1\n",
    "<div id=\"sec1\"></div>\n",
    "\n",
    "Here is a nested list:\n",
    "\n",
    "  * item1\n",
    "\n",
    "  * item2\n",
    "\n",
    "  * item3 which continues\n",
    "    on the next line to test that feature\n",
    "\n",
    "  * and a sublist\n",
    "\n",
    "    * with indented subitem1\n",
    "\n",
    "    * and a subitem2\n",
    "\n",
    "\n",
    "  * and perhaps an ordered sublist\n",
    "\n",
    "a. first item\n",
    "\n",
    "b. second item,\n",
    "      continuing on a new line\n",
    "\n",
    "\n",
    "**Here is a list with paragraph heading.**\n",
    "\n",
    "  * item1\n",
    "\n",
    "  * item2\n",
    "\n",
    "### Here is a list with subsubsection heading\n",
    "\n",
    "  * item1\n",
    "\n",
    "  * item2\n",
    "\n",
    "> Here are two lines that make up\n",
    "> a block quote for testing *emphasized words* and **boldface words**,\n",
    "> also with hypens:\n",
    "> *pre*-fix, post-*fix*, **pre**-fix, post-**fix**.\n",
    "\n",
    "\n",
    "\n",
    "\n",
    "\n",
    "Here are two references. Equation ([6](#my:eq1)) is fine. Eq. ([6](#my:eq1)) too.\n",
    "Even Equation ([6](#my:eq1)) without the tilde.\n",
    "\n",
    "## Subsection 1\n",
    "<div id=\"subsec1\"></div>\n",
    "\n",
    "<!-- Refer to section/appendix etc. at the beginning of the line -->\n",
    "<!-- and other special fix situations for HTML. -->\n",
    "\n",
    "More text, with a reference back to\n",
    "the section [Section 1](#sec1) and [Subsection 1](#subsec1), and further to the\n",
    "the sections [Subsection 1](#subsec1) and [URLs](#subsubsec:ex), which\n",
    "encourages you to do the tasks in [Problem 2: Flip a Coin](#demo:ex:1) and [Exercise 10: Make references to projects and problems](#exer:some:formula).\n",
    " [Appendix: Just for testing; part I](#app1) and [Appendix: Just for testing; part II](#app2) are also nice elements.\n",
    "\n",
    "### Test Section reference at beginning of line and after a sentence\n",
    "\n",
    "The section [Subsection 1](#subsec1) is fine.\n",
    "The section [URLs](#subsubsec:ex) too.\n",
    "\n",
    "<!-- sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console -->\n",
    "\n",
    "### Computer code\n",
    "\n",
    "Let's do some copying from files too. First from subroutine up to the very end,"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "              subroutine test()\n",
    "              integer i\n",
    "              real*8 r\n",
    "              r = 0\n",
    "              do i = 1, i\n",
    "                 r = r + i\n",
    "              end do\n",
    "              return\n",
    "        C     END1\n",
    "        \n",
    "              program testme\n",
    "              call test()\n",
    "              return\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "and then just the subroutine,"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "        \n",
    "              subroutine test()\n",
    "              integer i\n",
    "              real*8 r\n",
    "              r = 0\n",
    "              do i = 1, i\n",
    "                 r = r + i\n",
    "              end do\n",
    "              return\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "and finally the complete file with a plain text verbatim environment\n",
    "(`envir=ccq`):"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "        C     a comment\n",
    "        \n",
    "              subroutine test()\n",
    "              integer i\n",
    "              real*8 r\n",
    "              r = 0\n",
    "              do i = 1, i\n",
    "                 r = r + i\n",
    "              end do\n",
    "              return\n",
    "        C     END1\n",
    "        \n",
    "              program testme\n",
    "              call test()\n",
    "              return\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "Testing other code environments. First Python:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "        !bc pycod\n",
    "        def f(x):\n",
    "            return x+1\n",
    "        !ec\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "which gets rendered as"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "```Python\n",
    "        def f(x):\n",
    "            return x+1\n",
    "```"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "Test paragraph and subsubsection headings before\n",
    "before code.\n",
    "\n",
    "**Paragraph heading before code.**"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "```Python\n",
    "        import sys\n",
    "        sys.path.insert(0, os.pardir)\n",
    "```"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "### Subsubsection heading before code"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "```Python\n",
    "        def h(z):\n",
    "            return z+1\n",
    "```"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "Here is a program that is supposed to be interactive via\n",
    "Python Online Tutorial, but that service is not accessible\n",
    "for the present format."
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 1,
   "metadata": {
    "collapsed": false,
    "editable": true
   },
   "outputs": [],
   "source": [
    "class Line:\n",
    "    def __init__(self, a, b):\n",
    "        self.a, self.b = a, b\n",
    "\n",
    "    def __call__(self, x):\n",
    "        a, b = self.a, self.b\n",
    "        return a*x + b\n",
    "\n",
    "line = Line(2, 1)\n",
    "y = line(x=3)\n",
    "print(y)"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "Some more Python code (actually specified as a sage cell, but\n",
    "such cells are not supported by this format)."
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 2,
   "metadata": {
    "collapsed": false,
    "editable": true
   },
   "outputs": [],
   "source": [
    "%matplotlib inline\n",
    "\n",
    "a = 2\n",
    "b = 3\n",
    "print('a+b:', a + b)\n",
    "\n",
    "# In a sage cell we can also plot\n",
    "from matplotlib.pyplot import *\n",
    "from numpy import *\n",
    "x = linspace(0, 4*pi, 101)\n",
    "y = exp(-0.1*x)*cos(x)\n",
    "plot(x, y)\n",
    "xlabel('x'); ylabel('y')\n",
    "show()"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "Then Cython (with -h option so it is hidden in html/sphinx):"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "        cpdef f(double x):\n",
    "            return x + 1\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "Standard Python shell sessions:"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 3,
   "metadata": {
    "collapsed": false,
    "editable": true
   },
   "outputs": [],
   "source": [
    "from numpy import linspace, sin\n",
    "# Some comment\n",
    "x = linspace(0, 2, 11)\n",
    "y = sin(x)\n",
    "y[0]"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "Similar IPython sessions:"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 4,
   "metadata": {
    "collapsed": false,
    "editable": true
   },
   "outputs": [],
   "source": [
    "from numpy import linspace, sin\n",
    "# Some comment\n",
    "x = linspace(0, 2, 11)\n",
    "y = sin(x)\n",
    "y[0]"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 5,
   "metadata": {
    "collapsed": false,
    "editable": true
   },
   "outputs": [],
   "source": [
    "import matplotlib.pyplot as plt\n",
    "plt.plot(x, y)\n",
    "a='multiple-\\nline\\noutput'\n",
    "a"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 6,
   "metadata": {
    "collapsed": false,
    "editable": true
   },
   "outputs": [],
   "source": [
    "print(a)"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "Here is the interactive session again, but with `pyshell-t`.\n",
    "This makes a significant difference in the Jupyter Notebook, but\n",
    "not in other formats: code is not typset in cells, but printed\n",
    "verbatim in plain text (`-t` for text)."
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "```Python\n",
    "        >>> from numpy import linspace, sin\n",
    "        >>> # Some comment\n",
    "        >>> x = linspace(0, 2, 11)\n",
    "        >>> y = sin(x)\n",
    "        >>> y[0]\n",
    "        0\n",
    "        >>> import matplotlib.pyplot as plt\n",
    "        >>> plt.plot(x, y)\n",
    "```"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "<!-- This one tests a + sign before a code environment -->\n",
    "C++:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "```Cpp\n",
    "        #include <iostream>\n",
    "        \n",
    "        int main()\n",
    "        {\n",
    "           std::cout << \"Sample output\" << std::endl;\n",
    "           return 0\n",
    "        }\n",
    "```"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "<!-- The next should get correctly typset in sphinx (cod is fcod) -->\n",
    "<!-- It also tests emoji before code -->\n",
    "And a little bit of Fortran: :dizzy_face:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "        !bc cod\n",
    "              subroutine midpt(x, length, a, b)\n",
    "              real*8 a, b, x\n",
    "              x = (a + b)/2\n",
    "              length = b - a\n",
    "              return\n",
    "              end\n",
    "        !ec\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "which then is typeset as"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "```Python\n",
    "        subroutine midpt(x, length, a, b)\n",
    "              real*8 a, b, x\n",
    "              x = (a + b)/2\n",
    "              length = b - a\n",
    "              return\n",
    "              end\n",
    "```"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "HTML:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "        <table>\n",
    "        <tr><td>Column 1</td><td>Column 2</td></tr>\n",
    "        <tr><td>0.67526 </td><td>0.92871 </td></tr>\n",
    "        <!-- comment -->\n",
    "        </table>\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "But inline HTML code is also important, like text that starts with\n",
    "`<a href=\"` (which can destroy the following text if not properly\n",
    "quoted).\n",
    "\n",
    "Matlab with comments requires special typesetting:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "        % Comment on the beginning of the line can be escaped by %%\n",
    "        if a > b\n",
    "          % Indented comment needs this trick\n",
    "          c = a + b\n",
    "        end\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "And here is a system call:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "```\n",
    "        Terminal> mkdir test\n",
    "        Terminal> cd test\n",
    "        Terminal> myprog -f\n",
    "        output1\n",
    "        output2\n",
    "```"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "Any valid pygments lexer/language name can appear to, e.g.,"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "        !bc restructuredtext\n",
    "        =======\n",
    "        Heading\n",
    "        =======\n",
    "        \n",
    "        Some text.\n",
    "        !ec\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "results in"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "        =======\n",
    "        Heading\n",
    "        =======\n",
    "        \n",
    "        Some text.\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "<!-- Here goes hidden code. -->\n",
    "<!-- Python can be treated by some formats, Fortran is always out. -->"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 7,
   "metadata": {
    "collapsed": true,
    "editable": true
   },
   "outputs": [],
   "source": [
    "def f(x):\n",
    "    \"\"\"Secret, hidden function to be defined.\"\"\"\n",
    "    return 42"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "Finally, `!bc do` supports highlighting of DocOnce source:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "        ======= DocOnce test file =======\n",
    "        \n",
    "        ===== Computer code =====\n",
    "        \n",
    "        Inline verbatim code, as in `import numpy as np`, is allowed, as well as\n",
    "        code blocks:\n",
    "        \n",
    "        !bc pycod\n",
    "        from math import sin\n",
    "        \n",
    "        def f(x):\n",
    "            \"\"\"Example on a function.\"\"\"\n",
    "            return sin(x) + 1\n",
    "        \n",
    "        print(f(0))\n",
    "        !ec\n",
    "        \n",
    "        \n",
    "        ===== Mathematics =====\n",
    "        \n",
    "        Formulas can be inline, as in $\\nabla\\cdot\\boldsymbol{u} = 0$, or typeset\n",
    "        as equations:\n",
    "        \n",
    "        !bt\n",
    "        \\begin{align*}\n",
    "        \\nabla\\cdot\\boldsymbol{u} &= 0,\\\\\n",
    "        \\boldsymbol{u} &= \\nabla\\phi .\n",
    "        \\end{align*}\n",
    "        !et\n",
    "        \n",
    "        === Subsubsection heading ===\n",
    "        \n",
    "        DocOnce files can have chapters, sections, subsections, and subsubsections.\n",
    "        \n",
    "        __Paragraph heading.__ Paragraphs may have headings.\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "It is time to test `verbatim inline font` especially with `a newline\n",
    "inside the text` and an exclamation mark at the end: `BEGIN`! For\n",
    "spellcheck, test `a verbatim expression` in `another` in a `third`.\n",
    "Also test exclamation mark as in `!bc` and `!ec` as well as `a != b`.\n",
    "Also test backslashes and braces like `\\begin`, `\\begin{enumerate}`,\n",
    "`\\end{this}\\end{that}`, and `{something \\inside braces}`.\n",
    "\n",
    "The following attempt to exemplify colored text does not work in\n",
    "format ipynb.\n",
    "Here is some <font color=\"red\">red color</font> and an attempt to write <font color=\"green\">with\n",
    "green color containing a linebreak\n",
    "code.</font> Some formats will only display \n",
    "this correctly when `html` \n",
    "is the output format.\n",
    "But here some more running text is added which is not part of\n",
    "the previous blocks with line breaks.\n",
    "\n",
    "### Running OS commands"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "        Terminal> python -c 'print(\"Testing\\noutput\\nfrom\\nPython.\")'\n",
    "        Testing\n",
    "        output\n",
    "        from\n",
    "        Python.\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "### Footnotes\n",
    "\n",
    "Here is a test of footnotes [^footnote], which are handy in text.\n",
    "They are used in different flavors, now in\n",
    "\n",
    " * list items (note below that footnotes work after math, verbatim, and URLs - bin fact old and emphasize too!)\n",
    "\n",
    " * even with math $\\nabla^2u$[^math1]\n",
    "\n",
    " * and code `h[i] += 1`[^code]\n",
    "   (*must* have space between inline code and footnote!)\n",
    "\n",
    " * and [links](https://google.com)[^google-search]\n",
    "\n",
    "which gives flexibility in writing.\n",
    "This is the third[^example-of-the-third-footnote] example.\n",
    "\n",
    "  [^footnote]: Typesetting of the footnote depends on the format.\n",
    "Plain text does nothing, LaTeX removes the\n",
    "definition and inserts the footnote as part of the LaTeX text.\n",
    "reStructuredText and Sphinx employ a similar type of typesetting\n",
    "as Extended Markdown and DocOnce, and in HTML we keep the same\n",
    "syntax, just displayed properly in HTML.\n",
    "[^math1]: Math footnotes can be dangerous since it\n",
    "interferes with an exponent.\n",
    "[^code]: One-line footnote.\n",
    "\n",
    "[^google-search]: <google.com> is perhaps the most famous\n",
    "web site today.\n",
    "\n",
    "Here is some more text before a new definition of a footnote that was\n",
    "used above.\n",
    "\n",
    "**Non-breaking space character.**\n",
    "\n",
    "This paragraph aims to test [non-breaking space character](https://en.wikipedia.org/wiki/Non-breaking_space), and a typical\n",
    "example where this is needed is in physical units: 7.4 km is traveled\n",
    "in $7.4/5.5\\approx 1.345$ s.  Also check that a~[link](https://google.com) is\n",
    "not broken across lines (drag the browser window to test this).\n",
    "(On the other hand, the tilde is used in\n",
    "computer code, e.g., as in `[~x for x in y]` or in `y=~x`, and should\n",
    "of course remain a tilde in those contexts.)\n",
    "\n",
    "\n",
    "\n",
    "## Subsection 2: Testing figures\n",
    "<div id=\"subsec:ex\"></div>\n",
    "\n",
    "Test of figures. In particular we refer to [Figure 1](#fig:impact) in which\n",
    "there is a flow.\n",
    "\n",
    "<!-- dom:FIGURE:[../doc/src/manual/fig/wave1D.png, width=200] Visualization **of** a *wave*. <div id=\"fig:impact\"></div> -->\n",
    "<!-- begin figure -->\n",
    "<div id=\"fig:impact\"></div>\n",
    "\n",
    "<img src=\"../doc/src/manual/fig/wave1D.png\" width=200><p style=\"font-size: 0.9em\"><i>Figure 1: Visualization <b>of</b> a <em>wave</em>.</i></p>\n",
    "<!-- end figure -->\n",
    "\n",
    "Figures without captions are allowed and will be inlined.\n",
    "\n",
    "<!-- dom:FIGURE:[../doc/src/manual/fig/wave1D.png, width=200] -->\n",
    "<!-- begin figure -->\n",
    "\n",
    "<img src=\"../doc/src/manual/fig/wave1D.png\" width=200><p style=\"font-size: 0.9em\"><i>Figure 2: </i></p>\n",
    "<!-- end figure -->\n",
    "\n",
    "<!-- Test multi-line caption in figure with sidecap=True -->\n",
    "\n",
    "Here is [figure 2](#myfig) with a long (illegal) multi-line caption\n",
    "containing inline verbatim text:\n",
    "\n",
    "<!-- dom:FIGURE: [../doc/src/manual/fig/wave1D.png, width=500 sidecap=True] A long caption spanning several lines and containing verbatim words like `my_file_v1` and `my_file_v2` as well as math with subscript as in $t_{i+1}$. <div id=\"myfig\"></div>  -->\n",
    "<!-- begin figure -->\n",
    "<div id=\"myfig\"></div>\n",
    "\n",
    "<img src=\"../doc/src/manual/fig/wave1D.png\" width=500><p style=\"font-size: 0.9em\"><i>Figure 2: A long caption spanning several lines and containing verbatim words like <code>my_file_v1</code> and <code>my_file_v2</code> as well as math with subscript as in $t_{i+1}$.</i></p>\n",
    "<!-- end figure -->\n",
    "\n",
    "<!-- Must be a blank line after MOVIE or FIGURE to detect this problem -->\n",
    "\n",
    "Test URL as figure name:\n",
    "\n",
    "<!-- dom:FIGURE: [https://raw.github.com/doconce/doconce/master/doc/src/blog/f_plot.png, width=500 frac=0.8] -->\n",
    "<!-- begin figure -->\n",
    "\n",
    "<img src=\"https://raw.github.com/doconce/doconce/master/doc/src/blog/f_plot.png\" width=500><p style=\"font-size: 0.9em\"><i>Figure 3: </i></p>\n",
    "<!-- end figure -->\n",
    "\n",
    "<!-- Test wikimedia type of files that otherwise reside in subdirs -->\n",
    "\n",
    "**Remark.**\n",
    "Movies are tested in separate file `movies.do.txt`.\n",
    "\n",
    "<!-- Somewhat challenging heading with latex math, \\t, \\n, ? and parenthesis -->\n",
    "\n",
    "## The $\\theta$ parameter (not $\\nabla$?)\n",
    "<div id=\"decay:sec:theta\"></div>\n",
    "\n",
    "Functions do not always need to be advanced, here is one\n",
    "involving $\\theta$:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "        def f(theta):\n",
    "            return theta**2\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "**More on $\\theta$.** Here is more text following headline with math.\n",
    "\n",
    "Newcommands must also be tested in this test report:\n",
    "$\\frac{1}{2}$, ${1/2}$, $\\pmb{x}$, $\\frac{Du}{dt}$,\n",
    "both inline and in block:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "$$\n",
    "\\frac{Du}{dt} = 0\\nonumber\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "<!-- Equation labels as ordinary links -->\n",
    "<div id=\"_auto1\"></div>\n",
    "\n",
    "$$\n",
    "\\begin{equation}  \n",
    "\\frac{1}{2} = {1/2}\n",
    "\\label{_auto1} \\tag{1}\n",
    "\\end{equation}\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "<!-- Equation labels as ordinary links -->\n",
    "<div id=\"_auto2\"></div>\n",
    "\n",
    "$$\n",
    "\\begin{equation}  \n",
    "\\frac{1}{2}\\pmb{x} = \\pmb{n}\n",
    "\\label{_auto2} \\tag{2}\n",
    "\\end{equation}\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "Or with align with label and numbers:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "<!-- Equation labels as ordinary links -->\n",
    "<div id=\"aligneq1\"></div>\n",
    "\n",
    "$$\n",
    "\\begin{equation}\n",
    "\\frac{Du}{dt} = 0\n",
    "\\label{aligneq1} \\tag{3}\n",
    "\\end{equation}\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "<!-- Equation labels as ordinary links -->\n",
    "<div id=\"_auto3\"></div>\n",
    "\n",
    "$$\n",
    "\\begin{equation}  \n",
    "\\frac{1}{2} = {1/2}\n",
    "\\label{_auto3} \\tag{4}\n",
    "\\end{equation}\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "<!-- Equation labels as ordinary links -->\n",
    "<div id=\"aligneq2\"></div>\n",
    "\n",
    "$$\n",
    "\\begin{equation}  \n",
    "\\frac{1}{2}\\pmb{x} = \\pmb{n}\n",
    "\\label{aligneq2} \\tag{5}\n",
    "\\end{equation}\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "## Custom Environments\n",
    "\n",
    "Here is an attempt to create a theorem environment via Mako\n",
    "(for counting theorems) and comment lines to help replacing lines in\n",
    "the `.tex` by proper begin-end LaTeX environments for theorems.\n",
    "Should look nice in most formats!\n",
    "\n",
    "<!-- begin theorem -->\n",
    "<div id=\"theorem:fundamental1\"></div>\n",
    "\n",
    "**Theorem 5.**\n",
    "Let $a=1$ and $b=2$. Then $c=3$.\n",
    "<!-- end theorem -->\n",
    "\n",
    "<!-- begin proof -->\n",
    "**Proof.**\n",
    "Since $c=a+b$, the result follows from straightforward addition.\n",
    "$\\Diamond$\n",
    "<!-- end proof -->\n",
    "\n",
    "As we see, the proof of Theorem 5 is a modest\n",
    "achievement.\n",
    "\n",
    "## Tables\n",
    "<div id=\"subsec:table\"></div>\n",
    "\n",
    "<!-- index with comma could fool sphinx -->\n",
    "\n",
    "Let us take this table from the manual:\n",
    "\n",
    "<table border=\"1\">\n",
    "<thead>\n",
    "<tr><th align=\"center\">time</th> <th align=\"center\">velocity</th> <th align=\"center\">acceleration</th> </tr>\n",
    "</thead>\n",
    "<tbody>\n",
    "<tr><td align=\"left\">   0.0     </td> <td align=\"right\">   1.4186      </td> <td align=\"right\">   -5.01           </td> </tr>\n",
    "<tr><td align=\"left\">   2.0     </td> <td align=\"right\">   1.376512    </td> <td align=\"right\">   11.919          </td> </tr>\n",
    "<tr><td align=\"left\">   4.0     </td> <td align=\"right\">   1.1E+1      </td> <td align=\"right\">   14.717624       </td> </tr>\n",
    "</tbody>\n",
    "</table>\n",
    "The DocOnce source code reads"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "        \n",
    "          |--------------------------------|\n",
    "          |time  | velocity | acceleration |\n",
    "          |--l--------r-----------r--------|\n",
    "          | 0.0  | 1.4186   | -5.01        |\n",
    "          | 2.0  | 1.376512 | 11.919       |\n",
    "          | 4.0  | 1.1E+1   | 14.717624    |\n",
    "          |--------------------------------|\n",
    "        \n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "Here is yet another table to test that we can handle more than\n",
    "one table:\n",
    "\n",
    "<table border=\"1\">\n",
    "<thead>\n",
    "<tr><th align=\"left\">time</th> <th align=\"left\">velocity</th> <th align=\"left\">acceleration</th> </tr>\n",
    "</thead>\n",
    "<tbody>\n",
    "<tr><td align=\"left\">   0.0     </td> <td align=\"left\">   1.4186      </td> <td align=\"left\">   -5.01           </td> </tr>\n",
    "<tr><td align=\"left\">   1.0     </td> <td align=\"left\">   1.376512    </td> <td align=\"left\">   11.919          </td> </tr>\n",
    "<tr><td align=\"left\">   3.0     </td> <td align=\"left\">   1.1E+1      </td> <td align=\"left\">   14.717624       </td> </tr>\n",
    "</tbody>\n",
    "</table>\n",
    "And one with math headings (that are expanded and must be treated\n",
    "accordingly), verbatim heading and entry, and no space around the pipe\n",
    "symbol:\n",
    "\n",
    "<table border=\"1\">\n",
    "<thead>\n",
    "<tr><th align=\"center\">$i$</th> <th align=\"center\">$h_i$ </th> <th align=\"center\">$\\bar T_i$</th> <th align=\"center\"> <code>L_i</code> </th> </tr>\n",
    "</thead>\n",
    "<tbody>\n",
    "<tr><td align=\"left\">   0      </td> <td align=\"right\">   0         </td> <td align=\"right\">   288           </td> <td align=\"right\">   -0.0065    </td> </tr>\n",
    "<tr><td align=\"left\">   1      </td> <td align=\"right\">   11,000    </td> <td align=\"right\">   216           </td> <td align=\"right\">   0.0        </td> </tr>\n",
    "<tr><td align=\"left\">   2      </td> <td align=\"right\">   20,000    </td> <td align=\"right\">   216           </td> <td align=\"right\">   0.001      </td> </tr>\n",
    "<tr><td align=\"left\">   3      </td> <td align=\"right\">   32,000    </td> <td align=\"right\">   228           </td> <td align=\"right\">   0.0028     </td> </tr>\n",
    "<tr><td align=\"left\">   4      </td> <td align=\"right\">   47,000    </td> <td align=\"right\">   270           </td> <td align=\"right\">   0.0        </td> </tr>\n",
    "<tr><td align=\"left\">   5      </td> <td align=\"right\">   51,000    </td> <td align=\"right\">   270           </td> <td align=\"right\">   -0.0028    </td> </tr>\n",
    "<tr><td align=\"left\">   6      </td> <td align=\"right\">   71,000    </td> <td align=\"right\">   214           </td> <td align=\"right\">   <code>NaN</code>      </td> </tr>\n",
    "</tbody>\n",
    "</table>\n",
    "And add one with verbatim headings (with underscores),\n",
    "and rows starting with `|-` because of a negative number,\n",
    "and `|` right before and after verbatim word (with no space):\n",
    "\n",
    "<table border=\"1\">\n",
    "<thead>\n",
    "<tr><th align=\"center\">exact</th> <th align=\"center\"><code>v_1</code> </th> <th align=\"center\">$a_i$ + <code>v_2</code></th> <th align=\"center\"><code>verb_3_</code></th> </tr>\n",
    "</thead>\n",
    "<tbody>\n",
    "<tr><td align=\"right\">   9        </td> <td align=\"right\">   9.62      </td> <td align=\"right\">   5.57             </td> <td align=\"right\">   8.98         </td> </tr>\n",
    "<tr><td align=\"right\">   -20      </td> <td align=\"right\">   -23.39    </td> <td align=\"right\">   -7.65            </td> <td align=\"right\">   -19.93       </td> </tr>\n",
    "<tr><td align=\"right\">   10       </td> <td align=\"right\">   17.74     </td> <td align=\"right\">   -4.50            </td> <td align=\"right\">   9.96         </td> </tr>\n",
    "<tr><td align=\"right\">   0        </td> <td align=\"right\">   -9.19     </td> <td align=\"right\">   4.13             </td> <td align=\"right\">   -0.26        </td> </tr>\n",
    "</tbody>\n",
    "</table>\n",
    "Pipe symbols in verbatim and math text in tables used to pose difficulties,\n",
    "but not\n",
    "anymore:\n",
    "\n",
    "<table border=\"1\">\n",
    "<thead>\n",
    "<tr><th align=\"center\">    $S$    </th> <th align=\"center\">   command   </th> </tr>\n",
    "</thead>\n",
    "<tbody>\n",
    "<tr><td align=\"left\">   $ ||a_0|| $    </td> <td align=\"right\">   <code>norm|length</code>    </td> </tr>\n",
    "<tr><td align=\"left\">   $x\\cap y$      </td> <td align=\"right\">   <code>x|y</code>            </td> </tr>\n",
    "</tbody>\n",
    "</table>\n",
    "Here is a table with X alignment:\n",
    "\n",
    "<table border=\"1\">\n",
    "<thead>\n",
    "<tr><th align=\"center\"> Type</th> <th align=\"center\">                                                                                                     Description                                                                                                      </th> </tr>\n",
    "</thead>\n",
    "<tbody>\n",
    "<tr><td align=\"center\">   X        </td> <td align=\"left\">   Alignment character that is used for specifying a potentially very long text in a column in a table. It makes use of the <code>tabularx</code> package in LaTeX, otherwise (for other formats) it means <code>l</code> (centered alignment).    </td> </tr>\n",
    "<tr><td align=\"center\">   l,r,c    </td> <td align=\"left\">   standard alignment characters                                                                                                                                                                                             </td> </tr>\n",
    "</tbody>\n",
    "</table>\n",
    "Finally, a table with math\n",
    "and URLs.\n",
    "\n",
    "<!-- Mako code to expand URLs in the table -->\n",
    "<!-- (These types of tables did not work before Jan 2014) -->\n",
    "\n",
    "<table border=\"1\">\n",
    "<tr></tr>\n",
    "<tbody>\n",
    "<tr><td align=\"center\">   $\\mathcal{L}=0$                    </td> <td align=\"center\">   [<code>080</code>](../doc/src/manual/mov/wave_frames/frame_0080.png)    </td> <td align=\"center\">   [<code>085</code>](../doc/src/manual/mov/wave_frames/frame_0085.png)    </td> </tr>\n",
    "<tr><td align=\"center\">   $a=b$                              </td> <td align=\"center\">   [<code>090</code>](../doc/src/manual/mov/wave_frames/frame_0090.png)    </td> <td align=\"center\">   [<code>095</code>](../doc/src/manual/mov/wave_frames/frame_0095.png)    </td> </tr>\n",
    "<tr><td align=\"center\">   $\\nabla\\cdot\\boldsymbol{u} =0 $    </td> <td align=\"center\">   [<code>100</code>](../doc/src/manual/mov/wave_frames/frame_0100.png)    </td> <td align=\"center\">   [<code>105</code>](../doc/src/manual/mov/wave_frames/frame_0105.png)    </td> </tr>\n",
    "</tbody>\n",
    "</table>\n",
    "## A test of verbatim words in heading with subscript $a_i$: `my_file_v1` and `my_file_v2`\n",
    "\n",
    "**Paragraph with verbatim and math: `my_file_v1.py` and `my_file_v2.py` define some math $a_{i-1}$.** Here is more `__verbatim__` code and\n",
    "some plain text on a new line.\n",
    "\n",
    "<!-- Test various types of headlines -->\n",
    "## **Just bold**\n",
    "\n",
    "Some text.\n",
    "\n",
    "## *Just emphasize*\n",
    "\n",
    "Some text.\n",
    "\n",
    "## `Just verbatim`\n",
    "\n",
    "Some text.\n",
    "\n",
    "## **Bold** beginning\n",
    "\n",
    "Some text.\n",
    "\n",
    "## *Emphasize* beginning\n",
    "\n",
    "Some text.\n",
    "\n",
    "## `Verbatim` beginning\n",
    "\n",
    "Some text.\n",
    "\n",
    "## Maybe **bold end**\n",
    "\n",
    "Some text.\n",
    "\n",
    "## Maybe *emphasize end*\n",
    "\n",
    "Some text.\n",
    "\n",
    "## Maybe `verbatim end`\n",
    "\n",
    "Some text.\n",
    "\n",
    "## The middle has **bold** word\n",
    "\n",
    "Some text.\n",
    "\n",
    "## The middle has *emphasize* word\n",
    "\n",
    "Some text.\n",
    "\n",
    "## The middle has `verbatim` word\n",
    "\n",
    "Some text.\n",
    "\n",
    "***Just emphasize*.** Some text.\n",
    "\n",
    "**`Just verbatim`.** Some text.\n",
    "\n",
    "***Emphasize* beginning.** Some text.\n",
    "\n",
    "**`Verbatim beginning`.** Some text.\n",
    "\n",
    "**Maybe *emphasize end*.** Some text.\n",
    "\n",
    "**Maybe `verbatim end`.** Some text.\n",
    "\n",
    "**The middle has *emphasize* word.** Some text.\n",
    "\n",
    "**The middle has `verbatim` word.** Some text.\n",
    "\n",
    "**Ampersand.**\n",
    "We can test Hennes & Mauritz, often abbreviated H&M, but written\n",
    "as `Hennes & Mauritz` and `H & M`.\n",
    "A sole `&` must also work.\n",
    "<!-- Note: substitutions must not occur inside verbatim, just in ordinary text. -->"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "        # Just to check that ampersand works in code blocks:\n",
    "        c = a & b\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "**Quotes.**\n",
    "Let us also add a test of quotes such as \"double quotes, with numbers\n",
    "like 3.14 and newline/comma and hyphen (as in double-quote)\"; written\n",
    "in the standard LaTeX-style that gives correct LaTeX formatting and\n",
    "ordinary double quotes for all non-LaTeX formats.  Here is another\n",
    "sentence that \"caused\" a bug in the past because double backtick\n",
    "quotes could imply verbatim text up to a verbatim word starting with\n",
    "period, like `.txt`.\n",
    "\n",
    "More quotes to be tested for spellcheck:\n",
    "(\"with parenthesis\"), \"with newline\"\n",
    "and \"with comma\", \"hyphen\"-wise, and \"period\".\n",
    "\n",
    "## Bibliography test\n",
    "\n",
    "Here is an example: [[Langtangen_Pedersen_2002]](#Langtangen_Pedersen_2002) discussed propagation of\n",
    "large destructive water waves, [[Langtangen_et_al_2002]](#Langtangen_et_al_2002) gave\n",
    "an overview of numerical methods for solving the Navier - Stokes equations,\n",
    "while the use of Backward Kolmogorov equations for analyzing\n",
    "random vibrations was investigated in [[Langtangen_1994a]](#Langtangen_1994a).\n",
    "The book chapter [[Mardal_et_al_2003a]](#Mardal_et_al_2003a) contains information on\n",
    "C++ software tools for programming multigrid methods. A real retro\n",
    "reference is [[Langtangen_1988d]](#Langtangen_1988d) about a big FORTRAN package.\n",
    "Multiple references are also possible, e.g., see\n",
    "[[Langtangen_Pedersen_2002;@Mardal_et_al_2003a]](#Langtangen_Pedersen_2002;@Mardal_et_al_2003a).\n",
    "\n",
    "We need to cite more than 10 papers to reproduce an old formatting\n",
    "problem with blanks in the keys in reST format:\n",
    "[[Langtangen_1992c;@Langtangen_1994a;@Mortensen_et_al_2011;@Langtangen_Pedersen_2002]](#Langtangen_1992c;@Langtangen_1994a;@Mortensen_et_al_2011;@Langtangen_Pedersen_2002)\n",
    "and\n",
    "[[Langtangen_et_al_2002;@Glimsdal_et_al_20006;@Rahman_et_al_2006b;@Haga_et_al_2011a;@Langtangen_2003a;@Langtangen_2008a;@Langtangen:95]](#Langtangen_et_al_2002;@Glimsdal_et_al_20006;@Rahman_et_al_2006b;@Haga_et_al_2011a;@Langtangen_2003a;@Langtangen_2008a;@Langtangen:95)\n",
    "and all the work of\n",
    "[[Langtangen_2012;@Mardal_et_al_2003a;@Jeberg_et_al_2004]](#Langtangen_2012;@Mardal_et_al_2003a;@Jeberg_et_al_2004) as well as\n",
    "old work [[Langtangen_1988d]](#Langtangen_1988d) and [[Langtangen_1989e]](#Langtangen_1989e), and the\n",
    "talk [[Langtangen_talk_2007a]](#Langtangen_talk_2007a).\n",
    "Langtangen also had two thesis [[Langtangen:85;@Langtangen_1989e]](#Langtangen:85;@Langtangen_1989e)\n",
    "back in the days.\n",
    "More retro citations are\n",
    "the old ME-IN323 book [[Langtangen:91]](#Langtangen:91) and the\n",
    "[[Langtangen:94b]](#Langtangen:94b) OONSKI '94 paper.\n",
    "\n",
    "<!-- --- begin exercise --- -->\n",
    "\n",
    "## Example 1: Examples can be typeset as exercises\n",
    "<div id=\"Example\"></div>\n",
    "\n",
    "Examples can start with a subsection heading starting with `Example:`\n",
    "and then, with the command-line option `--examples_as_exercises` be\n",
    "typeset as exercises. This is useful if one has solution\n",
    "environments as part of the example.\n",
    "\n",
    "**a)**\n",
    "State some problem.\n",
    "\n",
    "**Solution.**\n",
    "The answer to this subproblem can be written here.\n",
    "\n",
    "**b)**\n",
    "State some other problem.\n",
    "\n",
    "**Hint 1.**\n",
    "A hint can be given.\n",
    "\n",
    "**Hint 2.**\n",
    "Maybe even another hint?\n",
    "\n",
    "**Solution.**\n",
    "The answer to this other subproblem goes here,\n",
    "maybe over multiple doconce input lines.\n",
    "\n",
    "<!-- --- end exercise --- -->\n",
    "\n",
    "## User-defined environments\n",
    "\n",
    "The example in the section [Example 1: A test function](#ex:test:1p1) demonstrates how to write a test function.\n",
    "That is, a special test function for a function `add` appears in\n",
    "the example in the section [Example 1: A test function](#ex:test:1p1).\n",
    "\n",
    "## Example 1: A test function\n",
    "<div id=\"ex:test:1p1\"></div>\n",
    "\n",
    "Suppose we want to write a test function for checking the\n",
    "implementation of a Python function for addition."
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 8,
   "metadata": {
    "collapsed": false,
    "editable": true
   },
   "outputs": [],
   "source": [
    "def add(a, b):\n",
    "    return a + b\n",
    "\n",
    "def test_add():\n",
    "    a = 1; b = 1\n",
    "    expected = a + b\n",
    "    computed = add(a, b)\n",
    "    assert expected == computed"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "## Example 2: Addition\n",
    "<div id=\"ex:math:1p1\"></div>\n",
    "\n",
    "We have"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "$$\n",
    "1 + 1 = 2\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "or in tabular form:\n",
    "\n",
    "<table border=\"1\">\n",
    "<thead>\n",
    "<tr><th align=\"center\">Problem</th> <th align=\"center\">Result</th> </tr>\n",
    "</thead>\n",
    "<tbody>\n",
    "<tr><td align=\"center\">   $1+1$      </td> <td align=\"center\">   $2$       </td> </tr>\n",
    "</tbody>\n",
    "</table>\n",
    "**Highlight box!**\n",
    "\n",
    "This environment is used to highlight something:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "$$\n",
    "E = mc^2\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "## URLs\n",
    "<div id=\"subsubsec:ex\"></div>\n",
    "\n",
    "Testing of URLs: hpl's home page [hpl](https://folk.uio.no/hpl), or\n",
    "the entire URL if desired, <https://folk.uio.no/hpl>.  Here is a\n",
    "plain file link <testdoc.do.txt>, or <testdoc.do.txt>, or\n",
    "<testdoc.do.txt> or <testdoc.do.txt> or [a link with\n",
    "newline](testdoc.do.txt). Can test spaces with the link with word\n",
    "too: [hpl](https://folk.uio.no/hpl) or [hpl](https://folk.uio.no/hpl). Also `file:///` works: [link to a\n",
    "file](file:///home/hpl/vc/doconce/doc/demos/manual/manual.html) is\n",
    "fine to have. Moreover, \"loose\" URLs work, i.e., no quotes, just\n",
    "the plain URL as in <https://folk.uio.no/hpl>, if followed by space, comma,\n",
    "colon, semi-colon, question mark, exclamation mark, but not a period\n",
    "(which gets confused with the periods inside the URL).\n",
    "\n",
    "Mail addresses can also be used: [`hpl@simula.no`](mailto:hpl@simula.no), or just a [mail link](mailto:hpl@simula.no), or a raw <mailto:hpl@simula.no>.\n",
    "\n",
    "Here are some tough tests of URLs, especially for the `latex` format:\n",
    "[Newton-Cotes](https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas) formulas\n",
    "and a [good book](https://www.springer.com/mathematics/computational+science+%26+engineering/book/978-3-642-23098-1). Need to test\n",
    "Newton-Cotes with percentage in URL too:\n",
    "<https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas>\n",
    "and <https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae> which has a shebang.\n",
    "\n",
    "For the `--device=paper` option it is important to test that URLs with\n",
    "monospace font link text get a footnote\n",
    "(unless the `--latex_no_program_footnotelink`\n",
    "is used), as in this reference to\n",
    "[`decay_mod`](https://github.com/hplgit/INF5620/tree/gh-pages/src/decay/experiments/decay_mod.py), [`ball1.py`](https://tinyurl.com/pwyasaa/formulas.ball1.py),\n",
    "and [`ball2.py`](https://tinyurl.com/pwyasaa/formulas.ball2.py).\n",
    "\n",
    "<!-- Comments should be inserted outside paragraphs (because in the rst -->\n",
    "<!-- format extra blanks make a paragraph break). -->\n",
    "\n",
    "<!-- Note that when there is no https: or file:, it can be a file link -->\n",
    "<!-- if the link name is URL, url, \"URL\", or \"url\". Such files should, -->\n",
    "<!-- if rst output is desired, but placed in a `_static*` folder. -->\n",
    "\n",
    "More tough tests: repeated URLs whose footnotes when using the\n",
    "`--device=paper` option must be correct. We have\n",
    "[google](https://google.com), [google](https://google.com), and\n",
    "[google](https://google.com), which should result in exactly three\n",
    "footnotes."
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "# LaTeX Mathematics\n",
    "\n",
    "Here is an equation without label using backslash-bracket environment:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "$$\n",
    "a = b + c\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "or with number and label, as in ([6](#my:eq1)), using the equation environment:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "<!-- Equation labels as ordinary links -->\n",
    "<div id=\"my:eq1\"></div>\n",
    "\n",
    "$$\n",
    "\\begin{equation}\n",
    "{\\partial u\\over\\partial t} = \\nabla^2 u \\label{my:eq1} \\tag{6}\n",
    "\\end{equation}\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "We can refer to this equation by ([6](#my:eq1)).\n",
    "\n",
    "Here is a system without equation numbers, using the align-asterisk environment:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "$$\n",
    "\\begin{align*}\n",
    "\\pmb{a} &= \\pmb{q}\\times\\pmb{n} \\\\ \n",
    "b &= \\nabla^2 u + \\nabla^4 v\n",
    "\\end{align*}\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "More mathematical typesetting is demonstrated in the coming exercises.\n",
    "\n",
    "Below, we have [Problem 2: Flip a Coin](#demo:ex:1) and [Project 4: Compute a Probability](#demo:ex:2),\n",
    "as well as [Project 5: Explore Distributions of Random Circles](#proj:circle1) and [Project 11: References to Project [demo:ex:2](#demo:ex:2) in a heading works for ipynb](#exer:you), and in\n",
    "between there we have [Exercise 10: Make references to projects and problems](#exer:some:formula).\n",
    "\n",
    "# Exercises\n",
    "\n",
    "<!-- --- begin exercise --- -->\n",
    "\n",
    "## Problem 2: Flip a Coin\n",
    "<div id=\"demo:ex:1\"></div>\n",
    "<!-- keywords = random numbers; Monte Carlo simulation; ipynb -->\n",
    "\n",
    "<!-- Torture tests -->\n",
    "\n",
    "**a)**\n",
    "Make a program that simulates flipping a coin $N$ times.\n",
    "Print out \"tail\" or \"head\" for each flip and\n",
    "let the program count the number of heads.\n",
    "\n",
    "<!-- --- begin hint in exercise --- -->\n",
    "\n",
    "**Hint 1.**\n",
    "Use `r = random.random()` and define head as `r <= 0.5`.\n",
    "\n",
    "<!-- --- end hint in exercise --- -->\n",
    "\n",
    "<!-- --- begin hint in exercise --- -->\n",
    "\n",
    "**Hint 2.**\n",
    "Draw an integer among $\\{1,2\\}$ with\n",
    "`r = random.randint(1,2)` and define head when `r` is 1.\n",
    "\n",
    "<!-- --- end hint in exercise --- -->\n",
    "\n",
    "<!-- --- begin answer of exercise --- -->\n",
    "**Answer.**\n",
    "If the `random.random()` function returns a number $<1/2$, let it be\n",
    "head, otherwise tail. Repeat this $N$ number of times.\n",
    "<!-- --- end answer of exercise --- -->\n",
    "\n",
    "<!-- --- begin solution of exercise --- -->\n",
    "**Solution.**"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 9,
   "metadata": {
    "collapsed": false,
    "editable": true
   },
   "outputs": [],
   "source": [
    "import sys, random\n",
    "N = int(sys.argv[1])\n",
    "heads = 0\n",
    "for i in range(N):\n",
    "    r = random.random()\n",
    "    if r <= 0.5:\n",
    "        heads += 1\n",
    "print('Flipping a coin %d times gave %d heads' % (N, heads))"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "<!-- --- end solution of exercise --- -->\n",
    "\n",
    "**b)**\n",
    "Vectorize the code in a) using boolean indexing.\n",
    "\n",
    "Vectorized code can be written in many ways.\n",
    "Sometimes the code is less intuitive, sometimes not.\n",
    "At least there is not much to find in the section [Section 1](#sec1).\n",
    "\n",
    "**c)**\n",
    "Vectorize the code in a) using `numpy.sum`.\n",
    "\n",
    "<!-- --- begin answer of exercise --- -->\n",
    "**Answer.**\n",
    "`np.sum(np.where(r <= 0.5, 1, 0))` or `np.sum(r <= 0.5)`.\n",
    "<!-- --- end answer of exercise --- -->\n",
    "\n",
    "In this latter subexercise, we have an\n",
    "example where the code is easy to read.\n",
    "\n",
    "### My remarks\n",
    "\n",
    "Remarks with such a subsubsection is treated as more text\n",
    "after the last subexercise. Test a list too:\n",
    "\n",
    "1. Mark 1.\n",
    "\n",
    "2. Mark 2.\n",
    "\n",
    "Filenames: `flip_coin.py`, `flip_coin.pdf`.\n",
    "\n",
    "<!-- Closing remarks for this Problem -->\n",
    "\n",
    "### Remarks\n",
    "\n",
    "These are the exercise remarks, appearing at the very end.\n",
    "\n",
    "<!-- solution files: mysol.txt, mysol_flip_coin.py, yet_another.file -->\n",
    "\n",
    "<!-- --- end exercise --- -->\n",
    "\n",
    "## Not an exercise\n",
    "\n",
    "Should be possible to stick a normal section in the middle of many\n",
    "exercises.\n",
    "\n",
    "<!-- --- begin exercise --- -->\n",
    "\n",
    "## Exercise 3: Test of plain text exercise\n",
    "<div id=\"my:exer1\"></div>\n",
    "\n",
    "Very short exercise. What is the capital\n",
    "of Norway?\n",
    "Filename: `myexer1`.\n",
    "\n",
    "<!-- --- end exercise --- -->\n",
    "\n",
    "<!-- --- begin exercise --- -->\n",
    "\n",
    "## Project 4: Compute a Probability\n",
    "<div id=\"demo:ex:2\"></div>\n",
    "\n",
    "<!-- Minimalistic exercise -->\n",
    "\n",
    "What is the probability of getting a number between 0.5 and 0.6 when\n",
    "drawing uniformly distributed random numbers from the interval $[0,1)$?\n",
    "\n",
    "At the end we have a list because that caused problems in LaTeX\n",
    "in previous DocOnce versions:\n",
    "\n",
    "1. item1\n",
    "\n",
    "2. item2\n",
    "\n",
    "<!-- --- begin hint in exercise --- -->\n",
    "\n",
    "**Hint.**\n",
    "To answer this question empirically, let a program\n",
    "draw $N$ such random numbers using Python's standard `random` module,\n",
    "count how many of them, $M$, that fall in the interval $(0.5,0.6)$, and\n",
    "compute the probability as $M/N$.\n",
    "\n",
    "<!-- --- end hint in exercise --- -->\n",
    "\n",
    "<!-- --- end exercise --- -->\n",
    "\n",
    "<!-- --- begin exercise --- -->\n",
    "\n",
    "## Project 5: Explore Distributions of Random Circles\n",
    "<div id=\"proj:circle1\"></div>\n",
    "<!-- keywords = ipynb -->\n",
    "\n",
    "The formula for a circle is given by"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "<!-- Equation labels as ordinary links -->\n",
    "<div id=\"circle:x\"></div>\n",
    "\n",
    "$$\n",
    "\\begin{equation}\n",
    "x = x_0 + R\\cos 2\\pi t,\n",
    "\\label{circle:x} \\tag{7}\n",
    "\\end{equation}\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "<!-- Equation labels as ordinary links -->\n",
    "<div id=\"circle:y\"></div>\n",
    "\n",
    "$$\n",
    "\\begin{equation}  \n",
    "y = y_0 + R\\sin 2\\pi t,\n",
    "\\label{circle:y} \\tag{8}\n",
    "\\end{equation}\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "where $R$ is the radius of the circle, $(x_0,y_0)$ is the\n",
    "center point, and $t$ is a parameter in the unit interval $[0,1]$.\n",
    "For any $t$, $(x,y)$ computed from ([7](#circle:x))-([8](#circle:y))\n",
    "is a point on the circle.\n",
    "The formula can be used to generate `n` points on a circle:"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 10,
   "metadata": {
    "collapsed": false,
    "editable": true
   },
   "outputs": [],
   "source": [
    "import numpy as np\n",
    "\n",
    "def circle(R, x0, y0, n=501):\n",
    "    t = np.linspace(0, 1, n)\n",
    "    x = x0 + R*np.cos(2*np.pi*t)\n",
    "    y = y0 + R*np.sin(2*np.pi*t)\n",
    "    return x, y\n",
    "\n",
    "x, y = circle(2.0, 0, 0)"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "<!-- Often in an exercise we have some comments about the solution -->\n",
    "<!-- which we normally want to keep where they are. -->\n",
    "\n",
    "The goal of this project is to draw $N$ circles with random\n",
    "center and radius. Plot each circle using the `circle` function\n",
    "above.\n",
    "\n",
    "**a)**\n",
    "Let $R$ be normally distributed and $(x_0,y_0)$ uniformly distributed.\n",
    "\n",
    "<!-- --- begin hint in exercise --- -->\n",
    "\n",
    "**Hint.**\n",
    "Use the `numpy.random` module to draw the\n",
    "$x_0$, $y_0$, and $R$ quantities.\n",
    "\n",
    "<!-- --- end hint in exercise --- -->\n",
    "\n",
    "<!-- --- begin answer of exercise --- -->\n",
    "**Answer.**\n",
    "Here goes the short answer to part a).\n",
    "<!-- --- end answer of exercise --- -->\n",
    "\n",
    "<!-- --- begin solution of exercise --- -->\n",
    "**Solution.**\n",
    "Here goes a full solution to part a).\n",
    "<!-- --- end solution of exercise --- -->\n",
    "\n",
    "**b)**\n",
    "Let $R$ be uniformly distributed and $(x_0,y_0)$ normally distributed.\n",
    "Filename: `norm`.\n",
    "\n",
    "**c)**\n",
    "Let $R$ and $(x_0,y_0)$ be normally distributed.\n",
    "\n",
    "Filename: `circles`.\n",
    "\n",
    "<!-- Closing remarks for this Project -->\n",
    "\n",
    "### Remarks\n",
    "\n",
    "At the very end of the exercise it may be appropriate to summarize\n",
    "and give some perspectives.\n",
    "\n",
    "<!-- --- end exercise --- -->\n",
    "\n",
    "<!-- --- begin exercise --- -->\n",
    "\n",
    "## Exercise 6: Determine some Distance\n",
    "<div id=\"exer:dist\"></div>\n",
    "\n",
    "Intro to this exercise. Questions are in subexercises below.\n",
    "\n",
    "<!-- --- begin solution of exercise --- -->\n",
    "**Solution.**\n",
    "Here goes a full solution of the whole exercise.\n",
    "With some math $a=b$ in this solution:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "$$\n",
    "\\hbox{math in solution: } a = b\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "And code `a=b` in this solution:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "        a = b  # code in solution\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "End of solution is here.\n",
    "\n",
    "<!-- --- end solution of exercise --- -->\n",
    "\n",
    "**a)**\n",
    "Subexercises are numbered a), b), etc.\n",
    "\n",
    "<!-- --- begin hint in exercise --- -->\n",
    "\n",
    "**Hint 1.**\n",
    "First hint to subexercise a).\n",
    "With math $a=b$ in hint:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "$$\n",
    "a=b.\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "And with code (in plain verbatim) returning $x+1$ in hint:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "        def func(x):\n",
    "            return x + 1  # with code in hint\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "<!-- --- end hint in exercise --- -->\n",
    "\n",
    "<!-- --- begin hint in exercise --- -->\n",
    "\n",
    "**Hint 2.**\n",
    "Second hint to subexercise a).\n",
    "\n",
    "Test list in hint:\n",
    "\n",
    "1. item1\n",
    "\n",
    "2. item2\n",
    "\n",
    "<!-- --- end hint in exercise --- -->\n",
    "Filename: `subexer_a.pdf`.\n",
    "\n",
    "<!-- --- begin answer of exercise --- -->\n",
    "**Answer.**\n",
    "Short answer to subexercise a).\n",
    "With math in answer: $a=b$.\n",
    "<!-- --- end answer of exercise --- -->\n",
    "\n",
    "**b)**\n",
    "Here goes the text for subexercise b).\n",
    "\n",
    "Some math $\\cos^2 x + \\sin^2 x = 1$ written one a single line:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "$$\n",
    "\\cos^2 x + \\sin^2 x = 1 \\thinspace .\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "<!-- --- begin hint in exercise --- -->\n",
    "\n",
    "**Hint.**\n",
    "A hint for this subexercise.\n",
    "\n",
    "<!-- --- end hint in exercise --- -->\n",
    "Filename: `subexer_b.pdf`.\n",
    "\n",
    "<!-- --- begin solution of exercise --- -->\n",
    "**Solution.**\n",
    "Here goes the solution of this subexercise.\n",
    "<!-- --- end solution of exercise --- -->\n",
    "\n",
    "<!-- No meaning in this weired test example: -->\n",
    "The text here belongs to the main (intro) part of the exercise. Need\n",
    "closing remarks to have text after subexercises.\n",
    "\n",
    "Test list in exercise:\n",
    "\n",
    "1. item1\n",
    "\n",
    "2. item2\n",
    "<!-- Closing remarks for this Exercise -->\n",
    "\n",
    "### Remarks\n",
    "\n",
    "Some final closing remarks, e.g., summarizing the main findings\n",
    "and their implications in other problems can be made. These\n",
    "remarks will appear at the end of the typeset exercise.\n",
    "\n",
    "<!-- --- end exercise --- -->\n",
    "\n",
    "<!-- --- begin exercise --- -->\n",
    "\n",
    "## Some exercise without the \"Exercise:\" prefix\n",
    "\n",
    "<!-- Another minimalistic exercise -->\n",
    "\n",
    "Just some text. And some math saying that $e^0=1$ on a single line,\n",
    "to test that math block insertion is correct:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "$$\n",
    "\\exp{(0)} = 1\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "And a test that the code `lambda x: x+2` is correctly placed here:"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "        lambda x: x+2\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "<!-- Have some comments at the end of the exercise to see that -->\n",
    "<!-- the Filename: ... is written correctly. -->\n",
    "<!-- --- end exercise --- -->\n",
    "\n",
    "<!-- --- begin exercise --- -->\n",
    "\n",
    "## Exercise 8: Solution of differential equation\n",
    "<div id=\"sec:this:exer:de\"></div>\n",
    "\n",
    "\n",
    "\n",
    "Given"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "$$\n",
    "\\frac{dy}{dx} = -y(x),\\quad y(0)=1\n",
    "$$"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "What is the solution of this equation?\n",
    "\n",
    "**Choice A:**\n",
    " $y=e^{-y}$\n",
    "\n",
    "**Choice B:**\n",
    " $y=e^{y}$\n",
    "\n",
    "**Choice C:**"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "from math import exp\n",
    "def f(x):\n",
    "    return exp(x)\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {
    "editable": true
   },
   "source": [
    "**Choice D:**\n",
    " The solution cannot be found because there is a derivative in the equation.\n",
    "\n",
    "**Choice E:**\n",
    " The equation is meaningless: an equation must be an equation\n",
    "for $x$ or $y$, not a function $y(x)$.\n",
    "\n",
    "\n",
    "\n",
    "<!-- --- end exercise --- -->\n",
    "\n",
    "<!-- --- begin exercise --- -->\n",
    "\n",
    "## Example 9: Just an example\n",
    "\n",
    "<!-- This example needs the --examples_as_exercises option, otherwise -->\n",
    "<!-- it is just typeset as it is written. -->\n",
    "\n",
    "**a)**\n",
    "What is the capital of Norway?\n",
    "\n",
    "**Answer.**\n",
    "Oslo.\n",
    "\n",
    "<!-- --- end exercise --- -->\n",
    "\n",
    "# Here goes another section\n",
    "\n",
    "With some text, before we continue with exercises.\n",
    "\n",
    "# More Exercises\n",
    "\n",
    "<!-- --- begin exercise --- -->\n",
    "\n",
    "## Exercise 10: Make references to projects and problems\n",
    "<div id=\"exer:some:formula\"></div>\n",
    "\n",
    "<!-- Test comments not at the end only -->\n",
    "Pick a statement from [Project 5: Explore Distributions of Random Circles](#proj:circle1) or [Problem 2: Flip a Coin](#demo:ex:1)\n",
    "and verify it.\n",
    "\n",
    "Test list at the end of an exercise without other elements (like subexercise,\n",
    "hint, etc.):\n",
    "\n",
    "1. item1\n",
    "\n",
    "2. item2\n",
    "\n",
    "Filename: `verify_formula.py`.\n",
    "\n",
    "<!-- --- end exercise --- -->\n",
    "\n",
    "<!-- --- begin exercise --- -->\n",
    "\n",
    "## Project 11: References to [Project 4: Compute a Probability](#demo:ex:2) in a heading works for ipynb\n",
    "<div id=\"exer:you\"></div>\n",
    "\n",
    "Refer to the previous exercise as [Exercise 10: Make references to projects and problems](#exer:some:formula),\n",
    "the two before that as [Project 4: Compute a Probability](#demo:ex:2) and [Project 5: Explore Distributions of Random Circles](#proj:circle1),\n",
    "and this one as [Project 11: References to Project [demo:ex:2](#demo:ex:2) in a heading works for ipynb](#exer:you).\n",
    "Filename: `selc_composed.pdf`.\n",
    "\n",
    "<!-- --- end exercise --- -->\n",
    "\n",
    "# References\n",
    "\n",
    "1. <div id=\"Langtangen_Pedersen_2002\"></div> **H. P. Langtangen and G. Pedersen**. \n",
    "    Propagation of Large Destructive Waves,\n",
    "    *International Journal of Applied Mechanics and Engineering*,\n",
    "    7(1),\n",
    "    pp. 187-204,\n",
    "    2002.\n",
    "\n",
    "2. <div id=\"Langtangen_et_al_2002\"></div> **H. P. Langtangen, K.-A. Mardal and R. Winther**. \n",
    "    Numerical Methods for Incompressible Viscous Flow,\n",
    "    *Advances in Water Resources*,\n",
    "    25,\n",
    "    pp. 1125-1146,\n",
    "    2002.\n",
    "\n",
    "3. <div id=\"Langtangen_1994a\"></div> **H. P. Langtangen**. \n",
    "    Numerical Solution of First Passage Problems in Random Vibrations,\n",
    "    *SIAM Journal of Scientific and Statistical Computing*,\n",
    "    15,\n",
    "    pp. 997-996,\n",
    "    1994.\n",
    "\n",
    "4. <div id=\"Mardal_et_al_2003a\"></div> **K.-A. Mardal, G. W. Zumbusch and H. P. Langtangen**. \n",
    "    Software Tools for Multigrid Methods,\n",
    "    *Advanced Topics in Computational Partial Differential Equations -- Numerical Methods and Diffpack Programming*,\n",
    "    edited by **H. P. Langtangen and A. Tveito**,\n",
    "    Springer,\n",
    "    2003,\n",
    "    Edited book,\n",
    "    <http://some.where.org>.\n",
    "\n",
    "5. <div id=\"Langtangen_1988d\"></div> **H. P. Langtangen**. \n",
    "    The FEMDEQS Program System,\n",
    "    *Department of Mathematics, University of Oslo*,\n",
    "    1989,\n",
    "    <http://www.math.uio.no/old/days/hpl/femdeqs.pdf>.\n",
    "\n",
    "6. <div id=\"Langtangen_1992c\"></div> **H. P. Langtangen**. \n",
    "    Stochastic Breakthrough Time Analysis of an Enhanced Oil Recovery Process,\n",
    "    *SIAM Journal on Scientific Computing*,\n",
    "    13,\n",
    "    pp. 1394-1417,\n",
    "    1992.\n",
    "\n",
    "7. <div id=\"Mortensen_et_al_2011\"></div> **M. Mortensen, H. P. Langtangen and G. N. Wells**. \n",
    "    A FEniCS-Based Programming Framework for Modeling Turbulent Flow by the Reynolds-Averaged Navier-Stokes Equations,\n",
    "    *Advances in Water Resources*,\n",
    "    34(9),\n",
    "    [doi: 10.1016/j.advwatres.2011.02.013](https://dx.doi.org/10.1016/j.advwatres.2011.02.013),\n",
    "    2011.\n",
    "\n",
    "8. <div id=\"Glimsdal_et_al_20006\"></div> **S. Glimsdal, G. Pedersen, K. Atakan, C. B. Harbitz, H. P. Langtangen and F. L\\ovholt**. \n",
    "    Propagation of the Dec. 26, 2004 Indian Ocean Tsunami: Effects of Dispersion and Source Characteristics,\n",
    "    *International Journal of Fluid Mechanics Research*,\n",
    "    33(1),\n",
    "    pp. 15-43,\n",
    "    2006.\n",
    "\n",
    "9. <div id=\"Rahman_et_al_2006b\"></div> **S. Rahman, J. Gorman, C. H. W. Barnes, D. A. Williams and H. P. Langtangen**. \n",
    "    Numerical Investigation of a Piezoelectric Surface Acoustic Wave Interaction With a One-Dimensional Channel,\n",
    "    *Physical Review B: Condensed Matter and Materials Physics*,\n",
    "    74,\n",
    "    2006,\n",
    "    035308.\n",
    "\n",
    "10. <div id=\"Haga_et_al_2011a\"></div> **J. B. Haga, H. Osnes and H. P. Langtangen**. \n",
    "    On the Causes of Pressure Oscillations in Low-Permeable and Low-Compressible Porous Media,\n",
    "    *International Journal of Analytical and Numerical Methods in Geomechanics*,\n",
    "    [doi: 10.1002/nag.1062](https://dx.doi.org/10.1002/nag.1062),\n",
    "    2011,\n",
    "    <http://onlinelibrary.wiley.com/doi/10.1002/nag.1062/abstract>.\n",
    "\n",
    "11. <div id=\"Langtangen_2003a\"></div> **H. P. Langtangen**. \n",
    "    *Computational Partial Differential Equations - Numerical Methods and Diffpack Programming*,\n",
    "    second edition,\n",
    "    *Texts in Computational Science and Engineering*,\n",
    "    Springer,\n",
    "    2003.\n",
    "\n",
    "12. <div id=\"Langtangen_2008a\"></div> **H. P. Langtangen**. \n",
    "    *Python Scripting for Computational Science*,\n",
    "    third edition,\n",
    "    *Texts in Computational Science and Engineering*,\n",
    "    Springer,\n",
    "    2008.\n",
    "\n",
    "13. <div id=\"Langtangen:95\"></div> **H. P. Langtangen and G. Pedersen**. \n",
    "    Finite Elements for the Boussinesq Wave Equations,\n",
    "    Waves and Non-linear Processes in Hydrodynamics,\n",
    "    edited by **J. Grue, B. Gjevik and J. E. Weber**,\n",
    "    Kluwer Academic Publishers,\n",
    "    pp. pp. 117-126,\n",
    "    1995,\n",
    "    <http://www.amazon.ca/Waves-Nonlinear-Processes-Hydrodynamics-John/dp/0792340310>.\n",
    "\n",
    "14. <div id=\"Langtangen_2012\"></div> **H. P. Langtangen**. \n",
    "    *A Primer on Scientific Programming With Python*,\n",
    "    third edition,\n",
    "    *Texts in Computational Science and Engineering*,\n",
    "    Springer,\n",
    "    2012.\n",
    "\n",
    "15. <div id=\"Jeberg_et_al_2004\"></div> **P. V. Jeberg, H. P. Langtangen and C. B. Terp**. \n",
    "    Optimization With Diffpack: Practical Example From Welding,\n",
    "    *Simula Research Laboratory*,\n",
    "    2004,\n",
    "    Internal report.\n",
    "\n",
    "16. <div id=\"Langtangen_1989e\"></div> **H. P. Langtangen**. \n",
    "    Computational Methods for Two-Phase Flow in Oil Reservoirs,\n",
    "    Ph.D. Thesis,\n",
    "    Mechanics Division, Department of Mathematics, University of Oslo,\n",
    "    1989,\n",
    "    Dr. Scient. thesis..\n",
    "\n",
    "17. <div id=\"Langtangen_talk_2007a\"></div> **H. P. Langtangen**. \n",
    "    Computational Modeling of Huge Tsunamis From Asteroid Impacts,\n",
    "    2007,\n",
    "    Invited keynote lecture at the \\emphInternational conference on Computational Science 2007 (ICCS'07), Beijing, China.\n",
    "\n",
    "18. <div id=\"Langtangen:85\"></div> **H. P. Langtangen**. \n",
    "    Solution of the Navier-Stokes Equations With the Finite Element Method in Two and Three Dimensions,\n",
    "    M.Sc. Thesis,\n",
    "    Mechanics Division, Department of Mathematics, University of Oslo,\n",
    "    1985,\n",
    "    Cand.Scient. thesis.\n",
    "\n",
    "19. <div id=\"Langtangen:91\"></div> **H. P. Langtangen and A. Tveito**. \n",
    "    Numerical Methods in Continuum Mechanics,\n",
    "    *Center for Industrial Research*,\n",
    "    1991,\n",
    "    Lecture notes for a course (ME-IN 324). 286 pages..\n",
    "\n",
    "20. <div id=\"Langtangen:94b\"></div> **H. P. Langtangen**. \n",
    "    Diffpack: Software for Partial Differential Equations,\n",
    "    *Proceedings of the Second Annual Object-Oriented Numerics Conference (OON-SKI'94), Sunriver, Oregon, USA*,\n",
    "    edited by **A. Vermeulen**,\n",
    "    1994.\n",
    "\n",
    "# Appendix: Just for testing; part I\n",
    "<div id=\"app1\"></div>\n",
    "\n",
    "This is the first appendix.\n",
    "\n",
    "## A subsection within an appendix\n",
    "\n",
    "Some text.\n",
    "\n",
    "# Appendix: Just for testing; part II\n",
    "<div id=\"app2\"></div>\n",
    "\n",
    "This is more stuff for an appendix.\n",
    "\n",
    "## Appendix: Testing identical titles\n",
    "\n",
    "Without label.\n",
    "\n",
    "## Appendix: Testing identical titles\n",
    "<div id=\"test:title:id1\"></div>\n",
    "\n",
    "With label.\n",
    "\n",
    "## Appendix: Testing identical titles\n",
    "<div id=\"test:title:id2\"></div>\n",
    "\n",
    "What about inserting a quiz?\n",
    "\n",
    "\n",
    "\n",
    "## Test of quizzes\n",
    "\n",
    "\n",
    "**Fundamental test:** What is the capital of Norway?\n",
    "\n",
    "**Answer 1:**\n",
    " Stockholm\n",
    "\n",
    "**Answer 2:**\n",
    " London\n",
    "\n",
    "**Answer 3:**\n",
    " Oslo\n",
    "\n",
    "**Choice D:**\n",
    " Bergen\n",
    "\n",
    "\n",
    "\n",
    "## Appendix: Testing identical titles\n",
    "\n",
    "Without label.\n",
    "\n",
    "**Tip.**\n",
    "\n",
    "Here is a tip or hint box, typeset as a notice box.\n",
    "\n",
    "\n",
    "\n",
    "Need a lot of text to surround the summary box.\n",
    "Version control systems allow you to record the history of files\n",
    "and share files among several computers and collaborators in a\n",
    "professional way. File changes on one computer are updated or\n",
    "merged with changes on another computer. Especially when working\n",
    "with programs or technical reports it is essential\n",
    "to have changes documented and to\n",
    "ensure that every computer and person involved in the project\n",
    "have the latest updates of the files.\n",
    "Greg Wilson' excellent [Script for Introduction to Version Control](https://software-carpentry.org/2010/07/script-for-introduction-to-version-control/) provides a more detailed motivation why you will benefit greatly\n",
    "from using version control systems.\n",
    "\n",
    "**Summary.**\n",
    "\n",
    "**Bold remark:** Make some text with this summary.\n",
    "Much testing in this document, otherwise stupid content.\n",
    "Much testing in this document, otherwise stupid content.\n",
    "Much testing in this document, otherwise stupid content.\n",
    "Much testing in this document, otherwise stupid content.\n",
    "Much testing in this document, otherwise stupid content.\n",
    "Much testing in this document, otherwise stupid content.\n",
    "Much testing in this document, otherwise stupid content.\n",
    "Much testing in this document, otherwise stupid content.\n",
    "Much testing in this document, otherwise stupid content.\n",
    "\n",
    "\n",
    "\n",
    "Projects that you want to share among several computers or project\n",
    "workers are today most conveniently stored at some web site \"in the\n",
    "cloud\" and updated through communication with that site. I strongly\n",
    "recommend you to use such sites for all serious programming and\n",
    "scientific writing work - and all other important files.\n",
    "\n",
    "The simplest services for hosting project files are [Dropbox](https://dropbox.com) and [Google Drive](https://drive.google.com).\n",
    "It is very easy to get started with these systems, and they allow you\n",
    "to share files among laptops and mobile units with as many users as\n",
    "you want. The systems offer a kind of version control in that the\n",
    "files are stored frequently (several times per minute), and you can go\n",
    "back to previous versions for the last 30 days. However, it is\n",
    "challenging  to find the right version from the past when there are\n",
    "so many of them.\n",
    "\n",
    "More seriously, when several people may edit files simultaneously, it\n",
    "can be difficult detect who did what when, roll back to previous\n",
    "versions, and to manually merge the edits when these are\n",
    "incompatible. Then one needs more sophisticated tools than Dropbox or\n",
    "Google Drive: project hosting services with true version control\n",
    "systems.  The following text aims at providing you with the minimum\n",
    "information to started with such systems. Numerous other tutorials\n",
    "contain more comprehensive material and in-depth explanations of the\n",
    "concepts and tools.\n",
    "\n",
    "The idea with project hosting services is that you have the files\n",
    "associated with a project in the cloud. Many people may share these\n",
    "files.  Every time you want to work on the project you explicitly\n",
    "update your version of the files, edit the files as you like, and\n",
    "synchronize the files with the \"master version\" at the site where the\n",
    "project is hosted.  If you at some point need to go back to a\n",
    "version of the files at some particular point in the past,\n",
    "this is an easy operation. You can also use tools to see\n",
    "what various people have done with the files in the various versions.\n",
    "\n",
    "All these services are very similar. Below we describe how you get\n",
    "started with Bitbucket, GitHub, and Googlecode. Launchpad works very\n",
    "similarly to the latter three. All the project hosting services have\n",
    "excellent introductions available at their web sites, but the recipes\n",
    "below are much shorter and aim at getting you started as quickly as\n",
    "possible by concentrating on the most important need-to-know steps.\n",
    "The Git tutorials we refer to later in this document contain more\n",
    "detailed information and constitute of course very valuable readings\n",
    "when you use version control systems every day. The point now is\n",
    "to get started.\n",
    "\n",
    "## Appendix: Testing inline comments\n",
    "\n",
    "<!-- Names can be [ A-Za-z0-9_'+-]+ -->\n",
    "\n",
    "Projects that you want to share among several computers or project\n",
    "workers are today most conveniently stored at some web site \"in the\n",
    "cloud\" and updated through communication with that\n",
    "site. [hpl's semi opinion 1: not sure if in the cloud is\n",
    "understood by\n",
    "all.] I strongly recommend you to use such sites for all serious\n",
    "programming and scientific writing work - and all other important\n",
    "files.\n",
    "\n",
    "The simplest services for hosting project files is Dropbox. [mp 2: Simply go to <https://dropbox.com> and watch the video. It explains\n",
    "how files, like `myfile.py`, perhaps containing much math, like\n",
    "$\\partial u/\\partial t$, are easily communicated between machines.] It\n",
    "is very easy to get started with Dropbox, and it allows you to share\n",
    "files among [hpl 3: laptops and mobile units -> computers, tablets,\n",
    "and phones].\n",
    "\n",
    "<!-- Test horizontal rule -->\n",
    "\n",
    "------\n",
    "\n",
    "<!-- Coments for editing -->\n",
    "\n",
    "First[add 4: ,] consider a quantity $Q$. [edit 5: To this end, -> We note that]\n",
    "$Q>0$, because [del 6: a] negative [edit 7: quantity is -> quantities\n",
    "are] [del 8: just] negative. [add 9: This comes as no surprise.]\n",
    "\n",
    "<!-- Test tailored latex figure references with page number -->\n",
    "Let us refer to [Figure 1](#fig:impact) again.\n",
    "\n",
    "Test references in a list:\n",
    "\n",
    " * [Section 1](#sec1)\n",
    "\n",
    " * [Subsection 1](#subsec1)\n",
    "\n",
    " * [fig:impact](#fig:impact)\n",
    "\n",
    "## Appendix: Testing headings ending with `verbatim inline`\n",
    "\n",
    "The point here is to test 1) `verbatim` code in headings, and 2)\n",
    "ending a heading with verbatim code as this triggers a special\n",
    "case in LaTeX.\n",
    "\n",
    "We also test mdash---used as alternative to hyphen without spaces around,\n",
    "or in quotes:\n",
    "\n",
    "> *Fun is fun*.---Unknown.\n",
    "\n",
    "\n",
    "\n",
    "\n",
    "\n",
    "The ndash should also be tested - as in the Hanson - Nilson equations\n",
    "on page 277 - 278.\n",
    "\n",
    "And finally, what about admons, quotes, and boxes? They are tested\n",
    "in a separate document: `admon.do.txt`.\n",
    "\n",
    "[^example-of-the-third-footnote]: Not much to add here, but the footnote\n",
    "is at the end with only one newline."
   ]
  }
 ],
 "metadata": {},
 "nbformat": 4,
 "nbformat_minor": 4
}

************** File: testdoc.m *****************
%% A Document for Testing DocOnce
% 
% Author: Hans Petter Langtangen [1, 2] (hpl@simula.no)
% Author: Kaare Dump [3] 
% Author: A. Dummy Author  
% Author: I. S. Overworked and Outburned [4, 5, 6, 7] 
% Author: J. Doe  (j_doe@cyberspace.com)
% 
% [1] Center for Biomedical Computing, Simula Research Laboratory
% [2] Department of Informatics, University of Oslo
% [3] Segfault, Cyberspace
% [4] Inst1
% [5] Inst2, Somewhere
% [6] Third Inst, Elsewhere
% [7] Fourth Inst
% 
% Date: Jan 32, 2100
% 
% Made with DocOnce
% 
% 
% 
% Table of contents:
% 
%  Section 1 
%      Here is a list with subsubsection heading 
%    Subsection 1 
%      Test Section reference at beginning of line and after a sentence 
%      Computer code 
%      Subsubsection heading before code 
%      Running OS commands 
%      Footnotes 
%    Subsection 2: Testing figures 
%    The $\theta$ parameter (not $\nabla$?) 
%    Custom Environments 
%    Tables 
%    A test of verbatim words in heading with subscript $a_i$: |my_file_v1| and |my_file_v2| 
%    *Just bold* 
%    _Just emphasize_ 
%    |Just verbatim| 
%    *Bold* beginning 
%    _Emphasize_ beginning 
%    |Verbatim| beginning 
%    Maybe *bold end* 
%    Maybe _emphasize end_ 
%    Maybe |verbatim end| 
%    The middle has *bold* word 
%    The middle has _emphasize_ word 
%    The middle has |verbatim| word 
%    Bibliography test 
%    Example 1: Examples can be typeset as exercises 
%    User-defined environments 
%    Example 1: A test function 
%    Example 2: Addition 
%    URLs 
%  LaTeX Mathematics 
%  Exercises 
%    Problem 2: Flip a Coin 
%      My remarks 
%      Remarks 
%    Not an exercise 
%    Exercise 3: Test of plain text exercise 
%    Project 4: Compute a Probability 
%    Project 5: Explore Distributions of Random Circles 
%      Remarks 
%    Exercise 6: Determine some Distance 
%      Remarks 
%    Some exercise without the "Exercise:" prefix 
%    Exercise 8: Solution of differential equation 
%    Example 9: Just an example 
%  Here goes another section 
%  More Exercises 
%    Exercise 10: Make references to projects and problems 
%    Project 11: References to "Project 4: Compute a Probability" in a heading works for matlabnb 
%  References 
%  Appendix: Just for testing; part I 
%    A subsection within an appendix 
%  Appendix: Just for testing; part II 
%    Appendix: Testing identical titles 
%    Appendix: Testing identical titles 
%    Appendix: Testing identical titles 
%    Appendix: Testing identical titles 
%    Appendix: Testing inline comments 
%    Appendix: Testing headings ending with |verbatim inline| 
% 
% % !split
% 
% The format of this document is
% matlabnb
% 
% *Abstract.* This is a document with many test constructions for doconce syntax.
% It was used heavily for the development and kept for testing
% numerous constructions, also special and less common cases.
% 
% And exactly for test purposes we have an extra line here, which
% is part of the abstract.
% 
% % Cannot demonstrate chapter headings since abstract and chapter
% % are mutually exclusive in LaTeX
% 
%% Section 1
% 
% Here is a nested list:
% 
%   * item1
% 
%   * item2
% 
%   * item3 which continues
%     on the next line to test that feature
% 
%   * and a sublist
% 
%     * with indented subitem1
% 
%     * and a subitem2
% 
% 
%   * and perhaps an ordered sublist
% 
%    # first item
% 
%    # second item,
%       continuing on a new line
% 
% 
% *Here is a list with paragraph heading.* 
%   * item1
% 
%   * item2
% 
%% Here is a list with subsubsection heading
%   * item1
% 
%   * item2
% 
% !bquote
% Here are two lines that make up
% a block quote for testing _emphasized words_ and *boldface words*,
% also with hypens:
% _pre_-fix, post-_fix_, *pre*-fix, post-*fix*.
% !equote
% 
% Here are two references. Equation (ref{my:eq1}) is fine. Eq. (ref{my:eq1}) too.
% Even Equation (ref{my:eq1}) without the tilde.
% 
%% Subsection 1
% 
% % Refer to section/appendix etc. at the beginning of the line
% % and other special fix situations for HTML.
% 
% More text, with a reference back to
% the section "Section 1" and "Subsection 1", and further to the
% the sections "Subsection 1" and "URLs", which
% encourages you to do the tasks in "Problem 2: Flip a Coin" and "Exercise 10: Make references to projects and problems".
%  "Appendix: Just for testing; part I" and "Appendix: Just for testing; part II" are also nice elements.
% 
%% Test Section reference at beginning of line and after a sentence
% The section "Subsection 1" is fine.
% The section "URLs" too.
% 
% % sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console
% 
%% Computer code
% Let's do some copying from files too. First from subroutine up to the very end,
% 
%        subroutine test()
%        integer i
%        real*8 r
%        r = 0
%        do i = 1, i
%           r = r + i
%        end do
%        return
%  C     END1
%  
%        program testme
%        call test()
%        return
% and then just the subroutine,
%  
%        subroutine test()
%        integer i
%        real*8 r
%        r = 0
%        do i = 1, i
%           r = r + i
%        end do
%        return
% and finally the complete file with a plain text verbatim environment
% (|envir=ccq|):
%  C     a comment
%  
%        subroutine test()
%        integer i
%        real*8 r
%        r = 0
%        do i = 1, i
%           r = r + i
%        end do
%        return
%  C     END1
%  
%        program testme
%        call test()
%        return
% 
% Testing other code environments. First Python:
% 
!bc
%  !bc pycod
%  def f(x):
%      return x+1
%  !ec
% which gets rendered as
% 
%  def f(x):
%      return x+1
% 
% Test paragraph and subsubsection headings before
% before code.
% 
% *Paragraph heading before code.* 
%  import sys
%  sys.path.insert(0, os.pardir)
% 
%% Subsubsection heading before code
%  def h(z):
%      return z+1
% 
% Here is a program that is supposed to be interactive via
% Python Online Tutorial, but that service is not accessible
% for the present format.
% 
%  class Line:
%      def __init__(self, a, b):
%          self.a, self.b = a, b
%  
%      def __call__(self, x):
%          a, b = self.a, self.b
%          return a*x + b
%  
%  line = Line(2, 1)
%  y = line(x=3)
%  print(y)
% 
% Some more Python code (actually specified as a sage cell, but
% such cells are not supported by this format).
% 
%  a = 2
%  b = 3
%  print('a+b:', a + b)
%  
%  # In a sage cell we can also plot
%  from matplotlib.pyplot import *
%  from numpy import *
%  x = linspace(0, 4*pi, 101)
%  y = exp(-0.1*x)*cos(x)
%  plot(x, y)
%  xlabel('x'); ylabel('y')
%  show()
% 
% Then Cython (with -h option so it is hidden in html/sphinx):
% 
%  cpdef f(double x):
%      return x + 1
% 
% Standard Python shell sessions:
% 
%  >>> from numpy import linspace, sin
%  >>> # Some comment
%  >>> x = linspace(0, 2, 11)
%  >>> y = sin(x)
%  >>> y[0]
%  0
%  >>> import matplotlib.pyplot as plt
%  >>> plt.plot(x, y)
% 
% Similar IPython sessions:
% 
%  In [1]: from numpy import linspace, sin
%  In [2]: # Some comment
%  In [3]: x = linspace(0, 2, 11)
%  In [4]: y = sin(x)
%  In [5]: y[0]
%  Out[5]: 0
%  In [6]: import matplotlib.pyplot as plt
%  In [7]: plt.plot(x, y)
%  In [8]: a='multiple-\nline\noutput'
%  In [9]: a
%  Out[9]: 'multiple-\nline\noutput'
%  In [10]: print(a)
%  multiple-
%  line
%  output
% 
% Here is the interactive session again, but with |pyshell-t|.
% 
%  >>> from numpy import linspace, sin
%  >>> # Some comment
%  >>> x = linspace(0, 2, 11)
%  >>> y = sin(x)
%  >>> y[0]
%  0
%  >>> import matplotlib.pyplot as plt
%  >>> plt.plot(x, y)
% 
% % This one tests a + sign before a code environment
% C++:
%  #include <iostream>
%  
%  int main()
%  {
%     std::cout << "Sample output" << std::endl;
%     return 0
%  }
% % The next should get correctly typset in sphinx (cod is fcod)
% % It also tests emoji before code
% And a little bit of Fortran: :dizzy_face:
% 
!bc
%  !bc cod
%        subroutine midpt(x, length, a, b)
%        real*8 a, b, x
%        x = (a + b)/2
%        length = b - a
%        return
%        end
%  !ec
% which then is typeset as
% 
%        subroutine midpt(x, length, a, b)
%        real*8 a, b, x
%        x = (a + b)/2
%        length = b - a
%        return
%        end
% 
% HTML:
% 
%  <table>
%  <tr><td>Column 1</td><td>Column 2</td></tr>
%  <tr><td>0.67526 </td><td>0.92871 </td></tr>
%  <!-- comment -->
%  </table>
% 
% But inline HTML code is also important, like text that starts with
% |<a href="| (which can destroy the following text if not properly
% quoted).
% 
% Matlab with comments requires special typesetting:
% 
% Comment on the beginning of the line can be escaped by %%
if a > b
% Indented comment needs this trick
c = a + b
end
% 
% And here is a system call:
% 
%  Terminal> mkdir test
%  Terminal> cd test
%  Terminal> myprog -f
%  output1
%  output2
% 
% Any valid pygments lexer/language name can appear to, e.g.,
% 
!bc
%  !bc restructuredtext
%  =======
%  Heading
%  =======
%  
%  Some text.
%  !ec
% results in
% 
%  =======
%  Heading
%  =======
%  
%  Some text.
% 
% % Here goes hidden code.
% % Python can be treated by some formats, Fortran is always out.
% 
% 
% 
% Finally, |!bc do| supports highlighting of DocOnce source:
% 
%  ======= DocOnce test file =======
%  
%  ===== Computer code =====
%  
%  Inline verbatim code, as in `import numpy as np`, is allowed, as well as
%  code blocks:
%  
%  !bc pycod
%  from math import sin
%  
%  def f(x):
%      """Example on a function."""
%      return sin(x) + 1
%  
%  print(f(0))
%  !ec
%  
%  
%  ===== Mathematics =====
%  
%  Formulas can be inline, as in $\nabla\cdot\bm{u} = 0$, or typeset
%  as equations:
%  
%  !bt
%  \begin{align*}
%  \nabla\cdot\bm{u} &= 0,\\ 
%  \bm{u} &= \nabla\phi .
%  \end{align*}
%  !et
%  
%  === Subsubsection heading ===
%  
%  DocOnce files can have chapters, sections, subsections, and subsubsections.
%  
%  __Paragraph heading.__ Paragraphs may have headings.
% 
% It is time to test |verbatim inline font| especially with |a newline
% inside the text| and an exclamation mark at the end: |BEGIN|! For
% spellcheck, test |a verbatim expression| in |another| in a |third|.
% Also test exclamation mark as in |!bc| and |!ec| as well as |a != b|.
% Also test backslashes and braces like |\begin|, |\begin{enumerate}|,
% |\end{this}\end{that}|, and |{something \inside braces}|.
% 
% The following attempt to exemplify colored text does not work in
% format matlabnb.
% Here is some red color and an attempt to write with
% green color containing a linebreak
% code. Some formats will only display 
% this correctly when |html| 
% is the output format.
% But here some more running text is added which is not part of
% the previous blocks with line breaks.
% 
%% Running OS commands
%  Terminal> python -c 'print("Testing\noutput\nfrom\nPython.")'
%  Testing
%  output
%  from
%  Python.
% 
%% Footnotes
% Here is a test of footnotes [^footnote], which are handy in text.
% They are used in different flavors, now in
% 
%  * list items (note below that footnotes work after math, verbatim, and URLs - bin fact old and emphasize too!)
% 
%  * even with math $\nabla^2u$[^math1]
% 
%  * and code |h[i] += 1|[^code]
%    (_must_ have space between inline code and footnote!)
% 
%  * and links <https://google.com>[^google-search]
% 
% which gives flexibility in writing.
% This is the third[^example-of-the-third-footnote] example.
% 
%   [^footnote]: Typesetting of the footnote depends on the format.
% Plain text does nothing, LaTeX removes the
% definition and inserts the footnote as part of the LaTeX text.
% reStructuredText and Sphinx employ a similar type of typesetting
% as Extended Markdown and DocOnce, and in HTML we keep the same
% syntax, just displayed properly in HTML.
% [^math1]: Math footnotes can be dangerous since it
% interferes with an exponent.
% [^code]: One-line footnote.
% 
% [^google-search]: <google.com> is perhaps the most famous
% web site today.
% 
% Here is some more text before a new definition of a footnote that was
% used above.
% 
% !bnotice Non-breaking space character
% This paragraph aims to test non-breaking space character <https://en.wikipedia.org/wiki/Non-breaking_space>, and a typical
% example where this is needed is in physical units: 7.4 km is traveled
% in $7.4/5.5\approx 1.345$ s.  Also check that a link <https://google.com> is
% not broken across lines (drag the browser window to test this).
% (On the other hand, the tilde is used in
% computer code, e.g., as in |[~x for x in y]| or in |y=~x|, and should
% of course remain a tilde in those contexts.)
% !enotice
% 
%% Subsection 2: Testing figures
% 
% Test of figures. In particular we refer to Figure ref{fig:impact} in which
% there is a flow.
% 
% <<../doc/src/manual/fig/wave1D.png>>
% 
% Figures without captions are allowed and will be inlined.
% 
% <<../doc/src/manual/fig/wave1D.png>>
% 
% % Test multi-line caption in figure with sidecap=True
% 
% Here is figure ref{myfig} with a long (illegal) multi-line caption
% containing inline verbatim text:
% 
% <<../doc/src/manual/fig/wave1D.png>>
% 
% % Must be a blank line after MOVIE or FIGURE to detect this problem
% 
% Test URL as figure name:
% 
% <<https://raw.github.com/doconce/doconce/master/doc/src/blog/f_plot.png>>
% 
% % Test wikimedia type of files that otherwise reside in subdirs
% 
% *Remark.* Movies are tested in separate file |movies.do.txt|.
% 
% % Somewhat challenging heading with latex math, \t, \n, ? and parenthesis
% 
%% The $\theta$ parameter (not $\nabla$?)
% 
% Functions do not always need to be advanced, here is one
% involving $\theta$:
!bc
%  def f(theta):
%      return theta**2
% 
% *More on $\theta$.* Here is more text following headline with math.
% 
% Newcommands must also be tested in this test report:
% $\frac{1}{2}$, ${1/2}$, $\pmb{x}$, $\frac{Du}{dt}$,
% both inline and in block:
% 
% $$\frac{Du}{dt} &= 0\nonumber \\  \frac{1}{2} &= {1/2} \\  \frac{1}{2}\pmb{x} &= \pmb{n}$$
% 
% Or with align with label and numbers:
% 
% $$\frac{Du}{dt} &= 0  \\  \frac{1}{2} &= {1/2} \\  \frac{1}{2}\pmb{x} &= \pmb{n}$$
% 
% % Must test more complicated align and matrix compositions
% % where DocOnce inserts auto-numbered labels etc.
% 
% First one numbered (automatically):
% 
% $$\begin{pmatrix} G_2 + G_3 & -G_3 & -G_2 & 0 \\  -G_3 & G_3 + G_4 & 0 & -G_4 \\  -G_2 & 0 & G_1 + G_2 & 0 \\  0 & -G_4 & 0 & G_4 \end{pmatrix} &= \begin{pmatrix}  v_1 \\   v_2 \\   v_3 \\   v_4 \end{pmatrix} + \cdots   \\  \begin{pmatrix}  C_5 + C_6 & -C_6 & 0 & 0 \\   -C_6 & C_6 & 0 & 0 \\   0 & 0 & 0 & 0 \\   0 & 0 & 0 & 0 \end{pmatrix}   &= \frac{d}{dt}\begin{pmatrix}  v_1 \\   v_2 \\   v_3 \\   v_4 \end{pmatrix} + \begin{pmatrix}  0 \\   0 \\   0 \\   -i_0 \end{pmatrix} \nonumber  \end{align}$$
% 
% Second numbered (automatically):
% 
% $$\begin{pmatrix} G_1 + G_2\\  -G_3 & G_4 \end{pmatrix} &= \begin{pmatrix}  v_1 \\   v_2 \end{pmatrix} + \cdots\nonumber  \\  \left(\begin{array}{ll} y & 2\\  2 & 1 \end{array}\right) \left(\begin{array}{ll} 0 \\ x \end{array}\right) &= \begin{pmatrix} A \\ B \end{pmatrix}  \end{align}$$
% 
% Both numbered, with label by the user:
% 
% $$\begin{pmatrix} G_1 + G_2\\  -G_3 & G_4 \end{pmatrix} &= \begin{pmatrix}  v_1 \\   v_2 \end{pmatrix} + \cdots  \\   \left(\begin{array}{ll} y & 2\\  2 & 1 \end{array}\right) \left(\begin{array}{ll} 0 \\ x \end{array}\right) &= \begin{pmatrix} A \\ B \end{pmatrix} \end{align}$$
% Now we refer to Equations (mymatrix:eq1)-(mymatrix:eq2).
% 
%% Custom Environments
% 
% Here is an attempt to create a theorem environment via Mako
% (for counting theorems) and comment lines to help replacing lines in
% the |.tex| by proper begin-end LaTeX environments for theorems.
% Should look nice in most formats!
% 
% % begin theorem
% 
% *Theorem 5.* Let $a=1$ and $b=2$. Then $c=3$.
% % end theorem
% 
% % begin proof
% *Proof.* Since $c=a+b$, the result follows from straightforward addition.
% $\Diamond$
% % end proof
% 
% As we see, the proof of Theorem 5 is a modest
% achievement.
% 
%% Tables
% 
% % index with comma could fool sphinx
% 
% Let us take this table from the manual:
% 
% <table border="1">
% <thead>
% <tr><th align="center">time</th> <th align="center">velocity</th> <th align="center">acceleration</th> </tr>
% </thead>
% <tbody>
% <tr><td align="left">   0.0     </td> <td align="right">   1.4186      </td> <td align="right">   -5.01           </td> </tr>
% <tr><td align="left">   2.0     </td> <td align="right">   1.376512    </td> <td align="right">   11.919          </td> </tr>
% <tr><td align="left">   4.0     </td> <td align="right">   1.1E+1      </td> <td align="right">   14.717624       </td> </tr>
% </tbody>
% </table>
% The DocOnce source code reads
%  
%    |--------------------------------|
%    |time  | velocity | acceleration |
%    |--l--------r-----------r--------|
%    | 0.0  | 1.4186   | -5.01        |
%    | 2.0  | 1.376512 | 11.919       |
%    | 4.0  | 1.1E+1   | 14.717624    |
%    |--------------------------------|
%  
% 
% Here is yet another table to test that we can handle more than
% one table:
% 
% <table border="1">
% <thead>
% <tr><th align="left">time</th> <th align="left">velocity</th> <th align="left">acceleration</th> </tr>
% </thead>
% <tbody>
% <tr><td align="left">   0.0     </td> <td align="left">   1.4186      </td> <td align="left">   -5.01           </td> </tr>
% <tr><td align="left">   1.0     </td> <td align="left">   1.376512    </td> <td align="left">   11.919          </td> </tr>
% <tr><td align="left">   3.0     </td> <td align="left">   1.1E+1      </td> <td align="left">   14.717624       </td> </tr>
% </tbody>
% </table>
% And one with math headings (that are expanded and must be treated
% accordingly), verbatim heading and entry, and no space around the pipe
% symbol:
% 
% <table border="1">
% <thead>
% <tr><th align="center">$i$</th> <th align="center">$h_i$ </th> <th align="center">$\bar T_i$</th> <th align="center">|L_i|</th> </tr>
% </thead>
% <tbody>
% <tr><td align="left">   0      </td> <td align="right">   0         </td> <td align="right">   288           </td> <td align="right">   -0.0065        </td> </tr>
% <tr><td align="left">   1      </td> <td align="right">   11,000    </td> <td align="right">   216           </td> <td align="right">   0.0            </td> </tr>
% <tr><td align="left">   2      </td> <td align="right">   20,000    </td> <td align="right">   216           </td> <td align="right">   0.001          </td> </tr>
% <tr><td align="left">   3      </td> <td align="right">   32,000    </td> <td align="right">   228           </td> <td align="right">   0.0028         </td> </tr>
% <tr><td align="left">   4      </td> <td align="right">   47,000    </td> <td align="right">   270           </td> <td align="right">   0.0            </td> </tr>
% <tr><td align="left">   5      </td> <td align="right">   51,000    </td> <td align="right">   270           </td> <td align="right">   -0.0028        </td> </tr>
% <tr><td align="left">   6      </td> <td align="right">   71,000    </td> <td align="right">   214           </td> <td align="right">   |NaN|    </td> </tr>
% </tbody>
% </table>
% And add one with verbatim headings (with underscores),
% and rows starting with ||-| because of a negative number,
% and ||| right before and after verbatim word (with no space):
% 
% <table border="1">
% <thead>
% <tr><th align="center">exact</th> <th align="center">|v_1|</th> <th align="center">$a_i$ + |v_2|</th> <th align="center">|verb_3_|</th> </tr>
% </thead>
% <tbody>
% <tr><td align="right">   9        </td> <td align="right">   9.62           </td> <td align="right">   5.57                   </td> <td align="right">   8.98               </td> </tr>
% <tr><td align="right">   -20      </td> <td align="right">   -23.39         </td> <td align="right">   -7.65                  </td> <td align="right">   -19.93             </td> </tr>
% <tr><td align="right">   10       </td> <td align="right">   17.74          </td> <td align="right">   -4.50                  </td> <td align="right">   9.96               </td> </tr>
% <tr><td align="right">   0        </td> <td align="right">   -9.19          </td> <td align="right">   4.13                   </td> <td align="right">   -0.26              </td> </tr>
% </tbody>
% </table>
% Pipe symbols in verbatim and math text in tables used to pose difficulties,
% but not
% anymore (except for plain text and matlabnb).
% 
% Here is a table with X alignment:
% 
% <table border="1">
% <thead>
% <tr><th align="center"> Type</th> <th align="center">                                                                                                           Description                                                                                                            </th> </tr>
% </thead>
% <tbody>
% <tr><td align="center">   X        </td> <td align="left">   Alignment character that is used for specifying a potentially very long text in a column in a table. It makes use of the |tabularx| package in LaTeX, otherwise (for other formats) it means |l| (centered alignment).    </td> </tr>
% <tr><td align="center">   l,r,c    </td> <td align="left">   standard alignment characters                                                                                                                                                                                                         </td> </tr>
% </tbody>
% </table>
% Finally, a table with math
% and URLs.
% 
% % Mako code to expand URLs in the table
% % (These types of tables did not work before Jan 2014)
% 
% <table border="1">
% <tr></tr>
% <tbody>
% <tr><td align="center">   $\mathcal{L}=0$            </td> <td align="center">   080 <../doc/src/manual/mov/wave_frames/frame_0080.png>    </td> <td align="center">   085 <../doc/src/manual/mov/wave_frames/frame_0085.png>    </td> </tr>
% <tr><td align="center">   $a=b$                      </td> <td align="center">   090 <../doc/src/manual/mov/wave_frames/frame_0090.png>    </td> <td align="center">   095 <../doc/src/manual/mov/wave_frames/frame_0095.png>    </td> </tr>
% <tr><td align="center">   $\nabla\cdot\bm{u} =0 $    </td> <td align="center">   100 <../doc/src/manual/mov/wave_frames/frame_0100.png>    </td> <td align="center">   105 <../doc/src/manual/mov/wave_frames/frame_0105.png>    </td> </tr>
% </tbody>
% </table>
%% A test of verbatim words in heading with subscript $a_i$: |my_file_v1| and |my_file_v2|
% 
% *Paragraph with verbatim and math: |my_file_v1.py| and |my_file_v2.py| define some math $a_{i-1}$.* Here is more |__verbatim__| code and
% some plain text on a new line.
% 
% % Test various types of headlines
%% *Just bold*
% 
% Some text.
% 
%% _Just emphasize_
% 
% Some text.
% 
%% |Just verbatim|
% 
% Some text.
% 
%% *Bold* beginning
% 
% Some text.
% 
%% _Emphasize_ beginning
% 
% Some text.
% 
%% |Verbatim| beginning
% 
% Some text.
% 
%% Maybe *bold end*
% 
% Some text.
% 
%% Maybe _emphasize end_
% 
% Some text.
% 
%% Maybe |verbatim end|
% 
% Some text.
% 
%% The middle has *bold* word
% 
% Some text.
% 
%% The middle has _emphasize_ word
% 
% Some text.
% 
%% The middle has |verbatim| word
% 
% Some text.
% 
% *_Just emphasize_.* Some text.
% 
% *|Just verbatim|.* Some text.
% 
% *_Emphasize_ beginning.* Some text.
% 
% *|Verbatim beginning|.* Some text.
% 
% *Maybe _emphasize end_.* Some text.
% 
% *Maybe |verbatim end|.* Some text.
% 
% *The middle has _emphasize_ word.* Some text.
% 
% *The middle has |verbatim| word.* Some text.
% 
% *Ampersand.* We can test Hennes & Mauritz, often abbreviated H&M, but written
% as |Hennes & Mauritz| and |H & M|.
% A sole |&| must also work.
% % Note: substitutions must not occur inside verbatim, just in ordinary text.
% 
!bc
%  # Just to check that ampersand works in code blocks:
%  c = a & b
% 
% *Quotes.* Let us also add a test of quotes such as "double quotes, with numbers
% like 3.14 and newline/comma and hyphen (as in double-quote)"; written
% in the standard LaTeX-style that gives correct LaTeX formatting and
% ordinary double quotes for all non-LaTeX formats.  Here is another
% sentence that "caused" a bug in the past because double backtick
% quotes could imply verbatim text up to a verbatim word starting with
% period, like |.txt|.
% 
% More quotes to be tested for spellcheck:
% ("with parenthesis"), "with newline"
% and "with comma", "hyphen"-wise, and "period".
% 
%% Bibliography test
% 
% Here is an example: [1] discussed propagation of
% large destructive water waves, [2] gave
% an overview of numerical methods for solving the Navier - Stokes equations,
% while the use of Backward Kolmogorov equations for analyzing
% random vibrations was investigated in [3].
% The book chapter [4] contains information on
% C++ software tools for programming multigrid methods. A real retro
% reference is [5] about a big FORTRAN package.
% Multiple references are also possible, e.g., see
% [1] [4].
% 
% We need to cite more than 10 papers to reproduce an old formatting
% problem with blanks in the keys in reST format:
% [6] [3] [7] [1]
% and
% [2] [8] [9] [10] [11] [12] [13]
% and all the work of
% [14] [4] [15] as well as
% old work [5] and [16], and the
% talk [17].
% Langtangen also had two thesis [18] [16]
% back in the days.
% More retro citations are
% the old ME-IN323 book [19] and the
% [20] OONSKI '94 paper.
% 
% % --- begin exercise ---
% 
%% Example 1: Examples can be typeset as exercises
% 
% Examples can start with a subsection heading starting with |Example:|
% and then, with the command-line option |--examples_as_exercises| be
% typeset as exercises. This is useful if one has solution
% environments as part of the example.
% 
% *a)* State some problem.
% 
% *Solution.* The answer to this subproblem can be written here.
% 
% *b)* State some other problem.
% 
% *Hint 1.* A hint can be given.
% 
% *Hint 2.* Maybe even another hint?
% 
% *Solution.* The answer to this other subproblem goes here,
% maybe over multiple doconce input lines.
% 
% % --- end exercise ---
% 
%% User-defined environments
% 
% The example in the section "Example 1: A test function" demonstrates how to write a test function.
% That is, a special test function for a function |add| appears in
% the example in the section "Example 1: A test function".
% 
%% Example 1: A test function
% 
% Suppose we want to write a test function for checking the
% implementation of a Python function for addition.
% 
%  def add(a, b):
%      return a + b
%  
%  def test_add():
%      a = 1; b = 1
%      expected = a + b
%      computed = add(a, b)
%      assert expected == computed
% 
%% Example 2: Addition
% 
% We have
% 
% $$1 + 1 = 2$$
% or in tabular form:
% 
% <table border="1">
% <thead>
% <tr><th align="center">Problem</th> <th align="center">Result</th> </tr>
% </thead>
% <tbody>
% <tr><td align="center">   $1+1$      </td> <td align="center">   $2$       </td> </tr>
% </tbody>
% </table>
% !bnotice Highlight box!
% This environment is used to highlight something:
% 
% $$E = mc^2$$
% !enotice
% 
%% URLs
% 
% Testing of URLs: hpl's home page hpl <https://folk.uio.no/hpl>, or
% the entire URL if desired, <https://folk.uio.no/hpl>.  Here is a
% plain file link <testdoc.do.txt>, or <testdoc.do.txt>, or
% <testdoc.do.txt> or <testdoc.do.txt> or a link with
% newline <testdoc.do.txt>. Can test spaces with the link with word
% too: hpl <https://folk.uio.no/hpl> or hpl <https://folk.uio.no/hpl>. Also |file:///| works: link to a
% file <file:///home/hpl/vc/doconce/doc/demos/manual/manual.html> is
% fine to have. Moreover, "loose" URLs work, i.e., no quotes, just
% the plain URL as in <https://folk.uio.no/hpl>, if followed by space, comma,
% colon, semi-colon, question mark, exclamation mark, but not a period
% (which gets confused with the periods inside the URL).
% 
% Mail addresses can also be used: hpl@simula.no <mailto:hpl@simula.no>, or just a mail link <mailto:hpl@simula.no>, or a raw <mailto:hpl@simula.no>.
% 
% Here are some tough tests of URLs, especially for the |latex| format:
% Newton-Cotes <https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas> formulas
% and a good book <https://www.springer.com/mathematics/computational+science+%26+engineering/book/978-3-642-23098-1>. Need to test
% Newton-Cotes with percentage in URL too:
% <https://en.wikipedia.org/wiki/Newton%E2%80%93Cotes_formulas>
% and <https://en.wikipedia.org/wiki/Newton-Cotes#Open_Newton.E2.80.93Cotes_formulae> which has a shebang.
% 
% For the |--device=paper| option it is important to test that URLs with
% monospace font link text get a footnote
% (unless the |--latex_no_program_footnotelink|
% is used), as in this reference to
% decay_mod <https://github.com/hplgit/INF5620/tree/gh-pages/src/decay/experiments/decay_mod.py>, ball1.py <https://tinyurl.com/pwyasaa/formulas.ball1.py>,
% and ball2.py <https://tinyurl.com/pwyasaa/formulas.ball2.py>.
% 
% % Comments should be inserted outside paragraphs (because in the rst
% % format extra blanks make a paragraph break).
% 
% % Note that when there is no https: or file:, it can be a file link
% % if the link name is URL, url, "URL", or "url". Such files should,
% % if rst output is desired, but placed in a |_static*| folder.
% 
% More tough tests: repeated URLs whose footnotes when using the
% |--device=paper| option must be correct. We have
% google <https://google.com>, google <https://google.com>, and
% google <https://google.com>, which should result in exactly three
% footnotes.
% 
% % !split and check if these extra words are included properly in the comment
% 
%% LaTeX Mathematics
% 
% Here is an equation without label using backslash-bracket environment:
% $$a = b + c$$
% 
% or with number and label, as in Equation (my:eq1), using the equation environment:
% 
% $${\partial u\over\partial t} = \nabla^2 u$$
% 
% We can refer to this equation by Equation (my:eq1).
% 
% Here is a system without equation numbers, using the align-asterisk environment:
% 
% $$\begin{align*} \pmb{a} &= \pmb{q}\times\pmb{n} \\  b &= \nabla^2 u + \nabla^4 v \end{align*}$$
% 
% More mathematical typesetting is demonstrated in the coming exercises.
% 
% Below, we have "Problem 2: Flip a Coin" and "Project 4: Compute a Probability",
% as well as "Project 5: Explore Distributions of Random Circles" and "Project 11: References to Project ref{demo:ex:2} in a heading works for matlabnb", and in
% between there we have "Exercise 10: Make references to projects and problems".
% 
%% Exercises
% 
% % --- begin exercise ---
% 
%% Problem 2: Flip a Coin
% 
% % keywords = random numbers; Monte Carlo simulation; ipynb
% 
% % Torture tests
% 
% *a)* Make a program that simulates flipping a coin $N$ times.
% Print out "tail" or "head" for each flip and
% let the program count the number of heads.
% 
% % --- begin hint in exercise ---
% 
% *Hint 1.* Use |r = random.random()| and define head as |r <= 0.5|.
% 
% % --- end hint in exercise ---
% 
% % --- begin hint in exercise ---
% 
% *Hint 2.* Draw an integer among $\{1,2\}$ with
% |r = random.randint(1,2)| and define head when |r| is 1.
% 
% % --- end hint in exercise ---
% 
% % --- begin answer of exercise ---
% *Answer.* If the |random.random()| function returns a number $<1/2$, let it be
% head, otherwise tail. Repeat this $N$ number of times.
% % --- end answer of exercise ---
% 
% % --- begin solution of exercise ---
*Solution.*
%  import sys, random
%  N = int(sys.argv[1])
%  heads = 0
%  for i in range(N):
%      r = random.random()
%      if r <= 0.5:
%          heads += 1
%  print('Flipping a coin %d times gave %d heads' % (N, heads))
% % --- end solution of exercise ---
% 
% *b)* Vectorize the code in a) using boolean indexing.
% 
% Vectorized code can be written in many ways.
% Sometimes the code is less intuitive, sometimes not.
% At least there is not much to find in the section "Section 1".
% 
% *c)* Vectorize the code in a) using |numpy.sum|.
% 
% % --- begin answer of exercise ---
% *Answer.* |np.sum(np.where(r <= 0.5, 1, 0))| or |np.sum(r <= 0.5)|.
% % --- end answer of exercise ---
% 
% In this latter subexercise, we have an
% example where the code is easy to read.
% 
%% My remarks
% Remarks with such a subsubsection is treated as more text
% after the last subexercise. Test a list too:
% 
% # Mark 1.
% 
% # Mark 2.
% 
% Filenames: |flip_coin.py|, |flip_coin.pdf|.
% 
% % Closing remarks for this Problem
% 
%% Remarks
% These are the exercise remarks, appearing at the very end.
% 
% % solution files: mysol.txt, mysol_flip_coin.py, yet_another.file
% 
% % --- end exercise ---
% 
%% Not an exercise
% 
% Should be possible to stick a normal section in the middle of many
% exercises.
% 
% % --- begin exercise ---
% 
%% Exercise 3: Test of plain text exercise
% 
% Very short exercise. What is the capital
% of Norway?
% Filename: |myexer1|.
% 
% % --- end exercise ---
% 
% % --- begin exercise ---
% 
%% Project 4: Compute a Probability
% 
% % Minimalistic exercise
% 
% What is the probability of getting a number between 0.5 and 0.6 when
% drawing uniformly distributed random numbers from the interval $[0,1)$?
% 
% At the end we have a list because that caused problems in LaTeX
% in previous DocOnce versions:
% 
% # item1
% 
% # item2
% 
% % --- begin hint in exercise ---
% 
% *Hint.* To answer this question empirically, let a program
% draw $N$ such random numbers using Python's standard |random| module,
% count how many of them, $M$, that fall in the interval $(0.5,0.6)$, and
% compute the probability as $M/N$.
% 
% % --- end hint in exercise ---
% 
% % --- end exercise ---
% 
% % --- begin exercise ---
% 
%% Project 5: Explore Distributions of Random Circles
% 
% % keywords = ipynb
% 
% The formula for a circle is given by
% 
% $$x &= x_0 + R\cos 2\pi t, \\  y &= y_0 + R\sin 2\pi t,$$
% where $R$ is the radius of the circle, $(x_0,y_0)$ is the
% center point, and $t$ is a parameter in the unit interval $[0,1]$.
% For any $t$, $(x,y)$ computed from Equations (circle:x)-(circle:y)
% is a point on the circle.
% The formula can be used to generate |n| points on a circle:
% 
%  import numpy as np
%  
%  def circle(R, x0, y0, n=501):
%      t = np.linspace(0, 1, n)
%      x = x0 + R*np.cos(2*np.pi*t)
%      y = y0 + R*np.sin(2*np.pi*t)
%      return x, y
%  
%  x, y = circle(2.0, 0, 0)
% 
% % Often in an exercise we have some comments about the solution
% % which we normally want to keep where they are.
% 
% The goal of this project is to draw $N$ circles with random
% center and radius. Plot each circle using the |circle| function
% above.
% 
% *a)* Let $R$ be normally distributed and $(x_0,y_0)$ uniformly distributed.
% 
% % --- begin hint in exercise ---
% 
% *Hint.* Use the |numpy.random| module to draw the
% $x_0$, $y_0$, and $R$ quantities.
% 
% % --- end hint in exercise ---
% 
% % --- begin answer of exercise ---
% *Answer.* Here goes the short answer to part a).
% % --- end answer of exercise ---
% 
% % --- begin solution of exercise ---
% *Solution.* Here goes a full solution to part a).
% % --- end solution of exercise ---
% 
% *b)* Let $R$ be uniformly distributed and $(x_0,y_0)$ normally distributed.
% Filename: |norm|.
% 
% *c)* Let $R$ and $(x_0,y_0)$ be normally distributed.
% 
% Filename: |circles|.
% 
% % Closing remarks for this Project
% 
%% Remarks
% At the very end of the exercise it may be appropriate to summarize
% and give some perspectives.
% 
% % --- end exercise ---
% 
% % --- begin exercise ---
% 
%% Exercise 6: Determine some Distance
% 
% Intro to this exercise. Questions are in subexercises below.
% 
% % --- begin solution of exercise ---
% *Solution.* Here goes a full solution of the whole exercise.
% With some math $a=b$ in this solution:
% $$\hbox{math in solution: } a = b$$
% And code |a=b| in this solution:
!bc
%  a = b  # code in solution
% End of solution is here.
% 
% % --- end solution of exercise ---
% 
% *a)* Subexercises are numbered a), b), etc.
% 
% % --- begin hint in exercise ---
% 
% *Hint 1.* First hint to subexercise a).
% With math $a=b$ in hint:
% 
% $$a=b.$$
% And with code (in plain verbatim) returning $x+1$ in hint:
% 
!bc
%  def func(x):
%      return x + 1  # with code in hint
% 
% % --- end hint in exercise ---
% 
% % --- begin hint in exercise ---
% 
% *Hint 2.* Second hint to subexercise a).
% 
% Test list in hint:
% 
% # item1
% 
% # item2
% 
% % --- end hint in exercise ---
% Filename: |subexer_a.pdf|.
% 
% % --- begin answer of exercise ---
% *Answer.* Short answer to subexercise a).
% With math in answer: $a=b$.
% % --- end answer of exercise ---
% 
% *b)* Here goes the text for subexercise b).
% 
% Some math $\cos^2 x + \sin^2 x = 1$ written one a single line:
% 
% $$\cos^2 x + \sin^2 x = 1 \thinspace .$$
% 
% % --- begin hint in exercise ---
% 
% *Hint.* A hint for this subexercise.
% 
% % --- end hint in exercise ---
% Filename: |subexer_b.pdf|.
% 
% % --- begin solution of exercise ---
% *Solution.* Here goes the solution of this subexercise.
% % --- end solution of exercise ---
% 
% % No meaning in this weired test example:
% The text here belongs to the main (intro) part of the exercise. Need
% closing remarks to have text after subexercises.
% 
% Test list in exercise:
% 
% # item1
% 
% # item2
% % Closing remarks for this Exercise
% 
%% Remarks
% Some final closing remarks, e.g., summarizing the main findings
% and their implications in other problems can be made. These
% remarks will appear at the end of the typeset exercise.
% 
% % --- end exercise ---
% 
% % --- begin exercise ---
% 
%% Some exercise without the "Exercise:" prefix
% 
% % Another minimalistic exercise
% 
% Just some text. And some math saying that $e^0=1$ on a single line,
% to test that math block insertion is correct:
% 
% $$\exp{(0)} = 1$$
% 
% And a test that the code |lambda x: x+2| is correctly placed here:
% 
!bc
%  lambda x: x+2
% 
% % Have some comments at the end of the exercise to see that
% % the Filename: ... is written correctly.
% % --- end exercise ---
% 
% % --- begin exercise ---
% 
%% Exercise 8: Solution of differential equation
% 
% % --- begin quiz ---
% % --- quiz heading: SOlution of differential equation
% % --- previous heading type: exercise
% % --- keywords: ['derivatives', 'exponential function', 'equation, differential', 'differential equation']
% 
% % --- begin quiz question ---
% Given
% 
% $$\frac{dy}{dx} = -y(x),\quad y(0)=1$$
% What is the solution of this equation?
% % --- end quiz question ---
% % --- label: quiz:diff:eq1
% 
% % --- begin quiz choice 1 (right) ---
% $y=e^{-y}$
% % --- end quiz choice 1 (right) ---
% 
% % --- begin quiz choice 2 (wrong) ---
% $y=e^{y}$
% % --- end quiz choice 2 (wrong) ---
% 
% % --- begin explanation of choice 2 ---
% Almost, but the sign is wrong (note the minus!).
% % --- end explanation of choice 2 ---
% 
% % --- begin quiz choice 3 (wrong) ---
%  from math import exp
%  def f(x):
%      return exp(x)
% % --- end quiz choice 3 (wrong) ---
% 
% % --- begin explanation of choice 3 ---
% Ooops, forgot a minus: |exp(-x)|, otherwise this Python code
% must be considered as a good answer. It is more natural,
% though, to write the solution to the problem
% in mathematical notation:
% 
% $$y(x) = e^{-y}.$$
% % --- end explanation of choice 3 ---
% 
% % --- begin quiz choice 4 (wrong) ---
% The solution cannot be found because there is a derivative in the equation.
% % --- end quiz choice 4 (wrong) ---
% 
% % --- begin explanation of choice 4 ---
% Equations with derivatives can be solved;
% they are termed _differential
% equations_.
% % --- end explanation of choice 4 ---
% 
% % --- begin quiz choice 5 (wrong) ---
% The equation is meaningless: an equation must be an equation
% for $x$ or $y$, not a function $y(x)$.
% % --- end quiz choice 5 (wrong) ---
% 
% % --- begin explanation of choice 5 ---
% Equations where the unknown is a function, as $y(x)$
% here, are called _differential equations_, and are solved by
% special techniques.
% % --- end explanation of choice 5 ---
% % --- end quiz ---
% 
% % --- end exercise ---
% 
% % --- begin exercise ---
% 
%% Example 9: Just an example
% 
% % This example needs the --examples_as_exercises option, otherwise
% % it is just typeset as it is written.
% 
% *a)* What is the capital of Norway?
% 
% *Answer.* Oslo.
% 
% % --- end exercise ---
% 
%% Here goes another section
% 
% With some text, before we continue with exercises.
% 
%% More Exercises
% 
% % --- begin exercise ---
% 
%% Exercise 10: Make references to projects and problems
% 
% % Test comments not at the end only
% Pick a statement from "Project 5: Explore Distributions of Random Circles" or "Problem 2: Flip a Coin"
% and verify it.
% 
% Test list at the end of an exercise without other elements (like subexercise,
% hint, etc.):
% 
% # item1
% 
% # item2
% 
% Filename: |verify_formula.py|.
% 
% % --- end exercise ---
% 
% % --- begin exercise ---
% 
%% Project 11: References to "Project 4: Compute a Probability" in a heading works for matlabnb
% 
% Refer to the previous exercise as "Exercise 10: Make references to projects and problems",
% the two before that as "Project 4: Compute a Probability" and "Project 5: Explore Distributions of Random Circles",
% and this one as "Project 11: References to Project ref{demo:ex:2} in a heading works for matlabnb".
% Filename: |selc_composed.pdf|.
% 
% % --- end exercise ---
% 
%% References
% 
%  # *H. P. Langtangen and G. Pedersen*. 
%     Propagation of Large Destructive Waves,
%     _International Journal of Applied Mechanics and Engineering_,
%     7(1),
%     pp. 187-204,
%     2002.
% 
%  # *H. P. Langtangen, K.-A. Mardal and R. Winther*. 
%     Numerical Methods for Incompressible Viscous Flow,
%     _Advances in Water Resources_,
%     25,
%     pp. 1125-1146,
%     2002.
% 
%  # *H. P. Langtangen*. 
%     Numerical Solution of First Passage Problems in Random Vibrations,
%     _SIAM Journal of Scientific and Statistical Computing_,
%     15,
%     pp. 997-996,
%     1994.
% 
%  # *K.-A. Mardal, G. W. Zumbusch and H. P. Langtangen*. 
%     Software Tools for Multigrid Methods,
%     _Advanced Topics in Computational Partial Differential Equations -- Numerical Methods and Diffpack Programming_,
%     edited by *H. P. Langtangen and A. Tveito*,
%     Springer,
%     2003,
%     Edited book,
%     <http://some.where.org>.
% 
%  # *H. P. Langtangen*. 
%     The FEMDEQS Program System,
%     _Department of Mathematics, University of Oslo_,
%     1989,
%     <http://www.math.uio.no/old/days/hpl/femdeqs.pdf>.
% 
%  # *H. P. Langtangen*. 
%     Stochastic Breakthrough Time Analysis of an Enhanced Oil Recovery Process,
%     _SIAM Journal on Scientific Computing_,
%     13,
%     pp. 1394-1417,
%     1992.
% 
%  # *M. Mortensen, H. P. Langtangen and G. N. Wells*. 
%     A FEniCS-Based Programming Framework for Modeling Turbulent Flow by the Reynolds-Averaged Navier-Stokes Equations,
%     _Advances in Water Resources_,
%     34(9),
%     doi: 10.1016/j.advwatres.2011.02.013 <https://dx.doi.org/10.1016/j.advwatres.2011.02.013>,
%     2011.
% 
%  # *S. Glimsdal, G. Pedersen, K. Atakan, C. B. Harbitz, H. P. Langtangen and F. L\ovholt*. 
%     Propagation of the Dec. 26, 2004 Indian Ocean Tsunami: Effects of Dispersion and Source Characteristics,
%     _International Journal of Fluid Mechanics Research_,
%     33(1),
%     pp. 15-43,
%     2006.
% 
%  # *S. Rahman, J. Gorman, C. H. W. Barnes, D. A. Williams and H. P. Langtangen*. 
%     Numerical Investigation of a Piezoelectric Surface Acoustic Wave Interaction With a One-Dimensional Channel,
%     _Physical Review B: Condensed Matter and Materials Physics_,
%     74,
%     2006,
%     035308.
% 
% # *J. B. Haga, H. Osnes and H. P. Langtangen*. 
%     On the Causes of Pressure Oscillations in Low-Permeable and Low-Compressible Porous Media,
%     _International Journal of Analytical and Numerical Methods in Geomechanics_,
%     doi: 10.1002/nag.1062 <https://dx.doi.org/10.1002/nag.1062>,
%     2011,
%     <http://onlinelibrary.wiley.com/doi/10.1002/nag.1062/abstract>.
% 
% # *H. P. Langtangen*. 
%     _Computational Partial Differential Equations - Numerical Methods and Diffpack Programming_,
%     second edition,
%     _Texts in Computational Science and Engineering_,
%     Springer,
%     2003.
% 
% # *H. P. Langtangen*. 
%     _Python Scripting for Computational Science_,
%     third edition,
%     _Texts in Computational Science and Engineering_,
%     Springer,
%     2008.
% 
% # *H. P. Langtangen and G. Pedersen*. 
%     Finite Elements for the Boussinesq Wave Equations,
%     Waves and Non-linear Processes in Hydrodynamics,
%     edited by *J. Grue, B. Gjevik and J. E. Weber*,
%     Kluwer Academic Publishers,
%     pp. pp. 117-126,
%     1995,
%     <http://www.amazon.ca/Waves-Nonlinear-Processes-Hydrodynamics-John/dp/0792340310>.
% 
% # *H. P. Langtangen*. 
%     _A Primer on Scientific Programming With Python_,
%     third edition,
%     _Texts in Computational Science and Engineering_,
%     Springer,
%     2012.
% 
% # *P. V. Jeberg, H. P. Langtangen and C. B. Terp*. 
%     Optimization With Diffpack: Practical Example From Welding,
%     _Simula Research Laboratory_,
%     2004,
%     Internal report.
% 
% # *H. P. Langtangen*. 
%     Computational Methods for Two-Phase Flow in Oil Reservoirs,
%     Ph.D. Thesis,
%     Mechanics Division, Department of Mathematics, University of Oslo,
%     1989,
%     Dr. Scient. thesis..
% 
% # *H. P. Langtangen*. 
%     Computational Modeling of Huge Tsunamis From Asteroid Impacts,
%     2007,
%     Invited keynote lecture at the \emphInternational conference on Computational Science 2007 (ICCS'07), Beijing, China.
% 
% # *H. P. Langtangen*. 
%     Solution of the Navier-Stokes Equations With the Finite Element Method in Two and Three Dimensions,
%     M.Sc. Thesis,
%     Mechanics Division, Department of Mathematics, University of Oslo,
%     1985,
%     Cand.Scient. thesis.
% 
% # *H. P. Langtangen and A. Tveito*. 
%     Numerical Methods in Continuum Mechanics,
%     _Center for Industrial Research_,
%     1991,
%     Lecture notes for a course (ME-IN 324). 286 pages..
% 
% # *H. P. Langtangen*. 
%     Diffpack: Software for Partial Differential Equations,
%     _Proceedings of the Second Annual Object-Oriented Numerics Conference (OON-SKI'94), Sunriver, Oregon, USA_,
%     edited by *A. Vermeulen*,
%     1994.
% 
%% Appendix: Just for testing; part I
% 
% This is the first appendix.
% 
%% A subsection within an appendix
% 
% Some text.
% 
%% Appendix: Just for testing; part II
% 
% This is more stuff for an appendix.
% 
%% Appendix: Testing identical titles
% 
% Without label.
% 
%% Appendix: Testing identical titles
% 
% With label.
% 
%% Appendix: Testing identical titles
% 
% What about inserting a quiz?
% 
% % --- begin quiz ---
% % --- new quiz page: Test of quizzes
% % --- quiz heading: Capital of Norway
% % --- previous heading type: subsection
% % --- keywords: ['capitals', 'basic intelligence', 'geography']
% 
% % --- begin quiz question ---
% [Fundamental test:] What is the capital of Norway?
% % --- end quiz question ---
% 
% % --- begin quiz choice 1 (wrong) ---
% [Answer 1:] Stockholm
% % --- end quiz choice 1 (wrong) ---
% 
% % --- begin explanation of choice 1 ---
% Stockholm is the capital of Sweden.
% % --- end explanation of choice 1 ---
% 
% % --- begin quiz choice 2 (wrong) ---
% [Answer 2:] London
% % --- end quiz choice 2 (wrong) ---
% 
% % --- begin quiz choice 3 (right) ---
% [Answer 3:] Oslo
% % --- end quiz choice 3 (right) ---
% 
% % --- begin quiz choice 4 (wrong) ---
% Bergen
% % --- end quiz choice 4 (wrong) ---
% 
% % --- begin explanation of choice 4 ---
% Those from Bergen would claim so, but nobody else.
% % --- end explanation of choice 4 ---
% % --- end quiz ---
% 
%% Appendix: Testing identical titles
% 
% Without label.
% 
% !bnotice Tip
% Here is a tip or hint box, typeset as a notice box.
% !enotice
% 
% Need a lot of text to surround the summary box.
% Version control systems allow you to record the history of files
% and share files among several computers and collaborators in a
% professional way. File changes on one computer are updated or
% merged with changes on another computer. Especially when working
% with programs or technical reports it is essential
% to have changes documented and to
% ensure that every computer and person involved in the project
% have the latest updates of the files.
% Greg Wilson' excellent Script for Introduction to Version Control <https://software-carpentry.org/2010/07/script-for-introduction-to-version-control/> provides a more detailed motivation why you will benefit greatly
% from using version control systems.
% 
% !bsummary
% *Bold remark:* Make some text with this summary.
% Much testing in this document, otherwise stupid content.
% Much testing in this document, otherwise stupid content.
% Much testing in this document, otherwise stupid content.
% Much testing in this document, otherwise stupid content.
% Much testing in this document, otherwise stupid content.
% Much testing in this document, otherwise stupid content.
% Much testing in this document, otherwise stupid content.
% Much testing in this document, otherwise stupid content.
% Much testing in this document, otherwise stupid content.
% !esummary
% 
% Projects that you want to share among several computers or project
% workers are today most conveniently stored at some web site "in the
% cloud" and updated through communication with that site. I strongly
% recommend you to use such sites for all serious programming and
% scientific writing work - and all other important files.
% 
% The simplest services for hosting project files are Dropbox <https://dropbox.com> and Google Drive <https://drive.google.com>.
% It is very easy to get started with these systems, and they allow you
% to share files among laptops and mobile units with as many users as
% you want. The systems offer a kind of version control in that the
% files are stored frequently (several times per minute), and you can go
% back to previous versions for the last 30 days. However, it is
% challenging  to find the right version from the past when there are
% so many of them.
% 
% More seriously, when several people may edit files simultaneously, it
% can be difficult detect who did what when, roll back to previous
% versions, and to manually merge the edits when these are
% incompatible. Then one needs more sophisticated tools than Dropbox or
% Google Drive: project hosting services with true version control
% systems.  The following text aims at providing you with the minimum
% information to started with such systems. Numerous other tutorials
% contain more comprehensive material and in-depth explanations of the
% concepts and tools.
% 
% The idea with project hosting services is that you have the files
% associated with a project in the cloud. Many people may share these
% files.  Every time you want to work on the project you explicitly
% update your version of the files, edit the files as you like, and
% synchronize the files with the "master version" at the site where the
% project is hosted.  If you at some point need to go back to a
% version of the files at some particular point in the past,
% this is an easy operation. You can also use tools to see
% what various people have done with the files in the various versions.
% 
% All these services are very similar. Below we describe how you get
% started with Bitbucket, GitHub, and Googlecode. Launchpad works very
% similarly to the latter three. All the project hosting services have
% excellent introductions available at their web sites, but the recipes
% below are much shorter and aim at getting you started as quickly as
% possible by concentrating on the most important need-to-know steps.
% The Git tutorials we refer to later in this document contain more
% detailed information and constitute of course very valuable readings
% when you use version control systems every day. The point now is
% to get started.
% 
%% Appendix: Testing inline comments
% 
% % Names can be [ A-Za-z0-9_'+-]+
% 
% Projects that you want to share among several computers or project
% workers are today most conveniently stored at some web site "in the
% cloud" and updated through communication with that
% site. [hpl's semi opinion 1: not sure if in the cloud is
% understood by
% all.] I strongly recommend you to use such sites for all serious
% programming and scientific writing work - and all other important
% files.
% 
% The simplest services for hosting project files is Dropbox. [mp 2: Simply go to <https://dropbox.com> and watch the video. It explains
% how files, like |myfile.py|, perhaps containing much math, like
% $\partial u/\partial t$, are easily communicated between machines.] It
% is very easy to get started with Dropbox, and it allows you to share
% files among [hpl 3: laptops and mobile units -> computers, tablets,
% and phones].
% 
% % Test horizontal rule
% 
% ------
% 
% % Coments for editing
% 
% First[add 4: ,] consider a quantity $Q$. [edit 5: To this end, -> We note that]
% $Q>0$, because [del 6: a] negative [edit 7: quantity is -> quantities
% are] [del 8: just] negative. [add 9: This comes as no surprise.]
% 
% % Test tailored latex figure references with page number
% Let us refer to Figure ref{fig:impact} again.
% 
% Test references in a list:
% 
%  * "Section 1"
% 
%  * "Subsection 1"
% 
%  * ref{fig:impact}
% 
%% Appendix: Testing headings ending with |verbatim inline|
% 
% The point here is to test 1) |verbatim| code in headings, and 2)
% ending a heading with verbatim code as this triggers a special
% case in LaTeX.
% 
% We also test mdash---used as alternative to hyphen without spaces around,
% or in quotes:
% 
% !bquote
% _Fun is fun_.---Unknown.
% !equote
% 
% The ndash should also be tested - as in the Hanson - Nilson equations
% on page 277 - 278.
% 
% And finally, what about admons, quotes, and boxes? They are tested
% in a separate document: |admon.do.txt|.
% 
% [^example-of-the-third-footnote]: Not much to add here, but the footnote
% is at the end with only one newline.

************** File: testdoc.tmp *****************
label{subsec1}

idx{`somefunc` function}

# Refer to section/appendix etc. at the beginning of the line
# and other special fix situations for HTML.

More text, with a reference back to
Section ref{sec1} and ref{subsec1}, and further to the
sections    ref{subsec1} and ref{subsubsec:ex}, which
encourages you to do the tasks in the
Exercises ref{demo:ex:1} and ref{exer:some:formula}.
Appendices     ref{app1} and ref{app2} are also nice elements.

=== Test Section reference at beginning of line and after a sentence ===

Section ref{subsec1} is fine.
Section ref{subsubsec:ex} too.


# sphinx code-blocks: pycod=python cod=fortran cppcod=c++ sys=console

=== Computer code ===

Let's do some copying from files too. First from subroutine up to the very end,

@@@CODE ../doc/src/manual/__testcode.f fromto: subroutine@
===== Project: Compute a Probability =====

# Minimalistic exercise

label{demo:ex:2}

What is the probability of getting a number between 0.5 and 0.6 when
Could not find match for from regex "\*\s+\$.+normally"

************** File: .testdoc.exerinfo *****************
# Information about all exercises in the file testdoc.do.txt.
# The information can be loaded into a Python list of dicts by
#
# f = open('.testdoc.exerinfo', 'r')
# exer = eval(f.read())
#
[{'ans_docend': '',
  'answer': '',
  'chapter_exercise': None,
  'chapter_no': None,
  'chapter_title': None,
  'chapter_type': None,
  'closing_remarks': '',
  'file': None,
  'heading': '=====',
  'hints': [],
  'keywords': None,
  'label': 'Example',
  'no': 1,
  'sol_docend': '',
  'solution': '',
  'solution_file': None,
  'subex': [{'ans_docend': '',
             'answer': '',
             'file': None,
             'hints': [],
             'sol_docend': '',
             'solution': 'The answer to this subproblem can be written here.',
             'text': 'State some problem.'},
            {'ans_docend': '',
             'answer': '',
             'file': None,
             'hints': ['A hint can be given.', 'Maybe even another hint?'],
             'sol_docend': '',
             'solution': 'The answer to this other subproblem goes here,\n'
                         'maybe over multiple doconce input lines.',
             'text': 'State some other problem.'}],
  'text': 'Examples can start with a subsection heading starting with '
          '`Example:`\n'
          'and then, with the command-line option `--examples_as_exercises` '
          'be\n'
          'typeset as exercises. This is useful if one has solution\n'
          'environments as part of the example.',
  'title': 'Examples can be typeset as exercises',
  'type': 'Example',
  'type_visible': True},
 {'ans_docend': '',
  'answer': '',
  'chapter_exercise': None,
  'chapter_no': None,
  'chapter_title': None,
  'chapter_type': None,
  'closing_remarks': 'These are the exercise remarks, appearing at the very '
                     'end.',
  'file': ['flip_coin.py', 'flip_coin.pdf'],
  'heading': '=====',
  'hints': [],
  'keywords': ['random numbers', 'Monte Carlo simulation', 'ipynb'],
  'label': 'demo:ex:1',
  'no': 2,
  'sol_docend': '',
  'solution': '',
  'solution_file': ['mysol.txt', 'mysol_flip_coin.py', 'yet_another.file'],
  'subex': [{'ans_docend': '',
             'answer': 'If the `random.random()` function returns a number '
                       '$<1/2$, let it be\n'
                       'head, otherwise tail. Repeat this $N$ number of times.',
             'file': None,
             'hints': ['Use `r = random.random()` and define head as `r <= '
                       '0.5`.',
                       'Draw an integer among $\\{1,2\\}$ with\n'
                       '`r = random.randint(1,2)` and define head when `r` is '
                       '1.'],
             'sol_docend': '',
             'solution': '!bc pycod\n'
                         'import sys, random\n'
                         'N = int(sys.argv[1])\n'
                         'heads = 0\n'
                         'for i in range(N):\n'
                         '    r = random.random()\n'
                         '    if r <= 0.5:\n'
                         '        heads += 1\n'
                         "print('Flipping a coin %d times gave %d heads' % (N, "
                         'heads))\n'
                         '\n'
                         '!ec',
             'text': 'Make a program that simulates flipping a coin $N$ '
                     'times.\n'
                     "Print out ``tail'' or ``head'' for each flip and\n"
                     'let the program count the number of heads.'},
            {'aftertext': '\n'
                          'Vectorized code can be written in many ways.\n'
                          'Sometimes the code is less intuitive, sometimes '
                          'not.\n'
                          'At least there is not much to find in Section '
                          'ref{sec1}.\n',
             'ans_docend': '',
             'answer': '',
             'file': None,
             'hints': [],
             'sol_docend': '',
             'solution': '',
             'text': 'Vectorize the code in a) using boolean indexing.'},
            {'aftertext': '\n'
                          'In this latter subexercise, we have an\n'
                          'example where the code is easy to read.\n'
                          '\n'
                          '\n'
                          '=== My remarks ===\n'
                          '\n'
                          'Remarks with such a subsubsection is treated as '
                          'more text\n'
                          'after the last subexercise. Test a list too:\n'
                          '\n'
                          ' o Mark 1.\n'
                          ' o Mark 2.\n',
             'ans_docend': '',
             'answer': '`np.sum(np.where(r <= 0.5, 1, 0))` or `np.sum(r <= '
                       '0.5)`.',
             'file': None,
             'hints': [],
             'sol_docend': '',
             'solution': '',
             'text': 'Vectorize the code in a) using `numpy.sum`.'}],
  'text': '# Torture tests',
  'title': 'Flip a Coin',
  'type': 'Problem',
  'type_visible': True},
 {'ans_docend': '',
  'answer': '',
  'chapter_exercise': None,
  'chapter_no': None,
  'chapter_title': None,
  'chapter_type': None,
  'closing_remarks': '',
  'file': ['myexer1'],
  'heading': '=====',
  'hints': [],
  'keywords': None,
  'label': 'my:exer1',
  'no': 3,
  'sol_docend': '',
  'solution': '',
  'solution_file': None,
  'subex': [],
  'text': 'Very short exercise. What is the capital\nof Norway?',
  'title': 'Test of plain text exercise',
  'type': 'Exercise',
  'type_visible': True},
 {'ans_docend': '',
  'answer': '',
  'chapter_exercise': None,
  'chapter_no': None,
  'chapter_title': None,
  'chapter_type': None,
  'closing_remarks': '',
  'file': None,
  'heading': '=====',
  'hints': ['To answer this question empirically, let a program\n'
            "draw $N$ such random numbers using Python's standard `random` "
            'module,\n'
            'count how many of them, $M$, that fall in the interval '
            '$(0.5,0.6)$, and\n'
            'compute the probability as $M/N$.'],
  'keywords': None,
  'label': 'demo:ex:2',
  'no': 4,
  'sol_docend': '',
  'solution': '',
  'solution_file': None,
  'subex': [],
  'text': '# Minimalistic exercise\n'
          '\n'
          '\n'
          'What is the probability of getting a number between 0.5 and 0.6 '
          'when\n'
          'drawing uniformly distributed random numbers from the interval '
          '$[0,1)$?\n'
          '\n'
          '\n'
          'At the end we have a list because that caused problems in LaTeX\n'
          'in previous DocOnce versions:\n'
          '\n'
          ' o item1\n'
          ' o item2',
  'title': 'Compute a Probability',
  'type': 'Project',
  'type_visible': True},
 {'ans_docend': '',
  'answer': '',
  'chapter_exercise': None,
  'chapter_no': None,
  'chapter_title': None,
  'chapter_type': None,
  'closing_remarks': 'At the very end of the exercise it may be appropriate to '
                     'summarize\n'
                     'and give some perspectives.',
  'file': ['circles'],
  'heading': '=====',
  'hints': [],
  'keywords': ['ipynb'],
  'label': 'proj:circle1',
  'no': 5,
  'sol_docend': '',
  'solution': '',
  'solution_file': None,
  'subex': [{'ans_docend': '',
             'answer': 'Here goes the short answer to part a).',
             'file': None,
             'hints': ['Use the `numpy.random` module to draw the\n'
                       '$x_0$, $y_0$, and $R$ quantities.'],
             'sol_docend': '',
             'solution': 'Here goes a full solution to part a).',
             'text': 'Let $R$ be normally distributed and $(x_0,y_0)$ '
                     'uniformly distributed.'},
            {'ans_docend': '',
             'answer': '',
             'file': ['norm'],
             'hints': [],
             'sol_docend': '',
             'solution': '',
             'text': 'Let $R$ be uniformly distributed and $(x_0,y_0)$ '
                     'normally distributed.'},
            {'aftertext': '\n',
             'ans_docend': '',
             'answer': '',
             'file': None,
             'hints': [],
             'sol_docend': '',
             'solution': '',
             'text': 'Let $R$ and $(x_0,y_0)$ be normally distributed.'}],
  'text': 'The formula for a circle is given by\n'
          '\n'
          '!bt\n'
          '\\begin{align}\n'
          'x &= x_0 + R\\cos 2\\pi t,\n'
          'label{circle:x}\\\\ \n'
          'y &= y_0 + R\\sin 2\\pi t,\n'
          'label{circle:y}\n'
          '\\end{align}\n'
          '\n'
          '!et\n'
          'where $R$ is the radius of the circle, $(x_0,y_0)$ is the\n'
          'center point, and $t$ is a parameter in the unit interval $[0,1]$.\n'
          'For any $t$, $(x,y)$ computed from (ref{circle:x})-(ref{circle:y})\n'
          'is a point on the circle.\n'
          'The formula can be used to generate `n` points on a circle:\n'
          '\n'
          '!bc pypro\n'
          'import numpy as np\n'
          '\n'
          'def circle(R, x0, y0, n=501):\n'
          '    t = np.linspace(0, 1, n)\n'
          '    x = x0 + R*np.cos(2*np.pi*t)\n'
          '    y = y0 + R*np.sin(2*np.pi*t)\n'
          '    return x, y\n'
          '\n'
          'x, y = circle(2.0, 0, 0)\n'
          '\n'
          '!ec\n'
          '\n'
          '# Often in an exercise we have some comments about the solution\n'
          '# which we normally want to keep where they are.\n'
          '\n'
          'The goal of this project is to draw $N$ circles with random\n'
          'center and radius. Plot each circle using the `circle` function\n'
          'above.',
  'title': 'Explore Distributions of Random Circles',
  'type': 'Project',
  'type_visible': True},
 {'ans_docend': '',
  'answer': '',
  'chapter_exercise': None,
  'chapter_no': None,
  'chapter_title': None,
  'chapter_type': None,
  'closing_remarks': 'Some final closing remarks, e.g., summarizing the main '
                     'findings\n'
                     'and their implications in other problems can be made. '
                     'These\n'
                     'remarks will appear at the end of the typeset exercise.',
  'file': None,
  'heading': '=====',
  'hints': [],
  'keywords': None,
  'label': 'exer:dist',
  'no': 6,
  'sol_docend': '',
  'solution': 'Here goes a full solution of the whole exercise.\n'
              'With some math $a=b$ in this solution:\n'
              '!bt\n'
              '\\[ \\hbox{math in solution: } a = b \\]\n'
              '\n'
              '!et\n'
              'And code `a=b` in this solution:\n'
              '!bc\n'
              'a = b  # code in solution\n'
              '\n'
              '!ec \n'
              'End of solution is here.',
  'solution_file': None,
  'subex': [{'ans_docend': '',
             'answer': 'Short answer to subexercise a).\n'
                       'With math in answer: $a=b$.',
             'file': ['subexer_a.pdf'],
             'hints': ['First hint to subexercise a).\n'
                       'With math $a=b$ in hint:\n'
                       '\n'
                       '!bt\n'
                       '\\[ a=b. \\]\n'
                       '\n'
                       '!et\n'
                       'And with code (in plain verbatim) returning $x+1$ in '
                       'hint:\n'
                       '\n'
                       '!bc\n'
                       'def func(x):\n'
                       '    return x + 1  # with code in hint\n'
                       '\n'
                       '!ec',
                       'Second hint to subexercise a).\n'
                       '\n'
                       'Test list in hint:\n'
                       '\n'
                       ' o item1\n'
                       ' o item2'],
             'sol_docend': '',
             'solution': '',
             'text': 'Subexercises are numbered a), b), etc.'},
            {'aftertext': '\n'
                          '\n'
                          '\n'
                          '#  No meaning in this weired test example:\n'
                          'The text here belongs to the main (intro) part of '
                          'the exercise. Need\n'
                          'closing remarks to have text after subexercises.\n'
                          '\n'
                          'Test list in exercise:\n'
                          '\n'
                          ' o item1\n'
                          ' o item2\n'
                          '\n',
             'ans_docend': '',
             'answer': '',
             'file': ['subexer_b.pdf'],
             'hints': ['A hint for this subexercise.'],
             'sol_docend': '',
             'solution': 'Here goes the solution of this subexercise.',
             'text': 'Here goes the text for subexercise b).\n'
                     '\n'
                     '\n'
                     'Some math $\\cos^2 x + \\sin^2 x = 1$ written one a '
                     'single line:\n'
                     '\n'
                     '!bt\n'
                     '\\[ \\cos^2 x + \\sin^2 x = 1 \\thinspace .\\]\n'
                     '\n'
                     '!et'}],
  'text': 'Intro to this exercise. Questions are in subexercises below.',
  'title': 'Determine some Distance',
  'type': 'Exercise',
  'type_visible': True},
 {'ans_docend': '',
  'answer': '',
  'chapter_exercise': None,
  'chapter_no': None,
  'chapter_title': None,
  'chapter_type': None,
  'closing_remarks': '',
  'file': None,
  'heading': '=====',
  'hints': [],
  'keywords': None,
  'label': None,
  'no': 7,
  'sol_docend': '',
  'solution': '',
  'solution_file': None,
  'subex': [],
  'text': '# Another minimalistic exercise\n'
          '\n'
          'Just some text. And some math saying that $e^0=1$ on a single '
          'line,\n'
          'to test that math block insertion is correct:\n'
          '\n'
          '!bt\n'
          '\\[ \\exp{(0)} = 1 \\]\n'
          '\n'
          '!et\n'
          '\n'
          'And a test that the code `lambda x: x+2` is correctly placed here:\n'
          '\n'
          '!bc\n'
          'lambda x: x+2\n'
          '\n'
          '!ec ',
  'title': 'Some exercise without the "Exercise:" prefix',
  'type': 'Exercise',
  'type_visible': False},
 {'ans_docend': '',
  'answer': '',
  'chapter_exercise': None,
  'chapter_no': None,
  'chapter_title': None,
  'chapter_type': None,
  'closing_remarks': '',
  'file': None,
  'heading': '=====',
  'hints': [],
  'keywords': None,
  'label': 'sec:this:exer:de',
  'no': 8,
  'sol_docend': '',
  'solution': '',
  'solution_file': None,
  'subex': [],
  'text': '# --- begin quiz ---\n'
          '# --- quiz heading: SOlution of differential equation\n'
          '# --- previous heading type: exercise\n'
          "# --- keywords: ['derivatives', 'exponential function', 'equation, "
          "differential', 'differential equation']\n"
          '\n'
          '# --- begin quiz question ---\n'
          'Given\n'
          '\n'
          '!bt\n'
          '\\[ \\frac{dy}{dx} = -y(x),\\quad y(0)=1 \\]\n'
          '\n'
          '!et\n'
          'What is the solution of this equation?\n'
          '# --- end quiz question ---\n'
          '# --- label: quiz:diff:eq1\n'
          '\n'
          '\n'
          '# --- begin quiz choice 1 (right) ---\n'
          '$y=e^{-y}$\n'
          '# --- end quiz choice 1 (right) ---\n'
          '\n'
          '# --- begin quiz choice 2 (wrong) ---\n'
          '$y=e^{y}$\n'
          '# --- end quiz choice 2 (wrong) ---\n'
          '\n'
          '# --- begin explanation of choice 2 ---\n'
          'Almost, but the sign is wrong (note the minus!).\n'
          '# --- end explanation of choice 2 ---\n'
          '\n'
          '# --- begin quiz choice 3 (wrong) ---\n'
          '!bc pycod\n'
          'from math import exp\n'
          'def f(x):\n'
          '    return exp(x)\n'
          '\n'
          '!ec\n'
          '# --- end quiz choice 3 (wrong) ---\n'
          '\n'
          '# --- begin explanation of choice 3 ---\n'
          'Ooops, forgot a minus: `exp(-x)`, otherwise this Python code\n'
          'must be considered as a good answer. It is more natural,\n'
          'though, to write the solution to the problem\n'
          'in mathematical notation:\n'
          '\n'
          '!bt\n'
          '\\[ y(x) = e^{-y}.\\]\n'
          '\n'
          '!et\n'
          '# --- end explanation of choice 3 ---\n'
          '\n'
          '# --- begin quiz choice 4 (wrong) ---\n'
          'The solution cannot be found because there is a derivative in the '
          'equation.\n'
          '# --- end quiz choice 4 (wrong) ---\n'
          '\n'
          '# --- begin explanation of choice 4 ---\n'
          'Equations with derivatives can be solved;\n'
          'they are termed *differential\n'
          'equations*.\n'
          '# --- end explanation of choice 4 ---\n'
          '\n'
          '# --- begin quiz choice 5 (wrong) ---\n'
          'The equation is meaningless: an equation must be an equation\n'
          'for $x$ or $y$, not a function $y(x)$.\n'
          '# --- end quiz choice 5 (wrong) ---\n'
          '\n'
          '# --- begin explanation of choice 5 ---\n'
          'Equations where the unknown is a function, as $y(x)$\n'
          'here, are called *differential equations*, and are solved by\n'
          'special techniques.\n'
          '# --- end explanation of choice 5 ---\n'
          '# --- end quiz ---',
  'title': 'Solution of differential equation',
  'type': 'Exercise',
  'type_visible': True},
 {'ans_docend': '',
  'answer': '',
  'chapter_exercise': None,
  'chapter_no': None,
  'chapter_title': None,
  'chapter_type': None,
  'closing_remarks': '',
  'file': None,
  'heading': '=====',
  'hints': [],
  'keywords': None,
  'label': None,
  'no': 9,
  'sol_docend': '',
  'solution': '',
  'solution_file': None,
  'subex': [{'ans_docend': '',
             'answer': 'Oslo.',
             'file': None,
             'hints': [],
             'sol_docend': '',
             'solution': '',
             'text': 'What is the capital of Norway?'}],
  'text': '# This example needs the --examples_as_exercises option, otherwise\n'
          '# it is just typeset as it is written.',
  'title': 'Just an example',
  'type': 'Example',
  'type_visible': True},
 {'ans_docend': '',
  'answer': '',
  'chapter_exercise': None,
  'chapter_no': None,
  'chapter_title': None,
  'chapter_type': None,
  'closing_remarks': '',
  'file': ['verify_formula.py'],
  'heading': '=====',
  'hints': [],
  'keywords': None,
  'label': 'exer:some:formula',
  'no': 10,
  'sol_docend': '',
  'solution': '',
  'solution_file': None,
  'subex': [],
  'text': '# Test comments not at the end only\n'
          'Pick a statement from Project ref{proj:circle1} or Problem '
          'ref{demo:ex:1}\n'
          'and verify it.\n'
          '\n'
          'Test list at the end of an exercise without other elements (like '
          'subexercise,\n'
          'hint, etc.):\n'
          '\n'
          ' o item1\n'
          ' o item2',
  'title': 'Make references to projects and problems',
  'type': 'Exercise',
  'type_visible': True},
 {'ans_docend': '',
  'answer': '',
  'chapter_exercise': None,
  'chapter_no': None,
  'chapter_title': None,
  'chapter_type': None,
  'closing_remarks': '',
  'file': ['selc_composed.pdf'],
  'heading': '=====',
  'hints': [],
  'keywords': None,
  'label': 'exer:you',
  'no': 11,
  'sol_docend': '',
  'solution': '',
  'solution_file': None,
  'subex': [],
  'text': 'Refer to the previous exercise as Exercise ref{exer:some:formula},\n'
          'the two before that as Projects ref{demo:ex:2} and '
          'ref{proj:circle1},\n'
          'and this one as Project ref{exer:you}.',
  'title': 'References to Project ref{demo:ex:2} in a heading works for pandoc',
  'type': 'Project',
  'type_visible': True}]
************** File: tmp_encodings.txt *****************
iso-8859-1
iso-8859-1
iso-8859-1
iso-8859-1
iso-8859-1

************** File: html_template.do.txt *****************
DATE: today

===== This is a test of HTML templates =====

Note: When using HTML templates, the DocOnce file cannot have a title
(to avoid generating a header). It should neither have an author.

======= This is a 7 heading =======

Here is some code:
!bc pycod
class Diff:
    def __init__(self, f, h=1E-5):
        self.f = f
        self.h = float(h)

class Forward1(Diff):
    def __call__(self, x):
        f, h = self.f, self.h
        return (f(x+h) - f(x))/h
!ec

===== This is a 5 heading =====

The template can be any HTML file with header and footer and
three possible slots: *title*, *date* and *main*,
where *main* will become the DocOnce file (the main body of text),
*title* is the first heading in the DocOnce file, and
*date* is extracted from the DocOnce file (if present).



************** File: html_template1.html *****************
<! -- test template -->

<?xml version="1.0" encoding="utf-8" ?>
<html>
<head>

<style type="text/css">
    body {
      margin-top: 1.0em;
      <!-- background-color: #e1c931; -->
      background-color: #000000;
      font-family: Helvetica, Arial, FreeSans, san-serif;
      color: #000000;
    }
    #container {
      margin: 0 auto;
      width: 700px;
    }
    h1 { font-size: 1.8em; color: #1e36ce; margin-bottom: 3px; }
    h1 .small { font-size: 0.4em; }
    h1 a { text-decoration: none }
    h2 { font-size: 1.5em; color: #1e36ce; }
    h3 { text-align: left; color: #1e36ce; }
    h4 { text-align: left; color: #1e36ce; }
    a { color: #1e36ce; }
    .description { font-size: 1.2em; margin-bottom: 30px; margin-top: 30px; font-style: italic;}
    .download { float: right; }
    <!-- white on black: pre { background: #000; color: #fff; padding: 15px;} -->
    <!-- black on white: pre { background: #fff; color: #000; padding: 15px;} -->
    pre { background: #EDEDED; color: #000; padding: 15px;}
    <!-- https://www.december.com/html/spec/color0.html -->
    hr { border: 0; width: 80%; border-bottom: 1px solid #aaa}
    .footer { text-align:center; padding-top:30px; font-style: italic; }
</style>

<!-- Use MathJax to render mathematics -->
<script type="text/x-mathjax-config">
MathJax.Hub.Config({
  TeX: {
     equationNumbers: {  autoNumber: "AMS"  },
     extensions: ["AMSmath.js"]
  }
});
</script>
<script type="text/javascript"
 src="http://cdn.mathjax.org/mathjax/latest/MathJax.js?config=TeX-AMS-MML_HTMLorMML">
</script>

</head>

<body bgcolor="white">

<title>This is a test of HTML templates</title>
<h4>Date: Jan 32, 2100</h4>

<!-- main body -->


<!-- tocinfo
{'highest level': 1,
 'sections': [('This is a test of HTML templates',
               2,
               None,
               'this-is-a-test-of-html-templates'),
              ('This is a 7 heading', 1, None, 'this-is-a-7-heading'),
              ('This is a 5 heading', 2, None, 'this-is-a-5-heading')]}
end of tocinfo -->


<!-- ------------------- main content ---------------------- -->


<br>
<p></p>
<h2 id="this-is-a-test-of-html-templates">This is a test of HTML templates </h2>

<p></p>
Note: When using HTML templates, the DocOnce file cannot have a title
(to avoid generating a header). It should neither have an author.

<p></p>
<h1 id="this-is-a-7-heading">This is a 7 heading </h1>

<p></p>
Here is some code:
<!-- begin verbatim block  pycod-->
<pre><code>class Diff:
    def __init__(self, f, h=1E-5):
        self.f = f
        self.h = float(h)

class Forward1(Diff):
    def __call__(self, x):
        f, h = self.f, self.h
        return (f(x+h) - f(x))/h
</code></pre>
<!-- end verbatim block -->

<p></p>
<h2 id="this-is-a-5-heading">This is a 5 heading </h2>

<p></p>
The template can be any HTML file with header and footer and
three possible slots: <em>title</em>, <em>date</em> and <em>main</em>,
where <em>main</em> will become the DocOnce file (the main body of text),
<em>title</em> is the first heading in the DocOnce file, and
<em>date</em> is extracted from the DocOnce file (if present).

<p></p>

<!-- ------------------- end of main content --------------- -->



<!-- end of main body -->
</body>
</html>


************** File: html_template.html *****************
<!-- Template for INF1100 web pages with University of Oslo web design -->

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "https://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html lang="no" xml:lang="no" xmlns="https://www.w3.org/1999/xhtml">
  <head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
   <!-- iPhone viewport -->
   <meta name="viewport" content="width=1020, user-scalable=yes" />


     <title>This is a test of HTML templates</title>

    <link rel="shortcut icon" type="image/vnd.microsoft.icon" href="https://www.uio.no/vrtx/decorating/resources/dist/images/favicon.ico" />
    <link type="text/css" rel="stylesheet" media="all" href="https://www.uio.no/vrtx/decorating/resources/dist/style/style.css" />

    <link type="text/css" rel="stylesheet" media="all" href="https://www.uio.no/vrtx/decorating/resources/dist/www.uio.no/logos/logos.css" />

    <link type="text/css" rel="stylesheet" media="print" href="https://www.uio.no/vrtx/decorating/resources/dist/style/print.css" />
    <link type="text/css" rel="stylesheet" media="handheld" href="https://www.uio.no/vrtx/decorating/resources/dist/style/handheld.css"/>

   <script type="text/javascript" src="https://www.uio.no/vrtx/__vrtx/static-resources/jquery/jquery-1.4.2.min.js"></script>

   <meta name="MSSmartTagsPreventParsing" content="true" />
   <meta http-equiv="imagetoolbar" content="no" />




          <script type="text/javascript" src="https://www.uio.no/vrtx/__vrtx/static-resources/js/share.js"></script>




  </head>


    <body class='faculty'  id="vrtx-structured-article">


    <!--stopindex-->
    <!-- Navigation start -->
    <ul id="hidnav">
      <li><a href="#globalnav">Hopp til global navigasjon</a></li>
      <li><a href="#main">Hopp til hovedinnholdet</a></li>

      <li><a href="#bottomnav">Hopp til bunnavigasjon</a></li>
      <li><a href="#footer">Hopp til kontaktinformasjon</a></li>
    </ul>
    <!-- Navigation end -->

    <!-- Page header starts -->
    <div id="head-globalnav">


     <!-- normal head -->


       <div id="head">

 	  <div id="logos">
	      <div id="uiologo" title="G&#229; til Universitetet i Oslo"><a href="https://www.uio.no"><span></span>Universitetet i Oslo</a></div>

              <!-- toppniv&#229; -->

	      <div id="facultylogo" title='G&#229; til Universitetet i Oslo'>
                <a href="/"><span></span>Universitetet i Oslo</a>
              </div>


	  </div>

	  <form class="searchform" method="get" action='/'>

	    <fieldset>
	      <label for="searchstring" class="searchstringlabel">S&#248;k i Universitetet i Oslo</label>
              <input type="hidden" name="vrtx" value="searchuio"/>
	      <input type="text" id="searchstring" name="query" value="" />
	      <button type="submit" class="searchsubmit"><span>S&oslash;k</span></button>
	    </fieldset>
	  </form>

	  <!-- head-menu -->
          <div id="head-menu">

              <ul class="ref-menu">

                 <!-- toppniv&#229; -->
                  <li><a href='/english'>English</a></li>


             </ul>

               <ul class="vrtx-uri-menu">

    <li class="for-ansatte">
  <a href="https://www.uio.no/for-ansatte/">For ansatte</a>
    </li>
  </ul>


          </div>
          <!-- head-menu -->
	</div>

        <!-- Global navigation start -->
	<div id="globalnav">

                <ul class="vrtx-tab-menu">

    <li class="root-folder parent-folder">
  <a href="https://www.uio.no/">Forsiden</a>
    </li>

    <li class="forskning">

  <a href="https://www.uio.no/forskning/">Forskning</a>
    </li>

    <li class="vrtx-active-item studier vrtx-current-item">
  <a href="https://www.uio.no/studier/">Studier</a>
    </li>

    <li class="livet-rundt-studiene">
  <a href="https://www.uio.no/livet-rundt-studiene/">Livet rundt studiene</a>

    </li>

    <li class="tjenester">
  <a href="https://www.uio.no/tjenester/">Tjenester og verkt&#248;y</a>
    </li>

    <li class="om">
  <a href="https://www.uio.no/om/">Om UiO</a>
    </li>

    <li class="personer">
  <a href="https://www.uio.no/personer/">Personer</a>
    </li>
  </ul>




        </div>
	<!-- Global navigation end -->

    </div>

    <!-- Page header end -->


    <div id="uiodoc">
        <!-- img-tag for print -->

           <!-- topp-/fakniv&#229; -->
            <img id="head-print" alt="print logo" src="https://www.uio.no/vrtx/decorating/resources/dist/www.uio.no/logos/faculty-small.png"/>



	<!-- Page content start -->
	<div id="main">
          <!--startindex-->

                     <!-- leftmenu (default) -->
            <!--stopindex-->
            <div id="left-main">
              <ul class="vrtx-breadcrumb-menu">
				<li class="vrtx-ancestor"> <a href="https://www.uio.no/studier/"><span>Studier</span></a> </li>
				<li class="vrtx-ancestor"> <a href="https://www.uio.no/studier/emner/"><span>Emner</span></a> </li>

				<li class="vrtx-ancestor"> <a href="https://www.uio.no/studier/emner/matnat/"><span>Matematikk og naturvitenskap</span></a> </li>
				<li class="vrtx-ancestor"> <a href="https://www.uio.no/studier/emner/matnat/ifi/"><span>Informatikk</span></a> </li>
				<li class="vrtx-parent" ><a href="https://www.uio.no/studier/emner/matnat/ifi/INF1100/"><span>INF1100</span></a>
    	<ul>
			<li class="vrtx-child"><a class="vrtx-marked" href="https://www.uio.no/studier/emner/matnat/ifi/INF1100/h12/"><span>H&#248;st 2012</span></a></li>

     	</ul>
   	 </li>
</ul>

            </div>
            <div id="right-main">
              <!--startindex-->


        <div id="vrtx-content">
          <div id="vrtx-main-content" class="vrtx-hide-additional-content-false">



<!-- tocinfo
{'highest level': 1,
 'sections': [('This is a test of HTML templates',
               2,
               None,
               'this-is-a-test-of-html-templates'),
              ('This is a 7 heading', 1, None, 'this-is-a-7-heading'),
              ('This is a 5 heading', 2, None, 'this-is-a-5-heading')]}
end of tocinfo -->


<!-- ------------------- main content ---------------------- -->


<br>
<p></p>
<h2 id="this-is-a-test-of-html-templates">This is a test of HTML templates </h2>

<p></p>
Note: When using HTML templates, the DocOnce file cannot have a title
(to avoid generating a header). It should neither have an author.

<p></p>
<h1 id="this-is-a-7-heading">This is a 7 heading </h1>

<p></p>
Here is some code:


<!-- code=python (!bc pycod) typeset with pygments style "emacs" -->
<div class="highlight" style="background: #f8f8f8"><pre style="line-height: 125%;"><span></span><span style="color: #AA22FF; font-weight: bold">class</span> <span style="color: #0000FF">Diff</span>:
    <span style="color: #AA22FF; font-weight: bold">def</span> <span style="color: #00A000">__init__</span>(<span style="color: #AA22FF">self</span>, f, h<span style="color: #666666">=1E-5</span>):
        <span style="color: #AA22FF">self</span><span style="color: #666666">.</span>f <span style="color: #666666">=</span> f
        <span style="color: #AA22FF">self</span><span style="color: #666666">.</span>h <span style="color: #666666">=</span> <span style="color: #AA22FF">float</span>(h)

<span style="color: #AA22FF; font-weight: bold">class</span> <span style="color: #0000FF">Forward1</span>(Diff):
    <span style="color: #AA22FF; font-weight: bold">def</span> <span style="color: #00A000">__call__</span>(<span style="color: #AA22FF">self</span>, x):
        f, h <span style="color: #666666">=</span> <span style="color: #AA22FF">self</span><span style="color: #666666">.</span>f, <span style="color: #AA22FF">self</span><span style="color: #666666">.</span>h
        <span style="color: #AA22FF; font-weight: bold">return</span> (f(x<span style="color: #666666">+</span>h) <span style="color: #666666">-</span> f(x))<span style="color: #666666">/</span>h
</pre></div>

<p></p>
<h2 id="this-is-a-5-heading">This is a 5 heading </h2>

<p></p>
The template can be any HTML file with header and footer and
three possible slots: <em>title</em>, <em>date</em> and <em>main</em>,
where <em>main</em> will become the DocOnce file (the main body of text),
<em>title</em> is the first heading in the DocOnce file, and
<em>date</em> is extracted from the DocOnce file (if present).

<p></p>

<!-- ------------------- end of main content --------------- -->


	    	<div class="vrtx-date-info">
	    	<span class="published-date-label">Publisert</span> <span class="published-date">Jan 32, 2100</span>

	    	</div>

            <div class="vrtx-social-components">

<!-- begin email a friend js -->
<script type="text/javascript" src="https://www.uio.no/vrtx/__vrtx/static-resources/js/email-a-friend.js"></script>
<!-- end email a friend js -->

<a class="vrtx-email-friend" href="https://www.uio.no/studier/emner/matnat/ifi/INF1100/h10/template.html?vrtx=email-a-friend" onclick="javascript:popup('https://www.uio.no/studier/emner/matnat/ifi/INF1100/h10/template.html?vrtx=email-a-friend'); return false">Tips en venn</a>

<div id="vrtx-share-component">
  <a href="#vrtx-share-link" id="vrtx-share-link" class="vrtx-share-link" name="vrtx-share-link">
  Del p&#229;...</a>
    <div id="vrtx-send-share">

      <div class="vrtx-send-inner">
        <div class="vrtx-share-top">
          <div class="vrtx-share-title">Del p&#229;...</div>
          <span><a href="#vrtx-share-link" class="vrtx-close-toolbox-send-share">
          Lukk</a></span>
        </div>
        <ul>
          <li><a href="https://www.facebook.com/share.php?u=http%3A%2F%2Fwww.uio.no%2Fstudier%2Femner%2Fmatnat%2Fifi%2FINF1100%2Fh10%2Ftemplate.html&amp;t=Template" target="_blank" class="facebook">

          Facebook</a></li>
          <li><a href="http://twitter.com/home?status=http%3A%2F%2Fwww.uio.no%2Fstudier%2Femner%2Fmatnat%2Fifi%2FINF1100%2Fh10%2Ftemplate.html" target="_blank" class="twitter">
          Twitter</a></li>
          <li><a href="http://del.icio.us/post?url=http%3A%2F%2Fwww.uio.no%2Fstudier%2Femner%2Fmatnat%2Fifi%2FINF1100%2Fh10%2Ftemplate.html&amp;title=Template" target="_blank" class="delicious">
          del.icio.us</a></li>
        </ul>
     </div>

    </div>
</div>
          	</div>
          </div>
        </div>

              <!--stopindex-->
            </div>

          <!--stopindex-->
         </div>
	<!-- Page content end -->

      <!-- Bottom navigation start -->
	<div id="bottomnav">
           <div id="breadcrumb-container">
	     <div id="vrtx-breadcrumb-start" class="breadcrumb">
	       <span class="vrtx-uio"><a href="https://www.uio.no">UiO</a> <span class="vrtx-breadcrumb-delimiter">&gt;</span></span>

                 <span class="vrtx-faculty"><a href="/">Universitetet i Oslo</a> <span class="vrtx-breadcrumb-delimiter">&gt;</span></span>


             </div>

<div id="vrtx-breadcrumb" class="breadcrumb">
      <span class="vrtx-breadcrumb-level-2"><a href="https://www.uio.no/studier/">Studier</a>
      	<span class="vrtx-breadcrumb-delimiter">&gt;</span>
      </span>
</div>



           </div>
           <div id="bottom-menu">



        <div class="vrtx-subfolder-menu">

          <div class="vrtx-group-1">
    <ul class="resultset-1">
      <li>
    <a href="https://www.uio.no/studier/program/">Studieprogrammer</a>
  <ul>
	          <li>
    <a href="https://www.uio.no/studier/program/litteratur-aarsenhet/">Allmenn litteraturvitenskap (&#229;rsenhet)</a>
          	</li>

	          <li>
    <a href="https://www.uio.no/studier/program/akks/">Antikk kultur og klassiske spr&#229;k (bachelor)</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/program/antikk/">Antikk kultur og klassisk tradisjon (bachelor)</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/program/antikk-master/">Antikk kultur og klassisk tradisjon (master - to &#229;r)</a>

          	</li>
	          <li>
    <a href="https://www.uio.no/studier/program/anvma-master/">Anvendt matematikk og mekanikk</a>
          	</li>
	    <li class="vrtx-more">
			<a href="https://www.uio.no/studier/program">Mer...</a>
		</li>
  </ul>

      </li>
  </ul>

    <ul class="resultset-2">
      <li>
    <a href="https://www.uio.no/studier/opptak/">Opptak</a>
  <ul>
	          <li>
    <a href="https://www.uio.no/studier/opptak/so/">S&#248;ke opptak</a>

          	</li>
	          <li>
    <a href="https://www.uio.no/studier/opptak/gsk/">Generell studiekompetanse (GSK)</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/opptak/realkompetanse/">Realkompetanse</a>
          	</li>
	          <li>

    <a href="https://www.uio.no/studier/opptak/spesielle-krav/">Spesielle opptakskrav</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/opptak/enkeltemner/">Enkeltemner</a>
          	</li>
  </ul>
      </li>
  </ul>


    <ul class="resultset-3">
      <li>
    <a href="https://www.uio.no/studier/admin/">Administrer dine studier</a>
  <ul>
	          <li>
    <a href="https://www.uio.no/studier/admin/semesterregistrering/">Registreringer hvert semester</a>
          	</li>
	          <li>

    <a href="https://www.uio.no/studier/admin/melding/">Frister for meldinger til undervisning og eksamen</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/admin/semesteravgift/">Betale semesteravgift</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/admin/kort/">Semesterkort og studiekort</a>

          	</li>
	          <li>
    <a href="https://www.uio.no/studier/admin/karakterutskrift/">Bestille karakterutskrift</a>
          	</li>
	    <li class="vrtx-more">
			<a href="https://www.uio.no/studier/admin">Mer...</a>
		</li>
  </ul>

      </li>
  </ul>

    <ul class="resultset-4">
      <li>
    <a href="https://www.uio.no/studier/emner/">Emner</a>
  <ul>
	          <li>
    <a href="https://www.uio.no/studier/emner/hf/">Humanistiske fag</a>

          	</li>
	          <li>
    <a href="https://www.uio.no/studier/emner/jus/">Jus</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/emner/matnat/">Matematikk og naturvitenskap</a>
          	</li>
	          <li>

    <a href="https://www.uio.no/studier/emner/medisin/">Medisin</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/emner/odont/">Odontologi</a>
          	</li>
	    <li class="vrtx-more">
			<a href="https://www.uio.no/studier/emner">Mer...</a>
		</li>

  </ul>
      </li>
  </ul>

    <ul class="resultset-5">
      <li>
    <a href="https://www.uio.no/studier/evu/">Etter- og videreutdanning</a>
  <ul>
	          <li>

    <a href="https://www.uio.no/studier/evu/kurs/">Studietilbud</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/evu/oppdrag/">Oppdragsundervisning</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/evu/erfaringsbasert-master/">Erfaringsbasert master</a>

          	</li>
  </ul>
      </li>
  </ul>

    <ul class="resultset-6">
      <li>
    <a href="https://www.uio.no/studier/studiestart/">Studiestart for nye studenter</a>
  <ul>

	          <li>
    <a href="https://www.uio.no/studier/studiestart/arrangementer/">Arrangementer</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/studiestart/fadderordning-for-nye-studenter/">Fadderordning for nye studenter</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/studiestart/fadderordningen/">Informasjon til fadderne</a>

          	</li>
  </ul>
      </li>
  </ul>

          </div>
          <div class="vrtx-group-2">
    <ul class="resultset-7">
      <li>
    <a href="https://www.uio.no/studier/tilrettelegging/">Har du spesielle behov?</a>

  <ul>
	          <li>
    <a href="https://www.uio.no/studier/tilrettelegging/adhd/">ADHD</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/tilrettelegging/asperger/">Asperger</a>
          	</li>
	          <li>

    <a href="https://www.uio.no/studier/tilrettelegging/bevegelseshemming/">Bevegelseshemming</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/tilrettelegging/dysleksi/">Dysleksi</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/tilrettelegging/kronisk-sydom/">Kronisk sykdom</a>

          	</li>
	    <li class="vrtx-more">
			<a href="https://www.uio.no/studier/tilrettelegging">Mer...</a>
		</li>
  </ul>
      </li>
  </ul>

    <ul class="resultset-8">
      <li>

    <a href="https://www.uio.no/studier/om/">Om studier</a>
  <ul>
	          <li>
    <a href="https://www.uio.no/studier/om/studier-og-grader/">Studiestruktur og grader</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/om/kvalitet/">Studiekvalitet</a>

          	</li>
	          <li>
    <a href="https://www.uio.no/studier/om/regelverk/">Lover og regler</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/om/godkjenning/">Godkjenning av utenlandsk utdanning</a>
          	</li>
	          <li>

    <a href="https://www.uio.no/studier/om/utvalg/">Komiteer og utvalg</a>
          	</li>
  </ul>
      </li>
  </ul>

    <ul class="resultset-9">
      <li>
    <a href="https://www.uio.no/studier/emnegrupper/">Emnegrupper</a>

  <ul>
	          <li>
    <a href="https://www.uio.no/studier/emnegrupper/hf/">Humanistiske fag</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/emnegrupper/jus/">Jus</a>
          	</li>
	          <li>

    <a href="https://www.uio.no/studier/emnegrupper/matnat/">Matematikk og naturvitenskap</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/emnegrupper/sv/">Samfunnsvitenskap</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/emnegrupper/teologi/">Teologi</a>

          	</li>
	    <li class="vrtx-more">
			<a href="https://www.uio.no/studier/emnegrupper">Mer...</a>
		</li>
  </ul>
      </li>
  </ul>

    <ul class="resultset-10">
      <li>

    <a href="https://www.uio.no/studier/ressurser/">L&#230;ringsressurser</a>
  <ul>
	          <li>
    <a href="https://www.uio.no/studier/ressurser/bibliotek-lesesaler/">Bibliotek, lesesaler og PC-stuer</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/ressurser/mifa/">Mangfold i fokus i akademia</a>

          	</li>
	          <li>
    <a href="https://www.uio.no/studier/ressurser/skrivehjelp/">Skrivehjelp</a>
          	</li>
	          <li>
    <a href="https://www.uio.no/studier/ressurser/spraak-tandem/">Spr&#229;k-tandem</a>
          	</li>
  </ul>

      </li>
  </ul>

    <ul class="resultset-11">
      <li>
    <a href="https://www.uio.no/studier/kontakt/">Kontakt oss</a>
      </li>
  </ul>

     </div>

        </div>



           </div>
        </div>
      <!-- Bottom navigation end -->
    </div>
    <!-- Page wrapper end -->
    <div id="footer-wrapper">

    <!-- Page footer start -->
      <div id="footer">
        <div id="footer-main" class="vcard">
	  <div class="institutelogo fn org"><span></span>Universitetet i Oslo : Universitetet i Oslo</div>


             <div class="adr visitor-adress">
  <span class="vrtx-label">N&#248;dnummer</span>
  <span>Ved brann, ulykker og alvorlige hendelser ring <br/>22 85 66 66</span>

</div>
<div class="adr mail-adress">
  <span class="vrtx-label">Adresse</span>
  <span class="post-office-box">Universitetet i Oslo</span>
  <span class="post-office-box">Boks 1072 Blindern</span>
  <span class="postal-code">0316</span>
  <span class="locality"> Oslo</span>

</div>
<div class="phone-fax-email">
  <span class="vrtx-label">Telefon og kontaktpunkter</span>
  <span class="tel">Sentralbord: 22 85 50 50</span>
  <a href="/om/kontaktinformasjon/">Kontaktpunkter UiO</a>
</div>




        </div>

        <div id="footer-admin">

          <ul class="unit-admin-links">
              <li>Ansvarlig for denne siden:</li>
              <li><a href="mailto:studieredaktor@admin.uio.no">Studieredakt&#248;r UiO</a></li>
          </ul>
          <ul class="vrtx-admin-links">
            <li><div class="vrtx-logout" id="vrtx-logout">
  <span class="vrtx-user">Lars Jahr R&#248;ine</span>
  <form id="logoutForm" action="https://www.uio.no/studier/emner/matnat/ifi/INF1100/h10/template.html?action=logout" method="post" style="display:inline;">

  <input type="hidden"
         name="csrf-prevention-token"
         value="c3ed5c2f65171c0952ab9b76819ef85843a0e40f" />
    <button type="submit" id="logoutAction" name="logoutAction">Logg ut</button>
  </form>
  <!-- Hide submit button, display a link instead: -->
  <script type="text/javascript" language="Javascript"><!--
	   	document.getElementById("logoutAction").style.display = "none";
		var logoutLink = document.createElement("a");
		logoutLink.setAttribute("href","javascript:document.getElementById('logoutForm').submit();");
		logoutLink.innerHTML = "Logg ut"

		var lp = document.createElement("span");
		lp.innerHTML = "( ";
		var rp = document.createElement("span");
		rp.innerHTML = " )";
		document.getElementById("vrtx-logout").appendChild(lp);
		document.getElementById("vrtx-logout").appendChild(logoutLink);
		document.getElementById("vrtx-logout").appendChild(rp);
		// -->
  </script>
</div>
</li>
            <li>

  <a id="vrtx-manage-url" class="vrtx-manage-url" href="https://www-adm.uio.no/studier/emner/matnat/ifi/INF1100/h10/template.html?vrtx=admin">Administrer dette dokumentet</a>
</li>
          </ul>
          <div id="cms">Drevet av <a href="https://www.uio.no/tjenester/it/web/vortex/">Vortex</a></div>
        </div>
      </div>
    <!-- Page footer end -->
   </div>

   <script type="text/javascript" src="https://www.uio.no/vrtx/__vrtx/static-resources/jquery/autocomplete/jquery.autocomplete.js"></script>
   <script type="text/javascript" src="https://www.uio.no/vrtx/decorating/resources/dist/script/jquery-syntax/jquery.syntax.min.js"></script>
   <script type="text/javascript" src="https://www.uio.no/vrtx/decorating/resources/dist/script/uio.js"></script>
   <script type="text/javascript">
      $(document).ready(function() {
        var emnerParams = {selectFirst:false, width:226, max:50, delay:75};
        emnerAutocomplete('course-search', 'emner', emnerParams);
        gotoEmnerAutocompleteSuggestion('course-search');

        var personerParams = {minChars:3, selectFirst:false, width:233, max:50, delay:200, cacheLength:0};
        personerAutocomplete('person-search', 'person', personerParams, '/');
        gotoPersonerAutocompleteSuggestion('person-search');

      });
   </script>

   <!-- Greybox for Email a friend / Tips en venn -->
   <script type="text/javascript">
     var GB_ROOT_DIR = "https://www.uio.no/vrtx/decorating/resources/dist/script/greybox/";
   </script>

   <script type="text/javascript" src="https://www.uio.no/vrtx/decorating/resources/dist/script/greybox/AJS-combined-min.js"></script>

   </body>
</html>



************** File: template1.html *****************
<! -- test template -->

<?xml version="1.0" encoding="utf-8" ?>
<html>
<head>

<style type="text/css">
    body {
      margin-top: 1.0em;
      <!-- background-color: #e1c931; -->
      background-color: #000000;
      font-family: Helvetica, Arial, FreeSans, san-serif;
      color: #000000;
    }
    #container {
      margin: 0 auto;
      width: 700px;
    }
    h1 { font-size: 1.8em; color: #1e36ce; margin-bottom: 3px; }
    h1 .small { font-size: 0.4em; }
    h1 a { text-decoration: none }
    h2 { font-size: 1.5em; color: #1e36ce; }
    h3 { text-align: left; color: #1e36ce; }
    h4 { text-align: left; color: #1e36ce; }
    a { color: #1e36ce; }
    .description { font-size: 1.2em; margin-bottom: 30px; margin-top: 30px; font-style: italic;}
    .download { float: right; }
    <!-- white on black: pre { background: #000; color: #fff; padding: 15px;} -->
    <!-- black on white: pre { background: #fff; color: #000; padding: 15px;} -->
    pre { background: #EDEDED; color: #000; padding: 15px;}
    <!-- https://www.december.com/html/spec/color0.html -->
    hr { border: 0; width: 80%; border-bottom: 1px solid #aaa}
    .footer { text-align:center; padding-top:30px; font-style: italic; }
</style>

<!-- Use MathJax to render mathematics -->
<script type="text/x-mathjax-config">
MathJax.Hub.Config({
  TeX: {
     equationNumbers: {  autoNumber: "AMS"  },
     extensions: ["AMSmath.js"]
  }
});
</script>
<script type="text/javascript"
 src="http://cdn.mathjax.org/mathjax/latest/MathJax.js?config=TeX-AMS-MML_HTMLorMML">
</script>

</head>

<body bgcolor="white">

<title>%(title)s</title>


<h4>Date: %(date)s</h4>

<!-- main body -->

%(main)s


<!-- end of main body -->
</body>
</html>

************** File: author1.html *****************
<!--
Automatically generated HTML file from DocOnce source
(https://github.com/doconce/doconce/)
-->
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="generator" content="DocOnce: https://github.com/doconce/doconce/" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<meta name="description" content="Test of one author at one institution">

<title>Test of one author at one institution</title>


<style type="text/css">
/* blueish style */

/* Color definitions:  https://www.december.com/html/spec/color0.html
   CSS examples:       https://www.w3schools.com/css/css_examples.asp */

body {
  margin-top: 1.0em;
  background-color: #ffffff;
  font-family: Helvetica, Arial, FreeSans, san-serif;
  color: #000000;
}
h1 { font-size: 1.8em; color: #1e36ce; }
h2 { font-size: 1.6em; color: #1e36ce; }
h3 { font-size: 1.4em; color: #1e36ce; }
a { color: #1e36ce; text-decoration:none; }
tt { font-family: "Courier New", Courier; }
/* pre style removed because it will interfer with pygments */
p { text-indent: 0px; }
hr { border: 0; width: 80%; border-bottom: 1px solid #aaa}
p.caption { width: 80%; font-style: normal; text-align: left; }
hr.figure { border: 0; width: 80%; border-bottom: 1px solid #aaa}

div { text-align: justify; text-justify: inter-word; }
</style>


</head>

<!-- tocinfo
{'highest level': 0,
 'sections': [('Generalized References', 0, 'genrefs', 'genrefs'),
              ('Test of math', 0, None, 'test-of-math')]}
end of tocinfo -->

<body>



<script type="text/x-mathjax-config">
MathJax.Hub.Config({
  TeX: {
     equationNumbers: {  autoNumber: "AMS"  },
     extensions: ["AMSmath.js", "AMSsymbols.js", "autobold.js", "color.js"]
  }
});
</script>
<script type="text/javascript" async
 src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.1/MathJax.js?config=TeX-AMS-MML_HTMLorMML">
</script>



    
<!-- ------------------- main content ---------------------- -->



<center>
<h1>Test of one author at one institution</h1>
</center>  <!-- document title -->

<p></p>
<!-- author(s): John Doe -->

<center>
<b>John Doe</b>  (<tt>doe at cyberspace.net</tt>)
</center>

<p><!-- institution --></p>

<center>
<b>Cyberspace Inc.</b>
</center>

<br>
<center>
<h4>Jan 32, 2100</h4>
</center> <!-- date -->
<br>
<p></p>
<!-- Externaldocument: testdoc -->

<p></p>

<center>
<h1 id="genrefs">Generalized References</h1>
</center> <hr>

<p></p>
Sometimes a series of individual documents may be assembled to one
large document. The assembly impacts how references to sections
are written: when referring to a section in the same document, a label
can be used, while references to sections in other documents are
written differently, sometimes involving a link (URL) and a citation.
Especially if both the individual documents and the large assembly document
are to exist side by side, a flexible way of referencing is needed.
For this purpose, DocOnce offers <em>generalized references</em> which allows
a reference to have two different formulations, one for internal
references and one for external references. Since LaTeX supports
references to labels in external documents via the <code>xr</code> package,
the generalized references in DocOnce has a syntax that may utilize
the <code>xr</code> feature in LaTeX.

<p></p>
The syntax of generalized references reads


<!-- code=text typeset with pygments style "default" -->
<div class="highlight" style="background: #f8f8f8"><pre style="line-height: 125%;"><span></span>ref[internal][cite][external]
</pre></div>

If all standard <code>ref</code> references (with curly braces)
in the text <code>internal</code> are references
to labels in the present document, the above <code>ref</code> command is replaced
by the text <code>internal</code>. Otherwise, if cite is non-empty and the format
is <code>latex</code> or <code>pdflatex</code> one assumes that the references in <code>internal</code>
are to external documents declared by a comment line <code>#
Externaldocuments: testdoc, mydoc</code> (usually after the title, authors,
and date). In this case the output text is <code>internal cite</code> and the
LaTeX package <code>xr</code> is used to handle the labels in the external documents.
When referring to a complete chapter (not a section in it), which
corresponds to a complete external document, it does not make sense
to write out <code>internal cite</code> since the <code>internal</code> reference is a
chapter number. In such cases, the <code>internal</code> syntax can be used,
and if the label is in another LaTeX document, the output is just <code>cite</code>.
For all
output formats other than <code>latex</code> and <code>pdflatex</code>, the <code>external</code>
text will be the output.

<p></p>
Here is an example on a specific generalized reference to a section
in a document:


<!-- code=text typeset with pygments style "default" -->
<div class="highlight" style="background: #f8f8f8"><pre style="line-height: 125%;"><span></span>As explained in
ref[Section ref{subsec:ex}][in &quot;Langtangen, 2012&quot;:
&quot;https://hplgit.github.io/doconce/test/demo_testdoc.html#subsec:ex&quot;
cite{testdoc:12}][a &quot;section&quot;:
&quot;https://hplgit.github.io/doconce/test/demo_testdoc.html#subsec:ex&quot; in
the document &quot;A Document for Testing DocOnce&quot;:
&quot;https://hplgit.github.io/doconce/test/demo_testdoc.html&quot;
cite{testdoc:12}], DocOnce documents may include tables.
</pre></div>

With <code>latex</code> or <code>pdflatex</code> as output, this translates to


<!-- code=text typeset with pygments style "default" -->
<div class="highlight" style="background: #f8f8f8"><pre style="line-height: 125%;"><span></span>As explained in
Section ref{subsec:ex}, DocOnce documents may include tables.
</pre></div>

if the label <code>{subsec:ex}</code> appears in the present DocOnce source, and
otherwise


<!-- code=text typeset with pygments style "default" -->
<div class="highlight" style="background: #f8f8f8"><pre style="line-height: 125%;"><span></span>As explained in
Section ref{subsec:ex} in &quot;Langtangen, 2012&quot;:
&quot;https://hplgit.github.io/doconce/test/demo_testdoc.html#subsec:ex&quot;
cite{testdoc:12}, DocOnce documents may include tables.
</pre></div>

In a format different from <code>latex</code> and <code>pdflatex</code>, the effective DocOnce
text becomes


<!-- code=text typeset with pygments style "default" -->
<div class="highlight" style="background: #f8f8f8"><pre style="line-height: 125%;"><span></span>As explained in
a &quot;section&quot;:
&quot;https://hplgit.github.io/doconce/test/demo_testdoc.html#subsec:ex&quot; in
the document &quot;A Document for Testing DocOnce&quot;:
&quot;https://hplgit.github.io/doconce/test/demo_testdoc.html&quot;
cite{testdoc:12}, DocOnce documents may include tables.
</pre></div>

The rendered text in the current format <code>html</code> becomes

<p></p>
<blockquote>
    As explained in
    a <a href="https://hplgit.github.io/doconce/test/demo_testdoc.html#subsec:ex" target="_self">section</a> in
    the document <a href="https://hplgit.github.io/doconce/test/demo_testdoc.html" target="_self">A Document for Testing DocOnce</a>
    <a href="#testdoc:12">[1]</a>, DocOnce documents may include tables.
</blockquote>


<p></p>
A reference to an entire external document, which is usually a chapter
if the reference is internal in the DocOnce source, applies the
<code>refch</code> syntax:

<p></p>


<!-- code=text typeset with pygments style "default" -->
<div class="highlight" style="background: #f8f8f8"><pre style="line-height: 125%;"><span></span>As explained in
refch[Chapter ref{ch:testdoc}][&quot;Langtangen, 2012&quot;:
&quot;https://hplgit.github.io/doconce/test/demo_testdoc.html&quot;
cite{testdoc:12}][the document
&quot;A Document for Testing DocOnce&quot;:
&quot;https://hplgit.github.io/doconce/test/demo_testdoc.html&quot;
cite{testdoc:12}], DocOnce documents may include tables.
</pre></div>

The output now if <code>ch:testdoc</code> is not a label in the document,
becomes in the <code>latex</code> and <code>pdflatex</code> case

<p></p>


<!-- code=text typeset with pygments style "default" -->
<div class="highlight" style="background: #f8f8f8"><pre style="line-height: 125%;"><span></span>As explained in
&quot;Langtangen, 2012&quot;:
&quot;https://hplgit.github.io/doconce/test/demo_testdoc.html&quot;
cite{testdoc:12}, DocOnce documents may include tables.
</pre></div>

That is, the internal reference <code>Chapter ...</code> is omitted since
it is not meaningful to refer to an external document as "Chapter".
The resulting rendered text in the current format <code>html</code> becomes

<p></p>
<blockquote>
    As explained in
    the document
    <a href="https://hplgit.github.io/doconce/test/demo_testdoc.html" target="_self">A Document for Testing DocOnce</a>
    <a href="#testdoc:12">[1]</a>, DocOnce documents may include tables.
</blockquote>


<p></p>
Note that LaTeX cannot
have links to local files, so a complete URL on the form
<code>https://...</code> must be used.

<p></p>
And here is another example with internal references only:

<p></p>


<!-- code=text typeset with pygments style "default" -->
<div class="highlight" style="background: #f8f8f8"><pre style="line-height: 125%;"><span></span>Generalized references are described in ref[Section ref{genrefs}][dummy1][
dummy2].
</pre></div>

The text is rendered to

<p></p>
<blockquote>
    Generalized references are described in
    the section <a href="#genrefs">Generalized References</a>.
</blockquote>


<p></p>

<center>
<h1 id="test-of-math">Test of math </h1>
</center> <hr>

<p></p>
<!-- Here we test the chapter heading to see if latex output then has -->
<!-- book style rather than article style. -->

<p></p>
Inline math, \( a=b \), is the only math in this document.

<p></p>
<!-- Need BIBFILE because of cite{} examples -->

<p></p>
<!-- begin bibliography -->

<ol>
 <li> <div id="testdoc:12"></div> <b>H. P. Langtangen</b>. 
    A Document for Testing Doconce,
    <em>Simula Research Laboratory</em>,
    2015,
    <a href="http://hplgit.github.io/doconce/test/demo_testdoc.html" target="_self"><tt>http://hplgit.github.io/doconce/test/demo_testdoc.html</tt></a>.</li>
</ol>

<!-- end bibliography -->

<!-- ------------------- end of main content --------------- -->


</body>
</html>
    


************** File: author1.p.tex *****************
%%
%% Automatically generated file from DocOnce source
%% (https://github.com/doconce/doconce/)
%%
%%
% #ifdef PTEX2TEX_EXPLANATION
%%
%% The file follows the ptex2tex extended LaTeX format, see
%% ptex2tex: https://code.google.com/p/ptex2tex/
%%
%% Run
%%      ptex2tex myfile
%% or
%%      doconce ptex2tex myfile
%%
%% to turn myfile.p.tex into an ordinary LaTeX file myfile.tex.
%% (The ptex2tex program: https://code.google.com/p/ptex2tex)
%% Many preprocess options can be added to ptex2tex or doconce ptex2tex
%%
%%      ptex2tex -DMINTED myfile
%%      doconce ptex2tex myfile envir=minted
%%
%% ptex2tex will typeset code environments according to a global or local
%% .ptex2tex.cfg configure file. doconce ptex2tex will typeset code
%% according to options on the command line (just type doconce ptex2tex to
%% see examples). If doconce ptex2tex has envir=minted, it enables the
%% minted style without needing -DMINTED.
% #endif

% #define PREAMBLE

% #ifdef PREAMBLE
%-------------------- begin preamble ----------------------

\documentclass[%
oneside,                 % oneside: electronic viewing, twoside: printing
final,                   % draft: marks overfull hboxes, figures with paths
chapterprefix=true,      % "Chapter" word at beginning of each chapter
open=right,              % start new chapters on odd-numbered pages
10pt]{book}

\listfiles               %  print all files needed to compile this document

\usepackage{relsize,epsfig,makeidx,color,setspace,amsmath,amsfonts,amssymb}
\usepackage[table]{xcolor}
\usepackage{bm,ltablex,microtype}

\usepackage{graphicx}

\usepackage{ptex2tex}
% #ifdef MINTED
\usepackage{minted}
\usemintedstyle{default}
% #endif
\usepackage{fancyvrb}

\usepackage[T1]{fontenc}
%\usepackage[latin1]{inputenc}
\usepackage{ucs}
\usepackage[utf8x]{inputenc}

\usepackage{lmodern}         % Latin Modern fonts derived from Computer Modern

% Hyperlinks in PDF:
\definecolor{linkcolor}{rgb}{0,0,0.4}
\usepackage{hyperref}
\hypersetup{
    breaklinks=true,
    colorlinks=true,
    linkcolor=linkcolor,
    urlcolor=linkcolor,
    citecolor=black,
    filecolor=black,
    %filecolor=blue,
    pdfmenubar=true,
    pdftoolbar=true,
    bookmarksdepth=3   % Uncomment (and tweak) for PDF bookmarks with more levels than the TOC
    }
%\hyperbaseurl{}   % hyperlinks are relative to this root

\setcounter{tocdepth}{3}  % levels in table of contents

% prevent orhpans and widows
\clubpenalty = 10000
\widowpenalty = 10000

% Redefine double page clear to make it a blank page without headers
% (from BYUTextbook)
\makeatletter
\def\cleardoublepage{\clearpage\if@twoside \ifodd\c@page\else
\hbox{}
\thispagestyle{empty}
\newpage
\if@twocolumn\hbox{}\newpage\fi\fi\fi}
\makeatother
% These commands fiddle with the space left for page numbers in the TOC
% (from BYUTextbook)
\makeatletter
%\renewcommand{\@pnumwidth}{2em}
%\renewcommand{\@tocrmarg}{2.85em}
\makeatother

% Make sure blank even-numbered pages before new chapters are
% totally blank with no header
\newcommand{\clearemptydoublepage}{\clearpage{\pagestyle{empty}\cleardoublepage}}
%\let\cleardoublepage\clearemptydoublepage % caused error in the toc

% --- end of standard preamble for documents ---




% References to labels in external documents:
\usepackage{xr}

\externaldocument{testdoc}

% Add external .aux files to \listfiles list:
\makeatletter
\@addtofilelist{testdoc.aux}
\makeatother


% insert custom LaTeX commands...


\raggedbottom
\makeindex
\usepackage[totoc]{idxlayout}   % for index in the toc
\usepackage[nottoc]{tocbibind}  % for references/bibliography in the toc

%-------------------- end preamble ----------------------

\begin{document}

% matching end for #ifdef PREAMBLE
% #endif

\newcommand{\exercisesection}[1]{\subsection*{#1}}

\input{newcommands_bfmath}
\input{newcommands_replace}

% ------------------- main content ----------------------



% ----------------- title -------------------------

\thispagestyle{empty}

\begin{center}
{\LARGE\bf
\begin{spacing}{1.25}
Test of one author at one institution
\end{spacing}
}
\end{center}

% ----------------- author(s) -------------------------

\begin{center}
{\bf John Doe (\texttt{doe@cyberspace.net})}
\end{center}

    \begin{center}
% List of all institutions:
\centerline{{\small Cyberspace Inc.}}
\end{center}
    
% ----------------- end author(s) -------------------------

% --- begin date ---
\begin{center}
Jan 32, 2100
\end{center}
% --- end date ---

\vspace{1cm}


% Externaldocument: testdoc

\chapter{Generalized References}
\label{genrefs}

Sometimes a series of individual documents may be assembled to one
large document. The assembly impacts how references to sections
are written: when referring to a section in the same document, a label
can be used, while references to sections in other documents are
written differently, sometimes involving a link (URL) and a citation.
Especially if both the individual documents and the large assembly document
are to exist side by side, a flexible way of referencing is needed.
For this purpose, DocOnce offers \emph{generalized references} which allows
a reference to have two different formulations, one for internal
references and one for external references. Since {\LaTeX} supports
references to labels in external documents via the \texttt{xr} package,
the generalized references in DocOnce has a syntax that may utilize
the \texttt{xr} feature in {\LaTeX}.

The syntax of generalized references reads
\bccq
ref[internal][cite][external]
\eccq
If all standard \texttt{ref} references (with curly braces)
in the text \texttt{internal} are references
to labels in the present document, the above \texttt{ref} command is replaced
by the text \texttt{internal}. Otherwise, if cite is non-empty and the format
is \texttt{latex} or \texttt{pdflatex} one assumes that the references in \texttt{internal}
are to external documents declared by a comment line \Verb!# Externaldocuments: testdoc, mydoc! (usually after the title, authors,
and date). In this case the output text is \texttt{internal cite} and the
{\LaTeX} package \texttt{xr} is used to handle the labels in the external documents.
When referring to a complete chapter (not a section in it), which
corresponds to a complete external document, it does not make sense
to write out \texttt{internal cite} since the \texttt{internal} reference is a
chapter number. In such cases, the \texttt{internal} syntax can be used,
and if the label is in another {\LaTeX} document, the output is just \texttt{cite}.
For all
output formats other than \texttt{latex} and \texttt{pdflatex}, the \texttt{external}
text will be the output.

Here is an example on a specific generalized reference to a section
in a document:
\bccq
As explained in
ref[Section ref{subsec:ex}][in "Langtangen, 2012":
"https://hplgit.github.io/doconce/test/demo_testdoc.html#subsec:ex"
cite{testdoc:12}][a "section":
"https://hplgit.github.io/doconce/test/demo_testdoc.html#subsec:ex" in
the document "A Document for Testing DocOnce":
"https://hplgit.github.io/doconce/test/demo_testdoc.html"
cite{testdoc:12}], DocOnce documents may include tables.
\eccq
With \texttt{latex} or \texttt{pdflatex} as output, this translates to
\bccq
As explained in
Section ref{subsec:ex}, DocOnce documents may include tables.
\eccq
if the label \Verb!{subsec:ex}! appears in the present DocOnce source, and
otherwise
\bccq
As explained in
Section ref{subsec:ex} in "Langtangen, 2012":
"https://hplgit.github.io/doconce/test/demo_testdoc.html#subsec:ex"
cite{testdoc:12}, DocOnce documents may include tables.
\eccq
In a format different from \texttt{latex} and \texttt{pdflatex}, the effective DocOnce
text becomes
\bccq
As explained in
a "section":
"https://hplgit.github.io/doconce/test/demo_testdoc.html#subsec:ex" in
the document "A Document for Testing DocOnce":
"https://hplgit.github.io/doconce/test/demo_testdoc.html"
cite{testdoc:12}, DocOnce documents may include tables.
\eccq
The rendered text in the current format \texttt{latex} becomes


\begin{quote}
As explained in
Section~\ref{subsec:ex}in \href{{https://hplgit.github.io/doconce/test/demo_testdoc.html#subsec:ex}}{Langtangen, 2012}
\cite{testdoc:12}, DocOnce documents may include tables.
\end{quote}


A reference to an entire external document, which is usually a chapter
if the reference is internal in the DocOnce source, applies the
\texttt{refch} syntax:

\bccq
As explained in
refch[Chapter ref{ch:testdoc}]["Langtangen, 2012":
"https://hplgit.github.io/doconce/test/demo_testdoc.html"
cite{testdoc:12}][the document
"A Document for Testing DocOnce":
"https://hplgit.github.io/doconce/test/demo_testdoc.html"
cite{testdoc:12}], DocOnce documents may include tables.
\eccq
The output now if \texttt{ch:testdoc} is not a label in the document,
becomes in the \texttt{latex} and \texttt{pdflatex} case

\bccq
As explained in
"Langtangen, 2012":
"https://hplgit.github.io/doconce/test/demo_testdoc.html"
cite{testdoc:12}, DocOnce documents may include tables.
\eccq
That is, the internal reference \texttt{Chapter ...} is omitted since
it is not meaningful to refer to an external document as "Chapter".
The resulting rendered text in the current format \texttt{latex} becomes


\begin{quote}
As explained in
\href{{https://hplgit.github.io/doconce/test/demo_testdoc.html}}{Langtangen, 2012}
\cite{testdoc:12}, DocOnce documents may include tables.
\end{quote}


Note that {\LaTeX} cannot
have links to local files, so a complete URL on the form
\texttt{https://...} must be used.

And here is another example with internal references only:

\bccq
Generalized references are described in ref[Section ref{genrefs}][dummy1][
dummy2].
\eccq
The text is rendered to


\begin{quote}
Generalized references are described in
Section~\ref{genrefs}.
\end{quote}


\chapter{Test of math}

% Here we test the chapter heading to see if latex output then has
% book style rather than article style.

Inline math, $a=b$, is the only math in this document.

% Need BIBFILE because of \cite{} examples
\clearemptydoublepage

\bibliographystyle{plain}
\bibliography{papers}


% ------------------- end of main content ---------------

% #ifdef PREAMBLE
\end{document}
% #endif


************** File: author1.rst *****************
.. Automatically generated Sphinx-extended reStructuredText file from DocOnce source
   (https://github.com/doconce/doconce/)

.. Document title:

Test of one author at one institution
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:Authors: John Doe (doe at cyberspace.net)
:Date: Jan 32, 2100

.. Externaldocument: testdoc

.. _genrefs:

Generalized References
%%%%%%%%%%%%%%%%%%%%%%

Sometimes a series of individual documents may be assembled to one
large document. The assembly impacts how references to sections
are written: when referring to a section in the same document, a label
can be used, while references to sections in other documents are
written differently, sometimes involving a link (URL) and a citation.
Especially if both the individual documents and the large assembly document
are to exist side by side, a flexible way of referencing is needed.
For this purpose, DocOnce offers *generalized references* which allows
a reference to have two different formulations, one for internal
references and one for external references. Since LaTeX supports
references to labels in external documents via the ``xr`` package,
the generalized references in DocOnce has a syntax that may utilize
the ``xr`` feature in LaTeX.

The syntax of generalized references reads

.. code-block:: text

    ref[internal][cite][external]

If all standard ``ref`` references (with curly braces)
in the text ``internal`` are references
to labels in the present document, the above ``ref`` command is replaced
by the text ``internal``. Otherwise, if cite is non-empty and the format
is ``latex`` or ``pdflatex`` one assumes that the references in ``internal``
are to external documents declared by a comment line ``#
Externaldocuments: testdoc, mydoc`` (usually after the title, authors,
and date). In this case the output text is ``internal cite`` and the
LaTeX package ``xr`` is used to handle the labels in the external documents.
When referring to a complete chapter (not a section in it), which
corresponds to a complete external document, it does not make sense
to write out ``internal cite`` since the ``internal`` reference is a
chapter number. In such cases, the ``internal`` syntax can be used,
and if the label is in another LaTeX document, the output is just ``cite``.
For all
output formats other than ``latex`` and ``pdflatex``, the ``external``
text will be the output.

Here is an example on a specific generalized reference to a section
in a document:

.. code-block:: text

    As explained in
    ref[Section ref{subsec:ex}][in "Langtangen, 2012":
    "https://hplgit.github.io/doconce/test/demo_testdoc.html#subsec:ex"
    cite{testdoc:12}][a "section":
    "https://hplgit.github.io/doconce/test/demo_testdoc.html#subsec:ex" in
    the document "A Document for Testing DocOnce":
    "https://hplgit.github.io/doconce/test/demo_testdoc.html"
    cite{testdoc:12}], DocOnce documents may include tables.

With ``latex`` or ``pdflatex`` as output, this translates to

.. code-block:: text

    As explained in
    Section ref{subsec:ex}, DocOnce documents may include tables.

if the label ``{subsec:ex}`` appears in the present DocOnce source, and
otherwise

.. code-block:: text

    As explained in
    Section ref{subsec:ex} in "Langtangen, 2012":
    "https://hplgit.github.io/doconce/test/demo_testdoc.html#subsec:ex"
    cite{testdoc:12}, DocOnce documents may include tables.

In a format different from ``latex`` and ``pdflatex``, the effective DocOnce
text becomes

.. code-block:: text

    As explained in
    a "section":
    "https://hplgit.github.io/doconce/test/demo_testdoc.html#subsec:ex" in
    the document "A Document for Testing DocOnce":
    "https://hplgit.github.io/doconce/test/demo_testdoc.html"
    cite{testdoc:12}, DocOnce documents may include tables.

The rendered text in the current format ``sphinx`` becomes


..

    As explained in
    a `section <https://hplgit.github.io/doconce/test/demo_testdoc.html#subsec:ex>`__ in
    the document `A Document for Testing DocOnce <https://hplgit.github.io/doconce/test/demo_testdoc.html>`__
    [Ref1]_, DocOnce documents may include tables.



A reference to an entire external document, which is usually a chapter
if the reference is internal in the DocOnce source, applies the
``refch`` syntax:

.. code-block:: text

    As explained in
    refch[Chapter ref{ch:testdoc}]["Langtangen, 2012":
    "https://hplgit.github.io/doconce/test/demo_testdoc.html"
    cite{testdoc:12}][the document
    "A Document for Testing DocOnce":
    "https://hplgit.github.io/doconce/test/demo_testdoc.html"
    cite{testdoc:12}], DocOnce documents may include tables.

The output now if ``ch:testdoc`` is not a label in the document,
becomes in the ``latex`` and ``pdflatex`` case

.. code-block:: text

    As explained in
    "Langtangen, 2012":
    "https://hplgit.github.io/doconce/test/demo_testdoc.html"
    cite{testdoc:12}, DocOnce documents may include tables.

That is, the internal reference ``Chapter ...`` is omitted since
it is not meaningful to refer to an external document as "Chapter".
The resulti