/* This file was generated from the templator_front.org org-mode file.
   To generate it, open templator_front.org in Emacs and execute
   M-x org-babel-tangle
*/

#include <pthread.h>
#include <assert.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include "trexio.h"
#include "trexio_private.h"
#include "trexio_s.h"
#include "trexio_text.h"
#include "trexio_hdf5.h"
/*
#include "trexio_json.h"
*/

const char*
trexio_string_of_error (const trexio_exit_code error)
{
  switch (error) {
  case TREXIO_FAILURE:
    return "Unknown failure";
    break;
  case TREXIO_SUCCESS:
    return "Success";
    break;
  case TREXIO_INVALID_ARG_1:
    return "Invalid argument 1";
    break;
  case TREXIO_INVALID_ARG_2:
    return "Invalid argument 2";
    break;
  case TREXIO_INVALID_ARG_3:
    return "Invalid argument 3";
    break;
  case TREXIO_INVALID_ARG_4:
    return "Invalid argument 4";
    break;
  case TREXIO_INVALID_ARG_5:
    return "Invalid argument 5";
    break;
  case TREXIO_END:
    return "End of file";
    break;
  case TREXIO_READONLY:
    return "Read-only file";
    break;
  case TREXIO_ERRNO:
    return strerror(errno);
    break;
  case TREXIO_INVALID_ID:
    return "Invalid ID";
    break;
  case TREXIO_ALLOCATION_FAILED:
    return "Allocation failed";
    break;
  case TREXIO_HAS_NOT:
    return "Element absent";
    break;
  case TREXIO_INVALID_NUM:
    return "Invalid dimensions";
    break;
  case TREXIO_ATTR_ALREADY_EXISTS:
    return "Attribute already exists";
    break;
  case TREXIO_DSET_ALREADY_EXISTS:
    return "Dataset already exists";
    break;
  case TREXIO_OPEN_ERROR:
    return "Error opening file";
    break;
  case TREXIO_LOCK_ERROR:
    return "Error locking file";
    break;
  case TREXIO_UNLOCK_ERROR:
    return "Error unlocking file";
    break;
  case TREXIO_FILE_ERROR:
    return "Invalid file handle";
    break;
  case TREXIO_GROUP_READ_ERROR:
    return "Error reading group";
    break;
  case TREXIO_GROUP_WRITE_ERROR:
    return "Error writing group";
    break;
  case TREXIO_ELEM_READ_ERROR:
    return "Error reading element";
    break;
  case TREXIO_ELEM_WRITE_ERROR:
    return "Error writing element";
    break;
  case TREXIO_UNSAFE_ARRAY_DIM:
    return "Access to memory beyond allocated";
    break;
  case TREXIO_ATTR_MISSING:
    return "Attribute does not exist in the file";
    break;
  case TREXIO_DSET_MISSING:
    return "Dataset does not exist in the file";
    break;
  case TREXIO_INVALID_STR_LEN:
    return "Invalid max_str_len";
    break;
  }
  return "Unknown error";
}

void
trexio_string_of_error_f (const trexio_exit_code error, char result[128])
{
  strncpy(result, trexio_string_of_error(error), 128);
}

trexio_t*
trexio_open(const char* file_name, const char mode,
	    const back_end_t back_end)
{

  if (file_name == NULL) return NULL;
  if (file_name[0] == '\0') return NULL;
  /* Check overflow in file_name */

  if (back_end <  0) return NULL;
  if (back_end >= TREXIO_INVALID_BACK_END) return NULL;

  if (mode != 'r' && mode != 'w') return NULL;

  trexio_t* result = NULL;
  void* result_tmp = NULL;

  /* Allocate data structures */
  switch (back_end) {

  case TREXIO_TEXT:
    result_tmp = malloc(sizeof(trexio_text_t));
    break;

  case TREXIO_HDF5:
    result_tmp = malloc(sizeof(trexio_hdf5_t));
    break;
/*
  case TREXIO_JSON:
    result = (trexio_t*) malloc (sizeof(trexio_json_t));
    break;
*/
  }
  result = (trexio_t*) result_tmp;

  assert (result != NULL);    /* TODO: Error handling */


  /* Data for the parent type */

  strncpy(result->file_name, file_name, TREXIO_MAX_FILENAME_LENGTH);
  if (result->file_name[TREXIO_MAX_FILENAME_LENGTH-1] != '\0') {
    free(result);
    return NULL;
  }

  strncpy(result->version, PACKAGE_VERSION, 16);
  if (result->version[15] != '\0') {
    free(result);
    return NULL;
  }

  result->back_end    = back_end;
  result->mode        = mode;
  result->one_based   = false;  // Need to be flipped in Fortran interface
  int irc = pthread_mutex_init ( &(result->thread_lock), NULL);
  if (irc != 0) {
    free(result);
    return NULL;
  }
  assert (irc == 0);

  trexio_exit_code rc;

  /* Back end initialization */

  rc = TREXIO_OPEN_ERROR;

  switch (back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_init(result);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_init(result);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_init(result);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) {
    free(result);
    return NULL;
  }

  rc = trexio_has_metadata_package_version(result);
  if (rc == TREXIO_FAILURE) {
    free(result);
    return NULL;
  }
 
  if (rc == TREXIO_HAS_NOT) {
    switch (back_end) {

    case TREXIO_TEXT:
      rc = trexio_text_write_metadata_package_version(result, PACKAGE_VERSION);
      break;

    case TREXIO_HDF5:
      rc = trexio_hdf5_write_metadata_package_version(result, PACKAGE_VERSION);
      break;
/*
    case TREXIO_JSON:
      rc = trexio_json_write_metadata_package_version(result, PACKAGE_VERSION);
      break;
*/
    }
  }

  if (rc != TREXIO_SUCCESS) {
    free(result);
    return NULL;
  }


  /* File locking */

  rc = TREXIO_LOCK_ERROR;

  switch (back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_lock(result);
    break;
  /* HDF5 v.>=1.10 has file locking activated by default */
  case TREXIO_HDF5:
    rc = TREXIO_SUCCESS;
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_lock(result);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) {
    free(result);
    return NULL;
  }

  return result;
}

trexio_exit_code trexio_set_one_based(trexio_t* file)
{
  if (file == NULL)
    return TREXIO_FILE_ERROR;

  file->one_based = true;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_close (trexio_t* file)
{

  if (file == NULL) return TREXIO_FILE_ERROR;

  trexio_exit_code rc = TREXIO_FAILURE;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  /* Terminate the back end */
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_deinit(file);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_deinit(file);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_deinit(file);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) {
    FREE(file);
    return rc;
  }

  /* File unlocking */

  rc = TREXIO_UNLOCK_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_unlock(file);
    break;

  case TREXIO_HDF5:
    rc = TREXIO_SUCCESS;
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_unlock(file);
    break;
*/
  }

  /* Terminate front end */

  int irc = pthread_mutex_destroy( &(file->thread_lock) );

  free(file);

  if (irc != 0) return TREXIO_ERRNO;
  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}
trexio_exit_code
trexio_has_metadata_package_version (trexio_t* const file)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_metadata_package_version(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_metadata_package_version(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_metadata_package_version(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_metadata_description (trexio_t* const file)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_metadata_description(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_metadata_description(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_metadata_description(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_nucleus_point_group (trexio_t* const file)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_nucleus_point_group(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_nucleus_point_group(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_nucleus_point_group(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_basis_type (trexio_t* const file)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_basis_type(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_basis_type(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_basis_type(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_mo_type (trexio_t* const file)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_mo_type(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_mo_type(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_mo_type(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_nucleus_charge (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_nucleus_charge(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_nucleus_charge(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_nucleus_charge(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_nucleus_coord (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_nucleus_coord(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_nucleus_coord(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_nucleus_coord(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ecp_lmax_plus_1 (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ecp_lmax_plus_1(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ecp_lmax_plus_1(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ecp_lmax_plus_1(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ecp_z_core (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ecp_z_core(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ecp_z_core(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ecp_z_core(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ecp_local_n (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ecp_local_n(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ecp_local_n(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ecp_local_n(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ecp_local_exponent (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ecp_local_exponent(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ecp_local_exponent(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ecp_local_exponent(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ecp_local_coef (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ecp_local_coef(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ecp_local_coef(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ecp_local_coef(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ecp_local_power (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ecp_local_power(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ecp_local_power(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ecp_local_power(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ecp_non_local_n (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ecp_non_local_n(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ecp_non_local_n(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ecp_non_local_n(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ecp_non_local_exponent (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ecp_non_local_exponent(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ecp_non_local_exponent(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ecp_non_local_exponent(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ecp_non_local_coef (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ecp_non_local_coef(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ecp_non_local_coef(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ecp_non_local_coef(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ecp_non_local_power (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ecp_non_local_power(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ecp_non_local_power(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ecp_non_local_power(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_basis_nucleus_index (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_basis_nucleus_index(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_basis_nucleus_index(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_basis_nucleus_index(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_basis_nucleus_shell_num (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_basis_nucleus_shell_num(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_basis_nucleus_shell_num(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_basis_nucleus_shell_num(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_basis_shell_ang_mom (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_basis_shell_ang_mom(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_basis_shell_ang_mom(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_basis_shell_ang_mom(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_basis_shell_prim_num (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_basis_shell_prim_num(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_basis_shell_prim_num(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_basis_shell_prim_num(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_basis_shell_factor (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_basis_shell_factor(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_basis_shell_factor(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_basis_shell_factor(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_basis_shell_prim_index (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_basis_shell_prim_index(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_basis_shell_prim_index(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_basis_shell_prim_index(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_basis_exponent (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_basis_exponent(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_basis_exponent(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_basis_exponent(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_basis_coefficient (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_basis_coefficient(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_basis_coefficient(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_basis_coefficient(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_basis_prim_factor (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_basis_prim_factor(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_basis_prim_factor(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_basis_prim_factor(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ao_shell (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ao_shell(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ao_shell(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ao_shell(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ao_normalization (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ao_normalization(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ao_normalization(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ao_normalization(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ao_1e_int_overlap (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ao_1e_int_overlap(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ao_1e_int_overlap(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ao_1e_int_overlap(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ao_1e_int_kinetic (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ao_1e_int_kinetic(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ao_1e_int_kinetic(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ao_1e_int_kinetic(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ao_1e_int_potential_n_e (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ao_1e_int_potential_n_e(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ao_1e_int_potential_n_e(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ao_1e_int_potential_n_e(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ao_1e_int_ecp_local (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ao_1e_int_ecp_local(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ao_1e_int_ecp_local(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ao_1e_int_ecp_local(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ao_1e_int_ecp_non_local (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ao_1e_int_ecp_non_local(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ao_1e_int_ecp_non_local(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ao_1e_int_ecp_non_local(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ao_1e_int_core_hamiltonian (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ao_1e_int_core_hamiltonian(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ao_1e_int_core_hamiltonian(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ao_1e_int_core_hamiltonian(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ao_2e_int_eri (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ao_2e_int_eri(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ao_2e_int_eri(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ao_2e_int_eri(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ao_2e_int_eri_lr (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ao_2e_int_eri_lr(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ao_2e_int_eri_lr(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ao_2e_int_eri_lr(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_mo_coefficient (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_mo_coefficient(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_mo_coefficient(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_mo_coefficient(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_mo_occupation (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_mo_occupation(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_mo_occupation(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_mo_occupation(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_mo_1e_int_overlap (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_mo_1e_int_overlap(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_mo_1e_int_overlap(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_mo_1e_int_overlap(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_mo_1e_int_kinetic (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_mo_1e_int_kinetic(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_mo_1e_int_kinetic(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_mo_1e_int_kinetic(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_mo_1e_int_potential_n_e (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_mo_1e_int_potential_n_e(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_mo_1e_int_potential_n_e(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_mo_1e_int_potential_n_e(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_mo_1e_int_ecp_local (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_mo_1e_int_ecp_local(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_mo_1e_int_ecp_local(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_mo_1e_int_ecp_local(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_mo_1e_int_ecp_non_local (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_mo_1e_int_ecp_non_local(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_mo_1e_int_ecp_non_local(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_mo_1e_int_ecp_non_local(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_mo_1e_int_core_hamiltonian (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_mo_1e_int_core_hamiltonian(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_mo_1e_int_core_hamiltonian(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_mo_1e_int_core_hamiltonian(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_mo_2e_int_eri (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_mo_2e_int_eri(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_mo_2e_int_eri(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_mo_2e_int_eri(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_mo_2e_int_eri_lr (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_mo_2e_int_eri_lr(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_mo_2e_int_eri_lr(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_mo_2e_int_eri_lr(file);
    break;
*/
  }
  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_metadata_code (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_metadata_code(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_metadata_code(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_metadata_code(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_metadata_author (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_metadata_author(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_metadata_author(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_metadata_author(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_nucleus_label (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_nucleus_label(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_nucleus_label(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_nucleus_label(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_mo_class (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_mo_class(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_mo_class(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_mo_class(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_mo_symmetry (trexio_t* const file)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_mo_symmetry(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_mo_symmetry(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_mo_symmetry(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_metadata_code_num (trexio_t* const file)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_metadata_code_num(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_metadata_code_num(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_metadata_code_num(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_metadata_author_num (trexio_t* const file)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_metadata_author_num(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_metadata_author_num(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_metadata_author_num(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_electron_up_num (trexio_t* const file)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_electron_up_num(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_electron_up_num(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_electron_up_num(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_electron_dn_num (trexio_t* const file)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_electron_dn_num(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_electron_dn_num(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_electron_dn_num(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_nucleus_num (trexio_t* const file)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_nucleus_num(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_nucleus_num(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_nucleus_num(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ecp_local_num_n_max (trexio_t* const file)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ecp_local_num_n_max(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ecp_local_num_n_max(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ecp_local_num_n_max(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ecp_non_local_num_n_max (trexio_t* const file)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ecp_non_local_num_n_max(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ecp_non_local_num_n_max(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ecp_non_local_num_n_max(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_basis_num (trexio_t* const file)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_basis_num(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_basis_num(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_basis_num(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_basis_prim_num (trexio_t* const file)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_basis_prim_num(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_basis_prim_num(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_basis_prim_num(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ao_cartesian (trexio_t* const file)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ao_cartesian(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ao_cartesian(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ao_cartesian(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_ao_num (trexio_t* const file)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_ao_num(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_ao_num(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_ao_num(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_has_mo_num (trexio_t* const file)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_has_mo_num(file);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_has_mo_num(file);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_has_mo_num(file);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_read_metadata_package_version (trexio_t* const file, char* const str_out, const int32_t max_str_len)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (str_out  == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_metadata_package_version(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_read_metadata_package_version(file, str_out, (uint32_t) max_str_len);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_read_metadata_package_version(file, str_out, (uint32_t) max_str_len);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_read_metadata_package_version(file, str);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_read_metadata_description (trexio_t* const file, char* const str_out, const int32_t max_str_len)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (str_out  == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_metadata_description(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_read_metadata_description(file, str_out, (uint32_t) max_str_len);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_read_metadata_description(file, str_out, (uint32_t) max_str_len);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_read_metadata_description(file, str);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_read_nucleus_point_group (trexio_t* const file, char* const str_out, const int32_t max_str_len)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (str_out  == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_nucleus_point_group(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_read_nucleus_point_group(file, str_out, (uint32_t) max_str_len);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_read_nucleus_point_group(file, str_out, (uint32_t) max_str_len);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_read_nucleus_point_group(file, str);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_read_basis_type (trexio_t* const file, char* const str_out, const int32_t max_str_len)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (str_out  == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_basis_type(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_read_basis_type(file, str_out, (uint32_t) max_str_len);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_read_basis_type(file, str_out, (uint32_t) max_str_len);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_read_basis_type(file, str);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_read_mo_type (trexio_t* const file, char* const str_out, const int32_t max_str_len)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (str_out  == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_mo_type(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_read_mo_type(file, str_out, (uint32_t) max_str_len);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_read_mo_type(file, str_out, (uint32_t) max_str_len);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_read_mo_type(file, str);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_read_nucleus_charge_32 (trexio_t* const file, float* const nucleus_charge)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (nucleus_charge == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_charge(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* nucleus_charge_64 = CALLOC(dim_size, double);
  if (nucleus_charge_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_nucleus_charge(file, nucleus_charge_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_nucleus_charge(file, nucleus_charge_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_nucleus_charge(file, nucleus_charge_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(nucleus_charge_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      nucleus_charge[i] = (float) nucleus_charge_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      nucleus_charge[i] = (float) nucleus_charge_64[i];
    }
  }

  FREE(nucleus_charge_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_nucleus_coord_32 (trexio_t* const file, float* const nucleus_coord)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (nucleus_coord == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_coord(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, 3};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* nucleus_coord_64 = CALLOC(dim_size, double);
  if (nucleus_coord_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_nucleus_coord(file, nucleus_coord_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_nucleus_coord(file, nucleus_coord_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_nucleus_coord(file, nucleus_coord_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(nucleus_coord_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      nucleus_coord[i] = (float) nucleus_coord_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      nucleus_coord[i] = (float) nucleus_coord_64[i];
    }
  }

  FREE(nucleus_coord_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_lmax_plus_1_32 (trexio_t* const file, int32_t* const ecp_lmax_plus_1)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_lmax_plus_1 == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_lmax_plus_1(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* ecp_lmax_plus_1_64 = CALLOC(dim_size, int64_t);
  if (ecp_lmax_plus_1_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_lmax_plus_1(file, ecp_lmax_plus_1_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_lmax_plus_1(file, ecp_lmax_plus_1_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_lmax_plus_1(file, ecp_lmax_plus_1_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ecp_lmax_plus_1_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_lmax_plus_1[i] = (int32_t) ecp_lmax_plus_1_64[i] + (int32_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_lmax_plus_1[i] = (int32_t) ecp_lmax_plus_1_64[i];
    }
  }

  FREE(ecp_lmax_plus_1_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_z_core_32 (trexio_t* const file, float* const ecp_z_core)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_z_core == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_z_core(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ecp_z_core_64 = CALLOC(dim_size, double);
  if (ecp_z_core_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_z_core(file, ecp_z_core_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_z_core(file, ecp_z_core_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_z_core(file, ecp_z_core_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ecp_z_core_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_z_core[i] = (float) ecp_z_core_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_z_core[i] = (float) ecp_z_core_64[i];
    }
  }

  FREE(ecp_z_core_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_local_n_32 (trexio_t* const file, int32_t* const ecp_local_n)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_local_n == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_n(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* ecp_local_n_64 = CALLOC(dim_size, int64_t);
  if (ecp_local_n_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_local_n(file, ecp_local_n_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_local_n(file, ecp_local_n_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_local_n(file, ecp_local_n_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ecp_local_n_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_local_n[i] = (int32_t) ecp_local_n_64[i] + (int32_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_local_n[i] = (int32_t) ecp_local_n_64[i];
    }
  }

  FREE(ecp_local_n_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_local_exponent_32 (trexio_t* const file, float* const ecp_local_exponent)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_local_exponent == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_exponent(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ecp_local_exponent_64 = CALLOC(dim_size, double);
  if (ecp_local_exponent_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_local_exponent(file, ecp_local_exponent_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_local_exponent(file, ecp_local_exponent_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_local_exponent(file, ecp_local_exponent_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ecp_local_exponent_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_local_exponent[i] = (float) ecp_local_exponent_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_local_exponent[i] = (float) ecp_local_exponent_64[i];
    }
  }

  FREE(ecp_local_exponent_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_local_coef_32 (trexio_t* const file, float* const ecp_local_coef)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_local_coef == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_coef(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ecp_local_coef_64 = CALLOC(dim_size, double);
  if (ecp_local_coef_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_local_coef(file, ecp_local_coef_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_local_coef(file, ecp_local_coef_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_local_coef(file, ecp_local_coef_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ecp_local_coef_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_local_coef[i] = (float) ecp_local_coef_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_local_coef[i] = (float) ecp_local_coef_64[i];
    }
  }

  FREE(ecp_local_coef_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_local_power_32 (trexio_t* const file, int32_t* const ecp_local_power)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_local_power == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_power(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* ecp_local_power_64 = CALLOC(dim_size, int64_t);
  if (ecp_local_power_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_local_power(file, ecp_local_power_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_local_power(file, ecp_local_power_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_local_power(file, ecp_local_power_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ecp_local_power_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_local_power[i] = (int32_t) ecp_local_power_64[i] + (int32_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_local_power[i] = (int32_t) ecp_local_power_64[i];
    }
  }

  FREE(ecp_local_power_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_non_local_n_32 (trexio_t* const file, int32_t* const ecp_non_local_n)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_non_local_n == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_n(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* ecp_non_local_n_64 = CALLOC(dim_size, int64_t);
  if (ecp_non_local_n_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_non_local_n(file, ecp_non_local_n_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_non_local_n(file, ecp_non_local_n_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_non_local_n(file, ecp_non_local_n_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ecp_non_local_n_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_non_local_n[i] = (int32_t) ecp_non_local_n_64[i] + (int32_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_non_local_n[i] = (int32_t) ecp_non_local_n_64[i];
    }
  }

  FREE(ecp_non_local_n_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_non_local_exponent_32 (trexio_t* const file, float* const ecp_non_local_exponent)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_non_local_exponent == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_exponent(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_non_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ecp_non_local_exponent_64 = CALLOC(dim_size, double);
  if (ecp_non_local_exponent_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_non_local_exponent(file, ecp_non_local_exponent_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_non_local_exponent(file, ecp_non_local_exponent_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_non_local_exponent(file, ecp_non_local_exponent_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ecp_non_local_exponent_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_non_local_exponent[i] = (float) ecp_non_local_exponent_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_non_local_exponent[i] = (float) ecp_non_local_exponent_64[i];
    }
  }

  FREE(ecp_non_local_exponent_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_non_local_coef_32 (trexio_t* const file, float* const ecp_non_local_coef)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_non_local_coef == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_coef(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_non_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ecp_non_local_coef_64 = CALLOC(dim_size, double);
  if (ecp_non_local_coef_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_non_local_coef(file, ecp_non_local_coef_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_non_local_coef(file, ecp_non_local_coef_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_non_local_coef(file, ecp_non_local_coef_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ecp_non_local_coef_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_non_local_coef[i] = (float) ecp_non_local_coef_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_non_local_coef[i] = (float) ecp_non_local_coef_64[i];
    }
  }

  FREE(ecp_non_local_coef_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_non_local_power_32 (trexio_t* const file, int32_t* const ecp_non_local_power)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_non_local_power == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_power(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_non_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* ecp_non_local_power_64 = CALLOC(dim_size, int64_t);
  if (ecp_non_local_power_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_non_local_power(file, ecp_non_local_power_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_non_local_power(file, ecp_non_local_power_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_non_local_power(file, ecp_non_local_power_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ecp_non_local_power_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_non_local_power[i] = (int32_t) ecp_non_local_power_64[i] + (int32_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_non_local_power[i] = (int32_t) ecp_non_local_power_64[i];
    }
  }

  FREE(ecp_non_local_power_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_nucleus_index_32 (trexio_t* const file, int32_t* const basis_nucleus_index)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_nucleus_index == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_nucleus_index(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* basis_nucleus_index_64 = CALLOC(dim_size, int64_t);
  if (basis_nucleus_index_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_basis_nucleus_index(file, basis_nucleus_index_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_nucleus_index(file, basis_nucleus_index_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_nucleus_index(file, basis_nucleus_index_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(basis_nucleus_index_64);
    return rc;
  }

  if (file->one_based) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_nucleus_index[i] = (int32_t) basis_nucleus_index_64[i] + (int32_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_nucleus_index[i] = (int32_t) basis_nucleus_index_64[i];
    }
  }

  FREE(basis_nucleus_index_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_nucleus_shell_num_32 (trexio_t* const file, int32_t* const basis_nucleus_shell_num)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_nucleus_shell_num == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_nucleus_shell_num(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* basis_nucleus_shell_num_64 = CALLOC(dim_size, int64_t);
  if (basis_nucleus_shell_num_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_basis_nucleus_shell_num(file, basis_nucleus_shell_num_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_nucleus_shell_num(file, basis_nucleus_shell_num_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_nucleus_shell_num(file, basis_nucleus_shell_num_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(basis_nucleus_shell_num_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_nucleus_shell_num[i] = (int32_t) basis_nucleus_shell_num_64[i] + (int32_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_nucleus_shell_num[i] = (int32_t) basis_nucleus_shell_num_64[i];
    }
  }

  FREE(basis_nucleus_shell_num_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_shell_ang_mom_32 (trexio_t* const file, int32_t* const basis_shell_ang_mom)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_shell_ang_mom == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_ang_mom(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t basis_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_num_64(file, &(basis_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* basis_shell_ang_mom_64 = CALLOC(dim_size, int64_t);
  if (basis_shell_ang_mom_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_basis_shell_ang_mom(file, basis_shell_ang_mom_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_shell_ang_mom(file, basis_shell_ang_mom_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_shell_ang_mom(file, basis_shell_ang_mom_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(basis_shell_ang_mom_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_shell_ang_mom[i] = (int32_t) basis_shell_ang_mom_64[i] + (int32_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_shell_ang_mom[i] = (int32_t) basis_shell_ang_mom_64[i];
    }
  }

  FREE(basis_shell_ang_mom_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_shell_prim_num_32 (trexio_t* const file, int32_t* const basis_shell_prim_num)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_shell_prim_num == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_prim_num(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t basis_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_num_64(file, &(basis_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* basis_shell_prim_num_64 = CALLOC(dim_size, int64_t);
  if (basis_shell_prim_num_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_basis_shell_prim_num(file, basis_shell_prim_num_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_shell_prim_num(file, basis_shell_prim_num_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_shell_prim_num(file, basis_shell_prim_num_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(basis_shell_prim_num_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_shell_prim_num[i] = (int32_t) basis_shell_prim_num_64[i] + (int32_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_shell_prim_num[i] = (int32_t) basis_shell_prim_num_64[i];
    }
  }

  FREE(basis_shell_prim_num_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_shell_factor_32 (trexio_t* const file, float* const basis_shell_factor)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_shell_factor == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_factor(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t basis_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_num_64(file, &(basis_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* basis_shell_factor_64 = CALLOC(dim_size, double);
  if (basis_shell_factor_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_basis_shell_factor(file, basis_shell_factor_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_shell_factor(file, basis_shell_factor_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_shell_factor(file, basis_shell_factor_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(basis_shell_factor_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_shell_factor[i] = (float) basis_shell_factor_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_shell_factor[i] = (float) basis_shell_factor_64[i];
    }
  }

  FREE(basis_shell_factor_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_shell_prim_index_32 (trexio_t* const file, int32_t* const basis_shell_prim_index)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_shell_prim_index == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_prim_index(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t basis_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_num_64(file, &(basis_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* basis_shell_prim_index_64 = CALLOC(dim_size, int64_t);
  if (basis_shell_prim_index_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_basis_shell_prim_index(file, basis_shell_prim_index_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_shell_prim_index(file, basis_shell_prim_index_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_shell_prim_index(file, basis_shell_prim_index_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(basis_shell_prim_index_64);
    return rc;
  }

  if (file->one_based) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_shell_prim_index[i] = (int32_t) basis_shell_prim_index_64[i] + (int32_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_shell_prim_index[i] = (int32_t) basis_shell_prim_index_64[i];
    }
  }

  FREE(basis_shell_prim_index_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_exponent_32 (trexio_t* const file, float* const basis_exponent)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_exponent == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_exponent(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t basis_prim_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_prim_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* basis_exponent_64 = CALLOC(dim_size, double);
  if (basis_exponent_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_basis_exponent(file, basis_exponent_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_exponent(file, basis_exponent_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_exponent(file, basis_exponent_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(basis_exponent_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_exponent[i] = (float) basis_exponent_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_exponent[i] = (float) basis_exponent_64[i];
    }
  }

  FREE(basis_exponent_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_coefficient_32 (trexio_t* const file, float* const basis_coefficient)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_coefficient == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_coefficient(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t basis_prim_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_prim_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* basis_coefficient_64 = CALLOC(dim_size, double);
  if (basis_coefficient_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_basis_coefficient(file, basis_coefficient_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_coefficient(file, basis_coefficient_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_coefficient(file, basis_coefficient_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(basis_coefficient_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_coefficient[i] = (float) basis_coefficient_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_coefficient[i] = (float) basis_coefficient_64[i];
    }
  }

  FREE(basis_coefficient_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_prim_factor_32 (trexio_t* const file, float* const basis_prim_factor)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_prim_factor == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_prim_factor(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t basis_prim_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_prim_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* basis_prim_factor_64 = CALLOC(dim_size, double);
  if (basis_prim_factor_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_basis_prim_factor(file, basis_prim_factor_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_prim_factor(file, basis_prim_factor_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_prim_factor(file, basis_prim_factor_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(basis_prim_factor_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_prim_factor[i] = (float) basis_prim_factor_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_prim_factor[i] = (float) basis_prim_factor_64[i];
    }
  }

  FREE(basis_prim_factor_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_shell_32 (trexio_t* const file, int32_t* const ao_shell)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_shell == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_shell(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* ao_shell_64 = CALLOC(dim_size, int64_t);
  if (ao_shell_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ao_shell(file, ao_shell_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_shell(file, ao_shell_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_shell(file, ao_shell_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ao_shell_64);
    return rc;
  }

  if (file->one_based) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_shell[i] = (int32_t) ao_shell_64[i] + (int32_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_shell[i] = (int32_t) ao_shell_64[i];
    }
  }

  FREE(ao_shell_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_normalization_32 (trexio_t* const file, float* const ao_normalization)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_normalization == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_normalization(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_normalization_64 = CALLOC(dim_size, double);
  if (ao_normalization_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ao_normalization(file, ao_normalization_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_normalization(file, ao_normalization_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_normalization(file, ao_normalization_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ao_normalization_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_normalization[i] = (float) ao_normalization_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_normalization[i] = (float) ao_normalization_64[i];
    }
  }

  FREE(ao_normalization_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_1e_int_overlap_32 (trexio_t* const file, float* const ao_1e_int_overlap)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_overlap == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_overlap(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_1e_int_overlap_64 = CALLOC(dim_size, double);
  if (ao_1e_int_overlap_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ao_1e_int_overlap(file, ao_1e_int_overlap_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_1e_int_overlap(file, ao_1e_int_overlap_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_1e_int_overlap(file, ao_1e_int_overlap_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ao_1e_int_overlap_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_overlap[i] = (float) ao_1e_int_overlap_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_overlap[i] = (float) ao_1e_int_overlap_64[i];
    }
  }

  FREE(ao_1e_int_overlap_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_1e_int_kinetic_32 (trexio_t* const file, float* const ao_1e_int_kinetic)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_kinetic == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_kinetic(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_1e_int_kinetic_64 = CALLOC(dim_size, double);
  if (ao_1e_int_kinetic_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ao_1e_int_kinetic(file, ao_1e_int_kinetic_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_1e_int_kinetic(file, ao_1e_int_kinetic_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_1e_int_kinetic(file, ao_1e_int_kinetic_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ao_1e_int_kinetic_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_kinetic[i] = (float) ao_1e_int_kinetic_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_kinetic[i] = (float) ao_1e_int_kinetic_64[i];
    }
  }

  FREE(ao_1e_int_kinetic_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_1e_int_potential_n_e_32 (trexio_t* const file, float* const ao_1e_int_potential_n_e)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_potential_n_e == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_potential_n_e(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_1e_int_potential_n_e_64 = CALLOC(dim_size, double);
  if (ao_1e_int_potential_n_e_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ao_1e_int_potential_n_e(file, ao_1e_int_potential_n_e_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_1e_int_potential_n_e(file, ao_1e_int_potential_n_e_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_1e_int_potential_n_e(file, ao_1e_int_potential_n_e_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ao_1e_int_potential_n_e_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_potential_n_e[i] = (float) ao_1e_int_potential_n_e_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_potential_n_e[i] = (float) ao_1e_int_potential_n_e_64[i];
    }
  }

  FREE(ao_1e_int_potential_n_e_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_1e_int_ecp_local_32 (trexio_t* const file, float* const ao_1e_int_ecp_local)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_ecp_local == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_ecp_local(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_1e_int_ecp_local_64 = CALLOC(dim_size, double);
  if (ao_1e_int_ecp_local_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ao_1e_int_ecp_local(file, ao_1e_int_ecp_local_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_1e_int_ecp_local(file, ao_1e_int_ecp_local_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_1e_int_ecp_local(file, ao_1e_int_ecp_local_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ao_1e_int_ecp_local_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_ecp_local[i] = (float) ao_1e_int_ecp_local_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_ecp_local[i] = (float) ao_1e_int_ecp_local_64[i];
    }
  }

  FREE(ao_1e_int_ecp_local_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_1e_int_ecp_non_local_32 (trexio_t* const file, float* const ao_1e_int_ecp_non_local)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_ecp_non_local == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_ecp_non_local(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_1e_int_ecp_non_local_64 = CALLOC(dim_size, double);
  if (ao_1e_int_ecp_non_local_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ao_1e_int_ecp_non_local(file, ao_1e_int_ecp_non_local_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_1e_int_ecp_non_local(file, ao_1e_int_ecp_non_local_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_1e_int_ecp_non_local(file, ao_1e_int_ecp_non_local_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ao_1e_int_ecp_non_local_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_ecp_non_local[i] = (float) ao_1e_int_ecp_non_local_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_ecp_non_local[i] = (float) ao_1e_int_ecp_non_local_64[i];
    }
  }

  FREE(ao_1e_int_ecp_non_local_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_1e_int_core_hamiltonian_32 (trexio_t* const file, float* const ao_1e_int_core_hamiltonian)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_core_hamiltonian == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_core_hamiltonian(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_1e_int_core_hamiltonian_64 = CALLOC(dim_size, double);
  if (ao_1e_int_core_hamiltonian_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ao_1e_int_core_hamiltonian(file, ao_1e_int_core_hamiltonian_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_1e_int_core_hamiltonian(file, ao_1e_int_core_hamiltonian_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_1e_int_core_hamiltonian(file, ao_1e_int_core_hamiltonian_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ao_1e_int_core_hamiltonian_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_core_hamiltonian[i] = (float) ao_1e_int_core_hamiltonian_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_core_hamiltonian[i] = (float) ao_1e_int_core_hamiltonian_64[i];
    }
  }

  FREE(ao_1e_int_core_hamiltonian_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_2e_int_eri_32 (trexio_t* const file, float* const ao_2e_int_eri)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_2e_int_eri == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_2e_int_eri(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 4;
  uint64_t dims[4] = {ao_num, ao_num, ao_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_2e_int_eri_64 = CALLOC(dim_size, double);
  if (ao_2e_int_eri_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ao_2e_int_eri(file, ao_2e_int_eri_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_2e_int_eri(file, ao_2e_int_eri_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_2e_int_eri(file, ao_2e_int_eri_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ao_2e_int_eri_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_2e_int_eri[i] = (float) ao_2e_int_eri_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_2e_int_eri[i] = (float) ao_2e_int_eri_64[i];
    }
  }

  FREE(ao_2e_int_eri_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_2e_int_eri_lr_32 (trexio_t* const file, float* const ao_2e_int_eri_lr)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_2e_int_eri_lr == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_2e_int_eri_lr(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 4;
  uint64_t dims[4] = {ao_num, ao_num, ao_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_2e_int_eri_lr_64 = CALLOC(dim_size, double);
  if (ao_2e_int_eri_lr_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ao_2e_int_eri_lr(file, ao_2e_int_eri_lr_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_2e_int_eri_lr(file, ao_2e_int_eri_lr_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_2e_int_eri_lr(file, ao_2e_int_eri_lr_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(ao_2e_int_eri_lr_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_2e_int_eri_lr[i] = (float) ao_2e_int_eri_lr_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_2e_int_eri_lr[i] = (float) ao_2e_int_eri_lr_64[i];
    }
  }

  FREE(ao_2e_int_eri_lr_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_coefficient_32 (trexio_t* const file, float* const mo_coefficient)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_coefficient == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_coefficient(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;
  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_coefficient_64 = CALLOC(dim_size, double);
  if (mo_coefficient_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_mo_coefficient(file, mo_coefficient_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_coefficient(file, mo_coefficient_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_coefficient(file, mo_coefficient_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(mo_coefficient_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_coefficient[i] = (float) mo_coefficient_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_coefficient[i] = (float) mo_coefficient_64[i];
    }
  }

  FREE(mo_coefficient_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_occupation_32 (trexio_t* const file, float* const mo_occupation)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_occupation == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_occupation(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_occupation_64 = CALLOC(dim_size, double);
  if (mo_occupation_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_mo_occupation(file, mo_occupation_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_occupation(file, mo_occupation_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_occupation(file, mo_occupation_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(mo_occupation_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_occupation[i] = (float) mo_occupation_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_occupation[i] = (float) mo_occupation_64[i];
    }
  }

  FREE(mo_occupation_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_1e_int_overlap_32 (trexio_t* const file, float* const mo_1e_int_overlap)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_overlap == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_overlap(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_1e_int_overlap_64 = CALLOC(dim_size, double);
  if (mo_1e_int_overlap_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_mo_1e_int_overlap(file, mo_1e_int_overlap_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_1e_int_overlap(file, mo_1e_int_overlap_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_1e_int_overlap(file, mo_1e_int_overlap_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(mo_1e_int_overlap_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_overlap[i] = (float) mo_1e_int_overlap_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_overlap[i] = (float) mo_1e_int_overlap_64[i];
    }
  }

  FREE(mo_1e_int_overlap_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_1e_int_kinetic_32 (trexio_t* const file, float* const mo_1e_int_kinetic)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_kinetic == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_kinetic(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_1e_int_kinetic_64 = CALLOC(dim_size, double);
  if (mo_1e_int_kinetic_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_mo_1e_int_kinetic(file, mo_1e_int_kinetic_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_1e_int_kinetic(file, mo_1e_int_kinetic_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_1e_int_kinetic(file, mo_1e_int_kinetic_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(mo_1e_int_kinetic_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_kinetic[i] = (float) mo_1e_int_kinetic_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_kinetic[i] = (float) mo_1e_int_kinetic_64[i];
    }
  }

  FREE(mo_1e_int_kinetic_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_1e_int_potential_n_e_32 (trexio_t* const file, float* const mo_1e_int_potential_n_e)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_potential_n_e == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_potential_n_e(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_1e_int_potential_n_e_64 = CALLOC(dim_size, double);
  if (mo_1e_int_potential_n_e_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_mo_1e_int_potential_n_e(file, mo_1e_int_potential_n_e_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_1e_int_potential_n_e(file, mo_1e_int_potential_n_e_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_1e_int_potential_n_e(file, mo_1e_int_potential_n_e_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(mo_1e_int_potential_n_e_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_potential_n_e[i] = (float) mo_1e_int_potential_n_e_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_potential_n_e[i] = (float) mo_1e_int_potential_n_e_64[i];
    }
  }

  FREE(mo_1e_int_potential_n_e_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_1e_int_ecp_local_32 (trexio_t* const file, float* const mo_1e_int_ecp_local)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_ecp_local == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_ecp_local(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_1e_int_ecp_local_64 = CALLOC(dim_size, double);
  if (mo_1e_int_ecp_local_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_mo_1e_int_ecp_local(file, mo_1e_int_ecp_local_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_1e_int_ecp_local(file, mo_1e_int_ecp_local_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_1e_int_ecp_local(file, mo_1e_int_ecp_local_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(mo_1e_int_ecp_local_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_ecp_local[i] = (float) mo_1e_int_ecp_local_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_ecp_local[i] = (float) mo_1e_int_ecp_local_64[i];
    }
  }

  FREE(mo_1e_int_ecp_local_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_1e_int_ecp_non_local_32 (trexio_t* const file, float* const mo_1e_int_ecp_non_local)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_ecp_non_local == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_ecp_non_local(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_1e_int_ecp_non_local_64 = CALLOC(dim_size, double);
  if (mo_1e_int_ecp_non_local_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_mo_1e_int_ecp_non_local(file, mo_1e_int_ecp_non_local_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_1e_int_ecp_non_local(file, mo_1e_int_ecp_non_local_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_1e_int_ecp_non_local(file, mo_1e_int_ecp_non_local_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(mo_1e_int_ecp_non_local_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_ecp_non_local[i] = (float) mo_1e_int_ecp_non_local_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_ecp_non_local[i] = (float) mo_1e_int_ecp_non_local_64[i];
    }
  }

  FREE(mo_1e_int_ecp_non_local_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_1e_int_core_hamiltonian_32 (trexio_t* const file, float* const mo_1e_int_core_hamiltonian)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_core_hamiltonian == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_core_hamiltonian(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_1e_int_core_hamiltonian_64 = CALLOC(dim_size, double);
  if (mo_1e_int_core_hamiltonian_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_mo_1e_int_core_hamiltonian(file, mo_1e_int_core_hamiltonian_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_1e_int_core_hamiltonian(file, mo_1e_int_core_hamiltonian_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_1e_int_core_hamiltonian(file, mo_1e_int_core_hamiltonian_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(mo_1e_int_core_hamiltonian_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_core_hamiltonian[i] = (float) mo_1e_int_core_hamiltonian_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_core_hamiltonian[i] = (float) mo_1e_int_core_hamiltonian_64[i];
    }
  }

  FREE(mo_1e_int_core_hamiltonian_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_2e_int_eri_32 (trexio_t* const file, float* const mo_2e_int_eri)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_2e_int_eri == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_2e_int_eri(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 4;
  uint64_t dims[4] = {mo_num, mo_num, mo_num, mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_2e_int_eri_64 = CALLOC(dim_size, double);
  if (mo_2e_int_eri_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_mo_2e_int_eri(file, mo_2e_int_eri_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_2e_int_eri(file, mo_2e_int_eri_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_2e_int_eri(file, mo_2e_int_eri_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(mo_2e_int_eri_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_2e_int_eri[i] = (float) mo_2e_int_eri_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_2e_int_eri[i] = (float) mo_2e_int_eri_64[i];
    }
  }

  FREE(mo_2e_int_eri_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_2e_int_eri_lr_32 (trexio_t* const file, float* const mo_2e_int_eri_lr)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_2e_int_eri_lr == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_2e_int_eri_lr(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 4;
  uint64_t dims[4] = {mo_num, mo_num, mo_num, mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_2e_int_eri_lr_64 = CALLOC(dim_size, double);
  if (mo_2e_int_eri_lr_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_mo_2e_int_eri_lr(file, mo_2e_int_eri_lr_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_2e_int_eri_lr(file, mo_2e_int_eri_lr_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_2e_int_eri_lr(file, mo_2e_int_eri_lr_64, rank, dims);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS){
    FREE(mo_2e_int_eri_lr_64);
    return rc;
  }

  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_2e_int_eri_lr[i] = (float) mo_2e_int_eri_lr_64[i] + (float) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_2e_int_eri_lr[i] = (float) mo_2e_int_eri_lr_64[i];
    }
  }

  FREE(mo_2e_int_eri_lr_64);
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_safe_nucleus_charge_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_charge(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_nucleus_charge_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_nucleus_coord_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_coord(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, 3};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_nucleus_coord_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_lmax_plus_1_32 (trexio_t* const file, int32_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_lmax_plus_1(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_lmax_plus_1_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_z_core_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_z_core(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_z_core_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_local_n_32 (trexio_t* const file, int32_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_n(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_local_n_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_local_exponent_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_exponent(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_local_exponent_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_local_coef_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_coef(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_local_coef_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_local_power_32 (trexio_t* const file, int32_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_power(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_local_power_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_non_local_n_32 (trexio_t* const file, int32_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_n(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_non_local_n_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_non_local_exponent_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_exponent(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_non_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_non_local_exponent_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_non_local_coef_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_coef(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_non_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_non_local_coef_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_non_local_power_32 (trexio_t* const file, int32_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_power(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_non_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_non_local_power_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_nucleus_index_32 (trexio_t* const file, int32_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_nucleus_index(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_nucleus_index_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_nucleus_shell_num_32 (trexio_t* const file, int32_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_nucleus_shell_num(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_nucleus_shell_num_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_shell_ang_mom_32 (trexio_t* const file, int32_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_ang_mom(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t basis_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_num_64(file, &(basis_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_shell_ang_mom_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_shell_prim_num_32 (trexio_t* const file, int32_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_prim_num(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t basis_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_num_64(file, &(basis_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_shell_prim_num_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_shell_factor_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_factor(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t basis_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_num_64(file, &(basis_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_shell_factor_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_shell_prim_index_32 (trexio_t* const file, int32_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_prim_index(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t basis_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_num_64(file, &(basis_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_shell_prim_index_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_exponent_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_exponent(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t basis_prim_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_prim_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_exponent_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_coefficient_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_coefficient(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t basis_prim_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_prim_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_coefficient_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_prim_factor_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_prim_factor(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t basis_prim_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_prim_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_prim_factor_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_shell_32 (trexio_t* const file, int32_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_shell(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_shell_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_normalization_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_normalization(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_normalization_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_overlap_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_overlap(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_1e_int_overlap_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_kinetic_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_kinetic(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_1e_int_kinetic_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_potential_n_e_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_potential_n_e(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_1e_int_potential_n_e_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_ecp_local_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_ecp_local(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_1e_int_ecp_local_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_ecp_non_local_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_ecp_non_local(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_1e_int_ecp_non_local_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_core_hamiltonian_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_core_hamiltonian(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_1e_int_core_hamiltonian_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_2e_int_eri_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_2e_int_eri(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 4;
uint64_t dims[4] = {ao_num, ao_num, ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_2e_int_eri_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_2e_int_eri_lr_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_2e_int_eri_lr(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 4;
uint64_t dims[4] = {ao_num, ao_num, ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_2e_int_eri_lr_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_coefficient_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_coefficient(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;
if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_coefficient_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_occupation_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_occupation(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_occupation_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_overlap_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_overlap(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_1e_int_overlap_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_kinetic_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_kinetic(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_1e_int_kinetic_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_potential_n_e_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_potential_n_e(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_1e_int_potential_n_e_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_ecp_local_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_ecp_local(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_1e_int_ecp_local_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_ecp_non_local_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_ecp_non_local(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_1e_int_ecp_non_local_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_core_hamiltonian_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_core_hamiltonian(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_1e_int_core_hamiltonian_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_2e_int_eri_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_2e_int_eri(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 4;
uint64_t dims[4] = {mo_num, mo_num, mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_2e_int_eri_32(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_2e_int_eri_lr_32 (trexio_t* const file, float* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_2e_int_eri_lr(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 4;
uint64_t dims[4] = {mo_num, mo_num, mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_2e_int_eri_lr_32(file, dset_out);
}

trexio_exit_code
trexio_read_nucleus_charge_64 (trexio_t* const file, double* const nucleus_charge)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (nucleus_charge == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_charge(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_nucleus_charge(file, nucleus_charge, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_nucleus_charge(file, nucleus_charge, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_nucleus_charge(file, nucleus_charge, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       nucleus_charge[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_nucleus_coord_64 (trexio_t* const file, double* const nucleus_coord)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (nucleus_coord == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_coord(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, 3};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_nucleus_coord(file, nucleus_coord, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_nucleus_coord(file, nucleus_coord, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_nucleus_coord(file, nucleus_coord, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       nucleus_coord[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_lmax_plus_1_64 (trexio_t* const file, int64_t* const ecp_lmax_plus_1)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_lmax_plus_1 == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_lmax_plus_1(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_lmax_plus_1(file, ecp_lmax_plus_1, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_lmax_plus_1(file, ecp_lmax_plus_1, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_lmax_plus_1(file, ecp_lmax_plus_1, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ecp_lmax_plus_1[i] += (int32_t) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_z_core_64 (trexio_t* const file, double* const ecp_z_core)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_z_core == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_z_core(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_z_core(file, ecp_z_core, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_z_core(file, ecp_z_core, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_z_core(file, ecp_z_core, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ecp_z_core[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_local_n_64 (trexio_t* const file, int64_t* const ecp_local_n)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_local_n == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_n(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_local_n(file, ecp_local_n, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_local_n(file, ecp_local_n, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_local_n(file, ecp_local_n, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ecp_local_n[i] += (int32_t) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_local_exponent_64 (trexio_t* const file, double* const ecp_local_exponent)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_local_exponent == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_exponent(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_local_exponent(file, ecp_local_exponent, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_local_exponent(file, ecp_local_exponent, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_local_exponent(file, ecp_local_exponent, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ecp_local_exponent[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_local_coef_64 (trexio_t* const file, double* const ecp_local_coef)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_local_coef == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_coef(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_local_coef(file, ecp_local_coef, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_local_coef(file, ecp_local_coef, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_local_coef(file, ecp_local_coef, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ecp_local_coef[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_local_power_64 (trexio_t* const file, int64_t* const ecp_local_power)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_local_power == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_power(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_local_power(file, ecp_local_power, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_local_power(file, ecp_local_power, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_local_power(file, ecp_local_power, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ecp_local_power[i] += (int32_t) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_non_local_n_64 (trexio_t* const file, int64_t* const ecp_non_local_n)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_non_local_n == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_n(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_non_local_n(file, ecp_non_local_n, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_non_local_n(file, ecp_non_local_n, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_non_local_n(file, ecp_non_local_n, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ecp_non_local_n[i] += (int32_t) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_non_local_exponent_64 (trexio_t* const file, double* const ecp_non_local_exponent)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_non_local_exponent == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_exponent(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_non_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_non_local_exponent(file, ecp_non_local_exponent, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_non_local_exponent(file, ecp_non_local_exponent, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_non_local_exponent(file, ecp_non_local_exponent, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ecp_non_local_exponent[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_non_local_coef_64 (trexio_t* const file, double* const ecp_non_local_coef)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_non_local_coef == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_coef(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_non_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_non_local_coef(file, ecp_non_local_coef, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_non_local_coef(file, ecp_non_local_coef, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_non_local_coef(file, ecp_non_local_coef, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ecp_non_local_coef[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_non_local_power_64 (trexio_t* const file, int64_t* const ecp_non_local_power)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_non_local_power == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_power(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_non_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_non_local_power(file, ecp_non_local_power, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_non_local_power(file, ecp_non_local_power, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ecp_non_local_power(file, ecp_non_local_power, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ecp_non_local_power[i] += (int32_t) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_nucleus_index_64 (trexio_t* const file, int64_t* const basis_nucleus_index)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_nucleus_index == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_nucleus_index(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_basis_nucleus_index(file, basis_nucleus_index, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_nucleus_index(file, basis_nucleus_index, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_nucleus_index(file, basis_nucleus_index, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (file->one_based) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       basis_nucleus_index[i] += (int32_t) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_nucleus_shell_num_64 (trexio_t* const file, int64_t* const basis_nucleus_shell_num)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_nucleus_shell_num == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_nucleus_shell_num(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_basis_nucleus_shell_num(file, basis_nucleus_shell_num, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_nucleus_shell_num(file, basis_nucleus_shell_num, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_nucleus_shell_num(file, basis_nucleus_shell_num, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       basis_nucleus_shell_num[i] += (int32_t) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_shell_ang_mom_64 (trexio_t* const file, int64_t* const basis_shell_ang_mom)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_shell_ang_mom == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_ang_mom(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t basis_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_num_64(file, &(basis_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_basis_shell_ang_mom(file, basis_shell_ang_mom, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_shell_ang_mom(file, basis_shell_ang_mom, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_shell_ang_mom(file, basis_shell_ang_mom, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       basis_shell_ang_mom[i] += (int32_t) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_shell_prim_num_64 (trexio_t* const file, int64_t* const basis_shell_prim_num)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_shell_prim_num == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_prim_num(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t basis_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_num_64(file, &(basis_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_basis_shell_prim_num(file, basis_shell_prim_num, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_shell_prim_num(file, basis_shell_prim_num, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_shell_prim_num(file, basis_shell_prim_num, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       basis_shell_prim_num[i] += (int32_t) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_shell_factor_64 (trexio_t* const file, double* const basis_shell_factor)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_shell_factor == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_factor(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t basis_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_num_64(file, &(basis_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_basis_shell_factor(file, basis_shell_factor, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_shell_factor(file, basis_shell_factor, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_shell_factor(file, basis_shell_factor, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       basis_shell_factor[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_shell_prim_index_64 (trexio_t* const file, int64_t* const basis_shell_prim_index)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_shell_prim_index == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_prim_index(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t basis_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_num_64(file, &(basis_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_basis_shell_prim_index(file, basis_shell_prim_index, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_shell_prim_index(file, basis_shell_prim_index, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_shell_prim_index(file, basis_shell_prim_index, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (file->one_based) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       basis_shell_prim_index[i] += (int32_t) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_exponent_64 (trexio_t* const file, double* const basis_exponent)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_exponent == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_exponent(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t basis_prim_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_prim_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_basis_exponent(file, basis_exponent, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_exponent(file, basis_exponent, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_exponent(file, basis_exponent, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       basis_exponent[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_coefficient_64 (trexio_t* const file, double* const basis_coefficient)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_coefficient == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_coefficient(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t basis_prim_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_prim_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_basis_coefficient(file, basis_coefficient, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_coefficient(file, basis_coefficient, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_coefficient(file, basis_coefficient, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       basis_coefficient[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_prim_factor_64 (trexio_t* const file, double* const basis_prim_factor)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_prim_factor == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_prim_factor(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t basis_prim_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_prim_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_basis_prim_factor(file, basis_prim_factor, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_prim_factor(file, basis_prim_factor, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_basis_prim_factor(file, basis_prim_factor, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       basis_prim_factor[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_shell_64 (trexio_t* const file, int64_t* const ao_shell)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_shell == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_shell(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {ao_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ao_shell(file, ao_shell, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_shell(file, ao_shell, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_shell(file, ao_shell, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (file->one_based) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ao_shell[i] += (int32_t) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_normalization_64 (trexio_t* const file, double* const ao_normalization)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_normalization == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_normalization(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {ao_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ao_normalization(file, ao_normalization, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_normalization(file, ao_normalization, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_normalization(file, ao_normalization, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ao_normalization[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_1e_int_overlap_64 (trexio_t* const file, double* const ao_1e_int_overlap)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_overlap == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_overlap(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ao_1e_int_overlap(file, ao_1e_int_overlap, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_1e_int_overlap(file, ao_1e_int_overlap, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_1e_int_overlap(file, ao_1e_int_overlap, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ao_1e_int_overlap[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_1e_int_kinetic_64 (trexio_t* const file, double* const ao_1e_int_kinetic)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_kinetic == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_kinetic(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ao_1e_int_kinetic(file, ao_1e_int_kinetic, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_1e_int_kinetic(file, ao_1e_int_kinetic, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_1e_int_kinetic(file, ao_1e_int_kinetic, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ao_1e_int_kinetic[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_1e_int_potential_n_e_64 (trexio_t* const file, double* const ao_1e_int_potential_n_e)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_potential_n_e == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_potential_n_e(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ao_1e_int_potential_n_e(file, ao_1e_int_potential_n_e, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_1e_int_potential_n_e(file, ao_1e_int_potential_n_e, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_1e_int_potential_n_e(file, ao_1e_int_potential_n_e, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ao_1e_int_potential_n_e[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_1e_int_ecp_local_64 (trexio_t* const file, double* const ao_1e_int_ecp_local)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_ecp_local == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_ecp_local(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ao_1e_int_ecp_local(file, ao_1e_int_ecp_local, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_1e_int_ecp_local(file, ao_1e_int_ecp_local, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_1e_int_ecp_local(file, ao_1e_int_ecp_local, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ao_1e_int_ecp_local[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_1e_int_ecp_non_local_64 (trexio_t* const file, double* const ao_1e_int_ecp_non_local)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_ecp_non_local == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_ecp_non_local(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ao_1e_int_ecp_non_local(file, ao_1e_int_ecp_non_local, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_1e_int_ecp_non_local(file, ao_1e_int_ecp_non_local, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_1e_int_ecp_non_local(file, ao_1e_int_ecp_non_local, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ao_1e_int_ecp_non_local[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_1e_int_core_hamiltonian_64 (trexio_t* const file, double* const ao_1e_int_core_hamiltonian)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_core_hamiltonian == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_core_hamiltonian(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ao_1e_int_core_hamiltonian(file, ao_1e_int_core_hamiltonian, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_1e_int_core_hamiltonian(file, ao_1e_int_core_hamiltonian, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_1e_int_core_hamiltonian(file, ao_1e_int_core_hamiltonian, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ao_1e_int_core_hamiltonian[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_2e_int_eri_64 (trexio_t* const file, double* const ao_2e_int_eri)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_2e_int_eri == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_2e_int_eri(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 4;
  uint64_t dims[4] = {ao_num, ao_num, ao_num, ao_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ao_2e_int_eri(file, ao_2e_int_eri, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_2e_int_eri(file, ao_2e_int_eri, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_2e_int_eri(file, ao_2e_int_eri, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ao_2e_int_eri[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_2e_int_eri_lr_64 (trexio_t* const file, double* const ao_2e_int_eri_lr)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_2e_int_eri_lr == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_2e_int_eri_lr(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 4;
  uint64_t dims[4] = {ao_num, ao_num, ao_num, ao_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_ao_2e_int_eri_lr(file, ao_2e_int_eri_lr, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_2e_int_eri_lr(file, ao_2e_int_eri_lr, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_ao_2e_int_eri_lr(file, ao_2e_int_eri_lr, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       ao_2e_int_eri_lr[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_coefficient_64 (trexio_t* const file, double* const mo_coefficient)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_coefficient == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_coefficient(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;
  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, ao_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_mo_coefficient(file, mo_coefficient, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_coefficient(file, mo_coefficient, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_coefficient(file, mo_coefficient, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       mo_coefficient[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_occupation_64 (trexio_t* const file, double* const mo_occupation)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_occupation == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_occupation(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {mo_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_mo_occupation(file, mo_occupation, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_occupation(file, mo_occupation, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_occupation(file, mo_occupation, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       mo_occupation[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_1e_int_overlap_64 (trexio_t* const file, double* const mo_1e_int_overlap)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_overlap == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_overlap(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_mo_1e_int_overlap(file, mo_1e_int_overlap, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_1e_int_overlap(file, mo_1e_int_overlap, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_1e_int_overlap(file, mo_1e_int_overlap, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       mo_1e_int_overlap[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_1e_int_kinetic_64 (trexio_t* const file, double* const mo_1e_int_kinetic)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_kinetic == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_kinetic(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_mo_1e_int_kinetic(file, mo_1e_int_kinetic, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_1e_int_kinetic(file, mo_1e_int_kinetic, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_1e_int_kinetic(file, mo_1e_int_kinetic, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       mo_1e_int_kinetic[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_1e_int_potential_n_e_64 (trexio_t* const file, double* const mo_1e_int_potential_n_e)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_potential_n_e == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_potential_n_e(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_mo_1e_int_potential_n_e(file, mo_1e_int_potential_n_e, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_1e_int_potential_n_e(file, mo_1e_int_potential_n_e, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_1e_int_potential_n_e(file, mo_1e_int_potential_n_e, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       mo_1e_int_potential_n_e[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_1e_int_ecp_local_64 (trexio_t* const file, double* const mo_1e_int_ecp_local)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_ecp_local == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_ecp_local(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_mo_1e_int_ecp_local(file, mo_1e_int_ecp_local, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_1e_int_ecp_local(file, mo_1e_int_ecp_local, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_1e_int_ecp_local(file, mo_1e_int_ecp_local, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       mo_1e_int_ecp_local[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_1e_int_ecp_non_local_64 (trexio_t* const file, double* const mo_1e_int_ecp_non_local)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_ecp_non_local == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_ecp_non_local(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_mo_1e_int_ecp_non_local(file, mo_1e_int_ecp_non_local, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_1e_int_ecp_non_local(file, mo_1e_int_ecp_non_local, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_1e_int_ecp_non_local(file, mo_1e_int_ecp_non_local, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       mo_1e_int_ecp_non_local[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_1e_int_core_hamiltonian_64 (trexio_t* const file, double* const mo_1e_int_core_hamiltonian)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_core_hamiltonian == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_core_hamiltonian(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_mo_1e_int_core_hamiltonian(file, mo_1e_int_core_hamiltonian, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_1e_int_core_hamiltonian(file, mo_1e_int_core_hamiltonian, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_1e_int_core_hamiltonian(file, mo_1e_int_core_hamiltonian, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       mo_1e_int_core_hamiltonian[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_2e_int_eri_64 (trexio_t* const file, double* const mo_2e_int_eri)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_2e_int_eri == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_2e_int_eri(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 4;
  uint64_t dims[4] = {mo_num, mo_num, mo_num, mo_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_mo_2e_int_eri(file, mo_2e_int_eri, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_2e_int_eri(file, mo_2e_int_eri, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_2e_int_eri(file, mo_2e_int_eri, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       mo_2e_int_eri[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_2e_int_eri_lr_64 (trexio_t* const file, double* const mo_2e_int_eri_lr)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_2e_int_eri_lr == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_2e_int_eri_lr(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 4;
  uint64_t dims[4] = {mo_num, mo_num, mo_num, mo_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {
    
  case TREXIO_TEXT:
    rc = trexio_text_read_mo_2e_int_eri_lr(file, mo_2e_int_eri_lr, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_2e_int_eri_lr(file, mo_2e_int_eri_lr, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_2e_int_eri_lr(file, mo_2e_int_eri_lr, rank, dims);
    break;
*/
  }
  if (rc != TREXIO_SUCCESS) return rc;
  
  /* Handle index type */
  if (false) {
    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }
    for (uint64_t i=0; i<dim_size; ++i){
       mo_2e_int_eri_lr[i] += (float) 1;
    }
  }
  
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_safe_nucleus_charge_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_charge(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_nucleus_charge_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_nucleus_coord_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_coord(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, 3};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_nucleus_coord_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_lmax_plus_1_64 (trexio_t* const file, int64_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_lmax_plus_1(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_lmax_plus_1_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_z_core_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_z_core(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_z_core_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_local_n_64 (trexio_t* const file, int64_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_n(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_local_n_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_local_exponent_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_exponent(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_local_exponent_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_local_coef_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_coef(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_local_coef_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_local_power_64 (trexio_t* const file, int64_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_power(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_local_power_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_non_local_n_64 (trexio_t* const file, int64_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_n(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_non_local_n_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_non_local_exponent_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_exponent(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_non_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_non_local_exponent_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_non_local_coef_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_coef(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_non_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_non_local_coef_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ecp_non_local_power_64 (trexio_t* const file, int64_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_power(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_non_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ecp_non_local_power_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_nucleus_index_64 (trexio_t* const file, int64_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_nucleus_index(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_nucleus_index_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_nucleus_shell_num_64 (trexio_t* const file, int64_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_nucleus_shell_num(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_nucleus_shell_num_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_shell_ang_mom_64 (trexio_t* const file, int64_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_ang_mom(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t basis_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_num_64(file, &(basis_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_shell_ang_mom_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_shell_prim_num_64 (trexio_t* const file, int64_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_prim_num(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t basis_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_num_64(file, &(basis_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_shell_prim_num_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_shell_factor_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_factor(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t basis_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_num_64(file, &(basis_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_shell_factor_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_shell_prim_index_64 (trexio_t* const file, int64_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_prim_index(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t basis_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_num_64(file, &(basis_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_shell_prim_index_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_exponent_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_exponent(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t basis_prim_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_prim_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_exponent_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_coefficient_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_coefficient(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t basis_prim_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_prim_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_coefficient_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_basis_prim_factor_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_prim_factor(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t basis_prim_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_prim_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_basis_prim_factor_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_shell_64 (trexio_t* const file, int64_t* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_shell(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_shell_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_normalization_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_normalization(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_normalization_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_overlap_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_overlap(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_1e_int_overlap_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_kinetic_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_kinetic(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_1e_int_kinetic_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_potential_n_e_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_potential_n_e(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_1e_int_potential_n_e_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_ecp_local_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_ecp_local(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_1e_int_ecp_local_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_ecp_non_local_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_ecp_non_local(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_1e_int_ecp_non_local_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_core_hamiltonian_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_core_hamiltonian(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_1e_int_core_hamiltonian_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_2e_int_eri_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_2e_int_eri(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 4;
uint64_t dims[4] = {ao_num, ao_num, ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_2e_int_eri_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_ao_2e_int_eri_lr_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_2e_int_eri_lr(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 4;
uint64_t dims[4] = {ao_num, ao_num, ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_ao_2e_int_eri_lr_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_coefficient_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_coefficient(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;
if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_coefficient_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_occupation_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_occupation(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_occupation_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_overlap_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_overlap(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_1e_int_overlap_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_kinetic_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_kinetic(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_1e_int_kinetic_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_potential_n_e_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_potential_n_e(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_1e_int_potential_n_e_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_ecp_local_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_ecp_local(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_1e_int_ecp_local_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_ecp_non_local_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_ecp_non_local(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_1e_int_ecp_non_local_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_core_hamiltonian_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_core_hamiltonian(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_1e_int_core_hamiltonian_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_2e_int_eri_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_2e_int_eri(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 4;
uint64_t dims[4] = {mo_num, mo_num, mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_2e_int_eri_64(file, dset_out);
}

trexio_exit_code
trexio_read_safe_mo_2e_int_eri_lr_64 (trexio_t* const file, double* const dset_out, const int64_t dim_out)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_2e_int_eri_lr(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 4;
uint64_t dims[4] = {mo_num, mo_num, mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}
  
  if (dim_out > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_read_mo_2e_int_eri_lr_64(file, dset_out);
}

trexio_exit_code
trexio_read_nucleus_charge (trexio_t* const file, double* const nucleus_charge)
{
  return trexio_read_nucleus_charge_64(file, nucleus_charge);
}

trexio_exit_code
trexio_read_nucleus_coord (trexio_t* const file, double* const nucleus_coord)
{
  return trexio_read_nucleus_coord_64(file, nucleus_coord);
}

trexio_exit_code
trexio_read_ecp_lmax_plus_1 (trexio_t* const file, int32_t* const ecp_lmax_plus_1)
{
  return trexio_read_ecp_lmax_plus_1_32(file, ecp_lmax_plus_1);
}

trexio_exit_code
trexio_read_ecp_z_core (trexio_t* const file, double* const ecp_z_core)
{
  return trexio_read_ecp_z_core_64(file, ecp_z_core);
}

trexio_exit_code
trexio_read_ecp_local_n (trexio_t* const file, int32_t* const ecp_local_n)
{
  return trexio_read_ecp_local_n_32(file, ecp_local_n);
}

trexio_exit_code
trexio_read_ecp_local_exponent (trexio_t* const file, double* const ecp_local_exponent)
{
  return trexio_read_ecp_local_exponent_64(file, ecp_local_exponent);
}

trexio_exit_code
trexio_read_ecp_local_coef (trexio_t* const file, double* const ecp_local_coef)
{
  return trexio_read_ecp_local_coef_64(file, ecp_local_coef);
}

trexio_exit_code
trexio_read_ecp_local_power (trexio_t* const file, int32_t* const ecp_local_power)
{
  return trexio_read_ecp_local_power_32(file, ecp_local_power);
}

trexio_exit_code
trexio_read_ecp_non_local_n (trexio_t* const file, int32_t* const ecp_non_local_n)
{
  return trexio_read_ecp_non_local_n_32(file, ecp_non_local_n);
}

trexio_exit_code
trexio_read_ecp_non_local_exponent (trexio_t* const file, double* const ecp_non_local_exponent)
{
  return trexio_read_ecp_non_local_exponent_64(file, ecp_non_local_exponent);
}

trexio_exit_code
trexio_read_ecp_non_local_coef (trexio_t* const file, double* const ecp_non_local_coef)
{
  return trexio_read_ecp_non_local_coef_64(file, ecp_non_local_coef);
}

trexio_exit_code
trexio_read_ecp_non_local_power (trexio_t* const file, int32_t* const ecp_non_local_power)
{
  return trexio_read_ecp_non_local_power_32(file, ecp_non_local_power);
}

trexio_exit_code
trexio_read_basis_nucleus_index (trexio_t* const file, int32_t* const basis_nucleus_index)
{
  return trexio_read_basis_nucleus_index_32(file, basis_nucleus_index);
}

trexio_exit_code
trexio_read_basis_nucleus_shell_num (trexio_t* const file, int32_t* const basis_nucleus_shell_num)
{
  return trexio_read_basis_nucleus_shell_num_32(file, basis_nucleus_shell_num);
}

trexio_exit_code
trexio_read_basis_shell_ang_mom (trexio_t* const file, int32_t* const basis_shell_ang_mom)
{
  return trexio_read_basis_shell_ang_mom_32(file, basis_shell_ang_mom);
}

trexio_exit_code
trexio_read_basis_shell_prim_num (trexio_t* const file, int32_t* const basis_shell_prim_num)
{
  return trexio_read_basis_shell_prim_num_32(file, basis_shell_prim_num);
}

trexio_exit_code
trexio_read_basis_shell_factor (trexio_t* const file, double* const basis_shell_factor)
{
  return trexio_read_basis_shell_factor_64(file, basis_shell_factor);
}

trexio_exit_code
trexio_read_basis_shell_prim_index (trexio_t* const file, int32_t* const basis_shell_prim_index)
{
  return trexio_read_basis_shell_prim_index_32(file, basis_shell_prim_index);
}

trexio_exit_code
trexio_read_basis_exponent (trexio_t* const file, double* const basis_exponent)
{
  return trexio_read_basis_exponent_64(file, basis_exponent);
}

trexio_exit_code
trexio_read_basis_coefficient (trexio_t* const file, double* const basis_coefficient)
{
  return trexio_read_basis_coefficient_64(file, basis_coefficient);
}

trexio_exit_code
trexio_read_basis_prim_factor (trexio_t* const file, double* const basis_prim_factor)
{
  return trexio_read_basis_prim_factor_64(file, basis_prim_factor);
}

trexio_exit_code
trexio_read_ao_shell (trexio_t* const file, int32_t* const ao_shell)
{
  return trexio_read_ao_shell_32(file, ao_shell);
}

trexio_exit_code
trexio_read_ao_normalization (trexio_t* const file, double* const ao_normalization)
{
  return trexio_read_ao_normalization_64(file, ao_normalization);
}

trexio_exit_code
trexio_read_ao_1e_int_overlap (trexio_t* const file, double* const ao_1e_int_overlap)
{
  return trexio_read_ao_1e_int_overlap_64(file, ao_1e_int_overlap);
}

trexio_exit_code
trexio_read_ao_1e_int_kinetic (trexio_t* const file, double* const ao_1e_int_kinetic)
{
  return trexio_read_ao_1e_int_kinetic_64(file, ao_1e_int_kinetic);
}

trexio_exit_code
trexio_read_ao_1e_int_potential_n_e (trexio_t* const file, double* const ao_1e_int_potential_n_e)
{
  return trexio_read_ao_1e_int_potential_n_e_64(file, ao_1e_int_potential_n_e);
}

trexio_exit_code
trexio_read_ao_1e_int_ecp_local (trexio_t* const file, double* const ao_1e_int_ecp_local)
{
  return trexio_read_ao_1e_int_ecp_local_64(file, ao_1e_int_ecp_local);
}

trexio_exit_code
trexio_read_ao_1e_int_ecp_non_local (trexio_t* const file, double* const ao_1e_int_ecp_non_local)
{
  return trexio_read_ao_1e_int_ecp_non_local_64(file, ao_1e_int_ecp_non_local);
}

trexio_exit_code
trexio_read_ao_1e_int_core_hamiltonian (trexio_t* const file, double* const ao_1e_int_core_hamiltonian)
{
  return trexio_read_ao_1e_int_core_hamiltonian_64(file, ao_1e_int_core_hamiltonian);
}

trexio_exit_code
trexio_read_ao_2e_int_eri (trexio_t* const file, double* const ao_2e_int_eri)
{
  return trexio_read_ao_2e_int_eri_64(file, ao_2e_int_eri);
}

trexio_exit_code
trexio_read_ao_2e_int_eri_lr (trexio_t* const file, double* const ao_2e_int_eri_lr)
{
  return trexio_read_ao_2e_int_eri_lr_64(file, ao_2e_int_eri_lr);
}

trexio_exit_code
trexio_read_mo_coefficient (trexio_t* const file, double* const mo_coefficient)
{
  return trexio_read_mo_coefficient_64(file, mo_coefficient);
}

trexio_exit_code
trexio_read_mo_occupation (trexio_t* const file, double* const mo_occupation)
{
  return trexio_read_mo_occupation_64(file, mo_occupation);
}

trexio_exit_code
trexio_read_mo_1e_int_overlap (trexio_t* const file, double* const mo_1e_int_overlap)
{
  return trexio_read_mo_1e_int_overlap_64(file, mo_1e_int_overlap);
}

trexio_exit_code
trexio_read_mo_1e_int_kinetic (trexio_t* const file, double* const mo_1e_int_kinetic)
{
  return trexio_read_mo_1e_int_kinetic_64(file, mo_1e_int_kinetic);
}

trexio_exit_code
trexio_read_mo_1e_int_potential_n_e (trexio_t* const file, double* const mo_1e_int_potential_n_e)
{
  return trexio_read_mo_1e_int_potential_n_e_64(file, mo_1e_int_potential_n_e);
}

trexio_exit_code
trexio_read_mo_1e_int_ecp_local (trexio_t* const file, double* const mo_1e_int_ecp_local)
{
  return trexio_read_mo_1e_int_ecp_local_64(file, mo_1e_int_ecp_local);
}

trexio_exit_code
trexio_read_mo_1e_int_ecp_non_local (trexio_t* const file, double* const mo_1e_int_ecp_non_local)
{
  return trexio_read_mo_1e_int_ecp_non_local_64(file, mo_1e_int_ecp_non_local);
}

trexio_exit_code
trexio_read_mo_1e_int_core_hamiltonian (trexio_t* const file, double* const mo_1e_int_core_hamiltonian)
{
  return trexio_read_mo_1e_int_core_hamiltonian_64(file, mo_1e_int_core_hamiltonian);
}

trexio_exit_code
trexio_read_mo_2e_int_eri (trexio_t* const file, double* const mo_2e_int_eri)
{
  return trexio_read_mo_2e_int_eri_64(file, mo_2e_int_eri);
}

trexio_exit_code
trexio_read_mo_2e_int_eri_lr (trexio_t* const file, double* const mo_2e_int_eri_lr)
{
  return trexio_read_mo_2e_int_eri_lr_64(file, mo_2e_int_eri_lr);
}

trexio_exit_code
trexio_read_safe_nucleus_charge (trexio_t* const file, double* const nucleus_charge, const int64_t dim_out)
{
  return trexio_read_safe_nucleus_charge_64(file, nucleus_charge, dim_out);
}

trexio_exit_code
trexio_read_safe_nucleus_coord (trexio_t* const file, double* const nucleus_coord, const int64_t dim_out)
{
  return trexio_read_safe_nucleus_coord_64(file, nucleus_coord, dim_out);
}

trexio_exit_code
trexio_read_safe_ecp_lmax_plus_1 (trexio_t* const file, int32_t* const ecp_lmax_plus_1, const int64_t dim_out)
{
  return trexio_read_safe_ecp_lmax_plus_1_32(file, ecp_lmax_plus_1, dim_out);
}

trexio_exit_code
trexio_read_safe_ecp_z_core (trexio_t* const file, double* const ecp_z_core, const int64_t dim_out)
{
  return trexio_read_safe_ecp_z_core_64(file, ecp_z_core, dim_out);
}

trexio_exit_code
trexio_read_safe_ecp_local_n (trexio_t* const file, int32_t* const ecp_local_n, const int64_t dim_out)
{
  return trexio_read_safe_ecp_local_n_32(file, ecp_local_n, dim_out);
}

trexio_exit_code
trexio_read_safe_ecp_local_exponent (trexio_t* const file, double* const ecp_local_exponent, const int64_t dim_out)
{
  return trexio_read_safe_ecp_local_exponent_64(file, ecp_local_exponent, dim_out);
}

trexio_exit_code
trexio_read_safe_ecp_local_coef (trexio_t* const file, double* const ecp_local_coef, const int64_t dim_out)
{
  return trexio_read_safe_ecp_local_coef_64(file, ecp_local_coef, dim_out);
}

trexio_exit_code
trexio_read_safe_ecp_local_power (trexio_t* const file, int32_t* const ecp_local_power, const int64_t dim_out)
{
  return trexio_read_safe_ecp_local_power_32(file, ecp_local_power, dim_out);
}

trexio_exit_code
trexio_read_safe_ecp_non_local_n (trexio_t* const file, int32_t* const ecp_non_local_n, const int64_t dim_out)
{
  return trexio_read_safe_ecp_non_local_n_32(file, ecp_non_local_n, dim_out);
}

trexio_exit_code
trexio_read_safe_ecp_non_local_exponent (trexio_t* const file, double* const ecp_non_local_exponent, const int64_t dim_out)
{
  return trexio_read_safe_ecp_non_local_exponent_64(file, ecp_non_local_exponent, dim_out);
}

trexio_exit_code
trexio_read_safe_ecp_non_local_coef (trexio_t* const file, double* const ecp_non_local_coef, const int64_t dim_out)
{
  return trexio_read_safe_ecp_non_local_coef_64(file, ecp_non_local_coef, dim_out);
}

trexio_exit_code
trexio_read_safe_ecp_non_local_power (trexio_t* const file, int32_t* const ecp_non_local_power, const int64_t dim_out)
{
  return trexio_read_safe_ecp_non_local_power_32(file, ecp_non_local_power, dim_out);
}

trexio_exit_code
trexio_read_safe_basis_nucleus_index (trexio_t* const file, int32_t* const basis_nucleus_index, const int64_t dim_out)
{
  return trexio_read_safe_basis_nucleus_index_32(file, basis_nucleus_index, dim_out);
}

trexio_exit_code
trexio_read_safe_basis_nucleus_shell_num (trexio_t* const file, int32_t* const basis_nucleus_shell_num, const int64_t dim_out)
{
  return trexio_read_safe_basis_nucleus_shell_num_32(file, basis_nucleus_shell_num, dim_out);
}

trexio_exit_code
trexio_read_safe_basis_shell_ang_mom (trexio_t* const file, int32_t* const basis_shell_ang_mom, const int64_t dim_out)
{
  return trexio_read_safe_basis_shell_ang_mom_32(file, basis_shell_ang_mom, dim_out);
}

trexio_exit_code
trexio_read_safe_basis_shell_prim_num (trexio_t* const file, int32_t* const basis_shell_prim_num, const int64_t dim_out)
{
  return trexio_read_safe_basis_shell_prim_num_32(file, basis_shell_prim_num, dim_out);
}

trexio_exit_code
trexio_read_safe_basis_shell_factor (trexio_t* const file, double* const basis_shell_factor, const int64_t dim_out)
{
  return trexio_read_safe_basis_shell_factor_64(file, basis_shell_factor, dim_out);
}

trexio_exit_code
trexio_read_safe_basis_shell_prim_index (trexio_t* const file, int32_t* const basis_shell_prim_index, const int64_t dim_out)
{
  return trexio_read_safe_basis_shell_prim_index_32(file, basis_shell_prim_index, dim_out);
}

trexio_exit_code
trexio_read_safe_basis_exponent (trexio_t* const file, double* const basis_exponent, const int64_t dim_out)
{
  return trexio_read_safe_basis_exponent_64(file, basis_exponent, dim_out);
}

trexio_exit_code
trexio_read_safe_basis_coefficient (trexio_t* const file, double* const basis_coefficient, const int64_t dim_out)
{
  return trexio_read_safe_basis_coefficient_64(file, basis_coefficient, dim_out);
}

trexio_exit_code
trexio_read_safe_basis_prim_factor (trexio_t* const file, double* const basis_prim_factor, const int64_t dim_out)
{
  return trexio_read_safe_basis_prim_factor_64(file, basis_prim_factor, dim_out);
}

trexio_exit_code
trexio_read_safe_ao_shell (trexio_t* const file, int32_t* const ao_shell, const int64_t dim_out)
{
  return trexio_read_safe_ao_shell_32(file, ao_shell, dim_out);
}

trexio_exit_code
trexio_read_safe_ao_normalization (trexio_t* const file, double* const ao_normalization, const int64_t dim_out)
{
  return trexio_read_safe_ao_normalization_64(file, ao_normalization, dim_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_overlap (trexio_t* const file, double* const ao_1e_int_overlap, const int64_t dim_out)
{
  return trexio_read_safe_ao_1e_int_overlap_64(file, ao_1e_int_overlap, dim_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_kinetic (trexio_t* const file, double* const ao_1e_int_kinetic, const int64_t dim_out)
{
  return trexio_read_safe_ao_1e_int_kinetic_64(file, ao_1e_int_kinetic, dim_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_potential_n_e (trexio_t* const file, double* const ao_1e_int_potential_n_e, const int64_t dim_out)
{
  return trexio_read_safe_ao_1e_int_potential_n_e_64(file, ao_1e_int_potential_n_e, dim_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_ecp_local (trexio_t* const file, double* const ao_1e_int_ecp_local, const int64_t dim_out)
{
  return trexio_read_safe_ao_1e_int_ecp_local_64(file, ao_1e_int_ecp_local, dim_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_ecp_non_local (trexio_t* const file, double* const ao_1e_int_ecp_non_local, const int64_t dim_out)
{
  return trexio_read_safe_ao_1e_int_ecp_non_local_64(file, ao_1e_int_ecp_non_local, dim_out);
}

trexio_exit_code
trexio_read_safe_ao_1e_int_core_hamiltonian (trexio_t* const file, double* const ao_1e_int_core_hamiltonian, const int64_t dim_out)
{
  return trexio_read_safe_ao_1e_int_core_hamiltonian_64(file, ao_1e_int_core_hamiltonian, dim_out);
}

trexio_exit_code
trexio_read_safe_ao_2e_int_eri (trexio_t* const file, double* const ao_2e_int_eri, const int64_t dim_out)
{
  return trexio_read_safe_ao_2e_int_eri_64(file, ao_2e_int_eri, dim_out);
}

trexio_exit_code
trexio_read_safe_ao_2e_int_eri_lr (trexio_t* const file, double* const ao_2e_int_eri_lr, const int64_t dim_out)
{
  return trexio_read_safe_ao_2e_int_eri_lr_64(file, ao_2e_int_eri_lr, dim_out);
}

trexio_exit_code
trexio_read_safe_mo_coefficient (trexio_t* const file, double* const mo_coefficient, const int64_t dim_out)
{
  return trexio_read_safe_mo_coefficient_64(file, mo_coefficient, dim_out);
}

trexio_exit_code
trexio_read_safe_mo_occupation (trexio_t* const file, double* const mo_occupation, const int64_t dim_out)
{
  return trexio_read_safe_mo_occupation_64(file, mo_occupation, dim_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_overlap (trexio_t* const file, double* const mo_1e_int_overlap, const int64_t dim_out)
{
  return trexio_read_safe_mo_1e_int_overlap_64(file, mo_1e_int_overlap, dim_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_kinetic (trexio_t* const file, double* const mo_1e_int_kinetic, const int64_t dim_out)
{
  return trexio_read_safe_mo_1e_int_kinetic_64(file, mo_1e_int_kinetic, dim_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_potential_n_e (trexio_t* const file, double* const mo_1e_int_potential_n_e, const int64_t dim_out)
{
  return trexio_read_safe_mo_1e_int_potential_n_e_64(file, mo_1e_int_potential_n_e, dim_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_ecp_local (trexio_t* const file, double* const mo_1e_int_ecp_local, const int64_t dim_out)
{
  return trexio_read_safe_mo_1e_int_ecp_local_64(file, mo_1e_int_ecp_local, dim_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_ecp_non_local (trexio_t* const file, double* const mo_1e_int_ecp_non_local, const int64_t dim_out)
{
  return trexio_read_safe_mo_1e_int_ecp_non_local_64(file, mo_1e_int_ecp_non_local, dim_out);
}

trexio_exit_code
trexio_read_safe_mo_1e_int_core_hamiltonian (trexio_t* const file, double* const mo_1e_int_core_hamiltonian, const int64_t dim_out)
{
  return trexio_read_safe_mo_1e_int_core_hamiltonian_64(file, mo_1e_int_core_hamiltonian, dim_out);
}

trexio_exit_code
trexio_read_safe_mo_2e_int_eri (trexio_t* const file, double* const mo_2e_int_eri, const int64_t dim_out)
{
  return trexio_read_safe_mo_2e_int_eri_64(file, mo_2e_int_eri, dim_out);
}

trexio_exit_code
trexio_read_safe_mo_2e_int_eri_lr (trexio_t* const file, double* const mo_2e_int_eri_lr, const int64_t dim_out)
{
  return trexio_read_safe_mo_2e_int_eri_lr_64(file, mo_2e_int_eri_lr, dim_out);
}

trexio_exit_code
trexio_read_metadata_code_low (trexio_t* const file, char* dset_out, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_metadata_code(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t metadata_code_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_metadata_code_num_64(file, &(metadata_code_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (metadata_code_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {metadata_code_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);
  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_read_metadata_code(file, dset_out, rank, dims, (uint32_t) max_str_len);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_read_metadata_code(file, dset_out, rank, dims, (uint32_t) max_str_len);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_metadata_code(file, dset_out, rank, dims);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_read_metadata_code (trexio_t* const file, char** dset_out, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_metadata_code(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  trexio_exit_code rc;
  int64_t dset_dim = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_metadata_code_num_64(file, &(dset_dim));
  if (rc != TREXIO_SUCCESS) return rc;

  if (dset_dim == 0L) return TREXIO_INVALID_NUM;

  char* str_compiled = CALLOC(dset_dim*(max_str_len+1) + 1, char);
  if (str_compiled == NULL) return TREXIO_ALLOCATION_FAILED;

  rc = trexio_read_metadata_code_low(file, str_compiled, max_str_len);
  if (rc != TREXIO_SUCCESS) {
    FREE(str_compiled);
    return rc;
  }

  for (uint64_t i=0; i < (uint64_t) dset_dim; i++) {

    char * pch;
    pch = i == 0 ? strtok(str_compiled, TREXIO_DELIM) : strtok(NULL, TREXIO_DELIM) ;
    if (pch == NULL) {
      FREE(str_compiled);
      return TREXIO_FAILURE;
    }

    strcpy(dset_out[i], "");
    strcat(dset_out[i], pch);

  }

  FREE(str_compiled);
  return TREXIO_SUCCESS;

}

trexio_exit_code
trexio_read_metadata_author_low (trexio_t* const file, char* dset_out, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_metadata_author(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t metadata_author_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_metadata_author_num_64(file, &(metadata_author_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (metadata_author_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {metadata_author_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);
  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_read_metadata_author(file, dset_out, rank, dims, (uint32_t) max_str_len);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_read_metadata_author(file, dset_out, rank, dims, (uint32_t) max_str_len);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_metadata_author(file, dset_out, rank, dims);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_read_metadata_author (trexio_t* const file, char** dset_out, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_metadata_author(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  trexio_exit_code rc;
  int64_t dset_dim = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_metadata_author_num_64(file, &(dset_dim));
  if (rc != TREXIO_SUCCESS) return rc;

  if (dset_dim == 0L) return TREXIO_INVALID_NUM;

  char* str_compiled = CALLOC(dset_dim*(max_str_len+1) + 1, char);
  if (str_compiled == NULL) return TREXIO_ALLOCATION_FAILED;

  rc = trexio_read_metadata_author_low(file, str_compiled, max_str_len);
  if (rc != TREXIO_SUCCESS) {
    FREE(str_compiled);
    return rc;
  }

  for (uint64_t i=0; i < (uint64_t) dset_dim; i++) {

    char * pch;
    pch = i == 0 ? strtok(str_compiled, TREXIO_DELIM) : strtok(NULL, TREXIO_DELIM) ;
    if (pch == NULL) {
      FREE(str_compiled);
      return TREXIO_FAILURE;
    }

    strcpy(dset_out[i], "");
    strcat(dset_out[i], pch);

  }

  FREE(str_compiled);
  return TREXIO_SUCCESS;

}

trexio_exit_code
trexio_read_nucleus_label_low (trexio_t* const file, char* dset_out, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_nucleus_label(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);
  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_read_nucleus_label(file, dset_out, rank, dims, (uint32_t) max_str_len);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_read_nucleus_label(file, dset_out, rank, dims, (uint32_t) max_str_len);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_nucleus_label(file, dset_out, rank, dims);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_read_nucleus_label (trexio_t* const file, char** dset_out, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_nucleus_label(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  trexio_exit_code rc;
  int64_t dset_dim = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(dset_dim));
  if (rc != TREXIO_SUCCESS) return rc;

  if (dset_dim == 0L) return TREXIO_INVALID_NUM;

  char* str_compiled = CALLOC(dset_dim*(max_str_len+1) + 1, char);
  if (str_compiled == NULL) return TREXIO_ALLOCATION_FAILED;

  rc = trexio_read_nucleus_label_low(file, str_compiled, max_str_len);
  if (rc != TREXIO_SUCCESS) {
    FREE(str_compiled);
    return rc;
  }

  for (uint64_t i=0; i < (uint64_t) dset_dim; i++) {

    char * pch;
    pch = i == 0 ? strtok(str_compiled, TREXIO_DELIM) : strtok(NULL, TREXIO_DELIM) ;
    if (pch == NULL) {
      FREE(str_compiled);
      return TREXIO_FAILURE;
    }

    strcpy(dset_out[i], "");
    strcat(dset_out[i], pch);

  }

  FREE(str_compiled);
  return TREXIO_SUCCESS;

}

trexio_exit_code
trexio_read_mo_class_low (trexio_t* const file, char* dset_out, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_mo_class(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {mo_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);
  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_read_mo_class(file, dset_out, rank, dims, (uint32_t) max_str_len);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_read_mo_class(file, dset_out, rank, dims, (uint32_t) max_str_len);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_class(file, dset_out, rank, dims);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_read_mo_class (trexio_t* const file, char** dset_out, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_mo_class(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  trexio_exit_code rc;
  int64_t dset_dim = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(dset_dim));
  if (rc != TREXIO_SUCCESS) return rc;

  if (dset_dim == 0L) return TREXIO_INVALID_NUM;

  char* str_compiled = CALLOC(dset_dim*(max_str_len+1) + 1, char);
  if (str_compiled == NULL) return TREXIO_ALLOCATION_FAILED;

  rc = trexio_read_mo_class_low(file, str_compiled, max_str_len);
  if (rc != TREXIO_SUCCESS) {
    FREE(str_compiled);
    return rc;
  }

  for (uint64_t i=0; i < (uint64_t) dset_dim; i++) {

    char * pch;
    pch = i == 0 ? strtok(str_compiled, TREXIO_DELIM) : strtok(NULL, TREXIO_DELIM) ;
    if (pch == NULL) {
      FREE(str_compiled);
      return TREXIO_FAILURE;
    }

    strcpy(dset_out[i], "");
    strcat(dset_out[i], pch);

  }

  FREE(str_compiled);
  return TREXIO_SUCCESS;

}

trexio_exit_code
trexio_read_mo_symmetry_low (trexio_t* const file, char* dset_out, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_mo_symmetry(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {mo_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);
  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_read_mo_symmetry(file, dset_out, rank, dims, (uint32_t) max_str_len);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_read_mo_symmetry(file, dset_out, rank, dims, (uint32_t) max_str_len);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_read_mo_symmetry(file, dset_out, rank, dims);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_read_mo_symmetry (trexio_t* const file, char** dset_out, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_out == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_mo_symmetry(file) != TREXIO_SUCCESS) return TREXIO_DSET_MISSING;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  trexio_exit_code rc;
  int64_t dset_dim = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(dset_dim));
  if (rc != TREXIO_SUCCESS) return rc;

  if (dset_dim == 0L) return TREXIO_INVALID_NUM;

  char* str_compiled = CALLOC(dset_dim*(max_str_len+1) + 1, char);
  if (str_compiled == NULL) return TREXIO_ALLOCATION_FAILED;

  rc = trexio_read_mo_symmetry_low(file, str_compiled, max_str_len);
  if (rc != TREXIO_SUCCESS) {
    FREE(str_compiled);
    return rc;
  }

  for (uint64_t i=0; i < (uint64_t) dset_dim; i++) {

    char * pch;
    pch = i == 0 ? strtok(str_compiled, TREXIO_DELIM) : strtok(NULL, TREXIO_DELIM) ;
    if (pch == NULL) {
      FREE(str_compiled);
      return TREXIO_FAILURE;
    }

    strcpy(dset_out[i], "");
    strcat(dset_out[i], pch);

  }

  FREE(str_compiled);
  return TREXIO_SUCCESS;

}

trexio_exit_code
trexio_read_metadata_code_num_32 (trexio_t* const file, int32_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_metadata_code_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_metadata_code_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_metadata_code_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_metadata_code_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int32_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_metadata_author_num_32 (trexio_t* const file, int32_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_metadata_author_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_metadata_author_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_metadata_author_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_metadata_author_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int32_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_electron_up_num_32 (trexio_t* const file, int32_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_electron_up_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_electron_up_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_electron_up_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_electron_up_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int32_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_electron_dn_num_32 (trexio_t* const file, int32_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_electron_dn_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_electron_dn_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_electron_dn_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_electron_dn_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int32_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_nucleus_num_32 (trexio_t* const file, int32_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_nucleus_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_nucleus_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_nucleus_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_nucleus_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int32_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_local_num_n_max_32 (trexio_t* const file, int32_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_ecp_local_num_n_max(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_local_num_n_max(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_local_num_n_max(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_ecp_local_num_n_max(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int32_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_non_local_num_n_max_32 (trexio_t* const file, int32_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_ecp_non_local_num_n_max(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_non_local_num_n_max(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_non_local_num_n_max(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_ecp_non_local_num_n_max(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int32_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_num_32 (trexio_t* const file, int32_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_basis_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_basis_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_basis_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int32_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_prim_num_32 (trexio_t* const file, int32_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_basis_prim_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_basis_prim_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_prim_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_basis_prim_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int32_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_cartesian_32 (trexio_t* const file, int32_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_ao_cartesian(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ao_cartesian(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_cartesian(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_ao_cartesian(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int32_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_num_32 (trexio_t* const file, int32_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_ao_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ao_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_ao_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int32_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_num_32 (trexio_t* const file, int32_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_mo_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_mo_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_mo_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int32_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_metadata_code_num_64 (trexio_t* const file, int64_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_metadata_code_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_metadata_code_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_metadata_code_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_metadata_code_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int64_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_metadata_author_num_64 (trexio_t* const file, int64_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_metadata_author_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_metadata_author_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_metadata_author_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_metadata_author_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int64_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_electron_up_num_64 (trexio_t* const file, int64_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_electron_up_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_electron_up_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_electron_up_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_electron_up_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int64_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_electron_dn_num_64 (trexio_t* const file, int64_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_electron_dn_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_electron_dn_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_electron_dn_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_electron_dn_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int64_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_nucleus_num_64 (trexio_t* const file, int64_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_nucleus_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_nucleus_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_nucleus_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_nucleus_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int64_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_local_num_n_max_64 (trexio_t* const file, int64_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_ecp_local_num_n_max(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_local_num_n_max(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_local_num_n_max(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_ecp_local_num_n_max(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int64_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ecp_non_local_num_n_max_64 (trexio_t* const file, int64_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_ecp_non_local_num_n_max(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ecp_non_local_num_n_max(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ecp_non_local_num_n_max(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_ecp_non_local_num_n_max(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int64_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_num_64 (trexio_t* const file, int64_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_basis_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_basis_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_basis_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int64_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_basis_prim_num_64 (trexio_t* const file, int64_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_basis_prim_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_basis_prim_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_basis_prim_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_basis_prim_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int64_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_cartesian_64 (trexio_t* const file, int64_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_ao_cartesian(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ao_cartesian(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_cartesian(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_ao_cartesian(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int64_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_ao_num_64 (trexio_t* const file, int64_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_ao_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_ao_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_ao_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_ao_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int64_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_mo_num_64 (trexio_t* const file, int64_t* const num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (trexio_has_mo_num(file) != TREXIO_SUCCESS) return TREXIO_ATTR_MISSING;

  uint64_t u_num = 0;
  trexio_exit_code rc = TREXIO_GROUP_READ_ERROR;

  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_read_mo_num(file, &u_num);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_read_mo_num(file, &u_num);
    break;
/*
  case TREXIO_JSON:
    rc =trexio_json_read_mo_num(file, &u_num);
    break;
*/
  }

  if (rc != TREXIO_SUCCESS) return rc;

  *num = (int64_t) u_num;
  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_read_metadata_code_num (trexio_t* const file, int32_t* const num)
{
  return trexio_read_metadata_code_num_32(file, num);
}

trexio_exit_code
trexio_read_metadata_author_num (trexio_t* const file, int32_t* const num)
{
  return trexio_read_metadata_author_num_32(file, num);
}

trexio_exit_code
trexio_read_electron_up_num (trexio_t* const file, int32_t* const num)
{
  return trexio_read_electron_up_num_32(file, num);
}

trexio_exit_code
trexio_read_electron_dn_num (trexio_t* const file, int32_t* const num)
{
  return trexio_read_electron_dn_num_32(file, num);
}

trexio_exit_code
trexio_read_nucleus_num (trexio_t* const file, int32_t* const num)
{
  return trexio_read_nucleus_num_32(file, num);
}

trexio_exit_code
trexio_read_ecp_local_num_n_max (trexio_t* const file, int32_t* const num)
{
  return trexio_read_ecp_local_num_n_max_32(file, num);
}

trexio_exit_code
trexio_read_ecp_non_local_num_n_max (trexio_t* const file, int32_t* const num)
{
  return trexio_read_ecp_non_local_num_n_max_32(file, num);
}

trexio_exit_code
trexio_read_basis_num (trexio_t* const file, int32_t* const num)
{
  return trexio_read_basis_num_32(file, num);
}

trexio_exit_code
trexio_read_basis_prim_num (trexio_t* const file, int32_t* const num)
{
  return trexio_read_basis_prim_num_32(file, num);
}

trexio_exit_code
trexio_read_ao_cartesian (trexio_t* const file, int32_t* const num)
{
  return trexio_read_ao_cartesian_32(file, num);
}

trexio_exit_code
trexio_read_ao_num (trexio_t* const file, int32_t* const num)
{
  return trexio_read_ao_num_32(file, num);
}

trexio_exit_code
trexio_read_mo_num (trexio_t* const file, int32_t* const num)
{
  return trexio_read_mo_num_32(file, num);
}

trexio_exit_code
trexio_write_metadata_package_version (trexio_t* const file, const char* str, const int32_t max_str_len)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (str  == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_metadata_package_version(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  size_t len_write = strlen(str);
  if ((size_t) max_str_len < len_write) return TREXIO_INVALID_STR_LEN;  

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_metadata_package_version(file, str);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_metadata_package_version(file, str);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_metadata_package_version(file, str);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_metadata_description (trexio_t* const file, const char* str, const int32_t max_str_len)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (str  == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_metadata_description(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  size_t len_write = strlen(str);
  if ((size_t) max_str_len < len_write) return TREXIO_INVALID_STR_LEN;  

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_metadata_description(file, str);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_metadata_description(file, str);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_metadata_description(file, str);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_nucleus_point_group (trexio_t* const file, const char* str, const int32_t max_str_len)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (str  == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_nucleus_point_group(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  size_t len_write = strlen(str);
  if ((size_t) max_str_len < len_write) return TREXIO_INVALID_STR_LEN;  

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_nucleus_point_group(file, str);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_nucleus_point_group(file, str);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_nucleus_point_group(file, str);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_basis_type (trexio_t* const file, const char* str, const int32_t max_str_len)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (str  == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_basis_type(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  size_t len_write = strlen(str);
  if ((size_t) max_str_len < len_write) return TREXIO_INVALID_STR_LEN;  

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_basis_type(file, str);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_basis_type(file, str);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_basis_type(file, str);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_mo_type (trexio_t* const file, const char* str, const int32_t max_str_len)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (str  == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_mo_type(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  size_t len_write = strlen(str);
  if ((size_t) max_str_len < len_write) return TREXIO_INVALID_STR_LEN;  

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_mo_type(file, str);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_mo_type(file, str);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_mo_type(file, str);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_nucleus_charge_32 (trexio_t* const file, const float* nucleus_charge)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (nucleus_charge == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_charge(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* nucleus_charge_64 = CALLOC(dim_size, double);
  if (nucleus_charge_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      nucleus_charge_64[i] = (double) nucleus_charge[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      nucleus_charge_64[i] = (double) nucleus_charge[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_nucleus_charge(file, nucleus_charge_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_nucleus_charge(file, nucleus_charge_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_nucleus_charge(file, nucleus_charge_64, rank, dims);
    break;
*/
  }

  FREE(nucleus_charge_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_nucleus_coord_32 (trexio_t* const file, const float* nucleus_coord)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (nucleus_coord == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_coord(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, 3};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* nucleus_coord_64 = CALLOC(dim_size, double);
  if (nucleus_coord_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      nucleus_coord_64[i] = (double) nucleus_coord[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      nucleus_coord_64[i] = (double) nucleus_coord[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_nucleus_coord(file, nucleus_coord_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_nucleus_coord(file, nucleus_coord_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_nucleus_coord(file, nucleus_coord_64, rank, dims);
    break;
*/
  }

  FREE(nucleus_coord_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ecp_lmax_plus_1_32 (trexio_t* const file, const int32_t* ecp_lmax_plus_1)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_lmax_plus_1 == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_lmax_plus_1(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* ecp_lmax_plus_1_64 = CALLOC(dim_size, int64_t);
  if (ecp_lmax_plus_1_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_lmax_plus_1_64[i] = (int64_t) ecp_lmax_plus_1[i] - (int64_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_lmax_plus_1_64[i] = (int64_t) ecp_lmax_plus_1[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_lmax_plus_1(file, ecp_lmax_plus_1_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_lmax_plus_1(file, ecp_lmax_plus_1_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_lmax_plus_1(file, ecp_lmax_plus_1_64, rank, dims);
    break;
*/
  }

  FREE(ecp_lmax_plus_1_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ecp_z_core_32 (trexio_t* const file, const float* ecp_z_core)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_z_core == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_z_core(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ecp_z_core_64 = CALLOC(dim_size, double);
  if (ecp_z_core_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_z_core_64[i] = (double) ecp_z_core[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_z_core_64[i] = (double) ecp_z_core[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_z_core(file, ecp_z_core_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_z_core(file, ecp_z_core_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_z_core(file, ecp_z_core_64, rank, dims);
    break;
*/
  }

  FREE(ecp_z_core_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ecp_local_n_32 (trexio_t* const file, const int32_t* ecp_local_n)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_local_n == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_n(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* ecp_local_n_64 = CALLOC(dim_size, int64_t);
  if (ecp_local_n_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_local_n_64[i] = (int64_t) ecp_local_n[i] - (int64_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_local_n_64[i] = (int64_t) ecp_local_n[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_local_n(file, ecp_local_n_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_local_n(file, ecp_local_n_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_local_n(file, ecp_local_n_64, rank, dims);
    break;
*/
  }

  FREE(ecp_local_n_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ecp_local_exponent_32 (trexio_t* const file, const float* ecp_local_exponent)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_local_exponent == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_exponent(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ecp_local_exponent_64 = CALLOC(dim_size, double);
  if (ecp_local_exponent_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_local_exponent_64[i] = (double) ecp_local_exponent[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_local_exponent_64[i] = (double) ecp_local_exponent[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_local_exponent(file, ecp_local_exponent_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_local_exponent(file, ecp_local_exponent_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_local_exponent(file, ecp_local_exponent_64, rank, dims);
    break;
*/
  }

  FREE(ecp_local_exponent_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ecp_local_coef_32 (trexio_t* const file, const float* ecp_local_coef)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_local_coef == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_coef(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ecp_local_coef_64 = CALLOC(dim_size, double);
  if (ecp_local_coef_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_local_coef_64[i] = (double) ecp_local_coef[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_local_coef_64[i] = (double) ecp_local_coef[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_local_coef(file, ecp_local_coef_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_local_coef(file, ecp_local_coef_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_local_coef(file, ecp_local_coef_64, rank, dims);
    break;
*/
  }

  FREE(ecp_local_coef_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ecp_local_power_32 (trexio_t* const file, const int32_t* ecp_local_power)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_local_power == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_power(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* ecp_local_power_64 = CALLOC(dim_size, int64_t);
  if (ecp_local_power_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_local_power_64[i] = (int64_t) ecp_local_power[i] - (int64_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_local_power_64[i] = (int64_t) ecp_local_power[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_local_power(file, ecp_local_power_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_local_power(file, ecp_local_power_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_local_power(file, ecp_local_power_64, rank, dims);
    break;
*/
  }

  FREE(ecp_local_power_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ecp_non_local_n_32 (trexio_t* const file, const int32_t* ecp_non_local_n)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_non_local_n == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_n(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* ecp_non_local_n_64 = CALLOC(dim_size, int64_t);
  if (ecp_non_local_n_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_non_local_n_64[i] = (int64_t) ecp_non_local_n[i] - (int64_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_non_local_n_64[i] = (int64_t) ecp_non_local_n[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_non_local_n(file, ecp_non_local_n_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_non_local_n(file, ecp_non_local_n_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_non_local_n(file, ecp_non_local_n_64, rank, dims);
    break;
*/
  }

  FREE(ecp_non_local_n_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ecp_non_local_exponent_32 (trexio_t* const file, const float* ecp_non_local_exponent)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_non_local_exponent == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_exponent(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_non_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ecp_non_local_exponent_64 = CALLOC(dim_size, double);
  if (ecp_non_local_exponent_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_non_local_exponent_64[i] = (double) ecp_non_local_exponent[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_non_local_exponent_64[i] = (double) ecp_non_local_exponent[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_non_local_exponent(file, ecp_non_local_exponent_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_non_local_exponent(file, ecp_non_local_exponent_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_non_local_exponent(file, ecp_non_local_exponent_64, rank, dims);
    break;
*/
  }

  FREE(ecp_non_local_exponent_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ecp_non_local_coef_32 (trexio_t* const file, const float* ecp_non_local_coef)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_non_local_coef == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_coef(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_non_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ecp_non_local_coef_64 = CALLOC(dim_size, double);
  if (ecp_non_local_coef_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_non_local_coef_64[i] = (double) ecp_non_local_coef[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_non_local_coef_64[i] = (double) ecp_non_local_coef[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_non_local_coef(file, ecp_non_local_coef_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_non_local_coef(file, ecp_non_local_coef_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_non_local_coef(file, ecp_non_local_coef_64, rank, dims);
    break;
*/
  }

  FREE(ecp_non_local_coef_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ecp_non_local_power_32 (trexio_t* const file, const int32_t* ecp_non_local_power)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_non_local_power == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_power(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_non_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* ecp_non_local_power_64 = CALLOC(dim_size, int64_t);
  if (ecp_non_local_power_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_non_local_power_64[i] = (int64_t) ecp_non_local_power[i] - (int64_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ecp_non_local_power_64[i] = (int64_t) ecp_non_local_power[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_non_local_power(file, ecp_non_local_power_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_non_local_power(file, ecp_non_local_power_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_non_local_power(file, ecp_non_local_power_64, rank, dims);
    break;
*/
  }

  FREE(ecp_non_local_power_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_basis_nucleus_index_32 (trexio_t* const file, const int32_t* basis_nucleus_index)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_nucleus_index == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_nucleus_index(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* basis_nucleus_index_64 = CALLOC(dim_size, int64_t);
  if (basis_nucleus_index_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (file->one_based) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_nucleus_index_64[i] = (int64_t) basis_nucleus_index[i] - (int64_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_nucleus_index_64[i] = (int64_t) basis_nucleus_index[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_nucleus_index(file, basis_nucleus_index_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_nucleus_index(file, basis_nucleus_index_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_nucleus_index(file, basis_nucleus_index_64, rank, dims);
    break;
*/
  }

  FREE(basis_nucleus_index_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_basis_nucleus_shell_num_32 (trexio_t* const file, const int32_t* basis_nucleus_shell_num)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_nucleus_shell_num == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_nucleus_shell_num(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* basis_nucleus_shell_num_64 = CALLOC(dim_size, int64_t);
  if (basis_nucleus_shell_num_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_nucleus_shell_num_64[i] = (int64_t) basis_nucleus_shell_num[i] - (int64_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_nucleus_shell_num_64[i] = (int64_t) basis_nucleus_shell_num[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_nucleus_shell_num(file, basis_nucleus_shell_num_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_nucleus_shell_num(file, basis_nucleus_shell_num_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_nucleus_shell_num(file, basis_nucleus_shell_num_64, rank, dims);
    break;
*/
  }

  FREE(basis_nucleus_shell_num_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_basis_shell_ang_mom_32 (trexio_t* const file, const int32_t* basis_shell_ang_mom)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_shell_ang_mom == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_ang_mom(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t basis_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_num_64(file, &(basis_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* basis_shell_ang_mom_64 = CALLOC(dim_size, int64_t);
  if (basis_shell_ang_mom_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_shell_ang_mom_64[i] = (int64_t) basis_shell_ang_mom[i] - (int64_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_shell_ang_mom_64[i] = (int64_t) basis_shell_ang_mom[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_shell_ang_mom(file, basis_shell_ang_mom_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_shell_ang_mom(file, basis_shell_ang_mom_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_shell_ang_mom(file, basis_shell_ang_mom_64, rank, dims);
    break;
*/
  }

  FREE(basis_shell_ang_mom_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_basis_shell_prim_num_32 (trexio_t* const file, const int32_t* basis_shell_prim_num)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_shell_prim_num == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_prim_num(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t basis_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_num_64(file, &(basis_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* basis_shell_prim_num_64 = CALLOC(dim_size, int64_t);
  if (basis_shell_prim_num_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_shell_prim_num_64[i] = (int64_t) basis_shell_prim_num[i] - (int64_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_shell_prim_num_64[i] = (int64_t) basis_shell_prim_num[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_shell_prim_num(file, basis_shell_prim_num_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_shell_prim_num(file, basis_shell_prim_num_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_shell_prim_num(file, basis_shell_prim_num_64, rank, dims);
    break;
*/
  }

  FREE(basis_shell_prim_num_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_basis_shell_factor_32 (trexio_t* const file, const float* basis_shell_factor)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_shell_factor == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_factor(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t basis_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_num_64(file, &(basis_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* basis_shell_factor_64 = CALLOC(dim_size, double);
  if (basis_shell_factor_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_shell_factor_64[i] = (double) basis_shell_factor[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_shell_factor_64[i] = (double) basis_shell_factor[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_shell_factor(file, basis_shell_factor_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_shell_factor(file, basis_shell_factor_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_shell_factor(file, basis_shell_factor_64, rank, dims);
    break;
*/
  }

  FREE(basis_shell_factor_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_basis_shell_prim_index_32 (trexio_t* const file, const int32_t* basis_shell_prim_index)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_shell_prim_index == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_prim_index(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t basis_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_num_64(file, &(basis_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* basis_shell_prim_index_64 = CALLOC(dim_size, int64_t);
  if (basis_shell_prim_index_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (file->one_based) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_shell_prim_index_64[i] = (int64_t) basis_shell_prim_index[i] - (int64_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_shell_prim_index_64[i] = (int64_t) basis_shell_prim_index[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_shell_prim_index(file, basis_shell_prim_index_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_shell_prim_index(file, basis_shell_prim_index_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_shell_prim_index(file, basis_shell_prim_index_64, rank, dims);
    break;
*/
  }

  FREE(basis_shell_prim_index_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_basis_exponent_32 (trexio_t* const file, const float* basis_exponent)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_exponent == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_exponent(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t basis_prim_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_prim_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* basis_exponent_64 = CALLOC(dim_size, double);
  if (basis_exponent_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_exponent_64[i] = (double) basis_exponent[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_exponent_64[i] = (double) basis_exponent[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_exponent(file, basis_exponent_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_exponent(file, basis_exponent_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_exponent(file, basis_exponent_64, rank, dims);
    break;
*/
  }

  FREE(basis_exponent_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_basis_coefficient_32 (trexio_t* const file, const float* basis_coefficient)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_coefficient == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_coefficient(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t basis_prim_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_prim_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* basis_coefficient_64 = CALLOC(dim_size, double);
  if (basis_coefficient_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_coefficient_64[i] = (double) basis_coefficient[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_coefficient_64[i] = (double) basis_coefficient[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_coefficient(file, basis_coefficient_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_coefficient(file, basis_coefficient_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_coefficient(file, basis_coefficient_64, rank, dims);
    break;
*/
  }

  FREE(basis_coefficient_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_basis_prim_factor_32 (trexio_t* const file, const float* basis_prim_factor)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_prim_factor == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_prim_factor(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t basis_prim_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_prim_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* basis_prim_factor_64 = CALLOC(dim_size, double);
  if (basis_prim_factor_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_prim_factor_64[i] = (double) basis_prim_factor[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      basis_prim_factor_64[i] = (double) basis_prim_factor[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_prim_factor(file, basis_prim_factor_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_prim_factor(file, basis_prim_factor_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_prim_factor(file, basis_prim_factor_64, rank, dims);
    break;
*/
  }

  FREE(basis_prim_factor_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ao_shell_32 (trexio_t* const file, const int32_t* ao_shell)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_shell == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_shell(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  int64_t* ao_shell_64 = CALLOC(dim_size, int64_t);
  if (ao_shell_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (file->one_based) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_shell_64[i] = (int64_t) ao_shell[i] - (int64_t) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_shell_64[i] = (int64_t) ao_shell[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_shell(file, ao_shell_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_shell(file, ao_shell_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_shell(file, ao_shell_64, rank, dims);
    break;
*/
  }

  FREE(ao_shell_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ao_normalization_32 (trexio_t* const file, const float* ao_normalization)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_normalization == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_normalization(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_normalization_64 = CALLOC(dim_size, double);
  if (ao_normalization_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_normalization_64[i] = (double) ao_normalization[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_normalization_64[i] = (double) ao_normalization[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_normalization(file, ao_normalization_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_normalization(file, ao_normalization_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_normalization(file, ao_normalization_64, rank, dims);
    break;
*/
  }

  FREE(ao_normalization_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ao_1e_int_overlap_32 (trexio_t* const file, const float* ao_1e_int_overlap)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_overlap == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_overlap(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_1e_int_overlap_64 = CALLOC(dim_size, double);
  if (ao_1e_int_overlap_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_overlap_64[i] = (double) ao_1e_int_overlap[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_overlap_64[i] = (double) ao_1e_int_overlap[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_1e_int_overlap(file, ao_1e_int_overlap_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_1e_int_overlap(file, ao_1e_int_overlap_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_1e_int_overlap(file, ao_1e_int_overlap_64, rank, dims);
    break;
*/
  }

  FREE(ao_1e_int_overlap_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ao_1e_int_kinetic_32 (trexio_t* const file, const float* ao_1e_int_kinetic)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_kinetic == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_kinetic(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_1e_int_kinetic_64 = CALLOC(dim_size, double);
  if (ao_1e_int_kinetic_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_kinetic_64[i] = (double) ao_1e_int_kinetic[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_kinetic_64[i] = (double) ao_1e_int_kinetic[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_1e_int_kinetic(file, ao_1e_int_kinetic_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_1e_int_kinetic(file, ao_1e_int_kinetic_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_1e_int_kinetic(file, ao_1e_int_kinetic_64, rank, dims);
    break;
*/
  }

  FREE(ao_1e_int_kinetic_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ao_1e_int_potential_n_e_32 (trexio_t* const file, const float* ao_1e_int_potential_n_e)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_potential_n_e == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_potential_n_e(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_1e_int_potential_n_e_64 = CALLOC(dim_size, double);
  if (ao_1e_int_potential_n_e_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_potential_n_e_64[i] = (double) ao_1e_int_potential_n_e[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_potential_n_e_64[i] = (double) ao_1e_int_potential_n_e[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_1e_int_potential_n_e(file, ao_1e_int_potential_n_e_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_1e_int_potential_n_e(file, ao_1e_int_potential_n_e_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_1e_int_potential_n_e(file, ao_1e_int_potential_n_e_64, rank, dims);
    break;
*/
  }

  FREE(ao_1e_int_potential_n_e_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ao_1e_int_ecp_local_32 (trexio_t* const file, const float* ao_1e_int_ecp_local)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_ecp_local == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_ecp_local(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_1e_int_ecp_local_64 = CALLOC(dim_size, double);
  if (ao_1e_int_ecp_local_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_ecp_local_64[i] = (double) ao_1e_int_ecp_local[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_ecp_local_64[i] = (double) ao_1e_int_ecp_local[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_1e_int_ecp_local(file, ao_1e_int_ecp_local_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_1e_int_ecp_local(file, ao_1e_int_ecp_local_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_1e_int_ecp_local(file, ao_1e_int_ecp_local_64, rank, dims);
    break;
*/
  }

  FREE(ao_1e_int_ecp_local_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ao_1e_int_ecp_non_local_32 (trexio_t* const file, const float* ao_1e_int_ecp_non_local)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_ecp_non_local == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_ecp_non_local(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_1e_int_ecp_non_local_64 = CALLOC(dim_size, double);
  if (ao_1e_int_ecp_non_local_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_ecp_non_local_64[i] = (double) ao_1e_int_ecp_non_local[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_ecp_non_local_64[i] = (double) ao_1e_int_ecp_non_local[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_1e_int_ecp_non_local(file, ao_1e_int_ecp_non_local_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_1e_int_ecp_non_local(file, ao_1e_int_ecp_non_local_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_1e_int_ecp_non_local(file, ao_1e_int_ecp_non_local_64, rank, dims);
    break;
*/
  }

  FREE(ao_1e_int_ecp_non_local_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ao_1e_int_core_hamiltonian_32 (trexio_t* const file, const float* ao_1e_int_core_hamiltonian)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_core_hamiltonian == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_core_hamiltonian(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_1e_int_core_hamiltonian_64 = CALLOC(dim_size, double);
  if (ao_1e_int_core_hamiltonian_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_core_hamiltonian_64[i] = (double) ao_1e_int_core_hamiltonian[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_1e_int_core_hamiltonian_64[i] = (double) ao_1e_int_core_hamiltonian[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_1e_int_core_hamiltonian(file, ao_1e_int_core_hamiltonian_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_1e_int_core_hamiltonian(file, ao_1e_int_core_hamiltonian_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_1e_int_core_hamiltonian(file, ao_1e_int_core_hamiltonian_64, rank, dims);
    break;
*/
  }

  FREE(ao_1e_int_core_hamiltonian_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ao_2e_int_eri_32 (trexio_t* const file, const float* ao_2e_int_eri)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_2e_int_eri == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_2e_int_eri(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 4;
  uint64_t dims[4] = {ao_num, ao_num, ao_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_2e_int_eri_64 = CALLOC(dim_size, double);
  if (ao_2e_int_eri_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_2e_int_eri_64[i] = (double) ao_2e_int_eri[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_2e_int_eri_64[i] = (double) ao_2e_int_eri[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_2e_int_eri(file, ao_2e_int_eri_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_2e_int_eri(file, ao_2e_int_eri_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_2e_int_eri(file, ao_2e_int_eri_64, rank, dims);
    break;
*/
  }

  FREE(ao_2e_int_eri_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_ao_2e_int_eri_lr_32 (trexio_t* const file, const float* ao_2e_int_eri_lr)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_2e_int_eri_lr == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_2e_int_eri_lr(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 4;
  uint64_t dims[4] = {ao_num, ao_num, ao_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* ao_2e_int_eri_lr_64 = CALLOC(dim_size, double);
  if (ao_2e_int_eri_lr_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_2e_int_eri_lr_64[i] = (double) ao_2e_int_eri_lr[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      ao_2e_int_eri_lr_64[i] = (double) ao_2e_int_eri_lr[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_2e_int_eri_lr(file, ao_2e_int_eri_lr_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_2e_int_eri_lr(file, ao_2e_int_eri_lr_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_2e_int_eri_lr(file, ao_2e_int_eri_lr_64, rank, dims);
    break;
*/
  }

  FREE(ao_2e_int_eri_lr_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_mo_coefficient_32 (trexio_t* const file, const float* mo_coefficient)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_coefficient == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_coefficient(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;
  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, ao_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_coefficient_64 = CALLOC(dim_size, double);
  if (mo_coefficient_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_coefficient_64[i] = (double) mo_coefficient[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_coefficient_64[i] = (double) mo_coefficient[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_coefficient(file, mo_coefficient_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_coefficient(file, mo_coefficient_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_coefficient(file, mo_coefficient_64, rank, dims);
    break;
*/
  }

  FREE(mo_coefficient_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_mo_occupation_32 (trexio_t* const file, const float* mo_occupation)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_occupation == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_occupation(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_occupation_64 = CALLOC(dim_size, double);
  if (mo_occupation_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_occupation_64[i] = (double) mo_occupation[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_occupation_64[i] = (double) mo_occupation[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_occupation(file, mo_occupation_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_occupation(file, mo_occupation_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_occupation(file, mo_occupation_64, rank, dims);
    break;
*/
  }

  FREE(mo_occupation_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_mo_1e_int_overlap_32 (trexio_t* const file, const float* mo_1e_int_overlap)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_overlap == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_overlap(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_1e_int_overlap_64 = CALLOC(dim_size, double);
  if (mo_1e_int_overlap_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_overlap_64[i] = (double) mo_1e_int_overlap[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_overlap_64[i] = (double) mo_1e_int_overlap[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_1e_int_overlap(file, mo_1e_int_overlap_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_1e_int_overlap(file, mo_1e_int_overlap_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_1e_int_overlap(file, mo_1e_int_overlap_64, rank, dims);
    break;
*/
  }

  FREE(mo_1e_int_overlap_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_mo_1e_int_kinetic_32 (trexio_t* const file, const float* mo_1e_int_kinetic)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_kinetic == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_kinetic(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_1e_int_kinetic_64 = CALLOC(dim_size, double);
  if (mo_1e_int_kinetic_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_kinetic_64[i] = (double) mo_1e_int_kinetic[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_kinetic_64[i] = (double) mo_1e_int_kinetic[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_1e_int_kinetic(file, mo_1e_int_kinetic_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_1e_int_kinetic(file, mo_1e_int_kinetic_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_1e_int_kinetic(file, mo_1e_int_kinetic_64, rank, dims);
    break;
*/
  }

  FREE(mo_1e_int_kinetic_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_mo_1e_int_potential_n_e_32 (trexio_t* const file, const float* mo_1e_int_potential_n_e)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_potential_n_e == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_potential_n_e(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_1e_int_potential_n_e_64 = CALLOC(dim_size, double);
  if (mo_1e_int_potential_n_e_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_potential_n_e_64[i] = (double) mo_1e_int_potential_n_e[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_potential_n_e_64[i] = (double) mo_1e_int_potential_n_e[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_1e_int_potential_n_e(file, mo_1e_int_potential_n_e_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_1e_int_potential_n_e(file, mo_1e_int_potential_n_e_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_1e_int_potential_n_e(file, mo_1e_int_potential_n_e_64, rank, dims);
    break;
*/
  }

  FREE(mo_1e_int_potential_n_e_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_mo_1e_int_ecp_local_32 (trexio_t* const file, const float* mo_1e_int_ecp_local)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_ecp_local == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_ecp_local(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_1e_int_ecp_local_64 = CALLOC(dim_size, double);
  if (mo_1e_int_ecp_local_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_ecp_local_64[i] = (double) mo_1e_int_ecp_local[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_ecp_local_64[i] = (double) mo_1e_int_ecp_local[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_1e_int_ecp_local(file, mo_1e_int_ecp_local_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_1e_int_ecp_local(file, mo_1e_int_ecp_local_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_1e_int_ecp_local(file, mo_1e_int_ecp_local_64, rank, dims);
    break;
*/
  }

  FREE(mo_1e_int_ecp_local_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_mo_1e_int_ecp_non_local_32 (trexio_t* const file, const float* mo_1e_int_ecp_non_local)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_ecp_non_local == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_ecp_non_local(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_1e_int_ecp_non_local_64 = CALLOC(dim_size, double);
  if (mo_1e_int_ecp_non_local_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_ecp_non_local_64[i] = (double) mo_1e_int_ecp_non_local[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_ecp_non_local_64[i] = (double) mo_1e_int_ecp_non_local[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_1e_int_ecp_non_local(file, mo_1e_int_ecp_non_local_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_1e_int_ecp_non_local(file, mo_1e_int_ecp_non_local_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_1e_int_ecp_non_local(file, mo_1e_int_ecp_non_local_64, rank, dims);
    break;
*/
  }

  FREE(mo_1e_int_ecp_non_local_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_mo_1e_int_core_hamiltonian_32 (trexio_t* const file, const float* mo_1e_int_core_hamiltonian)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_core_hamiltonian == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_core_hamiltonian(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_1e_int_core_hamiltonian_64 = CALLOC(dim_size, double);
  if (mo_1e_int_core_hamiltonian_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_core_hamiltonian_64[i] = (double) mo_1e_int_core_hamiltonian[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_1e_int_core_hamiltonian_64[i] = (double) mo_1e_int_core_hamiltonian[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_1e_int_core_hamiltonian(file, mo_1e_int_core_hamiltonian_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_1e_int_core_hamiltonian(file, mo_1e_int_core_hamiltonian_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_1e_int_core_hamiltonian(file, mo_1e_int_core_hamiltonian_64, rank, dims);
    break;
*/
  }

  FREE(mo_1e_int_core_hamiltonian_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_mo_2e_int_eri_32 (trexio_t* const file, const float* mo_2e_int_eri)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_2e_int_eri == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_2e_int_eri(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 4;
  uint64_t dims[4] = {mo_num, mo_num, mo_num, mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_2e_int_eri_64 = CALLOC(dim_size, double);
  if (mo_2e_int_eri_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_2e_int_eri_64[i] = (double) mo_2e_int_eri[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_2e_int_eri_64[i] = (double) mo_2e_int_eri[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_2e_int_eri(file, mo_2e_int_eri_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_2e_int_eri(file, mo_2e_int_eri_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_2e_int_eri(file, mo_2e_int_eri_64, rank, dims);
    break;
*/
  }

  FREE(mo_2e_int_eri_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_mo_2e_int_eri_lr_32 (trexio_t* const file, const float* mo_2e_int_eri_lr)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_2e_int_eri_lr == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_2e_int_eri_lr(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 4;
  uint64_t dims[4] = {mo_num, mo_num, mo_num, mo_num};

  uint64_t dim_size = 1;
  for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
  }

  double* mo_2e_int_eri_lr_64 = CALLOC(dim_size, double);
  if (mo_2e_int_eri_lr_64 == NULL) return TREXIO_ALLOCATION_FAILED;

  /* A type conversion from single precision to double reqired since back end only accepts 64-bit data */
  if (false) {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_2e_int_eri_lr_64[i] = (double) mo_2e_int_eri_lr[i] - (double) 1;
    }
  } else {
    for (uint64_t i=0; i<dim_size; ++i){
      mo_2e_int_eri_lr_64[i] = (double) mo_2e_int_eri_lr[i];
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_2e_int_eri_lr(file, mo_2e_int_eri_lr_64, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_2e_int_eri_lr(file, mo_2e_int_eri_lr_64, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_2e_int_eri_lr(file, mo_2e_int_eri_lr_64, rank, dims);
    break;
*/
  }

  FREE(mo_2e_int_eri_lr_64);

  if (rc != TREXIO_SUCCESS) return rc;

  return TREXIO_SUCCESS;
}

trexio_exit_code
trexio_write_safe_nucleus_charge_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_charge(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_nucleus_charge_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_nucleus_coord_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_coord(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, 3};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_nucleus_coord_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_lmax_plus_1_32 (trexio_t* const file, const int32_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_lmax_plus_1(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_lmax_plus_1_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_z_core_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_z_core(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_z_core_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_local_n_32 (trexio_t* const file, const int32_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_n(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_local_n_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_local_exponent_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_exponent(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_local_exponent_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_local_coef_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_coef(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_local_coef_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_local_power_32 (trexio_t* const file, const int32_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_power(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_local_power_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_non_local_n_32 (trexio_t* const file, const int32_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_n(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_non_local_n_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_non_local_exponent_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_exponent(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_non_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_non_local_exponent_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_non_local_coef_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_coef(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_non_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_non_local_coef_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_non_local_power_32 (trexio_t* const file, const int32_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_power(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_non_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_non_local_power_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_nucleus_index_32 (trexio_t* const file, const int32_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_nucleus_index(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_nucleus_index_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_nucleus_shell_num_32 (trexio_t* const file, const int32_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_nucleus_shell_num(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_nucleus_shell_num_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_shell_ang_mom_32 (trexio_t* const file, const int32_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_ang_mom(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t basis_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_num_64(file, &(basis_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_shell_ang_mom_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_shell_prim_num_32 (trexio_t* const file, const int32_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_prim_num(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t basis_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_num_64(file, &(basis_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_shell_prim_num_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_shell_factor_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_factor(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t basis_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_num_64(file, &(basis_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_shell_factor_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_shell_prim_index_32 (trexio_t* const file, const int32_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_prim_index(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t basis_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_num_64(file, &(basis_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_shell_prim_index_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_exponent_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_exponent(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t basis_prim_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_prim_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_exponent_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_coefficient_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_coefficient(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t basis_prim_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_prim_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_coefficient_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_prim_factor_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_prim_factor(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t basis_prim_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_prim_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_prim_factor_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_shell_32 (trexio_t* const file, const int32_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_shell(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_shell_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_normalization_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_normalization(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_normalization_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_overlap_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_overlap(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_1e_int_overlap_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_kinetic_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_kinetic(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_1e_int_kinetic_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_potential_n_e_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_potential_n_e(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_1e_int_potential_n_e_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_ecp_local_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_ecp_local(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_1e_int_ecp_local_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_ecp_non_local_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_ecp_non_local(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_1e_int_ecp_non_local_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_core_hamiltonian_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_core_hamiltonian(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_1e_int_core_hamiltonian_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_2e_int_eri_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_2e_int_eri(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 4;
uint64_t dims[4] = {ao_num, ao_num, ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_2e_int_eri_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_2e_int_eri_lr_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_2e_int_eri_lr(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 4;
uint64_t dims[4] = {ao_num, ao_num, ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_2e_int_eri_lr_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_coefficient_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_coefficient(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;
if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_coefficient_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_occupation_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_occupation(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_occupation_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_overlap_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_overlap(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_1e_int_overlap_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_kinetic_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_kinetic(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_1e_int_kinetic_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_potential_n_e_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_potential_n_e(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_1e_int_potential_n_e_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_ecp_local_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_ecp_local(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_1e_int_ecp_local_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_ecp_non_local_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_ecp_non_local(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_1e_int_ecp_non_local_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_core_hamiltonian_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_core_hamiltonian(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_1e_int_core_hamiltonian_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_2e_int_eri_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_2e_int_eri(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 4;
uint64_t dims[4] = {mo_num, mo_num, mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_2e_int_eri_32(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_2e_int_eri_lr_32 (trexio_t* const file, const float* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_2e_int_eri_lr(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 4;
uint64_t dims[4] = {mo_num, mo_num, mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_2e_int_eri_lr_32(file, dset_in);
}

trexio_exit_code
trexio_write_nucleus_charge_64 (trexio_t* const file, const double* nucleus_charge)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (nucleus_charge == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_charge(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  double* nucleus_charge_p = (double*) nucleus_charge;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    nucleus_charge_p = CALLOC(dim_size, double);
    if (nucleus_charge_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       nucleus_charge_p[i] = nucleus_charge_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_nucleus_charge(file, nucleus_charge_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_nucleus_charge(file, nucleus_charge_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_nucleus_charge(file, nucleus_charge_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(nucleus_charge_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_nucleus_coord_64 (trexio_t* const file, const double* nucleus_coord)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (nucleus_coord == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_coord(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, 3};

  double* nucleus_coord_p = (double*) nucleus_coord;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    nucleus_coord_p = CALLOC(dim_size, double);
    if (nucleus_coord_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       nucleus_coord_p[i] = nucleus_coord_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_nucleus_coord(file, nucleus_coord_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_nucleus_coord(file, nucleus_coord_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_nucleus_coord(file, nucleus_coord_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(nucleus_coord_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ecp_lmax_plus_1_64 (trexio_t* const file, const int64_t* ecp_lmax_plus_1)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_lmax_plus_1 == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_lmax_plus_1(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  int64_t* ecp_lmax_plus_1_p = (int64_t*) ecp_lmax_plus_1;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ecp_lmax_plus_1_p = CALLOC(dim_size, int64_t);
    if (ecp_lmax_plus_1_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ecp_lmax_plus_1_p[i] = ecp_lmax_plus_1_p[i] - (int32_t) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_lmax_plus_1(file, ecp_lmax_plus_1_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_lmax_plus_1(file, ecp_lmax_plus_1_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_lmax_plus_1(file, ecp_lmax_plus_1_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ecp_lmax_plus_1_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ecp_z_core_64 (trexio_t* const file, const double* ecp_z_core)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_z_core == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_z_core(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  double* ecp_z_core_p = (double*) ecp_z_core;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ecp_z_core_p = CALLOC(dim_size, double);
    if (ecp_z_core_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ecp_z_core_p[i] = ecp_z_core_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_z_core(file, ecp_z_core_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_z_core(file, ecp_z_core_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_z_core(file, ecp_z_core_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ecp_z_core_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ecp_local_n_64 (trexio_t* const file, const int64_t* ecp_local_n)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_local_n == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_n(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  int64_t* ecp_local_n_p = (int64_t*) ecp_local_n;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ecp_local_n_p = CALLOC(dim_size, int64_t);
    if (ecp_local_n_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ecp_local_n_p[i] = ecp_local_n_p[i] - (int32_t) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_local_n(file, ecp_local_n_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_local_n(file, ecp_local_n_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_local_n(file, ecp_local_n_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ecp_local_n_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ecp_local_exponent_64 (trexio_t* const file, const double* ecp_local_exponent)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_local_exponent == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_exponent(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

  double* ecp_local_exponent_p = (double*) ecp_local_exponent;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ecp_local_exponent_p = CALLOC(dim_size, double);
    if (ecp_local_exponent_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ecp_local_exponent_p[i] = ecp_local_exponent_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_local_exponent(file, ecp_local_exponent_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_local_exponent(file, ecp_local_exponent_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_local_exponent(file, ecp_local_exponent_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ecp_local_exponent_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ecp_local_coef_64 (trexio_t* const file, const double* ecp_local_coef)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_local_coef == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_coef(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

  double* ecp_local_coef_p = (double*) ecp_local_coef;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ecp_local_coef_p = CALLOC(dim_size, double);
    if (ecp_local_coef_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ecp_local_coef_p[i] = ecp_local_coef_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_local_coef(file, ecp_local_coef_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_local_coef(file, ecp_local_coef_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_local_coef(file, ecp_local_coef_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ecp_local_coef_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ecp_local_power_64 (trexio_t* const file, const int64_t* ecp_local_power)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_local_power == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_power(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

  int64_t* ecp_local_power_p = (int64_t*) ecp_local_power;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ecp_local_power_p = CALLOC(dim_size, int64_t);
    if (ecp_local_power_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ecp_local_power_p[i] = ecp_local_power_p[i] - (int32_t) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_local_power(file, ecp_local_power_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_local_power(file, ecp_local_power_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_local_power(file, ecp_local_power_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ecp_local_power_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ecp_non_local_n_64 (trexio_t* const file, const int64_t* ecp_non_local_n)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_non_local_n == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_n(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  int64_t* ecp_non_local_n_p = (int64_t*) ecp_non_local_n;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ecp_non_local_n_p = CALLOC(dim_size, int64_t);
    if (ecp_non_local_n_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ecp_non_local_n_p[i] = ecp_non_local_n_p[i] - (int32_t) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_non_local_n(file, ecp_non_local_n_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_non_local_n(file, ecp_non_local_n_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_non_local_n(file, ecp_non_local_n_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ecp_non_local_n_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ecp_non_local_exponent_64 (trexio_t* const file, const double* ecp_non_local_exponent)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_non_local_exponent == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_exponent(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_non_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

  double* ecp_non_local_exponent_p = (double*) ecp_non_local_exponent;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ecp_non_local_exponent_p = CALLOC(dim_size, double);
    if (ecp_non_local_exponent_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ecp_non_local_exponent_p[i] = ecp_non_local_exponent_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_non_local_exponent(file, ecp_non_local_exponent_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_non_local_exponent(file, ecp_non_local_exponent_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_non_local_exponent(file, ecp_non_local_exponent_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ecp_non_local_exponent_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ecp_non_local_coef_64 (trexio_t* const file, const double* ecp_non_local_coef)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_non_local_coef == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_coef(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_non_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

  double* ecp_non_local_coef_p = (double*) ecp_non_local_coef;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ecp_non_local_coef_p = CALLOC(dim_size, double);
    if (ecp_non_local_coef_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ecp_non_local_coef_p[i] = ecp_non_local_coef_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_non_local_coef(file, ecp_non_local_coef_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_non_local_coef(file, ecp_non_local_coef_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_non_local_coef(file, ecp_non_local_coef_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ecp_non_local_coef_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ecp_non_local_power_64 (trexio_t* const file, const int64_t* ecp_non_local_power)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ecp_non_local_power == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_power(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;
  int64_t ecp_non_local_num_n_max = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
  if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

  int64_t* ecp_non_local_power_p = (int64_t*) ecp_non_local_power;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ecp_non_local_power_p = CALLOC(dim_size, int64_t);
    if (ecp_non_local_power_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ecp_non_local_power_p[i] = ecp_non_local_power_p[i] - (int32_t) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ecp_non_local_power(file, ecp_non_local_power_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ecp_non_local_power(file, ecp_non_local_power_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ecp_non_local_power(file, ecp_non_local_power_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ecp_non_local_power_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_basis_nucleus_index_64 (trexio_t* const file, const int64_t* basis_nucleus_index)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_nucleus_index == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_nucleus_index(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  int64_t* basis_nucleus_index_p = (int64_t*) basis_nucleus_index;

  /* Handle index type */
  if (file->one_based) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    basis_nucleus_index_p = CALLOC(dim_size, int64_t);
    if (basis_nucleus_index_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       basis_nucleus_index_p[i] = basis_nucleus_index_p[i] - (int32_t) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_nucleus_index(file, basis_nucleus_index_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_nucleus_index(file, basis_nucleus_index_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_nucleus_index(file, basis_nucleus_index_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (file->one_based) {
    FREE(basis_nucleus_index_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_basis_nucleus_shell_num_64 (trexio_t* const file, const int64_t* basis_nucleus_shell_num)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_nucleus_shell_num == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_nucleus_shell_num(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  int64_t* basis_nucleus_shell_num_p = (int64_t*) basis_nucleus_shell_num;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    basis_nucleus_shell_num_p = CALLOC(dim_size, int64_t);
    if (basis_nucleus_shell_num_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       basis_nucleus_shell_num_p[i] = basis_nucleus_shell_num_p[i] - (int32_t) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_nucleus_shell_num(file, basis_nucleus_shell_num_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_nucleus_shell_num(file, basis_nucleus_shell_num_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_nucleus_shell_num(file, basis_nucleus_shell_num_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(basis_nucleus_shell_num_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_basis_shell_ang_mom_64 (trexio_t* const file, const int64_t* basis_shell_ang_mom)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_shell_ang_mom == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_ang_mom(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t basis_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_num_64(file, &(basis_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_num};

  int64_t* basis_shell_ang_mom_p = (int64_t*) basis_shell_ang_mom;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    basis_shell_ang_mom_p = CALLOC(dim_size, int64_t);
    if (basis_shell_ang_mom_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       basis_shell_ang_mom_p[i] = basis_shell_ang_mom_p[i] - (int32_t) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_shell_ang_mom(file, basis_shell_ang_mom_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_shell_ang_mom(file, basis_shell_ang_mom_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_shell_ang_mom(file, basis_shell_ang_mom_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(basis_shell_ang_mom_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_basis_shell_prim_num_64 (trexio_t* const file, const int64_t* basis_shell_prim_num)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_shell_prim_num == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_prim_num(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t basis_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_num_64(file, &(basis_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_num};

  int64_t* basis_shell_prim_num_p = (int64_t*) basis_shell_prim_num;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    basis_shell_prim_num_p = CALLOC(dim_size, int64_t);
    if (basis_shell_prim_num_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       basis_shell_prim_num_p[i] = basis_shell_prim_num_p[i] - (int32_t) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_shell_prim_num(file, basis_shell_prim_num_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_shell_prim_num(file, basis_shell_prim_num_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_shell_prim_num(file, basis_shell_prim_num_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(basis_shell_prim_num_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_basis_shell_factor_64 (trexio_t* const file, const double* basis_shell_factor)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_shell_factor == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_factor(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t basis_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_num_64(file, &(basis_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_num};

  double* basis_shell_factor_p = (double*) basis_shell_factor;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    basis_shell_factor_p = CALLOC(dim_size, double);
    if (basis_shell_factor_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       basis_shell_factor_p[i] = basis_shell_factor_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_shell_factor(file, basis_shell_factor_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_shell_factor(file, basis_shell_factor_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_shell_factor(file, basis_shell_factor_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(basis_shell_factor_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_basis_shell_prim_index_64 (trexio_t* const file, const int64_t* basis_shell_prim_index)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_shell_prim_index == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_prim_index(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t basis_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_num_64(file, &(basis_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_num};

  int64_t* basis_shell_prim_index_p = (int64_t*) basis_shell_prim_index;

  /* Handle index type */
  if (file->one_based) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    basis_shell_prim_index_p = CALLOC(dim_size, int64_t);
    if (basis_shell_prim_index_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       basis_shell_prim_index_p[i] = basis_shell_prim_index_p[i] - (int32_t) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_shell_prim_index(file, basis_shell_prim_index_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_shell_prim_index(file, basis_shell_prim_index_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_shell_prim_index(file, basis_shell_prim_index_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (file->one_based) {
    FREE(basis_shell_prim_index_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_basis_exponent_64 (trexio_t* const file, const double* basis_exponent)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_exponent == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_exponent(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t basis_prim_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_prim_num};

  double* basis_exponent_p = (double*) basis_exponent;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    basis_exponent_p = CALLOC(dim_size, double);
    if (basis_exponent_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       basis_exponent_p[i] = basis_exponent_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_exponent(file, basis_exponent_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_exponent(file, basis_exponent_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_exponent(file, basis_exponent_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(basis_exponent_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_basis_coefficient_64 (trexio_t* const file, const double* basis_coefficient)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_coefficient == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_coefficient(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t basis_prim_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_prim_num};

  double* basis_coefficient_p = (double*) basis_coefficient;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    basis_coefficient_p = CALLOC(dim_size, double);
    if (basis_coefficient_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       basis_coefficient_p[i] = basis_coefficient_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_coefficient(file, basis_coefficient_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_coefficient(file, basis_coefficient_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_coefficient(file, basis_coefficient_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(basis_coefficient_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_basis_prim_factor_64 (trexio_t* const file, const double* basis_prim_factor)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (basis_prim_factor == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_prim_factor(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t basis_prim_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {basis_prim_num};

  double* basis_prim_factor_p = (double*) basis_prim_factor;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    basis_prim_factor_p = CALLOC(dim_size, double);
    if (basis_prim_factor_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       basis_prim_factor_p[i] = basis_prim_factor_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_basis_prim_factor(file, basis_prim_factor_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_basis_prim_factor(file, basis_prim_factor_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_basis_prim_factor(file, basis_prim_factor_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(basis_prim_factor_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ao_shell_64 (trexio_t* const file, const int64_t* ao_shell)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_shell == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_shell(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {ao_num};

  int64_t* ao_shell_p = (int64_t*) ao_shell;

  /* Handle index type */
  if (file->one_based) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ao_shell_p = CALLOC(dim_size, int64_t);
    if (ao_shell_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ao_shell_p[i] = ao_shell_p[i] - (int32_t) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_shell(file, ao_shell_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_shell(file, ao_shell_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_shell(file, ao_shell_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (file->one_based) {
    FREE(ao_shell_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ao_normalization_64 (trexio_t* const file, const double* ao_normalization)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_normalization == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_normalization(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {ao_num};

  double* ao_normalization_p = (double*) ao_normalization;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ao_normalization_p = CALLOC(dim_size, double);
    if (ao_normalization_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ao_normalization_p[i] = ao_normalization_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_normalization(file, ao_normalization_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_normalization(file, ao_normalization_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_normalization(file, ao_normalization_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ao_normalization_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ao_1e_int_overlap_64 (trexio_t* const file, const double* ao_1e_int_overlap)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_overlap == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_overlap(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  double* ao_1e_int_overlap_p = (double*) ao_1e_int_overlap;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ao_1e_int_overlap_p = CALLOC(dim_size, double);
    if (ao_1e_int_overlap_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ao_1e_int_overlap_p[i] = ao_1e_int_overlap_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_1e_int_overlap(file, ao_1e_int_overlap_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_1e_int_overlap(file, ao_1e_int_overlap_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_1e_int_overlap(file, ao_1e_int_overlap_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ao_1e_int_overlap_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ao_1e_int_kinetic_64 (trexio_t* const file, const double* ao_1e_int_kinetic)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_kinetic == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_kinetic(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  double* ao_1e_int_kinetic_p = (double*) ao_1e_int_kinetic;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ao_1e_int_kinetic_p = CALLOC(dim_size, double);
    if (ao_1e_int_kinetic_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ao_1e_int_kinetic_p[i] = ao_1e_int_kinetic_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_1e_int_kinetic(file, ao_1e_int_kinetic_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_1e_int_kinetic(file, ao_1e_int_kinetic_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_1e_int_kinetic(file, ao_1e_int_kinetic_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ao_1e_int_kinetic_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ao_1e_int_potential_n_e_64 (trexio_t* const file, const double* ao_1e_int_potential_n_e)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_potential_n_e == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_potential_n_e(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  double* ao_1e_int_potential_n_e_p = (double*) ao_1e_int_potential_n_e;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ao_1e_int_potential_n_e_p = CALLOC(dim_size, double);
    if (ao_1e_int_potential_n_e_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ao_1e_int_potential_n_e_p[i] = ao_1e_int_potential_n_e_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_1e_int_potential_n_e(file, ao_1e_int_potential_n_e_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_1e_int_potential_n_e(file, ao_1e_int_potential_n_e_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_1e_int_potential_n_e(file, ao_1e_int_potential_n_e_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ao_1e_int_potential_n_e_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ao_1e_int_ecp_local_64 (trexio_t* const file, const double* ao_1e_int_ecp_local)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_ecp_local == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_ecp_local(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  double* ao_1e_int_ecp_local_p = (double*) ao_1e_int_ecp_local;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ao_1e_int_ecp_local_p = CALLOC(dim_size, double);
    if (ao_1e_int_ecp_local_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ao_1e_int_ecp_local_p[i] = ao_1e_int_ecp_local_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_1e_int_ecp_local(file, ao_1e_int_ecp_local_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_1e_int_ecp_local(file, ao_1e_int_ecp_local_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_1e_int_ecp_local(file, ao_1e_int_ecp_local_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ao_1e_int_ecp_local_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ao_1e_int_ecp_non_local_64 (trexio_t* const file, const double* ao_1e_int_ecp_non_local)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_ecp_non_local == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_ecp_non_local(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  double* ao_1e_int_ecp_non_local_p = (double*) ao_1e_int_ecp_non_local;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ao_1e_int_ecp_non_local_p = CALLOC(dim_size, double);
    if (ao_1e_int_ecp_non_local_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ao_1e_int_ecp_non_local_p[i] = ao_1e_int_ecp_non_local_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_1e_int_ecp_non_local(file, ao_1e_int_ecp_non_local_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_1e_int_ecp_non_local(file, ao_1e_int_ecp_non_local_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_1e_int_ecp_non_local(file, ao_1e_int_ecp_non_local_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ao_1e_int_ecp_non_local_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ao_1e_int_core_hamiltonian_64 (trexio_t* const file, const double* ao_1e_int_core_hamiltonian)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_1e_int_core_hamiltonian == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_core_hamiltonian(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {ao_num, ao_num};

  double* ao_1e_int_core_hamiltonian_p = (double*) ao_1e_int_core_hamiltonian;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ao_1e_int_core_hamiltonian_p = CALLOC(dim_size, double);
    if (ao_1e_int_core_hamiltonian_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ao_1e_int_core_hamiltonian_p[i] = ao_1e_int_core_hamiltonian_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_1e_int_core_hamiltonian(file, ao_1e_int_core_hamiltonian_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_1e_int_core_hamiltonian(file, ao_1e_int_core_hamiltonian_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_1e_int_core_hamiltonian(file, ao_1e_int_core_hamiltonian_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ao_1e_int_core_hamiltonian_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ao_2e_int_eri_64 (trexio_t* const file, const double* ao_2e_int_eri)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_2e_int_eri == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_2e_int_eri(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 4;
  uint64_t dims[4] = {ao_num, ao_num, ao_num, ao_num};

  double* ao_2e_int_eri_p = (double*) ao_2e_int_eri;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ao_2e_int_eri_p = CALLOC(dim_size, double);
    if (ao_2e_int_eri_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ao_2e_int_eri_p[i] = ao_2e_int_eri_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_2e_int_eri(file, ao_2e_int_eri_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_2e_int_eri(file, ao_2e_int_eri_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_2e_int_eri(file, ao_2e_int_eri_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ao_2e_int_eri_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_ao_2e_int_eri_lr_64 (trexio_t* const file, const double* ao_2e_int_eri_lr)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (ao_2e_int_eri_lr == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_2e_int_eri_lr(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 4;
  uint64_t dims[4] = {ao_num, ao_num, ao_num, ao_num};

  double* ao_2e_int_eri_lr_p = (double*) ao_2e_int_eri_lr;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    ao_2e_int_eri_lr_p = CALLOC(dim_size, double);
    if (ao_2e_int_eri_lr_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       ao_2e_int_eri_lr_p[i] = ao_2e_int_eri_lr_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_ao_2e_int_eri_lr(file, ao_2e_int_eri_lr_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_ao_2e_int_eri_lr(file, ao_2e_int_eri_lr_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_ao_2e_int_eri_lr(file, ao_2e_int_eri_lr_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(ao_2e_int_eri_lr_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_mo_coefficient_64 (trexio_t* const file, const double* mo_coefficient)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_coefficient == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_coefficient(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;
  int64_t ao_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;
  rc = trexio_read_ao_num_64(file, &(ao_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;
  if (ao_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, ao_num};

  double* mo_coefficient_p = (double*) mo_coefficient;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    mo_coefficient_p = CALLOC(dim_size, double);
    if (mo_coefficient_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       mo_coefficient_p[i] = mo_coefficient_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_coefficient(file, mo_coefficient_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_coefficient(file, mo_coefficient_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_coefficient(file, mo_coefficient_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(mo_coefficient_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_mo_occupation_64 (trexio_t* const file, const double* mo_occupation)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_occupation == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_occupation(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {mo_num};

  double* mo_occupation_p = (double*) mo_occupation;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    mo_occupation_p = CALLOC(dim_size, double);
    if (mo_occupation_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       mo_occupation_p[i] = mo_occupation_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_occupation(file, mo_occupation_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_occupation(file, mo_occupation_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_occupation(file, mo_occupation_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(mo_occupation_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_mo_1e_int_overlap_64 (trexio_t* const file, const double* mo_1e_int_overlap)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_overlap == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_overlap(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  double* mo_1e_int_overlap_p = (double*) mo_1e_int_overlap;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    mo_1e_int_overlap_p = CALLOC(dim_size, double);
    if (mo_1e_int_overlap_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       mo_1e_int_overlap_p[i] = mo_1e_int_overlap_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_1e_int_overlap(file, mo_1e_int_overlap_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_1e_int_overlap(file, mo_1e_int_overlap_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_1e_int_overlap(file, mo_1e_int_overlap_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(mo_1e_int_overlap_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_mo_1e_int_kinetic_64 (trexio_t* const file, const double* mo_1e_int_kinetic)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_kinetic == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_kinetic(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  double* mo_1e_int_kinetic_p = (double*) mo_1e_int_kinetic;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    mo_1e_int_kinetic_p = CALLOC(dim_size, double);
    if (mo_1e_int_kinetic_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       mo_1e_int_kinetic_p[i] = mo_1e_int_kinetic_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_1e_int_kinetic(file, mo_1e_int_kinetic_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_1e_int_kinetic(file, mo_1e_int_kinetic_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_1e_int_kinetic(file, mo_1e_int_kinetic_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(mo_1e_int_kinetic_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_mo_1e_int_potential_n_e_64 (trexio_t* const file, const double* mo_1e_int_potential_n_e)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_potential_n_e == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_potential_n_e(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  double* mo_1e_int_potential_n_e_p = (double*) mo_1e_int_potential_n_e;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    mo_1e_int_potential_n_e_p = CALLOC(dim_size, double);
    if (mo_1e_int_potential_n_e_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       mo_1e_int_potential_n_e_p[i] = mo_1e_int_potential_n_e_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_1e_int_potential_n_e(file, mo_1e_int_potential_n_e_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_1e_int_potential_n_e(file, mo_1e_int_potential_n_e_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_1e_int_potential_n_e(file, mo_1e_int_potential_n_e_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(mo_1e_int_potential_n_e_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_mo_1e_int_ecp_local_64 (trexio_t* const file, const double* mo_1e_int_ecp_local)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_ecp_local == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_ecp_local(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  double* mo_1e_int_ecp_local_p = (double*) mo_1e_int_ecp_local;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    mo_1e_int_ecp_local_p = CALLOC(dim_size, double);
    if (mo_1e_int_ecp_local_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       mo_1e_int_ecp_local_p[i] = mo_1e_int_ecp_local_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_1e_int_ecp_local(file, mo_1e_int_ecp_local_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_1e_int_ecp_local(file, mo_1e_int_ecp_local_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_1e_int_ecp_local(file, mo_1e_int_ecp_local_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(mo_1e_int_ecp_local_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_mo_1e_int_ecp_non_local_64 (trexio_t* const file, const double* mo_1e_int_ecp_non_local)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_ecp_non_local == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_ecp_non_local(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  double* mo_1e_int_ecp_non_local_p = (double*) mo_1e_int_ecp_non_local;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    mo_1e_int_ecp_non_local_p = CALLOC(dim_size, double);
    if (mo_1e_int_ecp_non_local_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       mo_1e_int_ecp_non_local_p[i] = mo_1e_int_ecp_non_local_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_1e_int_ecp_non_local(file, mo_1e_int_ecp_non_local_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_1e_int_ecp_non_local(file, mo_1e_int_ecp_non_local_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_1e_int_ecp_non_local(file, mo_1e_int_ecp_non_local_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(mo_1e_int_ecp_non_local_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_mo_1e_int_core_hamiltonian_64 (trexio_t* const file, const double* mo_1e_int_core_hamiltonian)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_1e_int_core_hamiltonian == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_core_hamiltonian(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 2;
  uint64_t dims[2] = {mo_num, mo_num};

  double* mo_1e_int_core_hamiltonian_p = (double*) mo_1e_int_core_hamiltonian;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    mo_1e_int_core_hamiltonian_p = CALLOC(dim_size, double);
    if (mo_1e_int_core_hamiltonian_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       mo_1e_int_core_hamiltonian_p[i] = mo_1e_int_core_hamiltonian_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_1e_int_core_hamiltonian(file, mo_1e_int_core_hamiltonian_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_1e_int_core_hamiltonian(file, mo_1e_int_core_hamiltonian_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_1e_int_core_hamiltonian(file, mo_1e_int_core_hamiltonian_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(mo_1e_int_core_hamiltonian_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_mo_2e_int_eri_64 (trexio_t* const file, const double* mo_2e_int_eri)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_2e_int_eri == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_2e_int_eri(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 4;
  uint64_t dims[4] = {mo_num, mo_num, mo_num, mo_num};

  double* mo_2e_int_eri_p = (double*) mo_2e_int_eri;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    mo_2e_int_eri_p = CALLOC(dim_size, double);
    if (mo_2e_int_eri_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       mo_2e_int_eri_p[i] = mo_2e_int_eri_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_2e_int_eri(file, mo_2e_int_eri_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_2e_int_eri(file, mo_2e_int_eri_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_2e_int_eri(file, mo_2e_int_eri_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(mo_2e_int_eri_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_mo_2e_int_eri_lr_64 (trexio_t* const file, const double* mo_2e_int_eri_lr)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (mo_2e_int_eri_lr == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_2e_int_eri_lr(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 4;
  uint64_t dims[4] = {mo_num, mo_num, mo_num, mo_num};

  double* mo_2e_int_eri_lr_p = (double*) mo_2e_int_eri_lr;

  /* Handle index type */
  if (false) {

    uint64_t dim_size = 1;
    for (uint32_t i=0; i<rank; ++i){
        dim_size *= dims[i];
    }

    mo_2e_int_eri_lr_p = CALLOC(dim_size, double);
    if (mo_2e_int_eri_lr_p == NULL) return TREXIO_ALLOCATION_FAILED;

    for (uint64_t i=0; i<dim_size; ++i){
       mo_2e_int_eri_lr_p[i] = mo_2e_int_eri_lr_p[i] - (float) 1;
    }
  }

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  rc = TREXIO_FAILURE;
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_2e_int_eri_lr(file, mo_2e_int_eri_lr_p, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_2e_int_eri_lr(file, mo_2e_int_eri_lr_p, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_2e_int_eri_lr(file, mo_2e_int_eri_lr_p, rank, dims);
    break;
*/
  }

  /* Handle index type */
  if (false) {
    FREE(mo_2e_int_eri_lr_p);
  }

  return rc;
}

trexio_exit_code
trexio_write_safe_nucleus_charge_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_charge(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_nucleus_charge_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_nucleus_coord_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_coord(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, 3};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_nucleus_coord_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_lmax_plus_1_64 (trexio_t* const file, const int64_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_lmax_plus_1(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_lmax_plus_1_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_z_core_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_z_core(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_z_core_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_local_n_64 (trexio_t* const file, const int64_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_n(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_local_n_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_local_exponent_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_exponent(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_local_exponent_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_local_coef_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_coef(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_local_coef_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_local_power_64 (trexio_t* const file, const int64_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_power(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_local_num_n_max_64(file, &(ecp_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_local_power_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_non_local_n_64 (trexio_t* const file, const int64_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_n(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_non_local_n_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_non_local_exponent_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_exponent(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_non_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_non_local_exponent_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_non_local_coef_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_coef(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_non_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_non_local_coef_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ecp_non_local_power_64 (trexio_t* const file, const int64_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_power(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;
int64_t ecp_non_local_num_n_max = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ecp_non_local_num_n_max_64(file, &(ecp_non_local_num_n_max));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;
if (ecp_non_local_num_n_max == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {nucleus_num, ecp_non_local_num_n_max};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ecp_non_local_power_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_nucleus_index_64 (trexio_t* const file, const int64_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_nucleus_index(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_nucleus_index_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_nucleus_shell_num_64 (trexio_t* const file, const int64_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_nucleus_shell_num(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t nucleus_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
if (rc != TREXIO_SUCCESS) return rc;

if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {nucleus_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_nucleus_shell_num_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_shell_ang_mom_64 (trexio_t* const file, const int64_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_ang_mom(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t basis_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_num_64(file, &(basis_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_shell_ang_mom_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_shell_prim_num_64 (trexio_t* const file, const int64_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_prim_num(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t basis_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_num_64(file, &(basis_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_shell_prim_num_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_shell_factor_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_factor(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t basis_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_num_64(file, &(basis_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_shell_factor_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_shell_prim_index_64 (trexio_t* const file, const int64_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_shell_prim_index(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t basis_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_num_64(file, &(basis_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_shell_prim_index_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_exponent_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_exponent(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t basis_prim_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_prim_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_exponent_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_coefficient_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_coefficient(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t basis_prim_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_prim_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_coefficient_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_basis_prim_factor_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_prim_factor(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t basis_prim_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_basis_prim_num_64(file, &(basis_prim_num));
if (rc != TREXIO_SUCCESS) return rc;

if (basis_prim_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {basis_prim_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_basis_prim_factor_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_shell_64 (trexio_t* const file, const int64_t* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_shell(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_shell_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_normalization_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_normalization(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_normalization_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_overlap_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_overlap(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_1e_int_overlap_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_kinetic_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_kinetic(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_1e_int_kinetic_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_potential_n_e_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_potential_n_e(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_1e_int_potential_n_e_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_ecp_local_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_ecp_local(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_1e_int_ecp_local_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_ecp_non_local_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_ecp_non_local(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_1e_int_ecp_non_local_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_core_hamiltonian_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_1e_int_core_hamiltonian(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_1e_int_core_hamiltonian_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_2e_int_eri_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_2e_int_eri(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 4;
uint64_t dims[4] = {ao_num, ao_num, ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_2e_int_eri_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_ao_2e_int_eri_lr_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_2e_int_eri_lr(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 4;
uint64_t dims[4] = {ao_num, ao_num, ao_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_ao_2e_int_eri_lr_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_coefficient_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_coefficient(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;
int64_t ao_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;
rc = trexio_read_ao_num_64(file, &(ao_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;
if (ao_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, ao_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_coefficient_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_occupation_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_occupation(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 1;
uint64_t dims[1] = {mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_occupation_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_overlap_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_overlap(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_1e_int_overlap_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_kinetic_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_kinetic(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_1e_int_kinetic_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_potential_n_e_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_potential_n_e(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_1e_int_potential_n_e_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_ecp_local_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_ecp_local(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_1e_int_ecp_local_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_ecp_non_local_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_ecp_non_local(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_1e_int_ecp_non_local_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_core_hamiltonian_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_1e_int_core_hamiltonian(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 2;
uint64_t dims[2] = {mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_1e_int_core_hamiltonian_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_2e_int_eri_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_2e_int_eri(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 4;
uint64_t dims[4] = {mo_num, mo_num, mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_2e_int_eri_64(file, dset_in);
}

trexio_exit_code
trexio_write_safe_mo_2e_int_eri_lr_64 (trexio_t* const file, const double* dset_in, const int64_t dim_in)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_2e_int_eri_lr(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

trexio_exit_code rc;
int64_t mo_num = 0;

/* Error handling for this call is added by the generator */
rc = trexio_read_mo_num_64(file, &(mo_num));
if (rc != TREXIO_SUCCESS) return rc;

if (mo_num == 0L) return TREXIO_INVALID_NUM;

uint32_t rank = 4;
uint64_t dims[4] = {mo_num, mo_num, mo_num, mo_num};

/* The block below is specific to safe API as it checks the boundaries */
uint64_t dim_size = 1;
for (uint32_t i=0; i<rank; ++i){
    dim_size *= dims[i];
}

  if (dim_in > (int64_t) dim_size) return TREXIO_UNSAFE_ARRAY_DIM;

  return trexio_write_mo_2e_int_eri_lr_64(file, dset_in);
}

trexio_exit_code
trexio_write_nucleus_charge (trexio_t* const file, const double* nucleus_charge)
{
  return trexio_write_nucleus_charge_64(file, nucleus_charge);
}

trexio_exit_code
trexio_write_nucleus_coord (trexio_t* const file, const double* nucleus_coord)
{
  return trexio_write_nucleus_coord_64(file, nucleus_coord);
}

trexio_exit_code
trexio_write_ecp_lmax_plus_1 (trexio_t* const file, const int32_t* ecp_lmax_plus_1)
{
  return trexio_write_ecp_lmax_plus_1_32(file, ecp_lmax_plus_1);
}

trexio_exit_code
trexio_write_ecp_z_core (trexio_t* const file, const double* ecp_z_core)
{
  return trexio_write_ecp_z_core_64(file, ecp_z_core);
}

trexio_exit_code
trexio_write_ecp_local_n (trexio_t* const file, const int32_t* ecp_local_n)
{
  return trexio_write_ecp_local_n_32(file, ecp_local_n);
}

trexio_exit_code
trexio_write_ecp_local_exponent (trexio_t* const file, const double* ecp_local_exponent)
{
  return trexio_write_ecp_local_exponent_64(file, ecp_local_exponent);
}

trexio_exit_code
trexio_write_ecp_local_coef (trexio_t* const file, const double* ecp_local_coef)
{
  return trexio_write_ecp_local_coef_64(file, ecp_local_coef);
}

trexio_exit_code
trexio_write_ecp_local_power (trexio_t* const file, const int32_t* ecp_local_power)
{
  return trexio_write_ecp_local_power_32(file, ecp_local_power);
}

trexio_exit_code
trexio_write_ecp_non_local_n (trexio_t* const file, const int32_t* ecp_non_local_n)
{
  return trexio_write_ecp_non_local_n_32(file, ecp_non_local_n);
}

trexio_exit_code
trexio_write_ecp_non_local_exponent (trexio_t* const file, const double* ecp_non_local_exponent)
{
  return trexio_write_ecp_non_local_exponent_64(file, ecp_non_local_exponent);
}

trexio_exit_code
trexio_write_ecp_non_local_coef (trexio_t* const file, const double* ecp_non_local_coef)
{
  return trexio_write_ecp_non_local_coef_64(file, ecp_non_local_coef);
}

trexio_exit_code
trexio_write_ecp_non_local_power (trexio_t* const file, const int32_t* ecp_non_local_power)
{
  return trexio_write_ecp_non_local_power_32(file, ecp_non_local_power);
}

trexio_exit_code
trexio_write_basis_nucleus_index (trexio_t* const file, const int32_t* basis_nucleus_index)
{
  return trexio_write_basis_nucleus_index_32(file, basis_nucleus_index);
}

trexio_exit_code
trexio_write_basis_nucleus_shell_num (trexio_t* const file, const int32_t* basis_nucleus_shell_num)
{
  return trexio_write_basis_nucleus_shell_num_32(file, basis_nucleus_shell_num);
}

trexio_exit_code
trexio_write_basis_shell_ang_mom (trexio_t* const file, const int32_t* basis_shell_ang_mom)
{
  return trexio_write_basis_shell_ang_mom_32(file, basis_shell_ang_mom);
}

trexio_exit_code
trexio_write_basis_shell_prim_num (trexio_t* const file, const int32_t* basis_shell_prim_num)
{
  return trexio_write_basis_shell_prim_num_32(file, basis_shell_prim_num);
}

trexio_exit_code
trexio_write_basis_shell_factor (trexio_t* const file, const double* basis_shell_factor)
{
  return trexio_write_basis_shell_factor_64(file, basis_shell_factor);
}

trexio_exit_code
trexio_write_basis_shell_prim_index (trexio_t* const file, const int32_t* basis_shell_prim_index)
{
  return trexio_write_basis_shell_prim_index_32(file, basis_shell_prim_index);
}

trexio_exit_code
trexio_write_basis_exponent (trexio_t* const file, const double* basis_exponent)
{
  return trexio_write_basis_exponent_64(file, basis_exponent);
}

trexio_exit_code
trexio_write_basis_coefficient (trexio_t* const file, const double* basis_coefficient)
{
  return trexio_write_basis_coefficient_64(file, basis_coefficient);
}

trexio_exit_code
trexio_write_basis_prim_factor (trexio_t* const file, const double* basis_prim_factor)
{
  return trexio_write_basis_prim_factor_64(file, basis_prim_factor);
}

trexio_exit_code
trexio_write_ao_shell (trexio_t* const file, const int32_t* ao_shell)
{
  return trexio_write_ao_shell_32(file, ao_shell);
}

trexio_exit_code
trexio_write_ao_normalization (trexio_t* const file, const double* ao_normalization)
{
  return trexio_write_ao_normalization_64(file, ao_normalization);
}

trexio_exit_code
trexio_write_ao_1e_int_overlap (trexio_t* const file, const double* ao_1e_int_overlap)
{
  return trexio_write_ao_1e_int_overlap_64(file, ao_1e_int_overlap);
}

trexio_exit_code
trexio_write_ao_1e_int_kinetic (trexio_t* const file, const double* ao_1e_int_kinetic)
{
  return trexio_write_ao_1e_int_kinetic_64(file, ao_1e_int_kinetic);
}

trexio_exit_code
trexio_write_ao_1e_int_potential_n_e (trexio_t* const file, const double* ao_1e_int_potential_n_e)
{
  return trexio_write_ao_1e_int_potential_n_e_64(file, ao_1e_int_potential_n_e);
}

trexio_exit_code
trexio_write_ao_1e_int_ecp_local (trexio_t* const file, const double* ao_1e_int_ecp_local)
{
  return trexio_write_ao_1e_int_ecp_local_64(file, ao_1e_int_ecp_local);
}

trexio_exit_code
trexio_write_ao_1e_int_ecp_non_local (trexio_t* const file, const double* ao_1e_int_ecp_non_local)
{
  return trexio_write_ao_1e_int_ecp_non_local_64(file, ao_1e_int_ecp_non_local);
}

trexio_exit_code
trexio_write_ao_1e_int_core_hamiltonian (trexio_t* const file, const double* ao_1e_int_core_hamiltonian)
{
  return trexio_write_ao_1e_int_core_hamiltonian_64(file, ao_1e_int_core_hamiltonian);
}

trexio_exit_code
trexio_write_ao_2e_int_eri (trexio_t* const file, const double* ao_2e_int_eri)
{
  return trexio_write_ao_2e_int_eri_64(file, ao_2e_int_eri);
}

trexio_exit_code
trexio_write_ao_2e_int_eri_lr (trexio_t* const file, const double* ao_2e_int_eri_lr)
{
  return trexio_write_ao_2e_int_eri_lr_64(file, ao_2e_int_eri_lr);
}

trexio_exit_code
trexio_write_mo_coefficient (trexio_t* const file, const double* mo_coefficient)
{
  return trexio_write_mo_coefficient_64(file, mo_coefficient);
}

trexio_exit_code
trexio_write_mo_occupation (trexio_t* const file, const double* mo_occupation)
{
  return trexio_write_mo_occupation_64(file, mo_occupation);
}

trexio_exit_code
trexio_write_mo_1e_int_overlap (trexio_t* const file, const double* mo_1e_int_overlap)
{
  return trexio_write_mo_1e_int_overlap_64(file, mo_1e_int_overlap);
}

trexio_exit_code
trexio_write_mo_1e_int_kinetic (trexio_t* const file, const double* mo_1e_int_kinetic)
{
  return trexio_write_mo_1e_int_kinetic_64(file, mo_1e_int_kinetic);
}

trexio_exit_code
trexio_write_mo_1e_int_potential_n_e (trexio_t* const file, const double* mo_1e_int_potential_n_e)
{
  return trexio_write_mo_1e_int_potential_n_e_64(file, mo_1e_int_potential_n_e);
}

trexio_exit_code
trexio_write_mo_1e_int_ecp_local (trexio_t* const file, const double* mo_1e_int_ecp_local)
{
  return trexio_write_mo_1e_int_ecp_local_64(file, mo_1e_int_ecp_local);
}

trexio_exit_code
trexio_write_mo_1e_int_ecp_non_local (trexio_t* const file, const double* mo_1e_int_ecp_non_local)
{
  return trexio_write_mo_1e_int_ecp_non_local_64(file, mo_1e_int_ecp_non_local);
}

trexio_exit_code
trexio_write_mo_1e_int_core_hamiltonian (trexio_t* const file, const double* mo_1e_int_core_hamiltonian)
{
  return trexio_write_mo_1e_int_core_hamiltonian_64(file, mo_1e_int_core_hamiltonian);
}

trexio_exit_code
trexio_write_mo_2e_int_eri (trexio_t* const file, const double* mo_2e_int_eri)
{
  return trexio_write_mo_2e_int_eri_64(file, mo_2e_int_eri);
}

trexio_exit_code
trexio_write_mo_2e_int_eri_lr (trexio_t* const file, const double* mo_2e_int_eri_lr)
{
  return trexio_write_mo_2e_int_eri_lr_64(file, mo_2e_int_eri_lr);
}

trexio_exit_code
trexio_write_safe_nucleus_charge (trexio_t* const file, const double* nucleus_charge, const int64_t dim_in)
{
  return trexio_write_safe_nucleus_charge_64(file, nucleus_charge, dim_in);
}

trexio_exit_code
trexio_write_safe_nucleus_coord (trexio_t* const file, const double* nucleus_coord, const int64_t dim_in)
{
  return trexio_write_safe_nucleus_coord_64(file, nucleus_coord, dim_in);
}

trexio_exit_code
trexio_write_safe_ecp_lmax_plus_1 (trexio_t* const file, const int32_t* ecp_lmax_plus_1, const int64_t dim_in)
{
  return trexio_write_safe_ecp_lmax_plus_1_32(file, ecp_lmax_plus_1, dim_in);
}

trexio_exit_code
trexio_write_safe_ecp_z_core (trexio_t* const file, const double* ecp_z_core, const int64_t dim_in)
{
  return trexio_write_safe_ecp_z_core_64(file, ecp_z_core, dim_in);
}

trexio_exit_code
trexio_write_safe_ecp_local_n (trexio_t* const file, const int32_t* ecp_local_n, const int64_t dim_in)
{
  return trexio_write_safe_ecp_local_n_32(file, ecp_local_n, dim_in);
}

trexio_exit_code
trexio_write_safe_ecp_local_exponent (trexio_t* const file, const double* ecp_local_exponent, const int64_t dim_in)
{
  return trexio_write_safe_ecp_local_exponent_64(file, ecp_local_exponent, dim_in);
}

trexio_exit_code
trexio_write_safe_ecp_local_coef (trexio_t* const file, const double* ecp_local_coef, const int64_t dim_in)
{
  return trexio_write_safe_ecp_local_coef_64(file, ecp_local_coef, dim_in);
}

trexio_exit_code
trexio_write_safe_ecp_local_power (trexio_t* const file, const int32_t* ecp_local_power, const int64_t dim_in)
{
  return trexio_write_safe_ecp_local_power_32(file, ecp_local_power, dim_in);
}

trexio_exit_code
trexio_write_safe_ecp_non_local_n (trexio_t* const file, const int32_t* ecp_non_local_n, const int64_t dim_in)
{
  return trexio_write_safe_ecp_non_local_n_32(file, ecp_non_local_n, dim_in);
}

trexio_exit_code
trexio_write_safe_ecp_non_local_exponent (trexio_t* const file, const double* ecp_non_local_exponent, const int64_t dim_in)
{
  return trexio_write_safe_ecp_non_local_exponent_64(file, ecp_non_local_exponent, dim_in);
}

trexio_exit_code
trexio_write_safe_ecp_non_local_coef (trexio_t* const file, const double* ecp_non_local_coef, const int64_t dim_in)
{
  return trexio_write_safe_ecp_non_local_coef_64(file, ecp_non_local_coef, dim_in);
}

trexio_exit_code
trexio_write_safe_ecp_non_local_power (trexio_t* const file, const int32_t* ecp_non_local_power, const int64_t dim_in)
{
  return trexio_write_safe_ecp_non_local_power_32(file, ecp_non_local_power, dim_in);
}

trexio_exit_code
trexio_write_safe_basis_nucleus_index (trexio_t* const file, const int32_t* basis_nucleus_index, const int64_t dim_in)
{
  return trexio_write_safe_basis_nucleus_index_32(file, basis_nucleus_index, dim_in);
}

trexio_exit_code
trexio_write_safe_basis_nucleus_shell_num (trexio_t* const file, const int32_t* basis_nucleus_shell_num, const int64_t dim_in)
{
  return trexio_write_safe_basis_nucleus_shell_num_32(file, basis_nucleus_shell_num, dim_in);
}

trexio_exit_code
trexio_write_safe_basis_shell_ang_mom (trexio_t* const file, const int32_t* basis_shell_ang_mom, const int64_t dim_in)
{
  return trexio_write_safe_basis_shell_ang_mom_32(file, basis_shell_ang_mom, dim_in);
}

trexio_exit_code
trexio_write_safe_basis_shell_prim_num (trexio_t* const file, const int32_t* basis_shell_prim_num, const int64_t dim_in)
{
  return trexio_write_safe_basis_shell_prim_num_32(file, basis_shell_prim_num, dim_in);
}

trexio_exit_code
trexio_write_safe_basis_shell_factor (trexio_t* const file, const double* basis_shell_factor, const int64_t dim_in)
{
  return trexio_write_safe_basis_shell_factor_64(file, basis_shell_factor, dim_in);
}

trexio_exit_code
trexio_write_safe_basis_shell_prim_index (trexio_t* const file, const int32_t* basis_shell_prim_index, const int64_t dim_in)
{
  return trexio_write_safe_basis_shell_prim_index_32(file, basis_shell_prim_index, dim_in);
}

trexio_exit_code
trexio_write_safe_basis_exponent (trexio_t* const file, const double* basis_exponent, const int64_t dim_in)
{
  return trexio_write_safe_basis_exponent_64(file, basis_exponent, dim_in);
}

trexio_exit_code
trexio_write_safe_basis_coefficient (trexio_t* const file, const double* basis_coefficient, const int64_t dim_in)
{
  return trexio_write_safe_basis_coefficient_64(file, basis_coefficient, dim_in);
}

trexio_exit_code
trexio_write_safe_basis_prim_factor (trexio_t* const file, const double* basis_prim_factor, const int64_t dim_in)
{
  return trexio_write_safe_basis_prim_factor_64(file, basis_prim_factor, dim_in);
}

trexio_exit_code
trexio_write_safe_ao_shell (trexio_t* const file, const int32_t* ao_shell, const int64_t dim_in)
{
  return trexio_write_safe_ao_shell_32(file, ao_shell, dim_in);
}

trexio_exit_code
trexio_write_safe_ao_normalization (trexio_t* const file, const double* ao_normalization, const int64_t dim_in)
{
  return trexio_write_safe_ao_normalization_64(file, ao_normalization, dim_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_overlap (trexio_t* const file, const double* ao_1e_int_overlap, const int64_t dim_in)
{
  return trexio_write_safe_ao_1e_int_overlap_64(file, ao_1e_int_overlap, dim_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_kinetic (trexio_t* const file, const double* ao_1e_int_kinetic, const int64_t dim_in)
{
  return trexio_write_safe_ao_1e_int_kinetic_64(file, ao_1e_int_kinetic, dim_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_potential_n_e (trexio_t* const file, const double* ao_1e_int_potential_n_e, const int64_t dim_in)
{
  return trexio_write_safe_ao_1e_int_potential_n_e_64(file, ao_1e_int_potential_n_e, dim_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_ecp_local (trexio_t* const file, const double* ao_1e_int_ecp_local, const int64_t dim_in)
{
  return trexio_write_safe_ao_1e_int_ecp_local_64(file, ao_1e_int_ecp_local, dim_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_ecp_non_local (trexio_t* const file, const double* ao_1e_int_ecp_non_local, const int64_t dim_in)
{
  return trexio_write_safe_ao_1e_int_ecp_non_local_64(file, ao_1e_int_ecp_non_local, dim_in);
}

trexio_exit_code
trexio_write_safe_ao_1e_int_core_hamiltonian (trexio_t* const file, const double* ao_1e_int_core_hamiltonian, const int64_t dim_in)
{
  return trexio_write_safe_ao_1e_int_core_hamiltonian_64(file, ao_1e_int_core_hamiltonian, dim_in);
}

trexio_exit_code
trexio_write_safe_ao_2e_int_eri (trexio_t* const file, const double* ao_2e_int_eri, const int64_t dim_in)
{
  return trexio_write_safe_ao_2e_int_eri_64(file, ao_2e_int_eri, dim_in);
}

trexio_exit_code
trexio_write_safe_ao_2e_int_eri_lr (trexio_t* const file, const double* ao_2e_int_eri_lr, const int64_t dim_in)
{
  return trexio_write_safe_ao_2e_int_eri_lr_64(file, ao_2e_int_eri_lr, dim_in);
}

trexio_exit_code
trexio_write_safe_mo_coefficient (trexio_t* const file, const double* mo_coefficient, const int64_t dim_in)
{
  return trexio_write_safe_mo_coefficient_64(file, mo_coefficient, dim_in);
}

trexio_exit_code
trexio_write_safe_mo_occupation (trexio_t* const file, const double* mo_occupation, const int64_t dim_in)
{
  return trexio_write_safe_mo_occupation_64(file, mo_occupation, dim_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_overlap (trexio_t* const file, const double* mo_1e_int_overlap, const int64_t dim_in)
{
  return trexio_write_safe_mo_1e_int_overlap_64(file, mo_1e_int_overlap, dim_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_kinetic (trexio_t* const file, const double* mo_1e_int_kinetic, const int64_t dim_in)
{
  return trexio_write_safe_mo_1e_int_kinetic_64(file, mo_1e_int_kinetic, dim_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_potential_n_e (trexio_t* const file, const double* mo_1e_int_potential_n_e, const int64_t dim_in)
{
  return trexio_write_safe_mo_1e_int_potential_n_e_64(file, mo_1e_int_potential_n_e, dim_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_ecp_local (trexio_t* const file, const double* mo_1e_int_ecp_local, const int64_t dim_in)
{
  return trexio_write_safe_mo_1e_int_ecp_local_64(file, mo_1e_int_ecp_local, dim_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_ecp_non_local (trexio_t* const file, const double* mo_1e_int_ecp_non_local, const int64_t dim_in)
{
  return trexio_write_safe_mo_1e_int_ecp_non_local_64(file, mo_1e_int_ecp_non_local, dim_in);
}

trexio_exit_code
trexio_write_safe_mo_1e_int_core_hamiltonian (trexio_t* const file, const double* mo_1e_int_core_hamiltonian, const int64_t dim_in)
{
  return trexio_write_safe_mo_1e_int_core_hamiltonian_64(file, mo_1e_int_core_hamiltonian, dim_in);
}

trexio_exit_code
trexio_write_safe_mo_2e_int_eri (trexio_t* const file, const double* mo_2e_int_eri, const int64_t dim_in)
{
  return trexio_write_safe_mo_2e_int_eri_64(file, mo_2e_int_eri, dim_in);
}

trexio_exit_code
trexio_write_safe_mo_2e_int_eri_lr (trexio_t* const file, const double* mo_2e_int_eri_lr, const int64_t dim_in)
{
  return trexio_write_safe_mo_2e_int_eri_lr_64(file, mo_2e_int_eri_lr, dim_in);
}

trexio_exit_code
trexio_write_metadata_code_low (trexio_t* const file, const char* dset_in, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_metadata_code(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t metadata_code_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_metadata_code_num_64(file, &(metadata_code_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (metadata_code_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {metadata_code_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  char*  tmp_str  = CALLOC(dims[0]*(max_str_len+1), char);
  if (tmp_str == NULL) return TREXIO_ALLOCATION_FAILED;
  char** dset_str = CALLOC(dims[0], char*);
  if (dset_str == NULL) {
    FREE(tmp_str);
    return TREXIO_ALLOCATION_FAILED;
  }

  /* parse the string using strtok */
  for(uint64_t i=0; i<dims[0]; i++) {

    char* pch;
    pch = i == 0 ? strtok( (char*) dset_in, TREXIO_DELIM) : strtok(NULL, TREXIO_DELIM) ;

    if (pch == NULL) {
      FREE(dset_str[0]);
      FREE(dset_str);
      return TREXIO_FAILURE;
    }

    size_t pch_len = strlen(pch) + 1;

    if (pch_len > (size_t) max_str_len) {
      FREE(dset_str[0]);
      FREE(dset_str);
      return TREXIO_INVALID_STR_LEN;
    }

    dset_str[i] = tmp_str;
    strncpy(tmp_str, pch, pch_len);
    tmp_str += pch_len + 1;
  }

  rc = TREXIO_FAILURE;  
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_metadata_code(file, (const char**) dset_str, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_metadata_code(file, (const char**) dset_str, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_metadata_code(file, dset, rank, dims);
    break;
*/
  }

  FREE(dset_str[0]);
  FREE(dset_str);
    
  return rc;

}

trexio_exit_code
trexio_write_metadata_code (trexio_t* const file, const char** dset_in, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_metadata_code(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  trexio_exit_code rc;
  int64_t dset_dim = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_metadata_code_num_64(file, &(dset_dim));
  if (rc != TREXIO_SUCCESS) return rc;

  if (dset_dim == 0L) return TREXIO_INVALID_NUM;

  char* str_compiled = CALLOC(dset_dim*max_str_len + 1, char);
  if (str_compiled == NULL) return TREXIO_ALLOCATION_FAILED;

  strcpy(str_compiled, "");
  for (uint64_t i=0; i < (uint64_t) dset_dim; i++) {
    strcat(str_compiled, dset_in[i]);
    strcat(str_compiled, TREXIO_DELIM);
  }

  rc = trexio_write_metadata_code_low(file, str_compiled, max_str_len);

  FREE(str_compiled);

  return rc;
}

trexio_exit_code
trexio_write_metadata_author_low (trexio_t* const file, const char* dset_in, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_metadata_author(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t metadata_author_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_metadata_author_num_64(file, &(metadata_author_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (metadata_author_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {metadata_author_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  char*  tmp_str  = CALLOC(dims[0]*(max_str_len+1), char);
  if (tmp_str == NULL) return TREXIO_ALLOCATION_FAILED;
  char** dset_str = CALLOC(dims[0], char*);
  if (dset_str == NULL) {
    FREE(tmp_str);
    return TREXIO_ALLOCATION_FAILED;
  }

  /* parse the string using strtok */
  for(uint64_t i=0; i<dims[0]; i++) {

    char* pch;
    pch = i == 0 ? strtok( (char*) dset_in, TREXIO_DELIM) : strtok(NULL, TREXIO_DELIM) ;

    if (pch == NULL) {
      FREE(dset_str[0]);
      FREE(dset_str);
      return TREXIO_FAILURE;
    }

    size_t pch_len = strlen(pch) + 1;

    if (pch_len > (size_t) max_str_len) {
      FREE(dset_str[0]);
      FREE(dset_str);
      return TREXIO_INVALID_STR_LEN;
    }

    dset_str[i] = tmp_str;
    strncpy(tmp_str, pch, pch_len);
    tmp_str += pch_len + 1;
  }

  rc = TREXIO_FAILURE;  
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_metadata_author(file, (const char**) dset_str, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_metadata_author(file, (const char**) dset_str, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_metadata_author(file, dset, rank, dims);
    break;
*/
  }

  FREE(dset_str[0]);
  FREE(dset_str);
    
  return rc;

}

trexio_exit_code
trexio_write_metadata_author (trexio_t* const file, const char** dset_in, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_metadata_author(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  trexio_exit_code rc;
  int64_t dset_dim = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_metadata_author_num_64(file, &(dset_dim));
  if (rc != TREXIO_SUCCESS) return rc;

  if (dset_dim == 0L) return TREXIO_INVALID_NUM;

  char* str_compiled = CALLOC(dset_dim*max_str_len + 1, char);
  if (str_compiled == NULL) return TREXIO_ALLOCATION_FAILED;

  strcpy(str_compiled, "");
  for (uint64_t i=0; i < (uint64_t) dset_dim; i++) {
    strcat(str_compiled, dset_in[i]);
    strcat(str_compiled, TREXIO_DELIM);
  }

  rc = trexio_write_metadata_author_low(file, str_compiled, max_str_len);

  FREE(str_compiled);

  return rc;
}

trexio_exit_code
trexio_write_nucleus_label_low (trexio_t* const file, const char* dset_in, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_nucleus_label(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t nucleus_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(nucleus_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (nucleus_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {nucleus_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  char*  tmp_str  = CALLOC(dims[0]*(max_str_len+1), char);
  if (tmp_str == NULL) return TREXIO_ALLOCATION_FAILED;
  char** dset_str = CALLOC(dims[0], char*);
  if (dset_str == NULL) {
    FREE(tmp_str);
    return TREXIO_ALLOCATION_FAILED;
  }

  /* parse the string using strtok */
  for(uint64_t i=0; i<dims[0]; i++) {

    char* pch;
    pch = i == 0 ? strtok( (char*) dset_in, TREXIO_DELIM) : strtok(NULL, TREXIO_DELIM) ;

    if (pch == NULL) {
      FREE(dset_str[0]);
      FREE(dset_str);
      return TREXIO_FAILURE;
    }

    size_t pch_len = strlen(pch) + 1;

    if (pch_len > (size_t) max_str_len) {
      FREE(dset_str[0]);
      FREE(dset_str);
      return TREXIO_INVALID_STR_LEN;
    }

    dset_str[i] = tmp_str;
    strncpy(tmp_str, pch, pch_len);
    tmp_str += pch_len + 1;
  }

  rc = TREXIO_FAILURE;  
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_nucleus_label(file, (const char**) dset_str, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_nucleus_label(file, (const char**) dset_str, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_nucleus_label(file, dset, rank, dims);
    break;
*/
  }

  FREE(dset_str[0]);
  FREE(dset_str);
    
  return rc;

}

trexio_exit_code
trexio_write_nucleus_label (trexio_t* const file, const char** dset_in, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_nucleus_label(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  trexio_exit_code rc;
  int64_t dset_dim = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_nucleus_num_64(file, &(dset_dim));
  if (rc != TREXIO_SUCCESS) return rc;

  if (dset_dim == 0L) return TREXIO_INVALID_NUM;

  char* str_compiled = CALLOC(dset_dim*max_str_len + 1, char);
  if (str_compiled == NULL) return TREXIO_ALLOCATION_FAILED;

  strcpy(str_compiled, "");
  for (uint64_t i=0; i < (uint64_t) dset_dim; i++) {
    strcat(str_compiled, dset_in[i]);
    strcat(str_compiled, TREXIO_DELIM);
  }

  rc = trexio_write_nucleus_label_low(file, str_compiled, max_str_len);

  FREE(str_compiled);

  return rc;
}

trexio_exit_code
trexio_write_mo_class_low (trexio_t* const file, const char* dset_in, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_mo_class(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {mo_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  char*  tmp_str  = CALLOC(dims[0]*(max_str_len+1), char);
  if (tmp_str == NULL) return TREXIO_ALLOCATION_FAILED;
  char** dset_str = CALLOC(dims[0], char*);
  if (dset_str == NULL) {
    FREE(tmp_str);
    return TREXIO_ALLOCATION_FAILED;
  }

  /* parse the string using strtok */
  for(uint64_t i=0; i<dims[0]; i++) {

    char* pch;
    pch = i == 0 ? strtok( (char*) dset_in, TREXIO_DELIM) : strtok(NULL, TREXIO_DELIM) ;

    if (pch == NULL) {
      FREE(dset_str[0]);
      FREE(dset_str);
      return TREXIO_FAILURE;
    }

    size_t pch_len = strlen(pch) + 1;

    if (pch_len > (size_t) max_str_len) {
      FREE(dset_str[0]);
      FREE(dset_str);
      return TREXIO_INVALID_STR_LEN;
    }

    dset_str[i] = tmp_str;
    strncpy(tmp_str, pch, pch_len);
    tmp_str += pch_len + 1;
  }

  rc = TREXIO_FAILURE;  
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_class(file, (const char**) dset_str, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_class(file, (const char**) dset_str, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_class(file, dset, rank, dims);
    break;
*/
  }

  FREE(dset_str[0]);
  FREE(dset_str);
    
  return rc;

}

trexio_exit_code
trexio_write_mo_class (trexio_t* const file, const char** dset_in, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_mo_class(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  trexio_exit_code rc;
  int64_t dset_dim = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(dset_dim));
  if (rc != TREXIO_SUCCESS) return rc;

  if (dset_dim == 0L) return TREXIO_INVALID_NUM;

  char* str_compiled = CALLOC(dset_dim*max_str_len + 1, char);
  if (str_compiled == NULL) return TREXIO_ALLOCATION_FAILED;

  strcpy(str_compiled, "");
  for (uint64_t i=0; i < (uint64_t) dset_dim; i++) {
    strcat(str_compiled, dset_in[i]);
    strcat(str_compiled, TREXIO_DELIM);
  }

  rc = trexio_write_mo_class_low(file, str_compiled, max_str_len);

  FREE(str_compiled);

  return rc;
}

trexio_exit_code
trexio_write_mo_symmetry_low (trexio_t* const file, const char* dset_in, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_mo_symmetry(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  trexio_exit_code rc;
  int64_t mo_num = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(mo_num));
  if (rc != TREXIO_SUCCESS) return rc;

  if (mo_num == 0L) return TREXIO_INVALID_NUM;

  uint32_t rank = 1;
  uint64_t dims[1] = {mo_num};

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  char*  tmp_str  = CALLOC(dims[0]*(max_str_len+1), char);
  if (tmp_str == NULL) return TREXIO_ALLOCATION_FAILED;
  char** dset_str = CALLOC(dims[0], char*);
  if (dset_str == NULL) {
    FREE(tmp_str);
    return TREXIO_ALLOCATION_FAILED;
  }

  /* parse the string using strtok */
  for(uint64_t i=0; i<dims[0]; i++) {

    char* pch;
    pch = i == 0 ? strtok( (char*) dset_in, TREXIO_DELIM) : strtok(NULL, TREXIO_DELIM) ;

    if (pch == NULL) {
      FREE(dset_str[0]);
      FREE(dset_str);
      return TREXIO_FAILURE;
    }

    size_t pch_len = strlen(pch) + 1;

    if (pch_len > (size_t) max_str_len) {
      FREE(dset_str[0]);
      FREE(dset_str);
      return TREXIO_INVALID_STR_LEN;
    }

    dset_str[i] = tmp_str;
    strncpy(tmp_str, pch, pch_len);
    tmp_str += pch_len + 1;
  }

  rc = TREXIO_FAILURE;  
  switch (file->back_end) {

  case TREXIO_TEXT:
    rc = trexio_text_write_mo_symmetry(file, (const char**) dset_str, rank, dims);
    break;

  case TREXIO_HDF5:
    rc = trexio_hdf5_write_mo_symmetry(file, (const char**) dset_str, rank, dims);
    break;
/*
  case TREXIO_JSON:
    rc = trexio_json_write_mo_symmetry(file, dset, rank, dims);
    break;
*/
  }

  FREE(dset_str[0]);
  FREE(dset_str);
    
  return rc;

}

trexio_exit_code
trexio_write_mo_symmetry (trexio_t* const file, const char** dset_in, const int32_t max_str_len)
{

  if (file  == NULL) return TREXIO_INVALID_ARG_1;
  if (dset_in == NULL) return TREXIO_INVALID_ARG_2;
  if (max_str_len <= 0) return TREXIO_INVALID_ARG_3;
  if (trexio_has_mo_symmetry(file) == TREXIO_SUCCESS) return TREXIO_DSET_ALREADY_EXISTS;

  assert(file->back_end < TREXIO_INVALID_BACK_END);

  trexio_exit_code rc;
  int64_t dset_dim = 0;

  /* Error handling for this call is added by the generator */
  rc = trexio_read_mo_num_64(file, &(dset_dim));
  if (rc != TREXIO_SUCCESS) return rc;

  if (dset_dim == 0L) return TREXIO_INVALID_NUM;

  char* str_compiled = CALLOC(dset_dim*max_str_len + 1, char);
  if (str_compiled == NULL) return TREXIO_ALLOCATION_FAILED;

  strcpy(str_compiled, "");
  for (uint64_t i=0; i < (uint64_t) dset_dim; i++) {
    strcat(str_compiled, dset_in[i]);
    strcat(str_compiled, TREXIO_DELIM);
  }

  rc = trexio_write_mo_symmetry_low(file, str_compiled, max_str_len);

  FREE(str_compiled);

  return rc;
}

trexio_exit_code
trexio_write_metadata_code_num_32 (trexio_t* const file, const int32_t num)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_metadata_code_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_metadata_code_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_metadata_code_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_metadata_code_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_metadata_author_num_32 (trexio_t* const file, const int32_t num)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_metadata_author_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_metadata_author_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_metadata_author_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_metadata_author_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_electron_up_num_32 (trexio_t* const file, const int32_t num)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_electron_up_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_electron_up_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_electron_up_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_electron_up_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_electron_dn_num_32 (trexio_t* const file, const int32_t num)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_electron_dn_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_electron_dn_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_electron_dn_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_electron_dn_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_nucleus_num_32 (trexio_t* const file, const int32_t num)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_nucleus_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_nucleus_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_nucleus_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_ecp_local_num_n_max_32 (trexio_t* const file, const int32_t num)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_num_n_max(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_ecp_local_num_n_max(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_ecp_local_num_n_max(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_ecp_local_num_n_max(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_ecp_non_local_num_n_max_32 (trexio_t* const file, const int32_t num)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_num_n_max(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_ecp_non_local_num_n_max(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_ecp_non_local_num_n_max(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_ecp_non_local_num_n_max(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_basis_num_32 (trexio_t* const file, const int32_t num)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_basis_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_basis_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_basis_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_basis_prim_num_32 (trexio_t* const file, const int32_t num)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_prim_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_basis_prim_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_basis_prim_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_basis_prim_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_ao_cartesian_32 (trexio_t* const file, const int32_t num)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_cartesian(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_ao_cartesian(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_ao_cartesian(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_ao_cartesian(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_ao_num_32 (trexio_t* const file, const int32_t num)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_ao_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_ao_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_ao_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_mo_num_32 (trexio_t* const file, const int32_t num)
{

  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_mo_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_mo_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_mo_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_metadata_code_num_64 (trexio_t* const file, const int64_t num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_metadata_code_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_metadata_code_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_metadata_code_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_metadata_code_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_metadata_author_num_64 (trexio_t* const file, const int64_t num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_metadata_author_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_metadata_author_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_metadata_author_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_metadata_author_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_electron_up_num_64 (trexio_t* const file, const int64_t num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_electron_up_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_electron_up_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_electron_up_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_electron_up_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_electron_dn_num_64 (trexio_t* const file, const int64_t num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_electron_dn_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_electron_dn_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_electron_dn_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_electron_dn_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_nucleus_num_64 (trexio_t* const file, const int64_t num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_nucleus_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_nucleus_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_nucleus_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_nucleus_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_ecp_local_num_n_max_64 (trexio_t* const file, const int64_t num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_local_num_n_max(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_ecp_local_num_n_max(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_ecp_local_num_n_max(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_ecp_local_num_n_max(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_ecp_non_local_num_n_max_64 (trexio_t* const file, const int64_t num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ecp_non_local_num_n_max(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_ecp_non_local_num_n_max(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_ecp_non_local_num_n_max(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_ecp_non_local_num_n_max(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_basis_num_64 (trexio_t* const file, const int64_t num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_basis_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_basis_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_basis_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_basis_prim_num_64 (trexio_t* const file, const int64_t num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_basis_prim_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_basis_prim_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_basis_prim_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_basis_prim_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_ao_cartesian_64 (trexio_t* const file, const int64_t num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_cartesian(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_ao_cartesian(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_ao_cartesian(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_ao_cartesian(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_ao_num_64 (trexio_t* const file, const int64_t num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_ao_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_ao_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_ao_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_ao_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_mo_num_64 (trexio_t* const file, const int64_t num)
{
  if (file == NULL) return TREXIO_INVALID_ARG_1;
  if (num  <  0   ) return TREXIO_INVALID_ARG_2;
  if (trexio_has_mo_num(file) == TREXIO_SUCCESS) return TREXIO_ATTR_ALREADY_EXISTS;

  switch (file->back_end) {

  case TREXIO_TEXT:
    return trexio_text_write_mo_num(file, (int64_t) num);
    break;

  case TREXIO_HDF5:
    return trexio_hdf5_write_mo_num(file, (int64_t) num);
    break;
/*
  case TREXIO_JSON:
    return trexio_json_write_mo_num(file, (int64_t) num);
    break;
*/
  }

  return TREXIO_FAILURE;
}

trexio_exit_code
trexio_write_metadata_code_num (trexio_t* const file, const int32_t num)
{
  return trexio_write_metadata_code_num_32(file, num);
}

trexio_exit_code
trexio_write_metadata_author_num (trexio_t* const file, const int32_t num)
{
  return trexio_write_metadata_author_num_32(file, num);
}

trexio_exit_code
trexio_write_electron_up_num (trexio_t* const file, const int32_t num)
{
  return trexio_write_electron_up_num_32(file, num);
}

trexio_exit_code
trexio_write_electron_dn_num (trexio_t* const file, const int32_t num)
{
  return trexio_write_electron_dn_num_32(file, num);
}

trexio_exit_code
trexio_write_nucleus_num (trexio_t* const file, const int32_t num)
{
  return trexio_write_nucleus_num_32(file, num);
}

trexio_exit_code
trexio_write_ecp_local_num_n_max (trexio_t* const file, const int32_t num)
{
  return trexio_write_ecp_local_num_n_max_32(file, num);
}

trexio_exit_code
trexio_write_ecp_non_local_num_n_max (trexio_t* const file, const int32_t num)
{
  return trexio_write_ecp_non_local_num_n_max_32(file, num);
}

trexio_exit_code
trexio_write_basis_num (trexio_t* const file, const int32_t num)
{
  return trexio_write_basis_num_32(file, num);
}

trexio_exit_code
trexio_write_basis_prim_num (trexio_t* const file, const int32_t num)
{
  return trexio_write_basis_prim_num_32(file, num);
}

trexio_exit_code
trexio_write_ao_cartesian (trexio_t* const file, const int32_t num)
{
  return trexio_write_ao_cartesian_32(file, num);
}

trexio_exit_code
trexio_write_ao_num (trexio_t* const file, const int32_t num)
{
  return trexio_write_ao_num_32(file, num);
}

trexio_exit_code
trexio_write_mo_num (trexio_t* const file, const int32_t num)
{
  return trexio_write_mo_num_32(file, num);
}

