#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 8520
#define LARGE_STATE_COUNT 3706
#define SYMBOL_COUNT 566
#define ALIAS_COUNT 16
#define TOKEN_COUNT 232
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 21
#define MAX_ALIAS_SEQUENCE_LENGTH 13
#define PRODUCTION_ID_COUNT 77

enum {
  sym__unquoted_identifier = 1,
  aux_sym_keyword_select_token1 = 2,
  aux_sym_keyword_replace_token1 = 3,
  aux_sym_keyword_into_token1 = 4,
  aux_sym_keyword_values_token1 = 5,
  aux_sym_keyword_set_token1 = 6,
  aux_sym_keyword_from_token1 = 7,
  aux_sym_keyword_left_token1 = 8,
  aux_sym_keyword_format_token1 = 9,
  aux_sym_keyword_extract_token1 = 10,
  aux_sym_keyword_right_token1 = 11,
  aux_sym_keyword_inner_token1 = 12,
  aux_sym_keyword_outer_token1 = 13,
  aux_sym_keyword_cross_token1 = 14,
  aux_sym_keyword_unnest_token1 = 15,
  aux_sym_keyword_join_token1 = 16,
  aux_sym_keyword_on_token1 = 17,
  aux_sym_keyword_recursive_token1 = 18,
  aux_sym_keyword_call_token1 = 19,
  aux_sym_keyword_where_token1 = 20,
  aux_sym_keyword_order_token1 = 21,
  aux_sym_keyword_group_token1 = 22,
  aux_sym_keyword_partition_token1 = 23,
  aux_sym_keyword_by_token1 = 24,
  aux_sym_keyword_having_token1 = 25,
  aux_sym_keyword_escape_token1 = 26,
  aux_sym_keyword_desc_token1 = 27,
  aux_sym_keyword_asc_token1 = 28,
  aux_sym_keyword_limit_token1 = 29,
  aux_sym_keyword_offset_token1 = 30,
  aux_sym_keyword_table_token1 = 31,
  aux_sym_keyword_view_token1 = 32,
  aux_sym_keyword_materialized_token1 = 33,
  aux_sym_keyword_as_token1 = 34,
  aux_sym_keyword_distinct_token1 = 35,
  aux_sym_keyword_cast_token1 = 36,
  aux_sym_keyword_safe_cast_token1 = 37,
  aux_sym_keyword_max_token1 = 38,
  aux_sym_keyword_min_token1 = 39,
  aux_sym_keyword_case_token1 = 40,
  aux_sym_keyword_when_token1 = 41,
  aux_sym_keyword_then_token1 = 42,
  aux_sym_keyword_else_token1 = 43,
  aux_sym_keyword_end_token1 = 44,
  aux_sym_keyword_substring_token1 = 45,
  aux_sym_keyword_in_token1 = 46,
  aux_sym_keyword_and_token1 = 47,
  aux_sym_keyword_or_token1 = 48,
  aux_sym_keyword_is_token1 = 49,
  aux_sym_keyword_not_token1 = 50,
  aux_sym_keyword_asymmetric_token1 = 51,
  aux_sym_keyword_symmetric_token1 = 52,
  aux_sym_keyword_using_token1 = 53,
  aux_sym_keyword_for_token1 = 54,
  aux_sym_keyword_bytes_token1 = 55,
  aux_sym_keyword_if_token1 = 56,
  aux_sym_keyword_exists_token1 = 57,
  aux_sym_keyword_at_token1 = 58,
  aux_sym_keyword_zone_token1 = 59,
  aux_sym_keyword_default_token1 = 60,
  aux_sym_keyword_with_token1 = 61,
  aux_sym_keyword_no_token1 = 62,
  aux_sym_keyword_to_token1 = 63,
  aux_sym_keyword_schema_token1 = 64,
  aux_sym_keyword_union_token1 = 65,
  aux_sym_keyword_all_token1 = 66,
  aux_sym_keyword_except_token1 = 67,
  aux_sym_keyword_intersect_token1 = 68,
  aux_sym_keyword_begin_token1 = 69,
  aux_sym_keyword_commit_token1 = 70,
  aux_sym_keyword_rollback_token1 = 71,
  aux_sym_keyword_transaction_token1 = 72,
  aux_sym_keyword_over_token1 = 73,
  aux_sym_keyword_nulls_token1 = 74,
  aux_sym_keyword_first_token1 = 75,
  aux_sym_keyword_last_token1 = 76,
  aux_sym_keyword_window_token1 = 77,
  aux_sym_keyword_system_time_token1 = 78,
  aux_sym_keyword_of_token1 = 79,
  aux_sym_keyword_range_token1 = 80,
  aux_sym_keyword_rows_token1 = 81,
  aux_sym_keyword_between_token1 = 82,
  aux_sym_keyword_unbounded_token1 = 83,
  aux_sym_keyword_preceding_token1 = 84,
  aux_sym_keyword_following_token1 = 85,
  aux_sym_keyword_exclude_token1 = 86,
  aux_sym_keyword_current_token1 = 87,
  aux_sym_keyword_row_token1 = 88,
  aux_sym_keyword_ties_token1 = 89,
  aux_sym_keyword_others_token1 = 90,
  aux_sym_keyword_like_token1 = 91,
  aux_sym_keyword_like_token2 = 92,
  aux_sym_keyword_similar_token1 = 93,
  aux_sym_keyword_within_token1 = 94,
  aux_sym_keyword_filter_token1 = 95,
  aux_sym_keyword_respect_token1 = 96,
  aux_sym_keyword_trim_token1 = 97,
  aux_sym_keyword_leading_token1 = 98,
  aux_sym_keyword_trailing_token1 = 99,
  aux_sym_keyword_both_token1 = 100,
  aux_sym_keyword_ignore_token1 = 101,
  aux_sym_keyword_privileges_token1 = 102,
  aux_sym_keyword_external_token1 = 103,
  aux_sym_keyword_declare_token1 = 104,
  aux_sym_keyword_execute_token1 = 105,
  aux_sym_keyword_immediate_token1 = 106,
  aux_sym_keyword_exception_token1 = 107,
  aux_sym_keyword_error_token1 = 108,
  aux_sym_keyword_elseif_token1 = 109,
  aux_sym_keyword_loop_token1 = 110,
  aux_sym_keyword_until_token1 = 111,
  aux_sym_keyword_repeat_token1 = 112,
  aux_sym_keyword_while_token1 = 113,
  aux_sym_keyword_do_token1 = 114,
  aux_sym_keyword_break_token1 = 115,
  aux_sym_keyword_leave_token1 = 116,
  aux_sym_keyword_continue_token1 = 117,
  aux_sym_keyword_iterate_token1 = 118,
  aux_sym_keyword_message_token1 = 119,
  aux_sym_keyword_raise_token1 = 120,
  aux_sym_keyword_assert_token1 = 121,
  aux_sym_keyword_struct_token1 = 122,
  aux_sym_keyword_value_token1 = 123,
  aux_sym_keyword_array_token1 = 124,
  aux_sym_keyword_any_token1 = 125,
  aux_sym_keyword_some_token1 = 126,
  aux_sym_keyword_current_date_token1 = 127,
  aux_sym_keyword_current_time_token1 = 128,
  aux_sym_keyword_current_timestamp_token1 = 129,
  aux_sym_keyword_system_token1 = 130,
  aux_sym_keyword_tablesample_token1 = 131,
  aux_sym_keyword_percent_token1 = 132,
  aux_sym_keyword_pivot_token1 = 133,
  aux_sym_keyword_qualify_token1 = 134,
  aux_sym_keyword_include_token1 = 135,
  aux_sym_keyword_unpivot_token1 = 136,
  aux_sym_keyword_full_token1 = 137,
  aux_sym_keyword_null_token1 = 138,
  aux_sym_keyword_true_token1 = 139,
  aux_sym_keyword_false_token1 = 140,
  aux_sym_keyword_boolean_token1 = 141,
  aux_sym_keyword_boolean_token2 = 142,
  aux_sym_keyword_smallserial_token1 = 143,
  aux_sym_keyword_smallserial_token2 = 144,
  aux_sym_keyword_serial_token1 = 145,
  aux_sym_keyword_serial_token2 = 146,
  aux_sym_keyword_bigserial_token1 = 147,
  aux_sym_keyword_bigserial_token2 = 148,
  aux_sym_keyword_int_token1 = 149,
  aux_sym_keyword_int_token2 = 150,
  aux_sym_keyword_int_token3 = 151,
  aux_sym_keyword_int_token4 = 152,
  aux_sym_keyword_int_token5 = 153,
  aux_sym_keyword_int_token6 = 154,
  aux_sym_keyword_int_token7 = 155,
  aux_sym_keyword_decimal_token1 = 156,
  aux_sym_keyword_bigdecimal_token1 = 157,
  aux_sym_keyword_numeric_token1 = 158,
  aux_sym_keyword_bignumeric_token1 = 159,
  aux_sym_keyword_real_token1 = 160,
  aux_sym_keyword_real_token2 = 161,
  aux_sym_keyword_float_token1 = 162,
  aux_sym_keyword_float_token2 = 163,
  aux_sym_keyword_money_token1 = 164,
  aux_sym_keyword_string_token1 = 165,
  aux_sym_keyword_char_token1 = 166,
  aux_sym_keyword_char_token2 = 167,
  aux_sym_keyword_varchar_token1 = 168,
  aux_sym_keyword_varchar_token2 = 169,
  aux_sym_keyword_text_token1 = 170,
  aux_sym_keyword_uuid_token1 = 171,
  aux_sym_keyword_json_token1 = 172,
  aux_sym_keyword_jsonb_token1 = 173,
  aux_sym_keyword_xml_token1 = 174,
  aux_sym_keyword_bytea_token1 = 175,
  aux_sym_keyword_interval_token1 = 176,
  aux_sym_keyword_time_token1 = 177,
  aux_sym_keyword_date_token1 = 178,
  aux_sym_keyword_datetime_token1 = 179,
  aux_sym_keyword_timestamp_token1 = 180,
  aux_sym_keyword_timestamp_token2 = 181,
  aux_sym_keyword_timestamptz_token1 = 182,
  aux_sym_keyword_geometry_token1 = 183,
  aux_sym_keyword_geography_token1 = 184,
  aux_sym_keyword_box2d_token1 = 185,
  aux_sym_keyword_box3d_token1 = 186,
  anon_sym_STAR = 187,
  anon_sym_SQUOTE = 188,
  anon_sym_DQUOTE = 189,
  sym_comment = 190,
  sym_comma = 191,
  anon_sym_SEMI = 192,
  anon_sym_EQ_GT = 193,
  sym_left_paren = 194,
  sym_right_paren = 195,
  anon_sym_QMARK = 196,
  anon_sym_DOLLAR = 197,
  aux_sym_parameter_token1 = 198,
  anon_sym_DOT = 199,
  anon_sym_COLON_COLON = 200,
  anon_sym_EQ = 201,
  anon_sym_LT = 202,
  anon_sym_GT = 203,
  anon_sym_LT_EQ = 204,
  anon_sym_GT_EQ = 205,
  anon_sym_TILDE = 206,
  anon_sym_PLUS = 207,
  anon_sym_DASH = 208,
  anon_sym_SLASH = 209,
  anon_sym_LT_GT = 210,
  anon_sym_BANG_EQ = 211,
  anon_sym_LT_LT = 212,
  anon_sym_GT_GT = 213,
  anon_sym_AMP = 214,
  anon_sym_CARET = 215,
  anon_sym_PIPE = 216,
  anon_sym_PIPE_PIPE = 217,
  anon_sym_LBRACK = 218,
  anon_sym_RBRACK = 219,
  sym_system_variable = 220,
  sym__named_query_parameter = 221,
  sym__positional_query_parameter = 222,
  sym_hex = 223,
  sym__integer = 224,
  aux_sym__float_token1 = 225,
  aux_sym__float_token2 = 226,
  aux_sym__float_token3 = 227,
  sym__quoted_identifier = 228,
  sym__string_start = 229,
  sym__string_content = 230,
  sym__string_end = 231,
  sym_program = 232,
  sym_keyword_select = 233,
  sym_keyword_replace = 234,
  sym_keyword_into = 235,
  sym_keyword_set = 236,
  sym_keyword_from = 237,
  sym_keyword_left = 238,
  sym_keyword_format = 239,
  sym_keyword_extract = 240,
  sym_keyword_right = 241,
  sym_keyword_inner = 242,
  sym_keyword_outer = 243,
  sym_keyword_cross = 244,
  sym_keyword_unnest = 245,
  sym_keyword_join = 246,
  sym_keyword_on = 247,
  sym_keyword_recursive = 248,
  sym_keyword_call = 249,
  sym_keyword_where = 250,
  sym_keyword_order = 251,
  sym_keyword_group = 252,
  sym_keyword_partition = 253,
  sym_keyword_by = 254,
  sym_keyword_having = 255,
  sym_keyword_escape = 256,
  sym_keyword_desc = 257,
  sym_keyword_asc = 258,
  sym_keyword_limit = 259,
  sym_keyword_offset = 260,
  sym_keyword_materialized = 261,
  sym_keyword_as = 262,
  sym_keyword_distinct = 263,
  sym_keyword_cast = 264,
  sym_keyword_safe_cast = 265,
  sym_keyword_max = 266,
  sym_keyword_min = 267,
  sym_keyword_case = 268,
  sym_keyword_when = 269,
  sym_keyword_then = 270,
  sym_keyword_else = 271,
  sym_keyword_end = 272,
  sym_keyword_substring = 273,
  sym_keyword_in = 274,
  sym_keyword_and = 275,
  sym_keyword_or = 276,
  sym_keyword_is = 277,
  sym_keyword_not = 278,
  sym_keyword_asymmetric = 279,
  sym_keyword_symmetric = 280,
  sym_keyword_using = 281,
  sym_keyword_for = 282,
  sym_keyword_bytes = 283,
  sym_keyword_if = 284,
  sym_keyword_exists = 285,
  sym_keyword_at = 286,
  sym_keyword_zone = 287,
  sym_keyword_default = 288,
  sym_keyword_with = 289,
  sym_keyword_no = 290,
  sym_keyword_to = 291,
  sym_keyword_union = 292,
  sym_keyword_all = 293,
  sym_keyword_except = 294,
  sym_keyword_intersect = 295,
  sym_keyword_begin = 296,
  sym_keyword_commit = 297,
  sym_keyword_rollback = 298,
  sym_keyword_transaction = 299,
  sym_keyword_over = 300,
  sym_keyword_nulls = 301,
  sym_keyword_first = 302,
  sym_keyword_last = 303,
  sym_keyword_window = 304,
  sym_keyword_system_time = 305,
  sym_keyword_of = 306,
  sym_keyword_range = 307,
  sym_keyword_rows = 308,
  sym_keyword_between = 309,
  sym_keyword_unbounded = 310,
  sym_keyword_preceding = 311,
  sym_keyword_following = 312,
  sym_keyword_exclude = 313,
  sym_keyword_current = 314,
  sym_keyword_row = 315,
  sym_keyword_ties = 316,
  sym_keyword_others = 317,
  sym_keyword_like = 318,
  sym_keyword_similar = 319,
  sym_keyword_within = 320,
  sym_keyword_filter = 321,
  sym_keyword_respect = 322,
  sym_keyword_trim = 323,
  sym_keyword_leading = 324,
  sym_keyword_trailing = 325,
  sym_keyword_both = 326,
  sym_keyword_ignore = 327,
  sym_keyword_declare = 328,
  sym_keyword_execute = 329,
  sym_keyword_immediate = 330,
  sym_keyword_exception = 331,
  sym_keyword_error = 332,
  sym_keyword_elseif = 333,
  sym_keyword_loop = 334,
  sym_keyword_until = 335,
  sym_keyword_repeat = 336,
  sym_keyword_while = 337,
  sym_keyword_do = 338,
  sym_keyword_break = 339,
  sym_keyword_leave = 340,
  sym_keyword_continue = 341,
  sym_keyword_iterate = 342,
  sym_keyword_message = 343,
  sym_keyword_raise = 344,
  sym_keyword_assert = 345,
  sym_keyword_struct = 346,
  sym_keyword_value = 347,
  sym_keyword_array = 348,
  sym_keyword_any = 349,
  sym_keyword_some = 350,
  sym_keyword_current_date = 351,
  sym_keyword_current_time = 352,
  sym_keyword_current_timestamp = 353,
  sym_keyword_system = 354,
  sym_keyword_tablesample = 355,
  sym_keyword_percent = 356,
  sym_keyword_pivot = 357,
  sym_keyword_qualify = 358,
  sym_keyword_include = 359,
  sym_keyword_unpivot = 360,
  sym_keyword_full = 361,
  sym_keyword_null = 362,
  sym_keyword_true = 363,
  sym_keyword_false = 364,
  sym_keyword_boolean = 365,
  sym_keyword_smallserial = 366,
  sym_keyword_serial = 367,
  sym_keyword_bigserial = 368,
  sym_keyword_int = 369,
  sym_keyword_decimal = 370,
  sym_keyword_bigdecimal = 371,
  sym_keyword_numeric = 372,
  sym_keyword_bignumeric = 373,
  sym_keyword_real = 374,
  sym_keyword_float = 375,
  sym_keyword_money = 376,
  sym_keyword_string = 377,
  sym_keyword_char = 378,
  sym_keyword_varchar = 379,
  sym_keyword_text = 380,
  sym_keyword_uuid = 381,
  sym_keyword_json = 382,
  sym_keyword_jsonb = 383,
  sym_keyword_xml = 384,
  sym_keyword_bytea = 385,
  sym_keyword_interval = 386,
  sym_keyword_time = 387,
  sym_keyword_date = 388,
  sym_keyword_datetime = 389,
  sym_keyword_timestamp = 390,
  sym_keyword_timestamptz = 391,
  sym_keyword_geometry = 392,
  sym_keyword_geography = 393,
  sym_keyword_box2d = 394,
  sym_keyword_box3d = 395,
  sym_wildcard = 396,
  sym__time_types = 397,
  sym__type = 398,
  sym_numeric = 399,
  sym_statement = 400,
  aux_sym__statement_list = 401,
  sym__argument = 402,
  sym__select_wildcard = 403,
  sym__distinct_on = 404,
  sym_select = 405,
  sym_select_clause = 406,
  sym_select_field = 407,
  sym_select_expression = 408,
  sym_select_statement = 409,
  sym_set_operation = 410,
  sym_cte_clause = 411,
  sym_cte = 412,
  sym_transaction = 413,
  sym__begin = 414,
  sym__commit = 415,
  sym__rollback = 416,
  sym_date = 417,
  sym_expression_list = 418,
  sym__expression_list_item = 419,
  sym_reference = 420,
  sym__column_list_without_order = 421,
  sym__column_without_order = 422,
  sym_direction = 423,
  sym__select_wildcard_except = 424,
  sym__select_wildcard_replace = 425,
  sym_select_replace_expression = 426,
  sym_parameter = 427,
  sym_case = 428,
  sym_when_clause = 429,
  sym_else_clause = 430,
  sym_field = 431,
  sym__format_string_expression = 432,
  sym__cast_with_format = 433,
  sym_cast = 434,
  sym_substring = 435,
  sym_quantified_comparison = 436,
  sym_trim = 437,
  sym_invocation = 438,
  sym__extract_invocation = 439,
  sym__array_invocation = 440,
  sym_within_group = 441,
  sym_filter = 442,
  sym_partition_by = 443,
  sym_window_clause = 444,
  sym_window_specification = 445,
  sym_window_function = 446,
  sym_window_frame = 447,
  sym_rows_range = 448,
  sym_window_numeric_preceding = 449,
  sym_window_numeric_following = 450,
  sym__window_frame_start = 451,
  sym__window_frame_end = 452,
  sym_window_frame_between = 453,
  sym__frame_exclusion = 454,
  sym__invocation_params = 455,
  sym_having_max_clause = 456,
  sym_having_min_clause = 457,
  sym_unnest_operator = 458,
  sym_unnest_withoffset = 459,
  sym_unnest_clause = 460,
  sym_column_alias_list = 461,
  sym__alias = 462,
  sym__from_item = 463,
  sym_from_clause = 464,
  sym_tablesample_operator = 465,
  sym_pivot_value = 466,
  sym_pivot_operator = 467,
  sym_unpivot_operator = 468,
  sym_single_column_unpivot = 469,
  sym_multi_column_unpivot = 470,
  sym_unpivot_column = 471,
  sym_join = 472,
  sym__cross_join_operation = 473,
  sym_join_prefix = 474,
  sym__conditional_join_operator = 475,
  sym_join_type = 476,
  sym_join_condition = 477,
  sym_declare_statement = 478,
  sym_set_statement = 479,
  sym_execute_immadiate_statement = 480,
  sym_into_clause = 481,
  sym_using_clause = 482,
  sym_argument = 483,
  sym_call_statement = 484,
  sym_begin_end_statement = 485,
  sym_begin_exception_end_statement = 486,
  sym_if_statement = 487,
  sym_loop_statement = 488,
  sym_repeat_statement = 489,
  sym_while_statement = 490,
  sym_for_in_statement = 491,
  sym_break_statement = 492,
  sym_leave_statement = 493,
  sym_continue_statement = 494,
  sym_iterate_statement = 495,
  sym_raise_statement = 496,
  sym_assert_statement = 497,
  sym_relation = 498,
  sym_where_clause = 499,
  sym_group_by_clause = 500,
  sym_having_clause = 501,
  sym_qualify_clause = 502,
  sym_order_by_item = 503,
  sym_order_by_items = 504,
  sym_order_by_clause = 505,
  sym_limit_clause = 506,
  sym_offset = 507,
  sym_between = 508,
  sym_interval = 509,
  sym__expression = 510,
  sym_predicate = 511,
  sym_binary_expression = 512,
  sym__parenthesized_expression = 513,
  sym_field_access = 514,
  sym_element_access = 515,
  sym_subquery = 516,
  sym_list = 517,
  sym_query_parameter = 518,
  sym_literal = 519,
  sym_json = 520,
  sym__number = 521,
  sym__float = 522,
  sym__float_or_integer = 523,
  sym_string = 524,
  sym_number = 525,
  sym__base_type = 526,
  sym__bqtype = 527,
  sym__type_struct = 528,
  sym__type_array = 529,
  sym_array = 530,
  sym_struct = 531,
  sym_current_date = 532,
  sym_current_time = 533,
  sym_current_timestamp = 534,
  sym__aliasable_expression = 535,
  sym__identifier = 536,
  sym__dotted_identifier = 537,
  sym_identifier = 538,
  aux_sym_program_repeat1 = 539,
  aux_sym__distinct_on_repeat1 = 540,
  aux_sym_select_expression_repeat1 = 541,
  aux_sym_cte_clause_repeat1 = 542,
  aux_sym_transaction_repeat1 = 543,
  aux_sym_expression_list_repeat1 = 544,
  aux_sym__column_list_without_order_repeat1 = 545,
  aux_sym__select_wildcard_except_repeat1 = 546,
  aux_sym__select_wildcard_replace_repeat1 = 547,
  aux_sym_case_repeat1 = 548,
  aux_sym_window_clause_repeat1 = 549,
  aux_sym__invocation_params_repeat1 = 550,
  aux_sym_column_alias_list_repeat1 = 551,
  aux_sym_pivot_operator_repeat1 = 552,
  aux_sym_pivot_operator_repeat2 = 553,
  aux_sym_single_column_unpivot_repeat1 = 554,
  aux_sym_multi_column_unpivot_repeat1 = 555,
  aux_sym_declare_statement_repeat1 = 556,
  aux_sym_using_clause_repeat1 = 557,
  aux_sym_call_statement_repeat1 = 558,
  aux_sym_if_statement_repeat1 = 559,
  aux_sym_order_by_items_repeat1 = 560,
  aux_sym_list_repeat1 = 561,
  aux_sym_string_repeat1 = 562,
  aux_sym__type_struct_repeat1 = 563,
  aux_sym_struct_repeat1 = 564,
  aux_sym_identifier_repeat1 = 565,
  alias_sym_alias = 566,
  alias_sym_between_from = 567,
  alias_sym_call_reference = 568,
  alias_sym_case_end = 569,
  alias_sym_cte_name = 570,
  alias_sym_datetime_part = 571,
  alias_sym_default_expression = 572,
  alias_sym_float = 573,
  alias_sym_having_expression = 574,
  alias_sym_input_column = 575,
  alias_sym_integer = 576,
  alias_sym_name_column = 577,
  alias_sym_pivot_column = 578,
  alias_sym_unpivot_value = 579,
  alias_sym_using_operator = 580,
  alias_sym_variable_type = 581,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__unquoted_identifier] = "_unquoted_identifier",
  [aux_sym_keyword_select_token1] = "keyword",
  [aux_sym_keyword_replace_token1] = "keyword",
  [aux_sym_keyword_into_token1] = "keyword",
  [aux_sym_keyword_values_token1] = "keyword",
  [aux_sym_keyword_set_token1] = "keyword",
  [aux_sym_keyword_from_token1] = "keyword",
  [aux_sym_keyword_left_token1] = "keyword",
  [aux_sym_keyword_format_token1] = "keyword",
  [aux_sym_keyword_extract_token1] = "keyword",
  [aux_sym_keyword_right_token1] = "keyword",
  [aux_sym_keyword_inner_token1] = "keyword",
  [aux_sym_keyword_outer_token1] = "keyword",
  [aux_sym_keyword_cross_token1] = "keyword",
  [aux_sym_keyword_unnest_token1] = "keyword",
  [aux_sym_keyword_join_token1] = "keyword",
  [aux_sym_keyword_on_token1] = "keyword",
  [aux_sym_keyword_recursive_token1] = "keyword",
  [aux_sym_keyword_call_token1] = "keyword",
  [aux_sym_keyword_where_token1] = "keyword",
  [aux_sym_keyword_order_token1] = "keyword",
  [aux_sym_keyword_group_token1] = "keyword",
  [aux_sym_keyword_partition_token1] = "keyword",
  [aux_sym_keyword_by_token1] = "keyword",
  [aux_sym_keyword_having_token1] = "keyword",
  [aux_sym_keyword_escape_token1] = "keyword",
  [aux_sym_keyword_desc_token1] = "keyword",
  [aux_sym_keyword_asc_token1] = "keyword",
  [aux_sym_keyword_limit_token1] = "keyword",
  [aux_sym_keyword_offset_token1] = "keyword",
  [aux_sym_keyword_table_token1] = "keyword",
  [aux_sym_keyword_view_token1] = "keyword",
  [aux_sym_keyword_materialized_token1] = "keyword",
  [aux_sym_keyword_as_token1] = "keyword",
  [aux_sym_keyword_distinct_token1] = "keyword",
  [aux_sym_keyword_cast_token1] = "keyword",
  [aux_sym_keyword_safe_cast_token1] = "keyword",
  [aux_sym_keyword_max_token1] = "keyword",
  [aux_sym_keyword_min_token1] = "keyword",
  [aux_sym_keyword_case_token1] = "keyword",
  [aux_sym_keyword_when_token1] = "keyword",
  [aux_sym_keyword_then_token1] = "keyword",
  [aux_sym_keyword_else_token1] = "keyword",
  [aux_sym_keyword_end_token1] = "keyword",
  [aux_sym_keyword_substring_token1] = "keyword",
  [aux_sym_keyword_in_token1] = "keyword",
  [aux_sym_keyword_and_token1] = "keyword",
  [aux_sym_keyword_or_token1] = "keyword",
  [aux_sym_keyword_is_token1] = "keyword",
  [aux_sym_keyword_not_token1] = "keyword",
  [aux_sym_keyword_asymmetric_token1] = "keyword",
  [aux_sym_keyword_symmetric_token1] = "keyword",
  [aux_sym_keyword_using_token1] = "keyword",
  [aux_sym_keyword_for_token1] = "keyword",
  [aux_sym_keyword_bytes_token1] = "keyword",
  [aux_sym_keyword_if_token1] = "keyword",
  [aux_sym_keyword_exists_token1] = "keyword",
  [aux_sym_keyword_at_token1] = "keyword",
  [aux_sym_keyword_zone_token1] = "keyword",
  [aux_sym_keyword_default_token1] = "keyword",
  [aux_sym_keyword_with_token1] = "keyword",
  [aux_sym_keyword_no_token1] = "keyword",
  [aux_sym_keyword_to_token1] = "keyword",
  [aux_sym_keyword_schema_token1] = "keyword",
  [aux_sym_keyword_union_token1] = "keyword",
  [aux_sym_keyword_all_token1] = "keyword",
  [aux_sym_keyword_except_token1] = "keyword",
  [aux_sym_keyword_intersect_token1] = "keyword",
  [aux_sym_keyword_begin_token1] = "keyword",
  [aux_sym_keyword_commit_token1] = "keyword",
  [aux_sym_keyword_rollback_token1] = "keyword",
  [aux_sym_keyword_transaction_token1] = "keyword",
  [aux_sym_keyword_over_token1] = "keyword",
  [aux_sym_keyword_nulls_token1] = "keyword",
  [aux_sym_keyword_first_token1] = "keyword",
  [aux_sym_keyword_last_token1] = "keyword",
  [aux_sym_keyword_window_token1] = "keyword",
  [aux_sym_keyword_system_time_token1] = "keyword",
  [aux_sym_keyword_of_token1] = "keyword",
  [aux_sym_keyword_range_token1] = "keyword",
  [aux_sym_keyword_rows_token1] = "keyword",
  [aux_sym_keyword_between_token1] = "keyword",
  [aux_sym_keyword_unbounded_token1] = "keyword",
  [aux_sym_keyword_preceding_token1] = "keyword",
  [aux_sym_keyword_following_token1] = "keyword",
  [aux_sym_keyword_exclude_token1] = "keyword",
  [aux_sym_keyword_current_token1] = "keyword",
  [aux_sym_keyword_row_token1] = "keyword",
  [aux_sym_keyword_ties_token1] = "keyword",
  [aux_sym_keyword_others_token1] = "keyword",
  [aux_sym_keyword_like_token1] = "keyword",
  [aux_sym_keyword_like_token2] = "keyword",
  [aux_sym_keyword_similar_token1] = "keyword",
  [aux_sym_keyword_within_token1] = "keyword",
  [aux_sym_keyword_filter_token1] = "keyword",
  [aux_sym_keyword_respect_token1] = "keyword",
  [aux_sym_keyword_trim_token1] = "keyword",
  [aux_sym_keyword_leading_token1] = "keyword",
  [aux_sym_keyword_trailing_token1] = "keyword",
  [aux_sym_keyword_both_token1] = "keyword",
  [aux_sym_keyword_ignore_token1] = "keyword",
  [aux_sym_keyword_privileges_token1] = "keyword",
  [aux_sym_keyword_external_token1] = "keyword",
  [aux_sym_keyword_declare_token1] = "keyword",
  [aux_sym_keyword_execute_token1] = "keyword",
  [aux_sym_keyword_immediate_token1] = "keyword",
  [aux_sym_keyword_exception_token1] = "keyword",
  [aux_sym_keyword_error_token1] = "keyword",
  [aux_sym_keyword_elseif_token1] = "keyword",
  [aux_sym_keyword_loop_token1] = "keyword",
  [aux_sym_keyword_until_token1] = "keyword",
  [aux_sym_keyword_repeat_token1] = "keyword",
  [aux_sym_keyword_while_token1] = "keyword",
  [aux_sym_keyword_do_token1] = "keyword",
  [aux_sym_keyword_break_token1] = "keyword",
  [aux_sym_keyword_leave_token1] = "keyword",
  [aux_sym_keyword_continue_token1] = "keyword",
  [aux_sym_keyword_iterate_token1] = "keyword",
  [aux_sym_keyword_message_token1] = "keyword",
  [aux_sym_keyword_raise_token1] = "keyword",
  [aux_sym_keyword_assert_token1] = "keyword",
  [aux_sym_keyword_struct_token1] = "keyword",
  [aux_sym_keyword_value_token1] = "keyword",
  [aux_sym_keyword_array_token1] = "keyword",
  [aux_sym_keyword_any_token1] = "keyword",
  [aux_sym_keyword_some_token1] = "keyword",
  [aux_sym_keyword_current_date_token1] = "keyword",
  [aux_sym_keyword_current_time_token1] = "keyword",
  [aux_sym_keyword_current_timestamp_token1] = "keyword",
  [aux_sym_keyword_system_token1] = "keyword",
  [aux_sym_keyword_tablesample_token1] = "keyword",
  [aux_sym_keyword_percent_token1] = "keyword",
  [aux_sym_keyword_pivot_token1] = "keyword",
  [aux_sym_keyword_qualify_token1] = "keyword",
  [aux_sym_keyword_include_token1] = "keyword",
  [aux_sym_keyword_unpivot_token1] = "keyword",
  [aux_sym_keyword_full_token1] = "keyword",
  [aux_sym_keyword_null_token1] = "keyword",
  [aux_sym_keyword_true_token1] = "keyword",
  [aux_sym_keyword_false_token1] = "keyword",
  [aux_sym_keyword_boolean_token1] = "keyword",
  [aux_sym_keyword_boolean_token2] = "keyword",
  [aux_sym_keyword_smallserial_token1] = "keyword",
  [aux_sym_keyword_smallserial_token2] = "keyword",
  [aux_sym_keyword_serial_token1] = "keyword",
  [aux_sym_keyword_serial_token2] = "keyword",
  [aux_sym_keyword_bigserial_token1] = "keyword",
  [aux_sym_keyword_bigserial_token2] = "keyword",
  [aux_sym_keyword_int_token1] = "keyword",
  [aux_sym_keyword_int_token2] = "keyword",
  [aux_sym_keyword_int_token3] = "keyword",
  [aux_sym_keyword_int_token4] = "keyword",
  [aux_sym_keyword_int_token5] = "keyword",
  [aux_sym_keyword_int_token6] = "keyword",
  [aux_sym_keyword_int_token7] = "keyword",
  [aux_sym_keyword_decimal_token1] = "keyword",
  [aux_sym_keyword_bigdecimal_token1] = "keyword",
  [aux_sym_keyword_numeric_token1] = "keyword",
  [aux_sym_keyword_bignumeric_token1] = "keyword",
  [aux_sym_keyword_real_token1] = "keyword",
  [aux_sym_keyword_real_token2] = "keyword",
  [aux_sym_keyword_float_token1] = "keyword",
  [aux_sym_keyword_float_token2] = "keyword",
  [aux_sym_keyword_money_token1] = "keyword",
  [aux_sym_keyword_string_token1] = "keyword",
  [aux_sym_keyword_char_token1] = "keyword",
  [aux_sym_keyword_char_token2] = "keyword",
  [aux_sym_keyword_varchar_token1] = "keyword",
  [aux_sym_keyword_varchar_token2] = "keyword",
  [aux_sym_keyword_text_token1] = "keyword",
  [aux_sym_keyword_uuid_token1] = "keyword",
  [aux_sym_keyword_json_token1] = "keyword",
  [aux_sym_keyword_jsonb_token1] = "keyword",
  [aux_sym_keyword_xml_token1] = "keyword",
  [aux_sym_keyword_bytea_token1] = "keyword",
  [aux_sym_keyword_interval_token1] = "keyword",
  [aux_sym_keyword_time_token1] = "keyword",
  [aux_sym_keyword_date_token1] = "keyword",
  [aux_sym_keyword_datetime_token1] = "keyword",
  [aux_sym_keyword_timestamp_token1] = "keyword",
  [aux_sym_keyword_timestamp_token2] = "keyword",
  [aux_sym_keyword_timestamptz_token1] = "keyword",
  [aux_sym_keyword_geometry_token1] = "keyword",
  [aux_sym_keyword_geography_token1] = "keyword",
  [aux_sym_keyword_box2d_token1] = "keyword",
  [aux_sym_keyword_box3d_token1] = "keyword",
  [anon_sym_STAR] = "*",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_DQUOTE] = "\"",
  [sym_comment] = "comment",
  [sym_comma] = "comma",
  [anon_sym_SEMI] = ";",
  [anon_sym_EQ_GT] = "=>",
  [sym_left_paren] = "left_paren",
  [sym_right_paren] = "right_paren",
  [anon_sym_QMARK] = "\?",
  [anon_sym_DOLLAR] = "$",
  [aux_sym_parameter_token1] = "parameter_token1",
  [anon_sym_DOT] = ".",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_EQ] = "=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_TILDE] = "~",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PIPE_PIPE] = "concat",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym_system_variable] = "system_variable",
  [sym__named_query_parameter] = "_named_query_parameter",
  [sym__positional_query_parameter] = "_positional_query_parameter",
  [sym_hex] = "hex",
  [sym__integer] = "_integer",
  [aux_sym__float_token1] = "_float_token1",
  [aux_sym__float_token2] = "_float_token2",
  [aux_sym__float_token3] = "_float_token3",
  [sym__quoted_identifier] = "_quoted_identifier",
  [sym__string_start] = "_string_start",
  [sym__string_content] = "_string_content",
  [sym__string_end] = "_string_end",
  [sym_program] = "program",
  [sym_keyword_select] = "keyword_select",
  [sym_keyword_replace] = "keyword_replace",
  [sym_keyword_into] = "keyword_into",
  [sym_keyword_set] = "keyword_set",
  [sym_keyword_from] = "keyword_from",
  [sym_keyword_left] = "keyword_left",
  [sym_keyword_format] = "keyword_format",
  [sym_keyword_extract] = "identifier",
  [sym_keyword_right] = "keyword_right",
  [sym_keyword_inner] = "keyword_inner",
  [sym_keyword_outer] = "keyword_outer",
  [sym_keyword_cross] = "keyword_cross",
  [sym_keyword_unnest] = "keyword_unnest",
  [sym_keyword_join] = "keyword_join",
  [sym_keyword_on] = "keyword_on",
  [sym_keyword_recursive] = "keyword_recursive",
  [sym_keyword_call] = "keyword_call",
  [sym_keyword_where] = "keyword_where",
  [sym_keyword_order] = "keyword_order",
  [sym_keyword_group] = "keyword_group",
  [sym_keyword_partition] = "keyword_partition",
  [sym_keyword_by] = "keyword_by",
  [sym_keyword_having] = "keyword_having",
  [sym_keyword_escape] = "keyword_escape",
  [sym_keyword_desc] = "keyword_desc",
  [sym_keyword_asc] = "keyword_asc",
  [sym_keyword_limit] = "keyword_limit",
  [sym_keyword_offset] = "keyword_offset",
  [sym_keyword_materialized] = "keyword_materialized",
  [sym_keyword_as] = "keyword_as",
  [sym_keyword_distinct] = "keyword_distinct",
  [sym_keyword_cast] = "identifier",
  [sym_keyword_safe_cast] = "identifier",
  [sym_keyword_max] = "keyword_max",
  [sym_keyword_min] = "keyword_min",
  [sym_keyword_case] = "keyword_case",
  [sym_keyword_when] = "keyword_when",
  [sym_keyword_then] = "keyword_then",
  [sym_keyword_else] = "keyword_else",
  [sym_keyword_end] = "keyword_end",
  [sym_keyword_substring] = "identifier",
  [sym_keyword_in] = "keyword_in",
  [sym_keyword_and] = "keyword_and",
  [sym_keyword_or] = "keyword_or",
  [sym_keyword_is] = "keyword_is",
  [sym_keyword_not] = "keyword_not",
  [sym_keyword_asymmetric] = "keyword_asymmetric",
  [sym_keyword_symmetric] = "keyword_symmetric",
  [sym_keyword_using] = "keyword_using",
  [sym_keyword_for] = "keyword_for",
  [sym_keyword_bytes] = "keyword_bytes",
  [sym_keyword_if] = "keyword_if",
  [sym_keyword_exists] = "keyword_exists",
  [sym_keyword_at] = "keyword_at",
  [sym_keyword_zone] = "keyword_zone",
  [sym_keyword_default] = "keyword_default",
  [sym_keyword_with] = "keyword_with",
  [sym_keyword_no] = "keyword_no",
  [sym_keyword_to] = "keyword_to",
  [sym_keyword_union] = "keyword_union",
  [sym_keyword_all] = "keyword_all",
  [sym_keyword_except] = "keyword_except",
  [sym_keyword_intersect] = "keyword_intersect",
  [sym_keyword_begin] = "keyword_begin",
  [sym_keyword_commit] = "keyword_commit",
  [sym_keyword_rollback] = "keyword_rollback",
  [sym_keyword_transaction] = "keyword_transaction",
  [sym_keyword_over] = "keyword_over",
  [sym_keyword_nulls] = "keyword_nulls",
  [sym_keyword_first] = "keyword_first",
  [sym_keyword_last] = "keyword_last",
  [sym_keyword_window] = "keyword_window",
  [sym_keyword_system_time] = "keyword_system_time",
  [sym_keyword_of] = "keyword_of",
  [sym_keyword_range] = "keyword_range",
  [sym_keyword_rows] = "keyword_rows",
  [sym_keyword_between] = "keyword_between",
  [sym_keyword_unbounded] = "keyword_unbounded",
  [sym_keyword_preceding] = "keyword_preceding",
  [sym_keyword_following] = "keyword_following",
  [sym_keyword_exclude] = "keyword_exclude",
  [sym_keyword_current] = "keyword_current",
  [sym_keyword_row] = "keyword_row",
  [sym_keyword_ties] = "keyword_ties",
  [sym_keyword_others] = "keyword_others",
  [sym_keyword_like] = "keyword_like",
  [sym_keyword_similar] = "keyword_similar",
  [sym_keyword_within] = "keyword_within",
  [sym_keyword_filter] = "keyword_filter",
  [sym_keyword_respect] = "keyword_respect",
  [sym_keyword_trim] = "identifier",
  [sym_keyword_leading] = "keyword_leading",
  [sym_keyword_trailing] = "keyword_trailing",
  [sym_keyword_both] = "keyword_both",
  [sym_keyword_ignore] = "keyword_ignore",
  [sym_keyword_declare] = "keyword_declare",
  [sym_keyword_execute] = "keyword_execute",
  [sym_keyword_immediate] = "keyword_immediate",
  [sym_keyword_exception] = "keyword_exception",
  [sym_keyword_error] = "keyword_error",
  [sym_keyword_elseif] = "keyword_elseif",
  [sym_keyword_loop] = "keyword_loop",
  [sym_keyword_until] = "until_clause",
  [sym_keyword_repeat] = "keyword_repeat",
  [sym_keyword_while] = "keyword_while",
  [sym_keyword_do] = "keyword_do",
  [sym_keyword_break] = "keyword_break",
  [sym_keyword_leave] = "keyword_leave",
  [sym_keyword_continue] = "keyword_continue",
  [sym_keyword_iterate] = "keyword_iterate",
  [sym_keyword_message] = "keyword_message",
  [sym_keyword_raise] = "keyword_raise",
  [sym_keyword_assert] = "keyword_assert",
  [sym_keyword_struct] = "keyword_struct",
  [sym_keyword_value] = "keyword_value",
  [sym_keyword_array] = "keyword_array",
  [sym_keyword_any] = "keyword_any",
  [sym_keyword_some] = "keyword_some",
  [sym_keyword_current_date] = "keyword_current_date",
  [sym_keyword_current_time] = "keyword_current_time",
  [sym_keyword_current_timestamp] = "keyword_current_timestamp",
  [sym_keyword_system] = "keyword_system",
  [sym_keyword_tablesample] = "keyword_tablesample",
  [sym_keyword_percent] = "keyword_percent",
  [sym_keyword_pivot] = "keyword_pivot",
  [sym_keyword_qualify] = "keyword_qualify",
  [sym_keyword_include] = "keyword_include",
  [sym_keyword_unpivot] = "keyword_unpivot",
  [sym_keyword_full] = "keyword_full",
  [sym_keyword_null] = "keyword_null",
  [sym_keyword_true] = "keyword_true",
  [sym_keyword_false] = "keyword_false",
  [sym_keyword_boolean] = "keyword_boolean",
  [sym_keyword_smallserial] = "keyword_smallserial",
  [sym_keyword_serial] = "keyword_serial",
  [sym_keyword_bigserial] = "keyword_bigserial",
  [sym_keyword_int] = "keyword_int",
  [sym_keyword_decimal] = "keyword_decimal",
  [sym_keyword_bigdecimal] = "keyword_bigdecimal",
  [sym_keyword_numeric] = "keyword_numeric",
  [sym_keyword_bignumeric] = "keyword_bignumeric",
  [sym_keyword_real] = "keyword_real",
  [sym_keyword_float] = "keyword_float",
  [sym_keyword_money] = "keyword_money",
  [sym_keyword_string] = "keyword_string",
  [sym_keyword_char] = "keyword_char",
  [sym_keyword_varchar] = "keyword_varchar",
  [sym_keyword_text] = "keyword_text",
  [sym_keyword_uuid] = "keyword_uuid",
  [sym_keyword_json] = "keyword_json",
  [sym_keyword_jsonb] = "keyword_jsonb",
  [sym_keyword_xml] = "keyword_xml",
  [sym_keyword_bytea] = "keyword_bytea",
  [sym_keyword_interval] = "keyword_interval",
  [sym_keyword_time] = "keyword_time",
  [sym_keyword_date] = "keyword_date",
  [sym_keyword_datetime] = "keyword_datetime",
  [sym_keyword_timestamp] = "keyword_timestamp",
  [sym_keyword_timestamptz] = "keyword_timestamptz",
  [sym_keyword_geometry] = "keyword_geometry",
  [sym_keyword_geography] = "keyword_geography",
  [sym_keyword_box2d] = "keyword_box2d",
  [sym_keyword_box3d] = "keyword_box3d",
  [sym_wildcard] = "wildcard",
  [sym__time_types] = "_time_types",
  [sym__type] = "_type",
  [sym_numeric] = "numeric",
  [sym_statement] = "statement",
  [aux_sym__statement_list] = "_statement_list",
  [sym__argument] = "_argument",
  [sym__select_wildcard] = "_select_wildcard",
  [sym__distinct_on] = "_distinct_on",
  [sym_select] = "select",
  [sym_select_clause] = "select_clause",
  [sym_select_field] = "select_field",
  [sym_select_expression] = "select_expression",
  [sym_select_statement] = "select_statement",
  [sym_set_operation] = "set_operation",
  [sym_cte_clause] = "cte_clause",
  [sym_cte] = "cte",
  [sym_transaction] = "transaction",
  [sym__begin] = "_begin",
  [sym__commit] = "_commit",
  [sym__rollback] = "_rollback",
  [sym_date] = "date",
  [sym_expression_list] = "expression_list",
  [sym__expression_list_item] = "_expression_list_item",
  [sym_reference] = "table_reference",
  [sym__column_list_without_order] = "column_list",
  [sym__column_without_order] = "column",
  [sym_direction] = "direction",
  [sym__select_wildcard_except] = "_select_wildcard_except",
  [sym__select_wildcard_replace] = "_select_wildcard_replace",
  [sym_select_replace_expression] = "select_replace_expression",
  [sym_parameter] = "parameter",
  [sym_case] = "case",
  [sym_when_clause] = "when_clause",
  [sym_else_clause] = "else_clause",
  [sym_field] = "field",
  [sym__format_string_expression] = "_format_string_expression",
  [sym__cast_with_format] = "_cast_with_format",
  [sym_cast] = "cast",
  [sym_substring] = "substring",
  [sym_quantified_comparison] = "quantified_comparison",
  [sym_trim] = "trim",
  [sym_invocation] = "invocation",
  [sym__extract_invocation] = "_extract_invocation",
  [sym__array_invocation] = "_array_invocation",
  [sym_within_group] = "within_group",
  [sym_filter] = "filter",
  [sym_partition_by] = "partition_by",
  [sym_window_clause] = "window_clause",
  [sym_window_specification] = "window_specification",
  [sym_window_function] = "window_function",
  [sym_window_frame] = "window_frame",
  [sym_rows_range] = "rows_range",
  [sym_window_numeric_preceding] = "window_numeric_preceding",
  [sym_window_numeric_following] = "window_numeric_following",
  [sym__window_frame_start] = "_window_frame_start",
  [sym__window_frame_end] = "between_to",
  [sym_window_frame_between] = "window_frame_between",
  [sym__frame_exclusion] = "_frame_exclusion",
  [sym__invocation_params] = "_invocation_params",
  [sym_having_max_clause] = "having_max_clause",
  [sym_having_min_clause] = "having_min_clause",
  [sym_unnest_operator] = "unnest_operator",
  [sym_unnest_withoffset] = "unnest_withoffset",
  [sym_unnest_clause] = "unnest_clause",
  [sym_column_alias_list] = "column_alias_list",
  [sym__alias] = "_alias",
  [sym__from_item] = "_from_item",
  [sym_from_clause] = "from_clause",
  [sym_tablesample_operator] = "tablesample_operator",
  [sym_pivot_value] = "pivot_value",
  [sym_pivot_operator] = "pivot_operator",
  [sym_unpivot_operator] = "unpivot_operator",
  [sym_single_column_unpivot] = "single_column_unpivot",
  [sym_multi_column_unpivot] = "multi_column_unpivot",
  [sym_unpivot_column] = "unpivot_column",
  [sym_join] = "join",
  [sym__cross_join_operation] = "_cross_join_operation",
  [sym_join_prefix] = "join_prefix",
  [sym__conditional_join_operator] = "_conditional_join_operator",
  [sym_join_type] = "join_type",
  [sym_join_condition] = "join_condition",
  [sym_declare_statement] = "declare_statement",
  [sym_set_statement] = "set_statement",
  [sym_execute_immadiate_statement] = "execute_immadiate_statement",
  [sym_into_clause] = "into_clause",
  [sym_using_clause] = "using_clause",
  [sym_argument] = "argument",
  [sym_call_statement] = "call_statement",
  [sym_begin_end_statement] = "begin_end_statement",
  [sym_begin_exception_end_statement] = "begin_exception_end_statement",
  [sym_if_statement] = "if_statement",
  [sym_loop_statement] = "loop_statement",
  [sym_repeat_statement] = "repeat_statement",
  [sym_while_statement] = "while_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym_break_statement] = "break_statement",
  [sym_leave_statement] = "leave_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_iterate_statement] = "iterate_statement",
  [sym_raise_statement] = "raise_statement",
  [sym_assert_statement] = "assert_statement",
  [sym_relation] = "relation",
  [sym_where_clause] = "where_clause",
  [sym_group_by_clause] = "group_by_clause",
  [sym_having_clause] = "having_clause",
  [sym_qualify_clause] = "qualify_clause",
  [sym_order_by_item] = "order_by_item",
  [sym_order_by_items] = "order_by_items",
  [sym_order_by_clause] = "order_by_clause",
  [sym_limit_clause] = "limit_clause",
  [sym_offset] = "offset",
  [sym_between] = "between",
  [sym_interval] = "interval",
  [sym__expression] = "_expression",
  [sym_predicate] = "predicate",
  [sym_binary_expression] = "binary_expression",
  [sym__parenthesized_expression] = "_parenthesized_expression",
  [sym_field_access] = "field_access",
  [sym_element_access] = "element_access",
  [sym_subquery] = "subquery",
  [sym_list] = "list",
  [sym_query_parameter] = "query_parameter",
  [sym_literal] = "literal",
  [sym_json] = "json",
  [sym__number] = "_number",
  [sym__float] = "_float",
  [sym__float_or_integer] = "value",
  [sym_string] = "string",
  [sym_number] = "number",
  [sym__base_type] = "_base_type",
  [sym__bqtype] = "_bqtype",
  [sym__type_struct] = "_type_struct",
  [sym__type_array] = "_type_array",
  [sym_array] = "array",
  [sym_struct] = "struct",
  [sym_current_date] = "current_date",
  [sym_current_time] = "current_time",
  [sym_current_timestamp] = "current_timestamp",
  [sym__aliasable_expression] = "_aliasable_expression",
  [sym__identifier] = "_identifier",
  [sym__dotted_identifier] = "_dotted_identifier",
  [sym_identifier] = "identifier",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym__distinct_on_repeat1] = "_distinct_on_repeat1",
  [aux_sym_select_expression_repeat1] = "select_expression_repeat1",
  [aux_sym_cte_clause_repeat1] = "cte_clause_repeat1",
  [aux_sym_transaction_repeat1] = "transaction_repeat1",
  [aux_sym_expression_list_repeat1] = "expression_list_repeat1",
  [aux_sym__column_list_without_order_repeat1] = "_column_list_without_order_repeat1",
  [aux_sym__select_wildcard_except_repeat1] = "_select_wildcard_except_repeat1",
  [aux_sym__select_wildcard_replace_repeat1] = "_select_wildcard_replace_repeat1",
  [aux_sym_case_repeat1] = "case_repeat1",
  [aux_sym_window_clause_repeat1] = "window_clause_repeat1",
  [aux_sym__invocation_params_repeat1] = "_invocation_params_repeat1",
  [aux_sym_column_alias_list_repeat1] = "column_alias_list_repeat1",
  [aux_sym_pivot_operator_repeat1] = "pivot_operator_repeat1",
  [aux_sym_pivot_operator_repeat2] = "pivot_operator_repeat2",
  [aux_sym_single_column_unpivot_repeat1] = "single_column_unpivot_repeat1",
  [aux_sym_multi_column_unpivot_repeat1] = "multi_column_unpivot_repeat1",
  [aux_sym_declare_statement_repeat1] = "declare_statement_repeat1",
  [aux_sym_using_clause_repeat1] = "using_clause_repeat1",
  [aux_sym_call_statement_repeat1] = "call_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_order_by_items_repeat1] = "order_by_items_repeat1",
  [aux_sym_list_repeat1] = "list_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym__type_struct_repeat1] = "_type_struct_repeat1",
  [aux_sym_struct_repeat1] = "struct_repeat1",
  [aux_sym_identifier_repeat1] = "identifier_repeat1",
  [alias_sym_alias] = "alias",
  [alias_sym_between_from] = "between_from",
  [alias_sym_call_reference] = "call_reference",
  [alias_sym_case_end] = "case_end",
  [alias_sym_cte_name] = "cte_name",
  [alias_sym_datetime_part] = "datetime_part",
  [alias_sym_default_expression] = "default_expression",
  [alias_sym_float] = "float",
  [alias_sym_having_expression] = "having_expression",
  [alias_sym_input_column] = "input_column",
  [alias_sym_integer] = "integer",
  [alias_sym_name_column] = "name_column",
  [alias_sym_pivot_column] = "pivot_column",
  [alias_sym_unpivot_value] = "unpivot_value",
  [alias_sym_using_operator] = "using_operator",
  [alias_sym_variable_type] = "variable_type",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__unquoted_identifier] = sym__unquoted_identifier,
  [aux_sym_keyword_select_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_replace_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_into_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_values_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_set_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_from_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_left_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_format_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_extract_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_right_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_inner_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_outer_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_cross_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_unnest_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_join_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_on_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_recursive_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_call_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_where_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_order_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_group_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_partition_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_by_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_having_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_escape_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_desc_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_asc_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_limit_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_offset_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_table_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_view_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_materialized_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_as_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_distinct_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_cast_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_safe_cast_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_max_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_min_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_case_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_when_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_then_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_else_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_end_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_substring_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_in_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_and_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_or_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_is_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_not_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_asymmetric_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_symmetric_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_using_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_for_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_bytes_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_if_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_exists_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_at_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_zone_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_default_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_with_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_no_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_to_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_schema_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_union_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_all_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_except_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_intersect_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_begin_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_commit_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_rollback_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_transaction_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_over_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_nulls_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_first_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_last_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_window_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_system_time_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_of_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_range_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_rows_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_between_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_unbounded_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_preceding_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_following_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_exclude_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_current_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_row_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_ties_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_others_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_like_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_like_token2] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_similar_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_within_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_filter_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_respect_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_trim_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_leading_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_trailing_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_both_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_ignore_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_privileges_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_external_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_declare_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_execute_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_immediate_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_exception_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_error_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_elseif_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_loop_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_until_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_repeat_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_while_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_do_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_break_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_leave_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_continue_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_iterate_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_message_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_raise_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_assert_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_struct_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_value_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_array_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_any_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_some_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_current_date_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_current_time_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_current_timestamp_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_system_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_tablesample_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_percent_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_pivot_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_qualify_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_include_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_unpivot_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_full_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_null_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_true_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_false_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_boolean_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_boolean_token2] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_smallserial_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_smallserial_token2] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_serial_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_serial_token2] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_bigserial_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_bigserial_token2] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_int_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_int_token2] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_int_token3] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_int_token4] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_int_token5] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_int_token6] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_int_token7] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_decimal_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_bigdecimal_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_numeric_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_bignumeric_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_real_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_real_token2] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_float_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_float_token2] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_money_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_string_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_char_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_char_token2] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_varchar_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_varchar_token2] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_text_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_uuid_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_json_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_jsonb_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_xml_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_bytea_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_interval_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_time_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_date_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_datetime_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_timestamp_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_timestamp_token2] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_timestamptz_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_geometry_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_geography_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_box2d_token1] = aux_sym_keyword_select_token1,
  [aux_sym_keyword_box3d_token1] = aux_sym_keyword_select_token1,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_comment] = sym_comment,
  [sym_comma] = sym_comma,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [sym_left_paren] = sym_left_paren,
  [sym_right_paren] = sym_right_paren,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [aux_sym_parameter_token1] = aux_sym_parameter_token1,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym_system_variable] = sym_system_variable,
  [sym__named_query_parameter] = sym__named_query_parameter,
  [sym__positional_query_parameter] = sym__positional_query_parameter,
  [sym_hex] = sym_hex,
  [sym__integer] = sym__integer,
  [aux_sym__float_token1] = aux_sym__float_token1,
  [aux_sym__float_token2] = aux_sym__float_token2,
  [aux_sym__float_token3] = aux_sym__float_token3,
  [sym__quoted_identifier] = sym__quoted_identifier,
  [sym__string_start] = sym__string_start,
  [sym__string_content] = sym__string_content,
  [sym__string_end] = sym__string_end,
  [sym_program] = sym_program,
  [sym_keyword_select] = sym_keyword_select,
  [sym_keyword_replace] = sym_keyword_replace,
  [sym_keyword_into] = sym_keyword_into,
  [sym_keyword_set] = sym_keyword_set,
  [sym_keyword_from] = sym_keyword_from,
  [sym_keyword_left] = sym_keyword_left,
  [sym_keyword_format] = sym_keyword_format,
  [sym_keyword_extract] = sym_identifier,
  [sym_keyword_right] = sym_keyword_right,
  [sym_keyword_inner] = sym_keyword_inner,
  [sym_keyword_outer] = sym_keyword_outer,
  [sym_keyword_cross] = sym_keyword_cross,
  [sym_keyword_unnest] = sym_keyword_unnest,
  [sym_keyword_join] = sym_keyword_join,
  [sym_keyword_on] = sym_keyword_on,
  [sym_keyword_recursive] = sym_keyword_recursive,
  [sym_keyword_call] = sym_keyword_call,
  [sym_keyword_where] = sym_keyword_where,
  [sym_keyword_order] = sym_keyword_order,
  [sym_keyword_group] = sym_keyword_group,
  [sym_keyword_partition] = sym_keyword_partition,
  [sym_keyword_by] = sym_keyword_by,
  [sym_keyword_having] = sym_keyword_having,
  [sym_keyword_escape] = sym_keyword_escape,
  [sym_keyword_desc] = sym_keyword_desc,
  [sym_keyword_asc] = sym_keyword_asc,
  [sym_keyword_limit] = sym_keyword_limit,
  [sym_keyword_offset] = sym_keyword_offset,
  [sym_keyword_materialized] = sym_keyword_materialized,
  [sym_keyword_as] = sym_keyword_as,
  [sym_keyword_distinct] = sym_keyword_distinct,
  [sym_keyword_cast] = sym_identifier,
  [sym_keyword_safe_cast] = sym_identifier,
  [sym_keyword_max] = sym_keyword_max,
  [sym_keyword_min] = sym_keyword_min,
  [sym_keyword_case] = sym_keyword_case,
  [sym_keyword_when] = sym_keyword_when,
  [sym_keyword_then] = sym_keyword_then,
  [sym_keyword_else] = sym_keyword_else,
  [sym_keyword_end] = sym_keyword_end,
  [sym_keyword_substring] = sym_identifier,
  [sym_keyword_in] = sym_keyword_in,
  [sym_keyword_and] = sym_keyword_and,
  [sym_keyword_or] = sym_keyword_or,
  [sym_keyword_is] = sym_keyword_is,
  [sym_keyword_not] = sym_keyword_not,
  [sym_keyword_asymmetric] = sym_keyword_asymmetric,
  [sym_keyword_symmetric] = sym_keyword_symmetric,
  [sym_keyword_using] = sym_keyword_using,
  [sym_keyword_for] = sym_keyword_for,
  [sym_keyword_bytes] = sym_keyword_bytes,
  [sym_keyword_if] = sym_keyword_if,
  [sym_keyword_exists] = sym_keyword_exists,
  [sym_keyword_at] = sym_keyword_at,
  [sym_keyword_zone] = sym_keyword_zone,
  [sym_keyword_default] = sym_keyword_default,
  [sym_keyword_with] = sym_keyword_with,
  [sym_keyword_no] = sym_keyword_no,
  [sym_keyword_to] = sym_keyword_to,
  [sym_keyword_union] = sym_keyword_union,
  [sym_keyword_all] = sym_keyword_all,
  [sym_keyword_except] = sym_keyword_except,
  [sym_keyword_intersect] = sym_keyword_intersect,
  [sym_keyword_begin] = sym_keyword_begin,
  [sym_keyword_commit] = sym_keyword_commit,
  [sym_keyword_rollback] = sym_keyword_rollback,
  [sym_keyword_transaction] = sym_keyword_transaction,
  [sym_keyword_over] = sym_keyword_over,
  [sym_keyword_nulls] = sym_keyword_nulls,
  [sym_keyword_first] = sym_keyword_first,
  [sym_keyword_last] = sym_keyword_last,
  [sym_keyword_window] = sym_keyword_window,
  [sym_keyword_system_time] = sym_keyword_system_time,
  [sym_keyword_of] = sym_keyword_of,
  [sym_keyword_range] = sym_keyword_range,
  [sym_keyword_rows] = sym_keyword_rows,
  [sym_keyword_between] = sym_keyword_between,
  [sym_keyword_unbounded] = sym_keyword_unbounded,
  [sym_keyword_preceding] = sym_keyword_preceding,
  [sym_keyword_following] = sym_keyword_following,
  [sym_keyword_exclude] = sym_keyword_exclude,
  [sym_keyword_current] = sym_keyword_current,
  [sym_keyword_row] = sym_keyword_row,
  [sym_keyword_ties] = sym_keyword_ties,
  [sym_keyword_others] = sym_keyword_others,
  [sym_keyword_like] = sym_keyword_like,
  [sym_keyword_similar] = sym_keyword_similar,
  [sym_keyword_within] = sym_keyword_within,
  [sym_keyword_filter] = sym_keyword_filter,
  [sym_keyword_respect] = sym_keyword_respect,
  [sym_keyword_trim] = sym_identifier,
  [sym_keyword_leading] = sym_keyword_leading,
  [sym_keyword_trailing] = sym_keyword_trailing,
  [sym_keyword_both] = sym_keyword_both,
  [sym_keyword_ignore] = sym_keyword_ignore,
  [sym_keyword_declare] = sym_keyword_declare,
  [sym_keyword_execute] = sym_keyword_execute,
  [sym_keyword_immediate] = sym_keyword_immediate,
  [sym_keyword_exception] = sym_keyword_exception,
  [sym_keyword_error] = sym_keyword_error,
  [sym_keyword_elseif] = sym_keyword_elseif,
  [sym_keyword_loop] = sym_keyword_loop,
  [sym_keyword_until] = sym_keyword_until,
  [sym_keyword_repeat] = sym_keyword_repeat,
  [sym_keyword_while] = sym_keyword_while,
  [sym_keyword_do] = sym_keyword_do,
  [sym_keyword_break] = sym_keyword_break,
  [sym_keyword_leave] = sym_keyword_leave,
  [sym_keyword_continue] = sym_keyword_continue,
  [sym_keyword_iterate] = sym_keyword_iterate,
  [sym_keyword_message] = sym_keyword_message,
  [sym_keyword_raise] = sym_keyword_raise,
  [sym_keyword_assert] = sym_keyword_assert,
  [sym_keyword_struct] = sym_keyword_struct,
  [sym_keyword_value] = sym_keyword_value,
  [sym_keyword_array] = sym_keyword_array,
  [sym_keyword_any] = sym_keyword_any,
  [sym_keyword_some] = sym_keyword_some,
  [sym_keyword_current_date] = sym_keyword_current_date,
  [sym_keyword_current_time] = sym_keyword_current_time,
  [sym_keyword_current_timestamp] = sym_keyword_current_timestamp,
  [sym_keyword_system] = sym_keyword_system,
  [sym_keyword_tablesample] = sym_keyword_tablesample,
  [sym_keyword_percent] = sym_keyword_percent,
  [sym_keyword_pivot] = sym_keyword_pivot,
  [sym_keyword_qualify] = sym_keyword_qualify,
  [sym_keyword_include] = sym_keyword_include,
  [sym_keyword_unpivot] = sym_keyword_unpivot,
  [sym_keyword_full] = sym_keyword_full,
  [sym_keyword_null] = sym_keyword_null,
  [sym_keyword_true] = sym_keyword_true,
  [sym_keyword_false] = sym_keyword_false,
  [sym_keyword_boolean] = sym_keyword_boolean,
  [sym_keyword_smallserial] = sym_keyword_smallserial,
  [sym_keyword_serial] = sym_keyword_serial,
  [sym_keyword_bigserial] = sym_keyword_bigserial,
  [sym_keyword_int] = sym_keyword_int,
  [sym_keyword_decimal] = sym_keyword_decimal,
  [sym_keyword_bigdecimal] = sym_keyword_bigdecimal,
  [sym_keyword_numeric] = sym_keyword_numeric,
  [sym_keyword_bignumeric] = sym_keyword_bignumeric,
  [sym_keyword_real] = sym_keyword_real,
  [sym_keyword_float] = sym_keyword_float,
  [sym_keyword_money] = sym_keyword_money,
  [sym_keyword_string] = sym_keyword_string,
  [sym_keyword_char] = sym_keyword_char,
  [sym_keyword_varchar] = sym_keyword_varchar,
  [sym_keyword_text] = sym_keyword_text,
  [sym_keyword_uuid] = sym_keyword_uuid,
  [sym_keyword_json] = sym_keyword_json,
  [sym_keyword_jsonb] = sym_keyword_jsonb,
  [sym_keyword_xml] = sym_keyword_xml,
  [sym_keyword_bytea] = sym_keyword_bytea,
  [sym_keyword_interval] = sym_keyword_interval,
  [sym_keyword_time] = sym_keyword_time,
  [sym_keyword_date] = sym_keyword_date,
  [sym_keyword_datetime] = sym_keyword_datetime,
  [sym_keyword_timestamp] = sym_keyword_timestamp,
  [sym_keyword_timestamptz] = sym_keyword_timestamptz,
  [sym_keyword_geometry] = sym_keyword_geometry,
  [sym_keyword_geography] = sym_keyword_geography,
  [sym_keyword_box2d] = sym_keyword_box2d,
  [sym_keyword_box3d] = sym_keyword_box3d,
  [sym_wildcard] = sym_wildcard,
  [sym__time_types] = sym__time_types,
  [sym__type] = sym__type,
  [sym_numeric] = sym_numeric,
  [sym_statement] = sym_statement,
  [aux_sym__statement_list] = aux_sym__statement_list,
  [sym__argument] = sym__argument,
  [sym__select_wildcard] = sym__select_wildcard,
  [sym__distinct_on] = sym__distinct_on,
  [sym_select] = sym_select,
  [sym_select_clause] = sym_select_clause,
  [sym_select_field] = sym_select_field,
  [sym_select_expression] = sym_select_expression,
  [sym_select_statement] = sym_select_statement,
  [sym_set_operation] = sym_set_operation,
  [sym_cte_clause] = sym_cte_clause,
  [sym_cte] = sym_cte,
  [sym_transaction] = sym_transaction,
  [sym__begin] = sym__begin,
  [sym__commit] = sym__commit,
  [sym__rollback] = sym__rollback,
  [sym_date] = sym_date,
  [sym_expression_list] = sym_expression_list,
  [sym__expression_list_item] = sym__expression_list_item,
  [sym_reference] = sym_reference,
  [sym__column_list_without_order] = sym__column_list_without_order,
  [sym__column_without_order] = sym__column_without_order,
  [sym_direction] = sym_direction,
  [sym__select_wildcard_except] = sym__select_wildcard_except,
  [sym__select_wildcard_replace] = sym__select_wildcard_replace,
  [sym_select_replace_expression] = sym_select_replace_expression,
  [sym_parameter] = sym_parameter,
  [sym_case] = sym_case,
  [sym_when_clause] = sym_when_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_field] = sym_field,
  [sym__format_string_expression] = sym__format_string_expression,
  [sym__cast_with_format] = sym__cast_with_format,
  [sym_cast] = sym_cast,
  [sym_substring] = sym_substring,
  [sym_quantified_comparison] = sym_quantified_comparison,
  [sym_trim] = sym_trim,
  [sym_invocation] = sym_invocation,
  [sym__extract_invocation] = sym__extract_invocation,
  [sym__array_invocation] = sym__array_invocation,
  [sym_within_group] = sym_within_group,
  [sym_filter] = sym_filter,
  [sym_partition_by] = sym_partition_by,
  [sym_window_clause] = sym_window_clause,
  [sym_window_specification] = sym_window_specification,
  [sym_window_function] = sym_window_function,
  [sym_window_frame] = sym_window_frame,
  [sym_rows_range] = sym_rows_range,
  [sym_window_numeric_preceding] = sym_window_numeric_preceding,
  [sym_window_numeric_following] = sym_window_numeric_following,
  [sym__window_frame_start] = sym__window_frame_start,
  [sym__window_frame_end] = sym__window_frame_end,
  [sym_window_frame_between] = sym_window_frame_between,
  [sym__frame_exclusion] = sym__frame_exclusion,
  [sym__invocation_params] = sym__invocation_params,
  [sym_having_max_clause] = sym_having_max_clause,
  [sym_having_min_clause] = sym_having_min_clause,
  [sym_unnest_operator] = sym_unnest_operator,
  [sym_unnest_withoffset] = sym_unnest_withoffset,
  [sym_unnest_clause] = sym_unnest_clause,
  [sym_column_alias_list] = sym_column_alias_list,
  [sym__alias] = sym__alias,
  [sym__from_item] = sym__from_item,
  [sym_from_clause] = sym_from_clause,
  [sym_tablesample_operator] = sym_tablesample_operator,
  [sym_pivot_value] = sym_pivot_value,
  [sym_pivot_operator] = sym_pivot_operator,
  [sym_unpivot_operator] = sym_unpivot_operator,
  [sym_single_column_unpivot] = sym_single_column_unpivot,
  [sym_multi_column_unpivot] = sym_multi_column_unpivot,
  [sym_unpivot_column] = sym_unpivot_column,
  [sym_join] = sym_join,
  [sym__cross_join_operation] = sym__cross_join_operation,
  [sym_join_prefix] = sym_join_prefix,
  [sym__conditional_join_operator] = sym__conditional_join_operator,
  [sym_join_type] = sym_join_type,
  [sym_join_condition] = sym_join_condition,
  [sym_declare_statement] = sym_declare_statement,
  [sym_set_statement] = sym_set_statement,
  [sym_execute_immadiate_statement] = sym_execute_immadiate_statement,
  [sym_into_clause] = sym_into_clause,
  [sym_using_clause] = sym_using_clause,
  [sym_argument] = sym_argument,
  [sym_call_statement] = sym_call_statement,
  [sym_begin_end_statement] = sym_begin_end_statement,
  [sym_begin_exception_end_statement] = sym_begin_exception_end_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_loop_statement] = sym_loop_statement,
  [sym_repeat_statement] = sym_repeat_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_leave_statement] = sym_leave_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_iterate_statement] = sym_iterate_statement,
  [sym_raise_statement] = sym_raise_statement,
  [sym_assert_statement] = sym_assert_statement,
  [sym_relation] = sym_relation,
  [sym_where_clause] = sym_where_clause,
  [sym_group_by_clause] = sym_group_by_clause,
  [sym_having_clause] = sym_having_clause,
  [sym_qualify_clause] = sym_qualify_clause,
  [sym_order_by_item] = sym_order_by_item,
  [sym_order_by_items] = sym_order_by_items,
  [sym_order_by_clause] = sym_order_by_clause,
  [sym_limit_clause] = sym_limit_clause,
  [sym_offset] = sym_offset,
  [sym_between] = sym_between,
  [sym_interval] = sym_interval,
  [sym__expression] = sym__expression,
  [sym_predicate] = sym_predicate,
  [sym_binary_expression] = sym_binary_expression,
  [sym__parenthesized_expression] = sym__parenthesized_expression,
  [sym_field_access] = sym_field_access,
  [sym_element_access] = sym_element_access,
  [sym_subquery] = sym_subquery,
  [sym_list] = sym_list,
  [sym_query_parameter] = sym_query_parameter,
  [sym_literal] = sym_literal,
  [sym_json] = sym_json,
  [sym__number] = sym__number,
  [sym__float] = sym__float,
  [sym__float_or_integer] = sym__float_or_integer,
  [sym_string] = sym_string,
  [sym_number] = sym_number,
  [sym__base_type] = sym__base_type,
  [sym__bqtype] = sym__bqtype,
  [sym__type_struct] = sym__type_struct,
  [sym__type_array] = sym__type_array,
  [sym_array] = sym_array,
  [sym_struct] = sym_struct,
  [sym_current_date] = sym_current_date,
  [sym_current_time] = sym_current_time,
  [sym_current_timestamp] = sym_current_timestamp,
  [sym__aliasable_expression] = sym__aliasable_expression,
  [sym__identifier] = sym__identifier,
  [sym__dotted_identifier] = sym__dotted_identifier,
  [sym_identifier] = sym_identifier,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym__distinct_on_repeat1] = aux_sym__distinct_on_repeat1,
  [aux_sym_select_expression_repeat1] = aux_sym_select_expression_repeat1,
  [aux_sym_cte_clause_repeat1] = aux_sym_cte_clause_repeat1,
  [aux_sym_transaction_repeat1] = aux_sym_transaction_repeat1,
  [aux_sym_expression_list_repeat1] = aux_sym_expression_list_repeat1,
  [aux_sym__column_list_without_order_repeat1] = aux_sym__column_list_without_order_repeat1,
  [aux_sym__select_wildcard_except_repeat1] = aux_sym__select_wildcard_except_repeat1,
  [aux_sym__select_wildcard_replace_repeat1] = aux_sym__select_wildcard_replace_repeat1,
  [aux_sym_case_repeat1] = aux_sym_case_repeat1,
  [aux_sym_window_clause_repeat1] = aux_sym_window_clause_repeat1,
  [aux_sym__invocation_params_repeat1] = aux_sym__invocation_params_repeat1,
  [aux_sym_column_alias_list_repeat1] = aux_sym_column_alias_list_repeat1,
  [aux_sym_pivot_operator_repeat1] = aux_sym_pivot_operator_repeat1,
  [aux_sym_pivot_operator_repeat2] = aux_sym_pivot_operator_repeat2,
  [aux_sym_single_column_unpivot_repeat1] = aux_sym_single_column_unpivot_repeat1,
  [aux_sym_multi_column_unpivot_repeat1] = aux_sym_multi_column_unpivot_repeat1,
  [aux_sym_declare_statement_repeat1] = aux_sym_declare_statement_repeat1,
  [aux_sym_using_clause_repeat1] = aux_sym_using_clause_repeat1,
  [aux_sym_call_statement_repeat1] = aux_sym_call_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_order_by_items_repeat1] = aux_sym_order_by_items_repeat1,
  [aux_sym_list_repeat1] = aux_sym_list_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym__type_struct_repeat1] = aux_sym__type_struct_repeat1,
  [aux_sym_struct_repeat1] = aux_sym_struct_repeat1,
  [aux_sym_identifier_repeat1] = aux_sym_identifier_repeat1,
  [alias_sym_alias] = alias_sym_alias,
  [alias_sym_between_from] = alias_sym_between_from,
  [alias_sym_call_reference] = alias_sym_call_reference,
  [alias_sym_case_end] = alias_sym_case_end,
  [alias_sym_cte_name] = alias_sym_cte_name,
  [alias_sym_datetime_part] = alias_sym_datetime_part,
  [alias_sym_default_expression] = alias_sym_default_expression,
  [alias_sym_float] = alias_sym_float,
  [alias_sym_having_expression] = alias_sym_having_expression,
  [alias_sym_input_column] = alias_sym_input_column,
  [alias_sym_integer] = alias_sym_integer,
  [alias_sym_name_column] = alias_sym_name_column,
  [alias_sym_pivot_column] = alias_sym_pivot_column,
  [alias_sym_unpivot_value] = alias_sym_unpivot_value,
  [alias_sym_using_operator] = alias_sym_using_operator,
  [alias_sym_variable_type] = alias_sym_variable_type,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__unquoted_identifier] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_keyword_select_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_replace_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_into_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_values_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_set_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_from_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_left_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_format_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_extract_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_right_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_inner_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_outer_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_cross_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_unnest_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_join_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_on_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_recursive_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_call_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_where_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_order_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_group_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_partition_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_by_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_having_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_escape_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_desc_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_asc_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_limit_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_offset_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_table_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_view_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_materialized_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_as_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_distinct_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_cast_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_safe_cast_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_max_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_min_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_case_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_when_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_then_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_else_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_end_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_substring_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_in_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_and_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_or_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_is_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_not_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_asymmetric_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_symmetric_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_using_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_for_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_bytes_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_if_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_exists_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_at_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_zone_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_default_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_with_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_no_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_to_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_schema_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_union_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_all_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_except_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_intersect_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_begin_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_commit_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_rollback_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_transaction_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_over_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_nulls_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_first_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_last_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_window_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_system_time_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_of_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_range_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_rows_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_between_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_unbounded_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_preceding_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_following_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_exclude_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_current_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_row_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_ties_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_others_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_like_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_like_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_similar_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_within_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_filter_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_respect_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_trim_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_leading_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_trailing_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_both_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_ignore_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_privileges_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_external_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_declare_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_execute_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_immediate_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_exception_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_error_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_elseif_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_loop_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_until_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_repeat_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_while_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_do_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_break_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_leave_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_continue_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_iterate_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_message_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_raise_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_assert_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_struct_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_value_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_array_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_any_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_some_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_current_date_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_current_time_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_current_timestamp_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_system_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_tablesample_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_percent_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_pivot_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_qualify_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_include_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_unpivot_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_full_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_null_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_true_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_false_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_boolean_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_boolean_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_smallserial_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_smallserial_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_serial_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_serial_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_bigserial_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_bigserial_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_int_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_int_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_int_token3] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_int_token4] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_int_token5] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_int_token6] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_int_token7] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_decimal_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_bigdecimal_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_numeric_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_bignumeric_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_real_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_real_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_float_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_float_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_money_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_string_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_char_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_char_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_varchar_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_varchar_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_text_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_uuid_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_json_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_jsonb_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_xml_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_bytea_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_interval_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_time_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_date_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_datetime_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_timestamp_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_timestamp_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_timestamptz_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_geometry_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_geography_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_box2d_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_box3d_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comma] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_left_paren] = {
    .visible = true,
    .named = true,
  },
  [sym_right_paren] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_parameter_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_system_variable] = {
    .visible = true,
    .named = true,
  },
  [sym__named_query_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym__positional_query_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_hex] = {
    .visible = true,
    .named = true,
  },
  [sym__integer] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__float_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__float_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__float_token3] = {
    .visible = false,
    .named = false,
  },
  [sym__quoted_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__string_start] = {
    .visible = false,
    .named = true,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym__string_end] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_select] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_replace] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_into] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_set] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_from] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_left] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_format] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_extract] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_right] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_inner] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_outer] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_cross] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_unnest] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_join] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_on] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_recursive] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_call] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_where] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_order] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_group] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_partition] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_by] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_having] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_desc] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_asc] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_limit] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_offset] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_materialized] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_as] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_distinct] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_safe_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_max] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_min] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_case] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_when] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_then] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_else] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_end] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_substring] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_in] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_and] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_or] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_is] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_not] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_asymmetric] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_symmetric] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_using] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_for] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_bytes] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_if] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_exists] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_at] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_zone] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_default] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_with] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_no] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_to] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_union] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_all] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_except] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_intersect] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_begin] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_commit] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_rollback] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_transaction] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_over] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_nulls] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_first] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_last] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_window] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_system_time] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_of] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_range] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_rows] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_between] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_unbounded] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_preceding] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_following] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_exclude] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_current] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_row] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_ties] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_others] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_like] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_similar] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_within] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_filter] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_respect] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_trim] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_leading] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_trailing] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_both] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_ignore] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_declare] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_execute] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_immediate] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_exception] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_error] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_elseif] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_until] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_repeat] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_while] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_do] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_break] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_leave] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_continue] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_iterate] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_message] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_raise] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_struct] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_value] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_array] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_any] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_some] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_current_date] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_current_time] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_current_timestamp] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_system] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_tablesample] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_percent] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_pivot] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_qualify] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_include] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_unpivot] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_full] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_null] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_true] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_false] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_smallserial] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_serial] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_bigserial] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_int] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_decimal] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_bigdecimal] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_numeric] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_bignumeric] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_real] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_float] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_money] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_string] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_char] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_varchar] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_text] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_uuid] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_json] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_jsonb] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_xml] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_bytea] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_interval] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_time] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_date] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_datetime] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_timestamp] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_timestamptz] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_geometry] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_geography] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_box2d] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_box3d] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard] = {
    .visible = true,
    .named = true,
  },
  [sym__time_types] = {
    .visible = false,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym_numeric] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__statement_list] = {
    .visible = false,
    .named = false,
  },
  [sym__argument] = {
    .visible = false,
    .named = true,
  },
  [sym__select_wildcard] = {
    .visible = false,
    .named = true,
  },
  [sym__distinct_on] = {
    .visible = false,
    .named = true,
  },
  [sym_select] = {
    .visible = true,
    .named = true,
  },
  [sym_select_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_select_field] = {
    .visible = true,
    .named = true,
  },
  [sym_select_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_select_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_set_operation] = {
    .visible = true,
    .named = true,
  },
  [sym_cte_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_cte] = {
    .visible = true,
    .named = true,
  },
  [sym_transaction] = {
    .visible = true,
    .named = true,
  },
  [sym__begin] = {
    .visible = false,
    .named = true,
  },
  [sym__commit] = {
    .visible = false,
    .named = true,
  },
  [sym__rollback] = {
    .visible = false,
    .named = true,
  },
  [sym_date] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_list_item] = {
    .visible = false,
    .named = true,
  },
  [sym_reference] = {
    .visible = true,
    .named = true,
  },
  [sym__column_list_without_order] = {
    .visible = true,
    .named = true,
  },
  [sym__column_without_order] = {
    .visible = true,
    .named = true,
  },
  [sym_direction] = {
    .visible = true,
    .named = true,
  },
  [sym__select_wildcard_except] = {
    .visible = false,
    .named = true,
  },
  [sym__select_wildcard_replace] = {
    .visible = false,
    .named = true,
  },
  [sym_select_replace_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_when_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym__format_string_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__cast_with_format] = {
    .visible = false,
    .named = true,
  },
  [sym_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_substring] = {
    .visible = true,
    .named = true,
  },
  [sym_quantified_comparison] = {
    .visible = true,
    .named = true,
  },
  [sym_trim] = {
    .visible = true,
    .named = true,
  },
  [sym_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym__extract_invocation] = {
    .visible = false,
    .named = true,
  },
  [sym__array_invocation] = {
    .visible = false,
    .named = true,
  },
  [sym_within_group] = {
    .visible = true,
    .named = true,
  },
  [sym_filter] = {
    .visible = true,
    .named = true,
  },
  [sym_partition_by] = {
    .visible = true,
    .named = true,
  },
  [sym_window_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_window_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_window_function] = {
    .visible = true,
    .named = true,
  },
  [sym_window_frame] = {
    .visible = true,
    .named = true,
  },
  [sym_rows_range] = {
    .visible = true,
    .named = true,
  },
  [sym_window_numeric_preceding] = {
    .visible = true,
    .named = true,
  },
  [sym_window_numeric_following] = {
    .visible = true,
    .named = true,
  },
  [sym__window_frame_start] = {
    .visible = false,
    .named = true,
  },
  [sym__window_frame_end] = {
    .visible = true,
    .named = true,
  },
  [sym_window_frame_between] = {
    .visible = true,
    .named = true,
  },
  [sym__frame_exclusion] = {
    .visible = false,
    .named = true,
  },
  [sym__invocation_params] = {
    .visible = false,
    .named = true,
  },
  [sym_having_max_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_having_min_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_unnest_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unnest_withoffset] = {
    .visible = true,
    .named = true,
  },
  [sym_unnest_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_column_alias_list] = {
    .visible = true,
    .named = true,
  },
  [sym__alias] = {
    .visible = false,
    .named = true,
  },
  [sym__from_item] = {
    .visible = false,
    .named = true,
  },
  [sym_from_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_tablesample_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_pivot_value] = {
    .visible = true,
    .named = true,
  },
  [sym_pivot_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unpivot_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_single_column_unpivot] = {
    .visible = true,
    .named = true,
  },
  [sym_multi_column_unpivot] = {
    .visible = true,
    .named = true,
  },
  [sym_unpivot_column] = {
    .visible = true,
    .named = true,
  },
  [sym_join] = {
    .visible = true,
    .named = true,
  },
  [sym__cross_join_operation] = {
    .visible = false,
    .named = true,
  },
  [sym_join_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym__conditional_join_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_join_type] = {
    .visible = true,
    .named = true,
  },
  [sym_join_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_declare_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_set_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_execute_immadiate_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_into_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_using_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_call_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_begin_end_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_begin_exception_end_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_loop_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_leave_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_iterate_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_raise_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_relation] = {
    .visible = true,
    .named = true,
  },
  [sym_where_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_group_by_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_having_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_qualify_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_order_by_item] = {
    .visible = true,
    .named = true,
  },
  [sym_order_by_items] = {
    .visible = true,
    .named = true,
  },
  [sym_order_by_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_limit_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_offset] = {
    .visible = true,
    .named = true,
  },
  [sym_between] = {
    .visible = true,
    .named = true,
  },
  [sym_interval] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__parenthesized_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym_element_access] = {
    .visible = true,
    .named = true,
  },
  [sym_subquery] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_query_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_json] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = false,
    .named = true,
  },
  [sym__float] = {
    .visible = false,
    .named = true,
  },
  [sym__float_or_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym__base_type] = {
    .visible = false,
    .named = true,
  },
  [sym__bqtype] = {
    .visible = false,
    .named = true,
  },
  [sym__type_struct] = {
    .visible = false,
    .named = true,
  },
  [sym__type_array] = {
    .visible = false,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_struct] = {
    .visible = true,
    .named = true,
  },
  [sym_current_date] = {
    .visible = true,
    .named = true,
  },
  [sym_current_time] = {
    .visible = true,
    .named = true,
  },
  [sym_current_timestamp] = {
    .visible = true,
    .named = true,
  },
  [sym__aliasable_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__dotted_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__distinct_on_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_select_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cte_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_transaction_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__column_list_without_order_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__select_wildcard_except_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__select_wildcard_replace_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_window_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__invocation_params_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_column_alias_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pivot_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pivot_operator_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_single_column_unpivot_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_multi_column_unpivot_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declare_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_using_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_call_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_order_by_items_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_struct_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_alias] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_between_from] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_call_reference] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_case_end] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_cte_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_datetime_part] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_default_expression] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_float] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_having_expression] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_input_column] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_integer] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_name_column] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pivot_column] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_unpivot_value] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_using_operator] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_variable_type] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_argument = 2,
  field_else_result = 3,
  field_except_key = 4,
  field_expr = 5,
  field_function = 6,
  field_keyword = 7,
  field_left = 8,
  field_length = 9,
  field_match_condition = 10,
  field_match_result = 11,
  field_name = 12,
  field_operator = 13,
  field_parameter = 14,
  field_right = 15,
  field_sample_rate = 16,
  field_schema = 17,
  field_start = 18,
  field_table_alias = 19,
  field_value = 20,
  field_variable_type = 21,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_argument] = "argument",
  [field_else_result] = "else_result",
  [field_except_key] = "except_key",
  [field_expr] = "expr",
  [field_function] = "function",
  [field_keyword] = "keyword",
  [field_left] = "left",
  [field_length] = "length",
  [field_match_condition] = "match_condition",
  [field_match_result] = "match_result",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_right] = "right",
  [field_sample_rate] = "sample_rate",
  [field_schema] = "schema",
  [field_start] = "start",
  [field_table_alias] = "table_alias",
  [field_value] = "value",
  [field_variable_type] = "variable_type",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 1},
  [7] = {.index = 4, .length = 1},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 1},
  [11] = {.index = 8, .length = 1},
  [12] = {.index = 9, .length = 1},
  [13] = {.index = 10, .length = 1},
  [18] = {.index = 11, .length = 3},
  [19] = {.index = 14, .length = 2},
  [20] = {.index = 16, .length = 2},
  [23] = {.index = 18, .length = 1},
  [24] = {.index = 19, .length = 2},
  [25] = {.index = 21, .length = 1},
  [26] = {.index = 22, .length = 1},
  [28] = {.index = 23, .length = 2},
  [29] = {.index = 25, .length = 4},
  [30] = {.index = 29, .length = 4},
  [31] = {.index = 33, .length = 3},
  [32] = {.index = 36, .length = 1},
  [33] = {.index = 8, .length = 1},
  [35] = {.index = 37, .length = 2},
  [36] = {.index = 21, .length = 1},
  [37] = {.index = 39, .length = 2},
  [39] = {.index = 41, .length = 1},
  [41] = {.index = 42, .length = 5},
  [42] = {.index = 47, .length = 3},
  [43] = {.index = 50, .length = 2},
  [44] = {.index = 52, .length = 4},
  [45] = {.index = 56, .length = 1},
  [46] = {.index = 57, .length = 3},
  [47] = {.index = 60, .length = 1},
  [48] = {.index = 61, .length = 2},
  [49] = {.index = 63, .length = 2},
  [51] = {.index = 18, .length = 1},
  [54] = {.index = 7, .length = 1},
  [55] = {.index = 65, .length = 3},
  [56] = {.index = 68, .length = 3},
  [57] = {.index = 71, .length = 2},
  [58] = {.index = 73, .length = 3},
  [59] = {.index = 76, .length = 1},
  [60] = {.index = 77, .length = 2},
  [61] = {.index = 79, .length = 2},
  [62] = {.index = 81, .length = 6},
  [64] = {.index = 87, .length = 1},
  [65] = {.index = 88, .length = 3},
  [66] = {.index = 91, .length = 4},
  [68] = {.index = 95, .length = 1},
  [73] = {.index = 96, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_except_key, 0, .inherited = true},
  [1] =
    {field_function, 0, .inherited = true},
  [2] =
    {field_name, 0},
  [3] =
    {field_operator, 0},
  [4] =
    {field_except_key, 1, .inherited = true},
  [5] =
    {field_operator, 0},
    {field_value, 1},
  [7] =
    {field_function, 0},
  [8] =
    {field_variable_type, 2},
  [9] =
    {field_operator, 0, .inherited = true},
  [10] =
    {field_operator, 1},
  [11] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [14] =
    {field_keyword, 0, .inherited = true},
    {field_parameter, 0},
  [16] =
    {field_name, 2},
    {field_table_alias, 0},
  [18] =
    {field_variable_type, 3},
  [19] =
    {field_operator, 1},
    {field_operator, 2},
  [21] =
    {field_expr, 1},
  [22] =
    {field_else_result, 1},
  [23] =
    {field_name, 0},
    {field_parameter, 2},
  [25] =
    {field_left, 0},
    {field_operator, 1},
    {field_operator, 2},
    {field_right, 3},
  [29] =
    {field_keyword, 0, .inherited = true},
    {field_keyword, 1, .inherited = true},
    {field_parameter, 0},
    {field_parameter, 1, .inherited = true},
  [33] =
    {field_keyword, 2, .inherited = true},
    {field_name, 0},
    {field_parameter, 2, .inherited = true},
  [36] =
    {field_argument, 3},
  [37] =
    {field_match_condition, 1},
    {field_match_result, 3},
  [39] =
    {field_name, 0},
    {field_parameter, 3},
  [41] =
    {field_except_key, 2},
  [42] =
    {field_left, 0},
    {field_operator, 1},
    {field_operator, 2},
    {field_operator, 3},
    {field_right, 4},
  [47] =
    {field_keyword, 3, .inherited = true},
    {field_name, 0},
    {field_parameter, 3, .inherited = true},
  [50] =
    {field_keyword, 1, .inherited = true},
    {field_parameter, 1},
  [52] =
    {field_keyword, 0, .inherited = true},
    {field_keyword, 1, .inherited = true},
    {field_parameter, 0, .inherited = true},
    {field_parameter, 1, .inherited = true},
  [56] =
    {field_keyword, 0},
  [57] =
    {field_name, 4},
    {field_schema, 0},
    {field_table_alias, 2},
  [60] =
    {field_argument, 1},
  [61] =
    {field_argument, 3},
    {field_argument, 4, .inherited = true},
  [63] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [65] =
    {field_match_condition, 1},
    {field_match_condition, 2},
    {field_match_result, 4},
  [68] =
    {field_name, 0},
    {field_parameter, 2},
    {field_start, 4},
  [71] =
    {field_name, 0},
    {field_parameter, 4},
  [73] =
    {field_name, 0},
    {field_parameter, 2},
    {field_parameter, 4},
  [76] =
    {field_except_key, 1},
  [77] =
    {field_except_key, 2},
    {field_except_key, 3, .inherited = true},
  [79] =
    {field_except_key, 0, .inherited = true},
    {field_except_key, 1, .inherited = true},
  [81] =
    {field_left, 0},
    {field_operator, 1},
    {field_operator, 2},
    {field_operator, 3},
    {field_operator, 4},
    {field_right, 5},
  [87] =
    {field_name, 1, .inherited = true},
  [88] =
    {field_name, 0},
    {field_parameter, 3},
    {field_parameter, 5},
  [91] =
    {field_length, 6},
    {field_name, 0},
    {field_parameter, 2},
    {field_start, 4},
  [95] =
    {field_sample_rate, 3},
  [96] =
    {field_alias, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_integer,
  },
  [4] = {
    [0] = alias_sym_float,
  },
  [10] = {
    [0] = alias_sym_alias,
  },
  [11] = {
    [2] = alias_sym_variable_type,
  },
  [14] = {
    [2] = alias_sym_case_end,
  },
  [15] = {
    [2] = alias_sym_datetime_part,
  },
  [16] = {
    [1] = alias_sym_alias,
  },
  [17] = {
    [0] = sym_comma,
  },
  [21] = {
    [1] = alias_sym_call_reference,
  },
  [22] = {
    [3] = alias_sym_default_expression,
  },
  [23] = {
    [3] = alias_sym_variable_type,
  },
  [25] = {
    [3] = alias_sym_case_end,
  },
  [27] = {
    [3] = alias_sym_case_end,
  },
  [32] = {
    [1] = alias_sym_call_reference,
  },
  [33] = {
    [2] = alias_sym_variable_type,
    [4] = alias_sym_default_expression,
  },
  [34] = {
    [4] = alias_sym_default_expression,
  },
  [36] = {
    [4] = alias_sym_case_end,
  },
  [38] = {
    [2] = alias_sym_datetime_part,
    [4] = alias_sym_datetime_part,
  },
  [40] = {
    [0] = sym_comma,
    [1] = alias_sym_alias,
  },
  [43] = {
    [0] = sym_comma,
  },
  [47] = {
    [0] = sym_comma,
  },
  [48] = {
    [1] = alias_sym_call_reference,
  },
  [50] = {
    [0] = alias_sym_cte_name,
  },
  [51] = {
    [3] = alias_sym_variable_type,
    [5] = alias_sym_default_expression,
  },
  [52] = {
    [3] = sym_keyword_until,
  },
  [53] = {
    [2] = alias_sym_using_operator,
  },
  [54] = {
    [2] = alias_sym_datetime_part,
  },
  [59] = {
    [0] = sym_comma,
  },
  [63] = {
    [2] = alias_sym_having_expression,
  },
  [67] = {
    [1] = alias_sym_between_from,
  },
  [69] = {
    [0] = sym_comma,
    [1] = alias_sym_unpivot_value,
  },
  [70] = {
    [0] = alias_sym_unpivot_value,
    [2] = alias_sym_name_column,
  },
  [71] = {
    [0] = sym_comma,
    [1] = alias_sym_pivot_column,
  },
  [72] = {
    [4] = alias_sym_input_column,
    [7] = alias_sym_pivot_column,
  },
  [74] = {
    [5] = alias_sym_input_column,
    [8] = alias_sym_pivot_column,
  },
  [75] = {
    [1] = alias_sym_unpivot_value,
    [4] = alias_sym_name_column,
  },
  [76] = {
    [1] = alias_sym_unpivot_value,
    [5] = alias_sym_name_column,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_keyword_end, 2,
    sym_keyword_end,
    alias_sym_case_end,
  sym_reference, 2,
    sym_reference,
    alias_sym_call_reference,
  sym__window_frame_start, 2,
    sym__window_frame_start,
    alias_sym_between_from,
  sym__expression, 4,
    sym__expression,
    alias_sym_default_expression,
    alias_sym_having_expression,
    sym_keyword_until,
  sym__float, 2,
    sym__float,
    alias_sym_float,
  sym__bqtype, 2,
    sym__bqtype,
    alias_sym_variable_type,
  sym__aliasable_expression, 2,
    sym__aliasable_expression,
    alias_sym_pivot_column,
  sym__identifier, 2,
    sym__identifier,
    alias_sym_datetime_part,
  sym_identifier, 6,
    sym_identifier,
    alias_sym_alias,
    alias_sym_cte_name,
    alias_sym_input_column,
    alias_sym_name_column,
    alias_sym_unpivot_value,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 2,
  [5] = 2,
  [6] = 3,
  [7] = 2,
  [8] = 2,
  [9] = 2,
  [10] = 2,
  [11] = 2,
  [12] = 2,
  [13] = 2,
  [14] = 14,
  [15] = 2,
  [16] = 2,
  [17] = 2,
  [18] = 2,
  [19] = 2,
  [20] = 2,
  [21] = 2,
  [22] = 3,
  [23] = 23,
  [24] = 23,
  [25] = 23,
  [26] = 26,
  [27] = 23,
  [28] = 26,
  [29] = 23,
  [30] = 26,
  [31] = 23,
  [32] = 23,
  [33] = 23,
  [34] = 23,
  [35] = 23,
  [36] = 23,
  [37] = 23,
  [38] = 23,
  [39] = 23,
  [40] = 23,
  [41] = 41,
  [42] = 42,
  [43] = 41,
  [44] = 41,
  [45] = 42,
  [46] = 41,
  [47] = 41,
  [48] = 41,
  [49] = 41,
  [50] = 42,
  [51] = 41,
  [52] = 41,
  [53] = 41,
  [54] = 41,
  [55] = 41,
  [56] = 41,
  [57] = 41,
  [58] = 41,
  [59] = 59,
  [60] = 60,
  [61] = 60,
  [62] = 60,
  [63] = 63,
  [64] = 59,
  [65] = 59,
  [66] = 60,
  [67] = 59,
  [68] = 60,
  [69] = 59,
  [70] = 60,
  [71] = 60,
  [72] = 59,
  [73] = 59,
  [74] = 60,
  [75] = 59,
  [76] = 60,
  [77] = 60,
  [78] = 59,
  [79] = 60,
  [80] = 59,
  [81] = 59,
  [82] = 60,
  [83] = 59,
  [84] = 63,
  [85] = 59,
  [86] = 60,
  [87] = 63,
  [88] = 59,
  [89] = 60,
  [90] = 59,
  [91] = 60,
  [92] = 92,
  [93] = 92,
  [94] = 92,
  [95] = 92,
  [96] = 92,
  [97] = 92,
  [98] = 98,
  [99] = 92,
  [100] = 92,
  [101] = 92,
  [102] = 92,
  [103] = 92,
  [104] = 92,
  [105] = 92,
  [106] = 92,
  [107] = 92,
  [108] = 92,
  [109] = 92,
  [110] = 92,
  [111] = 92,
  [112] = 112,
  [113] = 113,
  [114] = 113,
  [115] = 113,
  [116] = 116,
  [117] = 117,
  [118] = 116,
  [119] = 116,
  [120] = 116,
  [121] = 116,
  [122] = 116,
  [123] = 116,
  [124] = 116,
  [125] = 125,
  [126] = 116,
  [127] = 116,
  [128] = 117,
  [129] = 116,
  [130] = 125,
  [131] = 125,
  [132] = 125,
  [133] = 117,
  [134] = 116,
  [135] = 116,
  [136] = 136,
  [137] = 116,
  [138] = 116,
  [139] = 125,
  [140] = 125,
  [141] = 125,
  [142] = 142,
  [143] = 143,
  [144] = 143,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 146,
  [149] = 149,
  [150] = 150,
  [151] = 149,
  [152] = 143,
  [153] = 146,
  [154] = 145,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 142,
  [159] = 156,
  [160] = 142,
  [161] = 149,
  [162] = 142,
  [163] = 156,
  [164] = 155,
  [165] = 165,
  [166] = 156,
  [167] = 142,
  [168] = 142,
  [169] = 155,
  [170] = 150,
  [171] = 155,
  [172] = 156,
  [173] = 143,
  [174] = 150,
  [175] = 155,
  [176] = 165,
  [177] = 177,
  [178] = 165,
  [179] = 150,
  [180] = 143,
  [181] = 150,
  [182] = 155,
  [183] = 156,
  [184] = 143,
  [185] = 142,
  [186] = 142,
  [187] = 156,
  [188] = 143,
  [189] = 156,
  [190] = 155,
  [191] = 142,
  [192] = 150,
  [193] = 165,
  [194] = 143,
  [195] = 145,
  [196] = 155,
  [197] = 155,
  [198] = 143,
  [199] = 150,
  [200] = 200,
  [201] = 142,
  [202] = 156,
  [203] = 142,
  [204] = 143,
  [205] = 155,
  [206] = 143,
  [207] = 156,
  [208] = 155,
  [209] = 143,
  [210] = 142,
  [211] = 142,
  [212] = 156,
  [213] = 142,
  [214] = 143,
  [215] = 155,
  [216] = 156,
  [217] = 155,
  [218] = 156,
  [219] = 156,
  [220] = 143,
  [221] = 142,
  [222] = 155,
  [223] = 155,
  [224] = 156,
  [225] = 143,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 227,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 250,
  [252] = 252,
  [253] = 248,
  [254] = 249,
  [255] = 245,
  [256] = 247,
  [257] = 257,
  [258] = 229,
  [259] = 226,
  [260] = 260,
  [261] = 244,
  [262] = 240,
  [263] = 238,
  [264] = 232,
  [265] = 265,
  [266] = 227,
  [267] = 236,
  [268] = 238,
  [269] = 239,
  [270] = 234,
  [271] = 244,
  [272] = 245,
  [273] = 248,
  [274] = 250,
  [275] = 249,
  [276] = 247,
  [277] = 240,
  [278] = 257,
  [279] = 234,
  [280] = 228,
  [281] = 233,
  [282] = 241,
  [283] = 228,
  [284] = 242,
  [285] = 285,
  [286] = 286,
  [287] = 243,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 246,
  [294] = 294,
  [295] = 295,
  [296] = 235,
  [297] = 297,
  [298] = 298,
  [299] = 252,
  [300] = 257,
  [301] = 301,
  [302] = 257,
  [303] = 303,
  [304] = 229,
  [305] = 232,
  [306] = 303,
  [307] = 295,
  [308] = 265,
  [309] = 236,
  [310] = 310,
  [311] = 239,
  [312] = 237,
  [313] = 241,
  [314] = 242,
  [315] = 226,
  [316] = 243,
  [317] = 260,
  [318] = 318,
  [319] = 265,
  [320] = 295,
  [321] = 246,
  [322] = 303,
  [323] = 301,
  [324] = 298,
  [325] = 229,
  [326] = 297,
  [327] = 252,
  [328] = 301,
  [329] = 292,
  [330] = 291,
  [331] = 290,
  [332] = 289,
  [333] = 288,
  [334] = 285,
  [335] = 228,
  [336] = 234,
  [337] = 240,
  [338] = 257,
  [339] = 247,
  [340] = 249,
  [341] = 229,
  [342] = 232,
  [343] = 250,
  [344] = 236,
  [345] = 239,
  [346] = 248,
  [347] = 241,
  [348] = 242,
  [349] = 243,
  [350] = 245,
  [351] = 246,
  [352] = 285,
  [353] = 244,
  [354] = 252,
  [355] = 288,
  [356] = 298,
  [357] = 238,
  [358] = 260,
  [359] = 257,
  [360] = 252,
  [361] = 229,
  [362] = 232,
  [363] = 226,
  [364] = 364,
  [365] = 227,
  [366] = 237,
  [367] = 236,
  [368] = 297,
  [369] = 233,
  [370] = 239,
  [371] = 371,
  [372] = 235,
  [373] = 289,
  [374] = 241,
  [375] = 242,
  [376] = 290,
  [377] = 377,
  [378] = 291,
  [379] = 292,
  [380] = 243,
  [381] = 297,
  [382] = 235,
  [383] = 298,
  [384] = 384,
  [385] = 233,
  [386] = 297,
  [387] = 301,
  [388] = 227,
  [389] = 303,
  [390] = 295,
  [391] = 238,
  [392] = 265,
  [393] = 252,
  [394] = 246,
  [395] = 244,
  [396] = 252,
  [397] = 245,
  [398] = 237,
  [399] = 257,
  [400] = 248,
  [401] = 250,
  [402] = 249,
  [403] = 229,
  [404] = 247,
  [405] = 232,
  [406] = 292,
  [407] = 236,
  [408] = 240,
  [409] = 291,
  [410] = 239,
  [411] = 234,
  [412] = 228,
  [413] = 265,
  [414] = 295,
  [415] = 226,
  [416] = 260,
  [417] = 303,
  [418] = 241,
  [419] = 242,
  [420] = 301,
  [421] = 298,
  [422] = 297,
  [423] = 292,
  [424] = 291,
  [425] = 290,
  [426] = 289,
  [427] = 288,
  [428] = 285,
  [429] = 260,
  [430] = 226,
  [431] = 237,
  [432] = 235,
  [433] = 285,
  [434] = 288,
  [435] = 289,
  [436] = 290,
  [437] = 291,
  [438] = 292,
  [439] = 297,
  [440] = 298,
  [441] = 301,
  [442] = 303,
  [443] = 295,
  [444] = 233,
  [445] = 227,
  [446] = 265,
  [447] = 238,
  [448] = 244,
  [449] = 245,
  [450] = 248,
  [451] = 250,
  [452] = 249,
  [453] = 247,
  [454] = 240,
  [455] = 234,
  [456] = 243,
  [457] = 228,
  [458] = 228,
  [459] = 234,
  [460] = 246,
  [461] = 240,
  [462] = 265,
  [463] = 247,
  [464] = 249,
  [465] = 250,
  [466] = 252,
  [467] = 248,
  [468] = 243,
  [469] = 245,
  [470] = 244,
  [471] = 238,
  [472] = 227,
  [473] = 265,
  [474] = 242,
  [475] = 241,
  [476] = 257,
  [477] = 290,
  [478] = 229,
  [479] = 233,
  [480] = 232,
  [481] = 295,
  [482] = 239,
  [483] = 236,
  [484] = 239,
  [485] = 228,
  [486] = 234,
  [487] = 241,
  [488] = 242,
  [489] = 243,
  [490] = 303,
  [491] = 240,
  [492] = 247,
  [493] = 246,
  [494] = 494,
  [495] = 298,
  [496] = 250,
  [497] = 301,
  [498] = 252,
  [499] = 236,
  [500] = 298,
  [501] = 257,
  [502] = 232,
  [503] = 229,
  [504] = 232,
  [505] = 229,
  [506] = 248,
  [507] = 245,
  [508] = 508,
  [509] = 509,
  [510] = 236,
  [511] = 239,
  [512] = 244,
  [513] = 241,
  [514] = 514,
  [515] = 242,
  [516] = 243,
  [517] = 297,
  [518] = 246,
  [519] = 238,
  [520] = 292,
  [521] = 521,
  [522] = 291,
  [523] = 252,
  [524] = 257,
  [525] = 290,
  [526] = 227,
  [527] = 289,
  [528] = 257,
  [529] = 288,
  [530] = 229,
  [531] = 232,
  [532] = 233,
  [533] = 252,
  [534] = 233,
  [535] = 236,
  [536] = 239,
  [537] = 288,
  [538] = 241,
  [539] = 242,
  [540] = 243,
  [541] = 235,
  [542] = 246,
  [543] = 285,
  [544] = 237,
  [545] = 252,
  [546] = 260,
  [547] = 226,
  [548] = 257,
  [549] = 289,
  [550] = 229,
  [551] = 265,
  [552] = 232,
  [553] = 246,
  [554] = 295,
  [555] = 303,
  [556] = 301,
  [557] = 298,
  [558] = 297,
  [559] = 226,
  [560] = 260,
  [561] = 285,
  [562] = 292,
  [563] = 235,
  [564] = 291,
  [565] = 290,
  [566] = 233,
  [567] = 237,
  [568] = 226,
  [569] = 260,
  [570] = 288,
  [571] = 289,
  [572] = 289,
  [573] = 288,
  [574] = 290,
  [575] = 285,
  [576] = 291,
  [577] = 292,
  [578] = 297,
  [579] = 298,
  [580] = 301,
  [581] = 303,
  [582] = 246,
  [583] = 237,
  [584] = 235,
  [585] = 295,
  [586] = 586,
  [587] = 235,
  [588] = 265,
  [589] = 233,
  [590] = 590,
  [591] = 227,
  [592] = 243,
  [593] = 238,
  [594] = 242,
  [595] = 237,
  [596] = 244,
  [597] = 241,
  [598] = 245,
  [599] = 248,
  [600] = 285,
  [601] = 288,
  [602] = 289,
  [603] = 250,
  [604] = 249,
  [605] = 247,
  [606] = 290,
  [607] = 291,
  [608] = 240,
  [609] = 292,
  [610] = 297,
  [611] = 234,
  [612] = 298,
  [613] = 228,
  [614] = 301,
  [615] = 303,
  [616] = 295,
  [617] = 228,
  [618] = 265,
  [619] = 234,
  [620] = 620,
  [621] = 240,
  [622] = 260,
  [623] = 623,
  [624] = 226,
  [625] = 247,
  [626] = 226,
  [627] = 295,
  [628] = 249,
  [629] = 303,
  [630] = 301,
  [631] = 298,
  [632] = 297,
  [633] = 292,
  [634] = 291,
  [635] = 290,
  [636] = 250,
  [637] = 289,
  [638] = 288,
  [639] = 285,
  [640] = 260,
  [641] = 248,
  [642] = 245,
  [643] = 237,
  [644] = 244,
  [645] = 238,
  [646] = 265,
  [647] = 235,
  [648] = 228,
  [649] = 234,
  [650] = 240,
  [651] = 247,
  [652] = 295,
  [653] = 303,
  [654] = 301,
  [655] = 249,
  [656] = 250,
  [657] = 248,
  [658] = 245,
  [659] = 244,
  [660] = 238,
  [661] = 661,
  [662] = 227,
  [663] = 233,
  [664] = 298,
  [665] = 236,
  [666] = 239,
  [667] = 297,
  [668] = 241,
  [669] = 242,
  [670] = 243,
  [671] = 292,
  [672] = 672,
  [673] = 291,
  [674] = 290,
  [675] = 246,
  [676] = 676,
  [677] = 243,
  [678] = 289,
  [679] = 679,
  [680] = 252,
  [681] = 285,
  [682] = 682,
  [683] = 288,
  [684] = 288,
  [685] = 257,
  [686] = 242,
  [687] = 285,
  [688] = 229,
  [689] = 227,
  [690] = 232,
  [691] = 691,
  [692] = 289,
  [693] = 290,
  [694] = 291,
  [695] = 292,
  [696] = 297,
  [697] = 697,
  [698] = 233,
  [699] = 260,
  [700] = 298,
  [701] = 301,
  [702] = 303,
  [703] = 295,
  [704] = 514,
  [705] = 241,
  [706] = 233,
  [707] = 285,
  [708] = 226,
  [709] = 237,
  [710] = 235,
  [711] = 233,
  [712] = 712,
  [713] = 235,
  [714] = 260,
  [715] = 226,
  [716] = 237,
  [717] = 226,
  [718] = 239,
  [719] = 265,
  [720] = 260,
  [721] = 238,
  [722] = 244,
  [723] = 285,
  [724] = 288,
  [725] = 289,
  [726] = 290,
  [727] = 291,
  [728] = 292,
  [729] = 297,
  [730] = 298,
  [731] = 245,
  [732] = 301,
  [733] = 237,
  [734] = 303,
  [735] = 295,
  [736] = 265,
  [737] = 248,
  [738] = 250,
  [739] = 249,
  [740] = 247,
  [741] = 240,
  [742] = 234,
  [743] = 228,
  [744] = 236,
  [745] = 229,
  [746] = 235,
  [747] = 238,
  [748] = 244,
  [749] = 228,
  [750] = 233,
  [751] = 751,
  [752] = 245,
  [753] = 227,
  [754] = 248,
  [755] = 234,
  [756] = 239,
  [757] = 240,
  [758] = 247,
  [759] = 249,
  [760] = 250,
  [761] = 248,
  [762] = 245,
  [763] = 250,
  [764] = 238,
  [765] = 229,
  [766] = 244,
  [767] = 238,
  [768] = 227,
  [769] = 244,
  [770] = 233,
  [771] = 249,
  [772] = 247,
  [773] = 235,
  [774] = 245,
  [775] = 240,
  [776] = 234,
  [777] = 228,
  [778] = 234,
  [779] = 237,
  [780] = 226,
  [781] = 260,
  [782] = 240,
  [783] = 247,
  [784] = 249,
  [785] = 250,
  [786] = 248,
  [787] = 245,
  [788] = 228,
  [789] = 265,
  [790] = 295,
  [791] = 303,
  [792] = 301,
  [793] = 298,
  [794] = 297,
  [795] = 235,
  [796] = 292,
  [797] = 291,
  [798] = 290,
  [799] = 260,
  [800] = 226,
  [801] = 244,
  [802] = 238,
  [803] = 289,
  [804] = 288,
  [805] = 285,
  [806] = 260,
  [807] = 226,
  [808] = 237,
  [809] = 235,
  [810] = 237,
  [811] = 227,
  [812] = 238,
  [813] = 244,
  [814] = 245,
  [815] = 248,
  [816] = 816,
  [817] = 817,
  [818] = 250,
  [819] = 249,
  [820] = 285,
  [821] = 288,
  [822] = 289,
  [823] = 290,
  [824] = 291,
  [825] = 292,
  [826] = 297,
  [827] = 298,
  [828] = 301,
  [829] = 303,
  [830] = 295,
  [831] = 265,
  [832] = 247,
  [833] = 265,
  [834] = 240,
  [835] = 248,
  [836] = 514,
  [837] = 234,
  [838] = 228,
  [839] = 676,
  [840] = 260,
  [841] = 841,
  [842] = 682,
  [843] = 691,
  [844] = 295,
  [845] = 303,
  [846] = 301,
  [847] = 228,
  [848] = 234,
  [849] = 298,
  [850] = 297,
  [851] = 240,
  [852] = 292,
  [853] = 247,
  [854] = 249,
  [855] = 250,
  [856] = 291,
  [857] = 248,
  [858] = 227,
  [859] = 245,
  [860] = 623,
  [861] = 244,
  [862] = 238,
  [863] = 265,
  [864] = 227,
  [865] = 295,
  [866] = 303,
  [867] = 301,
  [868] = 236,
  [869] = 239,
  [870] = 290,
  [871] = 289,
  [872] = 241,
  [873] = 242,
  [874] = 243,
  [875] = 250,
  [876] = 298,
  [877] = 246,
  [878] = 297,
  [879] = 233,
  [880] = 292,
  [881] = 291,
  [882] = 252,
  [883] = 377,
  [884] = 290,
  [885] = 620,
  [886] = 288,
  [887] = 285,
  [888] = 289,
  [889] = 288,
  [890] = 285,
  [891] = 249,
  [892] = 247,
  [893] = 288,
  [894] = 257,
  [895] = 240,
  [896] = 289,
  [897] = 285,
  [898] = 290,
  [899] = 229,
  [900] = 291,
  [901] = 232,
  [902] = 292,
  [903] = 297,
  [904] = 298,
  [905] = 236,
  [906] = 301,
  [907] = 229,
  [908] = 303,
  [909] = 295,
  [910] = 260,
  [911] = 265,
  [912] = 226,
  [913] = 233,
  [914] = 237,
  [915] = 235,
  [916] = 235,
  [917] = 286,
  [918] = 230,
  [919] = 286,
  [920] = 230,
  [921] = 237,
  [922] = 226,
  [923] = 260,
  [924] = 286,
  [925] = 230,
  [926] = 286,
  [927] = 230,
  [928] = 286,
  [929] = 230,
  [930] = 237,
  [931] = 286,
  [932] = 230,
  [933] = 286,
  [934] = 230,
  [935] = 286,
  [936] = 230,
  [937] = 286,
  [938] = 230,
  [939] = 939,
  [940] = 286,
  [941] = 230,
  [942] = 286,
  [943] = 230,
  [944] = 228,
  [945] = 234,
  [946] = 240,
  [947] = 247,
  [948] = 235,
  [949] = 285,
  [950] = 288,
  [951] = 289,
  [952] = 290,
  [953] = 291,
  [954] = 292,
  [955] = 297,
  [956] = 298,
  [957] = 301,
  [958] = 303,
  [959] = 295,
  [960] = 265,
  [961] = 237,
  [962] = 226,
  [963] = 260,
  [964] = 285,
  [965] = 288,
  [966] = 289,
  [967] = 290,
  [968] = 291,
  [969] = 292,
  [970] = 297,
  [971] = 249,
  [972] = 250,
  [973] = 298,
  [974] = 974,
  [975] = 301,
  [976] = 228,
  [977] = 303,
  [978] = 234,
  [979] = 295,
  [980] = 240,
  [981] = 247,
  [982] = 249,
  [983] = 265,
  [984] = 248,
  [985] = 250,
  [986] = 248,
  [987] = 245,
  [988] = 244,
  [989] = 228,
  [990] = 590,
  [991] = 238,
  [992] = 234,
  [993] = 227,
  [994] = 240,
  [995] = 247,
  [996] = 249,
  [997] = 233,
  [998] = 250,
  [999] = 248,
  [1000] = 245,
  [1001] = 244,
  [1002] = 245,
  [1003] = 244,
  [1004] = 238,
  [1005] = 227,
  [1006] = 235,
  [1007] = 237,
  [1008] = 226,
  [1009] = 260,
  [1010] = 285,
  [1011] = 1011,
  [1012] = 238,
  [1013] = 288,
  [1014] = 289,
  [1015] = 290,
  [1016] = 291,
  [1017] = 292,
  [1018] = 297,
  [1019] = 298,
  [1020] = 230,
  [1021] = 235,
  [1022] = 286,
  [1023] = 301,
  [1024] = 230,
  [1025] = 286,
  [1026] = 230,
  [1027] = 1027,
  [1028] = 303,
  [1029] = 295,
  [1030] = 265,
  [1031] = 228,
  [1032] = 234,
  [1033] = 240,
  [1034] = 247,
  [1035] = 249,
  [1036] = 250,
  [1037] = 248,
  [1038] = 245,
  [1039] = 244,
  [1040] = 238,
  [1041] = 286,
  [1042] = 228,
  [1043] = 227,
  [1044] = 233,
  [1045] = 235,
  [1046] = 237,
  [1047] = 234,
  [1048] = 226,
  [1049] = 260,
  [1050] = 285,
  [1051] = 240,
  [1052] = 235,
  [1053] = 288,
  [1054] = 237,
  [1055] = 226,
  [1056] = 260,
  [1057] = 289,
  [1058] = 290,
  [1059] = 291,
  [1060] = 292,
  [1061] = 285,
  [1062] = 288,
  [1063] = 289,
  [1064] = 297,
  [1065] = 290,
  [1066] = 623,
  [1067] = 291,
  [1068] = 298,
  [1069] = 292,
  [1070] = 297,
  [1071] = 298,
  [1072] = 301,
  [1073] = 303,
  [1074] = 295,
  [1075] = 265,
  [1076] = 301,
  [1077] = 303,
  [1078] = 295,
  [1079] = 265,
  [1080] = 228,
  [1081] = 234,
  [1082] = 240,
  [1083] = 247,
  [1084] = 249,
  [1085] = 250,
  [1086] = 248,
  [1087] = 227,
  [1088] = 228,
  [1089] = 234,
  [1090] = 240,
  [1091] = 247,
  [1092] = 249,
  [1093] = 250,
  [1094] = 247,
  [1095] = 514,
  [1096] = 233,
  [1097] = 248,
  [1098] = 245,
  [1099] = 244,
  [1100] = 238,
  [1101] = 245,
  [1102] = 244,
  [1103] = 249,
  [1104] = 227,
  [1105] = 233,
  [1106] = 238,
  [1107] = 235,
  [1108] = 227,
  [1109] = 233,
  [1110] = 235,
  [1111] = 237,
  [1112] = 237,
  [1113] = 226,
  [1114] = 226,
  [1115] = 260,
  [1116] = 260,
  [1117] = 285,
  [1118] = 288,
  [1119] = 289,
  [1120] = 290,
  [1121] = 291,
  [1122] = 292,
  [1123] = 297,
  [1124] = 298,
  [1125] = 301,
  [1126] = 303,
  [1127] = 295,
  [1128] = 265,
  [1129] = 228,
  [1130] = 234,
  [1131] = 285,
  [1132] = 288,
  [1133] = 289,
  [1134] = 290,
  [1135] = 291,
  [1136] = 292,
  [1137] = 297,
  [1138] = 298,
  [1139] = 240,
  [1140] = 228,
  [1141] = 301,
  [1142] = 303,
  [1143] = 295,
  [1144] = 265,
  [1145] = 247,
  [1146] = 250,
  [1147] = 249,
  [1148] = 250,
  [1149] = 248,
  [1150] = 248,
  [1151] = 245,
  [1152] = 244,
  [1153] = 238,
  [1154] = 245,
  [1155] = 234,
  [1156] = 227,
  [1157] = 233,
  [1158] = 233,
  [1159] = 228,
  [1160] = 234,
  [1161] = 240,
  [1162] = 247,
  [1163] = 249,
  [1164] = 250,
  [1165] = 248,
  [1166] = 235,
  [1167] = 245,
  [1168] = 244,
  [1169] = 238,
  [1170] = 244,
  [1171] = 227,
  [1172] = 237,
  [1173] = 226,
  [1174] = 260,
  [1175] = 285,
  [1176] = 288,
  [1177] = 289,
  [1178] = 290,
  [1179] = 291,
  [1180] = 236,
  [1181] = 292,
  [1182] = 239,
  [1183] = 297,
  [1184] = 298,
  [1185] = 301,
  [1186] = 303,
  [1187] = 295,
  [1188] = 265,
  [1189] = 228,
  [1190] = 234,
  [1191] = 241,
  [1192] = 240,
  [1193] = 242,
  [1194] = 243,
  [1195] = 235,
  [1196] = 246,
  [1197] = 247,
  [1198] = 249,
  [1199] = 250,
  [1200] = 248,
  [1201] = 237,
  [1202] = 226,
  [1203] = 260,
  [1204] = 285,
  [1205] = 288,
  [1206] = 289,
  [1207] = 290,
  [1208] = 291,
  [1209] = 292,
  [1210] = 297,
  [1211] = 245,
  [1212] = 244,
  [1213] = 238,
  [1214] = 227,
  [1215] = 298,
  [1216] = 301,
  [1217] = 303,
  [1218] = 233,
  [1219] = 295,
  [1220] = 265,
  [1221] = 228,
  [1222] = 234,
  [1223] = 240,
  [1224] = 229,
  [1225] = 227,
  [1226] = 229,
  [1227] = 247,
  [1228] = 249,
  [1229] = 233,
  [1230] = 250,
  [1231] = 252,
  [1232] = 248,
  [1233] = 235,
  [1234] = 245,
  [1235] = 244,
  [1236] = 237,
  [1237] = 238,
  [1238] = 227,
  [1239] = 226,
  [1240] = 260,
  [1241] = 377,
  [1242] = 233,
  [1243] = 285,
  [1244] = 288,
  [1245] = 289,
  [1246] = 290,
  [1247] = 291,
  [1248] = 292,
  [1249] = 297,
  [1250] = 691,
  [1251] = 235,
  [1252] = 265,
  [1253] = 237,
  [1254] = 226,
  [1255] = 298,
  [1256] = 260,
  [1257] = 301,
  [1258] = 1027,
  [1259] = 303,
  [1260] = 623,
  [1261] = 233,
  [1262] = 257,
  [1263] = 295,
  [1264] = 295,
  [1265] = 238,
  [1266] = 265,
  [1267] = 228,
  [1268] = 227,
  [1269] = 514,
  [1270] = 661,
  [1271] = 229,
  [1272] = 234,
  [1273] = 240,
  [1274] = 247,
  [1275] = 691,
  [1276] = 303,
  [1277] = 682,
  [1278] = 232,
  [1279] = 676,
  [1280] = 249,
  [1281] = 227,
  [1282] = 233,
  [1283] = 301,
  [1284] = 238,
  [1285] = 250,
  [1286] = 227,
  [1287] = 244,
  [1288] = 245,
  [1289] = 248,
  [1290] = 250,
  [1291] = 249,
  [1292] = 247,
  [1293] = 240,
  [1294] = 234,
  [1295] = 228,
  [1296] = 285,
  [1297] = 248,
  [1298] = 245,
  [1299] = 244,
  [1300] = 288,
  [1301] = 292,
  [1302] = 238,
  [1303] = 289,
  [1304] = 290,
  [1305] = 291,
  [1306] = 292,
  [1307] = 227,
  [1308] = 297,
  [1309] = 298,
  [1310] = 301,
  [1311] = 303,
  [1312] = 295,
  [1313] = 238,
  [1314] = 235,
  [1315] = 237,
  [1316] = 244,
  [1317] = 245,
  [1318] = 248,
  [1319] = 250,
  [1320] = 249,
  [1321] = 247,
  [1322] = 298,
  [1323] = 240,
  [1324] = 234,
  [1325] = 228,
  [1326] = 294,
  [1327] = 226,
  [1328] = 310,
  [1329] = 265,
  [1330] = 260,
  [1331] = 235,
  [1332] = 237,
  [1333] = 285,
  [1334] = 226,
  [1335] = 260,
  [1336] = 285,
  [1337] = 288,
  [1338] = 265,
  [1339] = 289,
  [1340] = 290,
  [1341] = 291,
  [1342] = 235,
  [1343] = 237,
  [1344] = 292,
  [1345] = 297,
  [1346] = 508,
  [1347] = 509,
  [1348] = 298,
  [1349] = 514,
  [1350] = 301,
  [1351] = 521,
  [1352] = 303,
  [1353] = 295,
  [1354] = 265,
  [1355] = 228,
  [1356] = 234,
  [1357] = 288,
  [1358] = 289,
  [1359] = 290,
  [1360] = 291,
  [1361] = 292,
  [1362] = 297,
  [1363] = 298,
  [1364] = 301,
  [1365] = 303,
  [1366] = 295,
  [1367] = 240,
  [1368] = 265,
  [1369] = 247,
  [1370] = 249,
  [1371] = 250,
  [1372] = 248,
  [1373] = 227,
  [1374] = 228,
  [1375] = 265,
  [1376] = 234,
  [1377] = 240,
  [1378] = 247,
  [1379] = 249,
  [1380] = 228,
  [1381] = 234,
  [1382] = 250,
  [1383] = 248,
  [1384] = 245,
  [1385] = 240,
  [1386] = 244,
  [1387] = 247,
  [1388] = 301,
  [1389] = 245,
  [1390] = 238,
  [1391] = 244,
  [1392] = 238,
  [1393] = 227,
  [1394] = 233,
  [1395] = 295,
  [1396] = 303,
  [1397] = 295,
  [1398] = 226,
  [1399] = 303,
  [1400] = 301,
  [1401] = 298,
  [1402] = 297,
  [1403] = 292,
  [1404] = 291,
  [1405] = 290,
  [1406] = 249,
  [1407] = 289,
  [1408] = 288,
  [1409] = 285,
  [1410] = 246,
  [1411] = 249,
  [1412] = 250,
  [1413] = 292,
  [1414] = 291,
  [1415] = 290,
  [1416] = 289,
  [1417] = 248,
  [1418] = 288,
  [1419] = 245,
  [1420] = 260,
  [1421] = 285,
  [1422] = 297,
  [1423] = 244,
  [1424] = 233,
  [1425] = 235,
  [1426] = 237,
  [1427] = 226,
  [1428] = 260,
  [1429] = 285,
  [1430] = 288,
  [1431] = 238,
  [1432] = 289,
  [1433] = 697,
  [1434] = 260,
  [1435] = 227,
  [1436] = 233,
  [1437] = 226,
  [1438] = 623,
  [1439] = 620,
  [1440] = 237,
  [1441] = 290,
  [1442] = 260,
  [1443] = 226,
  [1444] = 291,
  [1445] = 292,
  [1446] = 285,
  [1447] = 297,
  [1448] = 298,
  [1449] = 301,
  [1450] = 303,
  [1451] = 295,
  [1452] = 265,
  [1453] = 288,
  [1454] = 227,
  [1455] = 228,
  [1456] = 291,
  [1457] = 234,
  [1458] = 290,
  [1459] = 240,
  [1460] = 247,
  [1461] = 249,
  [1462] = 233,
  [1463] = 235,
  [1464] = 590,
  [1465] = 260,
  [1466] = 237,
  [1467] = 226,
  [1468] = 590,
  [1469] = 235,
  [1470] = 250,
  [1471] = 623,
  [1472] = 248,
  [1473] = 245,
  [1474] = 244,
  [1475] = 238,
  [1476] = 620,
  [1477] = 227,
  [1478] = 232,
  [1479] = 233,
  [1480] = 289,
  [1481] = 233,
  [1482] = 237,
  [1483] = 235,
  [1484] = 1484,
  [1485] = 1485,
  [1486] = 1486,
  [1487] = 1484,
  [1488] = 1488,
  [1489] = 1488,
  [1490] = 1486,
  [1491] = 1485,
  [1492] = 1492,
  [1493] = 1492,
  [1494] = 1494,
  [1495] = 1494,
  [1496] = 1496,
  [1497] = 1497,
  [1498] = 1498,
  [1499] = 1499,
  [1500] = 1500,
  [1501] = 1488,
  [1502] = 1502,
  [1503] = 1488,
  [1504] = 1504,
  [1505] = 1496,
  [1506] = 1506,
  [1507] = 1498,
  [1508] = 1508,
  [1509] = 1509,
  [1510] = 1510,
  [1511] = 1511,
  [1512] = 1512,
  [1513] = 1513,
  [1514] = 1514,
  [1515] = 1515,
  [1516] = 1516,
  [1517] = 1517,
  [1518] = 1518,
  [1519] = 1519,
  [1520] = 1520,
  [1521] = 1521,
  [1522] = 1522,
  [1523] = 1523,
  [1524] = 1524,
  [1525] = 1525,
  [1526] = 1526,
  [1527] = 1527,
  [1528] = 1528,
  [1529] = 1529,
  [1530] = 1530,
  [1531] = 1531,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 1534,
  [1535] = 1535,
  [1536] = 1536,
  [1537] = 1537,
  [1538] = 1510,
  [1539] = 1492,
  [1540] = 1502,
  [1541] = 1509,
  [1542] = 1511,
  [1543] = 1506,
  [1544] = 1492,
  [1545] = 1504,
  [1546] = 1494,
  [1547] = 1494,
  [1548] = 1548,
  [1549] = 1549,
  [1550] = 1550,
  [1551] = 1551,
  [1552] = 1552,
  [1553] = 1553,
  [1554] = 1488,
  [1555] = 1555,
  [1556] = 1497,
  [1557] = 1552,
  [1558] = 1553,
  [1559] = 1548,
  [1560] = 1499,
  [1561] = 1496,
  [1562] = 1498,
  [1563] = 1563,
  [1564] = 1564,
  [1565] = 1549,
  [1566] = 1551,
  [1567] = 1550,
  [1568] = 1512,
  [1569] = 1569,
  [1570] = 1494,
  [1571] = 1571,
  [1572] = 1492,
  [1573] = 1573,
  [1574] = 1500,
  [1575] = 1575,
  [1576] = 1576,
  [1577] = 1577,
  [1578] = 1508,
  [1579] = 1579,
  [1580] = 1580,
  [1581] = 1581,
  [1582] = 1582,
  [1583] = 1488,
  [1584] = 1584,
  [1585] = 1522,
  [1586] = 1586,
  [1587] = 1587,
  [1588] = 1588,
  [1589] = 1589,
  [1590] = 1590,
  [1591] = 1513,
  [1592] = 1521,
  [1593] = 1514,
  [1594] = 1594,
  [1595] = 1517,
  [1596] = 1519,
  [1597] = 1520,
  [1598] = 1598,
  [1599] = 1599,
  [1600] = 1600,
  [1601] = 1488,
  [1602] = 1602,
  [1603] = 1518,
  [1604] = 1515,
  [1605] = 1605,
  [1606] = 1606,
  [1607] = 1607,
  [1608] = 1516,
  [1609] = 1609,
  [1610] = 1610,
  [1611] = 1611,
  [1612] = 1612,
  [1613] = 1523,
  [1614] = 1614,
  [1615] = 1615,
  [1616] = 1616,
  [1617] = 1617,
  [1618] = 1618,
  [1619] = 1619,
  [1620] = 1620,
  [1621] = 1621,
  [1622] = 1622,
  [1623] = 1623,
  [1624] = 1624,
  [1625] = 1625,
  [1626] = 1563,
  [1627] = 1555,
  [1628] = 1628,
  [1629] = 1629,
  [1630] = 1630,
  [1631] = 1631,
  [1632] = 1632,
  [1633] = 1633,
  [1634] = 1634,
  [1635] = 1635,
  [1636] = 1525,
  [1637] = 1637,
  [1638] = 1536,
  [1639] = 1529,
  [1640] = 1528,
  [1641] = 1641,
  [1642] = 1642,
  [1643] = 1643,
  [1644] = 1644,
  [1645] = 1645,
  [1646] = 1646,
  [1647] = 1647,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1650,
  [1651] = 1531,
  [1652] = 1652,
  [1653] = 1653,
  [1654] = 1654,
  [1655] = 1532,
  [1656] = 1656,
  [1657] = 1657,
  [1658] = 1533,
  [1659] = 1537,
  [1660] = 1524,
  [1661] = 1535,
  [1662] = 1662,
  [1663] = 1663,
  [1664] = 1664,
  [1665] = 1526,
  [1666] = 1666,
  [1667] = 1667,
  [1668] = 1668,
  [1669] = 1669,
  [1670] = 1670,
  [1671] = 1671,
  [1672] = 1672,
  [1673] = 1673,
  [1674] = 1674,
  [1675] = 1675,
  [1676] = 1676,
  [1677] = 1677,
  [1678] = 1678,
  [1679] = 1679,
  [1680] = 1680,
  [1681] = 1681,
  [1682] = 1682,
  [1683] = 1683,
  [1684] = 1684,
  [1685] = 1685,
  [1686] = 1686,
  [1687] = 1687,
  [1688] = 1534,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 1691,
  [1692] = 1692,
  [1693] = 1693,
  [1694] = 1694,
  [1695] = 1695,
  [1696] = 1696,
  [1697] = 1697,
  [1698] = 1698,
  [1699] = 1564,
  [1700] = 1700,
  [1701] = 1488,
  [1702] = 1702,
  [1703] = 1703,
  [1704] = 1704,
  [1705] = 1705,
  [1706] = 1706,
  [1707] = 1707,
  [1708] = 1708,
  [1709] = 1530,
  [1710] = 1710,
  [1711] = 1711,
  [1712] = 1712,
  [1713] = 1713,
  [1714] = 1714,
  [1715] = 1527,
  [1716] = 1716,
  [1717] = 1717,
  [1718] = 1718,
  [1719] = 1719,
  [1720] = 1720,
  [1721] = 1721,
  [1722] = 1722,
  [1723] = 1723,
  [1724] = 1724,
  [1725] = 1725,
  [1726] = 1726,
  [1727] = 1727,
  [1728] = 1582,
  [1729] = 1563,
  [1730] = 1730,
  [1731] = 1599,
  [1732] = 1598,
  [1733] = 1594,
  [1734] = 1590,
  [1735] = 1569,
  [1736] = 1586,
  [1737] = 1589,
  [1738] = 1492,
  [1739] = 1575,
  [1740] = 1576,
  [1741] = 1577,
  [1742] = 1579,
  [1743] = 1581,
  [1744] = 1587,
  [1745] = 1584,
  [1746] = 1588,
  [1747] = 1747,
  [1748] = 1492,
  [1749] = 1494,
  [1750] = 1606,
  [1751] = 1602,
  [1752] = 1512,
  [1753] = 1513,
  [1754] = 1514,
  [1755] = 1515,
  [1756] = 1516,
  [1757] = 1522,
  [1758] = 1521,
  [1759] = 1520,
  [1760] = 1519,
  [1761] = 1518,
  [1762] = 1494,
  [1763] = 1517,
  [1764] = 1607,
  [1765] = 1605,
  [1766] = 1563,
  [1767] = 1508,
  [1768] = 1500,
  [1769] = 1600,
  [1770] = 1573,
  [1771] = 1571,
  [1772] = 1580,
  [1773] = 1525,
  [1774] = 1526,
  [1775] = 1775,
  [1776] = 1625,
  [1777] = 1721,
  [1778] = 1778,
  [1779] = 1689,
  [1780] = 1780,
  [1781] = 1687,
  [1782] = 1707,
  [1783] = 1594,
  [1784] = 1590,
  [1785] = 1569,
  [1786] = 1586,
  [1787] = 1787,
  [1788] = 1609,
  [1789] = 1682,
  [1790] = 1790,
  [1791] = 1610,
  [1792] = 1675,
  [1793] = 1664,
  [1794] = 1484,
  [1795] = 1663,
  [1796] = 1498,
  [1797] = 1669,
  [1798] = 1790,
  [1799] = 1799,
  [1800] = 1800,
  [1801] = 1801,
  [1802] = 1610,
  [1803] = 1598,
  [1804] = 1599,
  [1805] = 1805,
  [1806] = 1696,
  [1807] = 1695,
  [1808] = 1694,
  [1809] = 1496,
  [1810] = 1684,
  [1811] = 1683,
  [1812] = 1650,
  [1813] = 1703,
  [1814] = 1704,
  [1815] = 1647,
  [1816] = 1494,
  [1817] = 1646,
  [1818] = 1645,
  [1819] = 1644,
  [1820] = 1676,
  [1821] = 1673,
  [1822] = 1643,
  [1823] = 1672,
  [1824] = 1642,
  [1825] = 1671,
  [1826] = 1637,
  [1827] = 1712,
  [1828] = 1716,
  [1829] = 1717,
  [1830] = 1830,
  [1831] = 1657,
  [1832] = 1633,
  [1833] = 1632,
  [1834] = 1698,
  [1835] = 1586,
  [1836] = 1615,
  [1837] = 1641,
  [1838] = 1569,
  [1839] = 1590,
  [1840] = 1656,
  [1841] = 1723,
  [1842] = 1720,
  [1843] = 1714,
  [1844] = 1713,
  [1845] = 1710,
  [1846] = 1708,
  [1847] = 1706,
  [1848] = 1700,
  [1849] = 1697,
  [1850] = 1653,
  [1851] = 1652,
  [1852] = 1693,
  [1853] = 1692,
  [1854] = 1649,
  [1855] = 1691,
  [1856] = 1635,
  [1857] = 1527,
  [1858] = 1690,
  [1859] = 1530,
  [1860] = 1686,
  [1861] = 1685,
  [1862] = 1681,
  [1863] = 1680,
  [1864] = 1679,
  [1865] = 1678,
  [1866] = 1677,
  [1867] = 1867,
  [1868] = 1674,
  [1869] = 1670,
  [1870] = 1634,
  [1871] = 1534,
  [1872] = 1872,
  [1873] = 1667,
  [1874] = 1666,
  [1875] = 1662,
  [1876] = 1654,
  [1877] = 1648,
  [1878] = 1668,
  [1879] = 1611,
  [1880] = 1612,
  [1881] = 1614,
  [1882] = 1718,
  [1883] = 1620,
  [1884] = 1599,
  [1885] = 1535,
  [1886] = 1524,
  [1887] = 1698,
  [1888] = 1594,
  [1889] = 1537,
  [1890] = 1719,
  [1891] = 1722,
  [1892] = 1533,
  [1893] = 1724,
  [1894] = 1616,
  [1895] = 1492,
  [1896] = 1631,
  [1897] = 1532,
  [1898] = 1725,
  [1899] = 1617,
  [1900] = 1726,
  [1901] = 1727,
  [1902] = 1536,
  [1903] = 1529,
  [1904] = 1618,
  [1905] = 1528,
  [1906] = 1523,
  [1907] = 1619,
  [1908] = 1598,
  [1909] = 1707,
  [1910] = 1531,
  [1911] = 1630,
  [1912] = 1621,
  [1913] = 1622,
  [1914] = 1623,
  [1915] = 1629,
  [1916] = 1624,
  [1917] = 1628,
  [1918] = 1500,
  [1919] = 1513,
  [1920] = 1514,
  [1921] = 1515,
  [1922] = 1516,
  [1923] = 1522,
  [1924] = 1521,
  [1925] = 1520,
  [1926] = 1508,
  [1927] = 1519,
  [1928] = 1518,
  [1929] = 1486,
  [1930] = 1930,
  [1931] = 1510,
  [1932] = 1512,
  [1933] = 1506,
  [1934] = 1488,
  [1935] = 1517,
  [1936] = 1502,
  [1937] = 1511,
  [1938] = 1509,
  [1939] = 1504,
  [1940] = 1496,
  [1941] = 1535,
  [1942] = 1531,
  [1943] = 1523,
  [1944] = 1524,
  [1945] = 1527,
  [1946] = 1526,
  [1947] = 1498,
  [1948] = 1498,
  [1949] = 1496,
  [1950] = 1537,
  [1951] = 1528,
  [1952] = 1529,
  [1953] = 1536,
  [1954] = 1525,
  [1955] = 1530,
  [1956] = 1533,
  [1957] = 1534,
  [1958] = 1532,
  [1959] = 1498,
  [1960] = 1506,
  [1961] = 1509,
  [1962] = 1510,
  [1963] = 1502,
  [1964] = 1492,
  [1965] = 1488,
  [1966] = 1504,
  [1967] = 1496,
  [1968] = 1727,
  [1969] = 1511,
  [1970] = 1494,
  [1971] = 1488,
  [1972] = 1488,
  [1973] = 1551,
  [1974] = 1548,
  [1975] = 1702,
  [1976] = 1705,
  [1977] = 1484,
  [1978] = 1552,
  [1979] = 1550,
  [1980] = 1549,
  [1981] = 1553,
  [1982] = 1711,
  [1983] = 1512,
  [1984] = 1486,
  [1985] = 1689,
  [1986] = 1614,
  [1987] = 1519,
  [1988] = 1518,
  [1989] = 1730,
  [1990] = 1494,
  [1991] = 1520,
  [1992] = 1488,
  [1993] = 1494,
  [1994] = 1517,
  [1995] = 1726,
  [1996] = 1500,
  [1997] = 1492,
  [1998] = 1513,
  [1999] = 1564,
  [2000] = 1508,
  [2001] = 1563,
  [2002] = 1492,
  [2003] = 1521,
  [2004] = 1747,
  [2005] = 1485,
  [2006] = 1522,
  [2007] = 1516,
  [2008] = 1515,
  [2009] = 1514,
  [2010] = 1800,
  [2011] = 1563,
  [2012] = 1780,
  [2013] = 1523,
  [2014] = 1711,
  [2015] = 1534,
  [2016] = 1555,
  [2017] = 1801,
  [2018] = 1492,
  [2019] = 1718,
  [2020] = 1526,
  [2021] = 1586,
  [2022] = 1569,
  [2023] = 1530,
  [2024] = 1590,
  [2025] = 1525,
  [2026] = 1716,
  [2027] = 1775,
  [2028] = 1609,
  [2029] = 1787,
  [2030] = 1488,
  [2031] = 1548,
  [2032] = 1536,
  [2033] = 1747,
  [2034] = 1527,
  [2035] = 1553,
  [2036] = 1552,
  [2037] = 1511,
  [2038] = 1529,
  [2039] = 1872,
  [2040] = 1528,
  [2041] = 1594,
  [2042] = 1531,
  [2043] = 1532,
  [2044] = 1717,
  [2045] = 1563,
  [2046] = 1799,
  [2047] = 1502,
  [2048] = 1504,
  [2049] = 1533,
  [2050] = 1730,
  [2051] = 1496,
  [2052] = 1551,
  [2053] = 1705,
  [2054] = 1484,
  [2055] = 1549,
  [2056] = 1705,
  [2057] = 1494,
  [2058] = 1537,
  [2059] = 1524,
  [2060] = 1702,
  [2061] = 1498,
  [2062] = 1778,
  [2063] = 1830,
  [2064] = 1725,
  [2065] = 1535,
  [2066] = 1719,
  [2067] = 1599,
  [2068] = 1598,
  [2069] = 1550,
  [2070] = 1867,
  [2071] = 1805,
  [2072] = 1625,
  [2073] = 1790,
  [2074] = 1506,
  [2075] = 1509,
  [2076] = 1510,
  [2077] = 1712,
  [2078] = 1588,
  [2079] = 2079,
  [2080] = 2079,
  [2081] = 1600,
  [2082] = 1517,
  [2083] = 1830,
  [2084] = 1623,
  [2085] = 1801,
  [2086] = 1500,
  [2087] = 2079,
  [2088] = 2079,
  [2089] = 1488,
  [2090] = 1492,
  [2091] = 1488,
  [2092] = 1575,
  [2093] = 1576,
  [2094] = 2079,
  [2095] = 1573,
  [2096] = 1605,
  [2097] = 1930,
  [2098] = 1508,
  [2099] = 1582,
  [2100] = 1577,
  [2101] = 1486,
  [2102] = 1584,
  [2103] = 1579,
  [2104] = 1581,
  [2105] = 1589,
  [2106] = 1800,
  [2107] = 1790,
  [2108] = 1629,
  [2109] = 1630,
  [2110] = 1682,
  [2111] = 2079,
  [2112] = 1646,
  [2113] = 1703,
  [2114] = 1607,
  [2115] = 2079,
  [2116] = 1587,
  [2117] = 2079,
  [2118] = 1662,
  [2119] = 2079,
  [2120] = 1663,
  [2121] = 1666,
  [2122] = 1599,
  [2123] = 1598,
  [2124] = 2079,
  [2125] = 2079,
  [2126] = 2079,
  [2127] = 1724,
  [2128] = 1647,
  [2129] = 1569,
  [2130] = 1586,
  [2131] = 2079,
  [2132] = 1518,
  [2133] = 1610,
  [2134] = 1569,
  [2135] = 1512,
  [2136] = 1580,
  [2137] = 1594,
  [2138] = 1704,
  [2139] = 1590,
  [2140] = 1594,
  [2141] = 2079,
  [2142] = 1606,
  [2143] = 2079,
  [2144] = 1519,
  [2145] = 1520,
  [2146] = 1521,
  [2147] = 1522,
  [2148] = 1698,
  [2149] = 1516,
  [2150] = 1494,
  [2151] = 1515,
  [2152] = 1514,
  [2153] = 1513,
  [2154] = 1707,
  [2155] = 1590,
  [2156] = 1598,
  [2157] = 1599,
  [2158] = 1586,
  [2159] = 1775,
  [2160] = 1602,
  [2161] = 1571,
  [2162] = 1787,
  [2163] = 1677,
  [2164] = 1535,
  [2165] = 1653,
  [2166] = 1526,
  [2167] = 1675,
  [2168] = 1652,
  [2169] = 1684,
  [2170] = 1683,
  [2171] = 1648,
  [2172] = 1668,
  [2173] = 1664,
  [2174] = 1669,
  [2175] = 1611,
  [2176] = 1612,
  [2177] = 1634,
  [2178] = 1649,
  [2179] = 1563,
  [2180] = 1635,
  [2181] = 1620,
  [2182] = 1867,
  [2183] = 1721,
  [2184] = 1676,
  [2185] = 1694,
  [2186] = 1523,
  [2187] = 1687,
  [2188] = 1654,
  [2189] = 1650,
  [2190] = 1722,
  [2191] = 1645,
  [2192] = 1872,
  [2193] = 1644,
  [2194] = 1643,
  [2195] = 2195,
  [2196] = 1642,
  [2197] = 1637,
  [2198] = 1527,
  [2199] = 1616,
  [2200] = 1633,
  [2201] = 1632,
  [2202] = 1615,
  [2203] = 1641,
  [2204] = 1723,
  [2205] = 1720,
  [2206] = 1714,
  [2207] = 1713,
  [2208] = 1710,
  [2209] = 1628,
  [2210] = 1708,
  [2211] = 1656,
  [2212] = 1619,
  [2213] = 1524,
  [2214] = 1537,
  [2215] = 1533,
  [2216] = 1532,
  [2217] = 1531,
  [2218] = 1528,
  [2219] = 1529,
  [2220] = 1536,
  [2221] = 1494,
  [2222] = 1631,
  [2223] = 1525,
  [2224] = 1617,
  [2225] = 1624,
  [2226] = 1618,
  [2227] = 1706,
  [2228] = 1700,
  [2229] = 1622,
  [2230] = 1621,
  [2231] = 1697,
  [2232] = 1693,
  [2233] = 1692,
  [2234] = 1534,
  [2235] = 1657,
  [2236] = 1691,
  [2237] = 1690,
  [2238] = 1686,
  [2239] = 1685,
  [2240] = 1681,
  [2241] = 1680,
  [2242] = 1679,
  [2243] = 1678,
  [2244] = 1711,
  [2245] = 1705,
  [2246] = 1674,
  [2247] = 1702,
  [2248] = 1492,
  [2249] = 1564,
  [2250] = 1670,
  [2251] = 1671,
  [2252] = 1780,
  [2253] = 1696,
  [2254] = 1672,
  [2255] = 1673,
  [2256] = 1555,
  [2257] = 1695,
  [2258] = 1667,
  [2259] = 1530,
  [2260] = 1599,
  [2261] = 1600,
  [2262] = 1587,
  [2263] = 1573,
  [2264] = 1580,
  [2265] = 1730,
  [2266] = 1605,
  [2267] = 1607,
  [2268] = 1602,
  [2269] = 1606,
  [2270] = 1588,
  [2271] = 1571,
  [2272] = 1584,
  [2273] = 1582,
  [2274] = 1581,
  [2275] = 1579,
  [2276] = 1577,
  [2277] = 1747,
  [2278] = 1492,
  [2279] = 1548,
  [2280] = 1498,
  [2281] = 1494,
  [2282] = 1576,
  [2283] = 1575,
  [2284] = 1488,
  [2285] = 1589,
  [2286] = 1598,
  [2287] = 1492,
  [2288] = 1494,
  [2289] = 1586,
  [2290] = 1569,
  [2291] = 1590,
  [2292] = 1550,
  [2293] = 1594,
  [2294] = 1496,
  [2295] = 1549,
  [2296] = 2195,
  [2297] = 1551,
  [2298] = 1552,
  [2299] = 1553,
  [2300] = 1488,
  [2301] = 1664,
  [2302] = 1800,
  [2303] = 1778,
  [2304] = 1496,
  [2305] = 1694,
  [2306] = 1703,
  [2307] = 1704,
  [2308] = 2308,
  [2309] = 1712,
  [2310] = 1716,
  [2311] = 1717,
  [2312] = 1718,
  [2313] = 1625,
  [2314] = 1719,
  [2315] = 1722,
  [2316] = 1724,
  [2317] = 1725,
  [2318] = 1726,
  [2319] = 1727,
  [2320] = 2308,
  [2321] = 1620,
  [2322] = 1721,
  [2323] = 1498,
  [2324] = 1805,
  [2325] = 2308,
  [2326] = 2308,
  [2327] = 2308,
  [2328] = 1689,
  [2329] = 1780,
  [2330] = 1867,
  [2331] = 1625,
  [2332] = 1696,
  [2333] = 1695,
  [2334] = 1563,
  [2335] = 2308,
  [2336] = 1687,
  [2337] = 1682,
  [2338] = 1609,
  [2339] = 1675,
  [2340] = 2308,
  [2341] = 2308,
  [2342] = 1801,
  [2343] = 1663,
  [2344] = 1669,
  [2345] = 1684,
  [2346] = 1683,
  [2347] = 2308,
  [2348] = 1609,
  [2349] = 1650,
  [2350] = 1647,
  [2351] = 1646,
  [2352] = 1676,
  [2353] = 1645,
  [2354] = 1673,
  [2355] = 1672,
  [2356] = 1644,
  [2357] = 1643,
  [2358] = 1671,
  [2359] = 2308,
  [2360] = 1642,
  [2361] = 1637,
  [2362] = 1775,
  [2363] = 2308,
  [2364] = 1799,
  [2365] = 1787,
  [2366] = 1633,
  [2367] = 1632,
  [2368] = 1615,
  [2369] = 1657,
  [2370] = 1641,
  [2371] = 1723,
  [2372] = 1656,
  [2373] = 1653,
  [2374] = 1652,
  [2375] = 1649,
  [2376] = 1635,
  [2377] = 1720,
  [2378] = 1634,
  [2379] = 1714,
  [2380] = 1713,
  [2381] = 1710,
  [2382] = 1708,
  [2383] = 1630,
  [2384] = 1629,
  [2385] = 1628,
  [2386] = 1706,
  [2387] = 1700,
  [2388] = 2308,
  [2389] = 1693,
  [2390] = 2308,
  [2391] = 1624,
  [2392] = 1697,
  [2393] = 1623,
  [2394] = 1622,
  [2395] = 1621,
  [2396] = 1692,
  [2397] = 1619,
  [2398] = 1691,
  [2399] = 2308,
  [2400] = 1690,
  [2401] = 1618,
  [2402] = 1686,
  [2403] = 1685,
  [2404] = 1681,
  [2405] = 1680,
  [2406] = 1679,
  [2407] = 1678,
  [2408] = 1677,
  [2409] = 1674,
  [2410] = 1670,
  [2411] = 2308,
  [2412] = 2308,
  [2413] = 1872,
  [2414] = 1667,
  [2415] = 1666,
  [2416] = 1662,
  [2417] = 1654,
  [2418] = 1648,
  [2419] = 2308,
  [2420] = 2308,
  [2421] = 1668,
  [2422] = 1611,
  [2423] = 1617,
  [2424] = 1612,
  [2425] = 1614,
  [2426] = 1631,
  [2427] = 1616,
  [2428] = 1830,
  [2429] = 1502,
  [2430] = 1517,
  [2431] = 1555,
  [2432] = 1518,
  [2433] = 1564,
  [2434] = 1514,
  [2435] = 1519,
  [2436] = 1517,
  [2437] = 1513,
  [2438] = 1586,
  [2439] = 1498,
  [2440] = 1496,
  [2441] = 1569,
  [2442] = 1590,
  [2443] = 1594,
  [2444] = 1510,
  [2445] = 1509,
  [2446] = 1498,
  [2447] = 1520,
  [2448] = 1599,
  [2449] = 1598,
  [2450] = 1506,
  [2451] = 1515,
  [2452] = 1516,
  [2453] = 1522,
  [2454] = 1512,
  [2455] = 1521,
  [2456] = 1513,
  [2457] = 1521,
  [2458] = 1522,
  [2459] = 1512,
  [2460] = 1516,
  [2461] = 1514,
  [2462] = 1515,
  [2463] = 1508,
  [2464] = 1511,
  [2465] = 1496,
  [2466] = 1500,
  [2467] = 1609,
  [2468] = 2468,
  [2469] = 1520,
  [2470] = 1625,
  [2471] = 1519,
  [2472] = 1518,
  [2473] = 1500,
  [2474] = 1488,
  [2475] = 1504,
  [2476] = 1508,
  [2477] = 1605,
  [2478] = 1512,
  [2479] = 1520,
  [2480] = 1521,
  [2481] = 1607,
  [2482] = 1522,
  [2483] = 1516,
  [2484] = 1515,
  [2485] = 1514,
  [2486] = 1513,
  [2487] = 1609,
  [2488] = 1524,
  [2489] = 1535,
  [2490] = 1496,
  [2491] = 1625,
  [2492] = 1799,
  [2493] = 1518,
  [2494] = 1702,
  [2495] = 1525,
  [2496] = 1514,
  [2497] = 1515,
  [2498] = 1516,
  [2499] = 1519,
  [2500] = 1522,
  [2501] = 1510,
  [2502] = 1527,
  [2503] = 1536,
  [2504] = 1534,
  [2505] = 1509,
  [2506] = 1506,
  [2507] = 1517,
  [2508] = 1529,
  [2509] = 1534,
  [2510] = 1500,
  [2511] = 1602,
  [2512] = 1606,
  [2513] = 1513,
  [2514] = 1518,
  [2515] = 1520,
  [2516] = 1494,
  [2517] = 1535,
  [2518] = 1512,
  [2519] = 1492,
  [2520] = 1492,
  [2521] = 1521,
  [2522] = 1500,
  [2523] = 1537,
  [2524] = 1519,
  [2525] = 1600,
  [2526] = 1573,
  [2527] = 1498,
  [2528] = 1537,
  [2529] = 1504,
  [2530] = 1533,
  [2531] = 1502,
  [2532] = 1532,
  [2533] = 1508,
  [2534] = 1508,
  [2535] = 1528,
  [2536] = 1571,
  [2537] = 1517,
  [2538] = 1531,
  [2539] = 1730,
  [2540] = 1533,
  [2541] = 1580,
  [2542] = 1747,
  [2543] = 1587,
  [2544] = 1494,
  [2545] = 1530,
  [2546] = 1523,
  [2547] = 1526,
  [2548] = 1530,
  [2549] = 1526,
  [2550] = 1523,
  [2551] = 1588,
  [2552] = 1525,
  [2553] = 1528,
  [2554] = 1778,
  [2555] = 1584,
  [2556] = 1582,
  [2557] = 1581,
  [2558] = 1589,
  [2559] = 1527,
  [2560] = 1536,
  [2561] = 1511,
  [2562] = 1531,
  [2563] = 1524,
  [2564] = 1529,
  [2565] = 1575,
  [2566] = 1576,
  [2567] = 1577,
  [2568] = 1532,
  [2569] = 1579,
  [2570] = 1488,
  [2571] = 1805,
  [2572] = 1711,
  [2573] = 1805,
  [2574] = 1531,
  [2575] = 1676,
  [2576] = 1683,
  [2577] = 1725,
  [2578] = 1684,
  [2579] = 1672,
  [2580] = 1671,
  [2581] = 1689,
  [2582] = 1799,
  [2583] = 1527,
  [2584] = 1526,
  [2585] = 1523,
  [2586] = 1657,
  [2587] = 1696,
  [2588] = 1492,
  [2589] = 1656,
  [2590] = 1488,
  [2591] = 1653,
  [2592] = 1530,
  [2593] = 1652,
  [2594] = 1649,
  [2595] = 1635,
  [2596] = 1675,
  [2597] = 1534,
  [2598] = 1634,
  [2599] = 1630,
  [2600] = 1629,
  [2601] = 1628,
  [2602] = 1694,
  [2603] = 1488,
  [2604] = 1527,
  [2605] = 1624,
  [2606] = 1801,
  [2607] = 1721,
  [2608] = 1530,
  [2609] = 1625,
  [2610] = 1494,
  [2611] = 1534,
  [2612] = 1703,
  [2613] = 1623,
  [2614] = 1622,
  [2615] = 1621,
  [2616] = 1620,
  [2617] = 1523,
  [2618] = 1726,
  [2619] = 1687,
  [2620] = 1682,
  [2621] = 1704,
  [2622] = 1778,
  [2623] = 1619,
  [2624] = 1618,
  [2625] = 1648,
  [2626] = 1617,
  [2627] = 1631,
  [2628] = 1609,
  [2629] = 1712,
  [2630] = 1616,
  [2631] = 1673,
  [2632] = 1800,
  [2633] = 1614,
  [2634] = 1612,
  [2635] = 1695,
  [2636] = 1611,
  [2637] = 1668,
  [2638] = 1717,
  [2639] = 1654,
  [2640] = 1727,
  [2641] = 1662,
  [2642] = 1666,
  [2643] = 1667,
  [2644] = 1718,
  [2645] = 1719,
  [2646] = 1670,
  [2647] = 1625,
  [2648] = 1674,
  [2649] = 1677,
  [2650] = 1706,
  [2651] = 1678,
  [2652] = 1664,
  [2653] = 1663,
  [2654] = 1679,
  [2655] = 1669,
  [2656] = 1535,
  [2657] = 1526,
  [2658] = 1524,
  [2659] = 1537,
  [2660] = 1535,
  [2661] = 1533,
  [2662] = 1680,
  [2663] = 1532,
  [2664] = 1716,
  [2665] = 1724,
  [2666] = 1528,
  [2667] = 1609,
  [2668] = 1722,
  [2669] = 1650,
  [2670] = 1647,
  [2671] = 1646,
  [2672] = 1645,
  [2673] = 1681,
  [2674] = 1644,
  [2675] = 1643,
  [2676] = 1685,
  [2677] = 1642,
  [2678] = 1686,
  [2679] = 1637,
  [2680] = 1775,
  [2681] = 1690,
  [2682] = 1691,
  [2683] = 1525,
  [2684] = 1536,
  [2685] = 1524,
  [2686] = 1787,
  [2687] = 1633,
  [2688] = 1632,
  [2689] = 1692,
  [2690] = 1537,
  [2691] = 1693,
  [2692] = 1697,
  [2693] = 1529,
  [2694] = 1615,
  [2695] = 1641,
  [2696] = 1723,
  [2697] = 1700,
  [2698] = 1830,
  [2699] = 1708,
  [2700] = 1529,
  [2701] = 1536,
  [2702] = 1525,
  [2703] = 1533,
  [2704] = 1532,
  [2705] = 1531,
  [2706] = 1720,
  [2707] = 1710,
  [2708] = 1528,
  [2709] = 1713,
  [2710] = 1714,
  [2711] = 1553,
  [2712] = 1504,
  [2713] = 1494,
  [2714] = 1550,
  [2715] = 1502,
  [2716] = 1510,
  [2717] = 1711,
  [2718] = 1509,
  [2719] = 1492,
  [2720] = 1506,
  [2721] = 1511,
  [2722] = 1702,
  [2723] = 1549,
  [2724] = 2724,
  [2725] = 1551,
  [2726] = 1552,
  [2727] = 2195,
  [2728] = 1548,
  [2729] = 1548,
  [2730] = 2730,
  [2731] = 2730,
  [2732] = 2730,
  [2733] = 2733,
  [2734] = 1492,
  [2735] = 2733,
  [2736] = 2733,
  [2737] = 1499,
  [2738] = 2733,
  [2739] = 2730,
  [2740] = 2730,
  [2741] = 2195,
  [2742] = 2733,
  [2743] = 2733,
  [2744] = 2730,
  [2745] = 1496,
  [2746] = 2730,
  [2747] = 2730,
  [2748] = 2733,
  [2749] = 2733,
  [2750] = 2730,
  [2751] = 2733,
  [2752] = 2733,
  [2753] = 2730,
  [2754] = 2733,
  [2755] = 2730,
  [2756] = 2733,
  [2757] = 1550,
  [2758] = 2733,
  [2759] = 2730,
  [2760] = 2733,
  [2761] = 2730,
  [2762] = 2733,
  [2763] = 2733,
  [2764] = 2730,
  [2765] = 2733,
  [2766] = 1553,
  [2767] = 1552,
  [2768] = 2733,
  [2769] = 2730,
  [2770] = 2730,
  [2771] = 1497,
  [2772] = 2733,
  [2773] = 2730,
  [2774] = 2733,
  [2775] = 2730,
  [2776] = 2730,
  [2777] = 2733,
  [2778] = 2730,
  [2779] = 2733,
  [2780] = 2730,
  [2781] = 1551,
  [2782] = 2730,
  [2783] = 1492,
  [2784] = 2730,
  [2785] = 1498,
  [2786] = 1549,
  [2787] = 2730,
  [2788] = 1494,
  [2789] = 1494,
  [2790] = 2733,
  [2791] = 2733,
  [2792] = 1513,
  [2793] = 1520,
  [2794] = 1512,
  [2795] = 1522,
  [2796] = 1778,
  [2797] = 1521,
  [2798] = 1563,
  [2799] = 1805,
  [2800] = 1555,
  [2801] = 2801,
  [2802] = 1705,
  [2803] = 1516,
  [2804] = 1517,
  [2805] = 1500,
  [2806] = 1872,
  [2807] = 1780,
  [2808] = 1514,
  [2809] = 1518,
  [2810] = 1564,
  [2811] = 1519,
  [2812] = 1515,
  [2813] = 2813,
  [2814] = 1508,
  [2815] = 1799,
  [2816] = 1520,
  [2817] = 1522,
  [2818] = 1548,
  [2819] = 1521,
  [2820] = 1496,
  [2821] = 1605,
  [2822] = 1550,
  [2823] = 1484,
  [2824] = 1516,
  [2825] = 1519,
  [2826] = 1553,
  [2827] = 1518,
  [2828] = 1552,
  [2829] = 1587,
  [2830] = 1527,
  [2831] = 1551,
  [2832] = 1563,
  [2833] = 1517,
  [2834] = 1564,
  [2835] = 1498,
  [2836] = 1549,
  [2837] = 1525,
  [2838] = 1508,
  [2839] = 1705,
  [2840] = 1607,
  [2841] = 1598,
  [2842] = 1515,
  [2843] = 1530,
  [2844] = 1599,
  [2845] = 1526,
  [2846] = 1602,
  [2847] = 1498,
  [2848] = 1606,
  [2849] = 1514,
  [2850] = 1534,
  [2851] = 2851,
  [2852] = 1571,
  [2853] = 1523,
  [2854] = 1496,
  [2855] = 1513,
  [2856] = 1512,
  [2857] = 1555,
  [2858] = 1730,
  [2859] = 1588,
  [2860] = 1498,
  [2861] = 1563,
  [2862] = 1584,
  [2863] = 1518,
  [2864] = 1582,
  [2865] = 1581,
  [2866] = 2866,
  [2867] = 1519,
  [2868] = 2868,
  [2869] = 1500,
  [2870] = 2468,
  [2871] = 1600,
  [2872] = 1579,
  [2873] = 1577,
  [2874] = 1576,
  [2875] = 1575,
  [2876] = 1535,
  [2877] = 1573,
  [2878] = 1512,
  [2879] = 1513,
  [2880] = 1589,
  [2881] = 1524,
  [2882] = 1500,
  [2883] = 1514,
  [2884] = 1517,
  [2885] = 1537,
  [2886] = 1533,
  [2887] = 1532,
  [2888] = 1515,
  [2889] = 1516,
  [2890] = 1496,
  [2891] = 1586,
  [2892] = 1569,
  [2893] = 1590,
  [2894] = 1522,
  [2895] = 1594,
  [2896] = 1521,
  [2897] = 1520,
  [2898] = 1531,
  [2899] = 1528,
  [2900] = 1529,
  [2901] = 1747,
  [2902] = 1580,
  [2903] = 1508,
  [2904] = 1536,
  [2905] = 1611,
  [2906] = 1563,
  [2907] = 1621,
  [2908] = 1696,
  [2909] = 1695,
  [2910] = 1711,
  [2911] = 1684,
  [2912] = 2912,
  [2913] = 1683,
  [2914] = 1523,
  [2915] = 1486,
  [2916] = 1705,
  [2917] = 1676,
  [2918] = 1527,
  [2919] = 1673,
  [2920] = 1775,
  [2921] = 1672,
  [2922] = 1671,
  [2923] = 1657,
  [2924] = 1787,
  [2925] = 1530,
  [2926] = 1600,
  [2927] = 1656,
  [2928] = 1669,
  [2929] = 1573,
  [2930] = 1653,
  [2931] = 1652,
  [2932] = 1649,
  [2933] = 1635,
  [2934] = 1634,
  [2935] = 1630,
  [2936] = 1629,
  [2937] = 1628,
  [2938] = 1580,
  [2939] = 1534,
  [2940] = 1747,
  [2941] = 1702,
  [2942] = 1702,
  [2943] = 1535,
  [2944] = 1524,
  [2945] = 1800,
  [2946] = 1537,
  [2947] = 1533,
  [2948] = 1532,
  [2949] = 1531,
  [2950] = 1528,
  [2951] = 1529,
  [2952] = 1624,
  [2953] = 1536,
  [2954] = 1623,
  [2955] = 1622,
  [2956] = 1641,
  [2957] = 1730,
  [2958] = 1525,
  [2959] = 1619,
  [2960] = 1618,
  [2961] = 1615,
  [2962] = 1512,
  [2963] = 1617,
  [2964] = 1830,
  [2965] = 1616,
  [2966] = 1571,
  [2967] = 1801,
  [2968] = 1614,
  [2969] = 1612,
  [2970] = 1668,
  [2971] = 1648,
  [2972] = 1654,
  [2973] = 1662,
  [2974] = 1666,
  [2975] = 1667,
  [2976] = 1599,
  [2977] = 1598,
  [2978] = 1525,
  [2979] = 1670,
  [2980] = 1536,
  [2981] = 1529,
  [2982] = 1528,
  [2983] = 1531,
  [2984] = 1532,
  [2985] = 1526,
  [2986] = 1513,
  [2987] = 1514,
  [2988] = 1515,
  [2989] = 1516,
  [2990] = 1522,
  [2991] = 1521,
  [2992] = 1520,
  [2993] = 1519,
  [2994] = 1518,
  [2995] = 1533,
  [2996] = 1537,
  [2997] = 1524,
  [2998] = 1674,
  [2999] = 1677,
  [3000] = 1678,
  [3001] = 1679,
  [3002] = 1680,
  [3003] = 1681,
  [3004] = 1711,
  [3005] = 1685,
  [3006] = 1686,
  [3007] = 1690,
  [3008] = 1691,
  [3009] = 1692,
  [3010] = 1693,
  [3011] = 1697,
  [3012] = 1700,
  [3013] = 1706,
  [3014] = 1631,
  [3015] = 1708,
  [3016] = 1710,
  [3017] = 1713,
  [3018] = 1714,
  [3019] = 1720,
  [3020] = 1723,
  [3021] = 1689,
  [3022] = 1535,
  [3023] = 1534,
  [3024] = 1530,
  [3025] = 1632,
  [3026] = 1633,
  [3027] = 1599,
  [3028] = 1598,
  [3029] = 1517,
  [3030] = 1527,
  [3031] = 1594,
  [3032] = 1637,
  [3033] = 1642,
  [3034] = 1643,
  [3035] = 1644,
  [3036] = 1645,
  [3037] = 1646,
  [3038] = 1647,
  [3039] = 1650,
  [3040] = 1711,
  [3041] = 1867,
  [3042] = 1500,
  [3043] = 1508,
  [3044] = 1605,
  [3045] = 1517,
  [3046] = 1518,
  [3047] = 1519,
  [3048] = 1520,
  [3049] = 1521,
  [3050] = 1522,
  [3051] = 1508,
  [3052] = 1516,
  [3053] = 1590,
  [3054] = 1515,
  [3055] = 1514,
  [3056] = 1569,
  [3057] = 1663,
  [3058] = 1664,
  [3059] = 1675,
  [3060] = 1526,
  [3061] = 1682,
  [3062] = 1523,
  [3063] = 1687,
  [3064] = 1513,
  [3065] = 1586,
  [3066] = 1512,
  [3067] = 1510,
  [3068] = 1509,
  [3069] = 1721,
  [3070] = 1506,
  [3071] = 1620,
  [3072] = 1727,
  [3073] = 1500,
  [3074] = 1504,
  [3075] = 1502,
  [3076] = 1726,
  [3077] = 1725,
  [3078] = 1724,
  [3079] = 1722,
  [3080] = 1594,
  [3081] = 1590,
  [3082] = 1569,
  [3083] = 1586,
  [3084] = 1790,
  [3085] = 1511,
  [3086] = 1719,
  [3087] = 1607,
  [3088] = 1718,
  [3089] = 1717,
  [3090] = 1716,
  [3091] = 1712,
  [3092] = 1704,
  [3093] = 1703,
  [3094] = 1694,
  [3095] = 1589,
  [3096] = 1485,
  [3097] = 1602,
  [3098] = 1805,
  [3099] = 1799,
  [3100] = 1587,
  [3101] = 1582,
  [3102] = 1698,
  [3103] = 1610,
  [3104] = 1707,
  [3105] = 1563,
  [3106] = 1588,
  [3107] = 1778,
  [3108] = 1575,
  [3109] = 1576,
  [3110] = 1577,
  [3111] = 1579,
  [3112] = 1584,
  [3113] = 1581,
  [3114] = 1606,
  [3115] = 1872,
  [3116] = 1532,
  [3117] = 1563,
  [3118] = 3118,
  [3119] = 3119,
  [3120] = 3119,
  [3121] = 3121,
  [3122] = 3121,
  [3123] = 1683,
  [3124] = 1676,
  [3125] = 1512,
  [3126] = 3126,
  [3127] = 1673,
  [3128] = 1513,
  [3129] = 1514,
  [3130] = 1515,
  [3131] = 1516,
  [3132] = 1672,
  [3133] = 1522,
  [3134] = 3119,
  [3135] = 1599,
  [3136] = 1598,
  [3137] = 1594,
  [3138] = 1590,
  [3139] = 1569,
  [3140] = 1586,
  [3141] = 3121,
  [3142] = 1599,
  [3143] = 1671,
  [3144] = 1598,
  [3145] = 1521,
  [3146] = 1520,
  [3147] = 1594,
  [3148] = 1590,
  [3149] = 1569,
  [3150] = 1586,
  [3151] = 1519,
  [3152] = 1518,
  [3153] = 1624,
  [3154] = 3126,
  [3155] = 3119,
  [3156] = 3156,
  [3157] = 1656,
  [3158] = 1653,
  [3159] = 1652,
  [3160] = 1649,
  [3161] = 1635,
  [3162] = 1517,
  [3163] = 1634,
  [3164] = 3118,
  [3165] = 1488,
  [3166] = 1698,
  [3167] = 3126,
  [3168] = 3126,
  [3169] = 3169,
  [3170] = 3119,
  [3171] = 3121,
  [3172] = 3118,
  [3173] = 3118,
  [3174] = 1696,
  [3175] = 3169,
  [3176] = 3126,
  [3177] = 3118,
  [3178] = 1684,
  [3179] = 3126,
  [3180] = 3121,
  [3181] = 3121,
  [3182] = 3169,
  [3183] = 3121,
  [3184] = 3121,
  [3185] = 3119,
  [3186] = 3169,
  [3187] = 1508,
  [3188] = 3169,
  [3189] = 1500,
  [3190] = 3118,
  [3191] = 3126,
  [3192] = 3119,
  [3193] = 3121,
  [3194] = 3126,
  [3195] = 1780,
  [3196] = 1711,
  [3197] = 3169,
  [3198] = 1625,
  [3199] = 3118,
  [3200] = 1609,
  [3201] = 3118,
  [3202] = 3118,
  [3203] = 3169,
  [3204] = 3169,
  [3205] = 3119,
  [3206] = 3121,
  [3207] = 3119,
  [3208] = 3121,
  [3209] = 3119,
  [3210] = 3121,
  [3211] = 3126,
  [3212] = 3126,
  [3213] = 3213,
  [3214] = 1527,
  [3215] = 1530,
  [3216] = 1695,
  [3217] = 1630,
  [3218] = 1629,
  [3219] = 3121,
  [3220] = 3119,
  [3221] = 1555,
  [3222] = 3121,
  [3223] = 3169,
  [3224] = 3119,
  [3225] = 3119,
  [3226] = 3121,
  [3227] = 3119,
  [3228] = 1694,
  [3229] = 1703,
  [3230] = 3126,
  [3231] = 1704,
  [3232] = 1712,
  [3233] = 1628,
  [3234] = 1716,
  [3235] = 3169,
  [3236] = 3169,
  [3237] = 1717,
  [3238] = 1718,
  [3239] = 3118,
  [3240] = 3118,
  [3241] = 1719,
  [3242] = 1867,
  [3243] = 3118,
  [3244] = 3169,
  [3245] = 1778,
  [3246] = 1707,
  [3247] = 3119,
  [3248] = 3118,
  [3249] = 1564,
  [3250] = 3119,
  [3251] = 3119,
  [3252] = 3126,
  [3253] = 3118,
  [3254] = 3121,
  [3255] = 3169,
  [3256] = 1702,
  [3257] = 1722,
  [3258] = 1724,
  [3259] = 3121,
  [3260] = 3126,
  [3261] = 3121,
  [3262] = 3121,
  [3263] = 1705,
  [3264] = 3119,
  [3265] = 3121,
  [3266] = 3119,
  [3267] = 3121,
  [3268] = 1711,
  [3269] = 3126,
  [3270] = 3118,
  [3271] = 3169,
  [3272] = 3169,
  [3273] = 3126,
  [3274] = 3126,
  [3275] = 3169,
  [3276] = 3118,
  [3277] = 3118,
  [3278] = 1534,
  [3279] = 1725,
  [3280] = 1657,
  [3281] = 3169,
  [3282] = 3126,
  [3283] = 1799,
  [3284] = 3118,
  [3285] = 3169,
  [3286] = 3126,
  [3287] = 3126,
  [3288] = 1527,
  [3289] = 3121,
  [3290] = 3119,
  [3291] = 1726,
  [3292] = 1790,
  [3293] = 3126,
  [3294] = 1727,
  [3295] = 1669,
  [3296] = 3169,
  [3297] = 3126,
  [3298] = 1535,
  [3299] = 1524,
  [3300] = 1537,
  [3301] = 1533,
  [3302] = 1620,
  [3303] = 1525,
  [3304] = 3126,
  [3305] = 1536,
  [3306] = 1801,
  [3307] = 1529,
  [3308] = 1528,
  [3309] = 3169,
  [3310] = 1531,
  [3311] = 1532,
  [3312] = 1533,
  [3313] = 1537,
  [3314] = 3119,
  [3315] = 1524,
  [3316] = 1535,
  [3317] = 1623,
  [3318] = 1622,
  [3319] = 1621,
  [3320] = 1531,
  [3321] = 3118,
  [3322] = 1528,
  [3323] = 1619,
  [3324] = 1618,
  [3325] = 1529,
  [3326] = 1534,
  [3327] = 1805,
  [3328] = 1530,
  [3329] = 1536,
  [3330] = 1721,
  [3331] = 3126,
  [3332] = 1617,
  [3333] = 1525,
  [3334] = 1616,
  [3335] = 1830,
  [3336] = 1800,
  [3337] = 1614,
  [3338] = 3119,
  [3339] = 1612,
  [3340] = 1611,
  [3341] = 1668,
  [3342] = 1648,
  [3343] = 1654,
  [3344] = 1702,
  [3345] = 1662,
  [3346] = 3169,
  [3347] = 1666,
  [3348] = 3118,
  [3349] = 1667,
  [3350] = 3126,
  [3351] = 3121,
  [3352] = 3169,
  [3353] = 3169,
  [3354] = 1646,
  [3355] = 1670,
  [3356] = 1689,
  [3357] = 1615,
  [3358] = 1780,
  [3359] = 1526,
  [3360] = 3118,
  [3361] = 1872,
  [3362] = 1687,
  [3363] = 1523,
  [3364] = 1682,
  [3365] = 1523,
  [3366] = 1526,
  [3367] = 1674,
  [3368] = 1677,
  [3369] = 1678,
  [3370] = 1679,
  [3371] = 1680,
  [3372] = 1681,
  [3373] = 1685,
  [3374] = 1686,
  [3375] = 1690,
  [3376] = 1691,
  [3377] = 1692,
  [3378] = 3118,
  [3379] = 1675,
  [3380] = 1693,
  [3381] = 1697,
  [3382] = 1700,
  [3383] = 1706,
  [3384] = 1708,
  [3385] = 1710,
  [3386] = 1713,
  [3387] = 1714,
  [3388] = 1720,
  [3389] = 1723,
  [3390] = 1641,
  [3391] = 3118,
  [3392] = 3119,
  [3393] = 3169,
  [3394] = 1632,
  [3395] = 1664,
  [3396] = 1633,
  [3397] = 1787,
  [3398] = 1631,
  [3399] = 1775,
  [3400] = 1637,
  [3401] = 1642,
  [3402] = 1643,
  [3403] = 1644,
  [3404] = 1645,
  [3405] = 3118,
  [3406] = 1647,
  [3407] = 1650,
  [3408] = 1663,
  [3409] = 1610,
  [3410] = 3121,
  [3411] = 3119,
  [3412] = 1607,
  [3413] = 1575,
  [3414] = 1515,
  [3415] = 1513,
  [3416] = 1516,
  [3417] = 1522,
  [3418] = 1521,
  [3419] = 1520,
  [3420] = 1519,
  [3421] = 1518,
  [3422] = 1517,
  [3423] = 3423,
  [3424] = 1778,
  [3425] = 1805,
  [3426] = 1512,
  [3427] = 1707,
  [3428] = 1698,
  [3429] = 1610,
  [3430] = 1594,
  [3431] = 1609,
  [3432] = 1625,
  [3433] = 1508,
  [3434] = 1500,
  [3435] = 1600,
  [3436] = 1573,
  [3437] = 1580,
  [3438] = 1747,
  [3439] = 1510,
  [3440] = 1799,
  [3441] = 1509,
  [3442] = 1506,
  [3443] = 1587,
  [3444] = 1730,
  [3445] = 1571,
  [3446] = 1504,
  [3447] = 1502,
  [3448] = 1780,
  [3449] = 3449,
  [3450] = 1532,
  [3451] = 1602,
  [3452] = 1606,
  [3453] = 1588,
  [3454] = 1584,
  [3455] = 1582,
  [3456] = 1581,
  [3457] = 1579,
  [3458] = 1577,
  [3459] = 1576,
  [3460] = 1511,
  [3461] = 1589,
  [3462] = 1526,
  [3463] = 1523,
  [3464] = 1527,
  [3465] = 1530,
  [3466] = 1534,
  [3467] = 1535,
  [3468] = 1524,
  [3469] = 1537,
  [3470] = 1533,
  [3471] = 1599,
  [3472] = 1514,
  [3473] = 1531,
  [3474] = 1598,
  [3475] = 1528,
  [3476] = 1529,
  [3477] = 1536,
  [3478] = 3478,
  [3479] = 1525,
  [3480] = 2724,
  [3481] = 1872,
  [3482] = 1790,
  [3483] = 1563,
  [3484] = 1605,
  [3485] = 1586,
  [3486] = 1569,
  [3487] = 1590,
  [3488] = 1778,
  [3489] = 1725,
  [3490] = 3490,
  [3491] = 3491,
  [3492] = 3492,
  [3493] = 1548,
  [3494] = 1553,
  [3495] = 1525,
  [3496] = 1536,
  [3497] = 1529,
  [3498] = 1552,
  [3499] = 1528,
  [3500] = 1531,
  [3501] = 1532,
  [3502] = 1500,
  [3503] = 1508,
  [3504] = 1517,
  [3505] = 1533,
  [3506] = 1537,
  [3507] = 1524,
  [3508] = 1535,
  [3509] = 1519,
  [3510] = 1520,
  [3511] = 1534,
  [3512] = 1530,
  [3513] = 1521,
  [3514] = 1527,
  [3515] = 1551,
  [3516] = 1549,
  [3517] = 1522,
  [3518] = 1516,
  [3519] = 1599,
  [3520] = 1598,
  [3521] = 1594,
  [3522] = 1590,
  [3523] = 1799,
  [3524] = 1569,
  [3525] = 1586,
  [3526] = 1515,
  [3527] = 1488,
  [3528] = 1526,
  [3529] = 1523,
  [3530] = 1514,
  [3531] = 1488,
  [3532] = 1609,
  [3533] = 1625,
  [3534] = 1513,
  [3535] = 1512,
  [3536] = 1518,
  [3537] = 1694,
  [3538] = 1703,
  [3539] = 1704,
  [3540] = 1712,
  [3541] = 1716,
  [3542] = 1717,
  [3543] = 1718,
  [3544] = 1719,
  [3545] = 1805,
  [3546] = 1722,
  [3547] = 1724,
  [3548] = 1790,
  [3549] = 1726,
  [3550] = 1727,
  [3551] = 1867,
  [3552] = 1696,
  [3553] = 1695,
  [3554] = 1684,
  [3555] = 1683,
  [3556] = 1676,
  [3557] = 1673,
  [3558] = 1672,
  [3559] = 1671,
  [3560] = 1657,
  [3561] = 1656,
  [3562] = 1653,
  [3563] = 1652,
  [3564] = 1649,
  [3565] = 1635,
  [3566] = 1634,
  [3567] = 1630,
  [3568] = 1629,
  [3569] = 1628,
  [3570] = 1624,
  [3571] = 1801,
  [3572] = 1623,
  [3573] = 1622,
  [3574] = 1621,
  [3575] = 1619,
  [3576] = 1618,
  [3577] = 1707,
  [3578] = 1617,
  [3579] = 1631,
  [3580] = 1616,
  [3581] = 1830,
  [3582] = 1800,
  [3583] = 1614,
  [3584] = 1612,
  [3585] = 1611,
  [3586] = 1620,
  [3587] = 1668,
  [3588] = 1648,
  [3589] = 1654,
  [3590] = 1662,
  [3591] = 1666,
  [3592] = 1667,
  [3593] = 1872,
  [3594] = 1670,
  [3595] = 1674,
  [3596] = 1677,
  [3597] = 1678,
  [3598] = 1679,
  [3599] = 1680,
  [3600] = 1681,
  [3601] = 1685,
  [3602] = 1686,
  [3603] = 1690,
  [3604] = 1691,
  [3605] = 1692,
  [3606] = 1693,
  [3607] = 1697,
  [3608] = 1700,
  [3609] = 1706,
  [3610] = 1721,
  [3611] = 1708,
  [3612] = 1710,
  [3613] = 1713,
  [3614] = 1714,
  [3615] = 1720,
  [3616] = 1723,
  [3617] = 1641,
  [3618] = 1615,
  [3619] = 1632,
  [3620] = 1633,
  [3621] = 1787,
  [3622] = 1550,
  [3623] = 1775,
  [3624] = 1637,
  [3625] = 1642,
  [3626] = 1643,
  [3627] = 1644,
  [3628] = 1645,
  [3629] = 1646,
  [3630] = 1647,
  [3631] = 1650,
  [3632] = 1610,
  [3633] = 1689,
  [3634] = 1698,
  [3635] = 1669,
  [3636] = 1663,
  [3637] = 1664,
  [3638] = 1675,
  [3639] = 1682,
  [3640] = 1687,
  [3641] = 1780,
  [3642] = 1488,
  [3643] = 1488,
  [3644] = 1563,
  [3645] = 2801,
  [3646] = 3646,
  [3647] = 1526,
  [3648] = 1523,
  [3649] = 1527,
  [3650] = 1530,
  [3651] = 1534,
  [3652] = 1563,
  [3653] = 2813,
  [3654] = 1488,
  [3655] = 1535,
  [3656] = 1524,
  [3657] = 1537,
  [3658] = 1533,
  [3659] = 1494,
  [3660] = 1492,
  [3661] = 1702,
  [3662] = 1532,
  [3663] = 1531,
  [3664] = 1528,
  [3665] = 1529,
  [3666] = 1536,
  [3667] = 1488,
  [3668] = 1525,
  [3669] = 1564,
  [3670] = 1610,
  [3671] = 1488,
  [3672] = 1705,
  [3673] = 1711,
  [3674] = 3674,
  [3675] = 3675,
  [3676] = 1549,
  [3677] = 1488,
  [3678] = 1747,
  [3679] = 1730,
  [3680] = 2868,
  [3681] = 3681,
  [3682] = 3682,
  [3683] = 1553,
  [3684] = 1552,
  [3685] = 3685,
  [3686] = 3686,
  [3687] = 1790,
  [3688] = 3688,
  [3689] = 1551,
  [3690] = 1599,
  [3691] = 1598,
  [3692] = 2851,
  [3693] = 1594,
  [3694] = 1590,
  [3695] = 1569,
  [3696] = 1586,
  [3697] = 1550,
  [3698] = 3698,
  [3699] = 3699,
  [3700] = 2866,
  [3701] = 3701,
  [3702] = 1548,
  [3703] = 1555,
  [3704] = 1707,
  [3705] = 1698,
  [3706] = 1494,
  [3707] = 1594,
  [3708] = 3708,
  [3709] = 1599,
  [3710] = 3710,
  [3711] = 1598,
  [3712] = 1571,
  [3713] = 1605,
  [3714] = 3714,
  [3715] = 1587,
  [3716] = 1711,
  [3717] = 1580,
  [3718] = 1805,
  [3719] = 3708,
  [3720] = 1702,
  [3721] = 1607,
  [3722] = 3722,
  [3723] = 3723,
  [3724] = 3724,
  [3725] = 1801,
  [3726] = 1830,
  [3727] = 3722,
  [3728] = 1573,
  [3729] = 1800,
  [3730] = 1600,
  [3731] = 3731,
  [3732] = 1602,
  [3733] = 1492,
  [3734] = 1606,
  [3735] = 1494,
  [3736] = 1775,
  [3737] = 1575,
  [3738] = 1799,
  [3739] = 3739,
  [3740] = 1576,
  [3741] = 1577,
  [3742] = 1579,
  [3743] = 3743,
  [3744] = 1787,
  [3745] = 1590,
  [3746] = 1569,
  [3747] = 1581,
  [3748] = 1586,
  [3749] = 3749,
  [3750] = 1582,
  [3751] = 1711,
  [3752] = 3752,
  [3753] = 1584,
  [3754] = 1589,
  [3755] = 3755,
  [3756] = 3756,
  [3757] = 1492,
  [3758] = 1588,
  [3759] = 1702,
  [3760] = 1646,
  [3761] = 1711,
  [3762] = 1723,
  [3763] = 3763,
  [3764] = 1686,
  [3765] = 1641,
  [3766] = 1624,
  [3767] = 1563,
  [3768] = 1623,
  [3769] = 1622,
  [3770] = 1615,
  [3771] = 1778,
  [3772] = 1621,
  [3773] = 1714,
  [3774] = 1517,
  [3775] = 1632,
  [3776] = 1666,
  [3777] = 1713,
  [3778] = 1508,
  [3779] = 1500,
  [3780] = 1710,
  [3781] = 1515,
  [3782] = 1708,
  [3783] = 3763,
  [3784] = 1706,
  [3785] = 1700,
  [3786] = 1657,
  [3787] = 1670,
  [3788] = 3763,
  [3789] = 3763,
  [3790] = 1697,
  [3791] = 3763,
  [3792] = 3763,
  [3793] = 1518,
  [3794] = 3763,
  [3795] = 1674,
  [3796] = 3763,
  [3797] = 1662,
  [3798] = 1494,
  [3799] = 1654,
  [3800] = 1648,
  [3801] = 1668,
  [3802] = 1693,
  [3803] = 1611,
  [3804] = 3763,
  [3805] = 1612,
  [3806] = 1692,
  [3807] = 1625,
  [3808] = 1647,
  [3809] = 1494,
  [3810] = 1696,
  [3811] = 1695,
  [3812] = 1517,
  [3813] = 1492,
  [3814] = 1519,
  [3815] = 1684,
  [3816] = 1520,
  [3817] = 1614,
  [3818] = 1683,
  [3819] = 1676,
  [3820] = 1492,
  [3821] = 1494,
  [3822] = 1691,
  [3823] = 1555,
  [3824] = 1609,
  [3825] = 1673,
  [3826] = 1672,
  [3827] = 1671,
  [3828] = 3763,
  [3829] = 1521,
  [3830] = 1522,
  [3831] = 1492,
  [3832] = 1516,
  [3833] = 1690,
  [3834] = 1616,
  [3835] = 1619,
  [3836] = 1564,
  [3837] = 1633,
  [3838] = 1515,
  [3839] = 3763,
  [3840] = 1631,
  [3841] = 1496,
  [3842] = 1637,
  [3843] = 1642,
  [3844] = 1702,
  [3845] = 1656,
  [3846] = 1617,
  [3847] = 1643,
  [3848] = 1677,
  [3849] = 1514,
  [3850] = 1513,
  [3851] = 1498,
  [3852] = 1644,
  [3853] = 1512,
  [3854] = 1872,
  [3855] = 1508,
  [3856] = 1694,
  [3857] = 1518,
  [3858] = 1703,
  [3859] = 1650,
  [3860] = 1653,
  [3861] = 1704,
  [3862] = 1712,
  [3863] = 1716,
  [3864] = 1519,
  [3865] = 1717,
  [3866] = 1652,
  [3867] = 1649,
  [3868] = 1500,
  [3869] = 1718,
  [3870] = 1635,
  [3871] = 1678,
  [3872] = 1628,
  [3873] = 1492,
  [3874] = 1629,
  [3875] = 1719,
  [3876] = 1720,
  [3877] = 1634,
  [3878] = 1645,
  [3879] = 1520,
  [3880] = 1685,
  [3881] = 1630,
  [3882] = 1521,
  [3883] = 1702,
  [3884] = 1522,
  [3885] = 1722,
  [3886] = 1724,
  [3887] = 3763,
  [3888] = 1725,
  [3889] = 1681,
  [3890] = 1705,
  [3891] = 1516,
  [3892] = 1514,
  [3893] = 1669,
  [3894] = 1726,
  [3895] = 1663,
  [3896] = 1727,
  [3897] = 1664,
  [3898] = 3763,
  [3899] = 1675,
  [3900] = 1620,
  [3901] = 1682,
  [3902] = 1687,
  [3903] = 3763,
  [3904] = 1680,
  [3905] = 1721,
  [3906] = 1513,
  [3907] = 1494,
  [3908] = 1512,
  [3909] = 3763,
  [3910] = 1618,
  [3911] = 1667,
  [3912] = 1679,
  [3913] = 1711,
  [3914] = 1867,
  [3915] = 1689,
  [3916] = 1780,
  [3917] = 1512,
  [3918] = 1575,
  [3919] = 1523,
  [3920] = 1535,
  [3921] = 3921,
  [3922] = 1523,
  [3923] = 1598,
  [3924] = 1526,
  [3925] = 1584,
  [3926] = 3926,
  [3927] = 1582,
  [3928] = 3928,
  [3929] = 1605,
  [3930] = 1525,
  [3931] = 1532,
  [3932] = 1581,
  [3933] = 1517,
  [3934] = 1533,
  [3935] = 1537,
  [3936] = 1580,
  [3937] = 1579,
  [3938] = 1524,
  [3939] = 1577,
  [3940] = 1573,
  [3941] = 1600,
  [3942] = 1576,
  [3943] = 1492,
  [3944] = 1872,
  [3945] = 1563,
  [3946] = 1536,
  [3947] = 1747,
  [3948] = 1528,
  [3949] = 1529,
  [3950] = 1494,
  [3951] = 1526,
  [3952] = 1530,
  [3953] = 1524,
  [3954] = 1492,
  [3955] = 1528,
  [3956] = 1535,
  [3957] = 1534,
  [3958] = 1587,
  [3959] = 1525,
  [3960] = 1531,
  [3961] = 1500,
  [3962] = 1532,
  [3963] = 1711,
  [3964] = 3964,
  [3965] = 3965,
  [3966] = 1527,
  [3967] = 1599,
  [3968] = 1594,
  [3969] = 1513,
  [3970] = 3970,
  [3971] = 1514,
  [3972] = 1515,
  [3973] = 1516,
  [3974] = 1522,
  [3975] = 1521,
  [3976] = 1520,
  [3977] = 1519,
  [3978] = 1518,
  [3979] = 1494,
  [3980] = 1780,
  [3981] = 1588,
  [3982] = 1536,
  [3983] = 1531,
  [3984] = 3928,
  [3985] = 1529,
  [3986] = 3986,
  [3987] = 1805,
  [3988] = 1730,
  [3989] = 1589,
  [3990] = 1508,
  [3991] = 1533,
  [3992] = 1586,
  [3993] = 1537,
  [3994] = 1569,
  [3995] = 1778,
  [3996] = 1590,
  [3997] = 1517,
  [3998] = 1799,
  [3999] = 1527,
  [4000] = 1530,
  [4001] = 1534,
  [4002] = 4002,
  [4003] = 1702,
  [4004] = 1508,
  [4005] = 1518,
  [4006] = 1519,
  [4007] = 1520,
  [4008] = 1500,
  [4009] = 1607,
  [4010] = 1521,
  [4011] = 1522,
  [4012] = 1516,
  [4013] = 1515,
  [4014] = 1514,
  [4015] = 1606,
  [4016] = 1513,
  [4017] = 1512,
  [4018] = 1571,
  [4019] = 1602,
  [4020] = 1681,
  [4021] = 1631,
  [4022] = 1599,
  [4023] = 1530,
  [4024] = 1527,
  [4025] = 1635,
  [4026] = 1630,
  [4027] = 1629,
  [4028] = 1694,
  [4029] = 1534,
  [4030] = 1649,
  [4031] = 1652,
  [4032] = 1535,
  [4033] = 1524,
  [4034] = 1703,
  [4035] = 1653,
  [4036] = 1537,
  [4037] = 1704,
  [4038] = 1533,
  [4039] = 1526,
  [4040] = 1532,
  [4041] = 1872,
  [4042] = 1594,
  [4043] = 1526,
  [4044] = 1712,
  [4045] = 1529,
  [4046] = 1536,
  [4047] = 1716,
  [4048] = 1717,
  [4049] = 1525,
  [4050] = 1718,
  [4051] = 1657,
  [4052] = 1719,
  [4053] = 1528,
  [4054] = 1930,
  [4055] = 1722,
  [4056] = 1586,
  [4057] = 1693,
  [4058] = 1778,
  [4059] = 1511,
  [4060] = 1799,
  [4061] = 1502,
  [4062] = 1724,
  [4063] = 1512,
  [4064] = 1513,
  [4065] = 1514,
  [4066] = 1692,
  [4067] = 1697,
  [4068] = 1516,
  [4069] = 1522,
  [4070] = 1725,
  [4071] = 1726,
  [4072] = 1569,
  [4073] = 1590,
  [4074] = 1674,
  [4075] = 1656,
  [4076] = 1727,
  [4077] = 1707,
  [4078] = 1620,
  [4079] = 1721,
  [4080] = 1504,
  [4081] = 1527,
  [4082] = 1700,
  [4083] = 1691,
  [4084] = 1689,
  [4085] = 1698,
  [4086] = 1780,
  [4087] = 1521,
  [4088] = 1624,
  [4089] = 1520,
  [4090] = 1519,
  [4091] = 1598,
  [4092] = 1676,
  [4093] = 1867,
  [4094] = 1530,
  [4095] = 1518,
  [4096] = 1711,
  [4097] = 1628,
  [4098] = 1517,
  [4099] = 1790,
  [4100] = 1706,
  [4101] = 1687,
  [4102] = 1867,
  [4103] = 1801,
  [4104] = 1696,
  [4105] = 1623,
  [4106] = 1622,
  [4107] = 1621,
  [4108] = 1780,
  [4109] = 4109,
  [4110] = 4110,
  [4111] = 1682,
  [4112] = 1525,
  [4113] = 1690,
  [4114] = 1708,
  [4115] = 1619,
  [4116] = 1675,
  [4117] = 1618,
  [4118] = 1671,
  [4119] = 1617,
  [4120] = 1672,
  [4121] = 1634,
  [4122] = 1616,
  [4123] = 1673,
  [4124] = 1664,
  [4125] = 1663,
  [4126] = 4126,
  [4127] = 1683,
  [4128] = 1669,
  [4129] = 1830,
  [4130] = 1800,
  [4131] = 1614,
  [4132] = 1612,
  [4133] = 1611,
  [4134] = 1668,
  [4135] = 1648,
  [4136] = 1654,
  [4137] = 1662,
  [4138] = 1666,
  [4139] = 1667,
  [4140] = 1523,
  [4141] = 1805,
  [4142] = 4142,
  [4143] = 1610,
  [4144] = 1534,
  [4145] = 1686,
  [4146] = 1684,
  [4147] = 1670,
  [4148] = 1650,
  [4149] = 1647,
  [4150] = 1646,
  [4151] = 1685,
  [4152] = 1523,
  [4153] = 1645,
  [4154] = 1515,
  [4155] = 1644,
  [4156] = 1872,
  [4157] = 1710,
  [4158] = 1643,
  [4159] = 1642,
  [4160] = 1510,
  [4161] = 1500,
  [4162] = 1713,
  [4163] = 1702,
  [4164] = 1637,
  [4165] = 1775,
  [4166] = 1714,
  [4167] = 1536,
  [4168] = 1509,
  [4169] = 1787,
  [4170] = 1506,
  [4171] = 1695,
  [4172] = 1633,
  [4173] = 1535,
  [4174] = 1720,
  [4175] = 1723,
  [4176] = 1677,
  [4177] = 1632,
  [4178] = 1524,
  [4179] = 1537,
  [4180] = 1533,
  [4181] = 1532,
  [4182] = 1531,
  [4183] = 1615,
  [4184] = 1678,
  [4185] = 3490,
  [4186] = 1528,
  [4187] = 1508,
  [4188] = 1529,
  [4189] = 1679,
  [4190] = 1680,
  [4191] = 1531,
  [4192] = 1641,
  [4193] = 1524,
  [4194] = 1537,
  [4195] = 1533,
  [4196] = 1532,
  [4197] = 1531,
  [4198] = 1528,
  [4199] = 1529,
  [4200] = 1536,
  [4201] = 1525,
  [4202] = 1780,
  [4203] = 1872,
  [4204] = 1534,
  [4205] = 1496,
  [4206] = 1702,
  [4207] = 1498,
  [4208] = 4208,
  [4209] = 1530,
  [4210] = 1526,
  [4211] = 1523,
  [4212] = 4212,
  [4213] = 1535,
  [4214] = 4214,
  [4215] = 1527,
  [4216] = 4216,
  [4217] = 4217,
  [4218] = 4218,
  [4219] = 4219,
  [4220] = 1711,
  [4221] = 3688,
  [4222] = 1518,
  [4223] = 1780,
  [4224] = 1500,
  [4225] = 1508,
  [4226] = 1515,
  [4227] = 1872,
  [4228] = 3685,
  [4229] = 1488,
  [4230] = 3674,
  [4231] = 3681,
  [4232] = 3675,
  [4233] = 3686,
  [4234] = 1516,
  [4235] = 1517,
  [4236] = 1512,
  [4237] = 1513,
  [4238] = 1522,
  [4239] = 1514,
  [4240] = 1521,
  [4241] = 1520,
  [4242] = 1519,
  [4243] = 1498,
  [4244] = 1533,
  [4245] = 1527,
  [4246] = 1496,
  [4247] = 1551,
  [4248] = 1530,
  [4249] = 1534,
  [4250] = 1537,
  [4251] = 1549,
  [4252] = 1535,
  [4253] = 1524,
  [4254] = 1536,
  [4255] = 1488,
  [4256] = 4256,
  [4257] = 1525,
  [4258] = 1488,
  [4259] = 1529,
  [4260] = 1548,
  [4261] = 1523,
  [4262] = 4262,
  [4263] = 1532,
  [4264] = 4264,
  [4265] = 1550,
  [4266] = 1526,
  [4267] = 1552,
  [4268] = 1553,
  [4269] = 1528,
  [4270] = 1531,
  [4271] = 1502,
  [4272] = 1496,
  [4273] = 1506,
  [4274] = 1511,
  [4275] = 1702,
  [4276] = 1509,
  [4277] = 1510,
  [4278] = 1504,
  [4279] = 1711,
  [4280] = 1496,
  [4281] = 1498,
  [4282] = 1498,
  [4283] = 1488,
  [4284] = 3928,
  [4285] = 1555,
  [4286] = 1563,
  [4287] = 3970,
  [4288] = 4264,
  [4289] = 1705,
  [4290] = 1494,
  [4291] = 3928,
  [4292] = 1488,
  [4293] = 1492,
  [4294] = 1711,
  [4295] = 1702,
  [4296] = 4256,
  [4297] = 1702,
  [4298] = 1600,
  [4299] = 1780,
  [4300] = 1575,
  [4301] = 1607,
  [4302] = 4126,
  [4303] = 1589,
  [4304] = 4110,
  [4305] = 1563,
  [4306] = 1576,
  [4307] = 1577,
  [4308] = 1579,
  [4309] = 1492,
  [4310] = 4109,
  [4311] = 1730,
  [4312] = 1564,
  [4313] = 1587,
  [4314] = 1492,
  [4315] = 1602,
  [4316] = 1496,
  [4317] = 1581,
  [4318] = 1702,
  [4319] = 1747,
  [4320] = 1582,
  [4321] = 1606,
  [4322] = 1580,
  [4323] = 1711,
  [4324] = 4142,
  [4325] = 1711,
  [4326] = 1494,
  [4327] = 1498,
  [4328] = 1707,
  [4329] = 1494,
  [4330] = 1705,
  [4331] = 1588,
  [4332] = 1573,
  [4333] = 1605,
  [4334] = 1584,
  [4335] = 1590,
  [4336] = 2195,
  [4337] = 1830,
  [4338] = 1698,
  [4339] = 4212,
  [4340] = 1790,
  [4341] = 4341,
  [4342] = 1594,
  [4343] = 1872,
  [4344] = 4216,
  [4345] = 1551,
  [4346] = 1553,
  [4347] = 4217,
  [4348] = 4214,
  [4349] = 1805,
  [4350] = 1548,
  [4351] = 1571,
  [4352] = 1550,
  [4353] = 1552,
  [4354] = 1801,
  [4355] = 4218,
  [4356] = 1800,
  [4357] = 1697,
  [4358] = 1549,
  [4359] = 1780,
  [4360] = 1707,
  [4361] = 1872,
  [4362] = 1799,
  [4363] = 1569,
  [4364] = 1586,
  [4365] = 1610,
  [4366] = 1598,
  [4367] = 1586,
  [4368] = 1599,
  [4369] = 1569,
  [4370] = 1711,
  [4371] = 1590,
  [4372] = 1775,
  [4373] = 1598,
  [4374] = 1702,
  [4375] = 1787,
  [4376] = 1599,
  [4377] = 4208,
  [4378] = 1594,
  [4379] = 4379,
  [4380] = 1724,
  [4381] = 1628,
  [4382] = 1629,
  [4383] = 1630,
  [4384] = 1637,
  [4385] = 1647,
  [4386] = 4386,
  [4387] = 1646,
  [4388] = 1610,
  [4389] = 1702,
  [4390] = 1634,
  [4391] = 1645,
  [4392] = 1635,
  [4393] = 1492,
  [4394] = 1649,
  [4395] = 1652,
  [4396] = 1644,
  [4397] = 1653,
  [4398] = 1698,
  [4399] = 1643,
  [4400] = 1633,
  [4401] = 1632,
  [4402] = 1624,
  [4403] = 4403,
  [4404] = 1615,
  [4405] = 1623,
  [4406] = 1778,
  [4407] = 1656,
  [4408] = 1642,
  [4409] = 1622,
  [4410] = 1650,
  [4411] = 1609,
  [4412] = 1621,
  [4413] = 1641,
  [4414] = 1723,
  [4415] = 1720,
  [4416] = 1714,
  [4417] = 1713,
  [4418] = 1710,
  [4419] = 1708,
  [4420] = 1706,
  [4421] = 1700,
  [4422] = 1669,
  [4423] = 1563,
  [4424] = 1663,
  [4425] = 1664,
  [4426] = 1563,
  [4427] = 1494,
  [4428] = 1693,
  [4429] = 1675,
  [4430] = 1692,
  [4431] = 1586,
  [4432] = 1719,
  [4433] = 2195,
  [4434] = 1691,
  [4435] = 1682,
  [4436] = 1690,
  [4437] = 1686,
  [4438] = 1685,
  [4439] = 1681,
  [4440] = 1680,
  [4441] = 1679,
  [4442] = 1678,
  [4443] = 1677,
  [4444] = 1674,
  [4445] = 1657,
  [4446] = 1611,
  [4447] = 1687,
  [4448] = 1625,
  [4449] = 1619,
  [4450] = 1618,
  [4451] = 1617,
  [4452] = 1780,
  [4453] = 1631,
  [4454] = 4454,
  [4455] = 1689,
  [4456] = 1718,
  [4457] = 1616,
  [4458] = 1694,
  [4459] = 1721,
  [4460] = 1671,
  [4461] = 1867,
  [4462] = 1670,
  [4463] = 1614,
  [4464] = 1703,
  [4465] = 1872,
  [4466] = 1612,
  [4467] = 1620,
  [4468] = 1648,
  [4469] = 1727,
  [4470] = 1668,
  [4471] = 1696,
  [4472] = 1672,
  [4473] = 1673,
  [4474] = 1676,
  [4475] = 1704,
  [4476] = 1695,
  [4477] = 1712,
  [4478] = 1716,
  [4479] = 1717,
  [4480] = 1726,
  [4481] = 1725,
  [4482] = 1667,
  [4483] = 1494,
  [4484] = 1492,
  [4485] = 1683,
  [4486] = 1654,
  [4487] = 1722,
  [4488] = 1684,
  [4489] = 4489,
  [4490] = 1666,
  [4491] = 1662,
  [4492] = 1510,
  [4493] = 1502,
  [4494] = 4494,
  [4495] = 4495,
  [4496] = 2468,
  [4497] = 4497,
  [4498] = 4498,
  [4499] = 4499,
  [4500] = 4500,
  [4501] = 4501,
  [4502] = 1747,
  [4503] = 1790,
  [4504] = 4262,
  [4505] = 1805,
  [4506] = 1711,
  [4507] = 1509,
  [4508] = 4508,
  [4509] = 4509,
  [4510] = 1730,
  [4511] = 1598,
  [4512] = 1599,
  [4513] = 4513,
  [4514] = 1506,
  [4515] = 1511,
  [4516] = 4264,
  [4517] = 1799,
  [4518] = 1594,
  [4519] = 1590,
  [4520] = 1569,
  [4521] = 1563,
  [4522] = 1805,
  [4523] = 4523,
  [4524] = 2195,
  [4525] = 4525,
  [4526] = 4526,
  [4527] = 1799,
  [4528] = 1504,
  [4529] = 1705,
  [4530] = 4256,
  [4531] = 1555,
  [4532] = 1564,
  [4533] = 1586,
  [4534] = 1598,
  [4535] = 1599,
  [4536] = 1519,
  [4537] = 1518,
  [4538] = 1799,
  [4539] = 1519,
  [4540] = 1588,
  [4541] = 1589,
  [4542] = 1606,
  [4543] = 1602,
  [4544] = 1517,
  [4545] = 1518,
  [4546] = 1519,
  [4547] = 1520,
  [4548] = 1573,
  [4549] = 1600,
  [4550] = 1521,
  [4551] = 1522,
  [4552] = 1516,
  [4553] = 1698,
  [4554] = 1575,
  [4555] = 1508,
  [4556] = 1587,
  [4557] = 1867,
  [4558] = 1576,
  [4559] = 1830,
  [4560] = 4560,
  [4561] = 1577,
  [4562] = 1515,
  [4563] = 1520,
  [4564] = 1569,
  [4565] = 1579,
  [4566] = 1590,
  [4567] = 1514,
  [4568] = 1625,
  [4569] = 1584,
  [4570] = 1508,
  [4571] = 1521,
  [4572] = 1800,
  [4573] = 1594,
  [4574] = 1590,
  [4575] = 1581,
  [4576] = 1569,
  [4577] = 1500,
  [4578] = 1513,
  [4579] = 1594,
  [4580] = 4580,
  [4581] = 1586,
  [4582] = 1522,
  [4583] = 1599,
  [4584] = 1598,
  [4585] = 1799,
  [4586] = 1516,
  [4587] = 1571,
  [4588] = 4588,
  [4589] = 1605,
  [4590] = 1582,
  [4591] = 1775,
  [4592] = 1609,
  [4593] = 1805,
  [4594] = 1778,
  [4595] = 1707,
  [4596] = 1799,
  [4597] = 1787,
  [4598] = 1500,
  [4599] = 1610,
  [4600] = 1518,
  [4601] = 1500,
  [4602] = 4602,
  [4603] = 1805,
  [4604] = 1508,
  [4605] = 1515,
  [4606] = 1512,
  [4607] = 1801,
  [4608] = 1514,
  [4609] = 1625,
  [4610] = 1607,
  [4611] = 1513,
  [4612] = 4612,
  [4613] = 1778,
  [4614] = 1517,
  [4615] = 1790,
  [4616] = 1805,
  [4617] = 1512,
  [4618] = 1609,
  [4619] = 4619,
  [4620] = 4620,
  [4621] = 4621,
  [4622] = 4622,
  [4623] = 1517,
  [4624] = 1580,
  [4625] = 4625,
  [4626] = 1512,
  [4627] = 1513,
  [4628] = 1514,
  [4629] = 1515,
  [4630] = 1516,
  [4631] = 1522,
  [4632] = 1521,
  [4633] = 1520,
  [4634] = 1535,
  [4635] = 1523,
  [4636] = 4256,
  [4637] = 1514,
  [4638] = 1523,
  [4639] = 1526,
  [4640] = 1527,
  [4641] = 4641,
  [4642] = 4642,
  [4643] = 4643,
  [4644] = 1673,
  [4645] = 1867,
  [4646] = 4646,
  [4647] = 1526,
  [4648] = 4648,
  [4649] = 4649,
  [4650] = 4650,
  [4651] = 1799,
  [4652] = 4652,
  [4653] = 1624,
  [4654] = 4654,
  [4655] = 1623,
  [4656] = 1622,
  [4657] = 1621,
  [4658] = 1778,
  [4659] = 1619,
  [4660] = 4264,
  [4661] = 1512,
  [4662] = 1527,
  [4663] = 4663,
  [4664] = 1530,
  [4665] = 1534,
  [4666] = 1618,
  [4667] = 1535,
  [4668] = 4668,
  [4669] = 1524,
  [4670] = 1537,
  [4671] = 1513,
  [4672] = 1696,
  [4673] = 1530,
  [4674] = 1533,
  [4675] = 1695,
  [4676] = 1532,
  [4677] = 1531,
  [4678] = 1528,
  [4679] = 1529,
  [4680] = 1536,
  [4681] = 1525,
  [4682] = 1625,
  [4683] = 1617,
  [4684] = 4684,
  [4685] = 1778,
  [4686] = 4686,
  [4687] = 1527,
  [4688] = 1631,
  [4689] = 1616,
  [4690] = 4690,
  [4691] = 1666,
  [4692] = 1805,
  [4693] = 1723,
  [4694] = 1500,
  [4695] = 1508,
  [4696] = 1534,
  [4697] = 1694,
  [4698] = 1684,
  [4699] = 1683,
  [4700] = 1703,
  [4701] = 1704,
  [4702] = 1517,
  [4703] = 1518,
  [4704] = 1676,
  [4705] = 1519,
  [4706] = 1520,
  [4707] = 1521,
  [4708] = 1522,
  [4709] = 4709,
  [4710] = 1516,
  [4711] = 1515,
  [4712] = 1514,
  [4713] = 1513,
  [4714] = 1512,
  [4715] = 1712,
  [4716] = 1609,
  [4717] = 1625,
  [4718] = 1716,
  [4719] = 1717,
  [4720] = 1718,
  [4721] = 1614,
  [4722] = 1612,
  [4723] = 1611,
  [4724] = 1719,
  [4725] = 1668,
  [4726] = 1648,
  [4727] = 1654,
  [4728] = 1662,
  [4729] = 1628,
  [4730] = 1714,
  [4731] = 1672,
  [4732] = 4732,
  [4733] = 1534,
  [4734] = 1667,
  [4735] = 1872,
  [4736] = 1670,
  [4737] = 4737,
  [4738] = 1609,
  [4739] = 1674,
  [4740] = 1677,
  [4741] = 4741,
  [4742] = 1678,
  [4743] = 4743,
  [4744] = 1722,
  [4745] = 1530,
  [4746] = 1515,
  [4747] = 1679,
  [4748] = 1680,
  [4749] = 1681,
  [4750] = 1498,
  [4751] = 1685,
  [4752] = 1686,
  [4753] = 1690,
  [4754] = 1691,
  [4755] = 1516,
  [4756] = 1671,
  [4757] = 1522,
  [4758] = 1692,
  [4759] = 1693,
  [4760] = 1521,
  [4761] = 1520,
  [4762] = 1697,
  [4763] = 1519,
  [4764] = 1700,
  [4765] = 1706,
  [4766] = 1708,
  [4767] = 1710,
  [4768] = 1713,
  [4769] = 1523,
  [4770] = 1720,
  [4771] = 1641,
  [4772] = 1615,
  [4773] = 1632,
  [4774] = 1518,
  [4775] = 1633,
  [4776] = 1637,
  [4777] = 1642,
  [4778] = 1643,
  [4779] = 1644,
  [4780] = 1645,
  [4781] = 1646,
  [4782] = 1647,
  [4783] = 1650,
  [4784] = 1535,
  [4785] = 1524,
  [4786] = 1537,
  [4787] = 1533,
  [4788] = 1532,
  [4789] = 1531,
  [4790] = 1657,
  [4791] = 4791,
  [4792] = 1528,
  [4793] = 1529,
  [4794] = 1536,
  [4795] = 1525,
  [4796] = 1724,
  [4797] = 1524,
  [4798] = 1669,
  [4799] = 4799,
  [4800] = 1517,
  [4801] = 1656,
  [4802] = 1512,
  [4803] = 4803,
  [4804] = 1663,
  [4805] = 1664,
  [4806] = 1513,
  [4807] = 4807,
  [4808] = 1653,
  [4809] = 1514,
  [4810] = 1515,
  [4811] = 1609,
  [4812] = 1516,
  [4813] = 1652,
  [4814] = 1675,
  [4815] = 1496,
  [4816] = 4816,
  [4817] = 1522,
  [4818] = 1682,
  [4819] = 1521,
  [4820] = 1525,
  [4821] = 4821,
  [4822] = 1508,
  [4823] = 1649,
  [4824] = 1635,
  [4825] = 1687,
  [4826] = 1500,
  [4827] = 1634,
  [4828] = 4828,
  [4829] = 1520,
  [4830] = 1519,
  [4831] = 1536,
  [4832] = 4832,
  [4833] = 1518,
  [4834] = 1529,
  [4835] = 1780,
  [4836] = 1528,
  [4837] = 1689,
  [4838] = 1531,
  [4839] = 1721,
  [4840] = 1625,
  [4841] = 1532,
  [4842] = 1620,
  [4843] = 1533,
  [4844] = 1537,
  [4845] = 1727,
  [4846] = 1778,
  [4847] = 1517,
  [4848] = 1508,
  [4849] = 1726,
  [4850] = 1725,
  [4851] = 4851,
  [4852] = 1696,
  [4853] = 1500,
  [4854] = 4854,
  [4855] = 1630,
  [4856] = 1629,
  [4857] = 1526,
  [4858] = 1526,
  [4859] = 1537,
  [4860] = 1525,
  [4861] = 1530,
  [4862] = 1534,
  [4863] = 1535,
  [4864] = 1524,
  [4865] = 1537,
  [4866] = 1533,
  [4867] = 1532,
  [4868] = 1532,
  [4869] = 1531,
  [4870] = 1508,
  [4871] = 1531,
  [4872] = 1528,
  [4873] = 1528,
  [4874] = 1529,
  [4875] = 1536,
  [4876] = 1529,
  [4877] = 1536,
  [4878] = 1525,
  [4879] = 1518,
  [4880] = 1519,
  [4881] = 1520,
  [4882] = 1521,
  [4883] = 1522,
  [4884] = 1516,
  [4885] = 1515,
  [4886] = 1514,
  [4887] = 1513,
  [4888] = 1533,
  [4889] = 1512,
  [4890] = 1537,
  [4891] = 1517,
  [4892] = 1527,
  [4893] = 1524,
  [4894] = 1535,
  [4895] = 1534,
  [4896] = 1530,
  [4897] = 1527,
  [4898] = 1523,
  [4899] = 1526,
  [4900] = 1551,
  [4901] = 1548,
  [4902] = 1500,
  [4903] = 1553,
  [4904] = 1552,
  [4905] = 1536,
  [4906] = 1529,
  [4907] = 1528,
  [4908] = 1531,
  [4909] = 1532,
  [4910] = 1533,
  [4911] = 1500,
  [4912] = 4912,
  [4913] = 1524,
  [4914] = 1523,
  [4915] = 1535,
  [4916] = 1523,
  [4917] = 1526,
  [4918] = 1534,
  [4919] = 4919,
  [4920] = 1530,
  [4921] = 1527,
  [4922] = 1778,
  [4923] = 1625,
  [4924] = 1609,
  [4925] = 1549,
  [4926] = 1508,
  [4927] = 1525,
  [4928] = 1550,
  [4929] = 1517,
  [4930] = 1518,
  [4931] = 1519,
  [4932] = 1520,
  [4933] = 1521,
  [4934] = 4934,
  [4935] = 1522,
  [4936] = 1516,
  [4937] = 1515,
  [4938] = 4938,
  [4939] = 1512,
  [4940] = 1514,
  [4941] = 1513,
  [4942] = 1530,
  [4943] = 1930,
  [4944] = 4944,
  [4945] = 4945,
  [4946] = 1525,
  [4947] = 1530,
  [4948] = 4948,
  [4949] = 1535,
  [4950] = 4950,
  [4951] = 1524,
  [4952] = 1537,
  [4953] = 1533,
  [4954] = 1532,
  [4955] = 1534,
  [4956] = 2801,
  [4957] = 1526,
  [4958] = 1523,
  [4959] = 1510,
  [4960] = 1504,
  [4961] = 1563,
  [4962] = 1506,
  [4963] = 1527,
  [4964] = 1534,
  [4965] = 4965,
  [4966] = 1509,
  [4967] = 1525,
  [4968] = 1536,
  [4969] = 1529,
  [4970] = 1528,
  [4971] = 1531,
  [4972] = 1532,
  [4973] = 1533,
  [4974] = 1537,
  [4975] = 1524,
  [4976] = 1535,
  [4977] = 1502,
  [4978] = 1531,
  [4979] = 2724,
  [4980] = 1527,
  [4981] = 1523,
  [4982] = 4982,
  [4983] = 1511,
  [4984] = 1526,
  [4985] = 1528,
  [4986] = 1529,
  [4987] = 4987,
  [4988] = 1536,
  [4989] = 1555,
  [4990] = 4379,
  [4991] = 1502,
  [4992] = 1504,
  [4993] = 1705,
  [4994] = 1730,
  [4995] = 1564,
  [4996] = 1511,
  [4997] = 1506,
  [4998] = 1509,
  [4999] = 1510,
  [5000] = 1747,
  [5001] = 5001,
  [5002] = 1605,
  [5003] = 2813,
  [5004] = 1582,
  [5005] = 1581,
  [5006] = 1586,
  [5007] = 1579,
  [5008] = 1577,
  [5009] = 1576,
  [5010] = 1575,
  [5011] = 1569,
  [5012] = 1571,
  [5013] = 1589,
  [5014] = 1801,
  [5015] = 1590,
  [5016] = 1594,
  [5017] = 1598,
  [5018] = 1584,
  [5019] = 1599,
  [5020] = 2851,
  [5021] = 1563,
  [5022] = 5022,
  [5023] = 1787,
  [5024] = 1606,
  [5025] = 1587,
  [5026] = 1830,
  [5027] = 1580,
  [5028] = 1588,
  [5029] = 1607,
  [5030] = 1602,
  [5031] = 1800,
  [5032] = 1573,
  [5033] = 5033,
  [5034] = 1775,
  [5035] = 1600,
  [5036] = 5036,
  [5037] = 4620,
  [5038] = 1723,
  [5039] = 1631,
  [5040] = 1725,
  [5041] = 1726,
  [5042] = 4588,
  [5043] = 1719,
  [5044] = 1727,
  [5045] = 1620,
  [5046] = 1617,
  [5047] = 1618,
  [5048] = 1619,
  [5049] = 1721,
  [5050] = 1718,
  [5051] = 1717,
  [5052] = 1716,
  [5053] = 1689,
  [5054] = 1780,
  [5055] = 1712,
  [5056] = 1687,
  [5057] = 1704,
  [5058] = 1703,
  [5059] = 1694,
  [5060] = 1711,
  [5061] = 1621,
  [5062] = 1622,
  [5063] = 1623,
  [5064] = 5064,
  [5065] = 1624,
  [5066] = 1614,
  [5067] = 1628,
  [5068] = 1682,
  [5069] = 1629,
  [5070] = 1630,
  [5071] = 1612,
  [5072] = 1611,
  [5073] = 1675,
  [5074] = 1664,
  [5075] = 1663,
  [5076] = 1668,
  [5077] = 1669,
  [5078] = 1702,
  [5079] = 4580,
  [5080] = 1722,
  [5081] = 1711,
  [5082] = 1648,
  [5083] = 1634,
  [5084] = 1654,
  [5085] = 1650,
  [5086] = 1647,
  [5087] = 1635,
  [5088] = 1649,
  [5089] = 1646,
  [5090] = 1645,
  [5091] = 1644,
  [5092] = 1643,
  [5093] = 1652,
  [5094] = 1642,
  [5095] = 5095,
  [5096] = 1548,
  [5097] = 4621,
  [5098] = 1553,
  [5099] = 1552,
  [5100] = 1637,
  [5101] = 1724,
  [5102] = 1633,
  [5103] = 1632,
  [5104] = 1551,
  [5105] = 1711,
  [5106] = 1615,
  [5107] = 1641,
  [5108] = 1616,
  [5109] = 1720,
  [5110] = 1714,
  [5111] = 1653,
  [5112] = 1713,
  [5113] = 1710,
  [5114] = 1656,
  [5115] = 1549,
  [5116] = 1702,
  [5117] = 1708,
  [5118] = 1706,
  [5119] = 1700,
  [5120] = 1697,
  [5121] = 1693,
  [5122] = 2868,
  [5123] = 1692,
  [5124] = 1691,
  [5125] = 1550,
  [5126] = 1696,
  [5127] = 1695,
  [5128] = 1690,
  [5129] = 1686,
  [5130] = 1685,
  [5131] = 1684,
  [5132] = 1683,
  [5133] = 1681,
  [5134] = 1680,
  [5135] = 1679,
  [5136] = 1678,
  [5137] = 1676,
  [5138] = 1677,
  [5139] = 1673,
  [5140] = 1672,
  [5141] = 1671,
  [5142] = 1674,
  [5143] = 1702,
  [5144] = 4619,
  [5145] = 4602,
  [5146] = 1670,
  [5147] = 1872,
  [5148] = 1667,
  [5149] = 1657,
  [5150] = 1666,
  [5151] = 1662,
  [5152] = 1730,
  [5153] = 1586,
  [5154] = 1548,
  [5155] = 4919,
  [5156] = 1553,
  [5157] = 1552,
  [5158] = 1707,
  [5159] = 1711,
  [5160] = 1698,
  [5161] = 1702,
  [5162] = 1594,
  [5163] = 1569,
  [5164] = 1711,
  [5165] = 1563,
  [5166] = 1702,
  [5167] = 1702,
  [5168] = 1551,
  [5169] = 1563,
  [5170] = 1598,
  [5171] = 1610,
  [5172] = 1599,
  [5173] = 1747,
  [5174] = 1711,
  [5175] = 1711,
  [5176] = 4912,
  [5177] = 1590,
  [5178] = 1550,
  [5179] = 1549,
  [5180] = 1522,
  [5181] = 5181,
  [5182] = 1563,
  [5183] = 1705,
  [5184] = 1586,
  [5185] = 1569,
  [5186] = 1790,
  [5187] = 1590,
  [5188] = 1564,
  [5189] = 1594,
  [5190] = 1730,
  [5191] = 1598,
  [5192] = 4938,
  [5193] = 1555,
  [5194] = 1702,
  [5195] = 1512,
  [5196] = 1513,
  [5197] = 1514,
  [5198] = 1747,
  [5199] = 1515,
  [5200] = 1516,
  [5201] = 4934,
  [5202] = 1702,
  [5203] = 1520,
  [5204] = 1518,
  [5205] = 1711,
  [5206] = 1521,
  [5207] = 1517,
  [5208] = 1519,
  [5209] = 1508,
  [5210] = 1500,
  [5211] = 1599,
  [5212] = 5212,
  [5213] = 1575,
  [5214] = 1537,
  [5215] = 1524,
  [5216] = 1535,
  [5217] = 5212,
  [5218] = 1531,
  [5219] = 1528,
  [5220] = 1529,
  [5221] = 1534,
  [5222] = 1594,
  [5223] = 1598,
  [5224] = 1599,
  [5225] = 1536,
  [5226] = 1525,
  [5227] = 1555,
  [5228] = 1530,
  [5229] = 1527,
  [5230] = 1523,
  [5231] = 1526,
  [5232] = 1800,
  [5233] = 4945,
  [5234] = 1830,
  [5235] = 5212,
  [5236] = 1780,
  [5237] = 1605,
  [5238] = 1801,
  [5239] = 5239,
  [5240] = 4982,
  [5241] = 1607,
  [5242] = 1707,
  [5243] = 1705,
  [5244] = 5244,
  [5245] = 5212,
  [5246] = 5246,
  [5247] = 5247,
  [5248] = 5248,
  [5249] = 5212,
  [5250] = 1602,
  [5251] = 1599,
  [5252] = 1698,
  [5253] = 1606,
  [5254] = 1588,
  [5255] = 1584,
  [5256] = 5256,
  [5257] = 5212,
  [5258] = 1533,
  [5259] = 1582,
  [5260] = 4965,
  [5261] = 1581,
  [5262] = 1579,
  [5263] = 1577,
  [5264] = 1571,
  [5265] = 5212,
  [5266] = 1576,
  [5267] = 5267,
  [5268] = 5268,
  [5269] = 5212,
  [5270] = 1694,
  [5271] = 1590,
  [5272] = 5272,
  [5273] = 1790,
  [5274] = 1586,
  [5275] = 4987,
  [5276] = 1532,
  [5277] = 1569,
  [5278] = 5212,
  [5279] = 1610,
  [5280] = 1590,
  [5281] = 1589,
  [5282] = 5212,
  [5283] = 5212,
  [5284] = 1564,
  [5285] = 5212,
  [5286] = 1569,
  [5287] = 4944,
  [5288] = 1787,
  [5289] = 4950,
  [5290] = 1586,
  [5291] = 5291,
  [5292] = 1775,
  [5293] = 1598,
  [5294] = 5212,
  [5295] = 5212,
  [5296] = 1580,
  [5297] = 1573,
  [5298] = 4948,
  [5299] = 1600,
  [5300] = 1512,
  [5301] = 1620,
  [5302] = 1500,
  [5303] = 1508,
  [5304] = 5304,
  [5305] = 1517,
  [5306] = 5212,
  [5307] = 1518,
  [5308] = 1594,
  [5309] = 1519,
  [5310] = 1520,
  [5311] = 1521,
  [5312] = 1522,
  [5313] = 1516,
  [5314] = 5212,
  [5315] = 1515,
  [5316] = 5212,
  [5317] = 1514,
  [5318] = 1513,
  [5319] = 1587,
  [5320] = 1705,
  [5321] = 5212,
  [5322] = 5212,
  [5323] = 5323,
  [5324] = 5324,
  [5325] = 1515,
  [5326] = 1500,
  [5327] = 1508,
  [5328] = 5328,
  [5329] = 5329,
  [5330] = 5330,
  [5331] = 5331,
  [5332] = 1517,
  [5333] = 1518,
  [5334] = 1519,
  [5335] = 1520,
  [5336] = 5329,
  [5337] = 1722,
  [5338] = 1724,
  [5339] = 1725,
  [5340] = 1726,
  [5341] = 1727,
  [5342] = 1521,
  [5343] = 5343,
  [5344] = 1721,
  [5345] = 1697,
  [5346] = 1522,
  [5347] = 5347,
  [5348] = 1689,
  [5349] = 1687,
  [5350] = 1682,
  [5351] = 5328,
  [5352] = 1675,
  [5353] = 1516,
  [5354] = 1664,
  [5355] = 1663,
  [5356] = 5356,
  [5357] = 1650,
  [5358] = 1647,
  [5359] = 1646,
  [5360] = 1645,
  [5361] = 1644,
  [5362] = 1643,
  [5363] = 1642,
  [5364] = 1514,
  [5365] = 1513,
  [5366] = 1637,
  [5367] = 1512,
  [5368] = 5343,
  [5369] = 5369,
  [5370] = 1633,
  [5371] = 1632,
  [5372] = 5347,
  [5373] = 5330,
  [5374] = 1723,
  [5375] = 5330,
  [5376] = 1720,
  [5377] = 1714,
  [5378] = 5324,
  [5379] = 5379,
  [5380] = 1719,
  [5381] = 1713,
  [5382] = 1718,
  [5383] = 1710,
  [5384] = 5384,
  [5385] = 1708,
  [5386] = 1716,
  [5387] = 1712,
  [5388] = 1706,
  [5389] = 1704,
  [5390] = 1700,
  [5391] = 1703,
  [5392] = 1616,
  [5393] = 1693,
  [5394] = 5347,
  [5395] = 5328,
  [5396] = 1692,
  [5397] = 5324,
  [5398] = 5347,
  [5399] = 5347,
  [5400] = 5328,
  [5401] = 1691,
  [5402] = 5328,
  [5403] = 5343,
  [5404] = 5404,
  [5405] = 5324,
  [5406] = 1690,
  [5407] = 5407,
  [5408] = 5408,
  [5409] = 1686,
  [5410] = 1685,
  [5411] = 5330,
  [5412] = 1780,
  [5413] = 5413,
  [5414] = 5414,
  [5415] = 5330,
  [5416] = 5347,
  [5417] = 1681,
  [5418] = 5328,
  [5419] = 5329,
  [5420] = 1717,
  [5421] = 1641,
  [5422] = 1526,
  [5423] = 5423,
  [5424] = 5424,
  [5425] = 5330,
  [5426] = 5343,
  [5427] = 1679,
  [5428] = 1678,
  [5429] = 5328,
  [5430] = 1677,
  [5431] = 1674,
  [5432] = 5324,
  [5433] = 1670,
  [5434] = 1589,
  [5435] = 1575,
  [5436] = 5330,
  [5437] = 1576,
  [5438] = 1872,
  [5439] = 1667,
  [5440] = 1666,
  [5441] = 1577,
  [5442] = 1662,
  [5443] = 1579,
  [5444] = 1654,
  [5445] = 1648,
  [5446] = 1668,
  [5447] = 1611,
  [5448] = 1612,
  [5449] = 1614,
  [5450] = 1523,
  [5451] = 5343,
  [5452] = 1607,
  [5453] = 5328,
  [5454] = 1617,
  [5455] = 1618,
  [5456] = 1619,
  [5457] = 1581,
  [5458] = 5324,
  [5459] = 5343,
  [5460] = 1582,
  [5461] = 1621,
  [5462] = 1622,
  [5463] = 1694,
  [5464] = 5324,
  [5465] = 1623,
  [5466] = 5343,
  [5467] = 1624,
  [5468] = 1628,
  [5469] = 5347,
  [5470] = 1629,
  [5471] = 5328,
  [5472] = 5343,
  [5473] = 1630,
  [5474] = 5330,
  [5475] = 5347,
  [5476] = 1620,
  [5477] = 1584,
  [5478] = 5330,
  [5479] = 1600,
  [5480] = 1500,
  [5481] = 5481,
  [5482] = 5482,
  [5483] = 1508,
  [5484] = 1573,
  [5485] = 1517,
  [5486] = 1634,
  [5487] = 5324,
  [5488] = 1635,
  [5489] = 1649,
  [5490] = 1652,
  [5491] = 1653,
  [5492] = 1656,
  [5493] = 1657,
  [5494] = 1518,
  [5495] = 1519,
  [5496] = 1520,
  [5497] = 5497,
  [5498] = 1521,
  [5499] = 1522,
  [5500] = 1516,
  [5501] = 1671,
  [5502] = 1672,
  [5503] = 1673,
  [5504] = 1680,
  [5505] = 1515,
  [5506] = 1514,
  [5507] = 1513,
  [5508] = 1512,
  [5509] = 1780,
  [5510] = 1683,
  [5511] = 5343,
  [5512] = 1580,
  [5513] = 1588,
  [5514] = 5328,
  [5515] = 1684,
  [5516] = 5343,
  [5517] = 1587,
  [5518] = 5330,
  [5519] = 1695,
  [5520] = 1696,
  [5521] = 5347,
  [5522] = 5328,
  [5523] = 5324,
  [5524] = 1606,
  [5525] = 5525,
  [5526] = 1602,
  [5527] = 1530,
  [5528] = 1669,
  [5529] = 5529,
  [5530] = 1775,
  [5531] = 1676,
  [5532] = 1615,
  [5533] = 1787,
  [5534] = 5343,
  [5535] = 5328,
  [5536] = 1867,
  [5537] = 1631,
  [5538] = 1527,
  [5539] = 5330,
  [5540] = 1534,
  [5541] = 5347,
  [5542] = 1571,
  [5543] = 1535,
  [5544] = 1524,
  [5545] = 1537,
  [5546] = 1533,
  [5547] = 1532,
  [5548] = 1531,
  [5549] = 1528,
  [5550] = 1529,
  [5551] = 1536,
  [5552] = 5552,
  [5553] = 1525,
  [5554] = 5324,
  [5555] = 5343,
  [5556] = 5330,
  [5557] = 5328,
  [5558] = 5330,
  [5559] = 5330,
  [5560] = 5347,
  [5561] = 5324,
  [5562] = 5343,
  [5563] = 1800,
  [5564] = 1830,
  [5565] = 5328,
  [5566] = 1605,
  [5567] = 5347,
  [5568] = 5324,
  [5569] = 5343,
  [5570] = 5570,
  [5571] = 5328,
  [5572] = 5347,
  [5573] = 5330,
  [5574] = 5324,
  [5575] = 5347,
  [5576] = 1801,
  [5577] = 5324,
  [5578] = 5343,
  [5579] = 5347,
  [5580] = 5324,
  [5581] = 1713,
  [5582] = 5582,
  [5583] = 1656,
  [5584] = 5584,
  [5585] = 1657,
  [5586] = 1525,
  [5587] = 1536,
  [5588] = 1529,
  [5589] = 1528,
  [5590] = 1531,
  [5591] = 1532,
  [5592] = 1533,
  [5593] = 1662,
  [5594] = 1537,
  [5595] = 1524,
  [5596] = 1535,
  [5597] = 1671,
  [5598] = 1534,
  [5599] = 1530,
  [5600] = 1527,
  [5601] = 1684,
  [5602] = 5602,
  [5603] = 1695,
  [5604] = 5604,
  [5605] = 1653,
  [5606] = 1649,
  [5607] = 1652,
  [5608] = 1673,
  [5609] = 1676,
  [5610] = 1635,
  [5611] = 1634,
  [5612] = 1696,
  [5613] = 1672,
  [5614] = 1630,
  [5615] = 1629,
  [5616] = 1628,
  [5617] = 1624,
  [5618] = 1623,
  [5619] = 1523,
  [5620] = 1526,
  [5621] = 1622,
  [5622] = 1621,
  [5623] = 1619,
  [5624] = 5624,
  [5625] = 1618,
  [5626] = 1617,
  [5627] = 1631,
  [5628] = 5582,
  [5629] = 1616,
  [5630] = 5630,
  [5631] = 1614,
  [5632] = 1612,
  [5633] = 1611,
  [5634] = 1668,
  [5635] = 1648,
  [5636] = 1654,
  [5637] = 1706,
  [5638] = 1666,
  [5639] = 1667,
  [5640] = 1872,
  [5641] = 1670,
  [5642] = 1674,
  [5643] = 1677,
  [5644] = 1678,
  [5645] = 1679,
  [5646] = 1680,
  [5647] = 1681,
  [5648] = 1685,
  [5649] = 1686,
  [5650] = 5650,
  [5651] = 1690,
  [5652] = 1691,
  [5653] = 1692,
  [5654] = 5654,
  [5655] = 1693,
  [5656] = 5624,
  [5657] = 1697,
  [5658] = 1700,
  [5659] = 5582,
  [5660] = 1683,
  [5661] = 1664,
  [5662] = 1708,
  [5663] = 5630,
  [5664] = 1710,
  [5665] = 1714,
  [5666] = 1720,
  [5667] = 1723,
  [5668] = 1641,
  [5669] = 1615,
  [5670] = 1632,
  [5671] = 1633,
  [5672] = 1637,
  [5673] = 1642,
  [5674] = 5624,
  [5675] = 5675,
  [5676] = 1643,
  [5677] = 1872,
  [5678] = 1644,
  [5679] = 5624,
  [5680] = 5582,
  [5681] = 1645,
  [5682] = 1646,
  [5683] = 1525,
  [5684] = 1647,
  [5685] = 1536,
  [5686] = 1529,
  [5687] = 1528,
  [5688] = 1531,
  [5689] = 1532,
  [5690] = 1650,
  [5691] = 1533,
  [5692] = 1537,
  [5693] = 1524,
  [5694] = 1535,
  [5695] = 1669,
  [5696] = 1663,
  [5697] = 1534,
  [5698] = 1682,
  [5699] = 1530,
  [5700] = 1675,
  [5701] = 1703,
  [5702] = 1527,
  [5703] = 5703,
  [5704] = 1687,
  [5705] = 5630,
  [5706] = 1689,
  [5707] = 5707,
  [5708] = 1721,
  [5709] = 5709,
  [5710] = 5624,
  [5711] = 5582,
  [5712] = 1523,
  [5713] = 1727,
  [5714] = 1526,
  [5715] = 1726,
  [5716] = 5630,
  [5717] = 5624,
  [5718] = 5582,
  [5719] = 1725,
  [5720] = 5582,
  [5721] = 1724,
  [5722] = 5722,
  [5723] = 1722,
  [5724] = 1719,
  [5725] = 1718,
  [5726] = 5630,
  [5727] = 5624,
  [5728] = 1717,
  [5729] = 1716,
  [5730] = 1712,
  [5731] = 1704,
  [5732] = 5732,
  [5733] = 5630,
  [5734] = 5582,
  [5735] = 5630,
  [5736] = 1867,
  [5737] = 5582,
  [5738] = 5624,
  [5739] = 5630,
  [5740] = 5630,
  [5741] = 5624,
  [5742] = 5582,
  [5743] = 5630,
  [5744] = 5582,
  [5745] = 5624,
  [5746] = 5630,
  [5747] = 5624,
  [5748] = 5582,
  [5749] = 5630,
  [5750] = 5624,
  [5751] = 5751,
  [5752] = 5582,
  [5753] = 5630,
  [5754] = 5624,
  [5755] = 5582,
  [5756] = 5624,
  [5757] = 5630,
  [5758] = 5582,
  [5759] = 5759,
  [5760] = 5624,
  [5761] = 5630,
  [5762] = 5064,
  [5763] = 5763,
  [5764] = 5764,
  [5765] = 5765,
  [5766] = 5764,
  [5767] = 5767,
  [5768] = 5768,
  [5769] = 5769,
  [5770] = 5767,
  [5771] = 5768,
  [5772] = 5763,
  [5773] = 5773,
  [5774] = 5765,
  [5775] = 5769,
  [5776] = 5763,
  [5777] = 5763,
  [5778] = 5769,
  [5779] = 5095,
  [5780] = 5780,
  [5781] = 5763,
  [5782] = 5780,
  [5783] = 5783,
  [5784] = 5765,
  [5785] = 5783,
  [5786] = 5763,
  [5787] = 5769,
  [5788] = 5765,
  [5789] = 5783,
  [5790] = 5780,
  [5791] = 5765,
  [5792] = 5769,
  [5793] = 5793,
  [5794] = 5794,
  [5795] = 5780,
  [5796] = 5765,
  [5797] = 5783,
  [5798] = 5763,
  [5799] = 5783,
  [5800] = 5767,
  [5801] = 5764,
  [5802] = 5768,
  [5803] = 5764,
  [5804] = 5780,
  [5805] = 5805,
  [5806] = 5768,
  [5807] = 5769,
  [5808] = 5763,
  [5809] = 5765,
  [5810] = 5767,
  [5811] = 5780,
  [5812] = 5769,
  [5813] = 5783,
  [5814] = 5765,
  [5815] = 5783,
  [5816] = 5780,
  [5817] = 5769,
  [5818] = 5765,
  [5819] = 5763,
  [5820] = 5769,
  [5821] = 5767,
  [5822] = 5767,
  [5823] = 5765,
  [5824] = 5769,
  [5825] = 5780,
  [5826] = 5783,
  [5827] = 5768,
  [5828] = 5780,
  [5829] = 5783,
  [5830] = 5764,
  [5831] = 5773,
  [5832] = 5768,
  [5833] = 5764,
  [5834] = 5768,
  [5835] = 5764,
  [5836] = 5836,
  [5837] = 5763,
  [5838] = 5838,
  [5839] = 5839,
  [5840] = 5764,
  [5841] = 5763,
  [5842] = 5767,
  [5843] = 5764,
  [5844] = 5844,
  [5845] = 5767,
  [5846] = 5768,
  [5847] = 5783,
  [5848] = 5780,
  [5849] = 5763,
  [5850] = 5850,
  [5851] = 5767,
  [5852] = 5769,
  [5853] = 5765,
  [5854] = 5768,
  [5855] = 5764,
  [5856] = 5856,
  [5857] = 5783,
  [5858] = 5780,
  [5859] = 5769,
  [5860] = 5764,
  [5861] = 5765,
  [5862] = 5769,
  [5863] = 5780,
  [5864] = 5764,
  [5865] = 5783,
  [5866] = 5767,
  [5867] = 5765,
  [5868] = 5768,
  [5869] = 5768,
  [5870] = 5768,
  [5871] = 5768,
  [5872] = 5768,
  [5873] = 5763,
  [5874] = 5768,
  [5875] = 5767,
  [5876] = 5768,
  [5877] = 5768,
  [5878] = 5764,
  [5879] = 5764,
  [5880] = 5768,
  [5881] = 5768,
  [5882] = 2724,
  [5883] = 5768,
  [5884] = 5767,
  [5885] = 5764,
  [5886] = 5763,
  [5887] = 5773,
  [5888] = 5765,
  [5889] = 5767,
  [5890] = 5767,
  [5891] = 5769,
  [5892] = 5767,
  [5893] = 5783,
  [5894] = 5763,
  [5895] = 5780,
  [5896] = 5769,
  [5897] = 5783,
  [5898] = 5780,
  [5899] = 5783,
  [5900] = 5780,
  [5901] = 5765,
  [5902] = 5902,
  [5903] = 5903,
  [5904] = 5903,
  [5905] = 5905,
  [5906] = 5903,
  [5907] = 5907,
  [5908] = 5908,
  [5909] = 5909,
  [5910] = 5910,
  [5911] = 2468,
  [5912] = 5912,
  [5913] = 5903,
  [5914] = 5914,
  [5915] = 5915,
  [5916] = 5916,
  [5917] = 5917,
  [5918] = 1711,
  [5919] = 5919,
  [5920] = 5920,
  [5921] = 5921,
  [5922] = 5922,
  [5923] = 5923,
  [5924] = 5924,
  [5925] = 5925,
  [5926] = 5925,
  [5927] = 5927,
  [5928] = 5928,
  [5929] = 5929,
  [5930] = 5930,
  [5931] = 1711,
  [5932] = 5932,
  [5933] = 5933,
  [5934] = 5934,
  [5935] = 5935,
  [5936] = 5934,
  [5937] = 5927,
  [5938] = 5932,
  [5939] = 5939,
  [5940] = 2912,
  [5941] = 1702,
  [5942] = 5942,
  [5943] = 4126,
  [5944] = 5944,
  [5945] = 5945,
  [5946] = 5946,
  [5947] = 3928,
  [5948] = 4109,
  [5949] = 4110,
  [5950] = 1702,
  [5951] = 3928,
  [5952] = 5935,
  [5953] = 4668,
  [5954] = 5924,
  [5955] = 3970,
  [5956] = 5304,
  [5957] = 5942,
  [5958] = 5958,
  [5959] = 4142,
  [5960] = 5256,
  [5961] = 5933,
  [5962] = 5291,
  [5963] = 5963,
  [5964] = 1711,
  [5965] = 5965,
  [5966] = 5966,
  [5967] = 5331,
  [5968] = 5968,
  [5969] = 5969,
  [5970] = 5970,
  [5971] = 4214,
  [5972] = 5972,
  [5973] = 1711,
  [5974] = 1702,
  [5975] = 4216,
  [5976] = 4217,
  [5977] = 4218,
  [5978] = 4212,
  [5979] = 5979,
  [5980] = 5980,
  [5981] = 1711,
  [5982] = 5982,
  [5983] = 1705,
  [5984] = 4208,
  [5985] = 5985,
  [5986] = 5986,
  [5987] = 3478,
  [5988] = 5988,
  [5989] = 5404,
  [5990] = 5990,
  [5991] = 5525,
  [5992] = 5992,
  [5993] = 1702,
  [5994] = 5994,
  [5995] = 5995,
  [5996] = 5996,
  [5997] = 5997,
  [5998] = 5379,
  [5999] = 2801,
  [6000] = 5384,
  [6001] = 6001,
  [6002] = 6002,
  [6003] = 1780,
  [6004] = 5995,
  [6005] = 6005,
  [6006] = 4262,
  [6007] = 6007,
  [6008] = 5979,
  [6009] = 5965,
  [6010] = 6010,
  [6011] = 5982,
  [6012] = 6012,
  [6013] = 6013,
  [6014] = 5850,
  [6015] = 4523,
  [6016] = 6016,
  [6017] = 6017,
  [6018] = 5844,
  [6019] = 1872,
  [6020] = 5944,
  [6021] = 5805,
  [6022] = 5856,
  [6023] = 6023,
  [6024] = 6024,
  [6025] = 4264,
  [6026] = 4256,
  [6027] = 5914,
  [6028] = 6028,
  [6029] = 5923,
  [6030] = 6030,
  [6031] = 6031,
  [6032] = 6032,
  [6033] = 5908,
  [6034] = 6034,
  [6035] = 6035,
  [6036] = 6035,
  [6037] = 6037,
  [6038] = 5925,
  [6039] = 6035,
  [6040] = 6035,
  [6041] = 5934,
  [6042] = 6035,
  [6043] = 5932,
  [6044] = 5927,
  [6045] = 6035,
  [6046] = 6035,
  [6047] = 6035,
  [6048] = 5927,
  [6049] = 6035,
  [6050] = 5932,
  [6051] = 6035,
  [6052] = 5934,
  [6053] = 6035,
  [6054] = 6035,
  [6055] = 6035,
  [6056] = 6035,
  [6057] = 6035,
  [6058] = 4650,
  [6059] = 5925,
  [6060] = 6060,
  [6061] = 6061,
  [6062] = 6062,
  [6063] = 6063,
  [6064] = 6064,
  [6065] = 6062,
  [6066] = 6063,
  [6067] = 6063,
  [6068] = 6064,
  [6069] = 6063,
  [6070] = 4264,
  [6071] = 4602,
  [6072] = 4619,
  [6073] = 6064,
  [6074] = 6062,
  [6075] = 6063,
  [6076] = 5945,
  [6077] = 5946,
  [6078] = 6062,
  [6079] = 6063,
  [6080] = 6080,
  [6081] = 6062,
  [6082] = 6082,
  [6083] = 6062,
  [6084] = 6063,
  [6085] = 6063,
  [6086] = 6086,
  [6087] = 6080,
  [6088] = 4256,
  [6089] = 6080,
  [6090] = 6090,
  [6091] = 6064,
  [6092] = 4620,
  [6093] = 6093,
  [6094] = 4621,
  [6095] = 6062,
  [6096] = 6062,
  [6097] = 6097,
  [6098] = 4737,
  [6099] = 6099,
  [6100] = 6100,
  [6101] = 6101,
  [6102] = 6102,
  [6103] = 6103,
  [6104] = 6104,
  [6105] = 6105,
  [6106] = 6106,
  [6107] = 6107,
  [6108] = 6108,
  [6109] = 6109,
  [6110] = 4832,
  [6111] = 6111,
  [6112] = 6112,
  [6113] = 6113,
  [6114] = 6114,
  [6115] = 6115,
  [6116] = 6116,
  [6117] = 6117,
  [6118] = 6118,
  [6119] = 6119,
  [6120] = 6120,
  [6121] = 6121,
  [6122] = 6122,
  [6123] = 5995,
  [6124] = 6124,
  [6125] = 6125,
  [6126] = 6126,
  [6127] = 6127,
  [6128] = 6128,
  [6129] = 5982,
  [6130] = 6130,
  [6131] = 6131,
  [6132] = 6132,
  [6133] = 5979,
  [6134] = 6134,
  [6135] = 6135,
  [6136] = 6136,
  [6137] = 6137,
  [6138] = 5979,
  [6139] = 6012,
  [6140] = 5982,
  [6141] = 4379,
  [6142] = 5995,
  [6143] = 4686,
  [6144] = 6144,
  [6145] = 6145,
  [6146] = 6146,
  [6147] = 6145,
  [6148] = 4580,
  [6149] = 6145,
  [6150] = 6060,
  [6151] = 4588,
  [6152] = 4621,
  [6153] = 6153,
  [6154] = 4620,
  [6155] = 4619,
  [6156] = 4602,
  [6157] = 4919,
  [6158] = 4938,
  [6159] = 6159,
  [6160] = 4621,
  [6161] = 6161,
  [6162] = 4602,
  [6163] = 4912,
  [6164] = 6164,
  [6165] = 4619,
  [6166] = 6166,
  [6167] = 6086,
  [6168] = 6082,
  [6169] = 6090,
  [6170] = 4620,
  [6171] = 4934,
  [6172] = 3928,
  [6173] = 4987,
  [6174] = 4982,
  [6175] = 6175,
  [6176] = 6176,
  [6177] = 6177,
  [6178] = 4851,
  [6179] = 3928,
  [6180] = 4965,
  [6181] = 4948,
  [6182] = 4944,
  [6183] = 6183,
  [6184] = 4945,
  [6185] = 1778,
  [6186] = 4950,
  [6187] = 4668,
  [6188] = 6188,
  [6189] = 6189,
  [6190] = 6190,
  [6191] = 6191,
  [6192] = 6192,
  [6193] = 6193,
  [6194] = 6194,
  [6195] = 6193,
  [6196] = 6196,
  [6197] = 6193,
  [6198] = 6198,
  [6199] = 6190,
  [6200] = 6190,
  [6201] = 6201,
  [6202] = 6202,
  [6203] = 6203,
  [6204] = 6204,
  [6205] = 6205,
  [6206] = 6204,
  [6207] = 6207,
  [6208] = 6205,
  [6209] = 6209,
  [6210] = 6204,
  [6211] = 6205,
  [6212] = 6204,
  [6213] = 6205,
  [6214] = 6204,
  [6215] = 6204,
  [6216] = 6205,
  [6217] = 6205,
  [6218] = 6205,
  [6219] = 6205,
  [6220] = 6204,
  [6221] = 6204,
  [6222] = 6204,
  [6223] = 4648,
  [6224] = 6204,
  [6225] = 6205,
  [6226] = 6205,
  [6227] = 6205,
  [6228] = 6204,
  [6229] = 6205,
  [6230] = 6204,
  [6231] = 6205,
  [6232] = 6204,
  [6233] = 6204,
  [6234] = 6204,
  [6235] = 6205,
  [6236] = 6205,
  [6237] = 6204,
  [6238] = 6204,
  [6239] = 6205,
  [6240] = 6205,
  [6241] = 6205,
  [6242] = 6204,
  [6243] = 6205,
  [6244] = 6244,
  [6245] = 6205,
  [6246] = 6205,
  [6247] = 6204,
  [6248] = 6248,
  [6249] = 6249,
  [6250] = 5095,
  [6251] = 5064,
  [6252] = 6252,
  [6253] = 6249,
  [6254] = 6254,
  [6255] = 6255,
  [6256] = 4264,
  [6257] = 6257,
  [6258] = 6258,
  [6259] = 1496,
  [6260] = 1498,
  [6261] = 4256,
  [6262] = 6262,
  [6263] = 6263,
  [6264] = 6264,
  [6265] = 6265,
  [6266] = 6266,
  [6267] = 6267,
  [6268] = 6268,
  [6269] = 6266,
  [6270] = 6270,
  [6271] = 6263,
  [6272] = 6272,
  [6273] = 6268,
  [6274] = 6272,
  [6275] = 6268,
  [6276] = 6268,
  [6277] = 6277,
  [6278] = 6272,
  [6279] = 6268,
  [6280] = 6280,
  [6281] = 6277,
  [6282] = 6272,
  [6283] = 6283,
  [6284] = 6284,
  [6285] = 6268,
  [6286] = 6268,
  [6287] = 6272,
  [6288] = 6268,
  [6289] = 6268,
  [6290] = 6290,
  [6291] = 6268,
  [6292] = 6264,
  [6293] = 6272,
  [6294] = 6294,
  [6295] = 6268,
  [6296] = 6272,
  [6297] = 6268,
  [6298] = 6266,
  [6299] = 6268,
  [6300] = 6300,
  [6301] = 6267,
  [6302] = 6272,
  [6303] = 6272,
  [6304] = 6304,
  [6305] = 6268,
  [6306] = 6268,
  [6307] = 6307,
  [6308] = 6268,
  [6309] = 6270,
  [6310] = 6268,
  [6311] = 6272,
  [6312] = 6264,
  [6313] = 6272,
  [6314] = 6268,
  [6315] = 6263,
  [6316] = 6272,
  [6317] = 6272,
  [6318] = 6277,
  [6319] = 6268,
  [6320] = 6272,
  [6321] = 6321,
  [6322] = 6272,
  [6323] = 6323,
  [6324] = 4256,
  [6325] = 4264,
  [6326] = 6326,
  [6327] = 5291,
  [6328] = 5304,
  [6329] = 5256,
  [6330] = 6330,
  [6331] = 6330,
  [6332] = 5404,
  [6333] = 5331,
  [6334] = 6330,
  [6335] = 5384,
  [6336] = 6336,
  [6337] = 6336,
  [6338] = 6336,
  [6339] = 6336,
  [6340] = 6336,
  [6341] = 6336,
  [6342] = 6336,
  [6343] = 6336,
  [6344] = 6336,
  [6345] = 6336,
  [6346] = 6336,
  [6347] = 6336,
  [6348] = 6336,
  [6349] = 6336,
  [6350] = 6336,
  [6351] = 5805,
  [6352] = 5856,
  [6353] = 5844,
  [6354] = 5850,
  [6355] = 6355,
  [6356] = 6356,
  [6357] = 6357,
  [6358] = 6358,
  [6359] = 6359,
  [6360] = 5908,
  [6361] = 4621,
  [6362] = 6362,
  [6363] = 5923,
  [6364] = 6364,
  [6365] = 6365,
  [6366] = 4620,
  [6367] = 5914,
  [6368] = 4602,
  [6369] = 6369,
  [6370] = 6370,
  [6371] = 6371,
  [6372] = 4619,
  [6373] = 6373,
  [6374] = 6374,
  [6375] = 6374,
  [6376] = 6376,
  [6377] = 6377,
  [6378] = 6378,
  [6379] = 6373,
  [6380] = 6376,
  [6381] = 6381,
  [6382] = 4803,
  [6383] = 6377,
  [6384] = 6374,
  [6385] = 6377,
  [6386] = 6374,
  [6387] = 6377,
  [6388] = 6376,
  [6389] = 6389,
  [6390] = 6381,
  [6391] = 6376,
  [6392] = 6381,
  [6393] = 6373,
  [6394] = 6374,
  [6395] = 6389,
  [6396] = 6396,
  [6397] = 6374,
  [6398] = 5932,
  [6399] = 6399,
  [6400] = 6373,
  [6401] = 6389,
  [6402] = 6374,
  [6403] = 6374,
  [6404] = 6381,
  [6405] = 6374,
  [6406] = 6374,
  [6407] = 6381,
  [6408] = 6373,
  [6409] = 6409,
  [6410] = 4650,
  [6411] = 6411,
  [6412] = 6377,
  [6413] = 6411,
  [6414] = 6374,
  [6415] = 6381,
  [6416] = 6399,
  [6417] = 6377,
  [6418] = 6377,
  [6419] = 6389,
  [6420] = 6374,
  [6421] = 6373,
  [6422] = 6374,
  [6423] = 6373,
  [6424] = 6374,
  [6425] = 6381,
  [6426] = 6374,
  [6427] = 6399,
  [6428] = 6389,
  [6429] = 6381,
  [6430] = 6374,
  [6431] = 6373,
  [6432] = 6381,
  [6433] = 6374,
  [6434] = 6373,
  [6435] = 5925,
  [6436] = 6381,
  [6437] = 6374,
  [6438] = 6374,
  [6439] = 6377,
  [6440] = 5925,
  [6441] = 6374,
  [6442] = 6396,
  [6443] = 6374,
  [6444] = 5934,
  [6445] = 6373,
  [6446] = 6374,
  [6447] = 6399,
  [6448] = 6374,
  [6449] = 6374,
  [6450] = 6377,
  [6451] = 5927,
  [6452] = 6381,
  [6453] = 6374,
  [6454] = 6374,
  [6455] = 6455,
  [6456] = 6374,
  [6457] = 6373,
  [6458] = 6373,
  [6459] = 6017,
  [6460] = 6374,
  [6461] = 6376,
  [6462] = 6377,
  [6463] = 6381,
  [6464] = 6381,
  [6465] = 6399,
  [6466] = 6374,
  [6467] = 6399,
  [6468] = 6374,
  [6469] = 5927,
  [6470] = 6374,
  [6471] = 6377,
  [6472] = 5934,
  [6473] = 6377,
  [6474] = 6374,
  [6475] = 6411,
  [6476] = 6381,
  [6477] = 6374,
  [6478] = 6376,
  [6479] = 6377,
  [6480] = 6373,
  [6481] = 5932,
  [6482] = 6374,
  [6483] = 6377,
  [6484] = 6389,
  [6485] = 6374,
  [6486] = 6381,
  [6487] = 6377,
  [6488] = 6374,
  [6489] = 6373,
  [6490] = 6373,
  [6491] = 6491,
  [6492] = 6492,
  [6493] = 6491,
  [6494] = 6492,
  [6495] = 6495,
  [6496] = 6492,
  [6497] = 6492,
  [6498] = 6495,
  [6499] = 6491,
  [6500] = 6491,
  [6501] = 6501,
  [6502] = 6492,
  [6503] = 6492,
  [6504] = 6495,
  [6505] = 6492,
  [6506] = 6492,
  [6507] = 5945,
  [6508] = 6492,
  [6509] = 6491,
  [6510] = 6492,
  [6511] = 6511,
  [6512] = 6492,
  [6513] = 6492,
  [6514] = 4732,
  [6515] = 6491,
  [6516] = 6492,
  [6517] = 5946,
  [6518] = 6495,
  [6519] = 6491,
  [6520] = 6520,
  [6521] = 6492,
  [6522] = 6492,
  [6523] = 6492,
  [6524] = 6492,
  [6525] = 6495,
  [6526] = 6492,
  [6527] = 6492,
  [6528] = 6495,
  [6529] = 6495,
  [6530] = 6492,
  [6531] = 6491,
  [6532] = 6491,
  [6533] = 6492,
  [6534] = 6491,
  [6535] = 6495,
  [6536] = 6491,
  [6537] = 6537,
  [6538] = 6492,
  [6539] = 6491,
  [6540] = 6492,
  [6541] = 6492,
  [6542] = 6491,
  [6543] = 6495,
  [6544] = 6492,
  [6545] = 6492,
  [6546] = 6546,
  [6547] = 6492,
  [6548] = 6495,
  [6549] = 6491,
  [6550] = 6495,
  [6551] = 6495,
  [6552] = 6492,
  [6553] = 6491,
  [6554] = 6554,
  [6555] = 6491,
  [6556] = 6495,
  [6557] = 6491,
  [6558] = 6492,
  [6559] = 6492,
  [6560] = 6491,
  [6561] = 6495,
  [6562] = 6492,
  [6563] = 6492,
  [6564] = 6492,
  [6565] = 6495,
  [6566] = 6492,
  [6567] = 6495,
  [6568] = 6492,
  [6569] = 6492,
  [6570] = 6570,
  [6571] = 6495,
  [6572] = 6492,
  [6573] = 6492,
  [6574] = 6492,
  [6575] = 6495,
  [6576] = 6495,
  [6577] = 6492,
  [6578] = 6578,
  [6579] = 6491,
  [6580] = 6580,
  [6581] = 6580,
  [6582] = 6580,
  [6583] = 6580,
  [6584] = 6580,
  [6585] = 6580,
  [6586] = 6580,
  [6587] = 6587,
  [6588] = 6580,
  [6589] = 6580,
  [6590] = 6580,
  [6591] = 6580,
  [6592] = 6580,
  [6593] = 6593,
  [6594] = 6580,
  [6595] = 6580,
  [6596] = 6596,
  [6597] = 6580,
  [6598] = 6580,
  [6599] = 6580,
  [6600] = 6600,
  [6601] = 6580,
  [6602] = 6580,
  [6603] = 6580,
  [6604] = 5979,
  [6605] = 6580,
  [6606] = 6580,
  [6607] = 6607,
  [6608] = 6580,
  [6609] = 6580,
  [6610] = 6580,
  [6611] = 6580,
  [6612] = 6580,
  [6613] = 5982,
  [6614] = 6580,
  [6615] = 6580,
  [6616] = 5995,
  [6617] = 6580,
  [6618] = 6580,
  [6619] = 6580,
  [6620] = 6580,
  [6621] = 6580,
  [6622] = 6580,
  [6623] = 6580,
  [6624] = 6624,
  [6625] = 6625,
  [6626] = 6626,
  [6627] = 6627,
  [6628] = 6628,
  [6629] = 6629,
  [6630] = 6630,
  [6631] = 6631,
  [6632] = 6627,
  [6633] = 6633,
  [6634] = 6627,
  [6635] = 6635,
  [6636] = 6627,
  [6637] = 6637,
  [6638] = 6629,
  [6639] = 6639,
  [6640] = 6627,
  [6641] = 6641,
  [6642] = 6642,
  [6643] = 6626,
  [6644] = 6642,
  [6645] = 6626,
  [6646] = 6627,
  [6647] = 6627,
  [6648] = 6629,
  [6649] = 6629,
  [6650] = 6642,
  [6651] = 6651,
  [6652] = 6642,
  [6653] = 6653,
  [6654] = 5979,
  [6655] = 6655,
  [6656] = 6656,
  [6657] = 6626,
  [6658] = 6626,
  [6659] = 6653,
  [6660] = 6629,
  [6661] = 6642,
  [6662] = 6662,
  [6663] = 6663,
  [6664] = 6664,
  [6665] = 6627,
  [6666] = 6653,
  [6667] = 6653,
  [6668] = 6629,
  [6669] = 6637,
  [6670] = 6637,
  [6671] = 6642,
  [6672] = 6642,
  [6673] = 5995,
  [6674] = 6642,
  [6675] = 6626,
  [6676] = 6642,
  [6677] = 6629,
  [6678] = 6637,
  [6679] = 6626,
  [6680] = 6642,
  [6681] = 6627,
  [6682] = 6627,
  [6683] = 6629,
  [6684] = 6626,
  [6685] = 6685,
  [6686] = 6642,
  [6687] = 6687,
  [6688] = 6688,
  [6689] = 6689,
  [6690] = 6626,
  [6691] = 6691,
  [6692] = 6629,
  [6693] = 6626,
  [6694] = 5982,
  [6695] = 6695,
  [6696] = 6642,
  [6697] = 6637,
  [6698] = 6637,
  [6699] = 6629,
  [6700] = 6653,
  [6701] = 6642,
  [6702] = 6626,
  [6703] = 6703,
  [6704] = 6629,
  [6705] = 6705,
  [6706] = 6629,
  [6707] = 6707,
  [6708] = 6626,
  [6709] = 6709,
  [6710] = 6626,
  [6711] = 6626,
  [6712] = 6712,
  [6713] = 6629,
  [6714] = 6642,
  [6715] = 6642,
  [6716] = 6629,
  [6717] = 6629,
  [6718] = 6627,
  [6719] = 6627,
  [6720] = 6653,
  [6721] = 6627,
  [6722] = 6628,
  [6723] = 6626,
  [6724] = 6724,
  [6725] = 6627,
  [6726] = 6726,
  [6727] = 6627,
  [6728] = 6705,
  [6729] = 6729,
  [6730] = 6730,
  [6731] = 5982,
  [6732] = 6732,
  [6733] = 6730,
  [6734] = 6734,
  [6735] = 6732,
  [6736] = 6730,
  [6737] = 6732,
  [6738] = 6730,
  [6739] = 5979,
  [6740] = 6732,
  [6741] = 6730,
  [6742] = 6730,
  [6743] = 6732,
  [6744] = 6732,
  [6745] = 5923,
  [6746] = 6730,
  [6747] = 6747,
  [6748] = 6748,
  [6749] = 6732,
  [6750] = 6730,
  [6751] = 6734,
  [6752] = 6732,
  [6753] = 6732,
  [6754] = 6732,
  [6755] = 6730,
  [6756] = 6732,
  [6757] = 5914,
  [6758] = 5908,
  [6759] = 6734,
  [6760] = 6730,
  [6761] = 5995,
  [6762] = 6730,
  [6763] = 6730,
  [6764] = 6732,
  [6765] = 6730,
  [6766] = 6732,
  [6767] = 6732,
  [6768] = 6730,
  [6769] = 6732,
  [6770] = 6730,
  [6771] = 6771,
  [6772] = 6772,
  [6773] = 6772,
  [6774] = 6772,
  [6775] = 6775,
  [6776] = 6776,
  [6777] = 6777,
  [6778] = 6778,
  [6779] = 6772,
  [6780] = 6780,
  [6781] = 6772,
  [6782] = 6772,
  [6783] = 6783,
  [6784] = 6784,
  [6785] = 6772,
  [6786] = 6775,
  [6787] = 6772,
  [6788] = 6772,
  [6789] = 6789,
  [6790] = 6790,
  [6791] = 6772,
  [6792] = 6775,
  [6793] = 6772,
  [6794] = 6794,
  [6795] = 6772,
  [6796] = 6772,
  [6797] = 6797,
  [6798] = 4709,
  [6799] = 6799,
  [6800] = 6772,
  [6801] = 6801,
  [6802] = 6802,
  [6803] = 6772,
  [6804] = 6804,
  [6805] = 6805,
  [6806] = 6804,
  [6807] = 6807,
  [6808] = 6808,
  [6809] = 6809,
  [6810] = 6810,
  [6811] = 6811,
  [6812] = 6812,
  [6813] = 6813,
  [6814] = 6814,
  [6815] = 6815,
  [6816] = 6816,
  [6817] = 6817,
  [6818] = 6818,
  [6819] = 6819,
  [6820] = 6804,
  [6821] = 6821,
  [6822] = 6822,
  [6823] = 6804,
  [6824] = 6824,
  [6825] = 6804,
  [6826] = 6826,
  [6827] = 6827,
  [6828] = 4489,
  [6829] = 6829,
  [6830] = 6830,
  [6831] = 6831,
  [6832] = 6832,
  [6833] = 6804,
  [6834] = 6834,
  [6835] = 6835,
  [6836] = 6836,
  [6837] = 6837,
  [6838] = 6804,
  [6839] = 6804,
  [6840] = 6804,
  [6841] = 6841,
  [6842] = 6842,
  [6843] = 6804,
  [6844] = 6844,
  [6845] = 6804,
  [6846] = 6846,
  [6847] = 6847,
  [6848] = 6848,
  [6849] = 6849,
  [6850] = 6850,
  [6851] = 6844,
  [6852] = 6844,
  [6853] = 6804,
  [6854] = 6854,
  [6855] = 6855,
  [6856] = 6856,
  [6857] = 6804,
  [6858] = 6809,
  [6859] = 6804,
  [6860] = 6860,
  [6861] = 6861,
  [6862] = 6862,
  [6863] = 6836,
  [6864] = 6809,
  [6865] = 6865,
  [6866] = 6866,
  [6867] = 6836,
  [6868] = 6804,
  [6869] = 6869,
  [6870] = 6870,
  [6871] = 6871,
  [6872] = 6872,
  [6873] = 6873,
  [6874] = 6874,
  [6875] = 6875,
  [6876] = 6876,
  [6877] = 6877,
  [6878] = 6878,
  [6879] = 6875,
  [6880] = 6880,
  [6881] = 6881,
  [6882] = 6882,
  [6883] = 6872,
  [6884] = 6873,
  [6885] = 6885,
  [6886] = 6885,
  [6887] = 6887,
  [6888] = 6888,
  [6889] = 6889,
  [6890] = 6885,
  [6891] = 6891,
  [6892] = 6874,
  [6893] = 6889,
  [6894] = 6885,
  [6895] = 6891,
  [6896] = 6896,
  [6897] = 6897,
  [6898] = 6898,
  [6899] = 6899,
  [6900] = 6874,
  [6901] = 6876,
  [6902] = 6902,
  [6903] = 6899,
  [6904] = 6904,
  [6905] = 6905,
  [6906] = 6888,
  [6907] = 6885,
  [6908] = 6908,
  [6909] = 6909,
  [6910] = 6873,
  [6911] = 6872,
  [6912] = 6877,
  [6913] = 6888,
  [6914] = 6885,
  [6915] = 6885,
  [6916] = 6889,
  [6917] = 6872,
  [6918] = 6875,
  [6919] = 6878,
  [6920] = 6877,
  [6921] = 6891,
  [6922] = 6876,
  [6923] = 6909,
  [6924] = 6899,
  [6925] = 6898,
  [6926] = 6898,
  [6927] = 6888,
  [6928] = 6898,
  [6929] = 6888,
  [6930] = 6889,
  [6931] = 6931,
  [6932] = 6885,
  [6933] = 6885,
  [6934] = 6876,
  [6935] = 6874,
  [6936] = 6873,
  [6937] = 6872,
  [6938] = 6875,
  [6939] = 6891,
  [6940] = 6888,
  [6941] = 6899,
  [6942] = 6909,
  [6943] = 6943,
  [6944] = 1780,
  [6945] = 6899,
  [6946] = 6878,
  [6947] = 6947,
  [6948] = 6888,
  [6949] = 6875,
  [6950] = 6885,
  [6951] = 6904,
  [6952] = 6952,
  [6953] = 6909,
  [6954] = 6954,
  [6955] = 6898,
  [6956] = 6885,
  [6957] = 6957,
  [6958] = 6958,
  [6959] = 6959,
  [6960] = 6960,
  [6961] = 6878,
  [6962] = 6899,
  [6963] = 6889,
  [6964] = 6877,
  [6965] = 6888,
  [6966] = 6876,
  [6967] = 6952,
  [6968] = 6874,
  [6969] = 6873,
  [6970] = 6904,
  [6971] = 6885,
  [6972] = 6899,
  [6973] = 6899,
  [6974] = 6872,
  [6975] = 6975,
  [6976] = 6952,
  [6977] = 6891,
  [6978] = 6888,
  [6979] = 6899,
  [6980] = 6909,
  [6981] = 6888,
  [6982] = 6982,
  [6983] = 6983,
  [6984] = 6984,
  [6985] = 6899,
  [6986] = 6986,
  [6987] = 6877,
  [6988] = 6878,
  [6989] = 6989,
  [6990] = 6990,
  [6991] = 6983,
  [6992] = 6982,
  [6993] = 6909,
  [6994] = 6878,
  [6995] = 6877,
  [6996] = 6885,
  [6997] = 6909,
  [6998] = 6998,
  [6999] = 6898,
  [7000] = 6889,
  [7001] = 5965,
  [7002] = 6876,
  [7003] = 6874,
  [7004] = 6873,
  [7005] = 6872,
  [7006] = 6875,
  [7007] = 6891,
  [7008] = 6888,
  [7009] = 6899,
  [7010] = 7010,
  [7011] = 7011,
  [7012] = 6904,
  [7013] = 6873,
  [7014] = 6878,
  [7015] = 6877,
  [7016] = 6909,
  [7017] = 6898,
  [7018] = 6889,
  [7019] = 7019,
  [7020] = 6876,
  [7021] = 6874,
  [7022] = 6873,
  [7023] = 6904,
  [7024] = 7024,
  [7025] = 6872,
  [7026] = 6875,
  [7027] = 7027,
  [7028] = 7028,
  [7029] = 7029,
  [7030] = 7030,
  [7031] = 6891,
  [7032] = 7032,
  [7033] = 6888,
  [7034] = 7034,
  [7035] = 6952,
  [7036] = 6952,
  [7037] = 6899,
  [7038] = 6887,
  [7039] = 6882,
  [7040] = 6896,
  [7041] = 6878,
  [7042] = 6877,
  [7043] = 7043,
  [7044] = 6909,
  [7045] = 6877,
  [7046] = 6904,
  [7047] = 7047,
  [7048] = 6878,
  [7049] = 6898,
  [7050] = 6952,
  [7051] = 6889,
  [7052] = 6909,
  [7053] = 6982,
  [7054] = 6983,
  [7055] = 6876,
  [7056] = 6874,
  [7057] = 6877,
  [7058] = 6898,
  [7059] = 6872,
  [7060] = 6875,
  [7061] = 6891,
  [7062] = 6888,
  [7063] = 7063,
  [7064] = 6891,
  [7065] = 6898,
  [7066] = 6899,
  [7067] = 6889,
  [7068] = 7068,
  [7069] = 6904,
  [7070] = 6952,
  [7071] = 6889,
  [7072] = 6877,
  [7073] = 7073,
  [7074] = 6878,
  [7075] = 6878,
  [7076] = 6899,
  [7077] = 6876,
  [7078] = 6909,
  [7079] = 6876,
  [7080] = 6874,
  [7081] = 6904,
  [7082] = 6874,
  [7083] = 6873,
  [7084] = 6898,
  [7085] = 6952,
  [7086] = 6873,
  [7087] = 6889,
  [7088] = 7088,
  [7089] = 6876,
  [7090] = 6874,
  [7091] = 6896,
  [7092] = 6873,
  [7093] = 6872,
  [7094] = 6954,
  [7095] = 6885,
  [7096] = 6875,
  [7097] = 6875,
  [7098] = 6891,
  [7099] = 6888,
  [7100] = 6899,
  [7101] = 6904,
  [7102] = 6899,
  [7103] = 6882,
  [7104] = 6952,
  [7105] = 6909,
  [7106] = 6888,
  [7107] = 6887,
  [7108] = 6888,
  [7109] = 6891,
  [7110] = 6875,
  [7111] = 6878,
  [7112] = 6877,
  [7113] = 6872,
  [7114] = 6909,
  [7115] = 6904,
  [7116] = 6898,
  [7117] = 6952,
  [7118] = 6889,
  [7119] = 6876,
  [7120] = 6874,
  [7121] = 6873,
  [7122] = 4525,
  [7123] = 6873,
  [7124] = 6874,
  [7125] = 6876,
  [7126] = 6954,
  [7127] = 6872,
  [7128] = 6875,
  [7129] = 6891,
  [7130] = 6888,
  [7131] = 7131,
  [7132] = 7132,
  [7133] = 6889,
  [7134] = 6899,
  [7135] = 6904,
  [7136] = 6952,
  [7137] = 6898,
  [7138] = 7138,
  [7139] = 7139,
  [7140] = 6878,
  [7141] = 6877,
  [7142] = 6909,
  [7143] = 6872,
  [7144] = 7144,
  [7145] = 6904,
  [7146] = 6904,
  [7147] = 6875,
  [7148] = 7148,
  [7149] = 6899,
  [7150] = 6898,
  [7151] = 6952,
  [7152] = 6952,
  [7153] = 6889,
  [7154] = 6876,
  [7155] = 6960,
  [7156] = 6959,
  [7157] = 6958,
  [7158] = 6957,
  [7159] = 6874,
  [7160] = 7160,
  [7161] = 6873,
  [7162] = 6885,
  [7163] = 6877,
  [7164] = 6878,
  [7165] = 6891,
  [7166] = 7166,
  [7167] = 6957,
  [7168] = 6888,
  [7169] = 7169,
  [7170] = 6872,
  [7171] = 6875,
  [7172] = 6891,
  [7173] = 7173,
  [7174] = 7174,
  [7175] = 6888,
  [7176] = 7176,
  [7177] = 7177,
  [7178] = 6958,
  [7179] = 6959,
  [7180] = 6904,
  [7181] = 7181,
  [7182] = 6899,
  [7183] = 7183,
  [7184] = 6952,
  [7185] = 7185,
  [7186] = 6960,
  [7187] = 6899,
  [7188] = 6878,
  [7189] = 6877,
  [7190] = 6909,
  [7191] = 6898,
  [7192] = 6904,
  [7193] = 7193,
  [7194] = 6889,
  [7195] = 6952,
  [7196] = 6876,
  [7197] = 6874,
  [7198] = 6873,
  [7199] = 6872,
  [7200] = 7200,
  [7201] = 6875,
  [7202] = 6891,
  [7203] = 6888,
  [7204] = 7204,
  [7205] = 7205,
  [7206] = 7205,
  [7207] = 7207,
  [7208] = 7208,
  [7209] = 7209,
  [7210] = 7210,
  [7211] = 7209,
  [7212] = 7210,
  [7213] = 7213,
  [7214] = 7214,
  [7215] = 7215,
  [7216] = 7216,
  [7217] = 7217,
  [7218] = 7218,
  [7219] = 7209,
  [7220] = 7220,
  [7221] = 7221,
  [7222] = 7215,
  [7223] = 7216,
  [7224] = 7224,
  [7225] = 7215,
  [7226] = 7216,
  [7227] = 7227,
  [7228] = 7215,
  [7229] = 7216,
  [7230] = 1872,
  [7231] = 7215,
  [7232] = 7216,
  [7233] = 7233,
  [7234] = 7234,
  [7235] = 7215,
  [7236] = 7236,
  [7237] = 7237,
  [7238] = 7216,
  [7239] = 7239,
  [7240] = 7240,
  [7241] = 7241,
  [7242] = 7242,
  [7243] = 7243,
  [7244] = 7244,
  [7245] = 7245,
  [7246] = 7246,
  [7247] = 7247,
  [7248] = 7248,
  [7249] = 7215,
  [7250] = 7210,
  [7251] = 7251,
  [7252] = 7216,
  [7253] = 7253,
  [7254] = 7254,
  [7255] = 7255,
  [7256] = 7215,
  [7257] = 7257,
  [7258] = 7258,
  [7259] = 7259,
  [7260] = 7216,
  [7261] = 7261,
  [7262] = 7262,
  [7263] = 7215,
  [7264] = 7264,
  [7265] = 7240,
  [7266] = 7216,
  [7267] = 7215,
  [7268] = 7268,
  [7269] = 7269,
  [7270] = 7220,
  [7271] = 7271,
  [7272] = 7216,
  [7273] = 7205,
  [7274] = 7215,
  [7275] = 7224,
  [7276] = 7216,
  [7277] = 7277,
  [7278] = 7227,
  [7279] = 7215,
  [7280] = 7216,
  [7281] = 7253,
  [7282] = 7247,
  [7283] = 7283,
  [7284] = 7253,
  [7285] = 7254,
  [7286] = 4799,
  [7287] = 7215,
  [7288] = 7288,
  [7289] = 7216,
  [7290] = 7283,
  [7291] = 7205,
  [7292] = 7292,
  [7293] = 7205,
  [7294] = 7261,
  [7295] = 7242,
  [7296] = 7254,
  [7297] = 7297,
  [7298] = 7253,
  [7299] = 7299,
  [7300] = 7215,
  [7301] = 7288,
  [7302] = 7216,
  [7303] = 7283,
  [7304] = 7247,
  [7305] = 7243,
  [7306] = 7306,
  [7307] = 7241,
  [7308] = 7308,
  [7309] = 7309,
  [7310] = 7310,
  [7311] = 7234,
  [7312] = 7233,
  [7313] = 7227,
  [7314] = 7314,
  [7315] = 7315,
  [7316] = 7308,
  [7317] = 7224,
  [7318] = 7308,
  [7319] = 7314,
  [7320] = 7315,
  [7321] = 7321,
  [7322] = 7277,
  [7323] = 7261,
  [7324] = 7261,
  [7325] = 7261,
  [7326] = 7261,
  [7327] = 7261,
  [7328] = 7261,
  [7329] = 7329,
  [7330] = 7330,
  [7331] = 7308,
  [7332] = 7292,
  [7333] = 7261,
  [7334] = 7207,
  [7335] = 7314,
  [7336] = 7261,
  [7337] = 7315,
  [7338] = 7308,
  [7339] = 7261,
  [7340] = 7340,
  [7341] = 7227,
  [7342] = 7220,
  [7343] = 7314,
  [7344] = 7253,
  [7345] = 7315,
  [7346] = 7254,
  [7347] = 7308,
  [7348] = 7314,
  [7349] = 7315,
  [7350] = 7308,
  [7351] = 7261,
  [7352] = 7227,
  [7353] = 7314,
  [7354] = 7315,
  [7355] = 7308,
  [7356] = 7253,
  [7357] = 7254,
  [7358] = 7314,
  [7359] = 7315,
  [7360] = 7308,
  [7361] = 7205,
  [7362] = 7261,
  [7363] = 7207,
  [7364] = 7314,
  [7365] = 7227,
  [7366] = 7315,
  [7367] = 7308,
  [7368] = 7292,
  [7369] = 7254,
  [7370] = 7314,
  [7371] = 7315,
  [7372] = 7205,
  [7373] = 7308,
  [7374] = 7261,
  [7375] = 7227,
  [7376] = 7253,
  [7377] = 7254,
  [7378] = 7220,
  [7379] = 7379,
  [7380] = 7314,
  [7381] = 7315,
  [7382] = 7205,
  [7383] = 7261,
  [7384] = 7227,
  [7385] = 7253,
  [7386] = 7205,
  [7387] = 7254,
  [7388] = 7253,
  [7389] = 7247,
  [7390] = 7227,
  [7391] = 7224,
  [7392] = 7254,
  [7393] = 7220,
  [7394] = 7394,
  [7395] = 7308,
  [7396] = 7396,
  [7397] = 7314,
  [7398] = 7205,
  [7399] = 7261,
  [7400] = 7205,
  [7401] = 7254,
  [7402] = 7253,
  [7403] = 7227,
  [7404] = 7220,
  [7405] = 7224,
  [7406] = 7227,
  [7407] = 7247,
  [7408] = 7205,
  [7409] = 7254,
  [7410] = 7253,
  [7411] = 7227,
  [7412] = 7253,
  [7413] = 7254,
  [7414] = 7315,
  [7415] = 7224,
  [7416] = 7205,
  [7417] = 7417,
  [7418] = 7227,
  [7419] = 7308,
  [7420] = 7261,
  [7421] = 7421,
  [7422] = 7299,
  [7423] = 7297,
  [7424] = 7220,
  [7425] = 7224,
  [7426] = 7247,
  [7427] = 7314,
  [7428] = 7428,
  [7429] = 7253,
  [7430] = 7315,
  [7431] = 7215,
  [7432] = 7227,
  [7433] = 7247,
  [7434] = 7253,
  [7435] = 7254,
  [7436] = 7254,
  [7437] = 7254,
  [7438] = 7205,
  [7439] = 7205,
  [7440] = 7261,
  [7441] = 7220,
  [7442] = 7224,
  [7443] = 7227,
  [7444] = 7247,
  [7445] = 7205,
  [7446] = 7446,
  [7447] = 7261,
  [7448] = 7253,
  [7449] = 7254,
  [7450] = 7254,
  [7451] = 7253,
  [7452] = 7308,
  [7453] = 7421,
  [7454] = 7233,
  [7455] = 7242,
  [7456] = 7205,
  [7457] = 7261,
  [7458] = 7233,
  [7459] = 7220,
  [7460] = 7460,
  [7461] = 7224,
  [7462] = 7462,
  [7463] = 7227,
  [7464] = 7227,
  [7465] = 7268,
  [7466] = 7247,
  [7467] = 7253,
  [7468] = 7254,
  [7469] = 7234,
  [7470] = 7268,
  [7471] = 7241,
  [7472] = 7205,
  [7473] = 7261,
  [7474] = 7233,
  [7475] = 7240,
  [7476] = 7220,
  [7477] = 7224,
  [7478] = 7227,
  [7479] = 7247,
  [7480] = 7253,
  [7481] = 7254,
  [7482] = 7243,
  [7483] = 7261,
  [7484] = 7205,
  [7485] = 7261,
  [7486] = 7233,
  [7487] = 7292,
  [7488] = 7207,
  [7489] = 7220,
  [7490] = 7224,
  [7491] = 7227,
  [7492] = 7247,
  [7493] = 7253,
  [7494] = 7314,
  [7495] = 7495,
  [7496] = 7269,
  [7497] = 7205,
  [7498] = 7315,
  [7499] = 7205,
  [7500] = 7500,
  [7501] = 7254,
  [7502] = 7261,
  [7503] = 7253,
  [7504] = 7233,
  [7505] = 7292,
  [7506] = 7207,
  [7507] = 7507,
  [7508] = 7508,
  [7509] = 7220,
  [7510] = 7247,
  [7511] = 7243,
  [7512] = 7224,
  [7513] = 7241,
  [7514] = 7227,
  [7515] = 7247,
  [7516] = 7253,
  [7517] = 7227,
  [7518] = 7254,
  [7519] = 7224,
  [7520] = 7308,
  [7521] = 7205,
  [7522] = 7261,
  [7523] = 7421,
  [7524] = 7220,
  [7525] = 7233,
  [7526] = 7292,
  [7527] = 7242,
  [7528] = 7207,
  [7529] = 7234,
  [7530] = 7530,
  [7531] = 7233,
  [7532] = 7233,
  [7533] = 7314,
  [7534] = 7534,
  [7535] = 7535,
  [7536] = 7315,
  [7537] = 7220,
  [7538] = 7538,
  [7539] = 7220,
  [7540] = 7234,
  [7541] = 7541,
  [7542] = 7241,
  [7543] = 7207,
  [7544] = 7315,
  [7545] = 7243,
  [7546] = 7207,
  [7547] = 7547,
  [7548] = 7224,
  [7549] = 7227,
  [7550] = 7292,
  [7551] = 7208,
  [7552] = 7233,
  [7553] = 7234,
  [7554] = 7554,
  [7555] = 7241,
  [7556] = 7247,
  [7557] = 7253,
  [7558] = 7254,
  [7559] = 7243,
  [7560] = 7224,
  [7561] = 7561,
  [7562] = 7261,
  [7563] = 7205,
  [7564] = 7535,
  [7565] = 7299,
  [7566] = 7288,
  [7567] = 7240,
  [7568] = 7254,
  [7569] = 7205,
  [7570] = 7261,
  [7571] = 7253,
  [7572] = 7247,
  [7573] = 7297,
  [7574] = 7243,
  [7575] = 7241,
  [7576] = 7234,
  [7577] = 7233,
  [7578] = 7227,
  [7579] = 7292,
  [7580] = 7207,
  [7581] = 7224,
  [7582] = 7220,
  [7583] = 7207,
  [7584] = 7292,
  [7585] = 7240,
  [7586] = 7586,
  [7587] = 7421,
  [7588] = 7233,
  [7589] = 7220,
  [7590] = 7590,
  [7591] = 7234,
  [7592] = 7292,
  [7593] = 7241,
  [7594] = 7243,
  [7595] = 7261,
  [7596] = 7205,
  [7597] = 7224,
  [7598] = 7227,
  [7599] = 7254,
  [7600] = 7600,
  [7601] = 7253,
  [7602] = 7247,
  [7603] = 7240,
  [7604] = 7247,
  [7605] = 7605,
  [7606] = 7253,
  [7607] = 7254,
  [7608] = 7227,
  [7609] = 7224,
  [7610] = 7220,
  [7611] = 7261,
  [7612] = 7205,
  [7613] = 7254,
  [7614] = 7253,
  [7615] = 7227,
  [7616] = 7240,
  [7617] = 7207,
  [7618] = 7292,
  [7619] = 7205,
  [7620] = 7254,
  [7621] = 7253,
  [7622] = 7227,
  [7623] = 7241,
  [7624] = 7205,
  [7625] = 7261,
  [7626] = 7233,
  [7627] = 7271,
  [7628] = 7628,
  [7629] = 7234,
  [7630] = 7205,
  [7631] = 7241,
  [7632] = 7243,
  [7633] = 7299,
  [7634] = 7261,
  [7635] = 7205,
  [7636] = 7254,
  [7637] = 7243,
  [7638] = 7253,
  [7639] = 7234,
  [7640] = 7221,
  [7641] = 7233,
  [7642] = 7642,
  [7643] = 7292,
  [7644] = 7207,
  [7645] = 7645,
  [7646] = 7205,
  [7647] = 7247,
  [7648] = 7240,
  [7649] = 7254,
  [7650] = 7227,
  [7651] = 7253,
  [7652] = 7224,
  [7653] = 7653,
  [7654] = 7242,
  [7655] = 7220,
  [7656] = 7656,
  [7657] = 7657,
  [7658] = 7220,
  [7659] = 7207,
  [7660] = 7227,
  [7661] = 7240,
  [7662] = 7292,
  [7663] = 7233,
  [7664] = 7234,
  [7665] = 7268,
  [7666] = 7224,
  [7667] = 7227,
  [7668] = 7240,
  [7669] = 7669,
  [7670] = 7241,
  [7671] = 7243,
  [7672] = 7672,
  [7673] = 7261,
  [7674] = 7205,
  [7675] = 7254,
  [7676] = 7253,
  [7677] = 7247,
  [7678] = 7678,
  [7679] = 7247,
  [7680] = 7240,
  [7681] = 7314,
  [7682] = 7216,
  [7683] = 7227,
  [7684] = 7224,
  [7685] = 7253,
  [7686] = 7254,
  [7687] = 7227,
  [7688] = 7207,
  [7689] = 7220,
  [7690] = 7690,
  [7691] = 7240,
  [7692] = 7207,
  [7693] = 7292,
  [7694] = 7233,
  [7695] = 7695,
  [7696] = 7205,
  [7697] = 7261,
  [7698] = 7234,
  [7699] = 7241,
  [7700] = 7243,
  [7701] = 7241,
  [7702] = 7234,
  [7703] = 7254,
  [7704] = 7233,
  [7705] = 7207,
  [7706] = 7243,
  [7707] = 7292,
  [7708] = 7207,
  [7709] = 7253,
  [7710] = 7261,
  [7711] = 7247,
  [7712] = 7292,
  [7713] = 7205,
  [7714] = 7714,
  [7715] = 7220,
  [7716] = 7716,
  [7717] = 7254,
  [7718] = 7253,
  [7719] = 7292,
  [7720] = 7247,
  [7721] = 7240,
  [7722] = 7227,
  [7723] = 7224,
  [7724] = 7227,
  [7725] = 7261,
  [7726] = 7224,
  [7727] = 7727,
  [7728] = 7220,
  [7729] = 7247,
  [7730] = 7253,
  [7731] = 7254,
  [7732] = 7207,
  [7733] = 7733,
  [7734] = 7205,
  [7735] = 7254,
  [7736] = 7253,
  [7737] = 7227,
  [7738] = 7738,
  [7739] = 7299,
  [7740] = 7292,
  [7741] = 7233,
  [7742] = 7234,
  [7743] = 7241,
  [7744] = 7744,
  [7745] = 7243,
  [7746] = 7299,
  [7747] = 7240,
  [7748] = 7261,
  [7749] = 7205,
  [7750] = 7243,
  [7751] = 7241,
  [7752] = 7234,
  [7753] = 7233,
  [7754] = 7754,
  [7755] = 7242,
  [7756] = 7292,
  [7757] = 7242,
  [7758] = 7207,
  [7759] = 7759,
  [7760] = 7240,
  [7761] = 7220,
  [7762] = 7762,
  [7763] = 7763,
  [7764] = 7299,
  [7765] = 7283,
  [7766] = 7224,
  [7767] = 7227,
  [7768] = 7247,
  [7769] = 7253,
  [7770] = 7254,
  [7771] = 7242,
  [7772] = 7772,
  [7773] = 7773,
  [7774] = 7774,
  [7775] = 7775,
  [7776] = 7776,
  [7777] = 7777,
  [7778] = 7778,
  [7779] = 7779,
  [7780] = 7780,
  [7781] = 7781,
  [7782] = 7782,
  [7783] = 7783,
  [7784] = 7784,
  [7785] = 7774,
  [7786] = 7778,
  [7787] = 7787,
  [7788] = 7788,
  [7789] = 7789,
  [7790] = 7790,
  [7791] = 7791,
  [7792] = 7792,
  [7793] = 7793,
  [7794] = 7794,
  [7795] = 7795,
  [7796] = 7796,
  [7797] = 7797,
  [7798] = 7798,
  [7799] = 7799,
  [7800] = 7800,
  [7801] = 7801,
  [7802] = 7802,
  [7803] = 7803,
  [7804] = 7804,
  [7805] = 7773,
  [7806] = 7806,
  [7807] = 7807,
  [7808] = 7787,
  [7809] = 7783,
  [7810] = 7774,
  [7811] = 7784,
  [7812] = 7782,
  [7813] = 7780,
  [7814] = 7779,
  [7815] = 7781,
  [7816] = 7779,
  [7817] = 7780,
  [7818] = 7806,
  [7819] = 7782,
  [7820] = 7773,
  [7821] = 7784,
  [7822] = 7774,
  [7823] = 7804,
  [7824] = 7803,
  [7825] = 7802,
  [7826] = 7783,
  [7827] = 7790,
  [7828] = 7828,
  [7829] = 7797,
  [7830] = 7798,
  [7831] = 7831,
  [7832] = 7800,
  [7833] = 7801,
  [7834] = 7776,
  [7835] = 7777,
  [7836] = 7787,
  [7837] = 7795,
  [7838] = 7788,
  [7839] = 7789,
  [7840] = 7794,
  [7841] = 7793,
  [7842] = 7792,
  [7843] = 7793,
  [7844] = 7794,
  [7845] = 7795,
  [7846] = 7789,
  [7847] = 7788,
  [7848] = 7792,
  [7849] = 7777,
  [7850] = 7801,
  [7851] = 7851,
  [7852] = 7779,
  [7853] = 7780,
  [7854] = 7854,
  [7855] = 7782,
  [7856] = 7784,
  [7857] = 7774,
  [7858] = 7802,
  [7859] = 7794,
  [7860] = 7803,
  [7861] = 7804,
  [7862] = 7776,
  [7863] = 7806,
  [7864] = 7795,
  [7865] = 7800,
  [7866] = 7798,
  [7867] = 7797,
  [7868] = 7778,
  [7869] = 7790,
  [7870] = 7783,
  [7871] = 7781,
  [7872] = 7793,
  [7873] = 7778,
  [7874] = 7874,
  [7875] = 7781,
  [7876] = 7806,
  [7877] = 7773,
  [7878] = 7777,
  [7879] = 7802,
  [7880] = 7790,
  [7881] = 7801,
  [7882] = 7779,
  [7883] = 7780,
  [7884] = 7802,
  [7885] = 7782,
  [7886] = 7784,
  [7887] = 7774,
  [7888] = 7804,
  [7889] = 7803,
  [7890] = 7797,
  [7891] = 7798,
  [7892] = 7800,
  [7893] = 7804,
  [7894] = 7894,
  [7895] = 7803,
  [7896] = 7776,
  [7897] = 7806,
  [7898] = 7787,
  [7899] = 7788,
  [7900] = 7802,
  [7901] = 7789,
  [7902] = 7801,
  [7903] = 7903,
  [7904] = 7904,
  [7905] = 7792,
  [7906] = 7793,
  [7907] = 7794,
  [7908] = 7795,
  [7909] = 7909,
  [7910] = 7789,
  [7911] = 7779,
  [7912] = 7780,
  [7913] = 7788,
  [7914] = 7782,
  [7915] = 7784,
  [7916] = 7774,
  [7917] = 7787,
  [7918] = 7773,
  [7919] = 7919,
  [7920] = 7801,
  [7921] = 7802,
  [7922] = 7806,
  [7923] = 7803,
  [7924] = 7804,
  [7925] = 7773,
  [7926] = 7806,
  [7927] = 7927,
  [7928] = 7928,
  [7929] = 7929,
  [7930] = 7795,
  [7931] = 7778,
  [7932] = 7794,
  [7933] = 7793,
  [7934] = 7792,
  [7935] = 7789,
  [7936] = 7781,
  [7937] = 7788,
  [7938] = 7787,
  [7939] = 7777,
  [7940] = 7779,
  [7941] = 7780,
  [7942] = 7783,
  [7943] = 7782,
  [7944] = 7784,
  [7945] = 7774,
  [7946] = 7790,
  [7947] = 7797,
  [7948] = 7798,
  [7949] = 7800,
  [7950] = 7950,
  [7951] = 7776,
  [7952] = 7776,
  [7953] = 7777,
  [7954] = 7787,
  [7955] = 7788,
  [7956] = 7956,
  [7957] = 7957,
  [7958] = 7958,
  [7959] = 7789,
  [7960] = 7960,
  [7961] = 7800,
  [7962] = 7798,
  [7963] = 7792,
  [7964] = 7793,
  [7965] = 7794,
  [7966] = 7795,
  [7967] = 7797,
  [7968] = 7790,
  [7969] = 7779,
  [7970] = 7780,
  [7971] = 7783,
  [7972] = 7782,
  [7973] = 7784,
  [7974] = 7774,
  [7975] = 7781,
  [7976] = 7976,
  [7977] = 7792,
  [7978] = 7801,
  [7979] = 7802,
  [7980] = 7803,
  [7981] = 7804,
  [7982] = 7773,
  [7983] = 7797,
  [7984] = 7984,
  [7985] = 7774,
  [7986] = 7986,
  [7987] = 7778,
  [7988] = 7784,
  [7989] = 7782,
  [7990] = 7990,
  [7991] = 7780,
  [7992] = 7779,
  [7993] = 7781,
  [7994] = 7778,
  [7995] = 7773,
  [7996] = 7804,
  [7997] = 7997,
  [7998] = 7779,
  [7999] = 7780,
  [8000] = 7783,
  [8001] = 7782,
  [8002] = 7784,
  [8003] = 7774,
  [8004] = 7790,
  [8005] = 7803,
  [8006] = 7781,
  [8007] = 7798,
  [8008] = 7800,
  [8009] = 7776,
  [8010] = 7776,
  [8011] = 7777,
  [8012] = 7787,
  [8013] = 7788,
  [8014] = 8014,
  [8015] = 8015,
  [8016] = 8016,
  [8017] = 7789,
  [8018] = 8018,
  [8019] = 8019,
  [8020] = 7778,
  [8021] = 7792,
  [8022] = 7793,
  [8023] = 7794,
  [8024] = 7795,
  [8025] = 7801,
  [8026] = 7795,
  [8027] = 7779,
  [8028] = 7780,
  [8029] = 7794,
  [8030] = 7782,
  [8031] = 7784,
  [8032] = 7774,
  [8033] = 7793,
  [8034] = 7801,
  [8035] = 7802,
  [8036] = 7803,
  [8037] = 7804,
  [8038] = 8038,
  [8039] = 4741,
  [8040] = 7773,
  [8041] = 7806,
  [8042] = 7792,
  [8043] = 7774,
  [8044] = 7784,
  [8045] = 7789,
  [8046] = 7778,
  [8047] = 7788,
  [8048] = 7787,
  [8049] = 7777,
  [8050] = 7777,
  [8051] = 8051,
  [8052] = 7800,
  [8053] = 7797,
  [8054] = 7798,
  [8055] = 8055,
  [8056] = 7779,
  [8057] = 7780,
  [8058] = 8058,
  [8059] = 7782,
  [8060] = 7784,
  [8061] = 7774,
  [8062] = 7783,
  [8063] = 7790,
  [8064] = 7797,
  [8065] = 7798,
  [8066] = 7800,
  [8067] = 7797,
  [8068] = 7776,
  [8069] = 7777,
  [8070] = 7787,
  [8071] = 7788,
  [8072] = 7789,
  [8073] = 7790,
  [8074] = 7783,
  [8075] = 7792,
  [8076] = 7793,
  [8077] = 7781,
  [8078] = 7794,
  [8079] = 7795,
  [8080] = 7778,
  [8081] = 8081,
  [8082] = 8082,
  [8083] = 8083,
  [8084] = 7801,
  [8085] = 7784,
  [8086] = 7774,
  [8087] = 7802,
  [8088] = 7803,
  [8089] = 7806,
  [8090] = 7804,
  [8091] = 8091,
  [8092] = 7773,
  [8093] = 7784,
  [8094] = 7774,
  [8095] = 7773,
  [8096] = 7806,
  [8097] = 4690,
  [8098] = 8098,
  [8099] = 7804,
  [8100] = 7784,
  [8101] = 7774,
  [8102] = 7778,
  [8103] = 8103,
  [8104] = 7803,
  [8105] = 7802,
  [8106] = 7801,
  [8107] = 7784,
  [8108] = 7774,
  [8109] = 7795,
  [8110] = 7794,
  [8111] = 7806,
  [8112] = 8112,
  [8113] = 8113,
  [8114] = 7784,
  [8115] = 7774,
  [8116] = 8116,
  [8117] = 7781,
  [8118] = 7792,
  [8119] = 7782,
  [8120] = 8120,
  [8121] = 7784,
  [8122] = 7774,
  [8123] = 7777,
  [8124] = 7789,
  [8125] = 7788,
  [8126] = 7780,
  [8127] = 7784,
  [8128] = 7774,
  [8129] = 7779,
  [8130] = 7787,
  [8131] = 7783,
  [8132] = 7790,
  [8133] = 7784,
  [8134] = 7774,
  [8135] = 8135,
  [8136] = 7773,
  [8137] = 8137,
  [8138] = 8138,
  [8139] = 7784,
  [8140] = 7774,
  [8141] = 7784,
  [8142] = 7774,
  [8143] = 7784,
  [8144] = 7774,
  [8145] = 7784,
  [8146] = 8146,
  [8147] = 7784,
  [8148] = 7774,
  [8149] = 7784,
  [8150] = 7774,
  [8151] = 7784,
  [8152] = 7774,
  [8153] = 7776,
  [8154] = 7798,
  [8155] = 7800,
  [8156] = 8135,
  [8157] = 7800,
  [8158] = 8120,
  [8159] = 7776,
  [8160] = 8038,
  [8161] = 8015,
  [8162] = 8014,
  [8163] = 7781,
  [8164] = 7793,
  [8165] = 7776,
  [8166] = 7798,
  [8167] = 8167,
  [8168] = 7777,
  [8169] = 7797,
  [8170] = 7790,
  [8171] = 8171,
  [8172] = 7781,
  [8173] = 7783,
  [8174] = 7787,
  [8175] = 7788,
  [8176] = 1695,
  [8177] = 7909,
  [8178] = 7789,
  [8179] = 8179,
  [8180] = 8180,
  [8181] = 8181,
  [8182] = 8180,
  [8183] = 8183,
  [8184] = 8184,
  [8185] = 7806,
  [8186] = 7773,
  [8187] = 7792,
  [8188] = 7793,
  [8189] = 7794,
  [8190] = 7795,
  [8191] = 8191,
  [8192] = 8192,
  [8193] = 8193,
  [8194] = 8194,
  [8195] = 8195,
  [8196] = 7801,
  [8197] = 7802,
  [8198] = 7803,
  [8199] = 7804,
  [8200] = 7773,
  [8201] = 8135,
  [8202] = 8202,
  [8203] = 8120,
  [8204] = 8038,
  [8205] = 8015,
  [8206] = 8014,
  [8207] = 7806,
  [8208] = 7806,
  [8209] = 7773,
  [8210] = 7793,
  [8211] = 7778,
  [8212] = 7806,
  [8213] = 7773,
  [8214] = 7806,
  [8215] = 7806,
  [8216] = 7909,
  [8217] = 7806,
  [8218] = 8180,
  [8219] = 8181,
  [8220] = 7773,
  [8221] = 8221,
  [8222] = 7781,
  [8223] = 7778,
  [8224] = 8224,
  [8225] = 8225,
  [8226] = 7806,
  [8227] = 7773,
  [8228] = 7804,
  [8229] = 7803,
  [8230] = 7802,
  [8231] = 7801,
  [8232] = 8181,
  [8233] = 8135,
  [8234] = 7773,
  [8235] = 8120,
  [8236] = 8236,
  [8237] = 8237,
  [8238] = 7774,
  [8239] = 7795,
  [8240] = 7794,
  [8241] = 7777,
  [8242] = 7792,
  [8243] = 7909,
  [8244] = 7784,
  [8245] = 8180,
  [8246] = 7782,
  [8247] = 7780,
  [8248] = 7779,
  [8249] = 8135,
  [8250] = 7806,
  [8251] = 8120,
  [8252] = 7773,
  [8253] = 7789,
  [8254] = 7788,
  [8255] = 8255,
  [8256] = 7787,
  [8257] = 7909,
  [8258] = 8180,
  [8259] = 7806,
  [8260] = 8135,
  [8261] = 7773,
  [8262] = 8120,
  [8263] = 7806,
  [8264] = 7795,
  [8265] = 7776,
  [8266] = 8266,
  [8267] = 7800,
  [8268] = 7909,
  [8269] = 8180,
  [8270] = 7773,
  [8271] = 8135,
  [8272] = 8272,
  [8273] = 8120,
  [8274] = 7806,
  [8275] = 8225,
  [8276] = 7800,
  [8277] = 8277,
  [8278] = 7773,
  [8279] = 7909,
  [8280] = 8180,
  [8281] = 7798,
  [8282] = 8135,
  [8283] = 7806,
  [8284] = 8120,
  [8285] = 8285,
  [8286] = 8286,
  [8287] = 7798,
  [8288] = 8288,
  [8289] = 7783,
  [8290] = 7909,
  [8291] = 8180,
  [8292] = 8292,
  [8293] = 8135,
  [8294] = 7806,
  [8295] = 8120,
  [8296] = 8296,
  [8297] = 7790,
  [8298] = 7797,
  [8299] = 8299,
  [8300] = 7797,
  [8301] = 7909,
  [8302] = 8180,
  [8303] = 7773,
  [8304] = 8135,
  [8305] = 8305,
  [8306] = 8120,
  [8307] = 8307,
  [8308] = 7790,
  [8309] = 7798,
  [8310] = 8310,
  [8311] = 8311,
  [8312] = 7909,
  [8313] = 8180,
  [8314] = 8314,
  [8315] = 8135,
  [8316] = 7776,
  [8317] = 8120,
  [8318] = 8318,
  [8319] = 7783,
  [8320] = 8320,
  [8321] = 8321,
  [8322] = 7800,
  [8323] = 7909,
  [8324] = 8180,
  [8325] = 7806,
  [8326] = 8135,
  [8327] = 7773,
  [8328] = 8120,
  [8329] = 8329,
  [8330] = 8330,
  [8331] = 8331,
  [8332] = 8332,
  [8333] = 8333,
  [8334] = 7909,
  [8335] = 8180,
  [8336] = 8336,
  [8337] = 8135,
  [8338] = 7806,
  [8339] = 8120,
  [8340] = 7773,
  [8341] = 8341,
  [8342] = 7773,
  [8343] = 7776,
  [8344] = 7777,
  [8345] = 7909,
  [8346] = 8180,
  [8347] = 7806,
  [8348] = 8135,
  [8349] = 7773,
  [8350] = 8120,
  [8351] = 8351,
  [8352] = 7787,
  [8353] = 7788,
  [8354] = 7789,
  [8355] = 7779,
  [8356] = 7909,
  [8357] = 8180,
  [8358] = 8358,
  [8359] = 8135,
  [8360] = 7780,
  [8361] = 8120,
  [8362] = 4646,
  [8363] = 7782,
  [8364] = 7781,
  [8365] = 8365,
  [8366] = 8366,
  [8367] = 7909,
  [8368] = 8180,
  [8369] = 8369,
  [8370] = 7797,
  [8371] = 7790,
  [8372] = 7792,
  [8373] = 7793,
  [8374] = 7794,
  [8375] = 7802,
  [8376] = 8376,
  [8377] = 8377,
  [8378] = 8378,
  [8379] = 8113,
  [8380] = 8380,
  [8381] = 8381,
  [8382] = 8382,
  [8383] = 8383,
  [8384] = 8384,
  [8385] = 7784,
  [8386] = 7778,
  [8387] = 7774,
  [8388] = 4816,
  [8389] = 7801,
  [8390] = 8382,
  [8391] = 8391,
  [8392] = 8392,
  [8393] = 7957,
  [8394] = 8394,
  [8395] = 8381,
  [8396] = 8382,
  [8397] = 7803,
  [8398] = 7804,
  [8399] = 7773,
  [8400] = 8400,
  [8401] = 8401,
  [8402] = 4341,
  [8403] = 7806,
  [8404] = 7806,
  [8405] = 8405,
  [8406] = 8406,
  [8407] = 8407,
  [8408] = 7773,
  [8409] = 8409,
  [8410] = 7804,
  [8411] = 8411,
  [8412] = 8412,
  [8413] = 7803,
  [8414] = 7802,
  [8415] = 7801,
  [8416] = 8416,
  [8417] = 8332,
  [8418] = 8418,
  [8419] = 7778,
  [8420] = 8420,
  [8421] = 8331,
  [8422] = 8330,
  [8423] = 8423,
  [8424] = 8424,
  [8425] = 8320,
  [8426] = 8426,
  [8427] = 8427,
  [8428] = 8428,
  [8429] = 8429,
  [8430] = 8311,
  [8431] = 8431,
  [8432] = 8432,
  [8433] = 8433,
  [8434] = 7795,
  [8435] = 8435,
  [8436] = 8436,
  [8437] = 8437,
  [8438] = 7794,
  [8439] = 7781,
  [8440] = 8440,
  [8441] = 8441,
  [8442] = 8442,
  [8443] = 7793,
  [8444] = 7792,
  [8445] = 8445,
  [8446] = 8446,
  [8447] = 8447,
  [8448] = 8448,
  [8449] = 7789,
  [8450] = 7788,
  [8451] = 8451,
  [8452] = 8452,
  [8453] = 7787,
  [8454] = 7777,
  [8455] = 8455,
  [8456] = 8381,
  [8457] = 8457,
  [8458] = 8171,
  [8459] = 8138,
  [8460] = 8137,
  [8461] = 7986,
  [8462] = 7783,
  [8463] = 8463,
  [8464] = 8225,
  [8465] = 8171,
  [8466] = 8138,
  [8467] = 8137,
  [8468] = 8468,
  [8469] = 8469,
  [8470] = 8171,
  [8471] = 8138,
  [8472] = 8137,
  [8473] = 8171,
  [8474] = 8138,
  [8475] = 8137,
  [8476] = 8171,
  [8477] = 8138,
  [8478] = 8137,
  [8479] = 8171,
  [8480] = 8138,
  [8481] = 8137,
  [8482] = 8171,
  [8483] = 8138,
  [8484] = 8137,
  [8485] = 8171,
  [8486] = 8138,
  [8487] = 8137,
  [8488] = 8171,
  [8489] = 8138,
  [8490] = 8137,
  [8491] = 8171,
  [8492] = 8138,
  [8493] = 8137,
  [8494] = 8171,
  [8495] = 8138,
  [8496] = 8137,
  [8497] = 8171,
  [8498] = 8138,
  [8499] = 8137,
  [8500] = 8171,
  [8501] = 8138,
  [8502] = 8137,
  [8503] = 8171,
  [8504] = 8138,
  [8505] = 8137,
  [8506] = 8506,
  [8507] = 7800,
  [8508] = 7798,
  [8509] = 7797,
  [8510] = 7790,
  [8511] = 8311,
  [8512] = 7783,
  [8513] = 8320,
  [8514] = 8330,
  [8515] = 8331,
  [8516] = 8332,
  [8517] = 8517,
  [8518] = 7775,
  [8519] = 7775,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(34);
      if (lookahead == '!') ADVANCE(11);
      if (lookahead == '"') ADVANCE(37);
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '$') ADVANCE(46);
      if (lookahead == '&') ADVANCE(69);
      if (lookahead == '\'') ADVANCE(36);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(44);
      if (lookahead == '*') ADVANCE(35);
      if (lookahead == '+') ADVANCE(60);
      if (lookahead == ',') ADVANCE(40);
      if (lookahead == '-') ADVANCE(63);
      if (lookahead == '.') ADVANCE(48);
      if (lookahead == '/') ADVANCE(64);
      if (lookahead == ':') ADVANCE(10);
      if (lookahead == ';') ADVANCE(41);
      if (lookahead == '<') ADVANCE(51);
      if (lookahead == '=') ADVANCE(50);
      if (lookahead == '>') ADVANCE(54);
      if (lookahead == '?') ADVANCE(45);
      if (lookahead == '@') ADVANCE(12);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '^') ADVANCE(70);
      if (lookahead == '`') ADVANCE(28);
      if (lookahead == '|') ADVANCE(71);
      if (lookahead == '~') ADVANCE(57);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(31)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 1:
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == '+') ADVANCE(9);
      if (lookahead == '-') ADVANCE(7);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(80);
      if (lookahead == '?') ADVANCE(78);
      if (lookahead == '@') ADVANCE(12);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '`') ADVANCE(28);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(81);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 2:
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '+') ADVANCE(9);
      if (lookahead == '-') ADVANCE(7);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(20)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(81);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '+') ADVANCE(22);
      if (lookahead == '-') ADVANCE(8);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '?') ADVANCE(78);
      if (lookahead == '@') ADVANCE(13);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(21)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      END_STATE();
    case 4:
      if (lookahead == '*') ADVANCE(6);
      END_STATE();
    case 5:
      if (lookahead == '*') ADVANCE(5);
      if (lookahead == '/') ADVANCE(38);
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 6:
      if (lookahead == '*') ADVANCE(5);
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '-') ADVANCE(39);
      if (lookahead == '.') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(81);
      END_STATE();
    case 8:
      if (lookahead == '-') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      END_STATE();
    case 9:
      if (lookahead == '.') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(81);
      END_STATE();
    case 10:
      if (lookahead == ':') ADVANCE(49);
      END_STATE();
    case 11:
      if (lookahead == '=') ADVANCE(66);
      END_STATE();
    case 12:
      if (lookahead == '@') ADVANCE(14);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(77);
      END_STATE();
    case 13:
      if (lookahead == '@') ADVANCE(13);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(77);
      END_STATE();
    case 14:
      if (lookahead == '@') ADVANCE(13);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 15:
      if (lookahead == '`') ADVANCE(89);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 16:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(24);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(87);
      END_STATE();
    case 17:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(86);
      END_STATE();
    case 18:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(84);
      END_STATE();
    case 19:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == '+') ADVANCE(9);
      if (lookahead == '-') ADVANCE(7);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(80);
      if (lookahead == '?') ADVANCE(78);
      if (lookahead == '@') ADVANCE(12);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '`') ADVANCE(28);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(81);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 20:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(20)
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '+') ADVANCE(9);
      if (lookahead == '-') ADVANCE(7);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(81);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 21:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(21)
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '+') ADVANCE(22);
      if (lookahead == '-') ADVANCE(8);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '?') ADVANCE(78);
      if (lookahead == '@') ADVANCE(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      END_STATE();
    case 22:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      END_STATE();
    case 23:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(85);
      END_STATE();
    case 24:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(87);
      END_STATE();
    case 25:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(86);
      END_STATE();
    case 26:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(84);
      END_STATE();
    case 27:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(79);
      END_STATE();
    case 28:
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(15);
      END_STATE();
    case 29:
      if (eof) ADVANCE(34);
      if (lookahead == '!') ADVANCE(11);
      if (lookahead == '"') ADVANCE(37);
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '&') ADVANCE(69);
      if (lookahead == '\'') ADVANCE(36);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(44);
      if (lookahead == '*') ADVANCE(35);
      if (lookahead == '+') ADVANCE(58);
      if (lookahead == ',') ADVANCE(40);
      if (lookahead == '-') ADVANCE(61);
      if (lookahead == '.') ADVANCE(48);
      if (lookahead == '/') ADVANCE(64);
      if (lookahead == ':') ADVANCE(10);
      if (lookahead == ';') ADVANCE(41);
      if (lookahead == '<') ADVANCE(51);
      if (lookahead == '=') ADVANCE(50);
      if (lookahead == '>') ADVANCE(54);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '^') ADVANCE(70);
      if (lookahead == '`') ADVANCE(28);
      if (lookahead == '|') ADVANCE(71);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 30:
      if (eof) ADVANCE(34);
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '$') ADVANCE(46);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(44);
      if (lookahead == '*') ADVANCE(35);
      if (lookahead == '+') ADVANCE(59);
      if (lookahead == ',') ADVANCE(40);
      if (lookahead == '-') ADVANCE(62);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(80);
      if (lookahead == ';') ADVANCE(41);
      if (lookahead == '<') ADVANCE(52);
      if (lookahead == '>') ADVANCE(53);
      if (lookahead == '?') ADVANCE(45);
      if (lookahead == '@') ADVANCE(12);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '`') ADVANCE(28);
      if (lookahead == '~') ADVANCE(57);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(32)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(81);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 31:
      if (eof) ADVANCE(34);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(31)
      if (lookahead == '!') ADVANCE(11);
      if (lookahead == '"') ADVANCE(37);
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '$') ADVANCE(46);
      if (lookahead == '&') ADVANCE(69);
      if (lookahead == '\'') ADVANCE(36);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(44);
      if (lookahead == '*') ADVANCE(35);
      if (lookahead == '+') ADVANCE(60);
      if (lookahead == ',') ADVANCE(40);
      if (lookahead == '-') ADVANCE(63);
      if (lookahead == '.') ADVANCE(48);
      if (lookahead == '/') ADVANCE(64);
      if (lookahead == ':') ADVANCE(10);
      if (lookahead == ';') ADVANCE(41);
      if (lookahead == '<') ADVANCE(51);
      if (lookahead == '=') ADVANCE(50);
      if (lookahead == '>') ADVANCE(54);
      if (lookahead == '?') ADVANCE(45);
      if (lookahead == '@') ADVANCE(12);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '^') ADVANCE(70);
      if (lookahead == '`') ADVANCE(28);
      if (lookahead == '|') ADVANCE(71);
      if (lookahead == '~') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 32:
      if (eof) ADVANCE(34);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(32)
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '$') ADVANCE(46);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(44);
      if (lookahead == '*') ADVANCE(35);
      if (lookahead == '+') ADVANCE(59);
      if (lookahead == ',') ADVANCE(40);
      if (lookahead == '-') ADVANCE(62);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(80);
      if (lookahead == ';') ADVANCE(41);
      if (lookahead == '<') ADVANCE(52);
      if (lookahead == '>') ADVANCE(53);
      if (lookahead == '?') ADVANCE(45);
      if (lookahead == '@') ADVANCE(12);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '`') ADVANCE(28);
      if (lookahead == '~') ADVANCE(57);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(81);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 33:
      if (eof) ADVANCE(34);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33)
      if (lookahead == '!') ADVANCE(11);
      if (lookahead == '"') ADVANCE(37);
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '&') ADVANCE(69);
      if (lookahead == '\'') ADVANCE(36);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(44);
      if (lookahead == '*') ADVANCE(35);
      if (lookahead == '+') ADVANCE(58);
      if (lookahead == ',') ADVANCE(40);
      if (lookahead == '-') ADVANCE(61);
      if (lookahead == '.') ADVANCE(48);
      if (lookahead == '/') ADVANCE(64);
      if (lookahead == ':') ADVANCE(10);
      if (lookahead == ';') ADVANCE(41);
      if (lookahead == '<') ADVANCE(51);
      if (lookahead == '=') ADVANCE(50);
      if (lookahead == '>') ADVANCE(54);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '^') ADVANCE(70);
      if (lookahead == '`') ADVANCE(28);
      if (lookahead == '|') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(39);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_comma);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_left_paren);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_right_paren);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(aux_sym_parameter_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(42);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(67);
      if (lookahead == '=') ADVANCE(55);
      if (lookahead == '>') ADVANCE(65);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(55);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(56);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(56);
      if (lookahead == '>') ADVANCE(68);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(81);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(39);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(39);
      if (lookahead == '.') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(81);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(6);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(72);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_system_variable);
      if (lookahead == '.') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_system_variable);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym__named_query_parameter);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(77);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym__positional_query_parameter);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_hex);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(79);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym__integer);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == 'x') ADVANCE(27);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(81);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym__integer);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(81);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym__integer);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(aux_sym__float_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(83);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(aux_sym__float_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(84);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(aux_sym__float_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(85);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(aux_sym__float_token2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(86);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(aux_sym__float_token3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(87);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym__unquoted_identifier);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym__quoted_identifier);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(4);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(5);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(6);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(7);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(8);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(9);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(10);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(11);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(12);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(13);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(14);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(15);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(16);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(17);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(18);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(19);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(20);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(21);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(22);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(23);
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(24);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      END_STATE();
    case 1:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(26);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(27);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(28);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(29);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(30);
      END_STATE();
    case 2:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(31);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(32);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(33);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(34);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(35);
      END_STATE();
    case 3:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(36);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(37);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(38);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(39);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 4:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(41);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(42);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(43);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(44);
      END_STATE();
    case 5:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(45);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(46);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(47);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(48);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(49);
      END_STATE();
    case 6:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(50);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(51);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(52);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(53);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(54);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(55);
      END_STATE();
    case 7:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(56);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(57);
      END_STATE();
    case 8:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 9:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(59);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(60);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(61);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(62);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(63);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(64);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(65);
      END_STATE();
    case 10:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(66);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(67);
      END_STATE();
    case 11:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(68);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(69);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(70);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(71);
      END_STATE();
    case 12:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(72);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(73);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(74);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 13:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(76);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(77);
      END_STATE();
    case 14:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(78);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(79);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(80);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(81);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(82);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(83);
      END_STATE();
    case 15:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(84);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(85);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(86);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(87);
      END_STATE();
    case 16:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(88);
      END_STATE();
    case 17:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(89);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(90);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(91);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(92);
      END_STATE();
    case 18:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(93);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(94);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(95);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(96);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(97);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(98);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(99);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(100);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(101);
      END_STATE();
    case 19:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(102);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(103);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(104);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(105);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(106);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(107);
      END_STATE();
    case 20:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(108);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(109);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(110);
      END_STATE();
    case 21:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(111);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(112);
      END_STATE();
    case 22:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(113);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(114);
      END_STATE();
    case 23:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(115);
      END_STATE();
    case 24:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(116);
      END_STATE();
    case 25:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(4);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(5);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(6);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(7);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(8);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(9);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(10);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(11);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(12);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(13);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(14);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(15);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(16);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(17);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(18);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(19);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(20);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(21);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(22);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(23);
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(24);
      END_STATE();
    case 26:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(117);
      END_STATE();
    case 27:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(118);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(119);
      END_STATE();
    case 28:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(120);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(aux_sym_keyword_as_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(121);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(122);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(123);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(aux_sym_keyword_at_token1);
      END_STATE();
    case 31:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(124);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(125);
      END_STATE();
    case 32:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(126);
      END_STATE();
    case 33:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(127);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(128);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(129);
      END_STATE();
    case 34:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(aux_sym_keyword_by_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(131);
      END_STATE();
    case 36:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(132);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(133);
      END_STATE();
    case 37:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(134);
      END_STATE();
    case 38:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(135);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(136);
      END_STATE();
    case 39:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(137);
      END_STATE();
    case 40:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(138);
      END_STATE();
    case 41:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(139);
      END_STATE();
    case 42:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(140);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(141);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(142);
      END_STATE();
    case 43:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(143);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(aux_sym_keyword_do_token1);
      END_STATE();
    case 45:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(144);
      END_STATE();
    case 46:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(145);
      END_STATE();
    case 47:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(146);
      END_STATE();
    case 48:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(147);
      END_STATE();
    case 49:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(148);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(149);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(150);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(151);
      END_STATE();
    case 50:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(152);
      END_STATE();
    case 51:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(153);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(154);
      END_STATE();
    case 52:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(155);
      END_STATE();
    case 53:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(156);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(157);
      END_STATE();
    case 54:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(158);
      END_STATE();
    case 55:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(159);
      END_STATE();
    case 56:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(160);
      END_STATE();
    case 57:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(161);
      END_STATE();
    case 58:
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(162);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(aux_sym_keyword_if_token1);
      END_STATE();
    case 60:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(163);
      END_STATE();
    case 61:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(164);
      END_STATE();
    case 62:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(165);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(aux_sym_keyword_in_token1);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(166);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(167);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(168);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(aux_sym_keyword_is_token1);
      END_STATE();
    case 65:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(169);
      END_STATE();
    case 66:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(170);
      END_STATE();
    case 67:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(171);
      END_STATE();
    case 68:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(172);
      END_STATE();
    case 69:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(173);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(174);
      END_STATE();
    case 70:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(175);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(176);
      END_STATE();
    case 71:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(177);
      END_STATE();
    case 72:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(178);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(179);
      END_STATE();
    case 73:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(180);
      END_STATE();
    case 74:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(181);
      END_STATE();
    case 75:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(182);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(aux_sym_keyword_no_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(183);
      END_STATE();
    case 77:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(184);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(185);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(aux_sym_keyword_of_token1);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(186);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(aux_sym_keyword_on_token1);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(aux_sym_keyword_or_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(187);
      END_STATE();
    case 81:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(188);
      END_STATE();
    case 82:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(189);
      END_STATE();
    case 83:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(190);
      END_STATE();
    case 84:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(191);
      END_STATE();
    case 85:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(192);
      END_STATE();
    case 86:
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(193);
      END_STATE();
    case 87:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(194);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(195);
      END_STATE();
    case 88:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(196);
      END_STATE();
    case 89:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(197);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(198);
      END_STATE();
    case 90:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(199);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(200);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(201);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(202);
      END_STATE();
    case 91:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(203);
      END_STATE();
    case 92:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(204);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(205);
      END_STATE();
    case 93:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(206);
      END_STATE();
    case 94:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(207);
      END_STATE();
    case 95:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(208);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(209);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(210);
      END_STATE();
    case 96:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(211);
      END_STATE();
    case 97:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(212);
      END_STATE();
    case 98:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(213);
      END_STATE();
    case 99:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(214);
      END_STATE();
    case 100:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(215);
      END_STATE();
    case 101:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(216);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(217);
      END_STATE();
    case 102:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(218);
      END_STATE();
    case 103:
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(219);
      END_STATE();
    case 104:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(220);
      END_STATE();
    case 105:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(221);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(222);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(223);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(aux_sym_keyword_to_token1);
      END_STATE();
    case 107:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(224);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(225);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(226);
      END_STATE();
    case 108:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(227);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(228);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(229);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(230);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(231);
      END_STATE();
    case 109:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(232);
      END_STATE();
    case 110:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(233);
      END_STATE();
    case 111:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(234);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(235);
      END_STATE();
    case 112:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(236);
      END_STATE();
    case 113:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(237);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(238);
      END_STATE();
    case 114:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(239);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(240);
      END_STATE();
    case 115:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(241);
      END_STATE();
    case 116:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(242);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym_keyword_all_token1);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(aux_sym_keyword_and_token1);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym_keyword_any_token1);
      END_STATE();
    case 120:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(243);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym_keyword_asc_token1);
      END_STATE();
    case 122:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(244);
      END_STATE();
    case 123:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(245);
      END_STATE();
    case 124:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(246);
      END_STATE();
    case 125:
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(247);
      END_STATE();
    case 126:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(248);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(249);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(250);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(251);
      END_STATE();
    case 127:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(252);
      END_STATE();
    case 128:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(253);
      END_STATE();
    case 129:
      if (lookahead == '2') ADVANCE(254);
      if (lookahead == '3') ADVANCE(255);
      END_STATE();
    case 130:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(256);
      END_STATE();
    case 131:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(257);
      END_STATE();
    case 132:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(258);
      END_STATE();
    case 133:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(259);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(260);
      END_STATE();
    case 134:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(261);
      END_STATE();
    case 135:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(262);
      END_STATE();
    case 136:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(263);
      END_STATE();
    case 137:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(264);
      END_STATE();
    case 138:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(265);
      END_STATE();
    case 139:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(266);
      END_STATE();
    case 140:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(267);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(268);
      END_STATE();
    case 141:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(269);
      END_STATE();
    case 142:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(270);
      END_STATE();
    case 143:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(271);
      END_STATE();
    case 144:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(272);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(aux_sym_keyword_end_token1);
      END_STATE();
    case 146:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(273);
      END_STATE();
    case 147:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(274);
      END_STATE();
    case 148:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(275);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(276);
      END_STATE();
    case 149:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(277);
      END_STATE();
    case 150:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(278);
      END_STATE();
    case 151:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(279);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(280);
      END_STATE();
    case 152:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(281);
      END_STATE();
    case 153:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(282);
      END_STATE();
    case 154:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(283);
      END_STATE();
    case 155:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(284);
      END_STATE();
    case 156:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(285);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym_keyword_for_token1);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(286);
      END_STATE();
    case 158:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(287);
      END_STATE();
    case 159:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(288);
      END_STATE();
    case 160:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(289);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(290);
      END_STATE();
    case 161:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(291);
      END_STATE();
    case 162:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(292);
      END_STATE();
    case 163:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(293);
      END_STATE();
    case 164:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(294);
      END_STATE();
    case 165:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(295);
      END_STATE();
    case 166:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(296);
      END_STATE();
    case 167:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(297);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(aux_sym_keyword_int_token2);
      if (lookahead == '6') ADVANCE(298);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(299);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(300);
      END_STATE();
    case 169:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(301);
      END_STATE();
    case 170:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(302);
      END_STATE();
    case 171:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(303);
      END_STATE();
    case 172:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(304);
      END_STATE();
    case 173:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(305);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(306);
      END_STATE();
    case 174:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(307);
      END_STATE();
    case 175:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(308);
      END_STATE();
    case 176:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(309);
      END_STATE();
    case 177:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(310);
      END_STATE();
    case 178:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(311);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(aux_sym_keyword_max_token1);
      END_STATE();
    case 180:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(312);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(aux_sym_keyword_min_token1);
      END_STATE();
    case 182:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(313);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(aux_sym_keyword_not_token1);
      END_STATE();
    case 184:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(314);
      END_STATE();
    case 185:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(315);
      END_STATE();
    case 186:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(316);
      END_STATE();
    case 187:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(317);
      END_STATE();
    case 188:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(318);
      END_STATE();
    case 189:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(319);
      END_STATE();
    case 190:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(320);
      END_STATE();
    case 191:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(321);
      END_STATE();
    case 192:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(322);
      END_STATE();
    case 193:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(323);
      END_STATE();
    case 194:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(324);
      END_STATE();
    case 195:
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(325);
      END_STATE();
    case 196:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(326);
      END_STATE();
    case 197:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(327);
      END_STATE();
    case 198:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(328);
      END_STATE();
    case 199:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(329);
      END_STATE();
    case 200:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(330);
      END_STATE();
    case 201:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(331);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(332);
      END_STATE();
    case 202:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(333);
      END_STATE();
    case 203:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(334);
      END_STATE();
    case 204:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(335);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(aux_sym_keyword_row_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(336);
      END_STATE();
    case 206:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(337);
      END_STATE();
    case 207:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(338);
      END_STATE();
    case 208:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(339);
      END_STATE();
    case 209:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(340);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(aux_sym_keyword_set_token1);
      END_STATE();
    case 211:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(341);
      END_STATE();
    case 212:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(342);
      END_STATE();
    case 213:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(343);
      END_STATE();
    case 214:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(344);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(345);
      END_STATE();
    case 215:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(346);
      END_STATE();
    case 216:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(347);
      END_STATE();
    case 217:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(348);
      END_STATE();
    case 218:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(349);
      END_STATE();
    case 219:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(350);
      END_STATE();
    case 220:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(351);
      END_STATE();
    case 221:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(352);
      END_STATE();
    case 222:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(353);
      END_STATE();
    case 223:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(354);
      END_STATE();
    case 224:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(355);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(356);
      END_STATE();
    case 225:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(357);
      END_STATE();
    case 226:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(358);
      END_STATE();
    case 227:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(359);
      END_STATE();
    case 228:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(360);
      END_STATE();
    case 229:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(361);
      END_STATE();
    case 230:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(362);
      END_STATE();
    case 231:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(363);
      END_STATE();
    case 232:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(364);
      END_STATE();
    case 233:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(365);
      END_STATE();
    case 234:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(366);
      END_STATE();
    case 235:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(367);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(368);
      END_STATE();
    case 236:
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(369);
      END_STATE();
    case 237:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(370);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(371);
      END_STATE();
    case 238:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(372);
      END_STATE();
    case 239:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(373);
      END_STATE();
    case 240:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(374);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(aux_sym_keyword_xml_token1);
      END_STATE();
    case 242:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(375);
      END_STATE();
    case 243:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(376);
      END_STATE();
    case 244:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(377);
      END_STATE();
    case 245:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(378);
      END_STATE();
    case 246:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(379);
      END_STATE();
    case 247:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(380);
      END_STATE();
    case 248:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(381);
      END_STATE();
    case 249:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(382);
      END_STATE();
    case 250:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(383);
      END_STATE();
    case 251:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(384);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(aux_sym_keyword_boolean_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(385);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(aux_sym_keyword_both_token1);
      END_STATE();
    case 254:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(386);
      END_STATE();
    case 255:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(387);
      END_STATE();
    case 256:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(388);
      END_STATE();
    case 257:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(389);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(390);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(391);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(aux_sym_keyword_call_token1);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(aux_sym_keyword_case_token1);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(aux_sym_keyword_cast_token1);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(aux_sym_keyword_char_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(392);
      END_STATE();
    case 262:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(393);
      END_STATE();
    case 263:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(394);
      END_STATE();
    case 264:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(395);
      END_STATE();
    case 265:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(396);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(aux_sym_keyword_date_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(397);
      END_STATE();
    case 267:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(398);
      END_STATE();
    case 268:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(399);
      END_STATE();
    case 269:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(400);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(aux_sym_keyword_desc_token1);
      END_STATE();
    case 271:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(401);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(aux_sym_keyword_else_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(402);
      END_STATE();
    case 273:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(403);
      END_STATE();
    case 274:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(404);
      END_STATE();
    case 275:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(405);
      END_STATE();
    case 276:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(406);
      END_STATE();
    case 277:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(407);
      END_STATE();
    case 278:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(408);
      END_STATE();
    case 279:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(409);
      END_STATE();
    case 280:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(410);
      END_STATE();
    case 281:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(411);
      END_STATE();
    case 282:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(412);
      END_STATE();
    case 283:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(413);
      END_STATE();
    case 284:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(414);
      END_STATE();
    case 285:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(415);
      END_STATE();
    case 286:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(416);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(aux_sym_keyword_from_token1);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(aux_sym_keyword_full_token1);
      END_STATE();
    case 289:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(417);
      END_STATE();
    case 290:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(418);
      END_STATE();
    case 291:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(419);
      END_STATE();
    case 292:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(420);
      END_STATE();
    case 293:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(421);
      END_STATE();
    case 294:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(422);
      END_STATE();
    case 295:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(423);
      END_STATE();
    case 296:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(424);
      END_STATE();
    case 297:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(425);
      END_STATE();
    case 298:
      if (lookahead == '4') ADVANCE(426);
      END_STATE();
    case 299:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(427);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(428);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(aux_sym_keyword_into_token1);
      END_STATE();
    case 301:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(429);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(aux_sym_keyword_join_token1);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(aux_sym_keyword_json_token1);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(430);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(aux_sym_keyword_last_token1);
      END_STATE();
    case 305:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(431);
      END_STATE();
    case 306:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(432);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(aux_sym_keyword_left_token1);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(aux_sym_keyword_like_token1);
      END_STATE();
    case 309:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(433);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(aux_sym_keyword_loop_token1);
      END_STATE();
    case 311:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(434);
      END_STATE();
    case 312:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(435);
      END_STATE();
    case 313:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(436);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(aux_sym_keyword_null_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(437);
      END_STATE();
    case 315:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(438);
      END_STATE();
    case 316:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(439);
      END_STATE();
    case 317:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(440);
      END_STATE();
    case 318:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(441);
      END_STATE();
    case 319:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(442);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(aux_sym_keyword_over_token1);
      END_STATE();
    case 321:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(443);
      END_STATE();
    case 322:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(444);
      END_STATE();
    case 323:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(445);
      END_STATE();
    case 324:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(446);
      END_STATE();
    case 325:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(447);
      END_STATE();
    case 326:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(448);
      END_STATE();
    case 327:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(449);
      END_STATE();
    case 328:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(450);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(aux_sym_keyword_real_token1);
      END_STATE();
    case 330:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(451);
      END_STATE();
    case 331:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(452);
      END_STATE();
    case 332:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(453);
      END_STATE();
    case 333:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(454);
      END_STATE();
    case 334:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(455);
      END_STATE();
    case 335:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(456);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(aux_sym_keyword_rows_token1);
      END_STATE();
    case 337:
      if (lookahead == '_') ADVANCE(457);
      END_STATE();
    case 338:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(458);
      END_STATE();
    case 339:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(459);
      END_STATE();
    case 340:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(460);
      END_STATE();
    case 341:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(461);
      END_STATE();
    case 342:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(462);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(aux_sym_keyword_some_token1);
      END_STATE();
    case 344:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(463);
      END_STATE();
    case 345:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(464);
      END_STATE();
    case 346:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(465);
      END_STATE();
    case 347:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(466);
      END_STATE();
    case 348:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(467);
      END_STATE();
    case 349:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(468);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(aux_sym_keyword_text_token1);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(aux_sym_keyword_then_token1);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(aux_sym_keyword_ties_token1);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(aux_sym_keyword_time_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(469);
      END_STATE();
    case 354:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(470);
      END_STATE();
    case 355:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(471);
      END_STATE();
    case 356:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(472);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(aux_sym_keyword_trim_token1);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(aux_sym_keyword_true_token1);
      END_STATE();
    case 359:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(473);
      END_STATE();
    case 360:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(474);
      END_STATE();
    case 361:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(475);
      END_STATE();
    case 362:
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(476);
      END_STATE();
    case 363:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(477);
      END_STATE();
    case 364:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(478);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(aux_sym_keyword_uuid_token1);
      END_STATE();
    case 366:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(479);
      END_STATE();
    case 367:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(480);
      END_STATE();
    case 368:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(481);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(aux_sym_keyword_view_token1);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(aux_sym_keyword_when_token1);
      END_STATE();
    case 371:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(482);
      END_STATE();
    case 372:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(483);
      END_STATE();
    case 373:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(484);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(aux_sym_keyword_with_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(485);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(486);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(aux_sym_keyword_zone_token1);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(aux_sym_keyword_array_token1);
      END_STATE();
    case 377:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(487);
      END_STATE();
    case 378:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(488);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(aux_sym_keyword_begin_token1);
      END_STATE();
    case 380:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(489);
      END_STATE();
    case 381:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(490);
      END_STATE();
    case 382:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(491);
      END_STATE();
    case 383:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(492);
      END_STATE();
    case 384:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(493);
      END_STATE();
    case 385:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(494);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(aux_sym_keyword_box2d_token1);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(aux_sym_keyword_box3d_token1);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(aux_sym_keyword_break_token1);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(aux_sym_keyword_bytea_token1);
      END_STATE();
    case 390:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(495);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(aux_sym_keyword_bytes_token1);
      END_STATE();
    case 392:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(496);
      END_STATE();
    case 393:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(497);
      END_STATE();
    case 394:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(498);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(aux_sym_keyword_cross_token1);
      END_STATE();
    case 396:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(499);
      END_STATE();
    case 397:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(500);
      END_STATE();
    case 398:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(501);
      END_STATE();
    case 399:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(502);
      END_STATE();
    case 400:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(503);
      END_STATE();
    case 401:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(504);
      END_STATE();
    case 402:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(505);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(aux_sym_keyword_error_token1);
      END_STATE();
    case 404:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(506);
      END_STATE();
    case 405:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(507);
      END_STATE();
    case 406:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(508);
      END_STATE();
    case 407:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(509);
      END_STATE();
    case 408:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(510);
      END_STATE();
    case 409:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(511);
      END_STATE();
    case 410:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(512);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(aux_sym_keyword_false_token1);
      END_STATE();
    case 412:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(513);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(aux_sym_keyword_first_token1);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(aux_sym_keyword_float_token1);
      if (lookahead == '4') ADVANCE(514);
      if (lookahead == '6') ADVANCE(515);
      END_STATE();
    case 415:
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(516);
      END_STATE();
    case 416:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(517);
      END_STATE();
    case 417:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(518);
      END_STATE();
    case 418:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(519);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(aux_sym_keyword_group_token1);
      END_STATE();
    case 420:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(520);
      END_STATE();
    case 421:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(521);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(aux_sym_keyword_like_token2);
      END_STATE();
    case 423:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(522);
      END_STATE();
    case 424:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(523);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(aux_sym_keyword_inner_token1);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(aux_sym_keyword_int_token1);
      END_STATE();
    case 427:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(524);
      END_STATE();
    case 428:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(525);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(526);
      END_STATE();
    case 429:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(527);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(aux_sym_keyword_jsonb_token1);
      END_STATE();
    case 431:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(528);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(aux_sym_keyword_leave_token1);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(aux_sym_keyword_limit_token1);
      END_STATE();
    case 434:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(529);
      END_STATE();
    case 435:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(530);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(aux_sym_keyword_money_token1);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(aux_sym_keyword_nulls_token1);
      END_STATE();
    case 438:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(531);
      END_STATE();
    case 439:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(532);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(aux_sym_keyword_order_token1);
      END_STATE();
    case 441:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(533);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(aux_sym_keyword_outer_token1);
      END_STATE();
    case 443:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(534);
      END_STATE();
    case 444:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(535);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(aux_sym_keyword_pivot_token1);
      END_STATE();
    case 446:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(536);
      END_STATE();
    case 447:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(537);
      END_STATE();
    case 448:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(538);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(aux_sym_keyword_raise_token1);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(aux_sym_keyword_range_token1);
      END_STATE();
    case 451:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(539);
      END_STATE();
    case 452:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(540);
      END_STATE();
    case 453:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(541);
      END_STATE();
    case 454:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(542);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(aux_sym_keyword_right_token1);
      END_STATE();
    case 456:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(543);
      END_STATE();
    case 457:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(544);
      END_STATE();
    case 458:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(545);
      END_STATE();
    case 459:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(546);
      END_STATE();
    case 460:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(547);
      END_STATE();
    case 461:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(548);
      END_STATE();
    case 462:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(549);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(550);
      END_STATE();
    case 463:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(551);
      END_STATE();
    case 464:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(552);
      END_STATE();
    case 465:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(553);
      END_STATE();
    case 466:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(554);
      END_STATE();
    case 467:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(555);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(aux_sym_keyword_table_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(556);
      END_STATE();
    case 469:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(557);
      END_STATE();
    case 470:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(558);
      END_STATE();
    case 471:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(559);
      END_STATE();
    case 472:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(560);
      END_STATE();
    case 473:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(561);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(aux_sym_keyword_union_token1);
      END_STATE();
    case 475:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(562);
      END_STATE();
    case 476:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(563);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(aux_sym_keyword_until_token1);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(aux_sym_keyword_using_token1);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(aux_sym_keyword_value_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(564);
      END_STATE();
    case 480:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(565);
      END_STATE();
    case 481:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(566);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(aux_sym_keyword_where_token1);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(aux_sym_keyword_while_token1);
      END_STATE();
    case 484:
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(567);
      END_STATE();
    case 485:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(568);
      END_STATE();
    case 486:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(569);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(aux_sym_keyword_assert_token1);
      END_STATE();
    case 488:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(570);
      END_STATE();
    case 489:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(571);
      END_STATE();
    case 490:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(572);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(aux_sym_keyword_int_token5);
      END_STATE();
    case 492:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(573);
      END_STATE();
    case 493:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(574);
      END_STATE();
    case 494:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(575);
      END_STATE();
    case 495:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(576);
      END_STATE();
    case 496:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(577);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(aux_sym_keyword_commit_token1);
      END_STATE();
    case 498:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(578);
      END_STATE();
    case 499:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(579);
      END_STATE();
    case 500:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(580);
      END_STATE();
    case 501:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(581);
      END_STATE();
    case 502:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(582);
      END_STATE();
    case 503:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(583);
      END_STATE();
    case 504:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(584);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(aux_sym_keyword_elseif_token1);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(aux_sym_keyword_escape_token1);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(aux_sym_keyword_except_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(585);
      END_STATE();
    case 508:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(586);
      END_STATE();
    case 509:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(587);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(aux_sym_keyword_exists_token1);
      END_STATE();
    case 511:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(588);
      END_STATE();
    case 512:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(589);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(aux_sym_keyword_filter_token1);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(aux_sym_keyword_real_token2);
      END_STATE();
    case 515:
      if (lookahead == '4') ADVANCE(590);
      END_STATE();
    case 516:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(591);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(aux_sym_keyword_format_token1);
      END_STATE();
    case 518:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(592);
      END_STATE();
    case 519:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(593);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(aux_sym_keyword_having_token1);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(aux_sym_keyword_ignore_token1);
      END_STATE();
    case 522:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(594);
      END_STATE();
    case 523:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(595);
      END_STATE();
    case 524:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(596);
      END_STATE();
    case 525:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(597);
      END_STATE();
    case 526:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(598);
      END_STATE();
    case 527:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(599);
      END_STATE();
    case 528:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(600);
      END_STATE();
    case 529:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(601);
      END_STATE();
    case 530:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(602);
      END_STATE();
    case 531:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(603);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(aux_sym_keyword_offset_token1);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(aux_sym_keyword_others_token1);
      END_STATE();
    case 534:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(604);
      END_STATE();
    case 535:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(605);
      END_STATE();
    case 536:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(606);
      END_STATE();
    case 537:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(607);
      END_STATE();
    case 538:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(608);
      END_STATE();
    case 539:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(609);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(aux_sym_keyword_repeat_token1);
      END_STATE();
    case 541:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(610);
      END_STATE();
    case 542:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(611);
      END_STATE();
    case 543:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(612);
      END_STATE();
    case 544:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(613);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(aux_sym_keyword_schema_token1);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(aux_sym_keyword_select_token1);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(aux_sym_keyword_serial_token1);
      if (lookahead == '2') ADVANCE(614);
      if (lookahead == '4') ADVANCE(615);
      if (lookahead == '8') ADVANCE(616);
      END_STATE();
    case 548:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(617);
      END_STATE();
    case 549:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(618);
      END_STATE();
    case 550:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(619);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(aux_sym_keyword_string_token1);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(aux_sym_keyword_struct_token1);
      END_STATE();
    case 553:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(620);
      END_STATE();
    case 554:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(621);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(aux_sym_keyword_system_token1);
      if (lookahead == '_') ADVANCE(622);
      END_STATE();
    case 556:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(623);
      END_STATE();
    case 557:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(624);
      END_STATE();
    case 558:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(625);
      END_STATE();
    case 559:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(626);
      END_STATE();
    case 560:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(627);
      END_STATE();
    case 561:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(628);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(aux_sym_keyword_unnest_token1);
      END_STATE();
    case 563:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(629);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(aux_sym_keyword_values_token1);
      END_STATE();
    case 565:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(630);
      END_STATE();
    case 566:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(631);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(aux_sym_keyword_window_token1);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(aux_sym_keyword_within_token1);
      END_STATE();
    case 569:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(632);
      END_STATE();
    case 570:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(633);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(aux_sym_keyword_between_token1);
      END_STATE();
    case 572:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(634);
      END_STATE();
    case 573:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(635);
      END_STATE();
    case 574:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(636);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(aux_sym_keyword_boolean_token2);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(aux_sym_keyword_int_token7);
      END_STATE();
    case 577:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(637);
      END_STATE();
    case 578:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(638);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(aux_sym_keyword_current_token1);
      if (lookahead == '_') ADVANCE(639);
      END_STATE();
    case 580:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(640);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(aux_sym_keyword_decimal_token1);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(aux_sym_keyword_declare_token1);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(aux_sym_keyword_default_token1);
      END_STATE();
    case 584:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(641);
      END_STATE();
    case 585:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(642);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(aux_sym_keyword_exclude_token1);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(aux_sym_keyword_execute_token1);
      END_STATE();
    case 588:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(643);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(aux_sym_keyword_extract_token1);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(aux_sym_keyword_float_token2);
      END_STATE();
    case 591:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(644);
      END_STATE();
    case 592:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(645);
      END_STATE();
    case 593:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(646);
      END_STATE();
    case 594:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(647);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(aux_sym_keyword_include_token1);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(aux_sym_keyword_int_token4);
      END_STATE();
    case 597:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(648);
      END_STATE();
    case 598:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(649);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(aux_sym_keyword_iterate_token1);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(aux_sym_keyword_leading_token1);
      END_STATE();
    case 601:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(650);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(aux_sym_keyword_message_token1);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(aux_sym_keyword_numeric_token1);
      END_STATE();
    case 604:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(651);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(aux_sym_keyword_percent_token1);
      END_STATE();
    case 606:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(652);
      END_STATE();
    case 607:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(653);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(aux_sym_keyword_qualify_token1);
      END_STATE();
    case 609:
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(654);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(aux_sym_keyword_replace_token1);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(aux_sym_keyword_respect_token1);
      END_STATE();
    case 612:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(655);
      END_STATE();
    case 613:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(656);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(aux_sym_keyword_smallserial_token2);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(aux_sym_keyword_serial_token2);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(aux_sym_keyword_bigserial_token2);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(aux_sym_keyword_similar_token1);
      END_STATE();
    case 618:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(657);
      END_STATE();
    case 619:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(658);
      END_STATE();
    case 620:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(659);
      END_STATE();
    case 621:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(660);
      END_STATE();
    case 622:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(661);
      END_STATE();
    case 623:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(662);
      END_STATE();
    case 624:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(663);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(aux_sym_keyword_int_token6);
      END_STATE();
    case 626:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(664);
      END_STATE();
    case 627:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(665);
      END_STATE();
    case 628:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(666);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(aux_sym_keyword_unpivot_token1);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(aux_sym_keyword_varchar_token1);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(aux_sym_keyword_varchar_token2);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(aux_sym_keyword_timestamp_token2);
      END_STATE();
    case 633:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(667);
      END_STATE();
    case 634:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(668);
      END_STATE();
    case 635:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(669);
      END_STATE();
    case 636:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(670);
      END_STATE();
    case 637:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(671);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(aux_sym_keyword_continue_token1);
      END_STATE();
    case 639:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(672);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(673);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(aux_sym_keyword_datetime_token1);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(aux_sym_keyword_distinct_token1);
      END_STATE();
    case 642:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(674);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(aux_sym_keyword_external_token1);
      END_STATE();
    case 644:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(675);
      END_STATE();
    case 645:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(676);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(aux_sym_keyword_geometry_token1);
      END_STATE();
    case 647:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(677);
      END_STATE();
    case 648:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(678);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(aux_sym_keyword_interval_token1);
      END_STATE();
    case 650:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(679);
      END_STATE();
    case 651:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(680);
      END_STATE();
    case 652:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(681);
      END_STATE();
    case 653:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(682);
      END_STATE();
    case 654:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(683);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(aux_sym_keyword_rollback_token1);
      END_STATE();
    case 656:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(684);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(aux_sym_keyword_int_token3);
      END_STATE();
    case 658:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(685);
      END_STATE();
    case 659:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(686);
      END_STATE();
    case 660:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(687);
      END_STATE();
    case 661:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(688);
      END_STATE();
    case 662:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(689);
      END_STATE();
    case 663:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(690);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(aux_sym_keyword_trailing_token1);
      END_STATE();
    case 665:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(691);
      END_STATE();
    case 666:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(692);
      END_STATE();
    case 667:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(693);
      END_STATE();
    case 668:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(694);
      END_STATE();
    case 669:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(695);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(aux_sym_keyword_bigserial_token1);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(aux_sym_keyword_char_token2);
      END_STATE();
    case 672:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(696);
      END_STATE();
    case 673:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(697);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(aux_sym_keyword_exception_token1);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(aux_sym_keyword_following_token1);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(aux_sym_keyword_geography_token1);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(aux_sym_keyword_immediate_token1);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(aux_sym_keyword_intersect_token1);
      END_STATE();
    case 679:
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(698);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(aux_sym_keyword_partition_token1);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(aux_sym_keyword_preceding_token1);
      END_STATE();
    case 682:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(699);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(aux_sym_keyword_recursive_token1);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(aux_sym_keyword_safe_cast_token1);
      END_STATE();
    case 685:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(700);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(aux_sym_keyword_substring_token1);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(aux_sym_keyword_symmetric_token1);
      END_STATE();
    case 688:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(701);
      END_STATE();
    case 689:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(702);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(aux_sym_keyword_timestamp_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(703);
      END_STATE();
    case 691:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(704);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(aux_sym_keyword_unbounded_token1);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(aux_sym_keyword_asymmetric_token1);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(aux_sym_keyword_bigdecimal_token1);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(aux_sym_keyword_bignumeric_token1);
      END_STATE();
    case 696:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(705);
      END_STATE();
    case 697:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(706);
      END_STATE();
    case 698:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(707);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(aux_sym_keyword_privileges_token1);
      END_STATE();
    case 700:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(708);
      END_STATE();
    case 701:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(709);
      END_STATE();
    case 702:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(710);
      END_STATE();
    case 703:
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(711);
      END_STATE();
    case 704:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(712);
      END_STATE();
    case 705:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(713);
      END_STATE();
    case 706:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(714);
      END_STATE();
    case 707:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(715);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(aux_sym_keyword_smallserial_token1);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(aux_sym_keyword_system_time_token1);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(aux_sym_keyword_tablesample_token1);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(aux_sym_keyword_timestamptz_token1);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(aux_sym_keyword_transaction_token1);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(aux_sym_keyword_current_date_token1);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(aux_sym_keyword_current_time_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(716);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(aux_sym_keyword_materialized_token1);
      END_STATE();
    case 716:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(717);
      END_STATE();
    case 717:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(718);
      END_STATE();
    case 718:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(719);
      END_STATE();
    case 719:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(720);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(aux_sym_keyword_current_timestamp_token1);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 30, .external_lex_state = 2},
  [3] = {.lex_state = 30, .external_lex_state = 2},
  [4] = {.lex_state = 30, .external_lex_state = 2},
  [5] = {.lex_state = 30, .external_lex_state = 2},
  [6] = {.lex_state = 30, .external_lex_state = 2},
  [7] = {.lex_state = 30, .external_lex_state = 2},
  [8] = {.lex_state = 30, .external_lex_state = 2},
  [9] = {.lex_state = 30, .external_lex_state = 2},
  [10] = {.lex_state = 30, .external_lex_state = 2},
  [11] = {.lex_state = 30, .external_lex_state = 2},
  [12] = {.lex_state = 30, .external_lex_state = 2},
  [13] = {.lex_state = 30, .external_lex_state = 2},
  [14] = {.lex_state = 30, .external_lex_state = 2},
  [15] = {.lex_state = 30, .external_lex_state = 2},
  [16] = {.lex_state = 30, .external_lex_state = 2},
  [17] = {.lex_state = 30, .external_lex_state = 2},
  [18] = {.lex_state = 30, .external_lex_state = 2},
  [19] = {.lex_state = 30, .external_lex_state = 2},
  [20] = {.lex_state = 30, .external_lex_state = 2},
  [21] = {.lex_state = 30, .external_lex_state = 2},
  [22] = {.lex_state = 30, .external_lex_state = 2},
  [23] = {.lex_state = 30, .external_lex_state = 2},
  [24] = {.lex_state = 30, .external_lex_state = 2},
  [25] = {.lex_state = 30, .external_lex_state = 2},
  [26] = {.lex_state = 30, .external_lex_state = 2},
  [27] = {.lex_state = 30, .external_lex_state = 2},
  [28] = {.lex_state = 30, .external_lex_state = 2},
  [29] = {.lex_state = 30, .external_lex_state = 2},
  [30] = {.lex_state = 30, .external_lex_state = 2},
  [31] = {.lex_state = 30, .external_lex_state = 2},
  [32] = {.lex_state = 30, .external_lex_state = 2},
  [33] = {.lex_state = 30, .external_lex_state = 2},
  [34] = {.lex_state = 30, .external_lex_state = 2},
  [35] = {.lex_state = 30, .external_lex_state = 2},
  [36] = {.lex_state = 30, .external_lex_state = 2},
  [37] = {.lex_state = 30, .external_lex_state = 2},
  [38] = {.lex_state = 30, .external_lex_state = 2},
  [39] = {.lex_state = 30, .external_lex_state = 2},
  [40] = {.lex_state = 30, .external_lex_state = 2},
  [41] = {.lex_state = 30, .external_lex_state = 2},
  [42] = {.lex_state = 30, .external_lex_state = 2},
  [43] = {.lex_state = 30, .external_lex_state = 2},
  [44] = {.lex_state = 30, .external_lex_state = 2},
  [45] = {.lex_state = 30, .external_lex_state = 2},
  [46] = {.lex_state = 30, .external_lex_state = 2},
  [47] = {.lex_state = 30, .external_lex_state = 2},
  [48] = {.lex_state = 30, .external_lex_state = 2},
  [49] = {.lex_state = 30, .external_lex_state = 2},
  [50] = {.lex_state = 30, .external_lex_state = 2},
  [51] = {.lex_state = 30, .external_lex_state = 2},
  [52] = {.lex_state = 30, .external_lex_state = 2},
  [53] = {.lex_state = 30, .external_lex_state = 2},
  [54] = {.lex_state = 30, .external_lex_state = 2},
  [55] = {.lex_state = 30, .external_lex_state = 2},
  [56] = {.lex_state = 30, .external_lex_state = 2},
  [57] = {.lex_state = 30, .external_lex_state = 2},
  [58] = {.lex_state = 30, .external_lex_state = 2},
  [59] = {.lex_state = 30, .external_lex_state = 2},
  [60] = {.lex_state = 30, .external_lex_state = 2},
  [61] = {.lex_state = 30, .external_lex_state = 2},
  [62] = {.lex_state = 30, .external_lex_state = 2},
  [63] = {.lex_state = 30, .external_lex_state = 2},
  [64] = {.lex_state = 30, .external_lex_state = 2},
  [65] = {.lex_state = 30, .external_lex_state = 2},
  [66] = {.lex_state = 30, .external_lex_state = 2},
  [67] = {.lex_state = 30, .external_lex_state = 2},
  [68] = {.lex_state = 30, .external_lex_state = 2},
  [69] = {.lex_state = 30, .external_lex_state = 2},
  [70] = {.lex_state = 30, .external_lex_state = 2},
  [71] = {.lex_state = 30, .external_lex_state = 2},
  [72] = {.lex_state = 30, .external_lex_state = 2},
  [73] = {.lex_state = 30, .external_lex_state = 2},
  [74] = {.lex_state = 30, .external_lex_state = 2},
  [75] = {.lex_state = 30, .external_lex_state = 2},
  [76] = {.lex_state = 30, .external_lex_state = 2},
  [77] = {.lex_state = 30, .external_lex_state = 2},
  [78] = {.lex_state = 30, .external_lex_state = 2},
  [79] = {.lex_state = 30, .external_lex_state = 2},
  [80] = {.lex_state = 30, .external_lex_state = 2},
  [81] = {.lex_state = 30, .external_lex_state = 2},
  [82] = {.lex_state = 30, .external_lex_state = 2},
  [83] = {.lex_state = 30, .external_lex_state = 2},
  [84] = {.lex_state = 30, .external_lex_state = 2},
  [85] = {.lex_state = 30, .external_lex_state = 2},
  [86] = {.lex_state = 30, .external_lex_state = 2},
  [87] = {.lex_state = 30, .external_lex_state = 2},
  [88] = {.lex_state = 30, .external_lex_state = 2},
  [89] = {.lex_state = 30, .external_lex_state = 2},
  [90] = {.lex_state = 30, .external_lex_state = 2},
  [91] = {.lex_state = 30, .external_lex_state = 2},
  [92] = {.lex_state = 30, .external_lex_state = 2},
  [93] = {.lex_state = 30, .external_lex_state = 2},
  [94] = {.lex_state = 30, .external_lex_state = 2},
  [95] = {.lex_state = 30, .external_lex_state = 2},
  [96] = {.lex_state = 30, .external_lex_state = 2},
  [97] = {.lex_state = 30, .external_lex_state = 2},
  [98] = {.lex_state = 30, .external_lex_state = 2},
  [99] = {.lex_state = 30, .external_lex_state = 2},
  [100] = {.lex_state = 30, .external_lex_state = 2},
  [101] = {.lex_state = 30, .external_lex_state = 2},
  [102] = {.lex_state = 30, .external_lex_state = 2},
  [103] = {.lex_state = 30, .external_lex_state = 2},
  [104] = {.lex_state = 30, .external_lex_state = 2},
  [105] = {.lex_state = 30, .external_lex_state = 2},
  [106] = {.lex_state = 30, .external_lex_state = 2},
  [107] = {.lex_state = 30, .external_lex_state = 2},
  [108] = {.lex_state = 30, .external_lex_state = 2},
  [109] = {.lex_state = 30, .external_lex_state = 2},
  [110] = {.lex_state = 30, .external_lex_state = 2},
  [111] = {.lex_state = 30, .external_lex_state = 2},
  [112] = {.lex_state = 30, .external_lex_state = 2},
  [113] = {.lex_state = 30, .external_lex_state = 2},
  [114] = {.lex_state = 30, .external_lex_state = 2},
  [115] = {.lex_state = 30, .external_lex_state = 2},
  [116] = {.lex_state = 30, .external_lex_state = 2},
  [117] = {.lex_state = 30, .external_lex_state = 2},
  [118] = {.lex_state = 30, .external_lex_state = 2},
  [119] = {.lex_state = 30, .external_lex_state = 2},
  [120] = {.lex_state = 30, .external_lex_state = 2},
  [121] = {.lex_state = 30, .external_lex_state = 2},
  [122] = {.lex_state = 30, .external_lex_state = 2},
  [123] = {.lex_state = 30, .external_lex_state = 2},
  [124] = {.lex_state = 30, .external_lex_state = 2},
  [125] = {.lex_state = 30, .external_lex_state = 2},
  [126] = {.lex_state = 30, .external_lex_state = 2},
  [127] = {.lex_state = 30, .external_lex_state = 2},
  [128] = {.lex_state = 30, .external_lex_state = 2},
  [129] = {.lex_state = 30, .external_lex_state = 2},
  [130] = {.lex_state = 30, .external_lex_state = 2},
  [131] = {.lex_state = 30, .external_lex_state = 2},
  [132] = {.lex_state = 30, .external_lex_state = 2},
  [133] = {.lex_state = 30, .external_lex_state = 2},
  [134] = {.lex_state = 30, .external_lex_state = 2},
  [135] = {.lex_state = 30, .external_lex_state = 2},
  [136] = {.lex_state = 30, .external_lex_state = 2},
  [137] = {.lex_state = 30, .external_lex_state = 2},
  [138] = {.lex_state = 30, .external_lex_state = 2},
  [139] = {.lex_state = 30, .external_lex_state = 2},
  [140] = {.lex_state = 30, .external_lex_state = 2},
  [141] = {.lex_state = 30, .external_lex_state = 2},
  [142] = {.lex_state = 30, .external_lex_state = 2},
  [143] = {.lex_state = 30, .external_lex_state = 2},
  [144] = {.lex_state = 30, .external_lex_state = 2},
  [145] = {.lex_state = 30, .external_lex_state = 2},
  [146] = {.lex_state = 30, .external_lex_state = 2},
  [147] = {.lex_state = 30, .external_lex_state = 2},
  [148] = {.lex_state = 30, .external_lex_state = 2},
  [149] = {.lex_state = 30, .external_lex_state = 2},
  [150] = {.lex_state = 30, .external_lex_state = 2},
  [151] = {.lex_state = 30, .external_lex_state = 2},
  [152] = {.lex_state = 30, .external_lex_state = 2},
  [153] = {.lex_state = 30, .external_lex_state = 2},
  [154] = {.lex_state = 30, .external_lex_state = 2},
  [155] = {.lex_state = 30, .external_lex_state = 2},
  [156] = {.lex_state = 30, .external_lex_state = 2},
  [157] = {.lex_state = 30, .external_lex_state = 2},
  [158] = {.lex_state = 30, .external_lex_state = 2},
  [159] = {.lex_state = 30, .external_lex_state = 2},
  [160] = {.lex_state = 30, .external_lex_state = 2},
  [161] = {.lex_state = 30, .external_lex_state = 2},
  [162] = {.lex_state = 30, .external_lex_state = 2},
  [163] = {.lex_state = 30, .external_lex_state = 2},
  [164] = {.lex_state = 30, .external_lex_state = 2},
  [165] = {.lex_state = 30, .external_lex_state = 2},
  [166] = {.lex_state = 30, .external_lex_state = 2},
  [167] = {.lex_state = 30, .external_lex_state = 2},
  [168] = {.lex_state = 30, .external_lex_state = 2},
  [169] = {.lex_state = 30, .external_lex_state = 2},
  [170] = {.lex_state = 30, .external_lex_state = 2},
  [171] = {.lex_state = 30, .external_lex_state = 2},
  [172] = {.lex_state = 30, .external_lex_state = 2},
  [173] = {.lex_state = 30, .external_lex_state = 2},
  [174] = {.lex_state = 30, .external_lex_state = 2},
  [175] = {.lex_state = 30, .external_lex_state = 2},
  [176] = {.lex_state = 30, .external_lex_state = 2},
  [177] = {.lex_state = 30, .external_lex_state = 2},
  [178] = {.lex_state = 30, .external_lex_state = 2},
  [179] = {.lex_state = 30, .external_lex_state = 2},
  [180] = {.lex_state = 30, .external_lex_state = 2},
  [181] = {.lex_state = 30, .external_lex_state = 2},
  [182] = {.lex_state = 30, .external_lex_state = 2},
  [183] = {.lex_state = 30, .external_lex_state = 2},
  [184] = {.lex_state = 30, .external_lex_state = 2},
  [185] = {.lex_state = 30, .external_lex_state = 2},
  [186] = {.lex_state = 30, .external_lex_state = 2},
  [187] = {.lex_state = 30, .external_lex_state = 2},
  [188] = {.lex_state = 30, .external_lex_state = 2},
  [189] = {.lex_state = 30, .external_lex_state = 2},
  [190] = {.lex_state = 30, .external_lex_state = 2},
  [191] = {.lex_state = 30, .external_lex_state = 2},
  [192] = {.lex_state = 30, .external_lex_state = 2},
  [193] = {.lex_state = 30, .external_lex_state = 2},
  [194] = {.lex_state = 30, .external_lex_state = 2},
  [195] = {.lex_state = 30, .external_lex_state = 2},
  [196] = {.lex_state = 30, .external_lex_state = 2},
  [197] = {.lex_state = 30, .external_lex_state = 2},
  [198] = {.lex_state = 30, .external_lex_state = 2},
  [199] = {.lex_state = 30, .external_lex_state = 2},
  [200] = {.lex_state = 30, .external_lex_state = 2},
  [201] = {.lex_state = 30, .external_lex_state = 2},
  [202] = {.lex_state = 30, .external_lex_state = 2},
  [203] = {.lex_state = 30, .external_lex_state = 2},
  [204] = {.lex_state = 30, .external_lex_state = 2},
  [205] = {.lex_state = 30, .external_lex_state = 2},
  [206] = {.lex_state = 30, .external_lex_state = 2},
  [207] = {.lex_state = 30, .external_lex_state = 2},
  [208] = {.lex_state = 30, .external_lex_state = 2},
  [209] = {.lex_state = 30, .external_lex_state = 2},
  [210] = {.lex_state = 30, .external_lex_state = 2},
  [211] = {.lex_state = 30, .external_lex_state = 2},
  [212] = {.lex_state = 30, .external_lex_state = 2},
  [213] = {.lex_state = 30, .external_lex_state = 2},
  [214] = {.lex_state = 30, .external_lex_state = 2},
  [215] = {.lex_state = 30, .external_lex_state = 2},
  [216] = {.lex_state = 30, .external_lex_state = 2},
  [217] = {.lex_state = 30, .external_lex_state = 2},
  [218] = {.lex_state = 30, .external_lex_state = 2},
  [219] = {.lex_state = 30, .external_lex_state = 2},
  [220] = {.lex_state = 30, .external_lex_state = 2},
  [221] = {.lex_state = 30, .external_lex_state = 2},
  [222] = {.lex_state = 30, .external_lex_state = 2},
  [223] = {.lex_state = 30, .external_lex_state = 2},
  [224] = {.lex_state = 30, .external_lex_state = 2},
  [225] = {.lex_state = 30, .external_lex_state = 2},
  [226] = {.lex_state = 30, .external_lex_state = 2},
  [227] = {.lex_state = 30, .external_lex_state = 2},
  [228] = {.lex_state = 30, .external_lex_state = 2},
  [229] = {.lex_state = 30, .external_lex_state = 2},
  [230] = {.lex_state = 30, .external_lex_state = 2},
  [231] = {.lex_state = 30, .external_lex_state = 2},
  [232] = {.lex_state = 30, .external_lex_state = 2},
  [233] = {.lex_state = 30, .external_lex_state = 2},
  [234] = {.lex_state = 30, .external_lex_state = 2},
  [235] = {.lex_state = 30, .external_lex_state = 2},
  [236] = {.lex_state = 30, .external_lex_state = 2},
  [237] = {.lex_state = 30, .external_lex_state = 2},
  [238] = {.lex_state = 30, .external_lex_state = 2},
  [239] = {.lex_state = 30, .external_lex_state = 2},
  [240] = {.lex_state = 30, .external_lex_state = 2},
  [241] = {.lex_state = 30, .external_lex_state = 2},
  [242] = {.lex_state = 30, .external_lex_state = 2},
  [243] = {.lex_state = 30, .external_lex_state = 2},
  [244] = {.lex_state = 30, .external_lex_state = 2},
  [245] = {.lex_state = 30, .external_lex_state = 2},
  [246] = {.lex_state = 30, .external_lex_state = 2},
  [247] = {.lex_state = 30, .external_lex_state = 2},
  [248] = {.lex_state = 30, .external_lex_state = 2},
  [249] = {.lex_state = 30, .external_lex_state = 2},
  [250] = {.lex_state = 30, .external_lex_state = 2},
  [251] = {.lex_state = 30, .external_lex_state = 2},
  [252] = {.lex_state = 30, .external_lex_state = 2},
  [253] = {.lex_state = 30, .external_lex_state = 2},
  [254] = {.lex_state = 30, .external_lex_state = 2},
  [255] = {.lex_state = 30, .external_lex_state = 2},
  [256] = {.lex_state = 30, .external_lex_state = 2},
  [257] = {.lex_state = 30, .external_lex_state = 2},
  [258] = {.lex_state = 30, .external_lex_state = 2},
  [259] = {.lex_state = 30, .external_lex_state = 2},
  [260] = {.lex_state = 30, .external_lex_state = 2},
  [261] = {.lex_state = 30, .external_lex_state = 2},
  [262] = {.lex_state = 30, .external_lex_state = 2},
  [263] = {.lex_state = 30, .external_lex_state = 2},
  [264] = {.lex_state = 30, .external_lex_state = 2},
  [265] = {.lex_state = 30, .external_lex_state = 2},
  [266] = {.lex_state = 30, .external_lex_state = 2},
  [267] = {.lex_state = 30, .external_lex_state = 2},
  [268] = {.lex_state = 30, .external_lex_state = 2},
  [269] = {.lex_state = 30, .external_lex_state = 2},
  [270] = {.lex_state = 30, .external_lex_state = 2},
  [271] = {.lex_state = 30, .external_lex_state = 2},
  [272] = {.lex_state = 30, .external_lex_state = 2},
  [273] = {.lex_state = 30, .external_lex_state = 2},
  [274] = {.lex_state = 30, .external_lex_state = 2},
  [275] = {.lex_state = 30, .external_lex_state = 2},
  [276] = {.lex_state = 30, .external_lex_state = 2},
  [277] = {.lex_state = 30, .external_lex_state = 2},
  [278] = {.lex_state = 30, .external_lex_state = 2},
  [279] = {.lex_state = 30, .external_lex_state = 2},
  [280] = {.lex_state = 30, .external_lex_state = 2},
  [281] = {.lex_state = 30, .external_lex_state = 2},
  [282] = {.lex_state = 30, .external_lex_state = 2},
  [283] = {.lex_state = 30, .external_lex_state = 2},
  [284] = {.lex_state = 30, .external_lex_state = 2},
  [285] = {.lex_state = 30, .external_lex_state = 2},
  [286] = {.lex_state = 30, .external_lex_state = 2},
  [287] = {.lex_state = 30, .external_lex_state = 2},
  [288] = {.lex_state = 30, .external_lex_state = 2},
  [289] = {.lex_state = 30, .external_lex_state = 2},
  [290] = {.lex_state = 30, .external_lex_state = 2},
  [291] = {.lex_state = 30, .external_lex_state = 2},
  [292] = {.lex_state = 30, .external_lex_state = 2},
  [293] = {.lex_state = 30, .external_lex_state = 2},
  [294] = {.lex_state = 30, .external_lex_state = 2},
  [295] = {.lex_state = 30, .external_lex_state = 2},
  [296] = {.lex_state = 30, .external_lex_state = 2},
  [297] = {.lex_state = 30, .external_lex_state = 2},
  [298] = {.lex_state = 30, .external_lex_state = 2},
  [299] = {.lex_state = 30, .external_lex_state = 2},
  [300] = {.lex_state = 30, .external_lex_state = 2},
  [301] = {.lex_state = 30, .external_lex_state = 2},
  [302] = {.lex_state = 30, .external_lex_state = 2},
  [303] = {.lex_state = 30, .external_lex_state = 2},
  [304] = {.lex_state = 30, .external_lex_state = 2},
  [305] = {.lex_state = 30, .external_lex_state = 2},
  [306] = {.lex_state = 30, .external_lex_state = 2},
  [307] = {.lex_state = 30, .external_lex_state = 2},
  [308] = {.lex_state = 30, .external_lex_state = 2},
  [309] = {.lex_state = 30, .external_lex_state = 2},
  [310] = {.lex_state = 30, .external_lex_state = 2},
  [311] = {.lex_state = 30, .external_lex_state = 2},
  [312] = {.lex_state = 30, .external_lex_state = 2},
  [313] = {.lex_state = 30, .external_lex_state = 2},
  [314] = {.lex_state = 30, .external_lex_state = 2},
  [315] = {.lex_state = 30, .external_lex_state = 2},
  [316] = {.lex_state = 30, .external_lex_state = 2},
  [317] = {.lex_state = 30, .external_lex_state = 2},
  [318] = {.lex_state = 30, .external_lex_state = 2},
  [319] = {.lex_state = 30, .external_lex_state = 2},
  [320] = {.lex_state = 30, .external_lex_state = 2},
  [321] = {.lex_state = 30, .external_lex_state = 2},
  [322] = {.lex_state = 30, .external_lex_state = 2},
  [323] = {.lex_state = 30, .external_lex_state = 2},
  [324] = {.lex_state = 30, .external_lex_state = 2},
  [325] = {.lex_state = 30, .external_lex_state = 2},
  [326] = {.lex_state = 30, .external_lex_state = 2},
  [327] = {.lex_state = 30, .external_lex_state = 2},
  [328] = {.lex_state = 30, .external_lex_state = 2},
  [329] = {.lex_state = 30, .external_lex_state = 2},
  [330] = {.lex_state = 30, .external_lex_state = 2},
  [331] = {.lex_state = 30, .external_lex_state = 2},
  [332] = {.lex_state = 30, .external_lex_state = 2},
  [333] = {.lex_state = 30, .external_lex_state = 2},
  [334] = {.lex_state = 30, .external_lex_state = 2},
  [335] = {.lex_state = 30, .external_lex_state = 2},
  [336] = {.lex_state = 30, .external_lex_state = 2},
  [337] = {.lex_state = 30, .external_lex_state = 2},
  [338] = {.lex_state = 30, .external_lex_state = 2},
  [339] = {.lex_state = 30, .external_lex_state = 2},
  [340] = {.lex_state = 30, .external_lex_state = 2},
  [341] = {.lex_state = 30, .external_lex_state = 2},
  [342] = {.lex_state = 30, .external_lex_state = 2},
  [343] = {.lex_state = 30, .external_lex_state = 2},
  [344] = {.lex_state = 30, .external_lex_state = 2},
  [345] = {.lex_state = 30, .external_lex_state = 2},
  [346] = {.lex_state = 30, .external_lex_state = 2},
  [347] = {.lex_state = 30, .external_lex_state = 2},
  [348] = {.lex_state = 30, .external_lex_state = 2},
  [349] = {.lex_state = 30, .external_lex_state = 2},
  [350] = {.lex_state = 30, .external_lex_state = 2},
  [351] = {.lex_state = 30, .external_lex_state = 2},
  [352] = {.lex_state = 30, .external_lex_state = 2},
  [353] = {.lex_state = 30, .external_lex_state = 2},
  [354] = {.lex_state = 30, .external_lex_state = 2},
  [355] = {.lex_state = 30, .external_lex_state = 2},
  [356] = {.lex_state = 30, .external_lex_state = 2},
  [357] = {.lex_state = 30, .external_lex_state = 2},
  [358] = {.lex_state = 30, .external_lex_state = 2},
  [359] = {.lex_state = 30, .external_lex_state = 2},
  [360] = {.lex_state = 30, .external_lex_state = 2},
  [361] = {.lex_state = 30, .external_lex_state = 2},
  [362] = {.lex_state = 30, .external_lex_state = 2},
  [363] = {.lex_state = 30, .external_lex_state = 2},
  [364] = {.lex_state = 30, .external_lex_state = 2},
  [365] = {.lex_state = 30, .external_lex_state = 2},
  [366] = {.lex_state = 30, .external_lex_state = 2},
  [367] = {.lex_state = 30, .external_lex_state = 2},
  [368] = {.lex_state = 30, .external_lex_state = 2},
  [369] = {.lex_state = 30, .external_lex_state = 2},
  [370] = {.lex_state = 30, .external_lex_state = 2},
  [371] = {.lex_state = 30, .external_lex_state = 2},
  [372] = {.lex_state = 30, .external_lex_state = 2},
  [373] = {.lex_state = 30, .external_lex_state = 2},
  [374] = {.lex_state = 30, .external_lex_state = 2},
  [375] = {.lex_state = 30, .external_lex_state = 2},
  [376] = {.lex_state = 30, .external_lex_state = 2},
  [377] = {.lex_state = 30, .external_lex_state = 2},
  [378] = {.lex_state = 30, .external_lex_state = 2},
  [379] = {.lex_state = 30, .external_lex_state = 2},
  [380] = {.lex_state = 30, .external_lex_state = 2},
  [381] = {.lex_state = 30, .external_lex_state = 2},
  [382] = {.lex_state = 30, .external_lex_state = 2},
  [383] = {.lex_state = 30, .external_lex_state = 2},
  [384] = {.lex_state = 30, .external_lex_state = 2},
  [385] = {.lex_state = 30, .external_lex_state = 2},
  [386] = {.lex_state = 30, .external_lex_state = 2},
  [387] = {.lex_state = 30, .external_lex_state = 2},
  [388] = {.lex_state = 30, .external_lex_state = 2},
  [389] = {.lex_state = 30, .external_lex_state = 2},
  [390] = {.lex_state = 30, .external_lex_state = 2},
  [391] = {.lex_state = 30, .external_lex_state = 2},
  [392] = {.lex_state = 30, .external_lex_state = 2},
  [393] = {.lex_state = 30, .external_lex_state = 2},
  [394] = {.lex_state = 30, .external_lex_state = 2},
  [395] = {.lex_state = 30, .external_lex_state = 2},
  [396] = {.lex_state = 30, .external_lex_state = 2},
  [397] = {.lex_state = 30, .external_lex_state = 2},
  [398] = {.lex_state = 30, .external_lex_state = 2},
  [399] = {.lex_state = 30, .external_lex_state = 2},
  [400] = {.lex_state = 30, .external_lex_state = 2},
  [401] = {.lex_state = 30, .external_lex_state = 2},
  [402] = {.lex_state = 30, .external_lex_state = 2},
  [403] = {.lex_state = 30, .external_lex_state = 2},
  [404] = {.lex_state = 30, .external_lex_state = 2},
  [405] = {.lex_state = 30, .external_lex_state = 2},
  [406] = {.lex_state = 30, .external_lex_state = 2},
  [407] = {.lex_state = 30, .external_lex_state = 2},
  [408] = {.lex_state = 30, .external_lex_state = 2},
  [409] = {.lex_state = 30, .external_lex_state = 2},
  [410] = {.lex_state = 30, .external_lex_state = 2},
  [411] = {.lex_state = 30, .external_lex_state = 2},
  [412] = {.lex_state = 30, .external_lex_state = 2},
  [413] = {.lex_state = 30, .external_lex_state = 2},
  [414] = {.lex_state = 30, .external_lex_state = 2},
  [415] = {.lex_state = 30, .external_lex_state = 2},
  [416] = {.lex_state = 30, .external_lex_state = 2},
  [417] = {.lex_state = 30, .external_lex_state = 2},
  [418] = {.lex_state = 30, .external_lex_state = 2},
  [419] = {.lex_state = 30, .external_lex_state = 2},
  [420] = {.lex_state = 30, .external_lex_state = 2},
  [421] = {.lex_state = 30, .external_lex_state = 2},
  [422] = {.lex_state = 30, .external_lex_state = 2},
  [423] = {.lex_state = 30, .external_lex_state = 2},
  [424] = {.lex_state = 30, .external_lex_state = 2},
  [425] = {.lex_state = 30, .external_lex_state = 2},
  [426] = {.lex_state = 30, .external_lex_state = 2},
  [427] = {.lex_state = 30, .external_lex_state = 2},
  [428] = {.lex_state = 30, .external_lex_state = 2},
  [429] = {.lex_state = 30, .external_lex_state = 2},
  [430] = {.lex_state = 30, .external_lex_state = 2},
  [431] = {.lex_state = 30, .external_lex_state = 2},
  [432] = {.lex_state = 30, .external_lex_state = 2},
  [433] = {.lex_state = 30, .external_lex_state = 2},
  [434] = {.lex_state = 30, .external_lex_state = 2},
  [435] = {.lex_state = 30, .external_lex_state = 2},
  [436] = {.lex_state = 30, .external_lex_state = 2},
  [437] = {.lex_state = 30, .external_lex_state = 2},
  [438] = {.lex_state = 30, .external_lex_state = 2},
  [439] = {.lex_state = 30, .external_lex_state = 2},
  [440] = {.lex_state = 30, .external_lex_state = 2},
  [441] = {.lex_state = 30, .external_lex_state = 2},
  [442] = {.lex_state = 30, .external_lex_state = 2},
  [443] = {.lex_state = 30, .external_lex_state = 2},
  [444] = {.lex_state = 30, .external_lex_state = 2},
  [445] = {.lex_state = 30, .external_lex_state = 2},
  [446] = {.lex_state = 30, .external_lex_state = 2},
  [447] = {.lex_state = 30, .external_lex_state = 2},
  [448] = {.lex_state = 30, .external_lex_state = 2},
  [449] = {.lex_state = 30, .external_lex_state = 2},
  [450] = {.lex_state = 30, .external_lex_state = 2},
  [451] = {.lex_state = 30, .external_lex_state = 2},
  [452] = {.lex_state = 30, .external_lex_state = 2},
  [453] = {.lex_state = 30, .external_lex_state = 2},
  [454] = {.lex_state = 30, .external_lex_state = 2},
  [455] = {.lex_state = 30, .external_lex_state = 2},
  [456] = {.lex_state = 30, .external_lex_state = 2},
  [457] = {.lex_state = 30, .external_lex_state = 2},
  [458] = {.lex_state = 30, .external_lex_state = 2},
  [459] = {.lex_state = 30, .external_lex_state = 2},
  [460] = {.lex_state = 30, .external_lex_state = 2},
  [461] = {.lex_state = 30, .external_lex_state = 2},
  [462] = {.lex_state = 30, .external_lex_state = 2},
  [463] = {.lex_state = 30, .external_lex_state = 2},
  [464] = {.lex_state = 30, .external_lex_state = 2},
  [465] = {.lex_state = 30, .external_lex_state = 2},
  [466] = {.lex_state = 30, .external_lex_state = 2},
  [467] = {.lex_state = 30, .external_lex_state = 2},
  [468] = {.lex_state = 30, .external_lex_state = 2},
  [469] = {.lex_state = 30, .external_lex_state = 2},
  [470] = {.lex_state = 30, .external_lex_state = 2},
  [471] = {.lex_state = 30, .external_lex_state = 2},
  [472] = {.lex_state = 30, .external_lex_state = 2},
  [473] = {.lex_state = 30, .external_lex_state = 2},
  [474] = {.lex_state = 30, .external_lex_state = 2},
  [475] = {.lex_state = 30, .external_lex_state = 2},
  [476] = {.lex_state = 30, .external_lex_state = 2},
  [477] = {.lex_state = 30, .external_lex_state = 2},
  [478] = {.lex_state = 30, .external_lex_state = 2},
  [479] = {.lex_state = 30, .external_lex_state = 2},
  [480] = {.lex_state = 30, .external_lex_state = 2},
  [481] = {.lex_state = 30, .external_lex_state = 2},
  [482] = {.lex_state = 30, .external_lex_state = 2},
  [483] = {.lex_state = 30, .external_lex_state = 2},
  [484] = {.lex_state = 30, .external_lex_state = 2},
  [485] = {.lex_state = 30, .external_lex_state = 2},
  [486] = {.lex_state = 30, .external_lex_state = 2},
  [487] = {.lex_state = 30, .external_lex_state = 2},
  [488] = {.lex_state = 30, .external_lex_state = 2},
  [489] = {.lex_state = 30, .external_lex_state = 2},
  [490] = {.lex_state = 30, .external_lex_state = 2},
  [491] = {.lex_state = 30, .external_lex_state = 2},
  [492] = {.lex_state = 30, .external_lex_state = 2},
  [493] = {.lex_state = 30, .external_lex_state = 2},
  [494] = {.lex_state = 30, .external_lex_state = 2},
  [495] = {.lex_state = 30, .external_lex_state = 2},
  [496] = {.lex_state = 30, .external_lex_state = 2},
  [497] = {.lex_state = 30, .external_lex_state = 2},
  [498] = {.lex_state = 30, .external_lex_state = 2},
  [499] = {.lex_state = 30, .external_lex_state = 2},
  [500] = {.lex_state = 30, .external_lex_state = 2},
  [501] = {.lex_state = 30, .external_lex_state = 2},
  [502] = {.lex_state = 30, .external_lex_state = 2},
  [503] = {.lex_state = 30, .external_lex_state = 2},
  [504] = {.lex_state = 30, .external_lex_state = 2},
  [505] = {.lex_state = 30, .external_lex_state = 2},
  [506] = {.lex_state = 30, .external_lex_state = 2},
  [507] = {.lex_state = 30, .external_lex_state = 2},
  [508] = {.lex_state = 30, .external_lex_state = 2},
  [509] = {.lex_state = 30, .external_lex_state = 2},
  [510] = {.lex_state = 30, .external_lex_state = 2},
  [511] = {.lex_state = 30, .external_lex_state = 2},
  [512] = {.lex_state = 30, .external_lex_state = 2},
  [513] = {.lex_state = 30, .external_lex_state = 2},
  [514] = {.lex_state = 30, .external_lex_state = 2},
  [515] = {.lex_state = 30, .external_lex_state = 2},
  [516] = {.lex_state = 30, .external_lex_state = 2},
  [517] = {.lex_state = 30, .external_lex_state = 2},
  [518] = {.lex_state = 30, .external_lex_state = 2},
  [519] = {.lex_state = 30, .external_lex_state = 2},
  [520] = {.lex_state = 30, .external_lex_state = 2},
  [521] = {.lex_state = 30, .external_lex_state = 2},
  [522] = {.lex_state = 30, .external_lex_state = 2},
  [523] = {.lex_state = 30, .external_lex_state = 2},
  [524] = {.lex_state = 30, .external_lex_state = 2},
  [525] = {.lex_state = 30, .external_lex_state = 2},
  [526] = {.lex_state = 30, .external_lex_state = 2},
  [527] = {.lex_state = 30, .external_lex_state = 2},
  [528] = {.lex_state = 30, .external_lex_state = 2},
  [529] = {.lex_state = 30, .external_lex_state = 2},
  [530] = {.lex_state = 30, .external_lex_state = 2},
  [531] = {.lex_state = 30, .external_lex_state = 2},
  [532] = {.lex_state = 30, .external_lex_state = 2},
  [533] = {.lex_state = 30, .external_lex_state = 2},
  [534] = {.lex_state = 30, .external_lex_state = 2},
  [535] = {.lex_state = 30, .external_lex_state = 2},
  [536] = {.lex_state = 30, .external_lex_state = 2},
  [537] = {.lex_state = 30, .external_lex_state = 2},
  [538] = {.lex_state = 30, .external_lex_state = 2},
  [539] = {.lex_state = 30, .external_lex_state = 2},
  [540] = {.lex_state = 30, .external_lex_state = 2},
  [541] = {.lex_state = 30, .external_lex_state = 2},
  [542] = {.lex_state = 30, .external_lex_state = 2},
  [543] = {.lex_state = 30, .external_lex_state = 2},
  [544] = {.lex_state = 30, .external_lex_state = 2},
  [545] = {.lex_state = 30, .external_lex_state = 2},
  [546] = {.lex_state = 30, .external_lex_state = 2},
  [547] = {.lex_state = 30, .external_lex_state = 2},
  [548] = {.lex_state = 30, .external_lex_state = 2},
  [549] = {.lex_state = 30, .external_lex_state = 2},
  [550] = {.lex_state = 30, .external_lex_state = 2},
  [551] = {.lex_state = 30, .external_lex_state = 2},
  [552] = {.lex_state = 30, .external_lex_state = 2},
  [553] = {.lex_state = 30, .external_lex_state = 2},
  [554] = {.lex_state = 30, .external_lex_state = 2},
  [555] = {.lex_state = 30, .external_lex_state = 2},
  [556] = {.lex_state = 30, .external_lex_state = 2},
  [557] = {.lex_state = 30, .external_lex_state = 2},
  [558] = {.lex_state = 30, .external_lex_state = 2},
  [559] = {.lex_state = 30, .external_lex_state = 2},
  [560] = {.lex_state = 30, .external_lex_state = 2},
  [561] = {.lex_state = 30, .external_lex_state = 2},
  [562] = {.lex_state = 30, .external_lex_state = 2},
  [563] = {.lex_state = 30, .external_lex_state = 2},
  [564] = {.lex_state = 30, .external_lex_state = 2},
  [565] = {.lex_state = 30, .external_lex_state = 2},
  [566] = {.lex_state = 30, .external_lex_state = 2},
  [567] = {.lex_state = 30, .external_lex_state = 2},
  [568] = {.lex_state = 30, .external_lex_state = 2},
  [569] = {.lex_state = 30, .external_lex_state = 2},
  [570] = {.lex_state = 30, .external_lex_state = 2},
  [571] = {.lex_state = 30, .external_lex_state = 2},
  [572] = {.lex_state = 30, .external_lex_state = 2},
  [573] = {.lex_state = 30, .external_lex_state = 2},
  [574] = {.lex_state = 30, .external_lex_state = 2},
  [575] = {.lex_state = 30, .external_lex_state = 2},
  [576] = {.lex_state = 30, .external_lex_state = 2},
  [577] = {.lex_state = 30, .external_lex_state = 2},
  [578] = {.lex_state = 30, .external_lex_state = 2},
  [579] = {.lex_state = 30, .external_lex_state = 2},
  [580] = {.lex_state = 30, .external_lex_state = 2},
  [581] = {.lex_state = 30, .external_lex_state = 2},
  [582] = {.lex_state = 30, .external_lex_state = 2},
  [583] = {.lex_state = 30, .external_lex_state = 2},
  [584] = {.lex_state = 30, .external_lex_state = 2},
  [585] = {.lex_state = 30, .external_lex_state = 2},
  [586] = {.lex_state = 30, .external_lex_state = 2},
  [587] = {.lex_state = 30, .external_lex_state = 2},
  [588] = {.lex_state = 30, .external_lex_state = 2},
  [589] = {.lex_state = 30, .external_lex_state = 2},
  [590] = {.lex_state = 30, .external_lex_state = 2},
  [591] = {.lex_state = 30, .external_lex_state = 2},
  [592] = {.lex_state = 30, .external_lex_state = 2},
  [593] = {.lex_state = 30, .external_lex_state = 2},
  [594] = {.lex_state = 30, .external_lex_state = 2},
  [595] = {.lex_state = 30, .external_lex_state = 2},
  [596] = {.lex_state = 30, .external_lex_state = 2},
  [597] = {.lex_state = 30, .external_lex_state = 2},
  [598] = {.lex_state = 30, .external_lex_state = 2},
  [599] = {.lex_state = 30, .external_lex_state = 2},
  [600] = {.lex_state = 30, .external_lex_state = 2},
  [601] = {.lex_state = 30, .external_lex_state = 2},
  [602] = {.lex_state = 30, .external_lex_state = 2},
  [603] = {.lex_state = 30, .external_lex_state = 2},
  [604] = {.lex_state = 30, .external_lex_state = 2},
  [605] = {.lex_state = 30, .external_lex_state = 2},
  [606] = {.lex_state = 30, .external_lex_state = 2},
  [607] = {.lex_state = 30, .external_lex_state = 2},
  [608] = {.lex_state = 30, .external_lex_state = 2},
  [609] = {.lex_state = 30, .external_lex_state = 2},
  [610] = {.lex_state = 30, .external_lex_state = 2},
  [611] = {.lex_state = 30, .external_lex_state = 2},
  [612] = {.lex_state = 30, .external_lex_state = 2},
  [613] = {.lex_state = 30, .external_lex_state = 2},
  [614] = {.lex_state = 30, .external_lex_state = 2},
  [615] = {.lex_state = 30, .external_lex_state = 2},
  [616] = {.lex_state = 30, .external_lex_state = 2},
  [617] = {.lex_state = 30, .external_lex_state = 2},
  [618] = {.lex_state = 30, .external_lex_state = 2},
  [619] = {.lex_state = 30, .external_lex_state = 2},
  [620] = {.lex_state = 30, .external_lex_state = 2},
  [621] = {.lex_state = 30, .external_lex_state = 2},
  [622] = {.lex_state = 30, .external_lex_state = 2},
  [623] = {.lex_state = 30, .external_lex_state = 2},
  [624] = {.lex_state = 30, .external_lex_state = 2},
  [625] = {.lex_state = 30, .external_lex_state = 2},
  [626] = {.lex_state = 30, .external_lex_state = 2},
  [627] = {.lex_state = 30, .external_lex_state = 2},
  [628] = {.lex_state = 30, .external_lex_state = 2},
  [629] = {.lex_state = 30, .external_lex_state = 2},
  [630] = {.lex_state = 30, .external_lex_state = 2},
  [631] = {.lex_state = 30, .external_lex_state = 2},
  [632] = {.lex_state = 30, .external_lex_state = 2},
  [633] = {.lex_state = 30, .external_lex_state = 2},
  [634] = {.lex_state = 30, .external_lex_state = 2},
  [635] = {.lex_state = 30, .external_lex_state = 2},
  [636] = {.lex_state = 30, .external_lex_state = 2},
  [637] = {.lex_state = 30, .external_lex_state = 2},
  [638] = {.lex_state = 30, .external_lex_state = 2},
  [639] = {.lex_state = 30, .external_lex_state = 2},
  [640] = {.lex_state = 30, .external_lex_state = 2},
  [641] = {.lex_state = 30, .external_lex_state = 2},
  [642] = {.lex_state = 30, .external_lex_state = 2},
  [643] = {.lex_state = 30, .external_lex_state = 2},
  [644] = {.lex_state = 30, .external_lex_state = 2},
  [645] = {.lex_state = 30, .external_lex_state = 2},
  [646] = {.lex_state = 30, .external_lex_state = 2},
  [647] = {.lex_state = 30, .external_lex_state = 2},
  [648] = {.lex_state = 30, .external_lex_state = 2},
  [649] = {.lex_state = 30, .external_lex_state = 2},
  [650] = {.lex_state = 30, .external_lex_state = 2},
  [651] = {.lex_state = 30, .external_lex_state = 2},
  [652] = {.lex_state = 30, .external_lex_state = 2},
  [653] = {.lex_state = 30, .external_lex_state = 2},
  [654] = {.lex_state = 30, .external_lex_state = 2},
  [655] = {.lex_state = 30, .external_lex_state = 2},
  [656] = {.lex_state = 30, .external_lex_state = 2},
  [657] = {.lex_state = 30, .external_lex_state = 2},
  [658] = {.lex_state = 30, .external_lex_state = 2},
  [659] = {.lex_state = 30, .external_lex_state = 2},
  [660] = {.lex_state = 30, .external_lex_state = 2},
  [661] = {.lex_state = 30, .external_lex_state = 2},
  [662] = {.lex_state = 30, .external_lex_state = 2},
  [663] = {.lex_state = 30, .external_lex_state = 2},
  [664] = {.lex_state = 30, .external_lex_state = 2},
  [665] = {.lex_state = 30, .external_lex_state = 2},
  [666] = {.lex_state = 30, .external_lex_state = 2},
  [667] = {.lex_state = 30, .external_lex_state = 2},
  [668] = {.lex_state = 30, .external_lex_state = 2},
  [669] = {.lex_state = 30, .external_lex_state = 2},
  [670] = {.lex_state = 30, .external_lex_state = 2},
  [671] = {.lex_state = 30, .external_lex_state = 2},
  [672] = {.lex_state = 30, .external_lex_state = 2},
  [673] = {.lex_state = 30, .external_lex_state = 2},
  [674] = {.lex_state = 30, .external_lex_state = 2},
  [675] = {.lex_state = 30, .external_lex_state = 2},
  [676] = {.lex_state = 30, .external_lex_state = 2},
  [677] = {.lex_state = 30, .external_lex_state = 2},
  [678] = {.lex_state = 30, .external_lex_state = 2},
  [679] = {.lex_state = 30, .external_lex_state = 2},
  [680] = {.lex_state = 30, .external_lex_state = 2},
  [681] = {.lex_state = 30, .external_lex_state = 2},
  [682] = {.lex_state = 30, .external_lex_state = 2},
  [683] = {.lex_state = 30, .external_lex_state = 2},
  [684] = {.lex_state = 30, .external_lex_state = 2},
  [685] = {.lex_state = 30, .external_lex_state = 2},
  [686] = {.lex_state = 30, .external_lex_state = 2},
  [687] = {.lex_state = 30, .external_lex_state = 2},
  [688] = {.lex_state = 30, .external_lex_state = 2},
  [689] = {.lex_state = 30, .external_lex_state = 2},
  [690] = {.lex_state = 30, .external_lex_state = 2},
  [691] = {.lex_state = 30, .external_lex_state = 2},
  [692] = {.lex_state = 30, .external_lex_state = 2},
  [693] = {.lex_state = 30, .external_lex_state = 2},
  [694] = {.lex_state = 30, .external_lex_state = 2},
  [695] = {.lex_state = 30, .external_lex_state = 2},
  [696] = {.lex_state = 30, .external_lex_state = 2},
  [697] = {.lex_state = 30, .external_lex_state = 2},
  [698] = {.lex_state = 30, .external_lex_state = 2},
  [699] = {.lex_state = 30, .external_lex_state = 2},
  [700] = {.lex_state = 30, .external_lex_state = 2},
  [701] = {.lex_state = 30, .external_lex_state = 2},
  [702] = {.lex_state = 30, .external_lex_state = 2},
  [703] = {.lex_state = 30, .external_lex_state = 2},
  [704] = {.lex_state = 30, .external_lex_state = 2},
  [705] = {.lex_state = 30, .external_lex_state = 2},
  [706] = {.lex_state = 30, .external_lex_state = 2},
  [707] = {.lex_state = 30, .external_lex_state = 2},
  [708] = {.lex_state = 30, .external_lex_state = 2},
  [709] = {.lex_state = 30, .external_lex_state = 2},
  [710] = {.lex_state = 30, .external_lex_state = 2},
  [711] = {.lex_state = 30, .external_lex_state = 2},
  [712] = {.lex_state = 30, .external_lex_state = 2},
  [713] = {.lex_state = 30, .external_lex_state = 2},
  [714] = {.lex_state = 30, .external_lex_state = 2},
  [715] = {.lex_state = 30, .external_lex_state = 2},
  [716] = {.lex_state = 30, .external_lex_state = 2},
  [717] = {.lex_state = 30, .external_lex_state = 2},
  [718] = {.lex_state = 30, .external_lex_state = 2},
  [719] = {.lex_state = 30, .external_lex_state = 2},
  [720] = {.lex_state = 30, .external_lex_state = 2},
  [721] = {.lex_state = 30, .external_lex_state = 2},
  [722] = {.lex_state = 30, .external_lex_state = 2},
  [723] = {.lex_state = 30, .external_lex_state = 2},
  [724] = {.lex_state = 30, .external_lex_state = 2},
  [725] = {.lex_state = 30, .external_lex_state = 2},
  [726] = {.lex_state = 30, .external_lex_state = 2},
  [727] = {.lex_state = 30, .external_lex_state = 2},
  [728] = {.lex_state = 30, .external_lex_state = 2},
  [729] = {.lex_state = 30, .external_lex_state = 2},
  [730] = {.lex_state = 30, .external_lex_state = 2},
  [731] = {.lex_state = 30, .external_lex_state = 2},
  [732] = {.lex_state = 30, .external_lex_state = 2},
  [733] = {.lex_state = 30, .external_lex_state = 2},
  [734] = {.lex_state = 30, .external_lex_state = 2},
  [735] = {.lex_state = 30, .external_lex_state = 2},
  [736] = {.lex_state = 30, .external_lex_state = 2},
  [737] = {.lex_state = 30, .external_lex_state = 2},
  [738] = {.lex_state = 30, .external_lex_state = 2},
  [739] = {.lex_state = 30, .external_lex_state = 2},
  [740] = {.lex_state = 30, .external_lex_state = 2},
  [741] = {.lex_state = 30, .external_lex_state = 2},
  [742] = {.lex_state = 30, .external_lex_state = 2},
  [743] = {.lex_state = 30, .external_lex_state = 2},
  [744] = {.lex_state = 30, .external_lex_state = 2},
  [745] = {.lex_state = 30, .external_lex_state = 2},
  [746] = {.lex_state = 30, .external_lex_state = 2},
  [747] = {.lex_state = 30, .external_lex_state = 2},
  [748] = {.lex_state = 30, .external_lex_state = 2},
  [749] = {.lex_state = 30, .external_lex_state = 2},
  [750] = {.lex_state = 30, .external_lex_state = 2},
  [751] = {.lex_state = 30, .external_lex_state = 2},
  [752] = {.lex_state = 30, .external_lex_state = 2},
  [753] = {.lex_state = 30, .external_lex_state = 2},
  [754] = {.lex_state = 30, .external_lex_state = 2},
  [755] = {.lex_state = 30, .external_lex_state = 2},
  [756] = {.lex_state = 30, .external_lex_state = 2},
  [757] = {.lex_state = 30, .external_lex_state = 2},
  [758] = {.lex_state = 30, .external_lex_state = 2},
  [759] = {.lex_state = 30, .external_lex_state = 2},
  [760] = {.lex_state = 30, .external_lex_state = 2},
  [761] = {.lex_state = 30, .external_lex_state = 2},
  [762] = {.lex_state = 30, .external_lex_state = 2},
  [763] = {.lex_state = 30, .external_lex_state = 2},
  [764] = {.lex_state = 30, .external_lex_state = 2},
  [765] = {.lex_state = 30, .external_lex_state = 2},
  [766] = {.lex_state = 30, .external_lex_state = 2},
  [767] = {.lex_state = 30, .external_lex_state = 2},
  [768] = {.lex_state = 30, .external_lex_state = 2},
  [769] = {.lex_state = 30, .external_lex_state = 2},
  [770] = {.lex_state = 30, .external_lex_state = 2},
  [771] = {.lex_state = 30, .external_lex_state = 2},
  [772] = {.lex_state = 30, .external_lex_state = 2},
  [773] = {.lex_state = 30, .external_lex_state = 2},
  [774] = {.lex_state = 30, .external_lex_state = 2},
  [775] = {.lex_state = 30, .external_lex_state = 2},
  [776] = {.lex_state = 30, .external_lex_state = 2},
  [777] = {.lex_state = 30, .external_lex_state = 2},
  [778] = {.lex_state = 30, .external_lex_state = 2},
  [779] = {.lex_state = 30, .external_lex_state = 2},
  [780] = {.lex_state = 30, .external_lex_state = 2},
  [781] = {.lex_state = 30, .external_lex_state = 2},
  [782] = {.lex_state = 30, .external_lex_state = 2},
  [783] = {.lex_state = 30, .external_lex_state = 2},
  [784] = {.lex_state = 30, .external_lex_state = 2},
  [785] = {.lex_state = 30, .external_lex_state = 2},
  [786] = {.lex_state = 30, .external_lex_state = 2},
  [787] = {.lex_state = 30, .external_lex_state = 2},
  [788] = {.lex_state = 30, .external_lex_state = 2},
  [789] = {.lex_state = 30, .external_lex_state = 2},
  [790] = {.lex_state = 30, .external_lex_state = 2},
  [791] = {.lex_state = 30, .external_lex_state = 2},
  [792] = {.lex_state = 30, .external_lex_state = 2},
  [793] = {.lex_state = 30, .external_lex_state = 2},
  [794] = {.lex_state = 30, .external_lex_state = 2},
  [795] = {.lex_state = 30, .external_lex_state = 2},
  [796] = {.lex_state = 30, .external_lex_state = 2},
  [797] = {.lex_state = 30, .external_lex_state = 2},
  [798] = {.lex_state = 30, .external_lex_state = 2},
  [799] = {.lex_state = 30, .external_lex_state = 2},
  [800] = {.lex_state = 30, .external_lex_state = 2},
  [801] = {.lex_state = 30, .external_lex_state = 2},
  [802] = {.lex_state = 30, .external_lex_state = 2},
  [803] = {.lex_state = 30, .external_lex_state = 2},
  [804] = {.lex_state = 30, .external_lex_state = 2},
  [805] = {.lex_state = 30, .external_lex_state = 2},
  [806] = {.lex_state = 30, .external_lex_state = 2},
  [807] = {.lex_state = 30, .external_lex_state = 2},
  [808] = {.lex_state = 30, .external_lex_state = 2},
  [809] = {.lex_state = 30, .external_lex_state = 2},
  [810] = {.lex_state = 30, .external_lex_state = 2},
  [811] = {.lex_state = 30, .external_lex_state = 2},
  [812] = {.lex_state = 30, .external_lex_state = 2},
  [813] = {.lex_state = 30, .external_lex_state = 2},
  [814] = {.lex_state = 30, .external_lex_state = 2},
  [815] = {.lex_state = 30, .external_lex_state = 2},
  [816] = {.lex_state = 30, .external_lex_state = 2},
  [817] = {.lex_state = 30, .external_lex_state = 2},
  [818] = {.lex_state = 30, .external_lex_state = 2},
  [819] = {.lex_state = 30, .external_lex_state = 2},
  [820] = {.lex_state = 30, .external_lex_state = 2},
  [821] = {.lex_state = 30, .external_lex_state = 2},
  [822] = {.lex_state = 30, .external_lex_state = 2},
  [823] = {.lex_state = 30, .external_lex_state = 2},
  [824] = {.lex_state = 30, .external_lex_state = 2},
  [825] = {.lex_state = 30, .external_lex_state = 2},
  [826] = {.lex_state = 30, .external_lex_state = 2},
  [827] = {.lex_state = 30, .external_lex_state = 2},
  [828] = {.lex_state = 30, .external_lex_state = 2},
  [829] = {.lex_state = 30, .external_lex_state = 2},
  [830] = {.lex_state = 30, .external_lex_state = 2},
  [831] = {.lex_state = 30, .external_lex_state = 2},
  [832] = {.lex_state = 30, .external_lex_state = 2},
  [833] = {.lex_state = 30, .external_lex_state = 2},
  [834] = {.lex_state = 30, .external_lex_state = 2},
  [835] = {.lex_state = 30, .external_lex_state = 2},
  [836] = {.lex_state = 30, .external_lex_state = 2},
  [837] = {.lex_state = 30, .external_lex_state = 2},
  [838] = {.lex_state = 30, .external_lex_state = 2},
  [839] = {.lex_state = 30, .external_lex_state = 2},
  [840] = {.lex_state = 30, .external_lex_state = 2},
  [841] = {.lex_state = 30, .external_lex_state = 2},
  [842] = {.lex_state = 30, .external_lex_state = 2},
  [843] = {.lex_state = 30, .external_lex_state = 2},
  [844] = {.lex_state = 30, .external_lex_state = 2},
  [845] = {.lex_state = 30, .external_lex_state = 2},
  [846] = {.lex_state = 30, .external_lex_state = 2},
  [847] = {.lex_state = 30, .external_lex_state = 2},
  [848] = {.lex_state = 30, .external_lex_state = 2},
  [849] = {.lex_state = 30, .external_lex_state = 2},
  [850] = {.lex_state = 30, .external_lex_state = 2},
  [851] = {.lex_state = 30, .external_lex_state = 2},
  [852] = {.lex_state = 30, .external_lex_state = 2},
  [853] = {.lex_state = 30, .external_lex_state = 2},
  [854] = {.lex_state = 30, .external_lex_state = 2},
  [855] = {.lex_state = 30, .external_lex_state = 2},
  [856] = {.lex_state = 30, .external_lex_state = 2},
  [857] = {.lex_state = 30, .external_lex_state = 2},
  [858] = {.lex_state = 30, .external_lex_state = 2},
  [859] = {.lex_state = 30, .external_lex_state = 2},
  [860] = {.lex_state = 30, .external_lex_state = 2},
  [861] = {.lex_state = 30, .external_lex_state = 2},
  [862] = {.lex_state = 30, .external_lex_state = 2},
  [863] = {.lex_state = 30, .external_lex_state = 2},
  [864] = {.lex_state = 30, .external_lex_state = 2},
  [865] = {.lex_state = 30, .external_lex_state = 2},
  [866] = {.lex_state = 30, .external_lex_state = 2},
  [867] = {.lex_state = 30, .external_lex_state = 2},
  [868] = {.lex_state = 30, .external_lex_state = 2},
  [869] = {.lex_state = 30, .external_lex_state = 2},
  [870] = {.lex_state = 30, .external_lex_state = 2},
  [871] = {.lex_state = 30, .external_lex_state = 2},
  [872] = {.lex_state = 30, .external_lex_state = 2},
  [873] = {.lex_state = 30, .external_lex_state = 2},
  [874] = {.lex_state = 30, .external_lex_state = 2},
  [875] = {.lex_state = 30, .external_lex_state = 2},
  [876] = {.lex_state = 30, .external_lex_state = 2},
  [877] = {.lex_state = 30, .external_lex_state = 2},
  [878] = {.lex_state = 30, .external_lex_state = 2},
  [879] = {.lex_state = 30, .external_lex_state = 2},
  [880] = {.lex_state = 30, .external_lex_state = 2},
  [881] = {.lex_state = 30, .external_lex_state = 2},
  [882] = {.lex_state = 30, .external_lex_state = 2},
  [883] = {.lex_state = 30, .external_lex_state = 2},
  [884] = {.lex_state = 30, .external_lex_state = 2},
  [885] = {.lex_state = 30, .external_lex_state = 2},
  [886] = {.lex_state = 30, .external_lex_state = 2},
  [887] = {.lex_state = 30, .external_lex_state = 2},
  [888] = {.lex_state = 30, .external_lex_state = 2},
  [889] = {.lex_state = 30, .external_lex_state = 2},
  [890] = {.lex_state = 30, .external_lex_state = 2},
  [891] = {.lex_state = 30, .external_lex_state = 2},
  [892] = {.lex_state = 30, .external_lex_state = 2},
  [893] = {.lex_state = 30, .external_lex_state = 2},
  [894] = {.lex_state = 30, .external_lex_state = 2},
  [895] = {.lex_state = 30, .external_lex_state = 2},
  [896] = {.lex_state = 30, .external_lex_state = 2},
  [897] = {.lex_state = 30, .external_lex_state = 2},
  [898] = {.lex_state = 30, .external_lex_state = 2},
  [899] = {.lex_state = 30, .external_lex_state = 2},
  [900] = {.lex_state = 30, .external_lex_state = 2},
  [901] = {.lex_state = 30, .external_lex_state = 2},
  [902] = {.lex_state = 30, .external_lex_state = 2},
  [903] = {.lex_state = 30, .external_lex_state = 2},
  [904] = {.lex_state = 30, .external_lex_state = 2},
  [905] = {.lex_state = 30, .external_lex_state = 2},
  [906] = {.lex_state = 30, .external_lex_state = 2},
  [907] = {.lex_state = 30, .external_lex_state = 2},
  [908] = {.lex_state = 30, .external_lex_state = 2},
  [909] = {.lex_state = 30, .external_lex_state = 2},
  [910] = {.lex_state = 30, .external_lex_state = 2},
  [911] = {.lex_state = 30, .external_lex_state = 2},
  [912] = {.lex_state = 30, .external_lex_state = 2},
  [913] = {.lex_state = 30, .external_lex_state = 2},
  [914] = {.lex_state = 30, .external_lex_state = 2},
  [915] = {.lex_state = 30, .external_lex_state = 2},
  [916] = {.lex_state = 30, .external_lex_state = 2},
  [917] = {.lex_state = 30, .external_lex_state = 2},
  [918] = {.lex_state = 30, .external_lex_state = 2},
  [919] = {.lex_state = 30, .external_lex_state = 2},
  [920] = {.lex_state = 30, .external_lex_state = 2},
  [921] = {.lex_state = 30, .external_lex_state = 2},
  [922] = {.lex_state = 30, .external_lex_state = 2},
  [923] = {.lex_state = 30, .external_lex_state = 2},
  [924] = {.lex_state = 30, .external_lex_state = 2},
  [925] = {.lex_state = 30, .external_lex_state = 2},
  [926] = {.lex_state = 30, .external_lex_state = 2},
  [927] = {.lex_state = 30, .external_lex_state = 2},
  [928] = {.lex_state = 30, .external_lex_state = 2},
  [929] = {.lex_state = 30, .external_lex_state = 2},
  [930] = {.lex_state = 30, .external_lex_state = 2},
  [931] = {.lex_state = 30, .external_lex_state = 2},
  [932] = {.lex_state = 30, .external_lex_state = 2},
  [933] = {.lex_state = 30, .external_lex_state = 2},
  [934] = {.lex_state = 30, .external_lex_state = 2},
  [935] = {.lex_state = 30, .external_lex_state = 2},
  [936] = {.lex_state = 30, .external_lex_state = 2},
  [937] = {.lex_state = 30, .external_lex_state = 2},
  [938] = {.lex_state = 30, .external_lex_state = 2},
  [939] = {.lex_state = 30, .external_lex_state = 2},
  [940] = {.lex_state = 30, .external_lex_state = 2},
  [941] = {.lex_state = 30, .external_lex_state = 2},
  [942] = {.lex_state = 30, .external_lex_state = 2},
  [943] = {.lex_state = 30, .external_lex_state = 2},
  [944] = {.lex_state = 30, .external_lex_state = 2},
  [945] = {.lex_state = 30, .external_lex_state = 2},
  [946] = {.lex_state = 30, .external_lex_state = 2},
  [947] = {.lex_state = 30, .external_lex_state = 2},
  [948] = {.lex_state = 30, .external_lex_state = 2},
  [949] = {.lex_state = 30, .external_lex_state = 2},
  [950] = {.lex_state = 30, .external_lex_state = 2},
  [951] = {.lex_state = 30, .external_lex_state = 2},
  [952] = {.lex_state = 30, .external_lex_state = 2},
  [953] = {.lex_state = 30, .external_lex_state = 2},
  [954] = {.lex_state = 30, .external_lex_state = 2},
  [955] = {.lex_state = 30, .external_lex_state = 2},
  [956] = {.lex_state = 30, .external_lex_state = 2},
  [957] = {.lex_state = 30, .external_lex_state = 2},
  [958] = {.lex_state = 30, .external_lex_state = 2},
  [959] = {.lex_state = 30, .external_lex_state = 2},
  [960] = {.lex_state = 30, .external_lex_state = 2},
  [961] = {.lex_state = 30, .external_lex_state = 2},
  [962] = {.lex_state = 30, .external_lex_state = 2},
  [963] = {.lex_state = 30, .external_lex_state = 2},
  [964] = {.lex_state = 30, .external_lex_state = 2},
  [965] = {.lex_state = 30, .external_lex_state = 2},
  [966] = {.lex_state = 30, .external_lex_state = 2},
  [967] = {.lex_state = 30, .external_lex_state = 2},
  [968] = {.lex_state = 30, .external_lex_state = 2},
  [969] = {.lex_state = 30, .external_lex_state = 2},
  [970] = {.lex_state = 30, .external_lex_state = 2},
  [971] = {.lex_state = 30, .external_lex_state = 2},
  [972] = {.lex_state = 30, .external_lex_state = 2},
  [973] = {.lex_state = 30, .external_lex_state = 2},
  [974] = {.lex_state = 30, .external_lex_state = 2},
  [975] = {.lex_state = 30, .external_lex_state = 2},
  [976] = {.lex_state = 30, .external_lex_state = 2},
  [977] = {.lex_state = 30, .external_lex_state = 2},
  [978] = {.lex_state = 30, .external_lex_state = 2},
  [979] = {.lex_state = 30, .external_lex_state = 2},
  [980] = {.lex_state = 30, .external_lex_state = 2},
  [981] = {.lex_state = 30, .external_lex_state = 2},
  [982] = {.lex_state = 30, .external_lex_state = 2},
  [983] = {.lex_state = 30, .external_lex_state = 2},
  [984] = {.lex_state = 30, .external_lex_state = 2},
  [985] = {.lex_state = 30, .external_lex_state = 2},
  [986] = {.lex_state = 30, .external_lex_state = 2},
  [987] = {.lex_state = 30, .external_lex_state = 2},
  [988] = {.lex_state = 30, .external_lex_state = 2},
  [989] = {.lex_state = 30, .external_lex_state = 2},
  [990] = {.lex_state = 30, .external_lex_state = 2},
  [991] = {.lex_state = 30, .external_lex_state = 2},
  [992] = {.lex_state = 30, .external_lex_state = 2},
  [993] = {.lex_state = 30, .external_lex_state = 2},
  [994] = {.lex_state = 30, .external_lex_state = 2},
  [995] = {.lex_state = 30, .external_lex_state = 2},
  [996] = {.lex_state = 30, .external_lex_state = 2},
  [997] = {.lex_state = 30, .external_lex_state = 2},
  [998] = {.lex_state = 30, .external_lex_state = 2},
  [999] = {.lex_state = 30, .external_lex_state = 2},
  [1000] = {.lex_state = 30, .external_lex_state = 2},
  [1001] = {.lex_state = 30, .external_lex_state = 2},
  [1002] = {.lex_state = 30, .external_lex_state = 2},
  [1003] = {.lex_state = 30, .external_lex_state = 2},
  [1004] = {.lex_state = 30, .external_lex_state = 2},
  [1005] = {.lex_state = 30, .external_lex_state = 2},
  [1006] = {.lex_state = 30, .external_lex_state = 2},
  [1007] = {.lex_state = 30, .external_lex_state = 2},
  [1008] = {.lex_state = 30, .external_lex_state = 2},
  [1009] = {.lex_state = 30, .external_lex_state = 2},
  [1010] = {.lex_state = 30, .external_lex_state = 2},
  [1011] = {.lex_state = 30, .external_lex_state = 2},
  [1012] = {.lex_state = 30, .external_lex_state = 2},
  [1013] = {.lex_state = 30, .external_lex_state = 2},
  [1014] = {.lex_state = 30, .external_lex_state = 2},
  [1015] = {.lex_state = 30, .external_lex_state = 2},
  [1016] = {.lex_state = 30, .external_lex_state = 2},
  [1017] = {.lex_state = 30, .external_lex_state = 2},
  [1018] = {.lex_state = 30, .external_lex_state = 2},
  [1019] = {.lex_state = 30, .external_lex_state = 2},
  [1020] = {.lex_state = 30, .external_lex_state = 2},
  [1021] = {.lex_state = 30, .external_lex_state = 2},
  [1022] = {.lex_state = 30, .external_lex_state = 2},
  [1023] = {.lex_state = 30, .external_lex_state = 2},
  [1024] = {.lex_state = 30, .external_lex_state = 2},
  [1025] = {.lex_state = 30, .external_lex_state = 2},
  [1026] = {.lex_state = 30, .external_lex_state = 2},
  [1027] = {.lex_state = 30, .external_lex_state = 2},
  [1028] = {.lex_state = 30, .external_lex_state = 2},
  [1029] = {.lex_state = 30, .external_lex_state = 2},
  [1030] = {.lex_state = 30, .external_lex_state = 2},
  [1031] = {.lex_state = 30, .external_lex_state = 2},
  [1032] = {.lex_state = 30, .external_lex_state = 2},
  [1033] = {.lex_state = 30, .external_lex_state = 2},
  [1034] = {.lex_state = 30, .external_lex_state = 2},
  [1035] = {.lex_state = 30, .external_lex_state = 2},
  [1036] = {.lex_state = 30, .external_lex_state = 2},
  [1037] = {.lex_state = 30, .external_lex_state = 2},
  [1038] = {.lex_state = 30, .external_lex_state = 2},
  [1039] = {.lex_state = 30, .external_lex_state = 2},
  [1040] = {.lex_state = 30, .external_lex_state = 2},
  [1041] = {.lex_state = 30, .external_lex_state = 2},
  [1042] = {.lex_state = 30, .external_lex_state = 2},
  [1043] = {.lex_state = 30, .external_lex_state = 2},
  [1044] = {.lex_state = 30, .external_lex_state = 2},
  [1045] = {.lex_state = 30, .external_lex_state = 2},
  [1046] = {.lex_state = 30, .external_lex_state = 2},
  [1047] = {.lex_state = 30, .external_lex_state = 2},
  [1048] = {.lex_state = 30, .external_lex_state = 2},
  [1049] = {.lex_state = 30, .external_lex_state = 2},
  [1050] = {.lex_state = 30, .external_lex_state = 2},
  [1051] = {.lex_state = 30, .external_lex_state = 2},
  [1052] = {.lex_state = 30, .external_lex_state = 2},
  [1053] = {.lex_state = 30, .external_lex_state = 2},
  [1054] = {.lex_state = 30, .external_lex_state = 2},
  [1055] = {.lex_state = 30, .external_lex_state = 2},
  [1056] = {.lex_state = 30, .external_lex_state = 2},
  [1057] = {.lex_state = 30, .external_lex_state = 2},
  [1058] = {.lex_state = 30, .external_lex_state = 2},
  [1059] = {.lex_state = 30, .external_lex_state = 2},
  [1060] = {.lex_state = 30, .external_lex_state = 2},
  [1061] = {.lex_state = 30, .external_lex_state = 2},
  [1062] = {.lex_state = 30, .external_lex_state = 2},
  [1063] = {.lex_state = 30, .external_lex_state = 2},
  [1064] = {.lex_state = 30, .external_lex_state = 2},
  [1065] = {.lex_state = 30, .external_lex_state = 2},
  [1066] = {.lex_state = 30, .external_lex_state = 2},
  [1067] = {.lex_state = 30, .external_lex_state = 2},
  [1068] = {.lex_state = 30, .external_lex_state = 2},
  [1069] = {.lex_state = 30, .external_lex_state = 2},
  [1070] = {.lex_state = 30, .external_lex_state = 2},
  [1071] = {.lex_state = 30, .external_lex_state = 2},
  [1072] = {.lex_state = 30, .external_lex_state = 2},
  [1073] = {.lex_state = 30, .external_lex_state = 2},
  [1074] = {.lex_state = 30, .external_lex_state = 2},
  [1075] = {.lex_state = 30, .external_lex_state = 2},
  [1076] = {.lex_state = 30, .external_lex_state = 2},
  [1077] = {.lex_state = 30, .external_lex_state = 2},
  [1078] = {.lex_state = 30, .external_lex_state = 2},
  [1079] = {.lex_state = 30, .external_lex_state = 2},
  [1080] = {.lex_state = 30, .external_lex_state = 2},
  [1081] = {.lex_state = 30, .external_lex_state = 2},
  [1082] = {.lex_state = 30, .external_lex_state = 2},
  [1083] = {.lex_state = 30, .external_lex_state = 2},
  [1084] = {.lex_state = 30, .external_lex_state = 2},
  [1085] = {.lex_state = 30, .external_lex_state = 2},
  [1086] = {.lex_state = 30, .external_lex_state = 2},
  [1087] = {.lex_state = 30, .external_lex_state = 2},
  [1088] = {.lex_state = 30, .external_lex_state = 2},
  [1089] = {.lex_state = 30, .external_lex_state = 2},
  [1090] = {.lex_state = 30, .external_lex_state = 2},
  [1091] = {.lex_state = 30, .external_lex_state = 2},
  [1092] = {.lex_state = 30, .external_lex_state = 2},
  [1093] = {.lex_state = 30, .external_lex_state = 2},
  [1094] = {.lex_state = 30, .external_lex_state = 2},
  [1095] = {.lex_state = 30, .external_lex_state = 2},
  [1096] = {.lex_state = 30, .external_lex_state = 2},
  [1097] = {.lex_state = 30, .external_lex_state = 2},
  [1098] = {.lex_state = 30, .external_lex_state = 2},
  [1099] = {.lex_state = 30, .external_lex_state = 2},
  [1100] = {.lex_state = 30, .external_lex_state = 2},
  [1101] = {.lex_state = 30, .external_lex_state = 2},
  [1102] = {.lex_state = 30, .external_lex_state = 2},
  [1103] = {.lex_state = 30, .external_lex_state = 2},
  [1104] = {.lex_state = 30, .external_lex_state = 2},
  [1105] = {.lex_state = 30, .external_lex_state = 2},
  [1106] = {.lex_state = 30, .external_lex_state = 2},
  [1107] = {.lex_state = 30, .external_lex_state = 2},
  [1108] = {.lex_state = 30, .external_lex_state = 2},
  [1109] = {.lex_state = 30, .external_lex_state = 2},
  [1110] = {.lex_state = 30, .external_lex_state = 2},
  [1111] = {.lex_state = 30, .external_lex_state = 2},
  [1112] = {.lex_state = 30, .external_lex_state = 2},
  [1113] = {.lex_state = 30, .external_lex_state = 2},
  [1114] = {.lex_state = 30, .external_lex_state = 2},
  [1115] = {.lex_state = 30, .external_lex_state = 2},
  [1116] = {.lex_state = 30, .external_lex_state = 2},
  [1117] = {.lex_state = 30, .external_lex_state = 2},
  [1118] = {.lex_state = 30, .external_lex_state = 2},
  [1119] = {.lex_state = 30, .external_lex_state = 2},
  [1120] = {.lex_state = 30, .external_lex_state = 2},
  [1121] = {.lex_state = 30, .external_lex_state = 2},
  [1122] = {.lex_state = 30, .external_lex_state = 2},
  [1123] = {.lex_state = 30, .external_lex_state = 2},
  [1124] = {.lex_state = 30, .external_lex_state = 2},
  [1125] = {.lex_state = 30, .external_lex_state = 2},
  [1126] = {.lex_state = 30, .external_lex_state = 2},
  [1127] = {.lex_state = 30, .external_lex_state = 2},
  [1128] = {.lex_state = 30, .external_lex_state = 2},
  [1129] = {.lex_state = 30, .external_lex_state = 2},
  [1130] = {.lex_state = 30, .external_lex_state = 2},
  [1131] = {.lex_state = 30, .external_lex_state = 2},
  [1132] = {.lex_state = 30, .external_lex_state = 2},
  [1133] = {.lex_state = 30, .external_lex_state = 2},
  [1134] = {.lex_state = 30, .external_lex_state = 2},
  [1135] = {.lex_state = 30, .external_lex_state = 2},
  [1136] = {.lex_state = 30, .external_lex_state = 2},
  [1137] = {.lex_state = 30, .external_lex_state = 2},
  [1138] = {.lex_state = 30, .external_lex_state = 2},
  [1139] = {.lex_state = 30, .external_lex_state = 2},
  [1140] = {.lex_state = 30, .external_lex_state = 2},
  [1141] = {.lex_state = 30, .external_lex_state = 2},
  [1142] = {.lex_state = 30, .external_lex_state = 2},
  [1143] = {.lex_state = 30, .external_lex_state = 2},
  [1144] = {.lex_state = 30, .external_lex_state = 2},
  [1145] = {.lex_state = 30, .external_lex_state = 2},
  [1146] = {.lex_state = 30, .external_lex_state = 2},
  [1147] = {.lex_state = 30, .external_lex_state = 2},
  [1148] = {.lex_state = 30, .external_lex_state = 2},
  [1149] = {.lex_state = 30, .external_lex_state = 2},
  [1150] = {.lex_state = 30, .external_lex_state = 2},
  [1151] = {.lex_state = 30, .external_lex_state = 2},
  [1152] = {.lex_state = 30, .external_lex_state = 2},
  [1153] = {.lex_state = 30, .external_lex_state = 2},
  [1154] = {.lex_state = 30, .external_lex_state = 2},
  [1155] = {.lex_state = 30, .external_lex_state = 2},
  [1156] = {.lex_state = 30, .external_lex_state = 2},
  [1157] = {.lex_state = 30, .external_lex_state = 2},
  [1158] = {.lex_state = 30, .external_lex_state = 2},
  [1159] = {.lex_state = 30, .external_lex_state = 2},
  [1160] = {.lex_state = 30, .external_lex_state = 2},
  [1161] = {.lex_state = 30, .external_lex_state = 2},
  [1162] = {.lex_state = 30, .external_lex_state = 2},
  [1163] = {.lex_state = 30, .external_lex_state = 2},
  [1164] = {.lex_state = 30, .external_lex_state = 2},
  [1165] = {.lex_state = 30, .external_lex_state = 2},
  [1166] = {.lex_state = 30, .external_lex_state = 2},
  [1167] = {.lex_state = 30, .external_lex_state = 2},
  [1168] = {.lex_state = 30, .external_lex_state = 2},
  [1169] = {.lex_state = 30, .external_lex_state = 2},
  [1170] = {.lex_state = 30, .external_lex_state = 2},
  [1171] = {.lex_state = 30, .external_lex_state = 2},
  [1172] = {.lex_state = 30, .external_lex_state = 2},
  [1173] = {.lex_state = 30, .external_lex_state = 2},
  [1174] = {.lex_state = 30, .external_lex_state = 2},
  [1175] = {.lex_state = 30, .external_lex_state = 2},
  [1176] = {.lex_state = 30, .external_lex_state = 2},
  [1177] = {.lex_state = 30, .external_lex_state = 2},
  [1178] = {.lex_state = 30, .external_lex_state = 2},
  [1179] = {.lex_state = 30, .external_lex_state = 2},
  [1180] = {.lex_state = 30, .external_lex_state = 2},
  [1181] = {.lex_state = 30, .external_lex_state = 2},
  [1182] = {.lex_state = 30, .external_lex_state = 2},
  [1183] = {.lex_state = 30, .external_lex_state = 2},
  [1184] = {.lex_state = 30, .external_lex_state = 2},
  [1185] = {.lex_state = 30, .external_lex_state = 2},
  [1186] = {.lex_state = 30, .external_lex_state = 2},
  [1187] = {.lex_state = 30, .external_lex_state = 2},
  [1188] = {.lex_state = 30, .external_lex_state = 2},
  [1189] = {.lex_state = 30, .external_lex_state = 2},
  [1190] = {.lex_state = 30, .external_lex_state = 2},
  [1191] = {.lex_state = 30, .external_lex_state = 2},
  [1192] = {.lex_state = 30, .external_lex_state = 2},
  [1193] = {.lex_state = 30, .external_lex_state = 2},
  [1194] = {.lex_state = 30, .external_lex_state = 2},
  [1195] = {.lex_state = 30, .external_lex_state = 2},
  [1196] = {.lex_state = 30, .external_lex_state = 2},
  [1197] = {.lex_state = 30, .external_lex_state = 2},
  [1198] = {.lex_state = 30, .external_lex_state = 2},
  [1199] = {.lex_state = 30, .external_lex_state = 2},
  [1200] = {.lex_state = 30, .external_lex_state = 2},
  [1201] = {.lex_state = 30, .external_lex_state = 2},
  [1202] = {.lex_state = 30, .external_lex_state = 2},
  [1203] = {.lex_state = 30, .external_lex_state = 2},
  [1204] = {.lex_state = 30, .external_lex_state = 2},
  [1205] = {.lex_state = 30, .external_lex_state = 2},
  [1206] = {.lex_state = 30, .external_lex_state = 2},
  [1207] = {.lex_state = 30, .external_lex_state = 2},
  [1208] = {.lex_state = 30, .external_lex_state = 2},
  [1209] = {.lex_state = 30, .external_lex_state = 2},
  [1210] = {.lex_state = 30, .external_lex_state = 2},
  [1211] = {.lex_state = 30, .external_lex_state = 2},
  [1212] = {.lex_state = 30, .external_lex_state = 2},
  [1213] = {.lex_state = 30, .external_lex_state = 2},
  [1214] = {.lex_state = 30, .external_lex_state = 2},
  [1215] = {.lex_state = 30, .external_lex_state = 2},
  [1216] = {.lex_state = 30, .external_lex_state = 2},
  [1217] = {.lex_state = 30, .external_lex_state = 2},
  [1218] = {.lex_state = 30, .external_lex_state = 2},
  [1219] = {.lex_state = 30, .external_lex_state = 2},
  [1220] = {.lex_state = 30, .external_lex_state = 2},
  [1221] = {.lex_state = 30, .external_lex_state = 2},
  [1222] = {.lex_state = 30, .external_lex_state = 2},
  [1223] = {.lex_state = 30, .external_lex_state = 2},
  [1224] = {.lex_state = 30, .external_lex_state = 2},
  [1225] = {.lex_state = 30, .external_lex_state = 2},
  [1226] = {.lex_state = 30, .external_lex_state = 2},
  [1227] = {.lex_state = 30, .external_lex_state = 2},
  [1228] = {.lex_state = 30, .external_lex_state = 2},
  [1229] = {.lex_state = 30, .external_lex_state = 2},
  [1230] = {.lex_state = 30, .external_lex_state = 2},
  [1231] = {.lex_state = 30, .external_lex_state = 2},
  [1232] = {.lex_state = 30, .external_lex_state = 2},
  [1233] = {.lex_state = 30, .external_lex_state = 2},
  [1234] = {.lex_state = 30, .external_lex_state = 2},
  [1235] = {.lex_state = 30, .external_lex_state = 2},
  [1236] = {.lex_state = 30, .external_lex_state = 2},
  [1237] = {.lex_state = 30, .external_lex_state = 2},
  [1238] = {.lex_state = 30, .external_lex_state = 2},
  [1239] = {.lex_state = 30, .external_lex_state = 2},
  [1240] = {.lex_state = 30, .external_lex_state = 2},
  [1241] = {.lex_state = 30, .external_lex_state = 2},
  [1242] = {.lex_state = 30, .external_lex_state = 2},
  [1243] = {.lex_state = 30, .external_lex_state = 2},
  [1244] = {.lex_state = 30, .external_lex_state = 2},
  [1245] = {.lex_state = 30, .external_lex_state = 2},
  [1246] = {.lex_state = 30, .external_lex_state = 2},
  [1247] = {.lex_state = 30, .external_lex_state = 2},
  [1248] = {.lex_state = 30, .external_lex_state = 2},
  [1249] = {.lex_state = 30, .external_lex_state = 2},
  [1250] = {.lex_state = 30, .external_lex_state = 2},
  [1251] = {.lex_state = 30, .external_lex_state = 2},
  [1252] = {.lex_state = 30, .external_lex_state = 2},
  [1253] = {.lex_state = 30, .external_lex_state = 2},
  [1254] = {.lex_state = 30, .external_lex_state = 2},
  [1255] = {.lex_state = 30, .external_lex_state = 2},
  [1256] = {.lex_state = 30, .external_lex_state = 2},
  [1257] = {.lex_state = 30, .external_lex_state = 2},
  [1258] = {.lex_state = 30, .external_lex_state = 2},
  [1259] = {.lex_state = 30, .external_lex_state = 2},
  [1260] = {.lex_state = 30, .external_lex_state = 2},
  [1261] = {.lex_state = 30, .external_lex_state = 2},
  [1262] = {.lex_state = 30, .external_lex_state = 2},
  [1263] = {.lex_state = 30, .external_lex_state = 2},
  [1264] = {.lex_state = 30, .external_lex_state = 2},
  [1265] = {.lex_state = 30, .external_lex_state = 2},
  [1266] = {.lex_state = 30, .external_lex_state = 2},
  [1267] = {.lex_state = 30, .external_lex_state = 2},
  [1268] = {.lex_state = 30, .external_lex_state = 2},
  [1269] = {.lex_state = 30, .external_lex_state = 2},
  [1270] = {.lex_state = 30, .external_lex_state = 2},
  [1271] = {.lex_state = 30, .external_lex_state = 2},
  [1272] = {.lex_state = 30, .external_lex_state = 2},
  [1273] = {.lex_state = 30, .external_lex_state = 2},
  [1274] = {.lex_state = 30, .external_lex_state = 2},
  [1275] = {.lex_state = 30, .external_lex_state = 2},
  [1276] = {.lex_state = 30, .external_lex_state = 2},
  [1277] = {.lex_state = 30, .external_lex_state = 2},
  [1278] = {.lex_state = 30, .external_lex_state = 2},
  [1279] = {.lex_state = 30, .external_lex_state = 2},
  [1280] = {.lex_state = 30, .external_lex_state = 2},
  [1281] = {.lex_state = 30, .external_lex_state = 2},
  [1282] = {.lex_state = 30, .external_lex_state = 2},
  [1283] = {.lex_state = 30, .external_lex_state = 2},
  [1284] = {.lex_state = 30, .external_lex_state = 2},
  [1285] = {.lex_state = 30, .external_lex_state = 2},
  [1286] = {.lex_state = 30, .external_lex_state = 2},
  [1287] = {.lex_state = 30, .external_lex_state = 2},
  [1288] = {.lex_state = 30, .external_lex_state = 2},
  [1289] = {.lex_state = 30, .external_lex_state = 2},
  [1290] = {.lex_state = 30, .external_lex_state = 2},
  [1291] = {.lex_state = 30, .external_lex_state = 2},
  [1292] = {.lex_state = 30, .external_lex_state = 2},
  [1293] = {.lex_state = 30, .external_lex_state = 2},
  [1294] = {.lex_state = 30, .external_lex_state = 2},
  [1295] = {.lex_state = 30, .external_lex_state = 2},
  [1296] = {.lex_state = 30, .external_lex_state = 2},
  [1297] = {.lex_state = 30, .external_lex_state = 2},
  [1298] = {.lex_state = 30, .external_lex_state = 2},
  [1299] = {.lex_state = 30, .external_lex_state = 2},
  [1300] = {.lex_state = 30, .external_lex_state = 2},
  [1301] = {.lex_state = 30, .external_lex_state = 2},
  [1302] = {.lex_state = 30, .external_lex_state = 2},
  [1303] = {.lex_state = 30, .external_lex_state = 2},
  [1304] = {.lex_state = 30, .external_lex_state = 2},
  [1305] = {.lex_state = 30, .external_lex_state = 2},
  [1306] = {.lex_state = 30, .external_lex_state = 2},
  [1307] = {.lex_state = 30, .external_lex_state = 2},
  [1308] = {.lex_state = 30, .external_lex_state = 2},
  [1309] = {.lex_state = 30, .external_lex_state = 2},
  [1310] = {.lex_state = 30, .external_lex_state = 2},
  [1311] = {.lex_state = 30, .external_lex_state = 2},
  [1312] = {.lex_state = 30, .external_lex_state = 2},
  [1313] = {.lex_state = 30, .external_lex_state = 2},
  [1314] = {.lex_state = 30, .external_lex_state = 2},
  [1315] = {.lex_state = 30, .external_lex_state = 2},
  [1316] = {.lex_state = 30, .external_lex_state = 2},
  [1317] = {.lex_state = 30, .external_lex_state = 2},
  [1318] = {.lex_state = 30, .external_lex_state = 2},
  [1319] = {.lex_state = 30, .external_lex_state = 2},
  [1320] = {.lex_state = 30, .external_lex_state = 2},
  [1321] = {.lex_state = 30, .external_lex_state = 2},
  [1322] = {.lex_state = 30, .external_lex_state = 2},
  [1323] = {.lex_state = 30, .external_lex_state = 2},
  [1324] = {.lex_state = 30, .external_lex_state = 2},
  [1325] = {.lex_state = 30, .external_lex_state = 2},
  [1326] = {.lex_state = 30, .external_lex_state = 2},
  [1327] = {.lex_state = 30, .external_lex_state = 2},
  [1328] = {.lex_state = 30, .external_lex_state = 2},
  [1329] = {.lex_state = 30, .external_lex_state = 2},
  [1330] = {.lex_state = 30, .external_lex_state = 2},
  [1331] = {.lex_state = 30, .external_lex_state = 2},
  [1332] = {.lex_state = 30, .external_lex_state = 2},
  [1333] = {.lex_state = 30, .external_lex_state = 2},
  [1334] = {.lex_state = 30, .external_lex_state = 2},
  [1335] = {.lex_state = 30, .external_lex_state = 2},
  [1336] = {.lex_state = 30, .external_lex_state = 2},
  [1337] = {.lex_state = 30, .external_lex_state = 2},
  [1338] = {.lex_state = 30, .external_lex_state = 2},
  [1339] = {.lex_state = 30, .external_lex_state = 2},
  [1340] = {.lex_state = 30, .external_lex_state = 2},
  [1341] = {.lex_state = 30, .external_lex_state = 2},
  [1342] = {.lex_state = 30, .external_lex_state = 2},
  [1343] = {.lex_state = 30, .external_lex_state = 2},
  [1344] = {.lex_state = 30, .external_lex_state = 2},
  [1345] = {.lex_state = 30, .external_lex_state = 2},
  [1346] = {.lex_state = 30, .external_lex_state = 2},
  [1347] = {.lex_state = 30, .external_lex_state = 2},
  [1348] = {.lex_state = 30, .external_lex_state = 2},
  [1349] = {.lex_state = 30, .external_lex_state = 2},
  [1350] = {.lex_state = 30, .external_lex_state = 2},
  [1351] = {.lex_state = 30, .external_lex_state = 2},
  [1352] = {.lex_state = 30, .external_lex_state = 2},
  [1353] = {.lex_state = 30, .external_lex_state = 2},
  [1354] = {.lex_state = 30, .external_lex_state = 2},
  [1355] = {.lex_state = 30, .external_lex_state = 2},
  [1356] = {.lex_state = 30, .external_lex_state = 2},
  [1357] = {.lex_state = 30, .external_lex_state = 2},
  [1358] = {.lex_state = 30, .external_lex_state = 2},
  [1359] = {.lex_state = 30, .external_lex_state = 2},
  [1360] = {.lex_state = 30, .external_lex_state = 2},
  [1361] = {.lex_state = 30, .external_lex_state = 2},
  [1362] = {.lex_state = 30, .external_lex_state = 2},
  [1363] = {.lex_state = 30, .external_lex_state = 2},
  [1364] = {.lex_state = 30, .external_lex_state = 2},
  [1365] = {.lex_state = 30, .external_lex_state = 2},
  [1366] = {.lex_state = 30, .external_lex_state = 2},
  [1367] = {.lex_state = 30, .external_lex_state = 2},
  [1368] = {.lex_state = 30, .external_lex_state = 2},
  [1369] = {.lex_state = 30, .external_lex_state = 2},
  [1370] = {.lex_state = 30, .external_lex_state = 2},
  [1371] = {.lex_state = 30, .external_lex_state = 2},
  [1372] = {.lex_state = 30, .external_lex_state = 2},
  [1373] = {.lex_state = 30, .external_lex_state = 2},
  [1374] = {.lex_state = 30, .external_lex_state = 2},
  [1375] = {.lex_state = 30, .external_lex_state = 2},
  [1376] = {.lex_state = 30, .external_lex_state = 2},
  [1377] = {.lex_state = 30, .external_lex_state = 2},
  [1378] = {.lex_state = 30, .external_lex_state = 2},
  [1379] = {.lex_state = 30, .external_lex_state = 2},
  [1380] = {.lex_state = 30, .external_lex_state = 2},
  [1381] = {.lex_state = 30, .external_lex_state = 2},
  [1382] = {.lex_state = 30, .external_lex_state = 2},
  [1383] = {.lex_state = 30, .external_lex_state = 2},
  [1384] = {.lex_state = 30, .external_lex_state = 2},
  [1385] = {.lex_state = 30, .external_lex_state = 2},
  [1386] = {.lex_state = 30, .external_lex_state = 2},
  [1387] = {.lex_state = 30, .external_lex_state = 2},
  [1388] = {.lex_state = 30, .external_lex_state = 2},
  [1389] = {.lex_state = 30, .external_lex_state = 2},
  [1390] = {.lex_state = 30, .external_lex_state = 2},
  [1391] = {.lex_state = 30, .external_lex_state = 2},
  [1392] = {.lex_state = 30, .external_lex_state = 2},
  [1393] = {.lex_state = 30, .external_lex_state = 2},
  [1394] = {.lex_state = 30, .external_lex_state = 2},
  [1395] = {.lex_state = 30, .external_lex_state = 2},
  [1396] = {.lex_state = 30, .external_lex_state = 2},
  [1397] = {.lex_state = 30, .external_lex_state = 2},
  [1398] = {.lex_state = 30, .external_lex_state = 2},
  [1399] = {.lex_state = 30, .external_lex_state = 2},
  [1400] = {.lex_state = 30, .external_lex_state = 2},
  [1401] = {.lex_state = 30, .external_lex_state = 2},
  [1402] = {.lex_state = 30, .external_lex_state = 2},
  [1403] = {.lex_state = 30, .external_lex_state = 2},
  [1404] = {.lex_state = 30, .external_lex_state = 2},
  [1405] = {.lex_state = 30, .external_lex_state = 2},
  [1406] = {.lex_state = 30, .external_lex_state = 2},
  [1407] = {.lex_state = 30, .external_lex_state = 2},
  [1408] = {.lex_state = 30, .external_lex_state = 2},
  [1409] = {.lex_state = 30, .external_lex_state = 2},
  [1410] = {.lex_state = 30, .external_lex_state = 2},
  [1411] = {.lex_state = 30, .external_lex_state = 2},
  [1412] = {.lex_state = 30, .external_lex_state = 2},
  [1413] = {.lex_state = 30, .external_lex_state = 2},
  [1414] = {.lex_state = 30, .external_lex_state = 2},
  [1415] = {.lex_state = 30, .external_lex_state = 2},
  [1416] = {.lex_state = 30, .external_lex_state = 2},
  [1417] = {.lex_state = 30, .external_lex_state = 2},
  [1418] = {.lex_state = 30, .external_lex_state = 2},
  [1419] = {.lex_state = 30, .external_lex_state = 2},
  [1420] = {.lex_state = 30, .external_lex_state = 2},
  [1421] = {.lex_state = 30, .external_lex_state = 2},
  [1422] = {.lex_state = 30, .external_lex_state = 2},
  [1423] = {.lex_state = 30, .external_lex_state = 2},
  [1424] = {.lex_state = 30, .external_lex_state = 2},
  [1425] = {.lex_state = 30, .external_lex_state = 2},
  [1426] = {.lex_state = 30, .external_lex_state = 2},
  [1427] = {.lex_state = 30, .external_lex_state = 2},
  [1428] = {.lex_state = 30, .external_lex_state = 2},
  [1429] = {.lex_state = 30, .external_lex_state = 2},
  [1430] = {.lex_state = 30, .external_lex_state = 2},
  [1431] = {.lex_state = 30, .external_lex_state = 2},
  [1432] = {.lex_state = 30, .external_lex_state = 2},
  [1433] = {.lex_state = 30, .external_lex_state = 2},
  [1434] = {.lex_state = 30, .external_lex_state = 2},
  [1435] = {.lex_state = 30, .external_lex_state = 2},
  [1436] = {.lex_state = 30, .external_lex_state = 2},
  [1437] = {.lex_state = 30, .external_lex_state = 2},
  [1438] = {.lex_state = 30, .external_lex_state = 2},
  [1439] = {.lex_state = 30, .external_lex_state = 2},
  [1440] = {.lex_state = 30, .external_lex_state = 2},
  [1441] = {.lex_state = 30, .external_lex_state = 2},
  [1442] = {.lex_state = 30, .external_lex_state = 2},
  [1443] = {.lex_state = 30, .external_lex_state = 2},
  [1444] = {.lex_state = 30, .external_lex_state = 2},
  [1445] = {.lex_state = 30, .external_lex_state = 2},
  [1446] = {.lex_state = 30, .external_lex_state = 2},
  [1447] = {.lex_state = 30, .external_lex_state = 2},
  [1448] = {.lex_state = 30, .external_lex_state = 2},
  [1449] = {.lex_state = 30, .external_lex_state = 2},
  [1450] = {.lex_state = 30, .external_lex_state = 2},
  [1451] = {.lex_state = 30, .external_lex_state = 2},
  [1452] = {.lex_state = 30, .external_lex_state = 2},
  [1453] = {.lex_state = 30, .external_lex_state = 2},
  [1454] = {.lex_state = 30, .external_lex_state = 2},
  [1455] = {.lex_state = 30, .external_lex_state = 2},
  [1456] = {.lex_state = 30, .external_lex_state = 2},
  [1457] = {.lex_state = 30, .external_lex_state = 2},
  [1458] = {.lex_state = 30, .external_lex_state = 2},
  [1459] = {.lex_state = 30, .external_lex_state = 2},
  [1460] = {.lex_state = 30, .external_lex_state = 2},
  [1461] = {.lex_state = 30, .external_lex_state = 2},
  [1462] = {.lex_state = 30, .external_lex_state = 2},
  [1463] = {.lex_state = 30, .external_lex_state = 2},
  [1464] = {.lex_state = 30, .external_lex_state = 2},
  [1465] = {.lex_state = 30, .external_lex_state = 2},
  [1466] = {.lex_state = 30, .external_lex_state = 2},
  [1467] = {.lex_state = 30, .external_lex_state = 2},
  [1468] = {.lex_state = 30, .external_lex_state = 2},
  [1469] = {.lex_state = 30, .external_lex_state = 2},
  [1470] = {.lex_state = 30, .external_lex_state = 2},
  [1471] = {.lex_state = 30, .external_lex_state = 2},
  [1472] = {.lex_state = 30, .external_lex_state = 2},
  [1473] = {.lex_state = 30, .external_lex_state = 2},
  [1474] = {.lex_state = 30, .external_lex_state = 2},
  [1475] = {.lex_state = 30, .external_lex_state = 2},
  [1476] = {.lex_state = 30, .external_lex_state = 2},
  [1477] = {.lex_state = 30, .external_lex_state = 2},
  [1478] = {.lex_state = 30, .external_lex_state = 2},
  [1479] = {.lex_state = 30, .external_lex_state = 2},
  [1480] = {.lex_state = 30, .external_lex_state = 2},
  [1481] = {.lex_state = 30, .external_lex_state = 2},
  [1482] = {.lex_state = 30, .external_lex_state = 2},
  [1483] = {.lex_state = 30, .external_lex_state = 2},
  [1484] = {.lex_state = 29},
  [1485] = {.lex_state = 29},
  [1486] = {.lex_state = 29},
  [1487] = {.lex_state = 29},
  [1488] = {.lex_state = 29},
  [1489] = {.lex_state = 29},
  [1490] = {.lex_state = 29},
  [1491] = {.lex_state = 29},
  [1492] = {.lex_state = 29},
  [1493] = {.lex_state = 29},
  [1494] = {.lex_state = 29},
  [1495] = {.lex_state = 29},
  [1496] = {.lex_state = 29},
  [1497] = {.lex_state = 29},
  [1498] = {.lex_state = 29},
  [1499] = {.lex_state = 29},
  [1500] = {.lex_state = 29},
  [1501] = {.lex_state = 29},
  [1502] = {.lex_state = 29},
  [1503] = {.lex_state = 29},
  [1504] = {.lex_state = 29},
  [1505] = {.lex_state = 29},
  [1506] = {.lex_state = 29},
  [1507] = {.lex_state = 29},
  [1508] = {.lex_state = 29},
  [1509] = {.lex_state = 29},
  [1510] = {.lex_state = 29},
  [1511] = {.lex_state = 29},
  [1512] = {.lex_state = 29},
  [1513] = {.lex_state = 29},
  [1514] = {.lex_state = 29},
  [1515] = {.lex_state = 29},
  [1516] = {.lex_state = 29},
  [1517] = {.lex_state = 29},
  [1518] = {.lex_state = 29},
  [1519] = {.lex_state = 29},
  [1520] = {.lex_state = 29},
  [1521] = {.lex_state = 29},
  [1522] = {.lex_state = 29},
  [1523] = {.lex_state = 29},
  [1524] = {.lex_state = 29},
  [1525] = {.lex_state = 29},
  [1526] = {.lex_state = 29},
  [1527] = {.lex_state = 29},
  [1528] = {.lex_state = 29},
  [1529] = {.lex_state = 29},
  [1530] = {.lex_state = 29},
  [1531] = {.lex_state = 29},
  [1532] = {.lex_state = 29},
  [1533] = {.lex_state = 29},
  [1534] = {.lex_state = 29},
  [1535] = {.lex_state = 29},
  [1536] = {.lex_state = 29},
  [1537] = {.lex_state = 29},
  [1538] = {.lex_state = 29},
  [1539] = {.lex_state = 29},
  [1540] = {.lex_state = 29},
  [1541] = {.lex_state = 29},
  [1542] = {.lex_state = 29},
  [1543] = {.lex_state = 29},
  [1544] = {.lex_state = 29},
  [1545] = {.lex_state = 29},
  [1546] = {.lex_state = 29},
  [1547] = {.lex_state = 29},
  [1548] = {.lex_state = 29},
  [1549] = {.lex_state = 29},
  [1550] = {.lex_state = 29},
  [1551] = {.lex_state = 29},
  [1552] = {.lex_state = 29},
  [1553] = {.lex_state = 29},
  [1554] = {.lex_state = 29},
  [1555] = {.lex_state = 29},
  [1556] = {.lex_state = 29},
  [1557] = {.lex_state = 29},
  [1558] = {.lex_state = 29},
  [1559] = {.lex_state = 29},
  [1560] = {.lex_state = 29},
  [1561] = {.lex_state = 29},
  [1562] = {.lex_state = 29},
  [1563] = {.lex_state = 29, .external_lex_state = 2},
  [1564] = {.lex_state = 29},
  [1565] = {.lex_state = 29},
  [1566] = {.lex_state = 29},
  [1567] = {.lex_state = 29},
  [1568] = {.lex_state = 29},
  [1569] = {.lex_state = 29, .external_lex_state = 2},
  [1570] = {.lex_state = 29},
  [1571] = {.lex_state = 29},
  [1572] = {.lex_state = 29},
  [1573] = {.lex_state = 29},
  [1574] = {.lex_state = 29},
  [1575] = {.lex_state = 29},
  [1576] = {.lex_state = 29},
  [1577] = {.lex_state = 29},
  [1578] = {.lex_state = 29},
  [1579] = {.lex_state = 29},
  [1580] = {.lex_state = 29},
  [1581] = {.lex_state = 29},
  [1582] = {.lex_state = 29},
  [1583] = {.lex_state = 29},
  [1584] = {.lex_state = 29},
  [1585] = {.lex_state = 29},
  [1586] = {.lex_state = 29, .external_lex_state = 2},
  [1587] = {.lex_state = 29},
  [1588] = {.lex_state = 29},
  [1589] = {.lex_state = 29},
  [1590] = {.lex_state = 29, .external_lex_state = 2},
  [1591] = {.lex_state = 29},
  [1592] = {.lex_state = 29},
  [1593] = {.lex_state = 29},
  [1594] = {.lex_state = 29, .external_lex_state = 2},
  [1595] = {.lex_state = 29},
  [1596] = {.lex_state = 29},
  [1597] = {.lex_state = 29},
  [1598] = {.lex_state = 29, .external_lex_state = 2},
  [1599] = {.lex_state = 29, .external_lex_state = 2},
  [1600] = {.lex_state = 29},
  [1601] = {.lex_state = 29},
  [1602] = {.lex_state = 29},
  [1603] = {.lex_state = 29},
  [1604] = {.lex_state = 29},
  [1605] = {.lex_state = 29},
  [1606] = {.lex_state = 29},
  [1607] = {.lex_state = 29},
  [1608] = {.lex_state = 29},
  [1609] = {.lex_state = 29},
  [1610] = {.lex_state = 29},
  [1611] = {.lex_state = 29},
  [1612] = {.lex_state = 29},
  [1613] = {.lex_state = 29},
  [1614] = {.lex_state = 29},
  [1615] = {.lex_state = 29},
  [1616] = {.lex_state = 29},
  [1617] = {.lex_state = 29},
  [1618] = {.lex_state = 29},
  [1619] = {.lex_state = 29},
  [1620] = {.lex_state = 29},
  [1621] = {.lex_state = 29},
  [1622] = {.lex_state = 29},
  [1623] = {.lex_state = 29},
  [1624] = {.lex_state = 29},
  [1625] = {.lex_state = 29},
  [1626] = {.lex_state = 29, .external_lex_state = 2},
  [1627] = {.lex_state = 29},
  [1628] = {.lex_state = 29},
  [1629] = {.lex_state = 29},
  [1630] = {.lex_state = 29},
  [1631] = {.lex_state = 29},
  [1632] = {.lex_state = 29},
  [1633] = {.lex_state = 29},
  [1634] = {.lex_state = 29},
  [1635] = {.lex_state = 29},
  [1636] = {.lex_state = 29},
  [1637] = {.lex_state = 29},
  [1638] = {.lex_state = 29},
  [1639] = {.lex_state = 29},
  [1640] = {.lex_state = 29},
  [1641] = {.lex_state = 29},
  [1642] = {.lex_state = 29},
  [1643] = {.lex_state = 29},
  [1644] = {.lex_state = 29},
  [1645] = {.lex_state = 29},
  [1646] = {.lex_state = 29},
  [1647] = {.lex_state = 29},
  [1648] = {.lex_state = 29},
  [1649] = {.lex_state = 29},
  [1650] = {.lex_state = 29},
  [1651] = {.lex_state = 29},
  [1652] = {.lex_state = 29},
  [1653] = {.lex_state = 29},
  [1654] = {.lex_state = 29},
  [1655] = {.lex_state = 29},
  [1656] = {.lex_state = 29},
  [1657] = {.lex_state = 29},
  [1658] = {.lex_state = 29},
  [1659] = {.lex_state = 29},
  [1660] = {.lex_state = 29},
  [1661] = {.lex_state = 29},
  [1662] = {.lex_state = 29},
  [1663] = {.lex_state = 29},
  [1664] = {.lex_state = 29},
  [1665] = {.lex_state = 29},
  [1666] = {.lex_state = 29},
  [1667] = {.lex_state = 29},
  [1668] = {.lex_state = 29},
  [1669] = {.lex_state = 29},
  [1670] = {.lex_state = 29},
  [1671] = {.lex_state = 29},
  [1672] = {.lex_state = 29},
  [1673] = {.lex_state = 29},
  [1674] = {.lex_state = 29},
  [1675] = {.lex_state = 29},
  [1676] = {.lex_state = 29},
  [1677] = {.lex_state = 29},
  [1678] = {.lex_state = 29},
  [1679] = {.lex_state = 29},
  [1680] = {.lex_state = 29},
  [1681] = {.lex_state = 29},
  [1682] = {.lex_state = 29},
  [1683] = {.lex_state = 29},
  [1684] = {.lex_state = 29},
  [1685] = {.lex_state = 29},
  [1686] = {.lex_state = 29},
  [1687] = {.lex_state = 29},
  [1688] = {.lex_state = 29},
  [1689] = {.lex_state = 29},
  [1690] = {.lex_state = 29},
  [1691] = {.lex_state = 29},
  [1692] = {.lex_state = 29},
  [1693] = {.lex_state = 29},
  [1694] = {.lex_state = 29},
  [1695] = {.lex_state = 29},
  [1696] = {.lex_state = 29},
  [1697] = {.lex_state = 29},
  [1698] = {.lex_state = 29},
  [1699] = {.lex_state = 29},
  [1700] = {.lex_state = 29},
  [1701] = {.lex_state = 29},
  [1702] = {.lex_state = 29},
  [1703] = {.lex_state = 29},
  [1704] = {.lex_state = 29},
  [1705] = {.lex_state = 29},
  [1706] = {.lex_state = 29},
  [1707] = {.lex_state = 29},
  [1708] = {.lex_state = 29},
  [1709] = {.lex_state = 29},
  [1710] = {.lex_state = 29},
  [1711] = {.lex_state = 29, .external_lex_state = 2},
  [1712] = {.lex_state = 29},
  [1713] = {.lex_state = 29},
  [1714] = {.lex_state = 29},
  [1715] = {.lex_state = 29},
  [1716] = {.lex_state = 29},
  [1717] = {.lex_state = 29},
  [1718] = {.lex_state = 29},
  [1719] = {.lex_state = 29},
  [1720] = {.lex_state = 29},
  [1721] = {.lex_state = 29},
  [1722] = {.lex_state = 29},
  [1723] = {.lex_state = 29},
  [1724] = {.lex_state = 29},
  [1725] = {.lex_state = 29},
  [1726] = {.lex_state = 29},
  [1727] = {.lex_state = 29},
  [1728] = {.lex_state = 29},
  [1729] = {.lex_state = 29},
  [1730] = {.lex_state = 29},
  [1731] = {.lex_state = 29, .external_lex_state = 2},
  [1732] = {.lex_state = 29, .external_lex_state = 2},
  [1733] = {.lex_state = 29, .external_lex_state = 2},
  [1734] = {.lex_state = 29, .external_lex_state = 2},
  [1735] = {.lex_state = 29, .external_lex_state = 2},
  [1736] = {.lex_state = 29, .external_lex_state = 2},
  [1737] = {.lex_state = 29},
  [1738] = {.lex_state = 29},
  [1739] = {.lex_state = 29},
  [1740] = {.lex_state = 29},
  [1741] = {.lex_state = 29},
  [1742] = {.lex_state = 29},
  [1743] = {.lex_state = 29},
  [1744] = {.lex_state = 29},
  [1745] = {.lex_state = 29},
  [1746] = {.lex_state = 29},
  [1747] = {.lex_state = 29},
  [1748] = {.lex_state = 29},
  [1749] = {.lex_state = 29},
  [1750] = {.lex_state = 29},
  [1751] = {.lex_state = 29},
  [1752] = {.lex_state = 29},
  [1753] = {.lex_state = 29},
  [1754] = {.lex_state = 29},
  [1755] = {.lex_state = 29},
  [1756] = {.lex_state = 29},
  [1757] = {.lex_state = 29},
  [1758] = {.lex_state = 29},
  [1759] = {.lex_state = 29},
  [1760] = {.lex_state = 29},
  [1761] = {.lex_state = 29},
  [1762] = {.lex_state = 29},
  [1763] = {.lex_state = 29},
  [1764] = {.lex_state = 29},
  [1765] = {.lex_state = 29},
  [1766] = {.lex_state = 29},
  [1767] = {.lex_state = 29},
  [1768] = {.lex_state = 29},
  [1769] = {.lex_state = 29},
  [1770] = {.lex_state = 29},
  [1771] = {.lex_state = 29},
  [1772] = {.lex_state = 29},
  [1773] = {.lex_state = 29},
  [1774] = {.lex_state = 29},
  [1775] = {.lex_state = 29},
  [1776] = {.lex_state = 29},
  [1777] = {.lex_state = 29},
  [1778] = {.lex_state = 29},
  [1779] = {.lex_state = 29},
  [1780] = {.lex_state = 29},
  [1781] = {.lex_state = 29},
  [1782] = {.lex_state = 29},
  [1783] = {.lex_state = 29},
  [1784] = {.lex_state = 29},
  [1785] = {.lex_state = 29},
  [1786] = {.lex_state = 29},
  [1787] = {.lex_state = 29},
  [1788] = {.lex_state = 29},
  [1789] = {.lex_state = 29},
  [1790] = {.lex_state = 29},
  [1791] = {.lex_state = 29},
  [1792] = {.lex_state = 29},
  [1793] = {.lex_state = 29},
  [1794] = {.lex_state = 29},
  [1795] = {.lex_state = 29},
  [1796] = {.lex_state = 29},
  [1797] = {.lex_state = 29},
  [1798] = {.lex_state = 29},
  [1799] = {.lex_state = 29},
  [1800] = {.lex_state = 29},
  [1801] = {.lex_state = 29},
  [1802] = {.lex_state = 29},
  [1803] = {.lex_state = 29},
  [1804] = {.lex_state = 29},
  [1805] = {.lex_state = 29},
  [1806] = {.lex_state = 29},
  [1807] = {.lex_state = 29},
  [1808] = {.lex_state = 29},
  [1809] = {.lex_state = 29},
  [1810] = {.lex_state = 29},
  [1811] = {.lex_state = 29},
  [1812] = {.lex_state = 29},
  [1813] = {.lex_state = 29},
  [1814] = {.lex_state = 29},
  [1815] = {.lex_state = 29},
  [1816] = {.lex_state = 29},
  [1817] = {.lex_state = 29},
  [1818] = {.lex_state = 29},
  [1819] = {.lex_state = 29},
  [1820] = {.lex_state = 29},
  [1821] = {.lex_state = 29},
  [1822] = {.lex_state = 29},
  [1823] = {.lex_state = 29},
  [1824] = {.lex_state = 29},
  [1825] = {.lex_state = 29},
  [1826] = {.lex_state = 29},
  [1827] = {.lex_state = 29},
  [1828] = {.lex_state = 29},
  [1829] = {.lex_state = 29},
  [1830] = {.lex_state = 29},
  [1831] = {.lex_state = 29},
  [1832] = {.lex_state = 29},
  [1833] = {.lex_state = 29},
  [1834] = {.lex_state = 29},
  [1835] = {.lex_state = 29},
  [1836] = {.lex_state = 29},
  [1837] = {.lex_state = 29},
  [1838] = {.lex_state = 29},
  [1839] = {.lex_state = 29},
  [1840] = {.lex_state = 29},
  [1841] = {.lex_state = 29},
  [1842] = {.lex_state = 29},
  [1843] = {.lex_state = 29},
  [1844] = {.lex_state = 29},
  [1845] = {.lex_state = 29},
  [1846] = {.lex_state = 29},
  [1847] = {.lex_state = 29},
  [1848] = {.lex_state = 29},
  [1849] = {.lex_state = 29},
  [1850] = {.lex_state = 29},
  [1851] = {.lex_state = 29},
  [1852] = {.lex_state = 29},
  [1853] = {.lex_state = 29},
  [1854] = {.lex_state = 29},
  [1855] = {.lex_state = 29},
  [1856] = {.lex_state = 29},
  [1857] = {.lex_state = 29},
  [1858] = {.lex_state = 29},
  [1859] = {.lex_state = 29},
  [1860] = {.lex_state = 29},
  [1861] = {.lex_state = 29},
  [1862] = {.lex_state = 29},
  [1863] = {.lex_state = 29},
  [1864] = {.lex_state = 29},
  [1865] = {.lex_state = 29},
  [1866] = {.lex_state = 29},
  [1867] = {.lex_state = 29},
  [1868] = {.lex_state = 29},
  [1869] = {.lex_state = 29},
  [1870] = {.lex_state = 29},
  [1871] = {.lex_state = 29},
  [1872] = {.lex_state = 29},
  [1873] = {.lex_state = 29},
  [1874] = {.lex_state = 29},
  [1875] = {.lex_state = 29},
  [1876] = {.lex_state = 29},
  [1877] = {.lex_state = 29},
  [1878] = {.lex_state = 29},
  [1879] = {.lex_state = 29},
  [1880] = {.lex_state = 29},
  [1881] = {.lex_state = 29},
  [1882] = {.lex_state = 29},
  [1883] = {.lex_state = 29},
  [1884] = {.lex_state = 29},
  [1885] = {.lex_state = 29},
  [1886] = {.lex_state = 29},
  [1887] = {.lex_state = 29},
  [1888] = {.lex_state = 29},
  [1889] = {.lex_state = 29},
  [1890] = {.lex_state = 29},
  [1891] = {.lex_state = 29},
  [1892] = {.lex_state = 29},
  [1893] = {.lex_state = 29},
  [1894] = {.lex_state = 29},
  [1895] = {.lex_state = 29},
  [1896] = {.lex_state = 29},
  [1897] = {.lex_state = 29},
  [1898] = {.lex_state = 29},
  [1899] = {.lex_state = 29},
  [1900] = {.lex_state = 29},
  [1901] = {.lex_state = 29},
  [1902] = {.lex_state = 29},
  [1903] = {.lex_state = 29},
  [1904] = {.lex_state = 29},
  [1905] = {.lex_state = 29},
  [1906] = {.lex_state = 29},
  [1907] = {.lex_state = 29},
  [1908] = {.lex_state = 29},
  [1909] = {.lex_state = 29},
  [1910] = {.lex_state = 29},
  [1911] = {.lex_state = 29},
  [1912] = {.lex_state = 29},
  [1913] = {.lex_state = 29},
  [1914] = {.lex_state = 29},
  [1915] = {.lex_state = 29},
  [1916] = {.lex_state = 29},
  [1917] = {.lex_state = 29},
  [1918] = {.lex_state = 29},
  [1919] = {.lex_state = 29},
  [1920] = {.lex_state = 29},
  [1921] = {.lex_state = 29},
  [1922] = {.lex_state = 29},
  [1923] = {.lex_state = 29},
  [1924] = {.lex_state = 29},
  [1925] = {.lex_state = 29},
  [1926] = {.lex_state = 29},
  [1927] = {.lex_state = 29},
  [1928] = {.lex_state = 29},
  [1929] = {.lex_state = 29},
  [1930] = {.lex_state = 29},
  [1931] = {.lex_state = 29},
  [1932] = {.lex_state = 29},
  [1933] = {.lex_state = 29},
  [1934] = {.lex_state = 29},
  [1935] = {.lex_state = 29},
  [1936] = {.lex_state = 29},
  [1937] = {.lex_state = 29},
  [1938] = {.lex_state = 29},
  [1939] = {.lex_state = 29},
  [1940] = {.lex_state = 29},
  [1941] = {.lex_state = 29},
  [1942] = {.lex_state = 29},
  [1943] = {.lex_state = 29},
  [1944] = {.lex_state = 29},
  [1945] = {.lex_state = 29},
  [1946] = {.lex_state = 29},
  [1947] = {.lex_state = 29},
  [1948] = {.lex_state = 29},
  [1949] = {.lex_state = 29},
  [1950] = {.lex_state = 29},
  [1951] = {.lex_state = 29},
  [1952] = {.lex_state = 29},
  [1953] = {.lex_state = 29},
  [1954] = {.lex_state = 29},
  [1955] = {.lex_state = 29},
  [1956] = {.lex_state = 29},
  [1957] = {.lex_state = 29},
  [1958] = {.lex_state = 29},
  [1959] = {.lex_state = 29},
  [1960] = {.lex_state = 29},
  [1961] = {.lex_state = 29},
  [1962] = {.lex_state = 29},
  [1963] = {.lex_state = 29},
  [1964] = {.lex_state = 29},
  [1965] = {.lex_state = 29},
  [1966] = {.lex_state = 29},
  [1967] = {.lex_state = 29},
  [1968] = {.lex_state = 29},
  [1969] = {.lex_state = 29},
  [1970] = {.lex_state = 29},
  [1971] = {.lex_state = 29},
  [1972] = {.lex_state = 29},
  [1973] = {.lex_state = 29},
  [1974] = {.lex_state = 29},
  [1975] = {.lex_state = 29},
  [1976] = {.lex_state = 29},
  [1977] = {.lex_state = 29},
  [1978] = {.lex_state = 29},
  [1979] = {.lex_state = 29},
  [1980] = {.lex_state = 29},
  [1981] = {.lex_state = 29},
  [1982] = {.lex_state = 29, .external_lex_state = 2},
  [1983] = {.lex_state = 29},
  [1984] = {.lex_state = 29},
  [1985] = {.lex_state = 29},
  [1986] = {.lex_state = 29},
  [1987] = {.lex_state = 29},
  [1988] = {.lex_state = 29},
  [1989] = {.lex_state = 29},
  [1990] = {.lex_state = 29},
  [1991] = {.lex_state = 29},
  [1992] = {.lex_state = 29},
  [1993] = {.lex_state = 29},
  [1994] = {.lex_state = 29},
  [1995] = {.lex_state = 29},
  [1996] = {.lex_state = 29},
  [1997] = {.lex_state = 29},
  [1998] = {.lex_state = 29},
  [1999] = {.lex_state = 29},
  [2000] = {.lex_state = 29},
  [2001] = {.lex_state = 29},
  [2002] = {.lex_state = 29},
  [2003] = {.lex_state = 29},
  [2004] = {.lex_state = 29},
  [2005] = {.lex_state = 29},
  [2006] = {.lex_state = 29},
  [2007] = {.lex_state = 29},
  [2008] = {.lex_state = 29},
  [2009] = {.lex_state = 29},
  [2010] = {.lex_state = 29},
  [2011] = {.lex_state = 29},
  [2012] = {.lex_state = 29},
  [2013] = {.lex_state = 29},
  [2014] = {.lex_state = 29, .external_lex_state = 2},
  [2015] = {.lex_state = 29},
  [2016] = {.lex_state = 29},
  [2017] = {.lex_state = 29},
  [2018] = {.lex_state = 29},
  [2019] = {.lex_state = 29},
  [2020] = {.lex_state = 29},
  [2021] = {.lex_state = 29},
  [2022] = {.lex_state = 29},
  [2023] = {.lex_state = 29},
  [2024] = {.lex_state = 29},
  [2025] = {.lex_state = 29},
  [2026] = {.lex_state = 29},
  [2027] = {.lex_state = 29},
  [2028] = {.lex_state = 29},
  [2029] = {.lex_state = 29},
  [2030] = {.lex_state = 29},
  [2031] = {.lex_state = 29},
  [2032] = {.lex_state = 29},
  [2033] = {.lex_state = 29},
  [2034] = {.lex_state = 29},
  [2035] = {.lex_state = 29},
  [2036] = {.lex_state = 29},
  [2037] = {.lex_state = 29},
  [2038] = {.lex_state = 29},
  [2039] = {.lex_state = 29},
  [2040] = {.lex_state = 29},
  [2041] = {.lex_state = 29},
  [2042] = {.lex_state = 29},
  [2043] = {.lex_state = 29},
  [2044] = {.lex_state = 29},
  [2045] = {.lex_state = 29, .external_lex_state = 2},
  [2046] = {.lex_state = 29},
  [2047] = {.lex_state = 29},
  [2048] = {.lex_state = 29},
  [2049] = {.lex_state = 29},
  [2050] = {.lex_state = 29},
  [2051] = {.lex_state = 29},
  [2052] = {.lex_state = 29},
  [2053] = {.lex_state = 29},
  [2054] = {.lex_state = 29},
  [2055] = {.lex_state = 29},
  [2056] = {.lex_state = 29},
  [2057] = {.lex_state = 29},
  [2058] = {.lex_state = 29},
  [2059] = {.lex_state = 29},
  [2060] = {.lex_state = 29},
  [2061] = {.lex_state = 29},
  [2062] = {.lex_state = 29},
  [2063] = {.lex_state = 29},
  [2064] = {.lex_state = 29},
  [2065] = {.lex_state = 29},
  [2066] = {.lex_state = 29},
  [2067] = {.lex_state = 29},
  [2068] = {.lex_state = 29},
  [2069] = {.lex_state = 29},
  [2070] = {.lex_state = 29},
  [2071] = {.lex_state = 29},
  [2072] = {.lex_state = 29},
  [2073] = {.lex_state = 29},
  [2074] = {.lex_state = 29},
  [2075] = {.lex_state = 29},
  [2076] = {.lex_state = 29},
  [2077] = {.lex_state = 29},
  [2078] = {.lex_state = 29},
  [2079] = {.lex_state = 0},
  [2080] = {.lex_state = 0},
  [2081] = {.lex_state = 29},
  [2082] = {.lex_state = 29},
  [2083] = {.lex_state = 29},
  [2084] = {.lex_state = 29},
  [2085] = {.lex_state = 29},
  [2086] = {.lex_state = 29},
  [2087] = {.lex_state = 0},
  [2088] = {.lex_state = 0},
  [2089] = {.lex_state = 29},
  [2090] = {.lex_state = 29},
  [2091] = {.lex_state = 29},
  [2092] = {.lex_state = 29},
  [2093] = {.lex_state = 29},
  [2094] = {.lex_state = 0},
  [2095] = {.lex_state = 29},
  [2096] = {.lex_state = 29},
  [2097] = {.lex_state = 29},
  [2098] = {.lex_state = 29},
  [2099] = {.lex_state = 29},
  [2100] = {.lex_state = 29},
  [2101] = {.lex_state = 29},
  [2102] = {.lex_state = 29},
  [2103] = {.lex_state = 29},
  [2104] = {.lex_state = 29},
  [2105] = {.lex_state = 29},
  [2106] = {.lex_state = 29},
  [2107] = {.lex_state = 29},
  [2108] = {.lex_state = 29},
  [2109] = {.lex_state = 29},
  [2110] = {.lex_state = 29},
  [2111] = {.lex_state = 0},
  [2112] = {.lex_state = 29},
  [2113] = {.lex_state = 29},
  [2114] = {.lex_state = 29},
  [2115] = {.lex_state = 0},
  [2116] = {.lex_state = 29},
  [2117] = {.lex_state = 0},
  [2118] = {.lex_state = 29},
  [2119] = {.lex_state = 0},
  [2120] = {.lex_state = 29},
  [2121] = {.lex_state = 29},
  [2122] = {.lex_state = 29, .external_lex_state = 2},
  [2123] = {.lex_state = 29, .external_lex_state = 2},
  [2124] = {.lex_state = 0},
  [2125] = {.lex_state = 0},
  [2126] = {.lex_state = 0},
  [2127] = {.lex_state = 29},
  [2128] = {.lex_state = 29},
  [2129] = {.lex_state = 29, .external_lex_state = 2},
  [2130] = {.lex_state = 29},
  [2131] = {.lex_state = 0},
  [2132] = {.lex_state = 29},
  [2133] = {.lex_state = 29},
  [2134] = {.lex_state = 29},
  [2135] = {.lex_state = 29},
  [2136] = {.lex_state = 29},
  [2137] = {.lex_state = 29, .external_lex_state = 2},
  [2138] = {.lex_state = 29},
  [2139] = {.lex_state = 29},
  [2140] = {.lex_state = 29},
  [2141] = {.lex_state = 0},
  [2142] = {.lex_state = 29},
  [2143] = {.lex_state = 0},
  [2144] = {.lex_state = 29},
  [2145] = {.lex_state = 29},
  [2146] = {.lex_state = 29},
  [2147] = {.lex_state = 29},
  [2148] = {.lex_state = 29},
  [2149] = {.lex_state = 29},
  [2150] = {.lex_state = 29},
  [2151] = {.lex_state = 29},
  [2152] = {.lex_state = 29},
  [2153] = {.lex_state = 29},
  [2154] = {.lex_state = 29},
  [2155] = {.lex_state = 29, .external_lex_state = 2},
  [2156] = {.lex_state = 29},
  [2157] = {.lex_state = 29},
  [2158] = {.lex_state = 29, .external_lex_state = 2},
  [2159] = {.lex_state = 29},
  [2160] = {.lex_state = 29},
  [2161] = {.lex_state = 29},
  [2162] = {.lex_state = 29},
  [2163] = {.lex_state = 29},
  [2164] = {.lex_state = 29},
  [2165] = {.lex_state = 29},
  [2166] = {.lex_state = 29},
  [2167] = {.lex_state = 29},
  [2168] = {.lex_state = 29},
  [2169] = {.lex_state = 29},
  [2170] = {.lex_state = 29},
  [2171] = {.lex_state = 29},
  [2172] = {.lex_state = 29},
  [2173] = {.lex_state = 29},
  [2174] = {.lex_state = 29},
  [2175] = {.lex_state = 29},
  [2176] = {.lex_state = 29},
  [2177] = {.lex_state = 29},
  [2178] = {.lex_state = 29},
  [2179] = {.lex_state = 29, .external_lex_state = 2},
  [2180] = {.lex_state = 29},
  [2181] = {.lex_state = 29},
  [2182] = {.lex_state = 29},
  [2183] = {.lex_state = 29},
  [2184] = {.lex_state = 29},
  [2185] = {.lex_state = 29},
  [2186] = {.lex_state = 29},
  [2187] = {.lex_state = 29},
  [2188] = {.lex_state = 29},
  [2189] = {.lex_state = 29},
  [2190] = {.lex_state = 29},
  [2191] = {.lex_state = 29},
  [2192] = {.lex_state = 29},
  [2193] = {.lex_state = 29},
  [2194] = {.lex_state = 29},
  [2195] = {.lex_state = 29},
  [2196] = {.lex_state = 29},
  [2197] = {.lex_state = 29},
  [2198] = {.lex_state = 29},
  [2199] = {.lex_state = 29},
  [2200] = {.lex_state = 29},
  [2201] = {.lex_state = 29},
  [2202] = {.lex_state = 29},
  [2203] = {.lex_state = 29},
  [2204] = {.lex_state = 29},
  [2205] = {.lex_state = 29},
  [2206] = {.lex_state = 29},
  [2207] = {.lex_state = 29},
  [2208] = {.lex_state = 29},
  [2209] = {.lex_state = 29},
  [2210] = {.lex_state = 29},
  [2211] = {.lex_state = 29},
  [2212] = {.lex_state = 29},
  [2213] = {.lex_state = 29},
  [2214] = {.lex_state = 29},
  [2215] = {.lex_state = 29},
  [2216] = {.lex_state = 29},
  [2217] = {.lex_state = 29},
  [2218] = {.lex_state = 29},
  [2219] = {.lex_state = 29},
  [2220] = {.lex_state = 29},
  [2221] = {.lex_state = 29},
  [2222] = {.lex_state = 29},
  [2223] = {.lex_state = 29},
  [2224] = {.lex_state = 29},
  [2225] = {.lex_state = 29},
  [2226] = {.lex_state = 29},
  [2227] = {.lex_state = 29},
  [2228] = {.lex_state = 29},
  [2229] = {.lex_state = 29},
  [2230] = {.lex_state = 29},
  [2231] = {.lex_state = 29},
  [2232] = {.lex_state = 29},
  [2233] = {.lex_state = 29},
  [2234] = {.lex_state = 29},
  [2235] = {.lex_state = 29},
  [2236] = {.lex_state = 29},
  [2237] = {.lex_state = 29},
  [2238] = {.lex_state = 29},
  [2239] = {.lex_state = 29},
  [2240] = {.lex_state = 29},
  [2241] = {.lex_state = 29},
  [2242] = {.lex_state = 29},
  [2243] = {.lex_state = 29},
  [2244] = {.lex_state = 29, .external_lex_state = 2},
  [2245] = {.lex_state = 29},
  [2246] = {.lex_state = 29},
  [2247] = {.lex_state = 29},
  [2248] = {.lex_state = 29},
  [2249] = {.lex_state = 29},
  [2250] = {.lex_state = 29},
  [2251] = {.lex_state = 29},
  [2252] = {.lex_state = 29},
  [2253] = {.lex_state = 29},
  [2254] = {.lex_state = 29},
  [2255] = {.lex_state = 29},
  [2256] = {.lex_state = 29},
  [2257] = {.lex_state = 29},
  [2258] = {.lex_state = 29},
  [2259] = {.lex_state = 29},
  [2260] = {.lex_state = 29, .external_lex_state = 2},
  [2261] = {.lex_state = 29},
  [2262] = {.lex_state = 29},
  [2263] = {.lex_state = 29},
  [2264] = {.lex_state = 29},
  [2265] = {.lex_state = 29},
  [2266] = {.lex_state = 29},
  [2267] = {.lex_state = 29},
  [2268] = {.lex_state = 29},
  [2269] = {.lex_state = 29},
  [2270] = {.lex_state = 29},
  [2271] = {.lex_state = 29},
  [2272] = {.lex_state = 29},
  [2273] = {.lex_state = 29},
  [2274] = {.lex_state = 29},
  [2275] = {.lex_state = 29},
  [2276] = {.lex_state = 29},
  [2277] = {.lex_state = 29},
  [2278] = {.lex_state = 29},
  [2279] = {.lex_state = 29},
  [2280] = {.lex_state = 29},
  [2281] = {.lex_state = 29},
  [2282] = {.lex_state = 29},
  [2283] = {.lex_state = 29},
  [2284] = {.lex_state = 29},
  [2285] = {.lex_state = 29},
  [2286] = {.lex_state = 29, .external_lex_state = 2},
  [2287] = {.lex_state = 29},
  [2288] = {.lex_state = 29},
  [2289] = {.lex_state = 29, .external_lex_state = 2},
  [2290] = {.lex_state = 29, .external_lex_state = 2},
  [2291] = {.lex_state = 29, .external_lex_state = 2},
  [2292] = {.lex_state = 29},
  [2293] = {.lex_state = 29, .external_lex_state = 2},
  [2294] = {.lex_state = 29},
  [2295] = {.lex_state = 29},
  [2296] = {.lex_state = 29},
  [2297] = {.lex_state = 29},
  [2298] = {.lex_state = 29},
  [2299] = {.lex_state = 29},
  [2300] = {.lex_state = 29},
  [2301] = {.lex_state = 29},
  [2302] = {.lex_state = 29},
  [2303] = {.lex_state = 29},
  [2304] = {.lex_state = 29},
  [2305] = {.lex_state = 29},
  [2306] = {.lex_state = 29},
  [2307] = {.lex_state = 29},
  [2308] = {.lex_state = 0},
  [2309] = {.lex_state = 29},
  [2310] = {.lex_state = 29},
  [2311] = {.lex_state = 29},
  [2312] = {.lex_state = 29},
  [2313] = {.lex_state = 29},
  [2314] = {.lex_state = 29},
  [2315] = {.lex_state = 29},
  [2316] = {.lex_state = 29},
  [2317] = {.lex_state = 29},
  [2318] = {.lex_state = 29},
  [2319] = {.lex_state = 29},
  [2320] = {.lex_state = 0},
  [2321] = {.lex_state = 29},
  [2322] = {.lex_state = 29},
  [2323] = {.lex_state = 29},
  [2324] = {.lex_state = 29},
  [2325] = {.lex_state = 0},
  [2326] = {.lex_state = 0},
  [2327] = {.lex_state = 0},
  [2328] = {.lex_state = 29},
  [2329] = {.lex_state = 29},
  [2330] = {.lex_state = 29},
  [2331] = {.lex_state = 29},
  [2332] = {.lex_state = 29},
  [2333] = {.lex_state = 29},
  [2334] = {.lex_state = 29, .external_lex_state = 2},
  [2335] = {.lex_state = 0},
  [2336] = {.lex_state = 29},
  [2337] = {.lex_state = 29},
  [2338] = {.lex_state = 29},
  [2339] = {.lex_state = 29},
  [2340] = {.lex_state = 0},
  [2341] = {.lex_state = 0},
  [2342] = {.lex_state = 29},
  [2343] = {.lex_state = 29},
  [2344] = {.lex_state = 29},
  [2345] = {.lex_state = 29},
  [2346] = {.lex_state = 29},
  [2347] = {.lex_state = 0},
  [2348] = {.lex_state = 29},
  [2349] = {.lex_state = 29},
  [2350] = {.lex_state = 29},
  [2351] = {.lex_state = 29},
  [2352] = {.lex_state = 29},
  [2353] = {.lex_state = 29},
  [2354] = {.lex_state = 29},
  [2355] = {.lex_state = 29},
  [2356] = {.lex_state = 29},
  [2357] = {.lex_state = 29},
  [2358] = {.lex_state = 29},
  [2359] = {.lex_state = 0},
  [2360] = {.lex_state = 29},
  [2361] = {.lex_state = 29},
  [2362] = {.lex_state = 29},
  [2363] = {.lex_state = 0},
  [2364] = {.lex_state = 29},
  [2365] = {.lex_state = 29},
  [2366] = {.lex_state = 29},
  [2367] = {.lex_state = 29},
  [2368] = {.lex_state = 29},
  [2369] = {.lex_state = 29},
  [2370] = {.lex_state = 29},
  [2371] = {.lex_state = 29},
  [2372] = {.lex_state = 29},
  [2373] = {.lex_state = 29},
  [2374] = {.lex_state = 29},
  [2375] = {.lex_state = 29},
  [2376] = {.lex_state = 29},
  [2377] = {.lex_state = 29},
  [2378] = {.lex_state = 29},
  [2379] = {.lex_state = 29},
  [2380] = {.lex_state = 29},
  [2381] = {.lex_state = 29},
  [2382] = {.lex_state = 29},
  [2383] = {.lex_state = 29},
  [2384] = {.lex_state = 29},
  [2385] = {.lex_state = 29},
  [2386] = {.lex_state = 29},
  [2387] = {.lex_state = 29},
  [2388] = {.lex_state = 0},
  [2389] = {.lex_state = 29},
  [2390] = {.lex_state = 0},
  [2391] = {.lex_state = 29},
  [2392] = {.lex_state = 29},
  [2393] = {.lex_state = 29},
  [2394] = {.lex_state = 29},
  [2395] = {.lex_state = 29},
  [2396] = {.lex_state = 29},
  [2397] = {.lex_state = 29},
  [2398] = {.lex_state = 29},
  [2399] = {.lex_state = 0},
  [2400] = {.lex_state = 29},
  [2401] = {.lex_state = 29},
  [2402] = {.lex_state = 29},
  [2403] = {.lex_state = 29},
  [2404] = {.lex_state = 29},
  [2405] = {.lex_state = 29},
  [2406] = {.lex_state = 29},
  [2407] = {.lex_state = 29},
  [2408] = {.lex_state = 29},
  [2409] = {.lex_state = 29},
  [2410] = {.lex_state = 29},
  [2411] = {.lex_state = 0},
  [2412] = {.lex_state = 0},
  [2413] = {.lex_state = 29},
  [2414] = {.lex_state = 29},
  [2415] = {.lex_state = 29},
  [2416] = {.lex_state = 29},
  [2417] = {.lex_state = 29},
  [2418] = {.lex_state = 29},
  [2419] = {.lex_state = 0},
  [2420] = {.lex_state = 0},
  [2421] = {.lex_state = 29},
  [2422] = {.lex_state = 29},
  [2423] = {.lex_state = 29},
  [2424] = {.lex_state = 29},
  [2425] = {.lex_state = 29},
  [2426] = {.lex_state = 29},
  [2427] = {.lex_state = 29},
  [2428] = {.lex_state = 29},
  [2429] = {.lex_state = 29},
  [2430] = {.lex_state = 29},
  [2431] = {.lex_state = 29},
  [2432] = {.lex_state = 29},
  [2433] = {.lex_state = 29},
  [2434] = {.lex_state = 29},
  [2435] = {.lex_state = 29},
  [2436] = {.lex_state = 29},
  [2437] = {.lex_state = 29},
  [2438] = {.lex_state = 29, .external_lex_state = 2},
  [2439] = {.lex_state = 29},
  [2440] = {.lex_state = 29},
  [2441] = {.lex_state = 29, .external_lex_state = 2},
  [2442] = {.lex_state = 29, .external_lex_state = 2},
  [2443] = {.lex_state = 29, .external_lex_state = 2},
  [2444] = {.lex_state = 29},
  [2445] = {.lex_state = 29},
  [2446] = {.lex_state = 29},
  [2447] = {.lex_state = 29},
  [2448] = {.lex_state = 29, .external_lex_state = 2},
  [2449] = {.lex_state = 29, .external_lex_state = 2},
  [2450] = {.lex_state = 29},
  [2451] = {.lex_state = 29},
  [2452] = {.lex_state = 29},
  [2453] = {.lex_state = 29},
  [2454] = {.lex_state = 29},
  [2455] = {.lex_state = 29},
  [2456] = {.lex_state = 29},
  [2457] = {.lex_state = 29},
  [2458] = {.lex_state = 29},
  [2459] = {.lex_state = 29},
  [2460] = {.lex_state = 29},
  [2461] = {.lex_state = 29},
  [2462] = {.lex_state = 29},
  [2463] = {.lex_state = 29},
  [2464] = {.lex_state = 29},
  [2465] = {.lex_state = 29},
  [2466] = {.lex_state = 29},
  [2467] = {.lex_state = 29},
  [2468] = {.lex_state = 29},
  [2469] = {.lex_state = 29},
  [2470] = {.lex_state = 29},
  [2471] = {.lex_state = 29},
  [2472] = {.lex_state = 29},
  [2473] = {.lex_state = 29},
  [2474] = {.lex_state = 29},
  [2475] = {.lex_state = 29},
  [2476] = {.lex_state = 29},
  [2477] = {.lex_state = 29},
  [2478] = {.lex_state = 29},
  [2479] = {.lex_state = 29},
  [2480] = {.lex_state = 29},
  [2481] = {.lex_state = 29},
  [2482] = {.lex_state = 29},
  [2483] = {.lex_state = 29},
  [2484] = {.lex_state = 29},
  [2485] = {.lex_state = 29},
  [2486] = {.lex_state = 29},
  [2487] = {.lex_state = 29},
  [2488] = {.lex_state = 29},
  [2489] = {.lex_state = 29},
  [2490] = {.lex_state = 29},
  [2491] = {.lex_state = 29},
  [2492] = {.lex_state = 29},
  [2493] = {.lex_state = 29},
  [2494] = {.lex_state = 29},
  [2495] = {.lex_state = 29},
  [2496] = {.lex_state = 29},
  [2497] = {.lex_state = 29},
  [2498] = {.lex_state = 29},
  [2499] = {.lex_state = 29},
  [2500] = {.lex_state = 29},
  [2501] = {.lex_state = 29},
  [2502] = {.lex_state = 29},
  [2503] = {.lex_state = 29},
  [2504] = {.lex_state = 29},
  [2505] = {.lex_state = 29},
  [2506] = {.lex_state = 29},
  [2507] = {.lex_state = 29},
  [2508] = {.lex_state = 29},
  [2509] = {.lex_state = 29},
  [2510] = {.lex_state = 29},
  [2511] = {.lex_state = 29},
  [2512] = {.lex_state = 29},
  [2513] = {.lex_state = 29},
  [2514] = {.lex_state = 29},
  [2515] = {.lex_state = 29},
  [2516] = {.lex_state = 29},
  [2517] = {.lex_state = 29},
  [2518] = {.lex_state = 29},
  [2519] = {.lex_state = 29},
  [2520] = {.lex_state = 29},
  [2521] = {.lex_state = 29},
  [2522] = {.lex_state = 29},
  [2523] = {.lex_state = 29},
  [2524] = {.lex_state = 29},
  [2525] = {.lex_state = 29},
  [2526] = {.lex_state = 29},
  [2527] = {.lex_state = 29},
  [2528] = {.lex_state = 29},
  [2529] = {.lex_state = 29},
  [2530] = {.lex_state = 29},
  [2531] = {.lex_state = 29},
  [2532] = {.lex_state = 29},
  [2533] = {.lex_state = 29},
  [2534] = {.lex_state = 29},
  [2535] = {.lex_state = 29},
  [2536] = {.lex_state = 29},
  [2537] = {.lex_state = 29},
  [2538] = {.lex_state = 29},
  [2539] = {.lex_state = 29},
  [2540] = {.lex_state = 29},
  [2541] = {.lex_state = 29},
  [2542] = {.lex_state = 29},
  [2543] = {.lex_state = 29},
  [2544] = {.lex_state = 29},
  [2545] = {.lex_state = 29},
  [2546] = {.lex_state = 29},
  [2547] = {.lex_state = 29},
  [2548] = {.lex_state = 29},
  [2549] = {.lex_state = 29},
  [2550] = {.lex_state = 29},
  [2551] = {.lex_state = 29},
  [2552] = {.lex_state = 29},
  [2553] = {.lex_state = 29},
  [2554] = {.lex_state = 29},
  [2555] = {.lex_state = 29},
  [2556] = {.lex_state = 29},
  [2557] = {.lex_state = 29},
  [2558] = {.lex_state = 29},
  [2559] = {.lex_state = 29},
  [2560] = {.lex_state = 29},
  [2561] = {.lex_state = 29},
  [2562] = {.lex_state = 29},
  [2563] = {.lex_state = 29},
  [2564] = {.lex_state = 29},
  [2565] = {.lex_state = 29},
  [2566] = {.lex_state = 29},
  [2567] = {.lex_state = 29},
  [2568] = {.lex_state = 29},
  [2569] = {.lex_state = 29},
  [2570] = {.lex_state = 29},
  [2571] = {.lex_state = 29},
  [2572] = {.lex_state = 29, .external_lex_state = 2},
  [2573] = {.lex_state = 29},
  [2574] = {.lex_state = 29},
  [2575] = {.lex_state = 29},
  [2576] = {.lex_state = 29},
  [2577] = {.lex_state = 29},
  [2578] = {.lex_state = 29},
  [2579] = {.lex_state = 29},
  [2580] = {.lex_state = 29},
  [2581] = {.lex_state = 29},
  [2582] = {.lex_state = 29},
  [2583] = {.lex_state = 29},
  [2584] = {.lex_state = 29},
  [2585] = {.lex_state = 29},
  [2586] = {.lex_state = 29},
  [2587] = {.lex_state = 29},
  [2588] = {.lex_state = 29},
  [2589] = {.lex_state = 29},
  [2590] = {.lex_state = 29},
  [2591] = {.lex_state = 29},
  [2592] = {.lex_state = 29},
  [2593] = {.lex_state = 29},
  [2594] = {.lex_state = 29},
  [2595] = {.lex_state = 29},
  [2596] = {.lex_state = 29},
  [2597] = {.lex_state = 29},
  [2598] = {.lex_state = 29},
  [2599] = {.lex_state = 29},
  [2600] = {.lex_state = 29},
  [2601] = {.lex_state = 29},
  [2602] = {.lex_state = 29},
  [2603] = {.lex_state = 29},
  [2604] = {.lex_state = 29},
  [2605] = {.lex_state = 29},
  [2606] = {.lex_state = 29},
  [2607] = {.lex_state = 29},
  [2608] = {.lex_state = 29},
  [2609] = {.lex_state = 29},
  [2610] = {.lex_state = 29},
  [2611] = {.lex_state = 29},
  [2612] = {.lex_state = 29},
  [2613] = {.lex_state = 29},
  [2614] = {.lex_state = 29},
  [2615] = {.lex_state = 29},
  [2616] = {.lex_state = 29},
  [2617] = {.lex_state = 29},
  [2618] = {.lex_state = 29},
  [2619] = {.lex_state = 29},
  [2620] = {.lex_state = 29},
  [2621] = {.lex_state = 29},
  [2622] = {.lex_state = 29},
  [2623] = {.lex_state = 29},
  [2624] = {.lex_state = 29},
  [2625] = {.lex_state = 29},
  [2626] = {.lex_state = 29},
  [2627] = {.lex_state = 29},
  [2628] = {.lex_state = 29},
  [2629] = {.lex_state = 29},
  [2630] = {.lex_state = 29},
  [2631] = {.lex_state = 29},
  [2632] = {.lex_state = 29},
  [2633] = {.lex_state = 29},
  [2634] = {.lex_state = 29},
  [2635] = {.lex_state = 29},
  [2636] = {.lex_state = 29},
  [2637] = {.lex_state = 29},
  [2638] = {.lex_state = 29},
  [2639] = {.lex_state = 29},
  [2640] = {.lex_state = 29},
  [2641] = {.lex_state = 29},
  [2642] = {.lex_state = 29},
  [2643] = {.lex_state = 29},
  [2644] = {.lex_state = 29},
  [2645] = {.lex_state = 29},
  [2646] = {.lex_state = 29},
  [2647] = {.lex_state = 29},
  [2648] = {.lex_state = 29},
  [2649] = {.lex_state = 29},
  [2650] = {.lex_state = 29},
  [2651] = {.lex_state = 29},
  [2652] = {.lex_state = 29},
  [2653] = {.lex_state = 29},
  [2654] = {.lex_state = 29},
  [2655] = {.lex_state = 29},
  [2656] = {.lex_state = 29},
  [2657] = {.lex_state = 29},
  [2658] = {.lex_state = 29},
  [2659] = {.lex_state = 29},
  [2660] = {.lex_state = 29},
  [2661] = {.lex_state = 29},
  [2662] = {.lex_state = 29},
  [2663] = {.lex_state = 29},
  [2664] = {.lex_state = 29},
  [2665] = {.lex_state = 29},
  [2666] = {.lex_state = 29},
  [2667] = {.lex_state = 29},
  [2668] = {.lex_state = 29},
  [2669] = {.lex_state = 29},
  [2670] = {.lex_state = 29},
  [2671] = {.lex_state = 29},
  [2672] = {.lex_state = 29},
  [2673] = {.lex_state = 29},
  [2674] = {.lex_state = 29},
  [2675] = {.lex_state = 29},
  [2676] = {.lex_state = 29},
  [2677] = {.lex_state = 29},
  [2678] = {.lex_state = 29},
  [2679] = {.lex_state = 29},
  [2680] = {.lex_state = 29},
  [2681] = {.lex_state = 29},
  [2682] = {.lex_state = 29},
  [2683] = {.lex_state = 29},
  [2684] = {.lex_state = 29},
  [2685] = {.lex_state = 29},
  [2686] = {.lex_state = 29},
  [2687] = {.lex_state = 29},
  [2688] = {.lex_state = 29},
  [2689] = {.lex_state = 29},
  [2690] = {.lex_state = 29},
  [2691] = {.lex_state = 29},
  [2692] = {.lex_state = 29},
  [2693] = {.lex_state = 29},
  [2694] = {.lex_state = 29},
  [2695] = {.lex_state = 29},
  [2696] = {.lex_state = 29},
  [2697] = {.lex_state = 29},
  [2698] = {.lex_state = 29},
  [2699] = {.lex_state = 29},
  [2700] = {.lex_state = 29},
  [2701] = {.lex_state = 29},
  [2702] = {.lex_state = 29},
  [2703] = {.lex_state = 29},
  [2704] = {.lex_state = 29},
  [2705] = {.lex_state = 29},
  [2706] = {.lex_state = 29},
  [2707] = {.lex_state = 29},
  [2708] = {.lex_state = 29},
  [2709] = {.lex_state = 29},
  [2710] = {.lex_state = 29},
  [2711] = {.lex_state = 29},
  [2712] = {.lex_state = 29},
  [2713] = {.lex_state = 29},
  [2714] = {.lex_state = 29},
  [2715] = {.lex_state = 29},
  [2716] = {.lex_state = 29},
  [2717] = {.lex_state = 29, .external_lex_state = 2},
  [2718] = {.lex_state = 29},
  [2719] = {.lex_state = 29},
  [2720] = {.lex_state = 29},
  [2721] = {.lex_state = 29},
  [2722] = {.lex_state = 29},
  [2723] = {.lex_state = 29},
  [2724] = {.lex_state = 29},
  [2725] = {.lex_state = 29},
  [2726] = {.lex_state = 29},
  [2727] = {.lex_state = 29},
  [2728] = {.lex_state = 29},
  [2729] = {.lex_state = 29},
  [2730] = {.lex_state = 1, .external_lex_state = 2},
  [2731] = {.lex_state = 1, .external_lex_state = 2},
  [2732] = {.lex_state = 1, .external_lex_state = 2},
  [2733] = {.lex_state = 1, .external_lex_state = 2},
  [2734] = {.lex_state = 29},
  [2735] = {.lex_state = 1, .external_lex_state = 2},
  [2736] = {.lex_state = 1, .external_lex_state = 2},
  [2737] = {.lex_state = 29},
  [2738] = {.lex_state = 1, .external_lex_state = 2},
  [2739] = {.lex_state = 1, .external_lex_state = 2},
  [2740] = {.lex_state = 1, .external_lex_state = 2},
  [2741] = {.lex_state = 29},
  [2742] = {.lex_state = 1, .external_lex_state = 2},
  [2743] = {.lex_state = 1, .external_lex_state = 2},
  [2744] = {.lex_state = 1, .external_lex_state = 2},
  [2745] = {.lex_state = 29},
  [2746] = {.lex_state = 1, .external_lex_state = 2},
  [2747] = {.lex_state = 1, .external_lex_state = 2},
  [2748] = {.lex_state = 1, .external_lex_state = 2},
  [2749] = {.lex_state = 1, .external_lex_state = 2},
  [2750] = {.lex_state = 1, .external_lex_state = 2},
  [2751] = {.lex_state = 1, .external_lex_state = 2},
  [2752] = {.lex_state = 1, .external_lex_state = 2},
  [2753] = {.lex_state = 1, .external_lex_state = 2},
  [2754] = {.lex_state = 1, .external_lex_state = 2},
  [2755] = {.lex_state = 1, .external_lex_state = 2},
  [2756] = {.lex_state = 1, .external_lex_state = 2},
  [2757] = {.lex_state = 29},
  [2758] = {.lex_state = 1, .external_lex_state = 2},
  [2759] = {.lex_state = 1, .external_lex_state = 2},
  [2760] = {.lex_state = 1, .external_lex_state = 2},
  [2761] = {.lex_state = 1, .external_lex_state = 2},
  [2762] = {.lex_state = 1, .external_lex_state = 2},
  [2763] = {.lex_state = 1, .external_lex_state = 2},
  [2764] = {.lex_state = 1, .external_lex_state = 2},
  [2765] = {.lex_state = 1, .external_lex_state = 2},
  [2766] = {.lex_state = 29},
  [2767] = {.lex_state = 29},
  [2768] = {.lex_state = 1, .external_lex_state = 2},
  [2769] = {.lex_state = 1, .external_lex_state = 2},
  [2770] = {.lex_state = 1, .external_lex_state = 2},
  [2771] = {.lex_state = 29},
  [2772] = {.lex_state = 1, .external_lex_state = 2},
  [2773] = {.lex_state = 1, .external_lex_state = 2},
  [2774] = {.lex_state = 1, .external_lex_state = 2},
  [2775] = {.lex_state = 1, .external_lex_state = 2},
  [2776] = {.lex_state = 1, .external_lex_state = 2},
  [2777] = {.lex_state = 1, .external_lex_state = 2},
  [2778] = {.lex_state = 1, .external_lex_state = 2},
  [2779] = {.lex_state = 1, .external_lex_state = 2},
  [2780] = {.lex_state = 1, .external_lex_state = 2},
  [2781] = {.lex_state = 29},
  [2782] = {.lex_state = 1, .external_lex_state = 2},
  [2783] = {.lex_state = 29},
  [2784] = {.lex_state = 1, .external_lex_state = 2},
  [2785] = {.lex_state = 29},
  [2786] = {.lex_state = 29},
  [2787] = {.lex_state = 1, .external_lex_state = 2},
  [2788] = {.lex_state = 29},
  [2789] = {.lex_state = 29},
  [2790] = {.lex_state = 1, .external_lex_state = 2},
  [2791] = {.lex_state = 1, .external_lex_state = 2},
  [2792] = {.lex_state = 29},
  [2793] = {.lex_state = 29},
  [2794] = {.lex_state = 29},
  [2795] = {.lex_state = 29},
  [2796] = {.lex_state = 29},
  [2797] = {.lex_state = 29},
  [2798] = {.lex_state = 29, .external_lex_state = 2},
  [2799] = {.lex_state = 29},
  [2800] = {.lex_state = 29},
  [2801] = {.lex_state = 0},
  [2802] = {.lex_state = 29},
  [2803] = {.lex_state = 29},
  [2804] = {.lex_state = 29},
  [2805] = {.lex_state = 29},
  [2806] = {.lex_state = 29},
  [2807] = {.lex_state = 29},
  [2808] = {.lex_state = 29},
  [2809] = {.lex_state = 29},
  [2810] = {.lex_state = 29},
  [2811] = {.lex_state = 29},
  [2812] = {.lex_state = 29},
  [2813] = {.lex_state = 29},
  [2814] = {.lex_state = 29},
  [2815] = {.lex_state = 29},
  [2816] = {.lex_state = 29},
  [2817] = {.lex_state = 29},
  [2818] = {.lex_state = 29},
  [2819] = {.lex_state = 29},
  [2820] = {.lex_state = 29},
  [2821] = {.lex_state = 29},
  [2822] = {.lex_state = 29},
  [2823] = {.lex_state = 29},
  [2824] = {.lex_state = 29},
  [2825] = {.lex_state = 29},
  [2826] = {.lex_state = 29},
  [2827] = {.lex_state = 29},
  [2828] = {.lex_state = 29},
  [2829] = {.lex_state = 29},
  [2830] = {.lex_state = 29},
  [2831] = {.lex_state = 29},
  [2832] = {.lex_state = 29},
  [2833] = {.lex_state = 29},
  [2834] = {.lex_state = 29},
  [2835] = {.lex_state = 29},
  [2836] = {.lex_state = 29},
  [2837] = {.lex_state = 29},
  [2838] = {.lex_state = 29},
  [2839] = {.lex_state = 29},
  [2840] = {.lex_state = 29},
  [2841] = {.lex_state = 29, .external_lex_state = 2},
  [2842] = {.lex_state = 29},
  [2843] = {.lex_state = 29},
  [2844] = {.lex_state = 29, .external_lex_state = 2},
  [2845] = {.lex_state = 29},
  [2846] = {.lex_state = 29},
  [2847] = {.lex_state = 29},
  [2848] = {.lex_state = 29},
  [2849] = {.lex_state = 29},
  [2850] = {.lex_state = 29},
  [2851] = {.lex_state = 0},
  [2852] = {.lex_state = 29},
  [2853] = {.lex_state = 29},
  [2854] = {.lex_state = 29},
  [2855] = {.lex_state = 29},
  [2856] = {.lex_state = 29},
  [2857] = {.lex_state = 29},
  [2858] = {.lex_state = 29},
  [2859] = {.lex_state = 29},
  [2860] = {.lex_state = 29},
  [2861] = {.lex_state = 29, .external_lex_state = 2},
  [2862] = {.lex_state = 29},
  [2863] = {.lex_state = 29},
  [2864] = {.lex_state = 29},
  [2865] = {.lex_state = 29},
  [2866] = {.lex_state = 29},
  [2867] = {.lex_state = 29},
  [2868] = {.lex_state = 29},
  [2869] = {.lex_state = 29},
  [2870] = {.lex_state = 29},
  [2871] = {.lex_state = 29},
  [2872] = {.lex_state = 29},
  [2873] = {.lex_state = 29},
  [2874] = {.lex_state = 29},
  [2875] = {.lex_state = 29},
  [2876] = {.lex_state = 29},
  [2877] = {.lex_state = 29},
  [2878] = {.lex_state = 29},
  [2879] = {.lex_state = 29},
  [2880] = {.lex_state = 29},
  [2881] = {.lex_state = 29},
  [2882] = {.lex_state = 29},
  [2883] = {.lex_state = 29},
  [2884] = {.lex_state = 29},
  [2885] = {.lex_state = 29},
  [2886] = {.lex_state = 29},
  [2887] = {.lex_state = 29},
  [2888] = {.lex_state = 29},
  [2889] = {.lex_state = 29},
  [2890] = {.lex_state = 29},
  [2891] = {.lex_state = 29, .external_lex_state = 2},
  [2892] = {.lex_state = 29, .external_lex_state = 2},
  [2893] = {.lex_state = 29, .external_lex_state = 2},
  [2894] = {.lex_state = 29},
  [2895] = {.lex_state = 29, .external_lex_state = 2},
  [2896] = {.lex_state = 29},
  [2897] = {.lex_state = 29},
  [2898] = {.lex_state = 29},
  [2899] = {.lex_state = 29},
  [2900] = {.lex_state = 29},
  [2901] = {.lex_state = 29},
  [2902] = {.lex_state = 29},
  [2903] = {.lex_state = 29},
  [2904] = {.lex_state = 29},
  [2905] = {.lex_state = 29},
  [2906] = {.lex_state = 29},
  [2907] = {.lex_state = 29},
  [2908] = {.lex_state = 29},
  [2909] = {.lex_state = 29},
  [2910] = {.lex_state = 29, .external_lex_state = 2},
  [2911] = {.lex_state = 29},
  [2912] = {.lex_state = 29},
  [2913] = {.lex_state = 29},
  [2914] = {.lex_state = 29},
  [2915] = {.lex_state = 29},
  [2916] = {.lex_state = 29},
  [2917] = {.lex_state = 29},
  [2918] = {.lex_state = 29},
  [2919] = {.lex_state = 29},
  [2920] = {.lex_state = 29},
  [2921] = {.lex_state = 29},
  [2922] = {.lex_state = 29},
  [2923] = {.lex_state = 29},
  [2924] = {.lex_state = 29},
  [2925] = {.lex_state = 29},
  [2926] = {.lex_state = 29},
  [2927] = {.lex_state = 29},
  [2928] = {.lex_state = 29},
  [2929] = {.lex_state = 29},
  [2930] = {.lex_state = 29},
  [2931] = {.lex_state = 29},
  [2932] = {.lex_state = 29},
  [2933] = {.lex_state = 29},
  [2934] = {.lex_state = 29},
  [2935] = {.lex_state = 29},
  [2936] = {.lex_state = 29},
  [2937] = {.lex_state = 29},
  [2938] = {.lex_state = 29},
  [2939] = {.lex_state = 29},
  [2940] = {.lex_state = 29},
  [2941] = {.lex_state = 29},
  [2942] = {.lex_state = 29},
  [2943] = {.lex_state = 29},
  [2944] = {.lex_state = 29},
  [2945] = {.lex_state = 29},
  [2946] = {.lex_state = 29},
  [2947] = {.lex_state = 29},
  [2948] = {.lex_state = 29},
  [2949] = {.lex_state = 29},
  [2950] = {.lex_state = 29},
  [2951] = {.lex_state = 29},
  [2952] = {.lex_state = 29},
  [2953] = {.lex_state = 29},
  [2954] = {.lex_state = 29},
  [2955] = {.lex_state = 29},
  [2956] = {.lex_state = 29},
  [2957] = {.lex_state = 29},
  [2958] = {.lex_state = 29},
  [2959] = {.lex_state = 29},
  [2960] = {.lex_state = 29},
  [2961] = {.lex_state = 29},
  [2962] = {.lex_state = 29},
  [2963] = {.lex_state = 29},
  [2964] = {.lex_state = 29},
  [2965] = {.lex_state = 29},
  [2966] = {.lex_state = 29},
  [2967] = {.lex_state = 29},
  [2968] = {.lex_state = 29},
  [2969] = {.lex_state = 29},
  [2970] = {.lex_state = 29},
  [2971] = {.lex_state = 29},
  [2972] = {.lex_state = 29},
  [2973] = {.lex_state = 29},
  [2974] = {.lex_state = 29},
  [2975] = {.lex_state = 29},
  [2976] = {.lex_state = 29, .external_lex_state = 2},
  [2977] = {.lex_state = 29, .external_lex_state = 2},
  [2978] = {.lex_state = 29},
  [2979] = {.lex_state = 29},
  [2980] = {.lex_state = 29},
  [2981] = {.lex_state = 29},
  [2982] = {.lex_state = 29},
  [2983] = {.lex_state = 29},
  [2984] = {.lex_state = 29},
  [2985] = {.lex_state = 29},
  [2986] = {.lex_state = 29},
  [2987] = {.lex_state = 29},
  [2988] = {.lex_state = 29},
  [2989] = {.lex_state = 29},
  [2990] = {.lex_state = 29},
  [2991] = {.lex_state = 29},
  [2992] = {.lex_state = 29},
  [2993] = {.lex_state = 29},
  [2994] = {.lex_state = 29},
  [2995] = {.lex_state = 29},
  [2996] = {.lex_state = 29},
  [2997] = {.lex_state = 29},
  [2998] = {.lex_state = 29},
  [2999] = {.lex_state = 29},
  [3000] = {.lex_state = 29},
  [3001] = {.lex_state = 29},
  [3002] = {.lex_state = 29},
  [3003] = {.lex_state = 29},
  [3004] = {.lex_state = 29, .external_lex_state = 2},
  [3005] = {.lex_state = 29},
  [3006] = {.lex_state = 29},
  [3007] = {.lex_state = 29},
  [3008] = {.lex_state = 29},
  [3009] = {.lex_state = 29},
  [3010] = {.lex_state = 29},
  [3011] = {.lex_state = 29},
  [3012] = {.lex_state = 29},
  [3013] = {.lex_state = 29},
  [3014] = {.lex_state = 29},
  [3015] = {.lex_state = 29},
  [3016] = {.lex_state = 29},
  [3017] = {.lex_state = 29},
  [3018] = {.lex_state = 29},
  [3019] = {.lex_state = 29},
  [3020] = {.lex_state = 29},
  [3021] = {.lex_state = 29},
  [3022] = {.lex_state = 29},
  [3023] = {.lex_state = 29},
  [3024] = {.lex_state = 29},
  [3025] = {.lex_state = 29},
  [3026] = {.lex_state = 29},
  [3027] = {.lex_state = 29},
  [3028] = {.lex_state = 29},
  [3029] = {.lex_state = 29},
  [3030] = {.lex_state = 29},
  [3031] = {.lex_state = 29},
  [3032] = {.lex_state = 29},
  [3033] = {.lex_state = 29},
  [3034] = {.lex_state = 29},
  [3035] = {.lex_state = 29},
  [3036] = {.lex_state = 29},
  [3037] = {.lex_state = 29},
  [3038] = {.lex_state = 29},
  [3039] = {.lex_state = 29},
  [3040] = {.lex_state = 29, .external_lex_state = 2},
  [3041] = {.lex_state = 29},
  [3042] = {.lex_state = 29},
  [3043] = {.lex_state = 29},
  [3044] = {.lex_state = 29},
  [3045] = {.lex_state = 29},
  [3046] = {.lex_state = 29},
  [3047] = {.lex_state = 29},
  [3048] = {.lex_state = 29},
  [3049] = {.lex_state = 29},
  [3050] = {.lex_state = 29},
  [3051] = {.lex_state = 29},
  [3052] = {.lex_state = 29},
  [3053] = {.lex_state = 29},
  [3054] = {.lex_state = 29},
  [3055] = {.lex_state = 29},
  [3056] = {.lex_state = 29},
  [3057] = {.lex_state = 29},
  [3058] = {.lex_state = 29},
  [3059] = {.lex_state = 29},
  [3060] = {.lex_state = 29},
  [3061] = {.lex_state = 29},
  [3062] = {.lex_state = 29},
  [3063] = {.lex_state = 29},
  [3064] = {.lex_state = 29},
  [3065] = {.lex_state = 29},
  [3066] = {.lex_state = 29},
  [3067] = {.lex_state = 29},
  [3068] = {.lex_state = 29},
  [3069] = {.lex_state = 29},
  [3070] = {.lex_state = 29},
  [3071] = {.lex_state = 29},
  [3072] = {.lex_state = 29},
  [3073] = {.lex_state = 29},
  [3074] = {.lex_state = 29},
  [3075] = {.lex_state = 29},
  [3076] = {.lex_state = 29},
  [3077] = {.lex_state = 29},
  [3078] = {.lex_state = 29},
  [3079] = {.lex_state = 29},
  [3080] = {.lex_state = 29, .external_lex_state = 2},
  [3081] = {.lex_state = 29, .external_lex_state = 2},
  [3082] = {.lex_state = 29, .external_lex_state = 2},
  [3083] = {.lex_state = 29, .external_lex_state = 2},
  [3084] = {.lex_state = 29},
  [3085] = {.lex_state = 29},
  [3086] = {.lex_state = 29},
  [3087] = {.lex_state = 29},
  [3088] = {.lex_state = 29},
  [3089] = {.lex_state = 29},
  [3090] = {.lex_state = 29},
  [3091] = {.lex_state = 29},
  [3092] = {.lex_state = 29},
  [3093] = {.lex_state = 29},
  [3094] = {.lex_state = 29},
  [3095] = {.lex_state = 29},
  [3096] = {.lex_state = 29},
  [3097] = {.lex_state = 29},
  [3098] = {.lex_state = 29},
  [3099] = {.lex_state = 29},
  [3100] = {.lex_state = 29},
  [3101] = {.lex_state = 29},
  [3102] = {.lex_state = 29},
  [3103] = {.lex_state = 29},
  [3104] = {.lex_state = 29},
  [3105] = {.lex_state = 29},
  [3106] = {.lex_state = 29},
  [3107] = {.lex_state = 29},
  [3108] = {.lex_state = 29},
  [3109] = {.lex_state = 29},
  [3110] = {.lex_state = 29},
  [3111] = {.lex_state = 29},
  [3112] = {.lex_state = 29},
  [3113] = {.lex_state = 29},
  [3114] = {.lex_state = 29},
  [3115] = {.lex_state = 29},
  [3116] = {.lex_state = 29},
  [3117] = {.lex_state = 29, .external_lex_state = 2},
  [3118] = {.lex_state = 1, .external_lex_state = 2},
  [3119] = {.lex_state = 1, .external_lex_state = 2},
  [3120] = {.lex_state = 1, .external_lex_state = 2},
  [3121] = {.lex_state = 1, .external_lex_state = 2},
  [3122] = {.lex_state = 1, .external_lex_state = 2},
  [3123] = {.lex_state = 29},
  [3124] = {.lex_state = 29},
  [3125] = {.lex_state = 29},
  [3126] = {.lex_state = 1, .external_lex_state = 2},
  [3127] = {.lex_state = 29},
  [3128] = {.lex_state = 29},
  [3129] = {.lex_state = 29},
  [3130] = {.lex_state = 29},
  [3131] = {.lex_state = 29},
  [3132] = {.lex_state = 29},
  [3133] = {.lex_state = 29},
  [3134] = {.lex_state = 1, .external_lex_state = 2},
  [3135] = {.lex_state = 29},
  [3136] = {.lex_state = 29},
  [3137] = {.lex_state = 29},
  [3138] = {.lex_state = 29},
  [3139] = {.lex_state = 29},
  [3140] = {.lex_state = 29},
  [3141] = {.lex_state = 1, .external_lex_state = 2},
  [3142] = {.lex_state = 29},
  [3143] = {.lex_state = 29},
  [3144] = {.lex_state = 29},
  [3145] = {.lex_state = 29},
  [3146] = {.lex_state = 29},
  [3147] = {.lex_state = 29},
  [3148] = {.lex_state = 29},
  [3149] = {.lex_state = 29},
  [3150] = {.lex_state = 29},
  [3151] = {.lex_state = 29},
  [3152] = {.lex_state = 29},
  [3153] = {.lex_state = 29},
  [3154] = {.lex_state = 1, .external_lex_state = 2},
  [3155] = {.lex_state = 1, .external_lex_state = 2},
  [3156] = {.lex_state = 0},
  [3157] = {.lex_state = 29},
  [3158] = {.lex_state = 29},
  [3159] = {.lex_state = 29},
  [3160] = {.lex_state = 29},
  [3161] = {.lex_state = 29},
  [3162] = {.lex_state = 29},
  [3163] = {.lex_state = 29},
  [3164] = {.lex_state = 1, .external_lex_state = 2},
  [3165] = {.lex_state = 29},
  [3166] = {.lex_state = 29},
  [3167] = {.lex_state = 1, .external_lex_state = 2},
  [3168] = {.lex_state = 1, .external_lex_state = 2},
  [3169] = {.lex_state = 1, .external_lex_state = 2},
  [3170] = {.lex_state = 1, .external_lex_state = 2},
  [3171] = {.lex_state = 1, .external_lex_state = 2},
  [3172] = {.lex_state = 1, .external_lex_state = 2},
  [3173] = {.lex_state = 1, .external_lex_state = 2},
  [3174] = {.lex_state = 29},
  [3175] = {.lex_state = 1, .external_lex_state = 2},
  [3176] = {.lex_state = 1, .external_lex_state = 2},
  [3177] = {.lex_state = 1, .external_lex_state = 2},
  [3178] = {.lex_state = 29},
  [3179] = {.lex_state = 1, .external_lex_state = 2},
  [3180] = {.lex_state = 1, .external_lex_state = 2},
  [3181] = {.lex_state = 1, .external_lex_state = 2},
  [3182] = {.lex_state = 1, .external_lex_state = 2},
  [3183] = {.lex_state = 1, .external_lex_state = 2},
  [3184] = {.lex_state = 1, .external_lex_state = 2},
  [3185] = {.lex_state = 1, .external_lex_state = 2},
  [3186] = {.lex_state = 1, .external_lex_state = 2},
  [3187] = {.lex_state = 29},
  [3188] = {.lex_state = 1, .external_lex_state = 2},
  [3189] = {.lex_state = 29},
  [3190] = {.lex_state = 1, .external_lex_state = 2},
  [3191] = {.lex_state = 1, .external_lex_state = 2},
  [3192] = {.lex_state = 1, .external_lex_state = 2},
  [3193] = {.lex_state = 1, .external_lex_state = 2},
  [3194] = {.lex_state = 1, .external_lex_state = 2},
  [3195] = {.lex_state = 29},
  [3196] = {.lex_state = 29, .external_lex_state = 2},
  [3197] = {.lex_state = 1, .external_lex_state = 2},
  [3198] = {.lex_state = 29},
  [3199] = {.lex_state = 1, .external_lex_state = 2},
  [3200] = {.lex_state = 29},
  [3201] = {.lex_state = 1, .external_lex_state = 2},
  [3202] = {.lex_state = 1, .external_lex_state = 2},
  [3203] = {.lex_state = 1, .external_lex_state = 2},
  [3204] = {.lex_state = 1, .external_lex_state = 2},
  [3205] = {.lex_state = 1, .external_lex_state = 2},
  [3206] = {.lex_state = 1, .external_lex_state = 2},
  [3207] = {.lex_state = 1, .external_lex_state = 2},
  [3208] = {.lex_state = 1, .external_lex_state = 2},
  [3209] = {.lex_state = 1, .external_lex_state = 2},
  [3210] = {.lex_state = 1, .external_lex_state = 2},
  [3211] = {.lex_state = 1, .external_lex_state = 2},
  [3212] = {.lex_state = 1, .external_lex_state = 2},
  [3213] = {.lex_state = 0},
  [3214] = {.lex_state = 29},
  [3215] = {.lex_state = 29},
  [3216] = {.lex_state = 29},
  [3217] = {.lex_state = 29},
  [3218] = {.lex_state = 29},
  [3219] = {.lex_state = 1, .external_lex_state = 2},
  [3220] = {.lex_state = 1, .external_lex_state = 2},
  [3221] = {.lex_state = 29},
  [3222] = {.lex_state = 1, .external_lex_state = 2},
  [3223] = {.lex_state = 1, .external_lex_state = 2},
  [3224] = {.lex_state = 1, .external_lex_state = 2},
  [3225] = {.lex_state = 1, .external_lex_state = 2},
  [3226] = {.lex_state = 1, .external_lex_state = 2},
  [3227] = {.lex_state = 1, .external_lex_state = 2},
  [3228] = {.lex_state = 29},
  [3229] = {.lex_state = 29},
  [3230] = {.lex_state = 1, .external_lex_state = 2},
  [3231] = {.lex_state = 29},
  [3232] = {.lex_state = 29},
  [3233] = {.lex_state = 29},
  [3234] = {.lex_state = 29},
  [3235] = {.lex_state = 1, .external_lex_state = 2},
  [3236] = {.lex_state = 1, .external_lex_state = 2},
  [3237] = {.lex_state = 29},
  [3238] = {.lex_state = 29},
  [3239] = {.lex_state = 1, .external_lex_state = 2},
  [3240] = {.lex_state = 1, .external_lex_state = 2},
  [3241] = {.lex_state = 29},
  [3242] = {.lex_state = 29},
  [3243] = {.lex_state = 1, .external_lex_state = 2},
  [3244] = {.lex_state = 1, .external_lex_state = 2},
  [3245] = {.lex_state = 29},
  [3246] = {.lex_state = 29},
  [3247] = {.lex_state = 1, .external_lex_state = 2},
  [3248] = {.lex_state = 1, .external_lex_state = 2},
  [3249] = {.lex_state = 29},
  [3250] = {.lex_state = 1, .external_lex_state = 2},
  [3251] = {.lex_state = 1, .external_lex_state = 2},
  [3252] = {.lex_state = 1, .external_lex_state = 2},
  [3253] = {.lex_state = 1, .external_lex_state = 2},
  [3254] = {.lex_state = 1, .external_lex_state = 2},
  [3255] = {.lex_state = 1, .external_lex_state = 2},
  [3256] = {.lex_state = 29},
  [3257] = {.lex_state = 29},
  [3258] = {.lex_state = 29},
  [3259] = {.lex_state = 1, .external_lex_state = 2},
  [3260] = {.lex_state = 1, .external_lex_state = 2},
  [3261] = {.lex_state = 1, .external_lex_state = 2},
  [3262] = {.lex_state = 1, .external_lex_state = 2},
  [3263] = {.lex_state = 29},
  [3264] = {.lex_state = 1, .external_lex_state = 2},
  [3265] = {.lex_state = 1, .external_lex_state = 2},
  [3266] = {.lex_state = 1, .external_lex_state = 2},
  [3267] = {.lex_state = 1, .external_lex_state = 2},
  [3268] = {.lex_state = 29, .external_lex_state = 2},
  [3269] = {.lex_state = 1, .external_lex_state = 2},
  [3270] = {.lex_state = 1, .external_lex_state = 2},
  [3271] = {.lex_state = 1, .external_lex_state = 2},
  [3272] = {.lex_state = 1, .external_lex_state = 2},
  [3273] = {.lex_state = 1, .external_lex_state = 2},
  [3274] = {.lex_state = 1, .external_lex_state = 2},
  [3275] = {.lex_state = 1, .external_lex_state = 2},
  [3276] = {.lex_state = 1, .external_lex_state = 2},
  [3277] = {.lex_state = 1, .external_lex_state = 2},
  [3278] = {.lex_state = 29},
  [3279] = {.lex_state = 29},
  [3280] = {.lex_state = 29},
  [3281] = {.lex_state = 1, .external_lex_state = 2},
  [3282] = {.lex_state = 1, .external_lex_state = 2},
  [3283] = {.lex_state = 29},
  [3284] = {.lex_state = 1, .external_lex_state = 2},
  [3285] = {.lex_state = 1, .external_lex_state = 2},
  [3286] = {.lex_state = 1, .external_lex_state = 2},
  [3287] = {.lex_state = 1, .external_lex_state = 2},
  [3288] = {.lex_state = 29},
  [3289] = {.lex_state = 1, .external_lex_state = 2},
  [3290] = {.lex_state = 1, .external_lex_state = 2},
  [3291] = {.lex_state = 29},
  [3292] = {.lex_state = 29},
  [3293] = {.lex_state = 1, .external_lex_state = 2},
  [3294] = {.lex_state = 29},
  [3295] = {.lex_state = 29},
  [3296] = {.lex_state = 1, .external_lex_state = 2},
  [3297] = {.lex_state = 1, .external_lex_state = 2},
  [3298] = {.lex_state = 29},
  [3299] = {.lex_state = 29},
  [3300] = {.lex_state = 29},
  [3301] = {.lex_state = 29},
  [3302] = {.lex_state = 29},
  [3303] = {.lex_state = 29},
  [3304] = {.lex_state = 1, .external_lex_state = 2},
  [3305] = {.lex_state = 29},
  [3306] = {.lex_state = 29},
  [3307] = {.lex_state = 29},
  [3308] = {.lex_state = 29},
  [3309] = {.lex_state = 1, .external_lex_state = 2},
  [3310] = {.lex_state = 29},
  [3311] = {.lex_state = 29},
  [3312] = {.lex_state = 29},
  [3313] = {.lex_state = 29},
  [3314] = {.lex_state = 1, .external_lex_state = 2},
  [3315] = {.lex_state = 29},
  [3316] = {.lex_state = 29},
  [3317] = {.lex_state = 29},
  [3318] = {.lex_state = 29},
  [3319] = {.lex_state = 29},
  [3320] = {.lex_state = 29},
  [3321] = {.lex_state = 1, .external_lex_state = 2},
  [3322] = {.lex_state = 29},
  [3323] = {.lex_state = 29},
  [3324] = {.lex_state = 29},
  [3325] = {.lex_state = 29},
  [3326] = {.lex_state = 29},
  [3327] = {.lex_state = 29},
  [3328] = {.lex_state = 29},
  [3329] = {.lex_state = 29},
  [3330] = {.lex_state = 29},
  [3331] = {.lex_state = 1, .external_lex_state = 2},
  [3332] = {.lex_state = 29},
  [3333] = {.lex_state = 29},
  [3334] = {.lex_state = 29},
  [3335] = {.lex_state = 29},
  [3336] = {.lex_state = 29},
  [3337] = {.lex_state = 29},
  [3338] = {.lex_state = 1, .external_lex_state = 2},
  [3339] = {.lex_state = 29},
  [3340] = {.lex_state = 29},
  [3341] = {.lex_state = 29},
  [3342] = {.lex_state = 29},
  [3343] = {.lex_state = 29},
  [3344] = {.lex_state = 29},
  [3345] = {.lex_state = 29},
  [3346] = {.lex_state = 1, .external_lex_state = 2},
  [3347] = {.lex_state = 29},
  [3348] = {.lex_state = 1, .external_lex_state = 2},
  [3349] = {.lex_state = 29},
  [3350] = {.lex_state = 1, .external_lex_state = 2},
  [3351] = {.lex_state = 1, .external_lex_state = 2},
  [3352] = {.lex_state = 1, .external_lex_state = 2},
  [3353] = {.lex_state = 1, .external_lex_state = 2},
  [3354] = {.lex_state = 29},
  [3355] = {.lex_state = 29},
  [3356] = {.lex_state = 29},
  [3357] = {.lex_state = 29},
  [3358] = {.lex_state = 29},
  [3359] = {.lex_state = 29},
  [3360] = {.lex_state = 1, .external_lex_state = 2},
  [3361] = {.lex_state = 29},
  [3362] = {.lex_state = 29},
  [3363] = {.lex_state = 29},
  [3364] = {.lex_state = 29},
  [3365] = {.lex_state = 29},
  [3366] = {.lex_state = 29},
  [3367] = {.lex_state = 29},
  [3368] = {.lex_state = 29},
  [3369] = {.lex_state = 29},
  [3370] = {.lex_state = 29},
  [3371] = {.lex_state = 29},
  [3372] = {.lex_state = 29},
  [3373] = {.lex_state = 29},
  [3374] = {.lex_state = 29},
  [3375] = {.lex_state = 29},
  [3376] = {.lex_state = 29},
  [3377] = {.lex_state = 29},
  [3378] = {.lex_state = 1, .external_lex_state = 2},
  [3379] = {.lex_state = 29},
  [3380] = {.lex_state = 29},
  [3381] = {.lex_state = 29},
  [3382] = {.lex_state = 29},
  [3383] = {.lex_state = 29},
  [3384] = {.lex_state = 29},
  [3385] = {.lex_state = 29},
  [3386] = {.lex_state = 29},
  [3387] = {.lex_state = 29},
  [3388] = {.lex_state = 29},
  [3389] = {.lex_state = 29},
  [3390] = {.lex_state = 29},
  [3391] = {.lex_state = 1, .external_lex_state = 2},
  [3392] = {.lex_state = 1, .external_lex_state = 2},
  [3393] = {.lex_state = 1, .external_lex_state = 2},
  [3394] = {.lex_state = 29},
  [3395] = {.lex_state = 29},
  [3396] = {.lex_state = 29},
  [3397] = {.lex_state = 29},
  [3398] = {.lex_state = 29},
  [3399] = {.lex_state = 29},
  [3400] = {.lex_state = 29},
  [3401] = {.lex_state = 29},
  [3402] = {.lex_state = 29},
  [3403] = {.lex_state = 29},
  [3404] = {.lex_state = 29},
  [3405] = {.lex_state = 1, .external_lex_state = 2},
  [3406] = {.lex_state = 29},
  [3407] = {.lex_state = 29},
  [3408] = {.lex_state = 29},
  [3409] = {.lex_state = 29},
  [3410] = {.lex_state = 1, .external_lex_state = 2},
  [3411] = {.lex_state = 1, .external_lex_state = 2},
  [3412] = {.lex_state = 29},
  [3413] = {.lex_state = 29},
  [3414] = {.lex_state = 29},
  [3415] = {.lex_state = 29},
  [3416] = {.lex_state = 29},
  [3417] = {.lex_state = 29},
  [3418] = {.lex_state = 29},
  [3419] = {.lex_state = 29},
  [3420] = {.lex_state = 29},
  [3421] = {.lex_state = 29},
  [3422] = {.lex_state = 29},
  [3423] = {.lex_state = 0},
  [3424] = {.lex_state = 29},
  [3425] = {.lex_state = 29},
  [3426] = {.lex_state = 29},
  [3427] = {.lex_state = 29},
  [3428] = {.lex_state = 29},
  [3429] = {.lex_state = 29},
  [3430] = {.lex_state = 29, .external_lex_state = 2},
  [3431] = {.lex_state = 29},
  [3432] = {.lex_state = 29},
  [3433] = {.lex_state = 29},
  [3434] = {.lex_state = 29},
  [3435] = {.lex_state = 29},
  [3436] = {.lex_state = 29},
  [3437] = {.lex_state = 29},
  [3438] = {.lex_state = 29},
  [3439] = {.lex_state = 29},
  [3440] = {.lex_state = 29},
  [3441] = {.lex_state = 29},
  [3442] = {.lex_state = 29},
  [3443] = {.lex_state = 29},
  [3444] = {.lex_state = 29},
  [3445] = {.lex_state = 29},
  [3446] = {.lex_state = 29},
  [3447] = {.lex_state = 29},
  [3448] = {.lex_state = 29},
  [3449] = {.lex_state = 0},
  [3450] = {.lex_state = 29},
  [3451] = {.lex_state = 29},
  [3452] = {.lex_state = 29},
  [3453] = {.lex_state = 29},
  [3454] = {.lex_state = 29},
  [3455] = {.lex_state = 29},
  [3456] = {.lex_state = 29},
  [3457] = {.lex_state = 29},
  [3458] = {.lex_state = 29},
  [3459] = {.lex_state = 29},
  [3460] = {.lex_state = 29},
  [3461] = {.lex_state = 29},
  [3462] = {.lex_state = 29},
  [3463] = {.lex_state = 29},
  [3464] = {.lex_state = 29},
  [3465] = {.lex_state = 29},
  [3466] = {.lex_state = 29},
  [3467] = {.lex_state = 29},
  [3468] = {.lex_state = 29},
  [3469] = {.lex_state = 29},
  [3470] = {.lex_state = 29},
  [3471] = {.lex_state = 29, .external_lex_state = 2},
  [3472] = {.lex_state = 29},
  [3473] = {.lex_state = 29},
  [3474] = {.lex_state = 29, .external_lex_state = 2},
  [3475] = {.lex_state = 29},
  [3476] = {.lex_state = 29},
  [3477] = {.lex_state = 29},
  [3478] = {.lex_state = 29},
  [3479] = {.lex_state = 29},
  [3480] = {.lex_state = 29},
  [3481] = {.lex_state = 29},
  [3482] = {.lex_state = 29},
  [3483] = {.lex_state = 29},
  [3484] = {.lex_state = 29},
  [3485] = {.lex_state = 29, .external_lex_state = 2},
  [3486] = {.lex_state = 29, .external_lex_state = 2},
  [3487] = {.lex_state = 29, .external_lex_state = 2},
  [3488] = {.lex_state = 29},
  [3489] = {.lex_state = 29},
  [3490] = {.lex_state = 29},
  [3491] = {.lex_state = 0},
  [3492] = {.lex_state = 0},
  [3493] = {.lex_state = 29},
  [3494] = {.lex_state = 29},
  [3495] = {.lex_state = 29},
  [3496] = {.lex_state = 29},
  [3497] = {.lex_state = 29},
  [3498] = {.lex_state = 29},
  [3499] = {.lex_state = 29},
  [3500] = {.lex_state = 29},
  [3501] = {.lex_state = 29},
  [3502] = {.lex_state = 29},
  [3503] = {.lex_state = 29},
  [3504] = {.lex_state = 29},
  [3505] = {.lex_state = 29},
  [3506] = {.lex_state = 29},
  [3507] = {.lex_state = 29},
  [3508] = {.lex_state = 29},
  [3509] = {.lex_state = 29},
  [3510] = {.lex_state = 29},
  [3511] = {.lex_state = 29},
  [3512] = {.lex_state = 29},
  [3513] = {.lex_state = 29},
  [3514] = {.lex_state = 29},
  [3515] = {.lex_state = 29},
  [3516] = {.lex_state = 29},
  [3517] = {.lex_state = 29},
  [3518] = {.lex_state = 29},
  [3519] = {.lex_state = 29},
  [3520] = {.lex_state = 29},
  [3521] = {.lex_state = 29},
  [3522] = {.lex_state = 29},
  [3523] = {.lex_state = 29},
  [3524] = {.lex_state = 29},
  [3525] = {.lex_state = 29},
  [3526] = {.lex_state = 29},
  [3527] = {.lex_state = 29},
  [3528] = {.lex_state = 29},
  [3529] = {.lex_state = 29},
  [3530] = {.lex_state = 29},
  [3531] = {.lex_state = 29},
  [3532] = {.lex_state = 29},
  [3533] = {.lex_state = 29},
  [3534] = {.lex_state = 29},
  [3535] = {.lex_state = 29},
  [3536] = {.lex_state = 29},
  [3537] = {.lex_state = 29},
  [3538] = {.lex_state = 29},
  [3539] = {.lex_state = 29},
  [3540] = {.lex_state = 29},
  [3541] = {.lex_state = 29},
  [3542] = {.lex_state = 29},
  [3543] = {.lex_state = 29},
  [3544] = {.lex_state = 29},
  [3545] = {.lex_state = 29},
  [3546] = {.lex_state = 29},
  [3547] = {.lex_state = 29},
  [3548] = {.lex_state = 29},
  [3549] = {.lex_state = 29},
  [3550] = {.lex_state = 29},
  [3551] = {.lex_state = 29},
  [3552] = {.lex_state = 29},
  [3553] = {.lex_state = 29},
  [3554] = {.lex_state = 29},
  [3555] = {.lex_state = 29},
  [3556] = {.lex_state = 29},
  [3557] = {.lex_state = 29},
  [3558] = {.lex_state = 29},
  [3559] = {.lex_state = 29},
  [3560] = {.lex_state = 29},
  [3561] = {.lex_state = 29},
  [3562] = {.lex_state = 29},
  [3563] = {.lex_state = 29},
  [3564] = {.lex_state = 29},
  [3565] = {.lex_state = 29},
  [3566] = {.lex_state = 29},
  [3567] = {.lex_state = 29},
  [3568] = {.lex_state = 29},
  [3569] = {.lex_state = 29},
  [3570] = {.lex_state = 29},
  [3571] = {.lex_state = 29},
  [3572] = {.lex_state = 29},
  [3573] = {.lex_state = 29},
  [3574] = {.lex_state = 29},
  [3575] = {.lex_state = 29},
  [3576] = {.lex_state = 29},
  [3577] = {.lex_state = 29},
  [3578] = {.lex_state = 29},
  [3579] = {.lex_state = 29},
  [3580] = {.lex_state = 29},
  [3581] = {.lex_state = 29},
  [3582] = {.lex_state = 29},
  [3583] = {.lex_state = 29},
  [3584] = {.lex_state = 29},
  [3585] = {.lex_state = 29},
  [3586] = {.lex_state = 29},
  [3587] = {.lex_state = 29},
  [3588] = {.lex_state = 29},
  [3589] = {.lex_state = 29},
  [3590] = {.lex_state = 29},
  [3591] = {.lex_state = 29},
  [3592] = {.lex_state = 29},
  [3593] = {.lex_state = 29},
  [3594] = {.lex_state = 29},
  [3595] = {.lex_state = 29},
  [3596] = {.lex_state = 29},
  [3597] = {.lex_state = 29},
  [3598] = {.lex_state = 29},
  [3599] = {.lex_state = 29},
  [3600] = {.lex_state = 29},
  [3601] = {.lex_state = 29},
  [3602] = {.lex_state = 29},
  [3603] = {.lex_state = 29},
  [3604] = {.lex_state = 29},
  [3605] = {.lex_state = 29},
  [3606] = {.lex_state = 29},
  [3607] = {.lex_state = 29},
  [3608] = {.lex_state = 29},
  [3609] = {.lex_state = 29},
  [3610] = {.lex_state = 29},
  [3611] = {.lex_state = 29},
  [3612] = {.lex_state = 29},
  [3613] = {.lex_state = 29},
  [3614] = {.lex_state = 29},
  [3615] = {.lex_state = 29},
  [3616] = {.lex_state = 29},
  [3617] = {.lex_state = 29},
  [3618] = {.lex_state = 29},
  [3619] = {.lex_state = 29},
  [3620] = {.lex_state = 29},
  [3621] = {.lex_state = 29},
  [3622] = {.lex_state = 29},
  [3623] = {.lex_state = 29},
  [3624] = {.lex_state = 29},
  [3625] = {.lex_state = 29},
  [3626] = {.lex_state = 29},
  [3627] = {.lex_state = 29},
  [3628] = {.lex_state = 29},
  [3629] = {.lex_state = 29},
  [3630] = {.lex_state = 29},
  [3631] = {.lex_state = 29},
  [3632] = {.lex_state = 29},
  [3633] = {.lex_state = 29},
  [3634] = {.lex_state = 29},
  [3635] = {.lex_state = 29},
  [3636] = {.lex_state = 29},
  [3637] = {.lex_state = 29},
  [3638] = {.lex_state = 29},
  [3639] = {.lex_state = 29},
  [3640] = {.lex_state = 29},
  [3641] = {.lex_state = 29},
  [3642] = {.lex_state = 29},
  [3643] = {.lex_state = 29},
  [3644] = {.lex_state = 29, .external_lex_state = 2},
  [3645] = {.lex_state = 0},
  [3646] = {.lex_state = 0},
  [3647] = {.lex_state = 29},
  [3648] = {.lex_state = 29},
  [3649] = {.lex_state = 29},
  [3650] = {.lex_state = 29},
  [3651] = {.lex_state = 29},
  [3652] = {.lex_state = 29},
  [3653] = {.lex_state = 29},
  [3654] = {.lex_state = 29},
  [3655] = {.lex_state = 29},
  [3656] = {.lex_state = 29},
  [3657] = {.lex_state = 29},
  [3658] = {.lex_state = 29},
  [3659] = {.lex_state = 29},
  [3660] = {.lex_state = 29},
  [3661] = {.lex_state = 29},
  [3662] = {.lex_state = 29},
  [3663] = {.lex_state = 29},
  [3664] = {.lex_state = 29},
  [3665] = {.lex_state = 29},
  [3666] = {.lex_state = 29},
  [3667] = {.lex_state = 29},
  [3668] = {.lex_state = 29},
  [3669] = {.lex_state = 29},
  [3670] = {.lex_state = 29},
  [3671] = {.lex_state = 29},
  [3672] = {.lex_state = 29},
  [3673] = {.lex_state = 29, .external_lex_state = 2},
  [3674] = {.lex_state = 29},
  [3675] = {.lex_state = 29},
  [3676] = {.lex_state = 29},
  [3677] = {.lex_state = 29},
  [3678] = {.lex_state = 29},
  [3679] = {.lex_state = 29},
  [3680] = {.lex_state = 29},
  [3681] = {.lex_state = 29},
  [3682] = {.lex_state = 0},
  [3683] = {.lex_state = 29},
  [3684] = {.lex_state = 29},
  [3685] = {.lex_state = 29},
  [3686] = {.lex_state = 29},
  [3687] = {.lex_state = 29},
  [3688] = {.lex_state = 29},
  [3689] = {.lex_state = 29},
  [3690] = {.lex_state = 29},
  [3691] = {.lex_state = 29},
  [3692] = {.lex_state = 0},
  [3693] = {.lex_state = 29},
  [3694] = {.lex_state = 29},
  [3695] = {.lex_state = 29},
  [3696] = {.lex_state = 29},
  [3697] = {.lex_state = 29},
  [3698] = {.lex_state = 0},
  [3699] = {.lex_state = 0},
  [3700] = {.lex_state = 29},
  [3701] = {.lex_state = 0},
  [3702] = {.lex_state = 29},
  [3703] = {.lex_state = 29},
  [3704] = {.lex_state = 29},
  [3705] = {.lex_state = 29},
  [3706] = {.lex_state = 29},
  [3707] = {.lex_state = 29, .external_lex_state = 2},
  [3708] = {.lex_state = 0},
  [3709] = {.lex_state = 29, .external_lex_state = 2},
  [3710] = {.lex_state = 0},
  [3711] = {.lex_state = 29, .external_lex_state = 2},
  [3712] = {.lex_state = 29},
  [3713] = {.lex_state = 29},
  [3714] = {.lex_state = 0},
  [3715] = {.lex_state = 29},
  [3716] = {.lex_state = 29, .external_lex_state = 2},
  [3717] = {.lex_state = 29},
  [3718] = {.lex_state = 29},
  [3719] = {.lex_state = 0},
  [3720] = {.lex_state = 29},
  [3721] = {.lex_state = 29},
  [3722] = {.lex_state = 0},
  [3723] = {.lex_state = 0},
  [3724] = {.lex_state = 0},
  [3725] = {.lex_state = 29},
  [3726] = {.lex_state = 29},
  [3727] = {.lex_state = 0},
  [3728] = {.lex_state = 29},
  [3729] = {.lex_state = 29},
  [3730] = {.lex_state = 29},
  [3731] = {.lex_state = 0},
  [3732] = {.lex_state = 29},
  [3733] = {.lex_state = 29},
  [3734] = {.lex_state = 29},
  [3735] = {.lex_state = 29},
  [3736] = {.lex_state = 29},
  [3737] = {.lex_state = 29},
  [3738] = {.lex_state = 29},
  [3739] = {.lex_state = 0},
  [3740] = {.lex_state = 29},
  [3741] = {.lex_state = 29},
  [3742] = {.lex_state = 29},
  [3743] = {.lex_state = 0},
  [3744] = {.lex_state = 29},
  [3745] = {.lex_state = 29, .external_lex_state = 2},
  [3746] = {.lex_state = 29, .external_lex_state = 2},
  [3747] = {.lex_state = 29},
  [3748] = {.lex_state = 29, .external_lex_state = 2},
  [3749] = {.lex_state = 0},
  [3750] = {.lex_state = 29},
  [3751] = {.lex_state = 29, .external_lex_state = 2},
  [3752] = {.lex_state = 0},
  [3753] = {.lex_state = 29},
  [3754] = {.lex_state = 29},
  [3755] = {.lex_state = 0},
  [3756] = {.lex_state = 0},
  [3757] = {.lex_state = 29},
  [3758] = {.lex_state = 29},
  [3759] = {.lex_state = 29},
  [3760] = {.lex_state = 29},
  [3761] = {.lex_state = 29, .external_lex_state = 2},
  [3762] = {.lex_state = 29},
  [3763] = {.lex_state = 29},
  [3764] = {.lex_state = 29},
  [3765] = {.lex_state = 29},
  [3766] = {.lex_state = 29},
  [3767] = {.lex_state = 29, .external_lex_state = 2},
  [3768] = {.lex_state = 29},
  [3769] = {.lex_state = 29},
  [3770] = {.lex_state = 29},
  [3771] = {.lex_state = 29},
  [3772] = {.lex_state = 29},
  [3773] = {.lex_state = 29},
  [3774] = {.lex_state = 29},
  [3775] = {.lex_state = 29},
  [3776] = {.lex_state = 29},
  [3777] = {.lex_state = 29},
  [3778] = {.lex_state = 29},
  [3779] = {.lex_state = 29},
  [3780] = {.lex_state = 29},
  [3781] = {.lex_state = 29},
  [3782] = {.lex_state = 29},
  [3783] = {.lex_state = 29},
  [3784] = {.lex_state = 29},
  [3785] = {.lex_state = 29},
  [3786] = {.lex_state = 29},
  [3787] = {.lex_state = 29},
  [3788] = {.lex_state = 29},
  [3789] = {.lex_state = 29},
  [3790] = {.lex_state = 29},
  [3791] = {.lex_state = 29},
  [3792] = {.lex_state = 29},
  [3793] = {.lex_state = 29},
  [3794] = {.lex_state = 29},
  [3795] = {.lex_state = 29},
  [3796] = {.lex_state = 29},
  [3797] = {.lex_state = 29},
  [3798] = {.lex_state = 29},
  [3799] = {.lex_state = 29},
  [3800] = {.lex_state = 29},
  [3801] = {.lex_state = 29},
  [3802] = {.lex_state = 29},
  [3803] = {.lex_state = 29},
  [3804] = {.lex_state = 29},
  [3805] = {.lex_state = 29},
  [3806] = {.lex_state = 29},
  [3807] = {.lex_state = 29},
  [3808] = {.lex_state = 29},
  [3809] = {.lex_state = 29},
  [3810] = {.lex_state = 29},
  [3811] = {.lex_state = 29},
  [3812] = {.lex_state = 29},
  [3813] = {.lex_state = 29},
  [3814] = {.lex_state = 29},
  [3815] = {.lex_state = 29},
  [3816] = {.lex_state = 29},
  [3817] = {.lex_state = 29},
  [3818] = {.lex_state = 29},
  [3819] = {.lex_state = 29},
  [3820] = {.lex_state = 29},
  [3821] = {.lex_state = 29},
  [3822] = {.lex_state = 29},
  [3823] = {.lex_state = 29},
  [3824] = {.lex_state = 29},
  [3825] = {.lex_state = 29},
  [3826] = {.lex_state = 29},
  [3827] = {.lex_state = 29},
  [3828] = {.lex_state = 29},
  [3829] = {.lex_state = 29},
  [3830] = {.lex_state = 29},
  [3831] = {.lex_state = 29},
  [3832] = {.lex_state = 29},
  [3833] = {.lex_state = 29},
  [3834] = {.lex_state = 29},
  [3835] = {.lex_state = 29},
  [3836] = {.lex_state = 29},
  [3837] = {.lex_state = 29},
  [3838] = {.lex_state = 29},
  [3839] = {.lex_state = 29},
  [3840] = {.lex_state = 29},
  [3841] = {.lex_state = 29},
  [3842] = {.lex_state = 29},
  [3843] = {.lex_state = 29},
  [3844] = {.lex_state = 29},
  [3845] = {.lex_state = 29},
  [3846] = {.lex_state = 29},
  [3847] = {.lex_state = 29},
  [3848] = {.lex_state = 29},
  [3849] = {.lex_state = 29},
  [3850] = {.lex_state = 29},
  [3851] = {.lex_state = 29},
  [3852] = {.lex_state = 29},
  [3853] = {.lex_state = 29},
  [3854] = {.lex_state = 29},
  [3855] = {.lex_state = 29},
  [3856] = {.lex_state = 29},
  [3857] = {.lex_state = 29},
  [3858] = {.lex_state = 29},
  [3859] = {.lex_state = 29},
  [3860] = {.lex_state = 29},
  [3861] = {.lex_state = 29},
  [3862] = {.lex_state = 29},
  [3863] = {.lex_state = 29},
  [3864] = {.lex_state = 29},
  [3865] = {.lex_state = 29},
  [3866] = {.lex_state = 29},
  [3867] = {.lex_state = 29},
  [3868] = {.lex_state = 29},
  [3869] = {.lex_state = 29},
  [3870] = {.lex_state = 29},
  [3871] = {.lex_state = 29},
  [3872] = {.lex_state = 29},
  [3873] = {.lex_state = 29},
  [3874] = {.lex_state = 29},
  [3875] = {.lex_state = 29},
  [3876] = {.lex_state = 29},
  [3877] = {.lex_state = 29},
  [3878] = {.lex_state = 29},
  [3879] = {.lex_state = 29},
  [3880] = {.lex_state = 29},
  [3881] = {.lex_state = 29},
  [3882] = {.lex_state = 29},
  [3883] = {.lex_state = 29},
  [3884] = {.lex_state = 29},
  [3885] = {.lex_state = 29},
  [3886] = {.lex_state = 29},
  [3887] = {.lex_state = 29},
  [3888] = {.lex_state = 29},
  [3889] = {.lex_state = 29},
  [3890] = {.lex_state = 29},
  [3891] = {.lex_state = 29},
  [3892] = {.lex_state = 29},
  [3893] = {.lex_state = 29},
  [3894] = {.lex_state = 29},
  [3895] = {.lex_state = 29},
  [3896] = {.lex_state = 29},
  [3897] = {.lex_state = 29},
  [3898] = {.lex_state = 29},
  [3899] = {.lex_state = 29},
  [3900] = {.lex_state = 29},
  [3901] = {.lex_state = 29},
  [3902] = {.lex_state = 29},
  [3903] = {.lex_state = 29},
  [3904] = {.lex_state = 29},
  [3905] = {.lex_state = 29},
  [3906] = {.lex_state = 29},
  [3907] = {.lex_state = 29},
  [3908] = {.lex_state = 29},
  [3909] = {.lex_state = 29},
  [3910] = {.lex_state = 29},
  [3911] = {.lex_state = 29},
  [3912] = {.lex_state = 29},
  [3913] = {.lex_state = 29, .external_lex_state = 2},
  [3914] = {.lex_state = 29},
  [3915] = {.lex_state = 29},
  [3916] = {.lex_state = 29},
  [3917] = {.lex_state = 29},
  [3918] = {.lex_state = 29},
  [3919] = {.lex_state = 29},
  [3920] = {.lex_state = 29},
  [3921] = {.lex_state = 0},
  [3922] = {.lex_state = 29},
  [3923] = {.lex_state = 29, .external_lex_state = 2},
  [3924] = {.lex_state = 29},
  [3925] = {.lex_state = 29},
  [3926] = {.lex_state = 0},
  [3927] = {.lex_state = 29},
  [3928] = {.lex_state = 0},
  [3929] = {.lex_state = 29},
  [3930] = {.lex_state = 29},
  [3931] = {.lex_state = 29},
  [3932] = {.lex_state = 29},
  [3933] = {.lex_state = 29},
  [3934] = {.lex_state = 29},
  [3935] = {.lex_state = 29},
  [3936] = {.lex_state = 29},
  [3937] = {.lex_state = 29},
  [3938] = {.lex_state = 29},
  [3939] = {.lex_state = 29},
  [3940] = {.lex_state = 29},
  [3941] = {.lex_state = 29},
  [3942] = {.lex_state = 29},
  [3943] = {.lex_state = 29},
  [3944] = {.lex_state = 29},
  [3945] = {.lex_state = 29},
  [3946] = {.lex_state = 29},
  [3947] = {.lex_state = 29},
  [3948] = {.lex_state = 29},
  [3949] = {.lex_state = 29},
  [3950] = {.lex_state = 29},
  [3951] = {.lex_state = 29},
  [3952] = {.lex_state = 29},
  [3953] = {.lex_state = 29},
  [3954] = {.lex_state = 29},
  [3955] = {.lex_state = 29},
  [3956] = {.lex_state = 29},
  [3957] = {.lex_state = 29},
  [3958] = {.lex_state = 29},
  [3959] = {.lex_state = 29},
  [3960] = {.lex_state = 29},
  [3961] = {.lex_state = 29},
  [3962] = {.lex_state = 29},
  [3963] = {.lex_state = 29, .external_lex_state = 2},
  [3964] = {.lex_state = 0},
  [3965] = {.lex_state = 29},
  [3966] = {.lex_state = 29},
  [3967] = {.lex_state = 29, .external_lex_state = 2},
  [3968] = {.lex_state = 29, .external_lex_state = 2},
  [3969] = {.lex_state = 29},
  [3970] = {.lex_state = 0},
  [3971] = {.lex_state = 29},
  [3972] = {.lex_state = 29},
  [3973] = {.lex_state = 29},
  [3974] = {.lex_state = 29},
  [3975] = {.lex_state = 29},
  [3976] = {.lex_state = 29},
  [3977] = {.lex_state = 29},
  [3978] = {.lex_state = 29},
  [3979] = {.lex_state = 29},
  [3980] = {.lex_state = 29},
  [3981] = {.lex_state = 29},
  [3982] = {.lex_state = 29},
  [3983] = {.lex_state = 29},
  [3984] = {.lex_state = 0},
  [3985] = {.lex_state = 29},
  [3986] = {.lex_state = 0},
  [3987] = {.lex_state = 29},
  [3988] = {.lex_state = 29},
  [3989] = {.lex_state = 29},
  [3990] = {.lex_state = 29},
  [3991] = {.lex_state = 29},
  [3992] = {.lex_state = 29, .external_lex_state = 2},
  [3993] = {.lex_state = 29},
  [3994] = {.lex_state = 29, .external_lex_state = 2},
  [3995] = {.lex_state = 29},
  [3996] = {.lex_state = 29, .external_lex_state = 2},
  [3997] = {.lex_state = 29},
  [3998] = {.lex_state = 29},
  [3999] = {.lex_state = 29},
  [4000] = {.lex_state = 29},
  [4001] = {.lex_state = 29},
  [4002] = {.lex_state = 0},
  [4003] = {.lex_state = 29},
  [4004] = {.lex_state = 29},
  [4005] = {.lex_state = 29},
  [4006] = {.lex_state = 29},
  [4007] = {.lex_state = 29},
  [4008] = {.lex_state = 29},
  [4009] = {.lex_state = 29},
  [4010] = {.lex_state = 29},
  [4011] = {.lex_state = 29},
  [4012] = {.lex_state = 29},
  [4013] = {.lex_state = 29},
  [4014] = {.lex_state = 29},
  [4015] = {.lex_state = 29},
  [4016] = {.lex_state = 29},
  [4017] = {.lex_state = 29},
  [4018] = {.lex_state = 29},
  [4019] = {.lex_state = 29},
  [4020] = {.lex_state = 29},
  [4021] = {.lex_state = 29},
  [4022] = {.lex_state = 29},
  [4023] = {.lex_state = 29},
  [4024] = {.lex_state = 29},
  [4025] = {.lex_state = 29},
  [4026] = {.lex_state = 29},
  [4027] = {.lex_state = 29},
  [4028] = {.lex_state = 29},
  [4029] = {.lex_state = 29},
  [4030] = {.lex_state = 29},
  [4031] = {.lex_state = 29},
  [4032] = {.lex_state = 29},
  [4033] = {.lex_state = 29},
  [4034] = {.lex_state = 29},
  [4035] = {.lex_state = 29},
  [4036] = {.lex_state = 29},
  [4037] = {.lex_state = 29},
  [4038] = {.lex_state = 29},
  [4039] = {.lex_state = 29},
  [4040] = {.lex_state = 29},
  [4041] = {.lex_state = 29},
  [4042] = {.lex_state = 29},
  [4043] = {.lex_state = 29},
  [4044] = {.lex_state = 29},
  [4045] = {.lex_state = 29},
  [4046] = {.lex_state = 29},
  [4047] = {.lex_state = 29},
  [4048] = {.lex_state = 29},
  [4049] = {.lex_state = 29},
  [4050] = {.lex_state = 29},
  [4051] = {.lex_state = 29},
  [4052] = {.lex_state = 29},
  [4053] = {.lex_state = 29},
  [4054] = {.lex_state = 29},
  [4055] = {.lex_state = 29},
  [4056] = {.lex_state = 29},
  [4057] = {.lex_state = 29},
  [4058] = {.lex_state = 29},
  [4059] = {.lex_state = 29},
  [4060] = {.lex_state = 29},
  [4061] = {.lex_state = 29},
  [4062] = {.lex_state = 29},
  [4063] = {.lex_state = 29},
  [4064] = {.lex_state = 29},
  [4065] = {.lex_state = 29},
  [4066] = {.lex_state = 29},
  [4067] = {.lex_state = 29},
  [4068] = {.lex_state = 29},
  [4069] = {.lex_state = 29},
  [4070] = {.lex_state = 29},
  [4071] = {.lex_state = 29},
  [4072] = {.lex_state = 29},
  [4073] = {.lex_state = 29},
  [4074] = {.lex_state = 29},
  [4075] = {.lex_state = 29},
  [4076] = {.lex_state = 29},
  [4077] = {.lex_state = 29},
  [4078] = {.lex_state = 29},
  [4079] = {.lex_state = 29},
  [4080] = {.lex_state = 29},
  [4081] = {.lex_state = 29},
  [4082] = {.lex_state = 29},
  [4083] = {.lex_state = 29},
  [4084] = {.lex_state = 29},
  [4085] = {.lex_state = 29},
  [4086] = {.lex_state = 29},
  [4087] = {.lex_state = 29},
  [4088] = {.lex_state = 29},
  [4089] = {.lex_state = 29},
  [4090] = {.lex_state = 29},
  [4091] = {.lex_state = 29},
  [4092] = {.lex_state = 29},
  [4093] = {.lex_state = 29},
  [4094] = {.lex_state = 29},
  [4095] = {.lex_state = 29},
  [4096] = {.lex_state = 29, .external_lex_state = 2},
  [4097] = {.lex_state = 29},
  [4098] = {.lex_state = 29},
  [4099] = {.lex_state = 29},
  [4100] = {.lex_state = 29},
  [4101] = {.lex_state = 29},
  [4102] = {.lex_state = 29},
  [4103] = {.lex_state = 29},
  [4104] = {.lex_state = 29},
  [4105] = {.lex_state = 29},
  [4106] = {.lex_state = 29},
  [4107] = {.lex_state = 29},
  [4108] = {.lex_state = 29},
  [4109] = {.lex_state = 0},
  [4110] = {.lex_state = 0},
  [4111] = {.lex_state = 29},
  [4112] = {.lex_state = 29},
  [4113] = {.lex_state = 29},
  [4114] = {.lex_state = 29},
  [4115] = {.lex_state = 29},
  [4116] = {.lex_state = 29},
  [4117] = {.lex_state = 29},
  [4118] = {.lex_state = 29},
  [4119] = {.lex_state = 29},
  [4120] = {.lex_state = 29},
  [4121] = {.lex_state = 29},
  [4122] = {.lex_state = 29},
  [4123] = {.lex_state = 29},
  [4124] = {.lex_state = 29},
  [4125] = {.lex_state = 29},
  [4126] = {.lex_state = 0},
  [4127] = {.lex_state = 29},
  [4128] = {.lex_state = 29},
  [4129] = {.lex_state = 29},
  [4130] = {.lex_state = 29},
  [4131] = {.lex_state = 29},
  [4132] = {.lex_state = 29},
  [4133] = {.lex_state = 29},
  [4134] = {.lex_state = 29},
  [4135] = {.lex_state = 29},
  [4136] = {.lex_state = 29},
  [4137] = {.lex_state = 29},
  [4138] = {.lex_state = 29},
  [4139] = {.lex_state = 29},
  [4140] = {.lex_state = 29},
  [4141] = {.lex_state = 29},
  [4142] = {.lex_state = 0},
  [4143] = {.lex_state = 29},
  [4144] = {.lex_state = 29},
  [4145] = {.lex_state = 29},
  [4146] = {.lex_state = 29},
  [4147] = {.lex_state = 29},
  [4148] = {.lex_state = 29},
  [4149] = {.lex_state = 29},
  [4150] = {.lex_state = 29},
  [4151] = {.lex_state = 29},
  [4152] = {.lex_state = 29},
  [4153] = {.lex_state = 29},
  [4154] = {.lex_state = 29},
  [4155] = {.lex_state = 29},
  [4156] = {.lex_state = 29},
  [4157] = {.lex_state = 29},
  [4158] = {.lex_state = 29},
  [4159] = {.lex_state = 29},
  [4160] = {.lex_state = 29},
  [4161] = {.lex_state = 29},
  [4162] = {.lex_state = 29},
  [4163] = {.lex_state = 29},
  [4164] = {.lex_state = 29},
  [4165] = {.lex_state = 29},
  [4166] = {.lex_state = 29},
  [4167] = {.lex_state = 29},
  [4168] = {.lex_state = 29},
  [4169] = {.lex_state = 29},
  [4170] = {.lex_state = 29},
  [4171] = {.lex_state = 29},
  [4172] = {.lex_state = 29},
  [4173] = {.lex_state = 29},
  [4174] = {.lex_state = 29},
  [4175] = {.lex_state = 29},
  [4176] = {.lex_state = 29},
  [4177] = {.lex_state = 29},
  [4178] = {.lex_state = 29},
  [4179] = {.lex_state = 29},
  [4180] = {.lex_state = 29},
  [4181] = {.lex_state = 29},
  [4182] = {.lex_state = 29},
  [4183] = {.lex_state = 29},
  [4184] = {.lex_state = 29},
  [4185] = {.lex_state = 29},
  [4186] = {.lex_state = 29},
  [4187] = {.lex_state = 29},
  [4188] = {.lex_state = 29},
  [4189] = {.lex_state = 29},
  [4190] = {.lex_state = 29},
  [4191] = {.lex_state = 29},
  [4192] = {.lex_state = 29},
  [4193] = {.lex_state = 29},
  [4194] = {.lex_state = 29},
  [4195] = {.lex_state = 29},
  [4196] = {.lex_state = 29},
  [4197] = {.lex_state = 29},
  [4198] = {.lex_state = 29},
  [4199] = {.lex_state = 29},
  [4200] = {.lex_state = 29},
  [4201] = {.lex_state = 29},
  [4202] = {.lex_state = 29},
  [4203] = {.lex_state = 29},
  [4204] = {.lex_state = 29},
  [4205] = {.lex_state = 29},
  [4206] = {.lex_state = 29},
  [4207] = {.lex_state = 29},
  [4208] = {.lex_state = 0},
  [4209] = {.lex_state = 29},
  [4210] = {.lex_state = 29},
  [4211] = {.lex_state = 29},
  [4212] = {.lex_state = 0},
  [4213] = {.lex_state = 29},
  [4214] = {.lex_state = 0},
  [4215] = {.lex_state = 29},
  [4216] = {.lex_state = 0},
  [4217] = {.lex_state = 0},
  [4218] = {.lex_state = 0},
  [4219] = {.lex_state = 29},
  [4220] = {.lex_state = 29, .external_lex_state = 2},
  [4221] = {.lex_state = 29},
  [4222] = {.lex_state = 29},
  [4223] = {.lex_state = 29},
  [4224] = {.lex_state = 29},
  [4225] = {.lex_state = 29},
  [4226] = {.lex_state = 29},
  [4227] = {.lex_state = 29},
  [4228] = {.lex_state = 29},
  [4229] = {.lex_state = 29},
  [4230] = {.lex_state = 29},
  [4231] = {.lex_state = 29},
  [4232] = {.lex_state = 29},
  [4233] = {.lex_state = 29},
  [4234] = {.lex_state = 29},
  [4235] = {.lex_state = 29},
  [4236] = {.lex_state = 29},
  [4237] = {.lex_state = 29},
  [4238] = {.lex_state = 29},
  [4239] = {.lex_state = 29},
  [4240] = {.lex_state = 29},
  [4241] = {.lex_state = 29},
  [4242] = {.lex_state = 29},
  [4243] = {.lex_state = 29},
  [4244] = {.lex_state = 29},
  [4245] = {.lex_state = 29},
  [4246] = {.lex_state = 29},
  [4247] = {.lex_state = 29},
  [4248] = {.lex_state = 29},
  [4249] = {.lex_state = 29},
  [4250] = {.lex_state = 29},
  [4251] = {.lex_state = 29},
  [4252] = {.lex_state = 29},
  [4253] = {.lex_state = 29},
  [4254] = {.lex_state = 29},
  [4255] = {.lex_state = 29},
  [4256] = {.lex_state = 0},
  [4257] = {.lex_state = 29},
  [4258] = {.lex_state = 29},
  [4259] = {.lex_state = 29},
  [4260] = {.lex_state = 29},
  [4261] = {.lex_state = 29},
  [4262] = {.lex_state = 0},
  [4263] = {.lex_state = 29},
  [4264] = {.lex_state = 0},
  [4265] = {.lex_state = 29},
  [4266] = {.lex_state = 29},
  [4267] = {.lex_state = 29},
  [4268] = {.lex_state = 29},
  [4269] = {.lex_state = 29},
  [4270] = {.lex_state = 29},
  [4271] = {.lex_state = 29},
  [4272] = {.lex_state = 29},
  [4273] = {.lex_state = 29},
  [4274] = {.lex_state = 29},
  [4275] = {.lex_state = 29},
  [4276] = {.lex_state = 29},
  [4277] = {.lex_state = 29},
  [4278] = {.lex_state = 29},
  [4279] = {.lex_state = 29, .external_lex_state = 2},
  [4280] = {.lex_state = 29},
  [4281] = {.lex_state = 29},
  [4282] = {.lex_state = 29},
  [4283] = {.lex_state = 29},
  [4284] = {.lex_state = 0},
  [4285] = {.lex_state = 29},
  [4286] = {.lex_state = 29, .external_lex_state = 2},
  [4287] = {.lex_state = 0},
  [4288] = {.lex_state = 0},
  [4289] = {.lex_state = 29},
  [4290] = {.lex_state = 29},
  [4291] = {.lex_state = 0},
  [4292] = {.lex_state = 29},
  [4293] = {.lex_state = 29},
  [4294] = {.lex_state = 29, .external_lex_state = 2},
  [4295] = {.lex_state = 29},
  [4296] = {.lex_state = 0},
  [4297] = {.lex_state = 29},
  [4298] = {.lex_state = 29},
  [4299] = {.lex_state = 29},
  [4300] = {.lex_state = 29},
  [4301] = {.lex_state = 29},
  [4302] = {.lex_state = 0},
  [4303] = {.lex_state = 29},
  [4304] = {.lex_state = 0},
  [4305] = {.lex_state = 29},
  [4306] = {.lex_state = 29},
  [4307] = {.lex_state = 29},
  [4308] = {.lex_state = 29},
  [4309] = {.lex_state = 29},
  [4310] = {.lex_state = 0},
  [4311] = {.lex_state = 29},
  [4312] = {.lex_state = 29},
  [4313] = {.lex_state = 29},
  [4314] = {.lex_state = 29},
  [4315] = {.lex_state = 29},
  [4316] = {.lex_state = 29},
  [4317] = {.lex_state = 29},
  [4318] = {.lex_state = 29},
  [4319] = {.lex_state = 29},
  [4320] = {.lex_state = 29},
  [4321] = {.lex_state = 29},
  [4322] = {.lex_state = 29},
  [4323] = {.lex_state = 29, .external_lex_state = 2},
  [4324] = {.lex_state = 0},
  [4325] = {.lex_state = 29, .external_lex_state = 2},
  [4326] = {.lex_state = 29},
  [4327] = {.lex_state = 29},
  [4328] = {.lex_state = 29},
  [4329] = {.lex_state = 29},
  [4330] = {.lex_state = 29},
  [4331] = {.lex_state = 29},
  [4332] = {.lex_state = 29},
  [4333] = {.lex_state = 29},
  [4334] = {.lex_state = 29},
  [4335] = {.lex_state = 29, .external_lex_state = 2},
  [4336] = {.lex_state = 29},
  [4337] = {.lex_state = 29},
  [4338] = {.lex_state = 29},
  [4339] = {.lex_state = 0},
  [4340] = {.lex_state = 29},
  [4341] = {.lex_state = 0},
  [4342] = {.lex_state = 29, .external_lex_state = 2},
  [4343] = {.lex_state = 29},
  [4344] = {.lex_state = 0},
  [4345] = {.lex_state = 29},
  [4346] = {.lex_state = 29},
  [4347] = {.lex_state = 0},
  [4348] = {.lex_state = 0},
  [4349] = {.lex_state = 29},
  [4350] = {.lex_state = 29},
  [4351] = {.lex_state = 29},
  [4352] = {.lex_state = 29},
  [4353] = {.lex_state = 29},
  [4354] = {.lex_state = 29},
  [4355] = {.lex_state = 0},
  [4356] = {.lex_state = 29},
  [4357] = {.lex_state = 29},
  [4358] = {.lex_state = 29},
  [4359] = {.lex_state = 29},
  [4360] = {.lex_state = 29},
  [4361] = {.lex_state = 29},
  [4362] = {.lex_state = 29},
  [4363] = {.lex_state = 29, .external_lex_state = 2},
  [4364] = {.lex_state = 29},
  [4365] = {.lex_state = 29},
  [4366] = {.lex_state = 29, .external_lex_state = 2},
  [4367] = {.lex_state = 29, .external_lex_state = 2},
  [4368] = {.lex_state = 29, .external_lex_state = 2},
  [4369] = {.lex_state = 29},
  [4370] = {.lex_state = 29, .external_lex_state = 2},
  [4371] = {.lex_state = 29},
  [4372] = {.lex_state = 29},
  [4373] = {.lex_state = 29},
  [4374] = {.lex_state = 29},
  [4375] = {.lex_state = 29},
  [4376] = {.lex_state = 29},
  [4377] = {.lex_state = 0},
  [4378] = {.lex_state = 29},
  [4379] = {.lex_state = 0},
  [4380] = {.lex_state = 29},
  [4381] = {.lex_state = 29},
  [4382] = {.lex_state = 29},
  [4383] = {.lex_state = 29},
  [4384] = {.lex_state = 29},
  [4385] = {.lex_state = 29},
  [4386] = {.lex_state = 30, .external_lex_state = 2},
  [4387] = {.lex_state = 29},
  [4388] = {.lex_state = 29},
  [4389] = {.lex_state = 29},
  [4390] = {.lex_state = 29},
  [4391] = {.lex_state = 29},
  [4392] = {.lex_state = 29},
  [4393] = {.lex_state = 29},
  [4394] = {.lex_state = 29},
  [4395] = {.lex_state = 29},
  [4396] = {.lex_state = 29},
  [4397] = {.lex_state = 29},
  [4398] = {.lex_state = 29},
  [4399] = {.lex_state = 29},
  [4400] = {.lex_state = 29},
  [4401] = {.lex_state = 29},
  [4402] = {.lex_state = 29},
  [4403] = {.lex_state = 0},
  [4404] = {.lex_state = 29},
  [4405] = {.lex_state = 29},
  [4406] = {.lex_state = 29},
  [4407] = {.lex_state = 29},
  [4408] = {.lex_state = 29},
  [4409] = {.lex_state = 29},
  [4410] = {.lex_state = 29},
  [4411] = {.lex_state = 29},
  [4412] = {.lex_state = 29},
  [4413] = {.lex_state = 29},
  [4414] = {.lex_state = 29},
  [4415] = {.lex_state = 29},
  [4416] = {.lex_state = 29},
  [4417] = {.lex_state = 29},
  [4418] = {.lex_state = 29},
  [4419] = {.lex_state = 29},
  [4420] = {.lex_state = 29},
  [4421] = {.lex_state = 29},
  [4422] = {.lex_state = 29},
  [4423] = {.lex_state = 29},
  [4424] = {.lex_state = 29},
  [4425] = {.lex_state = 29},
  [4426] = {.lex_state = 29, .external_lex_state = 2},
  [4427] = {.lex_state = 29},
  [4428] = {.lex_state = 29},
  [4429] = {.lex_state = 29},
  [4430] = {.lex_state = 29},
  [4431] = {.lex_state = 29},
  [4432] = {.lex_state = 29},
  [4433] = {.lex_state = 29},
  [4434] = {.lex_state = 29},
  [4435] = {.lex_state = 29},
  [4436] = {.lex_state = 29},
  [4437] = {.lex_state = 29},
  [4438] = {.lex_state = 29},
  [4439] = {.lex_state = 29},
  [4440] = {.lex_state = 29},
  [4441] = {.lex_state = 29},
  [4442] = {.lex_state = 29},
  [4443] = {.lex_state = 29},
  [4444] = {.lex_state = 29},
  [4445] = {.lex_state = 29},
  [4446] = {.lex_state = 29},
  [4447] = {.lex_state = 29},
  [4448] = {.lex_state = 29},
  [4449] = {.lex_state = 29},
  [4450] = {.lex_state = 29},
  [4451] = {.lex_state = 29},
  [4452] = {.lex_state = 29},
  [4453] = {.lex_state = 29},
  [4454] = {.lex_state = 0},
  [4455] = {.lex_state = 29},
  [4456] = {.lex_state = 29},
  [4457] = {.lex_state = 29},
  [4458] = {.lex_state = 29},
  [4459] = {.lex_state = 29},
  [4460] = {.lex_state = 29},
  [4461] = {.lex_state = 29},
  [4462] = {.lex_state = 29},
  [4463] = {.lex_state = 29},
  [4464] = {.lex_state = 29},
  [4465] = {.lex_state = 29},
  [4466] = {.lex_state = 29},
  [4467] = {.lex_state = 29},
  [4468] = {.lex_state = 29},
  [4469] = {.lex_state = 29},
  [4470] = {.lex_state = 29},
  [4471] = {.lex_state = 29},
  [4472] = {.lex_state = 29},
  [4473] = {.lex_state = 29},
  [4474] = {.lex_state = 29},
  [4475] = {.lex_state = 29},
  [4476] = {.lex_state = 29},
  [4477] = {.lex_state = 29},
  [4478] = {.lex_state = 29},
  [4479] = {.lex_state = 29},
  [4480] = {.lex_state = 29},
  [4481] = {.lex_state = 29},
  [4482] = {.lex_state = 29},
  [4483] = {.lex_state = 29},
  [4484] = {.lex_state = 29},
  [4485] = {.lex_state = 29},
  [4486] = {.lex_state = 29},
  [4487] = {.lex_state = 29},
  [4488] = {.lex_state = 29},
  [4489] = {.lex_state = 30, .external_lex_state = 2},
  [4490] = {.lex_state = 29},
  [4491] = {.lex_state = 29},
  [4492] = {.lex_state = 29},
  [4493] = {.lex_state = 29},
  [4494] = {.lex_state = 0},
  [4495] = {.lex_state = 0},
  [4496] = {.lex_state = 29},
  [4497] = {.lex_state = 0},
  [4498] = {.lex_state = 0},
  [4499] = {.lex_state = 0},
  [4500] = {.lex_state = 0},
  [4501] = {.lex_state = 0},
  [4502] = {.lex_state = 29},
  [4503] = {.lex_state = 29},
  [4504] = {.lex_state = 0},
  [4505] = {.lex_state = 29},
  [4506] = {.lex_state = 29, .external_lex_state = 2},
  [4507] = {.lex_state = 29},
  [4508] = {.lex_state = 0},
  [4509] = {.lex_state = 0},
  [4510] = {.lex_state = 29},
  [4511] = {.lex_state = 29},
  [4512] = {.lex_state = 29},
  [4513] = {.lex_state = 0},
  [4514] = {.lex_state = 29},
  [4515] = {.lex_state = 29},
  [4516] = {.lex_state = 0},
  [4517] = {.lex_state = 29},
  [4518] = {.lex_state = 29},
  [4519] = {.lex_state = 29},
  [4520] = {.lex_state = 29},
  [4521] = {.lex_state = 29},
  [4522] = {.lex_state = 29},
  [4523] = {.lex_state = 30, .external_lex_state = 2},
  [4524] = {.lex_state = 29},
  [4525] = {.lex_state = 30, .external_lex_state = 2},
  [4526] = {.lex_state = 30, .external_lex_state = 2},
  [4527] = {.lex_state = 29},
  [4528] = {.lex_state = 29},
  [4529] = {.lex_state = 29},
  [4530] = {.lex_state = 0},
  [4531] = {.lex_state = 29},
  [4532] = {.lex_state = 29},
  [4533] = {.lex_state = 29, .external_lex_state = 2},
  [4534] = {.lex_state = 29, .external_lex_state = 2},
  [4535] = {.lex_state = 29},
  [4536] = {.lex_state = 29},
  [4537] = {.lex_state = 29},
  [4538] = {.lex_state = 29},
  [4539] = {.lex_state = 29},
  [4540] = {.lex_state = 29},
  [4541] = {.lex_state = 29},
  [4542] = {.lex_state = 29},
  [4543] = {.lex_state = 29},
  [4544] = {.lex_state = 29},
  [4545] = {.lex_state = 29},
  [4546] = {.lex_state = 29},
  [4547] = {.lex_state = 29},
  [4548] = {.lex_state = 29},
  [4549] = {.lex_state = 29},
  [4550] = {.lex_state = 29},
  [4551] = {.lex_state = 29},
  [4552] = {.lex_state = 29},
  [4553] = {.lex_state = 29},
  [4554] = {.lex_state = 29},
  [4555] = {.lex_state = 29},
  [4556] = {.lex_state = 29},
  [4557] = {.lex_state = 29},
  [4558] = {.lex_state = 29},
  [4559] = {.lex_state = 29},
  [4560] = {.lex_state = 30, .external_lex_state = 2},
  [4561] = {.lex_state = 29},
  [4562] = {.lex_state = 29},
  [4563] = {.lex_state = 29},
  [4564] = {.lex_state = 29, .external_lex_state = 2},
  [4565] = {.lex_state = 29},
  [4566] = {.lex_state = 29, .external_lex_state = 2},
  [4567] = {.lex_state = 29},
  [4568] = {.lex_state = 29},
  [4569] = {.lex_state = 29},
  [4570] = {.lex_state = 29},
  [4571] = {.lex_state = 29},
  [4572] = {.lex_state = 29},
  [4573] = {.lex_state = 29},
  [4574] = {.lex_state = 29},
  [4575] = {.lex_state = 29},
  [4576] = {.lex_state = 29},
  [4577] = {.lex_state = 29},
  [4578] = {.lex_state = 29},
  [4579] = {.lex_state = 29, .external_lex_state = 2},
  [4580] = {.lex_state = 0},
  [4581] = {.lex_state = 29},
  [4582] = {.lex_state = 29},
  [4583] = {.lex_state = 29, .external_lex_state = 2},
  [4584] = {.lex_state = 29},
  [4585] = {.lex_state = 29},
  [4586] = {.lex_state = 29},
  [4587] = {.lex_state = 29},
  [4588] = {.lex_state = 0},
  [4589] = {.lex_state = 29},
  [4590] = {.lex_state = 29},
  [4591] = {.lex_state = 29},
  [4592] = {.lex_state = 29},
  [4593] = {.lex_state = 29},
  [4594] = {.lex_state = 29},
  [4595] = {.lex_state = 29},
  [4596] = {.lex_state = 29},
  [4597] = {.lex_state = 29},
  [4598] = {.lex_state = 29},
  [4599] = {.lex_state = 29},
  [4600] = {.lex_state = 29},
  [4601] = {.lex_state = 29},
  [4602] = {.lex_state = 0},
  [4603] = {.lex_state = 29},
  [4604] = {.lex_state = 29},
  [4605] = {.lex_state = 29},
  [4606] = {.lex_state = 29},
  [4607] = {.lex_state = 29},
  [4608] = {.lex_state = 29},
  [4609] = {.lex_state = 29},
  [4610] = {.lex_state = 29},
  [4611] = {.lex_state = 29},
  [4612] = {.lex_state = 30, .external_lex_state = 2},
  [4613] = {.lex_state = 29},
  [4614] = {.lex_state = 29},
  [4615] = {.lex_state = 29},
  [4616] = {.lex_state = 29},
  [4617] = {.lex_state = 29},
  [4618] = {.lex_state = 29},
  [4619] = {.lex_state = 0},
  [4620] = {.lex_state = 0},
  [4621] = {.lex_state = 0},
  [4622] = {.lex_state = 30, .external_lex_state = 2},
  [4623] = {.lex_state = 29},
  [4624] = {.lex_state = 29},
  [4625] = {.lex_state = 30, .external_lex_state = 2},
  [4626] = {.lex_state = 29},
  [4627] = {.lex_state = 29},
  [4628] = {.lex_state = 29},
  [4629] = {.lex_state = 29},
  [4630] = {.lex_state = 29},
  [4631] = {.lex_state = 29},
  [4632] = {.lex_state = 29},
  [4633] = {.lex_state = 29},
  [4634] = {.lex_state = 29},
  [4635] = {.lex_state = 29},
  [4636] = {.lex_state = 0},
  [4637] = {.lex_state = 29},
  [4638] = {.lex_state = 29},
  [4639] = {.lex_state = 29},
  [4640] = {.lex_state = 29},
  [4641] = {.lex_state = 30, .external_lex_state = 2},
  [4642] = {.lex_state = 30, .external_lex_state = 2},
  [4643] = {.lex_state = 30, .external_lex_state = 2},
  [4644] = {.lex_state = 29},
  [4645] = {.lex_state = 29},
  [4646] = {.lex_state = 30, .external_lex_state = 2},
  [4647] = {.lex_state = 29},
  [4648] = {.lex_state = 30, .external_lex_state = 2},
  [4649] = {.lex_state = 30, .external_lex_state = 2},
  [4650] = {.lex_state = 30, .external_lex_state = 2},
  [4651] = {.lex_state = 29},
  [4652] = {.lex_state = 30, .external_lex_state = 2},
  [4653] = {.lex_state = 29},
  [4654] = {.lex_state = 30, .external_lex_state = 2},
  [4655] = {.lex_state = 29},
  [4656] = {.lex_state = 29},
  [4657] = {.lex_state = 29},
  [4658] = {.lex_state = 29},
  [4659] = {.lex_state = 29},
  [4660] = {.lex_state = 0},
  [4661] = {.lex_state = 29},
  [4662] = {.lex_state = 29},
  [4663] = {.lex_state = 30, .external_lex_state = 2},
  [4664] = {.lex_state = 29},
  [4665] = {.lex_state = 29},
  [4666] = {.lex_state = 29},
  [4667] = {.lex_state = 29},
  [4668] = {.lex_state = 30, .external_lex_state = 2},
  [4669] = {.lex_state = 29},
  [4670] = {.lex_state = 29},
  [4671] = {.lex_state = 29},
  [4672] = {.lex_state = 29},
  [4673] = {.lex_state = 29},
  [4674] = {.lex_state = 29},
  [4675] = {.lex_state = 29},
  [4676] = {.lex_state = 29},
  [4677] = {.lex_state = 29},
  [4678] = {.lex_state = 29},
  [4679] = {.lex_state = 29},
  [4680] = {.lex_state = 29},
  [4681] = {.lex_state = 29},
  [4682] = {.lex_state = 29},
  [4683] = {.lex_state = 29},
  [4684] = {.lex_state = 30, .external_lex_state = 2},
  [4685] = {.lex_state = 29},
  [4686] = {.lex_state = 29},
  [4687] = {.lex_state = 29},
  [4688] = {.lex_state = 29},
  [4689] = {.lex_state = 29},
  [4690] = {.lex_state = 30, .external_lex_state = 2},
  [4691] = {.lex_state = 29},
  [4692] = {.lex_state = 29},
  [4693] = {.lex_state = 29},
  [4694] = {.lex_state = 29},
  [4695] = {.lex_state = 29},
  [4696] = {.lex_state = 29},
  [4697] = {.lex_state = 29},
  [4698] = {.lex_state = 29},
  [4699] = {.lex_state = 29},
  [4700] = {.lex_state = 29},
  [4701] = {.lex_state = 29},
  [4702] = {.lex_state = 29},
  [4703] = {.lex_state = 29},
  [4704] = {.lex_state = 29},
  [4705] = {.lex_state = 29},
  [4706] = {.lex_state = 29},
  [4707] = {.lex_state = 29},
  [4708] = {.lex_state = 29},
  [4709] = {.lex_state = 30, .external_lex_state = 2},
  [4710] = {.lex_state = 29},
  [4711] = {.lex_state = 29},
  [4712] = {.lex_state = 29},
  [4713] = {.lex_state = 29},
  [4714] = {.lex_state = 29},
  [4715] = {.lex_state = 29},
  [4716] = {.lex_state = 29},
  [4717] = {.lex_state = 29},
  [4718] = {.lex_state = 29},
  [4719] = {.lex_state = 29},
  [4720] = {.lex_state = 29},
  [4721] = {.lex_state = 29},
  [4722] = {.lex_state = 29},
  [4723] = {.lex_state = 29},
  [4724] = {.lex_state = 29},
  [4725] = {.lex_state = 29},
  [4726] = {.lex_state = 29},
  [4727] = {.lex_state = 29},
  [4728] = {.lex_state = 29},
  [4729] = {.lex_state = 29},
  [4730] = {.lex_state = 29},
  [4731] = {.lex_state = 29},
  [4732] = {.lex_state = 30, .external_lex_state = 2},
  [4733] = {.lex_state = 29},
  [4734] = {.lex_state = 29},
  [4735] = {.lex_state = 29},
  [4736] = {.lex_state = 29},
  [4737] = {.lex_state = 30, .external_lex_state = 2},
  [4738] = {.lex_state = 29},
  [4739] = {.lex_state = 29},
  [4740] = {.lex_state = 29},
  [4741] = {.lex_state = 30, .external_lex_state = 2},
  [4742] = {.lex_state = 29},
  [4743] = {.lex_state = 30, .external_lex_state = 2},
  [4744] = {.lex_state = 29},
  [4745] = {.lex_state = 29},
  [4746] = {.lex_state = 29},
  [4747] = {.lex_state = 29},
  [4748] = {.lex_state = 29},
  [4749] = {.lex_state = 29},
  [4750] = {.lex_state = 29},
  [4751] = {.lex_state = 29},
  [4752] = {.lex_state = 29},
  [4753] = {.lex_state = 29},
  [4754] = {.lex_state = 29},
  [4755] = {.lex_state = 29},
  [4756] = {.lex_state = 29},
  [4757] = {.lex_state = 29},
  [4758] = {.lex_state = 29},
  [4759] = {.lex_state = 29},
  [4760] = {.lex_state = 29},
  [4761] = {.lex_state = 29},
  [4762] = {.lex_state = 29},
  [4763] = {.lex_state = 29},
  [4764] = {.lex_state = 29},
  [4765] = {.lex_state = 29},
  [4766] = {.lex_state = 29},
  [4767] = {.lex_state = 29},
  [4768] = {.lex_state = 29},
  [4769] = {.lex_state = 29},
  [4770] = {.lex_state = 29},
  [4771] = {.lex_state = 29},
  [4772] = {.lex_state = 29},
  [4773] = {.lex_state = 29},
  [4774] = {.lex_state = 29},
  [4775] = {.lex_state = 29},
  [4776] = {.lex_state = 29},
  [4777] = {.lex_state = 29},
  [4778] = {.lex_state = 29},
  [4779] = {.lex_state = 29},
  [4780] = {.lex_state = 29},
  [4781] = {.lex_state = 29},
  [4782] = {.lex_state = 29},
  [4783] = {.lex_state = 29},
  [4784] = {.lex_state = 29},
  [4785] = {.lex_state = 29},
  [4786] = {.lex_state = 29},
  [4787] = {.lex_state = 29},
  [4788] = {.lex_state = 29},
  [4789] = {.lex_state = 29},
  [4790] = {.lex_state = 29},
  [4791] = {.lex_state = 30, .external_lex_state = 2},
  [4792] = {.lex_state = 29},
  [4793] = {.lex_state = 29},
  [4794] = {.lex_state = 29},
  [4795] = {.lex_state = 29},
  [4796] = {.lex_state = 29},
  [4797] = {.lex_state = 29},
  [4798] = {.lex_state = 29},
  [4799] = {.lex_state = 30, .external_lex_state = 2},
  [4800] = {.lex_state = 29},
  [4801] = {.lex_state = 29},
  [4802] = {.lex_state = 29},
  [4803] = {.lex_state = 30, .external_lex_state = 2},
  [4804] = {.lex_state = 29},
  [4805] = {.lex_state = 29},
  [4806] = {.lex_state = 29},
  [4807] = {.lex_state = 30, .external_lex_state = 2},
  [4808] = {.lex_state = 29},
  [4809] = {.lex_state = 29},
  [4810] = {.lex_state = 29},
  [4811] = {.lex_state = 29},
  [4812] = {.lex_state = 29},
  [4813] = {.lex_state = 29},
  [4814] = {.lex_state = 29},
  [4815] = {.lex_state = 29},
  [4816] = {.lex_state = 30, .external_lex_state = 2},
  [4817] = {.lex_state = 29},
  [4818] = {.lex_state = 29},
  [4819] = {.lex_state = 29},
  [4820] = {.lex_state = 29},
  [4821] = {.lex_state = 30, .external_lex_state = 2},
  [4822] = {.lex_state = 29},
  [4823] = {.lex_state = 29},
  [4824] = {.lex_state = 29},
  [4825] = {.lex_state = 29},
  [4826] = {.lex_state = 29},
  [4827] = {.lex_state = 29},
  [4828] = {.lex_state = 30, .external_lex_state = 2},
  [4829] = {.lex_state = 29},
  [4830] = {.lex_state = 29},
  [4831] = {.lex_state = 29},
  [4832] = {.lex_state = 30, .external_lex_state = 2},
  [4833] = {.lex_state = 29},
  [4834] = {.lex_state = 29},
  [4835] = {.lex_state = 29},
  [4836] = {.lex_state = 29},
  [4837] = {.lex_state = 29},
  [4838] = {.lex_state = 29},
  [4839] = {.lex_state = 29},
  [4840] = {.lex_state = 29},
  [4841] = {.lex_state = 29},
  [4842] = {.lex_state = 29},
  [4843] = {.lex_state = 29},
  [4844] = {.lex_state = 29},
  [4845] = {.lex_state = 29},
  [4846] = {.lex_state = 29},
  [4847] = {.lex_state = 29},
  [4848] = {.lex_state = 29},
  [4849] = {.lex_state = 29},
  [4850] = {.lex_state = 29},
  [4851] = {.lex_state = 30, .external_lex_state = 2},
  [4852] = {.lex_state = 30, .external_lex_state = 2},
  [4853] = {.lex_state = 29},
  [4854] = {.lex_state = 30, .external_lex_state = 2},
  [4855] = {.lex_state = 29},
  [4856] = {.lex_state = 29},
  [4857] = {.lex_state = 29},
  [4858] = {.lex_state = 29},
  [4859] = {.lex_state = 29},
  [4860] = {.lex_state = 29},
  [4861] = {.lex_state = 29},
  [4862] = {.lex_state = 29},
  [4863] = {.lex_state = 29},
  [4864] = {.lex_state = 29},
  [4865] = {.lex_state = 29},
  [4866] = {.lex_state = 29},
  [4867] = {.lex_state = 29},
  [4868] = {.lex_state = 29},
  [4869] = {.lex_state = 29},
  [4870] = {.lex_state = 29},
  [4871] = {.lex_state = 29},
  [4872] = {.lex_state = 29},
  [4873] = {.lex_state = 29},
  [4874] = {.lex_state = 29},
  [4875] = {.lex_state = 29},
  [4876] = {.lex_state = 29},
  [4877] = {.lex_state = 29},
  [4878] = {.lex_state = 29},
  [4879] = {.lex_state = 29},
  [4880] = {.lex_state = 29},
  [4881] = {.lex_state = 29},
  [4882] = {.lex_state = 29},
  [4883] = {.lex_state = 29},
  [4884] = {.lex_state = 29},
  [4885] = {.lex_state = 29},
  [4886] = {.lex_state = 29},
  [4887] = {.lex_state = 29},
  [4888] = {.lex_state = 29},
  [4889] = {.lex_state = 29},
  [4890] = {.lex_state = 29},
  [4891] = {.lex_state = 29},
  [4892] = {.lex_state = 29},
  [4893] = {.lex_state = 29},
  [4894] = {.lex_state = 29},
  [4895] = {.lex_state = 29},
  [4896] = {.lex_state = 29},
  [4897] = {.lex_state = 29},
  [4898] = {.lex_state = 29},
  [4899] = {.lex_state = 29},
  [4900] = {.lex_state = 29},
  [4901] = {.lex_state = 29},
  [4902] = {.lex_state = 29},
  [4903] = {.lex_state = 29},
  [4904] = {.lex_state = 29},
  [4905] = {.lex_state = 29},
  [4906] = {.lex_state = 29},
  [4907] = {.lex_state = 29},
  [4908] = {.lex_state = 29},
  [4909] = {.lex_state = 29},
  [4910] = {.lex_state = 29},
  [4911] = {.lex_state = 29},
  [4912] = {.lex_state = 0},
  [4913] = {.lex_state = 29},
  [4914] = {.lex_state = 29},
  [4915] = {.lex_state = 29},
  [4916] = {.lex_state = 29},
  [4917] = {.lex_state = 29},
  [4918] = {.lex_state = 29},
  [4919] = {.lex_state = 0},
  [4920] = {.lex_state = 29},
  [4921] = {.lex_state = 29},
  [4922] = {.lex_state = 29},
  [4923] = {.lex_state = 29},
  [4924] = {.lex_state = 29},
  [4925] = {.lex_state = 29},
  [4926] = {.lex_state = 29},
  [4927] = {.lex_state = 29},
  [4928] = {.lex_state = 29},
  [4929] = {.lex_state = 29},
  [4930] = {.lex_state = 29},
  [4931] = {.lex_state = 29},
  [4932] = {.lex_state = 29},
  [4933] = {.lex_state = 29},
  [4934] = {.lex_state = 0},
  [4935] = {.lex_state = 29},
  [4936] = {.lex_state = 29},
  [4937] = {.lex_state = 29},
  [4938] = {.lex_state = 0},
  [4939] = {.lex_state = 29},
  [4940] = {.lex_state = 29},
  [4941] = {.lex_state = 29},
  [4942] = {.lex_state = 29},
  [4943] = {.lex_state = 29},
  [4944] = {.lex_state = 0},
  [4945] = {.lex_state = 0},
  [4946] = {.lex_state = 29},
  [4947] = {.lex_state = 29},
  [4948] = {.lex_state = 0},
  [4949] = {.lex_state = 29},
  [4950] = {.lex_state = 0},
  [4951] = {.lex_state = 29},
  [4952] = {.lex_state = 29},
  [4953] = {.lex_state = 29},
  [4954] = {.lex_state = 29},
  [4955] = {.lex_state = 29},
  [4956] = {.lex_state = 0},
  [4957] = {.lex_state = 29},
  [4958] = {.lex_state = 29},
  [4959] = {.lex_state = 29},
  [4960] = {.lex_state = 29},
  [4961] = {.lex_state = 29, .external_lex_state = 2},
  [4962] = {.lex_state = 29},
  [4963] = {.lex_state = 29},
  [4964] = {.lex_state = 29},
  [4965] = {.lex_state = 0},
  [4966] = {.lex_state = 29},
  [4967] = {.lex_state = 29},
  [4968] = {.lex_state = 29},
  [4969] = {.lex_state = 29},
  [4970] = {.lex_state = 29},
  [4971] = {.lex_state = 29},
  [4972] = {.lex_state = 29},
  [4973] = {.lex_state = 29},
  [4974] = {.lex_state = 29},
  [4975] = {.lex_state = 29},
  [4976] = {.lex_state = 29},
  [4977] = {.lex_state = 29},
  [4978] = {.lex_state = 29},
  [4979] = {.lex_state = 29},
  [4980] = {.lex_state = 29},
  [4981] = {.lex_state = 29},
  [4982] = {.lex_state = 0},
  [4983] = {.lex_state = 29},
  [4984] = {.lex_state = 29},
  [4985] = {.lex_state = 29},
  [4986] = {.lex_state = 29},
  [4987] = {.lex_state = 0},
  [4988] = {.lex_state = 29},
  [4989] = {.lex_state = 29},
  [4990] = {.lex_state = 0},
  [4991] = {.lex_state = 29},
  [4992] = {.lex_state = 29},
  [4993] = {.lex_state = 29},
  [4994] = {.lex_state = 29},
  [4995] = {.lex_state = 29},
  [4996] = {.lex_state = 29},
  [4997] = {.lex_state = 29},
  [4998] = {.lex_state = 29},
  [4999] = {.lex_state = 29},
  [5000] = {.lex_state = 29},
  [5001] = {.lex_state = 29},
  [5002] = {.lex_state = 29},
  [5003] = {.lex_state = 29},
  [5004] = {.lex_state = 29},
  [5005] = {.lex_state = 29},
  [5006] = {.lex_state = 29, .external_lex_state = 2},
  [5007] = {.lex_state = 29},
  [5008] = {.lex_state = 29},
  [5009] = {.lex_state = 29},
  [5010] = {.lex_state = 29},
  [5011] = {.lex_state = 29, .external_lex_state = 2},
  [5012] = {.lex_state = 29},
  [5013] = {.lex_state = 29},
  [5014] = {.lex_state = 29},
  [5015] = {.lex_state = 29, .external_lex_state = 2},
  [5016] = {.lex_state = 29, .external_lex_state = 2},
  [5017] = {.lex_state = 29, .external_lex_state = 2},
  [5018] = {.lex_state = 29},
  [5019] = {.lex_state = 29, .external_lex_state = 2},
  [5020] = {.lex_state = 0},
  [5021] = {.lex_state = 29, .external_lex_state = 2},
  [5022] = {.lex_state = 1, .external_lex_state = 2},
  [5023] = {.lex_state = 29},
  [5024] = {.lex_state = 29},
  [5025] = {.lex_state = 29},
  [5026] = {.lex_state = 29},
  [5027] = {.lex_state = 29},
  [5028] = {.lex_state = 29},
  [5029] = {.lex_state = 29},
  [5030] = {.lex_state = 29},
  [5031] = {.lex_state = 29},
  [5032] = {.lex_state = 29},
  [5033] = {.lex_state = 29},
  [5034] = {.lex_state = 29},
  [5035] = {.lex_state = 29},
  [5036] = {.lex_state = 1, .external_lex_state = 2},
  [5037] = {.lex_state = 0},
  [5038] = {.lex_state = 29},
  [5039] = {.lex_state = 29},
  [5040] = {.lex_state = 29},
  [5041] = {.lex_state = 29},
  [5042] = {.lex_state = 0},
  [5043] = {.lex_state = 29},
  [5044] = {.lex_state = 29},
  [5045] = {.lex_state = 29},
  [5046] = {.lex_state = 29},
  [5047] = {.lex_state = 29},
  [5048] = {.lex_state = 29},
  [5049] = {.lex_state = 29},
  [5050] = {.lex_state = 29},
  [5051] = {.lex_state = 29},
  [5052] = {.lex_state = 29},
  [5053] = {.lex_state = 29},
  [5054] = {.lex_state = 29},
  [5055] = {.lex_state = 29},
  [5056] = {.lex_state = 29},
  [5057] = {.lex_state = 29},
  [5058] = {.lex_state = 29},
  [5059] = {.lex_state = 29},
  [5060] = {.lex_state = 29, .external_lex_state = 2},
  [5061] = {.lex_state = 29},
  [5062] = {.lex_state = 29},
  [5063] = {.lex_state = 29},
  [5064] = {.lex_state = 0},
  [5065] = {.lex_state = 29},
  [5066] = {.lex_state = 29},
  [5067] = {.lex_state = 29},
  [5068] = {.lex_state = 29},
  [5069] = {.lex_state = 29},
  [5070] = {.lex_state = 29},
  [5071] = {.lex_state = 29},
  [5072] = {.lex_state = 29},
  [5073] = {.lex_state = 29},
  [5074] = {.lex_state = 29},
  [5075] = {.lex_state = 29},
  [5076] = {.lex_state = 29},
  [5077] = {.lex_state = 29},
  [5078] = {.lex_state = 29},
  [5079] = {.lex_state = 0},
  [5080] = {.lex_state = 29},
  [5081] = {.lex_state = 29, .external_lex_state = 2},
  [5082] = {.lex_state = 29},
  [5083] = {.lex_state = 29},
  [5084] = {.lex_state = 29},
  [5085] = {.lex_state = 29},
  [5086] = {.lex_state = 29},
  [5087] = {.lex_state = 29},
  [5088] = {.lex_state = 29},
  [5089] = {.lex_state = 29},
  [5090] = {.lex_state = 29},
  [5091] = {.lex_state = 29},
  [5092] = {.lex_state = 29},
  [5093] = {.lex_state = 29},
  [5094] = {.lex_state = 29},
  [5095] = {.lex_state = 0},
  [5096] = {.lex_state = 29},
  [5097] = {.lex_state = 0},
  [5098] = {.lex_state = 29},
  [5099] = {.lex_state = 29},
  [5100] = {.lex_state = 29},
  [5101] = {.lex_state = 29},
  [5102] = {.lex_state = 29},
  [5103] = {.lex_state = 29},
  [5104] = {.lex_state = 29},
  [5105] = {.lex_state = 29, .external_lex_state = 2},
  [5106] = {.lex_state = 29},
  [5107] = {.lex_state = 29},
  [5108] = {.lex_state = 29},
  [5109] = {.lex_state = 29},
  [5110] = {.lex_state = 29},
  [5111] = {.lex_state = 29},
  [5112] = {.lex_state = 29},
  [5113] = {.lex_state = 29},
  [5114] = {.lex_state = 29},
  [5115] = {.lex_state = 29},
  [5116] = {.lex_state = 29},
  [5117] = {.lex_state = 29},
  [5118] = {.lex_state = 29},
  [5119] = {.lex_state = 29},
  [5120] = {.lex_state = 29},
  [5121] = {.lex_state = 29},
  [5122] = {.lex_state = 29},
  [5123] = {.lex_state = 29},
  [5124] = {.lex_state = 29},
  [5125] = {.lex_state = 29},
  [5126] = {.lex_state = 29},
  [5127] = {.lex_state = 29},
  [5128] = {.lex_state = 29},
  [5129] = {.lex_state = 29},
  [5130] = {.lex_state = 29},
  [5131] = {.lex_state = 29},
  [5132] = {.lex_state = 29},
  [5133] = {.lex_state = 29},
  [5134] = {.lex_state = 29},
  [5135] = {.lex_state = 29},
  [5136] = {.lex_state = 29},
  [5137] = {.lex_state = 29},
  [5138] = {.lex_state = 29},
  [5139] = {.lex_state = 29},
  [5140] = {.lex_state = 29},
  [5141] = {.lex_state = 29},
  [5142] = {.lex_state = 29},
  [5143] = {.lex_state = 29},
  [5144] = {.lex_state = 0},
  [5145] = {.lex_state = 0},
  [5146] = {.lex_state = 29},
  [5147] = {.lex_state = 29},
  [5148] = {.lex_state = 29},
  [5149] = {.lex_state = 29},
  [5150] = {.lex_state = 29},
  [5151] = {.lex_state = 29},
  [5152] = {.lex_state = 29},
  [5153] = {.lex_state = 29, .external_lex_state = 2},
  [5154] = {.lex_state = 29},
  [5155] = {.lex_state = 0},
  [5156] = {.lex_state = 29},
  [5157] = {.lex_state = 29},
  [5158] = {.lex_state = 29},
  [5159] = {.lex_state = 29, .external_lex_state = 2},
  [5160] = {.lex_state = 29},
  [5161] = {.lex_state = 29},
  [5162] = {.lex_state = 29, .external_lex_state = 2},
  [5163] = {.lex_state = 29, .external_lex_state = 2},
  [5164] = {.lex_state = 29, .external_lex_state = 2},
  [5165] = {.lex_state = 29, .external_lex_state = 2},
  [5166] = {.lex_state = 29},
  [5167] = {.lex_state = 29},
  [5168] = {.lex_state = 29},
  [5169] = {.lex_state = 29},
  [5170] = {.lex_state = 29, .external_lex_state = 2},
  [5171] = {.lex_state = 29},
  [5172] = {.lex_state = 29, .external_lex_state = 2},
  [5173] = {.lex_state = 29},
  [5174] = {.lex_state = 29, .external_lex_state = 2},
  [5175] = {.lex_state = 29, .external_lex_state = 2},
  [5176] = {.lex_state = 0},
  [5177] = {.lex_state = 29, .external_lex_state = 2},
  [5178] = {.lex_state = 29},
  [5179] = {.lex_state = 29},
  [5180] = {.lex_state = 29},
  [5181] = {.lex_state = 0},
  [5182] = {.lex_state = 29},
  [5183] = {.lex_state = 29},
  [5184] = {.lex_state = 29},
  [5185] = {.lex_state = 29},
  [5186] = {.lex_state = 29},
  [5187] = {.lex_state = 29},
  [5188] = {.lex_state = 29},
  [5189] = {.lex_state = 29},
  [5190] = {.lex_state = 29},
  [5191] = {.lex_state = 29},
  [5192] = {.lex_state = 0},
  [5193] = {.lex_state = 29},
  [5194] = {.lex_state = 29},
  [5195] = {.lex_state = 29},
  [5196] = {.lex_state = 29},
  [5197] = {.lex_state = 29},
  [5198] = {.lex_state = 29},
  [5199] = {.lex_state = 29},
  [5200] = {.lex_state = 29},
  [5201] = {.lex_state = 0},
  [5202] = {.lex_state = 29},
  [5203] = {.lex_state = 29},
  [5204] = {.lex_state = 29},
  [5205] = {.lex_state = 29, .external_lex_state = 2},
  [5206] = {.lex_state = 29},
  [5207] = {.lex_state = 29},
  [5208] = {.lex_state = 29},
  [5209] = {.lex_state = 29},
  [5210] = {.lex_state = 29},
  [5211] = {.lex_state = 29},
  [5212] = {.lex_state = 29},
  [5213] = {.lex_state = 29},
  [5214] = {.lex_state = 29},
  [5215] = {.lex_state = 29},
  [5216] = {.lex_state = 29},
  [5217] = {.lex_state = 29},
  [5218] = {.lex_state = 29},
  [5219] = {.lex_state = 29},
  [5220] = {.lex_state = 29},
  [5221] = {.lex_state = 29},
  [5222] = {.lex_state = 29, .external_lex_state = 2},
  [5223] = {.lex_state = 29, .external_lex_state = 2},
  [5224] = {.lex_state = 29, .external_lex_state = 2},
  [5225] = {.lex_state = 29},
  [5226] = {.lex_state = 29},
  [5227] = {.lex_state = 29},
  [5228] = {.lex_state = 29},
  [5229] = {.lex_state = 29},
  [5230] = {.lex_state = 29},
  [5231] = {.lex_state = 29},
  [5232] = {.lex_state = 29},
  [5233] = {.lex_state = 0},
  [5234] = {.lex_state = 29},
  [5235] = {.lex_state = 29},
  [5236] = {.lex_state = 29},
  [5237] = {.lex_state = 29},
  [5238] = {.lex_state = 29},
  [5239] = {.lex_state = 0},
  [5240] = {.lex_state = 0},
  [5241] = {.lex_state = 29},
  [5242] = {.lex_state = 29},
  [5243] = {.lex_state = 29},
  [5244] = {.lex_state = 0},
  [5245] = {.lex_state = 29},
  [5246] = {.lex_state = 29},
  [5247] = {.lex_state = 0},
  [5248] = {.lex_state = 0},
  [5249] = {.lex_state = 29},
  [5250] = {.lex_state = 29},
  [5251] = {.lex_state = 29},
  [5252] = {.lex_state = 29},
  [5253] = {.lex_state = 29},
  [5254] = {.lex_state = 29},
  [5255] = {.lex_state = 29},
  [5256] = {.lex_state = 0},
  [5257] = {.lex_state = 29},
  [5258] = {.lex_state = 29},
  [5259] = {.lex_state = 29},
  [5260] = {.lex_state = 0},
  [5261] = {.lex_state = 29},
  [5262] = {.lex_state = 29},
  [5263] = {.lex_state = 29},
  [5264] = {.lex_state = 29},
  [5265] = {.lex_state = 29},
  [5266] = {.lex_state = 29},
  [5267] = {.lex_state = 29},
  [5268] = {.lex_state = 0},
  [5269] = {.lex_state = 29},
  [5270] = {.lex_state = 29},
  [5271] = {.lex_state = 29, .external_lex_state = 2},
  [5272] = {.lex_state = 0},
  [5273] = {.lex_state = 29},
  [5274] = {.lex_state = 29},
  [5275] = {.lex_state = 0},
  [5276] = {.lex_state = 29},
  [5277] = {.lex_state = 29},
  [5278] = {.lex_state = 29},
  [5279] = {.lex_state = 29},
  [5280] = {.lex_state = 29},
  [5281] = {.lex_state = 29},
  [5282] = {.lex_state = 29},
  [5283] = {.lex_state = 29},
  [5284] = {.lex_state = 29},
  [5285] = {.lex_state = 29},
  [5286] = {.lex_state = 29, .external_lex_state = 2},
  [5287] = {.lex_state = 0},
  [5288] = {.lex_state = 29},
  [5289] = {.lex_state = 0},
  [5290] = {.lex_state = 29, .external_lex_state = 2},
  [5291] = {.lex_state = 0},
  [5292] = {.lex_state = 29},
  [5293] = {.lex_state = 29},
  [5294] = {.lex_state = 29},
  [5295] = {.lex_state = 29},
  [5296] = {.lex_state = 29},
  [5297] = {.lex_state = 29},
  [5298] = {.lex_state = 0},
  [5299] = {.lex_state = 29},
  [5300] = {.lex_state = 29},
  [5301] = {.lex_state = 29},
  [5302] = {.lex_state = 29},
  [5303] = {.lex_state = 29},
  [5304] = {.lex_state = 0},
  [5305] = {.lex_state = 29},
  [5306] = {.lex_state = 29},
  [5307] = {.lex_state = 29},
  [5308] = {.lex_state = 29},
  [5309] = {.lex_state = 29},
  [5310] = {.lex_state = 29},
  [5311] = {.lex_state = 29},
  [5312] = {.lex_state = 29},
  [5313] = {.lex_state = 29},
  [5314] = {.lex_state = 29},
  [5315] = {.lex_state = 29},
  [5316] = {.lex_state = 29},
  [5317] = {.lex_state = 29},
  [5318] = {.lex_state = 29},
  [5319] = {.lex_state = 29},
  [5320] = {.lex_state = 29},
  [5321] = {.lex_state = 29},
  [5322] = {.lex_state = 29},
  [5323] = {.lex_state = 29},
  [5324] = {.lex_state = 29},
  [5325] = {.lex_state = 29},
  [5326] = {.lex_state = 29},
  [5327] = {.lex_state = 29},
  [5328] = {.lex_state = 29},
  [5329] = {.lex_state = 29},
  [5330] = {.lex_state = 29},
  [5331] = {.lex_state = 0},
  [5332] = {.lex_state = 29},
  [5333] = {.lex_state = 29},
  [5334] = {.lex_state = 29},
  [5335] = {.lex_state = 29},
  [5336] = {.lex_state = 29},
  [5337] = {.lex_state = 29},
  [5338] = {.lex_state = 29},
  [5339] = {.lex_state = 29},
  [5340] = {.lex_state = 29},
  [5341] = {.lex_state = 29},
  [5342] = {.lex_state = 29},
  [5343] = {.lex_state = 29},
  [5344] = {.lex_state = 29},
  [5345] = {.lex_state = 29},
  [5346] = {.lex_state = 29},
  [5347] = {.lex_state = 29},
  [5348] = {.lex_state = 29},
  [5349] = {.lex_state = 29},
  [5350] = {.lex_state = 29},
  [5351] = {.lex_state = 29},
  [5352] = {.lex_state = 29},
  [5353] = {.lex_state = 29},
  [5354] = {.lex_state = 29},
  [5355] = {.lex_state = 29},
  [5356] = {.lex_state = 0},
  [5357] = {.lex_state = 29},
  [5358] = {.lex_state = 29},
  [5359] = {.lex_state = 29},
  [5360] = {.lex_state = 29},
  [5361] = {.lex_state = 29},
  [5362] = {.lex_state = 29},
  [5363] = {.lex_state = 29},
  [5364] = {.lex_state = 29},
  [5365] = {.lex_state = 29},
  [5366] = {.lex_state = 29},
  [5367] = {.lex_state = 29},
  [5368] = {.lex_state = 29},
  [5369] = {.lex_state = 29},
  [5370] = {.lex_state = 29},
  [5371] = {.lex_state = 29},
  [5372] = {.lex_state = 29},
  [5373] = {.lex_state = 29},
  [5374] = {.lex_state = 29},
  [5375] = {.lex_state = 29},
  [5376] = {.lex_state = 29},
  [5377] = {.lex_state = 29},
  [5378] = {.lex_state = 29},
  [5379] = {.lex_state = 0},
  [5380] = {.lex_state = 29},
  [5381] = {.lex_state = 29},
  [5382] = {.lex_state = 29},
  [5383] = {.lex_state = 29},
  [5384] = {.lex_state = 0},
  [5385] = {.lex_state = 29},
  [5386] = {.lex_state = 29},
  [5387] = {.lex_state = 29},
  [5388] = {.lex_state = 29},
  [5389] = {.lex_state = 29},
  [5390] = {.lex_state = 29},
  [5391] = {.lex_state = 29},
  [5392] = {.lex_state = 29},
  [5393] = {.lex_state = 29},
  [5394] = {.lex_state = 29},
  [5395] = {.lex_state = 29},
  [5396] = {.lex_state = 29},
  [5397] = {.lex_state = 29},
  [5398] = {.lex_state = 29},
  [5399] = {.lex_state = 29},
  [5400] = {.lex_state = 29},
  [5401] = {.lex_state = 29},
  [5402] = {.lex_state = 29},
  [5403] = {.lex_state = 29},
  [5404] = {.lex_state = 0},
  [5405] = {.lex_state = 29},
  [5406] = {.lex_state = 29},
  [5407] = {.lex_state = 0},
  [5408] = {.lex_state = 29},
  [5409] = {.lex_state = 29},
  [5410] = {.lex_state = 29},
  [5411] = {.lex_state = 29},
  [5412] = {.lex_state = 29},
  [5413] = {.lex_state = 29},
  [5414] = {.lex_state = 29},
  [5415] = {.lex_state = 29},
  [5416] = {.lex_state = 29},
  [5417] = {.lex_state = 29},
  [5418] = {.lex_state = 29},
  [5419] = {.lex_state = 29},
  [5420] = {.lex_state = 29},
  [5421] = {.lex_state = 29},
  [5422] = {.lex_state = 29},
  [5423] = {.lex_state = 0},
  [5424] = {.lex_state = 0},
  [5425] = {.lex_state = 29},
  [5426] = {.lex_state = 29},
  [5427] = {.lex_state = 29},
  [5428] = {.lex_state = 29},
  [5429] = {.lex_state = 29},
  [5430] = {.lex_state = 29},
  [5431] = {.lex_state = 29},
  [5432] = {.lex_state = 29},
  [5433] = {.lex_state = 29},
  [5434] = {.lex_state = 29},
  [5435] = {.lex_state = 29},
  [5436] = {.lex_state = 29},
  [5437] = {.lex_state = 29},
  [5438] = {.lex_state = 29},
  [5439] = {.lex_state = 29},
  [5440] = {.lex_state = 29},
  [5441] = {.lex_state = 29},
  [5442] = {.lex_state = 29},
  [5443] = {.lex_state = 29},
  [5444] = {.lex_state = 29},
  [5445] = {.lex_state = 29},
  [5446] = {.lex_state = 29},
  [5447] = {.lex_state = 29},
  [5448] = {.lex_state = 29},
  [5449] = {.lex_state = 29},
  [5450] = {.lex_state = 29},
  [5451] = {.lex_state = 29},
  [5452] = {.lex_state = 29},
  [5453] = {.lex_state = 29},
  [5454] = {.lex_state = 29},
  [5455] = {.lex_state = 29},
  [5456] = {.lex_state = 29},
  [5457] = {.lex_state = 29},
  [5458] = {.lex_state = 29},
  [5459] = {.lex_state = 29},
  [5460] = {.lex_state = 29},
  [5461] = {.lex_state = 29},
  [5462] = {.lex_state = 29},
  [5463] = {.lex_state = 29},
  [5464] = {.lex_state = 29},
  [5465] = {.lex_state = 29},
  [5466] = {.lex_state = 29},
  [5467] = {.lex_state = 29},
  [5468] = {.lex_state = 29},
  [5469] = {.lex_state = 29},
  [5470] = {.lex_state = 29},
  [5471] = {.lex_state = 29},
  [5472] = {.lex_state = 29},
  [5473] = {.lex_state = 29},
  [5474] = {.lex_state = 29},
  [5475] = {.lex_state = 29},
  [5476] = {.lex_state = 29},
  [5477] = {.lex_state = 29},
  [5478] = {.lex_state = 29},
  [5479] = {.lex_state = 29},
  [5480] = {.lex_state = 29},
  [5481] = {.lex_state = 29},
  [5482] = {.lex_state = 0},
  [5483] = {.lex_state = 29},
  [5484] = {.lex_state = 29},
  [5485] = {.lex_state = 29},
  [5486] = {.lex_state = 29},
  [5487] = {.lex_state = 29},
  [5488] = {.lex_state = 29},
  [5489] = {.lex_state = 29},
  [5490] = {.lex_state = 29},
  [5491] = {.lex_state = 29},
  [5492] = {.lex_state = 29},
  [5493] = {.lex_state = 29},
  [5494] = {.lex_state = 29},
  [5495] = {.lex_state = 29},
  [5496] = {.lex_state = 29},
  [5497] = {.lex_state = 0},
  [5498] = {.lex_state = 29},
  [5499] = {.lex_state = 29},
  [5500] = {.lex_state = 29},
  [5501] = {.lex_state = 29},
  [5502] = {.lex_state = 29},
  [5503] = {.lex_state = 29},
  [5504] = {.lex_state = 29},
  [5505] = {.lex_state = 29},
  [5506] = {.lex_state = 29},
  [5507] = {.lex_state = 29},
  [5508] = {.lex_state = 29},
  [5509] = {.lex_state = 29},
  [5510] = {.lex_state = 29},
  [5511] = {.lex_state = 29},
  [5512] = {.lex_state = 29},
  [5513] = {.lex_state = 29},
  [5514] = {.lex_state = 29},
  [5515] = {.lex_state = 29},
  [5516] = {.lex_state = 29},
  [5517] = {.lex_state = 29},
  [5518] = {.lex_state = 29},
  [5519] = {.lex_state = 29},
  [5520] = {.lex_state = 29},
  [5521] = {.lex_state = 29},
  [5522] = {.lex_state = 29},
  [5523] = {.lex_state = 29},
  [5524] = {.lex_state = 29},
  [5525] = {.lex_state = 0},
  [5526] = {.lex_state = 29},
  [5527] = {.lex_state = 29},
  [5528] = {.lex_state = 29},
  [5529] = {.lex_state = 0},
  [5530] = {.lex_state = 29},
  [5531] = {.lex_state = 29},
  [5532] = {.lex_state = 29},
  [5533] = {.lex_state = 29},
  [5534] = {.lex_state = 29},
  [5535] = {.lex_state = 29},
  [5536] = {.lex_state = 29},
  [5537] = {.lex_state = 29},
  [5538] = {.lex_state = 29},
  [5539] = {.lex_state = 29},
  [5540] = {.lex_state = 29},
  [5541] = {.lex_state = 29},
  [5542] = {.lex_state = 29},
  [5543] = {.lex_state = 29},
  [5544] = {.lex_state = 29},
  [5545] = {.lex_state = 29},
  [5546] = {.lex_state = 29},
  [5547] = {.lex_state = 29},
  [5548] = {.lex_state = 29},
  [5549] = {.lex_state = 29},
  [5550] = {.lex_state = 29},
  [5551] = {.lex_state = 29},
  [5552] = {.lex_state = 0},
  [5553] = {.lex_state = 29},
  [5554] = {.lex_state = 29},
  [5555] = {.lex_state = 29},
  [5556] = {.lex_state = 29},
  [5557] = {.lex_state = 29},
  [5558] = {.lex_state = 29},
  [5559] = {.lex_state = 29},
  [5560] = {.lex_state = 29},
  [5561] = {.lex_state = 29},
  [5562] = {.lex_state = 29},
  [5563] = {.lex_state = 29},
  [5564] = {.lex_state = 29},
  [5565] = {.lex_state = 29},
  [5566] = {.lex_state = 29},
  [5567] = {.lex_state = 29},
  [5568] = {.lex_state = 29},
  [5569] = {.lex_state = 29},
  [5570] = {.lex_state = 0},
  [5571] = {.lex_state = 29},
  [5572] = {.lex_state = 29},
  [5573] = {.lex_state = 29},
  [5574] = {.lex_state = 29},
  [5575] = {.lex_state = 29},
  [5576] = {.lex_state = 29},
  [5577] = {.lex_state = 29},
  [5578] = {.lex_state = 29},
  [5579] = {.lex_state = 29},
  [5580] = {.lex_state = 29},
  [5581] = {.lex_state = 29},
  [5582] = {.lex_state = 29},
  [5583] = {.lex_state = 29},
  [5584] = {.lex_state = 0},
  [5585] = {.lex_state = 29},
  [5586] = {.lex_state = 29},
  [5587] = {.lex_state = 29},
  [5588] = {.lex_state = 29},
  [5589] = {.lex_state = 29},
  [5590] = {.lex_state = 29},
  [5591] = {.lex_state = 29},
  [5592] = {.lex_state = 29},
  [5593] = {.lex_state = 29},
  [5594] = {.lex_state = 29},
  [5595] = {.lex_state = 29},
  [5596] = {.lex_state = 29},
  [5597] = {.lex_state = 29},
  [5598] = {.lex_state = 29},
  [5599] = {.lex_state = 29},
  [5600] = {.lex_state = 29},
  [5601] = {.lex_state = 29},
  [5602] = {.lex_state = 29},
  [5603] = {.lex_state = 29},
  [5604] = {.lex_state = 29},
  [5605] = {.lex_state = 29},
  [5606] = {.lex_state = 29},
  [5607] = {.lex_state = 29},
  [5608] = {.lex_state = 29},
  [5609] = {.lex_state = 29},
  [5610] = {.lex_state = 29},
  [5611] = {.lex_state = 29},
  [5612] = {.lex_state = 29},
  [5613] = {.lex_state = 29},
  [5614] = {.lex_state = 29},
  [5615] = {.lex_state = 29},
  [5616] = {.lex_state = 29},
  [5617] = {.lex_state = 29},
  [5618] = {.lex_state = 29},
  [5619] = {.lex_state = 29},
  [5620] = {.lex_state = 29},
  [5621] = {.lex_state = 29},
  [5622] = {.lex_state = 29},
  [5623] = {.lex_state = 29},
  [5624] = {.lex_state = 29},
  [5625] = {.lex_state = 29},
  [5626] = {.lex_state = 29},
  [5627] = {.lex_state = 29},
  [5628] = {.lex_state = 29},
  [5629] = {.lex_state = 29},
  [5630] = {.lex_state = 29},
  [5631] = {.lex_state = 29},
  [5632] = {.lex_state = 29},
  [5633] = {.lex_state = 29},
  [5634] = {.lex_state = 29},
  [5635] = {.lex_state = 29},
  [5636] = {.lex_state = 29},
  [5637] = {.lex_state = 29},
  [5638] = {.lex_state = 29},
  [5639] = {.lex_state = 29},
  [5640] = {.lex_state = 29},
  [5641] = {.lex_state = 29},
  [5642] = {.lex_state = 29},
  [5643] = {.lex_state = 29},
  [5644] = {.lex_state = 29},
  [5645] = {.lex_state = 29},
  [5646] = {.lex_state = 29},
  [5647] = {.lex_state = 29},
  [5648] = {.lex_state = 29},
  [5649] = {.lex_state = 29},
  [5650] = {.lex_state = 0},
  [5651] = {.lex_state = 29},
  [5652] = {.lex_state = 29},
  [5653] = {.lex_state = 29},
  [5654] = {.lex_state = 29},
  [5655] = {.lex_state = 29},
  [5656] = {.lex_state = 29},
  [5657] = {.lex_state = 29},
  [5658] = {.lex_state = 29},
  [5659] = {.lex_state = 29},
  [5660] = {.lex_state = 29},
  [5661] = {.lex_state = 29},
  [5662] = {.lex_state = 29},
  [5663] = {.lex_state = 29},
  [5664] = {.lex_state = 29},
  [5665] = {.lex_state = 29},
  [5666] = {.lex_state = 29},
  [5667] = {.lex_state = 29},
  [5668] = {.lex_state = 29},
  [5669] = {.lex_state = 29},
  [5670] = {.lex_state = 29},
  [5671] = {.lex_state = 29},
  [5672] = {.lex_state = 29},
  [5673] = {.lex_state = 29},
  [5674] = {.lex_state = 29},
  [5675] = {.lex_state = 0},
  [5676] = {.lex_state = 29},
  [5677] = {.lex_state = 29},
  [5678] = {.lex_state = 29},
  [5679] = {.lex_state = 29},
  [5680] = {.lex_state = 29},
  [5681] = {.lex_state = 29},
  [5682] = {.lex_state = 29},
  [5683] = {.lex_state = 29},
  [5684] = {.lex_state = 29},
  [5685] = {.lex_state = 29},
  [5686] = {.lex_state = 29},
  [5687] = {.lex_state = 29},
  [5688] = {.lex_state = 29},
  [5689] = {.lex_state = 29},
  [5690] = {.lex_state = 29},
  [5691] = {.lex_state = 29},
  [5692] = {.lex_state = 29},
  [5693] = {.lex_state = 29},
  [5694] = {.lex_state = 29},
  [5695] = {.lex_state = 29},
  [5696] = {.lex_state = 29},
  [5697] = {.lex_state = 29},
  [5698] = {.lex_state = 29},
  [5699] = {.lex_state = 29},
  [5700] = {.lex_state = 29},
  [5701] = {.lex_state = 29},
  [5702] = {.lex_state = 29},
  [5703] = {.lex_state = 29},
  [5704] = {.lex_state = 29},
  [5705] = {.lex_state = 29},
  [5706] = {.lex_state = 29},
  [5707] = {.lex_state = 0},
  [5708] = {.lex_state = 29},
  [5709] = {.lex_state = 29},
  [5710] = {.lex_state = 29},
  [5711] = {.lex_state = 29},
  [5712] = {.lex_state = 29},
  [5713] = {.lex_state = 29},
  [5714] = {.lex_state = 29},
  [5715] = {.lex_state = 29},
  [5716] = {.lex_state = 29},
  [5717] = {.lex_state = 29},
  [5718] = {.lex_state = 29},
  [5719] = {.lex_state = 29},
  [5720] = {.lex_state = 29},
  [5721] = {.lex_state = 29},
  [5722] = {.lex_state = 29},
  [5723] = {.lex_state = 29},
  [5724] = {.lex_state = 29},
  [5725] = {.lex_state = 29},
  [5726] = {.lex_state = 29},
  [5727] = {.lex_state = 29},
  [5728] = {.lex_state = 29},
  [5729] = {.lex_state = 29},
  [5730] = {.lex_state = 29},
  [5731] = {.lex_state = 29},
  [5732] = {.lex_state = 29},
  [5733] = {.lex_state = 29},
  [5734] = {.lex_state = 29},
  [5735] = {.lex_state = 29},
  [5736] = {.lex_state = 29},
  [5737] = {.lex_state = 29},
  [5738] = {.lex_state = 29},
  [5739] = {.lex_state = 29},
  [5740] = {.lex_state = 29},
  [5741] = {.lex_state = 29},
  [5742] = {.lex_state = 29},
  [5743] = {.lex_state = 29},
  [5744] = {.lex_state = 29},
  [5745] = {.lex_state = 29},
  [5746] = {.lex_state = 29},
  [5747] = {.lex_state = 29},
  [5748] = {.lex_state = 29},
  [5749] = {.lex_state = 29},
  [5750] = {.lex_state = 29},
  [5751] = {.lex_state = 29},
  [5752] = {.lex_state = 29},
  [5753] = {.lex_state = 29},
  [5754] = {.lex_state = 29},
  [5755] = {.lex_state = 29},
  [5756] = {.lex_state = 29},
  [5757] = {.lex_state = 29},
  [5758] = {.lex_state = 29},
  [5759] = {.lex_state = 0},
  [5760] = {.lex_state = 29},
  [5761] = {.lex_state = 29},
  [5762] = {.lex_state = 0},
  [5763] = {.lex_state = 29},
  [5764] = {.lex_state = 29},
  [5765] = {.lex_state = 29},
  [5766] = {.lex_state = 29},
  [5767] = {.lex_state = 29},
  [5768] = {.lex_state = 29},
  [5769] = {.lex_state = 29},
  [5770] = {.lex_state = 29},
  [5771] = {.lex_state = 29},
  [5772] = {.lex_state = 29},
  [5773] = {.lex_state = 0},
  [5774] = {.lex_state = 29},
  [5775] = {.lex_state = 29},
  [5776] = {.lex_state = 29},
  [5777] = {.lex_state = 29},
  [5778] = {.lex_state = 29},
  [5779] = {.lex_state = 0},
  [5780] = {.lex_state = 29},
  [5781] = {.lex_state = 29},
  [5782] = {.lex_state = 29},
  [5783] = {.lex_state = 29},
  [5784] = {.lex_state = 29},
  [5785] = {.lex_state = 29},
  [5786] = {.lex_state = 29},
  [5787] = {.lex_state = 29},
  [5788] = {.lex_state = 29},
  [5789] = {.lex_state = 29},
  [5790] = {.lex_state = 29},
  [5791] = {.lex_state = 29},
  [5792] = {.lex_state = 29},
  [5793] = {.lex_state = 0},
  [5794] = {.lex_state = 29},
  [5795] = {.lex_state = 29},
  [5796] = {.lex_state = 29},
  [5797] = {.lex_state = 29},
  [5798] = {.lex_state = 29},
  [5799] = {.lex_state = 29},
  [5800] = {.lex_state = 29},
  [5801] = {.lex_state = 29},
  [5802] = {.lex_state = 29},
  [5803] = {.lex_state = 29},
  [5804] = {.lex_state = 29},
  [5805] = {.lex_state = 0},
  [5806] = {.lex_state = 29},
  [5807] = {.lex_state = 29},
  [5808] = {.lex_state = 29},
  [5809] = {.lex_state = 29},
  [5810] = {.lex_state = 29},
  [5811] = {.lex_state = 29},
  [5812] = {.lex_state = 29},
  [5813] = {.lex_state = 29},
  [5814] = {.lex_state = 29},
  [5815] = {.lex_state = 29},
  [5816] = {.lex_state = 29},
  [5817] = {.lex_state = 29},
  [5818] = {.lex_state = 29},
  [5819] = {.lex_state = 29},
  [5820] = {.lex_state = 29},
  [5821] = {.lex_state = 29},
  [5822] = {.lex_state = 29},
  [5823] = {.lex_state = 29},
  [5824] = {.lex_state = 29},
  [5825] = {.lex_state = 29},
  [5826] = {.lex_state = 29},
  [5827] = {.lex_state = 29},
  [5828] = {.lex_state = 29},
  [5829] = {.lex_state = 29},
  [5830] = {.lex_state = 29},
  [5831] = {.lex_state = 0},
  [5832] = {.lex_state = 29},
  [5833] = {.lex_state = 29},
  [5834] = {.lex_state = 29},
  [5835] = {.lex_state = 29},
  [5836] = {.lex_state = 0},
  [5837] = {.lex_state = 29},
  [5838] = {.lex_state = 0},
  [5839] = {.lex_state = 0},
  [5840] = {.lex_state = 29},
  [5841] = {.lex_state = 29},
  [5842] = {.lex_state = 29},
  [5843] = {.lex_state = 29},
  [5844] = {.lex_state = 0},
  [5845] = {.lex_state = 29},
  [5846] = {.lex_state = 29},
  [5847] = {.lex_state = 29},
  [5848] = {.lex_state = 29},
  [5849] = {.lex_state = 29},
  [5850] = {.lex_state = 0},
  [5851] = {.lex_state = 29},
  [5852] = {.lex_state = 29},
  [5853] = {.lex_state = 29},
  [5854] = {.lex_state = 29},
  [5855] = {.lex_state = 29},
  [5856] = {.lex_state = 0},
  [5857] = {.lex_state = 29},
  [5858] = {.lex_state = 29},
  [5859] = {.lex_state = 29},
  [5860] = {.lex_state = 29},
  [5861] = {.lex_state = 29},
  [5862] = {.lex_state = 29},
  [5863] = {.lex_state = 29},
  [5864] = {.lex_state = 29},
  [5865] = {.lex_state = 29},
  [5866] = {.lex_state = 29},
  [5867] = {.lex_state = 29},
  [5868] = {.lex_state = 29},
  [5869] = {.lex_state = 29},
  [5870] = {.lex_state = 29},
  [5871] = {.lex_state = 29},
  [5872] = {.lex_state = 29},
  [5873] = {.lex_state = 29},
  [5874] = {.lex_state = 29},
  [5875] = {.lex_state = 29},
  [5876] = {.lex_state = 29},
  [5877] = {.lex_state = 29},
  [5878] = {.lex_state = 29},
  [5879] = {.lex_state = 29},
  [5880] = {.lex_state = 29},
  [5881] = {.lex_state = 29},
  [5882] = {.lex_state = 29},
  [5883] = {.lex_state = 29},
  [5884] = {.lex_state = 29},
  [5885] = {.lex_state = 29},
  [5886] = {.lex_state = 29},
  [5887] = {.lex_state = 0},
  [5888] = {.lex_state = 29},
  [5889] = {.lex_state = 29},
  [5890] = {.lex_state = 29},
  [5891] = {.lex_state = 29},
  [5892] = {.lex_state = 29},
  [5893] = {.lex_state = 29},
  [5894] = {.lex_state = 29},
  [5895] = {.lex_state = 29},
  [5896] = {.lex_state = 29},
  [5897] = {.lex_state = 29},
  [5898] = {.lex_state = 29},
  [5899] = {.lex_state = 29},
  [5900] = {.lex_state = 29},
  [5901] = {.lex_state = 29},
  [5902] = {.lex_state = 0},
  [5903] = {.lex_state = 29},
  [5904] = {.lex_state = 29},
  [5905] = {.lex_state = 0},
  [5906] = {.lex_state = 29},
  [5907] = {.lex_state = 0},
  [5908] = {.lex_state = 0},
  [5909] = {.lex_state = 0},
  [5910] = {.lex_state = 0},
  [5911] = {.lex_state = 29},
  [5912] = {.lex_state = 0},
  [5913] = {.lex_state = 29},
  [5914] = {.lex_state = 0},
  [5915] = {.lex_state = 0},
  [5916] = {.lex_state = 0},
  [5917] = {.lex_state = 0},
  [5918] = {.lex_state = 29, .external_lex_state = 2},
  [5919] = {.lex_state = 0},
  [5920] = {.lex_state = 0},
  [5921] = {.lex_state = 0},
  [5922] = {.lex_state = 0},
  [5923] = {.lex_state = 0},
  [5924] = {.lex_state = 0},
  [5925] = {.lex_state = 0},
  [5926] = {.lex_state = 0},
  [5927] = {.lex_state = 0},
  [5928] = {.lex_state = 0},
  [5929] = {.lex_state = 0},
  [5930] = {.lex_state = 0},
  [5931] = {.lex_state = 29, .external_lex_state = 2},
  [5932] = {.lex_state = 0},
  [5933] = {.lex_state = 0},
  [5934] = {.lex_state = 0},
  [5935] = {.lex_state = 0},
  [5936] = {.lex_state = 0},
  [5937] = {.lex_state = 0},
  [5938] = {.lex_state = 0},
  [5939] = {.lex_state = 0},
  [5940] = {.lex_state = 29},
  [5941] = {.lex_state = 29},
  [5942] = {.lex_state = 0},
  [5943] = {.lex_state = 0},
  [5944] = {.lex_state = 0},
  [5945] = {.lex_state = 0},
  [5946] = {.lex_state = 0},
  [5947] = {.lex_state = 0},
  [5948] = {.lex_state = 0},
  [5949] = {.lex_state = 0},
  [5950] = {.lex_state = 29},
  [5951] = {.lex_state = 0},
  [5952] = {.lex_state = 0},
  [5953] = {.lex_state = 0},
  [5954] = {.lex_state = 0},
  [5955] = {.lex_state = 0},
  [5956] = {.lex_state = 0},
  [5957] = {.lex_state = 0},
  [5958] = {.lex_state = 0},
  [5959] = {.lex_state = 0},
  [5960] = {.lex_state = 0},
  [5961] = {.lex_state = 0},
  [5962] = {.lex_state = 0},
  [5963] = {.lex_state = 0},
  [5964] = {.lex_state = 29, .external_lex_state = 2},
  [5965] = {.lex_state = 0},
  [5966] = {.lex_state = 0},
  [5967] = {.lex_state = 0},
  [5968] = {.lex_state = 0},
  [5969] = {.lex_state = 0},
  [5970] = {.lex_state = 0},
  [5971] = {.lex_state = 0},
  [5972] = {.lex_state = 0},
  [5973] = {.lex_state = 29, .external_lex_state = 2},
  [5974] = {.lex_state = 29},
  [5975] = {.lex_state = 0},
  [5976] = {.lex_state = 0},
  [5977] = {.lex_state = 0},
  [5978] = {.lex_state = 0},
  [5979] = {.lex_state = 0},
  [5980] = {.lex_state = 0},
  [5981] = {.lex_state = 29, .external_lex_state = 2},
  [5982] = {.lex_state = 0},
  [5983] = {.lex_state = 29},
  [5984] = {.lex_state = 0},
  [5985] = {.lex_state = 0},
  [5986] = {.lex_state = 0},
  [5987] = {.lex_state = 29},
  [5988] = {.lex_state = 0},
  [5989] = {.lex_state = 0},
  [5990] = {.lex_state = 0},
  [5991] = {.lex_state = 0},
  [5992] = {.lex_state = 0},
  [5993] = {.lex_state = 29},
  [5994] = {.lex_state = 0},
  [5995] = {.lex_state = 0},
  [5996] = {.lex_state = 0},
  [5997] = {.lex_state = 0},
  [5998] = {.lex_state = 0},
  [5999] = {.lex_state = 0},
  [6000] = {.lex_state = 0},
  [6001] = {.lex_state = 0},
  [6002] = {.lex_state = 0},
  [6003] = {.lex_state = 29},
  [6004] = {.lex_state = 0},
  [6005] = {.lex_state = 30},
  [6006] = {.lex_state = 0},
  [6007] = {.lex_state = 29},
  [6008] = {.lex_state = 0},
  [6009] = {.lex_state = 0},
  [6010] = {.lex_state = 30},
  [6011] = {.lex_state = 0},
  [6012] = {.lex_state = 0},
  [6013] = {.lex_state = 30},
  [6014] = {.lex_state = 0},
  [6015] = {.lex_state = 30},
  [6016] = {.lex_state = 30},
  [6017] = {.lex_state = 1, .external_lex_state = 2},
  [6018] = {.lex_state = 0},
  [6019] = {.lex_state = 29},
  [6020] = {.lex_state = 0},
  [6021] = {.lex_state = 0},
  [6022] = {.lex_state = 0},
  [6023] = {.lex_state = 0},
  [6024] = {.lex_state = 30},
  [6025] = {.lex_state = 0},
  [6026] = {.lex_state = 0},
  [6027] = {.lex_state = 0},
  [6028] = {.lex_state = 30},
  [6029] = {.lex_state = 0},
  [6030] = {.lex_state = 30},
  [6031] = {.lex_state = 30},
  [6032] = {.lex_state = 0},
  [6033] = {.lex_state = 0},
  [6034] = {.lex_state = 30},
  [6035] = {.lex_state = 0},
  [6036] = {.lex_state = 0},
  [6037] = {.lex_state = 1, .external_lex_state = 2},
  [6038] = {.lex_state = 0},
  [6039] = {.lex_state = 0},
  [6040] = {.lex_state = 0},
  [6041] = {.lex_state = 0},
  [6042] = {.lex_state = 0},
  [6043] = {.lex_state = 0},
  [6044] = {.lex_state = 0},
  [6045] = {.lex_state = 0},
  [6046] = {.lex_state = 0},
  [6047] = {.lex_state = 0},
  [6048] = {.lex_state = 0},
  [6049] = {.lex_state = 0},
  [6050] = {.lex_state = 0},
  [6051] = {.lex_state = 0},
  [6052] = {.lex_state = 0},
  [6053] = {.lex_state = 0},
  [6054] = {.lex_state = 0},
  [6055] = {.lex_state = 0},
  [6056] = {.lex_state = 0},
  [6057] = {.lex_state = 0},
  [6058] = {.lex_state = 1, .external_lex_state = 2},
  [6059] = {.lex_state = 0},
  [6060] = {.lex_state = 0},
  [6061] = {.lex_state = 1, .external_lex_state = 2},
  [6062] = {.lex_state = 0},
  [6063] = {.lex_state = 0},
  [6064] = {.lex_state = 0},
  [6065] = {.lex_state = 0},
  [6066] = {.lex_state = 0},
  [6067] = {.lex_state = 0},
  [6068] = {.lex_state = 0},
  [6069] = {.lex_state = 0},
  [6070] = {.lex_state = 0},
  [6071] = {.lex_state = 0},
  [6072] = {.lex_state = 0},
  [6073] = {.lex_state = 0},
  [6074] = {.lex_state = 0},
  [6075] = {.lex_state = 0},
  [6076] = {.lex_state = 0},
  [6077] = {.lex_state = 0},
  [6078] = {.lex_state = 0},
  [6079] = {.lex_state = 0},
  [6080] = {.lex_state = 0},
  [6081] = {.lex_state = 0},
  [6082] = {.lex_state = 0},
  [6083] = {.lex_state = 0},
  [6084] = {.lex_state = 0},
  [6085] = {.lex_state = 0},
  [6086] = {.lex_state = 0},
  [6087] = {.lex_state = 0},
  [6088] = {.lex_state = 0},
  [6089] = {.lex_state = 0},
  [6090] = {.lex_state = 0},
  [6091] = {.lex_state = 0},
  [6092] = {.lex_state = 0},
  [6093] = {.lex_state = 0},
  [6094] = {.lex_state = 0},
  [6095] = {.lex_state = 0},
  [6096] = {.lex_state = 0},
  [6097] = {.lex_state = 0},
  [6098] = {.lex_state = 0},
  [6099] = {.lex_state = 0},
  [6100] = {.lex_state = 0},
  [6101] = {.lex_state = 0},
  [6102] = {.lex_state = 0},
  [6103] = {.lex_state = 0},
  [6104] = {.lex_state = 0},
  [6105] = {.lex_state = 0},
  [6106] = {.lex_state = 0},
  [6107] = {.lex_state = 0},
  [6108] = {.lex_state = 0},
  [6109] = {.lex_state = 0},
  [6110] = {.lex_state = 0},
  [6111] = {.lex_state = 0},
  [6112] = {.lex_state = 0},
  [6113] = {.lex_state = 0},
  [6114] = {.lex_state = 0},
  [6115] = {.lex_state = 0},
  [6116] = {.lex_state = 0},
  [6117] = {.lex_state = 0},
  [6118] = {.lex_state = 0},
  [6119] = {.lex_state = 0},
  [6120] = {.lex_state = 0},
  [6121] = {.lex_state = 0},
  [6122] = {.lex_state = 0},
  [6123] = {.lex_state = 0},
  [6124] = {.lex_state = 0},
  [6125] = {.lex_state = 0},
  [6126] = {.lex_state = 0},
  [6127] = {.lex_state = 0},
  [6128] = {.lex_state = 0},
  [6129] = {.lex_state = 0},
  [6130] = {.lex_state = 0},
  [6131] = {.lex_state = 0},
  [6132] = {.lex_state = 0},
  [6133] = {.lex_state = 0},
  [6134] = {.lex_state = 0},
  [6135] = {.lex_state = 0},
  [6136] = {.lex_state = 0},
  [6137] = {.lex_state = 0},
  [6138] = {.lex_state = 0},
  [6139] = {.lex_state = 0},
  [6140] = {.lex_state = 0},
  [6141] = {.lex_state = 0},
  [6142] = {.lex_state = 0},
  [6143] = {.lex_state = 0},
  [6144] = {.lex_state = 0},
  [6145] = {.lex_state = 0},
  [6146] = {.lex_state = 2},
  [6147] = {.lex_state = 0},
  [6148] = {.lex_state = 0},
  [6149] = {.lex_state = 0},
  [6150] = {.lex_state = 0},
  [6151] = {.lex_state = 0},
  [6152] = {.lex_state = 0},
  [6153] = {.lex_state = 0},
  [6154] = {.lex_state = 0},
  [6155] = {.lex_state = 0},
  [6156] = {.lex_state = 0},
  [6157] = {.lex_state = 0},
  [6158] = {.lex_state = 0},
  [6159] = {.lex_state = 0},
  [6160] = {.lex_state = 0},
  [6161] = {.lex_state = 0},
  [6162] = {.lex_state = 0},
  [6163] = {.lex_state = 0},
  [6164] = {.lex_state = 0},
  [6165] = {.lex_state = 0},
  [6166] = {.lex_state = 0},
  [6167] = {.lex_state = 0},
  [6168] = {.lex_state = 0},
  [6169] = {.lex_state = 0},
  [6170] = {.lex_state = 0},
  [6171] = {.lex_state = 0},
  [6172] = {.lex_state = 0},
  [6173] = {.lex_state = 0},
  [6174] = {.lex_state = 0},
  [6175] = {.lex_state = 2},
  [6176] = {.lex_state = 0},
  [6177] = {.lex_state = 1, .external_lex_state = 2},
  [6178] = {.lex_state = 0},
  [6179] = {.lex_state = 0},
  [6180] = {.lex_state = 0},
  [6181] = {.lex_state = 0},
  [6182] = {.lex_state = 0},
  [6183] = {.lex_state = 2},
  [6184] = {.lex_state = 0},
  [6185] = {.lex_state = 1, .external_lex_state = 2},
  [6186] = {.lex_state = 0},
  [6187] = {.lex_state = 0},
  [6188] = {.lex_state = 0},
  [6189] = {.lex_state = 0},
  [6190] = {.lex_state = 0},
  [6191] = {.lex_state = 0},
  [6192] = {.lex_state = 0},
  [6193] = {.lex_state = 0},
  [6194] = {.lex_state = 0},
  [6195] = {.lex_state = 0},
  [6196] = {.lex_state = 0},
  [6197] = {.lex_state = 0},
  [6198] = {.lex_state = 0},
  [6199] = {.lex_state = 0},
  [6200] = {.lex_state = 0},
  [6201] = {.lex_state = 0},
  [6202] = {.lex_state = 0},
  [6203] = {.lex_state = 0},
  [6204] = {.lex_state = 0},
  [6205] = {.lex_state = 0},
  [6206] = {.lex_state = 0},
  [6207] = {.lex_state = 0},
  [6208] = {.lex_state = 0},
  [6209] = {.lex_state = 0},
  [6210] = {.lex_state = 0},
  [6211] = {.lex_state = 0},
  [6212] = {.lex_state = 0},
  [6213] = {.lex_state = 0},
  [6214] = {.lex_state = 0},
  [6215] = {.lex_state = 0},
  [6216] = {.lex_state = 0},
  [6217] = {.lex_state = 0},
  [6218] = {.lex_state = 0},
  [6219] = {.lex_state = 0},
  [6220] = {.lex_state = 0},
  [6221] = {.lex_state = 0},
  [6222] = {.lex_state = 0},
  [6223] = {.lex_state = 0},
  [6224] = {.lex_state = 0},
  [6225] = {.lex_state = 0},
  [6226] = {.lex_state = 0},
  [6227] = {.lex_state = 0},
  [6228] = {.lex_state = 0},
  [6229] = {.lex_state = 0},
  [6230] = {.lex_state = 0},
  [6231] = {.lex_state = 0},
  [6232] = {.lex_state = 0},
  [6233] = {.lex_state = 0},
  [6234] = {.lex_state = 0},
  [6235] = {.lex_state = 0},
  [6236] = {.lex_state = 0},
  [6237] = {.lex_state = 0},
  [6238] = {.lex_state = 0},
  [6239] = {.lex_state = 0},
  [6240] = {.lex_state = 0},
  [6241] = {.lex_state = 0},
  [6242] = {.lex_state = 0},
  [6243] = {.lex_state = 0},
  [6244] = {.lex_state = 0},
  [6245] = {.lex_state = 0},
  [6246] = {.lex_state = 0},
  [6247] = {.lex_state = 0},
  [6248] = {.lex_state = 0},
  [6249] = {.lex_state = 0},
  [6250] = {.lex_state = 0},
  [6251] = {.lex_state = 0},
  [6252] = {.lex_state = 0},
  [6253] = {.lex_state = 0},
  [6254] = {.lex_state = 0},
  [6255] = {.lex_state = 0},
  [6256] = {.lex_state = 0},
  [6257] = {.lex_state = 0},
  [6258] = {.lex_state = 0},
  [6259] = {.lex_state = 0},
  [6260] = {.lex_state = 0},
  [6261] = {.lex_state = 0},
  [6262] = {.lex_state = 0},
  [6263] = {.lex_state = 0},
  [6264] = {.lex_state = 0},
  [6265] = {.lex_state = 0},
  [6266] = {.lex_state = 0},
  [6267] = {.lex_state = 0},
  [6268] = {.lex_state = 0},
  [6269] = {.lex_state = 0},
  [6270] = {.lex_state = 0},
  [6271] = {.lex_state = 0},
  [6272] = {.lex_state = 0},
  [6273] = {.lex_state = 0},
  [6274] = {.lex_state = 0},
  [6275] = {.lex_state = 0},
  [6276] = {.lex_state = 0},
  [6277] = {.lex_state = 0},
  [6278] = {.lex_state = 0},
  [6279] = {.lex_state = 0},
  [6280] = {.lex_state = 0},
  [6281] = {.lex_state = 0},
  [6282] = {.lex_state = 0},
  [6283] = {.lex_state = 0},
  [6284] = {.lex_state = 0},
  [6285] = {.lex_state = 0},
  [6286] = {.lex_state = 0},
  [6287] = {.lex_state = 0},
  [6288] = {.lex_state = 0},
  [6289] = {.lex_state = 0},
  [6290] = {.lex_state = 0},
  [6291] = {.lex_state = 0},
  [6292] = {.lex_state = 0},
  [6293] = {.lex_state = 0},
  [6294] = {.lex_state = 0},
  [6295] = {.lex_state = 0},
  [6296] = {.lex_state = 0},
  [6297] = {.lex_state = 0},
  [6298] = {.lex_state = 0},
  [6299] = {.lex_state = 0},
  [6300] = {.lex_state = 0},
  [6301] = {.lex_state = 0},
  [6302] = {.lex_state = 0},
  [6303] = {.lex_state = 0},
  [6304] = {.lex_state = 0},
  [6305] = {.lex_state = 0},
  [6306] = {.lex_state = 0},
  [6307] = {.lex_state = 0},
  [6308] = {.lex_state = 0},
  [6309] = {.lex_state = 0},
  [6310] = {.lex_state = 0},
  [6311] = {.lex_state = 0},
  [6312] = {.lex_state = 0},
  [6313] = {.lex_state = 0},
  [6314] = {.lex_state = 0},
  [6315] = {.lex_state = 0},
  [6316] = {.lex_state = 0},
  [6317] = {.lex_state = 0},
  [6318] = {.lex_state = 0},
  [6319] = {.lex_state = 0},
  [6320] = {.lex_state = 0},
  [6321] = {.lex_state = 0},
  [6322] = {.lex_state = 0},
  [6323] = {.lex_state = 2},
  [6324] = {.lex_state = 0},
  [6325] = {.lex_state = 0},
  [6326] = {.lex_state = 0},
  [6327] = {.lex_state = 0},
  [6328] = {.lex_state = 0},
  [6329] = {.lex_state = 0},
  [6330] = {.lex_state = 0},
  [6331] = {.lex_state = 0},
  [6332] = {.lex_state = 0},
  [6333] = {.lex_state = 0},
  [6334] = {.lex_state = 0},
  [6335] = {.lex_state = 0},
  [6336] = {.lex_state = 0},
  [6337] = {.lex_state = 0},
  [6338] = {.lex_state = 0},
  [6339] = {.lex_state = 0},
  [6340] = {.lex_state = 0},
  [6341] = {.lex_state = 0},
  [6342] = {.lex_state = 0},
  [6343] = {.lex_state = 0},
  [6344] = {.lex_state = 0},
  [6345] = {.lex_state = 0},
  [6346] = {.lex_state = 0},
  [6347] = {.lex_state = 0},
  [6348] = {.lex_state = 0},
  [6349] = {.lex_state = 0},
  [6350] = {.lex_state = 0},
  [6351] = {.lex_state = 0},
  [6352] = {.lex_state = 0},
  [6353] = {.lex_state = 0},
  [6354] = {.lex_state = 0},
  [6355] = {.lex_state = 0},
  [6356] = {.lex_state = 2},
  [6357] = {.lex_state = 2},
  [6358] = {.lex_state = 0},
  [6359] = {.lex_state = 0},
  [6360] = {.lex_state = 0},
  [6361] = {.lex_state = 0},
  [6362] = {.lex_state = 0},
  [6363] = {.lex_state = 0},
  [6364] = {.lex_state = 0},
  [6365] = {.lex_state = 0},
  [6366] = {.lex_state = 0},
  [6367] = {.lex_state = 0},
  [6368] = {.lex_state = 0},
  [6369] = {.lex_state = 0},
  [6370] = {.lex_state = 2},
  [6371] = {.lex_state = 0},
  [6372] = {.lex_state = 0},
  [6373] = {.lex_state = 0},
  [6374] = {.lex_state = 0},
  [6375] = {.lex_state = 0},
  [6376] = {.lex_state = 0},
  [6377] = {.lex_state = 0},
  [6378] = {.lex_state = 0},
  [6379] = {.lex_state = 0},
  [6380] = {.lex_state = 0},
  [6381] = {.lex_state = 0},
  [6382] = {.lex_state = 0},
  [6383] = {.lex_state = 0},
  [6384] = {.lex_state = 0},
  [6385] = {.lex_state = 0},
  [6386] = {.lex_state = 0},
  [6387] = {.lex_state = 0},
  [6388] = {.lex_state = 0},
  [6389] = {.lex_state = 0},
  [6390] = {.lex_state = 0},
  [6391] = {.lex_state = 0},
  [6392] = {.lex_state = 0},
  [6393] = {.lex_state = 0},
  [6394] = {.lex_state = 0},
  [6395] = {.lex_state = 0},
  [6396] = {.lex_state = 0},
  [6397] = {.lex_state = 0},
  [6398] = {.lex_state = 0},
  [6399] = {.lex_state = 0},
  [6400] = {.lex_state = 0},
  [6401] = {.lex_state = 0},
  [6402] = {.lex_state = 0},
  [6403] = {.lex_state = 0},
  [6404] = {.lex_state = 0},
  [6405] = {.lex_state = 0},
  [6406] = {.lex_state = 0},
  [6407] = {.lex_state = 0},
  [6408] = {.lex_state = 0},
  [6409] = {.lex_state = 0},
  [6410] = {.lex_state = 2},
  [6411] = {.lex_state = 0},
  [6412] = {.lex_state = 0},
  [6413] = {.lex_state = 0},
  [6414] = {.lex_state = 0},
  [6415] = {.lex_state = 0},
  [6416] = {.lex_state = 0},
  [6417] = {.lex_state = 0},
  [6418] = {.lex_state = 0},
  [6419] = {.lex_state = 0},
  [6420] = {.lex_state = 0},
  [6421] = {.lex_state = 0},
  [6422] = {.lex_state = 0},
  [6423] = {.lex_state = 0},
  [6424] = {.lex_state = 0},
  [6425] = {.lex_state = 0},
  [6426] = {.lex_state = 0},
  [6427] = {.lex_state = 0},
  [6428] = {.lex_state = 0},
  [6429] = {.lex_state = 0},
  [6430] = {.lex_state = 0},
  [6431] = {.lex_state = 0},
  [6432] = {.lex_state = 0},
  [6433] = {.lex_state = 0},
  [6434] = {.lex_state = 0},
  [6435] = {.lex_state = 0},
  [6436] = {.lex_state = 0},
  [6437] = {.lex_state = 0},
  [6438] = {.lex_state = 0},
  [6439] = {.lex_state = 0},
  [6440] = {.lex_state = 0},
  [6441] = {.lex_state = 0},
  [6442] = {.lex_state = 0},
  [6443] = {.lex_state = 0},
  [6444] = {.lex_state = 0},
  [6445] = {.lex_state = 0},
  [6446] = {.lex_state = 0},
  [6447] = {.lex_state = 0},
  [6448] = {.lex_state = 0},
  [6449] = {.lex_state = 0},
  [6450] = {.lex_state = 0},
  [6451] = {.lex_state = 0},
  [6452] = {.lex_state = 0},
  [6453] = {.lex_state = 0},
  [6454] = {.lex_state = 0},
  [6455] = {.lex_state = 0},
  [6456] = {.lex_state = 0},
  [6457] = {.lex_state = 0},
  [6458] = {.lex_state = 0},
  [6459] = {.lex_state = 2},
  [6460] = {.lex_state = 0},
  [6461] = {.lex_state = 0},
  [6462] = {.lex_state = 0},
  [6463] = {.lex_state = 0},
  [6464] = {.lex_state = 0},
  [6465] = {.lex_state = 0},
  [6466] = {.lex_state = 0},
  [6467] = {.lex_state = 0},
  [6468] = {.lex_state = 0},
  [6469] = {.lex_state = 0},
  [6470] = {.lex_state = 0},
  [6471] = {.lex_state = 0},
  [6472] = {.lex_state = 0},
  [6473] = {.lex_state = 0},
  [6474] = {.lex_state = 0},
  [6475] = {.lex_state = 0},
  [6476] = {.lex_state = 0},
  [6477] = {.lex_state = 0},
  [6478] = {.lex_state = 0},
  [6479] = {.lex_state = 0},
  [6480] = {.lex_state = 0},
  [6481] = {.lex_state = 0},
  [6482] = {.lex_state = 0},
  [6483] = {.lex_state = 0},
  [6484] = {.lex_state = 0},
  [6485] = {.lex_state = 0},
  [6486] = {.lex_state = 0},
  [6487] = {.lex_state = 0},
  [6488] = {.lex_state = 0},
  [6489] = {.lex_state = 0},
  [6490] = {.lex_state = 0},
  [6491] = {.lex_state = 0},
  [6492] = {.lex_state = 0},
  [6493] = {.lex_state = 0},
  [6494] = {.lex_state = 0},
  [6495] = {.lex_state = 0},
  [6496] = {.lex_state = 0},
  [6497] = {.lex_state = 0},
  [6498] = {.lex_state = 0},
  [6499] = {.lex_state = 0},
  [6500] = {.lex_state = 0},
  [6501] = {.lex_state = 0},
  [6502] = {.lex_state = 0},
  [6503] = {.lex_state = 0},
  [6504] = {.lex_state = 0},
  [6505] = {.lex_state = 0},
  [6506] = {.lex_state = 0},
  [6507] = {.lex_state = 0},
  [6508] = {.lex_state = 0},
  [6509] = {.lex_state = 0},
  [6510] = {.lex_state = 0},
  [6511] = {.lex_state = 0},
  [6512] = {.lex_state = 0},
  [6513] = {.lex_state = 0},
  [6514] = {.lex_state = 0},
  [6515] = {.lex_state = 0},
  [6516] = {.lex_state = 0},
  [6517] = {.lex_state = 0},
  [6518] = {.lex_state = 0},
  [6519] = {.lex_state = 0},
  [6520] = {.lex_state = 0},
  [6521] = {.lex_state = 0},
  [6522] = {.lex_state = 0},
  [6523] = {.lex_state = 0},
  [6524] = {.lex_state = 0},
  [6525] = {.lex_state = 0},
  [6526] = {.lex_state = 0},
  [6527] = {.lex_state = 0},
  [6528] = {.lex_state = 0},
  [6529] = {.lex_state = 0},
  [6530] = {.lex_state = 0},
  [6531] = {.lex_state = 0},
  [6532] = {.lex_state = 0},
  [6533] = {.lex_state = 0},
  [6534] = {.lex_state = 0},
  [6535] = {.lex_state = 0},
  [6536] = {.lex_state = 0},
  [6537] = {.lex_state = 0},
  [6538] = {.lex_state = 0},
  [6539] = {.lex_state = 0},
  [6540] = {.lex_state = 0},
  [6541] = {.lex_state = 0},
  [6542] = {.lex_state = 0},
  [6543] = {.lex_state = 0},
  [6544] = {.lex_state = 0},
  [6545] = {.lex_state = 0},
  [6546] = {.lex_state = 0},
  [6547] = {.lex_state = 0},
  [6548] = {.lex_state = 0},
  [6549] = {.lex_state = 0},
  [6550] = {.lex_state = 0},
  [6551] = {.lex_state = 0},
  [6552] = {.lex_state = 0},
  [6553] = {.lex_state = 0},
  [6554] = {.lex_state = 0},
  [6555] = {.lex_state = 0},
  [6556] = {.lex_state = 0},
  [6557] = {.lex_state = 0},
  [6558] = {.lex_state = 0},
  [6559] = {.lex_state = 0},
  [6560] = {.lex_state = 0},
  [6561] = {.lex_state = 0},
  [6562] = {.lex_state = 0},
  [6563] = {.lex_state = 0},
  [6564] = {.lex_state = 0},
  [6565] = {.lex_state = 0},
  [6566] = {.lex_state = 0},
  [6567] = {.lex_state = 0},
  [6568] = {.lex_state = 0},
  [6569] = {.lex_state = 0},
  [6570] = {.lex_state = 0},
  [6571] = {.lex_state = 0},
  [6572] = {.lex_state = 0},
  [6573] = {.lex_state = 0},
  [6574] = {.lex_state = 0},
  [6575] = {.lex_state = 0},
  [6576] = {.lex_state = 0},
  [6577] = {.lex_state = 0},
  [6578] = {.lex_state = 0},
  [6579] = {.lex_state = 0},
  [6580] = {.lex_state = 0},
  [6581] = {.lex_state = 0},
  [6582] = {.lex_state = 0},
  [6583] = {.lex_state = 0},
  [6584] = {.lex_state = 0},
  [6585] = {.lex_state = 0},
  [6586] = {.lex_state = 0},
  [6587] = {.lex_state = 0},
  [6588] = {.lex_state = 0},
  [6589] = {.lex_state = 0},
  [6590] = {.lex_state = 0},
  [6591] = {.lex_state = 0},
  [6592] = {.lex_state = 0},
  [6593] = {.lex_state = 0},
  [6594] = {.lex_state = 0},
  [6595] = {.lex_state = 0},
  [6596] = {.lex_state = 0},
  [6597] = {.lex_state = 0},
  [6598] = {.lex_state = 0},
  [6599] = {.lex_state = 0},
  [6600] = {.lex_state = 0},
  [6601] = {.lex_state = 0},
  [6602] = {.lex_state = 0},
  [6603] = {.lex_state = 0},
  [6604] = {.lex_state = 0},
  [6605] = {.lex_state = 0},
  [6606] = {.lex_state = 0},
  [6607] = {.lex_state = 0},
  [6608] = {.lex_state = 0},
  [6609] = {.lex_state = 0},
  [6610] = {.lex_state = 0},
  [6611] = {.lex_state = 0},
  [6612] = {.lex_state = 0},
  [6613] = {.lex_state = 0},
  [6614] = {.lex_state = 0},
  [6615] = {.lex_state = 0},
  [6616] = {.lex_state = 0},
  [6617] = {.lex_state = 0},
  [6618] = {.lex_state = 0},
  [6619] = {.lex_state = 0},
  [6620] = {.lex_state = 0},
  [6621] = {.lex_state = 0},
  [6622] = {.lex_state = 0},
  [6623] = {.lex_state = 0},
  [6624] = {.lex_state = 0},
  [6625] = {.lex_state = 0},
  [6626] = {.lex_state = 0},
  [6627] = {.lex_state = 0},
  [6628] = {.lex_state = 0},
  [6629] = {.lex_state = 0},
  [6630] = {.lex_state = 0},
  [6631] = {.lex_state = 0},
  [6632] = {.lex_state = 0},
  [6633] = {.lex_state = 0},
  [6634] = {.lex_state = 0},
  [6635] = {.lex_state = 0},
  [6636] = {.lex_state = 0},
  [6637] = {.lex_state = 0},
  [6638] = {.lex_state = 0},
  [6639] = {.lex_state = 0},
  [6640] = {.lex_state = 0},
  [6641] = {.lex_state = 0},
  [6642] = {.lex_state = 0},
  [6643] = {.lex_state = 0},
  [6644] = {.lex_state = 0},
  [6645] = {.lex_state = 0},
  [6646] = {.lex_state = 0},
  [6647] = {.lex_state = 0},
  [6648] = {.lex_state = 0},
  [6649] = {.lex_state = 0},
  [6650] = {.lex_state = 0},
  [6651] = {.lex_state = 0},
  [6652] = {.lex_state = 0},
  [6653] = {.lex_state = 0},
  [6654] = {.lex_state = 0},
  [6655] = {.lex_state = 0},
  [6656] = {.lex_state = 0},
  [6657] = {.lex_state = 0},
  [6658] = {.lex_state = 0},
  [6659] = {.lex_state = 0},
  [6660] = {.lex_state = 0},
  [6661] = {.lex_state = 0},
  [6662] = {.lex_state = 0},
  [6663] = {.lex_state = 0},
  [6664] = {.lex_state = 0},
  [6665] = {.lex_state = 0},
  [6666] = {.lex_state = 0},
  [6667] = {.lex_state = 0},
  [6668] = {.lex_state = 0},
  [6669] = {.lex_state = 0},
  [6670] = {.lex_state = 0},
  [6671] = {.lex_state = 0},
  [6672] = {.lex_state = 0},
  [6673] = {.lex_state = 0},
  [6674] = {.lex_state = 0},
  [6675] = {.lex_state = 0},
  [6676] = {.lex_state = 0},
  [6677] = {.lex_state = 0},
  [6678] = {.lex_state = 0},
  [6679] = {.lex_state = 0},
  [6680] = {.lex_state = 0},
  [6681] = {.lex_state = 0},
  [6682] = {.lex_state = 0},
  [6683] = {.lex_state = 0},
  [6684] = {.lex_state = 0},
  [6685] = {.lex_state = 0},
  [6686] = {.lex_state = 0},
  [6687] = {.lex_state = 0},
  [6688] = {.lex_state = 0},
  [6689] = {.lex_state = 0},
  [6690] = {.lex_state = 0},
  [6691] = {.lex_state = 0},
  [6692] = {.lex_state = 0},
  [6693] = {.lex_state = 0},
  [6694] = {.lex_state = 0},
  [6695] = {.lex_state = 0},
  [6696] = {.lex_state = 0},
  [6697] = {.lex_state = 0},
  [6698] = {.lex_state = 0},
  [6699] = {.lex_state = 0},
  [6700] = {.lex_state = 0},
  [6701] = {.lex_state = 0},
  [6702] = {.lex_state = 0},
  [6703] = {.lex_state = 0},
  [6704] = {.lex_state = 0},
  [6705] = {.lex_state = 0},
  [6706] = {.lex_state = 0},
  [6707] = {.lex_state = 0},
  [6708] = {.lex_state = 0},
  [6709] = {.lex_state = 0},
  [6710] = {.lex_state = 0},
  [6711] = {.lex_state = 0},
  [6712] = {.lex_state = 0},
  [6713] = {.lex_state = 0},
  [6714] = {.lex_state = 0},
  [6715] = {.lex_state = 0},
  [6716] = {.lex_state = 0},
  [6717] = {.lex_state = 0},
  [6718] = {.lex_state = 0},
  [6719] = {.lex_state = 0},
  [6720] = {.lex_state = 0},
  [6721] = {.lex_state = 0},
  [6722] = {.lex_state = 0},
  [6723] = {.lex_state = 0},
  [6724] = {.lex_state = 0},
  [6725] = {.lex_state = 0},
  [6726] = {.lex_state = 0},
  [6727] = {.lex_state = 0},
  [6728] = {.lex_state = 0},
  [6729] = {.lex_state = 0},
  [6730] = {.lex_state = 2},
  [6731] = {.lex_state = 0},
  [6732] = {.lex_state = 2},
  [6733] = {.lex_state = 2},
  [6734] = {.lex_state = 0},
  [6735] = {.lex_state = 2},
  [6736] = {.lex_state = 2},
  [6737] = {.lex_state = 2},
  [6738] = {.lex_state = 2},
  [6739] = {.lex_state = 0},
  [6740] = {.lex_state = 2},
  [6741] = {.lex_state = 2},
  [6742] = {.lex_state = 2},
  [6743] = {.lex_state = 2},
  [6744] = {.lex_state = 2},
  [6745] = {.lex_state = 0},
  [6746] = {.lex_state = 2},
  [6747] = {.lex_state = 0},
  [6748] = {.lex_state = 30},
  [6749] = {.lex_state = 2},
  [6750] = {.lex_state = 2},
  [6751] = {.lex_state = 0},
  [6752] = {.lex_state = 2},
  [6753] = {.lex_state = 2},
  [6754] = {.lex_state = 2},
  [6755] = {.lex_state = 2},
  [6756] = {.lex_state = 2},
  [6757] = {.lex_state = 0},
  [6758] = {.lex_state = 0},
  [6759] = {.lex_state = 0},
  [6760] = {.lex_state = 2},
  [6761] = {.lex_state = 0},
  [6762] = {.lex_state = 2},
  [6763] = {.lex_state = 2},
  [6764] = {.lex_state = 2},
  [6765] = {.lex_state = 2},
  [6766] = {.lex_state = 2},
  [6767] = {.lex_state = 2},
  [6768] = {.lex_state = 2},
  [6769] = {.lex_state = 2},
  [6770] = {.lex_state = 2},
  [6771] = {.lex_state = 0},
  [6772] = {.lex_state = 0},
  [6773] = {.lex_state = 0},
  [6774] = {.lex_state = 0},
  [6775] = {.lex_state = 0},
  [6776] = {.lex_state = 0},
  [6777] = {.lex_state = 0},
  [6778] = {.lex_state = 0},
  [6779] = {.lex_state = 0},
  [6780] = {.lex_state = 0},
  [6781] = {.lex_state = 0},
  [6782] = {.lex_state = 0},
  [6783] = {.lex_state = 0},
  [6784] = {.lex_state = 0},
  [6785] = {.lex_state = 0},
  [6786] = {.lex_state = 0},
  [6787] = {.lex_state = 0},
  [6788] = {.lex_state = 0},
  [6789] = {.lex_state = 0},
  [6790] = {.lex_state = 0},
  [6791] = {.lex_state = 0},
  [6792] = {.lex_state = 0},
  [6793] = {.lex_state = 0},
  [6794] = {.lex_state = 0},
  [6795] = {.lex_state = 0},
  [6796] = {.lex_state = 0},
  [6797] = {.lex_state = 0},
  [6798] = {.lex_state = 30},
  [6799] = {.lex_state = 0},
  [6800] = {.lex_state = 0},
  [6801] = {.lex_state = 0},
  [6802] = {.lex_state = 0},
  [6803] = {.lex_state = 0},
  [6804] = {.lex_state = 0},
  [6805] = {.lex_state = 30},
  [6806] = {.lex_state = 0},
  [6807] = {.lex_state = 0},
  [6808] = {.lex_state = 0},
  [6809] = {.lex_state = 0},
  [6810] = {.lex_state = 0},
  [6811] = {.lex_state = 0},
  [6812] = {.lex_state = 0},
  [6813] = {.lex_state = 0},
  [6814] = {.lex_state = 0},
  [6815] = {.lex_state = 0},
  [6816] = {.lex_state = 0},
  [6817] = {.lex_state = 0},
  [6818] = {.lex_state = 0},
  [6819] = {.lex_state = 0},
  [6820] = {.lex_state = 0},
  [6821] = {.lex_state = 0},
  [6822] = {.lex_state = 0},
  [6823] = {.lex_state = 0},
  [6824] = {.lex_state = 0},
  [6825] = {.lex_state = 0},
  [6826] = {.lex_state = 0},
  [6827] = {.lex_state = 0},
  [6828] = {.lex_state = 0},
  [6829] = {.lex_state = 0},
  [6830] = {.lex_state = 3},
  [6831] = {.lex_state = 0},
  [6832] = {.lex_state = 0},
  [6833] = {.lex_state = 0},
  [6834] = {.lex_state = 0},
  [6835] = {.lex_state = 0},
  [6836] = {.lex_state = 0},
  [6837] = {.lex_state = 0},
  [6838] = {.lex_state = 0},
  [6839] = {.lex_state = 0},
  [6840] = {.lex_state = 0},
  [6841] = {.lex_state = 0},
  [6842] = {.lex_state = 0},
  [6843] = {.lex_state = 0},
  [6844] = {.lex_state = 0},
  [6845] = {.lex_state = 0},
  [6846] = {.lex_state = 0},
  [6847] = {.lex_state = 0},
  [6848] = {.lex_state = 0},
  [6849] = {.lex_state = 0},
  [6850] = {.lex_state = 0},
  [6851] = {.lex_state = 0},
  [6852] = {.lex_state = 0},
  [6853] = {.lex_state = 0},
  [6854] = {.lex_state = 0},
  [6855] = {.lex_state = 0},
  [6856] = {.lex_state = 0},
  [6857] = {.lex_state = 0},
  [6858] = {.lex_state = 0},
  [6859] = {.lex_state = 0},
  [6860] = {.lex_state = 0},
  [6861] = {.lex_state = 0},
  [6862] = {.lex_state = 0},
  [6863] = {.lex_state = 0},
  [6864] = {.lex_state = 0},
  [6865] = {.lex_state = 0},
  [6866] = {.lex_state = 0},
  [6867] = {.lex_state = 0},
  [6868] = {.lex_state = 0},
  [6869] = {.lex_state = 0},
  [6870] = {.lex_state = 0},
  [6871] = {.lex_state = 0},
  [6872] = {.lex_state = 0, .external_lex_state = 2},
  [6873] = {.lex_state = 0},
  [6874] = {.lex_state = 0},
  [6875] = {.lex_state = 0, .external_lex_state = 2},
  [6876] = {.lex_state = 0},
  [6877] = {.lex_state = 0},
  [6878] = {.lex_state = 0},
  [6879] = {.lex_state = 0, .external_lex_state = 2},
  [6880] = {.lex_state = 30},
  [6881] = {.lex_state = 30},
  [6882] = {.lex_state = 0},
  [6883] = {.lex_state = 0, .external_lex_state = 2},
  [6884] = {.lex_state = 0},
  [6885] = {.lex_state = 0},
  [6886] = {.lex_state = 0},
  [6887] = {.lex_state = 0},
  [6888] = {.lex_state = 0, .external_lex_state = 3},
  [6889] = {.lex_state = 0},
  [6890] = {.lex_state = 0},
  [6891] = {.lex_state = 0},
  [6892] = {.lex_state = 0},
  [6893] = {.lex_state = 0},
  [6894] = {.lex_state = 0},
  [6895] = {.lex_state = 0},
  [6896] = {.lex_state = 0},
  [6897] = {.lex_state = 0},
  [6898] = {.lex_state = 0},
  [6899] = {.lex_state = 0, .external_lex_state = 3},
  [6900] = {.lex_state = 0},
  [6901] = {.lex_state = 0},
  [6902] = {.lex_state = 0},
  [6903] = {.lex_state = 0, .external_lex_state = 3},
  [6904] = {.lex_state = 0},
  [6905] = {.lex_state = 0},
  [6906] = {.lex_state = 0, .external_lex_state = 3},
  [6907] = {.lex_state = 0},
  [6908] = {.lex_state = 0},
  [6909] = {.lex_state = 0},
  [6910] = {.lex_state = 0},
  [6911] = {.lex_state = 0, .external_lex_state = 2},
  [6912] = {.lex_state = 0},
  [6913] = {.lex_state = 0, .external_lex_state = 3},
  [6914] = {.lex_state = 0},
  [6915] = {.lex_state = 0},
  [6916] = {.lex_state = 0},
  [6917] = {.lex_state = 0, .external_lex_state = 2},
  [6918] = {.lex_state = 0, .external_lex_state = 2},
  [6919] = {.lex_state = 0},
  [6920] = {.lex_state = 0},
  [6921] = {.lex_state = 0},
  [6922] = {.lex_state = 0},
  [6923] = {.lex_state = 0},
  [6924] = {.lex_state = 0, .external_lex_state = 3},
  [6925] = {.lex_state = 0},
  [6926] = {.lex_state = 0},
  [6927] = {.lex_state = 0, .external_lex_state = 3},
  [6928] = {.lex_state = 0},
  [6929] = {.lex_state = 0, .external_lex_state = 3},
  [6930] = {.lex_state = 0},
  [6931] = {.lex_state = 0},
  [6932] = {.lex_state = 0},
  [6933] = {.lex_state = 0},
  [6934] = {.lex_state = 0},
  [6935] = {.lex_state = 0},
  [6936] = {.lex_state = 0},
  [6937] = {.lex_state = 0, .external_lex_state = 2},
  [6938] = {.lex_state = 0, .external_lex_state = 2},
  [6939] = {.lex_state = 0},
  [6940] = {.lex_state = 0, .external_lex_state = 3},
  [6941] = {.lex_state = 0, .external_lex_state = 3},
  [6942] = {.lex_state = 0},
  [6943] = {.lex_state = 0},
  [6944] = {.lex_state = 0},
  [6945] = {.lex_state = 0, .external_lex_state = 3},
  [6946] = {.lex_state = 0},
  [6947] = {.lex_state = 30},
  [6948] = {.lex_state = 0, .external_lex_state = 3},
  [6949] = {.lex_state = 0, .external_lex_state = 2},
  [6950] = {.lex_state = 0},
  [6951] = {.lex_state = 0},
  [6952] = {.lex_state = 0},
  [6953] = {.lex_state = 0},
  [6954] = {.lex_state = 0},
  [6955] = {.lex_state = 0},
  [6956] = {.lex_state = 0},
  [6957] = {.lex_state = 0},
  [6958] = {.lex_state = 0},
  [6959] = {.lex_state = 0},
  [6960] = {.lex_state = 0},
  [6961] = {.lex_state = 0},
  [6962] = {.lex_state = 0, .external_lex_state = 3},
  [6963] = {.lex_state = 0},
  [6964] = {.lex_state = 0},
  [6965] = {.lex_state = 0, .external_lex_state = 3},
  [6966] = {.lex_state = 0},
  [6967] = {.lex_state = 0},
  [6968] = {.lex_state = 0},
  [6969] = {.lex_state = 0},
  [6970] = {.lex_state = 0},
  [6971] = {.lex_state = 0},
  [6972] = {.lex_state = 0, .external_lex_state = 3},
  [6973] = {.lex_state = 0, .external_lex_state = 3},
  [6974] = {.lex_state = 0, .external_lex_state = 2},
  [6975] = {.lex_state = 0},
  [6976] = {.lex_state = 0},
  [6977] = {.lex_state = 0},
  [6978] = {.lex_state = 0, .external_lex_state = 3},
  [6979] = {.lex_state = 0, .external_lex_state = 3},
  [6980] = {.lex_state = 0},
  [6981] = {.lex_state = 0, .external_lex_state = 3},
  [6982] = {.lex_state = 0},
  [6983] = {.lex_state = 0},
  [6984] = {.lex_state = 30},
  [6985] = {.lex_state = 0, .external_lex_state = 3},
  [6986] = {.lex_state = 30},
  [6987] = {.lex_state = 0},
  [6988] = {.lex_state = 0},
  [6989] = {.lex_state = 0},
  [6990] = {.lex_state = 0},
  [6991] = {.lex_state = 0},
  [6992] = {.lex_state = 0},
  [6993] = {.lex_state = 0},
  [6994] = {.lex_state = 0},
  [6995] = {.lex_state = 0},
  [6996] = {.lex_state = 0},
  [6997] = {.lex_state = 0},
  [6998] = {.lex_state = 0},
  [6999] = {.lex_state = 0},
  [7000] = {.lex_state = 0},
  [7001] = {.lex_state = 0},
  [7002] = {.lex_state = 0},
  [7003] = {.lex_state = 0},
  [7004] = {.lex_state = 0},
  [7005] = {.lex_state = 0, .external_lex_state = 2},
  [7006] = {.lex_state = 0, .external_lex_state = 2},
  [7007] = {.lex_state = 0},
  [7008] = {.lex_state = 0, .external_lex_state = 3},
  [7009] = {.lex_state = 0, .external_lex_state = 3},
  [7010] = {.lex_state = 0},
  [7011] = {.lex_state = 0},
  [7012] = {.lex_state = 0},
  [7013] = {.lex_state = 0},
  [7014] = {.lex_state = 0},
  [7015] = {.lex_state = 0},
  [7016] = {.lex_state = 0},
  [7017] = {.lex_state = 0},
  [7018] = {.lex_state = 0},
  [7019] = {.lex_state = 0},
  [7020] = {.lex_state = 0},
  [7021] = {.lex_state = 0},
  [7022] = {.lex_state = 0},
  [7023] = {.lex_state = 0},
  [7024] = {.lex_state = 0},
  [7025] = {.lex_state = 0, .external_lex_state = 2},
  [7026] = {.lex_state = 0, .external_lex_state = 2},
  [7027] = {.lex_state = 0},
  [7028] = {.lex_state = 0},
  [7029] = {.lex_state = 0},
  [7030] = {.lex_state = 0},
  [7031] = {.lex_state = 0},
  [7032] = {.lex_state = 0},
  [7033] = {.lex_state = 0, .external_lex_state = 3},
  [7034] = {.lex_state = 0},
  [7035] = {.lex_state = 0},
  [7036] = {.lex_state = 0},
  [7037] = {.lex_state = 0, .external_lex_state = 3},
  [7038] = {.lex_state = 0},
  [7039] = {.lex_state = 0},
  [7040] = {.lex_state = 0},
  [7041] = {.lex_state = 0},
  [7042] = {.lex_state = 0},
  [7043] = {.lex_state = 0},
  [7044] = {.lex_state = 0},
  [7045] = {.lex_state = 0},
  [7046] = {.lex_state = 0},
  [7047] = {.lex_state = 0},
  [7048] = {.lex_state = 0},
  [7049] = {.lex_state = 0},
  [7050] = {.lex_state = 0},
  [7051] = {.lex_state = 0},
  [7052] = {.lex_state = 0},
  [7053] = {.lex_state = 0},
  [7054] = {.lex_state = 0},
  [7055] = {.lex_state = 0},
  [7056] = {.lex_state = 0},
  [7057] = {.lex_state = 0},
  [7058] = {.lex_state = 0},
  [7059] = {.lex_state = 0, .external_lex_state = 2},
  [7060] = {.lex_state = 0, .external_lex_state = 2},
  [7061] = {.lex_state = 0},
  [7062] = {.lex_state = 0, .external_lex_state = 3},
  [7063] = {.lex_state = 0},
  [7064] = {.lex_state = 0},
  [7065] = {.lex_state = 0},
  [7066] = {.lex_state = 0, .external_lex_state = 3},
  [7067] = {.lex_state = 0},
  [7068] = {.lex_state = 0},
  [7069] = {.lex_state = 0},
  [7070] = {.lex_state = 0},
  [7071] = {.lex_state = 0},
  [7072] = {.lex_state = 0},
  [7073] = {.lex_state = 30},
  [7074] = {.lex_state = 0},
  [7075] = {.lex_state = 0},
  [7076] = {.lex_state = 0, .external_lex_state = 3},
  [7077] = {.lex_state = 0},
  [7078] = {.lex_state = 0},
  [7079] = {.lex_state = 0},
  [7080] = {.lex_state = 0},
  [7081] = {.lex_state = 0},
  [7082] = {.lex_state = 0},
  [7083] = {.lex_state = 0},
  [7084] = {.lex_state = 0},
  [7085] = {.lex_state = 0},
  [7086] = {.lex_state = 0},
  [7087] = {.lex_state = 0},
  [7088] = {.lex_state = 0, .external_lex_state = 3},
  [7089] = {.lex_state = 0},
  [7090] = {.lex_state = 0},
  [7091] = {.lex_state = 0},
  [7092] = {.lex_state = 0},
  [7093] = {.lex_state = 0, .external_lex_state = 2},
  [7094] = {.lex_state = 0},
  [7095] = {.lex_state = 0},
  [7096] = {.lex_state = 0, .external_lex_state = 2},
  [7097] = {.lex_state = 0, .external_lex_state = 2},
  [7098] = {.lex_state = 0},
  [7099] = {.lex_state = 0, .external_lex_state = 3},
  [7100] = {.lex_state = 0, .external_lex_state = 3},
  [7101] = {.lex_state = 0},
  [7102] = {.lex_state = 0, .external_lex_state = 3},
  [7103] = {.lex_state = 0},
  [7104] = {.lex_state = 0},
  [7105] = {.lex_state = 0},
  [7106] = {.lex_state = 0, .external_lex_state = 3},
  [7107] = {.lex_state = 0},
  [7108] = {.lex_state = 0, .external_lex_state = 3},
  [7109] = {.lex_state = 0},
  [7110] = {.lex_state = 0, .external_lex_state = 2},
  [7111] = {.lex_state = 0},
  [7112] = {.lex_state = 0},
  [7113] = {.lex_state = 0, .external_lex_state = 2},
  [7114] = {.lex_state = 0},
  [7115] = {.lex_state = 0},
  [7116] = {.lex_state = 0},
  [7117] = {.lex_state = 0},
  [7118] = {.lex_state = 0},
  [7119] = {.lex_state = 0},
  [7120] = {.lex_state = 0},
  [7121] = {.lex_state = 0},
  [7122] = {.lex_state = 0},
  [7123] = {.lex_state = 0},
  [7124] = {.lex_state = 0},
  [7125] = {.lex_state = 0},
  [7126] = {.lex_state = 0},
  [7127] = {.lex_state = 0, .external_lex_state = 2},
  [7128] = {.lex_state = 0, .external_lex_state = 2},
  [7129] = {.lex_state = 0},
  [7130] = {.lex_state = 0, .external_lex_state = 3},
  [7131] = {.lex_state = 0},
  [7132] = {.lex_state = 0},
  [7133] = {.lex_state = 0},
  [7134] = {.lex_state = 0, .external_lex_state = 3},
  [7135] = {.lex_state = 0},
  [7136] = {.lex_state = 0},
  [7137] = {.lex_state = 0},
  [7138] = {.lex_state = 0},
  [7139] = {.lex_state = 0},
  [7140] = {.lex_state = 0},
  [7141] = {.lex_state = 0},
  [7142] = {.lex_state = 0},
  [7143] = {.lex_state = 0, .external_lex_state = 2},
  [7144] = {.lex_state = 0},
  [7145] = {.lex_state = 0},
  [7146] = {.lex_state = 0},
  [7147] = {.lex_state = 0, .external_lex_state = 2},
  [7148] = {.lex_state = 0},
  [7149] = {.lex_state = 0, .external_lex_state = 3},
  [7150] = {.lex_state = 0},
  [7151] = {.lex_state = 0},
  [7152] = {.lex_state = 0},
  [7153] = {.lex_state = 0},
  [7154] = {.lex_state = 0},
  [7155] = {.lex_state = 0},
  [7156] = {.lex_state = 0},
  [7157] = {.lex_state = 0},
  [7158] = {.lex_state = 0},
  [7159] = {.lex_state = 0},
  [7160] = {.lex_state = 0},
  [7161] = {.lex_state = 0},
  [7162] = {.lex_state = 0},
  [7163] = {.lex_state = 0},
  [7164] = {.lex_state = 0},
  [7165] = {.lex_state = 0},
  [7166] = {.lex_state = 0},
  [7167] = {.lex_state = 0},
  [7168] = {.lex_state = 0, .external_lex_state = 3},
  [7169] = {.lex_state = 0},
  [7170] = {.lex_state = 0, .external_lex_state = 2},
  [7171] = {.lex_state = 0, .external_lex_state = 2},
  [7172] = {.lex_state = 0},
  [7173] = {.lex_state = 0},
  [7174] = {.lex_state = 0},
  [7175] = {.lex_state = 0, .external_lex_state = 3},
  [7176] = {.lex_state = 0},
  [7177] = {.lex_state = 0},
  [7178] = {.lex_state = 0},
  [7179] = {.lex_state = 0},
  [7180] = {.lex_state = 0},
  [7181] = {.lex_state = 0},
  [7182] = {.lex_state = 0, .external_lex_state = 3},
  [7183] = {.lex_state = 0},
  [7184] = {.lex_state = 0},
  [7185] = {.lex_state = 0},
  [7186] = {.lex_state = 0},
  [7187] = {.lex_state = 0, .external_lex_state = 3},
  [7188] = {.lex_state = 0},
  [7189] = {.lex_state = 0},
  [7190] = {.lex_state = 0},
  [7191] = {.lex_state = 0},
  [7192] = {.lex_state = 0},
  [7193] = {.lex_state = 0},
  [7194] = {.lex_state = 0},
  [7195] = {.lex_state = 0},
  [7196] = {.lex_state = 0},
  [7197] = {.lex_state = 0},
  [7198] = {.lex_state = 0},
  [7199] = {.lex_state = 0, .external_lex_state = 2},
  [7200] = {.lex_state = 0},
  [7201] = {.lex_state = 0, .external_lex_state = 2},
  [7202] = {.lex_state = 0},
  [7203] = {.lex_state = 0, .external_lex_state = 3},
  [7204] = {.lex_state = 0},
  [7205] = {.lex_state = 0},
  [7206] = {.lex_state = 0},
  [7207] = {.lex_state = 0},
  [7208] = {.lex_state = 0},
  [7209] = {.lex_state = 0},
  [7210] = {.lex_state = 0},
  [7211] = {.lex_state = 0},
  [7212] = {.lex_state = 0},
  [7213] = {.lex_state = 0},
  [7214] = {.lex_state = 0},
  [7215] = {.lex_state = 0},
  [7216] = {.lex_state = 0},
  [7217] = {.lex_state = 0},
  [7218] = {.lex_state = 0},
  [7219] = {.lex_state = 0},
  [7220] = {.lex_state = 0},
  [7221] = {.lex_state = 0},
  [7222] = {.lex_state = 0},
  [7223] = {.lex_state = 0},
  [7224] = {.lex_state = 0},
  [7225] = {.lex_state = 0},
  [7226] = {.lex_state = 0},
  [7227] = {.lex_state = 0},
  [7228] = {.lex_state = 0},
  [7229] = {.lex_state = 0},
  [7230] = {.lex_state = 0},
  [7231] = {.lex_state = 0},
  [7232] = {.lex_state = 0},
  [7233] = {.lex_state = 0},
  [7234] = {.lex_state = 0},
  [7235] = {.lex_state = 0},
  [7236] = {.lex_state = 0},
  [7237] = {.lex_state = 0},
  [7238] = {.lex_state = 0},
  [7239] = {.lex_state = 0},
  [7240] = {.lex_state = 0, .external_lex_state = 2},
  [7241] = {.lex_state = 0},
  [7242] = {.lex_state = 0},
  [7243] = {.lex_state = 0, .external_lex_state = 2},
  [7244] = {.lex_state = 0},
  [7245] = {.lex_state = 0, .external_lex_state = 2},
  [7246] = {.lex_state = 0},
  [7247] = {.lex_state = 0},
  [7248] = {.lex_state = 0},
  [7249] = {.lex_state = 0},
  [7250] = {.lex_state = 0},
  [7251] = {.lex_state = 0},
  [7252] = {.lex_state = 0},
  [7253] = {.lex_state = 0},
  [7254] = {.lex_state = 0},
  [7255] = {.lex_state = 0},
  [7256] = {.lex_state = 0},
  [7257] = {.lex_state = 0, .external_lex_state = 2},
  [7258] = {.lex_state = 0},
  [7259] = {.lex_state = 0},
  [7260] = {.lex_state = 0},
  [7261] = {.lex_state = 0},
  [7262] = {.lex_state = 0},
  [7263] = {.lex_state = 0},
  [7264] = {.lex_state = 0},
  [7265] = {.lex_state = 0, .external_lex_state = 2},
  [7266] = {.lex_state = 0},
  [7267] = {.lex_state = 0},
  [7268] = {.lex_state = 0},
  [7269] = {.lex_state = 0},
  [7270] = {.lex_state = 0},
  [7271] = {.lex_state = 0},
  [7272] = {.lex_state = 0},
  [7273] = {.lex_state = 0},
  [7274] = {.lex_state = 0},
  [7275] = {.lex_state = 0},
  [7276] = {.lex_state = 0},
  [7277] = {.lex_state = 0},
  [7278] = {.lex_state = 0},
  [7279] = {.lex_state = 0},
  [7280] = {.lex_state = 0},
  [7281] = {.lex_state = 0},
  [7282] = {.lex_state = 0},
  [7283] = {.lex_state = 0},
  [7284] = {.lex_state = 0},
  [7285] = {.lex_state = 0},
  [7286] = {.lex_state = 0},
  [7287] = {.lex_state = 0},
  [7288] = {.lex_state = 0},
  [7289] = {.lex_state = 0},
  [7290] = {.lex_state = 0},
  [7291] = {.lex_state = 0},
  [7292] = {.lex_state = 0},
  [7293] = {.lex_state = 0},
  [7294] = {.lex_state = 0},
  [7295] = {.lex_state = 0},
  [7296] = {.lex_state = 0},
  [7297] = {.lex_state = 0},
  [7298] = {.lex_state = 0},
  [7299] = {.lex_state = 0},
  [7300] = {.lex_state = 0},
  [7301] = {.lex_state = 0},
  [7302] = {.lex_state = 0},
  [7303] = {.lex_state = 0},
  [7304] = {.lex_state = 0},
  [7305] = {.lex_state = 0, .external_lex_state = 2},
  [7306] = {.lex_state = 0, .external_lex_state = 2},
  [7307] = {.lex_state = 0},
  [7308] = {.lex_state = 0},
  [7309] = {.lex_state = 0},
  [7310] = {.lex_state = 0},
  [7311] = {.lex_state = 0},
  [7312] = {.lex_state = 0},
  [7313] = {.lex_state = 0},
  [7314] = {.lex_state = 0},
  [7315] = {.lex_state = 0},
  [7316] = {.lex_state = 0},
  [7317] = {.lex_state = 0},
  [7318] = {.lex_state = 0},
  [7319] = {.lex_state = 0},
  [7320] = {.lex_state = 0},
  [7321] = {.lex_state = 0},
  [7322] = {.lex_state = 0},
  [7323] = {.lex_state = 0},
  [7324] = {.lex_state = 0},
  [7325] = {.lex_state = 0},
  [7326] = {.lex_state = 0},
  [7327] = {.lex_state = 0},
  [7328] = {.lex_state = 0},
  [7329] = {.lex_state = 0},
  [7330] = {.lex_state = 0},
  [7331] = {.lex_state = 0},
  [7332] = {.lex_state = 0},
  [7333] = {.lex_state = 0},
  [7334] = {.lex_state = 0},
  [7335] = {.lex_state = 0},
  [7336] = {.lex_state = 0},
  [7337] = {.lex_state = 0},
  [7338] = {.lex_state = 0},
  [7339] = {.lex_state = 0},
  [7340] = {.lex_state = 0},
  [7341] = {.lex_state = 0},
  [7342] = {.lex_state = 0},
  [7343] = {.lex_state = 0},
  [7344] = {.lex_state = 0},
  [7345] = {.lex_state = 0},
  [7346] = {.lex_state = 0},
  [7347] = {.lex_state = 0},
  [7348] = {.lex_state = 0},
  [7349] = {.lex_state = 0},
  [7350] = {.lex_state = 0},
  [7351] = {.lex_state = 0},
  [7352] = {.lex_state = 0},
  [7353] = {.lex_state = 0},
  [7354] = {.lex_state = 0},
  [7355] = {.lex_state = 0},
  [7356] = {.lex_state = 0},
  [7357] = {.lex_state = 0},
  [7358] = {.lex_state = 0},
  [7359] = {.lex_state = 0},
  [7360] = {.lex_state = 0},
  [7361] = {.lex_state = 0},
  [7362] = {.lex_state = 0},
  [7363] = {.lex_state = 0},
  [7364] = {.lex_state = 0},
  [7365] = {.lex_state = 0},
  [7366] = {.lex_state = 0},
  [7367] = {.lex_state = 0},
  [7368] = {.lex_state = 0},
  [7369] = {.lex_state = 0},
  [7370] = {.lex_state = 0},
  [7371] = {.lex_state = 0},
  [7372] = {.lex_state = 0},
  [7373] = {.lex_state = 0},
  [7374] = {.lex_state = 0},
  [7375] = {.lex_state = 0},
  [7376] = {.lex_state = 0},
  [7377] = {.lex_state = 0},
  [7378] = {.lex_state = 0},
  [7379] = {.lex_state = 0},
  [7380] = {.lex_state = 0},
  [7381] = {.lex_state = 0},
  [7382] = {.lex_state = 0},
  [7383] = {.lex_state = 0},
  [7384] = {.lex_state = 0},
  [7385] = {.lex_state = 0},
  [7386] = {.lex_state = 0},
  [7387] = {.lex_state = 0},
  [7388] = {.lex_state = 0},
  [7389] = {.lex_state = 0},
  [7390] = {.lex_state = 0},
  [7391] = {.lex_state = 0},
  [7392] = {.lex_state = 0},
  [7393] = {.lex_state = 0},
  [7394] = {.lex_state = 0},
  [7395] = {.lex_state = 0},
  [7396] = {.lex_state = 0},
  [7397] = {.lex_state = 0},
  [7398] = {.lex_state = 0},
  [7399] = {.lex_state = 0},
  [7400] = {.lex_state = 0},
  [7401] = {.lex_state = 0},
  [7402] = {.lex_state = 0},
  [7403] = {.lex_state = 0},
  [7404] = {.lex_state = 0},
  [7405] = {.lex_state = 0},
  [7406] = {.lex_state = 0},
  [7407] = {.lex_state = 0},
  [7408] = {.lex_state = 0},
  [7409] = {.lex_state = 0},
  [7410] = {.lex_state = 0},
  [7411] = {.lex_state = 0},
  [7412] = {.lex_state = 0},
  [7413] = {.lex_state = 0},
  [7414] = {.lex_state = 0},
  [7415] = {.lex_state = 0},
  [7416] = {.lex_state = 0},
  [7417] = {.lex_state = 30},
  [7418] = {.lex_state = 0},
  [7419] = {.lex_state = 0},
  [7420] = {.lex_state = 0},
  [7421] = {.lex_state = 0},
  [7422] = {.lex_state = 0},
  [7423] = {.lex_state = 0},
  [7424] = {.lex_state = 0},
  [7425] = {.lex_state = 0},
  [7426] = {.lex_state = 0},
  [7427] = {.lex_state = 0},
  [7428] = {.lex_state = 0, .external_lex_state = 2},
  [7429] = {.lex_state = 0},
  [7430] = {.lex_state = 0},
  [7431] = {.lex_state = 0},
  [7432] = {.lex_state = 0},
  [7433] = {.lex_state = 0},
  [7434] = {.lex_state = 0},
  [7435] = {.lex_state = 0},
  [7436] = {.lex_state = 0},
  [7437] = {.lex_state = 0},
  [7438] = {.lex_state = 0},
  [7439] = {.lex_state = 0},
  [7440] = {.lex_state = 0},
  [7441] = {.lex_state = 0},
  [7442] = {.lex_state = 0},
  [7443] = {.lex_state = 0},
  [7444] = {.lex_state = 0},
  [7445] = {.lex_state = 0},
  [7446] = {.lex_state = 0},
  [7447] = {.lex_state = 0},
  [7448] = {.lex_state = 0},
  [7449] = {.lex_state = 0},
  [7450] = {.lex_state = 0},
  [7451] = {.lex_state = 0},
  [7452] = {.lex_state = 0},
  [7453] = {.lex_state = 0},
  [7454] = {.lex_state = 0},
  [7455] = {.lex_state = 0},
  [7456] = {.lex_state = 0},
  [7457] = {.lex_state = 0},
  [7458] = {.lex_state = 0},
  [7459] = {.lex_state = 0},
  [7460] = {.lex_state = 0},
  [7461] = {.lex_state = 0},
  [7462] = {.lex_state = 0},
  [7463] = {.lex_state = 0},
  [7464] = {.lex_state = 0},
  [7465] = {.lex_state = 0},
  [7466] = {.lex_state = 0},
  [7467] = {.lex_state = 0},
  [7468] = {.lex_state = 0},
  [7469] = {.lex_state = 0},
  [7470] = {.lex_state = 0},
  [7471] = {.lex_state = 0},
  [7472] = {.lex_state = 0},
  [7473] = {.lex_state = 0},
  [7474] = {.lex_state = 0},
  [7475] = {.lex_state = 0, .external_lex_state = 2},
  [7476] = {.lex_state = 0},
  [7477] = {.lex_state = 0},
  [7478] = {.lex_state = 0},
  [7479] = {.lex_state = 0},
  [7480] = {.lex_state = 0},
  [7481] = {.lex_state = 0},
  [7482] = {.lex_state = 0, .external_lex_state = 2},
  [7483] = {.lex_state = 0},
  [7484] = {.lex_state = 0},
  [7485] = {.lex_state = 0},
  [7486] = {.lex_state = 0},
  [7487] = {.lex_state = 0},
  [7488] = {.lex_state = 0},
  [7489] = {.lex_state = 0},
  [7490] = {.lex_state = 0},
  [7491] = {.lex_state = 0},
  [7492] = {.lex_state = 0},
  [7493] = {.lex_state = 0},
  [7494] = {.lex_state = 0},
  [7495] = {.lex_state = 0},
  [7496] = {.lex_state = 0},
  [7497] = {.lex_state = 0},
  [7498] = {.lex_state = 0},
  [7499] = {.lex_state = 0},
  [7500] = {.lex_state = 0},
  [7501] = {.lex_state = 0},
  [7502] = {.lex_state = 0},
  [7503] = {.lex_state = 0},
  [7504] = {.lex_state = 0},
  [7505] = {.lex_state = 0},
  [7506] = {.lex_state = 0},
  [7507] = {.lex_state = 0},
  [7508] = {.lex_state = 0},
  [7509] = {.lex_state = 0},
  [7510] = {.lex_state = 0},
  [7511] = {.lex_state = 0, .external_lex_state = 2},
  [7512] = {.lex_state = 0},
  [7513] = {.lex_state = 0},
  [7514] = {.lex_state = 0},
  [7515] = {.lex_state = 0},
  [7516] = {.lex_state = 0},
  [7517] = {.lex_state = 0},
  [7518] = {.lex_state = 0},
  [7519] = {.lex_state = 0},
  [7520] = {.lex_state = 0},
  [7521] = {.lex_state = 0},
  [7522] = {.lex_state = 0},
  [7523] = {.lex_state = 0},
  [7524] = {.lex_state = 0},
  [7525] = {.lex_state = 0},
  [7526] = {.lex_state = 0},
  [7527] = {.lex_state = 0},
  [7528] = {.lex_state = 0},
  [7529] = {.lex_state = 0},
  [7530] = {.lex_state = 0},
  [7531] = {.lex_state = 0},
  [7532] = {.lex_state = 0},
  [7533] = {.lex_state = 0},
  [7534] = {.lex_state = 0},
  [7535] = {.lex_state = 0},
  [7536] = {.lex_state = 0},
  [7537] = {.lex_state = 0},
  [7538] = {.lex_state = 0},
  [7539] = {.lex_state = 0},
  [7540] = {.lex_state = 0},
  [7541] = {.lex_state = 0},
  [7542] = {.lex_state = 0},
  [7543] = {.lex_state = 0},
  [7544] = {.lex_state = 0},
  [7545] = {.lex_state = 0, .external_lex_state = 2},
  [7546] = {.lex_state = 0},
  [7547] = {.lex_state = 30},
  [7548] = {.lex_state = 0},
  [7549] = {.lex_state = 0},
  [7550] = {.lex_state = 0},
  [7551] = {.lex_state = 0},
  [7552] = {.lex_state = 0},
  [7553] = {.lex_state = 0},
  [7554] = {.lex_state = 0},
  [7555] = {.lex_state = 0},
  [7556] = {.lex_state = 0},
  [7557] = {.lex_state = 0},
  [7558] = {.lex_state = 0},
  [7559] = {.lex_state = 0, .external_lex_state = 2},
  [7560] = {.lex_state = 0},
  [7561] = {.lex_state = 0},
  [7562] = {.lex_state = 0},
  [7563] = {.lex_state = 0},
  [7564] = {.lex_state = 0},
  [7565] = {.lex_state = 0},
  [7566] = {.lex_state = 0},
  [7567] = {.lex_state = 0, .external_lex_state = 2},
  [7568] = {.lex_state = 0},
  [7569] = {.lex_state = 0},
  [7570] = {.lex_state = 0},
  [7571] = {.lex_state = 0},
  [7572] = {.lex_state = 0},
  [7573] = {.lex_state = 0},
  [7574] = {.lex_state = 0, .external_lex_state = 2},
  [7575] = {.lex_state = 0},
  [7576] = {.lex_state = 0},
  [7577] = {.lex_state = 0},
  [7578] = {.lex_state = 0},
  [7579] = {.lex_state = 0},
  [7580] = {.lex_state = 0},
  [7581] = {.lex_state = 0},
  [7582] = {.lex_state = 0},
  [7583] = {.lex_state = 0},
  [7584] = {.lex_state = 0},
  [7585] = {.lex_state = 0, .external_lex_state = 2},
  [7586] = {.lex_state = 0},
  [7587] = {.lex_state = 0},
  [7588] = {.lex_state = 0},
  [7589] = {.lex_state = 0},
  [7590] = {.lex_state = 0},
  [7591] = {.lex_state = 0},
  [7592] = {.lex_state = 0},
  [7593] = {.lex_state = 0},
  [7594] = {.lex_state = 0, .external_lex_state = 2},
  [7595] = {.lex_state = 0},
  [7596] = {.lex_state = 0},
  [7597] = {.lex_state = 0},
  [7598] = {.lex_state = 0},
  [7599] = {.lex_state = 0},
  [7600] = {.lex_state = 0},
  [7601] = {.lex_state = 0},
  [7602] = {.lex_state = 0},
  [7603] = {.lex_state = 0, .external_lex_state = 2},
  [7604] = {.lex_state = 0},
  [7605] = {.lex_state = 0},
  [7606] = {.lex_state = 0},
  [7607] = {.lex_state = 0},
  [7608] = {.lex_state = 0},
  [7609] = {.lex_state = 0},
  [7610] = {.lex_state = 0},
  [7611] = {.lex_state = 0},
  [7612] = {.lex_state = 0},
  [7613] = {.lex_state = 0},
  [7614] = {.lex_state = 0},
  [7615] = {.lex_state = 0},
  [7616] = {.lex_state = 0, .external_lex_state = 2},
  [7617] = {.lex_state = 0},
  [7618] = {.lex_state = 0},
  [7619] = {.lex_state = 0},
  [7620] = {.lex_state = 0},
  [7621] = {.lex_state = 0},
  [7622] = {.lex_state = 0},
  [7623] = {.lex_state = 0},
  [7624] = {.lex_state = 0},
  [7625] = {.lex_state = 0},
  [7626] = {.lex_state = 0},
  [7627] = {.lex_state = 0},
  [7628] = {.lex_state = 0},
  [7629] = {.lex_state = 0},
  [7630] = {.lex_state = 0},
  [7631] = {.lex_state = 0},
  [7632] = {.lex_state = 0, .external_lex_state = 2},
  [7633] = {.lex_state = 0},
  [7634] = {.lex_state = 0},
  [7635] = {.lex_state = 0},
  [7636] = {.lex_state = 0},
  [7637] = {.lex_state = 0, .external_lex_state = 2},
  [7638] = {.lex_state = 0},
  [7639] = {.lex_state = 0},
  [7640] = {.lex_state = 0},
  [7641] = {.lex_state = 0},
  [7642] = {.lex_state = 0},
  [7643] = {.lex_state = 0},
  [7644] = {.lex_state = 0},
  [7645] = {.lex_state = 0},
  [7646] = {.lex_state = 0},
  [7647] = {.lex_state = 0},
  [7648] = {.lex_state = 0, .external_lex_state = 2},
  [7649] = {.lex_state = 0},
  [7650] = {.lex_state = 0},
  [7651] = {.lex_state = 0},
  [7652] = {.lex_state = 0},
  [7653] = {.lex_state = 0},
  [7654] = {.lex_state = 0},
  [7655] = {.lex_state = 0},
  [7656] = {.lex_state = 0, .external_lex_state = 2},
  [7657] = {.lex_state = 0},
  [7658] = {.lex_state = 0},
  [7659] = {.lex_state = 0},
  [7660] = {.lex_state = 0},
  [7661] = {.lex_state = 0, .external_lex_state = 2},
  [7662] = {.lex_state = 0},
  [7663] = {.lex_state = 0},
  [7664] = {.lex_state = 0},
  [7665] = {.lex_state = 0},
  [7666] = {.lex_state = 0},
  [7667] = {.lex_state = 0},
  [7668] = {.lex_state = 0, .external_lex_state = 2},
  [7669] = {.lex_state = 0},
  [7670] = {.lex_state = 0},
  [7671] = {.lex_state = 0, .external_lex_state = 2},
  [7672] = {.lex_state = 0},
  [7673] = {.lex_state = 0},
  [7674] = {.lex_state = 0},
  [7675] = {.lex_state = 0},
  [7676] = {.lex_state = 0},
  [7677] = {.lex_state = 0},
  [7678] = {.lex_state = 0},
  [7679] = {.lex_state = 0},
  [7680] = {.lex_state = 0, .external_lex_state = 2},
  [7681] = {.lex_state = 0},
  [7682] = {.lex_state = 0},
  [7683] = {.lex_state = 0},
  [7684] = {.lex_state = 0},
  [7685] = {.lex_state = 0},
  [7686] = {.lex_state = 0},
  [7687] = {.lex_state = 0},
  [7688] = {.lex_state = 0},
  [7689] = {.lex_state = 0},
  [7690] = {.lex_state = 0},
  [7691] = {.lex_state = 0, .external_lex_state = 2},
  [7692] = {.lex_state = 0},
  [7693] = {.lex_state = 0},
  [7694] = {.lex_state = 0},
  [7695] = {.lex_state = 0},
  [7696] = {.lex_state = 0},
  [7697] = {.lex_state = 0},
  [7698] = {.lex_state = 0},
  [7699] = {.lex_state = 0},
  [7700] = {.lex_state = 0, .external_lex_state = 2},
  [7701] = {.lex_state = 0},
  [7702] = {.lex_state = 0},
  [7703] = {.lex_state = 0},
  [7704] = {.lex_state = 0},
  [7705] = {.lex_state = 0},
  [7706] = {.lex_state = 0, .external_lex_state = 2},
  [7707] = {.lex_state = 0},
  [7708] = {.lex_state = 0},
  [7709] = {.lex_state = 0},
  [7710] = {.lex_state = 0},
  [7711] = {.lex_state = 0},
  [7712] = {.lex_state = 0},
  [7713] = {.lex_state = 0},
  [7714] = {.lex_state = 0},
  [7715] = {.lex_state = 0},
  [7716] = {.lex_state = 0},
  [7717] = {.lex_state = 0},
  [7718] = {.lex_state = 0},
  [7719] = {.lex_state = 0},
  [7720] = {.lex_state = 0},
  [7721] = {.lex_state = 0, .external_lex_state = 2},
  [7722] = {.lex_state = 0},
  [7723] = {.lex_state = 0},
  [7724] = {.lex_state = 0},
  [7725] = {.lex_state = 0},
  [7726] = {.lex_state = 0},
  [7727] = {.lex_state = 0},
  [7728] = {.lex_state = 0},
  [7729] = {.lex_state = 0},
  [7730] = {.lex_state = 0},
  [7731] = {.lex_state = 0},
  [7732] = {.lex_state = 0},
  [7733] = {.lex_state = 0},
  [7734] = {.lex_state = 0},
  [7735] = {.lex_state = 0},
  [7736] = {.lex_state = 0},
  [7737] = {.lex_state = 0},
  [7738] = {.lex_state = 0},
  [7739] = {.lex_state = 0},
  [7740] = {.lex_state = 0},
  [7741] = {.lex_state = 0},
  [7742] = {.lex_state = 0},
  [7743] = {.lex_state = 0},
  [7744] = {.lex_state = 0},
  [7745] = {.lex_state = 0, .external_lex_state = 2},
  [7746] = {.lex_state = 0},
  [7747] = {.lex_state = 0, .external_lex_state = 2},
  [7748] = {.lex_state = 0},
  [7749] = {.lex_state = 0},
  [7750] = {.lex_state = 0, .external_lex_state = 2},
  [7751] = {.lex_state = 0},
  [7752] = {.lex_state = 0},
  [7753] = {.lex_state = 0},
  [7754] = {.lex_state = 0},
  [7755] = {.lex_state = 0},
  [7756] = {.lex_state = 0},
  [7757] = {.lex_state = 0},
  [7758] = {.lex_state = 0},
  [7759] = {.lex_state = 0},
  [7760] = {.lex_state = 0, .external_lex_state = 2},
  [7761] = {.lex_state = 0},
  [7762] = {.lex_state = 0},
  [7763] = {.lex_state = 0},
  [7764] = {.lex_state = 0},
  [7765] = {.lex_state = 0},
  [7766] = {.lex_state = 0},
  [7767] = {.lex_state = 0},
  [7768] = {.lex_state = 0},
  [7769] = {.lex_state = 0},
  [7770] = {.lex_state = 0},
  [7771] = {.lex_state = 0},
  [7772] = {.lex_state = 0},
  [7773] = {.lex_state = 0},
  [7774] = {.lex_state = 0},
  [7775] = {.lex_state = 0},
  [7776] = {.lex_state = 0},
  [7777] = {.lex_state = 0},
  [7778] = {.lex_state = 0},
  [7779] = {.lex_state = 0},
  [7780] = {.lex_state = 0},
  [7781] = {.lex_state = 29},
  [7782] = {.lex_state = 0},
  [7783] = {.lex_state = 0},
  [7784] = {.lex_state = 0},
  [7785] = {.lex_state = 0},
  [7786] = {.lex_state = 0},
  [7787] = {.lex_state = 0},
  [7788] = {.lex_state = 0},
  [7789] = {.lex_state = 0},
  [7790] = {.lex_state = 0},
  [7791] = {.lex_state = 0},
  [7792] = {.lex_state = 0},
  [7793] = {.lex_state = 0},
  [7794] = {.lex_state = 0},
  [7795] = {.lex_state = 0},
  [7796] = {.lex_state = 0},
  [7797] = {.lex_state = 0},
  [7798] = {.lex_state = 0},
  [7799] = {.lex_state = 0},
  [7800] = {.lex_state = 0},
  [7801] = {.lex_state = 0},
  [7802] = {.lex_state = 0},
  [7803] = {.lex_state = 0},
  [7804] = {.lex_state = 0},
  [7805] = {.lex_state = 0},
  [7806] = {.lex_state = 0},
  [7807] = {.lex_state = 0},
  [7808] = {.lex_state = 0},
  [7809] = {.lex_state = 0},
  [7810] = {.lex_state = 0},
  [7811] = {.lex_state = 0},
  [7812] = {.lex_state = 0},
  [7813] = {.lex_state = 0},
  [7814] = {.lex_state = 0},
  [7815] = {.lex_state = 29},
  [7816] = {.lex_state = 0},
  [7817] = {.lex_state = 0},
  [7818] = {.lex_state = 0},
  [7819] = {.lex_state = 0},
  [7820] = {.lex_state = 0},
  [7821] = {.lex_state = 0},
  [7822] = {.lex_state = 0},
  [7823] = {.lex_state = 0},
  [7824] = {.lex_state = 0},
  [7825] = {.lex_state = 0},
  [7826] = {.lex_state = 0},
  [7827] = {.lex_state = 0},
  [7828] = {.lex_state = 0},
  [7829] = {.lex_state = 0},
  [7830] = {.lex_state = 0},
  [7831] = {.lex_state = 0},
  [7832] = {.lex_state = 0},
  [7833] = {.lex_state = 0},
  [7834] = {.lex_state = 0},
  [7835] = {.lex_state = 0},
  [7836] = {.lex_state = 0},
  [7837] = {.lex_state = 0},
  [7838] = {.lex_state = 0},
  [7839] = {.lex_state = 0},
  [7840] = {.lex_state = 0},
  [7841] = {.lex_state = 0},
  [7842] = {.lex_state = 0},
  [7843] = {.lex_state = 0},
  [7844] = {.lex_state = 0},
  [7845] = {.lex_state = 0},
  [7846] = {.lex_state = 0},
  [7847] = {.lex_state = 0},
  [7848] = {.lex_state = 0},
  [7849] = {.lex_state = 0},
  [7850] = {.lex_state = 0},
  [7851] = {.lex_state = 0},
  [7852] = {.lex_state = 0},
  [7853] = {.lex_state = 0},
  [7854] = {.lex_state = 0},
  [7855] = {.lex_state = 0},
  [7856] = {.lex_state = 0},
  [7857] = {.lex_state = 0},
  [7858] = {.lex_state = 0},
  [7859] = {.lex_state = 0},
  [7860] = {.lex_state = 0},
  [7861] = {.lex_state = 0},
  [7862] = {.lex_state = 0},
  [7863] = {.lex_state = 0},
  [7864] = {.lex_state = 0},
  [7865] = {.lex_state = 0},
  [7866] = {.lex_state = 0},
  [7867] = {.lex_state = 0},
  [7868] = {.lex_state = 0},
  [7869] = {.lex_state = 0},
  [7870] = {.lex_state = 0},
  [7871] = {.lex_state = 29},
  [7872] = {.lex_state = 0},
  [7873] = {.lex_state = 0},
  [7874] = {.lex_state = 0},
  [7875] = {.lex_state = 29},
  [7876] = {.lex_state = 0},
  [7877] = {.lex_state = 0},
  [7878] = {.lex_state = 0},
  [7879] = {.lex_state = 0},
  [7880] = {.lex_state = 0},
  [7881] = {.lex_state = 0},
  [7882] = {.lex_state = 0},
  [7883] = {.lex_state = 0},
  [7884] = {.lex_state = 0},
  [7885] = {.lex_state = 0},
  [7886] = {.lex_state = 0},
  [7887] = {.lex_state = 0},
  [7888] = {.lex_state = 0},
  [7889] = {.lex_state = 0},
  [7890] = {.lex_state = 0},
  [7891] = {.lex_state = 0},
  [7892] = {.lex_state = 0},
  [7893] = {.lex_state = 0},
  [7894] = {.lex_state = 30},
  [7895] = {.lex_state = 0},
  [7896] = {.lex_state = 0},
  [7897] = {.lex_state = 0},
  [7898] = {.lex_state = 0},
  [7899] = {.lex_state = 0},
  [7900] = {.lex_state = 0},
  [7901] = {.lex_state = 0},
  [7902] = {.lex_state = 0},
  [7903] = {.lex_state = 0},
  [7904] = {.lex_state = 0},
  [7905] = {.lex_state = 0},
  [7906] = {.lex_state = 0},
  [7907] = {.lex_state = 0},
  [7908] = {.lex_state = 0},
  [7909] = {.lex_state = 0},
  [7910] = {.lex_state = 0},
  [7911] = {.lex_state = 0},
  [7912] = {.lex_state = 0},
  [7913] = {.lex_state = 0},
  [7914] = {.lex_state = 0},
  [7915] = {.lex_state = 0},
  [7916] = {.lex_state = 0},
  [7917] = {.lex_state = 0},
  [7918] = {.lex_state = 0},
  [7919] = {.lex_state = 0},
  [7920] = {.lex_state = 0},
  [7921] = {.lex_state = 0},
  [7922] = {.lex_state = 0},
  [7923] = {.lex_state = 0},
  [7924] = {.lex_state = 0},
  [7925] = {.lex_state = 0},
  [7926] = {.lex_state = 0},
  [7927] = {.lex_state = 0},
  [7928] = {.lex_state = 0},
  [7929] = {.lex_state = 0},
  [7930] = {.lex_state = 0},
  [7931] = {.lex_state = 0},
  [7932] = {.lex_state = 0},
  [7933] = {.lex_state = 0},
  [7934] = {.lex_state = 0},
  [7935] = {.lex_state = 0},
  [7936] = {.lex_state = 29},
  [7937] = {.lex_state = 0},
  [7938] = {.lex_state = 0},
  [7939] = {.lex_state = 0},
  [7940] = {.lex_state = 0},
  [7941] = {.lex_state = 0},
  [7942] = {.lex_state = 0},
  [7943] = {.lex_state = 0},
  [7944] = {.lex_state = 0},
  [7945] = {.lex_state = 0},
  [7946] = {.lex_state = 0},
  [7947] = {.lex_state = 0},
  [7948] = {.lex_state = 0},
  [7949] = {.lex_state = 0},
  [7950] = {.lex_state = 0},
  [7951] = {.lex_state = 0},
  [7952] = {.lex_state = 0},
  [7953] = {.lex_state = 0},
  [7954] = {.lex_state = 0},
  [7955] = {.lex_state = 0},
  [7956] = {.lex_state = 0},
  [7957] = {.lex_state = 0},
  [7958] = {.lex_state = 0},
  [7959] = {.lex_state = 0},
  [7960] = {.lex_state = 0},
  [7961] = {.lex_state = 0},
  [7962] = {.lex_state = 0},
  [7963] = {.lex_state = 0},
  [7964] = {.lex_state = 0},
  [7965] = {.lex_state = 0},
  [7966] = {.lex_state = 0},
  [7967] = {.lex_state = 0},
  [7968] = {.lex_state = 0},
  [7969] = {.lex_state = 0},
  [7970] = {.lex_state = 0},
  [7971] = {.lex_state = 0},
  [7972] = {.lex_state = 0},
  [7973] = {.lex_state = 0},
  [7974] = {.lex_state = 0},
  [7975] = {.lex_state = 29},
  [7976] = {.lex_state = 0},
  [7977] = {.lex_state = 0},
  [7978] = {.lex_state = 0},
  [7979] = {.lex_state = 0},
  [7980] = {.lex_state = 0},
  [7981] = {.lex_state = 0},
  [7982] = {.lex_state = 0},
  [7983] = {.lex_state = 0},
  [7984] = {.lex_state = 0},
  [7985] = {.lex_state = 0},
  [7986] = {.lex_state = 0},
  [7987] = {.lex_state = 0},
  [7988] = {.lex_state = 0},
  [7989] = {.lex_state = 0},
  [7990] = {.lex_state = 0},
  [7991] = {.lex_state = 0},
  [7992] = {.lex_state = 0},
  [7993] = {.lex_state = 29},
  [7994] = {.lex_state = 0},
  [7995] = {.lex_state = 0},
  [7996] = {.lex_state = 0},
  [7997] = {.lex_state = 0},
  [7998] = {.lex_state = 0},
  [7999] = {.lex_state = 0},
  [8000] = {.lex_state = 0},
  [8001] = {.lex_state = 0},
  [8002] = {.lex_state = 0},
  [8003] = {.lex_state = 0},
  [8004] = {.lex_state = 0},
  [8005] = {.lex_state = 0},
  [8006] = {.lex_state = 29},
  [8007] = {.lex_state = 0},
  [8008] = {.lex_state = 0},
  [8009] = {.lex_state = 0},
  [8010] = {.lex_state = 0},
  [8011] = {.lex_state = 0},
  [8012] = {.lex_state = 0},
  [8013] = {.lex_state = 0},
  [8014] = {.lex_state = 0},
  [8015] = {.lex_state = 0},
  [8016] = {.lex_state = 0},
  [8017] = {.lex_state = 0},
  [8018] = {.lex_state = 0},
  [8019] = {.lex_state = 0},
  [8020] = {.lex_state = 0},
  [8021] = {.lex_state = 0},
  [8022] = {.lex_state = 0},
  [8023] = {.lex_state = 0},
  [8024] = {.lex_state = 0},
  [8025] = {.lex_state = 0},
  [8026] = {.lex_state = 0},
  [8027] = {.lex_state = 0},
  [8028] = {.lex_state = 0},
  [8029] = {.lex_state = 0},
  [8030] = {.lex_state = 0},
  [8031] = {.lex_state = 0},
  [8032] = {.lex_state = 0},
  [8033] = {.lex_state = 0},
  [8034] = {.lex_state = 0},
  [8035] = {.lex_state = 0},
  [8036] = {.lex_state = 0},
  [8037] = {.lex_state = 0},
  [8038] = {.lex_state = 0},
  [8039] = {.lex_state = 0},
  [8040] = {.lex_state = 0},
  [8041] = {.lex_state = 0},
  [8042] = {.lex_state = 0},
  [8043] = {.lex_state = 0},
  [8044] = {.lex_state = 0},
  [8045] = {.lex_state = 0},
  [8046] = {.lex_state = 0},
  [8047] = {.lex_state = 0},
  [8048] = {.lex_state = 0},
  [8049] = {.lex_state = 0},
  [8050] = {.lex_state = 0},
  [8051] = {.lex_state = 0},
  [8052] = {.lex_state = 0},
  [8053] = {.lex_state = 0},
  [8054] = {.lex_state = 0},
  [8055] = {.lex_state = 0},
  [8056] = {.lex_state = 0},
  [8057] = {.lex_state = 0},
  [8058] = {.lex_state = 0},
  [8059] = {.lex_state = 0},
  [8060] = {.lex_state = 0},
  [8061] = {.lex_state = 0},
  [8062] = {.lex_state = 0},
  [8063] = {.lex_state = 0},
  [8064] = {.lex_state = 0},
  [8065] = {.lex_state = 0},
  [8066] = {.lex_state = 0},
  [8067] = {.lex_state = 0},
  [8068] = {.lex_state = 0},
  [8069] = {.lex_state = 0},
  [8070] = {.lex_state = 0},
  [8071] = {.lex_state = 0},
  [8072] = {.lex_state = 0},
  [8073] = {.lex_state = 0},
  [8074] = {.lex_state = 0},
  [8075] = {.lex_state = 0},
  [8076] = {.lex_state = 0},
  [8077] = {.lex_state = 29},
  [8078] = {.lex_state = 0},
  [8079] = {.lex_state = 0},
  [8080] = {.lex_state = 0},
  [8081] = {.lex_state = 0},
  [8082] = {.lex_state = 0},
  [8083] = {.lex_state = 0},
  [8084] = {.lex_state = 0},
  [8085] = {.lex_state = 0},
  [8086] = {.lex_state = 0},
  [8087] = {.lex_state = 0},
  [8088] = {.lex_state = 0},
  [8089] = {.lex_state = 0},
  [8090] = {.lex_state = 0},
  [8091] = {.lex_state = 0},
  [8092] = {.lex_state = 0},
  [8093] = {.lex_state = 0},
  [8094] = {.lex_state = 0},
  [8095] = {.lex_state = 0},
  [8096] = {.lex_state = 0},
  [8097] = {.lex_state = 0},
  [8098] = {.lex_state = 0},
  [8099] = {.lex_state = 0},
  [8100] = {.lex_state = 0},
  [8101] = {.lex_state = 0},
  [8102] = {.lex_state = 0},
  [8103] = {.lex_state = 0},
  [8104] = {.lex_state = 0},
  [8105] = {.lex_state = 0},
  [8106] = {.lex_state = 0},
  [8107] = {.lex_state = 0},
  [8108] = {.lex_state = 0},
  [8109] = {.lex_state = 0},
  [8110] = {.lex_state = 0},
  [8111] = {.lex_state = 0},
  [8112] = {.lex_state = 0},
  [8113] = {.lex_state = 0},
  [8114] = {.lex_state = 0},
  [8115] = {.lex_state = 0},
  [8116] = {.lex_state = 0},
  [8117] = {.lex_state = 29},
  [8118] = {.lex_state = 0},
  [8119] = {.lex_state = 0},
  [8120] = {.lex_state = 0},
  [8121] = {.lex_state = 0},
  [8122] = {.lex_state = 0},
  [8123] = {.lex_state = 0},
  [8124] = {.lex_state = 0},
  [8125] = {.lex_state = 0},
  [8126] = {.lex_state = 0},
  [8127] = {.lex_state = 0},
  [8128] = {.lex_state = 0},
  [8129] = {.lex_state = 0},
  [8130] = {.lex_state = 0},
  [8131] = {.lex_state = 0},
  [8132] = {.lex_state = 0},
  [8133] = {.lex_state = 0},
  [8134] = {.lex_state = 0},
  [8135] = {.lex_state = 0},
  [8136] = {.lex_state = 0},
  [8137] = {.lex_state = 0},
  [8138] = {.lex_state = 0},
  [8139] = {.lex_state = 0},
  [8140] = {.lex_state = 0},
  [8141] = {.lex_state = 0},
  [8142] = {.lex_state = 0},
  [8143] = {.lex_state = 0},
  [8144] = {.lex_state = 0},
  [8145] = {.lex_state = 0},
  [8146] = {.lex_state = 0},
  [8147] = {.lex_state = 0},
  [8148] = {.lex_state = 0},
  [8149] = {.lex_state = 0},
  [8150] = {.lex_state = 0},
  [8151] = {.lex_state = 0},
  [8152] = {.lex_state = 0},
  [8153] = {.lex_state = 0},
  [8154] = {.lex_state = 0},
  [8155] = {.lex_state = 0},
  [8156] = {.lex_state = 0},
  [8157] = {.lex_state = 0},
  [8158] = {.lex_state = 0},
  [8159] = {.lex_state = 0},
  [8160] = {.lex_state = 0},
  [8161] = {.lex_state = 0},
  [8162] = {.lex_state = 0},
  [8163] = {.lex_state = 29},
  [8164] = {.lex_state = 0},
  [8165] = {.lex_state = 0},
  [8166] = {.lex_state = 0},
  [8167] = {.lex_state = 0},
  [8168] = {.lex_state = 0},
  [8169] = {.lex_state = 0},
  [8170] = {.lex_state = 0},
  [8171] = {.lex_state = 0},
  [8172] = {.lex_state = 29},
  [8173] = {.lex_state = 0},
  [8174] = {.lex_state = 0},
  [8175] = {.lex_state = 0},
  [8176] = {.lex_state = 0, .external_lex_state = 2},
  [8177] = {.lex_state = 0},
  [8178] = {.lex_state = 0},
  [8179] = {.lex_state = 0},
  [8180] = {.lex_state = 0},
  [8181] = {.lex_state = 0},
  [8182] = {.lex_state = 0},
  [8183] = {.lex_state = 0},
  [8184] = {.lex_state = 0},
  [8185] = {.lex_state = 0},
  [8186] = {.lex_state = 0},
  [8187] = {.lex_state = 0},
  [8188] = {.lex_state = 0},
  [8189] = {.lex_state = 0},
  [8190] = {.lex_state = 0},
  [8191] = {.lex_state = 0},
  [8192] = {.lex_state = 0},
  [8193] = {.lex_state = 0},
  [8194] = {.lex_state = 0},
  [8195] = {.lex_state = 0},
  [8196] = {.lex_state = 0},
  [8197] = {.lex_state = 0},
  [8198] = {.lex_state = 0},
  [8199] = {.lex_state = 0},
  [8200] = {.lex_state = 0},
  [8201] = {.lex_state = 0},
  [8202] = {.lex_state = 0},
  [8203] = {.lex_state = 0},
  [8204] = {.lex_state = 0},
  [8205] = {.lex_state = 0},
  [8206] = {.lex_state = 0},
  [8207] = {.lex_state = 0},
  [8208] = {.lex_state = 0},
  [8209] = {.lex_state = 0},
  [8210] = {.lex_state = 0},
  [8211] = {.lex_state = 0},
  [8212] = {.lex_state = 0},
  [8213] = {.lex_state = 0},
  [8214] = {.lex_state = 0},
  [8215] = {.lex_state = 0},
  [8216] = {.lex_state = 0},
  [8217] = {.lex_state = 0},
  [8218] = {.lex_state = 0},
  [8219] = {.lex_state = 0},
  [8220] = {.lex_state = 0},
  [8221] = {.lex_state = 0},
  [8222] = {.lex_state = 29},
  [8223] = {.lex_state = 0},
  [8224] = {.lex_state = 0},
  [8225] = {.lex_state = 0},
  [8226] = {.lex_state = 0},
  [8227] = {.lex_state = 0},
  [8228] = {.lex_state = 0},
  [8229] = {.lex_state = 0},
  [8230] = {.lex_state = 0},
  [8231] = {.lex_state = 0},
  [8232] = {.lex_state = 0},
  [8233] = {.lex_state = 0},
  [8234] = {.lex_state = 0},
  [8235] = {.lex_state = 0},
  [8236] = {.lex_state = 0, .external_lex_state = 2},
  [8237] = {.lex_state = 0},
  [8238] = {.lex_state = 0},
  [8239] = {.lex_state = 0},
  [8240] = {.lex_state = 0},
  [8241] = {.lex_state = 0},
  [8242] = {.lex_state = 0},
  [8243] = {.lex_state = 0},
  [8244] = {.lex_state = 0},
  [8245] = {.lex_state = 0},
  [8246] = {.lex_state = 0},
  [8247] = {.lex_state = 0},
  [8248] = {.lex_state = 0},
  [8249] = {.lex_state = 0},
  [8250] = {.lex_state = 0},
  [8251] = {.lex_state = 0},
  [8252] = {.lex_state = 0},
  [8253] = {.lex_state = 0},
  [8254] = {.lex_state = 0},
  [8255] = {.lex_state = 0},
  [8256] = {.lex_state = 0},
  [8257] = {.lex_state = 0},
  [8258] = {.lex_state = 0},
  [8259] = {.lex_state = 0},
  [8260] = {.lex_state = 0},
  [8261] = {.lex_state = 0},
  [8262] = {.lex_state = 0},
  [8263] = {.lex_state = 0},
  [8264] = {.lex_state = 0},
  [8265] = {.lex_state = 0},
  [8266] = {.lex_state = 0},
  [8267] = {.lex_state = 0},
  [8268] = {.lex_state = 0},
  [8269] = {.lex_state = 0},
  [8270] = {.lex_state = 0},
  [8271] = {.lex_state = 0},
  [8272] = {.lex_state = 0},
  [8273] = {.lex_state = 0},
  [8274] = {.lex_state = 0},
  [8275] = {.lex_state = 0},
  [8276] = {.lex_state = 0},
  [8277] = {.lex_state = 0},
  [8278] = {.lex_state = 0},
  [8279] = {.lex_state = 0},
  [8280] = {.lex_state = 0},
  [8281] = {.lex_state = 0},
  [8282] = {.lex_state = 0},
  [8283] = {.lex_state = 0},
  [8284] = {.lex_state = 0},
  [8285] = {.lex_state = 0},
  [8286] = {.lex_state = 0},
  [8287] = {.lex_state = 0},
  [8288] = {.lex_state = 0},
  [8289] = {.lex_state = 0},
  [8290] = {.lex_state = 0},
  [8291] = {.lex_state = 0},
  [8292] = {.lex_state = 0},
  [8293] = {.lex_state = 0},
  [8294] = {.lex_state = 0},
  [8295] = {.lex_state = 0},
  [8296] = {.lex_state = 0},
  [8297] = {.lex_state = 0},
  [8298] = {.lex_state = 0},
  [8299] = {.lex_state = 0},
  [8300] = {.lex_state = 0},
  [8301] = {.lex_state = 0},
  [8302] = {.lex_state = 0},
  [8303] = {.lex_state = 0},
  [8304] = {.lex_state = 0},
  [8305] = {.lex_state = 0},
  [8306] = {.lex_state = 0},
  [8307] = {.lex_state = 0},
  [8308] = {.lex_state = 0},
  [8309] = {.lex_state = 0},
  [8310] = {.lex_state = 0},
  [8311] = {.lex_state = 0},
  [8312] = {.lex_state = 0},
  [8313] = {.lex_state = 0},
  [8314] = {.lex_state = 0},
  [8315] = {.lex_state = 0},
  [8316] = {.lex_state = 0},
  [8317] = {.lex_state = 0},
  [8318] = {.lex_state = 0},
  [8319] = {.lex_state = 0},
  [8320] = {.lex_state = 0},
  [8321] = {.lex_state = 0},
  [8322] = {.lex_state = 0},
  [8323] = {.lex_state = 0},
  [8324] = {.lex_state = 0},
  [8325] = {.lex_state = 0},
  [8326] = {.lex_state = 0},
  [8327] = {.lex_state = 0},
  [8328] = {.lex_state = 0},
  [8329] = {.lex_state = 0},
  [8330] = {.lex_state = 0},
  [8331] = {.lex_state = 0},
  [8332] = {.lex_state = 0},
  [8333] = {.lex_state = 0},
  [8334] = {.lex_state = 0},
  [8335] = {.lex_state = 0},
  [8336] = {.lex_state = 0},
  [8337] = {.lex_state = 0},
  [8338] = {.lex_state = 0},
  [8339] = {.lex_state = 0},
  [8340] = {.lex_state = 0},
  [8341] = {.lex_state = 0},
  [8342] = {.lex_state = 0},
  [8343] = {.lex_state = 0},
  [8344] = {.lex_state = 0},
  [8345] = {.lex_state = 0},
  [8346] = {.lex_state = 0},
  [8347] = {.lex_state = 0},
  [8348] = {.lex_state = 0},
  [8349] = {.lex_state = 0},
  [8350] = {.lex_state = 0},
  [8351] = {.lex_state = 0},
  [8352] = {.lex_state = 0},
  [8353] = {.lex_state = 0},
  [8354] = {.lex_state = 0},
  [8355] = {.lex_state = 0},
  [8356] = {.lex_state = 0},
  [8357] = {.lex_state = 0},
  [8358] = {.lex_state = 0},
  [8359] = {.lex_state = 0},
  [8360] = {.lex_state = 0},
  [8361] = {.lex_state = 0},
  [8362] = {.lex_state = 0},
  [8363] = {.lex_state = 0},
  [8364] = {.lex_state = 29},
  [8365] = {.lex_state = 0},
  [8366] = {.lex_state = 0},
  [8367] = {.lex_state = 0},
  [8368] = {.lex_state = 0},
  [8369] = {.lex_state = 0},
  [8370] = {.lex_state = 0},
  [8371] = {.lex_state = 0},
  [8372] = {.lex_state = 0},
  [8373] = {.lex_state = 0},
  [8374] = {.lex_state = 0},
  [8375] = {.lex_state = 0},
  [8376] = {.lex_state = 0},
  [8377] = {.lex_state = 0},
  [8378] = {.lex_state = 0},
  [8379] = {.lex_state = 0},
  [8380] = {.lex_state = 0},
  [8381] = {.lex_state = 0},
  [8382] = {.lex_state = 0},
  [8383] = {.lex_state = 0},
  [8384] = {.lex_state = 0},
  [8385] = {.lex_state = 0},
  [8386] = {.lex_state = 0},
  [8387] = {.lex_state = 0},
  [8388] = {.lex_state = 0},
  [8389] = {.lex_state = 0},
  [8390] = {.lex_state = 0},
  [8391] = {.lex_state = 0},
  [8392] = {.lex_state = 0},
  [8393] = {.lex_state = 0},
  [8394] = {.lex_state = 0},
  [8395] = {.lex_state = 0},
  [8396] = {.lex_state = 0},
  [8397] = {.lex_state = 0},
  [8398] = {.lex_state = 0},
  [8399] = {.lex_state = 0},
  [8400] = {.lex_state = 0},
  [8401] = {.lex_state = 0},
  [8402] = {.lex_state = 0, .external_lex_state = 2},
  [8403] = {.lex_state = 0},
  [8404] = {.lex_state = 0},
  [8405] = {.lex_state = 0},
  [8406] = {.lex_state = 0},
  [8407] = {.lex_state = 0},
  [8408] = {.lex_state = 0},
  [8409] = {.lex_state = 0},
  [8410] = {.lex_state = 0},
  [8411] = {.lex_state = 0},
  [8412] = {.lex_state = 0},
  [8413] = {.lex_state = 0},
  [8414] = {.lex_state = 0},
  [8415] = {.lex_state = 0},
  [8416] = {.lex_state = 0},
  [8417] = {.lex_state = 0},
  [8418] = {.lex_state = 0},
  [8419] = {.lex_state = 0},
  [8420] = {.lex_state = 0},
  [8421] = {.lex_state = 0},
  [8422] = {.lex_state = 0},
  [8423] = {.lex_state = 0},
  [8424] = {.lex_state = 0},
  [8425] = {.lex_state = 0},
  [8426] = {.lex_state = 0},
  [8427] = {.lex_state = 0},
  [8428] = {.lex_state = 0},
  [8429] = {.lex_state = 0},
  [8430] = {.lex_state = 0},
  [8431] = {.lex_state = 0, .external_lex_state = 2},
  [8432] = {.lex_state = 0},
  [8433] = {.lex_state = 0},
  [8434] = {.lex_state = 0},
  [8435] = {.lex_state = 0},
  [8436] = {.lex_state = 0},
  [8437] = {.lex_state = 0},
  [8438] = {.lex_state = 0},
  [8439] = {.lex_state = 29},
  [8440] = {.lex_state = 0},
  [8441] = {.lex_state = 0},
  [8442] = {.lex_state = 0},
  [8443] = {.lex_state = 0},
  [8444] = {.lex_state = 0},
  [8445] = {.lex_state = 0},
  [8446] = {.lex_state = 0},
  [8447] = {.lex_state = 0},
  [8448] = {.lex_state = 0},
  [8449] = {.lex_state = 0},
  [8450] = {.lex_state = 0},
  [8451] = {.lex_state = 0},
  [8452] = {.lex_state = 0},
  [8453] = {.lex_state = 0},
  [8454] = {.lex_state = 0},
  [8455] = {.lex_state = 0},
  [8456] = {.lex_state = 0},
  [8457] = {.lex_state = 0},
  [8458] = {.lex_state = 0},
  [8459] = {.lex_state = 0},
  [8460] = {.lex_state = 0},
  [8461] = {.lex_state = 0},
  [8462] = {.lex_state = 0},
  [8463] = {.lex_state = 0},
  [8464] = {.lex_state = 0},
  [8465] = {.lex_state = 0},
  [8466] = {.lex_state = 0},
  [8467] = {.lex_state = 0},
  [8468] = {.lex_state = 0},
  [8469] = {.lex_state = 0},
  [8470] = {.lex_state = 0},
  [8471] = {.lex_state = 0},
  [8472] = {.lex_state = 0},
  [8473] = {.lex_state = 0},
  [8474] = {.lex_state = 0},
  [8475] = {.lex_state = 0},
  [8476] = {.lex_state = 0},
  [8477] = {.lex_state = 0},
  [8478] = {.lex_state = 0},
  [8479] = {.lex_state = 0},
  [8480] = {.lex_state = 0},
  [8481] = {.lex_state = 0},
  [8482] = {.lex_state = 0},
  [8483] = {.lex_state = 0},
  [8484] = {.lex_state = 0},
  [8485] = {.lex_state = 0},
  [8486] = {.lex_state = 0},
  [8487] = {.lex_state = 0},
  [8488] = {.lex_state = 0},
  [8489] = {.lex_state = 0},
  [8490] = {.lex_state = 0},
  [8491] = {.lex_state = 0},
  [8492] = {.lex_state = 0},
  [8493] = {.lex_state = 0},
  [8494] = {.lex_state = 0},
  [8495] = {.lex_state = 0},
  [8496] = {.lex_state = 0},
  [8497] = {.lex_state = 0},
  [8498] = {.lex_state = 0},
  [8499] = {.lex_state = 0},
  [8500] = {.lex_state = 0},
  [8501] = {.lex_state = 0},
  [8502] = {.lex_state = 0},
  [8503] = {.lex_state = 0},
  [8504] = {.lex_state = 0},
  [8505] = {.lex_state = 0},
  [8506] = {.lex_state = 0},
  [8507] = {.lex_state = 0},
  [8508] = {.lex_state = 0},
  [8509] = {.lex_state = 0},
  [8510] = {.lex_state = 0},
  [8511] = {.lex_state = 0},
  [8512] = {.lex_state = 0},
  [8513] = {.lex_state = 0},
  [8514] = {.lex_state = 0},
  [8515] = {.lex_state = 0},
  [8516] = {.lex_state = 0},
  [8517] = {.lex_state = 0},
  [8518] = {.lex_state = 0},
  [8519] = {.lex_state = 0},
};

enum {
  ts_external_token__string_start = 0,
  ts_external_token__string_content = 1,
  ts_external_token__string_end = 2,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__string_start] = sym__string_start,
  [ts_external_token__string_content] = sym__string_content,
  [ts_external_token__string_end] = sym__string_end,
};

static const bool ts_external_scanner_states[4][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__string_start] = true,
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
  },
  [2] = {
    [ts_external_token__string_start] = true,
  },
  [3] = {
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__unquoted_identifier] = ACTIONS(1),
    [aux_sym_keyword_select_token1] = ACTIONS(1),
    [aux_sym_keyword_replace_token1] = ACTIONS(1),
    [aux_sym_keyword_into_token1] = ACTIONS(1),
    [aux_sym_keyword_values_token1] = ACTIONS(1),
    [aux_sym_keyword_set_token1] = ACTIONS(1),
    [aux_sym_keyword_from_token1] = ACTIONS(1),
    [aux_sym_keyword_left_token1] = ACTIONS(1),
    [aux_sym_keyword_format_token1] = ACTIONS(1),
    [aux_sym_keyword_extract_token1] = ACTIONS(1),
    [aux_sym_keyword_right_token1] = ACTIONS(1),
    [aux_sym_keyword_inner_token1] = ACTIONS(1),
    [aux_sym_keyword_outer_token1] = ACTIONS(1),
    [aux_sym_keyword_cross_token1] = ACTIONS(1),
    [aux_sym_keyword_unnest_token1] = ACTIONS(1),
    [aux_sym_keyword_join_token1] = ACTIONS(1),
    [aux_sym_keyword_on_token1] = ACTIONS(1),
    [aux_sym_keyword_recursive_token1] = ACTIONS(1),
    [aux_sym_keyword_call_token1] = ACTIONS(1),
    [aux_sym_keyword_where_token1] = ACTIONS(1),
    [aux_sym_keyword_order_token1] = ACTIONS(1),
    [aux_sym_keyword_group_token1] = ACTIONS(1),
    [aux_sym_keyword_partition_token1] = ACTIONS(1),
    [aux_sym_keyword_by_token1] = ACTIONS(1),
    [aux_sym_keyword_having_token1] = ACTIONS(1),
    [aux_sym_keyword_escape_token1] = ACTIONS(1),
    [aux_sym_keyword_desc_token1] = ACTIONS(1),
    [aux_sym_keyword_asc_token1] = ACTIONS(1),
    [aux_sym_keyword_limit_token1] = ACTIONS(1),
    [aux_sym_keyword_offset_token1] = ACTIONS(1),
    [aux_sym_keyword_table_token1] = ACTIONS(1),
    [aux_sym_keyword_view_token1] = ACTIONS(1),
    [aux_sym_keyword_materialized_token1] = ACTIONS(1),
    [aux_sym_keyword_as_token1] = ACTIONS(1),
    [aux_sym_keyword_distinct_token1] = ACTIONS(1),
    [aux_sym_keyword_cast_token1] = ACTIONS(1),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(1),
    [aux_sym_keyword_max_token1] = ACTIONS(1),
    [aux_sym_keyword_min_token1] = ACTIONS(1),
    [aux_sym_keyword_case_token1] = ACTIONS(1),
    [aux_sym_keyword_when_token1] = ACTIONS(1),
    [aux_sym_keyword_then_token1] = ACTIONS(1),
    [aux_sym_keyword_else_token1] = ACTIONS(1),
    [aux_sym_keyword_end_token1] = ACTIONS(1),
    [aux_sym_keyword_substring_token1] = ACTIONS(1),
    [aux_sym_keyword_in_token1] = ACTIONS(1),
    [aux_sym_keyword_and_token1] = ACTIONS(1),
    [aux_sym_keyword_or_token1] = ACTIONS(1),
    [aux_sym_keyword_is_token1] = ACTIONS(1),
    [aux_sym_keyword_not_token1] = ACTIONS(1),
    [aux_sym_keyword_asymmetric_token1] = ACTIONS(1),
    [aux_sym_keyword_symmetric_token1] = ACTIONS(1),
    [aux_sym_keyword_using_token1] = ACTIONS(1),
    [aux_sym_keyword_for_token1] = ACTIONS(1),
    [aux_sym_keyword_bytes_token1] = ACTIONS(1),
    [aux_sym_keyword_if_token1] = ACTIONS(1),
    [aux_sym_keyword_exists_token1] = ACTIONS(1),
    [aux_sym_keyword_at_token1] = ACTIONS(1),
    [aux_sym_keyword_zone_token1] = ACTIONS(1),
    [aux_sym_keyword_default_token1] = ACTIONS(1),
    [aux_sym_keyword_with_token1] = ACTIONS(1),
    [aux_sym_keyword_no_token1] = ACTIONS(1),
    [aux_sym_keyword_to_token1] = ACTIONS(1),
    [aux_sym_keyword_schema_token1] = ACTIONS(1),
    [aux_sym_keyword_union_token1] = ACTIONS(1),
    [aux_sym_keyword_all_token1] = ACTIONS(1),
    [aux_sym_keyword_except_token1] = ACTIONS(1),
    [aux_sym_keyword_intersect_token1] = ACTIONS(1),
    [aux_sym_keyword_begin_token1] = ACTIONS(1),
    [aux_sym_keyword_commit_token1] = ACTIONS(1),
    [aux_sym_keyword_rollback_token1] = ACTIONS(1),
    [aux_sym_keyword_transaction_token1] = ACTIONS(1),
    [aux_sym_keyword_over_token1] = ACTIONS(1),
    [aux_sym_keyword_nulls_token1] = ACTIONS(1),
    [aux_sym_keyword_first_token1] = ACTIONS(1),
    [aux_sym_keyword_last_token1] = ACTIONS(1),
    [aux_sym_keyword_window_token1] = ACTIONS(1),
    [aux_sym_keyword_system_time_token1] = ACTIONS(1),
    [aux_sym_keyword_of_token1] = ACTIONS(1),
    [aux_sym_keyword_range_token1] = ACTIONS(1),
    [aux_sym_keyword_rows_token1] = ACTIONS(1),
    [aux_sym_keyword_between_token1] = ACTIONS(1),
    [aux_sym_keyword_unbounded_token1] = ACTIONS(1),
    [aux_sym_keyword_preceding_token1] = ACTIONS(1),
    [aux_sym_keyword_following_token1] = ACTIONS(1),
    [aux_sym_keyword_exclude_token1] = ACTIONS(1),
    [aux_sym_keyword_current_token1] = ACTIONS(1),
    [aux_sym_keyword_row_token1] = ACTIONS(1),
    [aux_sym_keyword_ties_token1] = ACTIONS(1),
    [aux_sym_keyword_others_token1] = ACTIONS(1),
    [aux_sym_keyword_like_token1] = ACTIONS(1),
    [aux_sym_keyword_like_token2] = ACTIONS(1),
    [aux_sym_keyword_similar_token1] = ACTIONS(1),
    [aux_sym_keyword_within_token1] = ACTIONS(1),
    [aux_sym_keyword_filter_token1] = ACTIONS(1),
    [aux_sym_keyword_respect_token1] = ACTIONS(1),
    [aux_sym_keyword_trim_token1] = ACTIONS(1),
    [aux_sym_keyword_leading_token1] = ACTIONS(1),
    [aux_sym_keyword_trailing_token1] = ACTIONS(1),
    [aux_sym_keyword_both_token1] = ACTIONS(1),
    [aux_sym_keyword_ignore_token1] = ACTIONS(1),
    [aux_sym_keyword_privileges_token1] = ACTIONS(1),
    [aux_sym_keyword_external_token1] = ACTIONS(1),
    [aux_sym_keyword_declare_token1] = ACTIONS(1),
    [aux_sym_keyword_execute_token1] = ACTIONS(1),
    [aux_sym_keyword_immediate_token1] = ACTIONS(1),
    [aux_sym_keyword_exception_token1] = ACTIONS(1),
    [aux_sym_keyword_error_token1] = ACTIONS(1),
    [aux_sym_keyword_elseif_token1] = ACTIONS(1),
    [aux_sym_keyword_loop_token1] = ACTIONS(1),
    [aux_sym_keyword_until_token1] = ACTIONS(1),
    [aux_sym_keyword_repeat_token1] = ACTIONS(1),
    [aux_sym_keyword_while_token1] = ACTIONS(1),
    [aux_sym_keyword_do_token1] = ACTIONS(1),
    [aux_sym_keyword_break_token1] = ACTIONS(1),
    [aux_sym_keyword_leave_token1] = ACTIONS(1),
    [aux_sym_keyword_continue_token1] = ACTIONS(1),
    [aux_sym_keyword_iterate_token1] = ACTIONS(1),
    [aux_sym_keyword_message_token1] = ACTIONS(1),
    [aux_sym_keyword_raise_token1] = ACTIONS(1),
    [aux_sym_keyword_assert_token1] = ACTIONS(1),
    [aux_sym_keyword_struct_token1] = ACTIONS(1),
    [aux_sym_keyword_value_token1] = ACTIONS(1),
    [aux_sym_keyword_array_token1] = ACTIONS(1),
    [aux_sym_keyword_any_token1] = ACTIONS(1),
    [aux_sym_keyword_some_token1] = ACTIONS(1),
    [aux_sym_keyword_current_date_token1] = ACTIONS(1),
    [aux_sym_keyword_current_time_token1] = ACTIONS(1),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(1),
    [aux_sym_keyword_system_token1] = ACTIONS(1),
    [aux_sym_keyword_tablesample_token1] = ACTIONS(1),
    [aux_sym_keyword_percent_token1] = ACTIONS(1),
    [aux_sym_keyword_pivot_token1] = ACTIONS(1),
    [aux_sym_keyword_qualify_token1] = ACTIONS(1),
    [aux_sym_keyword_include_token1] = ACTIONS(1),
    [aux_sym_keyword_unpivot_token1] = ACTIONS(1),
    [aux_sym_keyword_full_token1] = ACTIONS(1),
    [aux_sym_keyword_null_token1] = ACTIONS(1),
    [aux_sym_keyword_true_token1] = ACTIONS(1),
    [aux_sym_keyword_false_token1] = ACTIONS(1),
    [aux_sym_keyword_boolean_token1] = ACTIONS(1),
    [aux_sym_keyword_boolean_token2] = ACTIONS(1),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(1),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(1),
    [aux_sym_keyword_serial_token1] = ACTIONS(1),
    [aux_sym_keyword_serial_token2] = ACTIONS(1),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(1),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(1),
    [aux_sym_keyword_int_token1] = ACTIONS(1),
    [aux_sym_keyword_int_token2] = ACTIONS(1),
    [aux_sym_keyword_int_token3] = ACTIONS(1),
    [aux_sym_keyword_int_token4] = ACTIONS(1),
    [aux_sym_keyword_int_token5] = ACTIONS(1),
    [aux_sym_keyword_int_token6] = ACTIONS(1),
    [aux_sym_keyword_int_token7] = ACTIONS(1),
    [aux_sym_keyword_decimal_token1] = ACTIONS(1),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(1),
    [aux_sym_keyword_numeric_token1] = ACTIONS(1),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(1),
    [aux_sym_keyword_real_token1] = ACTIONS(1),
    [aux_sym_keyword_real_token2] = ACTIONS(1),
    [aux_sym_keyword_float_token1] = ACTIONS(1),
    [aux_sym_keyword_float_token2] = ACTIONS(1),
    [aux_sym_keyword_money_token1] = ACTIONS(1),
    [aux_sym_keyword_string_token1] = ACTIONS(1),
    [aux_sym_keyword_char_token1] = ACTIONS(1),
    [aux_sym_keyword_char_token2] = ACTIONS(1),
    [aux_sym_keyword_varchar_token1] = ACTIONS(1),
    [aux_sym_keyword_varchar_token2] = ACTIONS(1),
    [aux_sym_keyword_text_token1] = ACTIONS(1),
    [aux_sym_keyword_uuid_token1] = ACTIONS(1),
    [aux_sym_keyword_json_token1] = ACTIONS(1),
    [aux_sym_keyword_jsonb_token1] = ACTIONS(1),
    [aux_sym_keyword_xml_token1] = ACTIONS(1),
    [aux_sym_keyword_bytea_token1] = ACTIONS(1),
    [aux_sym_keyword_interval_token1] = ACTIONS(1),
    [aux_sym_keyword_time_token1] = ACTIONS(1),
    [aux_sym_keyword_date_token1] = ACTIONS(1),
    [aux_sym_keyword_datetime_token1] = ACTIONS(1),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(1),
    [aux_sym_keyword_timestamp_token2] = ACTIONS(1),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(1),
    [aux_sym_keyword_geometry_token1] = ACTIONS(1),
    [aux_sym_keyword_geography_token1] = ACTIONS(1),
    [aux_sym_keyword_box2d_token1] = ACTIONS(1),
    [aux_sym_keyword_box3d_token1] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [sym_left_paren] = ACTIONS(1),
    [sym_right_paren] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [aux_sym_parameter_token1] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [sym_system_variable] = ACTIONS(1),
    [sym__named_query_parameter] = ACTIONS(1),
    [sym__positional_query_parameter] = ACTIONS(1),
    [sym__integer] = ACTIONS(1),
    [sym__quoted_identifier] = ACTIONS(1),
    [sym__string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym__string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(8420),
    [sym_keyword_select] = STATE(22),
    [sym_keyword_set] = STATE(6253),
    [sym_keyword_call] = STATE(6258),
    [sym_keyword_for] = STATE(6270),
    [sym_keyword_if] = STATE(939),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_begin] = STATE(3491),
    [sym_keyword_declare] = STATE(6267),
    [sym_keyword_execute] = STATE(7277),
    [sym_keyword_loop] = STATE(3926),
    [sym_keyword_repeat] = STATE(3921),
    [sym_keyword_while] = STATE(1011),
    [sym_keyword_break] = STATE(6107),
    [sym_keyword_leave] = STATE(6111),
    [sym_keyword_continue] = STATE(6115),
    [sym_keyword_iterate] = STATE(6122),
    [sym_keyword_raise] = STATE(6167),
    [sym_keyword_assert] = STATE(1027),
    [sym_statement] = STATE(3701),
    [sym_select] = STATE(6059),
    [sym_select_clause] = STATE(5042),
    [sym_select_statement] = STATE(6139),
    [sym_set_operation] = STATE(6059),
    [sym_cte_clause] = STATE(6399),
    [sym_transaction] = STATE(3701),
    [sym__begin] = STATE(3449),
    [sym_declare_statement] = STATE(6127),
    [sym_set_statement] = STATE(6127),
    [sym_execute_immadiate_statement] = STATE(6127),
    [sym_call_statement] = STATE(6127),
    [sym_begin_end_statement] = STATE(6127),
    [sym_begin_exception_end_statement] = STATE(6127),
    [sym_if_statement] = STATE(6127),
    [sym_loop_statement] = STATE(6127),
    [sym_repeat_statement] = STATE(6127),
    [sym_while_statement] = STATE(6127),
    [sym_for_in_statement] = STATE(6127),
    [sym_break_statement] = STATE(6127),
    [sym_leave_statement] = STATE(6127),
    [sym_continue_statement] = STATE(6127),
    [sym_iterate_statement] = STATE(6127),
    [sym_raise_statement] = STATE(6127),
    [sym_assert_statement] = STATE(6127),
    [aux_sym_program_repeat1] = STATE(3701),
    [ts_builtin_sym_end] = ACTIONS(5),
    [aux_sym_keyword_select_token1] = ACTIONS(7),
    [aux_sym_keyword_set_token1] = ACTIONS(9),
    [aux_sym_keyword_call_token1] = ACTIONS(11),
    [aux_sym_keyword_for_token1] = ACTIONS(13),
    [aux_sym_keyword_if_token1] = ACTIONS(15),
    [aux_sym_keyword_with_token1] = ACTIONS(17),
    [aux_sym_keyword_begin_token1] = ACTIONS(19),
    [aux_sym_keyword_declare_token1] = ACTIONS(21),
    [aux_sym_keyword_execute_token1] = ACTIONS(23),
    [aux_sym_keyword_loop_token1] = ACTIONS(25),
    [aux_sym_keyword_repeat_token1] = ACTIONS(27),
    [aux_sym_keyword_while_token1] = ACTIONS(29),
    [aux_sym_keyword_break_token1] = ACTIONS(31),
    [aux_sym_keyword_leave_token1] = ACTIONS(33),
    [aux_sym_keyword_continue_token1] = ACTIONS(35),
    [aux_sym_keyword_iterate_token1] = ACTIONS(37),
    [aux_sym_keyword_raise_token1] = ACTIONS(39),
    [aux_sym_keyword_assert_token1] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(43),
  },
  [2] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6702),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3898),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(6939),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [3] = {
    [sym_keyword_extract] = STATE(8465),
    [sym_keyword_unnest] = STATE(7233),
    [sym_keyword_as] = STATE(6852),
    [sym_keyword_distinct] = STATE(63),
    [sym_keyword_cast] = STATE(8466),
    [sym_keyword_safe_cast] = STATE(8466),
    [sym_keyword_case] = STATE(108),
    [sym_keyword_substring] = STATE(8467),
    [sym_keyword_not] = STATE(1238),
    [sym_keyword_exists] = STATE(7311),
    [sym_keyword_all] = STATE(113),
    [sym_keyword_trim] = STATE(8201),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6859),
    [sym_keyword_any] = STATE(7307),
    [sym_keyword_some] = STATE(7307),
    [sym_keyword_current_date] = STATE(4467),
    [sym_keyword_current_time] = STATE(8248),
    [sym_keyword_current_timestamp] = STATE(8247),
    [sym_keyword_null] = STATE(4380),
    [sym_keyword_true] = STATE(4380),
    [sym_keyword_false] = STATE(4380),
    [sym_keyword_decimal] = STATE(7498),
    [sym_keyword_bigdecimal] = STATE(7498),
    [sym_keyword_numeric] = STATE(7498),
    [sym_keyword_bignumeric] = STATE(7498),
    [sym_keyword_json] = STATE(7305),
    [sym_keyword_interval] = STATE(901),
    [sym_keyword_time] = STATE(4325),
    [sym_keyword_date] = STATE(4325),
    [sym_keyword_datetime] = STATE(4325),
    [sym_keyword_timestamp] = STATE(4325),
    [sym_keyword_timestamptz] = STATE(4325),
    [sym_wildcard] = STATE(6141),
    [sym__time_types] = STATE(4325),
    [sym_numeric] = STATE(4380),
    [sym__select_wildcard] = STATE(5948),
    [sym__distinct_on] = STATE(5949),
    [sym_select_field] = STATE(6332),
    [sym_select_expression] = STATE(5552),
    [sym_date] = STATE(4459),
    [sym_parameter] = STATE(4459),
    [sym_case] = STATE(4459),
    [sym_field] = STATE(4459),
    [sym_cast] = STATE(4459),
    [sym_substring] = STATE(4459),
    [sym_quantified_comparison] = STATE(4459),
    [sym_trim] = STATE(4459),
    [sym_invocation] = STATE(4330),
    [sym__extract_invocation] = STATE(4298),
    [sym__array_invocation] = STATE(4332),
    [sym_window_function] = STATE(4459),
    [sym_unnest_operator] = STATE(3165),
    [sym_unnest_clause] = STATE(4459),
    [sym_between] = STATE(4459),
    [sym_interval] = STATE(4380),
    [sym__expression] = STATE(2737),
    [sym_predicate] = STATE(4459),
    [sym_binary_expression] = STATE(4459),
    [sym_field_access] = STATE(4459),
    [sym_element_access] = STATE(4459),
    [sym_subquery] = STATE(4459),
    [sym_list] = STATE(4459),
    [sym_query_parameter] = STATE(4380),
    [sym_literal] = STATE(4459),
    [sym_json] = STATE(4380),
    [sym__number] = STATE(4380),
    [sym__float] = STATE(4455),
    [sym_string] = STATE(4380),
    [sym__type_struct] = STATE(8203),
    [sym__type_array] = STATE(8246),
    [sym_array] = STATE(4380),
    [sym_struct] = STATE(4380),
    [sym_current_date] = STATE(4459),
    [sym_current_time] = STATE(4459),
    [sym_current_timestamp] = STATE(4459),
    [sym__identifier] = STATE(4338),
    [sym__dotted_identifier] = STATE(7126),
    [sym_identifier] = STATE(4452),
    [aux_sym_identifier_repeat1] = STATE(6788),
    [sym__unquoted_identifier] = ACTIONS(139),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_as_token1] = ACTIONS(141),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(147),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(149),
    [aux_sym_keyword_true_token1] = ACTIONS(151),
    [aux_sym_keyword_false_token1] = ACTIONS(153),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(155),
    [aux_sym_keyword_date_token1] = ACTIONS(157),
    [aux_sym_keyword_datetime_token1] = ACTIONS(159),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(161),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(167),
    [anon_sym_QMARK] = ACTIONS(169),
    [anon_sym_DOLLAR] = ACTIONS(171),
    [anon_sym_TILDE] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(175),
    [anon_sym_DASH] = ACTIONS(175),
    [anon_sym_LBRACK] = ACTIONS(177),
    [sym_system_variable] = ACTIONS(179),
    [sym__named_query_parameter] = ACTIONS(181),
    [sym__positional_query_parameter] = ACTIONS(181),
    [sym_hex] = ACTIONS(179),
    [sym__integer] = ACTIONS(183),
    [aux_sym__float_token1] = ACTIONS(185),
    [aux_sym__float_token2] = ACTIONS(187),
    [aux_sym__float_token3] = ACTIONS(185),
    [sym__quoted_identifier] = ACTIONS(189),
    [sym__string_start] = ACTIONS(191),
  },
  [4] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6645),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3788),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(7064),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [5] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6711),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3828),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(6921),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [6] = {
    [sym_keyword_extract] = STATE(8473),
    [sym_keyword_unnest] = STATE(7454),
    [sym_keyword_as] = STATE(6851),
    [sym_keyword_distinct] = STATE(87),
    [sym_keyword_cast] = STATE(8474),
    [sym_keyword_safe_cast] = STATE(8474),
    [sym_keyword_case] = STATE(99),
    [sym_keyword_substring] = STATE(8475),
    [sym_keyword_not] = STATE(689),
    [sym_keyword_exists] = STATE(7469),
    [sym_keyword_all] = STATE(114),
    [sym_keyword_trim] = STATE(8249),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6868),
    [sym_keyword_any] = STATE(7471),
    [sym_keyword_some] = STATE(7471),
    [sym_keyword_current_date] = STATE(2321),
    [sym_keyword_current_time] = STATE(7814),
    [sym_keyword_current_timestamp] = STATE(7813),
    [sym_keyword_null] = STATE(2316),
    [sym_keyword_true] = STATE(2316),
    [sym_keyword_false] = STATE(2316),
    [sym_keyword_decimal] = STATE(7414),
    [sym_keyword_bigdecimal] = STATE(7414),
    [sym_keyword_numeric] = STATE(7414),
    [sym_keyword_bignumeric] = STATE(7414),
    [sym_keyword_json] = STATE(7482),
    [sym_keyword_interval] = STATE(552),
    [sym_keyword_time] = STATE(2244),
    [sym_keyword_date] = STATE(2244),
    [sym_keyword_datetime] = STATE(2244),
    [sym_keyword_timestamp] = STATE(2244),
    [sym_keyword_timestamptz] = STATE(2244),
    [sym_wildcard] = STATE(4379),
    [sym__time_types] = STATE(2244),
    [sym_numeric] = STATE(2316),
    [sym__select_wildcard] = STATE(4109),
    [sym__distinct_on] = STATE(4110),
    [sym_select_field] = STATE(5404),
    [sym_select_expression] = STATE(5552),
    [sym_date] = STATE(2322),
    [sym_parameter] = STATE(2322),
    [sym_case] = STATE(2322),
    [sym_field] = STATE(2322),
    [sym_cast] = STATE(2322),
    [sym_substring] = STATE(2322),
    [sym_quantified_comparison] = STATE(2322),
    [sym_trim] = STATE(2322),
    [sym_invocation] = STATE(2245),
    [sym__extract_invocation] = STATE(2261),
    [sym__array_invocation] = STATE(2263),
    [sym_window_function] = STATE(2322),
    [sym_unnest_operator] = STATE(1554),
    [sym_unnest_clause] = STATE(2322),
    [sym_between] = STATE(2322),
    [sym_interval] = STATE(2316),
    [sym__expression] = STATE(1499),
    [sym_predicate] = STATE(2322),
    [sym_binary_expression] = STATE(2322),
    [sym_field_access] = STATE(2322),
    [sym_element_access] = STATE(2322),
    [sym_subquery] = STATE(2322),
    [sym_list] = STATE(2322),
    [sym_query_parameter] = STATE(2316),
    [sym_literal] = STATE(2322),
    [sym_json] = STATE(2316),
    [sym__number] = STATE(2316),
    [sym__float] = STATE(2328),
    [sym_string] = STATE(2316),
    [sym__type_struct] = STATE(8251),
    [sym__type_array] = STATE(7812),
    [sym_array] = STATE(2316),
    [sym_struct] = STATE(2316),
    [sym_current_date] = STATE(2322),
    [sym_current_time] = STATE(2322),
    [sym_current_timestamp] = STATE(2322),
    [sym__identifier] = STATE(2148),
    [sym__dotted_identifier] = STATE(6954),
    [sym_identifier] = STATE(2329),
    [aux_sym_identifier_repeat1] = STATE(6779),
    [sym__unquoted_identifier] = ACTIONS(193),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_as_token1] = ACTIONS(141),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(195),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(197),
    [aux_sym_keyword_true_token1] = ACTIONS(199),
    [aux_sym_keyword_false_token1] = ACTIONS(201),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(203),
    [aux_sym_keyword_date_token1] = ACTIONS(205),
    [aux_sym_keyword_datetime_token1] = ACTIONS(207),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(209),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(213),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(215),
    [anon_sym_QMARK] = ACTIONS(217),
    [anon_sym_DOLLAR] = ACTIONS(219),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [anon_sym_DASH] = ACTIONS(223),
    [anon_sym_LBRACK] = ACTIONS(225),
    [sym_system_variable] = ACTIONS(227),
    [sym__named_query_parameter] = ACTIONS(229),
    [sym__positional_query_parameter] = ACTIONS(229),
    [sym_hex] = ACTIONS(227),
    [sym__integer] = ACTIONS(231),
    [aux_sym__float_token1] = ACTIONS(233),
    [aux_sym__float_token2] = ACTIONS(235),
    [aux_sym__float_token3] = ACTIONS(233),
    [sym__quoted_identifier] = ACTIONS(237),
    [sym__string_start] = ACTIONS(239),
  },
  [7] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6657),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3887),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(7007),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [8] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6675),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3788),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(7172),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [9] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6690),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3796),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(6895),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [10] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6658),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3791),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(7061),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [11] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6684),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3792),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(6891),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [12] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6710),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3789),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(7109),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [13] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6723),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3783),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(7202),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [14] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6705),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3792),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(6891),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [15] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6626),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3839),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(7129),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [16] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6643),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3788),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(7165),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [17] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6693),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3763),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(6977),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [18] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6679),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3794),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(7031),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [19] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6675),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3903),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(7172),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [20] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6708),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3804),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(7098),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [21] = {
    [sym_keyword_select] = STATE(3),
    [sym_keyword_extract] = STATE(8470),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8471),
    [sym_keyword_safe_cast] = STATE(8471),
    [sym_keyword_case] = STATE(96),
    [sym_keyword_substring] = STATE(8472),
    [sym_keyword_not] = STATE(1087),
    [sym_keyword_exists] = STATE(7234),
    [sym_keyword_with] = STATE(6194),
    [sym_keyword_all] = STATE(7241),
    [sym_keyword_trim] = STATE(8233),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6820),
    [sym_keyword_any] = STATE(7241),
    [sym_keyword_some] = STATE(7241),
    [sym_keyword_current_date] = STATE(5045),
    [sym_keyword_current_time] = STATE(7992),
    [sym_keyword_current_timestamp] = STATE(7991),
    [sym_keyword_null] = STATE(5101),
    [sym_keyword_true] = STATE(5101),
    [sym_keyword_false] = STATE(5101),
    [sym_keyword_decimal] = STATE(7430),
    [sym_keyword_bigdecimal] = STATE(7430),
    [sym_keyword_numeric] = STATE(7430),
    [sym_keyword_bignumeric] = STATE(7430),
    [sym_keyword_json] = STATE(7243),
    [sym_keyword_interval] = STATE(690),
    [sym_keyword_time] = STATE(5164),
    [sym_keyword_date] = STATE(5164),
    [sym_keyword_datetime] = STATE(5164),
    [sym_keyword_timestamp] = STATE(5164),
    [sym_keyword_timestamptz] = STATE(5164),
    [sym__time_types] = STATE(5164),
    [sym_numeric] = STATE(5101),
    [sym_select] = STATE(6440),
    [sym_select_clause] = STATE(6151),
    [sym_select_statement] = STATE(6643),
    [sym_set_operation] = STATE(6440),
    [sym_cte_clause] = STATE(6447),
    [sym_date] = STATE(5049),
    [sym_parameter] = STATE(5049),
    [sym_case] = STATE(5049),
    [sym_field] = STATE(5049),
    [sym_cast] = STATE(5049),
    [sym_substring] = STATE(5049),
    [sym_quantified_comparison] = STATE(5049),
    [sym_trim] = STATE(5049),
    [sym_invocation] = STATE(4993),
    [sym__extract_invocation] = STATE(5035),
    [sym__array_invocation] = STATE(5032),
    [sym_window_function] = STATE(5049),
    [sym_unnest_operator] = STATE(4258),
    [sym_unnest_clause] = STATE(5049),
    [sym_between] = STATE(5049),
    [sym_interval] = STATE(5101),
    [sym__expression] = STATE(3909),
    [sym_predicate] = STATE(5049),
    [sym_binary_expression] = STATE(5049),
    [sym_field_access] = STATE(5049),
    [sym_element_access] = STATE(5049),
    [sym_subquery] = STATE(5049),
    [sym_list] = STATE(5049),
    [sym_query_parameter] = STATE(5101),
    [sym_literal] = STATE(5049),
    [sym_json] = STATE(5101),
    [sym__number] = STATE(5101),
    [sym__float] = STATE(5053),
    [sym_string] = STATE(5101),
    [sym__type_struct] = STATE(8235),
    [sym__type_array] = STATE(7989),
    [sym_array] = STATE(5101),
    [sym_struct] = STATE(5101),
    [sym_current_date] = STATE(5049),
    [sym_current_time] = STATE(5049),
    [sym_current_timestamp] = STATE(5049),
    [sym__aliasable_expression] = STATE(7165),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5054),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_select_token1] = ACTIONS(47),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(79),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(85),
    [aux_sym_keyword_true_token1] = ACTIONS(87),
    [aux_sym_keyword_false_token1] = ACTIONS(89),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(103),
    [aux_sym_keyword_date_token1] = ACTIONS(105),
    [aux_sym_keyword_datetime_token1] = ACTIONS(107),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(109),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(123),
    [sym_system_variable] = ACTIONS(125),
    [sym__named_query_parameter] = ACTIONS(127),
    [sym__positional_query_parameter] = ACTIONS(127),
    [sym_hex] = ACTIONS(125),
    [sym__integer] = ACTIONS(129),
    [aux_sym__float_token1] = ACTIONS(131),
    [aux_sym__float_token2] = ACTIONS(133),
    [aux_sym__float_token3] = ACTIONS(131),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(137),
  },
  [22] = {
    [sym_keyword_extract] = STATE(8171),
    [sym_keyword_unnest] = STATE(7531),
    [sym_keyword_as] = STATE(6844),
    [sym_keyword_distinct] = STATE(84),
    [sym_keyword_cast] = STATE(8138),
    [sym_keyword_safe_cast] = STATE(8138),
    [sym_keyword_case] = STATE(105),
    [sym_keyword_substring] = STATE(8137),
    [sym_keyword_not] = STATE(1373),
    [sym_keyword_exists] = STATE(7540),
    [sym_keyword_all] = STATE(115),
    [sym_keyword_trim] = STATE(8135),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6843),
    [sym_keyword_any] = STATE(7542),
    [sym_keyword_some] = STATE(7542),
    [sym_keyword_current_date] = STATE(2181),
    [sym_keyword_current_time] = STATE(8129),
    [sym_keyword_current_timestamp] = STATE(8126),
    [sym_keyword_null] = STATE(2127),
    [sym_keyword_true] = STATE(2127),
    [sym_keyword_false] = STATE(2127),
    [sym_keyword_decimal] = STATE(7544),
    [sym_keyword_bigdecimal] = STATE(7544),
    [sym_keyword_numeric] = STATE(7544),
    [sym_keyword_bignumeric] = STATE(7544),
    [sym_keyword_json] = STATE(7545),
    [sym_keyword_interval] = STATE(1478),
    [sym_keyword_time] = STATE(2717),
    [sym_keyword_date] = STATE(2717),
    [sym_keyword_datetime] = STATE(2717),
    [sym_keyword_timestamp] = STATE(2717),
    [sym_keyword_timestamptz] = STATE(2717),
    [sym_wildcard] = STATE(4990),
    [sym__time_types] = STATE(2717),
    [sym_numeric] = STATE(2127),
    [sym__select_wildcard] = STATE(4310),
    [sym__distinct_on] = STATE(4304),
    [sym_select_field] = STATE(5989),
    [sym_select_expression] = STATE(5552),
    [sym_date] = STATE(2183),
    [sym_parameter] = STATE(2183),
    [sym_case] = STATE(2183),
    [sym_field] = STATE(2183),
    [sym_cast] = STATE(2183),
    [sym_substring] = STATE(2183),
    [sym_quantified_comparison] = STATE(2183),
    [sym_trim] = STATE(2183),
    [sym_invocation] = STATE(2053),
    [sym__extract_invocation] = STATE(2081),
    [sym__array_invocation] = STATE(2095),
    [sym_window_function] = STATE(2183),
    [sym_unnest_operator] = STATE(1934),
    [sym_unnest_clause] = STATE(2183),
    [sym_between] = STATE(2183),
    [sym_interval] = STATE(2127),
    [sym__expression] = STATE(1560),
    [sym_predicate] = STATE(2183),
    [sym_binary_expression] = STATE(2183),
    [sym_field_access] = STATE(2183),
    [sym_element_access] = STATE(2183),
    [sym_subquery] = STATE(2183),
    [sym_list] = STATE(2183),
    [sym_query_parameter] = STATE(2127),
    [sym_literal] = STATE(2183),
    [sym_json] = STATE(2127),
    [sym__number] = STATE(2127),
    [sym__float] = STATE(1985),
    [sym_string] = STATE(2127),
    [sym__type_struct] = STATE(8120),
    [sym__type_array] = STATE(8119),
    [sym_array] = STATE(2127),
    [sym_struct] = STATE(2127),
    [sym_current_date] = STATE(2183),
    [sym_current_time] = STATE(2183),
    [sym_current_timestamp] = STATE(2183),
    [sym__identifier] = STATE(1887),
    [sym__dotted_identifier] = STATE(7094),
    [sym_identifier] = STATE(2807),
    [aux_sym_identifier_repeat1] = STATE(6787),
    [sym__unquoted_identifier] = ACTIONS(241),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_as_token1] = ACTIONS(141),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(243),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(245),
    [aux_sym_keyword_true_token1] = ACTIONS(247),
    [aux_sym_keyword_false_token1] = ACTIONS(249),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(251),
    [aux_sym_keyword_date_token1] = ACTIONS(253),
    [aux_sym_keyword_datetime_token1] = ACTIONS(255),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(257),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(259),
    [anon_sym_STAR] = ACTIONS(261),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(263),
    [anon_sym_QMARK] = ACTIONS(265),
    [anon_sym_DOLLAR] = ACTIONS(267),
    [anon_sym_TILDE] = ACTIONS(269),
    [anon_sym_PLUS] = ACTIONS(271),
    [anon_sym_DASH] = ACTIONS(271),
    [anon_sym_LBRACK] = ACTIONS(273),
    [sym_system_variable] = ACTIONS(275),
    [sym__named_query_parameter] = ACTIONS(277),
    [sym__positional_query_parameter] = ACTIONS(277),
    [sym_hex] = ACTIONS(275),
    [sym__integer] = ACTIONS(279),
    [aux_sym__float_token1] = ACTIONS(281),
    [aux_sym__float_token2] = ACTIONS(283),
    [aux_sym__float_token3] = ACTIONS(281),
    [sym__quoted_identifier] = ACTIONS(285),
    [sym__string_start] = ACTIONS(287),
  },
  [23] = {
    [sym_keyword_from] = STATE(545),
    [sym_keyword_extract] = STATE(8458),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8459),
    [sym_keyword_safe_cast] = STATE(8459),
    [sym_keyword_case] = STATE(93),
    [sym_keyword_substring] = STATE(8460),
    [sym_keyword_not] = STATE(1225),
    [sym_keyword_exists] = STATE(7529),
    [sym_keyword_all] = STATE(7513),
    [sym_keyword_trim] = STATE(8156),
    [sym_keyword_leading] = STATE(135),
    [sym_keyword_trailing] = STATE(135),
    [sym_keyword_both] = STATE(135),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6838),
    [sym_keyword_any] = STATE(7513),
    [sym_keyword_some] = STATE(7513),
    [sym_keyword_current_date] = STATE(2616),
    [sym_keyword_current_time] = STATE(8355),
    [sym_keyword_current_timestamp] = STATE(8360),
    [sym_keyword_null] = STATE(2665),
    [sym_keyword_true] = STATE(2665),
    [sym_keyword_false] = STATE(2665),
    [sym_keyword_decimal] = STATE(7536),
    [sym_keyword_bigdecimal] = STATE(7536),
    [sym_keyword_numeric] = STATE(7536),
    [sym_keyword_bignumeric] = STATE(7536),
    [sym_keyword_json] = STATE(7511),
    [sym_keyword_interval] = STATE(1278),
    [sym_keyword_time] = STATE(5175),
    [sym_keyword_date] = STATE(5175),
    [sym_keyword_datetime] = STATE(5175),
    [sym_keyword_timestamp] = STATE(5175),
    [sym_keyword_timestamptz] = STATE(5175),
    [sym__time_types] = STATE(5175),
    [sym_numeric] = STATE(2665),
    [sym_date] = STATE(2607),
    [sym_parameter] = STATE(2607),
    [sym_case] = STATE(2607),
    [sym_field] = STATE(2607),
    [sym_cast] = STATE(2607),
    [sym_substring] = STATE(2607),
    [sym_quantified_comparison] = STATE(2607),
    [sym_trim] = STATE(2607),
    [sym_invocation] = STATE(5320),
    [sym__extract_invocation] = STATE(2525),
    [sym__array_invocation] = STATE(2526),
    [sym_window_function] = STATE(2607),
    [sym_unnest_operator] = STATE(3677),
    [sym_unnest_clause] = STATE(2607),
    [sym_between] = STATE(2607),
    [sym_interval] = STATE(2665),
    [sym__expression] = STATE(5403),
    [sym_predicate] = STATE(2607),
    [sym_binary_expression] = STATE(2607),
    [sym_field_access] = STATE(2607),
    [sym_element_access] = STATE(2607),
    [sym_subquery] = STATE(2607),
    [sym_list] = STATE(2607),
    [sym_query_parameter] = STATE(2665),
    [sym_literal] = STATE(2607),
    [sym_json] = STATE(2665),
    [sym__number] = STATE(2665),
    [sym__float] = STATE(2581),
    [sym_string] = STATE(2665),
    [sym__type_struct] = STATE(8158),
    [sym__type_array] = STATE(8363),
    [sym_array] = STATE(2665),
    [sym_struct] = STATE(2665),
    [sym_current_date] = STATE(2607),
    [sym_current_time] = STATE(2607),
    [sym_current_timestamp] = STATE(2607),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5412),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_from_token1] = ACTIONS(289),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_leading_token1] = ACTIONS(291),
    [aux_sym_keyword_trailing_token1] = ACTIONS(293),
    [aux_sym_keyword_both_token1] = ACTIONS(295),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(297),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(299),
    [aux_sym_keyword_true_token1] = ACTIONS(301),
    [aux_sym_keyword_false_token1] = ACTIONS(303),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(305),
    [aux_sym_keyword_date_token1] = ACTIONS(307),
    [aux_sym_keyword_datetime_token1] = ACTIONS(309),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(311),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(313),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(315),
    [anon_sym_QMARK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [sym_system_variable] = ACTIONS(327),
    [sym__named_query_parameter] = ACTIONS(329),
    [sym__positional_query_parameter] = ACTIONS(329),
    [sym_hex] = ACTIONS(327),
    [sym__integer] = ACTIONS(331),
    [aux_sym__float_token1] = ACTIONS(333),
    [aux_sym__float_token2] = ACTIONS(335),
    [aux_sym__float_token3] = ACTIONS(333),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(337),
  },
  [24] = {
    [sym_keyword_from] = STATE(498),
    [sym_keyword_extract] = STATE(8458),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8459),
    [sym_keyword_safe_cast] = STATE(8459),
    [sym_keyword_case] = STATE(93),
    [sym_keyword_substring] = STATE(8460),
    [sym_keyword_not] = STATE(1225),
    [sym_keyword_exists] = STATE(7529),
    [sym_keyword_all] = STATE(7513),
    [sym_keyword_trim] = STATE(8156),
    [sym_keyword_leading] = STATE(116),
    [sym_keyword_trailing] = STATE(116),
    [sym_keyword_both] = STATE(116),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6838),
    [sym_keyword_any] = STATE(7513),
    [sym_keyword_some] = STATE(7513),
    [sym_keyword_current_date] = STATE(2616),
    [sym_keyword_current_time] = STATE(8355),
    [sym_keyword_current_timestamp] = STATE(8360),
    [sym_keyword_null] = STATE(2665),
    [sym_keyword_true] = STATE(2665),
    [sym_keyword_false] = STATE(2665),
    [sym_keyword_decimal] = STATE(7536),
    [sym_keyword_bigdecimal] = STATE(7536),
    [sym_keyword_numeric] = STATE(7536),
    [sym_keyword_bignumeric] = STATE(7536),
    [sym_keyword_json] = STATE(7511),
    [sym_keyword_interval] = STATE(1278),
    [sym_keyword_time] = STATE(5175),
    [sym_keyword_date] = STATE(5175),
    [sym_keyword_datetime] = STATE(5175),
    [sym_keyword_timestamp] = STATE(5175),
    [sym_keyword_timestamptz] = STATE(5175),
    [sym__time_types] = STATE(5175),
    [sym_numeric] = STATE(2665),
    [sym_date] = STATE(2607),
    [sym_parameter] = STATE(2607),
    [sym_case] = STATE(2607),
    [sym_field] = STATE(2607),
    [sym_cast] = STATE(2607),
    [sym_substring] = STATE(2607),
    [sym_quantified_comparison] = STATE(2607),
    [sym_trim] = STATE(2607),
    [sym_invocation] = STATE(5320),
    [sym__extract_invocation] = STATE(2525),
    [sym__array_invocation] = STATE(2526),
    [sym_window_function] = STATE(2607),
    [sym_unnest_operator] = STATE(3677),
    [sym_unnest_clause] = STATE(2607),
    [sym_between] = STATE(2607),
    [sym_interval] = STATE(2665),
    [sym__expression] = STATE(5562),
    [sym_predicate] = STATE(2607),
    [sym_binary_expression] = STATE(2607),
    [sym_field_access] = STATE(2607),
    [sym_element_access] = STATE(2607),
    [sym_subquery] = STATE(2607),
    [sym_list] = STATE(2607),
    [sym_query_parameter] = STATE(2665),
    [sym_literal] = STATE(2607),
    [sym_json] = STATE(2665),
    [sym__number] = STATE(2665),
    [sym__float] = STATE(2581),
    [sym_string] = STATE(2665),
    [sym__type_struct] = STATE(8158),
    [sym__type_array] = STATE(8363),
    [sym_array] = STATE(2665),
    [sym_struct] = STATE(2665),
    [sym_current_date] = STATE(2607),
    [sym_current_time] = STATE(2607),
    [sym_current_timestamp] = STATE(2607),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5412),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_from_token1] = ACTIONS(289),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_leading_token1] = ACTIONS(291),
    [aux_sym_keyword_trailing_token1] = ACTIONS(293),
    [aux_sym_keyword_both_token1] = ACTIONS(295),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(297),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(299),
    [aux_sym_keyword_true_token1] = ACTIONS(301),
    [aux_sym_keyword_false_token1] = ACTIONS(303),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(305),
    [aux_sym_keyword_date_token1] = ACTIONS(307),
    [aux_sym_keyword_datetime_token1] = ACTIONS(309),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(311),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(313),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(315),
    [anon_sym_QMARK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [sym_system_variable] = ACTIONS(327),
    [sym__named_query_parameter] = ACTIONS(329),
    [sym__positional_query_parameter] = ACTIONS(329),
    [sym_hex] = ACTIONS(327),
    [sym__integer] = ACTIONS(331),
    [aux_sym__float_token1] = ACTIONS(333),
    [aux_sym__float_token2] = ACTIONS(335),
    [aux_sym__float_token3] = ACTIONS(333),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(337),
  },
  [25] = {
    [sym_keyword_from] = STATE(299),
    [sym_keyword_extract] = STATE(8458),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8459),
    [sym_keyword_safe_cast] = STATE(8459),
    [sym_keyword_case] = STATE(93),
    [sym_keyword_substring] = STATE(8460),
    [sym_keyword_not] = STATE(1225),
    [sym_keyword_exists] = STATE(7529),
    [sym_keyword_all] = STATE(7513),
    [sym_keyword_trim] = STATE(8156),
    [sym_keyword_leading] = STATE(119),
    [sym_keyword_trailing] = STATE(119),
    [sym_keyword_both] = STATE(119),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6838),
    [sym_keyword_any] = STATE(7513),
    [sym_keyword_some] = STATE(7513),
    [sym_keyword_current_date] = STATE(2616),
    [sym_keyword_current_time] = STATE(8355),
    [sym_keyword_current_timestamp] = STATE(8360),
    [sym_keyword_null] = STATE(2665),
    [sym_keyword_true] = STATE(2665),
    [sym_keyword_false] = STATE(2665),
    [sym_keyword_decimal] = STATE(7536),
    [sym_keyword_bigdecimal] = STATE(7536),
    [sym_keyword_numeric] = STATE(7536),
    [sym_keyword_bignumeric] = STATE(7536),
    [sym_keyword_json] = STATE(7511),
    [sym_keyword_interval] = STATE(1278),
    [sym_keyword_time] = STATE(5175),
    [sym_keyword_date] = STATE(5175),
    [sym_keyword_datetime] = STATE(5175),
    [sym_keyword_timestamp] = STATE(5175),
    [sym_keyword_timestamptz] = STATE(5175),
    [sym__time_types] = STATE(5175),
    [sym_numeric] = STATE(2665),
    [sym_date] = STATE(2607),
    [sym_parameter] = STATE(2607),
    [sym_case] = STATE(2607),
    [sym_field] = STATE(2607),
    [sym_cast] = STATE(2607),
    [sym_substring] = STATE(2607),
    [sym_quantified_comparison] = STATE(2607),
    [sym_trim] = STATE(2607),
    [sym_invocation] = STATE(5320),
    [sym__extract_invocation] = STATE(2525),
    [sym__array_invocation] = STATE(2526),
    [sym_window_function] = STATE(2607),
    [sym_unnest_operator] = STATE(3677),
    [sym_unnest_clause] = STATE(2607),
    [sym_between] = STATE(2607),
    [sym_interval] = STATE(2665),
    [sym__expression] = STATE(5426),
    [sym_predicate] = STATE(2607),
    [sym_binary_expression] = STATE(2607),
    [sym_field_access] = STATE(2607),
    [sym_element_access] = STATE(2607),
    [sym_subquery] = STATE(2607),
    [sym_list] = STATE(2607),
    [sym_query_parameter] = STATE(2665),
    [sym_literal] = STATE(2607),
    [sym_json] = STATE(2665),
    [sym__number] = STATE(2665),
    [sym__float] = STATE(2581),
    [sym_string] = STATE(2665),
    [sym__type_struct] = STATE(8158),
    [sym__type_array] = STATE(8363),
    [sym_array] = STATE(2665),
    [sym_struct] = STATE(2665),
    [sym_current_date] = STATE(2607),
    [sym_current_time] = STATE(2607),
    [sym_current_timestamp] = STATE(2607),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5412),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_from_token1] = ACTIONS(289),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_leading_token1] = ACTIONS(291),
    [aux_sym_keyword_trailing_token1] = ACTIONS(293),
    [aux_sym_keyword_both_token1] = ACTIONS(295),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(297),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(299),
    [aux_sym_keyword_true_token1] = ACTIONS(301),
    [aux_sym_keyword_false_token1] = ACTIONS(303),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(305),
    [aux_sym_keyword_date_token1] = ACTIONS(307),
    [aux_sym_keyword_datetime_token1] = ACTIONS(309),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(311),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(313),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(315),
    [anon_sym_QMARK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [sym_system_variable] = ACTIONS(327),
    [sym__named_query_parameter] = ACTIONS(329),
    [sym__positional_query_parameter] = ACTIONS(329),
    [sym_hex] = ACTIONS(327),
    [sym__integer] = ACTIONS(331),
    [aux_sym__float_token1] = ACTIONS(333),
    [aux_sym__float_token2] = ACTIONS(335),
    [aux_sym__float_token3] = ACTIONS(333),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(337),
  },
  [26] = {
    [sym_keyword_extract] = STATE(8171),
    [sym_keyword_unnest] = STATE(7531),
    [sym_keyword_distinct] = STATE(84),
    [sym_keyword_cast] = STATE(8138),
    [sym_keyword_safe_cast] = STATE(8138),
    [sym_keyword_case] = STATE(105),
    [sym_keyword_substring] = STATE(8137),
    [sym_keyword_not] = STATE(1373),
    [sym_keyword_exists] = STATE(7540),
    [sym_keyword_all] = STATE(115),
    [sym_keyword_trim] = STATE(8135),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6843),
    [sym_keyword_any] = STATE(7542),
    [sym_keyword_some] = STATE(7542),
    [sym_keyword_current_date] = STATE(2181),
    [sym_keyword_current_time] = STATE(8129),
    [sym_keyword_current_timestamp] = STATE(8126),
    [sym_keyword_null] = STATE(2127),
    [sym_keyword_true] = STATE(2127),
    [sym_keyword_false] = STATE(2127),
    [sym_keyword_decimal] = STATE(7544),
    [sym_keyword_bigdecimal] = STATE(7544),
    [sym_keyword_numeric] = STATE(7544),
    [sym_keyword_bignumeric] = STATE(7544),
    [sym_keyword_json] = STATE(7545),
    [sym_keyword_interval] = STATE(1478),
    [sym_keyword_time] = STATE(2717),
    [sym_keyword_date] = STATE(2717),
    [sym_keyword_datetime] = STATE(2717),
    [sym_keyword_timestamp] = STATE(2717),
    [sym_keyword_timestamptz] = STATE(2717),
    [sym_wildcard] = STATE(4990),
    [sym__time_types] = STATE(2717),
    [sym_numeric] = STATE(2127),
    [sym__select_wildcard] = STATE(4310),
    [sym__distinct_on] = STATE(4304),
    [sym_select_field] = STATE(5989),
    [sym_select_expression] = STATE(5482),
    [sym_date] = STATE(2183),
    [sym_parameter] = STATE(2183),
    [sym_case] = STATE(2183),
    [sym_field] = STATE(2183),
    [sym_cast] = STATE(2183),
    [sym_substring] = STATE(2183),
    [sym_quantified_comparison] = STATE(2183),
    [sym_trim] = STATE(2183),
    [sym_invocation] = STATE(2053),
    [sym__extract_invocation] = STATE(2081),
    [sym__array_invocation] = STATE(2095),
    [sym_window_function] = STATE(2183),
    [sym_unnest_operator] = STATE(1934),
    [sym_unnest_clause] = STATE(2183),
    [sym_between] = STATE(2183),
    [sym_interval] = STATE(2127),
    [sym__expression] = STATE(1560),
    [sym_predicate] = STATE(2183),
    [sym_binary_expression] = STATE(2183),
    [sym_field_access] = STATE(2183),
    [sym_element_access] = STATE(2183),
    [sym_subquery] = STATE(2183),
    [sym_list] = STATE(2183),
    [sym_query_parameter] = STATE(2127),
    [sym_literal] = STATE(2183),
    [sym_json] = STATE(2127),
    [sym__number] = STATE(2127),
    [sym__float] = STATE(1985),
    [sym_string] = STATE(2127),
    [sym__type_struct] = STATE(8120),
    [sym__type_array] = STATE(8119),
    [sym_array] = STATE(2127),
    [sym_struct] = STATE(2127),
    [sym_current_date] = STATE(2183),
    [sym_current_time] = STATE(2183),
    [sym_current_timestamp] = STATE(2183),
    [sym__identifier] = STATE(1887),
    [sym__dotted_identifier] = STATE(7094),
    [sym_identifier] = STATE(2807),
    [aux_sym_identifier_repeat1] = STATE(6787),
    [sym__unquoted_identifier] = ACTIONS(241),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(243),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(245),
    [aux_sym_keyword_true_token1] = ACTIONS(247),
    [aux_sym_keyword_false_token1] = ACTIONS(249),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(251),
    [aux_sym_keyword_date_token1] = ACTIONS(253),
    [aux_sym_keyword_datetime_token1] = ACTIONS(255),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(257),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(259),
    [anon_sym_STAR] = ACTIONS(261),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(263),
    [anon_sym_QMARK] = ACTIONS(265),
    [anon_sym_DOLLAR] = ACTIONS(267),
    [anon_sym_TILDE] = ACTIONS(269),
    [anon_sym_PLUS] = ACTIONS(271),
    [anon_sym_DASH] = ACTIONS(271),
    [anon_sym_LBRACK] = ACTIONS(273),
    [sym_system_variable] = ACTIONS(275),
    [sym__named_query_parameter] = ACTIONS(277),
    [sym__positional_query_parameter] = ACTIONS(277),
    [sym_hex] = ACTIONS(275),
    [sym__integer] = ACTIONS(279),
    [aux_sym__float_token1] = ACTIONS(281),
    [aux_sym__float_token2] = ACTIONS(283),
    [aux_sym__float_token3] = ACTIONS(281),
    [sym__quoted_identifier] = ACTIONS(285),
    [sym__string_start] = ACTIONS(287),
  },
  [27] = {
    [sym_keyword_from] = STATE(252),
    [sym_keyword_extract] = STATE(8458),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8459),
    [sym_keyword_safe_cast] = STATE(8459),
    [sym_keyword_case] = STATE(93),
    [sym_keyword_substring] = STATE(8460),
    [sym_keyword_not] = STATE(1225),
    [sym_keyword_exists] = STATE(7529),
    [sym_keyword_all] = STATE(7513),
    [sym_keyword_trim] = STATE(8156),
    [sym_keyword_leading] = STATE(129),
    [sym_keyword_trailing] = STATE(129),
    [sym_keyword_both] = STATE(129),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6838),
    [sym_keyword_any] = STATE(7513),
    [sym_keyword_some] = STATE(7513),
    [sym_keyword_current_date] = STATE(2616),
    [sym_keyword_current_time] = STATE(8355),
    [sym_keyword_current_timestamp] = STATE(8360),
    [sym_keyword_null] = STATE(2665),
    [sym_keyword_true] = STATE(2665),
    [sym_keyword_false] = STATE(2665),
    [sym_keyword_decimal] = STATE(7536),
    [sym_keyword_bigdecimal] = STATE(7536),
    [sym_keyword_numeric] = STATE(7536),
    [sym_keyword_bignumeric] = STATE(7536),
    [sym_keyword_json] = STATE(7511),
    [sym_keyword_interval] = STATE(1278),
    [sym_keyword_time] = STATE(5175),
    [sym_keyword_date] = STATE(5175),
    [sym_keyword_datetime] = STATE(5175),
    [sym_keyword_timestamp] = STATE(5175),
    [sym_keyword_timestamptz] = STATE(5175),
    [sym__time_types] = STATE(5175),
    [sym_numeric] = STATE(2665),
    [sym_date] = STATE(2607),
    [sym_parameter] = STATE(2607),
    [sym_case] = STATE(2607),
    [sym_field] = STATE(2607),
    [sym_cast] = STATE(2607),
    [sym_substring] = STATE(2607),
    [sym_quantified_comparison] = STATE(2607),
    [sym_trim] = STATE(2607),
    [sym_invocation] = STATE(5320),
    [sym__extract_invocation] = STATE(2525),
    [sym__array_invocation] = STATE(2526),
    [sym_window_function] = STATE(2607),
    [sym_unnest_operator] = STATE(3677),
    [sym_unnest_clause] = STATE(2607),
    [sym_between] = STATE(2607),
    [sym_interval] = STATE(2665),
    [sym__expression] = STATE(5578),
    [sym_predicate] = STATE(2607),
    [sym_binary_expression] = STATE(2607),
    [sym_field_access] = STATE(2607),
    [sym_element_access] = STATE(2607),
    [sym_subquery] = STATE(2607),
    [sym_list] = STATE(2607),
    [sym_query_parameter] = STATE(2665),
    [sym_literal] = STATE(2607),
    [sym_json] = STATE(2665),
    [sym__number] = STATE(2665),
    [sym__float] = STATE(2581),
    [sym_string] = STATE(2665),
    [sym__type_struct] = STATE(8158),
    [sym__type_array] = STATE(8363),
    [sym_array] = STATE(2665),
    [sym_struct] = STATE(2665),
    [sym_current_date] = STATE(2607),
    [sym_current_time] = STATE(2607),
    [sym_current_timestamp] = STATE(2607),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5412),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_from_token1] = ACTIONS(289),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_leading_token1] = ACTIONS(291),
    [aux_sym_keyword_trailing_token1] = ACTIONS(293),
    [aux_sym_keyword_both_token1] = ACTIONS(295),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(297),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(299),
    [aux_sym_keyword_true_token1] = ACTIONS(301),
    [aux_sym_keyword_false_token1] = ACTIONS(303),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(305),
    [aux_sym_keyword_date_token1] = ACTIONS(307),
    [aux_sym_keyword_datetime_token1] = ACTIONS(309),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(311),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(313),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(315),
    [anon_sym_QMARK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [sym_system_variable] = ACTIONS(327),
    [sym__named_query_parameter] = ACTIONS(329),
    [sym__positional_query_parameter] = ACTIONS(329),
    [sym_hex] = ACTIONS(327),
    [sym__integer] = ACTIONS(331),
    [aux_sym__float_token1] = ACTIONS(333),
    [aux_sym__float_token2] = ACTIONS(335),
    [aux_sym__float_token3] = ACTIONS(333),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(337),
  },
  [28] = {
    [sym_keyword_extract] = STATE(8465),
    [sym_keyword_unnest] = STATE(7233),
    [sym_keyword_distinct] = STATE(63),
    [sym_keyword_cast] = STATE(8466),
    [sym_keyword_safe_cast] = STATE(8466),
    [sym_keyword_case] = STATE(108),
    [sym_keyword_substring] = STATE(8467),
    [sym_keyword_not] = STATE(1238),
    [sym_keyword_exists] = STATE(7311),
    [sym_keyword_all] = STATE(113),
    [sym_keyword_trim] = STATE(8201),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6859),
    [sym_keyword_any] = STATE(7307),
    [sym_keyword_some] = STATE(7307),
    [sym_keyword_current_date] = STATE(4467),
    [sym_keyword_current_time] = STATE(8248),
    [sym_keyword_current_timestamp] = STATE(8247),
    [sym_keyword_null] = STATE(4380),
    [sym_keyword_true] = STATE(4380),
    [sym_keyword_false] = STATE(4380),
    [sym_keyword_decimal] = STATE(7498),
    [sym_keyword_bigdecimal] = STATE(7498),
    [sym_keyword_numeric] = STATE(7498),
    [sym_keyword_bignumeric] = STATE(7498),
    [sym_keyword_json] = STATE(7305),
    [sym_keyword_interval] = STATE(901),
    [sym_keyword_time] = STATE(4325),
    [sym_keyword_date] = STATE(4325),
    [sym_keyword_datetime] = STATE(4325),
    [sym_keyword_timestamp] = STATE(4325),
    [sym_keyword_timestamptz] = STATE(4325),
    [sym_wildcard] = STATE(6141),
    [sym__time_types] = STATE(4325),
    [sym_numeric] = STATE(4380),
    [sym__select_wildcard] = STATE(5948),
    [sym__distinct_on] = STATE(5949),
    [sym_select_field] = STATE(6332),
    [sym_select_expression] = STATE(5482),
    [sym_date] = STATE(4459),
    [sym_parameter] = STATE(4459),
    [sym_case] = STATE(4459),
    [sym_field] = STATE(4459),
    [sym_cast] = STATE(4459),
    [sym_substring] = STATE(4459),
    [sym_quantified_comparison] = STATE(4459),
    [sym_trim] = STATE(4459),
    [sym_invocation] = STATE(4330),
    [sym__extract_invocation] = STATE(4298),
    [sym__array_invocation] = STATE(4332),
    [sym_window_function] = STATE(4459),
    [sym_unnest_operator] = STATE(3165),
    [sym_unnest_clause] = STATE(4459),
    [sym_between] = STATE(4459),
    [sym_interval] = STATE(4380),
    [sym__expression] = STATE(2737),
    [sym_predicate] = STATE(4459),
    [sym_binary_expression] = STATE(4459),
    [sym_field_access] = STATE(4459),
    [sym_element_access] = STATE(4459),
    [sym_subquery] = STATE(4459),
    [sym_list] = STATE(4459),
    [sym_query_parameter] = STATE(4380),
    [sym_literal] = STATE(4459),
    [sym_json] = STATE(4380),
    [sym__number] = STATE(4380),
    [sym__float] = STATE(4455),
    [sym_string] = STATE(4380),
    [sym__type_struct] = STATE(8203),
    [sym__type_array] = STATE(8246),
    [sym_array] = STATE(4380),
    [sym_struct] = STATE(4380),
    [sym_current_date] = STATE(4459),
    [sym_current_time] = STATE(4459),
    [sym_current_timestamp] = STATE(4459),
    [sym__identifier] = STATE(4338),
    [sym__dotted_identifier] = STATE(7126),
    [sym_identifier] = STATE(4452),
    [aux_sym_identifier_repeat1] = STATE(6788),
    [sym__unquoted_identifier] = ACTIONS(139),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(147),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(149),
    [aux_sym_keyword_true_token1] = ACTIONS(151),
    [aux_sym_keyword_false_token1] = ACTIONS(153),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(155),
    [aux_sym_keyword_date_token1] = ACTIONS(157),
    [aux_sym_keyword_datetime_token1] = ACTIONS(159),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(161),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(167),
    [anon_sym_QMARK] = ACTIONS(169),
    [anon_sym_DOLLAR] = ACTIONS(171),
    [anon_sym_TILDE] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(175),
    [anon_sym_DASH] = ACTIONS(175),
    [anon_sym_LBRACK] = ACTIONS(177),
    [sym_system_variable] = ACTIONS(179),
    [sym__named_query_parameter] = ACTIONS(181),
    [sym__positional_query_parameter] = ACTIONS(181),
    [sym_hex] = ACTIONS(179),
    [sym__integer] = ACTIONS(183),
    [aux_sym__float_token1] = ACTIONS(185),
    [aux_sym__float_token2] = ACTIONS(187),
    [aux_sym__float_token3] = ACTIONS(185),
    [sym__quoted_identifier] = ACTIONS(189),
    [sym__string_start] = ACTIONS(191),
  },
  [29] = {
    [sym_keyword_from] = STATE(327),
    [sym_keyword_extract] = STATE(8458),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8459),
    [sym_keyword_safe_cast] = STATE(8459),
    [sym_keyword_case] = STATE(93),
    [sym_keyword_substring] = STATE(8460),
    [sym_keyword_not] = STATE(1225),
    [sym_keyword_exists] = STATE(7529),
    [sym_keyword_all] = STATE(7513),
    [sym_keyword_trim] = STATE(8156),
    [sym_keyword_leading] = STATE(120),
    [sym_keyword_trailing] = STATE(120),
    [sym_keyword_both] = STATE(120),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6838),
    [sym_keyword_any] = STATE(7513),
    [sym_keyword_some] = STATE(7513),
    [sym_keyword_current_date] = STATE(2616),
    [sym_keyword_current_time] = STATE(8355),
    [sym_keyword_current_timestamp] = STATE(8360),
    [sym_keyword_null] = STATE(2665),
    [sym_keyword_true] = STATE(2665),
    [sym_keyword_false] = STATE(2665),
    [sym_keyword_decimal] = STATE(7536),
    [sym_keyword_bigdecimal] = STATE(7536),
    [sym_keyword_numeric] = STATE(7536),
    [sym_keyword_bignumeric] = STATE(7536),
    [sym_keyword_json] = STATE(7511),
    [sym_keyword_interval] = STATE(1278),
    [sym_keyword_time] = STATE(5175),
    [sym_keyword_date] = STATE(5175),
    [sym_keyword_datetime] = STATE(5175),
    [sym_keyword_timestamp] = STATE(5175),
    [sym_keyword_timestamptz] = STATE(5175),
    [sym__time_types] = STATE(5175),
    [sym_numeric] = STATE(2665),
    [sym_date] = STATE(2607),
    [sym_parameter] = STATE(2607),
    [sym_case] = STATE(2607),
    [sym_field] = STATE(2607),
    [sym_cast] = STATE(2607),
    [sym_substring] = STATE(2607),
    [sym_quantified_comparison] = STATE(2607),
    [sym_trim] = STATE(2607),
    [sym_invocation] = STATE(5320),
    [sym__extract_invocation] = STATE(2525),
    [sym__array_invocation] = STATE(2526),
    [sym_window_function] = STATE(2607),
    [sym_unnest_operator] = STATE(3677),
    [sym_unnest_clause] = STATE(2607),
    [sym_between] = STATE(2607),
    [sym_interval] = STATE(2665),
    [sym__expression] = STATE(5466),
    [sym_predicate] = STATE(2607),
    [sym_binary_expression] = STATE(2607),
    [sym_field_access] = STATE(2607),
    [sym_element_access] = STATE(2607),
    [sym_subquery] = STATE(2607),
    [sym_list] = STATE(2607),
    [sym_query_parameter] = STATE(2665),
    [sym_literal] = STATE(2607),
    [sym_json] = STATE(2665),
    [sym__number] = STATE(2665),
    [sym__float] = STATE(2581),
    [sym_string] = STATE(2665),
    [sym__type_struct] = STATE(8158),
    [sym__type_array] = STATE(8363),
    [sym_array] = STATE(2665),
    [sym_struct] = STATE(2665),
    [sym_current_date] = STATE(2607),
    [sym_current_time] = STATE(2607),
    [sym_current_timestamp] = STATE(2607),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5412),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_from_token1] = ACTIONS(289),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_leading_token1] = ACTIONS(291),
    [aux_sym_keyword_trailing_token1] = ACTIONS(293),
    [aux_sym_keyword_both_token1] = ACTIONS(295),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(297),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(299),
    [aux_sym_keyword_true_token1] = ACTIONS(301),
    [aux_sym_keyword_false_token1] = ACTIONS(303),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(305),
    [aux_sym_keyword_date_token1] = ACTIONS(307),
    [aux_sym_keyword_datetime_token1] = ACTIONS(309),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(311),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(313),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(315),
    [anon_sym_QMARK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [sym_system_variable] = ACTIONS(327),
    [sym__named_query_parameter] = ACTIONS(329),
    [sym__positional_query_parameter] = ACTIONS(329),
    [sym_hex] = ACTIONS(327),
    [sym__integer] = ACTIONS(331),
    [aux_sym__float_token1] = ACTIONS(333),
    [aux_sym__float_token2] = ACTIONS(335),
    [aux_sym__float_token3] = ACTIONS(333),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(337),
  },
  [30] = {
    [sym_keyword_extract] = STATE(8473),
    [sym_keyword_unnest] = STATE(7454),
    [sym_keyword_distinct] = STATE(87),
    [sym_keyword_cast] = STATE(8474),
    [sym_keyword_safe_cast] = STATE(8474),
    [sym_keyword_case] = STATE(99),
    [sym_keyword_substring] = STATE(8475),
    [sym_keyword_not] = STATE(689),
    [sym_keyword_exists] = STATE(7469),
    [sym_keyword_all] = STATE(114),
    [sym_keyword_trim] = STATE(8249),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6868),
    [sym_keyword_any] = STATE(7471),
    [sym_keyword_some] = STATE(7471),
    [sym_keyword_current_date] = STATE(2321),
    [sym_keyword_current_time] = STATE(7814),
    [sym_keyword_current_timestamp] = STATE(7813),
    [sym_keyword_null] = STATE(2316),
    [sym_keyword_true] = STATE(2316),
    [sym_keyword_false] = STATE(2316),
    [sym_keyword_decimal] = STATE(7414),
    [sym_keyword_bigdecimal] = STATE(7414),
    [sym_keyword_numeric] = STATE(7414),
    [sym_keyword_bignumeric] = STATE(7414),
    [sym_keyword_json] = STATE(7482),
    [sym_keyword_interval] = STATE(552),
    [sym_keyword_time] = STATE(2244),
    [sym_keyword_date] = STATE(2244),
    [sym_keyword_datetime] = STATE(2244),
    [sym_keyword_timestamp] = STATE(2244),
    [sym_keyword_timestamptz] = STATE(2244),
    [sym_wildcard] = STATE(4379),
    [sym__time_types] = STATE(2244),
    [sym_numeric] = STATE(2316),
    [sym__select_wildcard] = STATE(4109),
    [sym__distinct_on] = STATE(4110),
    [sym_select_field] = STATE(5404),
    [sym_select_expression] = STATE(5482),
    [sym_date] = STATE(2322),
    [sym_parameter] = STATE(2322),
    [sym_case] = STATE(2322),
    [sym_field] = STATE(2322),
    [sym_cast] = STATE(2322),
    [sym_substring] = STATE(2322),
    [sym_quantified_comparison] = STATE(2322),
    [sym_trim] = STATE(2322),
    [sym_invocation] = STATE(2245),
    [sym__extract_invocation] = STATE(2261),
    [sym__array_invocation] = STATE(2263),
    [sym_window_function] = STATE(2322),
    [sym_unnest_operator] = STATE(1554),
    [sym_unnest_clause] = STATE(2322),
    [sym_between] = STATE(2322),
    [sym_interval] = STATE(2316),
    [sym__expression] = STATE(1499),
    [sym_predicate] = STATE(2322),
    [sym_binary_expression] = STATE(2322),
    [sym_field_access] = STATE(2322),
    [sym_element_access] = STATE(2322),
    [sym_subquery] = STATE(2322),
    [sym_list] = STATE(2322),
    [sym_query_parameter] = STATE(2316),
    [sym_literal] = STATE(2322),
    [sym_json] = STATE(2316),
    [sym__number] = STATE(2316),
    [sym__float] = STATE(2328),
    [sym_string] = STATE(2316),
    [sym__type_struct] = STATE(8251),
    [sym__type_array] = STATE(7812),
    [sym_array] = STATE(2316),
    [sym_struct] = STATE(2316),
    [sym_current_date] = STATE(2322),
    [sym_current_time] = STATE(2322),
    [sym_current_timestamp] = STATE(2322),
    [sym__identifier] = STATE(2148),
    [sym__dotted_identifier] = STATE(6954),
    [sym_identifier] = STATE(2329),
    [aux_sym_identifier_repeat1] = STATE(6779),
    [sym__unquoted_identifier] = ACTIONS(193),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(195),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(197),
    [aux_sym_keyword_true_token1] = ACTIONS(199),
    [aux_sym_keyword_false_token1] = ACTIONS(201),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(203),
    [aux_sym_keyword_date_token1] = ACTIONS(205),
    [aux_sym_keyword_datetime_token1] = ACTIONS(207),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(209),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(213),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(215),
    [anon_sym_QMARK] = ACTIONS(217),
    [anon_sym_DOLLAR] = ACTIONS(219),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [anon_sym_DASH] = ACTIONS(223),
    [anon_sym_LBRACK] = ACTIONS(225),
    [sym_system_variable] = ACTIONS(227),
    [sym__named_query_parameter] = ACTIONS(229),
    [sym__positional_query_parameter] = ACTIONS(229),
    [sym_hex] = ACTIONS(227),
    [sym__integer] = ACTIONS(231),
    [aux_sym__float_token1] = ACTIONS(233),
    [aux_sym__float_token2] = ACTIONS(235),
    [aux_sym__float_token3] = ACTIONS(233),
    [sym__quoted_identifier] = ACTIONS(237),
    [sym__string_start] = ACTIONS(239),
  },
  [31] = {
    [sym_keyword_from] = STATE(1231),
    [sym_keyword_extract] = STATE(8458),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8459),
    [sym_keyword_safe_cast] = STATE(8459),
    [sym_keyword_case] = STATE(93),
    [sym_keyword_substring] = STATE(8460),
    [sym_keyword_not] = STATE(1225),
    [sym_keyword_exists] = STATE(7529),
    [sym_keyword_all] = STATE(7513),
    [sym_keyword_trim] = STATE(8156),
    [sym_keyword_leading] = STATE(127),
    [sym_keyword_trailing] = STATE(127),
    [sym_keyword_both] = STATE(127),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6838),
    [sym_keyword_any] = STATE(7513),
    [sym_keyword_some] = STATE(7513),
    [sym_keyword_current_date] = STATE(2616),
    [sym_keyword_current_time] = STATE(8355),
    [sym_keyword_current_timestamp] = STATE(8360),
    [sym_keyword_null] = STATE(2665),
    [sym_keyword_true] = STATE(2665),
    [sym_keyword_false] = STATE(2665),
    [sym_keyword_decimal] = STATE(7536),
    [sym_keyword_bigdecimal] = STATE(7536),
    [sym_keyword_numeric] = STATE(7536),
    [sym_keyword_bignumeric] = STATE(7536),
    [sym_keyword_json] = STATE(7511),
    [sym_keyword_interval] = STATE(1278),
    [sym_keyword_time] = STATE(5175),
    [sym_keyword_date] = STATE(5175),
    [sym_keyword_datetime] = STATE(5175),
    [sym_keyword_timestamp] = STATE(5175),
    [sym_keyword_timestamptz] = STATE(5175),
    [sym__time_types] = STATE(5175),
    [sym_numeric] = STATE(2665),
    [sym_date] = STATE(2607),
    [sym_parameter] = STATE(2607),
    [sym_case] = STATE(2607),
    [sym_field] = STATE(2607),
    [sym_cast] = STATE(2607),
    [sym_substring] = STATE(2607),
    [sym_quantified_comparison] = STATE(2607),
    [sym_trim] = STATE(2607),
    [sym_invocation] = STATE(5320),
    [sym__extract_invocation] = STATE(2525),
    [sym__array_invocation] = STATE(2526),
    [sym_window_function] = STATE(2607),
    [sym_unnest_operator] = STATE(3677),
    [sym_unnest_clause] = STATE(2607),
    [sym_between] = STATE(2607),
    [sym_interval] = STATE(2665),
    [sym__expression] = STATE(5451),
    [sym_predicate] = STATE(2607),
    [sym_binary_expression] = STATE(2607),
    [sym_field_access] = STATE(2607),
    [sym_element_access] = STATE(2607),
    [sym_subquery] = STATE(2607),
    [sym_list] = STATE(2607),
    [sym_query_parameter] = STATE(2665),
    [sym_literal] = STATE(2607),
    [sym_json] = STATE(2665),
    [sym__number] = STATE(2665),
    [sym__float] = STATE(2581),
    [sym_string] = STATE(2665),
    [sym__type_struct] = STATE(8158),
    [sym__type_array] = STATE(8363),
    [sym_array] = STATE(2665),
    [sym_struct] = STATE(2665),
    [sym_current_date] = STATE(2607),
    [sym_current_time] = STATE(2607),
    [sym_current_timestamp] = STATE(2607),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5412),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_from_token1] = ACTIONS(289),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_leading_token1] = ACTIONS(291),
    [aux_sym_keyword_trailing_token1] = ACTIONS(293),
    [aux_sym_keyword_both_token1] = ACTIONS(295),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(297),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(299),
    [aux_sym_keyword_true_token1] = ACTIONS(301),
    [aux_sym_keyword_false_token1] = ACTIONS(303),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(305),
    [aux_sym_keyword_date_token1] = ACTIONS(307),
    [aux_sym_keyword_datetime_token1] = ACTIONS(309),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(311),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(313),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(315),
    [anon_sym_QMARK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [sym_system_variable] = ACTIONS(327),
    [sym__named_query_parameter] = ACTIONS(329),
    [sym__positional_query_parameter] = ACTIONS(329),
    [sym_hex] = ACTIONS(327),
    [sym__integer] = ACTIONS(331),
    [aux_sym__float_token1] = ACTIONS(333),
    [aux_sym__float_token2] = ACTIONS(335),
    [aux_sym__float_token3] = ACTIONS(333),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(337),
  },
  [32] = {
    [sym_keyword_from] = STATE(354),
    [sym_keyword_extract] = STATE(8458),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8459),
    [sym_keyword_safe_cast] = STATE(8459),
    [sym_keyword_case] = STATE(93),
    [sym_keyword_substring] = STATE(8460),
    [sym_keyword_not] = STATE(1225),
    [sym_keyword_exists] = STATE(7529),
    [sym_keyword_all] = STATE(7513),
    [sym_keyword_trim] = STATE(8156),
    [sym_keyword_leading] = STATE(122),
    [sym_keyword_trailing] = STATE(122),
    [sym_keyword_both] = STATE(122),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6838),
    [sym_keyword_any] = STATE(7513),
    [sym_keyword_some] = STATE(7513),
    [sym_keyword_current_date] = STATE(2616),
    [sym_keyword_current_time] = STATE(8355),
    [sym_keyword_current_timestamp] = STATE(8360),
    [sym_keyword_null] = STATE(2665),
    [sym_keyword_true] = STATE(2665),
    [sym_keyword_false] = STATE(2665),
    [sym_keyword_decimal] = STATE(7536),
    [sym_keyword_bigdecimal] = STATE(7536),
    [sym_keyword_numeric] = STATE(7536),
    [sym_keyword_bignumeric] = STATE(7536),
    [sym_keyword_json] = STATE(7511),
    [sym_keyword_interval] = STATE(1278),
    [sym_keyword_time] = STATE(5175),
    [sym_keyword_date] = STATE(5175),
    [sym_keyword_datetime] = STATE(5175),
    [sym_keyword_timestamp] = STATE(5175),
    [sym_keyword_timestamptz] = STATE(5175),
    [sym__time_types] = STATE(5175),
    [sym_numeric] = STATE(2665),
    [sym_date] = STATE(2607),
    [sym_parameter] = STATE(2607),
    [sym_case] = STATE(2607),
    [sym_field] = STATE(2607),
    [sym_cast] = STATE(2607),
    [sym_substring] = STATE(2607),
    [sym_quantified_comparison] = STATE(2607),
    [sym_trim] = STATE(2607),
    [sym_invocation] = STATE(5320),
    [sym__extract_invocation] = STATE(2525),
    [sym__array_invocation] = STATE(2526),
    [sym_window_function] = STATE(2607),
    [sym_unnest_operator] = STATE(3677),
    [sym_unnest_clause] = STATE(2607),
    [sym_between] = STATE(2607),
    [sym_interval] = STATE(2665),
    [sym__expression] = STATE(5511),
    [sym_predicate] = STATE(2607),
    [sym_binary_expression] = STATE(2607),
    [sym_field_access] = STATE(2607),
    [sym_element_access] = STATE(2607),
    [sym_subquery] = STATE(2607),
    [sym_list] = STATE(2607),
    [sym_query_parameter] = STATE(2665),
    [sym_literal] = STATE(2607),
    [sym_json] = STATE(2665),
    [sym__number] = STATE(2665),
    [sym__float] = STATE(2581),
    [sym_string] = STATE(2665),
    [sym__type_struct] = STATE(8158),
    [sym__type_array] = STATE(8363),
    [sym_array] = STATE(2665),
    [sym_struct] = STATE(2665),
    [sym_current_date] = STATE(2607),
    [sym_current_time] = STATE(2607),
    [sym_current_timestamp] = STATE(2607),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5412),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_from_token1] = ACTIONS(289),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_leading_token1] = ACTIONS(291),
    [aux_sym_keyword_trailing_token1] = ACTIONS(293),
    [aux_sym_keyword_both_token1] = ACTIONS(295),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(297),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(299),
    [aux_sym_keyword_true_token1] = ACTIONS(301),
    [aux_sym_keyword_false_token1] = ACTIONS(303),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(305),
    [aux_sym_keyword_date_token1] = ACTIONS(307),
    [aux_sym_keyword_datetime_token1] = ACTIONS(309),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(311),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(313),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(315),
    [anon_sym_QMARK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [sym_system_variable] = ACTIONS(327),
    [sym__named_query_parameter] = ACTIONS(329),
    [sym__positional_query_parameter] = ACTIONS(329),
    [sym_hex] = ACTIONS(327),
    [sym__integer] = ACTIONS(331),
    [aux_sym__float_token1] = ACTIONS(333),
    [aux_sym__float_token2] = ACTIONS(335),
    [aux_sym__float_token3] = ACTIONS(333),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(337),
  },
  [33] = {
    [sym_keyword_from] = STATE(680),
    [sym_keyword_extract] = STATE(8458),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8459),
    [sym_keyword_safe_cast] = STATE(8459),
    [sym_keyword_case] = STATE(93),
    [sym_keyword_substring] = STATE(8460),
    [sym_keyword_not] = STATE(1225),
    [sym_keyword_exists] = STATE(7529),
    [sym_keyword_all] = STATE(7513),
    [sym_keyword_trim] = STATE(8156),
    [sym_keyword_leading] = STATE(118),
    [sym_keyword_trailing] = STATE(118),
    [sym_keyword_both] = STATE(118),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6838),
    [sym_keyword_any] = STATE(7513),
    [sym_keyword_some] = STATE(7513),
    [sym_keyword_current_date] = STATE(2616),
    [sym_keyword_current_time] = STATE(8355),
    [sym_keyword_current_timestamp] = STATE(8360),
    [sym_keyword_null] = STATE(2665),
    [sym_keyword_true] = STATE(2665),
    [sym_keyword_false] = STATE(2665),
    [sym_keyword_decimal] = STATE(7536),
    [sym_keyword_bigdecimal] = STATE(7536),
    [sym_keyword_numeric] = STATE(7536),
    [sym_keyword_bignumeric] = STATE(7536),
    [sym_keyword_json] = STATE(7511),
    [sym_keyword_interval] = STATE(1278),
    [sym_keyword_time] = STATE(5175),
    [sym_keyword_date] = STATE(5175),
    [sym_keyword_datetime] = STATE(5175),
    [sym_keyword_timestamp] = STATE(5175),
    [sym_keyword_timestamptz] = STATE(5175),
    [sym__time_types] = STATE(5175),
    [sym_numeric] = STATE(2665),
    [sym_date] = STATE(2607),
    [sym_parameter] = STATE(2607),
    [sym_case] = STATE(2607),
    [sym_field] = STATE(2607),
    [sym_cast] = STATE(2607),
    [sym_substring] = STATE(2607),
    [sym_quantified_comparison] = STATE(2607),
    [sym_trim] = STATE(2607),
    [sym_invocation] = STATE(5320),
    [sym__extract_invocation] = STATE(2525),
    [sym__array_invocation] = STATE(2526),
    [sym_window_function] = STATE(2607),
    [sym_unnest_operator] = STATE(3677),
    [sym_unnest_clause] = STATE(2607),
    [sym_between] = STATE(2607),
    [sym_interval] = STATE(2665),
    [sym__expression] = STATE(5368),
    [sym_predicate] = STATE(2607),
    [sym_binary_expression] = STATE(2607),
    [sym_field_access] = STATE(2607),
    [sym_element_access] = STATE(2607),
    [sym_subquery] = STATE(2607),
    [sym_list] = STATE(2607),
    [sym_query_parameter] = STATE(2665),
    [sym_literal] = STATE(2607),
    [sym_json] = STATE(2665),
    [sym__number] = STATE(2665),
    [sym__float] = STATE(2581),
    [sym_string] = STATE(2665),
    [sym__type_struct] = STATE(8158),
    [sym__type_array] = STATE(8363),
    [sym_array] = STATE(2665),
    [sym_struct] = STATE(2665),
    [sym_current_date] = STATE(2607),
    [sym_current_time] = STATE(2607),
    [sym_current_timestamp] = STATE(2607),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5412),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_from_token1] = ACTIONS(289),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_leading_token1] = ACTIONS(291),
    [aux_sym_keyword_trailing_token1] = ACTIONS(293),
    [aux_sym_keyword_both_token1] = ACTIONS(295),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(297),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(299),
    [aux_sym_keyword_true_token1] = ACTIONS(301),
    [aux_sym_keyword_false_token1] = ACTIONS(303),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(305),
    [aux_sym_keyword_date_token1] = ACTIONS(307),
    [aux_sym_keyword_datetime_token1] = ACTIONS(309),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(311),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(313),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(315),
    [anon_sym_QMARK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [sym_system_variable] = ACTIONS(327),
    [sym__named_query_parameter] = ACTIONS(329),
    [sym__positional_query_parameter] = ACTIONS(329),
    [sym_hex] = ACTIONS(327),
    [sym__integer] = ACTIONS(331),
    [aux_sym__float_token1] = ACTIONS(333),
    [aux_sym__float_token2] = ACTIONS(335),
    [aux_sym__float_token3] = ACTIONS(333),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(337),
  },
  [34] = {
    [sym_keyword_from] = STATE(396),
    [sym_keyword_extract] = STATE(8458),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8459),
    [sym_keyword_safe_cast] = STATE(8459),
    [sym_keyword_case] = STATE(93),
    [sym_keyword_substring] = STATE(8460),
    [sym_keyword_not] = STATE(1225),
    [sym_keyword_exists] = STATE(7529),
    [sym_keyword_all] = STATE(7513),
    [sym_keyword_trim] = STATE(8156),
    [sym_keyword_leading] = STATE(123),
    [sym_keyword_trailing] = STATE(123),
    [sym_keyword_both] = STATE(123),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6838),
    [sym_keyword_any] = STATE(7513),
    [sym_keyword_some] = STATE(7513),
    [sym_keyword_current_date] = STATE(2616),
    [sym_keyword_current_time] = STATE(8355),
    [sym_keyword_current_timestamp] = STATE(8360),
    [sym_keyword_null] = STATE(2665),
    [sym_keyword_true] = STATE(2665),
    [sym_keyword_false] = STATE(2665),
    [sym_keyword_decimal] = STATE(7536),
    [sym_keyword_bigdecimal] = STATE(7536),
    [sym_keyword_numeric] = STATE(7536),
    [sym_keyword_bignumeric] = STATE(7536),
    [sym_keyword_json] = STATE(7511),
    [sym_keyword_interval] = STATE(1278),
    [sym_keyword_time] = STATE(5175),
    [sym_keyword_date] = STATE(5175),
    [sym_keyword_datetime] = STATE(5175),
    [sym_keyword_timestamp] = STATE(5175),
    [sym_keyword_timestamptz] = STATE(5175),
    [sym__time_types] = STATE(5175),
    [sym_numeric] = STATE(2665),
    [sym_date] = STATE(2607),
    [sym_parameter] = STATE(2607),
    [sym_case] = STATE(2607),
    [sym_field] = STATE(2607),
    [sym_cast] = STATE(2607),
    [sym_substring] = STATE(2607),
    [sym_quantified_comparison] = STATE(2607),
    [sym_trim] = STATE(2607),
    [sym_invocation] = STATE(5320),
    [sym__extract_invocation] = STATE(2525),
    [sym__array_invocation] = STATE(2526),
    [sym_window_function] = STATE(2607),
    [sym_unnest_operator] = STATE(3677),
    [sym_unnest_clause] = STATE(2607),
    [sym_between] = STATE(2607),
    [sym_interval] = STATE(2665),
    [sym__expression] = STATE(5534),
    [sym_predicate] = STATE(2607),
    [sym_binary_expression] = STATE(2607),
    [sym_field_access] = STATE(2607),
    [sym_element_access] = STATE(2607),
    [sym_subquery] = STATE(2607),
    [sym_list] = STATE(2607),
    [sym_query_parameter] = STATE(2665),
    [sym_literal] = STATE(2607),
    [sym_json] = STATE(2665),
    [sym__number] = STATE(2665),
    [sym__float] = STATE(2581),
    [sym_string] = STATE(2665),
    [sym__type_struct] = STATE(8158),
    [sym__type_array] = STATE(8363),
    [sym_array] = STATE(2665),
    [sym_struct] = STATE(2665),
    [sym_current_date] = STATE(2607),
    [sym_current_time] = STATE(2607),
    [sym_current_timestamp] = STATE(2607),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5412),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_from_token1] = ACTIONS(289),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_leading_token1] = ACTIONS(291),
    [aux_sym_keyword_trailing_token1] = ACTIONS(293),
    [aux_sym_keyword_both_token1] = ACTIONS(295),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(297),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(299),
    [aux_sym_keyword_true_token1] = ACTIONS(301),
    [aux_sym_keyword_false_token1] = ACTIONS(303),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(305),
    [aux_sym_keyword_date_token1] = ACTIONS(307),
    [aux_sym_keyword_datetime_token1] = ACTIONS(309),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(311),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(313),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(315),
    [anon_sym_QMARK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [sym_system_variable] = ACTIONS(327),
    [sym__named_query_parameter] = ACTIONS(329),
    [sym__positional_query_parameter] = ACTIONS(329),
    [sym_hex] = ACTIONS(327),
    [sym__integer] = ACTIONS(331),
    [aux_sym__float_token1] = ACTIONS(333),
    [aux_sym__float_token2] = ACTIONS(335),
    [aux_sym__float_token3] = ACTIONS(333),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(337),
  },
  [35] = {
    [sym_keyword_from] = STATE(360),
    [sym_keyword_extract] = STATE(8458),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8459),
    [sym_keyword_safe_cast] = STATE(8459),
    [sym_keyword_case] = STATE(93),
    [sym_keyword_substring] = STATE(8460),
    [sym_keyword_not] = STATE(1225),
    [sym_keyword_exists] = STATE(7529),
    [sym_keyword_all] = STATE(7513),
    [sym_keyword_trim] = STATE(8156),
    [sym_keyword_leading] = STATE(126),
    [sym_keyword_trailing] = STATE(126),
    [sym_keyword_both] = STATE(126),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6838),
    [sym_keyword_any] = STATE(7513),
    [sym_keyword_some] = STATE(7513),
    [sym_keyword_current_date] = STATE(2616),
    [sym_keyword_current_time] = STATE(8355),
    [sym_keyword_current_timestamp] = STATE(8360),
    [sym_keyword_null] = STATE(2665),
    [sym_keyword_true] = STATE(2665),
    [sym_keyword_false] = STATE(2665),
    [sym_keyword_decimal] = STATE(7536),
    [sym_keyword_bigdecimal] = STATE(7536),
    [sym_keyword_numeric] = STATE(7536),
    [sym_keyword_bignumeric] = STATE(7536),
    [sym_keyword_json] = STATE(7511),
    [sym_keyword_interval] = STATE(1278),
    [sym_keyword_time] = STATE(5175),
    [sym_keyword_date] = STATE(5175),
    [sym_keyword_datetime] = STATE(5175),
    [sym_keyword_timestamp] = STATE(5175),
    [sym_keyword_timestamptz] = STATE(5175),
    [sym__time_types] = STATE(5175),
    [sym_numeric] = STATE(2665),
    [sym_date] = STATE(2607),
    [sym_parameter] = STATE(2607),
    [sym_case] = STATE(2607),
    [sym_field] = STATE(2607),
    [sym_cast] = STATE(2607),
    [sym_substring] = STATE(2607),
    [sym_quantified_comparison] = STATE(2607),
    [sym_trim] = STATE(2607),
    [sym_invocation] = STATE(5320),
    [sym__extract_invocation] = STATE(2525),
    [sym__array_invocation] = STATE(2526),
    [sym_window_function] = STATE(2607),
    [sym_unnest_operator] = STATE(3677),
    [sym_unnest_clause] = STATE(2607),
    [sym_between] = STATE(2607),
    [sym_interval] = STATE(2665),
    [sym__expression] = STATE(5459),
    [sym_predicate] = STATE(2607),
    [sym_binary_expression] = STATE(2607),
    [sym_field_access] = STATE(2607),
    [sym_element_access] = STATE(2607),
    [sym_subquery] = STATE(2607),
    [sym_list] = STATE(2607),
    [sym_query_parameter] = STATE(2665),
    [sym_literal] = STATE(2607),
    [sym_json] = STATE(2665),
    [sym__number] = STATE(2665),
    [sym__float] = STATE(2581),
    [sym_string] = STATE(2665),
    [sym__type_struct] = STATE(8158),
    [sym__type_array] = STATE(8363),
    [sym_array] = STATE(2665),
    [sym_struct] = STATE(2665),
    [sym_current_date] = STATE(2607),
    [sym_current_time] = STATE(2607),
    [sym_current_timestamp] = STATE(2607),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5412),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_from_token1] = ACTIONS(289),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_leading_token1] = ACTIONS(291),
    [aux_sym_keyword_trailing_token1] = ACTIONS(293),
    [aux_sym_keyword_both_token1] = ACTIONS(295),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(297),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(299),
    [aux_sym_keyword_true_token1] = ACTIONS(301),
    [aux_sym_keyword_false_token1] = ACTIONS(303),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(305),
    [aux_sym_keyword_date_token1] = ACTIONS(307),
    [aux_sym_keyword_datetime_token1] = ACTIONS(309),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(311),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(313),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(315),
    [anon_sym_QMARK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [sym_system_variable] = ACTIONS(327),
    [sym__named_query_parameter] = ACTIONS(329),
    [sym__positional_query_parameter] = ACTIONS(329),
    [sym_hex] = ACTIONS(327),
    [sym__integer] = ACTIONS(331),
    [aux_sym__float_token1] = ACTIONS(333),
    [aux_sym__float_token2] = ACTIONS(335),
    [aux_sym__float_token3] = ACTIONS(333),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(337),
  },
  [36] = {
    [sym_keyword_from] = STATE(393),
    [sym_keyword_extract] = STATE(8458),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8459),
    [sym_keyword_safe_cast] = STATE(8459),
    [sym_keyword_case] = STATE(93),
    [sym_keyword_substring] = STATE(8460),
    [sym_keyword_not] = STATE(1225),
    [sym_keyword_exists] = STATE(7529),
    [sym_keyword_all] = STATE(7513),
    [sym_keyword_trim] = STATE(8156),
    [sym_keyword_leading] = STATE(121),
    [sym_keyword_trailing] = STATE(121),
    [sym_keyword_both] = STATE(121),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6838),
    [sym_keyword_any] = STATE(7513),
    [sym_keyword_some] = STATE(7513),
    [sym_keyword_current_date] = STATE(2616),
    [sym_keyword_current_time] = STATE(8355),
    [sym_keyword_current_timestamp] = STATE(8360),
    [sym_keyword_null] = STATE(2665),
    [sym_keyword_true] = STATE(2665),
    [sym_keyword_false] = STATE(2665),
    [sym_keyword_decimal] = STATE(7536),
    [sym_keyword_bigdecimal] = STATE(7536),
    [sym_keyword_numeric] = STATE(7536),
    [sym_keyword_bignumeric] = STATE(7536),
    [sym_keyword_json] = STATE(7511),
    [sym_keyword_interval] = STATE(1278),
    [sym_keyword_time] = STATE(5175),
    [sym_keyword_date] = STATE(5175),
    [sym_keyword_datetime] = STATE(5175),
    [sym_keyword_timestamp] = STATE(5175),
    [sym_keyword_timestamptz] = STATE(5175),
    [sym__time_types] = STATE(5175),
    [sym_numeric] = STATE(2665),
    [sym_date] = STATE(2607),
    [sym_parameter] = STATE(2607),
    [sym_case] = STATE(2607),
    [sym_field] = STATE(2607),
    [sym_cast] = STATE(2607),
    [sym_substring] = STATE(2607),
    [sym_quantified_comparison] = STATE(2607),
    [sym_trim] = STATE(2607),
    [sym_invocation] = STATE(5320),
    [sym__extract_invocation] = STATE(2525),
    [sym__array_invocation] = STATE(2526),
    [sym_window_function] = STATE(2607),
    [sym_unnest_operator] = STATE(3677),
    [sym_unnest_clause] = STATE(2607),
    [sym_between] = STATE(2607),
    [sym_interval] = STATE(2665),
    [sym__expression] = STATE(5472),
    [sym_predicate] = STATE(2607),
    [sym_binary_expression] = STATE(2607),
    [sym_field_access] = STATE(2607),
    [sym_element_access] = STATE(2607),
    [sym_subquery] = STATE(2607),
    [sym_list] = STATE(2607),
    [sym_query_parameter] = STATE(2665),
    [sym_literal] = STATE(2607),
    [sym_json] = STATE(2665),
    [sym__number] = STATE(2665),
    [sym__float] = STATE(2581),
    [sym_string] = STATE(2665),
    [sym__type_struct] = STATE(8158),
    [sym__type_array] = STATE(8363),
    [sym_array] = STATE(2665),
    [sym_struct] = STATE(2665),
    [sym_current_date] = STATE(2607),
    [sym_current_time] = STATE(2607),
    [sym_current_timestamp] = STATE(2607),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5412),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_from_token1] = ACTIONS(289),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_leading_token1] = ACTIONS(291),
    [aux_sym_keyword_trailing_token1] = ACTIONS(293),
    [aux_sym_keyword_both_token1] = ACTIONS(295),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(297),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(299),
    [aux_sym_keyword_true_token1] = ACTIONS(301),
    [aux_sym_keyword_false_token1] = ACTIONS(303),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(305),
    [aux_sym_keyword_date_token1] = ACTIONS(307),
    [aux_sym_keyword_datetime_token1] = ACTIONS(309),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(311),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(313),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(315),
    [anon_sym_QMARK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [sym_system_variable] = ACTIONS(327),
    [sym__named_query_parameter] = ACTIONS(329),
    [sym__positional_query_parameter] = ACTIONS(329),
    [sym_hex] = ACTIONS(327),
    [sym__integer] = ACTIONS(331),
    [aux_sym__float_token1] = ACTIONS(333),
    [aux_sym__float_token2] = ACTIONS(335),
    [aux_sym__float_token3] = ACTIONS(333),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(337),
  },
  [37] = {
    [sym_keyword_from] = STATE(466),
    [sym_keyword_extract] = STATE(8458),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8459),
    [sym_keyword_safe_cast] = STATE(8459),
    [sym_keyword_case] = STATE(93),
    [sym_keyword_substring] = STATE(8460),
    [sym_keyword_not] = STATE(1225),
    [sym_keyword_exists] = STATE(7529),
    [sym_keyword_all] = STATE(7513),
    [sym_keyword_trim] = STATE(8156),
    [sym_keyword_leading] = STATE(124),
    [sym_keyword_trailing] = STATE(124),
    [sym_keyword_both] = STATE(124),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6838),
    [sym_keyword_any] = STATE(7513),
    [sym_keyword_some] = STATE(7513),
    [sym_keyword_current_date] = STATE(2616),
    [sym_keyword_current_time] = STATE(8355),
    [sym_keyword_current_timestamp] = STATE(8360),
    [sym_keyword_null] = STATE(2665),
    [sym_keyword_true] = STATE(2665),
    [sym_keyword_false] = STATE(2665),
    [sym_keyword_decimal] = STATE(7536),
    [sym_keyword_bigdecimal] = STATE(7536),
    [sym_keyword_numeric] = STATE(7536),
    [sym_keyword_bignumeric] = STATE(7536),
    [sym_keyword_json] = STATE(7511),
    [sym_keyword_interval] = STATE(1278),
    [sym_keyword_time] = STATE(5175),
    [sym_keyword_date] = STATE(5175),
    [sym_keyword_datetime] = STATE(5175),
    [sym_keyword_timestamp] = STATE(5175),
    [sym_keyword_timestamptz] = STATE(5175),
    [sym__time_types] = STATE(5175),
    [sym_numeric] = STATE(2665),
    [sym_date] = STATE(2607),
    [sym_parameter] = STATE(2607),
    [sym_case] = STATE(2607),
    [sym_field] = STATE(2607),
    [sym_cast] = STATE(2607),
    [sym_substring] = STATE(2607),
    [sym_quantified_comparison] = STATE(2607),
    [sym_trim] = STATE(2607),
    [sym_invocation] = STATE(5320),
    [sym__extract_invocation] = STATE(2525),
    [sym__array_invocation] = STATE(2526),
    [sym_window_function] = STATE(2607),
    [sym_unnest_operator] = STATE(3677),
    [sym_unnest_clause] = STATE(2607),
    [sym_between] = STATE(2607),
    [sym_interval] = STATE(2665),
    [sym__expression] = STATE(5555),
    [sym_predicate] = STATE(2607),
    [sym_binary_expression] = STATE(2607),
    [sym_field_access] = STATE(2607),
    [sym_element_access] = STATE(2607),
    [sym_subquery] = STATE(2607),
    [sym_list] = STATE(2607),
    [sym_query_parameter] = STATE(2665),
    [sym_literal] = STATE(2607),
    [sym_json] = STATE(2665),
    [sym__number] = STATE(2665),
    [sym__float] = STATE(2581),
    [sym_string] = STATE(2665),
    [sym__type_struct] = STATE(8158),
    [sym__type_array] = STATE(8363),
    [sym_array] = STATE(2665),
    [sym_struct] = STATE(2665),
    [sym_current_date] = STATE(2607),
    [sym_current_time] = STATE(2607),
    [sym_current_timestamp] = STATE(2607),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5412),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_from_token1] = ACTIONS(289),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_leading_token1] = ACTIONS(291),
    [aux_sym_keyword_trailing_token1] = ACTIONS(293),
    [aux_sym_keyword_both_token1] = ACTIONS(295),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(297),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(299),
    [aux_sym_keyword_true_token1] = ACTIONS(301),
    [aux_sym_keyword_false_token1] = ACTIONS(303),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(305),
    [aux_sym_keyword_date_token1] = ACTIONS(307),
    [aux_sym_keyword_datetime_token1] = ACTIONS(309),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(311),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(313),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(315),
    [anon_sym_QMARK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [sym_system_variable] = ACTIONS(327),
    [sym__named_query_parameter] = ACTIONS(329),
    [sym__positional_query_parameter] = ACTIONS(329),
    [sym_hex] = ACTIONS(327),
    [sym__integer] = ACTIONS(331),
    [aux_sym__float_token1] = ACTIONS(333),
    [aux_sym__float_token2] = ACTIONS(335),
    [aux_sym__float_token3] = ACTIONS(333),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(337),
  },
  [38] = {
    [sym_keyword_from] = STATE(523),
    [sym_keyword_extract] = STATE(8458),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8459),
    [sym_keyword_safe_cast] = STATE(8459),
    [sym_keyword_case] = STATE(93),
    [sym_keyword_substring] = STATE(8460),
    [sym_keyword_not] = STATE(1225),
    [sym_keyword_exists] = STATE(7529),
    [sym_keyword_all] = STATE(7513),
    [sym_keyword_trim] = STATE(8156),
    [sym_keyword_leading] = STATE(138),
    [sym_keyword_trailing] = STATE(138),
    [sym_keyword_both] = STATE(138),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6838),
    [sym_keyword_any] = STATE(7513),
    [sym_keyword_some] = STATE(7513),
    [sym_keyword_current_date] = STATE(2616),
    [sym_keyword_current_time] = STATE(8355),
    [sym_keyword_current_timestamp] = STATE(8360),
    [sym_keyword_null] = STATE(2665),
    [sym_keyword_true] = STATE(2665),
    [sym_keyword_false] = STATE(2665),
    [sym_keyword_decimal] = STATE(7536),
    [sym_keyword_bigdecimal] = STATE(7536),
    [sym_keyword_numeric] = STATE(7536),
    [sym_keyword_bignumeric] = STATE(7536),
    [sym_keyword_json] = STATE(7511),
    [sym_keyword_interval] = STATE(1278),
    [sym_keyword_time] = STATE(5175),
    [sym_keyword_date] = STATE(5175),
    [sym_keyword_datetime] = STATE(5175),
    [sym_keyword_timestamp] = STATE(5175),
    [sym_keyword_timestamptz] = STATE(5175),
    [sym__time_types] = STATE(5175),
    [sym_numeric] = STATE(2665),
    [sym_date] = STATE(2607),
    [sym_parameter] = STATE(2607),
    [sym_case] = STATE(2607),
    [sym_field] = STATE(2607),
    [sym_cast] = STATE(2607),
    [sym_substring] = STATE(2607),
    [sym_quantified_comparison] = STATE(2607),
    [sym_trim] = STATE(2607),
    [sym_invocation] = STATE(5320),
    [sym__extract_invocation] = STATE(2525),
    [sym__array_invocation] = STATE(2526),
    [sym_window_function] = STATE(2607),
    [sym_unnest_operator] = STATE(3677),
    [sym_unnest_clause] = STATE(2607),
    [sym_between] = STATE(2607),
    [sym_interval] = STATE(2665),
    [sym__expression] = STATE(5516),
    [sym_predicate] = STATE(2607),
    [sym_binary_expression] = STATE(2607),
    [sym_field_access] = STATE(2607),
    [sym_element_access] = STATE(2607),
    [sym_subquery] = STATE(2607),
    [sym_list] = STATE(2607),
    [sym_query_parameter] = STATE(2665),
    [sym_literal] = STATE(2607),
    [sym_json] = STATE(2665),
    [sym__number] = STATE(2665),
    [sym__float] = STATE(2581),
    [sym_string] = STATE(2665),
    [sym__type_struct] = STATE(8158),
    [sym__type_array] = STATE(8363),
    [sym_array] = STATE(2665),
    [sym_struct] = STATE(2665),
    [sym_current_date] = STATE(2607),
    [sym_current_time] = STATE(2607),
    [sym_current_timestamp] = STATE(2607),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5412),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_from_token1] = ACTIONS(289),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_leading_token1] = ACTIONS(291),
    [aux_sym_keyword_trailing_token1] = ACTIONS(293),
    [aux_sym_keyword_both_token1] = ACTIONS(295),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(297),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(299),
    [aux_sym_keyword_true_token1] = ACTIONS(301),
    [aux_sym_keyword_false_token1] = ACTIONS(303),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(305),
    [aux_sym_keyword_date_token1] = ACTIONS(307),
    [aux_sym_keyword_datetime_token1] = ACTIONS(309),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(311),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(313),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(315),
    [anon_sym_QMARK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [sym_system_variable] = ACTIONS(327),
    [sym__named_query_parameter] = ACTIONS(329),
    [sym__positional_query_parameter] = ACTIONS(329),
    [sym_hex] = ACTIONS(327),
    [sym__integer] = ACTIONS(331),
    [aux_sym__float_token1] = ACTIONS(333),
    [aux_sym__float_token2] = ACTIONS(335),
    [aux_sym__float_token3] = ACTIONS(333),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(337),
  },
  [39] = {
    [sym_keyword_from] = STATE(533),
    [sym_keyword_extract] = STATE(8458),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8459),
    [sym_keyword_safe_cast] = STATE(8459),
    [sym_keyword_case] = STATE(93),
    [sym_keyword_substring] = STATE(8460),
    [sym_keyword_not] = STATE(1225),
    [sym_keyword_exists] = STATE(7529),
    [sym_keyword_all] = STATE(7513),
    [sym_keyword_trim] = STATE(8156),
    [sym_keyword_leading] = STATE(137),
    [sym_keyword_trailing] = STATE(137),
    [sym_keyword_both] = STATE(137),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6838),
    [sym_keyword_any] = STATE(7513),
    [sym_keyword_some] = STATE(7513),
    [sym_keyword_current_date] = STATE(2616),
    [sym_keyword_current_time] = STATE(8355),
    [sym_keyword_current_timestamp] = STATE(8360),
    [sym_keyword_null] = STATE(2665),
    [sym_keyword_true] = STATE(2665),
    [sym_keyword_false] = STATE(2665),
    [sym_keyword_decimal] = STATE(7536),
    [sym_keyword_bigdecimal] = STATE(7536),
    [sym_keyword_numeric] = STATE(7536),
    [sym_keyword_bignumeric] = STATE(7536),
    [sym_keyword_json] = STATE(7511),
    [sym_keyword_interval] = STATE(1278),
    [sym_keyword_time] = STATE(5175),
    [sym_keyword_date] = STATE(5175),
    [sym_keyword_datetime] = STATE(5175),
    [sym_keyword_timestamp] = STATE(5175),
    [sym_keyword_timestamptz] = STATE(5175),
    [sym__time_types] = STATE(5175),
    [sym_numeric] = STATE(2665),
    [sym_date] = STATE(2607),
    [sym_parameter] = STATE(2607),
    [sym_case] = STATE(2607),
    [sym_field] = STATE(2607),
    [sym_cast] = STATE(2607),
    [sym_substring] = STATE(2607),
    [sym_quantified_comparison] = STATE(2607),
    [sym_trim] = STATE(2607),
    [sym_invocation] = STATE(5320),
    [sym__extract_invocation] = STATE(2525),
    [sym__array_invocation] = STATE(2526),
    [sym_window_function] = STATE(2607),
    [sym_unnest_operator] = STATE(3677),
    [sym_unnest_clause] = STATE(2607),
    [sym_between] = STATE(2607),
    [sym_interval] = STATE(2665),
    [sym__expression] = STATE(5569),
    [sym_predicate] = STATE(2607),
    [sym_binary_expression] = STATE(2607),
    [sym_field_access] = STATE(2607),
    [sym_element_access] = STATE(2607),
    [sym_subquery] = STATE(2607),
    [sym_list] = STATE(2607),
    [sym_query_parameter] = STATE(2665),
    [sym_literal] = STATE(2607),
    [sym_json] = STATE(2665),
    [sym__number] = STATE(2665),
    [sym__float] = STATE(2581),
    [sym_string] = STATE(2665),
    [sym__type_struct] = STATE(8158),
    [sym__type_array] = STATE(8363),
    [sym_array] = STATE(2665),
    [sym_struct] = STATE(2665),
    [sym_current_date] = STATE(2607),
    [sym_current_time] = STATE(2607),
    [sym_current_timestamp] = STATE(2607),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5412),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_from_token1] = ACTIONS(289),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_leading_token1] = ACTIONS(291),
    [aux_sym_keyword_trailing_token1] = ACTIONS(293),
    [aux_sym_keyword_both_token1] = ACTIONS(295),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(297),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(299),
    [aux_sym_keyword_true_token1] = ACTIONS(301),
    [aux_sym_keyword_false_token1] = ACTIONS(303),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(305),
    [aux_sym_keyword_date_token1] = ACTIONS(307),
    [aux_sym_keyword_datetime_token1] = ACTIONS(309),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(311),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(313),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(315),
    [anon_sym_QMARK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [sym_system_variable] = ACTIONS(327),
    [sym__named_query_parameter] = ACTIONS(329),
    [sym__positional_query_parameter] = ACTIONS(329),
    [sym_hex] = ACTIONS(327),
    [sym__integer] = ACTIONS(331),
    [aux_sym__float_token1] = ACTIONS(333),
    [aux_sym__float_token2] = ACTIONS(335),
    [aux_sym__float_token3] = ACTIONS(333),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(337),
  },
  [40] = {
    [sym_keyword_from] = STATE(882),
    [sym_keyword_extract] = STATE(8458),
    [sym_keyword_unnest] = STATE(7532),
    [sym_keyword_cast] = STATE(8459),
    [sym_keyword_safe_cast] = STATE(8459),
    [sym_keyword_case] = STATE(93),
    [sym_keyword_substring] = STATE(8460),
    [sym_keyword_not] = STATE(1225),
    [sym_keyword_exists] = STATE(7529),
    [sym_keyword_all] = STATE(7513),
    [sym_keyword_trim] = STATE(8156),
    [sym_keyword_leading] = STATE(134),
    [sym_keyword_trailing] = STATE(134),
    [sym_keyword_both] = STATE(134),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6838),
    [sym_keyword_any] = STATE(7513),
    [sym_keyword_some] = STATE(7513),
    [sym_keyword_current_date] = STATE(2616),
    [sym_keyword_current_time] = STATE(8355),
    [sym_keyword_current_timestamp] = STATE(8360),
    [sym_keyword_null] = STATE(2665),
    [sym_keyword_true] = STATE(2665),
    [sym_keyword_false] = STATE(2665),
    [sym_keyword_decimal] = STATE(7536),
    [sym_keyword_bigdecimal] = STATE(7536),
    [sym_keyword_numeric] = STATE(7536),
    [sym_keyword_bignumeric] = STATE(7536),
    [sym_keyword_json] = STATE(7511),
    [sym_keyword_interval] = STATE(1278),
    [sym_keyword_time] = STATE(5175),
    [sym_keyword_date] = STATE(5175),
    [sym_keyword_datetime] = STATE(5175),
    [sym_keyword_timestamp] = STATE(5175),
    [sym_keyword_timestamptz] = STATE(5175),
    [sym__time_types] = STATE(5175),
    [sym_numeric] = STATE(2665),
    [sym_date] = STATE(2607),
    [sym_parameter] = STATE(2607),
    [sym_case] = STATE(2607),
    [sym_field] = STATE(2607),
    [sym_cast] = STATE(2607),
    [sym_substring] = STATE(2607),
    [sym_quantified_comparison] = STATE(2607),
    [sym_trim] = STATE(2607),
    [sym_invocation] = STATE(5320),
    [sym__extract_invocation] = STATE(2525),
    [sym__array_invocation] = STATE(2526),
    [sym_window_function] = STATE(2607),
    [sym_unnest_operator] = STATE(3677),
    [sym_unnest_clause] = STATE(2607),
    [sym_between] = STATE(2607),
    [sym_interval] = STATE(2665),
    [sym__expression] = STATE(5343),
    [sym_predicate] = STATE(2607),
    [sym_binary_expression] = STATE(2607),
    [sym_field_access] = STATE(2607),
    [sym_element_access] = STATE(2607),
    [sym_subquery] = STATE(2607),
    [sym_list] = STATE(2607),
    [sym_query_parameter] = STATE(2665),
    [sym_literal] = STATE(2607),
    [sym_json] = STATE(2665),
    [sym__number] = STATE(2665),
    [sym__float] = STATE(2581),
    [sym_string] = STATE(2665),
    [sym__type_struct] = STATE(8158),
    [sym__type_array] = STATE(8363),
    [sym_array] = STATE(2665),
    [sym_struct] = STATE(2665),
    [sym_current_date] = STATE(2607),
    [sym_current_time] = STATE(2607),
    [sym_current_timestamp] = STATE(2607),
    [sym__identifier] = STATE(4398),
    [sym__dotted_identifier] = STATE(6782),
    [sym_identifier] = STATE(5412),
    [aux_sym_identifier_repeat1] = STATE(6782),
    [sym__unquoted_identifier] = ACTIONS(45),
    [aux_sym_keyword_from_token1] = ACTIONS(289),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(67),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_leading_token1] = ACTIONS(291),
    [aux_sym_keyword_trailing_token1] = ACTIONS(293),
    [aux_sym_keyword_both_token1] = ACTIONS(295),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(297),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(299),
    [aux_sym_keyword_true_token1] = ACTIONS(301),
    [aux_sym_keyword_false_token1] = ACTIONS(303),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(305),
    [aux_sym_keyword_date_token1] = ACTIONS(307),
    [aux_sym_keyword_datetime_token1] = ACTIONS(309),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(311),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(313),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(315),
    [anon_sym_QMARK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [sym_system_variable] = ACTIONS(327),
    [sym__named_query_parameter] = ACTIONS(329),
    [sym__positional_query_parameter] = ACTIONS(329),
    [sym_hex] = ACTIONS(327),
    [sym__integer] = ACTIONS(331),
    [aux_sym__float_token1] = ACTIONS(333),
    [aux_sym__float_token2] = ACTIONS(335),
    [aux_sym__float_token3] = ACTIONS(333),
    [sym__quoted_identifier] = ACTIONS(135),
    [sym__string_start] = ACTIONS(337),
  },
  [41] = {
    [sym_keyword_extract] = STATE(8479),
    [sym_keyword_unnest] = STATE(7694),
    [sym_keyword_distinct] = STATE(73),
    [sym_keyword_cast] = STATE(8480),
    [sym_keyword_safe_cast] = STATE(8480),
    [sym_keyword_case] = STATE(104),
    [sym_keyword_substring] = STATE(8481),
    [sym_keyword_not] = STATE(365),
    [sym_keyword_exists] = STATE(7591),
    [sym_keyword_all] = STATE(76),
    [sym_keyword_trim] = STATE(8271),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6839),
    [sym_keyword_any] = STATE(7593),
    [sym_keyword_some] = STATE(7593),
    [sym_keyword_current_date] = STATE(5301),
    [sym_keyword_current_time] = STATE(7816),
    [sym_keyword_current_timestamp] = STATE(7817),
    [sym_keyword_null] = STATE(5338),
    [sym_keyword_true] = STATE(5338),
    [sym_keyword_false] = STATE(5338),
    [sym_keyword_decimal] = STATE(7371),
    [sym_keyword_bigdecimal] = STATE(7371),
    [sym_keyword_numeric] = STATE(7371),
    [sym_keyword_bignumeric] = STATE(7371),
    [sym_keyword_json] = STATE(7594),
    [sym_keyword_interval] = STATE(504),
    [sym_keyword_time] = STATE(5060),
    [sym_keyword_date] = STATE(5060),
    [sym_keyword_datetime] = STATE(5060),
    [sym_keyword_timestamp] = STATE(5060),
    [sym_keyword_timestamptz] = STATE(5060),
    [sym_wildcard] = STATE(8024),
    [sym__time_types] = STATE(5060),
    [sym_numeric] = STATE(5338),
    [sym__argument] = STATE(6207),
    [sym_date] = STATE(5344),
    [sym_parameter] = STATE(5344),
    [sym_case] = STATE(5344),
    [sym_field] = STATE(5344),
    [sym_cast] = STATE(5344),
    [sym_substring] = STATE(5344),
    [sym_quantified_comparison] = STATE(5344),
    [sym_trim] = STATE(5344),
    [sym_invocation] = STATE(5183),
    [sym__extract_invocation] = STATE(5299),
    [sym__array_invocation] = STATE(5297),
    [sym_window_function] = STATE(5344),
    [sym__invocation_params] = STATE(8023),
    [sym_unnest_operator] = STATE(3643),
    [sym_unnest_clause] = STATE(5344),
    [sym_between] = STATE(5344),
    [sym_interval] = STATE(5338),
    [sym__expression] = STATE(5001),
    [sym_predicate] = STATE(5344),
    [sym_binary_expression] = STATE(5344),
    [sym_field_access] = STATE(5344),
    [sym_element_access] = STATE(5344),
    [sym_subquery] = STATE(5344),
    [sym_list] = STATE(5344),
    [sym_query_parameter] = STATE(5338),
    [sym_literal] = STATE(5344),
    [sym_json] = STATE(5338),
    [sym__number] = STATE(5338),
    [sym__float] = STATE(5348),
    [sym_string] = STATE(5338),
    [sym__type_struct] = STATE(8273),
    [sym__type_array] = STATE(7819),
    [sym_array] = STATE(5338),
    [sym_struct] = STATE(5338),
    [sym_current_date] = STATE(5344),
    [sym_current_time] = STATE(5344),
    [sym_current_timestamp] = STATE(5344),
    [sym__identifier] = STATE(5160),
    [sym__dotted_identifier] = STATE(7094),
    [sym_identifier] = STATE(5703),
    [aux_sym_identifier_repeat1] = STATE(6795),
    [sym__unquoted_identifier] = ACTIONS(339),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(341),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(343),
    [aux_sym_keyword_true_token1] = ACTIONS(345),
    [aux_sym_keyword_false_token1] = ACTIONS(347),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(349),
    [aux_sym_keyword_date_token1] = ACTIONS(351),
    [aux_sym_keyword_datetime_token1] = ACTIONS(353),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(355),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(357),
    [anon_sym_STAR] = ACTIONS(261),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(359),
    [sym_right_paren] = ACTIONS(361),
    [anon_sym_QMARK] = ACTIONS(363),
    [anon_sym_DOLLAR] = ACTIONS(365),
    [anon_sym_TILDE] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(369),
    [anon_sym_LBRACK] = ACTIONS(371),
    [sym_system_variable] = ACTIONS(373),
    [sym__named_query_parameter] = ACTIONS(375),
    [sym__positional_query_parameter] = ACTIONS(375),
    [sym_hex] = ACTIONS(373),
    [sym__integer] = ACTIONS(377),
    [aux_sym__float_token1] = ACTIONS(379),
    [aux_sym__float_token2] = ACTIONS(381),
    [aux_sym__float_token3] = ACTIONS(379),
    [sym__quoted_identifier] = ACTIONS(383),
    [sym__string_start] = ACTIONS(385),
  },
  [42] = {
    [sym_keyword_extract] = STATE(8473),
    [sym_keyword_unnest] = STATE(7454),
    [sym_keyword_distinct] = STATE(87),
    [sym_keyword_cast] = STATE(8474),
    [sym_keyword_safe_cast] = STATE(8474),
    [sym_keyword_case] = STATE(99),
    [sym_keyword_substring] = STATE(8475),
    [sym_keyword_not] = STATE(689),
    [sym_keyword_exists] = STATE(7469),
    [sym_keyword_all] = STATE(114),
    [sym_keyword_trim] = STATE(8249),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6868),
    [sym_keyword_any] = STATE(7471),
    [sym_keyword_some] = STATE(7471),
    [sym_keyword_current_date] = STATE(2321),
    [sym_keyword_current_time] = STATE(7814),
    [sym_keyword_current_timestamp] = STATE(7813),
    [sym_keyword_null] = STATE(2316),
    [sym_keyword_true] = STATE(2316),
    [sym_keyword_false] = STATE(2316),
    [sym_keyword_decimal] = STATE(7414),
    [sym_keyword_bigdecimal] = STATE(7414),
    [sym_keyword_numeric] = STATE(7414),
    [sym_keyword_bignumeric] = STATE(7414),
    [sym_keyword_json] = STATE(7482),
    [sym_keyword_interval] = STATE(552),
    [sym_keyword_time] = STATE(2244),
    [sym_keyword_date] = STATE(2244),
    [sym_keyword_datetime] = STATE(2244),
    [sym_keyword_timestamp] = STATE(2244),
    [sym_keyword_timestamptz] = STATE(2244),
    [sym_wildcard] = STATE(4379),
    [sym__time_types] = STATE(2244),
    [sym_numeric] = STATE(2316),
    [sym__select_wildcard] = STATE(4109),
    [sym__distinct_on] = STATE(4110),
    [sym_select_field] = STATE(5239),
    [sym_date] = STATE(2322),
    [sym_parameter] = STATE(2322),
    [sym_case] = STATE(2322),
    [sym_field] = STATE(2322),
    [sym_cast] = STATE(2322),
    [sym_substring] = STATE(2322),
    [sym_quantified_comparison] = STATE(2322),
    [sym_trim] = STATE(2322),
    [sym_invocation] = STATE(2245),
    [sym__extract_invocation] = STATE(2261),
    [sym__array_invocation] = STATE(2263),
    [sym_window_function] = STATE(2322),
    [sym_unnest_operator] = STATE(1554),
    [sym_unnest_clause] = STATE(2322),
    [sym_between] = STATE(2322),
    [sym_interval] = STATE(2316),
    [sym__expression] = STATE(1499),
    [sym_predicate] = STATE(2322),
    [sym_binary_expression] = STATE(2322),
    [sym_field_access] = STATE(2322),
    [sym_element_access] = STATE(2322),
    [sym_subquery] = STATE(2322),
    [sym_list] = STATE(2322),
    [sym_query_parameter] = STATE(2316),
    [sym_literal] = STATE(2322),
    [sym_json] = STATE(2316),
    [sym__number] = STATE(2316),
    [sym__float] = STATE(2328),
    [sym_string] = STATE(2316),
    [sym__type_struct] = STATE(8251),
    [sym__type_array] = STATE(7812),
    [sym_array] = STATE(2316),
    [sym_struct] = STATE(2316),
    [sym_current_date] = STATE(2322),
    [sym_current_time] = STATE(2322),
    [sym_current_timestamp] = STATE(2322),
    [sym__identifier] = STATE(2148),
    [sym__dotted_identifier] = STATE(6954),
    [sym_identifier] = STATE(2329),
    [aux_sym_identifier_repeat1] = STATE(6779),
    [sym__unquoted_identifier] = ACTIONS(193),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(195),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(197),
    [aux_sym_keyword_true_token1] = ACTIONS(199),
    [aux_sym_keyword_false_token1] = ACTIONS(201),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(203),
    [aux_sym_keyword_date_token1] = ACTIONS(205),
    [aux_sym_keyword_datetime_token1] = ACTIONS(207),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(209),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(211),
    [anon_sym_STAR] = ACTIONS(213),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(215),
    [anon_sym_QMARK] = ACTIONS(217),
    [anon_sym_DOLLAR] = ACTIONS(219),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [anon_sym_DASH] = ACTIONS(223),
    [anon_sym_LBRACK] = ACTIONS(225),
    [sym_system_variable] = ACTIONS(227),
    [sym__named_query_parameter] = ACTIONS(229),
    [sym__positional_query_parameter] = ACTIONS(229),
    [sym_hex] = ACTIONS(227),
    [sym__integer] = ACTIONS(231),
    [aux_sym__float_token1] = ACTIONS(233),
    [aux_sym__float_token2] = ACTIONS(235),
    [aux_sym__float_token3] = ACTIONS(233),
    [sym__quoted_identifier] = ACTIONS(237),
    [sym__string_start] = ACTIONS(239),
  },
  [43] = {
    [sym_keyword_extract] = STATE(8479),
    [sym_keyword_unnest] = STATE(7694),
    [sym_keyword_distinct] = STATE(69),
    [sym_keyword_cast] = STATE(8480),
    [sym_keyword_safe_cast] = STATE(8480),
    [sym_keyword_case] = STATE(104),
    [sym_keyword_substring] = STATE(8481),
    [sym_keyword_not] = STATE(365),
    [sym_keyword_exists] = STATE(7591),
    [sym_keyword_all] = STATE(68),
    [sym_keyword_trim] = STATE(8271),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6839),
    [sym_keyword_any] = STATE(7593),
    [sym_keyword_some] = STATE(7593),
    [sym_keyword_current_date] = STATE(5301),
    [sym_keyword_current_time] = STATE(7816),
    [sym_keyword_current_timestamp] = STATE(7817),
    [sym_keyword_null] = STATE(5338),
    [sym_keyword_true] = STATE(5338),
    [sym_keyword_false] = STATE(5338),
    [sym_keyword_decimal] = STATE(7371),
    [sym_keyword_bigdecimal] = STATE(7371),
    [sym_keyword_numeric] = STATE(7371),
    [sym_keyword_bignumeric] = STATE(7371),
    [sym_keyword_json] = STATE(7594),
    [sym_keyword_interval] = STATE(504),
    [sym_keyword_time] = STATE(5060),
    [sym_keyword_date] = STATE(5060),
    [sym_keyword_datetime] = STATE(5060),
    [sym_keyword_timestamp] = STATE(5060),
    [sym_keyword_timestamptz] = STATE(5060),
    [sym_wildcard] = STATE(8109),
    [sym__time_types] = STATE(5060),
    [sym_numeric] = STATE(5338),
    [sym__argument] = STATE(6207),
    [sym_date] = STATE(5344),
    [sym_parameter] = STATE(5344),
    [sym_case] = STATE(5344),
    [sym_field] = STATE(5344),
    [sym_cast] = STATE(5344),
    [sym_substring] = STATE(5344),
    [sym_quantified_comparison] = STATE(5344),
    [sym_trim] = STATE(5344),
    [sym_invocation] = STATE(5183),
    [sym__extract_invocation] = STATE(5299),
    [sym__array_invocation] = STATE(5297),
    [sym_window_function] = STATE(5344),
    [sym__invocation_params] = STATE(8110),
    [sym_unnest_operator] = STATE(3643),
    [sym_unnest_clause] = STATE(5344),
    [sym_between] = STATE(5344),
    [sym_interval] = STATE(5338),
    [sym__expression] = STATE(5001),
    [sym_predicate] = STATE(5344),
    [sym_binary_expression] = STATE(5344),
    [sym_field_access] = STATE(5344),
    [sym_element_access] = STATE(5344),
    [sym_subquery] = STATE(5344),
    [sym_list] = STATE(5344),
    [sym_query_parameter] = STATE(5338),
    [sym_literal] = STATE(5344),
    [sym_json] = STATE(5338),
    [sym__number] = STATE(5338),
    [sym__float] = STATE(5348),
    [sym_string] = STATE(5338),
    [sym__type_struct] = STATE(8273),
    [sym__type_array] = STATE(7819),
    [sym_array] = STATE(5338),
    [sym_struct] = STATE(5338),
    [sym_current_date] = STATE(5344),
    [sym_current_time] = STATE(5344),
    [sym_current_timestamp] = STATE(5344),
    [sym__identifier] = STATE(5160),
    [sym__dotted_identifier] = STATE(7094),
    [sym_identifier] = STATE(5703),
    [aux_sym_identifier_repeat1] = STATE(6795),
    [sym__unquoted_identifier] = ACTIONS(339),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(341),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(343),
    [aux_sym_keyword_true_token1] = ACTIONS(345),
    [aux_sym_keyword_false_token1] = ACTIONS(347),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(349),
    [aux_sym_keyword_date_token1] = ACTIONS(351),
    [aux_sym_keyword_datetime_token1] = ACTIONS(353),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(355),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(357),
    [anon_sym_STAR] = ACTIONS(261),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(359),
    [sym_right_paren] = ACTIONS(387),
    [anon_sym_QMARK] = ACTIONS(363),
    [anon_sym_DOLLAR] = ACTIONS(365),
    [anon_sym_TILDE] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(369),
    [anon_sym_LBRACK] = ACTIONS(371),
    [sym_system_variable] = ACTIONS(373),
    [sym__named_query_parameter] = ACTIONS(375),
    [sym__positional_query_parameter] = ACTIONS(375),
    [sym_hex] = ACTIONS(373),
    [sym__integer] = ACTIONS(377),
    [aux_sym__float_token1] = ACTIONS(379),
    [aux_sym__float_token2] = ACTIONS(381),
    [aux_sym__float_token3] = ACTIONS(379),
    [sym__quoted_identifier] = ACTIONS(383),
    [sym__string_start] = ACTIONS(385),
  },
  [44] = {
    [sym_keyword_extract] = STATE(8479),
    [sym_keyword_unnest] = STATE(7694),
    [sym_keyword_distinct] = STATE(72),
    [sym_keyword_cast] = STATE(8480),
    [sym_keyword_safe_cast] = STATE(8480),
    [sym_keyword_case] = STATE(104),
    [sym_keyword_substring] = STATE(8481),
    [sym_keyword_not] = STATE(365),
    [sym_keyword_exists] = STATE(7591),
    [sym_keyword_all] = STATE(86),
    [sym_keyword_trim] = STATE(8271),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6839),
    [sym_keyword_any] = STATE(7593),
    [sym_keyword_some] = STATE(7593),
    [sym_keyword_current_date] = STATE(5301),
    [sym_keyword_current_time] = STATE(7816),
    [sym_keyword_current_timestamp] = STATE(7817),
    [sym_keyword_null] = STATE(5338),
    [sym_keyword_true] = STATE(5338),
    [sym_keyword_false] = STATE(5338),
    [sym_keyword_decimal] = STATE(7371),
    [sym_keyword_bigdecimal] = STATE(7371),
    [sym_keyword_numeric] = STATE(7371),
    [sym_keyword_bignumeric] = STATE(7371),
    [sym_keyword_json] = STATE(7594),
    [sym_keyword_interval] = STATE(504),
    [sym_keyword_time] = STATE(5060),
    [sym_keyword_date] = STATE(5060),
    [sym_keyword_datetime] = STATE(5060),
    [sym_keyword_timestamp] = STATE(5060),
    [sym_keyword_timestamptz] = STATE(5060),
    [sym_wildcard] = STATE(7837),
    [sym__time_types] = STATE(5060),
    [sym_numeric] = STATE(5338),
    [sym__argument] = STATE(6207),
    [sym_date] = STATE(5344),
    [sym_parameter] = STATE(5344),
    [sym_case] = STATE(5344),
    [sym_field] = STATE(5344),
    [sym_cast] = STATE(5344),
    [sym_substring] = STATE(5344),
    [sym_quantified_comparison] = STATE(5344),
    [sym_trim] = STATE(5344),
    [sym_invocation] = STATE(5183),
    [sym__extract_invocation] = STATE(5299),
    [sym__array_invocation] = STATE(5297),
    [sym_window_function] = STATE(5344),
    [sym__invocation_params] = STATE(7840),
    [sym_unnest_operator] = STATE(3643),
    [sym_unnest_clause] = STATE(5344),
    [sym_between] = STATE(5344),
    [sym_interval] = STATE(5338),
    [sym__expression] = STATE(5001),
    [sym_predicate] = STATE(5344),
    [sym_binary_expression] = STATE(5344),
    [sym_field_access] = STATE(5344),
    [sym_element_access] = STATE(5344),
    [sym_subquery] = STATE(5344),
    [sym_list] = STATE(5344),
    [sym_query_parameter] = STATE(5338),
    [sym_literal] = STATE(5344),
    [sym_json] = STATE(5338),
    [sym__number] = STATE(5338),
    [sym__float] = STATE(5348),
    [sym_string] = STATE(5338),
    [sym__type_struct] = STATE(8273),
    [sym__type_array] = STATE(7819),
    [sym_array] = STATE(5338),
    [sym_struct] = STATE(5338),
    [sym_current_date] = STATE(5344),
    [sym_current_time] = STATE(5344),
    [sym_current_timestamp] = STATE(5344),
    [sym__identifier] = STATE(5160),
    [sym__dotted_identifier] = STATE(7094),
    [sym_identifier] = STATE(5703),
    [aux_sym_identifier_repeat1] = STATE(6795),
    [sym__unquoted_identifier] = ACTIONS(339),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(341),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(343),
    [aux_sym_keyword_true_token1] = ACTIONS(345),
    [aux_sym_keyword_false_token1] = ACTIONS(347),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(349),
    [aux_sym_keyword_date_token1] = ACTIONS(351),
    [aux_sym_keyword_datetime_token1] = ACTIONS(353),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(355),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(357),
    [anon_sym_STAR] = ACTIONS(261),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(359),
    [sym_right_paren] = ACTIONS(389),
    [anon_sym_QMARK] = ACTIONS(363),
    [anon_sym_DOLLAR] = ACTIONS(365),
    [anon_sym_TILDE] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(369),
    [anon_sym_LBRACK] = ACTIONS(371),
    [sym_system_variable] = ACTIONS(373),
    [sym__named_query_parameter] = ACTIONS(375),
    [sym__positional_query_parameter] = ACTIONS(375),
    [sym_hex] = ACTIONS(373),
    [sym__integer] = ACTIONS(377),
    [aux_sym__float_token1] = ACTIONS(379),
    [aux_sym__float_token2] = ACTIONS(381),
    [aux_sym__float_token3] = ACTIONS(379),
    [sym__quoted_identifier] = ACTIONS(383),
    [sym__string_start] = ACTIONS(385),
  },
  [45] = {
    [sym_keyword_extract] = STATE(8171),
    [sym_keyword_unnest] = STATE(7531),
    [sym_keyword_distinct] = STATE(84),
    [sym_keyword_cast] = STATE(8138),
    [sym_keyword_safe_cast] = STATE(8138),
    [sym_keyword_case] = STATE(105),
    [sym_keyword_substring] = STATE(8137),
    [sym_keyword_not] = STATE(1373),
    [sym_keyword_exists] = STATE(7540),
    [sym_keyword_all] = STATE(115),
    [sym_keyword_trim] = STATE(8135),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6843),
    [sym_keyword_any] = STATE(7542),
    [sym_keyword_some] = STATE(7542),
    [sym_keyword_current_date] = STATE(2181),
    [sym_keyword_current_time] = STATE(8129),
    [sym_keyword_current_timestamp] = STATE(8126),
    [sym_keyword_null] = STATE(2127),
    [sym_keyword_true] = STATE(2127),
    [sym_keyword_false] = STATE(2127),
    [sym_keyword_decimal] = STATE(7544),
    [sym_keyword_bigdecimal] = STATE(7544),
    [sym_keyword_numeric] = STATE(7544),
    [sym_keyword_bignumeric] = STATE(7544),
    [sym_keyword_json] = STATE(7545),
    [sym_keyword_interval] = STATE(1478),
    [sym_keyword_time] = STATE(2717),
    [sym_keyword_date] = STATE(2717),
    [sym_keyword_datetime] = STATE(2717),
    [sym_keyword_timestamp] = STATE(2717),
    [sym_keyword_timestamptz] = STATE(2717),
    [sym_wildcard] = STATE(4990),
    [sym__time_types] = STATE(2717),
    [sym_numeric] = STATE(2127),
    [sym__select_wildcard] = STATE(4310),
    [sym__distinct_on] = STATE(4304),
    [sym_select_field] = STATE(5239),
    [sym_date] = STATE(2183),
    [sym_parameter] = STATE(2183),
    [sym_case] = STATE(2183),
    [sym_field] = STATE(2183),
    [sym_cast] = STATE(2183),
    [sym_substring] = STATE(2183),
    [sym_quantified_comparison] = STATE(2183),
    [sym_trim] = STATE(2183),
    [sym_invocation] = STATE(2053),
    [sym__extract_invocation] = STATE(2081),
    [sym__array_invocation] = STATE(2095),
    [sym_window_function] = STATE(2183),
    [sym_unnest_operator] = STATE(1934),
    [sym_unnest_clause] = STATE(2183),
    [sym_between] = STATE(2183),
    [sym_interval] = STATE(2127),
    [sym__expression] = STATE(1560),
    [sym_predicate] = STATE(2183),
    [sym_binary_expression] = STATE(2183),
    [sym_field_access] = STATE(2183),
    [sym_element_access] = STATE(2183),
    [sym_subquery] = STATE(2183),
    [sym_list] = STATE(2183),
    [sym_query_parameter] = STATE(2127),
    [sym_literal] = STATE(2183),
    [sym_json] = STATE(2127),
    [sym__number] = STATE(2127),
    [sym__float] = STATE(1985),
    [sym_string] = STATE(2127),
    [sym__type_struct] = STATE(8120),
    [sym__type_array] = STATE(8119),
    [sym_array] = STATE(2127),
    [sym_struct] = STATE(2127),
    [sym_current_date] = STATE(2183),
    [sym_current_time] = STATE(2183),
    [sym_current_timestamp] = STATE(2183),
    [sym__identifier] = STATE(1887),
    [sym__dotted_identifier] = STATE(7094),
    [sym_identifier] = STATE(2807),
    [aux_sym_identifier_repeat1] = STATE(6787),
    [sym__unquoted_identifier] = ACTIONS(241),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(243),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(245),
    [aux_sym_keyword_true_token1] = ACTIONS(247),
    [aux_sym_keyword_false_token1] = ACTIONS(249),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(251),
    [aux_sym_keyword_date_token1] = ACTIONS(253),
    [aux_sym_keyword_datetime_token1] = ACTIONS(255),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(257),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(259),
    [anon_sym_STAR] = ACTIONS(261),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(263),
    [anon_sym_QMARK] = ACTIONS(265),
    [anon_sym_DOLLAR] = ACTIONS(267),
    [anon_sym_TILDE] = ACTIONS(269),
    [anon_sym_PLUS] = ACTIONS(271),
    [anon_sym_DASH] = ACTIONS(271),
    [anon_sym_LBRACK] = ACTIONS(273),
    [sym_system_variable] = ACTIONS(275),
    [sym__named_query_parameter] = ACTIONS(277),
    [sym__positional_query_parameter] = ACTIONS(277),
    [sym_hex] = ACTIONS(275),
    [sym__integer] = ACTIONS(279),
    [aux_sym__float_token1] = ACTIONS(281),
    [aux_sym__float_token2] = ACTIONS(283),
    [aux_sym__float_token3] = ACTIONS(281),
    [sym__quoted_identifier] = ACTIONS(285),
    [sym__string_start] = ACTIONS(287),
  },
  [46] = {
    [sym_keyword_extract] = STATE(8479),
    [sym_keyword_unnest] = STATE(7694),
    [sym_keyword_distinct] = STATE(75),
    [sym_keyword_cast] = STATE(8480),
    [sym_keyword_safe_cast] = STATE(8480),
    [sym_keyword_case] = STATE(104),
    [sym_keyword_substring] = STATE(8481),
    [sym_keyword_not] = STATE(365),
    [sym_keyword_exists] = STATE(7591),
    [sym_keyword_all] = STATE(74),
    [sym_keyword_trim] = STATE(8271),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6839),
    [sym_keyword_any] = STATE(7593),
    [sym_keyword_some] = STATE(7593),
    [sym_keyword_current_date] = STATE(5301),
    [sym_keyword_current_time] = STATE(7816),
    [sym_keyword_current_timestamp] = STATE(7817),
    [sym_keyword_null] = STATE(5338),
    [sym_keyword_true] = STATE(5338),
    [sym_keyword_false] = STATE(5338),
    [sym_keyword_decimal] = STATE(7371),
    [sym_keyword_bigdecimal] = STATE(7371),
    [sym_keyword_numeric] = STATE(7371),
    [sym_keyword_bignumeric] = STATE(7371),
    [sym_keyword_json] = STATE(7594),
    [sym_keyword_interval] = STATE(504),
    [sym_keyword_time] = STATE(5060),
    [sym_keyword_date] = STATE(5060),
    [sym_keyword_datetime] = STATE(5060),
    [sym_keyword_timestamp] = STATE(5060),
    [sym_keyword_timestamptz] = STATE(5060),
    [sym_wildcard] = STATE(8026),
    [sym__time_types] = STATE(5060),
    [sym_numeric] = STATE(5338),
    [sym__argument] = STATE(6207),
    [sym_date] = STATE(5344),
    [sym_parameter] = STATE(5344),
    [sym_case] = STATE(5344),
    [sym_field] = STATE(5344),
    [sym_cast] = STATE(5344),
    [sym_substring] = STATE(5344),
    [sym_quantified_comparison] = STATE(5344),
    [sym_trim] = STATE(5344),
    [sym_invocation] = STATE(5183),
    [sym__extract_invocation] = STATE(5299),
    [sym__array_invocation] = STATE(5297),
    [sym_window_function] = STATE(5344),
    [sym__invocation_params] = STATE(8029),
    [sym_unnest_operator] = STATE(3643),
    [sym_unnest_clause] = STATE(5344),
    [sym_between] = STATE(5344),
    [sym_interval] = STATE(5338),
    [sym__expression] = STATE(5001),
    [sym_predicate] = STATE(5344),
    [sym_binary_expression] = STATE(5344),
    [sym_field_access] = STATE(5344),
    [sym_element_access] = STATE(5344),
    [sym_subquery] = STATE(5344),
    [sym_list] = STATE(5344),
    [sym_query_parameter] = STATE(5338),
    [sym_literal] = STATE(5344),
    [sym_json] = STATE(5338),
    [sym__number] = STATE(5338),
    [sym__float] = STATE(5348),
    [sym_string] = STATE(5338),
    [sym__type_struct] = STATE(8273),
    [sym__type_array] = STATE(7819),
    [sym_array] = STATE(5338),
    [sym_struct] = STATE(5338),
    [sym_current_date] = STATE(5344),
    [sym_current_time] = STATE(5344),
    [sym_current_timestamp] = STATE(5344),
    [sym__identifier] = STATE(5160),
    [sym__dotted_identifier] = STATE(7094),
    [sym_identifier] = STATE(5703),
    [aux_sym_identifier_repeat1] = STATE(6795),
    [sym__unquoted_identifier] = ACTIONS(339),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(341),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(343),
    [aux_sym_keyword_true_token1] = ACTIONS(345),
    [aux_sym_keyword_false_token1] = ACTIONS(347),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(349),
    [aux_sym_keyword_date_token1] = ACTIONS(351),
    [aux_sym_keyword_datetime_token1] = ACTIONS(353),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(355),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(357),
    [anon_sym_STAR] = ACTIONS(261),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(359),
    [sym_right_paren] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(363),
    [anon_sym_DOLLAR] = ACTIONS(365),
    [anon_sym_TILDE] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(369),
    [anon_sym_LBRACK] = ACTIONS(371),
    [sym_system_variable] = ACTIONS(373),
    [sym__named_query_parameter] = ACTIONS(375),
    [sym__positional_query_parameter] = ACTIONS(375),
    [sym_hex] = ACTIONS(373),
    [sym__integer] = ACTIONS(377),
    [aux_sym__float_token1] = ACTIONS(379),
    [aux_sym__float_token2] = ACTIONS(381),
    [aux_sym__float_token3] = ACTIONS(379),
    [sym__quoted_identifier] = ACTIONS(383),
    [sym__string_start] = ACTIONS(385),
  },
  [47] = {
    [sym_keyword_extract] = STATE(8479),
    [sym_keyword_unnest] = STATE(7694),
    [sym_keyword_distinct] = STATE(88),
    [sym_keyword_cast] = STATE(8480),
    [sym_keyword_safe_cast] = STATE(8480),
    [sym_keyword_case] = STATE(104),
    [sym_keyword_substring] = STATE(8481),
    [sym_keyword_not] = STATE(365),
    [sym_keyword_exists] = STATE(7591),
    [sym_keyword_all] = STATE(91),
    [sym_keyword_trim] = STATE(8271),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6839),
    [sym_keyword_any] = STATE(7593),
    [sym_keyword_some] = STATE(7593),
    [sym_keyword_current_date] = STATE(5301),
    [sym_keyword_current_time] = STATE(7816),
    [sym_keyword_current_timestamp] = STATE(7817),
    [sym_keyword_null] = STATE(5338),
    [sym_keyword_true] = STATE(5338),
    [sym_keyword_false] = STATE(5338),
    [sym_keyword_decimal] = STATE(7371),
    [sym_keyword_bigdecimal] = STATE(7371),
    [sym_keyword_numeric] = STATE(7371),
    [sym_keyword_bignumeric] = STATE(7371),
    [sym_keyword_json] = STATE(7594),
    [sym_keyword_interval] = STATE(504),
    [sym_keyword_time] = STATE(5060),
    [sym_keyword_date] = STATE(5060),
    [sym_keyword_datetime] = STATE(5060),
    [sym_keyword_timestamp] = STATE(5060),
    [sym_keyword_timestamptz] = STATE(5060),
    [sym_wildcard] = STATE(7930),
    [sym__time_types] = STATE(5060),
    [sym_numeric] = STATE(5338),
    [sym__argument] = STATE(6207),
    [sym_date] = STATE(5344),
    [sym_parameter] = STATE(5344),
    [sym_case] = STATE(5344),
    [sym_field] = STATE(5344),
    [sym_cast] = STATE(5344),
    [sym_substring] = STATE(5344),
    [sym_quantified_comparison] = STATE(5344),
    [sym_trim] = STATE(5344),
    [sym_invocation] = STATE(5183),
    [sym__extract_invocation] = STATE(5299),
    [sym__array_invocation] = STATE(5297),
    [sym_window_function] = STATE(5344),
    [sym__invocation_params] = STATE(7932),
    [sym_unnest_operator] = STATE(3643),
    [sym_unnest_clause] = STATE(5344),
    [sym_between] = STATE(5344),
    [sym_interval] = STATE(5338),
    [sym__expression] = STATE(5001),
    [sym_predicate] = STATE(5344),
    [sym_binary_expression] = STATE(5344),
    [sym_field_access] = STATE(5344),
    [sym_element_access] = STATE(5344),
    [sym_subquery] = STATE(5344),
    [sym_list] = STATE(5344),
    [sym_query_parameter] = STATE(5338),
    [sym_literal] = STATE(5344),
    [sym_json] = STATE(5338),
    [sym__number] = STATE(5338),
    [sym__float] = STATE(5348),
    [sym_string] = STATE(5338),
    [sym__type_struct] = STATE(8273),
    [sym__type_array] = STATE(7819),
    [sym_array] = STATE(5338),
    [sym_struct] = STATE(5338),
    [sym_current_date] = STATE(5344),
    [sym_current_time] = STATE(5344),
    [sym_current_timestamp] = STATE(5344),
    [sym__identifier] = STATE(5160),
    [sym__dotted_identifier] = STATE(7094),
    [sym_identifier] = STATE(5703),
    [aux_sym_identifier_repeat1] = STATE(6795),
    [sym__unquoted_identifier] = ACTIONS(339),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(341),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(343),
    [aux_sym_keyword_true_token1] = ACTIONS(345),
    [aux_sym_keyword_false_token1] = ACTIONS(347),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(349),
    [aux_sym_keyword_date_token1] = ACTIONS(351),
    [aux_sym_keyword_datetime_token1] = ACTIONS(353),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(355),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(357),
    [anon_sym_STAR] = ACTIONS(261),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(359),
    [sym_right_paren] = ACTIONS(393),
    [anon_sym_QMARK] = ACTIONS(363),
    [anon_sym_DOLLAR] = ACTIONS(365),
    [anon_sym_TILDE] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(369),
    [anon_sym_LBRACK] = ACTIONS(371),
    [sym_system_variable] = ACTIONS(373),
    [sym__named_query_parameter] = ACTIONS(375),
    [sym__positional_query_parameter] = ACTIONS(375),
    [sym_hex] = ACTIONS(373),
    [sym__integer] = ACTIONS(377),
    [aux_sym__float_token1] = ACTIONS(379),
    [aux_sym__float_token2] = ACTIONS(381),
    [aux_sym__float_token3] = ACTIONS(379),
    [sym__quoted_identifier] = ACTIONS(383),
    [sym__string_start] = ACTIONS(385),
  },
  [48] = {
    [sym_keyword_extract] = STATE(8479),
    [sym_keyword_unnest] = STATE(7694),
    [sym_keyword_distinct] = STATE(64),
    [sym_keyword_cast] = STATE(8480),
    [sym_keyword_safe_cast] = STATE(8480),
    [sym_keyword_case] = STATE(104),
    [sym_keyword_substring] = STATE(8481),
    [sym_keyword_not] = STATE(365),
    [sym_keyword_exists] = STATE(7591),
    [sym_keyword_all] = STATE(60),
    [sym_keyword_trim] = STATE(8271),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6839),
    [sym_keyword_any] = STATE(7593),
    [sym_keyword_some] = STATE(7593),
    [sym_keyword_current_date] = STATE(5301),
    [sym_keyword_current_time] = STATE(7816),
    [sym_keyword_current_timestamp] = STATE(7817),
    [sym_keyword_null] = STATE(5338),
    [sym_keyword_true] = STATE(5338),
    [sym_keyword_false] = STATE(5338),
    [sym_keyword_decimal] = STATE(7371),
    [sym_keyword_bigdecimal] = STATE(7371),
    [sym_keyword_numeric] = STATE(7371),
    [sym_keyword_bignumeric] = STATE(7371),
    [sym_keyword_json] = STATE(7594),
    [sym_keyword_interval] = STATE(504),
    [sym_keyword_time] = STATE(5060),
    [sym_keyword_date] = STATE(5060),
    [sym_keyword_datetime] = STATE(5060),
    [sym_keyword_timestamp] = STATE(5060),
    [sym_keyword_timestamptz] = STATE(5060),
    [sym_wildcard] = STATE(7845),
    [sym__time_types] = STATE(5060),
    [sym_numeric] = STATE(5338),
    [sym__argument] = STATE(6207),
    [sym_date] = STATE(5344),
    [sym_parameter] = STATE(5344),
    [sym_case] = STATE(5344),
    [sym_field] = STATE(5344),
    [sym_cast] = STATE(5344),
    [sym_substring] = STATE(5344),
    [sym_quantified_comparison] = STATE(5344),
    [sym_trim] = STATE(5344),
    [sym_invocation] = STATE(5183),
    [sym__extract_invocation] = STATE(5299),
    [sym__array_invocation] = STATE(5297),
    [sym_window_function] = STATE(5344),
    [sym__invocation_params] = STATE(7844),
    [sym_unnest_operator] = STATE(3643),
    [sym_unnest_clause] = STATE(5344),
    [sym_between] = STATE(5344),
    [sym_interval] = STATE(5338),
    [sym__expression] = STATE(5001),
    [sym_predicate] = STATE(5344),
    [sym_binary_expression] = STATE(5344),
    [sym_field_access] = STATE(5344),
    [sym_element_access] = STATE(5344),
    [sym_subquery] = STATE(5344),
    [sym_list] = STATE(5344),
    [sym_query_parameter] = STATE(5338),
    [sym_literal] = STATE(5344),
    [sym_json] = STATE(5338),
    [sym__number] = STATE(5338),
    [sym__float] = STATE(5348),
    [sym_string] = STATE(5338),
    [sym__type_struct] = STATE(8273),
    [sym__type_array] = STATE(7819),
    [sym_array] = STATE(5338),
    [sym_struct] = STATE(5338),
    [sym_current_date] = STATE(5344),
    [sym_current_time] = STATE(5344),
    [sym_current_timestamp] = STATE(5344),
    [sym__identifier] = STATE(5160),
    [sym__dotted_identifier] = STATE(7094),
    [sym_identifier] = STATE(5703),
    [aux_sym_identifier_repeat1] = STATE(6795),
    [sym__unquoted_identifier] = ACTIONS(339),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(341),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(343),
    [aux_sym_keyword_true_token1] = ACTIONS(345),
    [aux_sym_keyword_false_token1] = ACTIONS(347),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(349),
    [aux_sym_keyword_date_token1] = ACTIONS(351),
    [aux_sym_keyword_datetime_token1] = ACTIONS(353),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(355),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(357),
    [anon_sym_STAR] = ACTIONS(261),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(359),
    [sym_right_paren] = ACTIONS(395),
    [anon_sym_QMARK] = ACTIONS(363),
    [anon_sym_DOLLAR] = ACTIONS(365),
    [anon_sym_TILDE] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(369),
    [anon_sym_LBRACK] = ACTIONS(371),
    [sym_system_variable] = ACTIONS(373),
    [sym__named_query_parameter] = ACTIONS(375),
    [sym__positional_query_parameter] = ACTIONS(375),
    [sym_hex] = ACTIONS(373),
    [sym__integer] = ACTIONS(377),
    [aux_sym__float_token1] = ACTIONS(379),
    [aux_sym__float_token2] = ACTIONS(381),
    [aux_sym__float_token3] = ACTIONS(379),
    [sym__quoted_identifier] = ACTIONS(383),
    [sym__string_start] = ACTIONS(385),
  },
  [49] = {
    [sym_keyword_extract] = STATE(8479),
    [sym_keyword_unnest] = STATE(7694),
    [sym_keyword_distinct] = STATE(83),
    [sym_keyword_cast] = STATE(8480),
    [sym_keyword_safe_cast] = STATE(8480),
    [sym_keyword_case] = STATE(104),
    [sym_keyword_substring] = STATE(8481),
    [sym_keyword_not] = STATE(365),
    [sym_keyword_exists] = STATE(7591),
    [sym_keyword_all] = STATE(71),
    [sym_keyword_trim] = STATE(8271),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6839),
    [sym_keyword_any] = STATE(7593),
    [sym_keyword_some] = STATE(7593),
    [sym_keyword_current_date] = STATE(5301),
    [sym_keyword_current_time] = STATE(7816),
    [sym_keyword_current_timestamp] = STATE(7817),
    [sym_keyword_null] = STATE(5338),
    [sym_keyword_true] = STATE(5338),
    [sym_keyword_false] = STATE(5338),
    [sym_keyword_decimal] = STATE(7371),
    [sym_keyword_bigdecimal] = STATE(7371),
    [sym_keyword_numeric] = STATE(7371),
    [sym_keyword_bignumeric] = STATE(7371),
    [sym_keyword_json] = STATE(7594),
    [sym_keyword_interval] = STATE(504),
    [sym_keyword_time] = STATE(5060),
    [sym_keyword_date] = STATE(5060),
    [sym_keyword_datetime] = STATE(5060),
    [sym_keyword_timestamp] = STATE(5060),
    [sym_keyword_timestamptz] = STATE(5060),
    [sym_wildcard] = STATE(7795),
    [sym__time_types] = STATE(5060),
    [sym_numeric] = STATE(5338),
    [sym__argument] = STATE(6207),
    [sym_date] = STATE(5344),
    [sym_parameter] = STATE(5344),
    [sym_case] = STATE(5344),
    [sym_field] = STATE(5344),
    [sym_cast] = STATE(5344),
    [sym_substring] = STATE(5344),
    [sym_quantified_comparison] = STATE(5344),
    [sym_trim] = STATE(5344),
    [sym_invocation] = STATE(5183),
    [sym__extract_invocation] = STATE(5299),
    [sym__array_invocation] = STATE(5297),
    [sym_window_function] = STATE(5344),
    [sym__invocation_params] = STATE(7794),
    [sym_unnest_operator] = STATE(3643),
    [sym_unnest_clause] = STATE(5344),
    [sym_between] = STATE(5344),
    [sym_interval] = STATE(5338),
    [sym__expression] = STATE(5001),
    [sym_predicate] = STATE(5344),
    [sym_binary_expression] = STATE(5344),
    [sym_field_access] = STATE(5344),
    [sym_element_access] = STATE(5344),
    [sym_subquery] = STATE(5344),
    [sym_list] = STATE(5344),
    [sym_query_parameter] = STATE(5338),
    [sym_literal] = STATE(5344),
    [sym_json] = STATE(5338),
    [sym__number] = STATE(5338),
    [sym__float] = STATE(5348),
    [sym_string] = STATE(5338),
    [sym__type_struct] = STATE(8273),
    [sym__type_array] = STATE(7819),
    [sym_array] = STATE(5338),
    [sym_struct] = STATE(5338),
    [sym_current_date] = STATE(5344),
    [sym_current_time] = STATE(5344),
    [sym_current_timestamp] = STATE(5344),
    [sym__identifier] = STATE(5160),
    [sym__dotted_identifier] = STATE(7094),
    [sym_identifier] = STATE(5703),
    [aux_sym_identifier_repeat1] = STATE(6795),
    [sym__unquoted_identifier] = ACTIONS(339),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(341),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(343),
    [aux_sym_keyword_true_token1] = ACTIONS(345),
    [aux_sym_keyword_false_token1] = ACTIONS(347),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(349),
    [aux_sym_keyword_date_token1] = ACTIONS(351),
    [aux_sym_keyword_datetime_token1] = ACTIONS(353),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(355),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(357),
    [anon_sym_STAR] = ACTIONS(261),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(359),
    [sym_right_paren] = ACTIONS(397),
    [anon_sym_QMARK] = ACTIONS(363),
    [anon_sym_DOLLAR] = ACTIONS(365),
    [anon_sym_TILDE] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(369),
    [anon_sym_LBRACK] = ACTIONS(371),
    [sym_system_variable] = ACTIONS(373),
    [sym__named_query_parameter] = ACTIONS(375),
    [sym__positional_query_parameter] = ACTIONS(375),
    [sym_hex] = ACTIONS(373),
    [sym__integer] = ACTIONS(377),
    [aux_sym__float_token1] = ACTIONS(379),
    [aux_sym__float_token2] = ACTIONS(381),
    [aux_sym__float_token3] = ACTIONS(379),
    [sym__quoted_identifier] = ACTIONS(383),
    [sym__string_start] = ACTIONS(385),
  },
  [50] = {
    [sym_keyword_extract] = STATE(8465),
    [sym_keyword_unnest] = STATE(7233),
    [sym_keyword_distinct] = STATE(63),
    [sym_keyword_cast] = STATE(8466),
    [sym_keyword_safe_cast] = STATE(8466),
    [sym_keyword_case] = STATE(108),
    [sym_keyword_substring] = STATE(8467),
    [sym_keyword_not] = STATE(1238),
    [sym_keyword_exists] = STATE(7311),
    [sym_keyword_all] = STATE(113),
    [sym_keyword_trim] = STATE(8201),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6859),
    [sym_keyword_any] = STATE(7307),
    [sym_keyword_some] = STATE(7307),
    [sym_keyword_current_date] = STATE(4467),
    [sym_keyword_current_time] = STATE(8248),
    [sym_keyword_current_timestamp] = STATE(8247),
    [sym_keyword_null] = STATE(4380),
    [sym_keyword_true] = STATE(4380),
    [sym_keyword_false] = STATE(4380),
    [sym_keyword_decimal] = STATE(7498),
    [sym_keyword_bigdecimal] = STATE(7498),
    [sym_keyword_numeric] = STATE(7498),
    [sym_keyword_bignumeric] = STATE(7498),
    [sym_keyword_json] = STATE(7305),
    [sym_keyword_interval] = STATE(901),
    [sym_keyword_time] = STATE(4325),
    [sym_keyword_date] = STATE(4325),
    [sym_keyword_datetime] = STATE(4325),
    [sym_keyword_timestamp] = STATE(4325),
    [sym_keyword_timestamptz] = STATE(4325),
    [sym_wildcard] = STATE(6141),
    [sym__time_types] = STATE(4325),
    [sym_numeric] = STATE(4380),
    [sym__select_wildcard] = STATE(5948),
    [sym__distinct_on] = STATE(5949),
    [sym_select_field] = STATE(5239),
    [sym_date] = STATE(4459),
    [sym_parameter] = STATE(4459),
    [sym_case] = STATE(4459),
    [sym_field] = STATE(4459),
    [sym_cast] = STATE(4459),
    [sym_substring] = STATE(4459),
    [sym_quantified_comparison] = STATE(4459),
    [sym_trim] = STATE(4459),
    [sym_invocation] = STATE(4330),
    [sym__extract_invocation] = STATE(4298),
    [sym__array_invocation] = STATE(4332),
    [sym_window_function] = STATE(4459),
    [sym_unnest_operator] = STATE(3165),
    [sym_unnest_clause] = STATE(4459),
    [sym_between] = STATE(4459),
    [sym_interval] = STATE(4380),
    [sym__expression] = STATE(2737),
    [sym_predicate] = STATE(4459),
    [sym_binary_expression] = STATE(4459),
    [sym_field_access] = STATE(4459),
    [sym_element_access] = STATE(4459),
    [sym_subquery] = STATE(4459),
    [sym_list] = STATE(4459),
    [sym_query_parameter] = STATE(4380),
    [sym_literal] = STATE(4459),
    [sym_json] = STATE(4380),
    [sym__number] = STATE(4380),
    [sym__float] = STATE(4455),
    [sym_string] = STATE(4380),
    [sym__type_struct] = STATE(8203),
    [sym__type_array] = STATE(8246),
    [sym_array] = STATE(4380),
    [sym_struct] = STATE(4380),
    [sym_current_date] = STATE(4459),
    [sym_current_time] = STATE(4459),
    [sym_current_timestamp] = STATE(4459),
    [sym__identifier] = STATE(4338),
    [sym__dotted_identifier] = STATE(7126),
    [sym_identifier] = STATE(4452),
    [aux_sym_identifier_repeat1] = STATE(6788),
    [sym__unquoted_identifier] = ACTIONS(139),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(147),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(149),
    [aux_sym_keyword_true_token1] = ACTIONS(151),
    [aux_sym_keyword_false_token1] = ACTIONS(153),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(155),
    [aux_sym_keyword_date_token1] = ACTIONS(157),
    [aux_sym_keyword_datetime_token1] = ACTIONS(159),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(161),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(167),
    [anon_sym_QMARK] = ACTIONS(169),
    [anon_sym_DOLLAR] = ACTIONS(171),
    [anon_sym_TILDE] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(175),
    [anon_sym_DASH] = ACTIONS(175),
    [anon_sym_LBRACK] = ACTIONS(177),
    [sym_system_variable] = ACTIONS(179),
    [sym__named_query_parameter] = ACTIONS(181),
    [sym__positional_query_parameter] = ACTIONS(181),
    [sym_hex] = ACTIONS(179),
    [sym__integer] = ACTIONS(183),
    [aux_sym__float_token1] = ACTIONS(185),
    [aux_sym__float_token2] = ACTIONS(187),
    [aux_sym__float_token3] = ACTIONS(185),
    [sym__quoted_identifier] = ACTIONS(189),
    [sym__string_start] = ACTIONS(191),
  },
  [51] = {
    [sym_keyword_extract] = STATE(8479),
    [sym_keyword_unnest] = STATE(7694),
    [sym_keyword_distinct] = STATE(85),
    [sym_keyword_cast] = STATE(8480),
    [sym_keyword_safe_cast] = STATE(8480),
    [sym_keyword_case] = STATE(104),
    [sym_keyword_substring] = STATE(8481),
    [sym_keyword_not] = STATE(365),
    [sym_keyword_exists] = STATE(7591),
    [sym_keyword_all] = STATE(89),
    [sym_keyword_trim] = STATE(8271),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6839),
    [sym_keyword_any] = STATE(7593),
    [sym_keyword_some] = STATE(7593),
    [sym_keyword_current_date] = STATE(5301),
    [sym_keyword_current_time] = STATE(7816),
    [sym_keyword_current_timestamp] = STATE(7817),
    [sym_keyword_null] = STATE(5338),
    [sym_keyword_true] = STATE(5338),
    [sym_keyword_false] = STATE(5338),
    [sym_keyword_decimal] = STATE(7371),
    [sym_keyword_bigdecimal] = STATE(7371),
    [sym_keyword_numeric] = STATE(7371),
    [sym_keyword_bignumeric] = STATE(7371),
    [sym_keyword_json] = STATE(7594),
    [sym_keyword_interval] = STATE(504),
    [sym_keyword_time] = STATE(5060),
    [sym_keyword_date] = STATE(5060),
    [sym_keyword_datetime] = STATE(5060),
    [sym_keyword_timestamp] = STATE(5060),
    [sym_keyword_timestamptz] = STATE(5060),
    [sym_wildcard] = STATE(7966),
    [sym__time_types] = STATE(5060),
    [sym_numeric] = STATE(5338),
    [sym__argument] = STATE(6207),
    [sym_date] = STATE(5344),
    [sym_parameter] = STATE(5344),
    [sym_case] = STATE(5344),
    [sym_field] = STATE(5344),
    [sym_cast] = STATE(5344),
    [sym_substring] = STATE(5344),
    [sym_quantified_comparison] = STATE(5344),
    [sym_trim] = STATE(5344),
    [sym_invocation] = STATE(5183),
    [sym__extract_invocation] = STATE(5299),
    [sym__array_invocation] = STATE(5297),
    [sym_window_function] = STATE(5344),
    [sym__invocation_params] = STATE(7965),
    [sym_unnest_operator] = STATE(3643),
    [sym_unnest_clause] = STATE(5344),
    [sym_between] = STATE(5344),
    [sym_interval] = STATE(5338),
    [sym__expression] = STATE(5001),
    [sym_predicate] = STATE(5344),
    [sym_binary_expression] = STATE(5344),
    [sym_field_access] = STATE(5344),
    [sym_element_access] = STATE(5344),
    [sym_subquery] = STATE(5344),
    [sym_list] = STATE(5344),
    [sym_query_parameter] = STATE(5338),
    [sym_literal] = STATE(5344),
    [sym_json] = STATE(5338),
    [sym__number] = STATE(5338),
    [sym__float] = STATE(5348),
    [sym_string] = STATE(5338),
    [sym__type_struct] = STATE(8273),
    [sym__type_array] = STATE(7819),
    [sym_array] = STATE(5338),
    [sym_struct] = STATE(5338),
    [sym_current_date] = STATE(5344),
    [sym_current_time] = STATE(5344),
    [sym_current_timestamp] = STATE(5344),
    [sym__identifier] = STATE(5160),
    [sym__dotted_identifier] = STATE(7094),
    [sym_identifier] = STATE(5703),
    [aux_sym_identifier_repeat1] = STATE(6795),
    [sym__unquoted_identifier] = ACTIONS(339),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(341),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(343),
    [aux_sym_keyword_true_token1] = ACTIONS(345),
    [aux_sym_keyword_false_token1] = ACTIONS(347),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(349),
    [aux_sym_keyword_date_token1] = ACTIONS(351),
    [aux_sym_keyword_datetime_token1] = ACTIONS(353),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(355),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(357),
    [anon_sym_STAR] = ACTIONS(261),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(359),
    [sym_right_paren] = ACTIONS(399),
    [anon_sym_QMARK] = ACTIONS(363),
    [anon_sym_DOLLAR] = ACTIONS(365),
    [anon_sym_TILDE] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(369),
    [anon_sym_LBRACK] = ACTIONS(371),
    [sym_system_variable] = ACTIONS(373),
    [sym__named_query_parameter] = ACTIONS(375),
    [sym__positional_query_parameter] = ACTIONS(375),
    [sym_hex] = ACTIONS(373),
    [sym__integer] = ACTIONS(377),
    [aux_sym__float_token1] = ACTIONS(379),
    [aux_sym__float_token2] = ACTIONS(381),
    [aux_sym__float_token3] = ACTIONS(379),
    [sym__quoted_identifier] = ACTIONS(383),
    [sym__string_start] = ACTIONS(385),
  },
  [52] = {
    [sym_keyword_extract] = STATE(8479),
    [sym_keyword_unnest] = STATE(7694),
    [sym_keyword_distinct] = STATE(78),
    [sym_keyword_cast] = STATE(8480),
    [sym_keyword_safe_cast] = STATE(8480),
    [sym_keyword_case] = STATE(104),
    [sym_keyword_substring] = STATE(8481),
    [sym_keyword_not] = STATE(365),
    [sym_keyword_exists] = STATE(7591),
    [sym_keyword_all] = STATE(77),
    [sym_keyword_trim] = STATE(8271),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6839),
    [sym_keyword_any] = STATE(7593),
    [sym_keyword_some] = STATE(7593),
    [sym_keyword_current_date] = STATE(5301),
    [sym_keyword_current_time] = STATE(7816),
    [sym_keyword_current_timestamp] = STATE(7817),
    [sym_keyword_null] = STATE(5338),
    [sym_keyword_true] = STATE(5338),
    [sym_keyword_false] = STATE(5338),
    [sym_keyword_decimal] = STATE(7371),
    [sym_keyword_bigdecimal] = STATE(7371),
    [sym_keyword_numeric] = STATE(7371),
    [sym_keyword_bignumeric] = STATE(7371),
    [sym_keyword_json] = STATE(7594),
    [sym_keyword_interval] = STATE(504),
    [sym_keyword_time] = STATE(5060),
    [sym_keyword_date] = STATE(5060),
    [sym_keyword_datetime] = STATE(5060),
    [sym_keyword_timestamp] = STATE(5060),
    [sym_keyword_timestamptz] = STATE(5060),
    [sym_wildcard] = STATE(8190),
    [sym__time_types] = STATE(5060),
    [sym_numeric] = STATE(5338),
    [sym__argument] = STATE(6207),
    [sym_date] = STATE(5344),
    [sym_parameter] = STATE(5344),
    [sym_case] = STATE(5344),
    [sym_field] = STATE(5344),
    [sym_cast] = STATE(5344),
    [sym_substring] = STATE(5344),
    [sym_quantified_comparison] = STATE(5344),
    [sym_trim] = STATE(5344),
    [sym_invocation] = STATE(5183),
    [sym__extract_invocation] = STATE(5299),
    [sym__array_invocation] = STATE(5297),
    [sym_window_function] = STATE(5344),
    [sym__invocation_params] = STATE(8189),
    [sym_unnest_operator] = STATE(3643),
    [sym_unnest_clause] = STATE(5344),
    [sym_between] = STATE(5344),
    [sym_interval] = STATE(5338),
    [sym__expression] = STATE(5001),
    [sym_predicate] = STATE(5344),
    [sym_binary_expression] = STATE(5344),
    [sym_field_access] = STATE(5344),
    [sym_element_access] = STATE(5344),
    [sym_subquery] = STATE(5344),
    [sym_list] = STATE(5344),
    [sym_query_parameter] = STATE(5338),
    [sym_literal] = STATE(5344),
    [sym_json] = STATE(5338),
    [sym__number] = STATE(5338),
    [sym__float] = STATE(5348),
    [sym_string] = STATE(5338),
    [sym__type_struct] = STATE(8273),
    [sym__type_array] = STATE(7819),
    [sym_array] = STATE(5338),
    [sym_struct] = STATE(5338),
    [sym_current_date] = STATE(5344),
    [sym_current_time] = STATE(5344),
    [sym_current_timestamp] = STATE(5344),
    [sym__identifier] = STATE(5160),
    [sym__dotted_identifier] = STATE(7094),
    [sym_identifier] = STATE(5703),
    [aux_sym_identifier_repeat1] = STATE(6795),
    [sym__unquoted_identifier] = ACTIONS(339),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(341),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(343),
    [aux_sym_keyword_true_token1] = ACTIONS(345),
    [aux_sym_keyword_false_token1] = ACTIONS(347),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(349),
    [aux_sym_keyword_date_token1] = ACTIONS(351),
    [aux_sym_keyword_datetime_token1] = ACTIONS(353),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(355),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(357),
    [anon_sym_STAR] = ACTIONS(261),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(359),
    [sym_right_paren] = ACTIONS(401),
    [anon_sym_QMARK] = ACTIONS(363),
    [anon_sym_DOLLAR] = ACTIONS(365),
    [anon_sym_TILDE] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(369),
    [anon_sym_LBRACK] = ACTIONS(371),
    [sym_system_variable] = ACTIONS(373),
    [sym__named_query_parameter] = ACTIONS(375),
    [sym__positional_query_parameter] = ACTIONS(375),
    [sym_hex] = ACTIONS(373),
    [sym__integer] = ACTIONS(377),
    [aux_sym__float_token1] = ACTIONS(379),
    [aux_sym__float_token2] = ACTIONS(381),
    [aux_sym__float_token3] = ACTIONS(379),
    [sym__quoted_identifier] = ACTIONS(383),
    [sym__string_start] = ACTIONS(385),
  },
  [53] = {
    [sym_keyword_extract] = STATE(8479),
    [sym_keyword_unnest] = STATE(7694),
    [sym_keyword_distinct] = STATE(81),
    [sym_keyword_cast] = STATE(8480),
    [sym_keyword_safe_cast] = STATE(8480),
    [sym_keyword_case] = STATE(104),
    [sym_keyword_substring] = STATE(8481),
    [sym_keyword_not] = STATE(365),
    [sym_keyword_exists] = STATE(7591),
    [sym_keyword_all] = STATE(79),
    [sym_keyword_trim] = STATE(8271),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6839),
    [sym_keyword_any] = STATE(7593),
    [sym_keyword_some] = STATE(7593),
    [sym_keyword_current_date] = STATE(5301),
    [sym_keyword_current_time] = STATE(7816),
    [sym_keyword_current_timestamp] = STATE(7817),
    [sym_keyword_null] = STATE(5338),
    [sym_keyword_true] = STATE(5338),
    [sym_keyword_false] = STATE(5338),
    [sym_keyword_decimal] = STATE(7371),
    [sym_keyword_bigdecimal] = STATE(7371),
    [sym_keyword_numeric] = STATE(7371),
    [sym_keyword_bignumeric] = STATE(7371),
    [sym_keyword_json] = STATE(7594),
    [sym_keyword_interval] = STATE(504),
    [sym_keyword_time] = STATE(5060),
    [sym_keyword_date] = STATE(5060),
    [sym_keyword_datetime] = STATE(5060),
    [sym_keyword_timestamp] = STATE(5060),
    [sym_keyword_timestamptz] = STATE(5060),
    [sym_wildcard] = STATE(7864),
    [sym__time_types] = STATE(5060),
    [sym_numeric] = STATE(5338),
    [sym__argument] = STATE(6207),
    [sym_date] = STATE(5344),
    [sym_parameter] = STATE(5344),
    [sym_case] = STATE(5344),
    [sym_field] = STATE(5344),
    [sym_cast] = STATE(5344),
    [sym_substring] = STATE(5344),
    [sym_quantified_comparison] = STATE(5344),
    [sym_trim] = STATE(5344),
    [sym_invocation] = STATE(5183),
    [sym__extract_invocation] = STATE(5299),
    [sym__array_invocation] = STATE(5297),
    [sym_window_function] = STATE(5344),
    [sym__invocation_params] = STATE(7859),
    [sym_unnest_operator] = STATE(3643),
    [sym_unnest_clause] = STATE(5344),
    [sym_between] = STATE(5344),
    [sym_interval] = STATE(5338),
    [sym__expression] = STATE(5001),
    [sym_predicate] = STATE(5344),
    [sym_binary_expression] = STATE(5344),
    [sym_field_access] = STATE(5344),
    [sym_element_access] = STATE(5344),
    [sym_subquery] = STATE(5344),
    [sym_list] = STATE(5344),
    [sym_query_parameter] = STATE(5338),
    [sym_literal] = STATE(5344),
    [sym_json] = STATE(5338),
    [sym__number] = STATE(5338),
    [sym__float] = STATE(5348),
    [sym_string] = STATE(5338),
    [sym__type_struct] = STATE(8273),
    [sym__type_array] = STATE(7819),
    [sym_array] = STATE(5338),
    [sym_struct] = STATE(5338),
    [sym_current_date] = STATE(5344),
    [sym_current_time] = STATE(5344),
    [sym_current_timestamp] = STATE(5344),
    [sym__identifier] = STATE(5160),
    [sym__dotted_identifier] = STATE(7094),
    [sym_identifier] = STATE(5703),
    [aux_sym_identifier_repeat1] = STATE(6795),
    [sym__unquoted_identifier] = ACTIONS(339),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(341),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(343),
    [aux_sym_keyword_true_token1] = ACTIONS(345),
    [aux_sym_keyword_false_token1] = ACTIONS(347),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(349),
    [aux_sym_keyword_date_token1] = ACTIONS(351),
    [aux_sym_keyword_datetime_token1] = ACTIONS(353),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(355),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(357),
    [anon_sym_STAR] = ACTIONS(261),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(359),
    [sym_right_paren] = ACTIONS(403),
    [anon_sym_QMARK] = ACTIONS(363),
    [anon_sym_DOLLAR] = ACTIONS(365),
    [anon_sym_TILDE] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(369),
    [anon_sym_LBRACK] = ACTIONS(371),
    [sym_system_variable] = ACTIONS(373),
    [sym__named_query_parameter] = ACTIONS(375),
    [sym__positional_query_parameter] = ACTIONS(375),
    [sym_hex] = ACTIONS(373),
    [sym__integer] = ACTIONS(377),
    [aux_sym__float_token1] = ACTIONS(379),
    [aux_sym__float_token2] = ACTIONS(381),
    [aux_sym__float_token3] = ACTIONS(379),
    [sym__quoted_identifier] = ACTIONS(383),
    [sym__string_start] = ACTIONS(385),
  },
  [54] = {
    [sym_keyword_extract] = STATE(8479),
    [sym_keyword_unnest] = STATE(7694),
    [sym_keyword_distinct] = STATE(59),
    [sym_keyword_cast] = STATE(8480),
    [sym_keyword_safe_cast] = STATE(8480),
    [sym_keyword_case] = STATE(104),
    [sym_keyword_substring] = STATE(8481),
    [sym_keyword_not] = STATE(365),
    [sym_keyword_exists] = STATE(7591),
    [sym_keyword_all] = STATE(61),
    [sym_keyword_trim] = STATE(8271),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6839),
    [sym_keyword_any] = STATE(7593),
    [sym_keyword_some] = STATE(7593),
    [sym_keyword_current_date] = STATE(5301),
    [sym_keyword_current_time] = STATE(7816),
    [sym_keyword_current_timestamp] = STATE(7817),
    [sym_keyword_null] = STATE(5338),
    [sym_keyword_true] = STATE(5338),
    [sym_keyword_false] = STATE(5338),
    [sym_keyword_decimal] = STATE(7371),
    [sym_keyword_bigdecimal] = STATE(7371),
    [sym_keyword_numeric] = STATE(7371),
    [sym_keyword_bignumeric] = STATE(7371),
    [sym_keyword_json] = STATE(7594),
    [sym_keyword_interval] = STATE(504),
    [sym_keyword_time] = STATE(5060),
    [sym_keyword_date] = STATE(5060),
    [sym_keyword_datetime] = STATE(5060),
    [sym_keyword_timestamp] = STATE(5060),
    [sym_keyword_timestamptz] = STATE(5060),
    [sym_wildcard] = STATE(8264),
    [sym__time_types] = STATE(5060),
    [sym_numeric] = STATE(5338),
    [sym__argument] = STATE(6207),
    [sym_date] = STATE(5344),
    [sym_parameter] = STATE(5344),
    [sym_case] = STATE(5344),
    [sym_field] = STATE(5344),
    [sym_cast] = STATE(5344),
    [sym_substring] = STATE(5344),
    [sym_quantified_comparison] = STATE(5344),
    [sym_trim] = STATE(5344),
    [sym_invocation] = STATE(5183),
    [sym__extract_invocation] = STATE(5299),
    [sym__array_invocation] = STATE(5297),
    [sym_window_function] = STATE(5344),
    [sym__invocation_params] = STATE(8374),
    [sym_unnest_operator] = STATE(3643),
    [sym_unnest_clause] = STATE(5344),
    [sym_between] = STATE(5344),
    [sym_interval] = STATE(5338),
    [sym__expression] = STATE(5001),
    [sym_predicate] = STATE(5344),
    [sym_binary_expression] = STATE(5344),
    [sym_field_access] = STATE(5344),
    [sym_element_access] = STATE(5344),
    [sym_subquery] = STATE(5344),
    [sym_list] = STATE(5344),
    [sym_query_parameter] = STATE(5338),
    [sym_literal] = STATE(5344),
    [sym_json] = STATE(5338),
    [sym__number] = STATE(5338),
    [sym__float] = STATE(5348),
    [sym_string] = STATE(5338),
    [sym__type_struct] = STATE(8273),
    [sym__type_array] = STATE(7819),
    [sym_array] = STATE(5338),
    [sym_struct] = STATE(5338),
    [sym_current_date] = STATE(5344),
    [sym_current_time] = STATE(5344),
    [sym_current_timestamp] = STATE(5344),
    [sym__identifier] = STATE(5160),
    [sym__dotted_identifier] = STATE(7094),
    [sym_identifier] = STATE(5703),
    [aux_sym_identifier_repeat1] = STATE(6795),
    [sym__unquoted_identifier] = ACTIONS(339),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(341),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(343),
    [aux_sym_keyword_true_token1] = ACTIONS(345),
    [aux_sym_keyword_false_token1] = ACTIONS(347),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(349),
    [aux_sym_keyword_date_token1] = ACTIONS(351),
    [aux_sym_keyword_datetime_token1] = ACTIONS(353),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(355),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(357),
    [anon_sym_STAR] = ACTIONS(261),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(359),
    [sym_right_paren] = ACTIONS(405),
    [anon_sym_QMARK] = ACTIONS(363),
    [anon_sym_DOLLAR] = ACTIONS(365),
    [anon_sym_TILDE] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(369),
    [anon_sym_LBRACK] = ACTIONS(371),
    [sym_system_variable] = ACTIONS(373),
    [sym__named_query_parameter] = ACTIONS(375),
    [sym__positional_query_parameter] = ACTIONS(375),
    [sym_hex] = ACTIONS(373),
    [sym__integer] = ACTIONS(377),
    [aux_sym__float_token1] = ACTIONS(379),
    [aux_sym__float_token2] = ACTIONS(381),
    [aux_sym__float_token3] = ACTIONS(379),
    [sym__quoted_identifier] = ACTIONS(383),
    [sym__string_start] = ACTIONS(385),
  },
  [55] = {
    [sym_keyword_extract] = STATE(8479),
    [sym_keyword_unnest] = STATE(7694),
    [sym_keyword_distinct] = STATE(90),
    [sym_keyword_cast] = STATE(8480),
    [sym_keyword_safe_cast] = STATE(8480),
    [sym_keyword_case] = STATE(104),
    [sym_keyword_substring] = STATE(8481),
    [sym_keyword_not] = STATE(365),
    [sym_keyword_exists] = STATE(7591),
    [sym_keyword_all] = STATE(62),
    [sym_keyword_trim] = STATE(8271),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6839),
    [sym_keyword_any] = STATE(7593),
    [sym_keyword_some] = STATE(7593),
    [sym_keyword_current_date] = STATE(5301),
    [sym_keyword_current_time] = STATE(7816),
    [sym_keyword_current_timestamp] = STATE(7817),
    [sym_keyword_null] = STATE(5338),
    [sym_keyword_true] = STATE(5338),
    [sym_keyword_false] = STATE(5338),
    [sym_keyword_decimal] = STATE(7371),
    [sym_keyword_bigdecimal] = STATE(7371),
    [sym_keyword_numeric] = STATE(7371),
    [sym_keyword_bignumeric] = STATE(7371),
    [sym_keyword_json] = STATE(7594),
    [sym_keyword_interval] = STATE(504),
    [sym_keyword_time] = STATE(5060),
    [sym_keyword_date] = STATE(5060),
    [sym_keyword_datetime] = STATE(5060),
    [sym_keyword_timestamp] = STATE(5060),
    [sym_keyword_timestamptz] = STATE(5060),
    [sym_wildcard] = STATE(7908),
    [sym__time_types] = STATE(5060),
    [sym_numeric] = STATE(5338),
    [sym__argument] = STATE(6207),
    [sym_date] = STATE(5344),
    [sym_parameter] = STATE(5344),
    [sym_case] = STATE(5344),
    [sym_field] = STATE(5344),
    [sym_cast] = STATE(5344),
    [sym_substring] = STATE(5344),
    [sym_quantified_comparison] = STATE(5344),
    [sym_trim] = STATE(5344),
    [sym_invocation] = STATE(5183),
    [sym__extract_invocation] = STATE(5299),
    [sym__array_invocation] = STATE(5297),
    [sym_window_function] = STATE(5344),
    [sym__invocation_params] = STATE(7907),
    [sym_unnest_operator] = STATE(3643),
    [sym_unnest_clause] = STATE(5344),
    [sym_between] = STATE(5344),
    [sym_interval] = STATE(5338),
    [sym__expression] = STATE(5001),
    [sym_predicate] = STATE(5344),
    [sym_binary_expression] = STATE(5344),
    [sym_field_access] = STATE(5344),
    [sym_element_access] = STATE(5344),
    [sym_subquery] = STATE(5344),
    [sym_list] = STATE(5344),
    [sym_query_parameter] = STATE(5338),
    [sym_literal] = STATE(5344),
    [sym_json] = STATE(5338),
    [sym__number] = STATE(5338),
    [sym__float] = STATE(5348),
    [sym_string] = STATE(5338),
    [sym__type_struct] = STATE(8273),
    [sym__type_array] = STATE(7819),
    [sym_array] = STATE(5338),
    [sym_struct] = STATE(5338),
    [sym_current_date] = STATE(5344),
    [sym_current_time] = STATE(5344),
    [sym_current_timestamp] = STATE(5344),
    [sym__identifier] = STATE(5160),
    [sym__dotted_identifier] = STATE(7094),
    [sym_identifier] = STATE(5703),
    [aux_sym_identifier_repeat1] = STATE(6795),
    [sym__unquoted_identifier] = ACTIONS(339),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(341),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(343),
    [aux_sym_keyword_true_token1] = ACTIONS(345),
    [aux_sym_keyword_false_token1] = ACTIONS(347),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(349),
    [aux_sym_keyword_date_token1] = ACTIONS(351),
    [aux_sym_keyword_datetime_token1] = ACTIONS(353),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(355),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(357),
    [anon_sym_STAR] = ACTIONS(261),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(359),
    [sym_right_paren] = ACTIONS(407),
    [anon_sym_QMARK] = ACTIONS(363),
    [anon_sym_DOLLAR] = ACTIONS(365),
    [anon_sym_TILDE] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(369),
    [anon_sym_LBRACK] = ACTIONS(371),
    [sym_system_variable] = ACTIONS(373),
    [sym__named_query_parameter] = ACTIONS(375),
    [sym__positional_query_parameter] = ACTIONS(375),
    [sym_hex] = ACTIONS(373),
    [sym__integer] = ACTIONS(377),
    [aux_sym__float_token1] = ACTIONS(379),
    [aux_sym__float_token2] = ACTIONS(381),
    [aux_sym__float_token3] = ACTIONS(379),
    [sym__quoted_identifier] = ACTIONS(383),
    [sym__string_start] = ACTIONS(385),
  },
  [56] = {
    [sym_keyword_extract] = STATE(8479),
    [sym_keyword_unnest] = STATE(7694),
    [sym_keyword_distinct] = STATE(67),
    [sym_keyword_cast] = STATE(8480),
    [sym_keyword_safe_cast] = STATE(8480),
    [sym_keyword_case] = STATE(104),
    [sym_keyword_substring] = STATE(8481),
    [sym_keyword_not] = STATE(365),
    [sym_keyword_exists] = STATE(7591),
    [sym_keyword_all] = STATE(70),
    [sym_keyword_trim] = STATE(8271),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6839),
    [sym_keyword_any] = STATE(7593),
    [sym_keyword_some] = STATE(7593),
    [sym_keyword_current_date] = STATE(5301),
    [sym_keyword_current_time] = STATE(7816),
    [sym_keyword_current_timestamp] = STATE(7817),
    [sym_keyword_null] = STATE(5338),
    [sym_keyword_true] = STATE(5338),
    [sym_keyword_false] = STATE(5338),
    [sym_keyword_decimal] = STATE(7371),
    [sym_keyword_bigdecimal] = STATE(7371),
    [sym_keyword_numeric] = STATE(7371),
    [sym_keyword_bignumeric] = STATE(7371),
    [sym_keyword_json] = STATE(7594),
    [sym_keyword_interval] = STATE(504),
    [sym_keyword_time] = STATE(5060),
    [sym_keyword_date] = STATE(5060),
    [sym_keyword_datetime] = STATE(5060),
    [sym_keyword_timestamp] = STATE(5060),
    [sym_keyword_timestamptz] = STATE(5060),
    [sym_wildcard] = STATE(8434),
    [sym__time_types] = STATE(5060),
    [sym_numeric] = STATE(5338),
    [sym__argument] = STATE(6207),
    [sym_date] = STATE(5344),
    [sym_parameter] = STATE(5344),
    [sym_case] = STATE(5344),
    [sym_field] = STATE(5344),
    [sym_cast] = STATE(5344),
    [sym_substring] = STATE(5344),
    [sym_quantified_comparison] = STATE(5344),
    [sym_trim] = STATE(5344),
    [sym_invocation] = STATE(5183),
    [sym__extract_invocation] = STATE(5299),
    [sym__array_invocation] = STATE(5297),
    [sym_window_function] = STATE(5344),
    [sym__invocation_params] = STATE(8438),
    [sym_unnest_operator] = STATE(3643),
    [sym_unnest_clause] = STATE(5344),
    [sym_between] = STATE(5344),
    [sym_interval] = STATE(5338),
    [sym__expression] = STATE(5001),
    [sym_predicate] = STATE(5344),
    [sym_binary_expression] = STATE(5344),
    [sym_field_access] = STATE(5344),
    [sym_element_access] = STATE(5344),
    [sym_subquery] = STATE(5344),
    [sym_list] = STATE(5344),
    [sym_query_parameter] = STATE(5338),
    [sym_literal] = STATE(5344),
    [sym_json] = STATE(5338),
    [sym__number] = STATE(5338),
    [sym__float] = STATE(5348),
    [sym_string] = STATE(5338),
    [sym__type_struct] = STATE(8273),
    [sym__type_array] = STATE(7819),
    [sym_array] = STATE(5338),
    [sym_struct] = STATE(5338),
    [sym_current_date] = STATE(5344),
    [sym_current_time] = STATE(5344),
    [sym_current_timestamp] = STATE(5344),
    [sym__identifier] = STATE(5160),
    [sym__dotted_identifier] = STATE(7094),
    [sym_identifier] = STATE(5703),
    [aux_sym_identifier_repeat1] = STATE(6795),
    [sym__unquoted_identifier] = ACTIONS(339),
    [aux_sym_keyword_extract_token1] = ACTIONS(49),
    [aux_sym_keyword_unnest_token1] = ACTIONS(51),
    [aux_sym_keyword_distinct_token1] = ACTIONS(143),
    [aux_sym_keyword_cast_token1] = ACTIONS(53),
    [aux_sym_keyword_safe_cast_token1] = ACTIONS(55),
    [aux_sym_keyword_case_token1] = ACTIONS(57),
    [aux_sym_keyword_substring_token1] = ACTIONS(59),
    [aux_sym_keyword_not_token1] = ACTIONS(61),
    [aux_sym_keyword_exists_token1] = ACTIONS(63),
    [aux_sym_keyword_all_token1] = ACTIONS(145),
    [aux_sym_keyword_trim_token1] = ACTIONS(69),
    [aux_sym_keyword_struct_token1] = ACTIONS(71),
    [aux_sym_keyword_array_token1] = ACTIONS(73),
    [aux_sym_keyword_any_token1] = ACTIONS(75),
    [aux_sym_keyword_some_token1] = ACTIONS(77),
    [aux_sym_keyword_current_date_token1] = ACTIONS(341),
    [aux_sym_keyword_current_time_token1] = ACTIONS(81),
    [aux_sym_keyword_current_timestamp_token1] = ACTIONS(83),
    [aux_sym_keyword_null_token1] = ACTIONS(343),
    [aux_sym_keyword_true_token1] = ACTIONS(345),
    [aux_sym_keyword_false_token1] = ACTIONS(347),
    [aux_sym_keyword_decimal_token1] = ACTIONS(91),
    [aux_sym_keyword_bigdecimal_token1] = ACTIONS(93),
    [aux_sym_keyword_numeric_token1] = ACTIONS(95),
    [aux_sym_keyword_bignumeric_token1] = ACTIONS(97),
    [aux_sym_keyword_json_token1] = ACTIONS(99),
    [aux_sym_keyword_interval_token1] = ACTIONS(101),
    [aux_sym_keyword_time_token1] = ACTIONS(349),
    [aux_sym_keyword_date_token1] = ACTIONS(351),
    [aux_sym_keyword_datetime_token1] = ACTIONS(353),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(355),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(357),
    [anon_sym_STAR] = ACTIONS(261),
    [sym_comment] = ACTIONS(3),
    [sym_left_paren] = ACTIONS(359),
    [sym_right_paren] = ACTIONS(409),
    [anon_sym_QMARK] = ACTIONS(363),
    [anon_sym_DOLLAR] = ACTIONS(365),
    [anon_sym_TILDE] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(369),
    [anon_sym_LBRACK] = ACTIONS(371),
    [sym_system_variable] = ACTIONS(373),
    [sym__named_query_parameter] = ACTIONS(375),
    [sym__positional_query_parameter] = ACTIONS(375),
    [sym_hex] = ACTIONS(373),
    [sym__integer] = ACTIONS(377),
    [aux_sym__float_token1] = ACTIONS(379),
    [aux_sym__float_token2] = ACTIONS(381),
    [aux_sym__float_token3] = ACTIONS(379),
    [sym__quoted_identifier] = ACTIONS(383),
    [sym__string_start] = ACTIONS(385),
  },
  [57] = {
    [sym_keyword_extract] = STATE(8479),
    [sym_keyword_unnest] = STATE(7694),
    [sym_keyword_distinct] = STATE(80),
    [sym_keyword_cast] = STATE(8480),
    [sym_keyword_safe_cast] = STATE(8480),
    [sym_keyword_case] = STATE(104),
    [sym_keyword_substring] = STATE(8481),
    [sym_keyword_not] = STATE(365),
    [sym_keyword_exists] = STATE(7591),
    [sym_keyword_all] = STATE(82),
    [sym_keyword_trim] = STATE(8271),
    [sym_keyword_struct] = STATE(6013),
    [sym_keyword_array] = STATE(6839),
    [sym_keyword_any] = STATE(7593),
    [sym_keyword_some] = STATE(7593),
    [sym_keyword_current_date] = STATE(5301),
    [sym_keyword_current_time] = STATE(7816),
    [sym_keyword_current_timestamp] = STATE(7817),
    [sym_keyword_null] = STATE(5338),
    [sym_keyword_true] = STATE(5338),
    [sym_keyword_false] = STATE(5338),
    [sym_keyword_decimal] = STATE(7371),
    [sym_keyword_bigdecimal] = STATE(7371),
    [sym_keyword_numeric] = STATE(7371),
    [sym_keyword_bignumeric] = STATE(7371),
    [sym_keyword_json] = STATE(7594),
    [sym_keyword_interval] = STATE(504),
    [sym_keyword_time] = STATE(5060),
    [sym_keyword_date] = STATE(5060),
    [sym_keyword_datetime] = STATE(5060),
    [sym_keyword_timestamp] = STATE(5060),
    [sym_keyword_timestamptz] = STATE(5060),
    [sym_wildcard] = STATE(8239),
    [sym__time_types] = STATE(5060),
    [sym_numeric] = STATE(5338),
    [sym__argument] = STATE(6207),
    [sym_date] = STATE(5344),
    [sym_parameter] = STATE(5344),
    [sym_case] = STATE(5344),
    [sym_field] = STATE(5344),
    [sym_cast] = STATE(5344),
    [sym_substring] = STATE(5344),
    [sym_quantified_comparison] = STATE(5344),
    [sym_trim] = STATE(5344),
    [sym_invocation] = STATE(5183),
    [sym__extract_invocation] = STATE(5299),
    [sym__array_invocation] = STATE(5297),
    [sym_window_function] = STATE(5344),
    [sym__invocation_pa