"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Nodegroup = exports.TaintEffect = exports.CapacityType = exports.NodegroupAmiType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const cluster_1 = require("./cluster");
const eks_generated_1 = require("./eks.generated");
/**
 * The AMI type for your node group. GPU instance types should use the `AL2_x86_64_GPU` AMI type, which uses the
 * Amazon EKS-optimized Linux AMI with GPU support. Non-GPU instances should use the `AL2_x86_64` AMI type, which
 * uses the Amazon EKS-optimized Linux AMI.
 */
var NodegroupAmiType;
(function (NodegroupAmiType) {
    /**
     * Amazon Linux 2 (x86-64)
     */
    NodegroupAmiType["AL2_X86_64"] = "AL2_x86_64";
    /**
     * Amazon Linux 2 with GPU support
     */
    NodegroupAmiType["AL2_X86_64_GPU"] = "AL2_x86_64_GPU";
    /**
     * Amazon Linux 2 (ARM-64)
     */
    NodegroupAmiType["AL2_ARM_64"] = "AL2_ARM_64";
    /**
     *  Bottlerocket Linux(ARM-64)
     */
    NodegroupAmiType["BOTTLEROCKET_ARM_64"] = "BOTTLEROCKET_ARM_64";
    /**
     * Bottlerocket(x86-64)
     */
    NodegroupAmiType["BOTTLEROCKET_X86_64"] = "BOTTLEROCKET_x86_64";
})(NodegroupAmiType = exports.NodegroupAmiType || (exports.NodegroupAmiType = {}));
/**
 * Capacity type of the managed node group
 */
var CapacityType;
(function (CapacityType) {
    /**
     * spot instances
     */
    CapacityType["SPOT"] = "SPOT";
    /**
     * on-demand instances
     */
    CapacityType["ON_DEMAND"] = "ON_DEMAND";
})(CapacityType = exports.CapacityType || (exports.CapacityType = {}));
/**
 * Effect types of kubernetes node taint.
 */
var TaintEffect;
(function (TaintEffect) {
    /**
     * NoSchedule
     */
    TaintEffect["NO_SCHEDULE"] = "NO_SCHEDULE";
    /**
     * PreferNoSchedule
     */
    TaintEffect["PREFER_NO_SCHEDULE"] = "PREFER_NO_SCHEDULE";
    /**
     * NoExecute
     */
    TaintEffect["NO_EXECUTE"] = "NO_EXECUTE";
})(TaintEffect = exports.TaintEffect || (exports.TaintEffect = {}));
/**
 * The Nodegroup resource class
 */
class Nodegroup extends core_1.Resource {
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f, _g, _h, _j;
        super(scope, id, {
            physicalName: props.nodegroupName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_eks_NodegroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.cluster = props.cluster;
        this.desiredSize = (_c = (_b = props.desiredSize) !== null && _b !== void 0 ? _b : props.minSize) !== null && _c !== void 0 ? _c : 2;
        this.maxSize = (_d = props.maxSize) !== null && _d !== void 0 ? _d : this.desiredSize;
        this.minSize = (_e = props.minSize) !== null && _e !== void 0 ? _e : 1;
        core_1.withResolved(this.desiredSize, this.maxSize, (desired, max) => {
            if (desired === undefined) {
                return;
            }
            if (desired > max) {
                throw new Error(`Desired capacity ${desired} can't be greater than max size ${max}`);
            }
        });
        core_1.withResolved(this.desiredSize, this.minSize, (desired, min) => {
            if (desired === undefined) {
                return;
            }
            if (desired < min) {
                throw new Error(`Minimum capacity ${min} can't be greater than desired size ${desired}`);
            }
        });
        if (props.launchTemplateSpec && props.diskSize) {
            // see - https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html
            // and https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-disksize
            throw new Error('diskSize must be specified within the launch template');
        }
        if (props.instanceType && props.instanceTypes) {
            throw new Error('"instanceType is deprecated, please use "instanceTypes" only.');
        }
        if (props.instanceType) {
            core_1.Annotations.of(this).addWarning('"instanceType" is deprecated and will be removed in the next major version. please use "instanceTypes" instead');
        }
        const instanceTypes = (_f = props.instanceTypes) !== null && _f !== void 0 ? _f : (props.instanceType ? [props.instanceType] : undefined);
        let possibleAmiTypes = [];
        if (instanceTypes && instanceTypes.length > 0) {
            /**
             * if the user explicitly configured instance types, we can't caculate the expected ami type as we support
             * Amazon Linux 2 and Bottlerocket now. However we can check:
             *
             * 1. instance types of different CPU architectures are not mixed(e.g. X86 with ARM).
             * 2. user-specified amiType should be included in `possibleAmiTypes`.
             */
            possibleAmiTypes = getPossibleAmiTypes(instanceTypes);
            // if the user explicitly configured an ami type, make sure it's included in the possibleAmiTypes
            if (props.amiType && !possibleAmiTypes.includes(props.amiType)) {
                throw new Error(`The specified AMI does not match the instance types architecture, either specify one of ${possibleAmiTypes} or don't specify any`);
            }
        }
        if (!props.nodeRole) {
            const ngRole = new aws_iam_1.Role(this, 'NodeGroupRole', {
                assumedBy: new aws_iam_1.ServicePrincipal('ec2.amazonaws.com'),
            });
            ngRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonEKSWorkerNodePolicy'));
            ngRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonEKS_CNI_Policy'));
            ngRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonEC2ContainerRegistryReadOnly'));
            this.role = ngRole;
        }
        else {
            this.role = props.nodeRole;
        }
        const resource = new eks_generated_1.CfnNodegroup(this, 'Resource', {
            clusterName: this.cluster.clusterName,
            nodegroupName: props.nodegroupName,
            nodeRole: this.role.roleArn,
            subnets: this.cluster.vpc.selectSubnets(props.subnets).subnetIds,
            /**
             * Case 1: If launchTemplate is explicitly specified with custom AMI, we cannot specify amiType, or the node group deployment will fail.
             * As we don't know if the custom AMI is specified in the lauchTemplate, we just use props.amiType.
             *
             * Case 2: If launchTemplate is not specified, we try to determine amiType from the instanceTypes and it could be either AL2 or Bottlerocket.
             * To avoid breaking changes, we use possibleAmiTypes[0] if amiType is undefined and make sure AL2 is always the first element in possibleAmiTypes
             * as AL2 is previously the `expectedAmi` and this avoids breaking changes.
             *
             * That being said, users now either have to explicitly specify correct amiType or just leave it undefined.
             */
            amiType: props.launchTemplateSpec ? props.amiType : ((_g = props.amiType) !== null && _g !== void 0 ? _g : possibleAmiTypes[0]),
            capacityType: props.capacityType ? props.capacityType.valueOf() : undefined,
            diskSize: props.diskSize,
            forceUpdateEnabled: (_h = props.forceUpdate) !== null && _h !== void 0 ? _h : true,
            // note that we don't check if a launch template is configured here (even though it might configure instance types as well)
            // because this doesn't have a default value, meaning the user had to explicitly configure this.
            instanceTypes: instanceTypes === null || instanceTypes === void 0 ? void 0 : instanceTypes.map(t => t.toString()),
            labels: props.labels,
            taints: props.taints,
            launchTemplate: props.launchTemplateSpec,
            releaseVersion: props.releaseVersion,
            remoteAccess: props.remoteAccess ? {
                ec2SshKey: props.remoteAccess.sshKeyName,
                sourceSecurityGroups: props.remoteAccess.sourceSecurityGroups ?
                    props.remoteAccess.sourceSecurityGroups.map(m => m.securityGroupId) : undefined,
            } : undefined,
            scalingConfig: {
                desiredSize: this.desiredSize,
                maxSize: this.maxSize,
                minSize: this.minSize,
            },
            tags: props.tags,
        });
        // managed nodegroups update the `aws-auth` on creation, but we still need to track
        // its state for consistency.
        if (this.cluster instanceof cluster_1.Cluster) {
            // see https://docs.aws.amazon.com/en_us/eks/latest/userguide/add-user-role.html
            this.cluster.awsAuth.addRoleMapping(this.role, {
                username: 'system:node:{{EC2PrivateDNSName}}',
                groups: [
                    'system:bootstrappers',
                    'system:nodes',
                ],
            });
            // the controller runs on the worker nodes so they cannot
            // be deleted before the controller.
            (_j = this.cluster.albController) === null || _j === void 0 ? void 0 : _j.node.addDependency(this);
        }
        this.nodegroupArn = this.getResourceArnAttribute(resource.attrArn, {
            service: 'eks',
            resource: 'nodegroup',
            resourceName: this.physicalName,
        });
        this.nodegroupName = this.getResourceNameAttribute(resource.ref);
    }
    /**
     * Import the Nodegroup from attributes
     */
    static fromNodegroupName(scope, id, nodegroupName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.nodegroupName = nodegroupName;
            }
        }
        return new Import(scope, id);
    }
}
exports.Nodegroup = Nodegroup;
_a = JSII_RTTI_SYMBOL_1;
Nodegroup[_a] = { fqn: "@aws-cdk/aws-eks.Nodegroup", version: "1.159.0" };
/**
 * AMI types of different architectures. Make sure AL2 is always the first element, which will be the default
 * AmiType if amiType and launchTemplateSpec are both undefined.
 */
const arm64AmiTypes = [NodegroupAmiType.AL2_ARM_64, NodegroupAmiType.BOTTLEROCKET_ARM_64];
const x8664AmiTypes = [NodegroupAmiType.AL2_X86_64, NodegroupAmiType.BOTTLEROCKET_X86_64];
const gpuAmiTypes = [NodegroupAmiType.AL2_X86_64_GPU];
/**
 * This function check if the instanceType is GPU instance.
 * @param instanceType The EC2 instance type
 */
function isGpuInstanceType(instanceType) {
    // capture the family, generation, capabilities, and size portions of the instance type id
    const instanceTypeComponents = instanceType.toString().match(/^([a-z]+)(\d{1,2})([a-z]*)\.([a-z0-9]+)$/);
    if (instanceTypeComponents == null) {
        throw new Error('Malformed instance type identifier');
    }
    const family = instanceTypeComponents[1];
    return ['p', 'g', 'inf'].includes(family);
}
/**
 * This function examines the CPU architecture of every instance type and determines
 * what AMI types are compatible for all of them. it either throws or produces an array of possible AMI types because
 * instance types of different CPU architectures are not supported.
 * @param instanceTypes The instance types
 * @returns NodegroupAmiType[]
 */
function getPossibleAmiTypes(instanceTypes) {
    function typeToArch(instanceType) {
        return isGpuInstanceType(instanceType) ? 'GPU' : instanceType.architecture;
    }
    const archAmiMap = new Map([
        [aws_ec2_1.InstanceArchitecture.ARM_64, arm64AmiTypes],
        [aws_ec2_1.InstanceArchitecture.X86_64, x8664AmiTypes],
        ['GPU', gpuAmiTypes],
    ]);
    const architectures = new Set(instanceTypes.map(typeToArch));
    if (architectures.size === 0) { // protective code, the current implementation will never result in this.
        throw new Error(`Cannot determine any ami type comptaible with instance types: ${instanceTypes.map(i => i.toString).join(',')}`);
    }
    if (architectures.size > 1) {
        throw new Error('instanceTypes of different architectures is not allowed');
    }
    return archAmiMap.get(Array.from(architectures)[0]);
}
//# sourceMappingURL=data:application/json;base64,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