"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultiZoneInstance = exports.MultiZoneInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const lindorm_generated_1 = require("./lindorm.generated");
Object.defineProperty(exports, "MultiZoneInstanceProperty", { enumerable: true, get: function () { return lindorm_generated_1.RosMultiZoneInstance; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::Lindorm::MultiZoneInstance`, which is used to create a multi-zone Lindorm instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosMultiZoneInstance`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-lindorm-multizoneinstance
 */
class MultiZoneInstance extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosMultiZoneInstance = new lindorm_generated_1.RosMultiZoneInstance(this, id, {
            standbyZoneId: props.standbyZoneId,
            resourceGroupId: props.resourceGroupId,
            instanceChargeType: props.instanceChargeType === undefined || props.instanceChargeType === null ? 'POSTPAY' : props.instanceChargeType,
            logDiskCategory: props.logDiskCategory,
            standbyVSwitchId: props.standbyVSwitchId,
            solrNum: props.solrNum,
            solrSpec: props.solrSpec,
            coreSpec: props.coreSpec,
            filestoreSpec: props.filestoreSpec,
            tsdbNum: props.tsdbNum,
            arbiterZoneId: props.arbiterZoneId,
            streamSpec: props.streamSpec,
            primaryZoneId: props.primaryZoneId,
            multiZoneCombination: props.multiZoneCombination,
            coreSingleStorage: props.coreSingleStorage,
            streamNum: props.streamNum,
            coldStorage: props.coldStorage,
            logSpec: props.logSpec,
            diskCategory: props.diskCategory,
            period: props.period,
            primaryVSwitchId: props.primaryVSwitchId,
            arbiterVSwitchId: props.arbiterVSwitchId,
            instanceName: props.instanceName,
            vpcId: props.vpcId,
            filestoreNum: props.filestoreNum,
            securityIpList: props.securityIpList,
            lindormSpec: props.lindormSpec,
            tsdbSpec: props.tsdbSpec,
            logSingleStorage: props.logSingleStorage,
            lindormNum: props.lindormNum,
            logNum: props.logNum,
            periodUnit: props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosMultiZoneInstance;
        this.attrAuthInfos = rosMultiZoneInstance.attrAuthInfos;
        this.attrInstanceId = rosMultiZoneInstance.attrInstanceId;
        this.attrJdbcUrlList = rosMultiZoneInstance.attrJdbcUrlList;
    }
}
exports.MultiZoneInstance = MultiZoneInstance;
//# sourceMappingURL=data:application/json;base64,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