"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosMultiZoneInstance = exports.RosInstance = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('streamSpec', ros.validateString)(properties.streamSpec));
    errors.collect(ros.propertyValidator('instanceStorage', ros.validateNumber)(properties.instanceStorage));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('zoneId', ros.validateString)(properties.zoneId));
    if (properties.instanceChargeType && (typeof properties.instanceChargeType) !== 'object') {
        errors.collect(ros.propertyValidator('instanceChargeType', ros.validateAllowedValues)({
            data: properties.instanceChargeType,
            allowedValues: ["PayAsYouGo", "PostPaid", "PayOnDemand", "Postpaid", "PostPay", "Postpay", "POSTPAY", "POST", "Subscription", "PrePaid", "Prepaid", "PrePay", "Prepay", "PREPAY", "PRE"],
        }));
    }
    errors.collect(ros.propertyValidator('instanceChargeType', ros.validateString)(properties.instanceChargeType));
    if (properties.streamNum && (typeof properties.streamNum) !== 'object') {
        errors.collect(ros.propertyValidator('streamNum', ros.validateRange)({
            data: properties.streamNum,
            min: 0,
            max: 90,
        }));
    }
    errors.collect(ros.propertyValidator('streamNum', ros.validateNumber)(properties.streamNum));
    if (properties.coldStorage && (typeof properties.coldStorage) !== 'object') {
        errors.collect(ros.propertyValidator('coldStorage', ros.validateRange)({
            data: properties.coldStorage,
            min: 800,
            max: 1000000,
        }));
    }
    errors.collect(ros.propertyValidator('coldStorage', ros.validateNumber)(properties.coldStorage));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('diskCategory', ros.requiredValidator)(properties.diskCategory));
    if (properties.diskCategory && (typeof properties.diskCategory) !== 'object') {
        errors.collect(ros.propertyValidator('diskCategory', ros.validateAllowedValues)({
            data: properties.diskCategory,
            allowedValues: ["capacity_cloud_storage", "cloud_efficiency", "cloud_ssd", "local_hdd_pro", "local_ssd_pro"],
        }));
    }
    errors.collect(ros.propertyValidator('diskCategory', ros.validateString)(properties.diskCategory));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('instanceName', ros.requiredValidator)(properties.instanceName));
    errors.collect(ros.propertyValidator('instanceName', ros.validateString)(properties.instanceName));
    if (properties.solrNum && (typeof properties.solrNum) !== 'object') {
        errors.collect(ros.propertyValidator('solrNum', ros.validateRange)({
            data: properties.solrNum,
            min: 0,
            max: 60,
        }));
    }
    errors.collect(ros.propertyValidator('solrNum', ros.validateNumber)(properties.solrNum));
    errors.collect(ros.propertyValidator('solrSpec', ros.validateString)(properties.solrSpec));
    if (properties.filestoreNum && (typeof properties.filestoreNum) !== 'object') {
        errors.collect(ros.propertyValidator('filestoreNum', ros.validateRange)({
            data: properties.filestoreNum,
            min: 0,
            max: 60,
        }));
    }
    errors.collect(ros.propertyValidator('filestoreNum', ros.validateNumber)(properties.filestoreNum));
    errors.collect(ros.propertyValidator('vpcId', ros.requiredValidator)(properties.vpcId));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    errors.collect(ros.propertyValidator('securityIpList', ros.listValidator(ros.validateString))(properties.securityIpList));
    errors.collect(ros.propertyValidator('lindormSpec', ros.validateString)(properties.lindormSpec));
    errors.collect(ros.propertyValidator('tsdbSpec', ros.validateString)(properties.tsdbSpec));
    errors.collect(ros.propertyValidator('coreSpec', ros.validateString)(properties.coreSpec));
    if (properties.lindormNum && (typeof properties.lindormNum) !== 'object') {
        errors.collect(ros.propertyValidator('lindormNum', ros.validateRange)({
            data: properties.lindormNum,
            min: 0,
            max: 400,
        }));
    }
    errors.collect(ros.propertyValidator('lindormNum', ros.validateNumber)(properties.lindormNum));
    errors.collect(ros.propertyValidator('filestoreSpec', ros.validateString)(properties.filestoreSpec));
    if (properties.tsdbNum && (typeof properties.tsdbNum) !== 'object') {
        errors.collect(ros.propertyValidator('tsdbNum', ros.validateRange)({
            data: properties.tsdbNum,
            min: 0,
            max: 32,
        }));
    }
    errors.collect(ros.propertyValidator('tsdbNum', ros.validateNumber)(properties.tsdbNum));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["Month", "Year", "month", "year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    return errors.wrap('supplied properties not correct for "RosInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::Lindorm::Instance` resource
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::Lindorm::Instance` resource.
 */
// @ts-ignore TS6133
function rosInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosInstancePropsValidator(properties).assertSuccess();
    }
    return {
        'DiskCategory': ros.stringToRosTemplate(properties.diskCategory),
        'InstanceName': ros.stringToRosTemplate(properties.instanceName),
        'VpcId': ros.stringToRosTemplate(properties.vpcId),
        'ColdStorage': ros.numberToRosTemplate(properties.coldStorage),
        'CoreSpec': ros.stringToRosTemplate(properties.coreSpec),
        'FilestoreNum': ros.numberToRosTemplate(properties.filestoreNum),
        'FilestoreSpec': ros.stringToRosTemplate(properties.filestoreSpec),
        'InstanceChargeType': ros.stringToRosTemplate(properties.instanceChargeType),
        'InstanceStorage': ros.numberToRosTemplate(properties.instanceStorage),
        'LindormNum': ros.numberToRosTemplate(properties.lindormNum),
        'LindormSpec': ros.stringToRosTemplate(properties.lindormSpec),
        'Period': ros.numberToRosTemplate(properties.period),
        'PeriodUnit': ros.stringToRosTemplate(properties.periodUnit),
        'ResourceGroupId': ros.stringToRosTemplate(properties.resourceGroupId),
        'SecurityIpList': ros.listMapper(ros.stringToRosTemplate)(properties.securityIpList),
        'SolrNum': ros.numberToRosTemplate(properties.solrNum),
        'SolrSpec': ros.stringToRosTemplate(properties.solrSpec),
        'StreamNum': ros.numberToRosTemplate(properties.streamNum),
        'StreamSpec': ros.stringToRosTemplate(properties.streamSpec),
        'TsdbNum': ros.numberToRosTemplate(properties.tsdbNum),
        'TsdbSpec': ros.stringToRosTemplate(properties.tsdbSpec),
        'VSwitchId': ros.stringToRosTemplate(properties.vSwitchId),
        'ZoneId': ros.stringToRosTemplate(properties.zoneId),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::Lindorm::Instance`, which is used to create a Lindorm instance.
 * @Note This class does not contain additional functions, so it is recommended to use the `Instance` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-lindorm-instance
 */
class RosInstance extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAuthInfos = this.getAtt('AuthInfos');
        this.attrInstanceId = this.getAtt('InstanceId');
        this.attrJdbcUrlList = this.getAtt('JdbcUrlList');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.diskCategory = props.diskCategory;
        this.instanceName = props.instanceName;
        this.vpcId = props.vpcId;
        this.coldStorage = props.coldStorage;
        this.coreSpec = props.coreSpec;
        this.filestoreNum = props.filestoreNum;
        this.filestoreSpec = props.filestoreSpec;
        this.instanceChargeType = props.instanceChargeType;
        this.instanceStorage = props.instanceStorage;
        this.lindormNum = props.lindormNum;
        this.lindormSpec = props.lindormSpec;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.resourceGroupId = props.resourceGroupId;
        this.securityIpList = props.securityIpList;
        this.solrNum = props.solrNum;
        this.solrSpec = props.solrSpec;
        this.streamNum = props.streamNum;
        this.streamSpec = props.streamSpec;
        this.tsdbNum = props.tsdbNum;
        this.tsdbSpec = props.tsdbSpec;
        this.vSwitchId = props.vSwitchId;
        this.zoneId = props.zoneId;
    }
    get rosProperties() {
        return {
            diskCategory: this.diskCategory,
            instanceName: this.instanceName,
            vpcId: this.vpcId,
            coldStorage: this.coldStorage,
            coreSpec: this.coreSpec,
            filestoreNum: this.filestoreNum,
            filestoreSpec: this.filestoreSpec,
            instanceChargeType: this.instanceChargeType,
            instanceStorage: this.instanceStorage,
            lindormNum: this.lindormNum,
            lindormSpec: this.lindormSpec,
            period: this.period,
            periodUnit: this.periodUnit,
            resourceGroupId: this.resourceGroupId,
            securityIpList: this.securityIpList,
            solrNum: this.solrNum,
            solrSpec: this.solrSpec,
            streamNum: this.streamNum,
            streamSpec: this.streamSpec,
            tsdbNum: this.tsdbNum,
            tsdbSpec: this.tsdbSpec,
            vSwitchId: this.vSwitchId,
            zoneId: this.zoneId,
        };
    }
    renderProperties(props) {
        return rosInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosInstance = RosInstance;
/**
 * The resource type name for this resource class.
 */
RosInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::Lindorm::Instance";
/**
 * Determine whether the given properties match those of a `RosMultiZoneInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosMultiZoneInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosMultiZoneInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('standbyZoneId', ros.validateString)(properties.standbyZoneId));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    if (properties.instanceChargeType && (typeof properties.instanceChargeType) !== 'object') {
        errors.collect(ros.propertyValidator('instanceChargeType', ros.validateAllowedValues)({
            data: properties.instanceChargeType,
            allowedValues: ["PayAsYouGo", "PostPaid", "PayOnDemand", "Postpaid", "PostPay", "Postpay", "POSTPAY", "POST", "Subscription", "PrePaid", "Prepaid", "PrePay", "Prepay", "PREPAY", "PRE"],
        }));
    }
    errors.collect(ros.propertyValidator('instanceChargeType', ros.validateString)(properties.instanceChargeType));
    if (properties.logDiskCategory && (typeof properties.logDiskCategory) !== 'object') {
        errors.collect(ros.propertyValidator('logDiskCategory', ros.validateAllowedValues)({
            data: properties.logDiskCategory,
            allowedValues: ["cloud_efficiency", "cloud_essd"],
        }));
    }
    errors.collect(ros.propertyValidator('logDiskCategory', ros.validateString)(properties.logDiskCategory));
    errors.collect(ros.propertyValidator('standbyVSwitchId', ros.validateString)(properties.standbyVSwitchId));
    if (properties.solrNum && (typeof properties.solrNum) !== 'object') {
        errors.collect(ros.propertyValidator('solrNum', ros.validateRange)({
            data: properties.solrNum,
            min: 0,
            max: 60,
        }));
    }
    errors.collect(ros.propertyValidator('solrNum', ros.validateNumber)(properties.solrNum));
    errors.collect(ros.propertyValidator('solrSpec', ros.validateString)(properties.solrSpec));
    errors.collect(ros.propertyValidator('coreSpec', ros.validateString)(properties.coreSpec));
    errors.collect(ros.propertyValidator('filestoreSpec', ros.validateString)(properties.filestoreSpec));
    if (properties.tsdbNum && (typeof properties.tsdbNum) !== 'object') {
        errors.collect(ros.propertyValidator('tsdbNum', ros.validateRange)({
            data: properties.tsdbNum,
            min: 0,
            max: 32,
        }));
    }
    errors.collect(ros.propertyValidator('tsdbNum', ros.validateNumber)(properties.tsdbNum));
    errors.collect(ros.propertyValidator('arbiterZoneId', ros.validateString)(properties.arbiterZoneId));
    errors.collect(ros.propertyValidator('streamSpec', ros.validateString)(properties.streamSpec));
    errors.collect(ros.propertyValidator('primaryZoneId', ros.validateString)(properties.primaryZoneId));
    errors.collect(ros.propertyValidator('multiZoneCombination', ros.validateString)(properties.multiZoneCombination));
    if (properties.coreSingleStorage && (typeof properties.coreSingleStorage) !== 'object') {
        errors.collect(ros.propertyValidator('coreSingleStorage', ros.validateRange)({
            data: properties.coreSingleStorage,
            min: 400,
            max: 64000,
        }));
    }
    errors.collect(ros.propertyValidator('coreSingleStorage', ros.validateNumber)(properties.coreSingleStorage));
    if (properties.streamNum && (typeof properties.streamNum) !== 'object') {
        errors.collect(ros.propertyValidator('streamNum', ros.validateRange)({
            data: properties.streamNum,
            min: 0,
            max: 90,
        }));
    }
    errors.collect(ros.propertyValidator('streamNum', ros.validateNumber)(properties.streamNum));
    if (properties.coldStorage && (typeof properties.coldStorage) !== 'object') {
        errors.collect(ros.propertyValidator('coldStorage', ros.validateRange)({
            data: properties.coldStorage,
            min: 800,
            max: 1000000,
        }));
    }
    errors.collect(ros.propertyValidator('coldStorage', ros.validateNumber)(properties.coldStorage));
    errors.collect(ros.propertyValidator('logSpec', ros.validateString)(properties.logSpec));
    errors.collect(ros.propertyValidator('diskCategory', ros.requiredValidator)(properties.diskCategory));
    if (properties.diskCategory && (typeof properties.diskCategory) !== 'object') {
        errors.collect(ros.propertyValidator('diskCategory', ros.validateAllowedValues)({
            data: properties.diskCategory,
            allowedValues: ["capacity_cloud_storage", "cloud_efficiency", "cloud_ssd", "local_hdd_pro", "local_ssd_pro"],
        }));
    }
    errors.collect(ros.propertyValidator('diskCategory', ros.validateString)(properties.diskCategory));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('primaryVSwitchId', ros.validateString)(properties.primaryVSwitchId));
    errors.collect(ros.propertyValidator('arbiterVSwitchId', ros.validateString)(properties.arbiterVSwitchId));
    errors.collect(ros.propertyValidator('instanceName', ros.requiredValidator)(properties.instanceName));
    errors.collect(ros.propertyValidator('instanceName', ros.validateString)(properties.instanceName));
    errors.collect(ros.propertyValidator('vpcId', ros.requiredValidator)(properties.vpcId));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    if (properties.filestoreNum && (typeof properties.filestoreNum) !== 'object') {
        errors.collect(ros.propertyValidator('filestoreNum', ros.validateRange)({
            data: properties.filestoreNum,
            min: 0,
            max: 60,
        }));
    }
    errors.collect(ros.propertyValidator('filestoreNum', ros.validateNumber)(properties.filestoreNum));
    errors.collect(ros.propertyValidator('securityIpList', ros.listValidator(ros.validateString))(properties.securityIpList));
    errors.collect(ros.propertyValidator('lindormSpec', ros.validateString)(properties.lindormSpec));
    errors.collect(ros.propertyValidator('tsdbSpec', ros.validateString)(properties.tsdbSpec));
    if (properties.logSingleStorage && (typeof properties.logSingleStorage) !== 'object') {
        errors.collect(ros.propertyValidator('logSingleStorage', ros.validateRange)({
            data: properties.logSingleStorage,
            min: 400,
            max: 64000,
        }));
    }
    errors.collect(ros.propertyValidator('logSingleStorage', ros.validateNumber)(properties.logSingleStorage));
    if (properties.lindormNum && (typeof properties.lindormNum) !== 'object') {
        errors.collect(ros.propertyValidator('lindormNum', ros.validateRange)({
            data: properties.lindormNum,
            min: 0,
            max: 400,
        }));
    }
    errors.collect(ros.propertyValidator('lindormNum', ros.validateNumber)(properties.lindormNum));
    if (properties.logNum && (typeof properties.logNum) !== 'object') {
        errors.collect(ros.propertyValidator('logNum', ros.validateRange)({
            data: properties.logNum,
            min: 4,
            max: 400,
        }));
    }
    errors.collect(ros.propertyValidator('logNum', ros.validateNumber)(properties.logNum));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["Month", "Year", "month", "year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    return errors.wrap('supplied properties not correct for "RosMultiZoneInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::Lindorm::MultiZoneInstance` resource
 *
 * @param properties - the TypeScript properties of a `RosMultiZoneInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::Lindorm::MultiZoneInstance` resource.
 */
// @ts-ignore TS6133
function rosMultiZoneInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosMultiZoneInstancePropsValidator(properties).assertSuccess();
    }
    return {
        'DiskCategory': ros.stringToRosTemplate(properties.diskCategory),
        'InstanceName': ros.stringToRosTemplate(properties.instanceName),
        'VpcId': ros.stringToRosTemplate(properties.vpcId),
        'ArbiterVSwitchId': ros.stringToRosTemplate(properties.arbiterVSwitchId),
        'ArbiterZoneId': ros.stringToRosTemplate(properties.arbiterZoneId),
        'ColdStorage': ros.numberToRosTemplate(properties.coldStorage),
        'CoreSingleStorage': ros.numberToRosTemplate(properties.coreSingleStorage),
        'CoreSpec': ros.stringToRosTemplate(properties.coreSpec),
        'FilestoreNum': ros.numberToRosTemplate(properties.filestoreNum),
        'FilestoreSpec': ros.stringToRosTemplate(properties.filestoreSpec),
        'InstanceChargeType': ros.stringToRosTemplate(properties.instanceChargeType),
        'LindormNum': ros.numberToRosTemplate(properties.lindormNum),
        'LindormSpec': ros.stringToRosTemplate(properties.lindormSpec),
        'LogDiskCategory': ros.stringToRosTemplate(properties.logDiskCategory),
        'LogNum': ros.numberToRosTemplate(properties.logNum),
        'LogSingleStorage': ros.numberToRosTemplate(properties.logSingleStorage),
        'LogSpec': ros.stringToRosTemplate(properties.logSpec),
        'MultiZoneCombination': ros.stringToRosTemplate(properties.multiZoneCombination),
        'Period': ros.numberToRosTemplate(properties.period),
        'PeriodUnit': ros.stringToRosTemplate(properties.periodUnit),
        'PrimaryVSwitchId': ros.stringToRosTemplate(properties.primaryVSwitchId),
        'PrimaryZoneId': ros.stringToRosTemplate(properties.primaryZoneId),
        'ResourceGroupId': ros.stringToRosTemplate(properties.resourceGroupId),
        'SecurityIpList': ros.listMapper(ros.stringToRosTemplate)(properties.securityIpList),
        'SolrNum': ros.numberToRosTemplate(properties.solrNum),
        'SolrSpec': ros.stringToRosTemplate(properties.solrSpec),
        'StandbyVSwitchId': ros.stringToRosTemplate(properties.standbyVSwitchId),
        'StandbyZoneId': ros.stringToRosTemplate(properties.standbyZoneId),
        'StreamNum': ros.numberToRosTemplate(properties.streamNum),
        'StreamSpec': ros.stringToRosTemplate(properties.streamSpec),
        'TsdbNum': ros.numberToRosTemplate(properties.tsdbNum),
        'TsdbSpec': ros.stringToRosTemplate(properties.tsdbSpec),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::Lindorm::MultiZoneInstance`, which is used to create a multi-zone Lindorm instance.
 * @Note This class does not contain additional functions, so it is recommended to use the `MultiZoneInstance` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-lindorm-multizoneinstance
 */
class RosMultiZoneInstance extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosMultiZoneInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAuthInfos = this.getAtt('AuthInfos');
        this.attrInstanceId = this.getAtt('InstanceId');
        this.attrJdbcUrlList = this.getAtt('JdbcUrlList');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.diskCategory = props.diskCategory;
        this.instanceName = props.instanceName;
        this.vpcId = props.vpcId;
        this.arbiterVSwitchId = props.arbiterVSwitchId;
        this.arbiterZoneId = props.arbiterZoneId;
        this.coldStorage = props.coldStorage;
        this.coreSingleStorage = props.coreSingleStorage;
        this.coreSpec = props.coreSpec;
        this.filestoreNum = props.filestoreNum;
        this.filestoreSpec = props.filestoreSpec;
        this.instanceChargeType = props.instanceChargeType;
        this.lindormNum = props.lindormNum;
        this.lindormSpec = props.lindormSpec;
        this.logDiskCategory = props.logDiskCategory;
        this.logNum = props.logNum;
        this.logSingleStorage = props.logSingleStorage;
        this.logSpec = props.logSpec;
        this.multiZoneCombination = props.multiZoneCombination;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.primaryVSwitchId = props.primaryVSwitchId;
        this.primaryZoneId = props.primaryZoneId;
        this.resourceGroupId = props.resourceGroupId;
        this.securityIpList = props.securityIpList;
        this.solrNum = props.solrNum;
        this.solrSpec = props.solrSpec;
        this.standbyVSwitchId = props.standbyVSwitchId;
        this.standbyZoneId = props.standbyZoneId;
        this.streamNum = props.streamNum;
        this.streamSpec = props.streamSpec;
        this.tsdbNum = props.tsdbNum;
        this.tsdbSpec = props.tsdbSpec;
    }
    get rosProperties() {
        return {
            diskCategory: this.diskCategory,
            instanceName: this.instanceName,
            vpcId: this.vpcId,
            arbiterVSwitchId: this.arbiterVSwitchId,
            arbiterZoneId: this.arbiterZoneId,
            coldStorage: this.coldStorage,
            coreSingleStorage: this.coreSingleStorage,
            coreSpec: this.coreSpec,
            filestoreNum: this.filestoreNum,
            filestoreSpec: this.filestoreSpec,
            instanceChargeType: this.instanceChargeType,
            lindormNum: this.lindormNum,
            lindormSpec: this.lindormSpec,
            logDiskCategory: this.logDiskCategory,
            logNum: this.logNum,
            logSingleStorage: this.logSingleStorage,
            logSpec: this.logSpec,
            multiZoneCombination: this.multiZoneCombination,
            period: this.period,
            periodUnit: this.periodUnit,
            primaryVSwitchId: this.primaryVSwitchId,
            primaryZoneId: this.primaryZoneId,
            resourceGroupId: this.resourceGroupId,
            securityIpList: this.securityIpList,
            solrNum: this.solrNum,
            solrSpec: this.solrSpec,
            standbyVSwitchId: this.standbyVSwitchId,
            standbyZoneId: this.standbyZoneId,
            streamNum: this.streamNum,
            streamSpec: this.streamSpec,
            tsdbNum: this.tsdbNum,
            tsdbSpec: this.tsdbSpec,
        };
    }
    renderProperties(props) {
        return rosMultiZoneInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosMultiZoneInstance = RosMultiZoneInstance;
/**
 * The resource type name for this resource class.
 */
RosMultiZoneInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::Lindorm::MultiZoneInstance";
//# sourceMappingURL=data:application/json;base64,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