# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Stripe(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'end_ms': 'int',
        'image_link': 'str',
        'model': 'str',
        'start_ms': 'int'
    }

    attribute_map = {
        'end_ms': 'endMs',
        'image_link': 'imageLink',
        'model': 'model',
        'start_ms': 'startMs'
    }

    def __init__(self, end_ms=None, image_link=None, model=None, start_ms=None):  # noqa: E501
        """Stripe - a model defined in Swagger"""  # noqa: E501

        self._end_ms = None
        self._image_link = None
        self._model = None
        self._start_ms = None
        self.discriminator = None

        self.end_ms = end_ms
        self.image_link = image_link
        self.model = model
        self.start_ms = start_ms

    @property
    def end_ms(self):
        """Gets the end_ms of this Stripe.  # noqa: E501

        endMs for this stripe  # noqa: E501

        :return: The end_ms of this Stripe.  # noqa: E501
        :rtype: int
        """
        return self._end_ms

    @end_ms.setter
    def end_ms(self, end_ms):
        """Sets the end_ms of this Stripe.

        endMs for this stripe  # noqa: E501

        :param end_ms: The end_ms of this Stripe.  # noqa: E501
        :type: int
        """
        if end_ms is None:
            raise ValueError("Invalid value for `end_ms`, must not be `None`")  # noqa: E501

        self._end_ms = end_ms

    @property
    def image_link(self):
        """Gets the image_link of this Stripe.  # noqa: E501

        image link for this stripe  # noqa: E501

        :return: The image_link of this Stripe.  # noqa: E501
        :rtype: str
        """
        return self._image_link

    @image_link.setter
    def image_link(self, image_link):
        """Sets the image_link of this Stripe.

        image link for this stripe  # noqa: E501

        :param image_link: The image_link of this Stripe.  # noqa: E501
        :type: str
        """
        if image_link is None:
            raise ValueError("Invalid value for `image_link`, must not be `None`")  # noqa: E501

        self._image_link = image_link

    @property
    def model(self):
        """Gets the model of this Stripe.  # noqa: E501

        model for this stripe  # noqa: E501

        :return: The model of this Stripe.  # noqa: E501
        :rtype: str
        """
        return self._model

    @model.setter
    def model(self, model):
        """Sets the model of this Stripe.

        model for this stripe  # noqa: E501

        :param model: The model of this Stripe.  # noqa: E501
        :type: str
        """
        if model is None:
            raise ValueError("Invalid value for `model`, must not be `None`")  # noqa: E501

        self._model = model

    @property
    def start_ms(self):
        """Gets the start_ms of this Stripe.  # noqa: E501

        startMs for this stripe  # noqa: E501

        :return: The start_ms of this Stripe.  # noqa: E501
        :rtype: int
        """
        return self._start_ms

    @start_ms.setter
    def start_ms(self, start_ms):
        """Sets the start_ms of this Stripe.

        startMs for this stripe  # noqa: E501

        :param start_ms: The start_ms of this Stripe.  # noqa: E501
        :type: int
        """
        if start_ms is None:
            raise ValueError("Invalid value for `start_ms`, must not be `None`")  # noqa: E501

        self._start_ms = start_ms

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Stripe, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Stripe):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
