# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class KubernetesComponent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'last_updated': 'int',
        'name': 'str',
        'status': 'dict(str, ComponentStatus)'
    }

    attribute_map = {
        'last_updated': 'lastUpdated',
        'name': 'name',
        'status': 'status'
    }

    def __init__(self, last_updated=None, name=None, status=None):  # noqa: E501
        """KubernetesComponent - a model defined in Swagger"""  # noqa: E501

        self._last_updated = None
        self._name = None
        self._status = None
        self.discriminator = None

        if last_updated is not None:
            self.last_updated = last_updated
        if name is not None:
            self.name = name
        if status is not None:
            self.status = status

    @property
    def last_updated(self):
        """Gets the last_updated of this KubernetesComponent.  # noqa: E501


        :return: The last_updated of this KubernetesComponent.  # noqa: E501
        :rtype: int
        """
        return self._last_updated

    @last_updated.setter
    def last_updated(self, last_updated):
        """Sets the last_updated of this KubernetesComponent.


        :param last_updated: The last_updated of this KubernetesComponent.  # noqa: E501
        :type: int
        """

        self._last_updated = last_updated

    @property
    def name(self):
        """Gets the name of this KubernetesComponent.  # noqa: E501


        :return: The name of this KubernetesComponent.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this KubernetesComponent.


        :param name: The name of this KubernetesComponent.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def status(self):
        """Gets the status of this KubernetesComponent.  # noqa: E501


        :return: The status of this KubernetesComponent.  # noqa: E501
        :rtype: dict(str, ComponentStatus)
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this KubernetesComponent.


        :param status: The status of this KubernetesComponent.  # noqa: E501
        :type: dict(str, ComponentStatus)
        """

        self._status = status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(KubernetesComponent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, KubernetesComponent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
