# Ctrl4BI 
[![Downloads](http://pepy.tech/badge/ctrl4bi)](http://pepy.tech/project/ctrl4bi)

#### This is a helper package for Business Intelligence solutions.

For documentation, please read [HELP.md](https://github.com/vkreat-tech/ctrl4bi/blob/master/HELP.md)

For demo on usage, please check [README.ipynb](https://github.com/vkreat-tech/ctrl4bi/blob/master/README.ipynb)


#### Contact Developer: [Shaji](https://www.linkedin.com/in/shaji-james/)

## Highlights
- Connector for AWS S3 - Bulk Download Files/Directories in S3 Bucket
- PII/PHI scrubbing - Removes occurrences of SSN / Driver License / Account Numbers etc from texts
- ETL testing - Column Level Check
- Parse JSON files

## Dependencies

Ctrl4BI requires:

* Python 3 (tested under Python 3.8)

## Installation

The easiest way to install the latest release version of Ctrl4BI is via ```pip```:
```bash
pip install ctrl4bi
```
In case you get ```ERROR: Could not install packages due to an EnvironmentError```, try using
```bash
pip install ctrl4bi --user
```
Check for the latest available version in [Ctrl4BI](https://pypi.org/project/ctrl4bi/)

## Import

Import any module from the package thru the following method:
```bash
from ctrl4bi import cleanser
```
```bash
from ctrl4bi import etl_testing
```

## Learn to use

Understand what each functions does by using ```help()```:
```bash
help(cleanser.scrub_pii)
```

## ChangeLog

- Sort and Compare two datasets (When joining is not possible)
- Flatten JSON & Dictionary
- Connector for AWS S3

## ToDo

- Connectors for various data sources
- Relationalize Unstructured Data
