YARP 3.0.0 (2018-06-11)                                                {#v3_0_0}
=======================

[TOC]

YARP 3.0.0 Release Notes
========================


A (partial) list of bug fixed and issues resolved in this release can be found
[here](https://github.com/robotology/yarp/issues?q=label%3A%22Fixed+in%3A+YARP+v3.0.0%22).


Important Changes
-----------------

* All YARP libraries can now be modified and distributed under the terms of the
  BSD-3-Clause license. See the accompanying LICENSE file for details.
* Visual Studio 2013 is no longer supported.
* CMake 3.5 or later is now required.
* Optional dependency on YCM now requires version 0.8.0 or later.
* All the functionalities deprecated before YARP 2.3.72 were removed.


### Build System

* The `CREATE_DEVICE_LIBRARY_MODULES` option was renamed
  `YARP_COMPILE_DEVICE_PLUGINS` and is now enabled by default.
* The `CREATE_OPTIONAL_CARRIERS` option was renamed
  `YARP_COMPILE_CARRIER_PLUGINS` and is now enabled by default.
* YARP now accepts the keyboard `COMPONENTS` in `find_package(YARP)` calls.
  The `YARP_LIBRARIES` variable contains only the libraries corresponding to the
  components requested in the last `find_package(YARP)` call.
  If no components are specified, the `OS`, `sig`, `dev` and `math` (only when
  enabled) components are searched.
* The `YARP_INCLUDE_DIRS` variable is deprecated, as it is handled automatically
  by CMake targets.
* The `YARP_MATH_LIBRARY` is deprecated.
  You can check for YARP_math using `find_package(YARP COMPONENTS math)`


### Libraries

#### `YARP_conf`

* The `YARP_WRAP_STL_STRING` and `YARP_WRAP_STL_STRING_INLINE` are now
  always undefined, and they are now considered deprecated.

#### `YARP_OS`

* The `shmem` carrier is no longer builtin inside `YARP_OS` and it is now a
  plugin.
* The `Run` class was moved to the new library `YARP_run`
* `yarp::os::setprogname()` is now deprecated.
* `yarp::os::getprogname()` is now deprecated.
* `yarp::os::SystemInfo::getProcessInfo()` now returns info for current process
  when called without arguments.
* The methods `yarp::os::Mutex::tryLock()` and
  `yarp::os::RecursiveMutex::tryLock()` were deprecated in favour of
  `try_lock()`.
* `ConstString` is now deprecated in favour of `std::string`.
* Replaced `YARP_INT{8,16,32,64}` with `std::int{8,16,32,64}_t` from `cstdint`
* Use defines from `cinttypes` instead of `YARP_INT64_FMT`
* Add `yarp::conf::float{32,64,128}_t` (128 only if supported)
* Add `yarp::conf::ssize_t`
* Deprecate `YARP_INT{8,16,32,64}` in favour of `std::int{8,16,32,64}_t`
* Deprecate `YARP_FLOAT{32,64}` in favour of `yarp::conf::float{32,64}_t`
* Deprecate `YARP_INT64_FMT` in favour of `PRId64`
* Deprecate `YARP_CONF_SSIZE_T` in favour of `yarp::conf::ssize_t`
* Add the following methods:
  * `yarp::os::Bottle::addInt{8,16,32,64}()`
  * `yarp::os::Bottle::addFloat{32,64}()`
  * `yarp::os::Value::{is,as,make}Int{8,16,32,64}()`
  * `yarp::os::Value::{is,as,make}Float{32,64}()`
  * `yarp::os::ConnectionWriter::appendInt{8,16,32,64}()`
  * `yarp::os::ConnectionWriter::appendFloat{32,64}()`
  * `yarp::os::ConnectionReader::expectInt{8,16,32,64}()`
  * `yarp::os::ConnectionReader::expectFloat{32,64}()`
  * `BOTTLE_TAG_INT{8,16,32,64}` (`BOTTLE_TAG_INT32` = `BOTTLE_TAG_INT`)
  * `BOTTLE_TAG_FLOAT{32,64}` (`BOTTLE_TAG_FLOAT64` = `BOTTLE_TAG_DOUBLE`)
* The following methods are not deprecated due to the large codebase where they
  are used, but their usage in new code is discouraged, and it is forbidden
  inside YARP.
  Anyway, all these methods are now calling the corresponding Int32 and Float64
  version, but are not architecture safe, since they still accept `int` and
  `double`.
  * `yarp::os::Bottle::addInt()`
  * `yarp::os::Bottle::addDouble()`
  * `yarp::os::Value::isInt()`
  * `yarp::os::Value::isDouble()`
  * `yarp::os::Value::asInt()`
  * `yarp::os::Value::asDouble()`
  * `yarp::os::Value::makeInt()`
  * `yarp::os::Value::makeDouble()`
  * `yarp::os::ConnectionWriter::appendInt()`
  * `yarp::os::ConnectionWriter::appendDouble()`
  * `yarp::os::ConnectionReader::expectInt()`
  * `yarp::os::ConnectionReader::expectDouble()`
  * `BOTTLE_TAG_INT`
  * `BOTTLE_TAG_DOUBLE`
* Value constructors are now explicit.
* `Thread` `setOptions()` and `setDefaultStackSize()` are now deprecated and
  no longer doing anything.
* The `YARP_STACK_SIZE` environment variable is no longer used.
* `Portable::getType()` became `Portable::getType() const`(#1617).
* `PortWriter::getWriteType()` became `PortWriter::getWriteType() const`(#1621).
* `PortReader::getReadType()` became `PortReader::getReadType() const`(#1616).
* `Companion` has been moved to a dedicated library (#1509). As consequences:
  * Following functions has been moved from `Companion` to `NetworkBase`:
    `disconnectInput`, `poll`, `sendMessage`, `wait` (`wait()` has been split
    into two new functions `waitConnection()` and `waitPort()`.
  * `Companion::exists()` has been removed unifying its code with
    `NetworkBase::exists()`.
  * `readString()` function has been deprecated in `NetworkBase`.
* `RateThread` has been deprecated in favour of the new class `PeriodicThread`.
  Note that `RateThread` used the period in msec(int), `PeriodicThread`
  requires the period in sec(double), so remember to consider a x1000 factor
  when migrate the code.
* Several methods in public interfaces have a slightly different signature (see
  #1738 for details).
* It is now possible to write a `const Portable` on a `Port`.
* `const Bytes` and `const ManagedBytes` can no longer return non-const pointers
  to the underlying data.

#### `YARP_dev`

* The `serial` device is no longer a plugin, but it is automatically built with
  `YARP_dev`.
* The following devices are no longer built with `YARP_dev` and are now plugins:
  * `ServerSoundGrabber`
  * `BatteryClient`
  * `BatteryWrapper`
  * `FrameTransformClient`
  * `FrameTransformServer`
  * `Localization2DClient`
  * `Map2DClient`
  * `Map2DServer`
  * `Navigation2DClient`
  * `Rangefinder2DClient`
  * `Rangefinder2DWrapper`
* The following headers were removed:
  * `/yarp/dev/DeviceGroup.h`
  * `/yarp/dev/DevicePipe.h`
  * `/yarp/dev/IKinectDeviceDriver.h`
  * `/yarp/dev/IOpenNI2DeviceDriver.h`
  * `/yarp/dev/RemoteFrameGrabber.h`
  * `/yarp/dev/ServerFrameGrabber.h`
  * `/yarp/dev/ServerSerial.h`
  * `/yarp/dev/ServerSoundGrabber.h`
  * `/yarp/dev/TestMotor.h`
  * `/yarp/dev/RemoteFrameGrabberDC1394.h`
* A class of interfaces to wrap multiple analog sensors is now available in:
  * `/yarp/dev/MultipleAnalogSensorsInterfaces.h`
* The devices `multipleanalogsensorsserver`, `multipleanalogsensorsclient` and
  `multipleanalogsensorsremapper` are available for exposing and accessing the
  multiple analog sensors over a network, and for combining multiple devices in
  a single device (*remapper*).
* Major changes to IPidControlImpl.cpp to allow conversion of PID gains from
  metric to machine units.
* Major changes to `TorqueControlImpl` to allow conversion of `bemf`, `ktau`
  parameters from metric to machine units.
* Major changes to `ControlBoardHelper` classes, implementation is now contained
  in a separate `.cpp` file. Removed inline functions.
* Added file `PidEnums.h`
* Added missing method `setNominalCurrentRaw()` to `IAmplifierControl`
  interface.
* Removed all control board interfaces methods e.g. `setTorquePid()`,
  `setPositionMode()` etc, marked as deprecated since 2.3.70
* In ControlBoardWrapper functions for all joints invoke the equivalent function
  for all joints of motion control device. In the   previous versions, that
  function call the equivalent function single-joint in a for-cicle, so the
  function for all joints in motion control devices have never been called.
  So please, check the implementation of function for all joints in your motion
  control device because now they will be invoked for the first time.
* The following classes have been deprecated:
  - `ICalibrateControl2` in favour of `ICalibrateControl`.
  - `ICalibrateControl2Raw` in favour of `ICalibrateControlRaw`.
  - `IFrameGrabberControl2` in favour of `IFrameGrabberControl.`
  - `FrameGrabberControl2Impl` in favour of `FrameGrabberControlImpl`
  - `IControlLimits2` in favour of `IControlLimits`.
  - `IControlLimits2Raw` in favour of `IControlLimitsRaw`.
  - `ImplementControlLimits2` in favour of `ImplementControlLimits`.
  - `IControlMode2` in favour of `IControlMode`.
  - `IControlMode2Raw` in favour of `IControlModeRaw`.
  - `ImplementControlMode2` in favour of `ImplementControlMode`.
  - `IPositionControl2Raw` in favour of `IPositionControlRaw`.
  - `IPositionControl2` in favour of `IPositionControl`.
  - `ImplementPositionControl2` in favour of `ImplementPositionControl`.
  - `IVelocityControl2Raw` in favour of `IVelocityControlRaw`.
  - `IVelocityControl2` in favour of `IVelocityControl`.
  - `ImplementVelocityControl2` in favour of `ImplementVelocityControl`.
* `IPositionDirectRaw::setPositionsRaw(const int, const int*, double*)` became
  `IPositionDirectRaw::setPositionsRaw(const int, const int*, const double*)`.
* `IPositionDirect::setPositions(const int, const int*, double*)` became
  `IPositionDirect::setPositions(const int, const int*, const double*)`(#1351).
* The file `yarp/dev/ControlBoardInterfacesImpl.inl` was renamed
  `yarp/dev/ControlBoardInterfacesImpl-inl.h`
* Several methods in public interfaces have a slightly different signature (see
  #1738 for details).

#### `YARP_sig`

* The file `yarp/sig/IplImage.h` is deprecated, use opencv headers instead.
* Added the `yarp::sig::PointCloud` class. See the documentation for details.
* if libjpeg is found, namespace yarp::sig::file implements a write method to
  save jpeg images.

#### `YARP_manager`

* The following headers were removed:
  * `/yarp/manager/ymm-dir.h`

#### `libyarpcxx`

* The `libyarpcxx` was removed.

#### `YARP_math`

* added new utility methods to Quaternion class.
* method toRotationMatrix() has been renamed to toRotationMatrix4x4() to avoid
  confusion with method toRotationMatrix3x3().
* operators for `yarp::math::<class>`es have been moved from the `yarp::math` to
  the global namespace.
* `libYARP_math` is now enabled by default if `Eigen3` is found.

#### `YARP_companion`

* new library created to isolate the old `yarp::os::Companion`.

### Tools

#### `yarpidl_thrift`

* Classes generated by yarpidl_thrift now transfer 8/16 bit integers using
  8/16 bits instead of 32. This makes it incompatible with YARP 2.

### Devices

* The following devices are no longer available in YARP, they will be
  available in the
  [yarp-deprecated-devices](https://github.com/robotology-legacy/yarp-deprecated-devices)
  repository:
  * cuda
  * nvidia
  * stage
  * vfw
  * wxsdl
  * jrkerr
  * urbtc
  * kinect
  * openni2
  * PumaCalibrator
  * meiMotionControl
  * microphone
  * dimax_u2c


New Features
------------

### Build System

* It is possible to have coloured output when running CMake, by setting the
  `CLICOLOR_FORCE=1` environment variable. This is not enabled by default
  because it is not GUI friendly.

### CMake Modules

#### `YarpPlugin`

* Added `OPTION`, `DEFAULT` and `DOC` options to `yarp_begin_plugin_library`.
  If the option is disabled, all plugins in the bundle are automatically
  disabled.
* Removed `VERBOSE` and `YarpPlugin_VERBOSE` options to `yarp_prepare_plugin`

### Libraries

* New auto-generated interface libraries for ros messages:
  * YARP_rosmsg_std_msgs
  * YARP_rosmsg_actionlib_msgs
  * YARP_rosmsg_diagnostic_msgs
  * YARP_rosmsg_geometry_msgs
  * YARP_rosmsg_nav_msgs
  * YARP_rosmsg_sensor_msgs
  * YARP_rosmsg_shape_msgs
  * YARP_rosmsg_stereo_msgs
  * YARP_rosmsg_trajectory_msgs
  * YARP_rosmsg_visualization_msgs
  * YARP_rosmsg_tf
  * YARP_rosmsg_tf2_msgs
  * YARP_rosmsg (includes all the other rosmsg libraries)

#### YARP_OS

* yarp::os::Mutex and yarp::os::RecursiveMutex now implement the
  [C++11 Mutex concept](http://en.cppreference.com/w/cpp/concept/Mutex).
* Added a Timer class to execute a static or member function in a separate
  thread after a period x, every y milliseconds, for z times or w seconds.
* Improved performance of tcp and fast_tcp carriers. TCP_NODELAY and TCP_CORK
  has been added in the `SocketTwoWayStream::open()`, in
  `SocketTwoWayStream::flush` is disabled and then re-enabled.
* Added `ResourceFinder::setDefault()` overloads for `int32_t` and `float64_t`.

#### YARP_sig

* `yarp::sig::file::[read|write](ImageOf<PixelFloat>&)` services
  refactored to store data in binary formats.

### Carriers

* `mjpeg` carrier is now compatible also with mono images.


### Tools

#### `yarpidl_thrift`

* Ported to thrift 0.11.0.

#### `yarpdatadumper`

* Added option --type image_jpg to save frames as jpeg images.

#### `yarpidl_rosmsg`

* Fixed verbose output.
* Added new --no-cache argument.
* Added new --no-index argument.
* Fixed generation when message files are in the msg folder.
* Added new --no-recurse argument. This option can be enabled when using
  `yarp_idl_to_dir` and `yarp_add_idl`, using the `NO_RECURSE` argument.
* Classes are now in the `yarp::rosmsg` namespace.
* Files are now in the `yarp/rosmsg` subfolder.
* `_indexALL.txt` files are generated only for the requested types.
* Old style files are still generated if `yarpidl_rosmsg` is not built with
  `YARP_NO_DEPRECATED` enabled, but they are considered deprecated.
* Only required included files are now included.
* Updated YarpIDL to support the new file names in `yarp_add_idl`.

### Devices

#### `ControlBoardWrapper`

* Added error code in attaching subdevices.
* Added realsense2 device.


### Bindings

#### IMotorEncoders interface bindings

* `IMotorEncoders` interface methods can be used to directly monitor the motor
  shaft position and speed or even to control the motor positions individually
  when estimating coupled motors friction parameters.
* Added bindings for the interface IMotorEncoders.
  The change extends the `yarp::dev::PolyDriver` and the
  `yarp::dev::IMotorEncoders` classes.


Bug Fixes
---------

### Libraries

#### `YARP_OS`

* Fixed race condition in yarp::os::Nodes.
* An `Int64` value no longer returns true when `isInt()` is called.

#### `GUIs`

* Made `yarpdataplayer` able to deal with `ImageOf<PixelFloat>` also with
  OpenCV.
* Fixed `yarpdataplayer` image overlapping.


Contributors
------------

This is a list of people that contributed to this release (generated from the
git history using `git shortlog -ens --no-merges v2.3.72..v3.0.0`):

```
   490	Daniele E. Domenichelli <daniele.domenichelli@iit.it>
   242	Nicolò Genesio <nicolo.genesio@iit.it>
    28	Marco Randazzo <marco.randazzo@iit.it>
    14	Juan G. Victores <jcgvicto@gmail.com>
    13	Silvio Traversaro <silvio.traversaro@iit.it>
    12	Alberto Cardellino <alberto.cardellino@iit.it>
    12	Valentina Gaggero <valentina.gaggero@iit.it>
    10	Andrea Ruzzenenti <andrea.ruzzenenti@iit.it>
     8	Damiano Enerli <damiano.enerli@iit.it>
     8	Ugo Pattacini <ugo.pattacini@iit.it>
     6	Nuno Guedelha <nuno.guedelha@iit.it>
     5	Matteo Brunettini <matteo.brunettini@iit.it>
     4	Bartek Łukawski <bwmn.peter@gmail.com>
     4	Lorenzo Rapetti <lorenzo.rapetti@iit.it>
     2	Claudio Fantacci <claudio.fantacci@iit.it>
     2	Prashanth Ramadoss <prashanth.ramadoss@iit.it>
     2	Yeshasvi Tirupachuri <yeshasvi.tirupachuri@iit.it>
     1	Bertrand Higy <bertrand.higy@iit.it>
     1	Vadim Tikhanoff <vadim.tikhanoff@iit.it>
```
