"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsDeploymentConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("../utils");
/**
 * A custom Deployment Configuration for an ECS Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom ECS Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class EcsDeploymentConfig {
    constructor() {
    }
    /**
     * Import a custom Deployment Configuration for an ECS Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct
     * @param _id the logical ID of this new Construct
     * @param ecsDeploymentConfigName the name of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static fromEcsDeploymentConfigName(_scope, _id, ecsDeploymentConfigName) {
        return deploymentConfig(ecsDeploymentConfigName);
    }
}
exports.EcsDeploymentConfig = EcsDeploymentConfig;
_a = JSII_RTTI_SYMBOL_1;
EcsDeploymentConfig[_a] = { fqn: "@aws-cdk/aws-codedeploy.EcsDeploymentConfig", version: "1.181.0" };
EcsDeploymentConfig.ALL_AT_ONCE = deploymentConfig('CodeDeployDefault.ECSAllAtOnce');
function deploymentConfig(name) {
    return {
        deploymentConfigName: name,
        deploymentConfigArn: utils_1.arnForDeploymentConfig(name),
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVwbG95bWVudC1jb25maWcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJkZXBsb3ltZW50LWNvbmZpZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLG9DQUFrRDtBQWdCbEQ7Ozs7Ozs7O0dBUUc7QUFDSCxNQUFhLG1CQUFtQjtJQWU5QjtLQUVDO0lBZEQ7Ozs7Ozs7T0FPRztJQUNJLE1BQU0sQ0FBQywyQkFBMkIsQ0FBQyxNQUFpQixFQUFFLEdBQVcsRUFBRSx1QkFBK0I7UUFDdkcsT0FBTyxnQkFBZ0IsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0tBQ2xEOztBQWJILGtEQWtCQzs7O0FBakJ3QiwrQkFBVyxHQUFHLGdCQUFnQixDQUFDLGdDQUFnQyxDQUFDLENBQUM7QUFtQjFGLFNBQVMsZ0JBQWdCLENBQUMsSUFBWTtJQUNwQyxPQUFPO1FBQ0wsb0JBQW9CLEVBQUUsSUFBSTtRQUMxQixtQkFBbUIsRUFBRSw4QkFBc0IsQ0FBQyxJQUFJLENBQUM7S0FDbEQsQ0FBQztBQUNKLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IGFybkZvckRlcGxveW1lbnRDb25maWcgfSBmcm9tICcuLi91dGlscyc7XG5cbi8qKlxuICogVGhlIERlcGxveW1lbnQgQ29uZmlndXJhdGlvbiBvZiBhbiBFQ1MgRGVwbG95bWVudCBHcm91cC5cbiAqIFRoZSBkZWZhdWx0LCBwcmUtZGVmaW5lZCBDb25maWd1cmF0aW9ucyBhcmUgYXZhaWxhYmxlIGFzIGNvbnN0YW50cyBvbiB0aGUge0BsaW5rIEVjc0RlcGxveW1lbnRDb25maWd9IGNsYXNzXG4gKiAoZm9yIGV4YW1wbGUsIGBFY3NEZXBsb3ltZW50Q29uZmlnLkFsbEF0T25jZWApLlxuICpcbiAqIE5vdGU6IENsb3VkRm9ybWF0aW9uIGRvZXMgbm90IGN1cnJlbnRseSBzdXBwb3J0IGNyZWF0aW5nIGN1c3RvbSBFQ1MgY29uZmlncyBvdXRzaWRlXG4gKiBvZiB1c2luZyBhIGN1c3RvbSByZXNvdXJjZS4gWW91IGNhbiBpbXBvcnQgY3VzdG9tIGRlcGxveW1lbnQgY29uZmlnIGNyZWF0ZWQgb3V0c2lkZSB0aGVcbiAqIENESyBvciB2aWEgYSBjdXN0b20gcmVzb3VyY2Ugd2l0aCB7QGxpbmsgRWNzRGVwbG95bWVudENvbmZpZyNmcm9tRWNzRGVwbG95bWVudENvbmZpZ05hbWV9LlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElFY3NEZXBsb3ltZW50Q29uZmlnIHtcbiAgcmVhZG9ubHkgZGVwbG95bWVudENvbmZpZ05hbWU6IHN0cmluZztcbiAgcmVhZG9ubHkgZGVwbG95bWVudENvbmZpZ0Fybjogc3RyaW5nO1xufVxuXG4vKipcbiAqIEEgY3VzdG9tIERlcGxveW1lbnQgQ29uZmlndXJhdGlvbiBmb3IgYW4gRUNTIERlcGxveW1lbnQgR3JvdXAuXG4gKlxuICogTm90ZTogVGhpcyBjbGFzcyBjdXJyZW50bHkgc3RhbmRzIGFzIG5hbWVzcGFjZWQgY29udGFpbmVyIG9mIHRoZSBkZWZhdWx0IGNvbmZpZ3VyYXRpb25zXG4gKiB1bnRpbCBDbG91ZEZvcm1hdGlvbiBzdXBwb3J0cyBjdXN0b20gRUNTIERlcGxveW1lbnQgQ29uZmlncy4gVW50aWwgdGhlbiBpdCBpcyBjbG9zZWRcbiAqIChwcml2YXRlIGNvbnN0cnVjdG9yKSBhbmQgZG9lcyBub3QgZXh0ZW5kIHtAbGluayBjZGsuQ29uc3RydWN0fVxuICpcbiAqIEByZXNvdXJjZSBBV1M6OkNvZGVEZXBsb3k6OkRlcGxveW1lbnRDb25maWdcbiAqL1xuZXhwb3J0IGNsYXNzIEVjc0RlcGxveW1lbnRDb25maWcge1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEFMTF9BVF9PTkNFID0gZGVwbG95bWVudENvbmZpZygnQ29kZURlcGxveURlZmF1bHQuRUNTQWxsQXRPbmNlJyk7XG5cbiAgLyoqXG4gICAqIEltcG9ydCBhIGN1c3RvbSBEZXBsb3ltZW50IENvbmZpZ3VyYXRpb24gZm9yIGFuIEVDUyBEZXBsb3ltZW50IEdyb3VwIGRlZmluZWQgb3V0c2lkZSB0aGUgQ0RLLlxuICAgKlxuICAgKiBAcGFyYW0gX3Njb3BlIHRoZSBwYXJlbnQgQ29uc3RydWN0IGZvciB0aGlzIG5ldyBDb25zdHJ1Y3RcbiAgICogQHBhcmFtIF9pZCB0aGUgbG9naWNhbCBJRCBvZiB0aGlzIG5ldyBDb25zdHJ1Y3RcbiAgICogQHBhcmFtIGVjc0RlcGxveW1lbnRDb25maWdOYW1lIHRoZSBuYW1lIG9mIHRoZSByZWZlcmVuY2VkIGN1c3RvbSBEZXBsb3ltZW50IENvbmZpZ3VyYXRpb25cbiAgICogQHJldHVybnMgYSBDb25zdHJ1Y3QgcmVwcmVzZW50aW5nIGEgcmVmZXJlbmNlIHRvIGFuIGV4aXN0aW5nIGN1c3RvbSBEZXBsb3ltZW50IENvbmZpZ3VyYXRpb25cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUVjc0RlcGxveW1lbnRDb25maWdOYW1lKF9zY29wZTogQ29uc3RydWN0LCBfaWQ6IHN0cmluZywgZWNzRGVwbG95bWVudENvbmZpZ05hbWU6IHN0cmluZyk6IElFY3NEZXBsb3ltZW50Q29uZmlnIHtcbiAgICByZXR1cm4gZGVwbG95bWVudENvbmZpZyhlY3NEZXBsb3ltZW50Q29uZmlnTmFtZSk7XG4gIH1cblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKCkge1xuICAgIC8vIG5vdGhpbmcgdG8gZG8gdW50aWwgQ0ZOIHN1cHBvcnRzIGN1c3RvbSBFQ1MgZGVwbG95bWVudCBjb25maWd1cmF0aW9uc1xuICB9XG59XG5cbmZ1bmN0aW9uIGRlcGxveW1lbnRDb25maWcobmFtZTogc3RyaW5nKTogSUVjc0RlcGxveW1lbnRDb25maWcge1xuICByZXR1cm4ge1xuICAgIGRlcGxveW1lbnRDb25maWdOYW1lOiBuYW1lLFxuICAgIGRlcGxveW1lbnRDb25maWdBcm46IGFybkZvckRlcGxveW1lbnRDb25maWcobmFtZSksXG4gIH07XG59XG4iXX0=