ERROR_CODES = {
    "200": "OK",
    "201": "Created",
    "202": "Accepted",
    "203": "Non-Authoritative Information",
    "204": "No Content",
    "205": "Reset Content",
    "206": "Partial Content",
    "300": "Multiple Choices",
    "301": "Moved Permanently",
    "302": "Found",
    "303": "See Other",
    "304": "Not Modified",
    "305": "Use Proxy",
    "307": "Temporary Redirect",
    "308": "Permanent Redirect",
    "400": "Bad Request",
    "401": "Unauthorized",
    "402": "Payment Required",
    "403": "Forbidden",
    "404": "Not Found",
    "405": "Method Not Allowed",
    "406": "Not Acceptable",
    "407": "Proxy Authentication Required",
    "408": "Request Timeout",
    "409": "Conflict",
    "410": "Gone",
    "411": "Length Required",
    "412": "Precondition Failed",
    "413": "Payload Too Large",
    "414": "URI Too Long",
    "415": "Unsupported Media Type",
    "416": "Requested Range Not Satisfiable",
    "417": "Expectation Failed",
    "418": "I'm a teapot",
    "421": "Misdirected Request",
    "422": "Unprocessable Entity",
    "423": "Locked",
    "424": "Failed Dependency",
    "426": "Upgrade Required",
    "428": "Precondition Required",
    "429": "Too Many Requests",
    "431": "Request Header Fields Too Large",
    "451": "Unavailable For Legal Reasons",
    "500": "Internal Server Error",
    "501": "Not Implemented",
    "502": "Bad Gateway",
    "503": "Service Unavailable",
    "504": "Gateway Timeout",
    "505": "HTTP Version Not Supported",
    "506": "Variant Also Negotiates",
    "507": "Insufficient Storage",
    "508": "Loop Detected",
    "510": "Not Extended",
    "511": "Network Authentication Required",
}

ERROR_CODE_DESCRIPTIONS = {
    "200": "The request has succeeded.",
    "201": "The request has been fulfilled and resulted in a new resource being created.",
    "202": "The request has been accepted for processing, but the processing has not been completed.",
    "203": "The returned meta-information is not the definitive set as available from the origin server.",
    "204": "The server has fulfilled the request but does not need to return an entity-body.",
    "205": "The server has fulfilled the request and the user agent SHOULD reset the document view which caused the request to be sent.",
    "206": "The server has fulfilled the partial GET request for the resource.",
    "300": "The requested resource corresponds to any one of multiple representations.",
    "301": "The requested resource has been assigned a new permanent URI and any future references to this resource SHOULD use one of the returned URIs.",
    "302": "The requested resource resides temporarily under a different URI.",
    "303": "The response to the request can be found under a different URI and SHOULD be retrieved using a GET method on that resource.",
    "304": "If the client has performed a conditional GET request and access is allowed, but the document has not been modified, the server SHOULD respond with this status code.",
    "305": "The requested resource MUST be accessed through the proxy given by the Location field.",
    "307": "The requested resource resides temporarily under a different URI.",
    "308": "The temporary URI SHOULD be used as long as the client continues to use the same URI to access the resource.",
    "400": "The request could not be understood by the server due to malformed syntax.",
    "400": "The request was malformed or missing required fields.",
    "401": "The request requires user authentication.",
    "402": "This code is reserved for future use.",
    "403": "The server has refused to fulfill the request.",
    "404": "The requested resource could not be found but may be available in the future. Subsequent requests by the client are permissible.",
    "405": "The method specified in the Request-Line is not allowed for the resource identified by the Request-URI.",
    "406": "The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.",
    "407": "This code is similar to 401 (Unauthorized), but indicates that the client must first authenticate itself with the proxy.",
    "408": "The client did not produce a request within the time that the server was prepared to wait.",
    "409": "The request could not be completed due to a conflict with the current state of the resource.",
    "410": "The requested resource is no longer available at the server and no forwarding address is known.",
    "411": "The server refuses to accept the request without a defined Content-Length.",
    "412": "The precondition given in one or more of the request-header fields evaluated to false when it was tested on the server.",
    "413": "The server is refusing to process a request because the request entity is larger than the server is willing or able to process.",
    "414": "The server is refusing to service the request because the Request-URI is longer than the server is willing to interpret.",
    "415": "The server is refusing to service the request because the entity of the request is in a format not supported by the requested resource for the requested method.",
    "416": "The server cannot serve the requested byte range.",
    "417": "The server could not meet the expectation given in the Expect request header.",
    "418": "This code is reserved for future use.",
    "421": "The request was directed at a server that is not able to produce a response.",
    "422": "The request was well-formed but was unable to be followed due to semantic errors.",
    "423": "The resource that is being accessed is locked.",
    "424": "The request failed due to failure of a previous request.",
    "426": "The server refuses to perform the request using the current protocol but might be willing to do so after the client upgrades to a different protocol.",
    "428": "The origin server requires the request to be conditional.",
    "429": "The user has sent too many requests in a given amount of time. Intended for use with rate limiting schemes.",
    "431": "The server is unwilling to process the request because its header fields are too large.",
    "451": "The server is denying access to the resource as a result of a legal demand.",
    "500": "The server encountered an unexpected condition that prevented it from fulfilling the request.",
    "501": "The server does not support the functionality required to fulfill the request.",
    "502": "The server, while acting as a gateway or proxy, received an invalid response from the upstream server it accessed in attempting to fulfill the request.",
    "503": "The server is currently unable to handle the request due to a temporary overloading or maintenance of the server.",
    "504": "The server, while acting as a gateway or proxy, did not receive a timely response from the upstream server specified by the URI.",
    "505": "The server does not support the HTTP protocol version used in the request.",
    "506": "The origin server is refusing to service the request because it is a country-locked IP address.",
    "507": "The server is unable to store the representation needed to complete the request.",
    "508": "The server detected an infinite loop while processing the request.",
    "510": "Further extensions to the request are required for the server to fulfill it.",
    "511": "The client needs to authenticate to gain network access.",
}


VALID_HEADERS = [
    "Accept",
    "Accept-Charset",
    "Accept-Encoding",
    "Accept-Language",
    "Accept-Ranges",
    "Age",
    "Allow",
    "Authorization",
    "Cache-Control",
    "Connection",
    "Content-Disposition",
    "Content-Encoding",
    "Content-Language",
    "Content-Length",
    "Content-Location",
    "Content-Range",
    "Content-Type",
    "Cookie",
    "Date",
    "ETag",
    "Expect",
    "Expires",
    "From",
    "Host",
    "If-Match",
    "If-Modified-Since",
    "If-None-Match",
    "If-Range",
    "If-Unmodified-Since",
    "Last-Modified",
    "Location",
    "Max-Forwards",
    "Origin",
    "Pragma",
    "Proxy-Authenticate",
    "Proxy-Authorization",
    "Range",
    "Referer",
    "Retry-After",
    "Server",
    "Set-Cookie",
    "TE",
    "Trailer",
    "Transfer-Encoding",
    "Upgrade",
    "User-Agent",
    "Vary",
    "Via",
    "Warning",
    "WWW-Authenticate",
]
