# Generated by Django 3.2.18 on 2023-04-04 17:44

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('openedx_ledger', '0005_help_text_and_more_indices'),
    ]

    operations = [
        migrations.CreateModel(
            name='ExternalFulfillmentProvider',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(
                    default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(
                    default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(db_index=True,
                 help_text='The name of the external reference type.', max_length=255, unique=True)),
                ('slug', models.SlugField(
                    help_text='The slug of the external reference type. This is typically the slugified name of the system that the reference is associated with.', max_length=32, unique=True)),
            ],
            options={
                'verbose_name': 'External Fulfillment provider',
                'verbose_name_plural': 'External fulfillment providers',
            },
        ),
        migrations.RemoveField(
            model_name='historicaltransaction',
            name='reference_id',
        ),
        migrations.RemoveField(
            model_name='historicaltransaction',
            name='reference_type',
        ),
        migrations.RemoveField(
            model_name='transaction',
            name='reference_id',
        ),
        migrations.RemoveField(
            model_name='transaction',
            name='reference_type',
        ),
        migrations.AddField(
            model_name='historicaltransaction',
            name='fulfillment_identifier',
            field=models.CharField(blank=True, db_index=True, help_text='The UUID identifier of the subsidized enrollment record for a learner generated durning the enrollmentcall made to enterprise/edx platform e.g. a LearnerCreditEnterpriseCourseEnrollment UUID.', max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='transaction',
            name='fulfillment_identifier',
            field=models.CharField(blank=True, db_index=True, help_text='The UUID identifier of the subsidized enrollment record for a learner generated durning the enrollmentcall made to enterprise/edx platform e.g. a LearnerCreditEnterpriseCourseEnrollment UUID.', max_length=255, null=True),
        ),
        migrations.CreateModel(
            name='ExternalTransactionReference',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(
                    default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(
                    default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('external_reference_id', models.CharField(db_index=True,
                 help_text='The identifier for the external reference operation. This is typically the name of the system that the reference is associated with.', max_length=255, primary_key=True, serialize=False)),
                ('external_fulfillment_provider', models.ForeignKey(help_text='The provider (source) of the external reference.',
                 on_delete=django.db.models.deletion.CASCADE, related_name='reference', to='openedx_ledger.externalfulfillmentprovider')),
                ('transaction', models.ForeignKey(help_text='The Transaction to which this external reference is associated.', null=True,
                 on_delete=django.db.models.deletion.CASCADE, related_name='external_reference', to='openedx_ledger.transaction')),
            ],
            options={
                'verbose_name': 'External Transaction Reference',
                'unique_together': {('external_reference_id', 'external_fulfillment_provider')},
            },
        ),
    ]
