"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DISCARD = exports.Errors = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Predefined error strings Error names in Amazon States Language - https://states-language.net/spec.html#appendix-a Error handling in Step Functions - https://docs.aws.amazon.com/step-functions/latest/dg/concepts-error-handling.html.
 *
 * @stability stable
 */
class Errors {
}
exports.Errors = Errors;
_a = JSII_RTTI_SYMBOL_1;
Errors[_a] = { fqn: "@aws-cdk/aws-stepfunctions.Errors", version: "1.139.0" };
/**
 * Matches any Error.
 *
 * @stability stable
 */
Errors.ALL = 'States.ALL';
/**
 * A Task State failed to heartbeat for a time longer than the “HeartbeatSeconds” value.
 *
 * @stability stable
 */
Errors.HEARTBEAT_TIMEOUT = 'States.HeartbeatTimeout';
/**
 * A Task State either ran longer than the “TimeoutSeconds” value, or failed to heartbeat for a time longer than the “HeartbeatSeconds” value.
 *
 * @stability stable
 */
Errors.TIMEOUT = 'States.Timeout';
/**
 * A Task State failed during the execution.
 *
 * @stability stable
 */
Errors.TASKS_FAILED = 'States.TaskFailed';
/**
 * A Task State failed because it had insufficient privileges to execute the specified code.
 *
 * @stability stable
 */
Errors.PERMISSIONS = 'States.Permissions';
/**
 * A Task State’s “ResultPath” field cannot be applied to the input the state received.
 *
 * @stability stable
 */
Errors.RESULT_PATH_MATCH_FAILURE = 'States.ResultPathMatchFailure';
/**
 * Within a state’s “Parameters” field, the attempt to replace a field whose name ends in “.$” using a Path failed.
 *
 * @stability stable
 */
Errors.PARAMETER_PATH_FAILURE = 'States.ParameterPathFailure';
/**
 * A branch of a Parallel state failed.
 *
 * @stability stable
 */
Errors.BRANCH_FAILED = 'States.BranchFailed';
/**
 * A Choice state failed to find a match for the condition field extracted from its input.
 *
 * @stability stable
 */
Errors.NO_CHOICE_MATCHED = 'States.NoChoiceMatched';
/**
 * Special string value to discard state input, output or result
 */
exports.DISCARD = 'DISCARD';
//# sourceMappingURL=data:application/json;base64,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