"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Condition = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A Condition for use in a Choice state branch.
 *
 * @stability stable
 */
class Condition {
    /**
     * Matches if variable is present.
     *
     * @stability stable
     */
    static isPresent(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsPresent, true);
    }
    /**
     * Matches if variable is not present.
     *
     * @stability stable
     */
    static isNotPresent(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsPresent, false);
    }
    /**
     * Matches if variable is a string.
     *
     * @stability stable
     */
    static isString(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsString, true);
    }
    /**
     * Matches if variable is not a string.
     *
     * @stability stable
     */
    static isNotString(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsString, false);
    }
    /**
     * Matches if variable is numeric.
     *
     * @stability stable
     */
    static isNumeric(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsNumeric, true);
    }
    /**
     * Matches if variable is not numeric.
     *
     * @stability stable
     */
    static isNotNumeric(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsNumeric, false);
    }
    /**
     * Matches if variable is boolean.
     *
     * @stability stable
     */
    static isBoolean(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsBoolean, true);
    }
    /**
     * Matches if variable is not boolean.
     *
     * @stability stable
     */
    static isNotBoolean(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsBoolean, false);
    }
    /**
     * Matches if variable is a timestamp.
     *
     * @stability stable
     */
    static isTimestamp(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsTimestamp, true);
    }
    /**
     * Matches if variable is not a timestamp.
     *
     * @stability stable
     */
    static isNotTimestamp(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsTimestamp, false);
    }
    /**
     * Matches if variable is not null.
     *
     * @stability stable
     */
    static isNotNull(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsNull, false);
    }
    /**
     * Matches if variable is Null.
     *
     * @stability stable
     */
    static isNull(variable) {
        return new VariableComparison(variable, ComparisonOperator.IsNull, true);
    }
    /**
     * Matches if a boolean field has the given value.
     *
     * @stability stable
     */
    static booleanEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.BooleanEquals, value);
    }
    /**
     * Matches if a boolean field equals to a value at a given mapping path.
     *
     * @stability stable
     */
    static booleanEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.BooleanEqualsPath, value);
    }
    /**
     * Matches if a string field equals to a value at a given mapping path.
     *
     * @stability stable
     */
    static stringEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringEqualsPath, value);
    }
    /**
     * Matches if a string field has the given value.
     *
     * @stability stable
     */
    static stringEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringEquals, value);
    }
    /**
     * Matches if a string field sorts before a given value.
     *
     * @stability stable
     */
    static stringLessThan(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringLessThan, value);
    }
    /**
     * Matches if a string field sorts before a given value at a particular mapping.
     *
     * @stability stable
     */
    static stringLessThanJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringLessThanPath, value);
    }
    /**
     * Matches if a string field sorts equal to or before a given value.
     *
     * @stability stable
     */
    static stringLessThanEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringLessThanEquals, value);
    }
    /**
     * Matches if a string field sorts equal to or before a given mapping.
     *
     * @stability stable
     */
    static stringLessThanEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringLessThanEqualsPath, value);
    }
    /**
     * Matches if a string field sorts after a given value.
     *
     * @stability stable
     */
    static stringGreaterThan(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringGreaterThan, value);
    }
    /**
     * Matches if a string field sorts after a value at a given mapping path.
     *
     * @stability stable
     */
    static stringGreaterThanJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringGreaterThanPath, value);
    }
    /**
     * Matches if a string field sorts after or equal to value at a given mapping path.
     *
     * @stability stable
     */
    static stringGreaterThanEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringGreaterThanEqualsPath, value);
    }
    /**
     * Matches if a string field sorts after or equal to a given value.
     *
     * @stability stable
     */
    static stringGreaterThanEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringGreaterThanEquals, value);
    }
    /**
     * Matches if a numeric field has the given value.
     *
     * @stability stable
     */
    static numberEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericEquals, value);
    }
    /**
     * Matches if a numeric field has the value in a given mapping path.
     *
     * @stability stable
     */
    static numberEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericEqualsPath, value);
    }
    /**
     * Matches if a numeric field is less than the given value.
     *
     * @stability stable
     */
    static numberLessThan(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericLessThan, value);
    }
    /**
     * Matches if a numeric field is less than the value at the given mapping path.
     *
     * @stability stable
     */
    static numberLessThanJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericLessThanPath, value);
    }
    /**
     * Matches if a numeric field is less than or equal to the given value.
     *
     * @stability stable
     */
    static numberLessThanEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericLessThanEquals, value);
    }
    /**
     * Matches if a numeric field is less than or equal to the numeric value at given mapping path.
     *
     * @stability stable
     */
    static numberLessThanEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericLessThanEqualsPath, value);
    }
    /**
     * Matches if a numeric field is greater than the given value.
     *
     * @stability stable
     */
    static numberGreaterThan(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericGreaterThan, value);
    }
    /**
     * Matches if a numeric field is greater than the value at a given mapping path.
     *
     * @stability stable
     */
    static numberGreaterThanJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericGreaterThanPath, value);
    }
    /**
     * Matches if a numeric field is greater than or equal to the given value.
     *
     * @stability stable
     */
    static numberGreaterThanEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericGreaterThanEquals, value);
    }
    /**
     * Matches if a numeric field is greater than or equal to the value at a given mapping path.
     *
     * @stability stable
     */
    static numberGreaterThanEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.NumericGreaterThanEqualsPath, value);
    }
    /**
     * Matches if a timestamp field is the same time as the given timestamp.
     *
     * @stability stable
     */
    static timestampEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampEquals, value);
    }
    /**
     * Matches if a timestamp field is the same time as the timestamp at a given mapping path.
     *
     * @stability stable
     */
    static timestampEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampEqualsPath, value);
    }
    /**
     * Matches if a timestamp field is before the given timestamp.
     *
     * @stability stable
     */
    static timestampLessThan(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampLessThan, value);
    }
    /**
     * Matches if a timestamp field is before the timestamp at a given mapping path.
     *
     * @stability stable
     */
    static timestampLessThanJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampLessThanPath, value);
    }
    /**
     * Matches if a timestamp field is before or equal to the given timestamp.
     *
     * @stability stable
     */
    static timestampLessThanEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampLessThanEquals, value);
    }
    /**
     * Matches if a timestamp field is before or equal to the timestamp at a given mapping path.
     *
     * @stability stable
     */
    static timestampLessThanEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampLessThanEqualsPath, value);
    }
    /**
     * Matches if a timestamp field is after the given timestamp.
     *
     * @stability stable
     */
    static timestampGreaterThan(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampGreaterThan, value);
    }
    /**
     * Matches if a timestamp field is after the timestamp at a given mapping path.
     *
     * @stability stable
     */
    static timestampGreaterThanJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampGreaterThanPath, value);
    }
    /**
     * Matches if a timestamp field is after or equal to the given timestamp.
     *
     * @stability stable
     */
    static timestampGreaterThanEquals(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampGreaterThanEquals, value);
    }
    /**
     * Matches if a timestamp field is after or equal to the timestamp at a given mapping path.
     *
     * @stability stable
     */
    static timestampGreaterThanEqualsJsonPath(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.TimestampGreaterThanEqualsPath, value);
    }
    /**
     * Matches if a field matches a string pattern that can contain a wild card (*) e.g: log-*.txt or *LATEST*. No other characters other than "*" have any special meaning - * can be escaped: \\*.
     *
     * @stability stable
     */
    static stringMatches(variable, value) {
        return new VariableComparison(variable, ComparisonOperator.StringMatches, value);
    }
    /**
     * Combine two or more conditions with a logical AND.
     *
     * @stability stable
     */
    static and(...conditions) {
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_Condition(conditions);
        return new CompoundCondition(CompoundOperator.And, ...conditions);
    }
    /**
     * Combine two or more conditions with a logical OR.
     *
     * @stability stable
     */
    static or(...conditions) {
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_Condition(conditions);
        return new CompoundCondition(CompoundOperator.Or, ...conditions);
    }
    /**
     * Negate a condition.
     *
     * @stability stable
     */
    static not(condition) {
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_Condition(condition);
        return new NotCondition(condition);
    }
}
exports.Condition = Condition;
_a = JSII_RTTI_SYMBOL_1;
Condition[_a] = { fqn: "@aws-cdk/aws-stepfunctions.Condition", version: "1.139.0" };
/**
 * Comparison Operator types
 */
var ComparisonOperator;
(function (ComparisonOperator) {
    ComparisonOperator[ComparisonOperator["StringEquals"] = 0] = "StringEquals";
    ComparisonOperator[ComparisonOperator["StringEqualsPath"] = 1] = "StringEqualsPath";
    ComparisonOperator[ComparisonOperator["StringLessThan"] = 2] = "StringLessThan";
    ComparisonOperator[ComparisonOperator["StringLessThanPath"] = 3] = "StringLessThanPath";
    ComparisonOperator[ComparisonOperator["StringGreaterThan"] = 4] = "StringGreaterThan";
    ComparisonOperator[ComparisonOperator["StringGreaterThanPath"] = 5] = "StringGreaterThanPath";
    ComparisonOperator[ComparisonOperator["StringLessThanEquals"] = 6] = "StringLessThanEquals";
    ComparisonOperator[ComparisonOperator["StringLessThanEqualsPath"] = 7] = "StringLessThanEqualsPath";
    ComparisonOperator[ComparisonOperator["StringGreaterThanEquals"] = 8] = "StringGreaterThanEquals";
    ComparisonOperator[ComparisonOperator["StringGreaterThanEqualsPath"] = 9] = "StringGreaterThanEqualsPath";
    ComparisonOperator[ComparisonOperator["NumericEquals"] = 10] = "NumericEquals";
    ComparisonOperator[ComparisonOperator["NumericEqualsPath"] = 11] = "NumericEqualsPath";
    ComparisonOperator[ComparisonOperator["NumericLessThan"] = 12] = "NumericLessThan";
    ComparisonOperator[ComparisonOperator["NumericLessThanPath"] = 13] = "NumericLessThanPath";
    ComparisonOperator[ComparisonOperator["NumericGreaterThan"] = 14] = "NumericGreaterThan";
    ComparisonOperator[ComparisonOperator["NumericGreaterThanPath"] = 15] = "NumericGreaterThanPath";
    ComparisonOperator[ComparisonOperator["NumericLessThanEquals"] = 16] = "NumericLessThanEquals";
    ComparisonOperator[ComparisonOperator["NumericLessThanEqualsPath"] = 17] = "NumericLessThanEqualsPath";
    ComparisonOperator[ComparisonOperator["NumericGreaterThanEquals"] = 18] = "NumericGreaterThanEquals";
    ComparisonOperator[ComparisonOperator["NumericGreaterThanEqualsPath"] = 19] = "NumericGreaterThanEqualsPath";
    ComparisonOperator[ComparisonOperator["BooleanEquals"] = 20] = "BooleanEquals";
    ComparisonOperator[ComparisonOperator["BooleanEqualsPath"] = 21] = "BooleanEqualsPath";
    ComparisonOperator[ComparisonOperator["TimestampEquals"] = 22] = "TimestampEquals";
    ComparisonOperator[ComparisonOperator["TimestampEqualsPath"] = 23] = "TimestampEqualsPath";
    ComparisonOperator[ComparisonOperator["TimestampLessThan"] = 24] = "TimestampLessThan";
    ComparisonOperator[ComparisonOperator["TimestampLessThanPath"] = 25] = "TimestampLessThanPath";
    ComparisonOperator[ComparisonOperator["TimestampGreaterThan"] = 26] = "TimestampGreaterThan";
    ComparisonOperator[ComparisonOperator["TimestampGreaterThanPath"] = 27] = "TimestampGreaterThanPath";
    ComparisonOperator[ComparisonOperator["TimestampLessThanEquals"] = 28] = "TimestampLessThanEquals";
    ComparisonOperator[ComparisonOperator["TimestampLessThanEqualsPath"] = 29] = "TimestampLessThanEqualsPath";
    ComparisonOperator[ComparisonOperator["TimestampGreaterThanEquals"] = 30] = "TimestampGreaterThanEquals";
    ComparisonOperator[ComparisonOperator["TimestampGreaterThanEqualsPath"] = 31] = "TimestampGreaterThanEqualsPath";
    ComparisonOperator[ComparisonOperator["IsNull"] = 32] = "IsNull";
    ComparisonOperator[ComparisonOperator["IsBoolean"] = 33] = "IsBoolean";
    ComparisonOperator[ComparisonOperator["IsNumeric"] = 34] = "IsNumeric";
    ComparisonOperator[ComparisonOperator["IsString"] = 35] = "IsString";
    ComparisonOperator[ComparisonOperator["IsTimestamp"] = 36] = "IsTimestamp";
    ComparisonOperator[ComparisonOperator["IsPresent"] = 37] = "IsPresent";
    ComparisonOperator[ComparisonOperator["StringMatches"] = 38] = "StringMatches";
})(ComparisonOperator || (ComparisonOperator = {}));
/**
 * Compound Operator types
 */
var CompoundOperator;
(function (CompoundOperator) {
    CompoundOperator[CompoundOperator["And"] = 0] = "And";
    CompoundOperator[CompoundOperator["Or"] = 1] = "Or";
})(CompoundOperator || (CompoundOperator = {}));
/**
 * Scalar comparison
 */
class VariableComparison extends Condition {
    constructor(variable, comparisonOperator, value) {
        super();
        this.variable = variable;
        this.comparisonOperator = comparisonOperator;
        this.value = value;
        if (!/^\$|(\$[.[])/.test(variable)) {
            throw new Error(`Variable reference must be '$', start with '$.', or start with '$[', got '${variable}'`);
        }
    }
    renderCondition() {
        return {
            Variable: this.variable,
            [ComparisonOperator[this.comparisonOperator]]: this.value,
        };
    }
}
/**
 * Logical compound condition
 */
class CompoundCondition extends Condition {
    constructor(operator, ...conditions) {
        super();
        this.operator = operator;
        this.conditions = conditions;
        if (conditions.length === 0) {
            throw new Error('Must supply at least one inner condition for a logical combination');
        }
    }
    renderCondition() {
        return {
            [CompoundOperator[this.operator]]: this.conditions.map(c => c.renderCondition()),
        };
    }
}
/**
 * Logical unary condition
 */
class NotCondition extends Condition {
    constructor(comparisonOperation) {
        super();
        this.comparisonOperation = comparisonOperation;
    }
    renderCondition() {
        return {
            Not: this.comparisonOperation.renderCondition(),
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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