<a id="mypy-boto3-ssm"></a>

# mypy-boto3-ssm

[![PyPI - mypy-boto3-ssm](https://img.shields.io/pypi/v/mypy-boto3-ssm.svg?color=blue)](https://pypi.org/project/mypy-boto3-ssm)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ssm.svg?color=blue)](https://pypi.org/project/mypy-boto3-ssm)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-ssm?color=blue)](https://pypistats.org/packages/mypy-boto3-ssm)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.SSM 1.18.49](https://boto3.amazonaws.com/v1/documentation/api/1.18.49/reference/services/ssm.html#SSM)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-ssm docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ssm/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-ssm](#mypy-boto3-ssm)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `SSM` service.

```bash
python -m pip install boto3-stubs[ssm]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[ssm]` in your environment:
  `python -m pip install 'boto3-stubs[ssm]'`

Both type checking and auto-complete should work for `SSM` service. No explicit
type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[ssm]` in your environment:
  `python -m pip install 'boto3-stubs[ssm]'`

Both type checking and auto-complete should work for `SSM` service. No explicit
type annotations required, write your `boto3` code as usual. Auto-complete can
be slow on big projects or if you have a lot of installed `boto3-stubs`
submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[ssm]` in your environment:
  `python -m pip install 'boto3-stubs[ssm]'`
- Run `mypy` as usual

Type checking should work for `SSM` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[ssm]` in your environment:
  `python -m pip install 'boto3-stubs[ssm]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `SSM` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`SSMClient` provides annotations for `boto3.client("ssm")`.

```python
import boto3

from mypy_boto3_ssm import SSMClient

client: SSMClient = boto3.client("ssm")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SSMClient = session.client("ssm")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_ssm.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_ssm import SSMClient
from mypy_boto3_ssm.paginator import (
    DescribeActivationsPaginator,
    DescribeAssociationExecutionTargetsPaginator,
    DescribeAssociationExecutionsPaginator,
    DescribeAutomationExecutionsPaginator,
    DescribeAutomationStepExecutionsPaginator,
    DescribeAvailablePatchesPaginator,
    DescribeEffectiveInstanceAssociationsPaginator,
    DescribeEffectivePatchesForPatchBaselinePaginator,
    DescribeInstanceAssociationsStatusPaginator,
    DescribeInstanceInformationPaginator,
    DescribeInstancePatchStatesPaginator,
    DescribeInstancePatchStatesForPatchGroupPaginator,
    DescribeInstancePatchesPaginator,
    DescribeInventoryDeletionsPaginator,
    DescribeMaintenanceWindowExecutionTaskInvocationsPaginator,
    DescribeMaintenanceWindowExecutionTasksPaginator,
    DescribeMaintenanceWindowExecutionsPaginator,
    DescribeMaintenanceWindowSchedulePaginator,
    DescribeMaintenanceWindowTargetsPaginator,
    DescribeMaintenanceWindowTasksPaginator,
    DescribeMaintenanceWindowsPaginator,
    DescribeMaintenanceWindowsForTargetPaginator,
    DescribeOpsItemsPaginator,
    DescribeParametersPaginator,
    DescribePatchBaselinesPaginator,
    DescribePatchGroupsPaginator,
    DescribePatchPropertiesPaginator,
    DescribeSessionsPaginator,
    GetInventoryPaginator,
    GetInventorySchemaPaginator,
    GetOpsSummaryPaginator,
    GetParameterHistoryPaginator,
    GetParametersByPathPaginator,
    ListAssociationVersionsPaginator,
    ListAssociationsPaginator,
    ListCommandInvocationsPaginator,
    ListCommandsPaginator,
    ListComplianceItemsPaginator,
    ListComplianceSummariesPaginator,
    ListDocumentVersionsPaginator,
    ListDocumentsPaginator,
    ListOpsItemEventsPaginator,
    ListOpsItemRelatedItemsPaginator,
    ListOpsMetadataPaginator,
    ListResourceComplianceSummariesPaginator,
    ListResourceDataSyncPaginator,
)

client: SSMClient = boto3.client("ssm")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_activations_paginator: DescribeActivationsPaginator = client.get_paginator("describe_activations")
describe_association_execution_targets_paginator: DescribeAssociationExecutionTargetsPaginator = client.get_paginator("describe_association_execution_targets")
describe_association_executions_paginator: DescribeAssociationExecutionsPaginator = client.get_paginator("describe_association_executions")
describe_automation_executions_paginator: DescribeAutomationExecutionsPaginator = client.get_paginator("describe_automation_executions")
describe_automation_step_executions_paginator: DescribeAutomationStepExecutionsPaginator = client.get_paginator("describe_automation_step_executions")
describe_available_patches_paginator: DescribeAvailablePatchesPaginator = client.get_paginator("describe_available_patches")
describe_effective_instance_associations_paginator: DescribeEffectiveInstanceAssociationsPaginator = client.get_paginator("describe_effective_instance_associations")
describe_effective_patches_for_patch_baseline_paginator: DescribeEffectivePatchesForPatchBaselinePaginator = client.get_paginator("describe_effective_patches_for_patch_baseline")
describe_instance_associations_status_paginator: DescribeInstanceAssociationsStatusPaginator = client.get_paginator("describe_instance_associations_status")
describe_instance_information_paginator: DescribeInstanceInformationPaginator = client.get_paginator("describe_instance_information")
describe_instance_patch_states_paginator: DescribeInstancePatchStatesPaginator = client.get_paginator("describe_instance_patch_states")
describe_instance_patch_states_for_patch_group_paginator: DescribeInstancePatchStatesForPatchGroupPaginator = client.get_paginator("describe_instance_patch_states_for_patch_group")
describe_instance_patches_paginator: DescribeInstancePatchesPaginator = client.get_paginator("describe_instance_patches")
describe_inventory_deletions_paginator: DescribeInventoryDeletionsPaginator = client.get_paginator("describe_inventory_deletions")
describe_maintenance_window_execution_task_invocations_paginator: DescribeMaintenanceWindowExecutionTaskInvocationsPaginator = client.get_paginator("describe_maintenance_window_execution_task_invocations")
describe_maintenance_window_execution_tasks_paginator: DescribeMaintenanceWindowExecutionTasksPaginator = client.get_paginator("describe_maintenance_window_execution_tasks")
describe_maintenance_window_executions_paginator: DescribeMaintenanceWindowExecutionsPaginator = client.get_paginator("describe_maintenance_window_executions")
describe_maintenance_window_schedule_paginator: DescribeMaintenanceWindowSchedulePaginator = client.get_paginator("describe_maintenance_window_schedule")
describe_maintenance_window_targets_paginator: DescribeMaintenanceWindowTargetsPaginator = client.get_paginator("describe_maintenance_window_targets")
describe_maintenance_window_tasks_paginator: DescribeMaintenanceWindowTasksPaginator = client.get_paginator("describe_maintenance_window_tasks")
describe_maintenance_windows_paginator: DescribeMaintenanceWindowsPaginator = client.get_paginator("describe_maintenance_windows")
describe_maintenance_windows_for_target_paginator: DescribeMaintenanceWindowsForTargetPaginator = client.get_paginator("describe_maintenance_windows_for_target")
describe_ops_items_paginator: DescribeOpsItemsPaginator = client.get_paginator("describe_ops_items")
describe_parameters_paginator: DescribeParametersPaginator = client.get_paginator("describe_parameters")
describe_patch_baselines_paginator: DescribePatchBaselinesPaginator = client.get_paginator("describe_patch_baselines")
describe_patch_groups_paginator: DescribePatchGroupsPaginator = client.get_paginator("describe_patch_groups")
describe_patch_properties_paginator: DescribePatchPropertiesPaginator = client.get_paginator("describe_patch_properties")
describe_sessions_paginator: DescribeSessionsPaginator = client.get_paginator("describe_sessions")
get_inventory_paginator: GetInventoryPaginator = client.get_paginator("get_inventory")
get_inventory_schema_paginator: GetInventorySchemaPaginator = client.get_paginator("get_inventory_schema")
get_ops_summary_paginator: GetOpsSummaryPaginator = client.get_paginator("get_ops_summary")
get_parameter_history_paginator: GetParameterHistoryPaginator = client.get_paginator("get_parameter_history")
get_parameters_by_path_paginator: GetParametersByPathPaginator = client.get_paginator("get_parameters_by_path")
list_association_versions_paginator: ListAssociationVersionsPaginator = client.get_paginator("list_association_versions")
list_associations_paginator: ListAssociationsPaginator = client.get_paginator("list_associations")
list_command_invocations_paginator: ListCommandInvocationsPaginator = client.get_paginator("list_command_invocations")
list_commands_paginator: ListCommandsPaginator = client.get_paginator("list_commands")
list_compliance_items_paginator: ListComplianceItemsPaginator = client.get_paginator("list_compliance_items")
list_compliance_summaries_paginator: ListComplianceSummariesPaginator = client.get_paginator("list_compliance_summaries")
list_document_versions_paginator: ListDocumentVersionsPaginator = client.get_paginator("list_document_versions")
list_documents_paginator: ListDocumentsPaginator = client.get_paginator("list_documents")
list_ops_item_events_paginator: ListOpsItemEventsPaginator = client.get_paginator("list_ops_item_events")
list_ops_item_related_items_paginator: ListOpsItemRelatedItemsPaginator = client.get_paginator("list_ops_item_related_items")
list_ops_metadata_paginator: ListOpsMetadataPaginator = client.get_paginator("list_ops_metadata")
list_resource_compliance_summaries_paginator: ListResourceComplianceSummariesPaginator = client.get_paginator("list_resource_compliance_summaries")
list_resource_data_sync_paginator: ListResourceDataSyncPaginator = client.get_paginator("list_resource_data_sync")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_ssm.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_ssm import SSMClient
from mypy_boto3_ssm.waiter import (
    CommandExecutedWaiter,
)

client: SSMClient = boto3.client("ssm")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
command_executed_waiter: CommandExecutedWaiter = client.get_waiter("command_executed")
```

<a id="literals"></a>

### Literals

`mypy_boto3_ssm.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_ssm.literals import (
    AssociationComplianceSeverityType,
    AssociationExecutionFilterKeyType,
    AssociationExecutionTargetsFilterKeyType,
    AssociationFilterKeyType,
    AssociationFilterOperatorTypeType,
    AssociationStatusNameType,
    AssociationSyncComplianceType,
    AttachmentHashTypeType,
    AttachmentsSourceKeyType,
    AutomationExecutionFilterKeyType,
    AutomationExecutionStatusType,
    AutomationSubtypeType,
    AutomationTypeType,
    CalendarStateType,
    CommandExecutedWaiterName,
    CommandFilterKeyType,
    CommandInvocationStatusType,
    CommandPluginStatusType,
    CommandStatusType,
    ComplianceQueryOperatorTypeType,
    ComplianceSeverityType,
    ComplianceStatusType,
    ComplianceUploadTypeType,
    ConnectionStatusType,
    DescribeActivationsFilterKeysType,
    DescribeActivationsPaginatorName,
    DescribeAssociationExecutionTargetsPaginatorName,
    DescribeAssociationExecutionsPaginatorName,
    DescribeAutomationExecutionsPaginatorName,
    DescribeAutomationStepExecutionsPaginatorName,
    DescribeAvailablePatchesPaginatorName,
    DescribeEffectiveInstanceAssociationsPaginatorName,
    DescribeEffectivePatchesForPatchBaselinePaginatorName,
    DescribeInstanceAssociationsStatusPaginatorName,
    DescribeInstanceInformationPaginatorName,
    DescribeInstancePatchStatesForPatchGroupPaginatorName,
    DescribeInstancePatchStatesPaginatorName,
    DescribeInstancePatchesPaginatorName,
    DescribeInventoryDeletionsPaginatorName,
    DescribeMaintenanceWindowExecutionTaskInvocationsPaginatorName,
    DescribeMaintenanceWindowExecutionTasksPaginatorName,
    DescribeMaintenanceWindowExecutionsPaginatorName,
    DescribeMaintenanceWindowSchedulePaginatorName,
    DescribeMaintenanceWindowTargetsPaginatorName,
    DescribeMaintenanceWindowTasksPaginatorName,
    DescribeMaintenanceWindowsForTargetPaginatorName,
    DescribeMaintenanceWindowsPaginatorName,
    DescribeOpsItemsPaginatorName,
    DescribeParametersPaginatorName,
    DescribePatchBaselinesPaginatorName,
    DescribePatchGroupsPaginatorName,
    DescribePatchPropertiesPaginatorName,
    DescribeSessionsPaginatorName,
    DocumentFilterKeyType,
    DocumentFormatType,
    DocumentHashTypeType,
    DocumentMetadataEnumType,
    DocumentParameterTypeType,
    DocumentPermissionTypeType,
    DocumentReviewActionType,
    DocumentReviewCommentTypeType,
    DocumentStatusType,
    DocumentTypeType,
    ExecutionModeType,
    FaultType,
    GetInventoryPaginatorName,
    GetInventorySchemaPaginatorName,
    GetOpsSummaryPaginatorName,
    GetParameterHistoryPaginatorName,
    GetParametersByPathPaginatorName,
    InstanceInformationFilterKeyType,
    InstancePatchStateOperatorTypeType,
    InventoryAttributeDataTypeType,
    InventoryDeletionStatusType,
    InventoryQueryOperatorTypeType,
    InventorySchemaDeleteOptionType,
    LastResourceDataSyncStatusType,
    ListAssociationVersionsPaginatorName,
    ListAssociationsPaginatorName,
    ListCommandInvocationsPaginatorName,
    ListCommandsPaginatorName,
    ListComplianceItemsPaginatorName,
    ListComplianceSummariesPaginatorName,
    ListDocumentVersionsPaginatorName,
    ListDocumentsPaginatorName,
    ListOpsItemEventsPaginatorName,
    ListOpsItemRelatedItemsPaginatorName,
    ListOpsMetadataPaginatorName,
    ListResourceComplianceSummariesPaginatorName,
    ListResourceDataSyncPaginatorName,
    MaintenanceWindowExecutionStatusType,
    MaintenanceWindowResourceTypeType,
    MaintenanceWindowTaskCutoffBehaviorType,
    MaintenanceWindowTaskTypeType,
    NotificationEventType,
    NotificationTypeType,
    OperatingSystemType,
    OpsFilterOperatorTypeType,
    OpsItemDataTypeType,
    OpsItemEventFilterKeyType,
    OpsItemEventFilterOperatorType,
    OpsItemFilterKeyType,
    OpsItemFilterOperatorType,
    OpsItemRelatedItemsFilterKeyType,
    OpsItemRelatedItemsFilterOperatorType,
    OpsItemStatusType,
    ParameterTierType,
    ParameterTypeType,
    ParametersFilterKeyType,
    PatchActionType,
    PatchComplianceDataStateType,
    PatchComplianceLevelType,
    PatchDeploymentStatusType,
    PatchFilterKeyType,
    PatchOperationTypeType,
    PatchPropertyType,
    PatchSetType,
    PingStatusType,
    PlatformTypeType,
    RebootOptionType,
    ResourceDataSyncS3FormatType,
    ResourceTypeForTaggingType,
    ResourceTypeType,
    ReviewStatusType,
    SessionFilterKeyType,
    SessionStateType,
    SessionStatusType,
    SignalTypeType,
    StepExecutionFilterKeyType,
    StopTypeType,
    ServiceName,
    PaginatorName,
    WaiterName,
)

def check_value(value: AssociationComplianceSeverityType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_ssm.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_ssm.type_defs import (
    AccountSharingInfoTypeDef,
    ActivationTypeDef,
    AddTagsToResourceRequestRequestTypeDef,
    AssociateOpsItemRelatedItemRequestRequestTypeDef,
    AssociateOpsItemRelatedItemResponseTypeDef,
    AssociationDescriptionTypeDef,
    AssociationExecutionFilterTypeDef,
    AssociationExecutionTargetTypeDef,
    AssociationExecutionTargetsFilterTypeDef,
    AssociationExecutionTypeDef,
    AssociationFilterTypeDef,
    AssociationOverviewTypeDef,
    AssociationStatusTypeDef,
    AssociationTypeDef,
    AssociationVersionInfoTypeDef,
    AttachmentContentTypeDef,
    AttachmentInformationTypeDef,
    AttachmentsSourceTypeDef,
    AutomationExecutionFilterTypeDef,
    AutomationExecutionMetadataTypeDef,
    AutomationExecutionTypeDef,
    BaselineOverrideTypeDef,
    CancelCommandRequestRequestTypeDef,
    CancelMaintenanceWindowExecutionRequestRequestTypeDef,
    CancelMaintenanceWindowExecutionResultTypeDef,
    CloudWatchOutputConfigTypeDef,
    CommandFilterTypeDef,
    CommandInvocationTypeDef,
    CommandPluginTypeDef,
    CommandTypeDef,
    ComplianceExecutionSummaryTypeDef,
    ComplianceItemEntryTypeDef,
    ComplianceItemTypeDef,
    ComplianceStringFilterTypeDef,
    ComplianceSummaryItemTypeDef,
    CompliantSummaryTypeDef,
    CreateActivationRequestRequestTypeDef,
    CreateActivationResultTypeDef,
    CreateAssociationBatchRequestEntryTypeDef,
    CreateAssociationBatchRequestRequestTypeDef,
    CreateAssociationBatchResultTypeDef,
    CreateAssociationRequestRequestTypeDef,
    CreateAssociationResultTypeDef,
    CreateDocumentRequestRequestTypeDef,
    CreateDocumentResultTypeDef,
    CreateMaintenanceWindowRequestRequestTypeDef,
    CreateMaintenanceWindowResultTypeDef,
    CreateOpsItemRequestRequestTypeDef,
    CreateOpsItemResponseTypeDef,
    CreateOpsMetadataRequestRequestTypeDef,
    CreateOpsMetadataResultTypeDef,
    CreatePatchBaselineRequestRequestTypeDef,
    CreatePatchBaselineResultTypeDef,
    CreateResourceDataSyncRequestRequestTypeDef,
    DeleteActivationRequestRequestTypeDef,
    DeleteAssociationRequestRequestTypeDef,
    DeleteDocumentRequestRequestTypeDef,
    DeleteInventoryRequestRequestTypeDef,
    DeleteInventoryResultTypeDef,
    DeleteMaintenanceWindowRequestRequestTypeDef,
    DeleteMaintenanceWindowResultTypeDef,
    DeleteOpsMetadataRequestRequestTypeDef,
    DeleteParameterRequestRequestTypeDef,
    DeleteParametersRequestRequestTypeDef,
    DeleteParametersResultTypeDef,
    DeletePatchBaselineRequestRequestTypeDef,
    DeletePatchBaselineResultTypeDef,
    DeleteResourceDataSyncRequestRequestTypeDef,
    DeregisterManagedInstanceRequestRequestTypeDef,
    DeregisterPatchBaselineForPatchGroupRequestRequestTypeDef,
    DeregisterPatchBaselineForPatchGroupResultTypeDef,
    DeregisterTargetFromMaintenanceWindowRequestRequestTypeDef,
    DeregisterTargetFromMaintenanceWindowResultTypeDef,
    DeregisterTaskFromMaintenanceWindowRequestRequestTypeDef,
    DeregisterTaskFromMaintenanceWindowResultTypeDef,
    DescribeActivationsFilterTypeDef,
    DescribeActivationsRequestRequestTypeDef,
    DescribeActivationsResultTypeDef,
    DescribeAssociationExecutionTargetsRequestRequestTypeDef,
    DescribeAssociationExecutionTargetsResultTypeDef,
    DescribeAssociationExecutionsRequestRequestTypeDef,
    DescribeAssociationExecutionsResultTypeDef,
    DescribeAssociationRequestRequestTypeDef,
    DescribeAssociationResultTypeDef,
    DescribeAutomationExecutionsRequestRequestTypeDef,
    DescribeAutomationExecutionsResultTypeDef,
    DescribeAutomationStepExecutionsRequestRequestTypeDef,
    DescribeAutomationStepExecutionsResultTypeDef,
    DescribeAvailablePatchesRequestRequestTypeDef,
    DescribeAvailablePatchesResultTypeDef,
    DescribeDocumentPermissionRequestRequestTypeDef,
    DescribeDocumentPermissionResponseTypeDef,
    DescribeDocumentRequestRequestTypeDef,
    DescribeDocumentResultTypeDef,
    DescribeEffectiveInstanceAssociationsRequestRequestTypeDef,
    DescribeEffectiveInstanceAssociationsResultTypeDef,
    DescribeEffectivePatchesForPatchBaselineRequestRequestTypeDef,
    DescribeEffectivePatchesForPatchBaselineResultTypeDef,
    DescribeInstanceAssociationsStatusRequestRequestTypeDef,
    DescribeInstanceAssociationsStatusResultTypeDef,
    DescribeInstanceInformationRequestRequestTypeDef,
    DescribeInstanceInformationResultTypeDef,
    DescribeInstancePatchStatesForPatchGroupRequestRequestTypeDef,
    DescribeInstancePatchStatesForPatchGroupResultTypeDef,
    DescribeInstancePatchStatesRequestRequestTypeDef,
    DescribeInstancePatchStatesResultTypeDef,
    DescribeInstancePatchesRequestRequestTypeDef,
    DescribeInstancePatchesResultTypeDef,
    DescribeInventoryDeletionsRequestRequestTypeDef,
    DescribeInventoryDeletionsResultTypeDef,
    DescribeMaintenanceWindowExecutionTaskInvocationsRequestRequestTypeDef,
    DescribeMaintenanceWindowExecutionTaskInvocationsResultTypeDef,
    DescribeMaintenanceWindowExecutionTasksRequestRequestTypeDef,
    DescribeMaintenanceWindowExecutionTasksResultTypeDef,
    DescribeMaintenanceWindowExecutionsRequestRequestTypeDef,
    DescribeMaintenanceWindowExecutionsResultTypeDef,
    DescribeMaintenanceWindowScheduleRequestRequestTypeDef,
    DescribeMaintenanceWindowScheduleResultTypeDef,
    DescribeMaintenanceWindowTargetsRequestRequestTypeDef,
    DescribeMaintenanceWindowTargetsResultTypeDef,
    DescribeMaintenanceWindowTasksRequestRequestTypeDef,
    DescribeMaintenanceWindowTasksResultTypeDef,
    DescribeMaintenanceWindowsForTargetRequestRequestTypeDef,
    DescribeMaintenanceWindowsForTargetResultTypeDef,
    DescribeMaintenanceWindowsRequestRequestTypeDef,
    DescribeMaintenanceWindowsResultTypeDef,
    DescribeOpsItemsRequestRequestTypeDef,
    DescribeOpsItemsResponseTypeDef,
    DescribeParametersRequestRequestTypeDef,
    DescribeParametersResultTypeDef,
    DescribePatchBaselinesRequestRequestTypeDef,
    DescribePatchBaselinesResultTypeDef,
    DescribePatchGroupStateRequestRequestTypeDef,
    DescribePatchGroupStateResultTypeDef,
    DescribePatchGroupsRequestRequestTypeDef,
    DescribePatchGroupsResultTypeDef,
    DescribePatchPropertiesRequestRequestTypeDef,
    DescribePatchPropertiesResultTypeDef,
    DescribeSessionsRequestRequestTypeDef,
    DescribeSessionsResponseTypeDef,
    DisassociateOpsItemRelatedItemRequestRequestTypeDef,
    DocumentDefaultVersionDescriptionTypeDef,
    DocumentDescriptionTypeDef,
    DocumentFilterTypeDef,
    DocumentIdentifierTypeDef,
    DocumentKeyValuesFilterTypeDef,
    DocumentMetadataResponseInfoTypeDef,
    DocumentParameterTypeDef,
    DocumentRequiresTypeDef,
    DocumentReviewCommentSourceTypeDef,
    DocumentReviewerResponseSourceTypeDef,
    DocumentReviewsTypeDef,
    DocumentVersionInfoTypeDef,
    EffectivePatchTypeDef,
    FailedCreateAssociationTypeDef,
    FailureDetailsTypeDef,
    GetAutomationExecutionRequestRequestTypeDef,
    GetAutomationExecutionResultTypeDef,
    GetCalendarStateRequestRequestTypeDef,
    GetCalendarStateResponseTypeDef,
    GetCommandInvocationRequestRequestTypeDef,
    GetCommandInvocationResultTypeDef,
    GetConnectionStatusRequestRequestTypeDef,
    GetConnectionStatusResponseTypeDef,
    GetDefaultPatchBaselineRequestRequestTypeDef,
    GetDefaultPatchBaselineResultTypeDef,
    GetDeployablePatchSnapshotForInstanceRequestRequestTypeDef,
    GetDeployablePatchSnapshotForInstanceResultTypeDef,
    GetDocumentRequestRequestTypeDef,
    GetDocumentResultTypeDef,
    GetInventoryRequestRequestTypeDef,
    GetInventoryResultTypeDef,
    GetInventorySchemaRequestRequestTypeDef,
    GetInventorySchemaResultTypeDef,
    GetMaintenanceWindowExecutionRequestRequestTypeDef,
    GetMaintenanceWindowExecutionResultTypeDef,
    GetMaintenanceWindowExecutionTaskInvocationRequestRequestTypeDef,
    GetMaintenanceWindowExecutionTaskInvocationResultTypeDef,
    GetMaintenanceWindowExecutionTaskRequestRequestTypeDef,
    GetMaintenanceWindowExecutionTaskResultTypeDef,
    GetMaintenanceWindowRequestRequestTypeDef,
    GetMaintenanceWindowResultTypeDef,
    GetMaintenanceWindowTaskRequestRequestTypeDef,
    GetMaintenanceWindowTaskResultTypeDef,
    GetOpsItemRequestRequestTypeDef,
    GetOpsItemResponseTypeDef,
    GetOpsMetadataRequestRequestTypeDef,
    GetOpsMetadataResultTypeDef,
    GetOpsSummaryRequestRequestTypeDef,
    GetOpsSummaryResultTypeDef,
    GetParameterHistoryRequestRequestTypeDef,
    GetParameterHistoryResultTypeDef,
    GetParameterRequestRequestTypeDef,
    GetParameterResultTypeDef,
    GetParametersByPathRequestRequestTypeDef,
    GetParametersByPathResultTypeDef,
    GetParametersRequestRequestTypeDef,
    GetParametersResultTypeDef,
    GetPatchBaselineForPatchGroupRequestRequestTypeDef,
    GetPatchBaselineForPatchGroupResultTypeDef,
    GetPatchBaselineRequestRequestTypeDef,
    GetPatchBaselineResultTypeDef,
    GetServiceSettingRequestRequestTypeDef,
    GetServiceSettingResultTypeDef,
    InstanceAggregatedAssociationOverviewTypeDef,
    InstanceAssociationOutputLocationTypeDef,
    InstanceAssociationOutputUrlTypeDef,
    InstanceAssociationStatusInfoTypeDef,
    InstanceAssociationTypeDef,
    InstanceInformationFilterTypeDef,
    InstanceInformationStringFilterTypeDef,
    InstanceInformationTypeDef,
    InstancePatchStateFilterTypeDef,
    InstancePatchStateTypeDef,
    InventoryAggregatorTypeDef,
    InventoryDeletionStatusItemTypeDef,
    InventoryDeletionSummaryItemTypeDef,
    InventoryDeletionSummaryTypeDef,
    InventoryFilterTypeDef,
    InventoryGroupTypeDef,
    InventoryItemAttributeTypeDef,
    InventoryItemSchemaTypeDef,
    InventoryItemTypeDef,
    InventoryResultEntityTypeDef,
    InventoryResultItemTypeDef,
    LabelParameterVersionRequestRequestTypeDef,
    LabelParameterVersionResultTypeDef,
    ListAssociationVersionsRequestRequestTypeDef,
    ListAssociationVersionsResultTypeDef,
    ListAssociationsRequestRequestTypeDef,
    ListAssociationsResultTypeDef,
    ListCommandInvocationsRequestRequestTypeDef,
    ListCommandInvocationsResultTypeDef,
    ListCommandsRequestRequestTypeDef,
    ListCommandsResultTypeDef,
    ListComplianceItemsRequestRequestTypeDef,
    ListComplianceItemsResultTypeDef,
    ListComplianceSummariesRequestRequestTypeDef,
    ListComplianceSummariesResultTypeDef,
    ListDocumentMetadataHistoryRequestRequestTypeDef,
    ListDocumentMetadataHistoryResponseTypeDef,
    ListDocumentVersionsRequestRequestTypeDef,
    ListDocumentVersionsResultTypeDef,
    ListDocumentsRequestRequestTypeDef,
    ListDocumentsResultTypeDef,
    ListInventoryEntriesRequestRequestTypeDef,
    ListInventoryEntriesResultTypeDef,
    ListOpsItemEventsRequestRequestTypeDef,
    ListOpsItemEventsResponseTypeDef,
    ListOpsItemRelatedItemsRequestRequestTypeDef,
    ListOpsItemRelatedItemsResponseTypeDef,
    ListOpsMetadataRequestRequestTypeDef,
    ListOpsMetadataResultTypeDef,
    ListResourceComplianceSummariesRequestRequestTypeDef,
    ListResourceComplianceSummariesResultTypeDef,
    ListResourceDataSyncRequestRequestTypeDef,
    ListResourceDataSyncResultTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResultTypeDef,
    LoggingInfoTypeDef,
    MaintenanceWindowAutomationParametersTypeDef,
    MaintenanceWindowExecutionTaskIdentityTypeDef,
    MaintenanceWindowExecutionTaskInvocationIdentityTypeDef,
    MaintenanceWindowExecutionTypeDef,
    MaintenanceWindowFilterTypeDef,
    MaintenanceWindowIdentityForTargetTypeDef,
    MaintenanceWindowIdentityTypeDef,
    MaintenanceWindowLambdaParametersTypeDef,
    MaintenanceWindowRunCommandParametersTypeDef,
    MaintenanceWindowStepFunctionsParametersTypeDef,
    MaintenanceWindowTargetTypeDef,
    MaintenanceWindowTaskInvocationParametersTypeDef,
    MaintenanceWindowTaskParameterValueExpressionTypeDef,
    MaintenanceWindowTaskTypeDef,
    MetadataValueTypeDef,
    ModifyDocumentPermissionRequestRequestTypeDef,
    NonCompliantSummaryTypeDef,
    NotificationConfigTypeDef,
    OpsAggregatorTypeDef,
    OpsEntityItemTypeDef,
    OpsEntityTypeDef,
    OpsFilterTypeDef,
    OpsItemDataValueTypeDef,
    OpsItemEventFilterTypeDef,
    OpsItemEventSummaryTypeDef,
    OpsItemFilterTypeDef,
    OpsItemIdentityTypeDef,
    OpsItemNotificationTypeDef,
    OpsItemRelatedItemSummaryTypeDef,
    OpsItemRelatedItemsFilterTypeDef,
    OpsItemSummaryTypeDef,
    OpsItemTypeDef,
    OpsMetadataFilterTypeDef,
    OpsMetadataTypeDef,
    OpsResultAttributeTypeDef,
    OutputSourceTypeDef,
    PaginatorConfigTypeDef,
    ParameterHistoryTypeDef,
    ParameterInlinePolicyTypeDef,
    ParameterMetadataTypeDef,
    ParameterStringFilterTypeDef,
    ParameterTypeDef,
    ParametersFilterTypeDef,
    PatchBaselineIdentityTypeDef,
    PatchComplianceDataTypeDef,
    PatchFilterGroupTypeDef,
    PatchFilterTypeDef,
    PatchGroupPatchBaselineMappingTypeDef,
    PatchOrchestratorFilterTypeDef,
    PatchRuleGroupTypeDef,
    PatchRuleTypeDef,
    PatchSourceTypeDef,
    PatchStatusTypeDef,
    PatchTypeDef,
    ProgressCountersTypeDef,
    PutComplianceItemsRequestRequestTypeDef,
    PutInventoryRequestRequestTypeDef,
    PutInventoryResultTypeDef,
    PutParameterRequestRequestTypeDef,
    PutParameterResultTypeDef,
    RegisterDefaultPatchBaselineRequestRequestTypeDef,
    RegisterDefaultPatchBaselineResultTypeDef,
    RegisterPatchBaselineForPatchGroupRequestRequestTypeDef,
    RegisterPatchBaselineForPatchGroupResultTypeDef,
    RegisterTargetWithMaintenanceWindowRequestRequestTypeDef,
    RegisterTargetWithMaintenanceWindowResultTypeDef,
    RegisterTaskWithMaintenanceWindowRequestRequestTypeDef,
    RegisterTaskWithMaintenanceWindowResultTypeDef,
    RelatedOpsItemTypeDef,
    RemoveTagsFromResourceRequestRequestTypeDef,
    ResetServiceSettingRequestRequestTypeDef,
    ResetServiceSettingResultTypeDef,
    ResolvedTargetsTypeDef,
    ResourceComplianceSummaryItemTypeDef,
    ResourceDataSyncAwsOrganizationsSourceTypeDef,
    ResourceDataSyncDestinationDataSharingTypeDef,
    ResourceDataSyncItemTypeDef,
    ResourceDataSyncOrganizationalUnitTypeDef,
    ResourceDataSyncS3DestinationTypeDef,
    ResourceDataSyncSourceTypeDef,
    ResourceDataSyncSourceWithStateTypeDef,
    ResponseMetadataTypeDef,
    ResultAttributeTypeDef,
    ResumeSessionRequestRequestTypeDef,
    ResumeSessionResponseTypeDef,
    ReviewInformationTypeDef,
    RunbookTypeDef,
    S3OutputLocationTypeDef,
    S3OutputUrlTypeDef,
    ScheduledWindowExecutionTypeDef,
    SendAutomationSignalRequestRequestTypeDef,
    SendCommandRequestRequestTypeDef,
    SendCommandResultTypeDef,
    ServiceSettingTypeDef,
    SessionFilterTypeDef,
    SessionManagerOutputUrlTypeDef,
    SessionTypeDef,
    SeveritySummaryTypeDef,
    StartAssociationsOnceRequestRequestTypeDef,
    StartAutomationExecutionRequestRequestTypeDef,
    StartAutomationExecutionResultTypeDef,
    StartChangeRequestExecutionRequestRequestTypeDef,
    StartChangeRequestExecutionResultTypeDef,
    StartSessionRequestRequestTypeDef,
    StartSessionResponseTypeDef,
    StepExecutionFilterTypeDef,
    StepExecutionTypeDef,
    StopAutomationExecutionRequestRequestTypeDef,
    TagTypeDef,
    TargetLocationTypeDef,
    TargetTypeDef,
    TerminateSessionRequestRequestTypeDef,
    TerminateSessionResponseTypeDef,
    UnlabelParameterVersionRequestRequestTypeDef,
    UnlabelParameterVersionResultTypeDef,
    UpdateAssociationRequestRequestTypeDef,
    UpdateAssociationResultTypeDef,
    UpdateAssociationStatusRequestRequestTypeDef,
    UpdateAssociationStatusResultTypeDef,
    UpdateDocumentDefaultVersionRequestRequestTypeDef,
    UpdateDocumentDefaultVersionResultTypeDef,
    UpdateDocumentMetadataRequestRequestTypeDef,
    UpdateDocumentRequestRequestTypeDef,
    UpdateDocumentResultTypeDef,
    UpdateMaintenanceWindowRequestRequestTypeDef,
    UpdateMaintenanceWindowResultTypeDef,
    UpdateMaintenanceWindowTargetRequestRequestTypeDef,
    UpdateMaintenanceWindowTargetResultTypeDef,
    UpdateMaintenanceWindowTaskRequestRequestTypeDef,
    UpdateMaintenanceWindowTaskResultTypeDef,
    UpdateManagedInstanceRoleRequestRequestTypeDef,
    UpdateOpsItemRequestRequestTypeDef,
    UpdateOpsMetadataRequestRequestTypeDef,
    UpdateOpsMetadataResultTypeDef,
    UpdatePatchBaselineRequestRequestTypeDef,
    UpdatePatchBaselineResultTypeDef,
    UpdateResourceDataSyncRequestRequestTypeDef,
    UpdateServiceSettingRequestRequestTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AccountSharingInfoTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-ssm` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-ssm docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ssm/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
