# database2text 使用手册

这个工具主要用于读取数据库里的对象如表、视图等的结构，根据这些结构生成文本文件。
可以用这些文本文件以及版本控制软件来备份、检查数据库结构的变动情况。
还可以使用模板技术根据这些结构自动生成代码，比如可以自动更新c/c++源代码里的结构，这样在表结构更新时可以帮助你迅速完成底层数据结构的重建。

执行代码为dbt，可以增加一个参数文件名作为执行文件，无参数则读取当前目录下的dbt.txt文件。

## dbt.txt 执行文件格式
所有#号开头的行为注释行，忽略其内容。
以:开头的行为段开始，后续直到另一个段开始的内容均属于这个段。文件开头为global段，不需要定义段开始。
各段的内容根据不同的段会有差异，扫描执行文件时会把每一行符合xxx=yyy格式的内容解析出来做为参数在调用段函数时使用。
不同的数据库各段也会有差异，不过不同的驱动器会尽可能保持一致，以方便用户切换数据库时学习成本较低。
执行文件中段的数量没有限制，执行时依次处理各段。

### global段
此段定义驱动器，如
driver=mysql
则后续联接的数据库为mysql数据

### connnect段
根据驱动器不同，这里需要的参数也有差异，具体请参看对应的驱动器的执行文件样例

### readdata段
读入数据库结构，具体数据格式细节随驱动器不同会有差异。

读入数据保存在dbdata字典中。其中
* dbdata["sql"]保存各对象的生成脚本，比如 dbdata["sql"]["TABLE"]["表名"]是这张表的创建脚本。export使用这个数据
* dbdata["exp"]保存了render功能需要的一些数据，如 dbdata["exp"]["TABLE"]是一个列表，包含所有表的数据，这个列表每一行是一个字典

{"tname":"表名","tdesc":"表的描述信息","ori":从数据库中获取的原始信息，具体细节跟数据库相关，"c":用于c/c++的字段信息列表}
	
c列表包含以下内容：

{"cname": 字段名,"ns": 字段名以及长度，主要用于char类型定义长度用,"cdesc": 描述信息,"type": 数据类型，如double,char,int等}

### export段
将读入的数据库结构导出成文本文件。这些文件按类组织，如表放在TABLE目录下，视图放在VIEW视图下。目录之下一个对象独立为一个文件。这些文件保存为.sql，尽可能保证是相应对象在数据库中建立的格式。

### render段
file=文件名 行告诉执行器处理哪一个文件。

help=y 会让执行器输出传递给jinja2渲染的数据内容，方便写模板时参考。

table=用空格隔开的表名 不设置则处理所有的表

table-=用空格隔开的表名 在这里列出的表不需要处理

start=和end=这两行告诉执行器在文件中搜索需要替换的文件内容的头和尾。头和尾可以是同一行，这样可以适应单行方式。搜索以python的re正则模块按行搜索。从文件头开始，搜索到start行之后继续搜索end，start和end以及中间的所有行就是找到的需要替换的文本块。

start和end行中间的内容约定是jinj2模板，使用dbdata["c"]["TABLE"]下对应表的那个字典去渲染。渲染后得到的结果判定是否需要和首尾行合并，判断的方法是取首、尾行分别和start、end行进行正则匹配，如果不匹配，则加上相应的首尾行。

这个设计的应用场景类似我要定义一个结构，首行是

struct stru_表名 {	//表的说明信息

这里的表名和说明信息都是变化的，如果修改了表的说明信息，那么下一次搜索替换的时候就找不到老的结构定义位置了，所以查找首行的时候start行不能写表的说明信息只能写类似  
struct stru_{{ tname }} {  
这样，然后在模板的第一行写上类似  
struct stru_{{ tname }} {	//{{ tdesc }}
	
这样搜索的时候可以正确找到描述不同的首行，替换的时候也可以保证首行被正确修改。

最终得到的结果和要替换的文本块进行比较，如果有差异，则重写文件，用新内容替换掉老的内容。

因为要处理多张表，所以start和end会先用表名{{ name }} 和表注释{{ desc }} 渲染一下。

如果start行搜索不到，则在文件的结尾追加内容

### end段
发现这个段就意味着执行器停止扫描，这样可以把一些暂时不用的代码放在end段后面。

这个段最好写上，因为执行器的“特性”，实际上它并不处理最后一个段。。。。
