# coding: utf-8

"""
    Spacestudio API documentation

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacestudio_satellite_client.models.drag_perturbation import DragPerturbation
from spacestudio_satellite_client.models.earth_potential_perturbation import EarthPotentialPerturbation
from spacestudio_satellite_client.models.orbit import Orbit
from spacestudio_satellite_client.models.platform import Platform
from spacestudio_satellite_client.models.propulsion_system import PropulsionSystem
from spacestudio_satellite_client.models.solar_radiation_pressure_perturbation import SolarRadiationPressurePerturbation
from spacestudio_satellite_client.models.spacecraft_geometry import SpacecraftGeometry
from spacestudio_satellite_client.models.third_body_perturbation import ThirdBodyPerturbation
from typing import Optional, Set
from typing_extensions import Self

class StudyInputs(BaseModel):
    """
    StudyInputs
    """ # noqa: E501
    propulsion_system: Optional[PropulsionSystem] = Field(default=None, alias="propulsionSystem")
    spacecraft_geometry: Optional[SpacecraftGeometry] = Field(default=None, alias="spacecraftGeometry")
    platform: Optional[Platform] = None
    initial_orbit: Optional[Orbit] = Field(default=None, alias="initialOrbit")
    final_orbit: Optional[Orbit] = Field(default=None, alias="finalOrbit")
    drag_perturbation: Optional[DragPerturbation] = Field(default=None, alias="dragPerturbation")
    earth_potential_perturbation: Optional[EarthPotentialPerturbation] = Field(default=None, alias="earthPotentialPerturbation")
    solar_radiation_pressure_perturbation: Optional[SolarRadiationPressurePerturbation] = Field(default=None, alias="solarRadiationPressurePerturbation")
    third_body_perturbation: Optional[ThirdBodyPerturbation] = Field(default=None, alias="thirdBodyPerturbation")
    __properties: ClassVar[List[str]] = ["propulsionSystem", "spacecraftGeometry", "platform", "initialOrbit", "finalOrbit", "dragPerturbation", "earthPotentialPerturbation", "solarRadiationPressurePerturbation", "thirdBodyPerturbation"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StudyInputs from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of propulsion_system
        if self.propulsion_system:
            _dict['propulsionSystem'] = self.propulsion_system.to_dict()
        # override the default output from pydantic by calling `to_dict()` of spacecraft_geometry
        if self.spacecraft_geometry:
            _dict['spacecraftGeometry'] = self.spacecraft_geometry.to_dict()
        # override the default output from pydantic by calling `to_dict()` of platform
        if self.platform:
            _dict['platform'] = self.platform.to_dict()
        # override the default output from pydantic by calling `to_dict()` of initial_orbit
        if self.initial_orbit:
            _dict['initialOrbit'] = self.initial_orbit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of final_orbit
        if self.final_orbit:
            _dict['finalOrbit'] = self.final_orbit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of drag_perturbation
        if self.drag_perturbation:
            _dict['dragPerturbation'] = self.drag_perturbation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of earth_potential_perturbation
        if self.earth_potential_perturbation:
            _dict['earthPotentialPerturbation'] = self.earth_potential_perturbation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of solar_radiation_pressure_perturbation
        if self.solar_radiation_pressure_perturbation:
            _dict['solarRadiationPressurePerturbation'] = self.solar_radiation_pressure_perturbation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of third_body_perturbation
        if self.third_body_perturbation:
            _dict['thirdBodyPerturbation'] = self.third_body_perturbation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StudyInputs from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "propulsionSystem": PropulsionSystem.from_dict(obj["propulsionSystem"]) if obj.get("propulsionSystem") is not None else None,
            "spacecraftGeometry": SpacecraftGeometry.from_dict(obj["spacecraftGeometry"]) if obj.get("spacecraftGeometry") is not None else None,
            "platform": Platform.from_dict(obj["platform"]) if obj.get("platform") is not None else None,
            "initialOrbit": Orbit.from_dict(obj["initialOrbit"]) if obj.get("initialOrbit") is not None else None,
            "finalOrbit": Orbit.from_dict(obj["finalOrbit"]) if obj.get("finalOrbit") is not None else None,
            "dragPerturbation": DragPerturbation.from_dict(obj["dragPerturbation"]) if obj.get("dragPerturbation") is not None else None,
            "earthPotentialPerturbation": EarthPotentialPerturbation.from_dict(obj["earthPotentialPerturbation"]) if obj.get("earthPotentialPerturbation") is not None else None,
            "solarRadiationPressurePerturbation": SolarRadiationPressurePerturbation.from_dict(obj["solarRadiationPressurePerturbation"]) if obj.get("solarRadiationPressurePerturbation") is not None else None,
            "thirdBodyPerturbation": ThirdBodyPerturbation.from_dict(obj["thirdBodyPerturbation"]) if obj.get("thirdBodyPerturbation") is not None else None
        })
        return _obj


