# coding: utf-8

"""
    Spacestudio API documentation

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacestudio_satellite_client.models.computation import Computation
from spacestudio_satellite_client.models.computation_status import ComputationStatus
from typing import Optional, Set
from typing_extensions import Self

class StudyComputation(BaseModel):
    """
    StudyComputation
    """ # noqa: E501
    progress: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The study computation progress, between 0.0 and 100.0")
    errors: Optional[List[StrictStr]] = Field(default=None, description="An optional list of study computation errors")
    status: Optional[ComputationStatus] = None
    baseline: Optional[Computation] = None
    cases: Optional[List[Computation]] = Field(default=None, description="The study computation results")
    __properties: ClassVar[List[str]] = ["progress", "errors", "status", "baseline", "cases"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StudyComputation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of baseline
        if self.baseline:
            _dict['baseline'] = self.baseline.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in cases (list)
        _items = []
        if self.cases:
            for _item in self.cases:
                if _item:
                    _items.append(_item.to_dict())
            _dict['cases'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StudyComputation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "progress": obj.get("progress"),
            "errors": obj.get("errors"),
            "status": obj.get("status"),
            "baseline": Computation.from_dict(obj["baseline"]) if obj.get("baseline") is not None else None,
            "cases": [Computation.from_dict(_item) for _item in obj["cases"]] if obj.get("cases") is not None else None
        })
        return _obj


