# coding: utf-8

"""
    Spacestudio API documentation

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from spacestudio_satellite_client.models.comparison_item import ComparisonItem
from spacestudio_satellite_client.models.display_configuration import DisplayConfiguration
from spacestudio_satellite_client.models.study_computation import StudyComputation
from spacestudio_satellite_client.models.study_inputs import StudyInputs
from spacestudio_satellite_client.models.study_parameters import StudyParameters
from typing import Optional, Set
from typing_extensions import Self

class Study(BaseModel):
    """
    Study
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The study unique identifier")
    name: StrictStr = Field(description="The study name")
    description: Optional[StrictStr] = Field(default=None, description="An optional description of the study")
    scenario_id: Optional[StrictStr] = Field(default=None, description="An optional identifier of a scenario associated to this study", alias="scenarioId")
    scenario_state_id: Optional[StrictStr] = Field(default=None, description="An optional identifier of a scenario state associated to this study", alias="scenarioStateId")
    parameters: Optional[StudyParameters] = None
    inputs: Optional[StudyInputs] = None
    comparison_items: Optional[List[ComparisonItem]] = Field(default=None, description="An optional list of comparison items to compute trade-offs on the study inputs", alias="comparisonItems")
    computation: Optional[StudyComputation] = None
    display_configuration: Optional[DisplayConfiguration] = Field(default=None, alias="displayConfiguration")
    need_recomputation: Optional[StrictBool] = Field(default=None, description="A flag indicating if the study needs to be recomputed", alias="needRecomputation")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "scenarioId", "scenarioStateId", "parameters", "inputs", "comparisonItems", "computation", "displayConfiguration", "needRecomputation"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Study from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of parameters
        if self.parameters:
            _dict['parameters'] = self.parameters.to_dict()
        # override the default output from pydantic by calling `to_dict()` of inputs
        if self.inputs:
            _dict['inputs'] = self.inputs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in comparison_items (list)
        _items = []
        if self.comparison_items:
            for _item in self.comparison_items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['comparisonItems'] = _items
        # override the default output from pydantic by calling `to_dict()` of computation
        if self.computation:
            _dict['computation'] = self.computation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of display_configuration
        if self.display_configuration:
            _dict['displayConfiguration'] = self.display_configuration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Study from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "scenarioId": obj.get("scenarioId"),
            "scenarioStateId": obj.get("scenarioStateId"),
            "parameters": StudyParameters.from_dict(obj["parameters"]) if obj.get("parameters") is not None else None,
            "inputs": StudyInputs.from_dict(obj["inputs"]) if obj.get("inputs") is not None else None,
            "comparisonItems": [ComparisonItem.from_dict(_item) for _item in obj["comparisonItems"]] if obj.get("comparisonItems") is not None else None,
            "computation": StudyComputation.from_dict(obj["computation"]) if obj.get("computation") is not None else None,
            "displayConfiguration": DisplayConfiguration.from_dict(obj["displayConfiguration"]) if obj.get("displayConfiguration") is not None else None,
            "needRecomputation": obj.get("needRecomputation")
        })
        return _obj


