# coding: utf-8

"""
    Spacestudio API documentation

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class SpacecraftGeometry(BaseModel):
    """
    SpacecraftGeometry
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The spacecraft geometry unique identifier")
    name: Optional[StrictStr] = Field(default=None, description="The spacecraft geometry name")
    scope: Optional[StrictStr] = Field(default=None, description="The spacecraft geometry scope")
    x: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry x coordinate")
    y: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry y coordinate")
    z: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry z coordinate")
    inertial_center_in_spacecraft_frame_x: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry inertial center in spacecraft frame x coordinate", alias="inertialCenterInSpacecraftFrameX")
    inertial_center_in_spacecraft_frame_y: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry inertial center in spacecraft frame y coordinate", alias="inertialCenterInSpacecraftFrameY")
    inertial_center_in_spacecraft_frame_z: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry inertial center in spacecraft frame z coordinate", alias="inertialCenterInSpacecraftFrameZ")
    inertia_xx: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry inertia XX", alias="inertiaXX")
    inertia_xy: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry inertia XY", alias="inertiaXY")
    inertia_xz: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry inertia XZ", alias="inertiaXZ")
    inertia_yx: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry inertia YX", alias="inertiaYX")
    inertia_yy: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry inertia YY", alias="inertiaYY")
    inertia_yz: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry inertia YZ", alias="inertiaYZ")
    inertia_zx: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry inertia ZX", alias="inertiaZX")
    inertia_zy: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry inertia ZY", alias="inertiaZY")
    inertia_zz: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry inertia ZZ", alias="inertiaZZ")
    thruster_axis_in_satellite_frame_x: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry thruster axis in satellite frame x coordinate", alias="thrusterAxisInSatelliteFrameX")
    thruster_axis_in_satellite_frame_y: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry thruster axis in satellite frame y coordinate", alias="thrusterAxisInSatelliteFrameY")
    thruster_axis_in_satellite_frame_z: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry thruster axis in satellite frame z coordinate", alias="thrusterAxisInSatelliteFrameZ")
    solar_array_efficiency: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry solar array efficiency", alias="solarArrayEfficiency")
    solar_array_maximum_power: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry solar array maximum power", alias="solarArrayMaximumPower")
    solar_array_surface: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry solar array surface", alias="solarArraySurface")
    solar_array_axis_in_satellite_frame_x: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry solar array axis in satellite frame x coordinate", alias="solarArrayAxisInSatelliteFrameX")
    solar_array_axis_in_satellite_frame_y: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry solar array axis in satellite frame y coordinate", alias="solarArrayAxisInSatelliteFrameY")
    solar_array_axis_in_satellite_frame_z: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry solar array axis in satellite frame z coordinate", alias="solarArrayAxisInSatelliteFrameZ")
    solar_array_normal_in_satellite_frame_x: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry solar array normal in satellite frame x coordinate", alias="solarArrayNormalInSatelliteFrameX")
    solar_array_normal_in_satellite_frame_y: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry solar array normal in satellite frame y coordinate", alias="solarArrayNormalInSatelliteFrameY")
    solar_array_normal_in_satellite_frame_z: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry solar array normal in satellite frame z coordinate", alias="solarArrayNormalInSatelliteFrameZ")
    payload_pointing_axis_in_satellite_frame_x: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry payload pointing axis in satellite frame x coordinate", alias="payloadPointingAxisInSatelliteFrameX")
    payload_pointing_axis_in_satellite_frame_y: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry payload pointing axis in satellite frame y coordinate", alias="payloadPointingAxisInSatelliteFrameY")
    payload_pointing_axis_in_satellite_frame_z: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry payload pointing axis in satellite frame z coordinate", alias="payloadPointingAxisInSatelliteFrameZ")
    antenna_pointing_axis_in_satellite_frame_x: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry antenna pointing axis in satellite frame x coordinate", alias="antennaPointingAxisInSatelliteFrameX")
    antenna_pointing_axis_in_satellite_frame_y: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry antenna pointing axis in satellite frame y coordinate", alias="antennaPointingAxisInSatelliteFrameY")
    antenna_pointing_axis_in_satellite_frame_z: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry antenna pointing axis in satellite frame z coordinate", alias="antennaPointingAxisInSatelliteFrameZ")
    spherical_cross_section: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spacecraft geometry spherical cross section", alias="sphericalCrossSection")
    body_solar_array_faces: Optional[List[StrictStr]] = Field(default=None, description="The spacecraft geometry body solar array faces", alias="bodySolarArrayFaces")
    solar_array_definition_type: Optional[StrictStr] = Field(default=None, description="The spacecraft geometry solar array definition type", alias="solarArrayDefinitionType")
    solar_array_type: Optional[StrictStr] = Field(default=None, description="The spacecraft geometry solar array type", alias="solarArrayType")
    type: Optional[StrictStr] = Field(default=None, description="The spacecraft geometry type")
    __properties: ClassVar[List[str]] = ["id", "name", "scope", "x", "y", "z", "inertialCenterInSpacecraftFrameX", "inertialCenterInSpacecraftFrameY", "inertialCenterInSpacecraftFrameZ", "inertiaXX", "inertiaXY", "inertiaXZ", "inertiaYX", "inertiaYY", "inertiaYZ", "inertiaZX", "inertiaZY", "inertiaZZ", "thrusterAxisInSatelliteFrameX", "thrusterAxisInSatelliteFrameY", "thrusterAxisInSatelliteFrameZ", "solarArrayEfficiency", "solarArrayMaximumPower", "solarArraySurface", "solarArrayAxisInSatelliteFrameX", "solarArrayAxisInSatelliteFrameY", "solarArrayAxisInSatelliteFrameZ", "solarArrayNormalInSatelliteFrameX", "solarArrayNormalInSatelliteFrameY", "solarArrayNormalInSatelliteFrameZ", "payloadPointingAxisInSatelliteFrameX", "payloadPointingAxisInSatelliteFrameY", "payloadPointingAxisInSatelliteFrameZ", "antennaPointingAxisInSatelliteFrameX", "antennaPointingAxisInSatelliteFrameY", "antennaPointingAxisInSatelliteFrameZ", "sphericalCrossSection", "bodySolarArrayFaces", "solarArrayDefinitionType", "solarArrayType", "type"]

    @field_validator('body_solar_array_faces')
    def body_solar_array_faces_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['PLUS_X', 'MINUS_X', 'PLUS_Y', 'MINUS_Y', 'PLUS_Z', 'MINUS_Z']):
                raise ValueError("each list item must be one of ('PLUS_X', 'MINUS_X', 'PLUS_Y', 'MINUS_Y', 'PLUS_Z', 'MINUS_Z')")
        return value

    @field_validator('solar_array_definition_type')
    def solar_array_definition_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['MAXIMUM_POWER', 'SURFACE', 'SURFACE_AND_POWER']):
            raise ValueError("must be one of enum values ('MAXIMUM_POWER', 'SURFACE', 'SURFACE_AND_POWER')")
        return value

    @field_validator('solar_array_type')
    def solar_array_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NONE', 'DEPLOYABLE_ROTATING', 'DEPLOYABLE_FIXED', 'BODY']):
            raise ValueError("must be one of enum values ('NONE', 'DEPLOYABLE_ROTATING', 'DEPLOYABLE_FIXED', 'BODY')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SPHERE', 'BOX']):
            raise ValueError("must be one of enum values ('SPHERE', 'BOX')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SpacecraftGeometry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SpacecraftGeometry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "scope": obj.get("scope"),
            "x": obj.get("x"),
            "y": obj.get("y"),
            "z": obj.get("z"),
            "inertialCenterInSpacecraftFrameX": obj.get("inertialCenterInSpacecraftFrameX"),
            "inertialCenterInSpacecraftFrameY": obj.get("inertialCenterInSpacecraftFrameY"),
            "inertialCenterInSpacecraftFrameZ": obj.get("inertialCenterInSpacecraftFrameZ"),
            "inertiaXX": obj.get("inertiaXX"),
            "inertiaXY": obj.get("inertiaXY"),
            "inertiaXZ": obj.get("inertiaXZ"),
            "inertiaYX": obj.get("inertiaYX"),
            "inertiaYY": obj.get("inertiaYY"),
            "inertiaYZ": obj.get("inertiaYZ"),
            "inertiaZX": obj.get("inertiaZX"),
            "inertiaZY": obj.get("inertiaZY"),
            "inertiaZZ": obj.get("inertiaZZ"),
            "thrusterAxisInSatelliteFrameX": obj.get("thrusterAxisInSatelliteFrameX"),
            "thrusterAxisInSatelliteFrameY": obj.get("thrusterAxisInSatelliteFrameY"),
            "thrusterAxisInSatelliteFrameZ": obj.get("thrusterAxisInSatelliteFrameZ"),
            "solarArrayEfficiency": obj.get("solarArrayEfficiency"),
            "solarArrayMaximumPower": obj.get("solarArrayMaximumPower"),
            "solarArraySurface": obj.get("solarArraySurface"),
            "solarArrayAxisInSatelliteFrameX": obj.get("solarArrayAxisInSatelliteFrameX"),
            "solarArrayAxisInSatelliteFrameY": obj.get("solarArrayAxisInSatelliteFrameY"),
            "solarArrayAxisInSatelliteFrameZ": obj.get("solarArrayAxisInSatelliteFrameZ"),
            "solarArrayNormalInSatelliteFrameX": obj.get("solarArrayNormalInSatelliteFrameX"),
            "solarArrayNormalInSatelliteFrameY": obj.get("solarArrayNormalInSatelliteFrameY"),
            "solarArrayNormalInSatelliteFrameZ": obj.get("solarArrayNormalInSatelliteFrameZ"),
            "payloadPointingAxisInSatelliteFrameX": obj.get("payloadPointingAxisInSatelliteFrameX"),
            "payloadPointingAxisInSatelliteFrameY": obj.get("payloadPointingAxisInSatelliteFrameY"),
            "payloadPointingAxisInSatelliteFrameZ": obj.get("payloadPointingAxisInSatelliteFrameZ"),
            "antennaPointingAxisInSatelliteFrameX": obj.get("antennaPointingAxisInSatelliteFrameX"),
            "antennaPointingAxisInSatelliteFrameY": obj.get("antennaPointingAxisInSatelliteFrameY"),
            "antennaPointingAxisInSatelliteFrameZ": obj.get("antennaPointingAxisInSatelliteFrameZ"),
            "sphericalCrossSection": obj.get("sphericalCrossSection"),
            "bodySolarArrayFaces": obj.get("bodySolarArrayFaces"),
            "solarArrayDefinitionType": obj.get("solarArrayDefinitionType"),
            "solarArrayType": obj.get("solarArrayType"),
            "type": obj.get("type")
        })
        return _obj


