# coding: utf-8

"""
    Spacestudio API documentation

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacestudio_satellite_client.models.computation_outputs import ComputationOutputs
from spacestudio_satellite_client.models.computation_type import ComputationType
from spacestudio_satellite_client.models.numerical_ephemeris import NumericalEphemeris
from typing import Optional, Set
from typing_extensions import Self

class SingleSatelliteNumericalComputationOutputs(ComputationOutputs):
    """
    SingleSatelliteNumericalComputationOutputs
    """ # noqa: E501
    ephemerides_frame: Optional[StrictStr] = Field(default=None, description="TODO", alias="ephemeridesFrame")
    number_of_burns: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="TODO", alias="numberOfBurns")
    thrust_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="TODO", alias="thrustDuration")
    used_propellant: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="TODO", alias="usedPropellant")
    delta_v: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="TODO", alias="deltaV")
    thruster_mean_duty_cycle: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="TODO", alias="thrusterMeanDutyCycle")
    total_warmup_duty_cycle: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="TODO", alias="totalWarmupDutyCycle")
    mean_burn_duration_estimation: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="TODO", alias="meanBurnDurationEstimation")
    mission_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="TODO", alias="missionDuration")
    number_of_period: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="TODO", alias="numberOfPeriod")
    total_impulse: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="TODO", alias="totalImpulse")
    final_duty_cycle: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="TODO", alias="finalDutyCycle")
    ephemeris: Optional[NumericalEphemeris] = None
    __properties: ClassVar[List[str]] = ["type", "ephemeridesFrame", "numberOfBurns", "thrustDuration", "usedPropellant", "deltaV", "thrusterMeanDutyCycle", "totalWarmupDutyCycle", "meanBurnDurationEstimation", "missionDuration", "numberOfPeriod", "totalImpulse", "finalDutyCycle", "ephemeris"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SingleSatelliteNumericalComputationOutputs from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ephemeris
        if self.ephemeris:
            _dict['ephemeris'] = self.ephemeris.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SingleSatelliteNumericalComputationOutputs from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "ephemeridesFrame": obj.get("ephemeridesFrame"),
            "numberOfBurns": obj.get("numberOfBurns"),
            "thrustDuration": obj.get("thrustDuration"),
            "usedPropellant": obj.get("usedPropellant"),
            "deltaV": obj.get("deltaV"),
            "thrusterMeanDutyCycle": obj.get("thrusterMeanDutyCycle"),
            "totalWarmupDutyCycle": obj.get("totalWarmupDutyCycle"),
            "meanBurnDurationEstimation": obj.get("meanBurnDurationEstimation"),
            "missionDuration": obj.get("missionDuration"),
            "numberOfPeriod": obj.get("numberOfPeriod"),
            "totalImpulse": obj.get("totalImpulse"),
            "finalDutyCycle": obj.get("finalDutyCycle"),
            "ephemeris": NumericalEphemeris.from_dict(obj["ephemeris"]) if obj.get("ephemeris") is not None else None
        })
        return _obj


