# coding: utf-8

"""
    Spacestudio API documentation

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from spacestudio_satellite_client.models.drag_perturbation import DragPerturbation
from spacestudio_satellite_client.models.earth_potential_perturbation import EarthPotentialPerturbation
from spacestudio_satellite_client.models.payload import Payload
from spacestudio_satellite_client.models.platform import Platform
from spacestudio_satellite_client.models.propulsion_system import PropulsionSystem
from spacestudio_satellite_client.models.solar_radiation_pressure_perturbation import SolarRadiationPressurePerturbation
from spacestudio_satellite_client.models.spacecraft_geometry import SpacecraftGeometry
from spacestudio_satellite_client.models.third_body_perturbation import ThirdBodyPerturbation
from spacestudio_satellite_client.models.timeline_slot import TimelineSlot
from typing import Optional, Set
from typing_extensions import Self

class ScenarioBaseline(BaseModel):
    """
    ScenarioBaseline
    """ # noqa: E501
    valid: Optional[StrictBool] = Field(default=None, description="Indicates whether this baseline is valid or not.")
    propulsion_system: Optional[PropulsionSystem] = Field(default=None, alias="propulsionSystem")
    platform: Optional[Platform] = None
    payload: Optional[Payload] = None
    spacecraft_geometry: Optional[SpacecraftGeometry] = Field(default=None, alias="spacecraftGeometry")
    timeline: Optional[List[TimelineSlot]] = Field(default=None, description="The baseline timeline.")
    drag_perturbation: Optional[DragPerturbation] = Field(default=None, alias="dragPerturbation")
    earth_potential_perturbation: Optional[EarthPotentialPerturbation] = Field(default=None, alias="earthPotentialPerturbation")
    solar_radiation_pressure_perturbation: Optional[SolarRadiationPressurePerturbation] = Field(default=None, alias="solarRadiationPressurePerturbation")
    third_body_perturbation: Optional[ThirdBodyPerturbation] = Field(default=None, alias="thirdBodyPerturbation")
    computation_status: Optional[StrictStr] = Field(default=None, description="Indicates whether the baseline computation is terminated or not.", alias="computationStatus")
    numerical_computation_required: Optional[StrictBool] = Field(default=None, description="Indicates whether this baseline requires numerical computation.", alias="numericalComputationRequired")
    __properties: ClassVar[List[str]] = ["valid", "propulsionSystem", "platform", "payload", "spacecraftGeometry", "timeline", "dragPerturbation", "earthPotentialPerturbation", "solarRadiationPressurePerturbation", "thirdBodyPerturbation", "computationStatus", "numericalComputationRequired"]

    @field_validator('computation_status')
    def computation_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['RUNNING', 'TERMINATED']):
            raise ValueError("must be one of enum values ('RUNNING', 'TERMINATED')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScenarioBaseline from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of propulsion_system
        if self.propulsion_system:
            _dict['propulsionSystem'] = self.propulsion_system.to_dict()
        # override the default output from pydantic by calling `to_dict()` of platform
        if self.platform:
            _dict['platform'] = self.platform.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payload
        if self.payload:
            _dict['payload'] = self.payload.to_dict()
        # override the default output from pydantic by calling `to_dict()` of spacecraft_geometry
        if self.spacecraft_geometry:
            _dict['spacecraftGeometry'] = self.spacecraft_geometry.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in timeline (list)
        _items = []
        if self.timeline:
            for _item in self.timeline:
                if _item:
                    _items.append(_item.to_dict())
            _dict['timeline'] = _items
        # override the default output from pydantic by calling `to_dict()` of drag_perturbation
        if self.drag_perturbation:
            _dict['dragPerturbation'] = self.drag_perturbation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of earth_potential_perturbation
        if self.earth_potential_perturbation:
            _dict['earthPotentialPerturbation'] = self.earth_potential_perturbation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of solar_radiation_pressure_perturbation
        if self.solar_radiation_pressure_perturbation:
            _dict['solarRadiationPressurePerturbation'] = self.solar_radiation_pressure_perturbation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of third_body_perturbation
        if self.third_body_perturbation:
            _dict['thirdBodyPerturbation'] = self.third_body_perturbation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScenarioBaseline from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "valid": obj.get("valid"),
            "propulsionSystem": PropulsionSystem.from_dict(obj["propulsionSystem"]) if obj.get("propulsionSystem") is not None else None,
            "platform": Platform.from_dict(obj["platform"]) if obj.get("platform") is not None else None,
            "payload": Payload.from_dict(obj["payload"]) if obj.get("payload") is not None else None,
            "spacecraftGeometry": SpacecraftGeometry.from_dict(obj["spacecraftGeometry"]) if obj.get("spacecraftGeometry") is not None else None,
            "timeline": [TimelineSlot.from_dict(_item) for _item in obj["timeline"]] if obj.get("timeline") is not None else None,
            "dragPerturbation": DragPerturbation.from_dict(obj["dragPerturbation"]) if obj.get("dragPerturbation") is not None else None,
            "earthPotentialPerturbation": EarthPotentialPerturbation.from_dict(obj["earthPotentialPerturbation"]) if obj.get("earthPotentialPerturbation") is not None else None,
            "solarRadiationPressurePerturbation": SolarRadiationPressurePerturbation.from_dict(obj["solarRadiationPressurePerturbation"]) if obj.get("solarRadiationPressurePerturbation") is not None else None,
            "thirdBodyPerturbation": ThirdBodyPerturbation.from_dict(obj["thirdBodyPerturbation"]) if obj.get("thirdBodyPerturbation") is not None else None,
            "computationStatus": obj.get("computationStatus"),
            "numericalComputationRequired": obj.get("numericalComputationRequired")
        })
        return _obj


