# coding: utf-8

"""
    Spacestudio API documentation

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from spacestudio_satellite_client.models.scenario_baseline import ScenarioBaseline
from typing import Optional, Set
from typing_extensions import Self

class Scenario(BaseModel):
    """
    Scenario
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The scenario unique identifier")
    name: Optional[StrictStr] = Field(default=None, description="Scenario name")
    description: Optional[StrictStr] = Field(default=None, description="Scenario description")
    last_update: Optional[datetime] = Field(default=None, description="Last update date/time", alias="lastUpdate")
    tags: Optional[List[StrictStr]] = None
    budget_parameters: Optional[List[StrictStr]] = Field(default=None, alias="budgetParameters")
    baseline: Optional[ScenarioBaseline] = None
    __properties: ClassVar[List[str]] = ["id", "name", "description", "lastUpdate", "tags", "budgetParameters", "baseline"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Scenario from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of baseline
        if self.baseline:
            _dict['baseline'] = self.baseline.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Scenario from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "lastUpdate": obj.get("lastUpdate"),
            "tags": obj.get("tags"),
            "budgetParameters": obj.get("budgetParameters"),
            "baseline": ScenarioBaseline.from_dict(obj["baseline"]) if obj.get("baseline") is not None else None
        })
        return _obj


