# coding: utf-8

"""
    Spacestudio API documentation

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacestudio_satellite_client.models.maneuver import Maneuver
from typing import Optional, Set
from typing_extensions import Self

class RaanPhasing(Maneuver):
    """
    RaanPhasing
    """ # noqa: E501
    coasting_domain: Optional[StrictStr] = Field(default=None, description="The domain of the coasting phase.", alias="coastingDomain")
    optimization_type: Optional[StrictStr] = Field(default=None, description="The type of optimization to perform.", alias="optimizationType")
    raan_phasing_reference: Optional[StrictStr] = Field(default=None, description="The reference for the RAAN phasing.", alias="raanPhasingReference")
    target_raan_ltan_type: Optional[StrictStr] = Field(default=None, description="The type of RAAN/LTAN to target.", alias="targetRaanLtanType")
    target_mission_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The target mission duration.", alias="targetMissionDuration")
    target_delta_ltan: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The target delta LTAN.", alias="targetDeltaLtan")
    target_delta_raan: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The target delta RAAN.", alias="targetDeltaRaan")
    target_delta_vmax: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The target delta Vmax.", alias="targetDeltaVmax")
    min_coasting_altitude: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The minimum coasting altitude.", alias="minCoastingAltitude")
    max_coasting_altitude: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The maximum coasting altitude.", alias="maxCoastingAltitude")
    min_coasting_inclination: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The minimum coasting inclination.", alias="minCoastingInclination")
    max_coasting_inclination: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The maximum coasting inclination.", alias="maxCoastingInclination")
    __properties: ClassVar[List[str]] = ["type", "coastingDomain", "optimizationType", "raanPhasingReference", "targetRaanLtanType", "targetMissionDuration", "targetDeltaLtan", "targetDeltaRaan", "targetDeltaVmax", "minCoastingAltitude", "maxCoastingAltitude", "minCoastingInclination", "maxCoastingInclination"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RaanPhasing from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RaanPhasing from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "coastingDomain": obj.get("coastingDomain"),
            "optimizationType": obj.get("optimizationType"),
            "raanPhasingReference": obj.get("raanPhasingReference"),
            "targetRaanLtanType": obj.get("targetRaanLtanType"),
            "targetMissionDuration": obj.get("targetMissionDuration"),
            "targetDeltaLtan": obj.get("targetDeltaLtan"),
            "targetDeltaRaan": obj.get("targetDeltaRaan"),
            "targetDeltaVmax": obj.get("targetDeltaVmax"),
            "minCoastingAltitude": obj.get("minCoastingAltitude"),
            "maxCoastingAltitude": obj.get("maxCoastingAltitude"),
            "minCoastingInclination": obj.get("minCoastingInclination"),
            "maxCoastingInclination": obj.get("maxCoastingInclination")
        })
        return _obj


