# coding: utf-8

"""
    Spacestudio API documentation

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class PropulsionSystem(BaseModel):
    """
    PropulsionSystem
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The propulsion system unique identifier")
    name: Optional[StrictStr] = Field(default=None, description="The propulsion system name")
    scope: Optional[StrictStr] = Field(default=None, description="The propulsion system scope")
    isp: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The propulsion system specific impulse")
    power: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The propulsion system power")
    thrust: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The propulsion system thrust")
    standby_power: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The propulsion system stand by power", alias="standbyPower")
    warm_up_power: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The propulsion system warm up power", alias="warmUpPower")
    warm_up_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The propulsion system warm up duration", alias="warmUpDuration")
    propellant_mass: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The propulsion system propellant mass", alias="propellantMass")
    total_mass: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The propulsion system total mass", alias="totalMass")
    total_impulse: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The propulsion system total impulse", alias="totalImpulse")
    maximum_thrust_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The propulsion system maximum thrust duration", alias="maximumThrustDuration")
    consumption: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The propulsion system consumption")
    propellant_capacity_choice: Optional[StrictStr] = Field(default=None, description="The propulsion system propellant capacity choice", alias="propellantCapacityChoice")
    propulsion_system_type: Optional[StrictStr] = Field(default=None, description="The propulsion system type", alias="propulsionSystemType")
    __properties: ClassVar[List[str]] = ["id", "name", "scope", "isp", "power", "thrust", "standbyPower", "warmUpPower", "warmUpDuration", "propellantMass", "totalMass", "totalImpulse", "maximumThrustDuration", "consumption", "propellantCapacityChoice", "propulsionSystemType"]

    @field_validator('propellant_capacity_choice')
    def propellant_capacity_choice_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PROPELLANT', 'TOTAL_IMPULSE']):
            raise ValueError("must be one of enum values ('PROPELLANT', 'TOTAL_IMPULSE')")
        return value

    @field_validator('propulsion_system_type')
    def propulsion_system_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CHEMICAL', 'ELECTRICAL']):
            raise ValueError("must be one of enum values ('CHEMICAL', 'ELECTRICAL')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PropulsionSystem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PropulsionSystem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "scope": obj.get("scope"),
            "isp": obj.get("isp"),
            "power": obj.get("power"),
            "thrust": obj.get("thrust"),
            "standbyPower": obj.get("standbyPower"),
            "warmUpPower": obj.get("warmUpPower"),
            "warmUpDuration": obj.get("warmUpDuration"),
            "propellantMass": obj.get("propellantMass"),
            "totalMass": obj.get("totalMass"),
            "totalImpulse": obj.get("totalImpulse"),
            "maximumThrustDuration": obj.get("maximumThrustDuration"),
            "consumption": obj.get("consumption"),
            "propellantCapacityChoice": obj.get("propellantCapacityChoice"),
            "propulsionSystemType": obj.get("propulsionSystemType")
        })
        return _obj


