# coding: utf-8

"""
    Spacestudio API documentation

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class NumericalOutputsConfiguration(BaseModel):
    """
    NumericalOutputsConfiguration
    """ # noqa: E501
    ephemerides_requested: Optional[List[StrictStr]] = Field(default=None, description="The types of requested ephemerides types", alias="ephemeridesRequested")
    ephemerides_step_in_seconds: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The ephemerides step (in seconds)", alias="ephemeridesStepInSeconds")
    ephemerides_mean_choice: Optional[StrictBool] = Field(default=None, description="TBD", alias="ephemeridesMeanChoice")
    ephemerides_osc_choice: Optional[StrictBool] = Field(default=None, description="TBD", alias="ephemeridesOscChoice")
    ephemerides_file_types_requested: Optional[List[StrictStr]] = Field(default=None, description="The types of requested ephemerides file types", alias="ephemeridesFileTypesRequested")
    __properties: ClassVar[List[str]] = ["ephemeridesRequested", "ephemeridesStepInSeconds", "ephemeridesMeanChoice", "ephemeridesOscChoice", "ephemeridesFileTypesRequested"]

    @field_validator('ephemerides_requested')
    def ephemerides_requested_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['CARTESIAN', 'KEPLERIAN', 'CIRCULAR', 'EQUINOCTIAL', 'THRUST', 'SYSTEM', 'ECLIPSE', 'ATTITUDE', 'MANOEUVRING_STRATEGIES', 'THRUSTER_AXES_CONSUMPTION', 'LINK_BUDGET']):
                raise ValueError("each list item must be one of ('CARTESIAN', 'KEPLERIAN', 'CIRCULAR', 'EQUINOCTIAL', 'THRUST', 'SYSTEM', 'ECLIPSE', 'ATTITUDE', 'MANOEUVRING_STRATEGIES', 'THRUSTER_AXES_CONSUMPTION', 'LINK_BUDGET')")
        return value

    @field_validator('ephemerides_file_types_requested')
    def ephemerides_file_types_requested_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['CCSDS_ATTITUDE_EPHEMERIS_MESSAGE', 'CCSDS_ORBIT_EPHEMERIS_MESSAGE', 'CIC_ATTITUDE_EPHEMERIS_MESSAGE', 'CIC_ORBIT_EPHEMERIS_MESSAGE']):
                raise ValueError("each list item must be one of ('CCSDS_ATTITUDE_EPHEMERIS_MESSAGE', 'CCSDS_ORBIT_EPHEMERIS_MESSAGE', 'CIC_ATTITUDE_EPHEMERIS_MESSAGE', 'CIC_ORBIT_EPHEMERIS_MESSAGE')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NumericalOutputsConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NumericalOutputsConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ephemeridesRequested": obj.get("ephemeridesRequested"),
            "ephemeridesStepInSeconds": obj.get("ephemeridesStepInSeconds"),
            "ephemeridesMeanChoice": obj.get("ephemeridesMeanChoice"),
            "ephemeridesOscChoice": obj.get("ephemeridesOscChoice"),
            "ephemeridesFileTypesRequested": obj.get("ephemeridesFileTypesRequested")
        })
        return _obj


