# coding: utf-8

"""
    Spacestudio API documentation

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from spacestudio_satellite_client.models.notification_content import NotificationContent
from typing import Optional, Set
from typing_extensions import Self

class Notification(BaseModel):
    """
    Notification
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The notification unique identifier")
    notification_content: NotificationContent = Field(alias="notificationContent")
    creation_date: StrictStr = Field(description="The expiration date of the notification", alias="creationDate")
    user_id: StrictStr = Field(description="The user identifier ", alias="userId")
    author: StrictStr = Field(description="The author of the notification ")
    announcement_id: Optional[StrictStr] = Field(default=None, description="The announcement identifier that create this notification", alias="announcementId")
    __properties: ClassVar[List[str]] = ["id", "notificationContent", "creationDate", "userId", "author", "announcementId"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Notification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of notification_content
        if self.notification_content:
            _dict['notificationContent'] = self.notification_content.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Notification from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "notificationContent": NotificationContent.from_dict(obj["notificationContent"]) if obj.get("notificationContent") is not None else None,
            "creationDate": obj.get("creationDate"),
            "userId": obj.get("userId"),
            "author": obj.get("author"),
            "announcementId": obj.get("announcementId")
        })
        return _obj


