# coding: utf-8

"""
    Spacestudio API documentation

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacestudio_satellite_client.models.thrust_arcs_position import ThrustArcsPosition
from typing import Optional, Set
from typing_extensions import Self

class ManeuveringStrategy(BaseModel):
    """
    ManeuveringStrategy
    """ # noqa: E501
    maneuvering_strategy_choice: Optional[StrictStr] = Field(default=None, description="The maneuvering strategy choice", alias="maneuveringStrategyChoice")
    number_of_rest_orbits: Optional[StrictInt] = Field(default=None, description="TBD", alias="numberOfRestOrbits")
    number_of_thrust_orbits: Optional[StrictInt] = Field(default=None, description="TBD", alias="numberOfThrustOrbits")
    number_of_shift_orbits: Optional[StrictInt] = Field(default=None, description="TBD", alias="numberOfShiftOrbits")
    thrust_arc_definition: Optional[StrictStr] = Field(default=None, description="TBD", alias="thrustArcDefinition")
    thrust_arc_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="TBD", alias="thrustArcDuration")
    orbital_duty_cycle: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="TBD", alias="orbitalDutyCycle")
    thrust_arcs_number: Optional[StrictStr] = Field(default=None, description="TBD", alias="thrustArcsNumber")
    thrust_arcs_position: Optional[ThrustArcsPosition] = Field(default=None, alias="thrustArcsPosition")
    reference: Optional[ThrustArcsPosition] = None
    delta_mean_longitude_argument: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="TBD", alias="deltaMeanLongitudeArgument")
    thrust_arc_mean_longitude_argument: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="TBD", alias="thrustArcMeanLongitudeArgument")
    stop_thrust_in_eclipse: Optional[StrictBool] = Field(default=None, description="TBD", alias="stopThrustInEclipse")
    dynamic_duty_cycle_simulated: Optional[StrictBool] = Field(default=None, description="TBD", alias="dynamicDutyCycleSimulated")
    __properties: ClassVar[List[str]] = ["maneuveringStrategyChoice", "numberOfRestOrbits", "numberOfThrustOrbits", "numberOfShiftOrbits", "thrustArcDefinition", "thrustArcDuration", "orbitalDutyCycle", "thrustArcsNumber", "thrustArcsPosition", "reference", "deltaMeanLongitudeArgument", "thrustArcMeanLongitudeArgument", "stopThrustInEclipse", "dynamicDutyCycleSimulated"]

    @field_validator('maneuvering_strategy_choice')
    def maneuvering_strategy_choice_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CUSTOM', 'DEFAULT']):
            raise ValueError("must be one of enum values ('CUSTOM', 'DEFAULT')")
        return value

    @field_validator('thrust_arc_definition')
    def thrust_arc_definition_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DUTY_CYCLE', 'THRUST_DURATION']):
            raise ValueError("must be one of enum values ('DUTY_CYCLE', 'THRUST_DURATION')")
        return value

    @field_validator('thrust_arcs_number')
    def thrust_arcs_number_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ONE', 'TWO']):
            raise ValueError("must be one of enum values ('ONE', 'TWO')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ManeuveringStrategy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ManeuveringStrategy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "maneuveringStrategyChoice": obj.get("maneuveringStrategyChoice"),
            "numberOfRestOrbits": obj.get("numberOfRestOrbits"),
            "numberOfThrustOrbits": obj.get("numberOfThrustOrbits"),
            "numberOfShiftOrbits": obj.get("numberOfShiftOrbits"),
            "thrustArcDefinition": obj.get("thrustArcDefinition"),
            "thrustArcDuration": obj.get("thrustArcDuration"),
            "orbitalDutyCycle": obj.get("orbitalDutyCycle"),
            "thrustArcsNumber": obj.get("thrustArcsNumber"),
            "thrustArcsPosition": obj.get("thrustArcsPosition"),
            "reference": obj.get("reference"),
            "deltaMeanLongitudeArgument": obj.get("deltaMeanLongitudeArgument"),
            "thrustArcMeanLongitudeArgument": obj.get("thrustArcMeanLongitudeArgument"),
            "stopThrustInEclipse": obj.get("stopThrustInEclipse"),
            "dynamicDutyCycleSimulated": obj.get("dynamicDutyCycleSimulated")
        })
        return _obj


