# coding: utf-8

"""
    Spacestudio API documentation

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import Field
from typing import Any, ClassVar, Dict, List, Optional
from spacestudio_satellite_client.models.computation import Computation
from spacestudio_satellite_client.models.computation_mode import ComputationMode
from spacestudio_satellite_client.models.maneuver import Maneuver
from spacestudio_satellite_client.models.orbit import Orbit
from spacestudio_satellite_client.models.timeline_slot import TimelineSlot
from typing import Optional, Set
from typing_extensions import Self

class ManeuverTimelineSlot(TimelineSlot):
    """
    ManeuverTimelineSlot
    """ # noqa: E501
    initial_orbit: Optional[Orbit] = Field(default=None, alias="initialOrbit")
    final_orbit: Optional[Orbit] = Field(default=None, alias="finalOrbit")
    maneuver: Optional[Maneuver] = None
    computation: Optional[Computation] = None
    computation_mode: Optional[ComputationMode] = Field(default=None, alias="computationMode")
    __properties: ClassVar[List[str]] = ["type", "id", "validity", "initialOrbit", "finalOrbit", "maneuver", "computation", "computationMode"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ManeuverTimelineSlot from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of initial_orbit
        if self.initial_orbit:
            _dict['initialOrbit'] = self.initial_orbit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of final_orbit
        if self.final_orbit:
            _dict['finalOrbit'] = self.final_orbit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of maneuver
        if self.maneuver:
            _dict['maneuver'] = self.maneuver.to_dict()
        # override the default output from pydantic by calling `to_dict()` of computation
        if self.computation:
            _dict['computation'] = self.computation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ManeuverTimelineSlot from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "id": obj.get("id"),
            "validity": obj.get("validity"),
            "initialOrbit": Orbit.from_dict(obj["initialOrbit"]) if obj.get("initialOrbit") is not None else None,
            "finalOrbit": Orbit.from_dict(obj["finalOrbit"]) if obj.get("finalOrbit") is not None else None,
            "maneuver": Maneuver.from_dict(obj["maneuver"]) if obj.get("maneuver") is not None else None,
            "computation": Computation.from_dict(obj["computation"]) if obj.get("computation") is not None else None,
            "computationMode": obj.get("computationMode")
        })
        return _obj


