# coding: utf-8

"""
    Spacestudio API documentation

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacestudio_satellite_client.models.baseline_configuration import BaselineConfiguration
from spacestudio_satellite_client.models.display_configuration_comparison_overview import DisplayConfigurationComparisonOverview
from spacestudio_satellite_client.models.tab import Tab
from typing import Optional, Set
from typing_extensions import Self

class DisplayConfiguration(BaseModel):
    """
    DisplayConfiguration
    """ # noqa: E501
    comparison_overview: Optional[DisplayConfigurationComparisonOverview] = Field(default=None, alias="comparisonOverview")
    baseline_configuration: Optional[BaselineConfiguration] = Field(default=None, alias="baselineConfiguration")
    tabs: Optional[List[Tab]] = None
    current_tab: Optional[Tab] = Field(default=None, alias="currentTab")
    __properties: ClassVar[List[str]] = ["comparisonOverview", "baselineConfiguration", "tabs", "currentTab"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DisplayConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of comparison_overview
        if self.comparison_overview:
            _dict['comparisonOverview'] = self.comparison_overview.to_dict()
        # override the default output from pydantic by calling `to_dict()` of baseline_configuration
        if self.baseline_configuration:
            _dict['baselineConfiguration'] = self.baseline_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tabs (list)
        _items = []
        if self.tabs:
            for _item in self.tabs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tabs'] = _items
        # override the default output from pydantic by calling `to_dict()` of current_tab
        if self.current_tab:
            _dict['currentTab'] = self.current_tab.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DisplayConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "comparisonOverview": DisplayConfigurationComparisonOverview.from_dict(obj["comparisonOverview"]) if obj.get("comparisonOverview") is not None else None,
            "baselineConfiguration": BaselineConfiguration.from_dict(obj["baselineConfiguration"]) if obj.get("baselineConfiguration") is not None else None,
            "tabs": [Tab.from_dict(_item) for _item in obj["tabs"]] if obj.get("tabs") is not None else None,
            "currentTab": Tab.from_dict(obj["currentTab"]) if obj.get("currentTab") is not None else None
        })
        return _obj


