# coding: utf-8

"""
    Spacestudio API documentation

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacestudio_satellite_client.models.comparison_item1 import ComparisonItem1
from spacestudio_satellite_client.models.computation_outputs import ComputationOutputs
from spacestudio_satellite_client.models.computation_status import ComputationStatus
from typing import Optional, Set
from typing_extensions import Self

class Computation(BaseModel):
    """
    Computation
    """ # noqa: E501
    id: StrictStr = Field(description="The computation unique identifier")
    errors: Optional[List[StrictStr]] = Field(default=None, description="In case of computation failure, a list of errors explaining the cause of the failure")
    progress: Union[StrictFloat, StrictInt] = Field(description="The computation progress, between 0.0 and 100.0")
    status: ComputationStatus
    comparison_items: Optional[List[ComparisonItem1]] = Field(default=None, description="The comparison item(s) used for this computation", alias="comparisonItems")
    outputs: Optional[ComputationOutputs] = None
    baseline: Optional[StrictBool] = Field(default=None, description="Indicates whether this computation corresponds to a study baseline or not.")
    __properties: ClassVar[List[str]] = ["id", "errors", "progress", "status", "comparisonItems", "outputs", "baseline"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Computation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in comparison_items (list)
        _items = []
        if self.comparison_items:
            for _item in self.comparison_items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['comparisonItems'] = _items
        # override the default output from pydantic by calling `to_dict()` of outputs
        if self.outputs:
            _dict['outputs'] = self.outputs.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Computation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "errors": obj.get("errors"),
            "progress": obj.get("progress"),
            "status": obj.get("status"),
            "comparisonItems": [ComparisonItem1.from_dict(_item) for _item in obj["comparisonItems"]] if obj.get("comparisonItems") is not None else None,
            "outputs": ComputationOutputs.from_dict(obj["outputs"]) if obj.get("outputs") is not None else None,
            "baseline": obj.get("baseline")
        })
        return _obj


