# coding: utf-8

"""
    Spacestudio API documentation

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ComparisonItem(BaseModel):
    """
    ComparisonItem
    """ # noqa: E501
    input: StrictStr = Field(description="The study input on which this comparison item applies (e.g. <b>propulsionSystem</b> or <b>finalOrbit</b>")
    field: Optional[StrictStr] = Field(default=None, description="In case of a comparison item on an object field (e.g. initial orbit altitude), the name of the field (e.g. <b>altitude</b>)")
    min: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="In case of a comparison item on an object field (e.g. initial orbit altitude), the lower bound value (e.g. <b>650000<b> for a 650km lower value)")
    max: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="In case of a comparison item on an object field (e.g. initial orbit altitude), the upper bound value (e.g. <b>750000<b> for a 750km upper value)")
    step: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="In case of a comparison item on an object field (e.g. initial orbit altitude), the step between two values (e.g. <b>10000<b> for a 10km step value)")
    points: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="In case of a comparison item on an object field (e.g. initial orbit altitude), the number of points to sample (e.g. 15 points)")
    ids: Optional[List[StrictStr]] = Field(default=None, description="In case of a comparison item on an entire object (e.g. propulsion system), the list of objects identifiers to use for the comparison")
    value: Optional[Dict[str, Any]] = Field(default=None, description="The value used for this comparison item")
    values: Optional[List[Dict[str, Any]]] = Field(default=None, description="The values used for this comparison item")
    __properties: ClassVar[List[str]] = ["input", "field", "min", "max", "step", "points", "ids", "value", "values"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ComparisonItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ComparisonItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "input": obj.get("input"),
            "field": obj.get("field"),
            "min": obj.get("min"),
            "max": obj.get("max"),
            "step": obj.get("step"),
            "points": obj.get("points"),
            "ids": obj.get("ids"),
            "value": obj.get("value"),
            "values": obj.get("values")
        })
        return _obj


