# coding: utf-8

"""
    Spacestudio API documentation

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class AdvancedOrbitParameters(BaseModel):
    """
    AdvancedOrbitParameters
    """ # noqa: E501
    orbit_date: Optional[StrictStr] = Field(default=None, description="The orbit date", alias="orbitDate")
    ascending_node_type: Optional[StrictStr] = Field(default=None, description="The orbit ascending node type", alias="ascendingNodeType")
    raan: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The orbit right ascension of the ascending node (in radians)")
    mltan: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The orbit mean local time of the ascending node (in radians)")
    anomaly: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The orbit anomaly (in radians)")
    anomaly_type: Optional[StrictStr] = Field(default=None, description="The orbit anomaly type", alias="anomalyType")
    orbital_element_type: Optional[StrictStr] = Field(default=None, description="The orbit orbital element type", alias="orbitalElementType")
    perigee_argument: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The orbit perigee argument (in radians)", alias="perigeeArgument")
    __properties: ClassVar[List[str]] = ["orbitDate", "ascendingNodeType", "raan", "mltan", "anomaly", "anomalyType", "orbitalElementType", "perigeeArgument"]

    @field_validator('ascending_node_type')
    def ascending_node_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['RAAN', 'LTAN', 'NOT_DEFINED']):
            raise ValueError("must be one of enum values ('RAAN', 'LTAN', 'NOT_DEFINED')")
        return value

    @field_validator('anomaly_type')
    def anomaly_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['TRUE', 'MEAN', 'ECCENTRIC']):
            raise ValueError("must be one of enum values ('TRUE', 'MEAN', 'ECCENTRIC')")
        return value

    @field_validator('orbital_element_type')
    def orbital_element_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['MEAN', 'OSC']):
            raise ValueError("must be one of enum values ('MEAN', 'OSC')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvancedOrbitParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvancedOrbitParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orbitDate": obj.get("orbitDate"),
            "ascendingNodeType": obj.get("ascendingNodeType"),
            "raan": obj.get("raan"),
            "mltan": obj.get("mltan"),
            "anomaly": obj.get("anomaly"),
            "anomalyType": obj.get("anomalyType"),
            "orbitalElementType": obj.get("orbitalElementType"),
            "perigeeArgument": obj.get("perigeeArgument")
        })
        return _obj


